<?php
/**
 * Cloudflare Error Page - Final Version
 * With original browser bar base64 image
 */

// Clear ALL output buffers first
while (ob_get_level()) {
    ob_end_clean();
}

// Suppress any errors
error_reporting(E_ALL);
ini_set('display_errors', 1);

// Get current domain for display
$currentDomain = $_SERVER['HTTP_HOST'] ?? 'example.com';

// Get real client IP (support Cloudflare and proxy headers)
$ip = $_SERVER['REMOTE_ADDR'] ?? 'Unknown';
if (isset($_SERVER["HTTP_CF_CONNECTING_IP"])) {
    $ip = $_SERVER["HTTP_CF_CONNECTING_IP"];
} elseif (isset($_SERVER['HTTP_CLIENT_IP'])) {
    $ip = $_SERVER['HTTP_CLIENT_IP'];
} elseif (isset($_SERVER['HTTP_X_FORWARDED_FOR'])) {
    $ip = $_SERVER['HTTP_X_FORWARDED_FOR'];
    if (strpos($ip, ',') !== false) {
        $ip = trim(explode(',', $ip)[0]);
    }
}

// Generate random Ray ID (16 characters hex)
$rayId = bin2hex(random_bytes(8));

// Generate CF-Ray ID (format: random16hex-3letter airport code)
$airportCodes = ['DFW', 'IAD', 'LAX', 'SJC', 'ORD', 'ATL', 'SEA', 'MIA', 'JFK', 'LHR', 'CDG', 'FRA', 'NRT', 'SYD', 'SIN'];
$cfRay = $rayId . '-' . $airportCodes[array_rand($airportCodes)];

// Set HTTP status code and headers (with @ to suppress warnings if already sent)
@http_response_code(403);

// Set Cloudflare-like response headers (suppress if already sent)
@header('Server: cloudflare');
@header('CF-Ray: ' . $cfRay);
@header('Cache-Control: private, max-age=0, no-store, no-cache, must-revalidate, post-check=0, pre-check=0');
@header('Expires: Thu, 01 Jan 1970 00:00:01 GMT');
@header('Content-Type: text/html; charset=UTF-8');
@header('X-Frame-Options: SAMEORIGIN');
@header('Referrer-Policy: same-origin');
@header('Vary: Accept-Encoding');
@header('Alt-Svc: h3=":443"; ma=86400');
@header('NEL: {"report_to":"cf-nel","success_fraction":0.0,"max_age":604800}');
@header('Report-To: {"group":"cf-nel","max_age":604800,"endpoints":[{"url":"https://a.nel.cloudflare.com/report/v4?s=4rtBfvbC88cx0A0%2F08l3TDc8mP2SUqku%2BFuvs7ZfDG7aEVM9RgLq0pbRdwSxn3%2BUT%2FMJAn%2FaQwfkAxt4kmygoMEpRGLW5ZlP6mDkqg%3D%3D"}]}');
@header('Server-Timing: cfEdge;dur=0,cfOrigin;dur=0');
@header('Server-Timing: cfExtPri');
@header('Priority: u=0,i');
?>
<!DOCTYPE html>
<html lang="en-US">
<head>
    <meta charset="UTF-8">
    <meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=Edge">
    <meta name="robots" content="noindex, nofollow">
    <meta name="viewport" content="width=device-width,initial-scale=1">
    <title>Attention Required! | Cloudflare</title>
    <style>
        body {
            margin: 0;
            padding: 0;
        }

        #cf-wrapper {
            display: block;
            margin: 0;
            padding: 0;
            position: relative;
            text-align: left;
            width: 100%;
            color: #404040;
            font-family: -apple-system, BlinkMacSystemFont, Segoe UI, Roboto, Oxygen, Ubuntu, Helvetica Neue, Arial, sans-serif;
            font-size: 15px;
            line-height: 1.5;
            -webkit-font-smoothing: antialiased;
        }

        #cf-wrapper * {
            margin: 0;
            padding: 0;
            border: 0;
            box-sizing: border-box;
        }

        /* Header Section */
        #cf-wrapper .cf-error-overview {
            padding: 25px 0 0;
        }

        #cf-wrapper h1 {
            font-size: 36px;
            line-height: 1.2;
            font-weight: 300;
            color: #404040;
        }

        #cf-wrapper h2 {
            font-size: 30px;
            line-height: 1.3;
            font-weight: 300;
            margin-top: 0.25em;
        }

        #cf-wrapper .cf-subheadline {
            color: #595959;
            font-weight: 300;
        }

        /* Screenshot/Browser Section */
        #cf-wrapper .cf-highlight {
            background: #ebebeb;
            background-image: linear-gradient(to bottom, #dedede, #ebebeb 3%, #ebebeb 97%, #dedede);
            overflow-x: hidden;
            padding: 60px 20px;
            margin: 2em 0;
        }

        #cf-wrapper .cf-screenshot-container {
            background: url(/cdn-cgi/images/browser-bar.png?1376755637) no-repeat #fff;
            max-height: 400px;
            max-width: 100%;
            overflow: hidden;
            padding-top: 53px;
            width: 960px;
            border-radius: 5px 5px 0 0;
            margin: 0 auto;
            position: relative;
            display: flex;
            align-items: center;
            justify-content: center;
            min-height: 300px;
        }

        /* Error Icon - RED CIRCLE WITH X */
        #cf-wrapper .cf-error-icon {
            width: 120px;
            height: 120px;
            background-color: #dc2626;
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            box-shadow: 0 4px 12px rgba(220, 38, 38, 0.3);
            position: relative;
            margin: 40px auto;
        }

        #cf-wrapper .cf-error-icon::before,
        #cf-wrapper .cf-error-icon::after {
            content: '';
            position: absolute;
            background-color: #ffffff;
            border-radius: 3px;
        }

        #cf-wrapper .cf-error-icon::before {
            width: 60px;
            height: 12px;
            transform: rotate(45deg);
        }

        #cf-wrapper .cf-error-icon::after {
            width: 60px;
            height: 12px;
            transform: rotate(-45deg);
        }

        /* Content Columns */
        #cf-wrapper .cf-wrapper {
            margin-left: auto;
            margin-right: auto;
            width: 90%;
            max-width: 1200px;
        }

        #cf-wrapper .cf-section {
            margin-bottom: 2em;
            margin-top: 2em;
        }

        #cf-wrapper .cf-columns {
            display: block;
            list-style: none;
            padding: 0;
            width: 100%;
        }

        #cf-wrapper .cf-columns::after {
            content: " ";
            display: table;
            clear: both;
        }

        #cf-wrapper .cf-column {
            float: left;
            padding-bottom: 45px;
            width: 100%;
            box-sizing: border-box;
        }

        #cf-wrapper .cf-column h2 {
            font-size: 20px;
            font-weight: 400;
            margin-bottom: 0.5em;
        }

        #cf-wrapper .cf-column p {
            color: #404040;
            line-height: 1.7;
        }

        /* Footer */
        #cf-wrapper .cf-error-footer {
            padding: 1.33333em 0;
            border-top: 1px solid #ebebeb;
            text-align: center;
        }

        #cf-wrapper .cf-error-footer p {
            font-size: 13px;
            color: #595959;
        }

        #cf-wrapper .cf-footer-item {
            display: block;
            margin-bottom: 5px;
        }

        #cf-wrapper .cf-footer-separator {
            display: none;
        }

        #cf-wrapper a {
            color: #0051c3;
            text-decoration: none;
            transition: color 0.15s ease;
        }

        #cf-wrapper a:hover {
            color: #f68b1f;
        }

        #cf-wrapper .font-semibold {
            font-weight: 600;
            color: #404040;
        }

        #cf-wrapper .cf-footer-ip-reveal-btn {
            appearance: button;
            background: none;
            color: #0051c3;
            border: none;
            padding: 0;
            font: inherit;
            cursor: pointer;
            transition: color 0.15s ease;
        }

        #cf-wrapper .cf-footer-ip-reveal-btn:hover {
            color: #ee730a;
        }

        #cf-wrapper .hidden {
            display: none;
        }

        /* Responsive Design */
        @media screen and (min-width: 49.2em) {
            #cf-wrapper .cf-wrapper {
                width: 708px;
            }

            #cf-wrapper h1 {
                font-size: 4em;
            }

            #cf-wrapper .cf-error-overview {
                padding-top: 2.33333em;
            }

            #cf-wrapper .cf-highlight {
                padding: 4em 0;
            }

            #cf-wrapper .cf-columns.two > .cf-column {
                padding-left: 0;
                padding-right: 22.5px;
                width: 50%;
                padding-bottom: 0;
            }

            #cf-wrapper .cf-columns.two > .cf-column:nth-child(2n) {
                padding-left: 22.5px;
                padding-right: 0;
            }

            #cf-wrapper .cf-columns.two > .cf-column:nth-child(odd) {
                clear: left;
            }

            #cf-wrapper .cf-error-footer {
                padding: 2.66667em 0;
            }

            #cf-wrapper .cf-footer-item,
            #cf-wrapper .cf-footer-separator {
                display: inline-block;
                vertical-align: baseline;
            }

            #cf-wrapper .cf-footer-separator {
                padding: 0 0.25em;
            }

            #cf-wrapper .cf-screenshot-container {
                height: 400px;
                margin-bottom: -4em;
            }

            #cf-wrapper .cf-error-icon {
                width: 140px;
                height: 140px;
            }

            #cf-wrapper .cf-error-icon::before,
            #cf-wrapper .cf-error-icon::after {
                width: 70px;
                height: 14px;
            }
        }

        @media screen and (min-width: 66em) {
            #cf-wrapper .cf-wrapper {
                width: 960px;
            }
        }
    </style>
</head>
<body>
    <div id="cf-wrapper">
        <div id="cf-error-details" class="cf-error-details-wrapper">
            
            <!-- Header Section -->
            <div class="cf-wrapper cf-header cf-error-overview">
                <h1>Sorry, you have been blocked</h1>
                <h2 class="cf-subheadline">
                    <span>You are unable to access</span> <?php echo htmlspecialchars($currentDomain); ?>
                </h2>
            </div>

            <!-- Browser Window with Red Error Icon -->
            <div class="cf-section cf-highlight">
                <div class="cf-wrapper">
                    <div class="cf-screenshot-container cf-screenshot-full">
                        <div class="cf-error-icon"></div>
                    </div>
                </div>
            </div>

            <!-- Information Section -->
            <div class="cf-section cf-wrapper">
                <div class="cf-columns two">
                    <div class="cf-column">
                        <h2>Why have I been blocked?</h2>
                        <p>
                            This website is using a security service to protect itself from online 
                            attacks. The action you just performed triggered the security solution. 
                            There are several actions that could trigger this block including 
                            submitting a certain word or phrase, a SQL command or malformed data.
                        </p>
                    </div>

                    <div class="cf-column">
                        <h2>What can I do to resolve this?</h2>
                        <p>
                            You can email the site owner to let them know you were blocked. 
                            Please include what you were doing when this page came up and the 
                            Cloudflare Ray ID found at the bottom of this page.
                        </p>
                    </div>
                </div>
            </div>

            <!-- Footer Section -->
            <div class="cf-error-footer cf-wrapper">
                <p>
                    <span class="cf-footer-item">
                        Cloudflare Ray ID: <strong class="font-semibold"><?php echo htmlspecialchars($rayId); ?></strong>
                    </span>
                    <span class="cf-footer-separator">&bull;</span>
                    <span id="cf-footer-item-ip" class="cf-footer-item hidden">
                        Your IP:
                        <button type="button" id="cf-footer-ip-reveal" class="cf-footer-ip-reveal-btn">
                            Click to reveal
                        </button>
                        <span class="hidden" id="cf-footer-ip"><?php echo htmlspecialchars($ip); ?></span>
                    </span>
                    <span class="cf-footer-separator">&bull;</span>
                    <span class="cf-footer-item">
                        <span>Performance &amp; security by</span> 
                        <a rel="noopener noreferrer" href="https://www.cloudflare.com/5xx-error-landing" target="_blank">Cloudflare</a>
                    </span>
                </p>
            </div>

        </div>
    </div>

    <script>
        (function() {
            function init() {
                var ipItem = document.getElementById("cf-footer-item-ip");
                var revealBtn = document.getElementById("cf-footer-ip-reveal");
                
                if (ipItem && revealBtn) {
                    ipItem.classList.remove("hidden");
                    revealBtn.addEventListener("click", function() {
                        revealBtn.classList.add("hidden");
                        document.getElementById("cf-footer-ip").classList.remove("hidden");
                    });
                }
            }
            
            if (document.addEventListener) {
                document.addEventListener("DOMContentLoaded", init);
            }
        })();
    </script>
</body>
</html>
<?php
exit;
?>
