<?php
function readFileReversed($filePath) {
    if (!file_exists($filePath)) {
        return [];
    }

    $lines = file($filePath, FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES);
    return array_reverse($lines);
}

$filePath = "../../../KsR7xiySIj/logs/ips.txt";
$fileData = readFileReversed($filePath);

?>
<div class="table-responsive" style="max-height: 250px; overflow-y: auto;">
    <table class="table text-nowrap table-striped table-borderless">
        <thead>
            <tr>
                <th scope="col">Date & Time</th>
                <th scope="col">Ip Address</th>
                <th scope="col">Device</th>
                <th scope="col">Browser</th>
                <th scope="col">Location</th>
                <th scope="col">Activity</th>
            </tr>
        </thead>
        <tbody>
            <?php
                if (count($fileData) != 0) {
                    foreach ($fileData as $value) {
                        $ex = explode('|', $value);
                        echo "<tr>";
                        echo "<td>{$ex[0]}</td>";
                        echo "<td>{$ex[1]}</td>";
                        echo "<td>{$ex[7]}</td>";
                        echo "<td>{$ex[6]}</td>";
                        echo "<td>City: {$ex[2]}<br /> State: {$ex[3]}<br /> Country: <img src='{$ex[5]}' width='15px' /> {$ex[4]}</td>";
                        echo "<td>{$ex[9]}</td>";
                        echo "</tr>";
                    }
                } else {
                    echo "<tr><td class='text-center' colspan='10'>Not available data.</td></tr>";
                }
            ?>
        </tbody>
    </table>
</div>