<?php
/**
 * ISP Whitelist API - GlobalSetting
 * Endpoints:
 *   GET  - List all whitelisted ISPs
 *   POST - Add/Delete ISP from whitelist
 */
header('Content-Type: application/json');

// Cookie-based auth (same as GlobalSetting)
$cookieName = 'gs_auth_token';
$secret = 'GlobalSetting2024SecretKey';
$token = $_COOKIE[$cookieName] ?? '';
$username = $_COOKIE['gs_username'] ?? '';
$valid = ($token === hash('sha256', $username . $secret . date('Y-m-d')));

if (!$valid) {
    http_response_code(401);
    echo json_encode(['error' => 'Unauthorized']);
    exit;
}

$whitelistFile = dirname(__DIR__) . '/config/isp_whitelist.json';

if (!file_exists($whitelistFile)) {
    file_put_contents($whitelistFile, '[]');
}

$whitelist = json_decode(file_get_contents($whitelistFile), true) ?? [];
$method = $_SERVER['REQUEST_METHOD'];

if ($method === 'GET') {
    echo json_encode(['success' => true, 'data' => $whitelist]);
    exit;
}

if ($method === 'POST') {
    $input = json_decode(file_get_contents('php://input'), true);
    if (empty($input)) $input = $_POST;
    
    $action = $input['action'] ?? 'add';
    
    if ($action === 'add') {
        $isp = trim($input['isp'] ?? '');
        $note = trim($input['note'] ?? '');
        
        if (empty($isp)) {
            echo json_encode(['success' => false, 'error' => 'ISP name is required']);
            exit;
        }
        
        foreach ($whitelist as $entry) {
            if (strtolower($entry['isp']) === strtolower($isp)) {
                echo json_encode(['success' => false, 'error' => 'ISP already in whitelist']);
                exit;
            }
        }
        
        $whitelist[] = [
            'isp' => $isp,
            'note' => $note,
            'added_at' => date('Y-m-d H:i:s')
        ];
        
        file_put_contents($whitelistFile, json_encode($whitelist, JSON_PRETTY_PRINT));
        echo json_encode(['success' => true, 'message' => 'ISP added to whitelist', 'data' => $whitelist]);
        exit;
    }
    
    if ($action === 'delete') {
        $index = $input['index'] ?? null;
        $isp = trim($input['isp'] ?? '');
        
        if ($index !== null && isset($whitelist[(int)$index])) {
            array_splice($whitelist, (int)$index, 1);
        } elseif (!empty($isp)) {
            $whitelist = array_values(array_filter($whitelist, function($e) use ($isp) {
                return strtolower($e['isp']) !== strtolower($isp);
            }));
        } else {
            echo json_encode(['success' => false, 'error' => 'ISP name or index required']);
            exit;
        }
        
        file_put_contents($whitelistFile, json_encode($whitelist, JSON_PRETTY_PRINT));
        echo json_encode(['success' => true, 'message' => 'ISP removed', 'data' => $whitelist]);
        exit;
    }
    
    echo json_encode(['success' => false, 'error' => 'Invalid action']);
    exit;
}

http_response_code(405);
echo json_encode(['error' => 'Method not allowed']);
