<?php
/**
 * Cookie-based Authentication Helper
 * No PHP sessions required
 */

// Suppress errors
error_reporting(E_ALL);
ini_set('display_errors', 1);

// Cookie settings
$cookieName = 'gs_auth_token';

// Generate auth token
function generateAuthToken($username) {
    $secret = 'GlobalSetting2024SecretKey';
    return hash('sha256', $username . $secret . date('Y-m-d'));
}

// Verify auth token
function verifyAuthToken($token, $username) {
    return $token === generateAuthToken($username);
}

// Check if logged in
function isLoggedIn() {
    global $cookieName;
    if (isset($_COOKIE[$cookieName]) && isset($_COOKIE['gs_username'])) {
        return verifyAuthToken($_COOKIE[$cookieName], $_COOKIE['gs_username']);
    }
    return false;
}

// Get current username
function getCurrentUsername() {
    return $_COOKIE['gs_username'] ?? 'Admin';
}

// Require login - redirect if not authenticated
function requireLogin() {
    if (!isLoggedIn()) {
        header('Location: index.php');
        exit;
    }
}

// Auto-check login
requireLogin();
