<?php
// Suppress errors
error_reporting(E_ALL);
ini_set('display_errors', 1);

// Cookie-based authentication check
$cookieName = 'gs_auth_token';
function gsVerifyAuth() {
    $secret = 'GlobalSetting2024SecretKey';
    $token = $_COOKIE['gs_auth_token'] ?? '';
    $username = $_COOKIE['gs_username'] ?? '';
    return $token === hash('sha256', $username . $secret . date('Y-m-d'));
}

if (!isset($_COOKIE[$cookieName]) || !isset($_COOKIE['gs_username']) || !gsVerifyAuth()) {
    header('Location: index.php');
    exit;
}

// Load global config
$configPath = __DIR__ . '/../../config/gen.json';
$genConfig = file_exists($configPath) ? json_decode(file_get_contents($configPath), true) : [];

// Load theme config
$themeConfigPath = __DIR__ . '/../../config/theme.json';
$themeConfig = file_exists($themeConfigPath) ? json_decode(file_get_contents($themeConfigPath), true) : [];

// Current page
$currentPage = basename($_SERVER['PHP_SELF'], '.php');
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?= ucfirst($currentPage) ?> - GlobalSetting</title>
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.1/font/bootstrap-icons.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@300;400;500;700;900&display=swap" rel="stylesheet">
    <style>
        :root {
            --primary: #00ff9d;
            --primary-dark: #00d4aa;
            --danger: #ff4757;
            --warning: #ffd700;
            --info: #667eea;
            --accent-green: #00ff9d;
            --accent-cyan: #00d4ff;
            --accent-purple: #a855f7;
            --accent-orange: #ff9500;
            --accent-pink: #ff6b9d;
            --accent-blue: #4f8cff;
            --bg-dark: #050508;
            --bg-deep: #020204;
            --bg-card: rgba(12, 12, 18, 0.85);
            --bg-card-hover: rgba(18, 18, 28, 0.9);
            --bg-hover: #1a1a25;
            --bg-input: #0a0a12;
            --border: rgba(255, 255, 255, 0.06);
            --border-hover: rgba(255, 255, 255, 0.12);
            --text: #f0f0f5;
            --text-muted: #8a8a9a;
            --text-dim: #5a5a6a;
            --topnav-height: 70px;
            
            /* Enhanced Glow Effects */
            --glow-green: 0 0 15px rgba(0, 255, 157, 0.5), 0 0 30px rgba(0, 255, 157, 0.3), 0 0 60px rgba(0, 255, 157, 0.15);
            --glow-cyan: 0 0 15px rgba(0, 212, 255, 0.5), 0 0 30px rgba(0, 212, 255, 0.3), 0 0 60px rgba(0, 212, 255, 0.15);
            --glow-purple: 0 0 15px rgba(168, 85, 247, 0.5), 0 0 30px rgba(168, 85, 247, 0.3), 0 0 60px rgba(168, 85, 247, 0.15);
            --glow-red: 0 0 15px rgba(255, 71, 87, 0.5), 0 0 30px rgba(255, 71, 87, 0.3), 0 0 60px rgba(255, 71, 87, 0.15);
            --glow-yellow: 0 0 15px rgba(255, 215, 0, 0.5), 0 0 30px rgba(255, 215, 0, 0.3), 0 0 60px rgba(255, 215, 0, 0.15);
            --glow-pink: 0 0 15px rgba(255, 107, 157, 0.5), 0 0 30px rgba(255, 107, 157, 0.3), 0 0 60px rgba(255, 107, 157, 0.15);
            
            /* Gradients */
            --gradient-main: linear-gradient(135deg, #00ff9d 0%, #00d4ff 50%, #a855f7 100%);
            --gradient-border: linear-gradient(90deg, #00ff9d 0%, #00d4ff 50%, #a855f7 100%);
            --gradient-glow: linear-gradient(135deg, rgba(0, 255, 157, 0.4) 0%, rgba(0, 212, 255, 0.4) 50%, rgba(168, 85, 247, 0.4) 100%);
        }
        
        * { margin: 0; padding: 0; box-sizing: border-box; }
        
        /* Enhanced Aurora Background with Animated Orbs */
        body {
            font-family: 'Roboto', sans-serif;
            background: var(--bg-dark);
            color: var(--text);
            min-height: 100vh;
            line-height: 1.6;
            overflow-x: hidden;
            position: relative;
        }

        /* Animated Background Orbs */
        body::before {
            content: '';
            position: fixed;
            top: 0; left: 0;
            width: 100%; height: 100%;
            background: 
                radial-gradient(800px ellipse at 0% 0%, rgba(0, 255, 157, 0.15), transparent 50%),
                radial-gradient(600px ellipse at 100% 0%, rgba(0, 212, 255, 0.18), transparent 50%),
                radial-gradient(700px ellipse at 100% 100%, rgba(168, 85, 247, 0.15), transparent 50%),
                radial-gradient(500px ellipse at 0% 100%, rgba(255, 107, 157, 0.12), transparent 50%),
                radial-gradient(900px ellipse at 50% 50%, rgba(0, 212, 255, 0.08), transparent 60%);
            z-index: -3;
            animation: auroraShift 25s ease-in-out infinite alternate;
        }

        /* Floating Glow Orbs */
        body::after {
            content: '';
            position: fixed;
            top: 0; left: 0;
            width: 100%; height: 100%;
            background: 
                radial-gradient(300px circle at 20% 30%, rgba(0, 255, 157, 0.08), transparent 60%),
                radial-gradient(400px circle at 80% 20%, rgba(0, 212, 255, 0.1), transparent 60%),
                radial-gradient(350px circle at 70% 80%, rgba(168, 85, 247, 0.08), transparent 60%),
                radial-gradient(250px circle at 30% 70%, rgba(255, 149, 0, 0.06), transparent 60%);
            z-index: -2;
            animation: orbFloat 20s ease-in-out infinite alternate-reverse;
            pointer-events: none;
        }

        @keyframes auroraShift {
            0% { 
                transform: scale(1) rotate(0deg);
                filter: blur(80px) brightness(1);
            }
            50% {
                filter: blur(100px) brightness(1.1);
            }
            100% { 
                transform: scale(1.15) rotate(3deg);
                filter: blur(90px) brightness(1);
            }
        }

        @keyframes orbFloat {
            0% { transform: translateY(0) translateX(0); }
            33% { transform: translateY(-20px) translateX(10px); }
            66% { transform: translateY(10px) translateX(-15px); }
            100% { transform: translateY(-10px) translateX(5px); }
        }
        
        /* Noise Texture Overlay */
        .noise-overlay {
            position: fixed;
            top: 0; left: 0;
            width: 100%; height: 100%;
            background-image: url("data:image/svg+xml,%3Csvg viewBox='0 0 200 200' xmlns='http://www.w3.org/2000/svg'%3E%3Cfilter id='noiseFilter'%3E%3CfeTurbulence type='fractalNoise' baseFrequency='0.65' numOctaves='3' stitchTiles='stitch'/%3E%3C/filter%3E%3Crect width='100%25' height='100%25' filter='url(%23noiseFilter)' opacity='0.025'/%3E%3C/svg%3E");
            z-index: -1;
            pointer-events: none;
            opacity: 0.6;
        }
        
        /* Enhanced Floating Particles with Glow */
        .particles {
            position: fixed;
            top: 0; left: 0;
            width: 100%; height: 100%;
            pointer-events: none;
            z-index: 0;
            overflow: hidden;
        }
        
        .particles span {
            position: absolute;
            border-radius: 50%;
            animation: particleFloat linear infinite;
            opacity: 0;
        }
        
        .particles span:nth-child(1) { left: 8%; width: 4px; height: 4px; background: var(--accent-cyan); box-shadow: 0 0 8px var(--accent-cyan), 0 0 20px var(--accent-cyan), 0 0 40px var(--accent-cyan); animation-delay: 0s; animation-duration: 22s; }
        .particles span:nth-child(2) { left: 18%; width: 3px; height: 3px; background: var(--accent-green); box-shadow: 0 0 8px var(--accent-green), 0 0 20px var(--accent-green); animation-delay: 2s; animation-duration: 19s; }
        .particles span:nth-child(3) { left: 28%; width: 5px; height: 5px; background: var(--accent-purple); box-shadow: 0 0 10px var(--accent-purple), 0 0 25px var(--accent-purple), 0 0 50px var(--accent-purple); animation-delay: 4s; animation-duration: 24s; }
        .particles span:nth-child(4) { left: 38%; width: 3px; height: 3px; background: var(--accent-pink); box-shadow: 0 0 8px var(--accent-pink), 0 0 20px var(--accent-pink); animation-delay: 1s; animation-duration: 17s; }
        .particles span:nth-child(5) { left: 48%; width: 4px; height: 4px; background: var(--accent-cyan); box-shadow: 0 0 8px var(--accent-cyan), 0 0 20px var(--accent-cyan), 0 0 40px var(--accent-cyan); animation-delay: 3s; animation-duration: 21s; }
        .particles span:nth-child(6) { left: 58%; width: 3px; height: 3px; background: var(--accent-green); box-shadow: 0 0 8px var(--accent-green), 0 0 20px var(--accent-green); animation-delay: 5s; animation-duration: 23s; }
        .particles span:nth-child(7) { left: 68%; width: 5px; height: 5px; background: var(--accent-purple); box-shadow: 0 0 10px var(--accent-purple), 0 0 25px var(--accent-purple), 0 0 50px var(--accent-purple); animation-delay: 2.5s; animation-duration: 18s; }
        .particles span:nth-child(8) { left: 78%; width: 4px; height: 4px; background: var(--accent-cyan); box-shadow: 0 0 8px var(--accent-cyan), 0 0 20px var(--accent-cyan); animation-delay: 4.5s; animation-duration: 25s; }
        .particles span:nth-child(9) { left: 88%; width: 3px; height: 3px; background: var(--accent-pink); box-shadow: 0 0 8px var(--accent-pink), 0 0 20px var(--accent-pink); animation-delay: 1.5s; animation-duration: 20s; }
        .particles span:nth-child(10) { left: 95%; width: 4px; height: 4px; background: var(--accent-green); box-shadow: 0 0 8px var(--accent-green), 0 0 20px var(--accent-green), 0 0 40px var(--accent-green); animation-delay: 3.5s; animation-duration: 19s; }
        
        @keyframes particleFloat {
            0% { 
                transform: translateY(100vh) translateX(0) scale(0);
                opacity: 0;
            }
            5% {
                opacity: 0;
            }
            15% {
                opacity: 0.9;
                transform: translateY(80vh) translateX(10px) scale(1);
            }
            50% {
                transform: translateY(40vh) translateX(-15px) scale(1.1);
            }
            85% {
                opacity: 0.9;
                transform: translateY(10vh) translateX(8px) scale(1);
            }
            95% {
                opacity: 0;
            }
            100% { 
                transform: translateY(-10vh) translateX(0) scale(0.8);
                opacity: 0;
            }
        }
        
        /* Grid Pattern - Professional */
        .main-content::before {
            content: '';
            position: fixed;
            top: 0; left: 0;
            width: 100%; height: 100%;
            background-size: 40px 40px;
            background-image: 
                linear-gradient(to right, rgba(255, 255, 255, 0.03) 1px, transparent 1px),
                linear-gradient(to bottom, rgba(255, 255, 255, 0.03) 1px, transparent 1px);
            mask-image: radial-gradient(circle at center, black 40%, transparent 100%);
            -webkit-mask-image: radial-gradient(circle at center, black 40%, transparent 100%);
            pointer-events: none;
            z-index: -1;
        }

        /* Note: Sidebar/Topnav styles are in sidebar.php */
        
        .sidebar-brand {
            padding: 0 20px 20px;
            border-bottom: 1px solid var(--border);
            margin-bottom: 20px;
        }
        
        .sidebar-brand h1 {
            font-size: 1.2rem;
            font-weight: 700;
            color: var(--primary);
            display: flex;
            align-items: center;
            gap: 10px;
        }
        
        .sidebar-brand small {
            display: block;
            font-size: 0.75rem;
            color: var(--text-muted);
            margin-top: 4px;
        }
        
        .sidebar-nav {
            padding: 0 12px;
        }
        
        .nav-section {
            margin-bottom: 20px;
        }
        
        .nav-section-title {
            font-size: 0.7rem;
            text-transform: uppercase;
            color: var(--text-dim);
            padding: 0 12px;
            margin-bottom: 8px;
            letter-spacing: 1px;
        }
        
        .nav-link {
            display: flex;
            align-items: center;
            gap: 12px;
            padding: 12px 16px;
            color: var(--text-muted);
            text-decoration: none;
            border-radius: 10px;
            margin-bottom: 4px;
            transition: all 0.2s;
            font-size: 0.9rem;
        }
        
        .nav-link:hover {
            background: linear-gradient(135deg, rgba(0, 212, 255, 0.1) 0%, rgba(168, 85, 247, 0.05) 100%);
            color: var(--text);
            border-color: rgba(0, 212, 255, 0.2);
        }
        
        .nav-link.active {
            background: linear-gradient(135deg, rgba(0, 255, 157, 0.15) 0%, rgba(0, 212, 255, 0.1) 100%);
            color: var(--primary);
            border-left: 2px solid var(--accent-green);
            box-shadow: 0 0 20px rgba(0, 255, 157, 0.15);
        }
        
        .nav-link i {
            font-size: 1.1rem;
            width: 24px;
            text-align: center;
        }
        
        .nav-link .badge {
            margin-left: auto;
            background: var(--primary);
            color: #000;
            font-size: 0.65rem;
            padding: 3px 8px;
            border-radius: 10px;
            font-weight: 600;
        }
        
        /* Main Content - Top Nav Layout */
        .main-content {
            margin-top: var(--topnav-height);
            padding: 30px;
            min-height: calc(100vh - var(--topnav-height));
            position: relative;
            z-index: 2;
        }
        
        .main-content::after {
            content: '';
            position: fixed;
            bottom: 0;
            left: 0;
            right: 0;
            height: 150px;
            background: linear-gradient(0deg, rgba(5, 5, 10, 0.9) 0%, transparent 100%);
            pointer-events: none;
            z-index: -1;
        }
        
        .page-header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 28px;
            flex-wrap: wrap;
            gap: 15px;
            padding-bottom: 20px;
            border-bottom: 1px solid rgba(255, 255, 255, 0.06);
        }
        
        .page-title {
            font-size: 1.6rem;
            font-weight: 800;
            display: flex;
            align-items: center;
            gap: 12px;
            background: linear-gradient(135deg, #fff 0%, var(--accent-cyan) 100%);
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
        }
        
        .page-title i {
            -webkit-text-fill-color: var(--accent-cyan);
            filter: drop-shadow(0 0 10px rgba(0, 212, 255, 0.5));
        }
        
        .page-subtitle {
            font-size: 0.85rem;
            color: var(--text-muted);
            margin-top: 6px;
        }
        
        /* Cards - Ultra Modern Glass with Glow */
        .card {
            background: linear-gradient(135deg, rgba(15, 15, 25, 0.9) 0%, rgba(10, 10, 18, 0.85) 100%);
            backdrop-filter: blur(20px) saturate(180%);
            -webkit-backdrop-filter: blur(20px) saturate(180%);
            border: 1px solid rgba(255, 255, 255, 0.08);
            border-radius: 20px;
            box-shadow: 
                0 8px 32px rgba(0, 0, 0, 0.4),
                0 0 0 1px rgba(255, 255, 255, 0.05) inset,
                0 0 60px -20px rgba(0, 212, 255, 0.15);
            margin-bottom: 24px;
            overflow: hidden;
            transition: all 0.4s cubic-bezier(0.175, 0.885, 0.32, 1.275);
            position: relative;
        }

        .card::before {
            content: '';
            position: absolute;
            top: 0; left: 0; right: 0;
            height: 1px;
            background: linear-gradient(90deg, transparent, rgba(0, 212, 255, 0.5), rgba(168, 85, 247, 0.5), transparent);
            opacity: 0.6;
        }

        .card::after {
            content: '';
            position: absolute;
            inset: 0;
            border-radius: 20px;
            padding: 1px;
            background: linear-gradient(135deg, rgba(0, 212, 255, 0.2), transparent 30%, transparent 70%, rgba(168, 85, 247, 0.15));
            -webkit-mask: 
                linear-gradient(#fff 0 0) content-box, 
                linear-gradient(#fff 0 0);
            -webkit-mask-composite: xor;
            mask-composite: exclude;
            pointer-events: none;
            opacity: 0;
            transition: opacity 0.4s;
        }
        
        .card:hover {
            transform: translateY(-4px) scale(1.01);
            background: linear-gradient(135deg, rgba(18, 18, 30, 0.95) 0%, rgba(12, 12, 22, 0.9) 100%);
            box-shadow: 
                0 20px 50px rgba(0, 0, 0, 0.5),
                0 0 80px -20px rgba(0, 212, 255, 0.25),
                0 0 0 1px rgba(255, 255, 255, 0.1) inset;
            border-color: rgba(0, 212, 255, 0.2);
        }

        .card:hover::after {
            opacity: 1;
        }
        
        .card-header {
            padding: 18px 22px;
            border-bottom: 1px solid var(--border);
            display: flex;
            justify-content: space-between;
            align-items: center;
            position: relative;
        }
        
        .card-header::before {
            content: '';
            position: absolute;
            left: 0;
            top: 0;
            bottom: 0;
            width: 4px;
            background: var(--accent-cyan);
            box-shadow: var(--glow-cyan);
            border-radius: 0 4px 4px 0;
            pointer-events: none;
        }
        
        .card-title {
            font-size: 0.95rem;
            font-weight: 700;
            display: flex;
            align-items: center;
            gap: 10px;
            text-transform: uppercase;
            letter-spacing: 1px;
        }
        
        .card-title i {
            color: var(--accent-cyan);
            filter: drop-shadow(0 0 8px rgba(0, 212, 255, 0.5));
        }
        
        .card-body {
            padding: 22px;
            background: linear-gradient(180deg, rgba(0,0,0,0.1) 0%, transparent 100%);
        }
        
        /* Stats Grid */
        .stats-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(220px, 1fr));
            gap: 24px;
            margin-bottom: 32px;
        }
        
        /* Stat Cards with Intense Glow */
        .stat-card {
            background: linear-gradient(145deg, rgba(15, 15, 25, 0.9) 0%, rgba(8, 8, 15, 0.85) 100%);
            backdrop-filter: blur(20px);
            -webkit-backdrop-filter: blur(20px);
            border: 1px solid rgba(255, 255, 255, 0.06);
            border-radius: 18px;
            padding: 24px;
            display: flex;
            justify-content: space-between;
            align-items: center;
            transition: all 0.4s cubic-bezier(0.175, 0.885, 0.32, 1.275);
            position: relative;
            overflow: hidden;
            box-shadow: 0 8px 30px rgba(0, 0, 0, 0.3);
        }

        .stat-card::before {
            content: '';
            position: absolute;
            top: 0; left: 0; right: 0;
            height: 2px;
            background: var(--gradient-main);
            opacity: 0;
            transition: opacity 0.4s;
        }

        .stat-card::after {
            content: '';
            position: absolute;
            inset: 0;
            background: radial-gradient(600px circle at var(--mouse-x, 50%) var(--mouse-y, 50%), rgba(255, 255, 255, 0.04), transparent 40%);
            opacity: 0;
            transition: opacity 0.4s;
            pointer-events: none;
        }

        .stat-card:hover {
            transform: translateY(-6px) scale(1.02);
            border-color: rgba(255, 255, 255, 0.1);
        }

        .stat-card:hover::before {
            opacity: 1;
        }

        .stat-card:hover::after {
            opacity: 1;
        }
        
        .stat-card.glow-green { border-left: 3px solid rgba(0, 255, 157, 0.5); }
        .stat-card.glow-green:hover { 
            border-color: rgba(0, 255, 157, 0.4); 
            box-shadow: 0 15px 50px rgba(0, 0, 0, 0.4), 0 0 50px rgba(0, 255, 157, 0.2), 0 0 100px rgba(0, 255, 157, 0.1);
        }
        .stat-card.glow-cyan { border-left: 3px solid rgba(0, 212, 255, 0.5); }
        .stat-card.glow-cyan:hover { 
            border-color: rgba(0, 212, 255, 0.4); 
            box-shadow: 0 15px 50px rgba(0, 0, 0, 0.4), 0 0 50px rgba(0, 212, 255, 0.2), 0 0 100px rgba(0, 212, 255, 0.1);
        }
        .stat-card.glow-red { border-left: 3px solid rgba(255, 71, 87, 0.5); }
        .stat-card.glow-red:hover { 
            border-color: rgba(255, 71, 87, 0.4); 
            box-shadow: 0 15px 50px rgba(0, 0, 0, 0.4), 0 0 50px rgba(255, 71, 87, 0.2), 0 0 100px rgba(255, 71, 87, 0.1);
        }
        .stat-card.glow-yellow { border-left: 3px solid rgba(255, 215, 0, 0.5); }
        .stat-card.glow-yellow:hover { 
            border-color: rgba(255, 215, 0, 0.4); 
            box-shadow: 0 15px 50px rgba(0, 0, 0, 0.4), 0 0 50px rgba(255, 215, 0, 0.2), 0 0 100px rgba(255, 215, 0, 0.1);
        }
        .stat-card.glow-purple { border-left: 3px solid rgba(168, 85, 247, 0.5); }
        .stat-card.glow-purple:hover { 
            border-color: rgba(168, 85, 247, 0.4); 
            box-shadow: 0 15px 50px rgba(0, 0, 0, 0.4), 0 0 50px rgba(168, 85, 247, 0.2), 0 0 100px rgba(168, 85, 247, 0.1);
        }
        
        .stat-value {
            font-size: 2.2rem;
            font-weight: 800;
            letter-spacing: -1px;
        }
        
        .stat-value.green { color: var(--accent-green); text-shadow: 0 0 25px rgba(0, 255, 157, 0.6), 0 0 50px rgba(0, 255, 157, 0.3); }
        .stat-value.cyan { color: var(--accent-cyan); text-shadow: 0 0 25px rgba(0, 212, 255, 0.6), 0 0 50px rgba(0, 212, 255, 0.3); }
        .stat-value.red { color: var(--danger); text-shadow: 0 0 25px rgba(255, 71, 87, 0.6), 0 0 50px rgba(255, 71, 87, 0.3); }
        .stat-value.yellow { color: var(--warning); text-shadow: 0 0 25px rgba(255, 215, 0, 0.6), 0 0 50px rgba(255, 215, 0, 0.3); }
        .stat-value.purple { color: var(--accent-purple); text-shadow: 0 0 25px rgba(168, 85, 247, 0.6), 0 0 50px rgba(168, 85, 247, 0.3); }
        
        .stat-label {
            font-size: 0.72rem;
            color: var(--text-muted);
            text-transform: uppercase;
            margin-top: 8px;
            letter-spacing: 1.5px;
            font-weight: 600;
        }
        
        .stat-icon {
            width: 56px;
            height: 56px;
            border-radius: 16px;
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 1.5rem;
            transition: all 0.4s cubic-bezier(0.175, 0.885, 0.32, 1.275);
            position: relative;
        }

        .stat-icon::after {
            content: '';
            position: absolute;
            inset: -3px;
            border-radius: 18px;
            opacity: 0;
            transition: opacity 0.4s;
        }
        
        .stat-icon.primary { 
            background: linear-gradient(135deg, rgba(0, 255, 157, 0.15) 0%, rgba(0, 255, 157, 0.05) 100%); 
            color: var(--accent-green); 
            border: 1px solid rgba(0, 255, 157, 0.25);
        }
        .stat-icon.primary::after { background: rgba(0, 255, 157, 0.15); }
        .stat-card:hover .stat-icon.primary { 
            box-shadow: var(--glow-green);
            transform: scale(1.1) rotate(5deg);
        }
        .stat-card:hover .stat-icon.primary::after { opacity: 1; }
        
        .stat-icon.danger { 
            background: linear-gradient(135deg, rgba(255, 71, 87, 0.15) 0%, rgba(255, 71, 87, 0.05) 100%); 
            color: var(--danger);
            border: 1px solid rgba(255, 71, 87, 0.25);
        }
        .stat-icon.danger::after { background: rgba(255, 71, 87, 0.15); }
        .stat-card:hover .stat-icon.danger { 
            box-shadow: var(--glow-red);
            transform: scale(1.1) rotate(5deg);
        }
        .stat-card:hover .stat-icon.danger::after { opacity: 1; }
        
        .stat-icon.warning { 
            background: linear-gradient(135deg, rgba(255, 215, 0, 0.15) 0%, rgba(255, 215, 0, 0.05) 100%); 
            color: var(--warning);
            border: 1px solid rgba(255, 215, 0, 0.25);
        }
        .stat-icon.warning::after { background: rgba(255, 215, 0, 0.15); }
        .stat-card:hover .stat-icon.warning { 
            box-shadow: var(--glow-yellow);
            transform: scale(1.1) rotate(5deg);
        }
        .stat-card:hover .stat-icon.warning::after { opacity: 1; }
        
        .stat-icon.info { 
            background: linear-gradient(135deg, rgba(0, 212, 255, 0.15) 0%, rgba(0, 212, 255, 0.05) 100%); 
            color: var(--accent-cyan);
            border: 1px solid rgba(0, 212, 255, 0.25);
        }
        .stat-icon.info::after { background: rgba(0, 212, 255, 0.15); }
        .stat-card:hover .stat-icon.info { 
            box-shadow: var(--glow-cyan);
            transform: scale(1.1) rotate(5deg);
        }
        .stat-card:hover .stat-icon.info::after { opacity: 1; }
        
        /* Enhanced Buttons with Glow */
        .btn {
            display: inline-flex;
            align-items: center;
            gap: 10px;
            padding: 14px 24px;
            border-radius: 12px;
            font-size: 0.85rem;
            font-weight: 700;
            border: none;
            cursor: pointer;
            transition: all 0.4s cubic-bezier(0.175, 0.885, 0.32, 1.275);
            text-decoration: none;
            text-transform: uppercase;
            letter-spacing: 1px;
            position: relative;
            overflow: hidden;
        }
        
        .btn-primary {
            background: var(--gradient-main);
            color: #000;
            box-shadow: 
                0 6px 20px rgba(0, 255, 157, 0.3),
                0 0 40px rgba(0, 212, 255, 0.2),
                inset 0 1px 0 rgba(255, 255, 255, 0.2);
        }
        
        .btn-primary::before {
            content: '';
            position: absolute;
            top: 0;
            left: -100%;
            width: 100%;
            height: 100%;
            background: linear-gradient(90deg, transparent, rgba(255,255,255,0.4), transparent);
            transition: left 0.6s ease;
        }

        .btn-primary::after {
            content: '';
            position: absolute;
            inset: -2px;
            background: var(--gradient-main);
            border-radius: 14px;
            z-index: -1;
            opacity: 0;
            filter: blur(15px);
            transition: opacity 0.4s;
        }
        
        .btn-primary:hover {
            transform: translateY(-4px) scale(1.02);
            box-shadow: 
                0 12px 35px rgba(0, 255, 157, 0.4),
                0 0 60px rgba(0, 212, 255, 0.3),
                0 0 80px rgba(168, 85, 247, 0.2);
        }
        
        .btn-primary:hover::before {
            left: 100%;
        }

        .btn-primary:hover::after {
            opacity: 0.6;
        }
        
        .btn-outline {
            background: rgba(255, 255, 255, 0.03);
            border: 1px solid rgba(255, 255, 255, 0.1);
            color: var(--text-muted);
            backdrop-filter: blur(10px);
        }
        
        .btn-outline:hover {
            border-color: var(--accent-cyan);
            color: var(--accent-cyan);
            background: rgba(0, 212, 255, 0.08);
            box-shadow: 0 0 30px rgba(0, 212, 255, 0.2), inset 0 0 20px rgba(0, 212, 255, 0.05);
            transform: translateY(-2px);
        }
        
        .btn-danger {
            background: linear-gradient(135deg, var(--danger), #dc3545);
            color: #fff;
            box-shadow: 0 6px 20px rgba(255, 71, 87, 0.3);
        }
        
        .btn-danger:hover {
            box-shadow: 
                0 12px 35px rgba(255, 71, 87, 0.4),
                0 0 50px rgba(255, 71, 87, 0.25);
            transform: translateY(-4px);
        }

        .btn-success {
            background: linear-gradient(135deg, var(--accent-green), #00d4aa);
            color: #000;
            box-shadow: 0 6px 20px rgba(0, 255, 157, 0.3);
        }
        
        .btn-success:hover {
            box-shadow: 
                0 12px 35px rgba(0, 255, 157, 0.4),
                0 0 50px rgba(0, 255, 157, 0.25);
            transform: translateY(-4px);
        }
        
        /* Enhanced Forms with Glow */
        .form-group {
            margin-bottom: 20px;
        }
        
        .form-label {
            display: block;
            font-size: 0.72rem;
            color: var(--text-muted);
            margin-bottom: 10px;
            text-transform: uppercase;
            letter-spacing: 1.5px;
            font-weight: 700;
        }
        
        .form-control {
            width: 100%;
            padding: 16px 18px;
            background: linear-gradient(135deg, rgba(12, 12, 20, 0.95) 0%, rgba(8, 8, 15, 0.9) 100%);
            border: 1px solid rgba(255, 255, 255, 0.06);
            border-radius: 12px;
            color: var(--text);
            font-size: 0.95rem;
            transition: all 0.4s ease;
            backdrop-filter: blur(10px);
        }
        
        .form-control:hover {
            border-color: rgba(0, 212, 255, 0.25);
            background: linear-gradient(135deg, rgba(15, 15, 25, 0.95) 0%, rgba(10, 10, 18, 0.9) 100%);
            box-shadow: 0 0 20px rgba(0, 212, 255, 0.08);
        }
        
        .form-control:focus {
            outline: none;
            border-color: var(--accent-cyan);
            box-shadow: 
                0 0 0 3px rgba(0, 212, 255, 0.15),
                0 0 30px rgba(0, 212, 255, 0.2),
                0 0 60px rgba(0, 212, 255, 0.1),
                inset 0 0 20px rgba(0, 212, 255, 0.03);
            background: linear-gradient(135deg, rgba(0, 212, 255, 0.08) 0%, rgba(10, 10, 20, 0.95) 100%);
        }

        .form-control::placeholder {
            color: var(--text-dim);
        }
        
        /* Select dropdown styling */
        select, .form-select {
            background: linear-gradient(135deg, rgba(12, 12, 20, 0.95) 0%, rgba(8, 8, 15, 0.9) 100%);
            border: 1px solid rgba(255, 255, 255, 0.06);
            border-radius: 12px;
            color: var(--text);
            padding: 12px 16px;
            cursor: pointer;
        }
        
        select option, .form-select option {
            background: #0a0a12;
            color: #f0f0f5;
            padding: 12px;
        }
        
        select option:hover,
        select option:focus,
        select option:checked,
        .form-select option:hover,
        .form-select option:focus,
        .form-select option:checked {
            background: linear-gradient(135deg, #1a1a2e 0%, #0f0f1a 100%);
            color: #00d4ff;
        }
        
        .form-switch {
            display: flex;
            align-items: center;
            gap: 12px;
        }
        
        .switch {
            position: relative;
            width: 54px;
            height: 28px;
        }
        
        .switch input {
            opacity: 0;
            width: 0;
            height: 0;
        }
        
        .switch-slider {
            position: absolute;
            cursor: pointer;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background: rgba(255, 255, 255, 0.08);
            border-radius: 28px;
            transition: all 0.4s ease;
            border: 1px solid rgba(255, 255, 255, 0.1);
        }
        
        .switch-slider::before {
            position: absolute;
            content: '';
            height: 22px;
            width: 22px;
            left: 2px;
            bottom: 2px;
            background: linear-gradient(135deg, #fff, #e0e0e0);
            border-radius: 50%;
            transition: all 0.4s cubic-bezier(0.175, 0.885, 0.32, 1.275);
            box-shadow: 0 2px 8px rgba(0, 0, 0, 0.3);
        }
        
        .switch input:checked + .switch-slider {
            background: linear-gradient(135deg, var(--accent-green), var(--accent-cyan));
            box-shadow: 0 0 25px rgba(0, 255, 157, 0.5), 0 0 50px rgba(0, 255, 157, 0.25);
            border-color: transparent;
        }
        
        .switch input:checked + .switch-slider::before {
            transform: translateX(26px);
            box-shadow: 0 0 15px rgba(255, 255, 255, 0.5);
        }
        
        /* Enhanced Alerts with Glow */
        .alert {
            padding: 18px 22px;
            border-radius: 14px;
            margin-bottom: 24px;
            display: flex;
            align-items: center;
            gap: 14px;
            font-size: 0.9rem;
            font-weight: 500;
            backdrop-filter: blur(10px);
            position: relative;
            overflow: hidden;
        }

        .alert::before {
            content: '';
            position: absolute;
            left: 0;
            top: 0;
            bottom: 0;
            width: 4px;
        }
        
        .alert-success {
            background: linear-gradient(135deg, rgba(0, 255, 157, 0.12) 0%, rgba(0, 255, 157, 0.05) 100%);
            border: 1px solid rgba(0, 255, 157, 0.25);
            color: var(--accent-green);
            box-shadow: 0 8px 30px rgba(0, 255, 157, 0.15), 0 0 50px rgba(0, 255, 157, 0.1);
        }

        .alert-success::before {
            background: linear-gradient(180deg, var(--accent-green), var(--accent-cyan));
            box-shadow: 0 0 15px var(--accent-green);
        }
        
        .alert-success i {
            filter: drop-shadow(0 0 10px rgba(0, 255, 157, 0.8));
            font-size: 1.2rem;
        }
        
        .alert-danger {
            background: linear-gradient(135deg, rgba(255, 71, 87, 0.12) 0%, rgba(255, 71, 87, 0.05) 100%);
            border: 1px solid rgba(255, 71, 87, 0.25);
            color: var(--danger);
            box-shadow: 0 8px 30px rgba(255, 71, 87, 0.15), 0 0 50px rgba(255, 71, 87, 0.1);
        }

        .alert-danger::before {
            background: linear-gradient(180deg, var(--danger), #ff6b6b);
            box-shadow: 0 0 15px var(--danger);
        }
        
        .alert-danger i {
            filter: drop-shadow(0 0 10px rgba(255, 71, 87, 0.8));
            font-size: 1.2rem;
        }

        .alert-warning {
            background: linear-gradient(135deg, rgba(255, 215, 0, 0.12) 0%, rgba(255, 215, 0, 0.05) 100%);
            border: 1px solid rgba(255, 215, 0, 0.25);
            color: var(--warning);
            box-shadow: 0 8px 30px rgba(255, 215, 0, 0.15), 0 0 50px rgba(255, 215, 0, 0.1);
        }

        .alert-warning::before {
            background: linear-gradient(180deg, var(--warning), #ffb800);
            box-shadow: 0 0 15px var(--warning);
        }

        .alert-info {
            background: linear-gradient(135deg, rgba(0, 212, 255, 0.12) 0%, rgba(0, 212, 255, 0.05) 100%);
            border: 1px solid rgba(0, 212, 255, 0.25);
            color: var(--accent-cyan);
            box-shadow: 0 8px 30px rgba(0, 212, 255, 0.15), 0 0 50px rgba(0, 212, 255, 0.1);
        }

        .alert-info::before {
            background: linear-gradient(180deg, var(--accent-cyan), var(--accent-purple));
            box-shadow: 0 0 15px var(--accent-cyan);
        }
        
        /* Page Title with Gradient */
        .page-title-gradient {
            background: var(--gradient-main);
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
            background-clip: text;
        }
        
        /* Enhanced Scrollbar with Glow */
        ::-webkit-scrollbar {
            width: 10px;
            height: 10px;
        }
        
        ::-webkit-scrollbar-track {
            background: rgba(5, 5, 10, 0.8);
            border-radius: 5px;
        }
        
        ::-webkit-scrollbar-thumb {
            background: linear-gradient(180deg, rgba(0, 212, 255, 0.3), rgba(168, 85, 247, 0.3));
            border-radius: 5px;
            border: 2px solid transparent;
            background-clip: padding-box;
        }
        
        ::-webkit-scrollbar-thumb:hover {
            background: linear-gradient(180deg, rgba(0, 212, 255, 0.5), rgba(168, 85, 247, 0.5));
            box-shadow: 0 0 15px rgba(0, 212, 255, 0.3);
        }

        ::-webkit-scrollbar-corner {
            background: transparent;
        }
        
        /* Selection Highlight */
        ::selection {
            background: rgba(0, 212, 255, 0.3);
            color: #fff;
        }

        ::-moz-selection {
            background: rgba(0, 212, 255, 0.3);
            color: #fff;
        }
        
        /* Grid */
        .row {
            display: flex;
            flex-wrap: wrap;
            margin: -10px;
        }
        
        .col-6 { width: 50%; padding: 10px; }
        .col-4 { width: 33.333%; padding: 10px; }
        .col-3 { width: 25%; padding: 10px; }
        .col-12 { width: 100%; padding: 10px; }
        
        @media (max-width: 768px) {
            .main-content { padding: 20px; }
            .col-6, .col-4, .col-3 { width: 100%; }
        }
    </style>
</head>
<body>
<!-- Noise Texture Overlay -->
<div class="noise-overlay"></div>

<!-- Floating Glow Particles -->
<div class="particles">
    <span></span><span></span><span></span><span></span><span></span>
    <span></span><span></span><span></span><span></span><span></span>
</div>
