<?php
$currentPage = basename($_SERVER['PHP_SELF'], '.php');
?>

<style>
/* Modern Top Navigation Bar */
.topnav {
    position: fixed;
    top: 0;
    left: 0;
    right: 0;
    height: 70px;
    background: linear-gradient(180deg, rgba(12, 12, 20, 0.98) 0%, rgba(8, 8, 14, 0.95) 100%);
    backdrop-filter: blur(20px) saturate(180%);
    -webkit-backdrop-filter: blur(20px) saturate(180%);
    border-bottom: 1px solid rgba(255, 255, 255, 0.06);
    display: flex;
    align-items: center;
    justify-content: space-between;
    padding: 0 30px;
    z-index: 1000;
    box-shadow: 
        0 4px 30px rgba(0, 0, 0, 0.4),
        0 0 50px rgba(0, 212, 255, 0.05);
}

/* Bottom Glow Line */
.topnav::after {
    content: '';
    position: absolute;
    bottom: 0;
    left: 10%;
    right: 10%;
    height: 1px;
    background: linear-gradient(90deg, transparent, rgba(0, 212, 255, 0.4), rgba(168, 85, 247, 0.4), rgba(0, 255, 157, 0.3), transparent);
    opacity: 0.7;
}

/* Logo Section */
.topnav-brand {
    display: flex;
    align-items: center;
    gap: 15px;
    text-decoration: none;
}

.topnav-logo {
    width: 44px;
    height: 44px;
    background: linear-gradient(135deg, var(--accent-green) 0%, var(--accent-cyan) 50%, var(--accent-purple) 100%);
    border-radius: 12px;
    display: flex;
    align-items: center;
    justify-content: center;
    font-size: 1.1rem;
    color: #000;
    font-weight: 900;
    box-shadow: 
        0 0 20px rgba(0, 255, 157, 0.3),
        0 0 40px rgba(0, 212, 255, 0.2);
    transition: all 0.3s ease;
}

.topnav-brand:hover .topnav-logo {
    transform: scale(1.05) rotate(3deg);
    box-shadow: 
        0 0 30px rgba(0, 255, 157, 0.5),
        0 0 60px rgba(0, 212, 255, 0.3);
}

.topnav-title {
    font-size: 1.2rem;
    font-weight: 800;
    background: linear-gradient(135deg, #fff 0%, var(--accent-cyan) 100%);
    -webkit-background-clip: text;
    -webkit-text-fill-color: transparent;
    letter-spacing: -0.5px;
}

.topnav-subtitle {
    font-size: 0.65rem;
    color: var(--text-dim);
    text-transform: uppercase;
    letter-spacing: 2px;
    margin-top: 2px;
}

/* Navigation Links */
.topnav-menu {
    display: flex;
    align-items: center;
    gap: 8px;
}

.topnav-link {
    display: flex;
    align-items: center;
    gap: 8px;
    padding: 10px 18px;
    border-radius: 10px;
    color: var(--text-muted);
    text-decoration: none;
    font-size: 0.85rem;
    font-weight: 600;
    transition: all 0.3s ease;
    border: 1px solid transparent;
    position: relative;
}

.topnav-link i {
    font-size: 1.1rem;
}

.topnav-link:hover {
    background: rgba(0, 212, 255, 0.1);
    color: var(--accent-cyan);
    border-color: rgba(0, 212, 255, 0.2);
}

.topnav-link:hover i {
    filter: drop-shadow(0 0 6px rgba(0, 212, 255, 0.5));
}

.topnav-link.active {
    background: linear-gradient(135deg, rgba(0, 255, 157, 0.15) 0%, rgba(0, 212, 255, 0.1) 100%);
    color: var(--accent-green);
    border-color: rgba(0, 255, 157, 0.3);
    box-shadow: 0 0 20px rgba(0, 255, 157, 0.15);
}

.topnav-link.active i {
    filter: drop-shadow(0 0 8px rgba(0, 255, 157, 0.6));
}

.topnav-link.active::after {
    content: '';
    position: absolute;
    bottom: -1px;
    left: 20%;
    right: 20%;
    height: 2px;
    background: linear-gradient(90deg, var(--accent-green), var(--accent-cyan));
    border-radius: 2px;
    box-shadow: 0 0 10px rgba(0, 255, 157, 0.5);
}

/* Divider */
.topnav-divider {
    width: 1px;
    height: 30px;
    background: linear-gradient(180deg, transparent, rgba(255, 255, 255, 0.1), transparent);
    margin: 0 10px;
}

/* Right Section - Actions */
.topnav-actions {
    display: flex;
    align-items: center;
    gap: 12px;
}

.topnav-action {
    width: 40px;
    height: 40px;
    border-radius: 10px;
    display: flex;
    align-items: center;
    justify-content: center;
    color: var(--text-dim);
    text-decoration: none;
    font-size: 1.1rem;
    transition: all 0.3s ease;
    border: 1px solid transparent;
}

.topnav-action:hover {
    background: rgba(0, 212, 255, 0.1);
    color: var(--accent-cyan);
    border-color: rgba(0, 212, 255, 0.2);
}

.topnav-action:hover i {
    filter: drop-shadow(0 0 6px rgba(0, 212, 255, 0.5));
}

.topnav-action.logout:hover {
    background: rgba(255, 71, 87, 0.1);
    color: #ff5252;
    border-color: rgba(255, 71, 87, 0.2);
}

.topnav-action.logout:hover i {
    filter: drop-shadow(0 0 6px rgba(255, 71, 87, 0.5));
}

/* Main Content - Adjusted for top nav */
.main-content {
    margin-top: 70px;
    min-height: calc(100vh - 70px);
    background: transparent;
    padding: 30px;
    padding-bottom: 60px;
    position: relative;
    z-index: 1;
}

/* Responsive */
@media (max-width: 900px) {
    .topnav {
        padding: 0 15px;
    }
    
    .topnav-title, .topnav-subtitle {
        display: none;
    }
    
    .topnav-link span {
        display: none;
    }
    
    .topnav-link {
        padding: 10px 14px;
    }
}

@media (max-width: 600px) {
    .topnav-menu {
        gap: 4px;
    }
    
    .topnav-link {
        padding: 8px 10px;
    }
    
    .topnav-divider {
        display: none;
    }
}
</style>

<nav class="topnav">
    <!-- Brand -->
    <a href="dashboard.php" class="topnav-brand">
        <div class="topnav-logo">GS</div>
        <div>
            <div class="topnav-title">GlobalSetting</div>
            <div class="topnav-subtitle">Control Panel</div>
        </div>
    </a>
    
    <!-- Menu -->
    <div class="topnav-menu">
        <a href="dashboard.php" class="topnav-link <?= $currentPage === 'dashboard' ? 'active' : '' ?>">
            <i class="bi bi-speedometer2"></i>
            <span>Dashboard</span>
        </a>
        <a href="control.php" class="topnav-link <?= $currentPage === 'control' ? 'active' : '' ?>">
            <i class="bi bi-sliders"></i>
            <span>Control</span>
        </a>
        <a href="settings.php" class="topnav-link <?= $currentPage === 'settings' ? 'active' : '' ?>">
            <i class="bi bi-gear-fill"></i>
            <span>Settings</span>
        </a>
        
        <div class="topnav-divider"></div>
        
        <a href="webshop.php" class="topnav-link <?= $currentPage === 'webshop' ? 'active' : '' ?>">
            <i class="bi bi-credit-card-fill"></i>
            <span>WebShop</span>
        </a>
        <a href="isp_whitelist.php" class="topnav-link <?= $currentPage === 'isp_whitelist' ? 'active' : '' ?>">
            <i class="bi bi-shield-check"></i>
            <span>ISP Whitelist</span>
        </a>
    </div>
    
    <!-- Actions -->
    <div class="topnav-actions">
        <a href="index.php?logout=1" class="topnav-action logout" title="Logout">
            <i class="bi bi-box-arrow-left"></i>
        </a>
    </div>
</nav>

<div class="main-content">
