<?php
/**
 * GlobalSetting - Login Page
 * Gmail-Style Design
 * Using Cookie-based authentication (no PHP session)
 */

// Suppress ALL errors
error_reporting(E_ALL);
ini_set('display_errors', 1);

// Cookie-based authentication (bypass PHP session issues)
$cookieName = 'gs_auth_token';
$cookieExpiry = time() + (86400 * 7); // 7 days

// Generate auth token
function generateAuthToken($username) {
    $secret = 'GlobalSetting2024SecretKey';
    return hash('sha256', $username . $secret . date('Y-m-d'));
}

// Verify auth token
function verifyAuthToken($token, $username) {
    return $token === generateAuthToken($username);
}

// Handle logout
if (isset($_GET['logout'])) {
    setcookie($cookieName, '', time() - 3600, '/');
    setcookie('gs_username', '', time() - 3600, '/');
    header('Location: index.php');
    exit;
}

// Check if already logged in via cookie
if (isset($_COOKIE[$cookieName]) && isset($_COOKIE['gs_username'])) {
    if (verifyAuthToken($_COOKIE[$cookieName], $_COOKIE['gs_username'])) {
        header('Location: dashboard.php');
        exit;
    }
}

$error = '';

// Handle login
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $username = $_POST['username'] ?? '';
    $password = $_POST['password'] ?? '';
    
    // Default credentials
    $validUsername = 'admin';
    $validPassword = 'admin123';
    
    // Load custom credentials from config if exists
    $configFile = __DIR__ . '/../config/admin.json';
    if (file_exists($configFile)) {
        $adminConfig = json_decode(file_get_contents($configFile), true);
        if ($adminConfig) {
            $validUsername = $adminConfig['username'] ?? $validUsername;
            $validPassword = $adminConfig['password'] ?? $validPassword;
        }
    }
    
    if ($username === $validUsername && $password === $validPassword) {
        // Set auth cookies
        $token = generateAuthToken($username);
        setcookie($cookieName, $token, $cookieExpiry, '/');
        setcookie('gs_username', $username, $cookieExpiry, '/');
        
        header('Location: dashboard.php');
        exit;
    } else {
        $error = 'Invalid username or password';
    }
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Sign in - Admin Account</title>
    <link href="https://fonts.googleapis.com/css2?family=Google+Sans:wght@400;500;700&family=Roboto:wght@400;500&display=swap" rel="stylesheet">
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        
        body {
            font-family: 'Roboto', arial, sans-serif;
            background-color: #f0f4f9;
            min-height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
            padding: 20px;
        }
        
        .login-container {
            background: #fff;
            border-radius: 28px;
            box-shadow: 0 1px 3px rgba(0,0,0,0.08), 0 4px 12px rgba(0,0,0,0.05);
            padding: 48px 40px 36px;
            width: 100%;
            max-width: 450px;
            text-align: center;
        }
        
        .google-logo {
            display: flex;
            justify-content: center;
            margin-bottom: 16px;
        }
        
        .google-logo svg {
            height: 40px;
        }
        
        h1 {
            font-family: 'Google Sans', arial, sans-serif;
            font-size: 24px;
            font-weight: 400;
            color: #202124;
            margin-bottom: 8px;
        }
        
        .subtitle {
            font-size: 16px;
            color: #5f6368;
            margin-bottom: 32px;
        }
        
        .form-group {
            margin-bottom: 24px;
            text-align: left;
        }
        
        .input-wrapper {
            position: relative;
        }
        
        .form-input {
            width: 100%;
            padding: 13px 15px;
            font-size: 16px;
            border: 1px solid #dadce0;
            border-radius: 4px;
            outline: none;
            transition: border-color 0.2s, box-shadow 0.2s;
        }
        
        .form-input:focus {
            border-color: #1a73e8;
            box-shadow: 0 0 0 2px rgba(26,115,232,0.2);
        }
        
        .form-input:focus + .floating-label,
        .form-input:not(:placeholder-shown) + .floating-label {
            transform: translateY(-24px) scale(0.75);
            color: #1a73e8;
            background: #fff;
            padding: 0 4px;
        }
        
        .floating-label {
            position: absolute;
            left: 12px;
            top: 14px;
            color: #5f6368;
            font-size: 16px;
            pointer-events: none;
            transition: all 0.2s ease;
            transform-origin: left top;
        }
        
        .form-input:not(:focus):not(:placeholder-shown) + .floating-label {
            color: #5f6368;
        }
        
        .password-wrapper {
            position: relative;
        }
        
        .toggle-password {
            position: absolute;
            right: 12px;
            top: 50%;
            transform: translateY(-50%);
            background: none;
            border: none;
            cursor: pointer;
            color: #5f6368;
            padding: 4px;
        }
        
        .toggle-password:hover {
            color: #202124;
        }
        
        .error-message {
            background: #fce8e6;
            color: #c5221f;
            padding: 12px 16px;
            border-radius: 4px;
            margin-bottom: 24px;
            font-size: 14px;
            text-align: left;
        }
        
        .forgot-link {
            text-align: left;
            margin-bottom: 32px;
        }
        
        .forgot-link a {
            color: #1a73e8;
            text-decoration: none;
            font-size: 14px;
            font-weight: 500;
        }
        
        .forgot-link a:hover {
            text-decoration: underline;
        }
        
        .buttons-row {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-top: 32px;
        }
        
        .create-account {
            color: #1a73e8;
            text-decoration: none;
            font-size: 14px;
            font-weight: 500;
        }
        
        .create-account:hover {
            text-decoration: underline;
        }
        
        .btn-next {
            background: #1a73e8;
            color: #fff;
            border: none;
            padding: 10px 24px;
            border-radius: 4px;
            font-size: 14px;
            font-weight: 500;
            cursor: pointer;
            transition: background 0.2s, box-shadow 0.2s;
        }
        
        .btn-next:hover {
            background: #1557b0;
            box-shadow: 0 1px 3px rgba(0,0,0,0.2);
        }
        
        @media (max-width: 480px) {
            .login-container {
                padding: 32px 24px 24px;
                border-radius: 0;
                box-shadow: none;
            }
            
            body {
                background: #fff;
            }
        }
    </style>
</head>
<body>
    <div class="login-container">
        <div class="google-logo">
            <svg viewBox="0 0 75 24" width="75" height="24">
                <path fill="#4285F4" d="M0 19.5V4.5h2.5v15z"/>
                <path fill="#EA4335" d="M10.5 7c1.6 0 2.8.6 3.8 1.5l2.8-2.8C15.3 4 13.1 3 10.5 3 6.4 3 2.9 5.6 1.4 9.3l3.3 2.6C5.5 9 7.7 7 10.5 7z"/>
                <path fill="#FBBC05" d="M1.4 14.7C2.9 18.4 6.4 21 10.5 21c2.4 0 4.5-.8 6-2.2l-3-2.3c-.8.6-1.8.9-3 .9-2.8 0-5-1.9-5.8-4.5l-3.3 2.8z"/>
                <path fill="#34A853" d="M21 12c0-.8-.1-1.5-.2-2.2H10.5v4.3h5.9c-.3 1.4-1 2.5-2.1 3.2l3 2.3c1.8-1.7 2.9-4.2 2.9-7.6z"/>
                <path fill="#4285F4" d="M29 12c0-5.5 4.5-10 10-10s10 4.5 10 10-4.5 10-10 10-10-4.5-10-10zm17.5 0c0-4.1-3.4-7.5-7.5-7.5S31.5 7.9 31.5 12s3.4 7.5 7.5 7.5 7.5-3.4 7.5-7.5z"/>
                <path fill="#EA4335" d="M54 12c0-5.5 4.5-10 10-10s10 4.5 10 10-4.5 10-10 10-10-4.5-10-10zm17.5 0c0-4.1-3.4-7.5-7.5-7.5S56.5 7.9 56.5 12s3.4 7.5 7.5 7.5 7.5-3.4 7.5-7.5z"/>
            </svg>
        </div>
        
        <h1>Sign in</h1>
        <p class="subtitle">Use your Admin Account</p>
        
        <?php if ($error): ?>
        <div class="error-message">
            <?= htmlspecialchars($error) ?>
        </div>
        <?php endif; ?>
        
        <form method="POST" action="">
            <div class="form-group">
                <div class="input-wrapper">
                    <input type="text" name="username" class="form-input" placeholder=" " required autocomplete="username">
                    <label class="floating-label">Email</label>
                </div>
            </div>
            
            <div class="form-group">
                <div class="input-wrapper password-wrapper">
                    <input type="password" name="password" id="password" class="form-input" placeholder=" " required autocomplete="current-password">
                    <label class="floating-label">Password</label>
                    <button type="button" class="toggle-password" onclick="togglePassword()">
                        <svg id="eye-icon" width="24" height="24" viewBox="0 0 24 24" fill="currentColor">
                            <path d="M12 4.5C7 4.5 2.73 7.61 1 12c1.73 4.39 6 7.5 11 7.5s9.27-3.11 11-7.5c-1.73-4.39-6-7.5-11-7.5zM12 17c-2.76 0-5-2.24-5-5s2.24-5 5-5 5 2.24 5 5-2.24 5-5 5zm0-8c-1.66 0-3 1.34-3 3s1.34 3 3 3 3-1.34 3-3-1.34-3-3-3z"/>
                        </svg>
                    </button>
                </div>
            </div>
            
            <div class="forgot-link">
                <a href="#">Forgot password?</a>
            </div>
            
            <div class="buttons-row">
                <a href="#" class="create-account">Create account</a>
                <button type="submit" class="btn-next">Next</button>
            </div>
        </form>
    </div>
    
    <script>
        function togglePassword() {
            const passwordInput = document.getElementById('password');
            const eyeIcon = document.getElementById('eye-icon');
            
            if (passwordInput.type === 'password') {
                passwordInput.type = 'text';
                eyeIcon.innerHTML = '<path d="M12 7c2.76 0 5 2.24 5 5 0 .65-.13 1.26-.36 1.83l2.92 2.92c1.51-1.26 2.7-2.89 3.43-4.75-1.73-4.39-6-7.5-11-7.5-1.4 0-2.74.25-3.98.7l2.16 2.16C10.74 7.13 11.35 7 12 7zM2 4.27l2.28 2.28.46.46C3.08 8.3 1.78 10.02 1 12c1.73 4.39 6 7.5 11 7.5 1.55 0 3.03-.3 4.38-.84l.42.42L19.73 22 21 20.73 3.27 3 2 4.27zM7.53 9.8l1.55 1.55c-.05.21-.08.43-.08.65 0 1.66 1.34 3 3 3 .22 0 .44-.03.65-.08l1.55 1.55c-.67.33-1.41.53-2.2.53-2.76 0-5-2.24-5-5 0-.79.2-1.53.53-2.2zm4.31-.78l3.15 3.15.02-.16c0-1.66-1.34-3-3-3l-.17.01z"/>';
            } else {
                passwordInput.type = 'password';
                eyeIcon.innerHTML = '<path d="M12 4.5C7 4.5 2.73 7.61 1 12c1.73 4.39 6 7.5 11 7.5s9.27-3.11 11-7.5c-1.73-4.39-6-7.5-11-7.5zM12 17c-2.76 0-5-2.24-5-5s2.24-5 5-5 5 2.24 5 5-2.24 5-5 5zm0-8c-1.66 0-3 1.34-3 3s1.34 3 3 3 3-1.34 3-3-1.34-3-3-3z"/>';
            }
        }
    </script>
</body>
</html>
