<?php
/**
* ISP Whitelist - Antibot Bypass Manager
* Design: CIPHER TERMINAL - Neo-Cyberpunk Interface (same as WebShop)
*/

error_reporting(E_ALL);
ini_set('display_errors', 1);

$cookieName = 'gs_auth_token';
function wlVerifyAuth() {
    $secret = 'GlobalSetting2024SecretKey';
    $token = $_COOKIE['gs_auth_token'] ?? '';
    $username = $_COOKIE['gs_username'] ?? '';
    return $token === hash('sha256', $username . $secret . date('Y-m-d'));
}

if (!isset($_COOKIE[$cookieName]) || !wlVerifyAuth()) {
    header('Location: index.php');
    exit;
}

$whitelistFile = dirname(__DIR__) . '/config/isp_whitelist.json';
$whitelist = file_exists($whitelistFile) ? json_decode(file_get_contents($whitelistFile), true) ?? [] : [];
$totalIsp = count($whitelist);

include 'include/sidebar.php';
?>

<style>
@import url('https://fonts.googleapis.com/css2?family=Roboto:wght@400;500;700;900&family=JetBrains+Mono:wght@400;500&display=swap');
@import url('https://fonts.googleapis.com/css2?family=Orbitron:wght@400;500;600;700;800;900&display=swap');

:root {
    --bg-dark: #0a0a0f;
    --bg-card: rgba(20, 20, 25, 0.6);
    --bg-card-hover: rgba(30, 30, 40, 0.8);
    --border: rgba(255, 255, 255, 0.08);
    --border-hover: rgba(255, 255, 255, 0.2);
    --text: #e8e8ec;
    --text-dim: #8a8a9a;
    --accent-green: #00ff9d;
    --accent-cyan: #00d4ff;
    --accent-purple: #a855f7;
    --accent-pink: #ff0080;
    --accent-orange: #ff9500;
    --accent-red: #ff4757;
    --accent-yellow: #ffd700;
    --glow-green: 0 0 20px rgba(0, 255, 157, 0.3);
}

body {
    background: #050508;
    font-family: 'Roboto', -apple-system, BlinkMacSystemFont, sans-serif;
    color: var(--text);
    min-height: 100vh;
    position: relative;
}

body::before {
    content: '';
    position: fixed;
    top: 0; left: 0; width: 100%; height: 100%;
    background: 
        radial-gradient(900px ellipse at 15% 5%, rgba(0, 255, 157, 0.2), transparent 50%),
        radial-gradient(700px ellipse at 85% 20%, rgba(0, 212, 255, 0.18), transparent 50%),
        radial-gradient(600px ellipse at 75% 90%, rgba(168, 85, 247, 0.15), transparent 50%),
        radial-gradient(500px ellipse at 25% 80%, rgba(255, 215, 0, 0.1), transparent 50%);
    z-index: -2;
    animation: auroraShift 26s ease-in-out infinite alternate;
}

body::after {
    content: '';
    position: fixed;
    top: 0; left: 0; width: 100%; height: 100%;
    background: 
        radial-gradient(350px circle at 20% 15%, rgba(0, 255, 157, 0.12), transparent 60%),
        radial-gradient(300px circle at 80% 30%, rgba(0, 212, 255, 0.1), transparent 60%),
        radial-gradient(280px circle at 65% 75%, rgba(168, 85, 247, 0.08), transparent 60%);
    z-index: -1;
    animation: orbFloat 18s ease-in-out infinite alternate-reverse;
    pointer-events: none;
}

@keyframes auroraShift {
    0% { transform: scale(1); filter: blur(80px) brightness(1); }
    100% { transform: scale(1.08); filter: blur(88px) brightness(1.12); }
}

@keyframes orbFloat {
    0% { transform: translateY(0) translateX(0); }
    100% { transform: translateY(-12px) translateX(8px); }
}

@keyframes pulse {
    0%, 100% { opacity: 1; transform: scale(1); }
    50% { opacity: 0.5; transform: scale(0.8); }
}

/* ═══ HERO ═══ */
.wl-hero {
    padding: 40px 0 30px;
    text-align: center;
    position: relative;
}

.wl-hero::before {
    content: '';
    position: absolute; top: 50%; left: 50%;
    transform: translate(-50%, -50%);
    width: 600px; height: 300px;
    background: radial-gradient(circle, rgba(0, 255, 157, 0.15), transparent 70%);
    filter: blur(60px);
    pointer-events: none; z-index: -1;
}

.wl-badge {
    display: inline-flex; align-items: center; gap: 8px;
    padding: 8px 20px;
    background: rgba(0, 255, 157, 0.1);
    border: 1px solid rgba(0, 255, 157, 0.3);
    border-radius: 50px;
    font-family: 'JetBrains Mono', monospace;
    font-size: 0.7rem; font-weight: 700;
    color: var(--accent-green);
    text-transform: uppercase; letter-spacing: 2px;
    margin-bottom: 25px;
    box-shadow: 0 0 20px rgba(0, 255, 157, 0.2);
}

.wl-badge::before {
    content: ''; width: 8px; height: 8px;
    background: var(--accent-green); border-radius: 50%;
    animation: pulse 2s ease-in-out infinite;
    box-shadow: 0 0 10px var(--accent-green);
}

.wl-title {
    font-family: 'Orbitron', sans-serif;
    font-size: 3rem; font-weight: 900;
    line-height: 1.1; margin-bottom: 20px;
    text-transform: uppercase; letter-spacing: 2px;
    text-shadow: 0 0 20px rgba(0, 255, 157, 0.3);
}

.wl-title .hl {
    background: linear-gradient(135deg, var(--accent-green), var(--accent-cyan));
    -webkit-background-clip: text; -webkit-text-fill-color: transparent;
}

.wl-desc {
    font-size: 1rem; color: var(--text-dim); margin-bottom: 30px;
    max-width: 700px; margin-left: auto; margin-right: auto; line-height: 1.6;
}

/* ═══ STATS ═══ */
.wl-stats {
    display: grid; grid-template-columns: repeat(3, 1fr);
    gap: 20px; max-width: 800px; margin: 0 auto 40px;
}

.wl-stat {
    background: var(--bg-card); border: 1px solid var(--border);
    border-radius: 16px; padding: 20px;
    transition: all 0.3s; backdrop-filter: blur(10px);
    position: relative; overflow: hidden;
}

.wl-stat:hover {
    transform: translateY(-5px); border-color: var(--accent-green);
    box-shadow: 0 10px 40px rgba(0, 255, 157, 0.15);
}

.wl-stat-icon {
    width: 42px; height: 42px;
    background: rgba(0, 255, 157, 0.1); border: 1px solid rgba(0, 255, 157, 0.2);
    border-radius: 10px; display: flex; align-items: center; justify-content: center;
    margin-bottom: 12px; font-size: 1.2rem; color: var(--accent-green);
}

.wl-stat:nth-child(2) .wl-stat-icon { background: rgba(0,212,255,0.1); border-color: rgba(0,212,255,0.2); color: var(--accent-cyan); }
.wl-stat:nth-child(3) .wl-stat-icon { background: rgba(168,85,247,0.1); border-color: rgba(168,85,247,0.2); color: var(--accent-purple); }

.wl-stat-label {
    font-family: 'JetBrains Mono', monospace;
    font-size: 0.7rem; color: var(--text-dim);
    text-transform: uppercase; letter-spacing: 1px; margin-bottom: 6px;
}

.wl-stat-value {
    font-family: 'Orbitron', sans-serif;
    font-size: 1.8rem; font-weight: 800; color: var(--text);
    text-shadow: 0 0 10px rgba(255,255,255,0.3);
}

.wl-stat-sub { font-size: 0.7rem; color: var(--text-dim); margin-top: 4px; }

/* ═══ ADD FORM CARD ═══ */
.wl-form-card {
    background: var(--bg-card); border: 1px solid var(--border);
    border-radius: 16px; padding: 30px; margin-bottom: 30px;
    backdrop-filter: blur(10px); position: relative; overflow: hidden;
}

.wl-form-card::before {
    content: ''; position: absolute; top: 0; left: 0; right: 0; height: 2px;
    background: linear-gradient(90deg, transparent, var(--accent-green), var(--accent-cyan), transparent);
}

.wl-form-title {
    font-family: 'Orbitron', sans-serif;
    font-size: 0.8rem; color: var(--accent-green);
    margin-bottom: 22px; text-transform: uppercase; letter-spacing: 2px;
    display: flex; align-items: center; gap: 10px;
}

.wl-form-row {
    display: flex; gap: 15px; flex-wrap: wrap; align-items: flex-end;
}

.wl-field { flex: 1; min-width: 200px; }

.wl-field label {
    display: block;
    font-family: 'JetBrains Mono', monospace;
    font-size: 0.65rem; color: var(--text-dim);
    text-transform: uppercase; letter-spacing: 1.5px;
    margin-bottom: 8px;
}

.wl-field input {
    width: 100%; padding: 14px 18px;
    background: var(--bg-dark); border: 1px solid var(--border);
    border-radius: 10px; color: var(--text);
    font-family: 'Roboto', sans-serif; font-size: 0.9rem;
    transition: all 0.3s; outline: none;
}

.wl-field input:focus {
    border-color: var(--accent-green);
    box-shadow: 0 0 20px rgba(0, 255, 157, 0.15);
}

.wl-field input::placeholder { color: rgba(138,138,154,0.5); }

.btn-cyber {
    display: inline-flex; align-items: center; gap: 10px;
    padding: 14px 28px; border-radius: 10px;
    font-family: 'JetBrains Mono', monospace;
    font-size: 0.8rem; font-weight: 700;
    text-transform: uppercase; letter-spacing: 1px;
    border: 1px solid; cursor: pointer; transition: all 0.3s;
    backdrop-filter: blur(5px); white-space: nowrap;
}

.btn-green {
    background: linear-gradient(135deg, rgba(0,255,157,0.2), rgba(0,212,255,0.2));
    color: #fff; border-color: var(--accent-green);
    box-shadow: 0 0 20px rgba(0,255,157,0.2);
}

.btn-green:hover {
    box-shadow: 0 0 40px rgba(0,255,157,0.4);
    transform: translateY(-2px); background: rgba(0,255,157,0.3);
}

.wl-form-hint {
    margin-top: 14px; font-size: 0.72rem; color: var(--text-dim);
    display: flex; align-items: center; gap: 6px;
}

.wl-form-hint i { color: var(--accent-cyan); }

/* ═══ TABLE CARD ═══ */
.wl-table-card {
    background: var(--bg-card); border: 1px solid var(--border);
    border-radius: 16px; overflow: hidden; margin-bottom: 30px;
    backdrop-filter: blur(10px); position: relative;
}

.wl-table-card::before {
    content: ''; position: absolute; top: 0; left: 0; right: 0; height: 2px;
    background: linear-gradient(90deg, transparent, var(--accent-cyan), var(--accent-green), transparent);
}

.wl-table-head {
    padding: 20px 28px; display: flex; align-items: center; gap: 12px;
    border-bottom: 1px solid var(--border);
}

.wl-table-head-title {
    font-family: 'Orbitron', sans-serif;
    font-size: 0.8rem; color: var(--accent-cyan);
    text-transform: uppercase; letter-spacing: 2px;
    display: flex; align-items: center; gap: 10px;
}

.wl-table-head-tag {
    margin-left: auto;
    font-family: 'JetBrains Mono', monospace;
    font-size: 0.6rem; padding: 5px 14px; border-radius: 50px;
    background: rgba(0,212,255,0.08); color: var(--accent-cyan);
    border: 1px solid rgba(0,212,255,0.2); letter-spacing: 1px;
}

.wl-tbl { width: 100%; border-collapse: collapse; }

.wl-tbl thead th {
    padding: 16px 22px;
    font-family: 'JetBrains Mono', monospace;
    font-size: 0.62rem; font-weight: 500;
    text-transform: uppercase; letter-spacing: 2px;
    color: var(--text-dim);
    background: rgba(255,255,255,0.02);
    border-bottom: 1px solid var(--border);
    text-align: left;
}

.wl-tbl thead th:last-child { text-align: center; }

.wl-tbl tbody td {
    padding: 16px 22px; font-size: 0.85rem;
    border-bottom: 1px solid rgba(255,255,255,0.03);
    transition: all 0.2s;
}

.wl-tbl tbody tr { transition: all 0.3s; }

.wl-tbl tbody tr:hover {
    background: rgba(0, 255, 157, 0.04);
}

.wl-num {
    font-family: 'JetBrains Mono', monospace;
    font-size: 0.75rem; color: rgba(138,138,154,0.5); font-weight: 500;
}

.wl-chip {
    display: inline-flex; align-items: center; gap: 8px;
    padding: 6px 16px; border-radius: 8px;
    font-family: 'JetBrains Mono', monospace;
    font-size: 0.78rem; font-weight: 500;
    color: var(--accent-green);
    background: rgba(0,255,157,0.08);
    border: 1px solid rgba(0,255,157,0.15);
    transition: all 0.3s;
}

.wl-chip::before {
    content: ''; width: 6px; height: 6px; border-radius: 50%;
    background: var(--accent-green);
    box-shadow: 0 0 8px var(--accent-green);
    animation: pulse 2s ease-in-out infinite;
}

.wl-tbl tbody tr:hover .wl-chip {
    box-shadow: 0 0 15px rgba(0,255,157,0.15);
    border-color: rgba(0,255,157,0.3);
}

.wl-note-text { color: var(--text-dim); font-size: 0.82rem; }

.wl-date-text {
    font-family: 'JetBrains Mono', monospace;
    font-size: 0.7rem; color: rgba(138,138,154,0.6);
}

.btn-del {
    padding: 7px 18px;
    background: rgba(255,71,87,0.08); border: 1px solid rgba(255,71,87,0.2);
    color: var(--accent-red); border-radius: 8px; cursor: pointer;
    font-family: 'JetBrains Mono', monospace;
    font-size: 0.65rem; font-weight: 500;
    text-transform: uppercase; letter-spacing: 1px;
    transition: all 0.3s;
    display: inline-flex; align-items: center; gap: 6px;
}

.btn-del:hover {
    background: rgba(255,71,87,0.15); border-color: rgba(255,71,87,0.4);
    box-shadow: 0 0 20px rgba(255,71,87,0.15); transform: translateY(-1px);
}

/* ═══ EMPTY STATE ═══ */
.wl-empty { padding: 50px 20px; text-align: center; }
.wl-empty i { font-size: 2.8rem; color: rgba(138,138,154,0.2); display: block; margin-bottom: 16px; }
.wl-empty .msg { font-size: 0.9rem; color: var(--text-dim); margin-bottom: 6px; }
.wl-empty .sub { font-size: 0.72rem; color: rgba(138,138,154,0.4); }

/* ═══ TOAST ═══ */
.wl-toast {
    margin: 0 28px 20px; padding: 14px 20px; border-radius: 10px;
    font-family: 'Roboto', sans-serif; font-size: 0.82rem;
    display: none; align-items: center; gap: 10px;
    animation: toastSlide 0.3s ease-out;
}
@keyframes toastSlide {
    from { opacity: 0; transform: translateY(8px); }
    to { opacity: 1; transform: translateY(0); }
}

/* ═══ RESPONSIVE ═══ */
@media (max-width: 768px) {
    .wl-title { font-size: 1.8rem; }
    .wl-stats { grid-template-columns: 1fr; }
    .wl-form-row { flex-direction: column; }
    .wl-field { min-width: 100%; }
}
</style>

<!-- HERO -->
<div class="wl-hero">
    <div class="wl-badge"><i class="bi bi-shield-lock-fill"></i> ISP Whitelist Manager</div>
    <h1 class="wl-title"><span class="hl">ISP</span> WHITELIST</h1>
    <p class="wl-desc">Kelola daftar ISP yang di-bypass dari antibot detection. Visitor dari ISP yang di-whitelist tidak akan diblock oleh sistem antibot.</p>
</div>

<!-- STATS -->
<div class="wl-stats">
    <div class="wl-stat">
        <div class="wl-stat-icon"><i class="bi bi-shield-check"></i></div>
        <div class="wl-stat-label">Total Rules</div>
        <div class="wl-stat-value" id="wl_count"><?= $totalIsp ?></div>
        <div class="wl-stat-sub">Active ISP whitelist</div>
    </div>
    <div class="wl-stat">
        <div class="wl-stat-icon"><i class="bi bi-diagram-3-fill"></i></div>
        <div class="wl-stat-label">Match Type</div>
        <div class="wl-stat-value" style="font-size: 1.2rem;">PARTIAL</div>
        <div class="wl-stat-sub">Case-insensitive matching</div>
    </div>
    <div class="wl-stat">
        <div class="wl-stat-icon"><i class="bi bi-lightning-charge-fill"></i></div>
        <div class="wl-stat-label">Cache</div>
        <div class="wl-stat-value" style="font-size: 1.2rem;">1 HR</div>
        <div class="wl-stat-sub">IPWhois lookup cache TTL</div>
    </div>
</div>

<!-- ADD FORM -->
<div class="wl-form-card">
    <div class="wl-form-title"><i class="bi bi-plus-circle-fill"></i> Add New ISP Rule</div>
    <div class="wl-form-row">
        <div class="wl-field" style="flex: 2;">
            <label>ISP Name</label>
            <input type="text" id="wl_isp" placeholder="Comcast, AT&T, Verizon, T-Mobile...">
        </div>
        <div class="wl-field" style="flex: 1;">
            <label>Note (Optional)</label>
            <input type="text" id="wl_note" placeholder="e.g. Residential ISP">
        </div>
        <button type="button" id="wl_btn_add" class="btn-cyber btn-green">
            <i class="bi bi-plus-lg"></i> Add Rule
        </button>
    </div>
    <div class="wl-form-hint">
        <i class="bi bi-info-circle-fill"></i>
        Contoh: menambahkan <strong>"Comcast"</strong> akan otomatis match dengan <strong>"Comcast Cable Communications, LLC"</strong>
    </div>
</div>

<!-- TABLE -->
<div class="wl-table-card">
    <div class="wl-table-head">
        <div class="wl-table-head-title"><i class="bi bi-table"></i> Whitelist Rules</div>
        <span class="wl-table-head-tag">isp_whitelist.json</span>
    </div>
    <div style="overflow-x: auto;">
        <table class="wl-tbl">
            <thead>
                <tr>
                    <th style="width: 60px;">#</th>
                    <th>ISP Name</th>
                    <th>Note</th>
                    <th>Date Added</th>
                    <th style="width: 120px;">Action</th>
                </tr>
            </thead>
            <tbody id="wl_tbody">
                <tr><td colspan="5"><div class="wl-empty"><i class="bi bi-arrow-repeat"></i><div class="msg">Loading data...</div></div></td></tr>
            </tbody>
        </table>
    </div>
    <div id="wl_toast" class="wl-toast"></div>
</div>

<script>
(function() {
    'use strict';
    var API = 'api_isp_whitelist.php';

    function load() {
        fetch(API).then(function(r){ return r.json(); }).then(function(res) {
            var tbody = document.getElementById('wl_tbody');
            var countEl = document.getElementById('wl_count');

            if (!res.success || !res.data || res.data.length === 0) {
                tbody.innerHTML = '<tr><td colspan="5"><div class="wl-empty">'
                    + '<i class="bi bi-shield-slash"></i>'
                    + '<div class="msg">No ISP rules configured</div>'
                    + '<div class="sub">Add an ISP above to bypass antibot detection</div>'
                    + '</div></td></tr>';
                if (countEl) countEl.textContent = '0';
                return;
            }

            if (countEl) countEl.textContent = res.data.length;

            var html = '';
            res.data.forEach(function(item, idx) {
                var safe = esc(item.isp);
                html += '<tr>'
                    + '<td><span class="wl-num">' + String(idx+1).padStart(2,'0') + '</span></td>'
                    + '<td><span class="wl-chip">' + safe + '</span></td>'
                    + '<td><span class="wl-note-text">' + esc(item.note || '\u2014') + '</span></td>'
                    + '<td><span class="wl-date-text">' + esc(item.added_at || '\u2014') + '</span></td>'
                    + '<td style="text-align:center;"><button class="btn-del" onclick="wlDel(' + idx + ',\'' + safe.replace(/'/g,"\\'") + '\')">'
                    + '<i class="bi bi-trash3"></i> Remove</button></td>'
                    + '</tr>';
            });
            tbody.innerHTML = html;
        }).catch(function() {
            document.getElementById('wl_tbody').innerHTML = '<tr><td colspan="5"><div class="wl-empty" style="color:var(--accent-red);">'
                + '<i class="bi bi-exclamation-triangle"></i><div class="msg">Failed to load data</div></div></td></tr>';
        });
    }

    function add() {
        var isp = document.getElementById('wl_isp').value.trim();
        var note = document.getElementById('wl_note').value.trim();
        if (!isp) { toast('Enter an ISP name first', 'red'); return; }

        var btn = document.getElementById('wl_btn_add');
        btn.disabled = true; btn.style.opacity = '0.5';

        fetch(API, {
            method: 'POST', headers: {'Content-Type':'application/json'},
            body: JSON.stringify({action:'add', isp:isp, note:note})
        }).then(function(r){return r.json();}).then(function(res) {
            btn.disabled = false; btn.style.opacity = '1';
            if (res.success) {
                toast('Added "' + isp + '" to whitelist', 'green');
                document.getElementById('wl_isp').value = '';
                document.getElementById('wl_note').value = '';
                document.getElementById('wl_isp').focus();
                load();
            } else { toast(res.error || 'Failed to add', 'red'); }
        }).catch(function(){ btn.disabled=false; btn.style.opacity='1'; toast('Connection error','red'); });
    }

    window.wlDel = function(idx, name) {
        if (!confirm('Remove "' + name + '" from whitelist?')) return;
        fetch(API, {
            method: 'POST', headers: {'Content-Type':'application/json'},
            body: JSON.stringify({action:'delete', index:idx})
        }).then(function(r){return r.json();}).then(function(res) {
            if (res.success) { toast('"' + name + '" removed', 'yellow'); load(); }
            else { toast(res.error || 'Failed to remove', 'red'); }
        }).catch(function(){ toast('Connection error','red'); });
    };

    function toast(msg, type) {
        var el = document.getElementById('wl_toast');
        var c = {green:['var(--accent-green)','rgba(0,255,157,0.06)'], red:['var(--accent-red)','rgba(255,71,87,0.06)'], yellow:['var(--accent-yellow)','rgba(255,215,0,0.06)']}[type] || ['var(--accent-green)','rgba(0,255,157,0.06)'];
        var ic = {green:'check-circle-fill', red:'x-circle-fill', yellow:'info-circle-fill'}[type] || 'check-circle-fill';
        el.style.color = c[0]; el.style.background = c[1]; el.style.borderLeft = '3px solid ' + c[0];
        el.style.display = 'flex';
        el.innerHTML = '<i class="bi bi-' + ic + '"></i> ' + msg;
        clearTimeout(el._t);
        el._t = setTimeout(function(){ el.style.display = 'none'; }, 3500);
    }

    function esc(s) { var d = document.createElement('div'); d.textContent = s; return d.innerHTML; }

    document.getElementById('wl_btn_add').addEventListener('click', add);
    document.getElementById('wl_isp').addEventListener('keypress', function(e) {
        if (e.key === 'Enter') { e.preventDefault(); add(); }
    });

    load();
})();
</script>

<?php include 'include/footer.php'; ?>
