<?php ob_start(); error_reporting(E_ALL); ini_set('display_errors', 1);
if (session_status() === PHP_SESSION_NONE) {
    @ini_set('session.save_path', sys_get_temp_dir());
    @session_start();
}

if (!isset($_SESSION['username'])) {
    header('Location: login');
    exit;
}

$config = json_decode(file_get_contents('../helper/config.json'), true);
?>
<!DOCTYPE html>
<html lang="en">

<head>
<meta charset="utf-8" />
<title>Settings | Dashboard</title>
<meta name="viewport" content="width=device-width, initial-scale=1" />
<meta name="description" content="" />
<meta name="author" content="" />

<link href="assets/css/vendor.min.css" rel="stylesheet" />
<link href="assets/css/app.min.css" rel="stylesheet" />

<style>
.tag-container {
    display: flex;
    flex-wrap: wrap;
    gap: 8px;
    padding: 10px;
    border: 1px solid rgba(255,255,255,0.2);
    border-radius: 6px;
    min-height: 50px;
    background: rgba(0,0,0,0.2);
}
.tag {
    display: inline-flex;
    align-items: center;
    background: #3b82f6;
    color: white;
    padding: 4px 10px;
    border-radius: 4px;
    font-size: 13px;
}
.tag.whitelist {
    background: #22c55e;
}
.tag .remove-tag {
    margin-left: 8px;
    cursor: pointer;
    opacity: 0.7;
    font-weight: bold;
}
.tag .remove-tag:hover {
    opacity: 1;
}
.add-tag-input {
    flex: 1;
    min-width: 150px;
    background: transparent;
    border: none;
    outline: none;
    color: white;
    padding: 4px;
}
.add-tag-input::placeholder {
    color: rgba(255,255,255,0.5);
}
.stats-card {
    background: linear-gradient(135deg, rgba(59, 130, 246, 0.1), rgba(139, 92, 246, 0.1));
    border: 1px solid rgba(255,255,255,0.1);
}
.save-indicator {
    display: none;
    color: #22c55e;
}
.save-indicator.show {
    display: inline;
}
</style>
</head>
<body>

<div id="app" class="app">

<?php include 'include/nav.php'; ?>
<?php include 'include/sidebar.php'; ?>

<button class="app-sidebar-mobile-backdrop" data-toggle-target=".app" data-toggle-class="app-sidebar-mobile-toggled"></button>

<div id="content" class="app-content">

<!-- Header -->
<div class="d-flex align-items-center mb-4">
    <div>
        <h1 class="page-header mb-0">Settings</h1>
        <small class="text-white text-opacity-50">Manage ISP Blacklist & Whitelist</small>
    </div>
</div>

<!-- Stats Cards -->
<div class="row mb-4">
    <div class="col-md-3">
        <div class="card stats-card mb-3">
            <div class="card-body">
                <div class="d-flex justify-content-between align-items-center">
                    <div>
                        <div class="text-white text-opacity-50 small">Local Blocked IPs</div>
                        <h3 class="mb-0" id="blockedIpsCount">0</h3>
                    </div>
                    <div class="text-primary fs-1"><i class="bi bi-shield-x"></i></div>
                </div>
            </div>
        </div>
    </div>
    <div class="col-md-3">
        <div class="card stats-card mb-3">
            <div class="card-body">
                <div class="d-flex justify-content-between align-items-center">
                    <div>
                        <div class="text-white text-opacity-50 small">IPWhois Cache</div>
                        <h3 class="mb-0" id="ipwhoisCacheCount">0</h3>
                    </div>
                    <div class="text-info fs-1"><i class="bi bi-database"></i></div>
                </div>
            </div>
        </div>
    </div>
    <div class="col-md-3">
        <div class="card stats-card mb-3">
            <div class="card-body">
                <div class="d-flex justify-content-between align-items-center">
                    <div>
                        <div class="text-white text-opacity-50 small">ISP Blacklist</div>
                        <h3 class="mb-0" id="blacklistCount"><?= count($config['isp_blacklist'] ?? []) ?></h3>
                    </div>
                    <div class="text-danger fs-1"><i class="bi bi-ban"></i></div>
                </div>
            </div>
        </div>
    </div>
    <div class="col-md-3">
        <div class="card stats-card mb-3">
            <div class="card-body">
                <div class="d-flex justify-content-between align-items-center">
                    <div>
                        <div class="text-white text-opacity-50 small">ISP Whitelist</div>
                        <h3 class="mb-0" id="whitelistCount"><?= count($config['isp_whitelist'] ?? []) ?></h3>
                    </div>
                    <div class="text-success fs-1"><i class="bi bi-check-circle"></i></div>
                </div>
            </div>
        </div>
    </div>
</div>

<div class="row">
    <!-- ISP Blacklist Settings -->
    <div class="col-xl-6">
        <div class="card mb-4">
            <div class="card-body">
                <div class="d-flex justify-content-between align-items-center mb-3">
                    <div>
                        <h5 class="mb-0"><i class="bi bi-ban text-danger me-2"></i>ISP Blacklist</h5>
                        <small class="text-white text-opacity-50">Block requests from these ISPs (partial match)</small>
                    </div>
                    <div class="form-check form-switch">
                        <input class="form-check-input" type="checkbox" id="ispBlacklistStatus" <?= ($config['isp_blacklist_status'] ?? 'off') === 'on' ? 'checked' : '' ?>>
                        <label class="form-check-label" for="ispBlacklistStatus">Enabled</label>
                    </div>
                </div>
                
                <div class="tag-container" id="blacklistContainer">
                    <?php foreach (($config['isp_blacklist'] ?? []) as $isp): ?>
                    <span class="tag">
                        <?= htmlspecialchars($isp) ?>
                        <span class="remove-tag" onclick="removeTag('blacklist', this)">&times;</span>
                    </span>
                    <?php endforeach; ?>
                    <input type="text" class="add-tag-input" id="blacklistInput" placeholder="Type ISP name and press Enter..." onkeydown="handleTagInput(event, 'blacklist')">
                </div>
                
                <div class="mt-3 d-flex justify-content-between align-items-center">
                    <small class="text-white text-opacity-50">
                        <i class="bi bi-info-circle me-1"></i>
                        Partial match: "Microsoft" blocks "Microsoft Corporation", "Microsoft Azure", etc.
                    </small>
                    <span class="save-indicator" id="blacklistSaved"><i class="bi bi-check-circle me-1"></i>Saved</span>
                </div>
            </div>
        </div>
    </div>

    <!-- ISP Whitelist Settings -->
    <div class="col-xl-6">
        <div class="card mb-4">
            <div class="card-body">
                <div class="d-flex justify-content-between align-items-center mb-3">
                    <div>
                        <h5 class="mb-0"><i class="bi bi-check-circle text-success me-2"></i>ISP Whitelist</h5>
                        <small class="text-white text-opacity-50">Allow requests from these ISPs (priority over blacklist)</small>
                    </div>
                </div>
                
                <div class="tag-container" id="whitelistContainer">
                    <?php foreach (($config['isp_whitelist'] ?? []) as $isp): ?>
                    <span class="tag whitelist">
                        <?= htmlspecialchars($isp) ?>
                        <span class="remove-tag" onclick="removeTag('whitelist', this)">&times;</span>
                    </span>
                    <?php endforeach; ?>
                    <input type="text" class="add-tag-input" id="whitelistInput" placeholder="Type ISP name and press Enter..." onkeydown="handleTagInput(event, 'whitelist')">
                </div>
                
                <div class="mt-3 d-flex justify-content-between align-items-center">
                    <small class="text-white text-opacity-50">
                        <i class="bi bi-info-circle me-1"></i>
                        Whitelist takes priority - matching ISPs will NOT be blocked
                    </small>
                    <span class="save-indicator" id="whitelistSaved"><i class="bi bi-check-circle me-1"></i>Saved</span>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Local Blocked IPs -->
<div class="row">
    <div class="col-12">
        <div class="card mb-4">
            <div class="card-body">
                <div class="d-flex justify-content-between align-items-center mb-3">
                    <div>
                        <h5 class="mb-0"><i class="bi bi-shield-x text-warning me-2"></i>Local Blocked IPs</h5>
                        <small class="text-white text-opacity-50">IPs automatically blocked by ISP blacklist or Gobot</small>
                    </div>
                    <button class="btn btn-sm btn-outline-danger" onclick="clearBlockedIps()">
                        <i class="bi bi-trash me-1"></i>Clear All
                    </button>
                </div>
                
                <div class="table-responsive">
                    <table class="table table-striped table-borderless mb-0 small">
                        <thead>
                            <tr>
                                <th>IP Address</th>
                                <th>Reason</th>
                                <th>Date Blocked</th>
                                <th>Action</th>
                            </tr>
                        </thead>
                        <tbody id="blockedIpsTable">
                            <tr><td colspan="4" class="text-center text-muted">Loading...</td></tr>
                        </tbody>
                    </table>
                </div>
                
                <!-- Pagination -->
                <div class="d-flex justify-content-between align-items-center mt-3">
                    <div class="text-muted small">
                        Showing <span id="showingFrom">0</span>-<span id="showingTo">0</span> of <span id="totalBlocked">0</span> blocked IPs
                    </div>
                    <nav>
                        <ul class="pagination pagination-sm mb-0" id="blockedPagination"></ul>
                    </nav>
                </div>
            </div>
        </div>
    </div>
</div>

</div>

<?php include 'include/footer.php'; ?>

<script>
let blockedPage = 1;
const blockedLimit = 20;

// Load stats on page load
async function loadStats() {
    try {
        const res = await fetch('api.php?action=isp_stats&_=' + Date.now());
        const data = await res.json();
        
        document.getElementById('blockedIpsCount').textContent = data.blocked_ips || 0;
        document.getElementById('ipwhoisCacheCount').textContent = data.ipwhois_cache || 0;
    } catch (e) {
        console.warn('Error loading stats:', e);
    }
}

// Handle tag input
function handleTagInput(event, type) {
    if (event.key === 'Enter') {
        event.preventDefault();
        const input = event.target;
        const value = input.value.trim();
        
        if (value) {
            addTag(type, value);
            input.value = '';
        }
    }
}

// Add tag
function addTag(type, value) {
    const container = document.getElementById(type + 'Container');
    const input = document.getElementById(type + 'Input');
    
    // Create tag element
    const tag = document.createElement('span');
    tag.className = 'tag' + (type === 'whitelist' ? ' whitelist' : '');
    tag.innerHTML = `${escapeHtml(value)}<span class="remove-tag" onclick="removeTag('${type}', this)">&times;</span>`;
    
    // Insert before input
    container.insertBefore(tag, input);
    
    // Save to server
    saveIspList(type);
}

// Remove tag
function removeTag(type, element) {
    element.parentElement.remove();
    saveIspList(type);
}

// Save ISP list to server
async function saveIspList(type) {
    const container = document.getElementById(type + 'Container');
    const tags = container.querySelectorAll('.tag');
    const values = Array.from(tags).map(tag => tag.textContent.replace('×', '').trim());
    
    // Update count
    document.getElementById(type + 'Count').textContent = values.length;
    
    try {
        const res = await fetch('api.php?action=save_isp_list', {
            method: 'POST',
            headers: { 'Content-Type': 'application/json' },
            body: JSON.stringify({ type: type, values: values })
        });
        
        const data = await res.json();
        if (data.success) {
            // Show saved indicator
            const indicator = document.getElementById(type + 'Saved');
            indicator.classList.add('show');
            setTimeout(() => indicator.classList.remove('show'), 2000);
        }
    } catch (e) {
        console.error('Error saving:', e);
        alert('Error saving ' + type);
    }
}

// Toggle ISP blacklist status
document.getElementById('ispBlacklistStatus').addEventListener('change', async function() {
    const status = this.checked ? 'on' : 'off';
    
    try {
        const res = await fetch('api.php?action=save_isp_status', {
            method: 'POST',
            headers: { 'Content-Type': 'application/json' },
            body: JSON.stringify({ status: status })
        });
        
        const data = await res.json();
        if (!data.success) {
            alert('Error saving status');
            this.checked = !this.checked;
        }
    } catch (e) {
        console.error('Error:', e);
        alert('Error saving status');
        this.checked = !this.checked;
    }
});

// Load blocked IPs
async function loadBlockedIps(page = 1) {
    blockedPage = page;
    
    try {
        const res = await fetch(`api.php?action=blocked_ips&page=${page}&limit=${blockedLimit}&_=${Date.now()}`);
        const data = await res.json();
        
        const tbody = document.getElementById('blockedIpsTable');
        const pagination = data.pagination || {};
        
        document.getElementById('showingFrom').textContent = pagination.total > 0 ? ((page - 1) * blockedLimit) + 1 : 0;
        document.getElementById('showingTo').textContent = Math.min(page * blockedLimit, pagination.total || 0);
        document.getElementById('totalBlocked').textContent = pagination.total || 0;
        document.getElementById('blockedIpsCount').textContent = pagination.total || 0;
        
        if (!data.data || data.data.length === 0) {
            tbody.innerHTML = '<tr><td colspan="4" class="text-center text-muted">No blocked IPs</td></tr>';
            document.getElementById('blockedPagination').innerHTML = '';
            return;
        }
        
        tbody.innerHTML = data.data.map(item => `
            <tr>
                <td><code>${escapeHtml(item.ip)}</code></td>
                <td>${escapeHtml(item.reason)}</td>
                <td>${escapeHtml(item.date)}</td>
                <td>
                    <button class="btn btn-xs btn-outline-danger" onclick="removeBlockedIp('${escapeHtml(item.ip)}')">
                        <i class="bi bi-trash"></i>
                    </button>
                </td>
            </tr>
        `).join('');
        
        // Render pagination
        renderBlockedPagination(pagination.totalPages || 1);
    } catch (e) {
        console.error('Error loading blocked IPs:', e);
    }
}

function renderBlockedPagination(totalPages) {
    const container = document.getElementById('blockedPagination');
    if (totalPages <= 1) {
        container.innerHTML = '';
        return;
    }
    
    let html = '';
    
    // Previous
    html += `<li class="page-item ${blockedPage === 1 ? 'disabled' : ''}">
        <a class="page-link" href="#" onclick="loadBlockedIps(${blockedPage - 1}); return false;">&laquo;</a>
    </li>`;
    
    // Pages
    for (let i = 1; i <= Math.min(5, totalPages); i++) {
        html += `<li class="page-item ${i === blockedPage ? 'active' : ''}">
            <a class="page-link" href="#" onclick="loadBlockedIps(${i}); return false;">${i}</a>
        </li>`;
    }
    
    // Next
    html += `<li class="page-item ${blockedPage === totalPages ? 'disabled' : ''}">
        <a class="page-link" href="#" onclick="loadBlockedIps(${blockedPage + 1}); return false;">&raquo;</a>
    </li>`;
    
    container.innerHTML = html;
}

// Remove single blocked IP
async function removeBlockedIp(ip) {
    if (!confirm('Remove ' + ip + ' from blocked list?')) return;
    
    try {
        const res = await fetch('api.php?action=remove_blocked_ip', {
            method: 'POST',
            headers: { 'Content-Type': 'application/json' },
            body: JSON.stringify({ ip: ip })
        });
        
        const data = await res.json();
        if (data.success) {
            loadBlockedIps(blockedPage);
        } else {
            alert('Error removing IP');
        }
    } catch (e) {
        console.error('Error:', e);
        alert('Error removing IP');
    }
}

// Clear all blocked IPs
async function clearBlockedIps() {
    if (!confirm('Clear ALL blocked IPs? They will need to be re-checked by IPWhois/Gobot.')) return;
    
    try {
        const res = await fetch('api.php?action=clear_blocked_ips', {
            method: 'POST'
        });
        
        const data = await res.json();
        if (data.success) {
            loadBlockedIps(1);
            alert('All blocked IPs cleared!');
        } else {
            alert('Error clearing blocked IPs');
        }
    } catch (e) {
        console.error('Error:', e);
        alert('Error clearing blocked IPs');
    }
}

function escapeHtml(text) {
    const div = document.createElement('div');
    div.textContent = text;
    return div.innerHTML;
}

// Initial load
loadStats();
loadBlockedIps();
</script>

</body>
</html>
