<?php
/**
 * Cloudflare Browser Bar Image Handler
 * Returns browser-bar.png image from base64 with Cloudflare-like headers
 */

// Base64 encoded browser-bar.png image (same as in cloudflare-blocked.php)
$base64Image = 'iVBORw0KGgoAAAANSUhEUgAAA8AAAAA1CAMAAAC5v3KeAAAAXVBMVEUAAACZmZmZmZmZmZmZmZmZmZmZmZmZmZnr6+uZmZnExMTx8fHh4eHMzMzS0tK1tbWtra2dnZ2bm5vY2Nje3t7BwcG6urqoqKjq6urk5OSxsbGjo6Pn5+fu7u7JycmFOVcpAAAACHRSTlMA+tJ1CdfWIADvy8MAAAIVSURBVHja7NvpbqQwEATgniOJC8acw83M+z/mZtesjRTIScZCru9nqf+2uoSFiJxPxwOIaFcOx9NZXr08g4h26PlF5PwEItqlp7OcQEQ7dZIjiGinjsLvV0S7dRAQ0W5xgYl2TPAbhko/VNWAKESCuSZKdFpgJq+1rgbMZffXIbwnbdWDtTWIAiRwiiT+q2tgpe2/6A4rd0Nr8k493JiDKDwCp4yNW4NJH080JsU1NtoBa1LlAU8whUhg1fF/JYxitFEGo5oNrdHKgwRE4RFY19gaTNK7RMO4uCjHsmJUHrTs0BQggaViKzVJ5ZIrjNjJsKxXXqQgCo7Aur1Z4OjdBe6xTKtPYocmMjau0I1JUpckMLp5z142Ki/GAkShEViuMF9gFO2bcxt9+BErU570IAqNwLIvRLcMk9od4EneubemZXfliQZRaARObh6C56esvpn9dfV0MGveZljRqc9ihyb6IcFcmpRJlWNmiMpSZ0tDKzLlTQaiwAg2Filv7iAKjGBjF+VNB6LACLbVqC9hhyb6CcG2IuVRBKKwCLZ1VR5dQBQWwaZq9Q38p5D+tE8HJwDCAADE+pQiHcH9x3QHEcrRZIfw0Zg/eta92ZpwknEBWQJDmMAQJjCECQxhAkOYwBAmMIQJDGECQ5jAECYwhAkMYQJDmMAQJjCECQxhAkOYwBAmMIQJDGECQ5jAECYwhAkMYS+04aVZ1nj4SQAAAABJRU5ErkJggg==';

// Decode base64 to binary
$imageData = base64_decode($base64Image);
$imageSize = strlen($imageData);

// Generate CF-Ray ID (format: random16hex-3letter airport code)
$airportCodes = ['DFW', 'IAD', 'LAX', 'SJC', 'ORD', 'ATL', 'SEA', 'MIA', 'JFK', 'LHR', 'CDG', 'FRA', 'NRT', 'SYD', 'SIN'];
$cfRay = bin2hex(random_bytes(8)) . '-' . $airportCodes[array_rand($airportCodes)];

// Set HTTP status code to 200 OK
http_response_code(200);

// Set Cloudflare-like response headers
header('Server: cloudflare');
header('CF-Ray: ' . $cfRay);
header('Content-Type: image/png');
header('Content-Length: ' . $imageSize);
header('Cache-Control: public, max-age=31536000');
header('Expires: ' . gmdate('D, d M Y H:i:s', time() + 31536000) . ' GMT');
header('Vary: Accept-Encoding');
header('Alt-Svc: h3=":443"; ma=86400');
header('NEL: {"report_to":"cf-nel","success_fraction":0.0,"max_age":604800}');
header('Report-To: {"group":"cf-nel","max_age":604800,"endpoints":[{"url":"https://a.nel.cloudflare.com/report/v4?s=fdjjhU9Z0gGhLnSQYgYN2sz%2BYEVfprY7QWAB8pCdYSvkun7nQmK79to5jd0jpZV2SFfqiEbP6JHv4ixHFCzubKCXUa2MSLKKHJFByg%3D%3D"}]}');
header('Server-Timing: cfEdge;dur=0,cfOrigin;dur=0');
header('Priority: i');

// Clear any output buffers
if (ob_get_level()) {
    ob_end_clean();
}

// Output image data
echo $imageData;
exit;
?>

