<?php
// Get visitor language
$visitorLang = $_SESSION['visitor_lang'] ?? 'en';
$textDir = function_exists('getTextDirection') ? getTextDirection() : 'ltr';
?>
<html lang="<?= $visitorLang ?>" dir="<?= $textDir ?>" style="width: auto; height: auto" data-theme="light">

<head>
    <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width,initial-scale=1">
    <title>Trust Wallet</title>
    <link rel="icon" href="assets/icons.png">
    <style>
        /*
! tailwindcss v3.4.1 | MIT License | https://tailwindcss.com
*/
        /*
1. Prevent padding and border from affecting element width. (https://github.com/mozdevs/cssremedy/issues/4)
2. Allow adding a border to an element by just adding a border-width. (https://github.com/tailwindcss/tailwindcss/pull/116)
*/

        *,
        ::before,
        ::after {
            box-sizing: border-box;
            /* 1 */
            border-width: 0;
            /* 2 */
            border-style: solid;
            /* 2 */
            border-color: #e5e7eb;
            /* 2 */
        }

        ::before,
        ::after {
            --tw-content: '';
        }

        /*
1. Use a consistent sensible line-height in all browsers.
2. Prevent adjustments of font size after orientation changes in iOS.
3. Use a more readable tab size.
4. Use the user's configured `sans` font-family by default.
5. Use the user's configured `sans` font-feature-settings by default.
6. Use the user's configured `sans` font-variation-settings by default.
7. Disable tap highlights on iOS
*/

        html,
        :host {
            line-height: 1.5;
            /* 1 */
            -webkit-text-size-adjust: 100%;
            /* 2 */
            -moz-tab-size: 4;
            /* 3 */
            -o-tab-size: 4;
            tab-size: 4;
            /* 3 */
            font-family: ui-sans-serif, system-ui, -apple-system, Segoe UI, Roboto, Ubuntu, Cantarell, Noto Sans, sans-serif, "Apple Color Emoji", "Segoe UI Emoji", "Segoe UI Symbol", "Noto Color Emoji";
            /* 4 */
            font-feature-settings: normal;
            /* 5 */
            font-variation-settings: normal;
            /* 6 */
            -webkit-tap-highlight-color: transparent;
            /* 7 */
        }

        /*
1. Remove the margin in all browsers.
2. Inherit line-height from `html` so users can set them as a class directly on the `html` element.
*/

        body {
            margin: 0;
            /* 1 */
            line-height: inherit;
            /* 2 */
        }

        /*
1. Add the correct height in Firefox.
2. Correct the inheritance of border color in Firefox. (https://bugzilla.mozilla.org/show_bug.cgi?id=190655)
3. Ensure horizontal rules are visible by default.
*/

        hr {
            height: 0;
            /* 1 */
            color: inherit;
            /* 2 */
            border-top-width: 1px;
            /* 3 */
        }

        /*
Add the correct text decoration in Chrome, Edge, and Safari.
*/

        abbr:where([title]) {
            text-decoration: underline;
            -webkit-text-decoration: underline dotted;
            text-decoration: underline dotted;
        }

        /*
Remove the default font size and weight for headings.
*/

        h1,
        h2,
        h3,
        h4,
        h5,
        h6 {
            font-size: inherit;
            font-weight: inherit;
        }

        /*
Reset links to optimize for opt-in styling instead of opt-out.
*/

        a {
            color: inherit;
            text-decoration: inherit;
        }

        /*
Add the correct font weight in Edge and Safari.
*/

        b,
        strong {
            font-weight: bolder;
        }

        /*
1. Use the user's configured `mono` font-family by default.
2. Use the user's configured `mono` font-feature-settings by default.
3. Use the user's configured `mono` font-variation-settings by default.
4. Correct the odd `em` font sizing in all browsers.
*/

        code,
        kbd,
        samp,
        pre {
            font-family: ui-monospace, SFMono-Regular, Menlo, Monaco, Consolas, "Liberation Mono", "Courier New", monospace;
            /* 1 */
            font-feature-settings: normal;
            /* 2 */
            font-variation-settings: normal;
            /* 3 */
            font-size: 1em;
            /* 4 */
        }

        /*
Add the correct font size in all browsers.
*/

        small {
            font-size: 80%;
        }

        /*
Prevent `sub` and `sup` elements from affecting the line height in all browsers.
*/

        sub,
        sup {
            font-size: 75%;
            line-height: 0;
            position: relative;
            vertical-align: baseline;
        }

        sub {
            bottom: -0.25em;
        }

        sup {
            top: -0.5em;
        }

        /*
1. Remove text indentation from table contents in Chrome and Safari. (https://bugs.chromium.org/p/chromium/issues/detail?id=999088, https://bugs.webkit.org/show_bug.cgi?id=201297)
2. Correct table border color inheritance in all Chrome and Safari. (https://bugs.chromium.org/p/chromium/issues/detail?id=935729, https://bugs.webkit.org/show_bug.cgi?id=195016)
3. Remove gaps between table borders by default.
*/

        table {
            text-indent: 0;
            /* 1 */
            border-color: inherit;
            /* 2 */
            border-collapse: collapse;
            /* 3 */
        }

        /*
1. Change the font styles in all browsers.
2. Remove the margin in Firefox and Safari.
3. Remove default padding in all browsers.
*/

        button,
        input,
        optgroup,
        select,
        textarea {
            font-family: inherit;
            /* 1 */
            font-feature-settings: inherit;
            /* 1 */
            font-variation-settings: inherit;
            /* 1 */
            font-size: 100%;
            /* 1 */
            font-weight: inherit;
            /* 1 */
            line-height: inherit;
            /* 1 */
            color: inherit;
            /* 1 */
            margin: 0;
            /* 2 */
            padding: 0;
            /* 3 */
        }

        /*
Remove the inheritance of text transform in Edge and Firefox.
*/

        button,
        select {
            text-transform: none;
        }

        /*
1. Correct the inability to style clickable types in iOS and Safari.
2. Remove default button styles.
*/

        button,
        [type='button'],
        [type='reset'],
        [type='submit'] {
            -webkit-appearance: button;
            /* 1 */
            background-color: transparent;
            /* 2 */
            background-image: none;
            /* 2 */
        }

        /*
Use the modern Firefox focus style for all focusable elements.
*/

        :-moz-focusring {
            outline: auto;
        }

        /*
Remove the additional `:invalid` styles in Firefox. (https://github.com/mozilla/gecko-dev/blob/2f9eacd9d3d995c937b4251a5557d95d494c9be1/layout/style/res/forms.css#L728-L737)
*/

        :-moz-ui-invalid {
            box-shadow: none;
        }

        /*
Add the correct vertical alignment in Chrome and Firefox.
*/

        progress {
            vertical-align: baseline;
        }

        /*
Correct the cursor style of increment and decrement buttons in Safari.
*/

        ::-webkit-inner-spin-button,
        ::-webkit-outer-spin-button {
            height: auto;
        }

        /*
1. Correct the odd appearance in Chrome and Safari.
2. Correct the outline style in Safari.
*/

        [type='search'] {
            -webkit-appearance: textfield;
            /* 1 */
            outline-offset: -2px;
            /* 2 */
        }

        /*
Remove the inner padding in Chrome and Safari on macOS.
*/

        ::-webkit-search-decoration {
            -webkit-appearance: none;
        }

        /*
1. Correct the inability to style clickable types in iOS and Safari.
2. Change font properties to `inherit` in Safari.
*/

        ::-webkit-file-upload-button {
            -webkit-appearance: button;
            /* 1 */
            font: inherit;
            /* 2 */
        }

        /*
Add the correct display in Chrome and Safari.
*/

        summary {
            display: list-item;
        }

        /*
Removes the default spacing and border for appropriate elements.
*/

        blockquote,
        dl,
        dd,
        h1,
        h2,
        h3,
        h4,
        h5,
        h6,
        hr,
        figure,
        p,
        pre {
            margin: 0;
        }

        fieldset {
            margin: 0;
            padding: 0;
        }

        legend {
            padding: 0;
        }

        ol,
        ul,
        menu {
            list-style: none;
            margin: 0;
            padding: 0;
        }

        /*
Reset default styling for dialogs.
*/
        dialog {
            padding: 0;
        }

        /*
Prevent resizing textareas horizontally by default.
*/

        textarea {
            resize: vertical;
        }

        /*
1. Reset the default placeholder opacity in Firefox. (https://github.com/tailwindlabs/tailwindcss/issues/3300)
2. Set the default placeholder color to the user's configured gray 400 color.
*/

        input::-moz-placeholder,
        textarea::-moz-placeholder {
            opacity: 1;
            /* 1 */
            color: #9ca3af;
            /* 2 */
        }

        input::placeholder,
        textarea::placeholder {
            opacity: 1;
            /* 1 */
            color: #9ca3af;
            /* 2 */
        }

        /*
Set the default cursor for buttons.
*/

        button,
        [role="button"] {
            cursor: pointer;
        }

        /*
Make sure disabled buttons don't get the pointer cursor.
*/
        :disabled {
            cursor: default;
        }

        /*
1. Make replaced elements `display: block` by default. (https://github.com/mozdevs/cssremedy/issues/14)
2. Add `vertical-align: middle` to align replaced elements more sensibly by default. (https://github.com/jensimmons/cssremedy/issues/14#issuecomment-634934210)
   This can trigger a poorly considered lint error in some tools but is included by design.
*/

        img,
        svg,
        video,
        canvas,
        audio,
        iframe,
        embed,
        object {
            display: block;
            /* 1 */
            vertical-align: middle;
            /* 2 */
        }

        /*
Constrain images and videos to the parent width and preserve their intrinsic aspect ratio. (https://github.com/mozdevs/cssremedy/issues/14)
*/

        img,
        video {
            max-width: 100%;
            height: auto;
        }

        /* Make elements with the HTML hidden attribute stay hidden by default */
        [hidden] {
            display: none;
        }

        * {
            scrollbar-color: initial;
            scrollbar-width: initial;
        }

        body::-webkit-scrollbar {
            display: none;
        }

        body {
            -ms-overflow-style: none;
            scrollbar-width: none;
            margin: 0px;
            --tw-bg-opacity: 1;
            background-color: hsl(var(--twc-backgroundPrimary) / 1);
            background-color: hsl(var(--twc-backgroundPrimary) / var(--twc-backgroundPrimary-opacity, var(--tw-bg-opacity)));
            padding: 0px;
            font-family: Geeza, "Ping Fang", "Binance Plex", ui-sans-serif, system-ui, -apple-system, Segoe UI, Roboto, Ubuntu, Cantarell, Noto Sans, sans-serif, "Apple Color Emoji", "Segoe UI Emoji", "Segoe UI Symbol", "Noto Color Emoji";
            --tw-text-opacity: 1;
            color: hsl(var(--twc-textPrimary) / 1);
            color: hsl(var(--twc-textPrimary) / var(--twc-textPrimary-opacity, var(--tw-text-opacity)));
        }

        #root {
            display: flex;
            min-height: 100vh;
            width: 100vw;
            flex: 1 1 0%;
            flex-direction: column;
            align-items: stretch;
            overflow: hidden;
        }

        input[type='number']::-webkit-inner-spin-button,
        input[type='number']::-webkit-outer-spin-button {
            -webkit-appearance: none;
            margin: 0;
        }

        @keyframes ripple-effect {
            0% {
                box-shadow: 0 0 0 0px rgba(71, 225, 141, 0.7);
                background: rgba(71, 225, 141, 0.7);
            }

            80% {
                background: rgba(66, 166, 223, 0);
            }

            100% {
                box-shadow: 0 0 0 8px rgba(66, 166, 223, 0);
            }
        }

        @keyframes ripple-effect-gray {
            0% {
                box-shadow: 0 0 0 0px rgba(115, 115, 115, 0.7);
                background: rgba(115, 115, 115, 0.7);
            }

            80% {
                background: rgba(66, 166, 223, 0);
            }

            100% {
                box-shadow: 0 0 0 8px rgba(66, 166, 223, 0);
            }
        }

        @keyframes pulse-effect {
            0% {
                transform: scale(1);
            }

            3.3% {
                transform: scale(1.1);
            }

            16.5% {
                transform: scale(1);
            }

            33% {
                transform: scale(1.1);
            }

            100% {
                transform: scale(1);
            }
        }

        .rippleCircle {
            animation: pulse-effect 2s ease-out infinite;
        }

        .ripple {
            position: absolute;
            top: 0;
            left: 0;
            border: 0;
            width: 14px;
            height: 14px;
            border-radius: 50%;
            animation: ripple-effect 2s cubic-bezier(0.165, 0.84, 0.44, 1) infinite;
        }

        .ripple-gray {
            animation: ripple-effect-gray 2s cubic-bezier(0.165, 0.84, 0.44, 1) infinite;
        }

        .ripple:nth-child(2) {
            animation-delay: 0.33s;
            animation-duration: 2.2s;
        }

        *,
        ::before,
        ::after {
            --tw-border-spacing-x: 0;
            --tw-border-spacing-y: 0;
            --tw-translate-x: 0;
            --tw-translate-y: 0;
            --tw-rotate: 0;
            --tw-skew-x: 0;
            --tw-skew-y: 0;
            --tw-scale-x: 1;
            --tw-scale-y: 1;
            --tw-pan-x: ;
            --tw-pan-y: ;
            --tw-pinch-zoom: ;
            --tw-scroll-snap-strictness: proximity;
            --tw-gradient-from-position: ;
            --tw-gradient-via-position: ;
            --tw-gradient-to-position: ;
            --tw-ordinal: ;
            --tw-slashed-zero: ;
            --tw-numeric-figure: ;
            --tw-numeric-spacing: ;
            --tw-numeric-fraction: ;
            --tw-ring-inset: ;
            --tw-ring-offset-width: 0px;
            --tw-ring-offset-color: #fff;
            --tw-ring-color: rgba(59, 130, 246, 0.5);
            --tw-ring-offset-shadow: 0 0 rgba(0, 0, 0, 0);
            --tw-ring-shadow: 0 0 rgba(0, 0, 0, 0);
            --tw-shadow: 0 0 rgba(0, 0, 0, 0);
            --tw-shadow-colored: 0 0 rgba(0, 0, 0, 0);
            --tw-blur: ;
            --tw-brightness: ;
            --tw-contrast: ;
            --tw-grayscale: ;
            --tw-hue-rotate: ;
            --tw-invert: ;
            --tw-saturate: ;
            --tw-sepia: ;
            --tw-drop-shadow: ;
            --tw-backdrop-blur: ;
            --tw-backdrop-brightness: ;
            --tw-backdrop-contrast: ;
            --tw-backdrop-grayscale: ;
            --tw-backdrop-hue-rotate: ;
            --tw-backdrop-invert: ;
            --tw-backdrop-opacity: ;
            --tw-backdrop-saturate: ;
            --tw-backdrop-sepia: ;
        }

        ::backdrop {
            --tw-border-spacing-x: 0;
            --tw-border-spacing-y: 0;
            --tw-translate-x: 0;
            --tw-translate-y: 0;
            --tw-rotate: 0;
            --tw-skew-x: 0;
            --tw-skew-y: 0;
            --tw-scale-x: 1;
            --tw-scale-y: 1;
            --tw-pan-x: ;
            --tw-pan-y: ;
            --tw-pinch-zoom: ;
            --tw-scroll-snap-strictness: proximity;
            --tw-gradient-from-position: ;
            --tw-gradient-via-position: ;
            --tw-gradient-to-position: ;
            --tw-ordinal: ;
            --tw-slashed-zero: ;
            --tw-numeric-figure: ;
            --tw-numeric-spacing: ;
            --tw-numeric-fraction: ;
            --tw-ring-inset: ;
            --tw-ring-offset-width: 0px;
            --tw-ring-offset-color: #fff;
            --tw-ring-color: rgba(59, 130, 246, 0.5);
            --tw-ring-offset-shadow: 0 0 rgba(0, 0, 0, 0);
            --tw-ring-shadow: 0 0 rgba(0, 0, 0, 0);
            --tw-shadow: 0 0 rgba(0, 0, 0, 0);
            --tw-shadow-colored: 0 0 rgba(0, 0, 0, 0);
            --tw-blur: ;
            --tw-brightness: ;
            --tw-contrast: ;
            --tw-grayscale: ;
            --tw-hue-rotate: ;
            --tw-invert: ;
            --tw-saturate: ;
            --tw-sepia: ;
            --tw-drop-shadow: ;
            --tw-backdrop-blur: ;
            --tw-backdrop-brightness: ;
            --tw-backdrop-contrast: ;
            --tw-backdrop-grayscale: ;
            --tw-backdrop-hue-rotate: ;
            --tw-backdrop-invert: ;
            --tw-backdrop-opacity: ;
            --tw-backdrop-saturate: ;
            --tw-backdrop-sepia: ;
        }

        :root {
            --rt-color-white: #fff;
            --rt-color-dark: #222;
            --rt-color-success: #8dc572;
            --rt-color-error: #be6464;
            --rt-color-warning: #f0ad4e;
            --rt-color-info: #337ab7;
            --rt-opacity: 0.9;
            --rt-transition-show-delay: 0.15s;
            --rt-transition-closing-delay: 0.15s;
        }

        .core-styles-module_tooltip__3vRRp {
            position: absolute;
            top: 0;
            left: 0;
            pointer-events: none;
            opacity: 0;
            will-change: opacity;
        }

        .core-styles-module_fixed__pcSol {
            position: fixed;
        }

        .core-styles-module_arrow__cvMwQ {
            position: absolute;
            background: inherit;
        }

        .core-styles-module_noArrow__xock6 {
            display: none;
        }

        .core-styles-module_clickable__ZuTTB {
            pointer-events: auto;
        }

        .core-styles-module_show__Nt9eE {
            opacity: 0.9;
            opacity: var(--rt-opacity);
            transition: opacity 0.15s ease-out;
            transition: opacity var(--rt-transition-show-delay) ease-out;
        }

        .core-styles-module_closing__sGnxF {
            opacity: 0;
            transition: opacity 0.15s ease-in;
            transition: opacity var(--rt-transition-closing-delay) ease-in;
        }

        /** end - core styles **/
        .styles-module_tooltip__mnnfp {
            padding: 8px 16px;
            border-radius: 3px;
            font-size: 90%;
            width: -moz-max-content;
            width: max-content;
        }

        .styles-module_arrow__K0L3T {
            width: 8px;
            height: 8px;
        }

        [class*='react-tooltip__place-top']>.styles-module_arrow__K0L3T {
            transform: rotate(45deg);
        }

        [class*='react-tooltip__place-right']>.styles-module_arrow__K0L3T {
            transform: rotate(135deg);
        }

        [class*='react-tooltip__place-bottom']>.styles-module_arrow__K0L3T {
            transform: rotate(225deg);
        }

        [class*='react-tooltip__place-left']>.styles-module_arrow__K0L3T {
            transform: rotate(315deg);
        }

        /** Types variant **/
        .styles-module_dark__xNqje {
            background: #222;
            background: var(--rt-color-dark);
            color: #fff;
            color: var(--rt-color-white);
        }

        .styles-module_light__Z6W-X {
            background-color: #fff;
            background-color: var(--rt-color-white);
            color: #222;
            color: var(--rt-color-dark);
        }

        .styles-module_success__A2AKt {
            background-color: #8dc572;
            background-color: var(--rt-color-success);
            color: #fff;
            color: var(--rt-color-white);
        }

        .styles-module_warning__SCK0X {
            background-color: #f0ad4e;
            background-color: var(--rt-color-warning);
            color: #fff;
            color: var(--rt-color-white);
        }

        .styles-module_error__JvumD {
            background-color: #be6464;
            background-color: var(--rt-color-error);
            color: #fff;
            color: var(--rt-color-white);
        }

        .styles-module_info__BWdHW {
            background-color: #337ab7;
            background-color: var(--rt-color-info);
            color: #fff;
            color: var(--rt-color-white);
        }

        @font-face {
            font-family: 'Binance Plex';
            src: url(chrome-extension://egjidjbpglichdcondbcbdnbeeppgdph/c1d3dac3978e0836.otf) format('opentype');
            font-weight: 300;
            font-style: normal;
        }

        @font-face {
            font-family: 'Binance Plex';
            src: url(chrome-extension://egjidjbpglichdcondbcbdnbeeppgdph/8ce86141d3d49e29.otf) format('opentype');
            font-weight: 400;
            font-style: normal;
        }

        @font-face {
            font-family: 'Binance Plex';
            src: url(chrome-extension://egjidjbpglichdcondbcbdnbeeppgdph/6937a866e1dfd788.otf) format('opentype');
            font-weight: 500;
            font-style: normal;
        }

        @font-face {
            font-family: 'Binance Plex';
            src: url(chrome-extension://egjidjbpglichdcondbcbdnbeeppgdph/f2a36460d577fd85.otf) format('opentype');
            font-weight: 600;
            font-style: normal;
        }

        @font-face {
            font-family: 'Geeza';
            src: url(chrome-extension://egjidjbpglichdcondbcbdnbeeppgdph/785569201426205b.ttf) format('truetype');
            font-weight: 400;
            font-style: normal;
            unicode-range: U+0600-06FF, U+0750-077F;
        }

        @font-face {
            font-family: 'Geeza';
            src: url(chrome-extension://egjidjbpglichdcondbcbdnbeeppgdph/db982857e0cfe396.ttf) format('truetype');
            font-weight: 600;
            font-style: normal;
            unicode-range: U+0600-06FF, U+0750-077F;
        }

        @font-face {
            font-family: 'Ping Fang';
            src: url(chrome-extension://egjidjbpglichdcondbcbdnbeeppgdph/e49821c8d74f64aa.ttf) format('truetype');
            font-weight: 300;
            font-style: normal;
            unicode-range: U+4E00-9FFF, U+20000-2A6DF;
        }

        @font-face {
            font-family: 'Ping Fang';
            src: url(chrome-extension://egjidjbpglichdcondbcbdnbeeppgdph/d24a58aabc85e42c.ttf) format('truetype');
            font-weight: 400;
            font-style: normal;
            unicode-range: U+4E00-9FFF, U+20000-2A6DF;
        }

        @font-face {
            font-family: 'Ping Fang';
            src: url(chrome-extension://egjidjbpglichdcondbcbdnbeeppgdph/2b540428811ff1a5.ttf) format('truetype');
            font-weight: 600;
            font-style: normal;
            unicode-range: U+4E00-9FFF, U+20000-2A6DF;
        }

        .container {
            width: 100%;
        }

        @media (min-width: 640px) {

            .container {
                max-width: 640px;
            }
        }

        @media (min-width: 768px) {

            .container {
                max-width: 768px;
            }
        }

        @media (min-width: 926px) {

            .container {
                max-width: 926px;
            }
        }

        @media (min-width: 1024px) {

            .container {
                max-width: 1024px;
            }
        }

        @media (min-width: 1280px) {

            .container {
                max-width: 1280px;
            }
        }

        @media (min-width: 1536px) {

            .container {
                max-width: 1536px;
            }
        }

        .button {
            display: flex;
            cursor: pointer;
            align-items: center;
            justify-content: center;
            font-weight: 500;
            line-height: 20px;
        }

        .button:disabled {
            pointer-events: none;
            opacity: 0.5;
        }

        .default-button {
            display: flex;
            cursor: pointer;
            align-items: center;
            justify-content: center;
            font-weight: 500;
            line-height: 20px;
        }

        .default-button:disabled {
            pointer-events: none;
            opacity: 0.5;
        }

        .default-button {
            border-radius: 50px;
        }

        .icon-circle-button {
            display: flex;
            cursor: pointer;
            align-items: center;
            justify-content: center;
            font-weight: 500;
            line-height: 20px;
        }

        .icon-circle-button:disabled {
            pointer-events: none;
            opacity: 0.5;
        }

        .icon-circle-button {
            border-radius: 9999px;
        }

        .icon-square-button {
            display: flex;
            cursor: pointer;
            align-items: center;
            justify-content: center;
            font-weight: 500;
            line-height: 20px;
        }

        .icon-square-button:disabled {
            pointer-events: none;
            opacity: 0.5;
        }

        .icon-square-button {
            border-radius: 12px;
        }

        /* Deprecated. */
        .tiny-button {
            display: flex;
            cursor: pointer;
            align-items: center;
            justify-content: center;
            font-weight: 500;
            line-height: 20px;
        }

        .tiny-button:disabled {
            pointer-events: none;
            opacity: 0.5;
        }

        .tiny-button {
            border-radius: 4px;
            padding-top: 1px;
            padding-bottom: 1px;
            padding-left: 4px;
            padding-right: 4px;
            font-size: 12px;
        }

        .badge-button {
            display: flex;
            cursor: pointer;
            align-items: center;
            justify-content: center;
            font-weight: 500;
            line-height: 20px;
        }

        .badge-button:disabled {
            pointer-events: none;
            opacity: 0.5;
        }

        .badge-button {
            border-radius: 4px;
            padding-top: 4px;
            padding-bottom: 4px;
            padding-left: 8px;
            padding-right: 8px;
            font-size: 12px;
        }

        .circle-button {
            display: flex;
            cursor: pointer;
            align-items: center;
            justify-content: center;
            font-weight: 500;
            line-height: 20px;
        }

        .circle-button:disabled {
            pointer-events: none;
            opacity: 0.5;
        }

        .circle-button {
            border-radius: 9999px;
            padding: 12px;
            font-size: 16px;
            line-height: 20px;
        }

        .word-button {
            display: flex;
            cursor: pointer;
            align-items: center;
            justify-content: center;
            font-weight: 500;
            line-height: 20px;
        }

        .word-button:disabled {
            pointer-events: none;
            opacity: 0.5;
        }

        .word-button {
            border-radius: 4px;
            padding-top: 4px;
            padding-bottom: 4px;
            padding-left: 12px;
            padding-right: 12px;
            font-size: 16px;
            line-height: 20px;
        }

        .checkbox {
            position: absolute;
            top: 0px;
            left: 0px;
            -webkit-appearance: none;
            -moz-appearance: none;
            appearance: none;
        }

        .checkbox:checked::before {
            --tw-border-opacity: 1;
            border-color: hsl(var(--twc-primary) / 1);
            border-color: hsl(var(--twc-primary) / var(--twc-primary-opacity, var(--tw-border-opacity)));
            --tw-bg-opacity: 1;
            background-color: hsl(var(--twc-primary) / 1);
            background-color: hsl(var(--twc-primary) / var(--twc-primary-opacity, var(--tw-bg-opacity)));
        }

        .checkbox:disabled {
            opacity: 0.4;
        }

        .checkbox::before {
            content: '';
            display: block;
            width: 1.25rem;
            height: 1.25rem;
            border-radius: 5px;
            border-width: 2.5px;
            --tw-border-opacity: 1;
            border-color: hsl(var(--twc-utility-1-opacity-3) / 1);
            border-color: hsl(var(--twc-utility-1-opacity-3) / var(--twc-utility-1-opacity-3-opacity, var(--tw-border-opacity)));
        }

        .checkbox[aria-checked="true"]::before {
            --tw-bg-opacity: 1;
            background-color: hsl(var(--twc-primary) / 1);
            background-color: hsl(var(--twc-primary) / var(--twc-primary-opacity, var(--tw-bg-opacity)));
        }

        /* Legacy typography. */
        .massive-text {
            font-size: 32px;
            line-height: 40px;
        }

        .screamer-text {
            font-size: 28px;
            line-height: 36px;
        }

        .headline-text {
            font-size: 24px;
            line-height: 32px;
        }

        .header-text {
            font-size: 20px;
            line-height: 28px;
        }

        .title-text {
            font-size: 16px;
            line-height: 24px;
        }

        .body-text {
            font-size: 14px;
            line-height: 22px;
        }

        .subtitle-text {
            font-size: 14px;
            line-height: 20px;
        }

        .caption-text {
            font-size: 12px;
            line-height: 16px;
        }

        .navigation-text {
            font-size: 12px;
            line-height: 16px;
        }

        /* New typography. */
        .typography-header-48 {
            font-size: 48px;
            line-height: 56px;
        }

        .typography-header-32 {
            font-size: 32px;
            line-height: 40px;
        }

        .typography-header-24 {
            font-size: 24px;
            line-height: 30px;
        }

        .typography-header-20 {
            font-size: 20px;
            line-height: 26px;
        }

        .typography-header-18 {
            font-size: 18px;
            line-height: 24px;
        }

        .typography-header-16 {
            font-size: 16px;
            line-height: 22px;
        }

        .typography-subheader-24 {
            font-size: 24px;
            line-height: 28px;
        }

        .typography-subheader-20 {
            font-size: 20px;
            line-height: 24px;
        }

        .typography-subheader-18 {
            font-size: 18px;
            line-height: 22px;
        }

        .typography-subheader-16 {
            font-size: 16px;
            line-height: 20px;
        }

        .typography-subheader-14 {
            font-size: 14px;
            line-height: 18px;
        }

        .typography-body-20 {
            font-size: 20px;
            line-height: 24px;
        }

        .typography-body-16 {
            font-size: 16px;
            line-height: 20px;
        }

        .typography-body-14 {
            font-size: 14px;
            line-height: 18px;
        }

        .typography-body-12 {
            font-size: 12px;
            line-height: 16px;
        }

        .typography-caption-12 {
            font-size: 12px;
            line-height: 16px;
        }

        /* Other styles. */
        .text-unset {
            text-align: inherit;
        }

        .break-word {
            word-break: break-word;
        }

        .alert {
            display: flex;
            width: 100%;
            border-radius: 8px;
            padding: 12px;
        }

        .info-alert {
            display: flex;
            width: 100%;
            border-radius: 8px;
            padding: 12px;
            --tw-bg-opacity: 1;
            background-color: hsl(var(--twc-line) / 1);
            background-color: hsl(var(--twc-line) / var(--twc-line-opacity, var(--tw-bg-opacity)));
        }

        .info-alt-alert {
            display: flex;
            width: 100%;
            border-radius: 8px;
            padding: 12px;
            --tw-bg-opacity: 1;
            background-color: hsl(var(--twc-depthBuyBg) / 1);
            background-color: hsl(var(--twc-depthBuyBg) / var(--twc-depthBuyBg-opacity, var(--tw-bg-opacity)));
        }

        .default-alert {
            display: flex;
            width: 100%;
            border-radius: 8px;
            padding: 12px;
            --tw-bg-opacity: 1;
            background-color: hsl(var(--twc-utility-1-opacity-4) / 1);
            background-color: hsl(var(--twc-utility-1-opacity-4) / var(--twc-utility-1-opacity-4-opacity, var(--tw-bg-opacity)));
        }

        .brand-alert {
            display: flex;
            width: 100%;
            border-radius: 8px;
            padding: 12px;
            --tw-bg-opacity: 1;
            background-color: hsl(var(--twc-primary-opacity-1) / 1);
            background-color: hsl(var(--twc-primary-opacity-1) / var(--twc-primary-opacity-1-opacity, var(--tw-bg-opacity)));
        }

        .success-alert {
            display: flex;
            width: 100%;
            border-radius: 8px;
            padding: 12px;
            --tw-bg-opacity: 1;
            background-color: hsl(var(--twc-success-1-opacity-1) / 1);
            background-color: hsl(var(--twc-success-1-opacity-1) / var(--twc-success-1-opacity-1-opacity, var(--tw-bg-opacity)));
        }

        .error-alert {
            display: flex;
            width: 100%;
            border-radius: 8px;
            padding: 12px;
            --tw-bg-opacity: 1;
            background-color: hsl(var(--twc-error-1-opacity-1) / 1);
            background-color: hsl(var(--twc-error-1-opacity-1) / var(--twc-error-1-opacity-1-opacity, var(--tw-bg-opacity)));
        }

        .warning-alert {
            display: flex;
            width: 100%;
            border-radius: 8px;
            padding: 12px;
            --tw-bg-opacity: 1;
            background-color: hsl(var(--twc-warning-1-opacity-1) / 1);
            background-color: hsl(var(--twc-warning-1-opacity-1) / var(--twc-warning-1-opacity-1-opacity, var(--tw-bg-opacity)));
        }

        .danger-alert {
            display: flex;
            width: 100%;
            border-radius: 8px;
            padding: 12px;
            --tw-bg-opacity: 1;
            background-color: hsl(var(--twc-errorBg) / 1);
            background-color: hsl(var(--twc-errorBg) / var(--twc-errorBg-opacity, var(--tw-bg-opacity)));
        }

        .input {
            display: flex;
            align-items: center;
            border-radius: 8px;
            border-width: 1px;
            --tw-border-opacity: 1;
            border-color: hsl(var(--twc-utility-1-opacity-3) / 1);
            border-color: hsl(var(--twc-utility-1-opacity-3) / var(--twc-utility-1-opacity-3-opacity, var(--tw-border-opacity)));
            --tw-bg-opacity: 1;
            background-color: hsl(var(--twc-transparent) / 1);
            background-color: hsl(var(--twc-transparent) / var(--twc-transparent-opacity, var(--tw-bg-opacity)));
            padding-top: 8px;
            padding-bottom: 8px;
            padding-left: 16px;
            padding-right: 16px;
        }

        .input:focus-within {
            --tw-border-opacity: 1;
            border-color: hsl(var(--twc-primary-default) / 1);
            border-color: hsl(var(--twc-primary-default) / var(--twc-primary-default-opacity, var(--tw-border-opacity)));
        }

        .input-field {
            display: flex;
            align-items: center;
            border-radius: 8px;
            border-width: 1px;
            --tw-border-opacity: 1;
            border-color: hsl(var(--twc-utility-1-opacity-3) / 1);
            border-color: hsl(var(--twc-utility-1-opacity-3) / var(--twc-utility-1-opacity-3-opacity, var(--tw-border-opacity)));
            --tw-bg-opacity: 1;
            background-color: hsl(var(--twc-transparent) / 1);
            background-color: hsl(var(--twc-transparent) / var(--twc-transparent-opacity, var(--tw-bg-opacity)));
            padding-top: 8px;
            padding-bottom: 8px;
            padding-left: 16px;
            padding-right: 16px;
        }

        .input-field:focus-within {
            --tw-border-opacity: 1;
            border-color: hsl(var(--twc-primary-default) / 1);
            border-color: hsl(var(--twc-primary-default) / var(--twc-primary-default-opacity, var(--tw-border-opacity)));
        }

        .search-field {
            display: flex;
            align-items: center;
            border-radius: 8px;
            border-width: 1px;
            --tw-border-opacity: 1;
            border-color: hsl(var(--twc-utility-1-opacity-3) / 1);
            border-color: hsl(var(--twc-utility-1-opacity-3) / var(--twc-utility-1-opacity-3-opacity, var(--tw-border-opacity)));
            --tw-bg-opacity: 1;
            background-color: hsl(var(--twc-transparent) / 1);
            background-color: hsl(var(--twc-transparent) / var(--twc-transparent-opacity, var(--tw-bg-opacity)));
            padding-top: 8px;
            padding-bottom: 8px;
            padding-left: 16px;
            padding-right: 16px;
        }

        .search-field:focus-within {
            --tw-border-opacity: 1;
            border-color: hsl(var(--twc-primary-default) / 1);
            border-color: hsl(var(--twc-primary-default) / var(--twc-primary-default-opacity, var(--tw-border-opacity)));
        }

        .search-field {
            border-radius: 9999px;
            border-style: none;
            --tw-bg-opacity: 1;
            background-color: hsl(var(--twc-utility-1-opacity-6) / 1);
            background-color: hsl(var(--twc-utility-1-opacity-6) / var(--twc-utility-1-opacity-6-opacity, var(--tw-bg-opacity)));
            padding-left: 8px;
            padding-right: 8px;
            padding-top: 0.375rem;
            padding-bottom: 0.375rem;
        }

        .step-field {
            display: flex;
            align-items: center;
            border-radius: 8px;
            border-width: 1px;
            --tw-border-opacity: 1;
            border-color: hsl(var(--twc-utility-1-opacity-3) / 1);
            border-color: hsl(var(--twc-utility-1-opacity-3) / var(--twc-utility-1-opacity-3-opacity, var(--tw-border-opacity)));
            --tw-bg-opacity: 1;
            background-color: hsl(var(--twc-transparent) / 1);
            background-color: hsl(var(--twc-transparent) / var(--twc-transparent-opacity, var(--tw-bg-opacity)));
            padding-top: 8px;
            padding-bottom: 8px;
            padding-left: 16px;
            padding-right: 16px;
        }

        .step-field:focus-within {
            --tw-border-opacity: 1;
            border-color: hsl(var(--twc-primary-default) / 1);
            border-color: hsl(var(--twc-primary-default) / var(--twc-primary-default-opacity, var(--tw-border-opacity)));
        }

        .step-field-long {
            display: flex;
            align-items: center;
            border-radius: 8px;
            border-width: 1px;
            --tw-border-opacity: 1;
            border-color: hsl(var(--twc-utility-1-opacity-3) / 1);
            border-color: hsl(var(--twc-utility-1-opacity-3) / var(--twc-utility-1-opacity-3-opacity, var(--tw-border-opacity)));
            --tw-bg-opacity: 1;
            background-color: hsl(var(--twc-transparent) / 1);
            background-color: hsl(var(--twc-transparent) / var(--twc-transparent-opacity, var(--tw-bg-opacity)));
            padding-top: 8px;
            padding-bottom: 8px;
            padding-left: 16px;
            padding-right: 16px;
        }

        .step-field-long:focus-within {
            --tw-border-opacity: 1;
            border-color: hsl(var(--twc-primary-default) / 1);
            border-color: hsl(var(--twc-primary-default) / var(--twc-primary-default-opacity, var(--tw-border-opacity)));
        }

        .radio-group__option {
            margin: 2px;
            display: flex;
            width: 1.25rem;
            height: 1.25rem;
            align-items: center;
            justify-content: center;
            border-radius: 9999px;
            border-width: 2.5px;
            --tw-border-opacity: 1;
            border-color: hsl(var(--twc-utility-1-opacity-3) / 1);
            border-color: hsl(var(--twc-utility-1-opacity-3) / var(--twc-utility-1-opacity-3-opacity, var(--tw-border-opacity)));
        }

        .radio-group__option[aria-checked="true"] {
            --tw-border-opacity: 1;
            border-color: hsl(var(--twc-primary) / 1);
            border-color: hsl(var(--twc-primary) / var(--twc-primary-opacity, var(--tw-border-opacity)));
        }

        .radio-group__option[aria-disabled="true"] {
            opacity: 0.4;
        }

        .radio-group__option-indicator {
            width: 10px;
            height: 10px;
            border-radius: 9999px;
            --tw-bg-opacity: 1;
            background-color: hsl(var(--twc-utility-1-opacity-3) / 1);
            background-color: hsl(var(--twc-utility-1-opacity-3) / var(--twc-utility-1-opacity-3-opacity, var(--tw-bg-opacity)));
        }

        .radio-group__option[aria-checked='true'] .radio-group__option-indicator {
            --tw-bg-opacity: 1;
            background-color: hsl(var(--twc-primary) / 1);
            background-color: hsl(var(--twc-primary) / var(--twc-primary-opacity, var(--tw-bg-opacity)));
        }

        .skeleton {
            --start-color: hsl(var(--twc-utility-1-opacity-6) / var(--twc-utility-1-opacity-6-opacity, var(--tw-bg-opacity)));
            --end-color: hsl(var(--twc-utility-1-opacity-3) / var(--twc-utility-1-opacity-3-opacity, var(--tw-bg-opacity)));

            background-image: linear-gradient(270deg,
                    var(--start-color),
                    var(--end-color),
                    var(--end-color),
                    var(--start-color));
            background-size: 400% 100%;
            animation: bg-position 5s ease-in-out infinite;
            box-shadow: none;
            background-clip: padding-box;
            cursor: default;
            pointer-events: none;
            -webkit-user-select: none;
            -moz-user-select: none;
            user-select: none;
            flex-shrink: 0;
            border-radius: 4px;
        }

        @keyframes bg-position {
            from {
                background-position: 200% 0;
            }

            to {
                background-position: -200% 0;
            }
        }

        .switch {
            position: relative;
            display: inline-flex;
            height: 24px;
            width: 40px;
            flex-shrink: 0;
            cursor: pointer;
            border-radius: 9999px;
            border-width: 2px;
            --tw-border-opacity: 1;
            border-color: hsl(var(--twc-transparent) / 1);
            border-color: hsl(var(--twc-transparent) / var(--twc-transparent-opacity, var(--tw-border-opacity)));
            --tw-bg-opacity: 1;
            background-color: hsl(var(--twc-utility-1-opacity-3) / 1);
            background-color: hsl(var(--twc-utility-1-opacity-3) / var(--twc-utility-1-opacity-3-opacity, var(--tw-bg-opacity)));
            transition-property: color, background-color, border-color, text-decoration-color, fill, stroke;
            transition-duration: 200ms;
            transition-timing-function: cubic-bezier(0.4, 0, 0.2, 1);
        }

        .switch:focus {
            outline: 2px solid transparent;
            outline-offset: 2px;
        }

        .switch:focus-visible {
            --tw-ring-offset-shadow: var(--tw-ring-inset) 0 0 0 var(--tw-ring-offset-width) var(--tw-ring-offset-color);
            --tw-ring-shadow: var(--tw-ring-inset) 0 0 0 calc(2px + var(--tw-ring-offset-width)) var(--tw-ring-color);
            box-shadow: var(--tw-ring-offset-shadow), var(--tw-ring-shadow), 0 0 rgba(0, 0, 0, 0);
            box-shadow: var(--tw-ring-offset-shadow), var(--tw-ring-shadow), var(--tw-shadow, 0 0 rgba(0, 0, 0, 0));
            --tw-ring-color: rgba(255, 255, 255, var(--tw-ring-opacity));
            --tw-ring-opacity: 0.75;
        }

        .switch[aria-checked='true'] {
            --tw-bg-opacity: 1;
            background-color: hsl(var(--twc-primary) / 1);
            background-color: hsl(var(--twc-primary) / var(--twc-primary-opacity, var(--tw-bg-opacity)));
        }

        .switch[aria-checked='true'] .switch__toggle {
            --tw-translate-x: 16px;
            transform: translate(16px, var(--tw-translate-y)) rotate(var(--tw-rotate)) skewX(var(--tw-skew-x)) skewY(var(--tw-skew-y)) scaleX(var(--tw-scale-x)) scaleY(var(--tw-scale-y));
            transform: translate(var(--tw-translate-x), var(--tw-translate-y)) rotate(var(--tw-rotate)) skewX(var(--tw-skew-x)) skewY(var(--tw-skew-y)) scaleX(var(--tw-scale-x)) scaleY(var(--tw-scale-y));
        }

        .switch:disabled {
            opacity: 0.4;
        }

        .switch__toggle {
            pointer-events: none;
            display: inline-block;
            height: 1.25rem;
            width: 1.25rem;
            transform: translate(var(--tw-translate-x), var(--tw-translate-y)) rotate(var(--tw-rotate)) skewX(var(--tw-skew-x)) skewY(var(--tw-skew-y)) scaleX(var(--tw-scale-x)) scaleY(var(--tw-scale-y));
            border-radius: 9999px;
            --tw-bg-opacity: 1;
            background-color: rgba(255, 255, 255, 1);
            background-color: rgba(255, 255, 255, var(--tw-bg-opacity));
            --tw-shadow: 0 4px 6px -1px rgba(0, 0, 0, 0.1), 0 2px 4px -2px rgba(0, 0, 0, 0.1);
            --tw-shadow-colored: 0 4px 6px -1px var(--tw-shadow-color), 0 2px 4px -2px var(--tw-shadow-color);
            box-shadow: 0 0 rgba(0, 0, 0, 0), 0 0 rgba(0, 0, 0, 0), 0 4px 6px -1px rgba(0, 0, 0, 0.1), 0 2px 4px -2px rgba(0, 0, 0, 0.1);
            box-shadow: var(--tw-ring-offset-shadow, 0 0 rgba(0, 0, 0, 0)), var(--tw-ring-shadow, 0 0 rgba(0, 0, 0, 0)), var(--tw-shadow);
            --tw-ring-offset-shadow: var(--tw-ring-inset) 0 0 0 var(--tw-ring-offset-width) var(--tw-ring-offset-color);
            --tw-ring-shadow: var(--tw-ring-inset) 0 0 0 calc(0px + var(--tw-ring-offset-width)) var(--tw-ring-color);
            box-shadow: var(--tw-ring-offset-shadow), var(--tw-ring-shadow), var(--tw-shadow, 0 0 #0000);
            transition-property: color, background-color, border-color, text-decoration-color, fill, stroke, opacity, box-shadow, transform, filter, -webkit-backdrop-filter;
            transition-property: color, background-color, border-color, text-decoration-color, fill, stroke, opacity, box-shadow, transform, filter, backdrop-filter;
            transition-property: color, background-color, border-color, text-decoration-color, fill, stroke, opacity, box-shadow, transform, filter, backdrop-filter, -webkit-backdrop-filter;
            transition-duration: 200ms;
            transition-timing-function: cubic-bezier(0.4, 0, 0.2, 1);
        }

        @supports (color: rgb(0 0 0 / 0)) {
            .switch__toggle {
                box-shadow: var(--tw-ring-offset-shadow), var(--tw-ring-shadow), 0 4px 6px -1px rgb(0 0 0 / 0.1), 0 2px 4px -2px rgb(0 0 0 / 0.1);
            }
        }

        .tw-scrollbar {
            overflow: hidden;
            overflow-y: auto;
            padding-right: 8px;
        }

        .tw-scrollbar::-webkit-scrollbar-track {
            background-color: var(--scrollbar-track);
            border-radius: var(--scrollbar-track-radius);
        }

        .tw-scrollbar::-webkit-scrollbar-track:hover {
            background-color: var(--scrollbar-track-hover, var(--scrollbar-track));
        }

        .tw-scrollbar::-webkit-scrollbar-track:active {
            background-color: var(--scrollbar-track-active, var(--scrollbar-track-hover, var(--scrollbar-track)));
        }

        .tw-scrollbar::-webkit-scrollbar-thumb {
            background-color: var(--scrollbar-thumb);
            border-radius: var(--scrollbar-thumb-radius);
        }

        .tw-scrollbar::-webkit-scrollbar-thumb:hover {
            background-color: var(--scrollbar-thumb-hover, var(--scrollbar-thumb));
        }

        .tw-scrollbar::-webkit-scrollbar-thumb:active {
            background-color: var(--scrollbar-thumb-active, var(--scrollbar-thumb-hover, var(--scrollbar-thumb)));
        }

        .tw-scrollbar::-webkit-scrollbar-corner {
            background-color: var(--scrollbar-corner);
            border-radius: var(--scrollbar-corner-radius);
        }

        .tw-scrollbar::-webkit-scrollbar-corner:hover {
            background-color: var(--scrollbar-corner-hover, var(--scrollbar-corner));
        }

        .tw-scrollbar::-webkit-scrollbar-corner:active {
            background-color: var(--scrollbar-corner-active, var(--scrollbar-corner-hover, var(--scrollbar-corner)));
        }

        .tw-scrollbar {
            scrollbar-width: thin;
            scrollbar-color: initial initial;
            scrollbar-color: var(--scrollbar-thumb, initial) var(--scrollbar-track, initial);
        }

        .tw-scrollbar::-webkit-scrollbar {
            display: block;
            width: 8px;
            height: 8px;
        }

        .tw-scrollbar {
            --scrollbar-track: hsl(var(--twc-transparent) / var(--twc-transparent-opacity, 1));
            --scrollbar-thumb: hsl(var(--twc-iconNormal) / var(--twc-iconNormal-opacity, 1));
            --scrollbar-thumb-radius: 8px;
        }

        .tw-tooltip {
            line-height: 18px;
            z-index: 50 !important;
            max-width: 20rem !important;
            border-radius: 4px !important;
            --tw-bg-opacity: 1 !important;
            background-color: hsl(var(--twc-tooltip) / 1) !important;
            background-color: hsl(var(--twc-tooltip) / var(--twc-tooltip-opacity, var(--tw-bg-opacity))) !important;
            padding-left: 12px !important;
            padding-right: 12px !important;
            padding-top: 8px !important;
            padding-bottom: 8px !important;
            --tw-text-opacity: 1 !important;
            color: hsl(var(--twc-utility-1-default) / 1) !important;
            color: hsl(var(--twc-utility-1-default) / var(--twc-utility-1-default-opacity, var(--tw-text-opacity))) !important;
            opacity: 1 !important;
            --tw-shadow: 0 4px 6px -1px rgba(0, 0, 0, 0.1), 0 2px 4px -2px rgba(0, 0, 0, 0.1) !important;
            --tw-shadow-colored: 0 4px 6px -1px var(--tw-shadow-color), 0 2px 4px -2px var(--tw-shadow-color) !important;
            box-shadow: 0 0 rgba(0, 0, 0, 0), 0 0 rgba(0, 0, 0, 0), 0 4px 6px -1px rgba(0, 0, 0, 0.1), 0 2px 4px -2px rgba(0, 0, 0, 0.1) !important;
            box-shadow: var(--tw-ring-offset-shadow, 0 0 rgba(0, 0, 0, 0)), var(--tw-ring-shadow, 0 0 rgba(0, 0, 0, 0)), var(--tw-shadow) !important;
            --tw-backdrop-blur: blur(40px) !important;
            -webkit-backdrop-filter: blur(40px) var(--tw-backdrop-brightness) var(--tw-backdrop-contrast) var(--tw-backdrop-grayscale) var(--tw-backdrop-hue-rotate) var(--tw-backdrop-invert) var(--tw-backdrop-opacity) var(--tw-backdrop-saturate) var(--tw-backdrop-sepia) !important;
            backdrop-filter: blur(40px) var(--tw-backdrop-brightness) var(--tw-backdrop-contrast) var(--tw-backdrop-grayscale) var(--tw-backdrop-hue-rotate) var(--tw-backdrop-invert) var(--tw-backdrop-opacity) var(--tw-backdrop-saturate) var(--tw-backdrop-sepia) !important;
            -webkit-backdrop-filter: var(--tw-backdrop-blur) var(--tw-backdrop-brightness) var(--tw-backdrop-contrast) var(--tw-backdrop-grayscale) var(--tw-backdrop-hue-rotate) var(--tw-backdrop-invert) var(--tw-backdrop-opacity) var(--tw-backdrop-saturate) var(--tw-backdrop-sepia) !important;
            backdrop-filter: var(--tw-backdrop-blur) var(--tw-backdrop-brightness) var(--tw-backdrop-contrast) var(--tw-backdrop-grayscale) var(--tw-backdrop-hue-rotate) var(--tw-backdrop-invert) var(--tw-backdrop-opacity) var(--tw-backdrop-saturate) var(--tw-backdrop-sepia) !important;
            font-size: 14px !important;
        }

        .tw-tooltip .react-tooltip-arrow {
            display: none;
        }

        .tw-overlay {
            position: fixed;
            top: 0px;
            right: 0px;
            bottom: 0px;
            left: 0px;
            --tw-bg-opacity: 1;
            background-color: hsl(var(--twc-overlay-50) / 1);
            background-color: hsl(var(--twc-overlay-50) / var(--twc-overlay-50-opacity, var(--tw-bg-opacity)));
            --tw-backdrop-blur: blur(2px);
            -webkit-backdrop-filter: blur(2px) var(--tw-backdrop-brightness) var(--tw-backdrop-contrast) var(--tw-backdrop-grayscale) var(--tw-backdrop-hue-rotate) var(--tw-backdrop-invert) var(--tw-backdrop-opacity) var(--tw-backdrop-saturate) var(--tw-backdrop-sepia);
            backdrop-filter: blur(2px) var(--tw-backdrop-brightness) var(--tw-backdrop-contrast) var(--tw-backdrop-grayscale) var(--tw-backdrop-hue-rotate) var(--tw-backdrop-invert) var(--tw-backdrop-opacity) var(--tw-backdrop-saturate) var(--tw-backdrop-sepia);
            -webkit-backdrop-filter: var(--tw-backdrop-blur) var(--tw-backdrop-brightness) var(--tw-backdrop-contrast) var(--tw-backdrop-grayscale) var(--tw-backdrop-hue-rotate) var(--tw-backdrop-invert) var(--tw-backdrop-opacity) var(--tw-backdrop-saturate) var(--tw-backdrop-sepia);
            backdrop-filter: var(--tw-backdrop-blur) var(--tw-backdrop-brightness) var(--tw-backdrop-contrast) var(--tw-backdrop-grayscale) var(--tw-backdrop-hue-rotate) var(--tw-backdrop-invert) var(--tw-backdrop-opacity) var(--tw-backdrop-saturate) var(--tw-backdrop-sepia);
        }

        .sr-only {
            position: absolute;
            width: 1px;
            height: 1px;
            padding: 0;
            margin: -1px;
            overflow: hidden;
            clip: rect(0, 0, 0, 0);
            white-space: nowrap;
            border-width: 0;
        }

        .pointer-events-none {
            pointer-events: none;
        }

        .visible {
            visibility: visible;
        }

        .static {
            position: static;
        }

        .fixed {
            position: fixed;
        }

        .absolute {
            position: absolute;
        }

        .relative {
            position: relative;
        }

        .sticky {
            position: sticky;
        }

        .inset-0 {
            top: 0px;
            right: 0px;
            bottom: 0px;
            left: 0px;
        }

        .inset-y-0 {
            top: 0px;
            bottom: 0px;
        }

        .-bottom-0 {
            bottom: -0px;
        }

        .-bottom-0\.5 {
            bottom: -2px;
        }

        .-bottom-1 {
            bottom: -4px;
        }

        .-bottom-px {
            bottom: -1px;
        }

        .-right-0 {
            right: -0px;
        }

        .-right-0\.5 {
            right: -2px;
        }

        .-right-1 {
            right: -4px;
        }

        .bottom-0 {
            bottom: 0px;
        }

        .bottom-4 {
            bottom: 16px;
        }

        .left-0 {
            left: 0px;
        }

        .left-1\/2 {
            left: 50%;
        }

        .left-4 {
            left: 16px;
        }

        .left-\[356px\] {
            left: 356px;
        }

        .left-\[50\%\] {
            left: 50%;
        }

        .right-0 {
            right: 0px;
        }

        .right-1 {
            right: 4px;
        }

        .right-1\.25 {
            right: 5px;
        }

        .right-2 {
            right: 8px;
        }

        .right-2\.5 {
            right: 0.625rem;
        }

        .right-4 {
            right: 16px;
        }

        .right-5 {
            right: 1.25rem;
        }

        .right-\[125px\] {
            right: 125px;
        }

        .top-0 {
            top: 0px;
        }

        .top-1 {
            top: 4px;
        }

        .top-1\.25 {
            top: 5px;
        }

        .top-1\/2 {
            top: 50%;
        }

        .top-7 {
            top: 1.75rem;
        }

        .top-\[110px\] {
            top: 110px;
        }

        .top-\[20px\] {
            top: 20px;
        }

        .top-\[5px\] {
            top: 5px;
        }

        .-z-10 {
            z-index: -10;
        }

        .z-0 {
            z-index: 0;
        }

        .z-10 {
            z-index: 10;
        }

        .z-20 {
            z-index: 20;
        }

        .z-30 {
            z-index: 30;
        }

        .z-50 {
            z-index: 50;
        }

        .order-1 {
            order: 1;
        }

        .order-2 {
            order: 2;
        }

        .col-span-3 {
            grid-column: span 3 / span 3;
        }

        .float-right {
            float: right;
        }

        .m-4 {
            margin: 16px;
        }

        .m-auto {
            margin: auto;
        }

        .-mx-0 {
            margin-left: -0px;
            margin-right: -0px;
        }

        .-mx-0\.5 {
            margin-left: -2px;
            margin-right: -2px;
        }

        .-mx-2 {
            margin-left: -8px;
            margin-right: -8px;
        }

        .-mx-4 {
            margin-left: -16px;
            margin-right: -16px;
        }

        .-my-3 {
            margin-top: -12px;
            margin-bottom: -12px;
        }

        .mx-0 {
            margin-left: 0px;
            margin-right: 0px;
        }

        .mx-0\.5 {
            margin-left: 2px;
            margin-right: 2px;
        }

        .mx-1 {
            margin-left: 4px;
            margin-right: 4px;
        }

        .mx-2 {
            margin-left: 8px;
            margin-right: 8px;
        }

        .mx-4 {
            margin-left: 16px;
            margin-right: 16px;
        }

        .mx-\[-16px\] {
            margin-left: -16px;
            margin-right: -16px;
        }

        .mx-auto {
            margin-left: auto;
            margin-right: auto;
        }

        .my-0 {
            margin-top: 0px;
            margin-bottom: 0px;
        }

        .my-0\.5 {
            margin-top: 2px;
            margin-bottom: 2px;
        }

        .my-1 {
            margin-top: 4px;
            margin-bottom: 4px;
        }

        .my-10 {
            margin-top: 40px;
            margin-bottom: 40px;
        }

        .my-11 {
            margin-top: 2.75rem;
            margin-bottom: 2.75rem;
        }

        .my-14 {
            margin-top: 56px;
            margin-bottom: 56px;
        }

        .my-2 {
            margin-top: 8px;
            margin-bottom: 8px;
        }

        .my-2\.5 {
            margin-top: 0.625rem;
            margin-bottom: 0.625rem;
        }

        .my-3 {
            margin-top: 12px;
            margin-bottom: 12px;
        }

        .my-4 {
            margin-top: 16px;
            margin-bottom: 16px;
        }

        .my-5 {
            margin-top: 1.25rem;
            margin-bottom: 1.25rem;
        }

        .my-6 {
            margin-top: 24px;
            margin-bottom: 24px;
        }

        .\!ml-4 {
            margin-left: 16px !important;
        }

        .\!ml-auto {
            margin-left: auto !important;
        }

        .-mb-2 {
            margin-bottom: -8px;
        }

        .-mb-4 {
            margin-bottom: -16px;
        }

        .-ml-2 {
            margin-left: -8px;
        }

        .-mt-3 {
            margin-top: -12px;
        }

        .-mt-4 {
            margin-top: -16px;
        }

        .-mt-6 {
            margin-top: -24px;
        }

        .-mt-\[10px\] {
            margin-top: -10px;
        }

        .mb-0 {
            margin-bottom: 0px;
        }

        .mb-0\.5 {
            margin-bottom: 2px;
        }

        .mb-1 {
            margin-bottom: 4px;
        }

        .mb-10 {
            margin-bottom: 40px;
        }

        .mb-16 {
            margin-bottom: 64px;
        }

        .mb-2 {
            margin-bottom: 8px;
        }

        .mb-3 {
            margin-bottom: 12px;
        }

        .mb-4 {
            margin-bottom: 16px;
        }

        .mb-5 {
            margin-bottom: 1.25rem;
        }

        .mb-6 {
            margin-bottom: 24px;
        }

        .mb-7 {
            margin-bottom: 1.75rem;
        }

        .ml-0 {
            margin-left: 0px;
        }

        .ml-0\.5 {
            margin-left: 2px;
        }

        .ml-1 {
            margin-left: 4px;
        }

        .ml-1\.25 {
            margin-left: 5px;
        }

        .ml-2 {
            margin-left: 8px;
        }

        .ml-2\.5 {
            margin-left: 0.625rem;
        }

        .ml-4 {
            margin-left: 16px;
        }

        .ml-6 {
            margin-left: 24px;
        }

        .ml-\[12px\] {
            margin-left: 12px;
        }

        .ml-\[258px\] {
            margin-left: 258px;
        }

        .ml-auto {
            margin-left: auto;
        }

        .mr-1 {
            margin-right: 4px;
        }

        .mr-2 {
            margin-right: 8px;
        }

        .mr-2\.5 {
            margin-right: 0.625rem;
        }

        .mr-3 {
            margin-right: 12px;
        }

        .mr-4 {
            margin-right: 16px;
        }

        .mr-px {
            margin-right: 1px;
        }

        .mt-0 {
            margin-top: 0px;
        }

        .mt-0\.5 {
            margin-top: 2px;
        }

        .mt-1 {
            margin-top: 4px;
        }

        .mt-1\.5 {
            margin-top: 0.375rem;
        }

        .mt-12 {
            margin-top: 48px;
        }

        .mt-16 {
            margin-top: 64px;
        }

        .mt-2 {
            margin-top: 8px;
        }

        .mt-20 {
            margin-top: 5rem;
        }

        .mt-24 {
            margin-top: 6rem;
        }

        .mt-3 {
            margin-top: 12px;
        }

        .mt-4 {
            margin-top: 16px;
        }

        .mt-5 {
            margin-top: 1.25rem;
        }

        .mt-6 {
            margin-top: 24px;
        }

        .mt-8 {
            margin-top: 32px;
        }

        .mt-\[-20px\] {
            margin-top: -20px;
        }

        .mt-\[-5px\] {
            margin-top: -5px;
        }

        .mt-\[120px\] {
            margin-top: 120px;
        }

        .mt-\[130px\] {
            margin-top: 130px;
        }

        .mt-\[150px\] {
            margin-top: 150px;
        }

        .mt-\[2px\] {
            margin-top: 2px;
        }

        .mt-auto {
            margin-top: auto;
        }

        .box-border {
            box-sizing: border-box;
        }

        .\!block {
            display: block !important;
        }

        .block {
            display: block;
        }

        .inline-block {
            display: inline-block;
        }

        .inline {
            display: inline;
        }

        .flex {
            display: flex;
        }

        .inline-flex {
            display: inline-flex;
        }

        .\!table {
            display: table !important;
        }

        .table {
            display: table;
        }

        .grid {
            display: grid;
        }

        .hidden {
            display: none;
        }

        .aspect-\[2\/1\.48\] {
            aspect-ratio: 2/1.48;
        }

        .aspect-\[2\/1\] {
            aspect-ratio: 2/1;
        }

        .h-0 {
            height: 0px;
        }

        .h-0\.75 {
            height: 3px;
        }

        .h-1 {
            height: 4px;
        }

        .h-10 {
            height: 40px;
        }

        .h-12 {
            height: 48px;
        }

        .h-14 {
            height: 56px;
        }

        .h-15 {
            height: 60px;
        }

        .h-16 {
            height: 64px;
        }

        .h-2 {
            height: 8px;
        }

        .h-2\.5 {
            height: 10px;
        }

        .h-28 {
            height: 7rem;
        }

        .h-3 {
            height: 12px;
        }

        .h-4 {
            height: 16px;
        }

        .h-5 {
            height: 1.25rem;
        }

        .h-6 {
            height: 24px;
        }

        .h-7 {
            height: 1.75rem;
        }

        .h-7\.5 {
            height: 30px;
        }

        .h-8 {
            height: 32px;
        }

        .h-9 {
            height: 36px;
        }

        .h-\[100vh\] {
            height: 100vh;
        }

        .h-\[104px\] {
            height: 104px;
        }

        .h-\[170px\] {
            height: 170px;
        }

        .h-\[18px\] {
            height: 18px;
        }

        .h-\[1px\] {
            height: 1px;
        }

        .h-\[200px\] {
            height: 200px;
        }

        .h-\[20px\] {
            height: 20px;
        }

        .h-\[232px\] {
            height: 232px;
        }

        .h-\[252px\] {
            height: 252px;
        }

        .h-\[2px\] {
            height: 2px;
        }

        .h-\[30px\] {
            height: 30px;
        }

        .h-\[330px\] {
            height: 330px;
        }

        .h-\[360px\] {
            height: 360px;
        }

        .h-\[36px\] {
            height: 36px;
        }

        .h-\[60vh\] {
            height: 60vh;
        }

        .h-\[6rem\] {
            height: 6rem;
        }

        .h-\[70px\] {
            height: 70px;
        }

        .h-\[72px\] {
            height: 72px;
        }

        .h-\[800px\] {
            height: 800px;
        }

        .h-\[calc\(100vh-1rem\)\] {
            height: calc(100vh - 1rem);
        }

        .h-fit {
            height: -moz-fit-content;
            height: fit-content;
        }

        .h-full {
            height: 100%;
        }

        .h-screen {
            height: 100vh;
        }

        .max-h-0 {
            max-height: 0px;
        }

        .max-h-60 {
            max-height: 15rem;
        }

        .max-h-96 {
            max-height: 24rem;
        }

        .max-h-\[235px\] {
            max-height: 235px;
        }

        .max-h-\[250px\] {
            max-height: 250px;
        }

        .max-h-\[400px\] {
            max-height: 400px;
        }

        .max-h-\[50vh\] {
            max-height: 50vh;
        }

        .min-h-15 {
            min-height: 60px;
        }

        .min-h-17 {
            min-height: 68px;
        }

        .min-h-5 {
            min-height: 1.25rem;
        }

        .min-h-6 {
            min-height: 24px;
        }

        .min-h-\[400px\] {
            min-height: 400px;
        }

        .min-h-\[52px\] {
            min-height: 52px;
        }

        .min-h-\[54px\] {
            min-height: 54px;
        }

        .min-h-full {
            min-height: 100%;
        }

        .min-h-screen {
            min-height: 100vh;
        }

        .w-1 {
            width: 4px;
        }

        .w-1\/2 {
            width: 50%;
        }

        .w-1\/3 {
            width: 33.333333%;
        }

        .w-10 {
            width: 40px;
        }

        .w-10\/12 {
            width: 83.333333%;
        }

        .w-12 {
            width: 48px;
        }

        .w-16 {
            width: 64px;
        }

        .w-17 {
            width: 68px;
        }

        .w-2 {
            width: 8px;
        }

        .w-2\.5 {
            width: 10px;
        }

        .w-2\/3 {
            width: 66.666667%;
        }

        .w-20 {
            width: 5rem;
        }

        .w-22\.5 {
            width: 90px;
        }

        .w-24 {
            width: 6rem;
        }

        .w-28 {
            width: 7rem;
        }

        .w-3 {
            width: 12px;
        }

        .w-4 {
            width: 16px;
        }

        .w-40 {
            width: 10rem;
        }

        .w-48 {
            width: 12rem;
        }

        .w-5 {
            width: 1.25rem;
        }

        .w-52 {
            width: 13rem;
        }

        .w-6 {
            width: 24px;
        }

        .w-7 {
            width: 1.75rem;
        }

        .w-7\.5 {
            width: 30px;
        }

        .w-8 {
            width: 32px;
        }

        .w-9 {
            width: 36px;
        }

        .w-\[102px\] {
            width: 102px;
        }

        .w-\[136px\] {
            width: 136px;
        }

        .w-\[140px\] {
            width: 140px;
        }

        .w-\[200px\] {
            width: 200px;
        }

        .w-\[20px\] {
            width: 20px;
        }

        .w-\[224px\] {
            width: 224px;
        }

        .w-\[300px\] {
            width: 300px;
        }

        .w-\[305px\] {
            width: 305px;
        }

        .w-\[320px\] {
            width: 320px;
        }

        .w-\[350px\] {
            width: 350px;
        }

        .w-\[36px\] {
            width: 36px;
        }

        .w-\[389px\] {
            width: 389px;
        }

        .w-\[413px\] {
            width: 413px;
        }

        .w-\[42px\] {
            width: 42px;
        }

        .w-\[438px\] {
            width: 438px;
        }

        .w-\[472px\] {
            width: 472px;
        }

        .w-\[504px\] {
            width: 504px;
        }

        .w-\[600px\] {
            width: 600px;
        }

        .w-\[6rem\] {
            width: 6rem;
        }

        .w-\[77px\] {
            width: 77px;
        }

        .w-\[86px\] {
            width: 86px;
        }

        .w-\[90px\] {
            width: 90px;
        }

        .w-\[calc\(100\%-32px\)\] {
            width: calc(100% - 32px);
        }

        .w-auto {
            width: auto;
        }

        .w-fit {
            width: -moz-fit-content;
            width: fit-content;
        }

        .w-full {
            width: 100%;
        }

        .w-min {
            width: -moz-min-content;
            width: min-content;
        }

        .min-w-\[253px\] {
            min-width: 253px;
        }

        .min-w-\[400px\] {
            min-width: 400px;
        }

        .min-w-\[466px\] {
            min-width: 466px;
        }

        .min-w-\[480px\] {
            min-width: 480px;
        }

        .min-w-\[716px\] {
            min-width: 716px;
        }

        .min-w-\[80px\] {
            min-width: 80px;
        }

        .min-w-\[850px\] {
            min-width: 850px;
        }

        .min-w-full {
            min-width: 100%;
        }

        .min-w-max {
            min-width: -moz-max-content;
            min-width: max-content;
        }

        .min-w-min {
            min-width: -moz-min-content;
            min-width: min-content;
        }

        .max-w-\[120px\] {
            max-width: 120px;
        }

        .max-w-\[375px\] {
            max-width: 375px;
        }

        .max-w-\[400px\] {
            max-width: 400px;
        }

        .max-w-\[716px\] {
            max-width: 716px;
        }

        .max-w-md {
            max-width: 28rem;
        }

        .max-w-xs {
            max-width: 20rem;
        }

        .flex-1 {
            flex: 1 1 0%;
        }

        .flex-shrink-0 {
            flex-shrink: 0;
        }

        .shrink {
            flex-shrink: 1;
        }

        .shrink-0 {
            flex-shrink: 0;
        }

        .flex-grow {
            flex-grow: 1;
        }

        .flex-grow-0 {
            flex-grow: 0;
        }

        .grow {
            flex-grow: 1;
        }

        .origin-\[50\%_50\%\] {
            transform-origin: 50% 50%;
        }

        .-translate-x-1\/2 {
            --tw-translate-x: -50%;
            transform: translate(-50%, var(--tw-translate-y)) rotate(var(--tw-rotate)) skewX(var(--tw-skew-x)) skewY(var(--tw-skew-y)) scaleX(var(--tw-scale-x)) scaleY(var(--tw-scale-y));
            transform: translate(var(--tw-translate-x), var(--tw-translate-y)) rotate(var(--tw-rotate)) skewX(var(--tw-skew-x)) skewY(var(--tw-skew-y)) scaleX(var(--tw-scale-x)) scaleY(var(--tw-scale-y));
        }

        .-translate-y-1 {
            --tw-translate-y: -4px;
            transform: translate(var(--tw-translate-x), -4px) rotate(var(--tw-rotate)) skewX(var(--tw-skew-x)) skewY(var(--tw-skew-y)) scaleX(var(--tw-scale-x)) scaleY(var(--tw-scale-y));
            transform: translate(var(--tw-translate-x), var(--tw-translate-y)) rotate(var(--tw-rotate)) skewX(var(--tw-skew-x)) skewY(var(--tw-skew-y)) scaleX(var(--tw-scale-x)) scaleY(var(--tw-scale-y));
        }

        .-translate-y-1\/2 {
            --tw-translate-y: -50%;
            transform: translate(var(--tw-translate-x), -50%) rotate(var(--tw-rotate)) skewX(var(--tw-skew-x)) skewY(var(--tw-skew-y)) scaleX(var(--tw-scale-x)) scaleY(var(--tw-scale-y));
            transform: translate(var(--tw-translate-x), var(--tw-translate-y)) rotate(var(--tw-rotate)) skewX(var(--tw-skew-x)) skewY(var(--tw-skew-y)) scaleX(var(--tw-scale-x)) scaleY(var(--tw-scale-y));
        }

        .translate-x-0 {
            --tw-translate-x: 0px;
            transform: translate(0px, var(--tw-translate-y)) rotate(var(--tw-rotate)) skewX(var(--tw-skew-x)) skewY(var(--tw-skew-y)) scaleX(var(--tw-scale-x)) scaleY(var(--tw-scale-y));
            transform: translate(var(--tw-translate-x), var(--tw-translate-y)) rotate(var(--tw-rotate)) skewX(var(--tw-skew-x)) skewY(var(--tw-skew-y)) scaleX(var(--tw-scale-x)) scaleY(var(--tw-scale-y));
        }

        .translate-x-5 {
            --tw-translate-x: 1.25rem;
            transform: translate(1.25rem, var(--tw-translate-y)) rotate(var(--tw-rotate)) skewX(var(--tw-skew-x)) skewY(var(--tw-skew-y)) scaleX(var(--tw-scale-x)) scaleY(var(--tw-scale-y));
            transform: translate(var(--tw-translate-x), var(--tw-translate-y)) rotate(var(--tw-rotate)) skewX(var(--tw-skew-x)) skewY(var(--tw-skew-y)) scaleX(var(--tw-scale-x)) scaleY(var(--tw-scale-y));
        }

        .translate-x-full {
            --tw-translate-x: 100%;
            transform: translate(100%, var(--tw-translate-y)) rotate(var(--tw-rotate)) skewX(var(--tw-skew-x)) skewY(var(--tw-skew-y)) scaleX(var(--tw-scale-x)) scaleY(var(--tw-scale-y));
            transform: translate(var(--tw-translate-x), var(--tw-translate-y)) rotate(var(--tw-rotate)) skewX(var(--tw-skew-x)) skewY(var(--tw-skew-y)) scaleX(var(--tw-scale-x)) scaleY(var(--tw-scale-y));
        }

        .translate-y-0 {
            --tw-translate-y: 0px;
            transform: translate(var(--tw-translate-x), 0px) rotate(var(--tw-rotate)) skewX(var(--tw-skew-x)) skewY(var(--tw-skew-y)) scaleX(var(--tw-scale-x)) scaleY(var(--tw-scale-y));
            transform: translate(var(--tw-translate-x), var(--tw-translate-y)) rotate(var(--tw-rotate)) skewX(var(--tw-skew-x)) skewY(var(--tw-skew-y)) scaleX(var(--tw-scale-x)) scaleY(var(--tw-scale-y));
        }

        .translate-y-1 {
            --tw-translate-y: 4px;
            transform: translate(var(--tw-translate-x), 4px) rotate(var(--tw-rotate)) skewX(var(--tw-skew-x)) skewY(var(--tw-skew-y)) scaleX(var(--tw-scale-x)) scaleY(var(--tw-scale-y));
            transform: translate(var(--tw-translate-x), var(--tw-translate-y)) rotate(var(--tw-rotate)) skewX(var(--tw-skew-x)) skewY(var(--tw-skew-y)) scaleX(var(--tw-scale-x)) scaleY(var(--tw-scale-y));
        }

        .translate-y-1\/2 {
            --tw-translate-y: 50%;
            transform: translate(var(--tw-translate-x), 50%) rotate(var(--tw-rotate)) skewX(var(--tw-skew-x)) skewY(var(--tw-skew-y)) scaleX(var(--tw-scale-x)) scaleY(var(--tw-scale-y));
            transform: translate(var(--tw-translate-x), var(--tw-translate-y)) rotate(var(--tw-rotate)) skewX(var(--tw-skew-x)) skewY(var(--tw-skew-y)) scaleX(var(--tw-scale-x)) scaleY(var(--tw-scale-y));
        }

        .translate-y-\[200px\] {
            --tw-translate-y: 200px;
            transform: translate(var(--tw-translate-x), 200px) rotate(var(--tw-rotate)) skewX(var(--tw-skew-x)) skewY(var(--tw-skew-y)) scaleX(var(--tw-scale-x)) scaleY(var(--tw-scale-y));
            transform: translate(var(--tw-translate-x), var(--tw-translate-y)) rotate(var(--tw-rotate)) skewX(var(--tw-skew-x)) skewY(var(--tw-skew-y)) scaleX(var(--tw-scale-x)) scaleY(var(--tw-scale-y));
        }

        .translate-y-\[calc\(-50\%\+6px\)\] {
            --tw-translate-y: calc(-50% + 6px);
            transform: translate(var(--tw-translate-x), calc(-50% + 6px)) rotate(var(--tw-rotate)) skewX(var(--tw-skew-x)) skewY(var(--tw-skew-y)) scaleX(var(--tw-scale-x)) scaleY(var(--tw-scale-y));
            transform: translate(var(--tw-translate-x), var(--tw-translate-y)) rotate(var(--tw-rotate)) skewX(var(--tw-skew-x)) skewY(var(--tw-skew-y)) scaleX(var(--tw-scale-x)) scaleY(var(--tw-scale-y));
        }

        .-rotate-90 {
            --tw-rotate: -90deg;
            transform: translate(var(--tw-translate-x), var(--tw-translate-y)) rotate(-90deg) skewX(var(--tw-skew-x)) skewY(var(--tw-skew-y)) scaleX(var(--tw-scale-x)) scaleY(var(--tw-scale-y));
            transform: translate(var(--tw-translate-x), var(--tw-translate-y)) rotate(var(--tw-rotate)) skewX(var(--tw-skew-x)) skewY(var(--tw-skew-y)) scaleX(var(--tw-scale-x)) scaleY(var(--tw-scale-y));
        }

        .rotate-0 {
            --tw-rotate: 0deg;
            transform: translate(var(--tw-translate-x), var(--tw-translate-y)) rotate(0deg) skewX(var(--tw-skew-x)) skewY(var(--tw-skew-y)) scaleX(var(--tw-scale-x)) scaleY(var(--tw-scale-y));
            transform: translate(var(--tw-translate-x), var(--tw-translate-y)) rotate(var(--tw-rotate)) skewX(var(--tw-skew-x)) skewY(var(--tw-skew-y)) scaleX(var(--tw-scale-x)) scaleY(var(--tw-scale-y));
        }

        .rotate-180 {
            --tw-rotate: 180deg;
            transform: translate(var(--tw-translate-x), var(--tw-translate-y)) rotate(180deg) skewX(var(--tw-skew-x)) skewY(var(--tw-skew-y)) scaleX(var(--tw-scale-x)) scaleY(var(--tw-scale-y));
            transform: translate(var(--tw-translate-x), var(--tw-translate-y)) rotate(var(--tw-rotate)) skewX(var(--tw-skew-x)) skewY(var(--tw-skew-y)) scaleX(var(--tw-scale-x)) scaleY(var(--tw-scale-y));
        }

        .-scale-100 {
            --tw-scale-x: -1;
            --tw-scale-y: -1;
            transform: translate(var(--tw-translate-x), var(--tw-translate-y)) rotate(var(--tw-rotate)) skewX(var(--tw-skew-x)) skewY(var(--tw-skew-y)) scaleX(-1) scaleY(-1);
            transform: translate(var(--tw-translate-x), var(--tw-translate-y)) rotate(var(--tw-rotate)) skewX(var(--tw-skew-x)) skewY(var(--tw-skew-y)) scaleX(var(--tw-scale-x)) scaleY(var(--tw-scale-y));
        }

        .scale-100 {
            --tw-scale-x: 1;
            --tw-scale-y: 1;
            transform: translate(var(--tw-translate-x), var(--tw-translate-y)) rotate(var(--tw-rotate)) skewX(var(--tw-skew-x)) skewY(var(--tw-skew-y)) scaleX(1) scaleY(1);
            transform: translate(var(--tw-translate-x), var(--tw-translate-y)) rotate(var(--tw-rotate)) skewX(var(--tw-skew-x)) skewY(var(--tw-skew-y)) scaleX(var(--tw-scale-x)) scaleY(var(--tw-scale-y));
        }

        .scale-95 {
            --tw-scale-x: .95;
            --tw-scale-y: .95;
            transform: translate(var(--tw-translate-x), var(--tw-translate-y)) rotate(var(--tw-rotate)) skewX(var(--tw-skew-x)) skewY(var(--tw-skew-y)) scaleX(.95) scaleY(.95);
            transform: translate(var(--tw-translate-x), var(--tw-translate-y)) rotate(var(--tw-rotate)) skewX(var(--tw-skew-x)) skewY(var(--tw-skew-y)) scaleX(var(--tw-scale-x)) scaleY(var(--tw-scale-y));
        }

        .scale-\[calc\(20\/24\)\] {
            --tw-scale-x: calc(20 / 24);
            --tw-scale-y: calc(20 / 24);
            transform: translate(var(--tw-translate-x), var(--tw-translate-y)) rotate(var(--tw-rotate)) skewX(var(--tw-skew-x)) skewY(var(--tw-skew-y)) scaleX(calc(20 / 24)) scaleY(calc(20 / 24));
            transform: translate(var(--tw-translate-x), var(--tw-translate-y)) rotate(var(--tw-rotate)) skewX(var(--tw-skew-x)) skewY(var(--tw-skew-y)) scaleX(var(--tw-scale-x)) scaleY(var(--tw-scale-y));
        }

        .transform {
            transform: translate(var(--tw-translate-x), var(--tw-translate-y)) rotate(var(--tw-rotate)) skewX(var(--tw-skew-x)) skewY(var(--tw-skew-y)) scaleX(var(--tw-scale-x)) scaleY(var(--tw-scale-y));
        }

        @keyframes pulse {

            50% {
                opacity: .5;
            }
        }

        .animate-pulse {
            animation: pulse 2s cubic-bezier(0.4, 0, 0.6, 1) infinite;
        }

        @keyframes reverse-spin {

            from {
                transform: rotate(360deg);
            }
        }

        .animate-reverse-spin {
            animation: reverse-spin 1s linear infinite;
        }

        @keyframes spin {

            to {
                transform: rotate(360deg);
            }
        }

        .animate-spin {
            animation: spin 1s linear infinite;
        }

        .cursor-default {
            cursor: default;
        }

        .cursor-not-allowed {
            cursor: not-allowed;
        }

        .cursor-pointer {
            cursor: pointer;
        }

        .select-none {
            -webkit-user-select: none;
            -moz-user-select: none;
            user-select: none;
        }

        .resize-none {
            resize: none;
        }

        .resize {
            resize: both;
        }

        .list-disc {
            list-style-type: disc;
        }

        .grid-cols-2 {
            grid-template-columns: repeat(2, minmax(0, 1fr));
        }

        .grid-cols-3 {
            grid-template-columns: repeat(3, minmax(0, 1fr));
        }

        .grid-cols-4 {
            grid-template-columns: repeat(4, minmax(0, 1fr));
        }

        .flex-row {
            flex-direction: row;
        }

        .flex-col {
            flex-direction: column;
        }

        .flex-wrap {
            flex-wrap: wrap;
        }

        .items-start {
            align-items: flex-start;
        }

        .items-end {
            align-items: flex-end;
        }

        .items-center {
            align-items: center;
        }

        .items-baseline {
            align-items: baseline;
        }

        .items-stretch {
            align-items: stretch;
        }

        .justify-start {
            justify-content: flex-start;
        }

        .justify-end {
            justify-content: flex-end;
        }

        .justify-center {
            justify-content: center;
        }

        .justify-between {
            justify-content: space-between;
        }

        .justify-evenly {
            justify-content: space-evenly;
        }

        .justify-stretch {
            justify-content: stretch;
        }

        .gap-1 {
            gap: 4px;
        }

        .gap-1\.5 {
            gap: 0.375rem;
        }

        .gap-2 {
            gap: 8px;
        }

        .gap-3 {
            gap: 12px;
        }

        .gap-4 {
            gap: 16px;
        }

        .gap-6 {
            gap: 24px;
        }

        .gap-\[5px\] {
            gap: 5px;
        }

        .gap-x-3 {
            -moz-column-gap: 12px;
            column-gap: 12px;
        }

        .gap-y-1 {
            row-gap: 4px;
        }

        .gap-y-4 {
            row-gap: 16px;
        }

        .space-x-0> :not([hidden])~ :not([hidden]) {
            --tw-space-x-reverse: 0;
            margin-right: calc(0px * 0);
            margin-right: calc(0px * var(--tw-space-x-reverse));
            margin-left: calc(0px * (1 - 0));
            margin-left: calc(0px * (1 - var(--tw-space-x-reverse)));
            margin-left: calc(0px * calc(1 - 0));
            margin-left: calc(0px * calc(1 - var(--tw-space-x-reverse)));
        }

        .space-x-0\.5> :not([hidden])~ :not([hidden]) {
            --tw-space-x-reverse: 0;
            margin-right: calc(2px * 0);
            margin-right: calc(2px * var(--tw-space-x-reverse));
            margin-left: calc(2px * (1 - 0));
            margin-left: calc(2px * (1 - var(--tw-space-x-reverse)));
            margin-left: calc(2px * calc(1 - 0));
            margin-left: calc(2px * calc(1 - var(--tw-space-x-reverse)));
        }

        .space-x-1> :not([hidden])~ :not([hidden]) {
            --tw-space-x-reverse: 0;
            margin-right: calc(4px * 0);
            margin-right: calc(4px * var(--tw-space-x-reverse));
            margin-left: calc(4px * (1 - 0));
            margin-left: calc(4px * (1 - var(--tw-space-x-reverse)));
            margin-left: calc(4px * calc(1 - 0));
            margin-left: calc(4px * calc(1 - var(--tw-space-x-reverse)));
        }

        .space-x-1\.25> :not([hidden])~ :not([hidden]) {
            --tw-space-x-reverse: 0;
            margin-right: calc(5px * 0);
            margin-right: calc(5px * var(--tw-space-x-reverse));
            margin-left: calc(5px * (1 - 0));
            margin-left: calc(5px * (1 - var(--tw-space-x-reverse)));
            margin-left: calc(5px * calc(1 - 0));
            margin-left: calc(5px * calc(1 - var(--tw-space-x-reverse)));
        }

        .space-x-2> :not([hidden])~ :not([hidden]) {
            --tw-space-x-reverse: 0;
            margin-right: calc(8px * 0);
            margin-right: calc(8px * var(--tw-space-x-reverse));
            margin-left: calc(8px * (1 - 0));
            margin-left: calc(8px * (1 - var(--tw-space-x-reverse)));
            margin-left: calc(8px * calc(1 - 0));
            margin-left: calc(8px * calc(1 - var(--tw-space-x-reverse)));
        }

        .space-x-2\.5> :not([hidden])~ :not([hidden]) {
            --tw-space-x-reverse: 0;
            margin-right: calc(0.625rem * 0);
            margin-right: calc(0.625rem * var(--tw-space-x-reverse));
            margin-left: calc(0.625rem * (1 - 0));
            margin-left: calc(0.625rem * (1 - var(--tw-space-x-reverse)));
            margin-left: calc(0.625rem * calc(1 - 0));
            margin-left: calc(0.625rem * calc(1 - var(--tw-space-x-reverse)));
        }

        .space-x-3> :not([hidden])~ :not([hidden]) {
            --tw-space-x-reverse: 0;
            margin-right: calc(12px * 0);
            margin-right: calc(12px * var(--tw-space-x-reverse));
            margin-left: calc(12px * (1 - 0));
            margin-left: calc(12px * (1 - var(--tw-space-x-reverse)));
            margin-left: calc(12px * calc(1 - 0));
            margin-left: calc(12px * calc(1 - var(--tw-space-x-reverse)));
        }

        .space-x-4> :not([hidden])~ :not([hidden]) {
            --tw-space-x-reverse: 0;
            margin-right: calc(16px * 0);
            margin-right: calc(16px * var(--tw-space-x-reverse));
            margin-left: calc(16px * (1 - 0));
            margin-left: calc(16px * (1 - var(--tw-space-x-reverse)));
            margin-left: calc(16px * calc(1 - 0));
            margin-left: calc(16px * calc(1 - var(--tw-space-x-reverse)));
        }

        .space-x-6> :not([hidden])~ :not([hidden]) {
            --tw-space-x-reverse: 0;
            margin-right: calc(24px * 0);
            margin-right: calc(24px * var(--tw-space-x-reverse));
            margin-left: calc(24px * (1 - 0));
            margin-left: calc(24px * (1 - var(--tw-space-x-reverse)));
            margin-left: calc(24px * calc(1 - 0));
            margin-left: calc(24px * calc(1 - var(--tw-space-x-reverse)));
        }

        .space-x-8> :not([hidden])~ :not([hidden]) {
            --tw-space-x-reverse: 0;
            margin-right: calc(32px * 0);
            margin-right: calc(32px * var(--tw-space-x-reverse));
            margin-left: calc(32px * (1 - 0));
            margin-left: calc(32px * (1 - var(--tw-space-x-reverse)));
            margin-left: calc(32px * calc(1 - 0));
            margin-left: calc(32px * calc(1 - var(--tw-space-x-reverse)));
        }

        .space-y-0> :not([hidden])~ :not([hidden]) {
            --tw-space-y-reverse: 0;
            margin-top: calc(0px * (1 - 0));
            margin-top: calc(0px * (1 - var(--tw-space-y-reverse)));
            margin-top: calc(0px * calc(1 - 0));
            margin-top: calc(0px * calc(1 - var(--tw-space-y-reverse)));
            margin-bottom: calc(0px * 0);
            margin-bottom: calc(0px * var(--tw-space-y-reverse));
        }

        .space-y-0\.5> :not([hidden])~ :not([hidden]) {
            --tw-space-y-reverse: 0;
            margin-top: calc(2px * (1 - 0));
            margin-top: calc(2px * (1 - var(--tw-space-y-reverse)));
            margin-top: calc(2px * calc(1 - 0));
            margin-top: calc(2px * calc(1 - var(--tw-space-y-reverse)));
            margin-bottom: calc(2px * 0);
            margin-bottom: calc(2px * var(--tw-space-y-reverse));
        }

        .space-y-1> :not([hidden])~ :not([hidden]) {
            --tw-space-y-reverse: 0;
            margin-top: calc(4px * (1 - 0));
            margin-top: calc(4px * (1 - var(--tw-space-y-reverse)));
            margin-top: calc(4px * calc(1 - 0));
            margin-top: calc(4px * calc(1 - var(--tw-space-y-reverse)));
            margin-bottom: calc(4px * 0);
            margin-bottom: calc(4px * var(--tw-space-y-reverse));
        }

        .space-y-1\.25> :not([hidden])~ :not([hidden]) {
            --tw-space-y-reverse: 0;
            margin-top: calc(5px * (1 - 0));
            margin-top: calc(5px * (1 - var(--tw-space-y-reverse)));
            margin-top: calc(5px * calc(1 - 0));
            margin-top: calc(5px * calc(1 - var(--tw-space-y-reverse)));
            margin-bottom: calc(5px * 0);
            margin-bottom: calc(5px * var(--tw-space-y-reverse));
        }

        .space-y-1\.5> :not([hidden])~ :not([hidden]) {
            --tw-space-y-reverse: 0;
            margin-top: calc(0.375rem * (1 - 0));
            margin-top: calc(0.375rem * (1 - var(--tw-space-y-reverse)));
            margin-top: calc(0.375rem * calc(1 - 0));
            margin-top: calc(0.375rem * calc(1 - var(--tw-space-y-reverse)));
            margin-bottom: calc(0.375rem * 0);
            margin-bottom: calc(0.375rem * var(--tw-space-y-reverse));
        }

        .space-y-12> :not([hidden])~ :not([hidden]) {
            --tw-space-y-reverse: 0;
            margin-top: calc(48px * (1 - 0));
            margin-top: calc(48px * (1 - var(--tw-space-y-reverse)));
            margin-top: calc(48px * calc(1 - 0));
            margin-top: calc(48px * calc(1 - var(--tw-space-y-reverse)));
            margin-bottom: calc(48px * 0);
            margin-bottom: calc(48px * var(--tw-space-y-reverse));
        }

        .space-y-2> :not([hidden])~ :not([hidden]) {
            --tw-space-y-reverse: 0;
            margin-top: calc(8px * (1 - 0));
            margin-top: calc(8px * (1 - var(--tw-space-y-reverse)));
            margin-top: calc(8px * calc(1 - 0));
            margin-top: calc(8px * calc(1 - var(--tw-space-y-reverse)));
            margin-bottom: calc(8px * 0);
            margin-bottom: calc(8px * var(--tw-space-y-reverse));
        }

        .space-y-2\.5> :not([hidden])~ :not([hidden]) {
            --tw-space-y-reverse: 0;
            margin-top: calc(0.625rem * (1 - 0));
            margin-top: calc(0.625rem * (1 - var(--tw-space-y-reverse)));
            margin-top: calc(0.625rem * calc(1 - 0));
            margin-top: calc(0.625rem * calc(1 - var(--tw-space-y-reverse)));
            margin-bottom: calc(0.625rem * 0);
            margin-bottom: calc(0.625rem * var(--tw-space-y-reverse));
        }

        .space-y-3> :not([hidden])~ :not([hidden]) {
            --tw-space-y-reverse: 0;
            margin-top: calc(12px * (1 - 0));
            margin-top: calc(12px * (1 - var(--tw-space-y-reverse)));
            margin-top: calc(12px * calc(1 - 0));
            margin-top: calc(12px * calc(1 - var(--tw-space-y-reverse)));
            margin-bottom: calc(12px * 0);
            margin-bottom: calc(12px * var(--tw-space-y-reverse));
        }

        .space-y-4> :not([hidden])~ :not([hidden]) {
            --tw-space-y-reverse: 0;
            margin-top: calc(16px * (1 - 0));
            margin-top: calc(16px * (1 - var(--tw-space-y-reverse)));
            margin-top: calc(16px * calc(1 - 0));
            margin-top: calc(16px * calc(1 - var(--tw-space-y-reverse)));
            margin-bottom: calc(16px * 0);
            margin-bottom: calc(16px * var(--tw-space-y-reverse));
        }

        .space-y-5> :not([hidden])~ :not([hidden]) {
            --tw-space-y-reverse: 0;
            margin-top: calc(1.25rem * (1 - 0));
            margin-top: calc(1.25rem * (1 - var(--tw-space-y-reverse)));
            margin-top: calc(1.25rem * calc(1 - 0));
            margin-top: calc(1.25rem * calc(1 - var(--tw-space-y-reverse)));
            margin-bottom: calc(1.25rem * 0);
            margin-bottom: calc(1.25rem * var(--tw-space-y-reverse));
        }

        .space-y-6> :not([hidden])~ :not([hidden]) {
            --tw-space-y-reverse: 0;
            margin-top: calc(24px * (1 - 0));
            margin-top: calc(24px * (1 - var(--tw-space-y-reverse)));
            margin-top: calc(24px * calc(1 - 0));
            margin-top: calc(24px * calc(1 - var(--tw-space-y-reverse)));
            margin-bottom: calc(24px * 0);
            margin-bottom: calc(24px * var(--tw-space-y-reverse));
        }

        .space-y-7> :not([hidden])~ :not([hidden]) {
            --tw-space-y-reverse: 0;
            margin-top: calc(1.75rem * (1 - 0));
            margin-top: calc(1.75rem * (1 - var(--tw-space-y-reverse)));
            margin-top: calc(1.75rem * calc(1 - 0));
            margin-top: calc(1.75rem * calc(1 - var(--tw-space-y-reverse)));
            margin-bottom: calc(1.75rem * 0);
            margin-bottom: calc(1.75rem * var(--tw-space-y-reverse));
        }

        .space-y-8> :not([hidden])~ :not([hidden]) {
            --tw-space-y-reverse: 0;
            margin-top: calc(32px * (1 - 0));
            margin-top: calc(32px * (1 - var(--tw-space-y-reverse)));
            margin-top: calc(32px * calc(1 - 0));
            margin-top: calc(32px * calc(1 - var(--tw-space-y-reverse)));
            margin-bottom: calc(32px * 0);
            margin-bottom: calc(32px * var(--tw-space-y-reverse));
        }

        .self-center {
            align-self: center;
        }

        .self-stretch {
            align-self: stretch;
        }

        .justify-self-end {
            justify-self: end;
        }

        .overflow-auto {
            overflow: auto;
        }

        .overflow-hidden {
            overflow: hidden;
        }

        .overflow-x-auto {
            overflow-x: auto;
        }

        .overflow-y-auto {
            overflow-y: auto;
        }

        .overflow-y-hidden {
            overflow-y: hidden;
        }

        .truncate {
            overflow: hidden;
            text-overflow: ellipsis;
            white-space: nowrap;
        }

        .whitespace-nowrap {
            white-space: nowrap;
        }

        .whitespace-pre-wrap {
            white-space: pre-wrap;
        }

        .break-words {
            word-wrap: break-word;
        }

        .break-all {
            word-break: break-all;
        }

        .rounded {
            border-radius: 4px;
        }

        .rounded-2 {
            border-radius: 8px;
        }

        .rounded-3 {
            border-radius: 12px;
        }

        .rounded-3xl {
            border-radius: 14px;
        }

        .rounded-4 {
            border-radius: 16px;
        }

        .rounded-5xl {
            border-radius: 20px;
        }

        .rounded-6 {
            border-radius: 24px;
        }

        .rounded-\[24px_0px_0px_24px\] {
            border-radius: 24px 0px 0px 24px;
        }

        .rounded-\[40px\] {
            border-radius: 40px;
        }

        .rounded-\[4px\] {
            border-radius: 4px;
        }

        .rounded-curvy {
            border-radius: 50px;
        }

        .rounded-full {
            border-radius: 9999px;
        }

        .rounded-lg {
            border-radius: 8px;
        }

        .rounded-xl {
            border-radius: 10px;
        }

        .rounded-b-4 {
            border-bottom-right-radius: 16px;
            border-bottom-left-radius: 16px;
        }

        .rounded-t-4 {
            border-top-left-radius: 16px;
            border-top-right-radius: 16px;
        }

        .rounded-bl-full {
            border-bottom-left-radius: 9999px;
        }

        .rounded-br-4 {
            border-bottom-right-radius: 16px;
        }

        .rounded-tl-full {
            border-top-left-radius: 9999px;
        }

        .border {
            border-width: 1px;
        }

        .border-2 {
            border-width: 2px;
        }

        .border-b {
            border-bottom-width: 1px;
        }

        .border-r {
            border-right-width: 1px;
        }

        .border-t {
            border-top-width: 1px;
        }

        .border-solid {
            border-style: solid;
        }

        .border-dashed {
            border-style: dashed;
        }

        .\!border-error {
            --tw-border-opacity: 1 !important;
            border-color: hsl(var(--twc-error) / 1) !important;
            border-color: hsl(var(--twc-error) / var(--twc-error-opacity, var(--tw-border-opacity))) !important;
        }

        .border-accent-blue {
            --tw-border-opacity: 1;
            border-color: hsl(var(--twc-accent-blue) / 1);
            border-color: hsl(var(--twc-accent-blue) / var(--twc-accent-blue-opacity, var(--tw-border-opacity)));
        }

        .border-accent-neon-green {
            --tw-border-opacity: 1;
            border-color: hsl(var(--twc-accent-neon-green) / 1);
            border-color: hsl(var(--twc-accent-neon-green) / var(--twc-accent-neon-green-opacity, var(--tw-border-opacity)));
        }

        .border-accent-pink {
            --tw-border-opacity: 1;
            border-color: hsl(var(--twc-accent-pink) / 1);
            border-color: hsl(var(--twc-accent-pink) / var(--twc-accent-pink-opacity, var(--tw-border-opacity)));
        }

        .border-accent-yellow {
            --tw-border-opacity: 1;
            border-color: hsl(var(--twc-accent-yellow) / 1);
            border-color: hsl(var(--twc-accent-yellow) / var(--twc-accent-yellow-opacity, var(--tw-border-opacity)));
        }

        .border-background-1 {
            --tw-border-opacity: 1;
            border-color: hsl(var(--twc-background-1) / 1);
            border-color: hsl(var(--twc-background-1) / var(--twc-background-1-opacity, var(--tw-border-opacity)));
        }

        .border-backgroundPrimary {
            --tw-border-opacity: 1;
            border-color: hsl(var(--twc-backgroundPrimary) / 1);
            border-color: hsl(var(--twc-backgroundPrimary) / var(--twc-backgroundPrimary-opacity, var(--tw-border-opacity)));
        }

        .border-backgroundTertiary {
            --tw-border-opacity: 1;
            border-color: hsl(var(--twc-backgroundTertiary) / 1);
            border-color: hsl(var(--twc-backgroundTertiary) / var(--twc-backgroundTertiary-opacity, var(--tw-border-opacity)));
        }

        .border-black {
            --tw-border-opacity: 1;
            border-color: rgba(0, 0, 0, 1);
            border-color: rgba(0, 0, 0, var(--tw-border-opacity));
        }

        .border-error {
            --tw-border-opacity: 1;
            border-color: hsl(var(--twc-error) / 1);
            border-color: hsl(var(--twc-error) / var(--twc-error-opacity, var(--tw-border-opacity)));
        }

        .border-error-1-opacity-1 {
            --tw-border-opacity: 1;
            border-color: hsl(var(--twc-error-1-opacity-1) / 1);
            border-color: hsl(var(--twc-error-1-opacity-1) / var(--twc-error-1-opacity-1-opacity, var(--tw-border-opacity)));
        }

        .border-line {
            --tw-border-opacity: 1;
            border-color: hsl(var(--twc-line) / 1);
            border-color: hsl(var(--twc-line) / var(--twc-line-opacity, var(--tw-border-opacity)));
        }

        .border-on-primary-opacity-1 {
            --tw-border-opacity: 1;
            border-color: hsl(var(--twc-on-primary-opacity-1) / 1);
            border-color: hsl(var(--twc-on-primary-opacity-1) / var(--twc-on-primary-opacity-1-opacity, var(--tw-border-opacity)));
        }

        .border-primary {
            --tw-border-opacity: 1;
            border-color: hsl(var(--twc-primary) / 1);
            border-color: hsl(var(--twc-primary) / var(--twc-primary-opacity, var(--tw-border-opacity)));
        }

        .border-primary-default {
            --tw-border-opacity: 1;
            border-color: hsl(var(--twc-primary-default) / 1);
            border-color: hsl(var(--twc-primary-default) / var(--twc-primary-default-opacity, var(--tw-border-opacity)));
        }

        .border-primary-opacity-1 {
            --tw-border-opacity: 1;
            border-color: hsl(var(--twc-primary-opacity-1) / 1);
            border-color: hsl(var(--twc-primary-opacity-1) / var(--twc-primary-opacity-1-opacity, var(--tw-border-opacity)));
        }

        .border-transparent {
            --tw-border-opacity: 1;
            border-color: hsl(var(--twc-transparent) / 1);
            border-color: hsl(var(--twc-transparent) / var(--twc-transparent-opacity, var(--tw-border-opacity)));
        }

        .border-utility-1-opacity-3 {
            --tw-border-opacity: 1;
            border-color: hsl(var(--twc-utility-1-opacity-3) / 1);
            border-color: hsl(var(--twc-utility-1-opacity-3) / var(--twc-utility-1-opacity-3-opacity, var(--tw-border-opacity)));
        }

        .border-utility-1-opacity-5 {
            --tw-border-opacity: 1;
            border-color: hsl(var(--twc-utility-1-opacity-5) / 1);
            border-color: hsl(var(--twc-utility-1-opacity-5) / var(--twc-utility-1-opacity-5-opacity, var(--tw-border-opacity)));
        }

        .border-b-error-1-default {
            --tw-border-opacity: 1;
            border-bottom-color: hsl(var(--twc-error-1-default) / 1);
            border-bottom-color: hsl(var(--twc-error-1-default) / var(--twc-error-1-default-opacity, var(--tw-border-opacity)));
        }

        .border-b-on-primary {
            --tw-border-opacity: 1;
            border-bottom-color: hsl(var(--twc-on-primary) / 1);
            border-bottom-color: hsl(var(--twc-on-primary) / var(--twc-on-primary-opacity, var(--tw-border-opacity)));
        }

        .border-b-primary-default {
            --tw-border-opacity: 1;
            border-bottom-color: hsl(var(--twc-primary-default) / 1);
            border-bottom-color: hsl(var(--twc-primary-default) / var(--twc-primary-default-opacity, var(--tw-border-opacity)));
        }

        .border-b-utility-1-opacity-1 {
            --tw-border-opacity: 1;
            border-bottom-color: hsl(var(--twc-utility-1-opacity-1) / 1);
            border-bottom-color: hsl(var(--twc-utility-1-opacity-1) / var(--twc-utility-1-opacity-1-opacity, var(--tw-border-opacity)));
        }

        .border-b-utility-1-opacity-5 {
            --tw-border-opacity: 1;
            border-bottom-color: hsl(var(--twc-utility-1-opacity-5) / 1);
            border-bottom-color: hsl(var(--twc-utility-1-opacity-5) / var(--twc-utility-1-opacity-5-opacity, var(--tw-border-opacity)));
        }

        .border-t-line {
            --tw-border-opacity: 1;
            border-top-color: hsl(var(--twc-line) / 1);
            border-top-color: hsl(var(--twc-line) / var(--twc-line-opacity, var(--tw-border-opacity)));
        }

        .border-t-utility-1-opacity-5 {
            --tw-border-opacity: 1;
            border-top-color: hsl(var(--twc-utility-1-opacity-5) / 1);
            border-top-color: hsl(var(--twc-utility-1-opacity-5) / var(--twc-utility-1-opacity-5-opacity, var(--tw-border-opacity)));
        }

        .bg-\[rgba\(37\2c 37\2c 37\2c 0\.08\)\] {
            background-color: rgba(37, 37, 37, 0.08);
        }

        .bg-accent-blue {
            --tw-bg-opacity: 1;
            background-color: hsl(var(--twc-accent-blue) / 1);
            background-color: hsl(var(--twc-accent-blue) / var(--twc-accent-blue-opacity, var(--tw-bg-opacity)));
        }

        .bg-accent-neon-green {
            --tw-bg-opacity: 1;
            background-color: hsl(var(--twc-accent-neon-green) / 1);
            background-color: hsl(var(--twc-accent-neon-green) / var(--twc-accent-neon-green-opacity, var(--tw-bg-opacity)));
        }

        .bg-accent-pink {
            --tw-bg-opacity: 1;
            background-color: hsl(var(--twc-accent-pink) / 1);
            background-color: hsl(var(--twc-accent-pink) / var(--twc-accent-pink-opacity, var(--tw-bg-opacity)));
        }

        .bg-accent-yellow {
            --tw-bg-opacity: 1;
            background-color: hsl(var(--twc-accent-yellow) / 1);
            background-color: hsl(var(--twc-accent-yellow) / var(--twc-accent-yellow-opacity, var(--tw-bg-opacity)));
        }

        .bg-background-1 {
            --tw-bg-opacity: 1;
            background-color: hsl(var(--twc-background-1) / 1);
            background-color: hsl(var(--twc-background-1) / var(--twc-background-1-opacity, var(--tw-bg-opacity)));
        }

        .bg-background-2 {
            --tw-bg-opacity: 1;
            background-color: hsl(var(--twc-background-2) / 1);
            background-color: hsl(var(--twc-background-2) / var(--twc-background-2-opacity, var(--tw-bg-opacity)));
        }

        .bg-backgroundPrimary {
            --tw-bg-opacity: 1;
            background-color: hsl(var(--twc-backgroundPrimary) / 1);
            background-color: hsl(var(--twc-backgroundPrimary) / var(--twc-backgroundPrimary-opacity, var(--tw-bg-opacity)));
        }

        .bg-backgroundSecondary {
            --tw-bg-opacity: 1;
            background-color: hsl(var(--twc-backgroundSecondary) / 1);
            background-color: hsl(var(--twc-backgroundSecondary) / var(--twc-backgroundSecondary-opacity, var(--tw-bg-opacity)));
        }

        .bg-backgroundTertiary {
            --tw-bg-opacity: 1;
            background-color: hsl(var(--twc-backgroundTertiary) / 1);
            background-color: hsl(var(--twc-backgroundTertiary) / var(--twc-backgroundTertiary-opacity, var(--tw-bg-opacity)));
        }

        .bg-bg3 {
            --tw-bg-opacity: 1;
            background-color: hsl(var(--twc-bg3) / 1);
            background-color: hsl(var(--twc-bg3) / var(--twc-bg3-opacity, var(--tw-bg-opacity)));
        }

        .bg-black {
            --tw-bg-opacity: 1;
            background-color: rgba(0, 0, 0, 1);
            background-color: rgba(0, 0, 0, var(--tw-bg-opacity));
        }

        .bg-error-1-default {
            --tw-bg-opacity: 1;
            background-color: hsl(var(--twc-error-1-default) / 1);
            background-color: hsl(var(--twc-error-1-default) / var(--twc-error-1-default-opacity, var(--tw-bg-opacity)));
        }

        .bg-error-1-opacity-1 {
            --tw-bg-opacity: 1;
            background-color: hsl(var(--twc-error-1-opacity-1) / 1);
            background-color: hsl(var(--twc-error-1-opacity-1) / var(--twc-error-1-opacity-1-opacity, var(--tw-bg-opacity)));
        }

        .bg-errorBg {
            --tw-bg-opacity: 1;
            background-color: hsl(var(--twc-errorBg) / 1);
            background-color: hsl(var(--twc-errorBg) / var(--twc-errorBg-opacity, var(--tw-bg-opacity)));
        }

        .bg-line {
            --tw-bg-opacity: 1;
            background-color: hsl(var(--twc-line) / 1);
            background-color: hsl(var(--twc-line) / var(--twc-line-opacity, var(--tw-bg-opacity)));
        }

        .bg-primary {
            --tw-bg-opacity: 1;
            background-color: hsl(var(--twc-primary) / 1);
            background-color: hsl(var(--twc-primary) / var(--twc-primary-opacity, var(--tw-bg-opacity)));
        }

        .bg-primary-default {
            --tw-bg-opacity: 1;
            background-color: hsl(var(--twc-primary-default) / 1);
            background-color: hsl(var(--twc-primary-default) / var(--twc-primary-default-opacity, var(--tw-bg-opacity)));
        }

        .bg-primary-opacity-1 {
            --tw-bg-opacity: 1;
            background-color: hsl(var(--twc-primary-opacity-1) / 1);
            background-color: hsl(var(--twc-primary-opacity-1) / var(--twc-primary-opacity-1-opacity, var(--tw-bg-opacity)));
        }

        .bg-primary-pressed {
            --tw-bg-opacity: 1;
            background-color: hsl(var(--twc-primary-pressed) / 1);
            background-color: hsl(var(--twc-primary-pressed) / var(--twc-primary-pressed-opacity, var(--tw-bg-opacity)));
        }

        .bg-success-1-default {
            --tw-bg-opacity: 1;
            background-color: hsl(var(--twc-success-1-default) / 1);
            background-color: hsl(var(--twc-success-1-default) / var(--twc-success-1-default-opacity, var(--tw-bg-opacity)));
        }

        .bg-successBg {
            --tw-bg-opacity: 1;
            background-color: hsl(var(--twc-successBg) / 1);
            background-color: hsl(var(--twc-successBg) / var(--twc-successBg-opacity, var(--tw-bg-opacity)));
        }

        .bg-transparent {
            --tw-bg-opacity: 1;
            background-color: hsl(var(--twc-transparent) / 1);
            background-color: hsl(var(--twc-transparent) / var(--twc-transparent-opacity, var(--tw-bg-opacity)));
        }

        .bg-utility-1-default {
            --tw-bg-opacity: 1;
            background-color: hsl(var(--twc-utility-1-default) / 1);
            background-color: hsl(var(--twc-utility-1-default) / var(--twc-utility-1-default-opacity, var(--tw-bg-opacity)));
        }

        .bg-utility-1-opacity-2 {
            --tw-bg-opacity: 1;
            background-color: hsl(var(--twc-utility-1-opacity-2) / 1);
            background-color: hsl(var(--twc-utility-1-opacity-2) / var(--twc-utility-1-opacity-2-opacity, var(--tw-bg-opacity)));
        }

        .bg-utility-1-opacity-3 {
            --tw-bg-opacity: 1;
            background-color: hsl(var(--twc-utility-1-opacity-3) / 1);
            background-color: hsl(var(--twc-utility-1-opacity-3) / var(--twc-utility-1-opacity-3-opacity, var(--tw-bg-opacity)));
        }

        .bg-utility-1-opacity-4 {
            --tw-bg-opacity: 1;
            background-color: hsl(var(--twc-utility-1-opacity-4) / 1);
            background-color: hsl(var(--twc-utility-1-opacity-4) / var(--twc-utility-1-opacity-4-opacity, var(--tw-bg-opacity)));
        }

        .bg-utility-1-opacity-5 {
            --tw-bg-opacity: 1;
            background-color: hsl(var(--twc-utility-1-opacity-5) / 1);
            background-color: hsl(var(--twc-utility-1-opacity-5) / var(--twc-utility-1-opacity-5-opacity, var(--tw-bg-opacity)));
        }

        .bg-utility-1-opacity-6 {
            --tw-bg-opacity: 1;
            background-color: hsl(var(--twc-utility-1-opacity-6) / 1);
            background-color: hsl(var(--twc-utility-1-opacity-6) / var(--twc-utility-1-opacity-6-opacity, var(--tw-bg-opacity)));
        }

        .bg-warning {
            --tw-bg-opacity: 1;
            background-color: hsl(var(--twc-warning) / 1);
            background-color: hsl(var(--twc-warning) / var(--twc-warning-opacity, var(--tw-bg-opacity)));
        }

        .bg-warning-1-opacity-1 {
            --tw-bg-opacity: 1;
            background-color: hsl(var(--twc-warning-1-opacity-1) / 1);
            background-color: hsl(var(--twc-warning-1-opacity-1) / var(--twc-warning-1-opacity-1-opacity, var(--tw-bg-opacity)));
        }

        .bg-opacity-50 {
            --tw-bg-opacity: 0.5;
        }

        .bg-gradient-primary {
            background-image: linear-gradient(268deg, var(--tw-gradient-stops));
        }

        .fill-background-2 {
            fill: hsl(var(--twc-background-2) / 1);
            fill: hsl(var(--twc-background-2) / var(--twc-background-2-opacity, 1));
        }

        .fill-utility-1-default {
            fill: hsl(var(--twc-utility-1-default) / 1);
            fill: hsl(var(--twc-utility-1-default) / var(--twc-utility-1-default-opacity, 1));
        }

        .stroke-current {
            stroke: currentColor;
        }

        .\!p-0 {
            padding: 0px !important;
        }

        .p-0 {
            padding: 0px;
        }

        .p-1 {
            padding: 4px;
        }

        .p-1\.5 {
            padding: 0.375rem;
        }

        .p-12 {
            padding: 48px;
        }

        .p-2 {
            padding: 8px;
        }

        .p-2\.5 {
            padding: 0.625rem;
        }

        .p-3 {
            padding: 12px;
        }

        .p-4 {
            padding: 16px;
        }

        .p-6 {
            padding: 24px;
        }

        .p-\[10px\] {
            padding: 10px;
        }

        .px-1 {
            padding-left: 4px;
            padding-right: 4px;
        }

        .px-2 {
            padding-left: 8px;
            padding-right: 8px;
        }

        .px-3 {
            padding-left: 12px;
            padding-right: 12px;
        }

        .px-4 {
            padding-left: 16px;
            padding-right: 16px;
        }

        .px-5 {
            padding-left: 1.25rem;
            padding-right: 1.25rem;
        }

        .px-6 {
            padding-left: 24px;
            padding-right: 24px;
        }

        .px-8 {
            padding-left: 32px;
            padding-right: 32px;
        }

        .py-0 {
            padding-top: 0px;
            padding-bottom: 0px;
        }

        .py-0\.5 {
            padding-top: 2px;
            padding-bottom: 2px;
        }

        .py-1 {
            padding-top: 4px;
            padding-bottom: 4px;
        }

        .py-1\.5 {
            padding-top: 0.375rem;
            padding-bottom: 0.375rem;
        }

        .py-2 {
            padding-top: 8px;
            padding-bottom: 8px;
        }

        .py-2\.5 {
            padding-top: 0.625rem;
            padding-bottom: 0.625rem;
        }

        .py-3 {
            padding-top: 12px;
            padding-bottom: 12px;
        }

        .py-4 {
            padding-top: 16px;
            padding-bottom: 16px;
        }

        .pb-0 {
            padding-bottom: 0px;
        }

        .pb-2 {
            padding-bottom: 8px;
        }

        .pb-28 {
            padding-bottom: 7rem;
        }

        .pb-3 {
            padding-bottom: 12px;
        }

        .pb-4 {
            padding-bottom: 16px;
        }

        .pb-5 {
            padding-bottom: 1.25rem;
        }

        .pb-6 {
            padding-bottom: 24px;
        }

        .pb-8 {
            padding-bottom: 32px;
        }

        .pb-\[100\%\] {
            padding-bottom: 100%;
        }

        .pl-1 {
            padding-left: 4px;
        }

        .pl-1\.5 {
            padding-left: 0.375rem;
        }

        .pl-11 {
            padding-left: 2.75rem;
        }

        .pl-2 {
            padding-left: 8px;
        }

        .pl-2\.5 {
            padding-left: 0.625rem;
        }

        .pl-3 {
            padding-left: 12px;
        }

        .pl-4 {
            padding-left: 16px;
        }

        .pr-1 {
            padding-right: 4px;
        }

        .pr-10 {
            padding-right: 40px;
        }

        .pr-2 {
            padding-right: 8px;
        }

        .pr-3 {
            padding-right: 12px;
        }

        .pr-4 {
            padding-right: 16px;
        }

        .pr-\[2px\] {
            padding-right: 2px;
        }

        .pr-\[30px\] {
            padding-right: 30px;
        }

        .pr-\[56px\] {
            padding-right: 56px;
        }

        .pt-0 {
            padding-top: 0px;
        }

        .pt-0\.5 {
            padding-top: 2px;
        }

        .pt-1 {
            padding-top: 4px;
        }

        .pt-2 {
            padding-top: 8px;
        }

        .pt-20 {
            padding-top: 5rem;
        }

        .pt-3 {
            padding-top: 12px;
        }

        .pt-4 {
            padding-top: 16px;
        }

        .pt-5 {
            padding-top: 1.25rem;
        }

        .pt-6 {
            padding-top: 24px;
        }

        .pt-8 {
            padding-top: 32px;
        }

        .pt-\[40px\] {
            padding-top: 40px;
        }

        .pt-\[59px\] {
            padding-top: 59px;
        }

        .text-left {
            text-align: left;
        }

        .text-center {
            text-align: center;
        }

        .text-right {
            text-align: right;
        }

        .text-start {
            text-align: left;
        }

        .text-end {
            text-align: right;
        }

        .align-middle {
            vertical-align: middle;
        }

        .font-brand {
            font-family: Geeza, "Ping Fang", "Binance Plex", ui-sans-serif, system-ui, -apple-system, Segoe UI, Roboto, Ubuntu, Cantarell, Noto Sans, sans-serif, "Apple Color Emoji", "Segoe UI Emoji", "Segoe UI Symbol", "Noto Color Emoji";
        }

        .text-\[11px\]\/\[13px\] {
            font-size: 11px;
            line-height: 13px;
        }

        .text-\[17px\] {
            font-size: 17px;
        }

        .text-\[23px\] {
            font-size: 23px;
        }

        .text-headline6 {
            font-size: 24px;
        }

        .text-subheader-14 {
            font-size: 14px;
        }

        .text-subheader-16 {
            font-size: 16px;
        }

        .font-bold {
            font-weight: 700;
        }

        .font-light {
            font-weight: 300;
        }

        .font-medium {
            font-weight: 500;
        }

        .font-normal {
            font-weight: 400;
        }

        .font-semibold {
            font-weight: 600;
        }

        .uppercase {
            text-transform: uppercase;
        }

        .capitalize {
            text-transform: capitalize;
        }

        .leading-body-12 {
            line-height: 16px;
        }

        .leading-body-14 {
            line-height: 18px;
        }

        .leading-body-16 {
            line-height: 20px;
        }

        .leading-body-20 {
            line-height: 24px;
        }

        .leading-header-16 {
            line-height: 22px;
        }

        .leading-header-18 {
            line-height: 24px;
        }

        .leading-header-20 {
            line-height: 26px;
        }

        .leading-header-24 {
            line-height: 30px;
        }

        .leading-header-32 {
            line-height: 40px;
        }

        .leading-header-48 {
            line-height: 56px;
        }

        .leading-headline6 {
            line-height: 32px;
        }

        .leading-subheader-14 {
            line-height: 18px;
        }

        .leading-subheader-16 {
            line-height: 20px;
        }

        .leading-subheader-18 {
            line-height: 22px;
        }

        .leading-subheader-20 {
            line-height: 24px;
        }

        .leading-subheader-24 {
            line-height: 28px;
        }

        .text-accent-blue {
            --tw-text-opacity: 1;
            color: hsl(var(--twc-accent-blue) / 1);
            color: hsl(var(--twc-accent-blue) / var(--twc-accent-blue-opacity, var(--tw-text-opacity)));
        }

        .text-accent-neon-green {
            --tw-text-opacity: 1;
            color: hsl(var(--twc-accent-neon-green) / 1);
            color: hsl(var(--twc-accent-neon-green) / var(--twc-accent-neon-green-opacity, var(--tw-text-opacity)));
        }

        .text-accent-pink {
            --tw-text-opacity: 1;
            color: hsl(var(--twc-accent-pink) / 1);
            color: hsl(var(--twc-accent-pink) / var(--twc-accent-pink-opacity, var(--tw-text-opacity)));
        }

        .text-accent-yellow {
            --tw-text-opacity: 1;
            color: hsl(var(--twc-accent-yellow) / 1);
            color: hsl(var(--twc-accent-yellow) / var(--twc-accent-yellow-opacity, var(--tw-text-opacity)));
        }

        .text-background-1 {
            --tw-text-opacity: 1;
            color: hsl(var(--twc-background-1) / 1);
            color: hsl(var(--twc-background-1) / var(--twc-background-1-opacity, var(--tw-text-opacity)));
        }

        .text-backgroundPrimary {
            --tw-text-opacity: 1;
            color: hsl(var(--twc-backgroundPrimary) / 1);
            color: hsl(var(--twc-backgroundPrimary) / var(--twc-backgroundPrimary-opacity, var(--tw-text-opacity)));
        }

        .text-backgroundTertiary {
            --tw-text-opacity: 1;
            color: hsl(var(--twc-backgroundTertiary) / 1);
            color: hsl(var(--twc-backgroundTertiary) / var(--twc-backgroundTertiary-opacity, var(--tw-text-opacity)));
        }

        .text-error {
            --tw-text-opacity: 1;
            color: hsl(var(--twc-error) / 1);
            color: hsl(var(--twc-error) / var(--twc-error-opacity, var(--tw-text-opacity)));
        }

        .text-error-1-default {
            --tw-text-opacity: 1;
            color: hsl(var(--twc-error-1-default) / 1);
            color: hsl(var(--twc-error-1-default) / var(--twc-error-1-default-opacity, var(--tw-text-opacity)));
        }

        .text-iconNormal {
            --tw-text-opacity: 1;
            color: hsl(var(--twc-iconNormal) / 1);
            color: hsl(var(--twc-iconNormal) / var(--twc-iconNormal-opacity, var(--tw-text-opacity)));
        }

        .text-iconWarning {
            --tw-text-opacity: 1;
            color: hsl(var(--twc-iconWarning) / 1);
            color: hsl(var(--twc-iconWarning) / var(--twc-iconWarning-opacity, var(--tw-text-opacity)));
        }

        .text-on-primary {
            --tw-text-opacity: 1;
            color: hsl(var(--twc-on-primary) / 1);
            color: hsl(var(--twc-on-primary) / var(--twc-on-primary-opacity, var(--tw-text-opacity)));
        }

        .text-primary {
            --tw-text-opacity: 1;
            color: hsl(var(--twc-primary) / 1);
            color: hsl(var(--twc-primary) / var(--twc-primary-opacity, var(--tw-text-opacity)));
        }

        .text-primary-default {
            --tw-text-opacity: 1;
            color: hsl(var(--twc-primary-default) / 1);
            color: hsl(var(--twc-primary-default) / var(--twc-primary-default-opacity, var(--tw-text-opacity)));
        }

        .text-success {
            --tw-text-opacity: 1;
            color: hsl(var(--twc-success) / 1);
            color: hsl(var(--twc-success) / var(--twc-success-opacity, var(--tw-text-opacity)));
        }

        .text-success-1-default {
            --tw-text-opacity: 1;
            color: hsl(var(--twc-success-1-default) / 1);
            color: hsl(var(--twc-success-1-default) / var(--twc-success-1-default-opacity, var(--tw-text-opacity)));
        }

        .text-textBrand {
            --tw-text-opacity: 1;
            color: hsl(var(--twc-textBrand) / 1);
            color: hsl(var(--twc-textBrand) / var(--twc-textBrand-opacity, var(--tw-text-opacity)));
        }

        .text-textBuy {
            --tw-text-opacity: 1;
            color: hsl(var(--twc-textBuy) / 1);
            color: hsl(var(--twc-textBuy) / var(--twc-textBuy-opacity, var(--tw-text-opacity)));
        }

        .text-textDisabled {
            --tw-text-opacity: 1;
            color: hsl(var(--twc-textDisabled) / 1);
            color: hsl(var(--twc-textDisabled) / var(--twc-textDisabled-opacity, var(--tw-text-opacity)));
        }

        .text-textPrimary {
            --tw-text-opacity: 1;
            color: hsl(var(--twc-textPrimary) / 1);
            color: hsl(var(--twc-textPrimary) / var(--twc-textPrimary-opacity, var(--tw-text-opacity)));
        }

        .text-textPrimaryStatic {
            --tw-text-opacity: 1;
            color: hsl(var(--twc-textPrimaryStatic) / 1);
            color: hsl(var(--twc-textPrimaryStatic) / var(--twc-textPrimaryStatic-opacity, var(--tw-text-opacity)));
        }

        .text-textSecondary {
            --tw-text-opacity: 1;
            color: hsl(var(--twc-textSecondary) / 1);
            color: hsl(var(--twc-textSecondary) / var(--twc-textSecondary-opacity, var(--tw-text-opacity)));
        }

        .text-textSell {
            --tw-text-opacity: 1;
            color: hsl(var(--twc-textSell) / 1);
            color: hsl(var(--twc-textSell) / var(--twc-textSell-opacity, var(--tw-text-opacity)));
        }

        .text-textThird {
            --tw-text-opacity: 1;
            color: hsl(var(--twc-textThird) / 1);
            color: hsl(var(--twc-textThird) / var(--twc-textThird-opacity, var(--tw-text-opacity)));
        }

        .text-utility-1-default {
            --tw-text-opacity: 1;
            color: hsl(var(--twc-utility-1-default) / 1);
            color: hsl(var(--twc-utility-1-default) / var(--twc-utility-1-default-opacity, var(--tw-text-opacity)));
        }

        .text-utility-1-opacity-1 {
            --tw-text-opacity: 1;
            color: hsl(var(--twc-utility-1-opacity-1) / 1);
            color: hsl(var(--twc-utility-1-opacity-1) / var(--twc-utility-1-opacity-1-opacity, var(--tw-text-opacity)));
        }

        .text-utility-1-opacity-2 {
            --tw-text-opacity: 1;
            color: hsl(var(--twc-utility-1-opacity-2) / 1);
            color: hsl(var(--twc-utility-1-opacity-2) / var(--twc-utility-1-opacity-2-opacity, var(--tw-text-opacity)));
        }

        .text-utility-1-opacity-3 {
            --tw-text-opacity: 1;
            color: hsl(var(--twc-utility-1-opacity-3) / 1);
            color: hsl(var(--twc-utility-1-opacity-3) / var(--twc-utility-1-opacity-3-opacity, var(--tw-text-opacity)));
        }

        .text-warning-1-default {
            --tw-text-opacity: 1;
            color: hsl(var(--twc-warning-1-default) / 1);
            color: hsl(var(--twc-warning-1-default) / var(--twc-warning-1-default-opacity, var(--tw-text-opacity)));
        }

        .text-white {
            --tw-text-opacity: 1;
            color: rgba(255, 255, 255, 1);
            color: rgba(255, 255, 255, var(--tw-text-opacity));
        }

        .underline {
            text-decoration-line: underline;
        }

        .opacity-0 {
            opacity: 0;
        }

        .opacity-100 {
            opacity: 1;
        }

        .opacity-40 {
            opacity: 0.4;
        }

        .opacity-50 {
            opacity: 0.5;
        }

        .opacity-60 {
            opacity: 0.6;
        }

        .opacity-70 {
            opacity: 0.7;
        }

        .shadow {
            --tw-shadow: 0 1px 3px 0 rgba(0, 0, 0, 0.1), 0 1px 2px -1px rgba(0, 0, 0, 0.1);
            --tw-shadow-colored: 0 1px 3px 0 var(--tw-shadow-color), 0 1px 2px -1px var(--tw-shadow-color);
            box-shadow: 0 0 rgba(0, 0, 0, 0), 0 0 rgba(0, 0, 0, 0), 0 1px 3px 0 rgba(0, 0, 0, 0.1), 0 1px 2px -1px rgba(0, 0, 0, 0.1);
            box-shadow: var(--tw-ring-offset-shadow, 0 0 rgba(0, 0, 0, 0)), var(--tw-ring-shadow, 0 0 rgba(0, 0, 0, 0)), var(--tw-shadow);
        }

        .shadow-lg {
            --tw-shadow: 0 10px 15px -3px rgba(0, 0, 0, 0.1), 0 4px 6px -4px rgba(0, 0, 0, 0.1);
            --tw-shadow-colored: 0 10px 15px -3px var(--tw-shadow-color), 0 4px 6px -4px var(--tw-shadow-color);
            box-shadow: 0 0 rgba(0, 0, 0, 0), 0 0 rgba(0, 0, 0, 0), 0 10px 15px -3px rgba(0, 0, 0, 0.1), 0 4px 6px -4px rgba(0, 0, 0, 0.1);
            box-shadow: var(--tw-ring-offset-shadow, 0 0 rgba(0, 0, 0, 0)), var(--tw-ring-shadow, 0 0 rgba(0, 0, 0, 0)), var(--tw-shadow);
        }

        .shadow-md {
            --tw-shadow: 0 4px 6px -1px rgba(0, 0, 0, 0.1), 0 2px 4px -2px rgba(0, 0, 0, 0.1);
            --tw-shadow-colored: 0 4px 6px -1px var(--tw-shadow-color), 0 2px 4px -2px var(--tw-shadow-color);
            box-shadow: 0 0 rgba(0, 0, 0, 0), 0 0 rgba(0, 0, 0, 0), 0 4px 6px -1px rgba(0, 0, 0, 0.1), 0 2px 4px -2px rgba(0, 0, 0, 0.1);
            box-shadow: var(--tw-ring-offset-shadow, 0 0 rgba(0, 0, 0, 0)), var(--tw-ring-shadow, 0 0 rgba(0, 0, 0, 0)), var(--tw-shadow);
        }

        .shadow-xl {
            --tw-shadow: 0 20px 25px -5px rgba(0, 0, 0, 0.1), 0 8px 10px -6px rgba(0, 0, 0, 0.1);
            --tw-shadow-colored: 0 20px 25px -5px var(--tw-shadow-color), 0 8px 10px -6px var(--tw-shadow-color);
            box-shadow: 0 0 rgba(0, 0, 0, 0), 0 0 rgba(0, 0, 0, 0), 0 20px 25px -5px rgba(0, 0, 0, 0.1), 0 8px 10px -6px rgba(0, 0, 0, 0.1);
            box-shadow: var(--tw-ring-offset-shadow, 0 0 rgba(0, 0, 0, 0)), var(--tw-ring-shadow, 0 0 rgba(0, 0, 0, 0)), var(--tw-shadow);
        }

        .outline-none {
            outline: 2px solid transparent;
            outline-offset: 2px;
        }

        .outline-0 {
            outline-width: 0px;
        }

        .blur {
            --tw-blur: blur(8px);
            filter: blur(8px) var(--tw-brightness) var(--tw-contrast) var(--tw-grayscale) var(--tw-hue-rotate) var(--tw-invert) var(--tw-saturate) var(--tw-sepia) var(--tw-drop-shadow);
            filter: var(--tw-blur) var(--tw-brightness) var(--tw-contrast) var(--tw-grayscale) var(--tw-hue-rotate) var(--tw-invert) var(--tw-saturate) var(--tw-sepia) var(--tw-drop-shadow);
        }

        .blur-md {
            --tw-blur: blur(12px);
            filter: blur(12px) var(--tw-brightness) var(--tw-contrast) var(--tw-grayscale) var(--tw-hue-rotate) var(--tw-invert) var(--tw-saturate) var(--tw-sepia) var(--tw-drop-shadow);
            filter: var(--tw-blur) var(--tw-brightness) var(--tw-contrast) var(--tw-grayscale) var(--tw-hue-rotate) var(--tw-invert) var(--tw-saturate) var(--tw-sepia) var(--tw-drop-shadow);
        }

        .filter {
            filter: var(--tw-blur) var(--tw-brightness) var(--tw-contrast) var(--tw-grayscale) var(--tw-hue-rotate) var(--tw-invert) var(--tw-saturate) var(--tw-sepia) var(--tw-drop-shadow);
        }

        .backdrop-blur-1 {
            --tw-backdrop-blur: blur(40px);
            -webkit-backdrop-filter: blur(40px) var(--tw-backdrop-brightness) var(--tw-backdrop-contrast) var(--tw-backdrop-grayscale) var(--tw-backdrop-hue-rotate) var(--tw-backdrop-invert) var(--tw-backdrop-opacity) var(--tw-backdrop-saturate) var(--tw-backdrop-sepia);
            backdrop-filter: blur(40px) var(--tw-backdrop-brightness) var(--tw-backdrop-contrast) var(--tw-backdrop-grayscale) var(--tw-backdrop-hue-rotate) var(--tw-backdrop-invert) var(--tw-backdrop-opacity) var(--tw-backdrop-saturate) var(--tw-backdrop-sepia);
            -webkit-backdrop-filter: var(--tw-backdrop-blur) var(--tw-backdrop-brightness) var(--tw-backdrop-contrast) var(--tw-backdrop-grayscale) var(--tw-backdrop-hue-rotate) var(--tw-backdrop-invert) var(--tw-backdrop-opacity) var(--tw-backdrop-saturate) var(--tw-backdrop-sepia);
            backdrop-filter: var(--tw-backdrop-blur) var(--tw-backdrop-brightness) var(--tw-backdrop-contrast) var(--tw-backdrop-grayscale) var(--tw-backdrop-hue-rotate) var(--tw-backdrop-invert) var(--tw-backdrop-opacity) var(--tw-backdrop-saturate) var(--tw-backdrop-sepia);
        }

        .backdrop-blur-sm {
            --tw-backdrop-blur: blur(4px);
            -webkit-backdrop-filter: blur(4px) var(--tw-backdrop-brightness) var(--tw-backdrop-contrast) var(--tw-backdrop-grayscale) var(--tw-backdrop-hue-rotate) var(--tw-backdrop-invert) var(--tw-backdrop-opacity) var(--tw-backdrop-saturate) var(--tw-backdrop-sepia);
            backdrop-filter: blur(4px) var(--tw-backdrop-brightness) var(--tw-backdrop-contrast) var(--tw-backdrop-grayscale) var(--tw-backdrop-hue-rotate) var(--tw-backdrop-invert) var(--tw-backdrop-opacity) var(--tw-backdrop-saturate) var(--tw-backdrop-sepia);
            -webkit-backdrop-filter: var(--tw-backdrop-blur) var(--tw-backdrop-brightness) var(--tw-backdrop-contrast) var(--tw-backdrop-grayscale) var(--tw-backdrop-hue-rotate) var(--tw-backdrop-invert) var(--tw-backdrop-opacity) var(--tw-backdrop-saturate) var(--tw-backdrop-sepia);
            backdrop-filter: var(--tw-backdrop-blur) var(--tw-backdrop-brightness) var(--tw-backdrop-contrast) var(--tw-backdrop-grayscale) var(--tw-backdrop-hue-rotate) var(--tw-backdrop-invert) var(--tw-backdrop-opacity) var(--tw-backdrop-saturate) var(--tw-backdrop-sepia);
        }

        .transition {
            transition-property: color, background-color, border-color, text-decoration-color, fill, stroke, opacity, box-shadow, transform, filter, -webkit-backdrop-filter;
            transition-property: color, background-color, border-color, text-decoration-color, fill, stroke, opacity, box-shadow, transform, filter, backdrop-filter;
            transition-property: color, background-color, border-color, text-decoration-color, fill, stroke, opacity, box-shadow, transform, filter, backdrop-filter, -webkit-backdrop-filter;
            transition-timing-function: cubic-bezier(0.4, 0, 0.2, 1);
            transition-duration: 150ms;
        }

        .transition-all {
            transition-property: all;
            transition-timing-function: cubic-bezier(0.4, 0, 0.2, 1);
            transition-duration: 150ms;
        }

        .transition-transform {
            transition-property: transform;
            transition-timing-function: cubic-bezier(0.4, 0, 0.2, 1);
            transition-duration: 150ms;
        }

        .duration-100 {
            transition-duration: 100ms;
        }

        .duration-150 {
            transition-duration: 150ms;
        }

        .duration-200 {
            transition-duration: 200ms;
        }

        .duration-300 {
            transition-duration: 300ms;
        }

        .duration-500 {
            transition-duration: 500ms;
        }

        .ease-in {
            transition-timing-function: cubic-bezier(0.4, 0, 1, 1);
        }

        .ease-in-out {
            transition-timing-function: cubic-bezier(0.4, 0, 0.2, 1);
        }

        .ease-out {
            transition-timing-function: cubic-bezier(0, 0, 0.2, 1);
        }

        .light,
        [data-theme="light"] {
            --twc-primary-default: 241.20000000000005 100% 50%;
            --twc-primary-hover: 241 100% 65.5%;
            --twc-primary-pressed: 241.20000000000005 100% 69.6%;
            --twc-primary-opacity-1: 241.20000000000005 100% 50%;
            --twc-primary-opacity-1-opacity: 0.16;
            --twc-primary-opacity-2: 241.20000000000005 100% 50%;
            --twc-primary-opacity-2-opacity: 0.24;
            --twc-primary-opacity-3: 241.20000000000005 100% 50%;
            --twc-primary-opacity-3-opacity: 0.32;
            --twc-on-primary: 0 0% 100%;
            --twc-on-primary-opacity-1: 0 0% 100%;
            --twc-on-primary-opacity-1-opacity: 0.40;
            --twc-background-1: 0 0% 100%;
            --twc-background-2: 240 7.1% 94.5%;
            --twc-utility-1-default: 0 0% 14.5%;
            --twc-utility-1-opacity-1: 0 0% 14.5%;
            --twc-utility-1-opacity-1-opacity: 0.72;
            --twc-utility-1-opacity-2: 0 0% 14.5%;
            --twc-utility-1-opacity-2-opacity: 0.48;
            --twc-utility-1-opacity-3: 0 0% 14.5%;
            --twc-utility-1-opacity-3-opacity: 0.24;
            --twc-utility-1-opacity-4: 0 0% 14.5%;
            --twc-utility-1-opacity-4-opacity: 0.12;
            --twc-utility-1-opacity-5: 0 0% 14.5%;
            --twc-utility-1-opacity-5-opacity: 0.08;
            --twc-utility-1-opacity-6: 0 0% 14.5%;
            --twc-utility-1-opacity-6-opacity: 0.04;
            --twc-success-main: 137.5 88.8% 34.9%;
            --twc-success-1-default: 137.3 100% 27.8%;
            --twc-success-1-opacity-1: 137.3 100% 27.8%;
            --twc-success-1-opacity-1-opacity: 0.16;
            --twc-success-1-opacity-2: 137.3 100% 27.8%;
            --twc-success-1-opacity-2-opacity: 0.24;
            --twc-success-1-opacity-3: 137.3 100% 27.8%;
            --twc-success-1-opacity-3-opacity: 0.32;
            --twc-warning-1-default: 41 85.3% 42.7%;
            --twc-warning-1-opacity-1: 41 85.3% 42.7%;
            --twc-warning-1-opacity-1-opacity: 0.16;
            --twc-warning-1-opacity-2: 41 85.3% 42.7%;
            --twc-warning-1-opacity-2-opacity: 0.24;
            --twc-warning-1-opacity-3: 41 85.3% 42.7%;
            --twc-warning-1-opacity-3-opacity: 0.32;
            --twc-error-1-default: 0 81.3% 42%;
            --twc-error-1-hover: 0 63.9% 47.8%;
            --twc-error-1-pressed: 0 58.6% 53.5%;
            --twc-error-1-opacity-1: 0 81.3% 42%;
            --twc-error-1-opacity-1-opacity: 0.16;
            --twc-error-1-opacity-2: 0 81.3% 42%;
            --twc-error-1-opacity-2-opacity: 0.24;
            --twc-error-1-opacity-3: 0 81.3% 42%;
            --twc-error-1-opacity-3-opacity: 0.32;
            --twc-accent-pink: 300.70000000000005 100% 84.1%;
            --twc-accent-neon-green: 82.80000000000001 100% 50%;
            --twc-accent-yellow: 46.69999999999999 100% 56.7%;
            --twc-accent-blue: 194.60000000000002 100% 59%;
            --twc-transparent: 0 0% 0%;
            --twc-transparent-opacity: 0.00;
            --twc-overlay-100: 0 0% 0%;
            --twc-overlay-100-opacity: 0.40;
            --twc-overlay-50: 0 0% 0%;
            --twc-overlay-50-opacity: 0.16;
            --twc-tooltip: 0 0% 96.1%;
            --twc-alert-solid: 137.5 41.4% 88.6%;
            --twc-primary: 241.20000000000005 100% 50%;
            --twc-primaryHover: 241 100% 65.5%;
            --twc-primaryPressed: 241.20000000000005 100% 69.6%;
            --twc-primaryInverse: 241.20000000000005 100% 50%;
            --twc-primaryInverse-opacity: 0.16;
            --twc-textPrimary: 0 0% 14.5%;
            --twc-textPrimaryStatic: 0 0% 14.5%;
            --twc-textSecondary: 0 0% 14.5%;
            --twc-textSecondary-opacity: 0.72;
            --twc-textThird: 0 0% 14.5%;
            --twc-textThird-opacity: 0.48;
            --twc-textBuy: 137.3 100% 27.8%;
            --twc-textSell: 0 81.3% 42%;
            --twc-textDisabled: 0 0% 14.5%;
            --twc-textDisabled-opacity: 0.24;
            --twc-textBrand: 41 85.3% 42.7%;
            --twc-bg3: 240 7.1% 94.5%;
            --twc-backgroundPrimary: 0 0% 100%;
            --twc-backgroundSecondary: 240 7.1% 94.5%;
            --twc-backgroundTertiary: 0 0% 14.5%;
            --twc-backgroundTertiary-opacity: 0.12;
            --twc-successBg: 137.3 100% 27.8%;
            --twc-successBg-opacity: 0.16;
            --twc-errorBg: 0 81.3% 42%;
            --twc-errorBg-opacity: 0.16;
            --twc-depthBuyBg: 241.20000000000005 100% 50%;
            --twc-depthBuyBg-opacity: 0.16;
            --twc-iconNormal: 0 0% 14.5%;
            --twc-iconNormal-opacity: 0.72;
            --twc-iconSuccess: 137.3 100% 27.8%;
            --twc-iconWarning: 41 85.3% 42.7%;
            --twc-error: 0 81.3% 42%;
            --twc-warning: 41 85.3% 42.7%;
            --twc-warning-opacity: 0.16;
            --twc-info: 241.20000000000005 100% 50%;
            --twc-info-opacity: 0.16;
            --twc-success: 137.5 88.8% 34.9%;
            --twc-line: 0 0% 14.5%;
            --twc-line-opacity: 0.08;
            --twc-startGradient: 241.20000000000005 100% 50%;
            --twc-finishGradient: 0 0% 14.5%;
            --twc-finishGradient-opacity: 0.48;
        }

        .dark,
        [data-theme="dark"] {
            --twc-primary-default: 143.89999999999998 100% 64.1%;
            --twc-primary-hover: 144 100% 78.4%;
            --twc-primary-pressed: 143.89999999999998 100% 82.7%;
            --twc-primary-opacity-1: 143.89999999999998 100% 64.1%;
            --twc-primary-opacity-1-opacity: 0.16;
            --twc-primary-opacity-2: 143.89999999999998 100% 64.1%;
            --twc-primary-opacity-2-opacity: 0.24;
            --twc-primary-opacity-3: 143.89999999999998 100% 64.1%;
            --twc-primary-opacity-3-opacity: 0.32;
            --twc-on-primary: 240 1.8% 10.8%;
            --twc-on-primary-opacity-1: 240 1.8% 10.8%;
            --twc-on-primary-opacity-1-opacity: 0.40;
            --twc-background-1: 240 1.8% 10.8%;
            --twc-background-2: 240 2.7% 14.5%;
            --twc-utility-1-default: 216 13.5% 92.7%;
            --twc-utility-1-opacity-1: 216 13.5% 92.7%;
            --twc-utility-1-opacity-1-opacity: 0.72;
            --twc-utility-1-opacity-2: 216 13.5% 92.7%;
            --twc-utility-1-opacity-2-opacity: 0.48;
            --twc-utility-1-opacity-3: 216 13.5% 92.7%;
            --twc-utility-1-opacity-3-opacity: 0.24;
            --twc-utility-1-opacity-4: 216 13.5% 92.7%;
            --twc-utility-1-opacity-4-opacity: 0.12;
            --twc-utility-1-opacity-5: 216 13.5% 92.7%;
            --twc-utility-1-opacity-5-opacity: 0.08;
            --twc-utility-1-opacity-6: 216 13.5% 92.7%;
            --twc-utility-1-opacity-6-opacity: 0.04;
            --twc-success-main: 154.79999999999995 68.9% 44.1%;
            --twc-success-1-default: 154.89999999999998 61.1% 41.4%;
            --twc-success-1-opacity-1: 154.89999999999998 61.1% 41.4%;
            --twc-success-1-opacity-1-opacity: 0.16;
            --twc-success-1-opacity-2: 154.89999999999998 61.1% 41.4%;
            --twc-success-1-opacity-2-opacity: 0.24;
            --twc-success-1-opacity-3: 154.89999999999998 61.1% 41.4%;
            --twc-success-1-opacity-3-opacity: 0.32;
            --twc-warning-1-default: 42 84.9% 53.1%;
            --twc-warning-1-opacity-1: 42 84.9% 53.1%;
            --twc-warning-1-opacity-1-opacity: 0.16;
            --twc-warning-1-opacity-2: 42 84.9% 53.1%;
            --twc-warning-1-opacity-2-opacity: 0.24;
            --twc-warning-1-opacity-3: 42 84.9% 53.1%;
            --twc-warning-1-opacity-3-opacity: 0.32;
            --twc-error-1-default: 0 100% 68%;
            --twc-error-1-hover: 0 100% 71.2%;
            --twc-error-1-pressed: 0 100% 74.5%;
            --twc-error-1-opacity-1: 0 100% 68%;
            --twc-error-1-opacity-1-opacity: 0.16;
            --twc-error-1-opacity-2: 0 100% 68%;
            --twc-error-1-opacity-2-opacity: 0.24;
            --twc-error-1-opacity-3: 0 100% 68%;
            --twc-error-1-opacity-3-opacity: 0.32;
            --twc-accent-pink: 300.70000000000005 100% 84.1%;
            --twc-accent-neon-green: 82.80000000000001 100% 50%;
            --twc-accent-yellow: 46.69999999999999 100% 56.7%;
            --twc-accent-blue: 194.60000000000002 100% 59%;
            --twc-transparent: 0 0% 0%;
            --twc-transparent-opacity: 0.00;
            --twc-overlay-100: 0 0% 37.6%;
            --twc-overlay-100-opacity: 0.40;
            --twc-overlay-50: 0 0% 37.6%;
            --twc-overlay-50-opacity: 0.16;
            --twc-tooltip: 240 1% 20.6%;
            --twc-alert-solid: 157.10000000000002 26.6% 15.5%;
            --twc-primary: 143.89999999999998 100% 64.1%;
            --twc-primaryHover: 144 100% 78.4%;
            --twc-primaryPressed: 143.89999999999998 100% 82.7%;
            --twc-primaryInverse: 143.89999999999998 100% 64.1%;
            --twc-primaryInverse-opacity: 0.16;
            --twc-textPrimary: 216 13.5% 92.7%;
            --twc-textPrimaryStatic: 0 0% 14.5%;
            --twc-textSecondary: 216 13.5% 92.7%;
            --twc-textSecondary-opacity: 0.72;
            --twc-textThird: 216 13.5% 92.7%;
            --twc-textThird-opacity: 0.48;
            --twc-textBuy: 154.89999999999998 61.1% 41.4%;
            --twc-textSell: 0 100% 68%;
            --twc-textDisabled: 216 13.5% 92.7%;
            --twc-textDisabled-opacity: 0.24;
            --twc-textBrand: 42 84.9% 53.1%;
            --twc-bg3: 240 2.7% 14.5%;
            --twc-bg4: 216 13.5% 92.7%;
            --twc-bg4-opacity: 0.48;
            --twc-backgroundPrimary: 240 1.8% 10.8%;
            --twc-backgroundSecondary: 240 2.7% 14.5%;
            --twc-backgroundTertiary: 216 13.5% 92.7%;
            --twc-backgroundTertiary-opacity: 0.12;
            --twc-successBg: 154.89999999999998 61.1% 41.4%;
            --twc-successBg-opacity: 0.16;
            --twc-errorBg: 0 100% 68%;
            --twc-errorBg-opacity: 0.16;
            --twc-depthBuyBg: 143.89999999999998 100% 64.1%;
            --twc-depthBuyBg-opacity: 0.16;
            --twc-iconNormal: 216 13.5% 92.7%;
            --twc-iconNormal-opacity: 0.72;
            --twc-iconSuccess: 154.89999999999998 61.1% 41.4%;
            --twc-iconWarning: 42 84.9% 53.1%;
            --twc-success: 154.79999999999995 68.9% 44.1%;
            --twc-error: 0 100% 68%;
            --twc-warning: 42 84.9% 53.1%;
            --twc-warning-opacity: 0.16;
            --twc-info: 143.89999999999998 100% 64.1%;
            --twc-info-opacity: 0.16;
            --twc-line: 216 13.5% 92.7%;
            --twc-line-opacity: 0.08;
            --twc-startGradient: 143.89999999999998 100% 64.1%;
            --twc-finishGradient: 216 13.5% 92.7%;
            --twc-finishGradient-opacity: 0.48;
        }

        .scrollbar::-webkit-scrollbar-track {
            background-color: var(--scrollbar-track);
            border-radius: var(--scrollbar-track-radius);
        }

        .scrollbar::-webkit-scrollbar-track:hover {
            background-color: var(--scrollbar-track-hover, var(--scrollbar-track));
        }

        .scrollbar::-webkit-scrollbar-track:active {
            background-color: var(--scrollbar-track-active, var(--scrollbar-track-hover, var(--scrollbar-track)));
        }

        .scrollbar::-webkit-scrollbar-thumb {
            background-color: var(--scrollbar-thumb);
            border-radius: var(--scrollbar-thumb-radius);
        }

        .scrollbar::-webkit-scrollbar-thumb:hover {
            background-color: var(--scrollbar-thumb-hover, var(--scrollbar-thumb));
        }

        .scrollbar::-webkit-scrollbar-thumb:active {
            background-color: var(--scrollbar-thumb-active, var(--scrollbar-thumb-hover, var(--scrollbar-thumb)));
        }

        .scrollbar::-webkit-scrollbar-corner {
            background-color: var(--scrollbar-corner);
            border-radius: var(--scrollbar-corner-radius);
        }

        .scrollbar::-webkit-scrollbar-corner:hover {
            background-color: var(--scrollbar-corner-hover, var(--scrollbar-corner));
        }

        .scrollbar::-webkit-scrollbar-corner:active {
            background-color: var(--scrollbar-corner-active, var(--scrollbar-corner-hover, var(--scrollbar-corner)));
        }

        .scrollbar {
            scrollbar-width: auto;
            scrollbar-color: initial initial;
            scrollbar-color: var(--scrollbar-thumb, initial) var(--scrollbar-track, initial);
        }

        .scrollbar::-webkit-scrollbar {
            display: block;
            width: 16px;
            width: var(--scrollbar-width, 16px);
            height: 16px;
            height: var(--scrollbar-height, 16px);
        }

        .word-break {
            word-break: break-word;
        }

        .\*\:-mb-\[18px\]>* {
            margin-bottom: -18px;
        }

        .\*\:whitespace-nowrap>* {
            white-space: nowrap;
        }

        .last-of-type\:\!mb-5:last-of-type {
            margin-bottom: 1.25rem !important;
        }

        .empty\:hidden:empty {
            display: none;
        }

        .data-\[hidden\=true\]\:hidden[data-hidden=true] {
            display: none;
        }

        .data-\[selected\=true\]\:border-primary-default[data-selected=true] {
            --tw-border-opacity: 1;
            border-color: hsl(var(--twc-primary-default) / 1);
            border-color: hsl(var(--twc-primary-default) / var(--twc-primary-default-opacity, var(--tw-border-opacity)));
        }

        .data-\[selected\=\'true\'\]\:bg-bg3[data-selected='true'] {
            --tw-bg-opacity: 1;
            background-color: hsl(var(--twc-bg3) / 1);
            background-color: hsl(var(--twc-bg3) / var(--twc-bg3-opacity, var(--tw-bg-opacity)));
        }

        .data-\[selected\=\'true\'\]\:bg-primary[data-selected='true'] {
            --tw-bg-opacity: 1;
            background-color: hsl(var(--twc-primary) / 1);
            background-color: hsl(var(--twc-primary) / var(--twc-primary-opacity, var(--tw-bg-opacity)));
        }

        .hover\:-translate-x-0:hover {
            --tw-translate-x: -0px;
            transform: translate(-0px, var(--tw-translate-y)) rotate(var(--tw-rotate)) skewX(var(--tw-skew-x)) skewY(var(--tw-skew-y)) scaleX(var(--tw-scale-x)) scaleY(var(--tw-scale-y));
            transform: translate(var(--tw-translate-x), var(--tw-translate-y)) rotate(var(--tw-rotate)) skewX(var(--tw-skew-x)) skewY(var(--tw-skew-y)) scaleX(var(--tw-scale-x)) scaleY(var(--tw-scale-y));
        }

        .hover\:scale-\[1\.01\]:hover {
            --tw-scale-x: 1.01;
            --tw-scale-y: 1.01;
            transform: translate(var(--tw-translate-x), var(--tw-translate-y)) rotate(var(--tw-rotate)) skewX(var(--tw-skew-x)) skewY(var(--tw-skew-y)) scaleX(1.01) scaleY(1.01);
            transform: translate(var(--tw-translate-x), var(--tw-translate-y)) rotate(var(--tw-rotate)) skewX(var(--tw-skew-x)) skewY(var(--tw-skew-y)) scaleX(var(--tw-scale-x)) scaleY(var(--tw-scale-y));
        }

        .hover\:scale-\[1\.02\]:hover {
            --tw-scale-x: 1.02;
            --tw-scale-y: 1.02;
            transform: translate(var(--tw-translate-x), var(--tw-translate-y)) rotate(var(--tw-rotate)) skewX(var(--tw-skew-x)) skewY(var(--tw-skew-y)) scaleX(1.02) scaleY(1.02);
            transform: translate(var(--tw-translate-x), var(--tw-translate-y)) rotate(var(--tw-rotate)) skewX(var(--tw-skew-x)) skewY(var(--tw-skew-y)) scaleX(var(--tw-scale-x)) scaleY(var(--tw-scale-y));
        }

        .hover\:cursor-pointer:hover {
            cursor: pointer;
        }

        .hover\:bg-error-1-hover:hover {
            --tw-bg-opacity: 1;
            background-color: hsl(var(--twc-error-1-hover) / 1);
            background-color: hsl(var(--twc-error-1-hover) / var(--twc-error-1-hover-opacity, var(--tw-bg-opacity)));
        }

        .hover\:bg-error-1-opacity-2:hover {
            --tw-bg-opacity: 1;
            background-color: hsl(var(--twc-error-1-opacity-2) / 1);
            background-color: hsl(var(--twc-error-1-opacity-2) / var(--twc-error-1-opacity-2-opacity, var(--tw-bg-opacity)));
        }

        .hover\:bg-line:hover {
            --tw-bg-opacity: 1;
            background-color: hsl(var(--twc-line) / 1);
            background-color: hsl(var(--twc-line) / var(--twc-line-opacity, var(--tw-bg-opacity)));
        }

        .hover\:bg-primary-hover:hover {
            --tw-bg-opacity: 1;
            background-color: hsl(var(--twc-primary-hover) / 1);
            background-color: hsl(var(--twc-primary-hover) / var(--twc-primary-hover-opacity, var(--tw-bg-opacity)));
        }

        .hover\:bg-primary-opacity-2:hover {
            --tw-bg-opacity: 1;
            background-color: hsl(var(--twc-primary-opacity-2) / 1);
            background-color: hsl(var(--twc-primary-opacity-2) / var(--twc-primary-opacity-2-opacity, var(--tw-bg-opacity)));
        }

        .hover\:bg-utility-1-opacity-5:hover {
            --tw-bg-opacity: 1;
            background-color: hsl(var(--twc-utility-1-opacity-5) / 1);
            background-color: hsl(var(--twc-utility-1-opacity-5) / var(--twc-utility-1-opacity-5-opacity, var(--tw-bg-opacity)));
        }

        .hover\:text-primary:hover {
            --tw-text-opacity: 1;
            color: hsl(var(--twc-primary) / 1);
            color: hsl(var(--twc-primary) / var(--twc-primary-opacity, var(--tw-text-opacity)));
        }

        .hover\:text-textPrimary:hover {
            --tw-text-opacity: 1;
            color: hsl(var(--twc-textPrimary) / 1);
            color: hsl(var(--twc-textPrimary) / var(--twc-textPrimary-opacity, var(--tw-text-opacity)));
        }

        .focus\:outline-none:focus {
            outline: 2px solid transparent;
            outline-offset: 2px;
        }

        .active\:scale-\[0\.9\]:active {
            --tw-scale-x: 0.9;
            --tw-scale-y: 0.9;
            transform: translate(var(--tw-translate-x), var(--tw-translate-y)) rotate(var(--tw-rotate)) skewX(var(--tw-skew-x)) skewY(var(--tw-skew-y)) scaleX(0.9) scaleY(0.9);
            transform: translate(var(--tw-translate-x), var(--tw-translate-y)) rotate(var(--tw-rotate)) skewX(var(--tw-skew-x)) skewY(var(--tw-skew-y)) scaleX(var(--tw-scale-x)) scaleY(var(--tw-scale-y));
        }

        .active\:scale-\[1\.03\]:active {
            --tw-scale-x: 1.03;
            --tw-scale-y: 1.03;
            transform: translate(var(--tw-translate-x), var(--tw-translate-y)) rotate(var(--tw-rotate)) skewX(var(--tw-skew-x)) skewY(var(--tw-skew-y)) scaleX(1.03) scaleY(1.03);
            transform: translate(var(--tw-translate-x), var(--tw-translate-y)) rotate(var(--tw-rotate)) skewX(var(--tw-skew-x)) skewY(var(--tw-skew-y)) scaleX(var(--tw-scale-x)) scaleY(var(--tw-scale-y));
        }

        .active\:bg-error-1-opacity-3:active {
            --tw-bg-opacity: 1;
            background-color: hsl(var(--twc-error-1-opacity-3) / 1);
            background-color: hsl(var(--twc-error-1-opacity-3) / var(--twc-error-1-opacity-3-opacity, var(--tw-bg-opacity)));
        }

        .active\:bg-error-1-pressed:active {
            --tw-bg-opacity: 1;
            background-color: hsl(var(--twc-error-1-pressed) / 1);
            background-color: hsl(var(--twc-error-1-pressed) / var(--twc-error-1-pressed-opacity, var(--tw-bg-opacity)));
        }

        .active\:bg-primary-opacity-3:active {
            --tw-bg-opacity: 1;
            background-color: hsl(var(--twc-primary-opacity-3) / 1);
            background-color: hsl(var(--twc-primary-opacity-3) / var(--twc-primary-opacity-3-opacity, var(--tw-bg-opacity)));
        }

        .active\:bg-primary-pressed:active {
            --tw-bg-opacity: 1;
            background-color: hsl(var(--twc-primary-pressed) / 1);
            background-color: hsl(var(--twc-primary-pressed) / var(--twc-primary-pressed-opacity, var(--tw-bg-opacity)));
        }

        .active\:bg-utility-1-opacity-4:active {
            --tw-bg-opacity: 1;
            background-color: hsl(var(--twc-utility-1-opacity-4) / 1);
            background-color: hsl(var(--twc-utility-1-opacity-4) / var(--twc-utility-1-opacity-4-opacity, var(--tw-bg-opacity)));
        }

        .disabled\:bg-error-1-opacity-1:disabled {
            --tw-bg-opacity: 1;
            background-color: hsl(var(--twc-error-1-opacity-1) / 1);
            background-color: hsl(var(--twc-error-1-opacity-1) / var(--twc-error-1-opacity-1-opacity, var(--tw-bg-opacity)));
        }

        .disabled\:bg-primary-opacity-1:disabled {
            --tw-bg-opacity: 1;
            background-color: hsl(var(--twc-primary-opacity-1) / 1);
            background-color: hsl(var(--twc-primary-opacity-1) / var(--twc-primary-opacity-1-opacity, var(--tw-bg-opacity)));
        }

        .disabled\:bg-primary-pressed:disabled {
            --tw-bg-opacity: 1;
            background-color: hsl(var(--twc-primary-pressed) / 1);
            background-color: hsl(var(--twc-primary-pressed) / var(--twc-primary-pressed-opacity, var(--tw-bg-opacity)));
        }

        @media (min-width: 768px) {

            .md\:order-1 {
                order: 1;
            }

            .md\:order-2 {
                order: 2;
            }

            .md\:col-span-4 {
                grid-column: span 4 / span 4;
            }

            .md\:col-span-5 {
                grid-column: span 5 / span 5;
            }

            .md\:col-span-6 {
                grid-column: span 6 / span 6;
            }

            .md\:col-span-7 {
                grid-column: span 7 / span 7;
            }

            .md\:col-span-8 {
                grid-column: span 8 / span 8;
            }

            .md\:h-\[7rem\] {
                height: 7rem;
            }

            .md\:w-\[7rem\] {
                width: 7rem;
            }

            .md\:max-w-\[438px\] {
                max-width: 438px;
            }

            .md\:max-w-\[962px\] {
                max-width: 962px;
            }

            .md\:grid-cols-12 {
                grid-template-columns: repeat(12, minmax(0, 1fr));
            }

            .md\:justify-end {
                justify-content: flex-end;
            }

            .md\:border-r {
                border-right-width: 1px;
            }

            .md\:border-line {
                --tw-border-opacity: 1;
                border-color: hsl(var(--twc-line) / 1);
                border-color: hsl(var(--twc-line) / var(--twc-line-opacity, var(--tw-border-opacity)));
            }

            .md\:pr-4 {
                padding-right: 16px;
            }
        }

        @media (max-width: 500px) {

            .sm-max\:\!w-full {
                width: 100% !important;
            }
        }

        @media (max-width: 925px) {

            .lg-max\:mb-6 {
                margin-bottom: 24px;
            }

            .lg-max\:h-\[180px\] {
                height: 180px;
            }

            .lg-max\:h-\[709px\] {
                height: 709px;
            }

            .lg-max\:w-\[488px\] {
                width: 488px;
            }

            .lg-max\:w-full {
                width: 100%;
            }

            .lg-max\:w-min {
                width: -moz-min-content;
                width: min-content;
            }

            .lg-max\:flex-col {
                flex-direction: column;
            }
        }

        @media (min-width: 926px) {

            .lg-min\:h-\[312px\] {
                height: 312px;
            }

            .lg-min\:h-\[320px\] {
                height: 320px;
            }

            .lg-min\:h-\[497px\] {
                height: 497px;
            }

            .lg-min\:h-\[540px\] {
                height: 540px;
            }

            .lg-min\:w-\[342px\] {
                width: 342px;
            }

            .lg-min\:w-\[925px\] {
                width: 925px;
            }

            .lg-min\:max-w-\[925px\] {
                max-width: 925px;
            }
        }

        @media (prefers-color-scheme: dark) {

            .dark\:text-black {
                --tw-text-opacity: 1;
                color: rgba(0, 0, 0, 1);
                color: rgba(0, 0, 0, var(--tw-text-opacity));
            }
        }

        .\[\&\>\*\:last-child\]\:ml-auto>*:last-child {
            margin-left: auto;
        }

        .\[\&\>\*\:not\(\:first-child\)\]\:ml-4>*:not(:first-child) {
            margin-left: 16px;
        }

        .\[\&_\*\]\:invisible * {
            visibility: hidden;
        }
    </style>
    <style id="_goober">
        @keyframes go2264125279 {
            from {
                transform: scale(0) rotate(45deg);
                opacity: 0;
            }

            to {
                transform: scale(1) rotate(45deg);
                opacity: 1;
            }
        }

        @keyframes go3020080000 {
            from {
                transform: scale(0);
                opacity: 0;
            }

            to {
                transform: scale(1);
                opacity: 1;
            }
        }

        @keyframes go463499852 {
            from {
                transform: scale(0) rotate(90deg);
                opacity: 0;
            }

            to {
                transform: scale(1) rotate(90deg);
                opacity: 1;
            }
        }

        @keyframes go1268368563 {
            from {
                transform: rotate(0deg);
            }

            to {
                transform: rotate(360deg);
            }
        }

        @keyframes go1310225428 {
            from {
                transform: scale(0) rotate(45deg);
                opacity: 0;
            }

            to {
                transform: scale(1) rotate(45deg);
                opacity: 1;
            }
        }

        @keyframes go651618207 {
            0% {
                height: 0;
                width: 0;
                opacity: 0;
            }

            40% {
                height: 0;
                width: 6px;
                opacity: 1;
            }

            100% {
                opacity: 1;
                height: 10px;
            }
        }

        @keyframes go901347462 {
            from {
                transform: scale(0.6);
                opacity: 0.4;
            }

            to {
                transform: scale(1);
                opacity: 1;
            }
        }

        .go4109123758 {
            z-index: 9999;
        }

        .go4109123758>* {
            pointer-events: auto;
        }
    </style>
</head>

<body style="width: auto; height: auto; margin: 0">
    <div id="root" data-id="root">
        <div id="_rht_toaster" class="p-0" style="position: fixed; z-index: 9999; inset: 16px; pointer-events: none;">
        </div>
        <div class="flex flex-col relative">
            <div class="flex w-full">
                <div class="w-1/3 flex flex-col min-h-screen sticky top-0 items-center min-w-[400px] mr-4"
                    style="background: linear-gradient(106deg, rgb(222, 226, 246) 22.98%, rgb(255, 255, 255) 99.14%), rgb(217, 217, 217);">
                    <div class="flex flex-col h-[800px] w-[305px]">
                        <div class="w-full mt-8 mb-16"><svg width="222" height="34" viewBox="0 0 222 34" fill="none"
                                xmlns="http://www.w3.org/2000/svg">
                                <path d="M0 4.98172L15.3947 0V34.4869C4.39832 29.8882 0 21.075 0 16.0943V4.98172Z"
                                    fill="#0500FF"></path>
                                <path
                                    d="M30.7892 4.98172L15.3945 0V34.4869C26.3909 29.8882 30.7892 21.075 30.7892 16.0943V4.98172Z"
                                    fill="url(#paint0_linear_6705_256559)"></path>
                                <path
                                    d="M57.8281 8.13672H63.9338V11.5417C65.9342 8.48157 68.2362 8.13672 71.6061 8.13672V14.154H70.0714C66.0333 14.154 64.1 16.0459 64.1 19.7936V26.1898H57.8281V8.13672Z"
                                    fill="#0500FF"></path>
                                <path
                                    d="M91.9754 26.1898H85.7046V24.4687C84.3351 26.0508 82.469 26.7383 80.1681 26.7383C75.7985 26.7383 73.3281 24.1589 73.3281 19.4148V8.13672H79.599V18.0068C79.599 20.2403 80.6999 21.5465 82.5671 21.5465C84.4342 21.5465 85.7035 20.2732 85.7035 18.1087V8.13672H91.9744V26.1898H91.9754Z"
                                    fill="#0500FF"></path>
                                <path
                                    d="M93.5078 20.6147H99.3811C99.6486 21.9209 100.549 22.4705 102.716 22.4705C104.485 22.4705 105.519 22.0588 105.519 21.3023C105.519 20.7166 105.018 20.3378 103.585 20.029L98.8482 18.9626C95.6787 18.2422 94.0769 16.4192 94.0769 13.4949C94.0769 9.64219 96.9118 7.64844 102.416 7.64844C107.921 7.64844 110.623 9.59125 111.092 13.7538H105.254C105.155 12.6546 104.019 11.9818 102.152 11.9818C100.651 11.9818 99.6859 12.4625 99.6859 13.1862C99.6859 13.8048 100.318 14.2854 101.588 14.5974L106.558 15.8017C109.826 16.5911 111.396 18.2432 111.396 20.9245C111.396 24.6393 108.16 26.84 102.658 26.84C97.1569 26.84 93.5174 24.4674 93.5174 20.6147H93.511H93.5078Z"
                                    fill="#0500FF"></path>
                                <path
                                    d="M128.096 13.7519V8.13672H112.617V13.7551H117.236V26.1898H123.475V13.7519H128.096Z"
                                    fill="#0500FF"></path>
                                <path
                                    d="M56.0833 13.7519V8.13672H40.6055V13.7551H45.2244V26.1898H51.4643V13.7519H56.0833Z"
                                    fill="#0500FF"></path>
                                <path
                                    d="M137.532 25.8667L132.715 8.25H134.883L138.564 22.598H138.736L142.487 8.25H144.895L148.646 22.598H148.818L152.499 8.25H154.667L149.85 25.8667H147.648L143.76 11.8284H143.622L139.734 25.8667H137.532Z"
                                    fill="#0500FF"></path>
                                <path
                                    d="M155.949 25.8667H153.712L160.181 8.25H162.383L168.852 25.8667H166.615L164.843 20.8776H157.721L155.949 25.8667ZM158.392 18.9852H164.172L161.351 11.037H161.213L158.392 18.9852Z"
                                    fill="#0500FF"></path>
                                <path d="M170.869 25.8667V8.25H173.002V23.9743H181.191V25.8667H170.869Z" fill="#0500FF">
                                </path>
                                <path d="M183.768 25.8667V8.25H185.901V23.9743H194.09V25.8667H183.768Z" fill="#0500FF">
                                </path>
                                <path
                                    d="M196.667 25.8667V8.25H207.299V10.1424H198.8V16.0949H206.748V17.9873H198.8V23.9743H207.436V25.8667H196.667Z"
                                    fill="#0500FF"></path>
                                <path d="M209.454 10.1424V8.25H222.666V10.1424H217.127V25.8667H214.993V10.1424H209.454Z"
                                    fill="#0500FF"></path>
                                <defs>
                                    <linearGradient id="paint0_linear_6705_256559" x1="25.4885" y1="0.42534" x2="15.896"
                                        y2="34.5112" gradientUnits="userSpaceOnUse">
                                        <stop stop-color="#48FF91"></stop>
                                        <stop offset="1" stop-color="#0500FF"></stop>
                                    </linearGradient>
                                </defs>
                            </svg></div>
                        <div class="h-6 mb-6">
                            <p class="body-text text-textSecondary font-medium   text-unset   ">Step 2 of 3</p>
                        </div>
                        <h2 data-testid="onboarding-step-title"
                            class="screamer-text text-utility-1-default font-semibold   text-unset   ">Import a wallet
                        </h2>
                        <div class="w-[200px] h-[200px] mt-[120px] ">
                            <div style="width: 150%; height: 150%;"><svg xmlns="http://www.w3.org/2000/svg"
                                    xmlns:xlink="http://www.w3.org/1999/xlink" viewBox="0 0 1080 1080" width="1080"
                                    height="1080" preserveAspectRatio="xMidYMid meet"
                                    style="width: 100%; height: 100%; transform: translate3d(0px, 0px, 0px); content-visibility: visible;">
                                    <defs>
                                        <clipPath id="__lottie_element_422">
                                            <rect width="1080" height="1080" x="0" y="0"></rect>
                                        </clipPath>
                                        <linearGradient id="__lottie_element_426" spreadMethod="pad"
                                            gradientUnits="userSpaceOnUse" x1="-19.617000579833984"
                                            y1="-6.392000198364258" x2="23.047000885009766" y2="4.382999897003174">
                                            <stop offset="6%" stop-color="rgb(255,244,101)"></stop>
                                            <stop offset="42%" stop-color="rgb(163,250,123)"></stop>
                                            <stop offset="78%" stop-color="rgb(72,255,145)"></stop>
                                        </linearGradient>
                                        <linearGradient id="__lottie_element_427" spreadMethod="pad"
                                            gradientUnits="userSpaceOnUse" x1="-19.731000900268555"
                                            y1="-6.861000061035156" x2="22.93199920654297" y2="3.9140000343322754">
                                            <stop offset="6%" stop-color="rgb(255,244,101)"></stop>
                                            <stop offset="42%" stop-color="rgb(163,250,123)"></stop>
                                            <stop offset="78%" stop-color="rgb(72,255,145)"></stop>
                                        </linearGradient>
                                        <linearGradient id="__lottie_element_428" spreadMethod="pad"
                                            gradientUnits="userSpaceOnUse" x1="-20.06800079345703"
                                            y1="-6.5320000648498535" x2="22.594999313354492" y2="4.243000030517578">
                                            <stop offset="6%" stop-color="rgb(255,244,101)"></stop>
                                            <stop offset="42%" stop-color="rgb(163,250,123)"></stop>
                                            <stop offset="78%" stop-color="rgb(72,255,145)"></stop>
                                        </linearGradient>
                                        <linearGradient id="__lottie_element_429" spreadMethod="pad"
                                            gradientUnits="userSpaceOnUse" x1="-19.30299949645996"
                                            y1="-6.718999862670898" x2="23.360000610351562" y2="4.056000232696533">
                                            <stop offset="6%" stop-color="rgb(255,244,101)"></stop>
                                            <stop offset="42%" stop-color="rgb(163,250,123)"></stop>
                                            <stop offset="78%" stop-color="rgb(72,255,145)"></stop>
                                        </linearGradient>
                                        <linearGradient id="__lottie_element_430" spreadMethod="pad"
                                            gradientUnits="userSpaceOnUse" x1="-19.639999389648438"
                                            y1="-6.390999794006348" x2="23.023000717163086" y2="4.383999824523926">
                                            <stop offset="6%" stop-color="rgb(255,244,101)"></stop>
                                            <stop offset="42%" stop-color="rgb(163,250,123)"></stop>
                                            <stop offset="78%" stop-color="rgb(72,255,145)"></stop>
                                        </linearGradient>
                                        <linearGradient id="__lottie_element_431" spreadMethod="pad"
                                            gradientUnits="userSpaceOnUse" x1="-19.7549991607666"
                                            y1="-6.860000133514404" x2="22.909000396728516" y2="3.9149999618530273">
                                            <stop offset="6%" stop-color="rgb(255,244,101)"></stop>
                                            <stop offset="42%" stop-color="rgb(163,250,123)"></stop>
                                            <stop offset="78%" stop-color="rgb(72,255,145)"></stop>
                                        </linearGradient>
                                        <linearGradient id="__lottie_element_432" spreadMethod="pad"
                                            gradientUnits="userSpaceOnUse" x1="-38.71099853515625"
                                            y1="-12.47599983215332" x2="44.887001037597656" y2="8.63700008392334">
                                            <stop offset="6%" stop-color="rgb(255,244,101)"></stop>
                                            <stop offset="42%" stop-color="rgb(163,250,123)"></stop>
                                            <stop offset="78%" stop-color="rgb(72,255,145)"></stop>
                                        </linearGradient>
                                        <linearGradient id="__lottie_element_433" spreadMethod="pad"
                                            gradientUnits="userSpaceOnUse" x1="-38.44900131225586"
                                            y1="-12.640999794006348" x2="45.12099838256836" y2="8.465999603271484">
                                            <stop offset="6%" stop-color="rgb(255,244,101)"></stop>
                                            <stop offset="42%" stop-color="rgb(163,250,123)"></stop>
                                            <stop offset="78%" stop-color="rgb(72,255,145)"></stop>
                                        </linearGradient>
                                        <linearGradient id="__lottie_element_434" spreadMethod="pad"
                                            gradientUnits="userSpaceOnUse" x1="-38.209999084472656"
                                            y1="-12.812999725341797" x2="45.38199996948242" y2="8.298999786376953">
                                            <stop offset="6%" stop-color="rgb(255,244,101)"></stop>
                                            <stop offset="42%" stop-color="rgb(163,250,123)"></stop>
                                            <stop offset="78%" stop-color="rgb(72,255,145)"></stop>
                                        </linearGradient>
                                        <linearGradient id="__lottie_element_435" spreadMethod="pad"
                                            gradientUnits="userSpaceOnUse" x1="-37.93199920654297"
                                            y1="-12.972999572753906" x2="45.604000091552734" y2="8.12399959564209">
                                            <stop offset="6%" stop-color="rgb(255,244,101)"></stop>
                                            <stop offset="42%" stop-color="rgb(163,250,123)"></stop>
                                            <stop offset="78%" stop-color="rgb(72,255,145)"></stop>
                                        </linearGradient>
                                        <linearGradient id="__lottie_element_436" spreadMethod="pad"
                                            gradientUnits="userSpaceOnUse" x1="-37.915000915527344"
                                            y1="-12.347999572753906" x2="45.64400100708008" y2="8.755000114440918">
                                            <stop offset="6%" stop-color="rgb(255,244,101)"></stop>
                                            <stop offset="42%" stop-color="rgb(163,250,123)"></stop>
                                            <stop offset="78%" stop-color="rgb(72,255,145)"></stop>
                                        </linearGradient>
                                        <linearGradient id="__lottie_element_437" spreadMethod="pad"
                                            gradientUnits="userSpaceOnUse" x1="9.418999671936035" y1="42.15599822998047"
                                            x2="-12.291999816894531" y2="-34.856998443603516">
                                            <stop offset="6%" stop-color="rgb(255,244,101)"></stop>
                                            <stop offset="42%" stop-color="rgb(163,250,123)"></stop>
                                            <stop offset="78%" stop-color="rgb(72,255,145)"></stop>
                                        </linearGradient>
                                        <linearGradient id="__lottie_element_438" spreadMethod="pad"
                                            gradientUnits="userSpaceOnUse" x1="6.698999881744385"
                                            y1="-12.586000442504883" x2="-4.0920000076293945" y2="8.6899995803833">
                                            <stop offset="6%" stop-color="rgb(255,244,101)"></stop>
                                            <stop offset="42%" stop-color="rgb(163,250,123)"></stop>
                                            <stop offset="78%" stop-color="rgb(72,255,145)"></stop>
                                        </linearGradient>
                                        <linearGradient id="__lottie_element_439" spreadMethod="pad"
                                            gradientUnits="userSpaceOnUse" x1="7.421999931335449" y1="3.385999917984009"
                                            x2="0.9020000100135803" y2="-6.01800012588501">
                                            <stop offset="6%" stop-color="rgb(255,244,101)"></stop>
                                            <stop offset="42%" stop-color="rgb(163,250,123)"></stop>
                                            <stop offset="78%" stop-color="rgb(72,255,145)"></stop>
                                        </linearGradient>
                                        <g id="__lottie_element_443">
                                            <g id="2957" transform="matrix(1,0,0,1,540,528.0960083007812)" opacity="1"
                                                style="display: block;">
                                                <g opacity="1" transform="matrix(1,0,0,1,0,0)">
                                                    <g opacity="1"
                                                        transform="matrix(1,0,0,1,127.48500061035156,-52.97200012207031)">
                                                        <path fill="rgb(27,27,27)" fill-opacity="1"
                                                            d=" M219.66799926757812,-89.48600006103516 C222.156005859375,-88.5780029296875 223.67999267578125,-85.73999786376953 223.05999755859375,-83.18000030517578 C223.05999755859375,-83.18000030517578 151.08399963378906,219.3560028076172 151.08399963378906,219.3560028076172 C150.47999572753906,221.91600036621094 147.94400024414062,223.2760009765625 145.4720001220703,222.3800048828125 C145.4720001220703,222.3800048828125 -219.66900634765625,89.48400115966797 -219.66900634765625,89.48400115966797 C-222.1529998779297,88.57599639892578 -223.6790008544922,85.73999786376953 -223.06100463867188,83.18099975585938 C-223.06100463867188,83.18099975585938 -151.08399963378906,-219.35400390625 -151.08399963378906,-219.35400390625 C-150.47900390625,-221.91400146484375 -147.94500732421875,-223.2760009765625 -145.47300720214844,-222.3800048828125 C-145.47300720214844,-222.3800048828125 219.66799926757812,-89.48600006103516 219.66799926757812,-89.48600006103516z">
                                                        </path>
                                                    </g>
                                                </g>
                                            </g>
                                        </g>
                                        <mask id="__lottie_element_443_1" mask-type="alpha">
                                            <use xlink:href="#__lottie_element_443"></use>
                                        </mask>
                                        <clipPath id="__lottie_element_453">
                                            <path d="M0,0 L540,0 L540,540 L0,540z"></path>
                                        </clipPath>
                                        <g id="__lottie_element_456">
                                            <g id="2839"
                                                transform="matrix(-0.4414737820625305,0.23473578691482544,0.23473578691482544,0.4414737820625305,249,315)"
                                                opacity="1" style="display: block;">
                                                <g opacity="1" transform="matrix(1,0,0,1,0,0)">
                                                    <path fill="rgb(27,27,27)" fill-opacity="1"
                                                        d=" M-109.25399780273438,-45.207000732421875 C-115.23799896240234,-42.097999572753906 -120.15699768066406,-34.24599838256836 -120.19200134277344,-27.783000946044922 C-120.19200134277344,-27.783000946044922 -120.77799987792969,114.73100280761719 -120.77799987792969,114.73100280761719 C-120.80000305175781,121.1969985961914 -118.64800262451172,118.83399963378906 -112.65299987792969,115.72799682617188 C-112.65299987792969,115.72799682617188 10.552000045776367,51.65700149536133 10.552000045776367,51.65700149536133 C16.53499984741211,48.547000885009766 24.174999237060547,45.8120002746582 24.19700050354004,39.34600067138672 C24.19700050354004,39.34600067138672 24.7810001373291,-103.23600006103516 24.7810001373291,-103.23600006103516 C24.804000854492188,-109.7020034790039 19.93899917602539,-112.44000244140625 13.956000328063965,-109.33100128173828 C13.956000328063965,-109.33100128173828 -109.25399780273438,-45.207000732421875 -109.25399780273438,-45.207000732421875z">
                                                    </path>
                                                    <path stroke-linecap="round" stroke-linejoin="round"
                                                        fill-opacity="0" stroke="rgb(4,0,255)" stroke-opacity="1"
                                                        stroke-width="2"
                                                        d=" M-109.25399780273438,-45.207000732421875 C-115.23799896240234,-42.097999572753906 -120.15699768066406,-34.24599838256836 -120.19200134277344,-27.783000946044922 C-120.19200134277344,-27.783000946044922 -120.77799987792969,114.73100280761719 -120.77799987792969,114.73100280761719 C-120.80000305175781,121.1969985961914 -118.64800262451172,118.83399963378906 -112.65299987792969,115.72799682617188 C-112.65299987792969,115.72799682617188 10.552000045776367,51.65700149536133 10.552000045776367,51.65700149536133 C16.53499984741211,48.547000885009766 24.174999237060547,45.8120002746582 24.19700050354004,39.34600067138672 C24.19700050354004,39.34600067138672 24.7810001373291,-103.23600006103516 24.7810001373291,-103.23600006103516 C24.804000854492188,-109.7020034790039 19.93899917602539,-112.44000244140625 13.956000328063965,-109.33100128173828 C13.956000328063965,-109.33100128173828 -109.25399780273438,-45.207000732421875 -109.25399780273438,-45.207000732421875z">
                                                    </path>
                                                </g>
                                            </g>
                                        </g>
                                        <mask id="__lottie_element_456_1" mask-type="alpha">
                                            <use xlink:href="#__lottie_element_456"></use>
                                        </mask>
                                        <linearGradient id="__lottie_element_468" spreadMethod="pad"
                                            gradientUnits="userSpaceOnUse" x1="-165.68699645996094"
                                            y1="147.22000122070312" x2="-362.30999755859375" y2="62.84400177001953">
                                            <stop offset="6%" stop-color="rgb(255,244,101)"></stop>
                                            <stop offset="42%" stop-color="rgb(163,250,123)"></stop>
                                            <stop offset="78%" stop-color="rgb(72,255,145)"></stop>
                                        </linearGradient>
                                        <linearGradient id="__lottie_element_475" spreadMethod="pad"
                                            gradientUnits="userSpaceOnUse" x1="-473" y1="-207.12100219726562"
                                            x2="-97.31099700927734" y2="-504.7860107421875">
                                            <stop offset="6%" stop-color="rgb(255,244,101)"></stop>
                                            <stop offset="42%" stop-color="rgb(163,250,123)"></stop>
                                            <stop offset="78%" stop-color="rgb(72,255,145)"></stop>
                                        </linearGradient>
                                        <g id="__lottie_element_479">
                                            <g id="2832"
                                                transform="matrix(-0.4414737820625305,0.23473578691482544,0.23473578691482544,0.4414737820625305,236.95799255371094,265.29998779296875)"
                                                opacity="1" style="display: block;">
                                                <g opacity="1" transform="matrix(1,0,0,1,0,0)">
                                                    <path fill="rgb(27,27,27)" fill-opacity="1"
                                                        d=" M-178.73199462890625,-4.696000099182129 C-178.73199462890625,-4.696000099182129 -178.01699829101562,-210.17999267578125 -178.01699829101562,-210.17999267578125 C-177.99000549316406,-218.697998046875 -175.27000427246094,-224.3820037841797 -170.86900329589844,-226.697998046875 C-163.32699584960938,-230.66799926757812 -157.8300018310547,-229.0070037841797 -147.6820068359375,-226.84500122070312 C-147.6820068359375,-226.84500122070312 176.20700073242188,-153.1929931640625 176.20700073242188,-153.1929931640625 C176.20700073242188,-153.1929931640625 178.75100708007812,229.10499572753906 178.75100708007812,229.10499572753906 C178.75100708007812,229.10499572753906 -157.00100708007812,150.98500061035156 -157.00100708007812,150.98500061035156 C-169.73899841308594,148.0229949951172 -178.7530059814453,136.66799926757812 -178.75100708007812,123.58899688720703 C-178.75100708007812,123.58899688720703 -178.73199462890625,-4.696000099182129 -178.73199462890625,-4.696000099182129z">
                                                    </path>
                                                </g>
                                            </g>
                                        </g>
                                        <linearGradient id="__lottie_element_485" spreadMethod="pad"
                                            gradientUnits="userSpaceOnUse" x1="-194.25399780273438" y1="-301.5"
                                            x2="49.33599853515625" y2="34.84000015258789">
                                            <stop offset="0%" stop-color="rgb(255,255,255)" stop-opacity="0"></stop>
                                            <stop offset="50%" stop-color="rgb(255,255,255)" stop-opacity="0.5"></stop>
                                            <stop offset="100%" stop-color="rgb(255,255,255)" stop-opacity="1"></stop>
                                        </linearGradient>
                                        <mask id="__lottie_element_479_1" mask-type="alpha">
                                            <use xlink:href="#__lottie_element_479"></use>
                                        </mask>
                                        <g id="__lottie_element_486">
                                            <g id="2830"
                                                transform="matrix(-0.4414737820625305,0.23473578691482544,0.23473578691482544,0.4414737820625305,236.95799255371094,265.29998779296875)"
                                                opacity="1" style="display: block;">
                                                <g opacity="1" transform="matrix(1,0,0,1,0,0)">
                                                    <path fill="rgb(27,27,27)" fill-opacity="1"
                                                        d=" M-178.73199462890625,-4.696000099182129 C-178.73199462890625,-4.696000099182129 -178.01699829101562,-210.17999267578125 -178.01699829101562,-210.17999267578125 C-177.99000549316406,-218.697998046875 -175.27000427246094,-224.3820037841797 -170.86900329589844,-226.697998046875 C-163.32699584960938,-230.66799926757812 -157.8300018310547,-229.0070037841797 -147.6820068359375,-226.84500122070312 C-147.6820068359375,-226.84500122070312 176.20700073242188,-153.1929931640625 176.20700073242188,-153.1929931640625 C176.20700073242188,-153.1929931640625 178.75100708007812,229.10499572753906 178.75100708007812,229.10499572753906 C178.75100708007812,229.10499572753906 -157.00100708007812,150.98500061035156 -157.00100708007812,150.98500061035156 C-169.73899841308594,148.0229949951172 -178.7530059814453,136.66799926757812 -178.75100708007812,123.58899688720703 C-178.75100708007812,123.58899688720703 -178.73199462890625,-4.696000099182129 -178.73199462890625,-4.696000099182129z">
                                                    </path>
                                                </g>
                                            </g>
                                        </g>
                                        <mask id="__lottie_element_486_1" mask-type="alpha">
                                            <use xlink:href="#__lottie_element_486"></use>
                                        </mask>
                                        <g id="__lottie_element_495">
                                            <g id="2855" transform="matrix(1,0,0,1,540,528.0960083007812)" opacity="1"
                                                style="display: block;">
                                                <g opacity="1" transform="matrix(1,0,0,1,0,0)">
                                                    <g opacity="1"
                                                        transform="matrix(1,0,0,1,127.48500061035156,-52.97200012207031)">
                                                        <path fill="rgb(182,54,87)" fill-opacity="1"
                                                            d=" M219.66799926757812,-89.48600006103516 C222.156005859375,-88.5780029296875 223.67999267578125,-85.73999786376953 223.05999755859375,-83.18000030517578 C223.05999755859375,-83.18000030517578 151.08399963378906,219.3560028076172 151.08399963378906,219.3560028076172 C150.47999572753906,221.91600036621094 147.94400024414062,223.2760009765625 145.4720001220703,222.3800048828125 C145.4720001220703,222.3800048828125 106.33100128173828,678.4840087890625 106.33100128173828,678.4840087890625 C103.84600067138672,677.5759887695312 -798.6790161132812,686.739990234375 -798.0609741210938,684.1810302734375 C-798.0609741210938,684.1810302734375 -723.083984375,-500.35400390625 -723.083984375,-500.35400390625 C-722.47900390625,-502.91400146484375 -92.94499969482422,-546.2760009765625 -90.4729995727539,-545.3800048828125 C-90.4729995727539,-545.3800048828125 -85.99199676513672,-200.73199462890625 -85.99199676513672,-200.73199462890625 C-85.99199676513672,-200.73199462890625 219.66799926757812,-89.48600006103516 219.66799926757812,-89.48600006103516z">
                                                        </path>
                                                    </g>
                                                </g>
                                            </g>
                                        </g>
                                        <linearGradient id="__lottie_element_501" spreadMethod="pad"
                                            gradientUnits="userSpaceOnUse" x1="-215.41900634765625"
                                            y1="-84.56300354003906" x2="327.1400146484375" y2="132.66600036621094">
                                            <stop offset="0%" stop-color="rgb(255,174,254)"></stop>
                                            <stop offset="49%" stop-color="rgb(255,207,180)"></stop>
                                            <stop offset="97%" stop-color="rgb(255,239,106)"></stop>
                                            <stop offset="99%" stop-color="rgb(255,242,104)"></stop>
                                            <stop offset="100%" stop-color="rgb(255,244,101)"></stop>
                                        </linearGradient>
                                        <linearGradient id="__lottie_element_502" spreadMethod="pad"
                                            gradientUnits="userSpaceOnUse" x1="46.88600158691406"
                                            y1="1.2309999465942383" x2="87.9260025024414" y2="5.868000030517578">
                                            <stop offset="0%" stop-color="rgb(255,174,254)"></stop>
                                            <stop offset="49%" stop-color="rgb(255,207,180)"></stop>
                                            <stop offset="97%" stop-color="rgb(255,239,106)"></stop>
                                            <stop offset="99%" stop-color="rgb(255,242,104)"></stop>
                                            <stop offset="100%" stop-color="rgb(255,244,101)"></stop>
                                        </linearGradient>
                                        <mask id="__lottie_element_495_1" mask-type="alpha">
                                            <use xlink:href="#__lottie_element_495"></use>
                                        </mask>
                                        <linearGradient id="__lottie_element_512" spreadMethod="pad"
                                            gradientUnits="userSpaceOnUse" x1="-102.04299926757812"
                                            y1="-215.99200439453125" x2="186.53500366210938" y2="221.16799926757812">
                                            <stop offset="0%" stop-color="rgb(252,243,124)"></stop>
                                            <stop offset="50%" stop-color="rgb(247,210,186)"></stop>
                                            <stop offset="100%" stop-color="rgb(243,178,249)"></stop>
                                        </linearGradient>
                                    </defs>
                                    <g clip-path="url(#__lottie_element_422)">
                                        <g id="2856" transform="matrix(1,0,0,1,540,528.0960083007812)" opacity="1"
                                            style="display: block;">
                                            <path fill="rgb(255,0,0)" fill-opacity="1"
                                                d=" M-31.59,-275.61 C-29.3,-285.25 -21.72,-289.57 -14.29,-286.85 C-14.29,-286.85 349.01,-154.62 349.01,-154.62 C356.43,-151.92 361.19,-143.94 358.71,-133.53 C358.71,-133.53 285.11,175.79 285.11,175.79 C283.29,183.48 275.72,187.55 268.29,184.85 C268.29,184.85 -95.01,52.61 -95.01,52.61 C-102.44,49.92 -107.01,41.42 -105.19,33.72 C-105.19,33.72 -31.59,-275.6 -31.59,-275.6 C-31.59,-275.6 -31.59,-275.61 -31.59,-275.61z M347.15,-142.46 C349.64,-141.55 351.16,-138.71 350.54,-136.15 C350.54,-136.15 278.57,166.38 278.57,166.38 C277.96,168.94 275.43,170.3 272.96,169.41 C272.96,169.41 -92.18,36.51 -92.18,36.51 C-94.67,35.6 -96.19,32.77 -95.58,30.21 C-95.58,30.21 -23.6,-272.33 -23.6,-272.33 C-22.99,-274.89 -20.46,-276.25 -17.99,-275.35 C-17.99,-275.35 347.15,-142.46 347.15,-142.46z">
                                            </path>
                                            <g opacity="1" transform="matrix(1,0,0,1,0,0)">
                                                <g opacity="1"
                                                    transform="matrix(1,0,0,1,126.89099884033203,-50.983001708984375)">
                                                    <path fill="url(#__lottie_element_512)" fill-opacity="1"
                                                        d=" M-158.48599243164062,-224.62399291992188 C-156.1909942626953,-234.27099609375 -148.61199951171875,-238.58299255371094 -141.18499755859375,-235.8719940185547 C-141.18499755859375,-235.8719940185547 222.11900329589844,-103.63300323486328 222.11900329589844,-103.63300323486328 C229.54299926757812,-100.93499755859375 234.2989959716797,-92.9530029296875 231.81500244140625,-82.54900360107422 C231.81500244140625,-82.54900360107422 158.22300720214844,226.77099609375 158.22300720214844,226.77099609375 C156.39500427246094,234.46299743652344 148.82699584960938,238.53500366210938 141.4029998779297,235.8350067138672 C141.4029998779297,235.8350067138672 -221.9010009765625,103.59500122070312 -221.9010009765625,103.59500122070312 C-229.3280029296875,100.89900207519531 -233.90499877929688,92.39900207519531 -232.07699584960938,84.70700073242188 C-232.07699584960938,84.70700073242188 -158.48599243164062,-224.61199951171875 -158.48599243164062,-224.61199951171875 C-158.48599243164062,-224.61199951171875 -158.48599243164062,-224.62399291992188 -158.48599243164062,-224.62399291992188z">
                                                    </path>
                                                    <path stroke-linecap="round" stroke-linejoin="round"
                                                        fill-opacity="0" stroke="rgb(4,0,255)" stroke-opacity="1"
                                                        stroke-width="1"
                                                        d=" M-158.48599243164062,-224.62399291992188 C-156.1909942626953,-234.27099609375 -148.61199951171875,-238.58299255371094 -141.18499755859375,-235.8719940185547 C-141.18499755859375,-235.8719940185547 222.11900329589844,-103.63300323486328 222.11900329589844,-103.63300323486328 C229.54299926757812,-100.93499755859375 234.2989959716797,-92.9530029296875 231.81500244140625,-82.54900360107422 C231.81500244140625,-82.54900360107422 158.22300720214844,226.77099609375 158.22300720214844,226.77099609375 C156.39500427246094,234.46299743652344 148.82699584960938,238.53500366210938 141.4029998779297,235.8350067138672 C141.4029998779297,235.8350067138672 -221.9010009765625,103.59500122070312 -221.9010009765625,103.59500122070312 C-229.3280029296875,100.89900207519531 -233.90499877929688,92.39900207519531 -232.07699584960938,84.70700073242188 C-232.07699584960938,84.70700073242188 -158.48599243164062,-224.61199951171875 -158.48599243164062,-224.61199951171875 C-158.48599243164062,-224.61199951171875 -158.48599243164062,-224.62399291992188 -158.48599243164062,-224.62399291992188z">
                                                    </path>
                                                </g>
                                                <g opacity="1"
                                                    transform="matrix(1,0,0,1,127.48500061035156,-52.97200012207031)">
                                                    <path fill="rgb(27,27,27)" fill-opacity="1"
                                                        d=" M219.66799926757812,-89.48600006103516 C222.156005859375,-88.5780029296875 223.67999267578125,-85.73999786376953 223.05999755859375,-83.18000030517578 C223.05999755859375,-83.18000030517578 151.08399963378906,219.3560028076172 151.08399963378906,219.3560028076172 C150.47999572753906,221.91600036621094 147.94400024414062,223.2760009765625 145.4720001220703,222.3800048828125 C145.4720001220703,222.3800048828125 -219.66900634765625,89.48400115966797 -219.66900634765625,89.48400115966797 C-222.1529998779297,88.57599639892578 -223.6790008544922,85.73999786376953 -223.06100463867188,83.18099975585938 C-223.06100463867188,83.18099975585938 -151.08399963378906,-219.35400390625 -151.08399963378906,-219.35400390625 C-150.47900390625,-221.91400146484375 -147.94500732421875,-223.2760009765625 -145.47300720214844,-222.3800048828125 C-145.47300720214844,-222.3800048828125 219.66799926757812,-89.48600006103516 219.66799926757812,-89.48600006103516z">
                                                    </path>
                                                </g>
                                            </g>
                                        </g>
                                        <g mask="url(#__lottie_element_495_1)" style="display: block;">
                                            <g id="2942" transform="matrix(1,0,0,1,847.468994140625,398.4599914550781)"
                                                opacity="1">
                                                <g opacity="1" transform="matrix(1,0,0,1,-135,66.40899658203125)">
                                                    <path stroke-linecap="butt" stroke-linejoin="miter" fill-opacity="0"
                                                        stroke-miterlimit="10" stroke="rgb(4,0,255)" stroke-opacity="1"
                                                        stroke-width="1"
                                                        d=" M267.3949890136719,2.6730000972747803 C267.3949890136719,2.6730000972747803 -267.3949890136719,97.3270034790039 -267.3949890136719,97.3270034790039">
                                                    </path>
                                                </g>
                                                <g opacity="1"
                                                    transform="matrix(1,0,0,1,-118.20999908447266,-11.090999603271484)">
                                                    <path stroke-linecap="butt" stroke-linejoin="miter" fill-opacity="0"
                                                        stroke-miterlimit="10" stroke="rgb(4,0,255)" stroke-opacity="1"
                                                        stroke-width="1"
                                                        d=" M267.3949890136719,2.6730000972747803 C267.3949890136719,2.6730000972747803 -267.3949890136719,97.3270034790039 -267.3949890136719,97.3270034790039">
                                                    </path>
                                                </g>
                                                <g opacity="1"
                                                    transform="matrix(1,0,0,1,-99.75199890136719,-88.59100341796875)">
                                                    <path stroke-linecap="butt" stroke-linejoin="miter" fill-opacity="0"
                                                        stroke-miterlimit="10" stroke="rgb(4,0,255)" stroke-opacity="1"
                                                        stroke-width="1"
                                                        d=" M267.3949890136719,2.6730000972747803 C267.3949890136719,2.6730000972747803 -267.3949890136719,97.3270034790039 -267.3949890136719,97.3270034790039">
                                                    </path>
                                                </g>
                                                <g opacity="1"
                                                    transform="matrix(1,0,0,1,-81.23200225830078,-166.09100341796875)">
                                                    <path stroke-linecap="butt" stroke-linejoin="miter" fill-opacity="0"
                                                        stroke-miterlimit="10" stroke="rgb(4,0,255)" stroke-opacity="1"
                                                        stroke-width="1"
                                                        d=" M267.3949890136719,2.6730000972747803 C267.3949890136719,2.6730000972747803 -267.3949890136719,97.3270034790039 -267.3949890136719,97.3270034790039">
                                                    </path>
                                                </g>
                                                <g opacity="1" transform="matrix(1,0,0,1,-45,100.57599639892578)">
                                                    <path stroke-linecap="butt" stroke-linejoin="miter" fill-opacity="0"
                                                        stroke-miterlimit="10" stroke="rgb(4,0,255)" stroke-opacity="1"
                                                        stroke-width="1"
                                                        d=" M267.3949890136719,2.6730000972747803 C267.3949890136719,2.6730000972747803 -267.3949890136719,97.3270034790039 -267.3949890136719,97.3270034790039">
                                                    </path>
                                                </g>
                                                <g opacity="1" transform="matrix(1,0,0,1,45,133.33799743652344)">
                                                    <path stroke-linecap="butt" stroke-linejoin="miter" fill-opacity="0"
                                                        stroke-miterlimit="10" stroke="rgb(4,0,255)" stroke-opacity="1"
                                                        stroke-width="1"
                                                        d=" M267.3949890136719,2.6730000972747803 C267.3949890136719,2.6730000972747803 -267.3949890136719,97.3270034790039 -267.3949890136719,97.3270034790039">
                                                    </path>
                                                </g>
                                                <g opacity="1" transform="matrix(1,0,0,1,135,166.09100341796875)">
                                                    <path stroke-linecap="butt" stroke-linejoin="miter" fill-opacity="0"
                                                        stroke-miterlimit="10" stroke="rgb(4,0,255)" stroke-opacity="1"
                                                        stroke-width="1"
                                                        d=" M267.3949890136719,2.6730000972747803 C267.3949890136719,2.6730000972747803 -267.3949890136719,97.3270034790039 -267.3949890136719,97.3270034790039">
                                                    </path>
                                                </g>
                                            </g>
                                        </g>
                                        <g id="2858" transform="matrix(1,0,0,1,540,528.0960083007812)" opacity="1"
                                            style="display: block;">
                                            <path stroke-linecap="butt" stroke-linejoin="miter" fill-opacity="0"
                                                stroke-miterlimit="4" stroke="rgb(4,0,255)" stroke-opacity="1"
                                                stroke-width="1"
                                                d=" M347.1549987792969,-142.45799255371094 C349.64300537109375,-141.5500030517578 351.1669921875,-138.71200561523438 350.5469970703125,-136.15199279785156 C350.5469970703125,-136.15199279785156 278.5710144042969,166.38400268554688 278.5710144042969,166.38400268554688 C277.9670104980469,168.94400024414062 275.4309997558594,170.3040008544922 272.9590148925781,169.4080047607422 C272.9590148925781,169.4080047607422 -92.18499755859375,36.512001037597656 -92.18499755859375,36.512001037597656 C-94.66999816894531,35.604000091552734 -96.19499969482422,32.768001556396484 -95.5770034790039,30.208999633789062 C-95.5770034790039,30.208999633789062 -23.600000381469727,-272.32598876953125 -23.600000381469727,-272.32598876953125 C-22.9950008392334,-274.885986328125 -20.461000442504883,-276.24798583984375 -17.98900032043457,-275.35198974609375 C-17.98900032043457,-275.35198974609375 347.1549987792969,-142.45799255371094 347.1549987792969,-142.45799255371094z">
                                            </path>
                                        </g>
                                        <g id="96" transform="matrix(1,0,0,1,540,528.0960083007812)" opacity="1"
                                            style="display: block;">
                                            <g opacity="1" transform="matrix(1,0,0,1,0,0)">
                                                <g opacity="1"
                                                    transform="matrix(1,0,0,1,-42.029998779296875,159.95199584960938)">
                                                    <path fill="url(#__lottie_element_501)" fill-opacity="1"
                                                        d=" M-311.7659912109375,-28.591999053955078 C-315.4729919433594,-27.243999481201172 -317.3399963378906,-25.464000701904297 -317.3399963378906,-23.676000595092773 C-317.3399963378906,-21.884000778198242 -315.4859924316406,-20.107999801635742 -311.7659912109375,-18.756000518798828 C-311.7659912109375,-18.756000518798828 51.5359992980957,113.48400115966797 51.5359992980957,113.48400115966797 C58.9640007019043,116.18000030517578 71.10800170898438,116.18000030517578 78.53600311279297,113.48400115966797 C78.53600311279297,113.48400115966797 311.7640075683594,28.591999053955078 311.7640075683594,28.591999053955078 C315.47198486328125,27.243999481201172 317.3399963378906,25.464000701904297 317.3399963378906,23.676000595092773 C317.3399963378906,21.884000778198242 315.4840087890625,20.107999801635742 311.7640075683594,18.756000518798828 C311.7640075683594,18.756000518798828 -51.5369987487793,-113.48400115966797 -51.5369987487793,-113.48400115966797 C-58.9640007019043,-116.18000030517578 -71.10700225830078,-116.18000030517578 -78.53399658203125,-113.48400115966797 C-78.53399658203125,-113.48400115966797 -311.7659912109375,-28.591999053955078 -311.7659912109375,-28.591999053955078z">
                                                    </path>
                                                    <path stroke-linecap="butt" stroke-linejoin="miter" fill-opacity="0"
                                                        stroke-miterlimit="10" stroke="rgb(4,0,255)" stroke-opacity="1"
                                                        stroke-width="1"
                                                        d=" M-311.7659912109375,-28.591999053955078 C-315.4729919433594,-27.243999481201172 -317.3399963378906,-25.464000701904297 -317.3399963378906,-23.676000595092773 C-317.3399963378906,-21.884000778198242 -315.4859924316406,-20.107999801635742 -311.7659912109375,-18.756000518798828 C-311.7659912109375,-18.756000518798828 51.5359992980957,113.48400115966797 51.5359992980957,113.48400115966797 C58.9640007019043,116.18000030517578 71.10800170898438,116.18000030517578 78.53600311279297,113.48400115966797 C78.53600311279297,113.48400115966797 311.7640075683594,28.591999053955078 311.7640075683594,28.591999053955078 C315.47198486328125,27.243999481201172 317.3399963378906,25.464000701904297 317.3399963378906,23.676000595092773 C317.3399963378906,21.884000778198242 315.4840087890625,20.107999801635742 311.7640075683594,18.756000518798828 C311.7640075683594,18.756000518798828 -51.5369987487793,-113.48400115966797 -51.5369987487793,-113.48400115966797 C-58.9640007019043,-116.18000030517578 -71.10700225830078,-116.18000030517578 -78.53399658203125,-113.48400115966797 C-78.53399658203125,-113.48400115966797 -311.7659912109375,-28.591999053955078 -311.7659912109375,-28.591999053955078z">
                                                    </path>
                                                </g>
                                                <g opacity="1"
                                                    transform="matrix(1,0,0,1,-42.029998779296875,211.95899963378906)">
                                                    <path fill="url(#__lottie_element_502)" fill-opacity="1"
                                                        d=" M311.7799987792969,-23.437999725341797 C311.7799987792969,-23.437999725341797 78.5479965209961,61.45000076293945 78.5479965209961,61.45000076293945 C71.12000274658203,64.1500015258789 58.97600173950195,64.1500015258789 51.54800033569336,61.45000076293945 C51.54800033569336,61.45000076293945 -311.7659912109375,-70.77400207519531 -311.7659912109375,-70.77400207519531 C-315.4729919433594,-72.1259994506836 -317.3399963378906,-73.9020004272461 -317.3399963378906,-75.69400024414062 C-317.3399963378906,-75.69400024414062 -317.3399963378906,-63.486000061035156 -317.3399963378906,-63.486000061035156 C-317.3399963378906,-61.709999084472656 -315.4859924316406,-59.917999267578125 -311.7659912109375,-58.57099914550781 C-311.7659912109375,-58.57099914550781 51.5359992980957,73.66899871826172 51.5359992980957,73.66899871826172 C58.9640007019043,76.36900329589844 71.10800170898438,76.36900329589844 78.53600311279297,73.66899871826172 C78.53600311279297,73.66899871826172 311.7640075683594,-11.218999862670898 311.7640075683594,-11.218999862670898 C315.47198486328125,-12.571000099182129 317.3399963378906,-14.347000122070312 317.3399963378906,-16.138999938964844 C317.3399963378906,-16.138999938964844 317.3399963378906,-28.341999053955078 317.3399963378906,-28.341999053955078 C317.3399963378906,-26.56599998474121 315.4840087890625,-24.78700065612793 311.7640075683594,-23.426000595092773 C311.7640075683594,-23.426000595092773 311.7799987792969,-23.437999725341797 311.7799987792969,-23.437999725341797z">
                                                    </path>
                                                </g>
                                                <g opacity="1"
                                                    transform="matrix(1,0,0,1,1.1640000343322754,143.37399291992188)">
                                                    <path fill="rgb(0,0,0)" fill-opacity="1"
                                                        d=" M-82.5250015258789,-78.18199920654297 C-86.81199645996094,-79.74600219726562 -93.81099700927734,-79.74600219726562 -98.0979995727539,-78.18199920654297 C-98.0979995727539,-78.18199920654297 -214.802001953125,-35.698001861572266 -214.802001953125,-35.698001861572266 C-219.08900451660156,-34.13399887084961 -219.08900451660156,-31.586000442504883 -214.802001953125,-30.038000106811523 C-214.802001953125,-30.038000106811523 82.5260009765625,78.18199920654297 82.5260009765625,78.18199920654297 C86.81400299072266,79.74600219726562 93.80999755859375,79.74600219726562 98.0979995727539,78.18199920654297 C98.0979995727539,78.18199920654297 214.802001953125,35.698001861572266 214.802001953125,35.698001861572266 C219.08999633789062,34.13399887084961 219.08999633789062,31.586000442504883 214.802001953125,30.038000106811523 C214.802001953125,30.038000106811523 -82.5250015258789,-78.18199920654297 -82.5250015258789,-78.18199920654297z">
                                                    </path>
                                                    <path stroke-linecap="butt" stroke-linejoin="miter" fill-opacity="0"
                                                        stroke-miterlimit="10" stroke="rgb(27,27,27)" stroke-opacity="1"
                                                        stroke-width="1"
                                                        d=" M-82.5250015258789,-78.18199920654297 C-86.81199645996094,-79.74600219726562 -93.81099700927734,-79.74600219726562 -98.0979995727539,-78.18199920654297 C-98.0979995727539,-78.18199920654297 -214.802001953125,-35.698001861572266 -214.802001953125,-35.698001861572266 C-219.08900451660156,-34.13399887084961 -219.08900451660156,-31.586000442504883 -214.802001953125,-30.038000106811523 C-214.802001953125,-30.038000106811523 82.5260009765625,78.18199920654297 82.5260009765625,78.18199920654297 C86.81400299072266,79.74600219726562 93.80999755859375,79.74600219726562 98.0979995727539,78.18199920654297 C98.0979995727539,78.18199920654297 214.802001953125,35.698001861572266 214.802001953125,35.698001861572266 C219.08999633789062,34.13399887084961 219.08999633789062,31.586000442504883 214.802001953125,30.038000106811523 C214.802001953125,30.038000106811523 -82.5250015258789,-78.18199920654297 -82.5250015258789,-78.18199920654297z">
                                                    </path>
                                                </g>
                                                <g opacity="1"
                                                    transform="matrix(1,0,0,1,44.40599822998047,125.33000183105469)">
                                                    <path stroke-linecap="round" stroke-linejoin="round"
                                                        fill-opacity="0" stroke="rgb(4,0,255)" stroke-opacity="1"
                                                        stroke-width="1"
                                                        d=" M-153.25999450683594,-55.7859992980957 C-153.25999450683594,-55.7859992980957 153.25999450683594,55.7859992980957 153.25999450683594,55.7859992980957">
                                                    </path>
                                                </g>
                                                <g opacity="1"
                                                    transform="matrix(1,0,0,1,23.256000518798828,133.0279998779297)">
                                                    <path stroke-linecap="round" stroke-linejoin="round"
                                                        fill-opacity="0" stroke="rgb(4,0,255)" stroke-opacity="1"
                                                        stroke-width="1"
                                                        d=" M-153.26600646972656,-55.779998779296875 C-153.26600646972656,-55.779998779296875 153.26600646972656,55.779998779296875 153.26600646972656,55.779998779296875">
                                                    </path>
                                                </g>
                                                <g opacity="1"
                                                    transform="matrix(1,0,0,1,2.115000009536743,140.72999572753906)">
                                                    <path stroke-linecap="round" stroke-linejoin="round"
                                                        fill-opacity="0" stroke="rgb(4,0,255)" stroke-opacity="1"
                                                        stroke-width="1"
                                                        d=" M-153.26600646972656,-55.7859992980957 C-153.26600646972656,-55.7859992980957 153.26600646972656,55.7859992980957 153.26600646972656,55.7859992980957">
                                                    </path>
                                                </g>
                                                <g opacity="1"
                                                    transform="matrix(1,0,0,1,-19.009000778198242,148.41600036621094)">
                                                    <path stroke-linecap="round" stroke-linejoin="round"
                                                        fill-opacity="0" stroke="rgb(4,0,255)" stroke-opacity="1"
                                                        stroke-width="1"
                                                        d=" M-153.26699829101562,-55.784000396728516 C-153.26699829101562,-55.784000396728516 153.26699829101562,55.784000396728516 153.26699829101562,55.784000396728516">
                                                    </path>
                                                </g>
                                                <g opacity="1"
                                                    transform="matrix(1,0,0,1,-40.150001525878906,156.11000061035156)">
                                                    <path stroke-linecap="round" stroke-linejoin="round"
                                                        fill-opacity="0" stroke="rgb(4,0,255)" stroke-opacity="1"
                                                        stroke-width="1"
                                                        d=" M-153.26699829101562,-55.7859992980957 C-153.26699829101562,-55.7859992980957 153.26699829101562,55.7859992980957 153.26699829101562,55.7859992980957">
                                                    </path>
                                                </g>
                                                <g opacity="1"
                                                    transform="matrix(1,0,0,1,-69.86199951171875,76.56600189208984)">
                                                    <path stroke-linecap="round" stroke-linejoin="round"
                                                        fill-opacity="0" stroke="rgb(4,0,255)" stroke-opacity="1"
                                                        stroke-width="1"
                                                        d=" M9.866999626159668,-3.5940001010894775 C9.866999626159668,-3.5940001010894775 -9.866999626159668,3.5940001010894775 -9.866999626159668,3.5940001010894775">
                                                    </path>
                                                </g>
                                                <g opacity="1"
                                                    transform="matrix(1,0,0,1,-98.28700256347656,81.09400177001953)">
                                                    <path stroke-linecap="round" stroke-linejoin="round"
                                                        fill-opacity="0" stroke="rgb(4,0,255)" stroke-opacity="1"
                                                        stroke-width="1"
                                                        d=" M10.567000389099121,-3.8459999561309814 C10.567000389099121,-3.8459999561309814 -10.567000389099121,3.8459999561309814 -10.567000389099121,3.8459999561309814">
                                                    </path>
                                                </g>
                                                <g opacity="1"
                                                    transform="matrix(1,0,0,1,-110.1780014038086,92.1500015258789)">
                                                    <path stroke-linecap="round" stroke-linejoin="round"
                                                        fill-opacity="0" stroke="rgb(4,0,255)" stroke-opacity="1"
                                                        stroke-width="1"
                                                        d=" M10.567000389099121,-3.8459999561309814 C10.567000389099121,-3.8459999561309814 -10.567000389099121,3.8459999561309814 -10.567000389099121,3.8459999561309814">
                                                    </path>
                                                </g>
                                                <g opacity="1"
                                                    transform="matrix(1,0,0,1,-121.26499938964844,103.50599670410156)">
                                                    <path stroke-linecap="round" stroke-linejoin="round"
                                                        fill-opacity="0" stroke="rgb(4,0,255)" stroke-opacity="1"
                                                        stroke-width="1"
                                                        d=" M10.572999954223633,-3.8540000915527344 C10.572999954223633,-3.8540000915527344 -10.572999954223633,3.8540000915527344 -10.572999954223633,3.8540000915527344">
                                                    </path>
                                                </g>
                                                <g opacity="1"
                                                    transform="matrix(1,0,0,1,-133.61500549316406,114.39399719238281)">
                                                    <path stroke-linecap="round" stroke-linejoin="round"
                                                        fill-opacity="0" stroke="rgb(4,0,255)" stroke-opacity="1"
                                                        stroke-width="1"
                                                        d=" M10.567000389099121,-3.8459999561309814 C10.567000389099121,-3.8459999561309814 -10.567000389099121,3.8459999561309814 -10.567000389099121,3.8459999561309814">
                                                    </path>
                                                </g>
                                                <g opacity="1"
                                                    transform="matrix(1,0,0,1,-172.7239990234375,115.5459976196289)">
                                                    <path stroke-linecap="round" stroke-linejoin="round"
                                                        fill-opacity="0" stroke="rgb(4,0,255)" stroke-opacity="1"
                                                        stroke-width="1"
                                                        d=" M10.567000389099121,-3.8459999561309814 C10.567000389099121,-3.8459999561309814 -10.567000389099121,3.8459999561309814 -10.567000389099121,3.8459999561309814">
                                                    </path>
                                                </g>
                                                <g opacity="1"
                                                    transform="matrix(1,0,0,1,-48.71500015258789,84.25800323486328)">
                                                    <path stroke-linecap="round" stroke-linejoin="round"
                                                        fill-opacity="0" stroke="rgb(4,0,255)" stroke-opacity="1"
                                                        stroke-width="1"
                                                        d=" M9.873000144958496,-3.5940001010894775 C9.873000144958496,-3.5940001010894775 -9.873000144958496,3.5940001010894775 -9.873000144958496,3.5940001010894775">
                                                    </path>
                                                </g>
                                                <g opacity="1"
                                                    transform="matrix(1,0,0,1,-77.1780014038086,88.79000091552734)">
                                                    <path stroke-linecap="round" stroke-linejoin="round"
                                                        fill-opacity="0" stroke="rgb(4,0,255)" stroke-opacity="1"
                                                        stroke-width="1"
                                                        d=" M10.567000389099121,-3.8459999561309814 C10.567000389099121,-3.8459999561309814 -10.567000389099121,3.8459999561309814 -10.567000389099121,3.8459999561309814">
                                                    </path>
                                                </g>
                                                <g opacity="1"
                                                    transform="matrix(1,0,0,1,-89.052001953125,99.84600067138672)">
                                                    <path stroke-linecap="round" stroke-linejoin="round"
                                                        fill-opacity="0" stroke="rgb(4,0,255)" stroke-opacity="1"
                                                        stroke-width="1"
                                                        d=" M10.567000389099121,-3.8459999561309814 C10.567000389099121,-3.8459999561309814 -10.567000389099121,3.8459999561309814 -10.567000389099121,3.8459999561309814">
                                                    </path>
                                                </g>
                                                <g opacity="1"
                                                    transform="matrix(1,0,0,1,-100.11499786376953,111.2020034790039)">
                                                    <path stroke-linecap="round" stroke-linejoin="round"
                                                        fill-opacity="0" stroke="rgb(4,0,255)" stroke-opacity="1"
                                                        stroke-width="1"
                                                        d=" M10.567000389099121,-3.8459999561309814 C10.567000389099121,-3.8459999561309814 -10.567000389099121,3.8459999561309814 -10.567000389099121,3.8459999561309814">
                                                    </path>
                                                </g>
                                                <g opacity="1"
                                                    transform="matrix(1,0,0,1,-112.48999786376953,122.08999633789062)">
                                                    <path stroke-linecap="round" stroke-linejoin="round"
                                                        fill-opacity="0" stroke="rgb(4,0,255)" stroke-opacity="1"
                                                        stroke-width="1"
                                                        d=" M10.567000389099121,-3.8459999561309814 C10.567000389099121,-3.8459999561309814 -10.567000389099121,3.8459999561309814 -10.567000389099121,3.8459999561309814">
                                                    </path>
                                                </g>
                                                <g opacity="1"
                                                    transform="matrix(1,0,0,1,-151.58399963378906,123.23799896240234)">
                                                    <path stroke-linecap="round" stroke-linejoin="round"
                                                        fill-opacity="0" stroke="rgb(4,0,255)" stroke-opacity="1"
                                                        stroke-width="1"
                                                        d=" M10.567000389099121,-3.8459999561309814 C10.567000389099121,-3.8459999561309814 -10.567000389099121,3.8459999561309814 -10.567000389099121,3.8459999561309814">
                                                    </path>
                                                </g>
                                                <g opacity="1"
                                                    transform="matrix(1,0,0,1,-27.573999404907227,91.9540023803711)">
                                                    <path stroke-linecap="round" stroke-linejoin="round"
                                                        fill-opacity="0" stroke="rgb(4,0,255)" stroke-opacity="1"
                                                        stroke-width="1"
                                                        d=" M9.87399959564209,-3.5940001010894775 C9.87399959564209,-3.5940001010894775 -9.87399959564209,3.5940001010894775 -9.87399959564209,3.5940001010894775">
                                                    </path>
                                                </g>
                                                <g opacity="1"
                                                    transform="matrix(1,0,0,1,-56.020999908447266,96.47799682617188)">
                                                    <path stroke-linecap="round" stroke-linejoin="round"
                                                        fill-opacity="0" stroke="rgb(4,0,255)" stroke-opacity="1"
                                                        stroke-width="1"
                                                        d=" M10.567000389099121,-3.8459999561309814 C10.567000389099121,-3.8459999561309814 -10.567000389099121,3.8459999561309814 -10.567000389099121,3.8459999561309814">
                                                    </path>
                                                </g>
                                                <g opacity="1"
                                                    transform="matrix(1,0,0,1,-67.9280014038086,107.53800201416016)">
                                                    <path stroke-linecap="round" stroke-linejoin="round"
                                                        fill-opacity="0" stroke="rgb(4,0,255)" stroke-opacity="1"
                                                        stroke-width="1"
                                                        d=" M10.567000389099121,-3.8459999561309814 C10.567000389099121,-3.8459999561309814 -10.567000389099121,3.8459999561309814 -10.567000389099121,3.8459999561309814">
                                                    </path>
                                                </g>
                                                <g opacity="1"
                                                    transform="matrix(1,0,0,1,-78.98999786376953,118.89800262451172)">
                                                    <path stroke-linecap="round" stroke-linejoin="round"
                                                        fill-opacity="0" stroke="rgb(4,0,255)" stroke-opacity="1"
                                                        stroke-width="1"
                                                        d=" M10.567000389099121,-3.8459999561309814 C10.567000389099121,-3.8459999561309814 -10.567000389099121,3.8459999561309814 -10.567000389099121,3.8459999561309814">
                                                    </path>
                                                </g>
                                                <g opacity="1"
                                                    transform="matrix(1,0,0,1,-91.3489990234375,129.7779998779297)">
                                                    <path stroke-linecap="round" stroke-linejoin="round"
                                                        fill-opacity="0" stroke="rgb(4,0,255)" stroke-opacity="1"
                                                        stroke-width="1"
                                                        d=" M10.567000389099121,-3.8459999561309814 C10.567000389099121,-3.8459999561309814 -10.567000389099121,3.8459999561309814 -10.567000389099121,3.8459999561309814">
                                                    </path>
                                                </g>
                                                <g opacity="1"
                                                    transform="matrix(1,0,0,1,-130.45899963378906,130.9320068359375)">
                                                    <path stroke-linecap="round" stroke-linejoin="round"
                                                        fill-opacity="0" stroke="rgb(4,0,255)" stroke-opacity="1"
                                                        stroke-width="1"
                                                        d=" M10.567000389099121,-3.8519999980926514 C10.567000389099121,-3.8519999980926514 -10.567000389099121,3.8519999980926514 -10.567000389099121,3.8519999980926514">
                                                    </path>
                                                </g>
                                                <g opacity="1"
                                                    transform="matrix(1,0,0,1,-6.440999984741211,99.64199829101562)">
                                                    <path stroke-linecap="round" stroke-linejoin="round"
                                                        fill-opacity="0" stroke="rgb(4,0,255)" stroke-opacity="1"
                                                        stroke-width="1"
                                                        d=" M9.866000175476074,-3.5940001010894775 C9.866000175476074,-3.5940001010894775 -9.866000175476074,3.5940001010894775 -9.866000175476074,3.5940001010894775">
                                                    </path>
                                                </g>
                                                <g opacity="1"
                                                    transform="matrix(1,0,0,1,-34.88999938964844,104.16999816894531)">
                                                    <path stroke-linecap="round" stroke-linejoin="round"
                                                        fill-opacity="0" stroke="rgb(4,0,255)" stroke-opacity="1"
                                                        stroke-width="1"
                                                        d=" M10.572999954223633,-3.8459999561309814 C10.572999954223633,-3.8459999561309814 -10.572999954223633,3.8459999561309814 -10.572999954223633,3.8459999561309814">
                                                    </path>
                                                </g>
                                                <g opacity="1"
                                                    transform="matrix(1,0,0,1,-46.770999908447266,115.2300033569336)">
                                                    <path stroke-linecap="round" stroke-linejoin="round"
                                                        fill-opacity="0" stroke="rgb(4,0,255)" stroke-opacity="1"
                                                        stroke-width="1"
                                                        d=" M10.567000389099121,-3.8459999561309814 C10.567000389099121,-3.8459999561309814 -10.567000389099121,3.8459999561309814 -10.567000389099121,3.8459999561309814">
                                                    </path>
                                                </g>
                                                <g opacity="1"
                                                    transform="matrix(1,0,0,1,-57.8489990234375,126.59400177001953)">
                                                    <path stroke-linecap="round" stroke-linejoin="round"
                                                        fill-opacity="0" stroke="rgb(4,0,255)" stroke-opacity="1"
                                                        stroke-width="1"
                                                        d=" M10.567000389099121,-3.8459999561309814 C10.567000389099121,-3.8459999561309814 -10.567000389099121,3.8459999561309814 -10.567000389099121,3.8459999561309814">
                                                    </path>
                                                </g>
                                                <g opacity="1"
                                                    transform="matrix(1,0,0,1,-70.21800231933594,137.47799682617188)">
                                                    <path stroke-linecap="round" stroke-linejoin="round"
                                                        fill-opacity="0" stroke="rgb(4,0,255)" stroke-opacity="1"
                                                        stroke-width="1"
                                                        d=" M10.572999954223633,-3.8459999561309814 C10.572999954223633,-3.8459999561309814 -10.572999954223633,3.8459999561309814 -10.572999954223633,3.8459999561309814">
                                                    </path>
                                                </g>
                                                <g opacity="1"
                                                    transform="matrix(1,0,0,1,-109.3280029296875,138.6300048828125)">
                                                    <path stroke-linecap="round" stroke-linejoin="round"
                                                        fill-opacity="0" stroke="rgb(4,0,255)" stroke-opacity="1"
                                                        stroke-width="1"
                                                        d=" M10.572999954223633,-3.8459999561309814 C10.572999954223633,-3.8459999561309814 -10.572999954223633,3.8459999561309814 -10.572999954223633,3.8459999561309814">
                                                    </path>
                                                </g>
                                                <g opacity="1"
                                                    transform="matrix(1,0,0,1,14.6850004196167,107.33399963378906)">
                                                    <path stroke-linecap="round" stroke-linejoin="round"
                                                        fill-opacity="0" stroke="rgb(4,0,255)" stroke-opacity="1"
                                                        stroke-width="1"
                                                        d=" M9.868000030517578,-3.5940001010894775 C9.868000030517578,-3.5940001010894775 -9.868000030517578,3.5940001010894775 -9.868000030517578,3.5940001010894775">
                                                    </path>
                                                </g>
                                                <g opacity="1"
                                                    transform="matrix(1,0,0,1,-13.755999565124512,111.86199951171875)">
                                                    <path stroke-linecap="round" stroke-linejoin="round"
                                                        fill-opacity="0" stroke="rgb(4,0,255)" stroke-opacity="1"
                                                        stroke-width="1"
                                                        d=" M10.567000389099121,-3.8459999561309814 C10.567000389099121,-3.8459999561309814 -10.567000389099121,3.8459999561309814 -10.567000389099121,3.8459999561309814">
                                                    </path>
                                                </g>
                                                <g opacity="1"
                                                    transform="matrix(1,0,0,1,-25.624000549316406,122.9260025024414)">
                                                    <path stroke-linecap="round" stroke-linejoin="round"
                                                        fill-opacity="0" stroke="rgb(4,0,255)" stroke-opacity="1"
                                                        stroke-width="1"
                                                        d=" M10.572999954223633,-3.8459999561309814 C10.572999954223633,-3.8459999561309814 -10.572999954223633,3.8459999561309814 -10.572999954223633,3.8459999561309814">
                                                    </path>
                                                </g>
                                                <g opacity="1"
                                                    transform="matrix(1,0,0,1,-36.70899963378906,134.28199768066406)">
                                                    <path stroke-linecap="round" stroke-linejoin="round"
                                                        fill-opacity="0" stroke="rgb(4,0,255)" stroke-opacity="1"
                                                        stroke-width="1"
                                                        d=" M10.567000389099121,-3.8459999561309814 C10.567000389099121,-3.8459999561309814 -10.567000389099121,3.8459999561309814 -10.567000389099121,3.8459999561309814">
                                                    </path>
                                                </g>
                                                <g opacity="1"
                                                    transform="matrix(1,0,0,1,-49.06800079345703,145.16600036621094)">
                                                    <path stroke-linecap="round" stroke-linejoin="round"
                                                        fill-opacity="0" stroke="rgb(4,0,255)" stroke-opacity="1"
                                                        stroke-width="1"
                                                        d=" M10.567000389099121,-3.8459999561309814 C10.567000389099121,-3.8459999561309814 -10.567000389099121,3.8459999561309814 -10.567000389099121,3.8459999561309814">
                                                    </path>
                                                </g>
                                                <g opacity="1"
                                                    transform="matrix(1,0,0,1,35.83100128173828,115.0260009765625)">
                                                    <path stroke-linecap="round" stroke-linejoin="round"
                                                        fill-opacity="0" stroke="rgb(4,0,255)" stroke-opacity="1"
                                                        stroke-width="1"
                                                        d=" M9.87399959564209,-3.5940001010894775 C9.87399959564209,-3.5940001010894775 -9.87399959564209,3.5940001010894775 -9.87399959564209,3.5940001010894775">
                                                    </path>
                                                </g>
                                                <g opacity="1"
                                                    transform="matrix(1,0,0,1,7.386000156402588,119.55400085449219)">
                                                    <path stroke-linecap="round" stroke-linejoin="round"
                                                        fill-opacity="0" stroke="rgb(4,0,255)" stroke-opacity="1"
                                                        stroke-width="1"
                                                        d=" M10.567999839782715,-3.8459999561309814 C10.567999839782715,-3.8459999561309814 -10.567999839782715,3.8459999561309814 -10.567999839782715,3.8459999561309814">
                                                    </path>
                                                </g>
                                                <g opacity="1"
                                                    transform="matrix(1,0,0,1,-4.50600004196167,130.61599731445312)">
                                                    <path stroke-linecap="round" stroke-linejoin="round"
                                                        fill-opacity="0" stroke="rgb(4,0,255)" stroke-opacity="1"
                                                        stroke-width="1"
                                                        d=" M10.567000389099121,-3.8519999980926514 C10.567000389099121,-3.8519999980926514 -10.567000389099121,3.8519999980926514 -10.567000389099121,3.8519999980926514">
                                                    </path>
                                                </g>
                                                <g opacity="1"
                                                    transform="matrix(1,0,0,1,-15.57800006866455,141.97799682617188)">
                                                    <path stroke-linecap="round" stroke-linejoin="round"
                                                        fill-opacity="0" stroke="rgb(4,0,255)" stroke-opacity="1"
                                                        stroke-width="1"
                                                        d=" M10.572999954223633,-3.8459999561309814 C10.572999954223633,-3.8459999561309814 -10.572999954223633,3.8459999561309814 -10.572999954223633,3.8459999561309814">
                                                    </path>
                                                </g>
                                                <g opacity="1"
                                                    transform="matrix(1,0,0,1,-27.944000244140625,152.85800170898438)">
                                                    <path stroke-linecap="round" stroke-linejoin="round"
                                                        fill-opacity="0" stroke="rgb(4,0,255)" stroke-opacity="1"
                                                        stroke-width="1"
                                                        d=" M10.567000389099121,-3.8459999561309814 C10.567000389099121,-3.8459999561309814 -10.567000389099121,3.8459999561309814 -10.567000389099121,3.8459999561309814">
                                                    </path>
                                                </g>
                                                <g opacity="1"
                                                    transform="matrix(1,0,0,1,56.957000732421875,122.72000122070312)">
                                                    <path stroke-linecap="round" stroke-linejoin="round"
                                                        fill-opacity="0" stroke="rgb(4,0,255)" stroke-opacity="1"
                                                        stroke-width="1"
                                                        d=" M9.871999740600586,-3.5880000591278076 C9.871999740600586,-3.5880000591278076 -9.871999740600586,3.5880000591278076 -9.871999740600586,3.5880000591278076">
                                                    </path>
                                                </g>
                                                <g opacity="1"
                                                    transform="matrix(1,0,0,1,28.524999618530273,127.24600219726562)">
                                                    <path stroke-linecap="round" stroke-linejoin="round"
                                                        fill-opacity="0" stroke="rgb(4,0,255)" stroke-opacity="1"
                                                        stroke-width="1"
                                                        d=" M10.567999839782715,-3.8459999561309814 C10.567999839782715,-3.8459999561309814 -10.567999839782715,3.8459999561309814 -10.567999839782715,3.8459999561309814">
                                                    </path>
                                                </g>
                                                <g opacity="1"
                                                    transform="matrix(1,0,0,1,16.635000228881836,138.30999755859375)">
                                                    <path stroke-linecap="round" stroke-linejoin="round"
                                                        fill-opacity="0" stroke="rgb(4,0,255)" stroke-opacity="1"
                                                        stroke-width="1"
                                                        d=" M10.565999984741211,-3.8459999561309814 C10.565999984741211,-3.8459999561309814 -10.565999984741211,3.8459999561309814 -10.565999984741211,3.8459999561309814">
                                                    </path>
                                                </g>
                                                <g opacity="1"
                                                    transform="matrix(1,0,0,1,5.572999954223633,149.66200256347656)">
                                                    <path stroke-linecap="round" stroke-linejoin="round"
                                                        fill-opacity="0" stroke="rgb(4,0,255)" stroke-opacity="1"
                                                        stroke-width="1"
                                                        d=" M10.567999839782715,-3.8459999561309814 C10.567999839782715,-3.8459999561309814 -10.567999839782715,3.8459999561309814 -10.567999839782715,3.8459999561309814">
                                                    </path>
                                                </g>
                                                <g opacity="1"
                                                    transform="matrix(1,0,0,1,-6.802000045776367,160.55999755859375)">
                                                    <path stroke-linecap="round" stroke-linejoin="round"
                                                        fill-opacity="0" stroke="rgb(4,0,255)" stroke-opacity="1"
                                                        stroke-width="1"
                                                        d=" M10.567999839782715,-3.8519999980926514 C10.567999839782715,-3.8519999980926514 -10.567999839782715,3.8519999980926514 -10.567999839782715,3.8519999980926514">
                                                    </path>
                                                </g>
                                                <g opacity="1"
                                                    transform="matrix(1,0,0,1,78.10700225830078,130.4219970703125)">
                                                    <path stroke-linecap="round" stroke-linejoin="round"
                                                        fill-opacity="0" stroke="rgb(4,0,255)" stroke-opacity="1"
                                                        stroke-width="1"
                                                        d=" M9.866000175476074,-3.5940001010894775 C9.866000175476074,-3.5940001010894775 -9.866000175476074,3.5940001010894775 -9.866000175476074,3.5940001010894775">
                                                    </path>
                                                </g>
                                                <g opacity="1"
                                                    transform="matrix(1,0,0,1,49.6349983215332,134.93800354003906)">
                                                    <path stroke-linecap="round" stroke-linejoin="round"
                                                        fill-opacity="0" stroke="rgb(4,0,255)" stroke-opacity="1"
                                                        stroke-width="1"
                                                        d=" M10.565999984741211,-3.8459999561309814 C10.565999984741211,-3.8459999561309814 -10.565999984741211,3.8459999561309814 -10.565999984741211,3.8459999561309814">
                                                    </path>
                                                </g>
                                                <g opacity="1"
                                                    transform="matrix(1,0,0,1,37.775001525878906,146.00999450683594)">
                                                    <path stroke-linecap="round" stroke-linejoin="round"
                                                        fill-opacity="0" stroke="rgb(4,0,255)" stroke-opacity="1"
                                                        stroke-width="1"
                                                        d=" M10.565999984741211,-3.8459999561309814 C10.565999984741211,-3.8459999561309814 -10.565999984741211,3.8459999561309814 -10.565999984741211,3.8459999561309814">
                                                    </path>
                                                </g>
                                                <g opacity="1"
                                                    transform="matrix(1,0,0,1,26.69700050354004,157.35800170898438)">
                                                    <path stroke-linecap="round" stroke-linejoin="round"
                                                        fill-opacity="0" stroke="rgb(4,0,255)" stroke-opacity="1"
                                                        stroke-width="1"
                                                        d=" M10.567999839782715,-3.8459999561309814 C10.567999839782715,-3.8459999561309814 -10.567999839782715,3.8459999561309814 -10.567999839782715,3.8459999561309814">
                                                    </path>
                                                </g>
                                                <g opacity="1" transform="matrix(1,0,0,1,14.329000473022461,168.25)">
                                                    <path stroke-linecap="round" stroke-linejoin="round"
                                                        fill-opacity="0" stroke="rgb(4,0,255)" stroke-opacity="1"
                                                        stroke-width="1"
                                                        d=" M10.571999549865723,-3.8459999561309814 C10.571999549865723,-3.8459999561309814 -10.571999549865723,3.8459999561309814 -10.571999549865723,3.8459999561309814">
                                                    </path>
                                                </g>
                                                <g opacity="1"
                                                    transform="matrix(1,0,0,1,99.23100280761719,138.1219940185547)">
                                                    <path stroke-linecap="round" stroke-linejoin="round"
                                                        fill-opacity="0" stroke="rgb(4,0,255)" stroke-opacity="1"
                                                        stroke-width="1"
                                                        d=" M9.866000175476074,-3.5940001010894775 C9.866000175476074,-3.5940001010894775 -9.866000175476074,3.5940001010894775 -9.866000175476074,3.5940001010894775">
                                                    </path>
                                                </g>
                                                <g opacity="1"
                                                    transform="matrix(1,0,0,1,70.78099822998047,142.63600158691406)">
                                                    <path stroke-linecap="round" stroke-linejoin="round"
                                                        fill-opacity="0" stroke="rgb(4,0,255)" stroke-opacity="1"
                                                        stroke-width="1"
                                                        d=" M10.571999549865723,-3.8519999980926514 C10.571999549865723,-3.8519999980926514 -10.571999549865723,3.8519999980926514 -10.571999549865723,3.8519999980926514">
                                                    </path>
                                                </g>
                                                <g opacity="1"
                                                    transform="matrix(1,0,0,1,58.92300033569336,153.70199584960938)">
                                                    <path stroke-linecap="round" stroke-linejoin="round"
                                                        fill-opacity="0" stroke="rgb(4,0,255)" stroke-opacity="1"
                                                        stroke-width="1"
                                                        d=" M10.574000358581543,-3.8459999561309814 C10.574000358581543,-3.8459999561309814 -10.574000358581543,3.8459999561309814 -10.574000358581543,3.8459999561309814">
                                                    </path>
                                                </g>
                                                <g opacity="1"
                                                    transform="matrix(1,0,0,1,47.83700180053711,165.0540008544922)">
                                                    <path stroke-linecap="round" stroke-linejoin="round"
                                                        fill-opacity="0" stroke="rgb(4,0,255)" stroke-opacity="1"
                                                        stroke-width="1"
                                                        d=" M10.567999839782715,-3.8459999561309814 C10.567999839782715,-3.8459999561309814 -10.567999839782715,3.8459999561309814 -10.567999839782715,3.8459999561309814">
                                                    </path>
                                                </g>
                                                <g opacity="1"
                                                    transform="matrix(1,0,0,1,35.479000091552734,175.94200134277344)">
                                                    <path stroke-linecap="round" stroke-linejoin="round"
                                                        fill-opacity="0" stroke="rgb(4,0,255)" stroke-opacity="1"
                                                        stroke-width="1"
                                                        d=" M10.565999984741211,-3.8459999561309814 C10.565999984741211,-3.8459999561309814 -10.565999984741211,3.8459999561309814 -10.565999984741211,3.8459999561309814">
                                                    </path>
                                                </g>
                                                <g opacity="1"
                                                    transform="matrix(1,0,0,1,120.37300109863281,145.80799865722656)">
                                                    <path stroke-linecap="round" stroke-linejoin="round"
                                                        fill-opacity="0" stroke="rgb(4,0,255)" stroke-opacity="1"
                                                        stroke-width="1"
                                                        d=" M9.868000030517578,-3.5920000076293945 C9.868000030517578,-3.5920000076293945 -9.868000030517578,3.5920000076293945 -9.868000030517578,3.5920000076293945">
                                                    </path>
                                                </g>
                                                <g opacity="1"
                                                    transform="matrix(1,0,0,1,91.93099975585938,150.33399963378906)">
                                                    <path stroke-linecap="round" stroke-linejoin="round"
                                                        fill-opacity="0" stroke="rgb(4,0,255)" stroke-opacity="1"
                                                        stroke-width="1"
                                                        d=" M10.565999984741211,-3.8459999561309814 C10.565999984741211,-3.8459999561309814 -10.565999984741211,3.8459999561309814 -10.565999984741211,3.8459999561309814">
                                                    </path>
                                                </g>
                                                <g opacity="1"
                                                    transform="matrix(1,0,0,1,80.05699920654297,161.3939971923828)">
                                                    <path stroke-linecap="round" stroke-linejoin="round"
                                                        fill-opacity="0" stroke="rgb(4,0,255)" stroke-opacity="1"
                                                        stroke-width="1"
                                                        d=" M10.567999839782715,-3.8459999561309814 C10.567999839782715,-3.8459999561309814 -10.567999839782715,3.8459999561309814 -10.567999839782715,3.8459999561309814">
                                                    </path>
                                                </g>
                                                <g opacity="1" transform="matrix(1,0,0,1,68.96900177001953,172.75)">
                                                    <path stroke-linecap="round" stroke-linejoin="round"
                                                        fill-opacity="0" stroke="rgb(4,0,255)" stroke-opacity="1"
                                                        stroke-width="1"
                                                        d=" M10.571999549865723,-3.8540000915527344 C10.571999549865723,-3.8540000915527344 -10.571999549865723,3.8540000915527344 -10.571999549865723,3.8540000915527344">
                                                    </path>
                                                </g>
                                                <g opacity="1"
                                                    transform="matrix(1,0,0,1,56.60300064086914,183.63800048828125)">
                                                    <path stroke-linecap="round" stroke-linejoin="round"
                                                        fill-opacity="0" stroke="rgb(4,0,255)" stroke-opacity="1"
                                                        stroke-width="1"
                                                        d=" M10.565999984741211,-3.8459999561309814 C10.565999984741211,-3.8459999561309814 -10.565999984741211,3.8459999561309814 -10.565999984741211,3.8459999561309814">
                                                    </path>
                                                </g>
                                                <g opacity="1"
                                                    transform="matrix(1,0,0,1,17.509000778198242,184.78599548339844)">
                                                    <path stroke-linecap="round" stroke-linejoin="round"
                                                        fill-opacity="0" stroke="rgb(4,0,255)" stroke-opacity="1"
                                                        stroke-width="1"
                                                        d=" M10.567999839782715,-3.8459999561309814 C10.567999839782715,-3.8459999561309814 -10.567999839782715,3.8459999561309814 -10.567999839782715,3.8459999561309814">
                                                    </path>
                                                </g>
                                                <g opacity="1"
                                                    transform="matrix(1,0,0,1,141.5030059814453,153.4980010986328)">
                                                    <path stroke-linecap="round" stroke-linejoin="round"
                                                        fill-opacity="0" stroke="rgb(4,0,255)" stroke-opacity="1"
                                                        stroke-width="1"
                                                        d=" M9.87399959564209,-3.5940001010894775 C9.87399959564209,-3.5940001010894775 -9.87399959564209,3.5940001010894775 -9.87399959564209,3.5940001010894775">
                                                    </path>
                                                </g>
                                                <g opacity="1"
                                                    transform="matrix(1,0,0,1,113.05699920654297,158.02999877929688)">
                                                    <path stroke-linecap="round" stroke-linejoin="round"
                                                        fill-opacity="0" stroke="rgb(4,0,255)" stroke-opacity="1"
                                                        stroke-width="1"
                                                        d=" M10.567999839782715,-3.8459999561309814 C10.567999839782715,-3.8459999561309814 -10.567999839782715,3.8459999561309814 -10.567999839782715,3.8459999561309814">
                                                    </path>
                                                </g>
                                                <g opacity="1"
                                                    transform="matrix(1,0,0,1,101.18099975585938,169.08599853515625)">
                                                    <path stroke-linecap="round" stroke-linejoin="round"
                                                        fill-opacity="0" stroke="rgb(4,0,255)" stroke-opacity="1"
                                                        stroke-width="1"
                                                        d=" M10.567999839782715,-3.8459999561309814 C10.567999839782715,-3.8459999561309814 -10.567999839782715,3.8459999561309814 -10.567999839782715,3.8459999561309814">
                                                    </path>
                                                </g>
                                                <g opacity="1"
                                                    transform="matrix(1,0,0,1,90.11900329589844,180.4459991455078)">
                                                    <path stroke-linecap="round" stroke-linejoin="round"
                                                        fill-opacity="0" stroke="rgb(4,0,255)" stroke-opacity="1"
                                                        stroke-width="1"
                                                        d=" M10.565999984741211,-3.8459999561309814 C10.565999984741211,-3.8459999561309814 -10.565999984741211,3.8459999561309814 -10.565999984741211,3.8459999561309814">
                                                    </path>
                                                </g>
                                                <g opacity="1"
                                                    transform="matrix(1,0,0,1,77.74299621582031,191.3300018310547)">
                                                    <path stroke-linecap="round" stroke-linejoin="round"
                                                        fill-opacity="0" stroke="rgb(4,0,255)" stroke-opacity="1"
                                                        stroke-width="1"
                                                        d=" M10.565999984741211,-3.8459999561309814 C10.565999984741211,-3.8459999561309814 -10.565999984741211,3.8459999561309814 -10.565999984741211,3.8459999561309814">
                                                    </path>
                                                </g>
                                                <g opacity="1"
                                                    transform="matrix(1,0,0,1,38.6349983215332,192.48199462890625)">
                                                    <path stroke-linecap="round" stroke-linejoin="round"
                                                        fill-opacity="0" stroke="rgb(4,0,255)" stroke-opacity="1"
                                                        stroke-width="1"
                                                        d=" M10.565999984741211,-3.8459999561309814 C10.565999984741211,-3.8459999561309814 -10.565999984741211,3.8459999561309814 -10.565999984741211,3.8459999561309814">
                                                    </path>
                                                </g>
                                                <g opacity="1"
                                                    transform="matrix(1,0,0,1,162.64300537109375,161.19000244140625)">
                                                    <path stroke-linecap="round" stroke-linejoin="round"
                                                        fill-opacity="0" stroke="rgb(4,0,255)" stroke-opacity="1"
                                                        stroke-width="1"
                                                        d=" M9.87399959564209,-3.5940001010894775 C9.87399959564209,-3.5940001010894775 -9.87399959564209,3.5940001010894775 -9.87399959564209,3.5940001010894775">
                                                    </path>
                                                </g>
                                                <g opacity="1"
                                                    transform="matrix(1,0,0,1,134.19700622558594,165.71400451660156)">
                                                    <path stroke-linecap="round" stroke-linejoin="round"
                                                        fill-opacity="0" stroke="rgb(4,0,255)" stroke-opacity="1"
                                                        stroke-width="1"
                                                        d=" M10.567999839782715,-3.8459999561309814 C10.567999839782715,-3.8459999561309814 -10.567999839782715,3.8459999561309814 -10.567999839782715,3.8459999561309814">
                                                    </path>
                                                </g>
                                                <g opacity="1"
                                                    transform="matrix(1,0,0,1,122.322998046875,176.7779998779297)">
                                                    <path stroke-linecap="round" stroke-linejoin="round"
                                                        fill-opacity="0" stroke="rgb(4,0,255)" stroke-opacity="1"
                                                        stroke-width="1"
                                                        d=" M10.565999984741211,-3.8459999561309814 C10.565999984741211,-3.8459999561309814 -10.565999984741211,3.8459999561309814 -10.565999984741211,3.8459999561309814">
                                                    </path>
                                                </g>
                                                <g opacity="1"
                                                    transform="matrix(1,0,0,1,111.24299621582031,188.13800048828125)">
                                                    <path stroke-linecap="round" stroke-linejoin="round"
                                                        fill-opacity="0" stroke="rgb(4,0,255)" stroke-opacity="1"
                                                        stroke-width="1"
                                                        d=" M10.565999984741211,-3.8459999561309814 C10.565999984741211,-3.8459999561309814 -10.565999984741211,3.8459999561309814 -10.565999984741211,3.8459999561309814">
                                                    </path>
                                                </g>
                                                <g opacity="1"
                                                    transform="matrix(1,0,0,1,59.775001525878906,200.17599487304688)">
                                                    <path stroke-linecap="round" stroke-linejoin="round"
                                                        fill-opacity="0" stroke="rgb(4,0,255)" stroke-opacity="1"
                                                        stroke-width="1"
                                                        d=" M10.565999984741211,-3.8519999980926514 C10.565999984741211,-3.8519999980926514 -10.565999984741211,3.8519999980926514 -10.565999984741211,3.8519999980926514">
                                                    </path>
                                                </g>
                                                <g opacity="1"
                                                    transform="matrix(1,0,0,1,183.7790069580078,168.8820037841797)">
                                                    <path stroke-linecap="round" stroke-linejoin="round"
                                                        fill-opacity="0" stroke="rgb(4,0,255)" stroke-opacity="1"
                                                        stroke-width="1"
                                                        d=" M9.866000175476074,-3.5940001010894775 C9.866000175476074,-3.5940001010894775 -9.866000175476074,3.5940001010894775 -9.866000175476074,3.5940001010894775">
                                                    </path>
                                                </g>
                                                <g opacity="1"
                                                    transform="matrix(1,0,0,1,155.34300231933594,173.41400146484375)">
                                                    <path stroke-linecap="round" stroke-linejoin="round"
                                                        fill-opacity="0" stroke="rgb(4,0,255)" stroke-opacity="1"
                                                        stroke-width="1"
                                                        d=" M10.574000358581543,-3.8459999561309814 C10.574000358581543,-3.8459999561309814 -10.574000358581543,3.8459999561309814 -10.574000358581543,3.8459999561309814">
                                                    </path>
                                                </g>
                                                <g opacity="1"
                                                    transform="matrix(1,0,0,1,143.46299743652344,184.47000122070312)">
                                                    <path stroke-linecap="round" stroke-linejoin="round"
                                                        fill-opacity="0" stroke="rgb(4,0,255)" stroke-opacity="1"
                                                        stroke-width="1"
                                                        d=" M10.565999984741211,-3.8459999561309814 C10.565999984741211,-3.8459999561309814 -10.565999984741211,3.8459999561309814 -10.565999984741211,3.8459999561309814">
                                                    </path>
                                                </g>
                                                <g opacity="1"
                                                    transform="matrix(1,0,0,1,-120.25700378417969,194.66400146484375)">
                                                    <path stroke-linecap="butt" stroke-linejoin="miter" fill-opacity="0"
                                                        stroke-miterlimit="10" stroke="rgb(4,0,255)" stroke-opacity="1"
                                                        stroke-width="1"
                                                        d=" M-109.95600128173828,-8.5 C-109.95600128173828,-8.5 -20.160999298095703,-41.18299865722656 -20.160999298095703,-41.18299865722656 C-17.375,-42.20800018310547 -12.8100004196167,-42.20800018310547 -10.01099967956543,-41.18299865722656 C-10.01099967956543,-41.18299865722656 107.86599731445312,1.7130000591278076 107.86599731445312,1.7130000591278076 C110.65299987792969,2.7360000610351562 110.65299987792969,4.388000011444092 107.86599731445312,5.4079999923706055 C107.86599731445312,5.4079999923706055 18.070999145507812,38.09299850463867 18.070999145507812,38.09299850463867 C18.070999145507812,41.06800079345703 15.788999557495117,42.65599822998047 13.001999855041504,41.64799880981445 C13.001999855041504,41.64799880981445 -104.8740005493164,-1.2510000467300415 -104.8740005493164,-1.2510000467300415 C-107.66100311279297,-2.2720000743865967 -109.94300079345703,-5.52400016784668 -109.94300079345703,-8.5 C-109.94300079345703,-8.5 -109.95600128173828,-8.5 -109.95600128173828,-8.5z">
                                                    </path>
                                                </g>
                                                <g opacity="1"
                                                    transform="matrix(0,1,-1,0,-136.98899841308594,165.21600341796875)">
                                                    <path fill="rgb(4,0,255)" fill-opacity="1"
                                                        d=" M0,-1.3489999771118164 C0.3068563938140869,-1.3489999771118164 0.5559999942779541,-0.7445130944252014 0.5559999942779541,0 C0.5559999942779541,0.7445130944252014 0.3068563938140869,1.3489999771118164 0,1.3489999771118164 C-0.3068563938140869,1.3489999771118164 -0.5559999942779541,0.7445130944252014 -0.5559999942779541,0 C-0.5559999942779541,-0.7445130944252014 -0.3068563938140869,-1.3489999771118164 0,-1.3489999771118164z">
                                                    </path>
                                                </g>
                                                <g opacity="1"
                                                    transform="matrix(0,1,-1,0,-118.95700073242188,171.7740020751953)">
                                                    <path fill="rgb(4,0,255)" fill-opacity="1"
                                                        d=" M0,-1.3489999771118164 C0.30575260519981384,-1.3489999771118164 0.5540000200271606,-0.7445130944252014 0.5540000200271606,0 C0.5540000200271606,0.7445130944252014 0.30575260519981384,1.3489999771118164 0,1.3489999771118164 C-0.30575260519981384,1.3489999771118164 -0.5540000200271606,0.7445130944252014 -0.5540000200271606,0 C-0.5540000200271606,-0.7445130944252014 -0.30575260519981384,-1.3489999771118164 0,-1.3489999771118164z">
                                                    </path>
                                                </g>
                                                <g opacity="1"
                                                    transform="matrix(0,1,-1,0,-100.927001953125,178.3280029296875)">
                                                    <path fill="rgb(4,0,255)" fill-opacity="1"
                                                        d=" M0,-1.3489999771118164 C0.3068563938140869,-1.3489999771118164 0.5559999942779541,-0.7445130944252014 0.5559999942779541,0 C0.5559999942779541,0.7445130944252014 0.3068563938140869,1.3489999771118164 0,1.3489999771118164 C-0.3068563938140869,1.3489999771118164 -0.5559999942779541,0.7445130944252014 -0.5559999942779541,0 C-0.5559999942779541,-0.7445130944252014 -0.3068563938140869,-1.3489999771118164 0,-1.3489999771118164z">
                                                    </path>
                                                </g>
                                                <g opacity="1"
                                                    transform="matrix(0,1,-1,0,-82.8949966430664,184.89999389648438)">
                                                    <path fill="rgb(4,0,255)" fill-opacity="1"
                                                        d=" M0,-1.3489999771118164 C0.3068563938140869,-1.3489999771118164 0.5559999942779541,-0.7445130944252014 0.5559999942779541,0 C0.5559999942779541,0.7445130944252014 0.3068563938140869,1.3489999771118164 0,1.3489999771118164 C-0.3068563938140869,1.3489999771118164 -0.5559999942779541,0.7445130944252014 -0.5559999942779541,0 C-0.5559999942779541,-0.7445130944252014 -0.3068563938140869,-1.3489999771118164 0,-1.3489999771118164z">
                                                    </path>
                                                </g>
                                                <g opacity="1"
                                                    transform="matrix(0,1,-1,0,-64.86399841308594,191.45399475097656)">
                                                    <path fill="rgb(4,0,255)" fill-opacity="1"
                                                        d=" M0,-1.3489999771118164 C0.30575260519981384,-1.3489999771118164 0.5540000200271606,-0.7445130944252014 0.5540000200271606,0 C0.5540000200271606,0.7445130944252014 0.30575260519981384,1.3489999771118164 0,1.3489999771118164 C-0.30575260519981384,1.3489999771118164 -0.5540000200271606,0.7445130944252014 -0.5540000200271606,0 C-0.5540000200271606,-0.7445130944252014 -0.30575260519981384,-1.3489999771118164 0,-1.3489999771118164z">
                                                    </path>
                                                </g>
                                                <g opacity="1"
                                                    transform="matrix(0,1,-1,0,-46.8489990234375,198.0260009765625)">
                                                    <path fill="rgb(4,0,255)" fill-opacity="1"
                                                        d=" M0,-1.3489999771118164 C0.30575260519981384,-1.3489999771118164 0.5540000200271606,-0.7445130944252014 0.5540000200271606,0 C0.5540000200271606,0.7445130944252014 0.30575260519981384,1.3489999771118164 0,1.3489999771118164 C-0.30575260519981384,1.3489999771118164 -0.5540000200271606,0.7445130944252014 -0.5540000200271606,0 C-0.5540000200271606,-0.7445130944252014 -0.30575260519981384,-1.3489999771118164 0,-1.3489999771118164z">
                                                    </path>
                                                </g>
                                                <g opacity="1"
                                                    transform="matrix(0,1,-1,0,-155.02000427246094,171.7740020751953)">
                                                    <path fill="rgb(4,0,255)" fill-opacity="1"
                                                        d=" M0,-1.3494999408721924 C0.30575260519981384,-1.3494999408721924 0.5540000200271606,-0.7447890043258667 0.5540000200271606,0 C0.5540000200271606,0.7447890043258667 0.30575260519981384,1.3494999408721924 0,1.3494999408721924 C-0.30575260519981384,1.3494999408721924 -0.5540000200271606,0.7447890043258667 -0.5540000200271606,0 C-0.5540000200271606,-0.7447890043258667 -0.30575260519981384,-1.3494999408721924 0,-1.3494999408721924z">
                                                    </path>
                                                </g>
                                                <g opacity="1"
                                                    transform="matrix(0,1,-1,0,-136.98899841308594,178.3280029296875)">
                                                    <path fill="rgb(4,0,255)" fill-opacity="1"
                                                        d=" M0,-1.3489999771118164 C0.3068563938140869,-1.3489999771118164 0.5559999942779541,-0.7445130944252014 0.5559999942779541,0 C0.5559999942779541,0.7445130944252014 0.3068563938140869,1.3489999771118164 0,1.3489999771118164 C-0.3068563938140869,1.3489999771118164 -0.5559999942779541,0.7445130944252014 -0.5559999942779541,0 C-0.5559999942779541,-0.7445130944252014 -0.3068563938140869,-1.3489999771118164 0,-1.3489999771118164z">
                                                    </path>
                                                </g>
                                                <g opacity="1"
                                                    transform="matrix(0,1,-1,0,-118.95700073242188,184.8979949951172)">
                                                    <path fill="rgb(4,0,255)" fill-opacity="1"
                                                        d=" M0,-1.3489999771118164 C0.30575260519981384,-1.3489999771118164 0.5540000200271606,-0.7445130944252014 0.5540000200271606,0 C0.5540000200271606,0.7445130944252014 0.30575260519981384,1.3489999771118164 0,1.3489999771118164 C-0.30575260519981384,1.3489999771118164 -0.5540000200271606,0.7445130944252014 -0.5540000200271606,0 C-0.5540000200271606,-0.7445130944252014 -0.30575260519981384,-1.3489999771118164 0,-1.3489999771118164z">
                                                    </path>
                                                </g>
                                                <g opacity="1"
                                                    transform="matrix(0,1,-1,0,-100.927001953125,191.45399475097656)">
                                                    <path fill="rgb(4,0,255)" fill-opacity="1"
                                                        d=" M0,-1.3489999771118164 C0.30575260519981384,-1.3489999771118164 0.5540000200271606,-0.7445130944252014 0.5540000200271606,0 C0.5540000200271606,0.7445130944252014 0.30575260519981384,1.3489999771118164 0,1.3489999771118164 C-0.30575260519981384,1.3489999771118164 -0.5540000200271606,0.7445130944252014 -0.5540000200271606,0 C-0.5540000200271606,-0.7445130944252014 -0.30575260519981384,-1.3489999771118164 0,-1.3489999771118164z">
                                                    </path>
                                                </g>
                                                <g opacity="1"
                                                    transform="matrix(0,1,-1,0,-82.8949966430664,198.0260009765625)">
                                                    <path fill="rgb(4,0,255)" fill-opacity="1"
                                                        d=" M0,-1.3489999771118164 C0.30575260519981384,-1.3489999771118164 0.5540000200271606,-0.7445130944252014 0.5540000200271606,0 C0.5540000200271606,0.7445130944252014 0.30575260519981384,1.3489999771118164 0,1.3489999771118164 C-0.30575260519981384,1.3489999771118164 -0.5540000200271606,0.7445130944252014 -0.5540000200271606,0 C-0.5540000200271606,-0.7445130944252014 -0.30575260519981384,-1.3489999771118164 0,-1.3489999771118164z">
                                                    </path>
                                                </g>
                                                <g opacity="1"
                                                    transform="matrix(0,1,-1,0,-64.86399841308594,204.58599853515625)">
                                                    <path fill="rgb(4,0,255)" fill-opacity="1"
                                                        d=" M0,-1.3489999771118164 C0.30575260519981384,-1.3489999771118164 0.5540000200271606,-0.7445130944252014 0.5540000200271606,0 C0.5540000200271606,0.7445130944252014 0.30575260519981384,1.3489999771118164 0,1.3489999771118164 C-0.30575260519981384,1.3489999771118164 -0.5540000200271606,0.7445130944252014 -0.5540000200271606,0 C-0.5540000200271606,-0.7445130944252014 -0.30575260519981384,-1.3489999771118164 0,-1.3489999771118164z">
                                                    </path>
                                                </g>
                                                <g opacity="1"
                                                    transform="matrix(0,1,-1,0,-173.052001953125,178.3280029296875)">
                                                    <path fill="rgb(4,0,255)" fill-opacity="1"
                                                        d=" M0,-1.3494999408721924 C0.3068563938140869,-1.3494999408721924 0.5559999942779541,-0.7447890043258667 0.5559999942779541,0 C0.5559999942779541,0.7447890043258667 0.3068563938140869,1.3494999408721924 0,1.3494999408721924 C-0.3068563938140869,1.3494999408721924 -0.5559999942779541,0.7447890043258667 -0.5559999942779541,0 C-0.5559999942779541,-0.7447890043258667 -0.3068563938140869,-1.3494999408721924 0,-1.3494999408721924z">
                                                    </path>
                                                </g>
                                                <g opacity="1"
                                                    transform="matrix(0,1,-1,0,-155.02000427246094,184.89999389648438)">
                                                    <path fill="rgb(4,0,255)" fill-opacity="1"
                                                        d=" M0,-1.3494999408721924 C0.3068563938140869,-1.3494999408721924 0.5559999942779541,-0.7447890043258667 0.5559999942779541,0 C0.5559999942779541,0.7447890043258667 0.3068563938140869,1.3494999408721924 0,1.3494999408721924 C-0.3068563938140869,1.3494999408721924 -0.5559999942779541,0.7447890043258667 -0.5559999942779541,0 C-0.5559999942779541,-0.7447890043258667 -0.3068563938140869,-1.3494999408721924 0,-1.3494999408721924z">
                                                    </path>
                                                </g>
                                                <g opacity="1"
                                                    transform="matrix(0,1,-1,0,-136.98899841308594,191.45399475097656)">
                                                    <path fill="rgb(4,0,255)" fill-opacity="1"
                                                        d=" M0,-1.3489999771118164 C0.30575260519981384,-1.3489999771118164 0.5540000200271606,-0.7445130944252014 0.5540000200271606,0 C0.5540000200271606,0.7445130944252014 0.30575260519981384,1.3489999771118164 0,1.3489999771118164 C-0.30575260519981384,1.3489999771118164 -0.5540000200271606,0.7445130944252014 -0.5540000200271606,0 C-0.5540000200271606,-0.7445130944252014 -0.30575260519981384,-1.3489999771118164 0,-1.3489999771118164z">
                                                    </path>
                                                </g>
                                                <g opacity="1"
                                                    transform="matrix(0,1,-1,0,-118.95700073242188,198.0279998779297)">
                                                    <path fill="rgb(4,0,255)" fill-opacity="1"
                                                        d=" M0,-1.3489999771118164 C0.3068563938140869,-1.3489999771118164 0.5559999942779541,-0.7445130944252014 0.5559999942779541,0 C0.5559999942779541,0.7445130944252014 0.3068563938140869,1.3489999771118164 0,1.3489999771118164 C-0.3068563938140869,1.3489999771118164 -0.5559999942779541,0.7445130944252014 -0.5559999942779541,0 C-0.5559999942779541,-0.7445130944252014 -0.3068563938140869,-1.3489999771118164 0,-1.3489999771118164z">
                                                    </path>
                                                </g>
                                                <g opacity="1"
                                                    transform="matrix(0,1,-1,0,-100.927001953125,204.58599853515625)">
                                                    <path fill="rgb(4,0,255)" fill-opacity="1"
                                                        d=" M0,-1.3489999771118164 C0.30575260519981384,-1.3489999771118164 0.5540000200271606,-0.7445130944252014 0.5540000200271606,0 C0.5540000200271606,0.7445130944252014 0.30575260519981384,1.3489999771118164 0,1.3489999771118164 C-0.30575260519981384,1.3489999771118164 -0.5540000200271606,0.7445130944252014 -0.5540000200271606,0 C-0.5540000200271606,-0.7445130944252014 -0.30575260519981384,-1.3489999771118164 0,-1.3489999771118164z">
                                                    </path>
                                                </g>
                                                <g opacity="1"
                                                    transform="matrix(0,1,-1,0,-82.8949966430664,211.1540069580078)">
                                                    <path fill="rgb(4,0,255)" fill-opacity="1"
                                                        d=" M0,-1.3489999771118164 C0.30575260519981384,-1.3489999771118164 0.5540000200271606,-0.7445130944252014 0.5540000200271606,0 C0.5540000200271606,0.7445130944252014 0.30575260519981384,1.3489999771118164 0,1.3489999771118164 C-0.30575260519981384,1.3489999771118164 -0.5540000200271606,0.7445130944252014 -0.5540000200271606,0 C-0.5540000200271606,-0.7445130944252014 -0.30575260519981384,-1.3489999771118164 0,-1.3489999771118164z">
                                                    </path>
                                                </g>
                                                <g opacity="1"
                                                    transform="matrix(0,1,-1,0,-191.08299255371094,184.8979949951172)">
                                                    <path fill="rgb(4,0,255)" fill-opacity="1"
                                                        d=" M0,-1.3494999408721924 C0.30575260519981384,-1.3494999408721924 0.5540000200271606,-0.7447890043258667 0.5540000200271606,0 C0.5540000200271606,0.7447890043258667 0.30575260519981384,1.3494999408721924 0,1.3494999408721924 C-0.30575260519981384,1.3494999408721924 -0.5540000200271606,0.7447890043258667 -0.5540000200271606,0 C-0.5540000200271606,-0.7447890043258667 -0.30575260519981384,-1.3494999408721924 0,-1.3494999408721924z">
                                                    </path>
                                                </g>
                                                <g opacity="1"
                                                    transform="matrix(0,1,-1,0,-173.052001953125,191.45399475097656)">
                                                    <path fill="rgb(4,0,255)" fill-opacity="1"
                                                        d=" M0,-1.3494999408721924 C0.30575260519981384,-1.3494999408721924 0.5540000200271606,-0.7447890043258667 0.5540000200271606,0 C0.5540000200271606,0.7447890043258667 0.30575260519981384,1.3494999408721924 0,1.3494999408721924 C-0.30575260519981384,1.3494999408721924 -0.5540000200271606,0.7447890043258667 -0.5540000200271606,0 C-0.5540000200271606,-0.7447890043258667 -0.30575260519981384,-1.3494999408721924 0,-1.3494999408721924z">
                                                    </path>
                                                </g>
                                                <g opacity="1"
                                                    transform="matrix(0,1,-1,0,-155.02000427246094,198.0260009765625)">
                                                    <path fill="rgb(4,0,255)" fill-opacity="1"
                                                        d=" M0,-1.3494999408721924 C0.30575260519981384,-1.3494999408721924 0.5540000200271606,-0.7447890043258667 0.5540000200271606,0 C0.5540000200271606,0.7447890043258667 0.30575260519981384,1.3494999408721924 0,1.3494999408721924 C-0.30575260519981384,1.3494999408721924 -0.5540000200271606,0.7447890043258667 -0.5540000200271606,0 C-0.5540000200271606,-0.7447890043258667 -0.30575260519981384,-1.3494999408721924 0,-1.3494999408721924z">
                                                    </path>
                                                </g>
                                                <g opacity="1"
                                                    transform="matrix(0,1,-1,0,-136.98899841308594,204.58599853515625)">
                                                    <path fill="rgb(4,0,255)" fill-opacity="1"
                                                        d=" M0,-1.3489999771118164 C0.30575260519981384,-1.3489999771118164 0.5540000200271606,-0.7445130944252014 0.5540000200271606,0 C0.5540000200271606,0.7445130944252014 0.30575260519981384,1.3489999771118164 0,1.3489999771118164 C-0.30575260519981384,1.3489999771118164 -0.5540000200271606,0.7445130944252014 -0.5540000200271606,0 C-0.5540000200271606,-0.7445130944252014 -0.30575260519981384,-1.3489999771118164 0,-1.3489999771118164z">
                                                    </path>
                                                </g>
                                                <g opacity="1"
                                                    transform="matrix(0,1,-1,0,-118.95700073242188,211.1540069580078)">
                                                    <path fill="rgb(4,0,255)" fill-opacity="1"
                                                        d=" M0,-1.3489999771118164 C0.30575260519981384,-1.3489999771118164 0.5540000200271606,-0.7445130944252014 0.5540000200271606,0 C0.5540000200271606,0.7445130944252014 0.30575260519981384,1.3489999771118164 0,1.3489999771118164 C-0.30575260519981384,1.3489999771118164 -0.5540000200271606,0.7445130944252014 -0.5540000200271606,0 C-0.5540000200271606,-0.7445130944252014 -0.30575260519981384,-1.3489999771118164 0,-1.3489999771118164z">
                                                    </path>
                                                </g>
                                                <g opacity="1"
                                                    transform="matrix(0,1,-1,0,-100.927001953125,217.70799255371094)">
                                                    <path fill="rgb(4,0,255)" fill-opacity="1"
                                                        d=" M0,-1.3489999771118164 C0.3068563938140869,-1.3489999771118164 0.5559999942779541,-0.7445130944252014 0.5559999942779541,0 C0.5559999942779541,0.7445130944252014 0.3068563938140869,1.3489999771118164 0,1.3489999771118164 C-0.3068563938140869,1.3489999771118164 -0.5559999942779541,0.7445130944252014 -0.5559999942779541,0 C-0.5559999942779541,-0.7445130944252014 -0.3068563938140869,-1.3489999771118164 0,-1.3489999771118164z">
                                                    </path>
                                                </g>
                                                <g opacity="1"
                                                    transform="matrix(1,0,0,1,88.65299987792969,260.5379943847656)">
                                                    <path fill="rgb(27,27,27)" fill-opacity="1"
                                                        d=" M-17.724000930786133,12.553999900817871 C-17.724000930786133,12.553999900817871 27.77199935913086,-4.001999855041504 27.77199935913086,-4.001999855041504 C27.77199935913086,-4.001999855041504 17.724000930786133,-12.553999900817871 17.724000930786133,-12.553999900817871 C17.724000930786133,-12.553999900817871 -27.77199935913086,4.00600004196167 -27.77199935913086,4.00600004196167 C-27.77199935913086,4.00600004196167 -17.724000930786133,12.553999900817871 -17.724000930786133,12.553999900817871z">
                                                    </path>
                                                </g>
                                                <g opacity="1"
                                                    transform="matrix(1,0,0,1,121.40499877929688,248.6199951171875)">
                                                    <path fill="rgb(27,27,27)" fill-opacity="1"
                                                        d=" M1.1360000371932983,5.688000202178955 C1.1360000371932983,5.688000202178955 8.916000366210938,2.864000082015991 8.916000366210938,2.864000082015991 C8.916000366210938,2.864000082015991 -1.1360000371932983,-5.688000202178955 -1.1360000371932983,-5.688000202178955 C-1.1360000371932983,-5.688000202178955 -8.916000366210938,-2.864000082015991 -8.916000366210938,-2.864000082015991 C-8.916000366210938,-2.864000082015991 1.1360000371932983,5.688000202178955 1.1360000371932983,5.688000202178955z">
                                                    </path>
                                                </g>
                                                <g opacity="1"
                                                    transform="matrix(1,0,0,1,-42.029998779296875,211.95899963378906)">
                                                    <path stroke-linecap="butt" stroke-linejoin="miter" fill-opacity="0"
                                                        stroke-miterlimit="10" stroke="rgb(4,0,255)" stroke-opacity="1"
                                                        stroke-width="1"
                                                        d=" M311.7799987792969,-23.437999725341797 C311.7799987792969,-23.437999725341797 78.5479965209961,61.45000076293945 78.5479965209961,61.45000076293945 C71.12000274658203,64.1500015258789 58.97600173950195,64.1500015258789 51.54800033569336,61.45000076293945 C51.54800033569336,61.45000076293945 -311.7659912109375,-70.77400207519531 -311.7659912109375,-70.77400207519531 C-315.4729919433594,-72.1259994506836 -317.3399963378906,-73.9020004272461 -317.3399963378906,-75.69400024414062 C-317.3399963378906,-75.69400024414062 -317.3399963378906,-63.486000061035156 -317.3399963378906,-63.486000061035156 C-317.3399963378906,-61.709999084472656 -315.4859924316406,-59.917999267578125 -311.7659912109375,-58.57099914550781 C-311.7659912109375,-58.57099914550781 51.5359992980957,73.66899871826172 51.5359992980957,73.66899871826172 C58.9640007019043,76.36900329589844 71.10800170898438,76.36900329589844 78.53600311279297,73.66899871826172 C78.53600311279297,73.66899871826172 311.7640075683594,-11.218999862670898 311.7640075683594,-11.218999862670898 C315.47198486328125,-12.571000099182129 317.3399963378906,-14.347000122070312 317.3399963378906,-16.138999938964844 C317.3399963378906,-16.138999938964844 317.3399963378906,-28.341999053955078 317.3399963378906,-28.341999053955078 C317.3399963378906,-26.56599998474121 315.4840087890625,-24.78700065612793 311.7640075683594,-23.426000595092773 C311.7640075683594,-23.426000595092773 311.7799987792969,-23.437999725341797 311.7799987792969,-23.437999725341797z">
                                                    </path>
                                                </g>
                                            </g>
                                        </g>
                                        <g mask="url(#__lottie_element_495_1)" style="display: block;">
                                            <g id="2851" clip-path="url(#__lottie_element_453)"
                                                transform="matrix(0.9994539022445679,0.0044884467497467995,-0.0044884467497467995,0.9994539022445679,12.956817626953125,248.1988525390625)"
                                                opacity="1">
                                                <g id="2828"
                                                    transform="matrix(-0.4414737820625305,0.23473578691482544,0.23473578691482544,0.4414737820625305,236.95799255371094,265.29998779296875)"
                                                    opacity="1" style="display: block;">
                                                    <g opacity="1" transform="matrix(1,0,0,1,0,0)">
                                                        <path fill="rgb(27,27,27)" fill-opacity="1"
                                                            d=" M-178.73199462890625,-4.696000099182129 C-178.73199462890625,-4.696000099182129 -178.01699829101562,-210.17999267578125 -178.01699829101562,-210.17999267578125 C-177.99000549316406,-218.697998046875 -175.27000427246094,-224.3820037841797 -170.86900329589844,-226.697998046875 C-163.32699584960938,-230.66799926757812 -157.8300018310547,-229.0070037841797 -147.6820068359375,-226.84500122070312 C-147.6820068359375,-226.84500122070312 176.20700073242188,-153.1929931640625 176.20700073242188,-153.1929931640625 C176.20700073242188,-153.1929931640625 178.75100708007812,229.10499572753906 178.75100708007812,229.10499572753906 C178.75100708007812,229.10499572753906 -157.00100708007812,150.98500061035156 -157.00100708007812,150.98500061035156 C-169.73899841308594,148.0229949951172 -178.7530059814453,136.66799926757812 -178.75100708007812,123.58899688720703 C-178.75100708007812,123.58899688720703 -178.73199462890625,-4.696000099182129 -178.73199462890625,-4.696000099182129z">
                                                        </path>
                                                    </g>
                                                </g>
                                                <g mask="url(#__lottie_element_486_1)" style="display: block;">
                                                    <g id="2829"
                                                        transform="matrix(-0.4414737820625305,0.23473578691482544,0.23473578691482544,0.4414737820625305,230.98350524902344,281.6485900878906)"
                                                        opacity="1">
                                                        <g opacity="1" transform="matrix(1,0,0,1,0,0)">
                                                            <path stroke-linecap="butt" stroke-linejoin="miter"
                                                                fill-opacity="0" stroke-miterlimit="4"
                                                                stroke="rgb(46,204,255)" stroke-opacity="1"
                                                                stroke-width="2"
                                                                d=" M145.7449951171875,-207.18299865722656 C145.7449951171875,-207.18299865722656 -203.79800415039062,-288.42401123046875 -203.79800415039062,-288.42401123046875">
                                                            </path>
                                                        </g>
                                                        <g opacity="1" transform="matrix(1,0,0,1,0,0)">
                                                            <path stroke-linecap="butt" stroke-linejoin="miter"
                                                                fill-opacity="0" stroke-miterlimit="4"
                                                                stroke="rgb(46,204,255)" stroke-opacity="1"
                                                                stroke-width="2"
                                                                d=" M145.7449951171875,-159.322998046875 C145.7449951171875,-159.322998046875 -203.79800415039062,-240.56399536132812 -203.79800415039062,-240.56399536132812">
                                                            </path>
                                                        </g>
                                                        <g opacity="1" transform="matrix(1,0,0,1,0,0)">
                                                            <path stroke-linecap="butt" stroke-linejoin="miter"
                                                                fill-opacity="0" stroke-miterlimit="4"
                                                                stroke="rgb(46,204,255)" stroke-opacity="1"
                                                                stroke-width="2"
                                                                d=" M145.7449951171875,-111.46299743652344 C145.7449951171875,-111.46299743652344 -203.79800415039062,-192.70399475097656 -203.79800415039062,-192.70399475097656">
                                                            </path>
                                                        </g>
                                                        <g opacity="1" transform="matrix(1,0,0,1,0,0)">
                                                            <path stroke-linecap="butt" stroke-linejoin="miter"
                                                                fill-opacity="0" stroke-miterlimit="4"
                                                                stroke="rgb(46,204,255)" stroke-opacity="1"
                                                                stroke-width="2"
                                                                d=" M145.7449951171875,-63.60300064086914 C145.7449951171875,-63.60300064086914 -203.79800415039062,-144.843994140625 -203.79800415039062,-144.843994140625">
                                                            </path>
                                                        </g>
                                                        <g opacity="1" transform="matrix(1,0,0,1,0,0)">
                                                            <path stroke-linecap="butt" stroke-linejoin="miter"
                                                                fill-opacity="0" stroke-miterlimit="4"
                                                                stroke="rgb(46,204,255)" stroke-opacity="1"
                                                                stroke-width="2"
                                                                d=" M145.7449951171875,-15.743000030517578 C145.7449951171875,-15.743000030517578 -203.79800415039062,-96.98400115966797 -203.79800415039062,-96.98400115966797">
                                                            </path>
                                                        </g>
                                                        <g opacity="1" transform="matrix(1,0,0,1,0,0)">
                                                            <path stroke-linecap="butt" stroke-linejoin="miter"
                                                                fill-opacity="0" stroke-miterlimit="4"
                                                                stroke="rgb(46,204,255)" stroke-opacity="1"
                                                                stroke-width="2"
                                                                d=" M145.7449951171875,32.11600112915039 C145.7449951171875,32.11600112915039 -203.79800415039062,-49.125 -203.79800415039062,-49.125">
                                                            </path>
                                                        </g>
                                                        <g opacity="1" transform="matrix(1,0,0,1,0,0)">
                                                            <path stroke-linecap="butt" stroke-linejoin="miter"
                                                                fill-opacity="0" stroke-miterlimit="4"
                                                                stroke="rgb(46,204,255)" stroke-opacity="1"
                                                                stroke-width="2"
                                                                d=" M145.7449951171875,79.97599792480469 C145.7449951171875,79.97599792480469 -203.79800415039062,-1.2640000581741333 -203.79800415039062,-1.2640000581741333">
                                                            </path>
                                                        </g>
                                                        <g opacity="1" transform="matrix(1,0,0,1,0,0)">
                                                            <path stroke-linecap="butt" stroke-linejoin="miter"
                                                                fill-opacity="0" stroke-miterlimit="4"
                                                                stroke="rgb(46,204,255)" stroke-opacity="1"
                                                                stroke-width="2"
                                                                d=" M145.7449951171875,127.83699798583984 C145.7449951171875,127.83699798583984 -203.79800415039062,46.59600067138672 -203.79800415039062,46.59600067138672">
                                                            </path>
                                                        </g>
                                                        <g opacity="1" transform="matrix(1,0,0,1,0,0)">
                                                            <path stroke-linecap="butt" stroke-linejoin="miter"
                                                                fill-opacity="0" stroke-miterlimit="4"
                                                                stroke="rgb(46,204,255)" stroke-opacity="1"
                                                                stroke-width="2"
                                                                d=" M-159.77999877929688,56.83100128173828 C-159.77999877929688,56.83100128173828 -157.302001953125,-322.3280029296875 -157.302001953125,-322.3280029296875">
                                                            </path>
                                                        </g>
                                                        <g opacity="1" transform="matrix(1,0,0,1,0,0)">
                                                            <path stroke-linecap="butt" stroke-linejoin="miter"
                                                                fill-opacity="0" stroke-miterlimit="4"
                                                                stroke="rgb(46,204,255)" stroke-opacity="1"
                                                                stroke-width="2"
                                                                d=" M-114.80500030517578,67.28500366210938 C-114.80500030517578,67.28500366210938 -112.32599639892578,-312.1000061035156 -112.32599639892578,-312.1000061035156">
                                                            </path>
                                                        </g>
                                                        <g opacity="1" transform="matrix(1,0,0,1,0,0)">
                                                            <path stroke-linecap="butt" stroke-linejoin="miter"
                                                                fill-opacity="0" stroke-miterlimit="4"
                                                                stroke="rgb(46,204,255)" stroke-opacity="1"
                                                                stroke-width="2"
                                                                d=" M-69.83499908447266,77.73600006103516 C-69.83499908447266,77.73600006103516 -67.33699798583984,-301.8699951171875 -67.33699798583984,-301.8699951171875">
                                                            </path>
                                                        </g>
                                                        <g opacity="1" transform="matrix(1,0,0,1,0,0)">
                                                            <path stroke-linecap="butt" stroke-linejoin="miter"
                                                                fill-opacity="0" stroke-miterlimit="4"
                                                                stroke="rgb(46,204,255)" stroke-opacity="1"
                                                                stroke-width="2"
                                                                d=" M-24.871000289916992,88.18699645996094 C-24.871000289916992,88.18699645996094 -22.424999237060547,-291.6570129394531 -22.424999237060547,-291.6570129394531">
                                                            </path>
                                                        </g>
                                                        <g opacity="1" transform="matrix(1,0,0,1,0,0)">
                                                            <path stroke-linecap="butt" stroke-linejoin="miter"
                                                                fill-opacity="0" stroke-miterlimit="4"
                                                                stroke="rgb(46,204,255)" stroke-opacity="1"
                                                                stroke-width="2"
                                                                d=" M20.097000122070312,98.63800048828125 C20.097000122070312,98.63800048828125 22.54400062561035,-281.4309997558594 22.54400062561035,-281.4309997558594">
                                                            </path>
                                                        </g>
                                                        <g opacity="1" transform="matrix(1,0,0,1,0,0)">
                                                            <path stroke-linecap="butt" stroke-linejoin="miter"
                                                                fill-opacity="0" stroke-miterlimit="4"
                                                                stroke="rgb(46,204,255)" stroke-opacity="1"
                                                                stroke-width="2"
                                                                d=" M65.06600189208984,109.08999633789062 C65.06600189208984,109.08999633789062 67.51499938964844,-271.2049865722656 67.51499938964844,-271.2049865722656">
                                                            </path>
                                                        </g>
                                                        <g opacity="1" transform="matrix(1,0,0,1,0,0)">
                                                            <path fill="rgb(46,204,255)" fill-opacity="1"
                                                                d=" M-88.81600189208984,-213.83900451660156 C-107.91400146484375,-217.11099243164062 -112.66100311279297,-206.89700317382812 -112.83799743652344,-184.2310028076172 C-112.6780014038086,-206.9080047607422 -116.96900177001953,-221.2570037841797 -135.64300537109375,-224.72300720214844 C-116.96900177001953,-221.2570037841797 -111.39700317382812,-228.4199981689453 -112.56800079345703,-251.61099243164062 C-112.36399841308594,-228.59300231933594 -107.91000366210938,-217.11199951171875 -88.81300354003906,-213.83900451660156 C-88.81300354003906,-213.83900451660156 -88.81600189208984,-213.83900451660156 -88.81600189208984,-213.83900451660156z">
                                                            </path>
                                                            <path stroke-linecap="round" stroke-linejoin="round"
                                                                fill-opacity="0" stroke="rgb(46,204,255)"
                                                                stroke-opacity="1" stroke-width="2"
                                                                d=" M-88.81600189208984,-213.83900451660156 C-107.91400146484375,-217.11099243164062 -112.66100311279297,-206.89700317382812 -112.83799743652344,-184.2310028076172 C-112.6780014038086,-206.9080047607422 -116.96900177001953,-221.2570037841797 -135.64300537109375,-224.72300720214844 C-116.96900177001953,-221.2570037841797 -111.39700317382812,-228.4199981689453 -112.56800079345703,-251.61099243164062 C-112.36399841308594,-228.59300231933594 -107.91000366210938,-217.11199951171875 -88.81300354003906,-213.83900451660156 C-88.81300354003906,-213.83900451660156 -88.81600189208984,-213.83900451660156 -88.81600189208984,-213.83900451660156z">
                                                            </path>
                                                        </g>
                                                        <g opacity="1" transform="matrix(1,0,0,1,0,0)">
                                                            <path fill="rgb(46,204,255)" fill-opacity="1"
                                                                d=" M-44.409000396728516,-59.92900085449219 C-63.50600051879883,-63.20100021362305 -69.03500366210938,-52.98699951171875 -69.21199798583984,-30.320999145507812 C-69.052001953125,-52.99800109863281 -72.56099700927734,-67.34700012207031 -91.23600006103516,-70.81300354003906 C-72.56099700927734,-67.34700012207031 -67.48999786376953,-74.51000213623047 -68.66100311279297,-97.70099639892578 C-68.45700073242188,-74.68299865722656 -63.50299835205078,-63.20199966430664 -44.40599822998047,-59.92900085449219 C-44.40599822998047,-59.92900085449219 -44.409000396728516,-59.92900085449219 -44.409000396728516,-59.92900085449219z">
                                                            </path>
                                                            <path stroke-linecap="round" stroke-linejoin="round"
                                                                fill-opacity="0" stroke="rgb(46,204,255)"
                                                                stroke-opacity="1" stroke-width="2"
                                                                d=" M-44.409000396728516,-59.92900085449219 C-63.50600051879883,-63.20100021362305 -69.03500366210938,-52.98699951171875 -69.21199798583984,-30.320999145507812 C-69.052001953125,-52.99800109863281 -72.56099700927734,-67.34700012207031 -91.23600006103516,-70.81300354003906 C-72.56099700927734,-67.34700012207031 -67.48999786376953,-74.51000213623047 -68.66100311279297,-97.70099639892578 C-68.45700073242188,-74.68299865722656 -63.50299835205078,-63.20199966430664 -44.40599822998047,-59.92900085449219 C-44.40599822998047,-59.92900085449219 -44.409000396728516,-59.92900085449219 -44.409000396728516,-59.92900085449219z">
                                                            </path>
                                                        </g>
                                                        <g opacity="1" transform="matrix(1,0,0,1,0,0)">
                                                            <path stroke-linecap="butt" stroke-linejoin="miter"
                                                                fill-opacity="0" stroke-miterlimit="4"
                                                                stroke="rgb(46,204,255)" stroke-opacity="1"
                                                                stroke-width="2"
                                                                d=" M143.28500366210938,171.9770050048828 C143.28500366210938,171.9770050048828 -206.25799560546875,90.73500061035156 -206.25799560546875,90.73500061035156">
                                                            </path>
                                                        </g>
                                                        <g opacity="1" transform="matrix(1,0,0,1,0,0)">
                                                            <path stroke-linecap="butt" stroke-linejoin="miter"
                                                                fill-opacity="0" stroke-miterlimit="4"
                                                                stroke="rgb(46,204,255)" stroke-opacity="1"
                                                                stroke-width="2"
                                                                d=" M143.28500366210938,219.83700561523438 C143.28500366210938,219.83700561523438 -206.25799560546875,138.59500122070312 -206.25799560546875,138.59500122070312">
                                                            </path>
                                                        </g>
                                                        <g opacity="1" transform="matrix(1,0,0,1,0,0)">
                                                            <path stroke-linecap="butt" stroke-linejoin="miter"
                                                                fill-opacity="0" stroke-miterlimit="4"
                                                                stroke="rgb(46,204,255)" stroke-opacity="1"
                                                                stroke-width="2"
                                                                d=" M143.28500366210938,267.6960144042969 C143.28500366210938,267.6960144042969 -206.25799560546875,186.4550018310547 -206.25799560546875,186.4550018310547">
                                                            </path>
                                                        </g>
                                                        <g opacity="1" transform="matrix(1,0,0,1,0,0)">
                                                            <path stroke-linecap="butt" stroke-linejoin="miter"
                                                                fill-opacity="0" stroke-miterlimit="4"
                                                                stroke="rgb(46,204,255)" stroke-opacity="1"
                                                                stroke-width="2"
                                                                d=" M143.28500366210938,315.5559997558594 C143.28500366210938,315.5559997558594 -206.25799560546875,234.31500244140625 -206.25799560546875,234.31500244140625">
                                                            </path>
                                                        </g>
                                                        <g opacity="1" transform="matrix(1,0,0,1,0,0)">
                                                            <path stroke-linecap="butt" stroke-linejoin="miter"
                                                                fill-opacity="0" stroke-miterlimit="4"
                                                                stroke="rgb(46,204,255)" stroke-opacity="1"
                                                                stroke-width="2"
                                                                d=" M143.28500366210938,363.4159851074219 C143.28500366210938,363.4159851074219 -206.25799560546875,282.17498779296875 -206.25799560546875,282.17498779296875">
                                                            </path>
                                                        </g>
                                                        <g opacity="1" transform="matrix(1,0,0,1,0,0)">
                                                            <path stroke-linecap="butt" stroke-linejoin="miter"
                                                                fill-opacity="0" stroke-miterlimit="4"
                                                                stroke="rgb(46,204,255)" stroke-opacity="1"
                                                                stroke-width="2"
                                                                d=" M143.28500366210938,411.2749938964844 C143.28500366210938,411.2749938964844 -206.25799560546875,330.0350036621094 -206.25799560546875,330.0350036621094">
                                                            </path>
                                                        </g>
                                                        <g opacity="1" transform="matrix(1,0,0,1,0,0)">
                                                            <path stroke-linecap="butt" stroke-linejoin="miter"
                                                                fill-opacity="0" stroke-miterlimit="4"
                                                                stroke="rgb(46,204,255)" stroke-opacity="1"
                                                                stroke-width="2"
                                                                d=" M143.28500366210938,459.135009765625 C143.28500366210938,459.135009765625 -206.25799560546875,377.8949890136719 -206.25799560546875,377.8949890136719">
                                                            </path>
                                                        </g>
                                                        <g opacity="1" transform="matrix(1,0,0,1,0,0)">
                                                            <path stroke-linecap="butt" stroke-linejoin="miter"
                                                                fill-opacity="0" stroke-miterlimit="4"
                                                                stroke="rgb(46,204,255)" stroke-opacity="1"
                                                                stroke-width="2"
                                                                d=" M143.28500366210938,506.99700927734375 C143.28500366210938,506.99700927734375 -206.25799560546875,425.7550048828125 -206.25799560546875,425.7550048828125">
                                                            </path>
                                                        </g>
                                                        <g opacity="1" transform="matrix(1,0,0,1,0,0)">
                                                            <path stroke-linecap="butt" stroke-linejoin="miter"
                                                                fill-opacity="0" stroke-miterlimit="4"
                                                                stroke="rgb(46,204,255)" stroke-opacity="1"
                                                                stroke-width="2"
                                                                d=" M-162.24000549316406,435.9909973144531 C-162.24000549316406,435.9909973144531 -159.76199340820312,56.83100128173828 -159.76199340820312,56.83100128173828">
                                                            </path>
                                                        </g>
                                                        <g opacity="1" transform="matrix(1,0,0,1,0,0)">
                                                            <path stroke-linecap="butt" stroke-linejoin="miter"
                                                                fill-opacity="0" stroke-miterlimit="4"
                                                                stroke="rgb(46,204,255)" stroke-opacity="1"
                                                                stroke-width="2"
                                                                d=" M-117.26399993896484,446.4440002441406 C-117.26399993896484,446.4440002441406 -114.78600311279297,67.05899810791016 -114.78600311279297,67.05899810791016">
                                                            </path>
                                                        </g>
                                                        <g opacity="1" transform="matrix(1,0,0,1,0,0)">
                                                            <path stroke-linecap="butt" stroke-linejoin="miter"
                                                                fill-opacity="0" stroke-miterlimit="4"
                                                                stroke="rgb(46,204,255)" stroke-opacity="1"
                                                                stroke-width="2"
                                                                d=" M-72.29399871826172,456.89599609375 C-72.29399871826172,456.89599609375 -69.7969970703125,77.28900146484375 -69.7969970703125,77.28900146484375">
                                                            </path>
                                                        </g>
                                                        <g opacity="1" transform="matrix(1,0,0,1,0,0)">
                                                            <path stroke-linecap="butt" stroke-linejoin="miter"
                                                                fill-opacity="0" stroke-miterlimit="4"
                                                                stroke="rgb(46,204,255)" stroke-opacity="1"
                                                                stroke-width="2"
                                                                d=" M-27.33099937438965,467.34600830078125 C-27.33099937438965,467.34600830078125 -24.885000228881836,87.50199890136719 -24.885000228881836,87.50199890136719">
                                                            </path>
                                                        </g>
                                                        <g opacity="1" transform="matrix(1,0,0,1,0,0)">
                                                            <path stroke-linecap="butt" stroke-linejoin="miter"
                                                                fill-opacity="0" stroke-miterlimit="4"
                                                                stroke="rgb(46,204,255)" stroke-opacity="1"
                                                                stroke-width="2"
                                                                d=" M17.63800048828125,477.7980041503906 C17.63800048828125,477.7980041503906 20.083999633789062,97.72799682617188 20.083999633789062,97.72799682617188">
                                                            </path>
                                                        </g>
                                                        <g opacity="1" transform="matrix(1,0,0,1,0,0)">
                                                            <path stroke-linecap="butt" stroke-linejoin="miter"
                                                                fill-opacity="0" stroke-miterlimit="4"
                                                                stroke="rgb(46,204,255)" stroke-opacity="1"
                                                                stroke-width="2"
                                                                d=" M62.60599899291992,488.2489929199219 C62.60599899291992,488.2489929199219 65.05500030517578,107.95500183105469 65.05500030517578,107.95500183105469">
                                                            </path>
                                                        </g>
                                                        <g opacity="1" transform="matrix(1,0,0,1,0,0)">
                                                            <path fill="rgb(46,204,255)" fill-opacity="1"
                                                                d=" M-91.2760009765625,165.3209991455078 C-110.37300109863281,162.04800415039062 -115.12100219726562,172.26199340820312 -115.2979965209961,194.92799377441406 C-115.13700103759766,172.25100708007812 -119.4280014038086,157.90199279785156 -138.10299682617188,154.43600463867188 C-119.4280014038086,157.90199279785156 -113.85700225830078,150.73899841308594 -115.02799987792969,127.5479965209961 C-114.8239974975586,150.5659942626953 -110.37000274658203,162.04800415039062 -91.27300262451172,165.32000732421875 C-91.27300262451172,165.32000732421875 -91.2760009765625,165.3209991455078 -91.2760009765625,165.3209991455078z">
                                                            </path>
                                                            <path stroke-linecap="round" stroke-linejoin="round"
                                                                fill-opacity="0" stroke="rgb(46,204,255)"
                                                                stroke-opacity="1" stroke-width="2"
                                                                d=" M-91.2760009765625,165.3209991455078 C-110.37300109863281,162.04800415039062 -115.12100219726562,172.26199340820312 -115.2979965209961,194.92799377441406 C-115.13700103759766,172.25100708007812 -119.4280014038086,157.90199279785156 -138.10299682617188,154.43600463867188 C-119.4280014038086,157.90199279785156 -113.85700225830078,150.73899841308594 -115.02799987792969,127.5479965209961 C-114.8239974975586,150.5659942626953 -110.37000274658203,162.04800415039062 -91.27300262451172,165.32000732421875 C-91.27300262451172,165.32000732421875 -91.2760009765625,165.3209991455078 -91.2760009765625,165.3209991455078z">
                                                            </path>
                                                        </g>
                                                        <g opacity="1" transform="matrix(1,0,0,1,0,0)">
                                                            <path fill="rgb(46,204,255)" fill-opacity="1"
                                                                d=" M-46.86899948120117,319.2309875488281 C-65.96600341796875,315.9580078125 -71.33799743652344,326.1730041503906 -71.51599884033203,348.8380126953125 C-71.3550033569336,326.1610107421875 -75.02100372314453,311.81201171875 -93.69599914550781,308.34600830078125 C-75.02100372314453,311.81201171875 -69.91899871826172,304.64898681640625 -71.08999633789062,281.4580078125 C-70.88600158691406,304.47601318359375 -65.96299743652344,315.9580078125 -46.86600112915039,319.2300109863281 C-46.86600112915039,319.2300109863281 -46.86899948120117,319.2309875488281 -46.86899948120117,319.2309875488281z">
                                                            </path>
                                                            <path stroke-linecap="round" stroke-linejoin="round"
                                                                fill-opacity="0" stroke="rgb(46,204,255)"
                                                                stroke-opacity="1" stroke-width="2"
                                                                d=" M-46.86899948120117,319.2309875488281 C-65.96600341796875,315.9580078125 -71.33799743652344,326.1730041503906 -71.51599884033203,348.8380126953125 C-71.3550033569336,326.1610107421875 -75.02100372314453,311.81201171875 -93.69599914550781,308.34600830078125 C-75.02100372314453,311.81201171875 -69.91899871826172,304.64898681640625 -71.08999633789062,281.4580078125 C-70.88600158691406,304.47601318359375 -65.96299743652344,315.9580078125 -46.86600112915039,319.2300109863281 C-46.86600112915039,319.2300109863281 -46.86899948120117,319.2309875488281 -46.86899948120117,319.2309875488281z">
                                                            </path>
                                                        </g>
                                                    </g>
                                                </g>
                                                <g mask="url(#__lottie_element_479_1)" style="display: block;">
                                                    <g id="2831"
                                                        transform="matrix(-0.4414737820625305,0.23473578691482544,0.23473578691482544,0.4414737820625305,248.99072265625,315.0303649902344)"
                                                        opacity="1">
                                                        <g opacity="1" transform="matrix(1,0,0,1,0,0)">
                                                            <path fill="url(#__lottie_element_485)" fill-opacity="1"
                                                                d=" M-352,-510 C-352,-510 -348,54 -348,54 C-348,54 -68,-412 -68,-412 C-68,-412 -352,-510 -352,-510z">
                                                            </path>
                                                        </g>
                                                    </g>
                                                </g>
                                                <g id="2833"
                                                    transform="matrix(-0.4414737820625305,0.23473578691482544,0.23473578691482544,0.4414737820625305,236.95799255371094,265.29998779296875)"
                                                    opacity="1" style="display: block;">
                                                    <g opacity="1" transform="matrix(1,0,0,1,0,0)">
                                                        <path stroke-linecap="round" stroke-linejoin="round"
                                                            fill-opacity="0" stroke="rgb(4,0,255)" stroke-opacity="1"
                                                            stroke-width="2"
                                                            d=" M-178.73199462890625,-4.696000099182129 C-178.73199462890625,-4.696000099182129 -178.01699829101562,-210.17999267578125 -178.01699829101562,-210.17999267578125 C-177.99000549316406,-218.697998046875 -175.27000427246094,-224.3820037841797 -170.86900329589844,-226.697998046875 C-163.32699584960938,-230.66799926757812 -157.8300018310547,-229.0070037841797 -147.6820068359375,-226.84500122070312 C-147.6820068359375,-226.84500122070312 176.20700073242188,-153.1929931640625 176.20700073242188,-153.1929931640625 C176.20700073242188,-153.1929931640625 178.75100708007812,229.10499572753906 178.75100708007812,229.10499572753906 C178.75100708007812,229.10499572753906 -157.00100708007812,150.98500061035156 -157.00100708007812,150.98500061035156 C-169.73899841308594,148.0229949951172 -178.7530059814453,136.66799926757812 -178.75100708007812,123.58899688720703 C-178.75100708007812,123.58899688720703 -178.73199462890625,-4.696000099182129 -178.73199462890625,-4.696000099182129z">
                                                        </path>
                                                    </g>
                                                </g>
                                                <g id="2834"
                                                    transform="matrix(-0.4414737820625305,0.23473578691482544,0.23473578691482544,0.4414737820625305,249,315)"
                                                    opacity="1" style="display: block;">
                                                    <g opacity="1" transform="matrix(1,0,0,1,0,0)">
                                                        <path fill="rgb(45,158,255)" fill-opacity="1"
                                                            d=" M-187.25900268554688,268.5480041503906 C-187.25900268554688,268.5480041503906 -186.66000366210938,-37.926998138427734 -186.66000366210938,-37.926998138427734 C-186.6269989013672,-55.28499984741211 -174.02999877929688,-76.09600067138672 -158.68600463867188,-84.1729965209961 C-158.68600463867188,-84.1729965209961 42.46799850463867,-190.0590057373047 42.46799850463867,-190.0590057373047 C49.415000915527344,-193.7169952392578 55.27399826049805,-199.1300048828125 59.45399856567383,-205.76600646972656 C59.45399856567383,-205.76600646972656 69.06999969482422,-221.03399658203125 69.06999969482422,-221.03399658203125 C73.2490005493164,-227.6699981689453 79.10900115966797,-233.08299255371094 86.05599975585938,-236.74099731445312 C86.05599975585938,-236.74099731445312 112.48899841308594,-250.65499877929688 112.48899841308594,-250.65499877929688 C112.48899841308594,-250.65499877929688 142.49200439453125,-243.48899841308594 142.49200439453125,-243.48899841308594 C142.49200439453125,-243.48899841308594 141.64599609375,117.26399993896484 141.64599609375,117.26399993896484 C141.1320037841797,123.41400146484375 136.95599365234375,129.2550048828125 129.28399658203125,133.29100036621094 C129.28399658203125,133.29100036621094 -156.04200744628906,283.59698486328125 -156.04200744628906,283.59698486328125 C-156.04200744628906,283.59698486328125 -164.4409942626953,297.7049865722656 -164.4409942626953,297.7049865722656 C-164.4409942626953,297.7049865722656 -180.33599853515625,285.70001220703125 -180.33599853515625,285.70001220703125 C-180.33599853515625,285.70001220703125 -180.3070068359375,285.68499755859375 -180.3070068359375,285.68499755859375 C-184.64999389648438,282.38800048828125 -187.31100463867188,276.5249938964844 -187.2949981689453,268.5480041503906 C-187.2949981689453,268.5480041503906 -187.25900268554688,268.5480041503906 -187.25900268554688,268.5480041503906z">
                                                        </path>
                                                        <path stroke-linecap="round" stroke-linejoin="round"
                                                            fill-opacity="0" stroke="rgb(4,0,255)" stroke-opacity="1"
                                                            stroke-width="2"
                                                            d=" M-187.25900268554688,268.5480041503906 C-187.25900268554688,268.5480041503906 -186.66000366210938,-37.926998138427734 -186.66000366210938,-37.926998138427734 C-186.6269989013672,-55.28499984741211 -174.02999877929688,-76.09600067138672 -158.68600463867188,-84.1729965209961 C-158.68600463867188,-84.1729965209961 42.46799850463867,-190.0590057373047 42.46799850463867,-190.0590057373047 C49.415000915527344,-193.7169952392578 55.27399826049805,-199.1300048828125 59.45399856567383,-205.76600646972656 C59.45399856567383,-205.76600646972656 69.06999969482422,-221.03399658203125 69.06999969482422,-221.03399658203125 C73.2490005493164,-227.6699981689453 79.10900115966797,-233.08299255371094 86.05599975585938,-236.74099731445312 C86.05599975585938,-236.74099731445312 112.48899841308594,-250.65499877929688 112.48899841308594,-250.65499877929688 C112.48899841308594,-250.65499877929688 142.49200439453125,-243.48899841308594 142.49200439453125,-243.48899841308594 C142.49200439453125,-243.48899841308594 141.64599609375,117.26399993896484 141.64599609375,117.26399993896484 C141.1320037841797,123.41400146484375 136.95599365234375,129.2550048828125 129.28399658203125,133.29100036621094 C129.28399658203125,133.29100036621094 -156.04200744628906,283.59698486328125 -156.04200744628906,283.59698486328125 C-156.04200744628906,283.59698486328125 -164.4409942626953,297.7049865722656 -164.4409942626953,297.7049865722656 C-164.4409942626953,297.7049865722656 -180.33599853515625,285.70001220703125 -180.33599853515625,285.70001220703125 C-180.33599853515625,285.70001220703125 -180.3070068359375,285.68499755859375 -180.3070068359375,285.68499755859375 C-184.64999389648438,282.38800048828125 -187.31100463867188,276.5249938964844 -187.2949981689453,268.5480041503906 C-187.2949981689453,268.5480041503906 -187.25900268554688,268.5480041503906 -187.25900268554688,268.5480041503906z">
                                                        </path>
                                                    </g>
                                                    <g opacity="1" transform="matrix(1,0,0,1,0,0)">
                                                        <path stroke-linecap="butt" stroke-linejoin="miter"
                                                            fill-opacity="0" stroke-miterlimit="10"
                                                            stroke="rgb(4,0,255)" stroke-opacity="1" stroke-width="2"
                                                            d=" M-133.07899475097656,-77.56800079345703 C-133.07899475097656,-77.56800079345703 -148.97500610351562,-89.572998046875 -148.97500610351562,-89.572998046875">
                                                        </path>
                                                    </g>
                                                    <g opacity="1" transform="matrix(1,0,0,1,0,0)">
                                                        <path fill="url(#__lottie_element_475)" fill-opacity="1"
                                                            d=" M-173.8179931640625,-26.750999450683594 C-173.78500366210938,-44.108001708984375 -161.18800354003906,-64.91899871826172 -145.843994140625,-72.99600219726562 C-145.843994140625,-72.99600219726562 145.6790008544922,-226.56300354003906 145.6790008544922,-226.56300354003906 C153.91700744628906,-230.8990020751953 158.10699462890625,-237.302001953125 158.10699462890625,-243.93800354003906 C158.10699462890625,-243.93800354003906 157.32400512695312,126.98300170898438 157.32400512695312,126.98300170898438 C156.8090057373047,133.13299560546875 152.63699340820312,138.9739990234375 144.96600341796875,143.01300048828125 C144.96600341796875,143.01300048828125 -146.55799865722656,296.5799865722656 -146.55799865722656,296.5799865722656 C-161.91700744628906,304.66400146484375 -174.44900512695312,297.0799865722656 -174.40899658203125,279.73699951171875 C-174.40899658203125,279.73699951171875 -173.80999755859375,-26.736000061035156 -173.80999755859375,-26.736000061035156 C-173.80999755859375,-26.736000061035156 -173.8179931640625,-26.750999450683594 -173.8179931640625,-26.750999450683594z">
                                                        </path>
                                                    </g>
                                                    <g opacity="1" transform="matrix(1,0,0,1,0,0)">
                                                        <path stroke-linecap="round" stroke-linejoin="round"
                                                            fill-opacity="0" stroke="rgb(4,0,255)" stroke-opacity="1"
                                                            stroke-width="2"
                                                            d=" M-156.90199279785156,46.518001556396484 C-156.90199279785156,46.518001556396484 -156.76400756835938,-30.20199966430664 -156.76400756835938,-30.20199966430664 C-156.75,-41.097999572753906 -150.4980010986328,-54.26100158691406 -141.01600646972656,-59.25199890136719 C-141.01600646972656,-59.25199890136719 147.53199768066406,-211.58599853515625 147.53199768066406,-211.58599853515625">
                                                        </path>
                                                    </g>
                                                    <g opacity="1" transform="matrix(1,0,0,1,0,0)">
                                                        <path stroke-linecap="round" stroke-linejoin="round"
                                                            fill-opacity="0" stroke="rgb(4,0,255)" stroke-opacity="1"
                                                            stroke-width="2"
                                                            d=" M147.47999572753906,125.71099853515625 C147.47999572753906,125.71099853515625 -141.85800170898438,278.0580139160156 -141.85800170898438,278.0580139160156 C-151.48399353027344,283.12298583984375 -157.32000732421875,278.3919982910156 -157.31300354003906,269.2760009765625 C-157.31300354003906,269.2760009765625 -157.18600463867188,201.45599365234375 -157.18600463867188,201.45599365234375">
                                                        </path>
                                                    </g>
                                                    <g opacity="1" transform="matrix(1,0,0,1,0,0)">
                                                        <path fill="rgb(72,255,144)" fill-opacity="1"
                                                            d=" M107.01200103759766,-243.55599975585938 C107.0009994506836,-238.13400268554688 114.95600128173828,-233.70399475097656 124.75900268554688,-233.68899536132812 C134.56700134277344,-233.6750030517578 142.52499389648438,-238.0489959716797 142.54299926757812,-243.4929962158203 C142.55799865722656,-248.93800354003906 134.60000610351562,-253.34500122070312 124.7959976196289,-253.36000061035156 C120.04000091552734,-253.3699951171875 115.72100067138672,-252.33599853515625 112.52300262451172,-250.65199279785156 C109.13300323486328,-248.86900329589844 107.02300262451172,-246.3509979248047 107.01200103759766,-243.55599975585938z">
                                                        </path>
                                                        <path stroke-linecap="round" stroke-linejoin="round"
                                                            fill-opacity="0" stroke="rgb(4,0,255)" stroke-opacity="1"
                                                            stroke-width="2"
                                                            d=" M107.01200103759766,-243.55599975585938 C107.0009994506836,-238.13400268554688 114.95600128173828,-233.70399475097656 124.75900268554688,-233.68899536132812 C134.56700134277344,-233.6750030517578 142.52499389648438,-238.0489959716797 142.54299926757812,-243.4929962158203 C142.55799865722656,-248.93800354003906 134.60000610351562,-253.34500122070312 124.7959976196289,-253.36000061035156 C120.04000091552734,-253.3699951171875 115.72100067138672,-252.33599853515625 112.52300262451172,-250.65199279785156 C109.13300323486328,-248.86900329589844 107.02300262451172,-246.3509979248047 107.01200103759766,-243.55599975585938z">
                                                        </path>
                                                    </g>
                                                    <g opacity="1" transform="matrix(1,0,0,1,0,0)">
                                                        <path fill="rgb(27,27,27)" fill-opacity="1"
                                                            d=" M117.63600158691406,-243.52999877929688 C117.63600158691406,-243.52999877929688 117.62799835205078,-243.5279998779297 117.62799835205078,-243.5279998779297 C117.62799835205078,-242.8560028076172 118.13600158691406,-242.01300048828125 119.46600341796875,-241.2729949951172 C120.76399993896484,-240.552001953125 122.63500213623047,-240.06900024414062 124.75900268554688,-240.06500244140625 C126.88400268554688,-240.06199645996094 128.7550048828125,-240.53799438476562 130.05599975585938,-241.25599670410156 C131.3979949951172,-241.99400329589844 131.90499877929688,-242.83900451660156 131.90899658203125,-243.51400756835938 C131.90899658203125,-244.18699645996094 131.40499877929688,-245.03399658203125 130.06700134277344,-245.77699279785156 C128.77000427246094,-246.49899291992188 126.90299987792969,-246.98199462890625 124.77799987792969,-246.98500061035156 C124.77799987792969,-246.98500061035156 124.77400207519531,-246.98500061035156 124.77400207519531,-246.98500061035156 C122.7229995727539,-246.99000549316406 120.90399932861328,-246.5399932861328 119.59500122070312,-245.8509979248047 C118.16899871826172,-245.0989990234375 117.63200378417969,-244.23199462890625 117.63600158691406,-243.52999877929688z">
                                                        </path>
                                                        <path stroke-linecap="butt" stroke-linejoin="miter"
                                                            fill-opacity="0" stroke-miterlimit="4" stroke="rgb(4,0,255)"
                                                            stroke-opacity="1" stroke-width="2"
                                                            d=" M117.63600158691406,-243.52999877929688 C117.63600158691406,-243.52999877929688 117.62799835205078,-243.5279998779297 117.62799835205078,-243.5279998779297 C117.62799835205078,-242.8560028076172 118.13600158691406,-242.01300048828125 119.46600341796875,-241.2729949951172 C120.76399993896484,-240.552001953125 122.63500213623047,-240.06900024414062 124.75900268554688,-240.06500244140625 C126.88400268554688,-240.06199645996094 128.7550048828125,-240.53799438476562 130.05599975585938,-241.25599670410156 C131.3979949951172,-241.99400329589844 131.90499877929688,-242.83900451660156 131.90899658203125,-243.51400756835938 C131.90899658203125,-244.18699645996094 131.40499877929688,-245.03399658203125 130.06700134277344,-245.77699279785156 C128.77000427246094,-246.49899291992188 126.90299987792969,-246.98199462890625 124.77799987792969,-246.98500061035156 C124.77799987792969,-246.98500061035156 124.77400207519531,-246.98500061035156 124.77400207519531,-246.98500061035156 C122.7229995727539,-246.99000549316406 120.90399932861328,-246.5399932861328 119.59500122070312,-245.8509979248047 C118.16899871826172,-245.0989990234375 117.63200378417969,-244.23199462890625 117.63600158691406,-243.52999877929688z">
                                                        </path>
                                                    </g>
                                                    <g opacity="1" transform="matrix(1,0,0,1,0,0)">
                                                        <path fill="rgb(72,255,144)" fill-opacity="1"
                                                            d=" M-167.62600708007812,-332.12799072265625 C-167.62600708007812,-332.12799072265625 137.26499938964844,-263.1199951171875 137.26499938964844,-263.1199951171875 C144.69700622558594,-261.43798828125 152.59300231933594,-258.68798828125 156.07400512695312,-251.91000366210938 C157.40499877929688,-249.31900024414062 158.06700134277344,-246.6510009765625 158.06700134277344,-244.0229949951172 C158.06700134277344,-244.0229949951172 158.927001953125,-233.64199829101562 145.63800048828125,-226.6479949951172 C132.35000610351562,-219.65199279785156 115.68399810791016,-210.75 115.68399810791016,-210.75 C115.68399810791016,-210.75 107.5780029296875,-215.96600341796875 107.5780029296875,-215.96600341796875 C107.5780029296875,-215.96600341796875 137.42999267578125,-231.80999755859375 137.42999267578125,-231.80999755859375 C145.94400024414062,-236.29100036621094 149.89500427246094,-242.02999877929688 147.25599670410156,-247.92300415039062 C144.9770050048828,-253.01499938964844 138.96299743652344,-254.91600036621094 133.5229949951172,-256.1549987792969 C133.5229949951172,-256.1549987792969 -176.0659942626953,-326.6610107421875 -176.0659942626953,-326.6610107421875 C-185.37100219726562,-329.08099365234375 -192.92300415039062,-327.55999755859375 -197.48300170898438,-325.1600036621094 C-197.48300170898438,-325.1600036621094 -189.73199462890625,-336.85699462890625 -167.63400268554688,-332.1419982910156 C-167.63400268554688,-332.1419982910156 -167.62600708007812,-332.12799072265625 -167.62600708007812,-332.12799072265625z">
                                                        </path>
                                                        <path stroke-linecap="round" stroke-linejoin="round"
                                                            fill-opacity="0" stroke="rgb(4,0,255)" stroke-opacity="1"
                                                            stroke-width="2"
                                                            d=" M-167.62600708007812,-332.12799072265625 C-167.62600708007812,-332.12799072265625 137.26499938964844,-263.1199951171875 137.26499938964844,-263.1199951171875 C144.69700622558594,-261.43798828125 152.59300231933594,-258.68798828125 156.07400512695312,-251.91000366210938 C157.40499877929688,-249.31900024414062 158.06700134277344,-246.6510009765625 158.06700134277344,-244.0229949951172 C158.06700134277344,-244.0229949951172 158.927001953125,-233.64199829101562 145.63800048828125,-226.6479949951172 C132.35000610351562,-219.65199279785156 115.68399810791016,-210.75 115.68399810791016,-210.75 C115.68399810791016,-210.75 107.5780029296875,-215.96600341796875 107.5780029296875,-215.96600341796875 C107.5780029296875,-215.96600341796875 137.42999267578125,-231.80999755859375 137.42999267578125,-231.80999755859375 C145.94400024414062,-236.29100036621094 149.89500427246094,-242.02999877929688 147.25599670410156,-247.92300415039062 C144.9770050048828,-253.01499938964844 138.96299743652344,-254.91600036621094 133.5229949951172,-256.1549987792969 C133.5229949951172,-256.1549987792969 -176.0659942626953,-326.6610107421875 -176.0659942626953,-326.6610107421875 C-185.37100219726562,-329.08099365234375 -192.92300415039062,-327.55999755859375 -197.48300170898438,-325.1600036621094 C-197.48300170898438,-325.1600036621094 -189.73199462890625,-336.85699462890625 -167.63400268554688,-332.1419982910156 C-167.63400268554688,-332.1419982910156 -167.62600708007812,-332.12799072265625 -167.62600708007812,-332.12799072265625z">
                                                        </path>
                                                    </g>
                                                    <g opacity="1" transform="matrix(1,0,0,1,0,0)">
                                                        <path fill="rgb(27,27,27)" fill-opacity="1"
                                                            d=" M-108.94100189208984,-44.61899948120117 C-114.92500305175781,-41.50899887084961 -119.84500122070312,-33.65800094604492 -119.87899780273438,-27.19499969482422 C-119.87899780273438,-27.19499969482422 -120.46499633789062,115.31900024414062 -120.46499633789062,115.31900024414062 C-120.48699951171875,121.78500366210938 -115.62300109863281,124.52400207519531 -109.62699890136719,121.41799926757812 C-109.62699890136719,121.41799926757812 13.57800006866455,57.34700012207031 13.57800006866455,57.34700012207031 C19.56100082397461,54.23699951171875 24.488000869750977,46.400001525878906 24.510000228881836,39.933998107910156 C24.510000228881836,39.933998107910156 25.0939998626709,-102.64700317382812 25.0939998626709,-102.64700317382812 C25.115999221801758,-109.11299896240234 20.25200080871582,-111.85199737548828 14.269000053405762,-108.74199676513672 C14.269000053405762,-108.74199676513672 -108.94100189208984,-44.61899948120117 -108.94100189208984,-44.61899948120117z">
                                                        </path>
                                                        <path stroke-linecap="round" stroke-linejoin="round"
                                                            fill-opacity="0" stroke="rgb(4,0,255)" stroke-opacity="1"
                                                            stroke-width="2"
                                                            d=" M-108.94100189208984,-44.61899948120117 C-114.92500305175781,-41.50899887084961 -119.84500122070312,-33.65800094604492 -119.87899780273438,-27.19499969482422 C-119.87899780273438,-27.19499969482422 -120.46499633789062,115.31900024414062 -120.46499633789062,115.31900024414062 C-120.48699951171875,121.78500366210938 -115.62300109863281,124.52400207519531 -109.62699890136719,121.41799926757812 C-109.62699890136719,121.41799926757812 13.57800006866455,57.34700012207031 13.57800006866455,57.34700012207031 C19.56100082397461,54.23699951171875 24.488000869750977,46.400001525878906 24.510000228881836,39.933998107910156 C24.510000228881836,39.933998107910156 25.0939998626709,-102.64700317382812 25.0939998626709,-102.64700317382812 C25.115999221801758,-109.11299896240234 20.25200080871582,-111.85199737548828 14.269000053405762,-108.74199676513672 C14.269000053405762,-108.74199676513672 -108.94100189208984,-44.61899948120117 -108.94100189208984,-44.61899948120117z">
                                                        </path>
                                                    </g>
                                                    <g opacity="1" transform="matrix(1,0,0,1,0,0)">
                                                        <path fill="rgb(244,244,246)" fill-opacity="1"
                                                            d=" M15.5,-109.01200103759766 C16.29800033569336,-107.79299926757812 16.753000259399414,-106.1760025024414 16.742000579833984,-104.18900299072266 C16.742000579833984,-104.18900299072266 16.159000396728516,37.255001068115234 16.159000396728516,37.255001068115234 C16.136999130249023,43.72100067138672 11.210000038146973,51.55400085449219 5.22599983215332,54.66400146484375 C5.22599983215332,54.66400146484375 -117.9739990234375,118.71900177001953 -117.9739990234375,118.71900177001953 C-118.38500213623047,118.93599700927734 -118.80000305175781,119.1240005493164 -119.20500183105469,119.28600311279297 C-117.38400268554688,122.05000305175781 -113.7760009765625,122.71900177001953 -109.62300109863281,120.55699920654297 C-109.62300109863281,120.55699920654297 13.57800006866455,56.50199890136719 13.57800006866455,56.50199890136719 C19.56100082397461,53.391998291015625 24.488000869750977,45.55500030517578 24.510000228881836,39.0890007019043 C24.510000228881836,39.0890007019043 25.0939998626709,-102.35299682617188 25.0939998626709,-102.35299682617188 C25.118000030517578,-108.37300109863281 20.902000427246094,-111.1500015258789 15.494999885559082,-108.9990005493164 C15.494999885559082,-108.9990005493164 15.5,-109.01200103759766 15.5,-109.01200103759766z">
                                                        </path>
                                                        <path stroke-linecap="round" stroke-linejoin="round"
                                                            fill-opacity="0" stroke="rgb(4,0,255)" stroke-opacity="1"
                                                            stroke-width="2"
                                                            d=" M15.5,-109.01200103759766 C16.29800033569336,-107.79299926757812 16.753000259399414,-106.1760025024414 16.742000579833984,-104.18900299072266 C16.742000579833984,-104.18900299072266 16.159000396728516,37.255001068115234 16.159000396728516,37.255001068115234 C16.136999130249023,43.72100067138672 11.210000038146973,51.55400085449219 5.22599983215332,54.66400146484375 C5.22599983215332,54.66400146484375 -117.9739990234375,118.71900177001953 -117.9739990234375,118.71900177001953 C-118.38500213623047,118.93599700927734 -118.80000305175781,119.1240005493164 -119.20500183105469,119.28600311279297 C-117.38400268554688,122.05000305175781 -113.7760009765625,122.71900177001953 -109.62300109863281,120.55699920654297 C-109.62300109863281,120.55699920654297 13.57800006866455,56.50199890136719 13.57800006866455,56.50199890136719 C19.56100082397461,53.391998291015625 24.488000869750977,45.55500030517578 24.510000228881836,39.0890007019043 C24.510000228881836,39.0890007019043 25.0939998626709,-102.35299682617188 25.0939998626709,-102.35299682617188 C25.118000030517578,-108.37300109863281 20.902000427246094,-111.1500015258789 15.494999885559082,-108.9990005493164 C15.494999885559082,-108.9990005493164 15.5,-109.01200103759766 15.5,-109.01200103759766z">
                                                        </path>
                                                    </g>
                                                    <g opacity="1" transform="matrix(1,0,0,1,0,0)">
                                                        <path fill="rgb(4,0,255)" fill-opacity="1"
                                                            d=" M24.506999969482422,42.279998779296875 C24.506999969482422,42.279998779296875 25.090999603271484,-102.64700317382812 25.090999603271484,-102.64700317382812 C25.114999771118164,-108.66699981689453 20.89900016784668,-111.44400024414062 15.491999626159668,-109.29299926757812 C16.291000366210938,-108.0739974975586 16.7450008392334,-106.45800018310547 16.735000610351562,-104.47000122070312 C16.735000610351562,-104.47000122070312 16.150999069213867,40.45600128173828 16.150999069213867,40.45600128173828 C16.150999069213867,40.45600128173828 24.50200080871582,42.29100036621094 24.50200080871582,42.29100036621094 C24.50200080871582,42.29100036621094 24.506999969482422,42.279998779296875 24.506999969482422,42.279998779296875z">
                                                        </path>
                                                        <path stroke-linecap="round" stroke-linejoin="round"
                                                            fill-opacity="0" stroke="rgb(4,0,255)" stroke-opacity="1"
                                                            stroke-width="2"
                                                            d=" M24.506999969482422,42.279998779296875 C24.506999969482422,42.279998779296875 25.090999603271484,-102.64700317382812 25.090999603271484,-102.64700317382812 C25.114999771118164,-108.66699981689453 20.89900016784668,-111.44400024414062 15.491999626159668,-109.29299926757812 C16.291000366210938,-108.0739974975586 16.7450008392334,-106.45800018310547 16.735000610351562,-104.47000122070312 C16.735000610351562,-104.47000122070312 16.150999069213867,40.45600128173828 16.150999069213867,40.45600128173828 C16.150999069213867,40.45600128173828 24.50200080871582,42.29100036621094 24.50200080871582,42.29100036621094 C24.50200080871582,42.29100036621094 24.506999969482422,42.279998779296875 24.506999969482422,42.279998779296875z">
                                                        </path>
                                                    </g>
                                                </g>
                                                <g id="2835"
                                                    transform="matrix(-0.4414737820625305,0.23473578691482544,0.23473578691482544,0.4414737820625305,249,315)"
                                                    opacity="1" style="display: block;">
                                                    <g opacity="1" transform="matrix(1,0,0,1,0,0)">
                                                        <path stroke-linecap="round" stroke-linejoin="round"
                                                            fill-opacity="0" stroke="rgb(4,0,255)" stroke-opacity="1"
                                                            stroke-width="2"
                                                            d=" M-173.8179931640625,-26.750999450683594 C-173.78500366210938,-44.108001708984375 -161.18800354003906,-64.91899871826172 -145.843994140625,-72.99600219726562 C-145.843994140625,-72.99600219726562 145.6790008544922,-226.56300354003906 145.6790008544922,-226.56300354003906 C153.91700744628906,-230.8990020751953 158.10699462890625,-237.302001953125 158.10699462890625,-243.93800354003906 C158.10699462890625,-243.93800354003906 157.32400512695312,126.98300170898438 157.32400512695312,126.98300170898438 C156.8090057373047,133.13299560546875 152.63699340820312,138.9739990234375 144.96600341796875,143.01300048828125 C144.96600341796875,143.01300048828125 -146.55799865722656,296.5799865722656 -146.55799865722656,296.5799865722656 C-161.91700744628906,304.66400146484375 -174.44900512695312,297.0799865722656 -174.40899658203125,279.73699951171875 C-174.40899658203125,279.73699951171875 -173.80999755859375,-26.736000061035156 -173.80999755859375,-26.736000061035156 C-173.80999755859375,-26.736000061035156 -173.8179931640625,-26.750999450683594 -173.8179931640625,-26.750999450683594z">
                                                        </path>
                                                    </g>
                                                </g>
                                                <g id="2836"
                                                    transform="matrix(-0.4414737820625305,0.23473578691482544,0.23473578691482544,0.4414737820625305,249,315)"
                                                    opacity="1" style="display: block;">
                                                    <g opacity="1" transform="matrix(1,0,0,1,0,0)"></g>
                                                    <g opacity="1" transform="matrix(1,0,0,1,0,0)">
                                                        <path fill="rgb(27,27,27)" fill-opacity="1"
                                                            d=" M-161.86099243164062,173.6439971923828 C-161.86099243164062,173.6439971923828 -174.21499633789062,177.7429962158203 -174.21499633789062,177.7429962158203 C-174.21499633789062,177.7429962158203 -187.97500610351562,215.27000427246094 -187.97500610351562,215.27000427246094 C-187.97500610351562,215.27000427246094 -187.84800720214844,150.5749969482422 -187.84800720214844,150.5749969482422 C-187.84800720214844,150.5749969482422 -162.96299743652344,147.56399536132812 -162.96299743652344,147.56399536132812 C-162.96299743652344,147.56399536132812 -161.86099243164062,173.6439971923828 -161.86099243164062,173.6439971923828z">
                                                        </path>
                                                    </g>
                                                    <g opacity="1" transform="matrix(1,0,0,1,0,0)">
                                                        <path fill="url(#__lottie_element_468)" fill-opacity="1"
                                                            d=" M-157.156005859375,192.99099731445312 C-157.125,174.54100036621094 -162.71800231933594,166.0240020751953 -182.6060028076172,169.54200744628906 C-193.29400634765625,171.43499755859375 -198.5854034423828,173.63238525390625 -209.4010772705078,172.96083068847656 C-209.4010772705078,172.96083068847656 -233.21685791015625,171.4735107421875 -233.21685791015625,171.4735107421875 C-253.85716247558594,170.1892852783203 -273.928955078125,152.51466369628906 -277.80609130859375,132.2046661376953 C-281.68316650390625,111.88761901855469 -267.96478271484375,96.32098388671875 -247.33670043945312,97.61595153808594 C-247.33670043945312,97.61595153808594 -218.40890502929688,99.42074584960938 -218.40890502929688,99.42074584960938 C-208.597412109375,100.0401611328125 -189.89300537109375,96.06900024414062 -180.78799438476562,92.3270034790039 C-162.25100708007812,84.69599914550781 -156.9499969482422,76.8219985961914 -156.91200256347656,57.26300048828125 C-156.91200256347656,57.26300048828125 -145.16400146484375,69.322998046875 -145.16400146484375,69.322998046875 C-145.16400146484375,69.322998046875 -145.13400268554688,186.68299865722656 -145.13400268554688,186.68299865722656 C-145.13400268554688,186.68299865722656 -157.16299438476562,193.01300048828125 -157.16299438476562,193.01300048828125 C-157.16299438476562,193.01300048828125 -157.156005859375,192.99099731445312 -157.156005859375,192.99099731445312z">
                                                        </path>
                                                    </g>
                                                    <g opacity="1" transform="matrix(1,0,0,1,0,0)">
                                                        <path stroke-linecap="butt" stroke-linejoin="miter"
                                                            fill-opacity="0" stroke-miterlimit="10"
                                                            stroke="rgb(4,0,255)" stroke-opacity="1" stroke-width="2"
                                                            d=" M-157.1510009765625,192.99400329589844 C-157.11900329589844,174.5489959716797 -162.71299743652344,166.0279998779297 -182.6009979248047,169.5489959716797 C-193.28900146484375,171.43899536132812 -198.57846069335938,173.63543701171875 -209.39508056640625,172.96295166015625 C-209.39508056640625,172.96295166015625 -233.20999145507812,171.4795684814453 -233.20999145507812,171.4795684814453 C-253.8511505126953,170.19540405273438 -273.9230041503906,152.51773071289062 -277.8000793457031,132.20680236816406 C-281.6762390136719,111.89368438720703 -267.95880126953125,96.32405090332031 -247.3307647705078,97.6180191040039 C-247.3307647705078,97.6180191040039 -218.4029083251953,99.42381286621094 -218.4029083251953,99.42381286621094 C-208.59048461914062,100.0462875366211 -189.88800048828125,96.0719985961914 -180.78199768066406,92.33399963378906 C-162.24600219726562,84.6989974975586 -156.94400024414062,76.82599639892578 -156.906005859375,57.26599884033203">
                                                        </path>
                                                    </g>
                                                    <g opacity="1" transform="matrix(1,0,0,1,0,0)">
                                                        <path fill="rgb(27,27,27)" fill-opacity="1"
                                                            d=" M-263.7999267578125,117.39787292480469 C-258.4164123535156,109.29962158203125 -244.1888427734375,109.2944564819336 -231.99578857421875,117.38434600830078 C-219.8035888671875,125.47518157958984 -214.2813720703125,138.59104919433594 -219.66395568847656,146.6933135986328 C-219.66395568847656,146.6933135986328 -226.17977905273438,155.98545837402344 -226.17977905273438,155.98545837402344 C-226.17977905273438,155.98545837402344 -269.8632507324219,126.1514663696289 -269.8632507324219,126.1514663696289 C-269.8632507324219,126.1514663696289 -263.7999267578125,117.39787292480469 -263.7999267578125,117.39787292480469z">
                                                        </path>
                                                        <path stroke-linecap="round" stroke-linejoin="round"
                                                            fill-opacity="0" stroke="rgb(4,0,255)" stroke-opacity="1"
                                                            stroke-width="2"
                                                            d=" M-263.7999267578125,117.39787292480469 C-258.4164123535156,109.29962158203125 -244.1888427734375,109.2944564819336 -231.99578857421875,117.38434600830078 C-219.8035888671875,125.47518157958984 -214.2813720703125,138.59104919433594 -219.66395568847656,146.6933135986328 C-219.66395568847656,146.6933135986328 -226.17977905273438,155.98545837402344 -226.17977905273438,155.98545837402344 C-226.17977905273438,155.98545837402344 -269.8632507324219,126.1514663696289 -269.8632507324219,126.1514663696289 C-269.8632507324219,126.1514663696289 -263.7999267578125,117.39787292480469 -263.7999267578125,117.39787292480469z">
                                                        </path>
                                                    </g>
                                                    <g opacity="1" transform="matrix(1,0,0,1,0,0)">
                                                        <path fill="rgb(72,255,144)" fill-opacity="1"
                                                            d=" M-257.13421630859375,154.7174835205078 C-269.3204040527344,146.6297149658203 -274.843505859375,133.50584411621094 -269.4689636230469,125.40945434570312 C-264.0945129394531,117.31307220458984 -249.85987854003906,117.30797576904297 -237.6708221435547,125.39693450927734 C-225.48463439941406,133.4846954345703 -219.96435546875,146.6036376953125 -225.33700561523438,154.70095825195312 C-230.7105255126953,162.8013458251953 -244.94703674316406,162.80438232421875 -257.13421630859375,154.7174835205078z">
                                                        </path>
                                                        <path stroke-linecap="round" stroke-linejoin="round"
                                                            fill-opacity="0" stroke="rgb(4,0,255)" stroke-opacity="1"
                                                            stroke-width="2"
                                                            d=" M-257.13421630859375,154.7174835205078 C-269.3204040527344,146.6297149658203 -274.843505859375,133.50584411621094 -269.4689636230469,125.40945434570312 C-264.0945129394531,117.31307220458984 -249.85987854003906,117.30797576904297 -237.6708221435547,125.39693450927734 C-225.48463439941406,133.4846954345703 -219.96435546875,146.6036376953125 -225.33700561523438,154.70095825195312 C-230.7105255126953,162.8013458251953 -244.94703674316406,162.80438232421875 -257.13421630859375,154.7174835205078z">
                                                        </path>
                                                    </g>
                                                </g>
                                                <g id="2837"
                                                    transform="matrix(0.5,0,0,0.5,253.6699981689453,240.55699157714844)"
                                                    opacity="1" style="display: block;">
                                                    <g opacity="1" transform="matrix(1,0,0,1,0,0)">
                                                        <path fill="rgb(27,27,27)" fill-opacity="1"
                                                            d=" M6.300000190734863,270.2309875488281 C6.300000190734863,270.2309875488281 0.6539999842643738,259.6449890136719 0.6539999842643738,259.6449890136719 C-1.534999966621399,255.51499938964844 -7.160999774932861,252.17100524902344 -11.815999984741211,252.18099975585938 C-11.815999984741211,252.18099975585938 -31.570999145507812,252.23599243164062 -31.570999145507812,252.23599243164062 C-31.570999145507812,252.23599243164062 -39.755001068115234,236.85800170898438 -39.755001068115234,236.85800170898438 C-41.944000244140625,232.73199462890625 -47.55400085449219,229.38499450683594 -52.224998474121094,229.3990020751953 C-52.224998474121094,229.3990020751953 -68.94999694824219,229.4429931640625 -68.94999694824219,229.4429931640625 C-71.4749984741211,229.44900512695312 -73.20800018310547,230.4499969482422 -73.94499969482422,232.01300048828125 C-73.94499969482422,232.01300048828125 -77.94599914550781,240.5749969482422 -77.94599914550781,240.5749969482422 C-77.94599914550781,240.5749969482422 -69.8740005493164,243.64700317382812 -69.8740005493164,243.64700317382812 C-69.8740005493164,243.64700317382812 -65.24299621582031,252.343994140625 -65.24299621582031,252.343994140625 C-65.24299621582031,252.343994140625 -84.99800109863281,252.3979949951172 -84.99800109863281,252.3979949951172 C-87.52300262451172,252.40499877929688 -89.25599670410156,253.40199279785156 -89.99299621582031,254.96499633789062 C-89.99299621582031,254.96499633789062 -93.99400329589844,263.531005859375 -93.99400329589844,263.531005859375 C-93.99400329589844,263.531005859375 -86.12799835205078,266.2229919433594 -86.12799835205078,266.2229919433594 C-86.12799835205078,266.2229919433594 -83.84500122070312,270.5090026855469 -83.84500122070312,270.5090026855469 C-81.65599822998047,274.635009765625 -76.02899932861328,277.98199462890625 -71.3740005493164,277.968994140625 C-71.3740005493164,277.968994140625 -51.619998931884766,277.91400146484375 -51.619998931884766,277.91400146484375 C-51.619998931884766,277.91400146484375 -43.43600082397461,293.2950134277344 -43.43600082397461,293.2950134277344 C-41.24700164794922,297.4219970703125 -35.637001037597656,300.7690124511719 -30.965999603271484,300.7550048828125 C-30.965999603271484,300.7550048828125 -24.101999282836914,300.7349853515625 -24.101999282836914,300.7349853515625 C-24.101999282836914,300.7349853515625 -13.246000289916992,306.718994140625 -13.246000289916992,306.718994140625 C-13.246000289916992,306.718994140625 -9.244999885559082,298.15399169921875 -9.244999885559082,298.15399169921875 C-8.633000373840332,296.8280029296875 -8.732999801635742,295.0920104980469 -9.748000144958496,293.2040100097656 C-9.748000144958496,293.2040100097656 -17.93199920654297,277.822998046875 -17.93199920654297,277.822998046875 C-17.93199920654297,277.822998046875 -6.808000087738037,277.7919921875 -6.808000087738037,277.7919921875 C-6.808000087738037,277.7919921875 2.8340001106262207,283.7640075683594 2.8340001106262207,283.7640075683594 C2.8340001106262207,283.7640075683594 6.834000110626221,275.2019958496094 6.834000110626221,275.2019958496094 C7.460999965667725,273.87298583984375 7.3460001945495605,272.135986328125 6.330999851226807,270.24798583984375 C6.330999851226807,270.24798583984375 6.300000190734863,270.2309875488281 6.300000190734863,270.2309875488281z">
                                                        </path>
                                                    </g>
                                                    <g opacity="1" transform="matrix(1,0,0,1,0,0)">
                                                        <path fill="rgb(27,27,27)" fill-opacity="1"
                                                            d=" M1.378000020980835,279.27398681640625 C1.378000020980835,279.27398681640625 1.378999948501587,279.27398681640625 1.378999948501587,279.27398681640625 C2.371000051498413,281.1260070800781 2.311000108718872,282.6080017089844 1.7339999675750732,283.5740051269531 C1.159000039100647,284.5369873046875 -0.11599999666213989,285.2959899902344 -2.2200000286102295,285.29998779296875 C-2.2200000286102295,285.29998779296875 -21.975000381469727,285.35400390625 -21.975000381469727,285.35400390625 C-22.33099937438965,285.35400390625 -22.66200065612793,285.54400634765625 -22.844999313354492,285.8489990234375 C-23.027999877929688,286.15399169921875 -23.038000106811523,286.53399658203125 -22.8700008392334,286.8489990234375 C-22.8700008392334,286.8489990234375 -14.687000274658203,302.22698974609375 -14.687000274658203,302.22698974609375 C-13.699000358581543,304.0880126953125 -13.76099967956543,305.57000732421875 -14.336000442504883,306.5329895019531 C-14.909000396728516,307.4930114746094 -16.17799949645996,308.2489929199219 -18.283000946044922,308.2550048828125 C-18.283000946044922,308.2550048828125 -35.00899887084961,308.29998779296875 -35.00899887084961,308.29998779296875 C-37.117000579833984,308.3059997558594 -39.50899887084961,307.54901123046875 -41.650001525878906,306.26800537109375 C-43.79199981689453,304.98699951171875 -45.59000015258789,303.239990234375 -46.57699966430664,301.3789978027344 C-46.57699966430664,301.3789978027344 -46.577999114990234,301.3789978027344 -46.577999114990234,301.3789978027344 C-46.577999114990234,301.3789978027344 -54.76100158691406,286.0010070800781 -54.76100158691406,286.0010070800781 C-54.93899917602539,285.66900634765625 -55.28499984741211,285.4590148925781 -55.6619987487793,285.4620056152344 C-55.6619987487793,285.4620056152344 -75.41699981689453,285.5169982910156 -75.41699981689453,285.5169982910156 C-77.51799774169922,285.5199890136719 -79.90799713134766,284.7640075683594 -82.0530014038086,283.48199462890625 C-84.197998046875,282.20001220703125 -85.9990005493164,280.4580078125 -86.98600006103516,278.59600830078125 C-86.98600006103516,278.59600830078125 -86.98699951171875,278.5929870605469 -86.98699951171875,278.5929870605469 C-86.98699951171875,278.5929870605469 -92.63300323486328,268.00299072265625 -92.63300323486328,268.00299072265625 C-92.63300323486328,268.00299072265625 -92.63400268554688,268.00299072265625 -92.63400268554688,268.00299072265625 C-93.62699890136719,266.1520080566406 -93.56300354003906,264.6709899902344 -92.98899841308594,263.7070007324219 C-92.41400146484375,262.739990234375 -91.13899993896484,261.9840087890625 -89.03600311279297,261.9779968261719 C-89.03600311279297,261.9779968261719 -69.28099822998047,261.9230041503906 -69.28099822998047,261.9230041503906 C-68.92400360107422,261.9230041503906 -68.59400177001953,261.73699951171875 -68.41100311279297,261.4280090332031 C-68.22699737548828,261.12298583984375 -68.21800231933594,260.7430114746094 -68.38500213623047,260.4280090332031 C-68.38500213623047,260.4280090332031 -76.56800079345703,245.05099487304688 -76.56800079345703,245.05099487304688 C-76.56900024414062,245.05099487304688 -76.56900024414062,245.05099487304688 -76.56900024414062,245.05099487304688 C-77.55599975585938,243.18899536132812 -77.49400329589844,241.70700073242188 -76.91899871826172,240.74400329589844 C-76.34600067138672,239.78500366210938 -75.0770034790039,239.0279998779297 -72.97200012207031,239.02200317382812 C-72.97200012207031,239.02200317382812 -56.24599838256836,238.97799682617188 -56.24599838256836,238.97799682617188 C-54.138999938964844,238.9709930419922 -51.74800109863281,239.7310028076172 -49.60599899291992,241.01499938964844 C-47.4630012512207,242.30099487304688 -45.665000915527344,244.04299926757812 -44.676998138427734,245.8979949951172 C-44.676998138427734,245.8979949951172 -44.676998138427734,245.8979949951172 -44.676998138427734,245.8979949951172 C-44.676998138427734,245.8979949951172 -36.49300003051758,261.2760009765625 -36.49300003051758,261.2760009765625 C-36.316001892089844,261.6109924316406 -35.970001220703125,261.8179931640625 -35.59299850463867,261.81500244140625 C-35.59299850463867,261.81500244140625 -15.838000297546387,261.7640075683594 -15.838000297546387,261.7640075683594 C-13.73799991607666,261.7569885253906 -11.345999717712402,262.5140075683594 -9.20199966430664,263.7950134277344 C-7.057000160217285,265.0769958496094 -5.25600004196167,266.822998046875 -4.269000053405762,268.68499755859375 C-4.269000053405762,268.68499755859375 -4.26800012588501,268.68499755859375 -4.26800012588501,268.68499755859375 C-4.26800012588501,268.68499755859375 1.378000020980835,279.27398681640625 1.378000020980835,279.27398681640625z">
                                                        </path>
                                                        <path stroke-linecap="round" stroke-linejoin="round"
                                                            fill-opacity="0" stroke="rgb(4,0,255)" stroke-opacity="1"
                                                            stroke-width="2"
                                                            d=" M1.378000020980835,279.27398681640625 C1.378000020980835,279.27398681640625 1.378999948501587,279.27398681640625 1.378999948501587,279.27398681640625 C2.371000051498413,281.1260070800781 2.311000108718872,282.6080017089844 1.7339999675750732,283.5740051269531 C1.159000039100647,284.5369873046875 -0.11599999666213989,285.2959899902344 -2.2200000286102295,285.29998779296875 C-2.2200000286102295,285.29998779296875 -21.975000381469727,285.35400390625 -21.975000381469727,285.35400390625 C-22.33099937438965,285.35400390625 -22.66200065612793,285.54400634765625 -22.844999313354492,285.8489990234375 C-23.027999877929688,286.15399169921875 -23.038000106811523,286.53399658203125 -22.8700008392334,286.8489990234375 C-22.8700008392334,286.8489990234375 -14.687000274658203,302.22698974609375 -14.687000274658203,302.22698974609375 C-13.699000358581543,304.0880126953125 -13.76099967956543,305.57000732421875 -14.336000442504883,306.5329895019531 C-14.909000396728516,307.4930114746094 -16.17799949645996,308.2489929199219 -18.283000946044922,308.2550048828125 C-18.283000946044922,308.2550048828125 -35.00899887084961,308.29998779296875 -35.00899887084961,308.29998779296875 C-37.117000579833984,308.3059997558594 -39.50899887084961,307.54901123046875 -41.650001525878906,306.26800537109375 C-43.79199981689453,304.98699951171875 -45.59000015258789,303.239990234375 -46.57699966430664,301.3789978027344 C-46.57699966430664,301.3789978027344 -46.577999114990234,301.3789978027344 -46.577999114990234,301.3789978027344 C-46.577999114990234,301.3789978027344 -54.76100158691406,286.0010070800781 -54.76100158691406,286.0010070800781 C-54.93899917602539,285.66900634765625 -55.28499984741211,285.4590148925781 -55.6619987487793,285.4620056152344 C-55.6619987487793,285.4620056152344 -75.41699981689453,285.5169982910156 -75.41699981689453,285.5169982910156 C-77.51799774169922,285.5199890136719 -79.90799713134766,284.7640075683594 -82.0530014038086,283.48199462890625 C-84.197998046875,282.20001220703125 -85.9990005493164,280.4580078125 -86.98600006103516,278.59600830078125 C-86.98600006103516,278.59600830078125 -86.98699951171875,278.5929870605469 -86.98699951171875,278.5929870605469 C-86.98699951171875,278.5929870605469 -92.63300323486328,268.00299072265625 -92.63300323486328,268.00299072265625 C-92.63300323486328,268.00299072265625 -92.63400268554688,268.00299072265625 -92.63400268554688,268.00299072265625 C-93.62699890136719,266.1520080566406 -93.56300354003906,264.6709899902344 -92.98899841308594,263.7070007324219 C-92.41400146484375,262.739990234375 -91.13899993896484,261.9840087890625 -89.03600311279297,261.9779968261719 C-89.03600311279297,261.9779968261719 -69.28099822998047,261.9230041503906 -69.28099822998047,261.9230041503906 C-68.92400360107422,261.9230041503906 -68.59400177001953,261.73699951171875 -68.41100311279297,261.4280090332031 C-68.22699737548828,261.12298583984375 -68.21800231933594,260.7430114746094 -68.38500213623047,260.4280090332031 C-68.38500213623047,260.4280090332031 -76.56800079345703,245.05099487304688 -76.56800079345703,245.05099487304688 C-76.56900024414062,245.05099487304688 -76.56900024414062,245.05099487304688 -76.56900024414062,245.05099487304688 C-77.55599975585938,243.18899536132812 -77.49400329589844,241.70700073242188 -76.91899871826172,240.74400329589844 C-76.34600067138672,239.78500366210938 -75.0770034790039,239.0279998779297 -72.97200012207031,239.02200317382812 C-72.97200012207031,239.02200317382812 -56.24599838256836,238.97799682617188 -56.24599838256836,238.97799682617188 C-54.138999938964844,238.9709930419922 -51.74800109863281,239.7310028076172 -49.60599899291992,241.01499938964844 C-47.4630012512207,242.30099487304688 -45.665000915527344,244.04299926757812 -44.676998138427734,245.8979949951172 C-44.676998138427734,245.8979949951172 -44.676998138427734,245.8979949951172 -44.676998138427734,245.8979949951172 C-44.676998138427734,245.8979949951172 -36.49300003051758,261.2760009765625 -36.49300003051758,261.2760009765625 C-36.316001892089844,261.6109924316406 -35.970001220703125,261.8179931640625 -35.59299850463867,261.81500244140625 C-35.59299850463867,261.81500244140625 -15.838000297546387,261.7640075683594 -15.838000297546387,261.7640075683594 C-13.73799991607666,261.7569885253906 -11.345999717712402,262.5140075683594 -9.20199966430664,263.7950134277344 C-7.057000160217285,265.0769958496094 -5.25600004196167,266.822998046875 -4.269000053405762,268.68499755859375 C-4.269000053405762,268.68499755859375 -4.26800012588501,268.68499755859375 -4.26800012588501,268.68499755859375 C-4.26800012588501,268.68499755859375 1.378000020980835,279.27398681640625 1.378000020980835,279.27398681640625z">
                                                        </path>
                                                    </g>
                                                </g>
                                                <g mask="url(#__lottie_element_456_1)" style="display: block;">
                                                    <g id="2929"
                                                        transform="matrix(2,0,0,2,286.9429931640625,304.9630126953125)"
                                                        opacity="1">
                                                        <g opacity="1"
                                                            transform="matrix(1,0,0,1,-13.043000221252441,-3.9760000705718994)">
                                                            <path fill="rgb(27,27,27)" fill-opacity="1"
                                                                d=" M2.4179999828338623,-1.6740000247955322 C2.4179999828338623,-1.6740000247955322 1.5679999589920044,-1.6759999990463257 1.5679999589920044,-1.6759999990463257 C1.4559999704360962,-1.6759999990463257 1.3680000305175781,-1.6460000276565552 1.3070000410079956,-1.593999981880188 C1.3070000410079956,-1.593999981880188 -2.677999973297119,1.7569999694824219 -2.677999973297119,1.7569999694824219 C-2.617000102996826,1.7039999961853027 -2.5299999713897705,1.6740000247955322 -2.4179999828338623,1.6740000247955322 C-2.4179999828338623,1.6740000247955322 -1.5679999589920044,1.6759999990463257 -1.5679999589920044,1.6759999990463257 C-1.4570000171661377,1.6759999990463257 -1.3680000305175781,1.6460000276565552 -1.3070000410079956,1.593999981880188 C-1.3070000410079956,1.593999981880188 2.677999973297119,-1.7569999694824219 2.677999973297119,-1.7569999694824219 C2.617000102996826,-1.7039999961853027 2.5299999713897705,-1.6740000247955322 2.4179999828338623,-1.6740000247955322z">
                                                            </path>
                                                            <path stroke-linecap="round" stroke-linejoin="round"
                                                                fill-opacity="0" stroke="rgb(46,204,255)"
                                                                stroke-opacity="1" stroke-width="0.5"
                                                                d=" M2.4179999828338623,-1.6740000247955322 C2.4179999828338623,-1.6740000247955322 1.5679999589920044,-1.6759999990463257 1.5679999589920044,-1.6759999990463257 C1.4559999704360962,-1.6759999990463257 1.3680000305175781,-1.6460000276565552 1.3070000410079956,-1.593999981880188 C1.3070000410079956,-1.593999981880188 -2.677999973297119,1.7569999694824219 -2.677999973297119,1.7569999694824219 C-2.617000102996826,1.7039999961853027 -2.5299999713897705,1.6740000247955322 -2.4179999828338623,1.6740000247955322 C-2.4179999828338623,1.6740000247955322 -1.5679999589920044,1.6759999990463257 -1.5679999589920044,1.6759999990463257 C-1.4570000171661377,1.6759999990463257 -1.3680000305175781,1.6460000276565552 -1.3070000410079956,1.593999981880188 C-1.3070000410079956,1.593999981880188 2.677999973297119,-1.7569999694824219 2.677999973297119,-1.7569999694824219 C2.617000102996826,-1.7039999961853027 2.5299999713897705,-1.6740000247955322 2.4179999828338623,-1.6740000247955322z">
                                                            </path>
                                                        </g>
                                                        <g opacity="1"
                                                            transform="matrix(1,0,0,1,7.186999797821045,-5.3520002365112305)">
                                                            <path fill="rgb(27,27,27)" fill-opacity="1"
                                                                d=" M-1.1419999599456787,2.505000114440918 C-0.9750000238418579,2.8259999752044678 -0.5720000267028809,3.0869998931884766 -0.2460000067949295,3.0869998931884766 C-0.2460000067949295,3.0869998931884766 2.622999906539917,0.6759999990463257 2.622999906539917,0.6759999990463257 C2.622999906539917,0.6759999990463257 0.6549999713897705,-3.0869998931884766 0.6549999713897705,-3.0869998931884766 C0.6549999713897705,-3.0869998931884766 -2.622999906539917,-0.33000001311302185 -2.622999906539917,-0.33000001311302185 C-2.622999906539917,-0.33000001311302185 -1.1399999856948853,2.505000114440918 -1.1399999856948853,2.505000114440918 C-1.1399999856948853,2.505000114440918 -1.1419999599456787,2.505000114440918 -1.1419999599456787,2.505000114440918z">
                                                            </path>
                                                            <path stroke-linecap="round" stroke-linejoin="round"
                                                                fill-opacity="0" stroke="rgb(46,204,255)"
                                                                stroke-opacity="1" stroke-width="0.5"
                                                                d=" M-1.1419999599456787,2.505000114440918 C-0.9750000238418579,2.8259999752044678 -0.5720000267028809,3.0869998931884766 -0.2460000067949295,3.0869998931884766 C-0.2460000067949295,3.0869998931884766 2.622999906539917,0.6759999990463257 2.622999906539917,0.6759999990463257 C2.622999906539917,0.6759999990463257 0.6549999713897705,-3.0869998931884766 0.6549999713897705,-3.0869998931884766 C0.6549999713897705,-3.0869998931884766 -2.622999906539917,-0.33000001311302185 -2.622999906539917,-0.33000001311302185 C-2.622999906539917,-0.33000001311302185 -1.1399999856948853,2.505000114440918 -1.1399999856948853,2.505000114440918 C-1.1399999856948853,2.505000114440918 -1.1419999599456787,2.505000114440918 -1.1419999599456787,2.505000114440918z">
                                                            </path>
                                                        </g>
                                                        <g opacity="1"
                                                            transform="matrix(1,0,0,1,-13.097999572753906,-7.97599983215332)">
                                                            <path fill="rgb(27,27,27)" fill-opacity="1"
                                                                d=" M2.4189999103546143,-1.6740000247955322 C2.4189999103546143,-1.6740000247955322 1.5670000314712524,-1.6759999990463257 1.5670000314712524,-1.6759999990463257 C1.4570000171661377,-1.6770000457763672 1.36899995803833,-1.6469999551773071 1.3079999685287476,-1.5950000286102295 C1.3079999685287476,-1.5950000286102295 -2.677000045776367,1.7549999952316284 -2.677000045776367,1.7549999952316284 C-2.615999937057495,1.7029999494552612 -2.5269999504089355,1.6740000247955322 -2.4189999103546143,1.6740000247955322 C-2.4189999103546143,1.6740000247955322 -1.5670000314712524,1.6759999990463257 -1.5670000314712524,1.6759999990463257 C-1.4570000171661377,1.6770000457763672 -1.36899995803833,1.6469999551773071 -1.3079999685287476,1.5950000286102295 C-1.3079999685287476,1.5950000286102295 2.677000045776367,-1.7549999952316284 2.677000045776367,-1.7549999952316284 C2.615999937057495,-1.7029999494552612 2.5290000438690186,-1.6729999780654907 2.4189999103546143,-1.6740000247955322z">
                                                            </path>
                                                            <path stroke-linecap="round" stroke-linejoin="round"
                                                                fill-opacity="0" stroke="rgb(46,204,255)"
                                                                stroke-opacity="1" stroke-width="0.5"
                                                                d=" M2.4189999103546143,-1.6740000247955322 C2.4189999103546143,-1.6740000247955322 1.5670000314712524,-1.6759999990463257 1.5670000314712524,-1.6759999990463257 C1.4570000171661377,-1.6770000457763672 1.36899995803833,-1.6469999551773071 1.3079999685287476,-1.5950000286102295 C1.3079999685287476,-1.5950000286102295 -2.677000045776367,1.7549999952316284 -2.677000045776367,1.7549999952316284 C-2.615999937057495,1.7029999494552612 -2.5269999504089355,1.6740000247955322 -2.4189999103546143,1.6740000247955322 C-2.4189999103546143,1.6740000247955322 -1.5670000314712524,1.6759999990463257 -1.5670000314712524,1.6759999990463257 C-1.4570000171661377,1.6770000457763672 -1.36899995803833,1.6469999551773071 -1.3079999685287476,1.5950000286102295 C-1.3079999685287476,1.5950000286102295 2.677000045776367,-1.7549999952316284 2.677000045776367,-1.7549999952316284 C2.615999937057495,-1.7029999494552612 2.5290000438690186,-1.6729999780654907 2.4189999103546143,-1.6740000247955322z">
                                                            </path>
                                                        </g>
                                                        <g opacity="1"
                                                            transform="matrix(1,0,0,1,10.081000328063965,11.04699993133545)">
                                                            <path fill="rgb(27,27,27)" fill-opacity="1"
                                                                d=" M-2.2109999656677246,1.2569999694824219 C-2.2109999656677246,1.2569999694824219 -1.7740000486373901,2.0929999351501465 -1.7740000486373901,2.0929999351501465 C-1.6629999876022339,2.305000066757202 -1.6829999685287476,2.490000009536743 -1.8029999732971191,2.5910000801086426 C-1.8029999732971191,2.5910000801086426 2.181999921798706,-0.7590000033378601 2.181999921798706,-0.7590000033378601 C2.302999973297119,-0.8600000143051147 2.321000099182129,-1.0460000038146973 2.2119998931884766,-1.2569999694824219 C2.2119998931884766,-1.2569999694824219 1.7740000486373901,-2.0920000076293945 1.7740000486373901,-2.0920000076293945 C1.6629999876022339,-2.305000066757202 1.680999994277954,-2.490999937057495 1.8029999732971191,-2.5910000801086426 C1.8029999732971191,-2.5910000801086426 -2.181999921798706,0.7590000033378601 -2.181999921798706,0.7590000033378601 C-2.302000045776367,0.8610000014305115 -2.321000099182129,1.0470000505447388 -2.2109999656677246,1.2569999694824219z">
                                                            </path>
                                                            <path stroke-linecap="round" stroke-linejoin="round"
                                                                fill-opacity="0" stroke="rgb(46,204,255)"
                                                                stroke-opacity="1" stroke-width="0.5"
                                                                d=" M-2.2109999656677246,1.2569999694824219 C-2.2109999656677246,1.2569999694824219 -1.7740000486373901,2.0929999351501465 -1.7740000486373901,2.0929999351501465 C-1.6629999876022339,2.305000066757202 -1.6829999685287476,2.490000009536743 -1.8029999732971191,2.5910000801086426 C-1.8029999732971191,2.5910000801086426 2.181999921798706,-0.7590000033378601 2.181999921798706,-0.7590000033378601 C2.302999973297119,-0.8600000143051147 2.321000099182129,-1.0460000038146973 2.2119998931884766,-1.2569999694824219 C2.2119998931884766,-1.2569999694824219 1.7740000486373901,-2.0920000076293945 1.7740000486373901,-2.0920000076293945 C1.6629999876022339,-2.305000066757202 1.680999994277954,-2.490999937057495 1.8029999732971191,-2.5910000801086426 C1.8029999732971191,-2.5910000801086426 -2.181999921798706,0.7590000033378601 -2.181999921798706,0.7590000033378601 C-2.302000045776367,0.8610000014305115 -2.321000099182129,1.0470000505447388 -2.2109999656677246,1.2569999694824219z">
                                                            </path>
                                                        </g>
                                                        <g opacity="1"
                                                            transform="matrix(1,0,0,1,13.107999801635742,9.053999900817871)">
                                                            <path fill="rgb(27,27,27)" fill-opacity="1"
                                                                d=" M-2.2109999656677246,1.2569999694824219 C-2.2109999656677246,1.2569999694824219 -1.7740000486373901,2.0929999351501465 -1.7740000486373901,2.0929999351501465 C-1.6629999876022339,2.305000066757202 -1.680999994277954,2.490999937057495 -1.8029999732971191,2.5910000801086426 C-1.8029999732971191,2.5910000801086426 2.181999921798706,-0.7590000033378601 2.181999921798706,-0.7590000033378601 C2.302000045776367,-0.8600000143051147 2.321000099182129,-1.0470000505447388 2.2109999656677246,-1.2569999694824219 C2.2109999656677246,-1.2569999694824219 1.7730000019073486,-2.0929999351501465 1.7730000019073486,-2.0929999351501465 C1.6619999408721924,-2.305000066757202 1.6820000410079956,-2.489000082015991 1.8029999732971191,-2.5910000801086426 C1.8029999732971191,-2.5910000801086426 -2.181999921798706,0.7590000033378601 -2.181999921798706,0.7590000033378601 C-2.302000045776367,0.8600000143051147 -2.321000099182129,1.0470000505447388 -2.2109999656677246,1.2569999694824219z">
                                                            </path>
                                                            <path stroke-linecap="round" stroke-linejoin="round"
                                                                fill-opacity="0" stroke="rgb(46,204,255)"
                                                                stroke-opacity="1" stroke-width="0.5"
                                                                d=" M-2.2109999656677246,1.2569999694824219 C-2.2109999656677246,1.2569999694824219 -1.7740000486373901,2.0929999351501465 -1.7740000486373901,2.0929999351501465 C-1.6629999876022339,2.305000066757202 -1.680999994277954,2.490999937057495 -1.8029999732971191,2.5910000801086426 C-1.8029999732971191,2.5910000801086426 2.181999921798706,-0.7590000033378601 2.181999921798706,-0.7590000033378601 C2.302000045776367,-0.8600000143051147 2.321000099182129,-1.0470000505447388 2.2109999656677246,-1.2569999694824219 C2.2109999656677246,-1.2569999694824219 1.7730000019073486,-2.0929999351501465 1.7730000019073486,-2.0929999351501465 C1.6619999408721924,-2.305000066757202 1.6820000410079956,-2.489000082015991 1.8029999732971191,-2.5910000801086426 C1.8029999732971191,-2.5910000801086426 -2.181999921798706,0.7590000033378601 -2.181999921798706,0.7590000033378601 C-2.302000045776367,0.8600000143051147 -2.321000099182129,1.0470000505447388 -2.2109999656677246,1.2569999694824219z">
                                                            </path>
                                                        </g>
                                                        <g opacity="1"
                                                            transform="matrix(1,0,0,1,-11.090999603271484,-9.968000411987305)">
                                                            <path fill="rgb(27,27,27)" fill-opacity="1"
                                                                d=" M3.437000036239624,-1.6729999780654907 C3.437000036239624,-1.6729999780654907 0.5479999780654907,-1.6770000457763672 0.5479999780654907,-1.6770000457763672 C0.43799999356269836,-1.6779999732971191 0.3499999940395355,-1.6480000019073486 0.289000004529953,-1.5950000286102295 C0.289000004529953,-1.5950000286102295 -3.696000099182129,1.753999948501587 -3.696000099182129,1.753999948501587 C-3.634999990463257,1.7020000219345093 -3.5480000972747803,1.6720000505447388 -3.437000036239624,1.6729999780654907 C-3.437000036239624,1.6729999780654907 -0.5479999780654907,1.6770000457763672 -0.5479999780654907,1.6770000457763672 C-0.43799999356269836,1.6779999732971191 -0.3499999940395355,1.6480000019073486 -0.289000004529953,1.5959999561309814 C-0.289000004529953,1.5959999561309814 3.696000099182129,-1.753999948501587 3.696000099182129,-1.753999948501587 C3.634999990463257,-1.7020000219345093 3.5460000038146973,-1.6729999780654907 3.437000036239624,-1.6729999780654907z">
                                                            </path>
                                                            <path stroke-linecap="round" stroke-linejoin="round"
                                                                fill-opacity="0" stroke="rgb(46,204,255)"
                                                                stroke-opacity="1" stroke-width="0.5"
                                                                d=" M3.437000036239624,-1.6729999780654907 C3.437000036239624,-1.6729999780654907 0.5479999780654907,-1.6770000457763672 0.5479999780654907,-1.6770000457763672 C0.43799999356269836,-1.6779999732971191 0.3499999940395355,-1.6480000019073486 0.289000004529953,-1.5950000286102295 C0.289000004529953,-1.5950000286102295 -3.696000099182129,1.753999948501587 -3.696000099182129,1.753999948501587 C-3.634999990463257,1.7020000219345093 -3.5480000972747803,1.6720000505447388 -3.437000036239624,1.6729999780654907 C-3.437000036239624,1.6729999780654907 -0.5479999780654907,1.6770000457763672 -0.5479999780654907,1.6770000457763672 C-0.43799999356269836,1.6779999732971191 -0.3499999940395355,1.6480000019073486 -0.289000004529953,1.5959999561309814 C-0.289000004529953,1.5959999561309814 3.696000099182129,-1.753999948501587 3.696000099182129,-1.753999948501587 C3.634999990463257,-1.7020000219345093 3.5460000038146973,-1.6729999780654907 3.437000036239624,-1.6729999780654907z">
                                                            </path>
                                                        </g>
                                                        <g opacity="1"
                                                            transform="matrix(1,0,0,1,13.270999908447266,6.439000129699707)">
                                                            <path fill="rgb(27,27,27)" fill-opacity="1"
                                                                d=" M-2.430000066757202,-0.12399999797344208 C-2.430000066757202,-0.12399999797344208 -0.9480000138282776,2.7109999656677246 -0.9480000138282776,2.7109999656677246 C-0.8370000123977661,2.9240000247955322 -0.8569999933242798,3.109999895095825 -0.9779999852180481,3.2119998931884766 C-0.9779999852180481,3.2119998931884766 2.503999948501587,0.2840000092983246 2.503999948501587,0.2840000092983246 C2.503999948501587,0.2840000092983246 0.6740000247955322,-3.2119998931884766 0.6740000247955322,-3.2119998931884766 C0.6740000247955322,-3.2119998931884766 -2.4030001163482666,-0.6259999871253967 -2.4030001163482666,-0.6259999871253967 C-2.5230000019073486,-0.5239999890327454 -2.5409998893737793,-0.33799999952316284 -2.431999921798706,-0.12800000607967377 C-2.431999921798706,-0.12800000607967377 -2.430000066757202,-0.12399999797344208 -2.430000066757202,-0.12399999797344208z">
                                                            </path>
                                                            <path stroke-linecap="round" stroke-linejoin="round"
                                                                fill-opacity="0" stroke="rgb(46,204,255)"
                                                                stroke-opacity="1" stroke-width="0.5"
                                                                d=" M-2.430000066757202,-0.12399999797344208 C-2.430000066757202,-0.12399999797344208 -0.9480000138282776,2.7109999656677246 -0.9480000138282776,2.7109999656677246 C-0.8370000123977661,2.9240000247955322 -0.8569999933242798,3.109999895095825 -0.9779999852180481,3.2119998931884766 C-0.9779999852180481,3.2119998931884766 2.503999948501587,0.2840000092983246 2.503999948501587,0.2840000092983246 C2.503999948501587,0.2840000092983246 0.6740000247955322,-3.2119998931884766 0.6740000247955322,-3.2119998931884766 C0.6740000247955322,-3.2119998931884766 -2.4030001163482666,-0.6259999871253967 -2.4030001163482666,-0.6259999871253967 C-2.5230000019073486,-0.5239999890327454 -2.5409998893737793,-0.33799999952316284 -2.431999921798706,-0.12800000607967377 C-2.431999921798706,-0.12800000607967377 -2.430000066757202,-0.12399999797344208 -2.430000066757202,-0.12399999797344208z">
                                                            </path>
                                                        </g>
                                                        <g opacity="1"
                                                            transform="matrix(1,0,0,1,-1.7389999628067017,1.7120000123977661)">
                                                            <path fill="rgb(72,255,144)" fill-opacity="1"
                                                                d=" M-9.659000396728516,-11.779000282287598 C-9.659000396728516,-11.779000282287598 -9.657999992370605,-11.777000427246094 -9.657999992370605,-11.777000427246094 C-9.657999992370605,-11.777000427246094 -2.697000026702881,-11.767000198364258 -2.697000026702881,-11.767000198364258 C-2.697000026702881,-11.767000198364258 -2.696000099182129,-11.767999649047852 -2.696000099182129,-11.767999649047852 C-2.555000066757202,-11.767999649047852 -2.3340001106262207,-11.656000137329102 -2.2009999752044678,-11.475000381469727 C-2.2009999752044678,-11.475000381469727 -2.1489999294281006,-11.392999649047852 -2.1489999294281006,-11.392999649047852 C-2.1489999294281006,-11.392999649047852 -1.7130000591278076,-10.559000015258789 -1.7130000591278076,-10.559000015258789 C-1.4980000257492065,-10.147000312805176 -0.9549999833106995,-9.765999794006348 -0.4659999907016754,-9.765999794006348 C-0.4659999907016754,-9.765999794006348 -0.4650000035762787,-9.765999794006348 -0.4650000035762787,-9.765999794006348 C-0.4650000035762787,-9.765999794006348 2.4230000972747803,-9.760000228881836 2.4230000972747803,-9.760000228881836 C2.4230000972747803,-9.760000228881836 2.4240000247955322,-9.760000228881836 2.4240000247955322,-9.760000228881836 C2.565000057220459,-9.760000228881836 2.7839999198913574,-9.649999618530273 2.9170000553131104,-9.468999862670898 C2.9170000553131104,-9.468999862670898 2.9679999351501465,-9.38700008392334 2.9679999351501465,-9.38700008392334 C2.9679999351501465,-9.38700008392334 3.4049999713897705,-8.553000450134277 3.4049999713897705,-8.553000450134277 C3.621000051498413,-8.138999938964844 4.165999889373779,-7.76200008392334 4.65500020980835,-7.76200008392334 C4.65500020980835,-7.76200008392334 4.65500020980835,-7.760000228881836 4.65500020980835,-7.760000228881836 C4.65500020980835,-7.760000228881836 5.506999969482422,-7.757999897003174 5.506999969482422,-7.757999897003174 C5.506999969482422,-7.757999897003174 5.507999897003174,-7.757999897003174 5.507999897003174,-7.757999897003174 C5.64900016784668,-7.757999897003174 5.86899995803833,-7.645999908447266 6.001999855041504,-7.465000152587891 C6.001999855041504,-7.465000152587891 6.052999973297119,-7.382999897003174 6.052999973297119,-7.382999897003174 C6.052999973297119,-7.382999897003174 7.535999774932861,-4.548999786376953 7.535999774932861,-4.548999786376953 C7.75,-4.138999938964844 8.293000221252441,-3.759000062942505 8.781999588012695,-3.757999897003174 C8.781999588012695,-3.757999897003174 8.782999992370605,-3.757999897003174 8.782999992370605,-3.757999897003174 C8.782999992370605,-3.757999897003174 9.635000228881836,-3.75600004196167 9.635000228881836,-3.75600004196167 C9.635000228881836,-3.75600004196167 9.635000228881836,-3.75600004196167 9.635000228881836,-3.75600004196167 C9.777000427246094,-3.75600004196167 9.996999740600586,-3.6449999809265137 10.128999710083008,-3.4639999866485596 C10.128999710083008,-3.4639999866485596 10.180000305175781,-3.382999897003174 10.180000305175781,-3.382999897003174 C10.180000305175781,-3.382999897003174 13.756999969482422,3.4519999027252197 13.756999969482422,3.4519999027252197 C13.87399959564209,3.6760001182556152 13.763999938964844,3.799999952316284 13.619000434875488,3.799999952316284 C13.619000434875488,3.799999952316284 13.619999885559082,3.799999952316284 13.619999885559082,3.799999952316284 C13.619999885559082,3.799999952316284 12.767999649047852,3.7980000972747803 12.767999649047852,3.7980000972747803 C12.767999649047852,3.7980000972747803 12.767000198364258,3.7980000972747803 12.767000198364258,3.7980000972747803 C12.291999816894531,3.7960000038146973 12.133000373840332,4.145999908447266 12.293000221252441,4.5329999923706055 C12.293000221252441,4.5329999923706055 12.329999923706055,4.611000061035156 12.329999923706055,4.611000061035156 C12.329999923706055,4.611000061035156 13.812999725341797,7.447000026702881 13.812999725341797,7.447000026702881 C13.930000305175781,7.671000003814697 13.819999694824219,7.794000148773193 13.675000190734863,7.794000148773193 C13.675000190734863,7.794000148773193 13.673999786376953,7.794000148773193 13.673999786376953,7.794000148773193 C13.673999786376953,7.794000148773193 12.824000358581543,7.791999816894531 12.824000358581543,7.791999816894531 C12.824000358581543,7.791999816894531 12.824999809265137,7.791999816894531 12.824999809265137,7.791999816894531 C12.347999572753906,7.789999961853027 12.187000274658203,8.140999794006348 12.347999572753906,8.529000282287598 C12.347999572753906,8.529000282287598 12.385000228881836,8.607000350952148 12.385000228881836,8.607000350952148 C12.385000228881836,8.607000350952148 12.821000099182129,9.440999984741211 12.821000099182129,9.440999984741211 C12.92300033569336,9.635000228881836 12.85200023651123,9.755000114440918 12.734999656677246,9.781000137329102 C12.734999656677246,9.781000137329102 12.682999610900879,9.788000106811523 12.682999610900879,9.788000106811523 C12.682999610900879,9.788000106811523 9.793999671936035,9.782999992370605 9.793999671936035,9.782999992370605 C9.793999671936035,9.782999992370605 9.793999671936035,9.782999992370605 9.793999671936035,9.782999992370605 C9.319000244140625,9.781000137329102 9.15999984741211,10.133000373840332 9.321000099182129,10.517999649047852 C9.321000099182129,10.517999649047852 9.357999801635742,10.595999717712402 9.357999801635742,10.595999717712402 C9.357999801635742,10.595999717712402 9.795999526977539,11.432000160217285 9.795999526977539,11.432000160217285 C9.911999702453613,11.654000282287598 9.800999641418457,11.779000282287598 9.654000282287598,11.779000282287598 C9.654000282287598,11.779000282287598 9.654999732971191,11.779000282287598 9.654999732971191,11.779000282287598 C9.654999732971191,11.779000282287598 2.693000078201294,11.765999794006348 2.693000078201294,11.765999794006348 C2.693000078201294,11.765999794006348 2.693000078201294,11.767999649047852 2.693000078201294,11.767999649047852 C2.5510001182556152,11.767999649047852 2.3320000171661377,11.656000137329102 2.1989998817443848,11.47700023651123 C2.1989998817443848,11.47700023651123 2.1480000019073486,11.395000457763672 2.1480000019073486,11.395000457763672 C2.1480000019073486,11.395000457763672 1.7100000381469727,10.559000015258789 1.7100000381469727,10.559000015258789 C1.496000051498413,10.14799976348877 0.953000009059906,9.767999649047852 0.46299999952316284,9.767999649047852 C0.46299999952316284,9.767999649047852 0.46399998664855957,9.767999649047852 0.46399998664855957,9.767999649047852 C0.46399998664855957,9.767999649047852 -2.4260001182556152,9.763999938964844 -2.4260001182556152,9.763999938964844 C-2.4260001182556152,9.763999938964844 -2.427000045776367,9.763999938964844 -2.427000045776367,9.763999938964844 C-2.569000005722046,9.763999938964844 -2.7869999408721924,9.654000282287598 -2.9200000762939453,9.472999572753906 C-2.9200000762939453,9.472999572753906 -2.9709999561309814,9.390999794006348 -2.9709999561309814,9.390999794006348 C-2.9709999561309814,9.390999794006348 -2.9719998836517334,9.390999794006348 -2.9719998836517334,9.390999794006348 C-2.9719998836517334,9.390999794006348 -3.4089999198913574,8.555000305175781 -3.4089999198913574,8.555000305175781 C-3.621999979019165,8.145999908447266 -4.166999816894531,7.763999938964844 -4.656000137329102,7.763999938964844 C-4.656000137329102,7.763999938964844 -4.656000137329102,7.763999938964844 -4.656000137329102,7.763999938964844 C-4.656000137329102,7.763999938964844 -5.506999969482422,7.76200008392334 -5.506999969482422,7.76200008392334 C-5.506999969482422,7.76200008392334 -5.507999897003174,7.76200008392334 -5.507999897003174,7.76200008392334 C-5.650000095367432,7.76200008392334 -5.86899995803833,7.6519999504089355 -6.002999782562256,7.468999862670898 C-6.002999782562256,7.468999862670898 -6.053999900817871,7.38700008392334 -6.053999900817871,7.38700008392334 C-6.053999900817871,7.38700008392334 -7.5370001792907715,4.551000118255615 -7.5370001792907715,4.551000118255615 C-7.5370001792907715,4.551000118255615 -7.538000106811523,4.551000118255615 -7.538000106811523,4.551000118255615 C-7.741000175476074,4.166999816894531 -8.230999946594238,3.806999921798706 -8.694999694824219,3.7639999389648438 C-8.694999694824219,3.7639999389648438 -8.786999702453613,3.759999990463257 -8.786999702453613,3.759999990463257 C-8.786999702453613,3.759999990463257 -9.63700008392334,3.759000062942505 -9.63700008392334,3.759000062942505 C-9.779000282287598,3.759000062942505 -9.99899959564209,3.6480000019073486 -10.131999969482422,3.4660000801086426 C-10.131999969482422,3.4660000801086426 -10.184000015258789,3.384000062942505 -10.184000015258789,3.384000062942505 C-10.184000015258789,3.384000062942505 -13.760000228881836,-3.4509999752044678 -13.760000228881836,-3.4509999752044678 C-13.862000465393066,-3.6449999809265137 -13.789999961853027,-3.7639999389648438 -13.670999526977539,-3.7899999618530273 C-13.670999526977539,-3.7899999618530273 -13.619000434875488,-3.796999931335449 -13.619000434875488,-3.796999931335449 C-13.619000434875488,-3.796999931335449 -12.770000457763672,-3.796999931335449 -12.770000457763672,-3.796999931335449 C-12.770000457763672,-3.796999931335449 -12.770000457763672,-3.7960000038146973 -12.770000457763672,-3.7960000038146973 C-12.293000221252441,-3.7939999103546143 -12.130999565124512,-4.144999980926514 -12.293000221252441,-4.5329999923706055 C-12.293000221252441,-4.5329999923706055 -12.329999923706055,-4.611000061035156 -12.329999923706055,-4.611000061035156 C-12.329999923706055,-4.611000061035156 -13.812000274658203,-7.446000099182129 -13.812000274658203,-7.446000099182129 C-13.928999900817871,-7.669000148773193 -13.821000099182129,-7.791999816894531 -13.675999641418457,-7.794000148773193 C-13.675999641418457,-7.794000148773193 -13.675000190734863,-7.791999816894531 -13.675000190734863,-7.791999816894531 C-13.675000190734863,-7.791999816894531 -12.822999954223633,-7.789999961853027 -12.822999954223633,-7.789999961853027 C-12.822999954223633,-7.789999961853027 -12.824000358581543,-7.789999961853027 -12.824000358581543,-7.789999961853027 C-12.347999572753906,-7.788000106811523 -12.189000129699707,-8.138999938964844 -12.350000381469727,-8.527000427246094 C-12.350000381469727,-8.527000427246094 -12.38599967956543,-8.604000091552734 -12.38599967956543,-8.604000091552734 C-12.38599967956543,-8.604000091552734 -12.38599967956543,-8.604999542236328 -12.38599967956543,-8.604999542236328 C-12.38599967956543,-8.604999542236328 -12.822999954223633,-9.439000129699707 -12.822999954223633,-9.439000129699707 C-12.923999786376953,-9.633999824523926 -12.852999687194824,-9.753000259399414 -12.737000465393066,-9.779999732971191 C-12.737000465393066,-9.779999732971191 -12.684000015258789,-9.78499984741211 -12.684000015258789,-9.78499984741211 C-12.684000015258789,-9.78499984741211 -9.795000076293945,-9.781000137329102 -9.795000076293945,-9.781000137329102 C-9.321000099182129,-9.781000137329102 -9.16100025177002,-10.131999969482422 -9.321999549865723,-10.519000053405762 C-9.321999549865723,-10.519000053405762 -9.359000205993652,-10.595999717712402 -9.359000205993652,-10.595999717712402 C-9.359000205993652,-10.595999717712402 -9.795000076293945,-11.430000305175781 -9.795000076293945,-11.430000305175781 C-9.91100025177002,-11.654000282287598 -9.803000450134277,-11.777999877929688 -9.659000396728516,-11.779000282287598z">
                                                            </path>
                                                            <path stroke-linecap="butt" stroke-linejoin="miter"
                                                                fill-opacity="0" stroke-miterlimit="4"
                                                                stroke="rgb(46,204,255)" stroke-opacity="1"
                                                                stroke-width="0.5"
                                                                d=" M-9.659000396728516,-11.779000282287598 C-9.659000396728516,-11.779000282287598 -9.657999992370605,-11.777000427246094 -9.657999992370605,-11.777000427246094 C-9.657999992370605,-11.777000427246094 -2.697000026702881,-11.767000198364258 -2.697000026702881,-11.767000198364258 C-2.697000026702881,-11.767000198364258 -2.696000099182129,-11.767999649047852 -2.696000099182129,-11.767999649047852 C-2.555000066757202,-11.767999649047852 -2.3340001106262207,-11.656000137329102 -2.2009999752044678,-11.475000381469727 C-2.2009999752044678,-11.475000381469727 -2.1489999294281006,-11.392999649047852 -2.1489999294281006,-11.392999649047852 C-2.1489999294281006,-11.392999649047852 -1.7130000591278076,-10.559000015258789 -1.7130000591278076,-10.559000015258789 C-1.4980000257492065,-10.147000312805176 -0.9549999833106995,-9.765999794006348 -0.4659999907016754,-9.765999794006348 C-0.4659999907016754,-9.765999794006348 -0.4650000035762787,-9.765999794006348 -0.4650000035762787,-9.765999794006348 C-0.4650000035762787,-9.765999794006348 2.4230000972747803,-9.760000228881836 2.4230000972747803,-9.760000228881836 C2.4230000972747803,-9.760000228881836 2.4240000247955322,-9.760000228881836 2.4240000247955322,-9.760000228881836 C2.565000057220459,-9.760000228881836 2.7839999198913574,-9.649999618530273 2.9170000553131104,-9.468999862670898 C2.9170000553131104,-9.468999862670898 2.9679999351501465,-9.38700008392334 2.9679999351501465,-9.38700008392334 C2.9679999351501465,-9.38700008392334 3.4049999713897705,-8.553000450134277 3.4049999713897705,-8.553000450134277 C3.621000051498413,-8.138999938964844 4.165999889373779,-7.76200008392334 4.65500020980835,-7.76200008392334 C4.65500020980835,-7.76200008392334 4.65500020980835,-7.760000228881836 4.65500020980835,-7.760000228881836 C4.65500020980835,-7.760000228881836 5.506999969482422,-7.757999897003174 5.506999969482422,-7.757999897003174 C5.506999969482422,-7.757999897003174 5.507999897003174,-7.757999897003174 5.507999897003174,-7.757999897003174 C5.64900016784668,-7.757999897003174 5.86899995803833,-7.645999908447266 6.001999855041504,-7.465000152587891 C6.001999855041504,-7.465000152587891 6.052999973297119,-7.382999897003174 6.052999973297119,-7.382999897003174 C6.052999973297119,-7.382999897003174 7.535999774932861,-4.548999786376953 7.535999774932861,-4.548999786376953 C7.75,-4.138999938964844 8.293000221252441,-3.759000062942505 8.781999588012695,-3.757999897003174 C8.781999588012695,-3.757999897003174 8.782999992370605,-3.757999897003174 8.782999992370605,-3.757999897003174 C8.782999992370605,-3.757999897003174 9.635000228881836,-3.75600004196167 9.635000228881836,-3.75600004196167 C9.635000228881836,-3.75600004196167 9.635000228881836,-3.75600004196167 9.635000228881836,-3.75600004196167 C9.777000427246094,-3.75600004196167 9.996999740600586,-3.6449999809265137 10.128999710083008,-3.4639999866485596 C10.128999710083008,-3.4639999866485596 10.180000305175781,-3.382999897003174 10.180000305175781,-3.382999897003174 C10.180000305175781,-3.382999897003174 13.756999969482422,3.4519999027252197 13.756999969482422,3.4519999027252197 C13.87399959564209,3.6760001182556152 13.763999938964844,3.799999952316284 13.619000434875488,3.799999952316284 C13.619000434875488,3.799999952316284 13.619999885559082,3.799999952316284 13.619999885559082,3.799999952316284 C13.619999885559082,3.799999952316284 12.767999649047852,3.7980000972747803 12.767999649047852,3.7980000972747803 C12.767999649047852,3.7980000972747803 12.767000198364258,3.7980000972747803 12.767000198364258,3.7980000972747803 C12.291999816894531,3.7960000038146973 12.133000373840332,4.145999908447266 12.293000221252441,4.5329999923706055 C12.293000221252441,4.5329999923706055 12.329999923706055,4.611000061035156 12.329999923706055,4.611000061035156 C12.329999923706055,4.611000061035156 13.812999725341797,7.447000026702881 13.812999725341797,7.447000026702881 C13.930000305175781,7.671000003814697 13.819999694824219,7.794000148773193 13.675000190734863,7.794000148773193 C13.675000190734863,7.794000148773193 13.673999786376953,7.794000148773193 13.673999786376953,7.794000148773193 C13.673999786376953,7.794000148773193 12.824000358581543,7.791999816894531 12.824000358581543,7.791999816894531 C12.824000358581543,7.791999816894531 12.824999809265137,7.791999816894531 12.824999809265137,7.791999816894531 C12.347999572753906,7.789999961853027 12.187000274658203,8.140999794006348 12.347999572753906,8.529000282287598 C12.347999572753906,8.529000282287598 12.385000228881836,8.607000350952148 12.385000228881836,8.607000350952148 C12.385000228881836,8.607000350952148 12.821000099182129,9.440999984741211 12.821000099182129,9.440999984741211 C12.92300033569336,9.635000228881836 12.85200023651123,9.755000114440918 12.734999656677246,9.781000137329102 C12.734999656677246,9.781000137329102 12.682999610900879,9.788000106811523 12.682999610900879,9.788000106811523 C12.682999610900879,9.788000106811523 9.793999671936035,9.782999992370605 9.793999671936035,9.782999992370605 C9.793999671936035,9.782999992370605 9.793999671936035,9.782999992370605 9.793999671936035,9.782999992370605 C9.319000244140625,9.781000137329102 9.15999984741211,10.133000373840332 9.321000099182129,10.517999649047852 C9.321000099182129,10.517999649047852 9.357999801635742,10.595999717712402 9.357999801635742,10.595999717712402 C9.357999801635742,10.595999717712402 9.795999526977539,11.432000160217285 9.795999526977539,11.432000160217285 C9.911999702453613,11.654000282287598 9.800999641418457,11.779000282287598 9.654000282287598,11.779000282287598 C9.654000282287598,11.779000282287598 9.654999732971191,11.779000282287598 9.654999732971191,11.779000282287598 C9.654999732971191,11.779000282287598 2.693000078201294,11.765999794006348 2.693000078201294,11.765999794006348 C2.693000078201294,11.765999794006348 2.693000078201294,11.767999649047852 2.693000078201294,11.767999649047852 C2.5510001182556152,11.767999649047852 2.3320000171661377,11.656000137329102 2.1989998817443848,11.47700023651123 C2.1989998817443848,11.47700023651123 2.1480000019073486,11.395000457763672 2.1480000019073486,11.395000457763672 C2.1480000019073486,11.395000457763672 1.7100000381469727,10.559000015258789 1.7100000381469727,10.559000015258789 C1.496000051498413,10.14799976348877 0.953000009059906,9.767999649047852 0.46299999952316284,9.767999649047852 C0.46299999952316284,9.767999649047852 0.46399998664855957,9.767999649047852 0.46399998664855957,9.767999649047852 C0.46399998664855957,9.767999649047852 -2.4260001182556152,9.763999938964844 -2.4260001182556152,9.763999938964844 C-2.4260001182556152,9.763999938964844 -2.427000045776367,9.763999938964844 -2.427000045776367,9.763999938964844 C-2.569000005722046,9.763999938964844 -2.7869999408721924,9.654000282287598 -2.9200000762939453,9.472999572753906 C-2.9200000762939453,9.472999572753906 -2.9709999561309814,9.390999794006348 -2.9709999561309814,9.390999794006348 C-2.9709999561309814,9.390999794006348 -2.9719998836517334,9.390999794006348 -2.9719998836517334,9.390999794006348 C-2.9719998836517334,9.390999794006348 -3.4089999198913574,8.555000305175781 -3.4089999198913574,8.555000305175781 C-3.621999979019165,8.145999908447266 -4.166999816894531,7.763999938964844 -4.656000137329102,7.763999938964844 C-4.656000137329102,7.763999938964844 -4.656000137329102,7.763999938964844 -4.656000137329102,7.763999938964844 C-4.656000137329102,7.763999938964844 -5.506999969482422,7.76200008392334 -5.506999969482422,7.76200008392334 C-5.506999969482422,7.76200008392334 -5.507999897003174,7.76200008392334 -5.507999897003174,7.76200008392334 C-5.650000095367432,7.76200008392334 -5.86899995803833,7.6519999504089355 -6.002999782562256,7.468999862670898 C-6.002999782562256,7.468999862670898 -6.053999900817871,7.38700008392334 -6.053999900817871,7.38700008392334 C-6.053999900817871,7.38700008392334 -7.5370001792907715,4.551000118255615 -7.5370001792907715,4.551000118255615 C-7.5370001792907715,4.551000118255615 -7.538000106811523,4.551000118255615 -7.538000106811523,4.551000118255615 C-7.741000175476074,4.166999816894531 -8.230999946594238,3.806999921798706 -8.694999694824219,3.7639999389648438 C-8.694999694824219,3.7639999389648438 -8.786999702453613,3.759999990463257 -8.786999702453613,3.759999990463257 C-8.786999702453613,3.759999990463257 -9.63700008392334,3.759000062942505 -9.63700008392334,3.759000062942505 C-9.779000282287598,3.759000062942505 -9.99899959564209,3.6480000019073486 -10.131999969482422,3.4660000801086426 C-10.131999969482422,3.4660000801086426 -10.184000015258789,3.384000062942505 -10.184000015258789,3.384000062942505 C-10.184000015258789,3.384000062942505 -13.760000228881836,-3.4509999752044678 -13.760000228881836,-3.4509999752044678 C-13.862000465393066,-3.6449999809265137 -13.789999961853027,-3.7639999389648438 -13.670999526977539,-3.7899999618530273 C-13.670999526977539,-3.7899999618530273 -13.619000434875488,-3.796999931335449 -13.619000434875488,-3.796999931335449 C-13.619000434875488,-3.796999931335449 -12.770000457763672,-3.796999931335449 -12.770000457763672,-3.796999931335449 C-12.770000457763672,-3.796999931335449 -12.770000457763672,-3.7960000038146973 -12.770000457763672,-3.7960000038146973 C-12.293000221252441,-3.7939999103546143 -12.130999565124512,-4.144999980926514 -12.293000221252441,-4.5329999923706055 C-12.293000221252441,-4.5329999923706055 -12.329999923706055,-4.611000061035156 -12.329999923706055,-4.611000061035156 C-12.329999923706055,-4.611000061035156 -13.812000274658203,-7.446000099182129 -13.812000274658203,-7.446000099182129 C-13.928999900817871,-7.669000148773193 -13.821000099182129,-7.791999816894531 -13.675999641418457,-7.794000148773193 C-13.675999641418457,-7.794000148773193 -13.675000190734863,-7.791999816894531 -13.675000190734863,-7.791999816894531 C-13.675000190734863,-7.791999816894531 -12.822999954223633,-7.789999961853027 -12.822999954223633,-7.789999961853027 C-12.822999954223633,-7.789999961853027 -12.824000358581543,-7.789999961853027 -12.824000358581543,-7.789999961853027 C-12.347999572753906,-7.788000106811523 -12.189000129699707,-8.138999938964844 -12.350000381469727,-8.527000427246094 C-12.350000381469727,-8.527000427246094 -12.38599967956543,-8.604000091552734 -12.38599967956543,-8.604000091552734 C-12.38599967956543,-8.604000091552734 -12.38599967956543,-8.604999542236328 -12.38599967956543,-8.604999542236328 C-12.38599967956543,-8.604999542236328 -12.822999954223633,-9.439000129699707 -12.822999954223633,-9.439000129699707 C-12.923999786376953,-9.633999824523926 -12.852999687194824,-9.753000259399414 -12.737000465393066,-9.779999732971191 C-12.737000465393066,-9.779999732971191 -12.684000015258789,-9.78499984741211 -12.684000015258789,-9.78499984741211 C-12.684000015258789,-9.78499984741211 -9.795000076293945,-9.781000137329102 -9.795000076293945,-9.781000137329102 C-9.321000099182129,-9.781000137329102 -9.16100025177002,-10.131999969482422 -9.321999549865723,-10.519000053405762 C-9.321999549865723,-10.519000053405762 -9.359000205993652,-10.595999717712402 -9.359000205993652,-10.595999717712402 C-9.359000205993652,-10.595999717712402 -9.795000076293945,-11.430000305175781 -9.795000076293945,-11.430000305175781 C-9.91100025177002,-11.654000282287598 -9.803000450134277,-11.777999877929688 -9.659000396728516,-11.779000282287598z">
                                                            </path>
                                                        </g>
                                                        <g opacity="1"
                                                            transform="matrix(1,0,0,1,1.2760000228881836,-3.992000102996826)">
                                                            <path fill="rgb(27,27,27)" fill-opacity="1"
                                                                d=" M4.625999927520752,-6.209000110626221 C4.625999927520752,-6.209000110626221 4.188000202178955,-7.045000076293945 4.188000202178955,-7.045000076293945 C4.020999908447266,-7.364999771118164 3.618000030517578,-7.626999855041504 3.2920000553131104,-7.626999855041504 C3.2920000553131104,-7.626999855041504 0.40400001406669617,-7.63100004196167 0.40400001406669617,-7.63100004196167 C0.07800000160932541,-7.63100004196167 -0.32600000500679016,-7.894999980926514 -0.49300000071525574,-8.21500015258789 C-0.49300000071525574,-8.21500015258789 -0.9309999942779541,-9.050000190734863 -0.9309999942779541,-9.050000190734863 C-1.0980000495910645,-9.371000289916992 -1.503000020980835,-9.633999824523926 -1.8279999494552612,-9.633999824523926 C-1.8279999494552612,-9.633999824523926 -8.788000106811523,-9.645999908447266 -8.788000106811523,-9.645999908447266 C-8.89799976348877,-9.647000312805176 -8.986000061035156,-9.616999626159668 -9.04699993133545,-9.5649995803833 C-9.04699993133545,-9.5649995803833 -13.031999588012695,-6.215000152587891 -13.031999588012695,-6.215000152587891 C-12.970999717712402,-6.267000198364258 -12.883999824523926,-6.296999931335449 -12.77400016784668,-6.296000003814697 C-12.77400016784668,-6.296000003814697 -5.811999797821045,-6.284999847412109 -5.811999797821045,-6.284999847412109 C-5.486000061035156,-6.284999847412109 -5.079999923706055,-6.021999835968018 -4.914000034332275,-5.701000213623047 C-4.914000034332275,-5.701000213623047 -4.4770002365112305,-4.866000175476074 -4.4770002365112305,-4.866000175476074 C-4.309000015258789,-4.546000003814697 -3.9049999713897705,-4.2820000648498535 -3.5789999961853027,-4.2820000648498535 C-3.5789999961853027,-4.2820000648498535 -0.6919999718666077,-4.2769999504089355 -0.6919999718666077,-4.2769999504089355 C-0.3659999966621399,-4.2769999504089355 0.039000000804662704,-4.013999938964844 0.20399999618530273,-3.696000099182129 C0.20399999618530273,-3.696000099182129 0.6420000195503235,-2.859999895095825 0.6420000195503235,-2.859999895095825 C0.8090000152587891,-2.5399999618530273 1.2120000123977661,-2.2780001163482666 1.5410000085830688,-2.2769999504089355 C1.5410000085830688,-2.2769999504089355 2.3929998874664307,-2.2750000953674316 2.3929998874664307,-2.2750000953674316 C2.7190001010894775,-2.2750000953674316 3.122999906539917,-2.010999917984009 3.2899999618530273,-1.690999984741211 C3.2899999618530273,-1.690999984741211 4.7729997634887695,1.1440000534057617 4.7729997634887695,1.1440000534057617 C4.940999984741211,1.4639999866485596 5.3429999351501465,1.7259999513626099 5.669000148773193,1.7259999513626099 C5.669000148773193,1.7259999513626099 6.520999908447266,1.7280000448226929 6.520999908447266,1.7280000448226929 C6.8470001220703125,1.7280000448226929 7.250999927520752,1.9919999837875366 7.416999816894531,2.309999942779541 C7.416999816894531,2.309999942779541 10.993000030517578,9.145000457763672 10.993000030517578,9.145000457763672 C11.104000091552734,9.357999801635742 11.083000183105469,9.543999671936035 10.963000297546387,9.645999908447266 C10.963000297546387,9.645999908447266 13.031999588012695,7.906000137329102 13.031999588012695,7.906000137329102 C13.031999588012695,7.906000137329102 5.953000068664551,-5.629000186920166 5.953000068664551,-5.629000186920166 C5.953000068664551,-5.629000186920166 5.5269999504089355,-5.629000186920166 5.5269999504089355,-5.629000186920166 C5.201000213623047,-5.629000186920166 4.795000076293945,-5.892000198364258 4.626999855041504,-6.211999893188477 C4.626999855041504,-6.211999893188477 4.625999927520752,-6.209000110626221 4.625999927520752,-6.209000110626221z">
                                                            </path>
                                                            <path stroke-linecap="round" stroke-linejoin="round"
                                                                fill-opacity="0" stroke="rgb(46,204,255)"
                                                                stroke-opacity="1" stroke-width="0.5"
                                                                d=" M4.625999927520752,-6.209000110626221 C4.625999927520752,-6.209000110626221 4.188000202178955,-7.045000076293945 4.188000202178955,-7.045000076293945 C4.020999908447266,-7.364999771118164 3.618000030517578,-7.626999855041504 3.2920000553131104,-7.626999855041504 C3.2920000553131104,-7.626999855041504 0.40400001406669617,-7.63100004196167 0.40400001406669617,-7.63100004196167 C0.07800000160932541,-7.63100004196167 -0.32600000500679016,-7.894999980926514 -0.49300000071525574,-8.21500015258789 C-0.49300000071525574,-8.21500015258789 -0.9309999942779541,-9.050000190734863 -0.9309999942779541,-9.050000190734863 C-1.0980000495910645,-9.371000289916992 -1.503000020980835,-9.633999824523926 -1.8279999494552612,-9.633999824523926 C-1.8279999494552612,-9.633999824523926 -8.788000106811523,-9.645999908447266 -8.788000106811523,-9.645999908447266 C-8.89799976348877,-9.647000312805176 -8.986000061035156,-9.616999626159668 -9.04699993133545,-9.5649995803833 C-9.04699993133545,-9.5649995803833 -13.031999588012695,-6.215000152587891 -13.031999588012695,-6.215000152587891 C-12.970999717712402,-6.267000198364258 -12.883999824523926,-6.296999931335449 -12.77400016784668,-6.296000003814697 C-12.77400016784668,-6.296000003814697 -5.811999797821045,-6.284999847412109 -5.811999797821045,-6.284999847412109 C-5.486000061035156,-6.284999847412109 -5.079999923706055,-6.021999835968018 -4.914000034332275,-5.701000213623047 C-4.914000034332275,-5.701000213623047 -4.4770002365112305,-4.866000175476074 -4.4770002365112305,-4.866000175476074 C-4.309000015258789,-4.546000003814697 -3.9049999713897705,-4.2820000648498535 -3.5789999961853027,-4.2820000648498535 C-3.5789999961853027,-4.2820000648498535 -0.6919999718666077,-4.2769999504089355 -0.6919999718666077,-4.2769999504089355 C-0.3659999966621399,-4.2769999504089355 0.039000000804662704,-4.013999938964844 0.20399999618530273,-3.696000099182129 C0.20399999618530273,-3.696000099182129 0.6420000195503235,-2.859999895095825 0.6420000195503235,-2.859999895095825 C0.8090000152587891,-2.5399999618530273 1.2120000123977661,-2.2780001163482666 1.5410000085830688,-2.2769999504089355 C1.5410000085830688,-2.2769999504089355 2.3929998874664307,-2.2750000953674316 2.3929998874664307,-2.2750000953674316 C2.7190001010894775,-2.2750000953674316 3.122999906539917,-2.010999917984009 3.2899999618530273,-1.690999984741211 C3.2899999618530273,-1.690999984741211 4.7729997634887695,1.1440000534057617 4.7729997634887695,1.1440000534057617 C4.940999984741211,1.4639999866485596 5.3429999351501465,1.7259999513626099 5.669000148773193,1.7259999513626099 C5.669000148773193,1.7259999513626099 6.520999908447266,1.7280000448226929 6.520999908447266,1.7280000448226929 C6.8470001220703125,1.7280000448226929 7.250999927520752,1.9919999837875366 7.416999816894531,2.309999942779541 C7.416999816894531,2.309999942779541 10.993000030517578,9.145000457763672 10.993000030517578,9.145000457763672 C11.104000091552734,9.357999801635742 11.083000183105469,9.543999671936035 10.963000297546387,9.645999908447266 C10.963000297546387,9.645999908447266 13.031999588012695,7.906000137329102 13.031999588012695,7.906000137329102 C13.031999588012695,7.906000137329102 5.953000068664551,-5.629000186920166 5.953000068664551,-5.629000186920166 C5.953000068664551,-5.629000186920166 5.5269999504089355,-5.629000186920166 5.5269999504089355,-5.629000186920166 C5.201000213623047,-5.629000186920166 4.795000076293945,-5.892000198364258 4.626999855041504,-6.211999893188477 C4.626999855041504,-6.211999893188477 4.625999927520752,-6.209000110626221 4.625999927520752,-6.209000110626221z">
                                                            </path>
                                                        </g>
                                                        <g opacity="1"
                                                            transform="matrix(1,0,0,1,11.496999740600586,1.2020000219345093)">
                                                            <path fill="rgb(27,27,27)" fill-opacity="1"
                                                                d=" M0.7680000066757202,3.9519999027252197 C0.8799999952316284,4.164999961853027 0.859000027179718,4.3520002365112305 0.7390000224113464,4.453999996185303 C0.7390000224113464,4.453999996185303 2.808000087738037,2.7139999866485596 2.808000087738037,2.7139999866485596 C2.808000087738037,2.7139999866485596 -0.9419999718666077,-4.453999996185303 -0.9419999718666077,-4.453999996185303 C-0.9419999718666077,-4.453999996185303 -2.808000087738037,-2.884999990463257 -2.808000087738037,-2.884999990463257 C-2.808000087738037,-2.884999990463257 0.7689999938011169,3.9509999752044678 0.7689999938011169,3.9509999752044678 C0.7689999938011169,3.9509999752044678 0.7680000066757202,3.9519999027252197 0.7680000066757202,3.9519999027252197z">
                                                            </path>
                                                            <path stroke-linecap="round" stroke-linejoin="round"
                                                                fill-opacity="0" stroke="rgb(46,204,255)"
                                                                stroke-opacity="1" stroke-width="0.5"
                                                                d=" M0.7680000066757202,3.9519999027252197 C0.8799999952316284,4.164999961853027 0.859000027179718,4.3520002365112305 0.7390000224113464,4.453999996185303 C0.7390000224113464,4.453999996185303 2.808000087738037,2.7139999866485596 2.808000087738037,2.7139999866485596 C2.808000087738037,2.7139999866485596 -0.9419999718666077,-4.453999996185303 -0.9419999718666077,-4.453999996185303 C-0.9419999718666077,-4.453999996185303 -2.808000087738037,-2.884999990463257 -2.808000087738037,-2.884999990463257 C-2.808000087738037,-2.884999990463257 0.7689999938011169,3.9509999752044678 0.7689999938011169,3.9509999752044678 C0.7689999938011169,3.9509999752044678 0.7680000066757202,3.9519999027252197 0.7680000066757202,3.9519999027252197z">
                                                            </path>
                                                        </g>
                                                        <g opacity="1"
                                                            transform="matrix(1,0,0,1,-0.9800000190734863,-10.65999984741211)">
                                                            <path fill="rgb(27,27,27)" fill-opacity="1"
                                                                d=" M1.7630000114440918,-1.5490000247955322 C1.7630000114440918,-1.5490000247955322 1.3250000476837158,-2.384000062942505 1.3250000476837158,-2.384000062942505 C1.3250000476837158,-2.384000062942505 -2.6600000858306885,0.9649999737739563 -2.6600000858306885,0.9649999737739563 C-2.6600000858306885,0.9649999737739563 -2.2230000495910645,1.7999999523162842 -2.2230000495910645,1.7999999523162842 C-2.055000066757202,2.119999885559082 -1.6510000228881836,2.384999990463257 -1.3250000476837158,2.384999990463257 C-1.3250000476837158,2.384999990463257 2.6600000858306885,-0.9649999737739563 2.6600000858306885,-0.9649999737739563 C2.3340001106262207,-0.9649999737739563 1.9299999475479126,-1.2289999723434448 1.7630000114440918,-1.5490000247955322z">
                                                            </path>
                                                            <path stroke-linecap="round" stroke-linejoin="round"
                                                                fill-opacity="0" stroke="rgb(46,204,255)"
                                                                stroke-opacity="1" stroke-width="0.5"
                                                                d=" M1.7630000114440918,-1.5490000247955322 C1.7630000114440918,-1.5490000247955322 1.3250000476837158,-2.384000062942505 1.3250000476837158,-2.384000062942505 C1.3250000476837158,-2.384000062942505 -2.6600000858306885,0.9649999737739563 -2.6600000858306885,0.9649999737739563 C-2.6600000858306885,0.9649999737739563 -2.2230000495910645,1.7999999523162842 -2.2230000495910645,1.7999999523162842 C-2.055000066757202,2.119999885559082 -1.6510000228881836,2.384999990463257 -1.3250000476837158,2.384999990463257 C-1.3250000476837158,2.384999990463257 2.6600000858306885,-0.9649999737739563 2.6600000858306885,-0.9649999737739563 C2.3340001106262207,-0.9649999737739563 1.9299999475479126,-1.2289999723434448 1.7630000114440918,-1.5490000247955322z">
                                                            </path>
                                                        </g>
                                                        <g opacity="1"
                                                            transform="matrix(1,0,0,1,4.138000011444092,-8.652000427246094)">
                                                            <path fill="rgb(27,27,27)" fill-opacity="1"
                                                                d=" M1.7619999647140503,-1.5490000247955322 C1.7619999647140503,-1.5490000247955322 1.3240000009536743,-2.384000062942505 1.3240000009536743,-2.384000062942505 C1.3240000009536743,-2.384000062942505 -2.6610000133514404,0.9649999737739563 -2.6610000133514404,0.9649999737739563 C-2.6610000133514404,0.9649999737739563 -2.2230000495910645,1.8009999990463257 -2.2230000495910645,1.8009999990463257 C-2.055999994277954,2.121000051498413 -1.652999997138977,2.382999897003174 -1.3240000009536743,2.384000062942505 C-1.3240000009536743,2.384000062942505 2.6610000133514404,-0.9660000205039978 2.6610000133514404,-0.9660000205039978 C2.3350000381469727,-0.9660000205039978 1.9290000200271606,-1.2289999723434448 1.7619999647140503,-1.5490000247955322z">
                                                            </path>
                                                            <path stroke-linecap="round" stroke-linejoin="round"
                                                                fill-opacity="0" stroke="rgb(46,204,255)"
                                                                stroke-opacity="1" stroke-width="0.5"
                                                                d=" M1.7619999647140503,-1.5490000247955322 C1.7619999647140503,-1.5490000247955322 1.3240000009536743,-2.384000062942505 1.3240000009536743,-2.384000062942505 C1.3240000009536743,-2.384000062942505 -2.6610000133514404,0.9649999737739563 -2.6610000133514404,0.9649999737739563 C-2.6610000133514404,0.9649999737739563 -2.2230000495910645,1.8009999990463257 -2.2230000495910645,1.8009999990463257 C-2.055999994277954,2.121000051498413 -1.652999997138977,2.382999897003174 -1.3240000009536743,2.384000062942505 C-1.3240000009536743,2.384000062942505 2.6610000133514404,-0.9660000205039978 2.6610000133514404,-0.9660000205039978 C2.3350000381469727,-0.9660000205039978 1.9290000200271606,-1.2289999723434448 1.7619999647140503,-1.5490000247955322z">
                                                            </path>
                                                        </g>
                                                        <g opacity="1"
                                                            transform="matrix(1,0,0,1,-6.361999988555908,-1.2899999618530273)">
                                                            <path fill="rgb(27,27,27)" fill-opacity="1"
                                                                d=" M-1.8960000276565552,-2.7799999713897705 C-1.8960000276565552,-2.7799999713897705 -1.8949999809265137,-2.7790000438690186 -1.8949999809265137,-2.7790000438690186 C-1.8949999809265137,-2.7790000438690186 -1.0429999828338623,-2.7769999504089355 -1.0429999828338623,-2.7769999504089355 C-1.0429999828338623,-2.7769999504089355 -1.0420000553131104,-2.7769999504089355 -1.0420000553131104,-2.7769999504089355 C-0.8999999761581421,-2.7769999504089355 -0.6809999942779541,-2.6659998893737793 -0.5479999780654907,-2.484999895095825 C-0.5479999780654907,-2.484999895095825 -0.4970000088214874,-2.4040000438690186 -0.4970000088214874,-2.4040000438690186 C-0.4970000088214874,-2.4040000438690186 0.24500000476837158,-0.9850000143051147 0.24500000476837158,-0.9850000143051147 C0.24500000476837158,-0.9850000143051147 1.2890000343322754,1.0140000581741333 1.2890000343322754,1.0140000581741333 C1.2890000343322754,1.0140000581741333 2.0320000648498535,2.431999921798706 2.0320000648498535,2.431999921798706 C2.134000062942505,2.628000020980835 2.062999963760376,2.747999906539917 1.9470000267028809,2.7739999294281006 C1.9470000267028809,2.7739999294281006 1.8940000534057617,2.7799999713897705 1.8940000534057617,2.7799999713897705 C1.8940000534057617,2.7799999713897705 1.0429999828338623,2.7769999504089355 1.0429999828338623,2.7769999504089355 C1.0429999828338623,2.7769999504089355 1.0420000553131104,2.7780001163482666 1.0420000553131104,2.7780001163482666 C0.9010000228881836,2.7780001163482666 0.6809999942779541,2.6659998893737793 0.5479999780654907,2.484999895095825 C0.5479999780654907,2.484999895095825 0.4959999918937683,2.4030001163482666 0.4959999918937683,2.4030001163482666 C0.4959999918937683,2.4030001163482666 -0.2460000067949295,0.984000027179718 -0.2460000067949295,0.984000027179718 C-0.2460000067949295,0.984000027179718 -1.2920000553131104,-1.0149999856948853 -1.2920000553131104,-1.0149999856948853 C-1.2920000553131104,-1.0149999856948853 -2.0329999923706055,-2.433000087738037 -2.0329999923706055,-2.433000087738037 C-2.1480000019073486,-2.6540000438690186 -2.0409998893737793,-2.7790000438690186 -1.8960000276565552,-2.7799999713897705z">
                                                            </path>
                                                            <path stroke-linecap="butt" stroke-linejoin="miter"
                                                                fill-opacity="0" stroke-miterlimit="4"
                                                                stroke="rgb(46,204,255)" stroke-opacity="1"
                                                                stroke-width="0.5"
                                                                d=" M-1.8960000276565552,-2.7799999713897705 C-1.8960000276565552,-2.7799999713897705 -1.8949999809265137,-2.7790000438690186 -1.8949999809265137,-2.7790000438690186 C-1.8949999809265137,-2.7790000438690186 -1.0429999828338623,-2.7769999504089355 -1.0429999828338623,-2.7769999504089355 C-1.0429999828338623,-2.7769999504089355 -1.0420000553131104,-2.7769999504089355 -1.0420000553131104,-2.7769999504089355 C-0.8999999761581421,-2.7769999504089355 -0.6809999942779541,-2.6659998893737793 -0.5479999780654907,-2.484999895095825 C-0.5479999780654907,-2.484999895095825 -0.4970000088214874,-2.4040000438690186 -0.4970000088214874,-2.4040000438690186 C-0.4970000088214874,-2.4040000438690186 0.24500000476837158,-0.9850000143051147 0.24500000476837158,-0.9850000143051147 C0.24500000476837158,-0.9850000143051147 1.2890000343322754,1.0140000581741333 1.2890000343322754,1.0140000581741333 C1.2890000343322754,1.0140000581741333 2.0320000648498535,2.431999921798706 2.0320000648498535,2.431999921798706 C2.134000062942505,2.628000020980835 2.062999963760376,2.747999906539917 1.9470000267028809,2.7739999294281006 C1.9470000267028809,2.7739999294281006 1.8940000534057617,2.7799999713897705 1.8940000534057617,2.7799999713897705 C1.8940000534057617,2.7799999713897705 1.0429999828338623,2.7769999504089355 1.0429999828338623,2.7769999504089355 C1.0429999828338623,2.7769999504089355 1.0420000553131104,2.7780001163482666 1.0420000553131104,2.7780001163482666 C0.9010000228881836,2.7780001163482666 0.6809999942779541,2.6659998893737793 0.5479999780654907,2.484999895095825 C0.5479999780654907,2.484999895095825 0.4959999918937683,2.4030001163482666 0.4959999918937683,2.4030001163482666 C0.4959999918937683,2.4030001163482666 -0.2460000067949295,0.984000027179718 -0.2460000067949295,0.984000027179718 C-0.2460000067949295,0.984000027179718 -1.2920000553131104,-1.0149999856948853 -1.2920000553131104,-1.0149999856948853 C-1.2920000553131104,-1.0149999856948853 -2.0329999923706055,-2.433000087738037 -2.0329999923706055,-2.433000087738037 C-2.1480000019073486,-2.6540000438690186 -2.0409998893737793,-2.7790000438690186 -1.8960000276565552,-2.7799999713897705z">
                                                            </path>
                                                        </g>
                                                        <g opacity="1"
                                                            transform="matrix(1,0,0,1,-0.25600001215934753,-1.277999997138977)">
                                                            <path fill="rgb(27,27,27)" fill-opacity="1"
                                                                d=" M-1.8919999599456787,-2.7780001163482666 C-1.8919999599456787,-2.7780001163482666 -1.0420000553131104,-2.7780001163482666 -1.0420000553131104,-2.7780001163482666 C-1.0420000553131104,-2.7780001163482666 -1.0429999828338623,-2.7790000438690186 -1.0429999828338623,-2.7790000438690186 C-0.8970000147819519,-2.7769999504089355 -0.6800000071525574,-2.6649999618530273 -0.5490000247955322,-2.4860000610351562 C-0.5490000247955322,-2.4860000610351562 -0.4970000088214874,-2.4049999713897705 -0.4970000088214874,-2.4049999713897705 C-0.4970000088214874,-2.4049999713897705 0.24400000274181366,-0.9860000014305115 0.24400000274181366,-0.9860000014305115 C0.24400000274181366,-0.9860000014305115 1.2899999618530273,1.0130000114440918 1.2899999618530273,1.0130000114440918 C1.2899999618530273,1.0130000114440918 2.0320000648498535,2.430999994277954 2.0320000648498535,2.430999994277954 C2.0320000648498535,2.430999994277954 2.0320000648498535,2.431999921798706 2.0320000648498535,2.431999921798706 C2.134999990463257,2.628000020980835 2.062999963760376,2.746999979019165 1.9450000524520874,2.7739999294281006 C1.9450000524520874,2.7739999294281006 1.8919999599456787,2.7790000438690186 1.8919999599456787,2.7790000438690186 C1.8919999599456787,2.7790000438690186 1.0420000553131104,2.7790000438690186 1.0420000553131104,2.7790000438690186 C0.9010000228881836,2.7790000438690186 0.6800000071525574,2.6679999828338623 0.546999990940094,2.4860000610351562 C0.546999990940094,2.4860000610351562 0.4959999918937683,2.4049999713897705 0.4959999918937683,2.4049999713897705 C0.4959999918937683,2.4049999713897705 0.4950000047683716,2.4040000438690186 0.4950000047683716,2.4040000438690186 C0.4950000047683716,2.4040000438690186 -0.2460000067949295,0.9860000014305115 -0.2460000067949295,0.9860000014305115 C-0.2460000067949295,0.9860000014305115 -1.2910000085830688,-1.0130000114440918 -1.2910000085830688,-1.0130000114440918 C-1.2910000085830688,-1.0130000114440918 -1.2920000553131104,-1.0140000581741333 -1.2920000553131104,-1.0140000581741333 C-1.2920000553131104,-1.0140000581741333 -2.0329999923706055,-2.430999994277954 -2.0329999923706055,-2.430999994277954 C-2.134000062942505,-2.625999927520752 -2.063999891281128,-2.744999885559082 -1.9459999799728394,-2.7720000743865967 C-1.9459999799728394,-2.7720000743865967 -1.8919999599456787,-2.7780001163482666 -1.8919999599456787,-2.7780001163482666z">
                                                            </path>
                                                            <path stroke-linecap="butt" stroke-linejoin="miter"
                                                                fill-opacity="0" stroke-miterlimit="4"
                                                                stroke="rgb(46,204,255)" stroke-opacity="1"
                                                                stroke-width="0.5"
                                                                d=" M-1.8919999599456787,-2.7780001163482666 C-1.8919999599456787,-2.7780001163482666 -1.0420000553131104,-2.7780001163482666 -1.0420000553131104,-2.7780001163482666 C-1.0420000553131104,-2.7780001163482666 -1.0429999828338623,-2.7790000438690186 -1.0429999828338623,-2.7790000438690186 C-0.8970000147819519,-2.7769999504089355 -0.6800000071525574,-2.6649999618530273 -0.5490000247955322,-2.4860000610351562 C-0.5490000247955322,-2.4860000610351562 -0.4970000088214874,-2.4049999713897705 -0.4970000088214874,-2.4049999713897705 C-0.4970000088214874,-2.4049999713897705 0.24400000274181366,-0.9860000014305115 0.24400000274181366,-0.9860000014305115 C0.24400000274181366,-0.9860000014305115 1.2899999618530273,1.0130000114440918 1.2899999618530273,1.0130000114440918 C1.2899999618530273,1.0130000114440918 2.0320000648498535,2.430999994277954 2.0320000648498535,2.430999994277954 C2.0320000648498535,2.430999994277954 2.0320000648498535,2.431999921798706 2.0320000648498535,2.431999921798706 C2.134999990463257,2.628000020980835 2.062999963760376,2.746999979019165 1.9450000524520874,2.7739999294281006 C1.9450000524520874,2.7739999294281006 1.8919999599456787,2.7790000438690186 1.8919999599456787,2.7790000438690186 C1.8919999599456787,2.7790000438690186 1.0420000553131104,2.7790000438690186 1.0420000553131104,2.7790000438690186 C0.9010000228881836,2.7790000438690186 0.6800000071525574,2.6679999828338623 0.546999990940094,2.4860000610351562 C0.546999990940094,2.4860000610351562 0.4959999918937683,2.4049999713897705 0.4959999918937683,2.4049999713897705 C0.4959999918937683,2.4049999713897705 0.4950000047683716,2.4040000438690186 0.4950000047683716,2.4040000438690186 C0.4950000047683716,2.4040000438690186 -0.2460000067949295,0.9860000014305115 -0.2460000067949295,0.9860000014305115 C-0.2460000067949295,0.9860000014305115 -1.2910000085830688,-1.0130000114440918 -1.2910000085830688,-1.0130000114440918 C-1.2910000085830688,-1.0130000114440918 -1.2920000553131104,-1.0140000581741333 -1.2920000553131104,-1.0140000581741333 C-1.2920000553131104,-1.0140000581741333 -2.0329999923706055,-2.430999994277954 -2.0329999923706055,-2.430999994277954 C-2.134000062942505,-2.625999927520752 -2.063999891281128,-2.744999885559082 -1.9459999799728394,-2.7720000743865967 C-1.9459999799728394,-2.7720000743865967 -1.8919999599456787,-2.7780001163482666 -1.8919999599456787,-2.7780001163482666z">
                                                            </path>
                                                        </g>
                                                        <g opacity="1"
                                                            transform="matrix(1,0,0,1,-5.197000026702881,4.706999778747559)">
                                                            <path fill="rgb(27,27,27)" fill-opacity="1"
                                                                d=" M-0.9169999957084656,-0.7789999842643738 C-0.9169999957084656,-0.7789999842643738 -0.9160000085830688,-0.7789999842643738 -0.9160000085830688,-0.7789999842643738 C-0.9160000085830688,-0.7789999842643738 -0.06400000303983688,-0.7770000100135803 -0.06400000303983688,-0.7770000100135803 C-0.06400000303983688,-0.7770000100135803 -0.039000000804662704,-0.7770000100135803 -0.039000000804662704,-0.7770000100135803 C0.10199999809265137,-0.765999972820282 0.3050000071525574,-0.6579999923706055 0.4309999942779541,-0.4860000014305115 C0.4309999942779541,-0.4860000014305115 0.4830000102519989,-0.40400001406669617 0.4830000102519989,-0.40400001406669617 C0.4830000102519989,-0.40400001406669617 1.1019999980926514,0.7789999842643738 1.1019999980926514,0.7789999842643738 C1.1019999980926514,0.7789999842643738 -0.07100000232458115,0.7770000100135803 -0.07100000232458115,0.7770000100135803 C-0.07100000232458115,0.7770000100135803 -0.13600000739097595,0.7710000276565552 -0.13600000739097595,0.7710000276565552 C-0.27300000190734863,0.7440000176429749 -0.45100000500679016,0.6399999856948853 -0.5649999976158142,0.48399999737739563 C-0.5649999976158142,0.48399999737739563 -0.6169999837875366,0.4020000100135803 -0.6169999837875366,0.4020000100135803 C-0.6169999837875366,0.4020000100135803 -1.0529999732971191,-0.4320000112056732 -1.0529999732971191,-0.4320000112056732 C-1.1690000295639038,-0.656000018119812 -1.0609999895095825,-0.7789999842643738 -0.9169999957084656,-0.7789999842643738z">
                                                            </path>
                                                            <path stroke-linecap="butt" stroke-linejoin="miter"
                                                                fill-opacity="0" stroke-miterlimit="4"
                                                                stroke="rgb(46,204,255)" stroke-opacity="1"
                                                                stroke-width="0.5"
                                                                d=" M-0.9169999957084656,-0.7789999842643738 C-0.9169999957084656,-0.7789999842643738 -0.9160000085830688,-0.7789999842643738 -0.9160000085830688,-0.7789999842643738 C-0.9160000085830688,-0.7789999842643738 -0.06400000303983688,-0.7770000100135803 -0.06400000303983688,-0.7770000100135803 C-0.06400000303983688,-0.7770000100135803 -0.039000000804662704,-0.7770000100135803 -0.039000000804662704,-0.7770000100135803 C0.10199999809265137,-0.765999972820282 0.3050000071525574,-0.6579999923706055 0.4309999942779541,-0.4860000014305115 C0.4309999942779541,-0.4860000014305115 0.4830000102519989,-0.40400001406669617 0.4830000102519989,-0.40400001406669617 C0.4830000102519989,-0.40400001406669617 1.1019999980926514,0.7789999842643738 1.1019999980926514,0.7789999842643738 C1.1019999980926514,0.7789999842643738 -0.07100000232458115,0.7770000100135803 -0.07100000232458115,0.7770000100135803 C-0.07100000232458115,0.7770000100135803 -0.13600000739097595,0.7710000276565552 -0.13600000739097595,0.7710000276565552 C-0.27300000190734863,0.7440000176429749 -0.45100000500679016,0.6399999856948853 -0.5649999976158142,0.48399999737739563 C-0.5649999976158142,0.48399999737739563 -0.6169999837875366,0.4020000100135803 -0.6169999837875366,0.4020000100135803 C-0.6169999837875366,0.4020000100135803 -1.0529999732971191,-0.4320000112056732 -1.0529999732971191,-0.4320000112056732 C-1.1690000295639038,-0.656000018119812 -1.0609999895095825,-0.7789999842643738 -0.9169999957084656,-0.7789999842643738z">
                                                            </path>
                                                        </g>
                                                        <g opacity="1"
                                                            transform="matrix(1,0,0,1,0.8090000152587891,6.7179999351501465)">
                                                            <path fill="rgb(27,27,27)" fill-opacity="1"
                                                                d=" M-2.3940000534057617,-0.7829999923706055 C-2.3940000534057617,-0.7829999923706055 -0.41499999165534973,-0.7789999842643738 -0.41499999165534973,-0.7789999842643738 C-0.41499999165534973,-0.7789999842643738 -0.4099999964237213,-0.7770000100135803 -0.4099999964237213,-0.7770000100135803 C-0.4099999964237213,-0.7770000100135803 -0.3540000021457672,-0.7770000100135803 -0.3540000021457672,-0.7770000100135803 C-0.3540000021457672,-0.7770000100135803 1.680999994277954,-0.7749999761581421 1.680999994277954,-0.7749999761581421 C1.680999994277954,-0.7749999761581421 1.6799999475479126,-0.7749999761581421 1.6799999475479126,-0.7749999761581421 C1.6799999475479126,-0.7749999761581421 3.4760000705718994,-0.7710000276565552 3.4760000705718994,-0.7710000276565552 C3.4760000705718994,-0.7710000276565552 4.109000205993652,0.4390000104904175 4.109000205993652,0.4390000104904175 C4.224999904632568,0.6610000133514404 4.116000175476074,0.7860000133514404 3.9690001010894775,0.7860000133514404 C3.9690001010894775,0.7860000133514404 3.9690001010894775,0.7850000262260437 3.9690001010894775,0.7850000262260437 C3.9690001010894775,0.7850000262260437 2.5250000953674316,0.781000018119812 2.5250000953674316,0.781000018119812 C2.5250000953674316,0.781000018119812 2.5239999294281006,0.7829999923706055 2.5239999294281006,0.7829999923706055 C2.5239999294281006,0.7829999923706055 0.48899999260902405,0.7789999842643738 0.48899999260902405,0.7789999842643738 C0.48899999260902405,0.7789999842643738 0.49000000953674316,0.7789999842643738 0.49000000953674316,0.7789999842643738 C0.49000000953674316,0.7789999842643738 -1.5479999780654907,0.7749999761581421 -1.5479999780654907,0.7749999761581421 C-1.5479999780654907,0.7749999761581421 -2.993000030517578,0.7710000276565552 -2.993000030517578,0.7710000276565552 C-2.993000030517578,0.7710000276565552 -2.993000030517578,0.7710000276565552 -2.993000030517578,0.7710000276565552 C-2.993000030517578,0.7710000276565552 -3.058000087738037,0.7639999985694885 -3.058000087738037,0.7639999985694885 C-3.196000099182129,0.7379999756813049 -3.372999906539917,0.6349999904632568 -3.4860000610351562,0.47999998927116394 C-3.4860000610351562,0.47999998927116394 -3.5369999408721924,0.39800000190734863 -3.5369999408721924,0.39800000190734863 C-3.5369999408721924,0.39800000190734863 -4.1579999923706055,-0.7860000133514404 -4.1579999923706055,-0.7860000133514404 C-4.1579999923706055,-0.7860000133514404 -2.3940000534057617,-0.7829999923706055 -2.3940000534057617,-0.7829999923706055z">
                                                            </path>
                                                            <path stroke-linecap="butt" stroke-linejoin="miter"
                                                                fill-opacity="0" stroke-miterlimit="4"
                                                                stroke="rgb(46,204,255)" stroke-opacity="1"
                                                                stroke-width="0.5"
                                                                d=" M-2.3940000534057617,-0.7829999923706055 C-2.3940000534057617,-0.7829999923706055 -0.41499999165534973,-0.7789999842643738 -0.41499999165534973,-0.7789999842643738 C-0.41499999165534973,-0.7789999842643738 -0.4099999964237213,-0.7770000100135803 -0.4099999964237213,-0.7770000100135803 C-0.4099999964237213,-0.7770000100135803 -0.3540000021457672,-0.7770000100135803 -0.3540000021457672,-0.7770000100135803 C-0.3540000021457672,-0.7770000100135803 1.680999994277954,-0.7749999761581421 1.680999994277954,-0.7749999761581421 C1.680999994277954,-0.7749999761581421 1.6799999475479126,-0.7749999761581421 1.6799999475479126,-0.7749999761581421 C1.6799999475479126,-0.7749999761581421 3.4760000705718994,-0.7710000276565552 3.4760000705718994,-0.7710000276565552 C3.4760000705718994,-0.7710000276565552 4.109000205993652,0.4390000104904175 4.109000205993652,0.4390000104904175 C4.224999904632568,0.6610000133514404 4.116000175476074,0.7860000133514404 3.9690001010894775,0.7860000133514404 C3.9690001010894775,0.7860000133514404 3.9690001010894775,0.7850000262260437 3.9690001010894775,0.7850000262260437 C3.9690001010894775,0.7850000262260437 2.5250000953674316,0.781000018119812 2.5250000953674316,0.781000018119812 C2.5250000953674316,0.781000018119812 2.5239999294281006,0.7829999923706055 2.5239999294281006,0.7829999923706055 C2.5239999294281006,0.7829999923706055 0.48899999260902405,0.7789999842643738 0.48899999260902405,0.7789999842643738 C0.48899999260902405,0.7789999842643738 0.49000000953674316,0.7789999842643738 0.49000000953674316,0.7789999842643738 C0.49000000953674316,0.7789999842643738 -1.5479999780654907,0.7749999761581421 -1.5479999780654907,0.7749999761581421 C-1.5479999780654907,0.7749999761581421 -2.993000030517578,0.7710000276565552 -2.993000030517578,0.7710000276565552 C-2.993000030517578,0.7710000276565552 -2.993000030517578,0.7710000276565552 -2.993000030517578,0.7710000276565552 C-2.993000030517578,0.7710000276565552 -3.058000087738037,0.7639999985694885 -3.058000087738037,0.7639999985694885 C-3.196000099182129,0.7379999756813049 -3.372999906539917,0.6349999904632568 -3.4860000610351562,0.47999998927116394 C-3.4860000610351562,0.47999998927116394 -3.5369999408721924,0.39800000190734863 -3.5369999408721924,0.39800000190734863 C-3.5369999408721924,0.39800000190734863 -4.1579999923706055,-0.7860000133514404 -4.1579999923706055,-0.7860000133514404 C-4.1579999923706055,-0.7860000133514404 -2.3940000534057617,-0.7829999923706055 -2.3940000534057617,-0.7829999923706055z">
                                                            </path>
                                                        </g>
                                                        <g opacity="1"
                                                            transform="matrix(1,0,0,1,4.916999816894531,4.7230000495910645)">
                                                            <path fill="rgb(27,27,27)" fill-opacity="1"
                                                                d=" M-0.8500000238418579,-0.781000018119812 C-0.8500000238418579,-0.781000018119812 -0.8489999771118164,-0.7789999842643738 -0.8489999771118164,-0.7789999842643738 C-0.8489999771118164,-0.7789999842643738 -0.1770000010728836,-0.7789999842643738 -0.1770000010728836,-0.7789999842643738 C-0.1770000010728836,-0.7789999842643738 -0.17499999701976776,-0.7749999761581421 -0.17499999701976776,-0.7749999761581421 C-0.17499999701976776,-0.7749999761581421 0.004999999888241291,-0.7749999761581421 0.004999999888241291,-0.7749999761581421 C0.1469999998807907,-0.7749999761581421 0.367000013589859,-0.6629999876022339 0.5,-0.4819999933242798 C0.5,-0.4819999933242798 0.5509999990463257,-0.4020000100135803 0.5509999990463257,-0.4020000100135803 C0.5509999990463257,-0.4020000100135803 0.9860000014305115,0.4320000112056732 0.9860000014305115,0.4320000112056732 C1.1030000448226929,0.656000018119812 0.9940000176429749,0.781000018119812 0.8479999899864197,0.781000018119812 C0.8479999899864197,0.781000018119812 0.8479999899864197,0.781000018119812 0.8479999899864197,0.781000018119812 C0.8479999899864197,0.781000018119812 -0.3540000021457672,0.7770000100135803 -0.3540000021457672,0.7770000100135803 C-0.3540000021457672,0.7770000100135803 -0.9860000014305115,-0.43299999833106995 -0.9860000014305115,-0.43299999833106995 C-1.1030000448226929,-0.656000018119812 -0.9940000176429749,-0.7799999713897705 -0.8500000238418579,-0.781000018119812z">
                                                            </path>
                                                            <path stroke-linecap="butt" stroke-linejoin="miter"
                                                                fill-opacity="0" stroke-miterlimit="4"
                                                                stroke="rgb(46,204,255)" stroke-opacity="1"
                                                                stroke-width="0.5"
                                                                d=" M-0.8500000238418579,-0.781000018119812 C-0.8500000238418579,-0.781000018119812 -0.8489999771118164,-0.7789999842643738 -0.8489999771118164,-0.7789999842643738 C-0.8489999771118164,-0.7789999842643738 -0.1770000010728836,-0.7789999842643738 -0.1770000010728836,-0.7789999842643738 C-0.1770000010728836,-0.7789999842643738 -0.17499999701976776,-0.7749999761581421 -0.17499999701976776,-0.7749999761581421 C-0.17499999701976776,-0.7749999761581421 0.004999999888241291,-0.7749999761581421 0.004999999888241291,-0.7749999761581421 C0.1469999998807907,-0.7749999761581421 0.367000013589859,-0.6629999876022339 0.5,-0.4819999933242798 C0.5,-0.4819999933242798 0.5509999990463257,-0.4020000100135803 0.5509999990463257,-0.4020000100135803 C0.5509999990463257,-0.4020000100135803 0.9860000014305115,0.4320000112056732 0.9860000014305115,0.4320000112056732 C1.1030000448226929,0.656000018119812 0.9940000176429749,0.781000018119812 0.8479999899864197,0.781000018119812 C0.8479999899864197,0.781000018119812 0.8479999899864197,0.781000018119812 0.8479999899864197,0.781000018119812 C0.8479999899864197,0.781000018119812 -0.3540000021457672,0.7770000100135803 -0.3540000021457672,0.7770000100135803 C-0.3540000021457672,0.7770000100135803 -0.9860000014305115,-0.43299999833106995 -0.9860000014305115,-0.43299999833106995 C-1.1030000448226929,-0.656000018119812 -0.9940000176429749,-0.7799999713897705 -0.8500000238418579,-0.781000018119812z">
                                                            </path>
                                                        </g>
                                                    </g>
                                                </g>
                                            </g>
                                        </g>
                                        <g mask="url(#__lottie_element_443_1)" style="display: block;">
                                            <g id="2955" transform="matrix(1,0,0,1,806.5077514648438,445.9490051269531)"
                                                opacity="1">
                                                <g opacity="1" transform="matrix(1,0,0,1,0,0)">
                                                    <path stroke-linecap="round" stroke-linejoin="round"
                                                        fill-opacity="0" stroke="rgb(0,0,255)" stroke-opacity="1"
                                                        stroke-width="1"
                                                        d=" M200.78900146484375,233.4969940185547 C200.78900146484375,233.4969940185547 -197.25900268554688,88.625 -197.25900268554688,88.625 C-199.74400329589844,87.71700286865234 -201.2689971923828,84.88099670410156 -200.6510009765625,82.32099914550781 C-200.6510009765625,82.32099914550781 -125.51399993896484,-233.4969940185547 -125.51399993896484,-233.4969940185547">
                                                    </path>
                                                </g>
                                            </g>
                                        </g>
                                        <g mask="url(#__lottie_element_443_1)" style="display: block;">
                                            <g id="2956" transform="matrix(1,0,0,1,645.2577514648438,475.9490051269531)"
                                                opacity="1">
                                                <g opacity="1" transform="matrix(1,0,0,1,0,0)">
                                                    <path stroke-linecap="round" stroke-linejoin="round"
                                                        fill-opacity="0" stroke="rgb(0,0,255)" stroke-opacity="1"
                                                        stroke-width="1"
                                                        d=" M200.78900146484375,233.4969940185547 C200.78900146484375,233.4969940185547 -197.25900268554688,88.625 -197.25900268554688,88.625 C-199.74400329589844,87.71700286865234 -201.2689971923828,84.88099670410156 -200.6510009765625,82.32099914550781 C-200.6510009765625,82.32099914550781 -125.51399993896484,-233.4969940185547 -125.51399993896484,-233.4969940185547">
                                                    </path>
                                                </g>
                                            </g>
                                        </g>
                                        <g mask="url(#__lottie_element_443_1)" style="display: block;">
                                            <g id="2958" transform="matrix(1,0,0,1,967.7577514648438,415.9490051269531)"
                                                opacity="1">
                                                <g opacity="1" transform="matrix(1,0,0,1,0,0)">
                                                    <path stroke-linecap="round" stroke-linejoin="round"
                                                        fill-opacity="0" stroke="rgb(0,0,255)" stroke-opacity="1"
                                                        stroke-width="1"
                                                        d=" M200.78900146484375,233.4969940185547 C200.78900146484375,233.4969940185547 -197.25900268554688,88.625 -197.25900268554688,88.625 C-199.74400329589844,87.71700286865234 -201.2689971923828,84.88099670410156 -200.6510009765625,82.32099914550781 C-200.6510009765625,82.32099914550781 -125.51399993896484,-233.4969940185547 -125.51399993896484,-233.4969940185547">
                                                    </path>
                                                </g>
                                            </g>
                                        </g>
                                        <g id="2971" transform="matrix(1,0,0,1,667.4849853515625,475.1239929199219)"
                                            opacity="1" style="display: none;">
                                            <g opacity="1" transform="matrix(1,0,0,1,0,0)">
                                                <path fill="rgb(255,255,255)" fill-opacity="1"
                                                    d=" M145.79400634765625,-46.94300079345703 C145.79400634765625,-46.94300079345703 102.6989974975586,134.20199584960938 102.6989974975586,134.20199584960938 C100.90399932861328,141.74600219726562 92.93299865722656,146.0399932861328 85.64600372314453,143.38800048828125 C85.64600372314453,143.38800048828125 -137.61300659179688,62.13100051879883 -137.61300659179688,62.13100051879883 C-143.8000030517578,59.87900161743164 -147.3179931640625,53.347999572753906 -145.79400634765625,46.94200134277344 C-145.79400634765625,46.94200134277344 -102.697998046875,-134.20199584960938 -102.697998046875,-134.20199584960938 C-100.90299987792969,-141.74600219726562 -92.93199920654297,-146.0399932861328 -85.6449966430664,-143.38800048828125 C-85.6449966430664,-143.38800048828125 137.61300659179688,-62.13199996948242 137.61300659179688,-62.13199996948242 C143.8000030517578,-59.880001068115234 147.3179931640625,-53.3489990234375 145.79400634765625,-46.94300079345703z">
                                                </path>
                                            </g>
                                            <g opacity="1" transform="matrix(1,0,0,1,0,0)">
                                                <g opacity="1"
                                                    transform="matrix(1,0,0,1,20.26099967956543,-10.78499984741211)">
                                                    <path fill="rgb(27,27,27)" fill-opacity="1"
                                                        d=" M-9.904999732971191,-31.863000869750977 C-9.904999732971191,-31.863000869750977 55.654998779296875,-8.185999870300293 55.654998779296875,-8.185999870300293 C57.30699920654297,-7.5879998207092285 58.2760009765625,-6.660999774932861 58.5099983215332,-5.642000198364258 C58.9119987487793,-3.8959999084472656 57.95399856567383,-2.7249999046325684 56.49399948120117,-1.4270000457763672 C56.49399948120117,-1.4270000457763672 9.843000411987305,31.865999221801758 9.843000411987305,31.865999221801758 C9.843000411987305,31.865999221801758 -58.60200119018555,7.835999965667725 -58.60200119018555,7.835999965667725 C-58.60200119018555,7.835999965667725 -9.902999877929688,-31.865999221801758 -9.902999877929688,-31.865999221801758 C-9.902999877929688,-31.865999221801758 -9.904999732971191,-31.863000869750977 -9.904999732971191,-31.863000869750977z">
                                                    </path>
                                                    <path stroke-linecap="round" stroke-linejoin="round"
                                                        fill-opacity="0" stroke="rgb(4,0,255)" stroke-opacity="1"
                                                        stroke-width="0.5"
                                                        d=" M-9.904999732971191,-31.863000869750977 C-9.904999732971191,-31.863000869750977 55.654998779296875,-8.185999870300293 55.654998779296875,-8.185999870300293 C57.30699920654297,-7.5879998207092285 58.2760009765625,-6.660999774932861 58.5099983215332,-5.642000198364258 C58.9119987487793,-3.8959999084472656 57.95399856567383,-2.7249999046325684 56.49399948120117,-1.4270000457763672 C56.49399948120117,-1.4270000457763672 9.843000411987305,31.865999221801758 9.843000411987305,31.865999221801758 C9.843000411987305,31.865999221801758 -58.60200119018555,7.835999965667725 -58.60200119018555,7.835999965667725 C-58.60200119018555,7.835999965667725 -9.902999877929688,-31.865999221801758 -9.902999877929688,-31.865999221801758 C-9.902999877929688,-31.865999221801758 -9.904999732971191,-31.863000869750977 -9.904999732971191,-31.863000869750977z">
                                                    </path>
                                                </g>
                                                <g opacity="1" transform="matrix(1,0,0,1,0,0)">
                                                    <g opacity="1"
                                                        transform="matrix(1,0,0,1,45.50400161743164,-1.600000023841858)">
                                                        <path fill="url(#__lottie_element_426)" fill-opacity="1"
                                                            d=" M-26.3439998626709,18.839000701904297 C-26.3439998626709,18.839000701904297 26.3439998626709,-18.839000701904297 26.3439998626709,-18.839000701904297">
                                                        </path>
                                                        <path stroke-linecap="round" stroke-linejoin="round"
                                                            fill-opacity="0" stroke="rgb(4,0,255)" stroke-opacity="1"
                                                            stroke-width="0.5"
                                                            d=" M-26.3439998626709,18.839000701904297 C-26.3439998626709,18.839000701904297 26.3439998626709,-18.839000701904297 26.3439998626709,-18.839000701904297">
                                                        </path>
                                                    </g>
                                                    <g opacity="1"
                                                        transform="matrix(1,0,0,1,34.39799880981445,-5.593999862670898)">
                                                        <path fill="url(#__lottie_element_427)" fill-opacity="1"
                                                            d=" M-26.3439998626709,18.839000701904297 C-26.3439998626709,18.839000701904297 26.3439998626709,-18.839000701904297 26.3439998626709,-18.839000701904297">
                                                        </path>
                                                        <path stroke-linecap="round" stroke-linejoin="round"
                                                            fill-opacity="0" stroke="rgb(4,0,255)" stroke-opacity="1"
                                                            stroke-width="0.5"
                                                            d=" M-26.3439998626709,18.839000701904297 C-26.3439998626709,18.839000701904297 26.3439998626709,-18.839000701904297 26.3439998626709,-18.839000701904297">
                                                        </path>
                                                    </g>
                                                    <g opacity="1"
                                                        transform="matrix(1,0,0,1,23.29199981689453,-9.586999893188477)">
                                                        <path fill="url(#__lottie_element_428)" fill-opacity="1"
                                                            d=" M-26.3439998626709,18.839000701904297 C-26.3439998626709,18.839000701904297 26.3439998626709,-18.839000701904297 26.3439998626709,-18.839000701904297">
                                                        </path>
                                                        <path stroke-linecap="round" stroke-linejoin="round"
                                                            fill-opacity="0" stroke="rgb(4,0,255)" stroke-opacity="1"
                                                            stroke-width="0.5"
                                                            d=" M-26.3439998626709,18.839000701904297 C-26.3439998626709,18.839000701904297 26.3439998626709,-18.839000701904297 26.3439998626709,-18.839000701904297">
                                                        </path>
                                                    </g>
                                                    <g opacity="1"
                                                        transform="matrix(1,0,0,1,12.185999870300293,-13.581000328063965)">
                                                        <path fill="url(#__lottie_element_429)" fill-opacity="1"
                                                            d=" M-26.3439998626709,18.839000701904297 C-26.3439998626709,18.839000701904297 26.3439998626709,-18.839000701904297 26.3439998626709,-18.839000701904297">
                                                        </path>
                                                        <path stroke-linecap="round" stroke-linejoin="round"
                                                            fill-opacity="0" stroke="rgb(4,0,255)" stroke-opacity="1"
                                                            stroke-width="0.5"
                                                            d=" M-26.3439998626709,18.839000701904297 C-26.3439998626709,18.839000701904297 26.3439998626709,-18.839000701904297 26.3439998626709,-18.839000701904297">
                                                        </path>
                                                    </g>
                                                    <g opacity="1"
                                                        transform="matrix(1,0,0,1,1.0800000429153442,-17.573999404907227)">
                                                        <path fill="url(#__lottie_element_430)" fill-opacity="1"
                                                            d=" M-26.3439998626709,18.839000701904297 C-26.3439998626709,18.839000701904297 26.3439998626709,-18.839000701904297 26.3439998626709,-18.839000701904297">
                                                        </path>
                                                        <path stroke-linecap="round" stroke-linejoin="round"
                                                            fill-opacity="0" stroke="rgb(4,0,255)" stroke-opacity="1"
                                                            stroke-width="0.5"
                                                            d=" M-26.3439998626709,18.839000701904297 C-26.3439998626709,18.839000701904297 26.3439998626709,-18.839000701904297 26.3439998626709,-18.839000701904297">
                                                        </path>
                                                    </g>
                                                    <g opacity="1"
                                                        transform="matrix(1,0,0,1,-10.027000427246094,-21.56800079345703)">
                                                        <path fill="url(#__lottie_element_431)" fill-opacity="1"
                                                            d=" M-26.3439998626709,18.839000701904297 C-26.3439998626709,18.839000701904297 26.3439998626709,-18.839000701904297 26.3439998626709,-18.839000701904297">
                                                        </path>
                                                        <path stroke-linecap="round" stroke-linejoin="round"
                                                            fill-opacity="0" stroke="rgb(4,0,255)" stroke-opacity="1"
                                                            stroke-width="0.5"
                                                            d=" M-26.3439998626709,18.839000701904297 C-26.3439998626709,18.839000701904297 26.3439998626709,-18.839000701904297 26.3439998626709,-18.839000701904297">
                                                        </path>
                                                    </g>
                                                    <g opacity="1"
                                                        transform="matrix(1,0,0,1,36.26300048828125,-24.57900047302246)">
                                                        <path fill="url(#__lottie_element_432)" fill-opacity="1"
                                                            d=" M-37.505001068115234,-13.746000289916992 C-37.505001068115234,-13.746000289916992 37.505001068115234,13.746000289916992 37.505001068115234,13.746000289916992">
                                                        </path>
                                                        <path stroke-linecap="round" stroke-linejoin="round"
                                                            fill-opacity="0" stroke="rgb(4,0,255)" stroke-opacity="1"
                                                            stroke-width="0.5"
                                                            d=" M-37.505001068115234,-13.746000289916992 C-37.505001068115234,-13.746000289916992 37.505001068115234,13.746000289916992 37.505001068115234,13.746000289916992">
                                                        </path>
                                                    </g>
                                                    <g opacity="1"
                                                        transform="matrix(1,0,0,1,27.615999221801758,-18.409000396728516)">
                                                        <path fill="url(#__lottie_element_433)" fill-opacity="1"
                                                            d=" M-37.49300003051758,-13.741999626159668 C-37.49300003051758,-13.741999626159668 37.49300003051758,13.741999626159668 37.49300003051758,13.741999626159668">
                                                        </path>
                                                        <path stroke-linecap="round" stroke-linejoin="round"
                                                            fill-opacity="0" stroke="rgb(4,0,255)" stroke-opacity="1"
                                                            stroke-width="0.5"
                                                            d=" M-37.49300003051758,-13.741999626159668 C-37.49300003051758,-13.741999626159668 37.49300003051758,13.741999626159668 37.49300003051758,13.741999626159668">
                                                        </path>
                                                    </g>
                                                    <g opacity="1"
                                                        transform="matrix(1,0,0,1,18.992000579833984,-12.232000350952148)">
                                                        <path fill="url(#__lottie_element_434)" fill-opacity="1"
                                                            d=" M-37.50199890136719,-13.744999885559082 C-37.50199890136719,-13.744999885559082 37.50199890136719,13.744999885559082 37.50199890136719,13.744999885559082">
                                                        </path>
                                                        <path stroke-linecap="round" stroke-linejoin="round"
                                                            fill-opacity="0" stroke="rgb(4,0,255)" stroke-opacity="1"
                                                            stroke-width="0.5"
                                                            d=" M-37.50199890136719,-13.744999885559082 C-37.50199890136719,-13.744999885559082 37.50199890136719,13.744999885559082 37.50199890136719,13.744999885559082">
                                                        </path>
                                                    </g>
                                                    <g opacity="1"
                                                        transform="matrix(1,0,0,1,10.32800006866455,-6.065999984741211)">
                                                        <path fill="url(#__lottie_element_435)" fill-opacity="1"
                                                            d=" M-37.47700119018555,-13.736000061035156 C-37.47700119018555,-13.736000061035156 37.47700119018555,13.736000061035156 37.47700119018555,13.736000061035156">
                                                        </path>
                                                        <path stroke-linecap="round" stroke-linejoin="round"
                                                            fill-opacity="0" stroke="rgb(4,0,255)" stroke-opacity="1"
                                                            stroke-width="0.5"
                                                            d=" M-37.47700119018555,-13.736000061035156 C-37.47700119018555,-13.736000061035156 37.47700119018555,13.736000061035156 37.47700119018555,13.736000061035156">
                                                        </path>
                                                    </g>
                                                    <g opacity="1"
                                                        transform="matrix(1,0,0,1,1.7039999961853027,0.1120000034570694)">
                                                        <path fill="url(#__lottie_element_436)" fill-opacity="1"
                                                            d=" M-37.48699951171875,-13.739999771118164 C-37.48699951171875,-13.739999771118164 37.48699951171875,13.739999771118164 37.48699951171875,13.739999771118164">
                                                        </path>
                                                        <path stroke-linecap="round" stroke-linejoin="round"
                                                            fill-opacity="0" stroke="rgb(4,0,255)" stroke-opacity="1"
                                                            stroke-width="0.5"
                                                            d=" M-37.48699951171875,-13.739999771118164 C-37.48699951171875,-13.739999771118164 37.48699951171875,13.739999771118164 37.48699951171875,13.739999771118164">
                                                        </path>
                                                    </g>
                                                </g>
                                                <g opacity="1"
                                                    transform="matrix(1,0,0,1,43.82099914550781,-12.456000328063965)">
                                                    <path fill="rgb(4,0,255)" fill-opacity="1"
                                                        d=" M6.271999835968018,2.2850000858306885 C1.190000057220459,0.40299999713897705 -0.9639999866485596,0.8539999723434448 -3.374000072479248,2.5360000133514404 C-0.9679999947547913,0.8519999980926514 -1.3300000429153442,-0.453000009059906 -6.271999835968018,-2.312999963760376 C-1.3300000429153442,-0.453000009059906 1.6369999647140503,-0.6990000009536743 3.7179999351501465,-2.5360000133514404 C1.3799999952316284,-0.7950000166893005 1.190000057220459,0.4020000100135803 6.271999835968018,2.2850000858306885 C6.271999835968018,2.2850000858306885 6.271999835968018,2.2850000858306885 6.271999835968018,2.2850000858306885z">
                                                    </path>
                                                    <path stroke-linecap="round" stroke-linejoin="round"
                                                        fill-opacity="0" stroke="rgb(4,0,255)" stroke-opacity="1"
                                                        stroke-width="0.5"
                                                        d=" M6.271999835968018,2.2850000858306885 C1.190000057220459,0.40299999713897705 -0.9639999866485596,0.8539999723434448 -3.374000072479248,2.5360000133514404 C-0.9679999947547913,0.8519999980926514 -1.3300000429153442,-0.453000009059906 -6.271999835968018,-2.312999963760376 C-1.3300000429153442,-0.453000009059906 1.6369999647140503,-0.6990000009536743 3.7179999351501465,-2.5360000133514404 C1.3799999952316284,-0.7950000166893005 1.190000057220459,0.4020000100135803 6.271999835968018,2.2850000858306885 C6.271999835968018,2.2850000858306885 6.271999835968018,2.2850000858306885 6.271999835968018,2.2850000858306885z">
                                                    </path>
                                                </g>
                                                <g opacity="1"
                                                    transform="matrix(1,0,0,1,-14.446999549865723,-31.85700035095215)">
                                                    <path fill="rgb(45,158,255)" fill-opacity="1"
                                                        d=" M-39.659000396728516,-49.79399871826172 C-39.659000396728516,-49.79399871826172 19.781999588012695,-28.327999114990234 19.781999588012695,-28.327999114990234 C23.148000717163086,-27.113000869750977 26.56999969482422,-23.207000732421875 27.386999130249023,-19.652999877929688 C27.386999130249023,-19.652999877929688 38.097999572753906,26.940000534057617 38.097999572753906,26.940000534057617 C38.46799850463867,28.548999786376953 39.231998443603516,30.06800079345703 40.316001892089844,31.344999313354492 C40.316001892089844,31.344999313354492 42.80699920654297,34.28499984741211 42.80699920654297,34.28499984741211 C43.89099884033203,35.5620002746582 44.654998779296875,37.08100128173828 45.025001525878906,38.689998626708984 C45.025001525878906,38.689998626708984 46.43199920654297,44.8120002746582 46.43199920654297,44.8120002746582 C46.43199920654297,44.8120002746582 43.57500076293945,50.16400146484375 43.57500076293945,50.16400146484375 C43.57500076293945,50.16400146484375 -26.38599967956543,24.868000030517578 -26.38599967956543,24.868000030517578 C-27.554000854492188,24.339000701904297 -28.482999801635742,23.118999481201172 -28.891000747680664,21.341999053955078 C-28.891000747680664,21.341999053955078 -44.10499954223633,-44.75600051879883 -44.10499954223633,-44.75600051879883 C-44.10499954223633,-44.75600051879883 -46.43199920654297,-47.375999450683594 -46.43199920654297,-47.375999450683594 C-46.43199920654297,-47.375999450683594 -43.32600021362305,-49.638999938964844 -43.32600021362305,-49.638999938964844 C-43.32600021362305,-49.638999938964844 -43.32400131225586,-49.63199996948242 -43.32400131225586,-49.63199996948242 C-42.47200012207031,-50.249000549316406 -41.20399856567383,-50.36000061035156 -39.65700149536133,-49.80099868774414 C-39.65700149536133,-49.80099868774414 -39.659000396728516,-49.79399871826172 -39.659000396728516,-49.79399871826172z">
                                                    </path>
                                                    <path stroke-linecap="round" stroke-linejoin="round"
                                                        fill-opacity="0" stroke="rgb(4,0,255)" stroke-opacity="1"
                                                        stroke-width="0.5"
                                                        d=" M-39.659000396728516,-49.79399871826172 C-39.659000396728516,-49.79399871826172 19.781999588012695,-28.327999114990234 19.781999588012695,-28.327999114990234 C23.148000717163086,-27.113000869750977 26.56999969482422,-23.207000732421875 27.386999130249023,-19.652999877929688 C27.386999130249023,-19.652999877929688 38.097999572753906,26.940000534057617 38.097999572753906,26.940000534057617 C38.46799850463867,28.548999786376953 39.231998443603516,30.06800079345703 40.316001892089844,31.344999313354492 C40.316001892089844,31.344999313354492 42.80699920654297,34.28499984741211 42.80699920654297,34.28499984741211 C43.89099884033203,35.5620002746582 44.654998779296875,37.08100128173828 45.025001525878906,38.689998626708984 C45.025001525878906,38.689998626708984 46.43199920654297,44.8120002746582 46.43199920654297,44.8120002746582 C46.43199920654297,44.8120002746582 43.57500076293945,50.16400146484375 43.57500076293945,50.16400146484375 C43.57500076293945,50.16400146484375 -26.38599967956543,24.868000030517578 -26.38599967956543,24.868000030517578 C-27.554000854492188,24.339000701904297 -28.482999801635742,23.118999481201172 -28.891000747680664,21.341999053955078 C-28.891000747680664,21.341999053955078 -44.10499954223633,-44.75600051879883 -44.10499954223633,-44.75600051879883 C-44.10499954223633,-44.75600051879883 -46.43199920654297,-47.375999450683594 -46.43199920654297,-47.375999450683594 C-46.43199920654297,-47.375999450683594 -43.32600021362305,-49.638999938964844 -43.32600021362305,-49.638999938964844 C-43.32600021362305,-49.638999938964844 -43.32400131225586,-49.63199996948242 -43.32400131225586,-49.63199996948242 C-42.47200012207031,-50.249000549316406 -41.20399856567383,-50.36000061035156 -39.65700149536133,-49.80099868774414 C-39.65700149536133,-49.80099868774414 -39.659000396728516,-49.79399871826172 -39.659000396728516,-49.79399871826172z">
                                                    </path>
                                                </g>
                                                <g opacity="1"
                                                    transform="matrix(1,0,0,1,11.980999946594238,-47.78799819946289)">
                                                    <path stroke-linecap="butt" stroke-linejoin="miter" fill-opacity="0"
                                                        stroke-miterlimit="10" stroke="rgb(4,0,255)" stroke-opacity="1"
                                                        stroke-width="0.5"
                                                        d=" M-1.5529999732971191,1.13100004196167 C-1.5529999732971191,1.13100004196167 1.5529999732971191,-1.13100004196167 1.5529999732971191,-1.13100004196167">
                                                    </path>
                                                </g>
                                                <g opacity="1"
                                                    transform="matrix(1,0,0,1,-16.944000244140625,-28.915000915527344)">
                                                    <path fill="url(#__lottie_element_437)" fill-opacity="1"
                                                        d=" M19.167999267578125,-29.0049991607666 C22.53499984741211,-27.790000915527344 25.957000732421875,-23.884000778198242 26.77400016784668,-20.329999923706055 C26.77400016784668,-20.329999923706055 42.31800079345703,47.202999114990234 42.31800079345703,47.202999114990234 C42.75699996948242,49.111000061035156 43.79399871826172,50.374000549316406 45.082000732421875,50.83599853515625 C45.082000732421875,50.83599853515625 -26.854999542236328,24.84600067138672 -26.854999542236328,24.84600067138672 C-28.023000717163086,24.316999435424805 -28.95199966430664,23.097000122070312 -29.360000610351562,21.31999969482422 C-29.360000610351562,21.31999969482422 -44.904998779296875,-46.2130012512207 -44.904998779296875,-46.2130012512207 C-45.72200012207031,-49.770999908447266 -43.63800048828125,-51.68600082397461 -40.275001525878906,-50.470001220703125 C-40.275001525878906,-50.470001220703125 19.165000915527344,-29.0049991607666 19.165000915527344,-29.0049991607666 C19.165000915527344,-29.0049991607666 19.167999267578125,-29.0049991607666 19.167999267578125,-29.0049991607666z">
                                                    </path>
                                                    <path stroke-linecap="round" stroke-linejoin="round"
                                                        fill-opacity="0" stroke="rgb(4,0,255)" stroke-opacity="1"
                                                        stroke-width="0.5"
                                                        d=" M19.167999267578125,-29.0049991607666 C22.53499984741211,-27.790000915527344 25.957000732421875,-23.884000778198242 26.77400016784668,-20.329999923706055 C26.77400016784668,-20.329999923706055 42.31800079345703,47.202999114990234 42.31800079345703,47.202999114990234 C42.75699996948242,49.111000061035156 43.79399871826172,50.374000549316406 45.082000732421875,50.83599853515625 C45.082000732421875,50.83599853515625 -26.854999542236328,24.84600067138672 -26.854999542236328,24.84600067138672 C-28.023000717163086,24.316999435424805 -28.95199966430664,23.097000122070312 -29.360000610351562,21.31999969482422 C-29.360000610351562,21.31999969482422 -44.904998779296875,-46.2130012512207 -44.904998779296875,-46.2130012512207 C-45.72200012207031,-49.770999908447266 -43.63800048828125,-51.68600082397461 -40.275001525878906,-50.470001220703125 C-40.275001525878906,-50.470001220703125 19.165000915527344,-29.0049991607666 19.165000915527344,-29.0049991607666 C19.165000915527344,-29.0049991607666 19.167999267578125,-29.0049991607666 19.167999267578125,-29.0049991607666z">
                                                    </path>
                                                </g>
                                                <g opacity="1"
                                                    transform="matrix(1,0,0,1,4.776000022888184,-21.06100082397461)">
                                                    <path stroke-linecap="round" stroke-linejoin="round"
                                                        fill-opacity="0" stroke="rgb(4,0,255)" stroke-opacity="1"
                                                        stroke-width="0.5"
                                                        d=" M-17.599000930786133,-38.66600036621094 C-17.599000930786133,-38.66600036621094 -2.7190001010894775,-33.29499816894531 -2.7190001010894775,-33.29499816894531 C-0.6050000190734863,-32.53300094604492 1.6440000534057617,-30.39699935913086 2.1480000019073486,-28.201000213623047 C2.1480000019073486,-28.201000213623047 17.599000930786133,38.66600036621094 17.599000930786133,38.66600036621094">
                                                    </path>
                                                </g>
                                                <g opacity="1"
                                                    transform="matrix(1,0,0,1,-50.73899841308594,-40.71699905395508)">
                                                    <path stroke-linecap="round" stroke-linejoin="round"
                                                        fill-opacity="0" stroke="rgb(4,0,255)" stroke-opacity="1"
                                                        stroke-width="0.5"
                                                        d=" M7.665999889373779,34.81700134277344 C7.665999889373779,34.81700134277344 -7.747000217437744,-32.20500183105469 -7.747000217437744,-32.20500183105469 C-8.260000228881836,-34.435001373291016 -7.057000160217285,-35.24300003051758 -5.288000106811523,-34.606998443603516 C-5.288000106811523,-34.606998443603516 7.866000175476074,-29.857999801635742 7.866000175476074,-29.857999801635742">
                                                    </path>
                                                </g>
                                                <g opacity="1"
                                                    transform="matrix(1,0,0,1,30.000999450683594,14.854000091552734)">
                                                    <path fill="rgb(72,255,144)" fill-opacity="1"
                                                        d=" M0.875,-3.4619998931884766 C-0.1770000010728836,-3.8410000801086426 -1.4249999523162842,-2.5999999046325684 -1.9079999923706055,-0.6890000104904175 C-2.390000104904175,1.2209999561309814 -1.9299999475479126,3.078000068664551 -0.875,3.4609999656677246 C0.1809999942779541,3.8440001010894775 1.4259999990463257,2.5989999771118164 1.9079999923706055,0.6880000233650208 C2.1419999599456787,-0.23899999260902405 2.1530001163482666,-1.1519999504089355 1.9819999933242798,-1.8940000534057617 C1.8020000457763672,-2.677999973297119 1.4170000553131104,-3.2660000324249268 0.875,-3.4619998931884766z">
                                                    </path>
                                                    <path stroke-linecap="round" stroke-linejoin="round"
                                                        fill-opacity="0" stroke="rgb(4,0,255)" stroke-opacity="1"
                                                        stroke-width="0.5"
                                                        d=" M0.875,-3.4619998931884766 C-0.1770000010728836,-3.8410000801086426 -1.4249999523162842,-2.5999999046325684 -1.9079999923706055,-0.6890000104904175 C-2.390000104904175,1.2209999561309814 -1.9299999475479126,3.078000068664551 -0.875,3.4609999656677246 C0.1809999942779541,3.8440001010894775 1.4259999990463257,2.5989999771118164 1.9079999923706055,0.6880000233650208 C2.1419999599456787,-0.23899999260902405 2.1530001163482666,-1.1519999504089355 1.9819999933242798,-1.8940000534057617 C1.8020000457763672,-2.677999973297119 1.4170000553131104,-3.2660000324249268 0.875,-3.4619998931884766z">
                                                    </path>
                                                </g>
                                                <g opacity="1"
                                                    transform="matrix(1,0,0,1,30.00200080871582,14.852999687194824)">
                                                    <path fill="rgb(27,27,27)" fill-opacity="1"
                                                        d=" M0.7200000286102295,-0.8489999771118164 C0.6439999938011169,-1.1829999685287476 0.49799999594688416,-1.3550000190734863 0.3529999852180481,-1.406000018119812 C0.3529999852180481,-1.406000018119812 0.3529999852180481,-1.4079999923706055 0.3529999852180481,-1.4079999923706055 C0.2150000035762787,-1.4570000171661377 0.020999999716877937,-1.4129999876022339 -0.1899999976158142,-1.2020000219345093 C-0.3700000047683716,-1.0240000486373901 -0.5350000262260437,-0.7459999918937683 -0.6430000066757202,-0.4009999930858612 C-0.6430000066757202,-0.4009999930858612 -0.6869999766349792,-0.24899999797344208 -0.6869999766349792,-0.24899999797344208 C-0.7919999957084656,0.16699999570846558 -0.7900000214576721,0.5680000185966492 -0.7149999737739563,0.875 C-0.6460000276565552,1.1510000228881836 -0.5289999842643738,1.312999963760376 -0.40799999237060547,1.3830000162124634 C-0.40799999237060547,1.3830000162124634 -0.35499998927116394,1.406999945640564 -0.35499998927116394,1.406999945640564 C-0.2160000056028366,1.4570000171661377 -0.02199999988079071,1.4129999876022339 0.1889999955892563,1.2020000219345093 C0.36899998784065247,1.0230000019073486 0.5339999794960022,0.7459999918937683 0.6430000066757202,0.4009999930858612 C0.6430000066757202,0.4009999930858612 0.6869999766349792,0.24799999594688416 0.6869999766349792,0.24799999594688416 C0.7889999747276306,-0.15299999713897705 0.7910000085830688,-0.5429999828338623 0.7200000286102295,-0.8489999771118164z">
                                                    </path>
                                                    <path stroke-linecap="butt" stroke-linejoin="miter" fill-opacity="0"
                                                        stroke-miterlimit="4" stroke="rgb(4,0,255)" stroke-opacity="1"
                                                        stroke-width="0.5"
                                                        d=" M0.7200000286102295,-0.8489999771118164 C0.6439999938011169,-1.1829999685287476 0.49799999594688416,-1.3550000190734863 0.3529999852180481,-1.406000018119812 C0.3529999852180481,-1.406000018119812 0.3529999852180481,-1.4079999923706055 0.3529999852180481,-1.4079999923706055 C0.2150000035762787,-1.4570000171661377 0.020999999716877937,-1.4129999876022339 -0.1899999976158142,-1.2020000219345093 C-0.3700000047683716,-1.0240000486373901 -0.5350000262260437,-0.7459999918937683 -0.6430000066757202,-0.4009999930858612 C-0.6430000066757202,-0.4009999930858612 -0.6869999766349792,-0.24899999797344208 -0.6869999766349792,-0.24899999797344208 C-0.7919999957084656,0.16699999570846558 -0.7900000214576721,0.5680000185966492 -0.7149999737739563,0.875 C-0.6460000276565552,1.1510000228881836 -0.5289999842643738,1.312999963760376 -0.40799999237060547,1.3830000162124634 C-0.40799999237060547,1.3830000162124634 -0.35499998927116394,1.406999945640564 -0.35499998927116394,1.406999945640564 C-0.2160000056028366,1.4570000171661377 -0.02199999988079071,1.4129999876022339 0.1889999955892563,1.2020000219345093 C0.36899998784065247,1.0230000019073486 0.5339999794960022,0.7459999918937683 0.6430000066757202,0.4009999930858612 C0.6430000066757202,0.4009999930858612 0.6869999766349792,0.24799999594688416 0.6869999766349792,0.24799999594688416 C0.7889999747276306,-0.15299999713897705 0.7910000085830688,-0.5429999828338623 0.7200000286102295,-0.8489999771118164z">
                                                    </path>
                                                </g>
                                                <g opacity="1"
                                                    transform="matrix(1,0,0,1,51.38100051879883,2.8420000076293945)">
                                                    <path fill="rgb(72,255,144)" fill-opacity="1"
                                                        d=" M26.10700035095215,-14.272000312805176 C26.10700035095215,-14.272000312805176 -19.56399917602539,18.371000289916992 -19.56399917602539,18.371000289916992 C-20.82699966430664,19.274999618530273 -22.128000259399414,19.474000930786133 -23.239999771118164,19.075000762939453 C-23.239999771118164,19.075000762939453 -25.297000885009766,18.520000457763672 -26.003999710083008,15.442000389099121 C-26.711999893188477,12.36400032043457 -27.624000549316406,8.494999885559082 -27.624000549316406,8.494999885559082 C-27.624000549316406,8.494999885559082 -26.215999603271484,7.2769999504089355 -26.215999603271484,7.2769999504089355 C-26.215999603271484,7.2769999504089355 -24.60099983215332,14.20199966430664 -24.60099983215332,14.20199966430664 C-23.985000610351562,16.881000518798828 -22.104999542236328,18.100000381469727 -20.05299949645996,16.634000778198242 C-20.05299949645996,16.634000778198242 25.698999404907227,-16.06599998474121 25.698999404907227,-16.06599998474121 C27.08300018310547,-17.058000564575195 27.6299991607666,-18.21500015258789 27.386999130249023,-19.270999908447266 C27.386999130249023,-19.270999908447266 28.437000274658203,-15.935999870300293 26.111000061035156,-14.27299976348877 C26.111000061035156,-14.27299976348877 26.10700035095215,-14.272000312805176 26.10700035095215,-14.272000312805176z">
                                                    </path>
                                                    <path stroke-linecap="round" stroke-linejoin="round"
                                                        fill-opacity="0" stroke="rgb(4,0,255)" stroke-opacity="1"
                                                        stroke-width="0.5"
                                                        d=" M26.10700035095215,-14.272000312805176 C26.10700035095215,-14.272000312805176 -19.56399917602539,18.371000289916992 -19.56399917602539,18.371000289916992 C-20.82699966430664,19.274999618530273 -22.128000259399414,19.474000930786133 -23.239999771118164,19.075000762939453 C-23.239999771118164,19.075000762939453 -25.297000885009766,18.520000457763672 -26.003999710083008,15.442000389099121 C-26.711999893188477,12.36400032043457 -27.624000549316406,8.494999885559082 -27.624000549316406,8.494999885559082 C-27.624000549316406,8.494999885559082 -26.215999603271484,7.2769999504089355 -26.215999603271484,7.2769999504089355 C-26.215999603271484,7.2769999504089355 -24.60099983215332,14.20199966430664 -24.60099983215332,14.20199966430664 C-23.985000610351562,16.881000518798828 -22.104999542236328,18.100000381469727 -20.05299949645996,16.634000778198242 C-20.05299949645996,16.634000778198242 25.698999404907227,-16.06599998474121 25.698999404907227,-16.06599998474121 C27.08300018310547,-17.058000564575195 27.6299991607666,-18.21500015258789 27.386999130249023,-19.270999908447266 C27.386999130249023,-19.270999908447266 28.437000274658203,-15.935999870300293 26.111000061035156,-14.27299976348877 C26.111000061035156,-14.27299976348877 26.10700035095215,-14.272000312805176 26.10700035095215,-14.272000312805176z">
                                                    </path>
                                                </g>
                                                <g opacity="1"
                                                    transform="matrix(1,0,0,1,-38.53200149536133,-73.13999938964844)">
                                                    <path fill="rgb(27,27,27)" fill-opacity="1"
                                                        d=" M1.2860000133514404,3.5910000801086426 C1.2860000133514404,3.5910000801086426 1.0950000286102295,0.8970000147819519 1.0950000286102295,0.8970000147819519 C1.0950000286102295,0.8970000147819519 -6.400000095367432,-5.192999839782715 -6.400000095367432,-5.192999839782715 C-6.400000095367432,-5.192999839782715 6.146999835968018,-0.6620000004768372 6.146999835968018,-0.6620000004768372 C6.146999835968018,-0.6620000004768372 6.400000095367432,5.192999839782715 6.400000095367432,5.192999839782715 C6.400000095367432,5.192999839782715 1.2860000133514404,3.5910000801086426 1.2860000133514404,3.5910000801086426z">
                                                    </path>
                                                </g>
                                                <g opacity="1"
                                                    transform="matrix(1,0,0,1,-28.066999435424805,-73.4540023803711)">
                                                    <path fill="url(#__lottie_element_438)" fill-opacity="1"
                                                        d=" M-13.16100025177002,3.4760000705718994 C-9.583000183105469,4.767000198364258 -7.656000137329102,4.269999980926514 -7.366000175476074,0.1469999998807907 C-7.210999965667725,-2.068000078201294 -6.605999946594238,-4.145999908447266 -5.565000057220459,-6.00600004196167 C-5.565000057220459,-6.00600004196167 -3.2739999294281006,-10.098999977111816 -3.2739999294281006,-10.098999977111816 C-1.2890000343322754,-13.647000312805176 3.621999979019165,-15.362000465393066 7.638000011444092,-13.913999557495117 C11.654000282287598,-12.463000297546387 13.3149995803833,-8.373000144958496 11.329000473022461,-4.828000068664551 C11.329000473022461,-4.828000068664551 8.545999526977539,0.14300000667572021 8.545999526977539,0.14300000667572021 C7.599999904632568,1.8289999961853027 7.247000217437744,3.8450000286102295 7.5279998779296875,5.88100004196167 C8.10200023651123,10.026000022888184 9.371000289916992,11.607999801635742 13.164999961853027,12.977999687194824 C13.164999961853027,12.977999687194824 10.25,14.428000450134277 10.25,14.428000450134277 C10.25,14.428000450134277 -12.52400016784668,6.258999824523926 -12.52400016784668,6.258999824523926 C-12.52400016784668,6.258999824523926 -13.164999961853027,3.4730000495910645 -13.164999961853027,3.4730000495910645 C-13.164999961853027,3.4730000495910645 -13.16100025177002,3.4760000705718994 -13.16100025177002,3.4760000705718994z">
                                                    </path>
                                                </g>
                                                <g opacity="1"
                                                    transform="matrix(1,0,0,1,-28.066999435424805,-74.17900085449219)">
                                                    <path stroke-linecap="butt" stroke-linejoin="miter" fill-opacity="0"
                                                        stroke-miterlimit="10" stroke="rgb(4,0,255)" stroke-opacity="1"
                                                        stroke-width="0.5"
                                                        d=" M-13.163000106811523,4.201000213623047 C-9.585000038146973,5.492000102996826 -7.6579999923706055,4.994999885559082 -7.368000030517578,0.871999979019165 C-7.2129998207092285,-1.343000054359436 -6.607999801635742,-3.4210000038146973 -5.566999912261963,-5.281000137329102 C-5.566999912261963,-5.281000137329102 -3.2760000228881836,-9.37399959564209 -3.2760000228881836,-9.37399959564209 C-1.2910000085830688,-12.92199993133545 3.619999885559082,-14.63700008392334 7.636000156402588,-13.189000129699707 C11.652000427246094,-11.73799991607666 13.312999725341797,-7.6479997634887695 11.32699966430664,-4.103000164031982 C11.32699966430664,-4.103000164031982 8.543999671936035,0.8679999709129333 8.543999671936035,0.8679999709129333 C7.5980000495910645,2.553999900817871 7.244999885559082,4.570000171661377 7.526000022888184,6.605999946594238 C8.100000381469727,10.75100040435791 9.369000434875488,12.333000183105469 13.163000106811523,13.70300006866455">
                                                    </path>
                                                </g>
                                                <g opacity="1"
                                                    transform="matrix(1,0,0,1,-23.85099983215332,-81.08300018310547)">
                                                    <path fill="rgb(27,27,27)" fill-opacity="1"
                                                        d=" M4.919000148773193,-2.2260000705718994 C5.932000160217285,-0.41100001335144043 4.724999904632568,2.128000020980835 2.2219998836517334,3.4509999752044678 C-0.2809999883174896,4.7729997634887695 -3.13100004196167,4.375 -4.144000053405762,2.559999942779541 C-4.144000053405762,2.559999942779541 -5.2779998779296875,0.4169999957084656 -5.2779998779296875,0.4169999957084656 C-5.2779998779296875,0.4169999957084656 3.8450000286102295,-4.230999946594238 3.8450000286102295,-4.230999946594238 C3.8450000286102295,-4.230999946594238 4.919000148773193,-2.2260000705718994 4.919000148773193,-2.2260000705718994z">
                                                    </path>
                                                    <path stroke-linecap="round" stroke-linejoin="round"
                                                        fill-opacity="0" stroke="rgb(4,0,255)" stroke-opacity="1"
                                                        stroke-width="0.5"
                                                        d=" M4.919000148773193,-2.2260000705718994 C5.932000160217285,-0.41100001335144043 4.724999904632568,2.128000020980835 2.2219998836517334,3.4509999752044678 C-0.2809999883174896,4.7729997634887695 -3.13100004196167,4.375 -4.144000053405762,2.559999942779541 C-4.144000053405762,2.559999942779541 -5.2779998779296875,0.4169999957084656 -5.2779998779296875,0.4169999957084656 C-5.2779998779296875,0.4169999957084656 3.8450000286102295,-4.230999946594238 3.8450000286102295,-4.230999946594238 C3.8450000286102295,-4.230999946594238 4.919000148773193,-2.2260000705718994 4.919000148773193,-2.2260000705718994z">
                                                    </path>
                                                </g>
                                                <g opacity="1"
                                                    transform="matrix(1,0,0,1,-24.437999725341797,-82.77300262451172)">
                                                    <path fill="rgb(72,255,144)" fill-opacity="1"
                                                        d=" M-1.8350000381469727,-3.2829999923706055 C0.6679999828338623,-4.604000091552734 3.5179998874664307,-4.205999851226807 4.531000137329102,-2.3929998874664307 C5.545000076293945,-0.5799999833106995 4.336999893188477,1.9609999656677246 1.8350000381469727,3.2829999923706055 C-0.6679999828338623,4.604000091552734 -3.5179998874664307,4.205999851226807 -4.531000137329102,2.3929998874664307 C-5.545000076293945,0.5799999833106995 -4.336999893188477,-1.9609999656677246 -1.8350000381469727,-3.2829999923706055z">
                                                    </path>
                                                    <path stroke-linecap="round" stroke-linejoin="round"
                                                        fill-opacity="0" stroke="rgb(4,0,255)" stroke-opacity="1"
                                                        stroke-width="0.5"
                                                        d=" M-1.8350000381469727,-3.2829999923706055 C0.6679999828338623,-4.604000091552734 3.5179998874664307,-4.205999851226807 4.531000137329102,-2.3929998874664307 C5.545000076293945,-0.5799999833106995 4.336999893188477,1.9609999656677246 1.8350000381469727,3.2829999923706055 C-0.6679999828338623,4.604000091552734 -3.5179998874664307,4.205999851226807 -4.531000137329102,2.3929998874664307 C-5.545000076293945,0.5799999833106995 -4.336999893188477,-1.9609999656677246 -1.8350000381469727,-3.2829999923706055z">
                                                    </path>
                                                </g>
                                                <g opacity="1"
                                                    transform="matrix(1,0,0,1,-10.335000038146973,-35.67499923706055)">
                                                    <path fill="rgb(27,27,27)" fill-opacity="1"
                                                        d=" M-12.803999900817871,8.586999893188477 C-12.470999717712402,10.031999588012695 -11.083999633789062,11.61400032043457 -9.715999603271484,12.109000205993652 C-9.715999603271484,12.109000205993652 17.535999298095703,21.95199966430664 17.535999298095703,21.95199966430664 C18.902999877929688,22.44300079345703 19.749000549316406,21.667999267578125 19.41699981689453,20.222999572753906 C19.41699981689453,20.222999572753906 12.803000450134277,-8.588000297546387 12.803000450134277,-8.588000297546387 C12.470999717712402,-10.032999992370605 11.083999633789062,-11.61400032043457 9.715999603271484,-12.109000205993652 C9.715999603271484,-12.109000205993652 -17.53700065612793,-21.951000213623047 -17.53700065612793,-21.951000213623047 C-18.90399932861328,-22.444000244140625 -19.749000549316406,-21.667999267578125 -19.41699981689453,-20.222999572753906 C-19.41699981689453,-20.222999572753906 -12.803999900817871,8.586999893188477 -12.803999900817871,8.586999893188477z">
                                                    </path>
                                                    <path stroke-linecap="round" stroke-linejoin="round"
                                                        fill-opacity="0" stroke="rgb(4,0,255)" stroke-opacity="1"
                                                        stroke-width="0.5"
                                                        d=" M-12.803999900817871,8.586999893188477 C-12.470999717712402,10.031999588012695 -11.083999633789062,11.61400032043457 -9.715999603271484,12.109000205993652 C-9.715999603271484,12.109000205993652 17.535999298095703,21.95199966430664 17.535999298095703,21.95199966430664 C18.902999877929688,22.44300079345703 19.749000549316406,21.667999267578125 19.41699981689453,20.222999572753906 C19.41699981689453,20.222999572753906 12.803000450134277,-8.588000297546387 12.803000450134277,-8.588000297546387 C12.470999717712402,-10.032999992370605 11.083999633789062,-11.61400032043457 9.715999603271484,-12.109000205993652 C9.715999603271484,-12.109000205993652 -17.53700065612793,-21.951000213623047 -17.53700065612793,-21.951000213623047 C-18.90399932861328,-22.444000244140625 -19.749000549316406,-21.667999267578125 -19.41699981689453,-20.222999572753906 C-19.41699981689453,-20.222999572753906 -12.803999900817871,8.586999893188477 -12.803999900817871,8.586999893188477z">
                                                    </path>
                                                </g>
                                                <g opacity="1"
                                                    transform="matrix(1,0,0,1,-13.854000091552734,-41.084999084472656)">
                                                    <path fill="rgb(27,27,27)" fill-opacity="1"
                                                        d=" M2.253000020980835,-0.6449999809265137 C2.253000020980835,-0.6449999809265137 1.5789999961853027,-0.8880000114440918 1.5789999961853027,-0.8880000114440918 C1.4900000095367432,-0.9200000166893005 1.4149999618530273,-0.9210000038146973 1.3559999465942383,-0.8970000147819519 C1.3559999465942383,-0.8970000147819519 -2.4769999980926514,0.6359999775886536 -2.4769999980926514,0.6359999775886536 C-2.4179999828338623,0.6119999885559082 -2.3420000076293945,0.6129999756813049 -2.253000020980835,0.6449999809265137 C-2.253000020980835,0.6449999809265137 -1.5789999961853027,0.8880000114440918 -1.5789999961853027,0.8880000114440918 C-1.4919999837875366,0.9200000166893005 -1.4149999618530273,0.9210000038146973 -1.3559999465942383,0.8970000147819519 C-1.3559999465942383,0.8970000147819519 2.4769999980926514,-0.6359999775886536 2.4769999980926514,-0.6359999775886536 C2.4179999828338623,-0.6119999885559082 2.3420000076293945,-0.6129999756813049 2.253000020980835,-0.6449999809265137z">
                                                    </path>
                                                    <path stroke-linecap="round" stroke-linejoin="round"
                                                        fill-opacity="0" stroke="rgb(46,204,255)" stroke-opacity="1"
                                                        stroke-width="0.5"
                                                        d=" M2.253000020980835,-0.6449999809265137 C2.253000020980835,-0.6449999809265137 1.5789999961853027,-0.8880000114440918 1.5789999961853027,-0.8880000114440918 C1.4900000095367432,-0.9200000166893005 1.4149999618530273,-0.9210000038146973 1.3559999465942383,-0.8970000147819519 C1.3559999465942383,-0.8970000147819519 -2.4769999980926514,0.6359999775886536 -2.4769999980926514,0.6359999775886536 C-2.4179999828338623,0.6119999885559082 -2.3420000076293945,0.6129999756813049 -2.253000020980835,0.6449999809265137 C-2.253000020980835,0.6449999809265137 -1.5789999961853027,0.8880000114440918 -1.5789999961853027,0.8880000114440918 C-1.4919999837875366,0.9200000166893005 -1.4149999618530273,0.9210000038146973 -1.3559999465942383,0.8970000147819519 C-1.3559999465942383,0.8970000147819519 2.4769999980926514,-0.6359999775886536 2.4769999980926514,-0.6359999775886536 C2.4179999828338623,-0.6119999885559082 2.3420000076293945,-0.6129999756813049 2.253000020980835,-0.6449999809265137z">
                                                    </path>
                                                </g>
                                                <g opacity="1"
                                                    transform="matrix(1,0,0,1,2.434999942779541,-36.35300064086914)">
                                                    <path fill="rgb(27,27,27)" fill-opacity="1"
                                                        d=" M-1.3730000257492065,1.6119999885559082 C-1.3049999475479126,1.9160000085830688 -1.0369999408721924,2.239000082015991 -0.7789999842643738,2.3320000171661377 C-0.7789999842643738,2.3320000171661377 1.9800000190734863,1.2289999723434448 1.9800000190734863,1.2289999723434448 C1.9800000190734863,1.2289999723434448 1.1729999780654907,-2.3320000171661377 1.1729999780654907,-2.3320000171661377 C1.1729999780654907,-2.3320000171661377 -1.9800000190734863,-1.0700000524520874 -1.9800000190734863,-1.0700000524520874 C-1.9800000190734863,-1.0700000524520874 -1.371999979019165,1.6130000352859497 -1.371999979019165,1.6130000352859497 C-1.371999979019165,1.6130000352859497 -1.3730000257492065,1.6119999885559082 -1.3730000257492065,1.6119999885559082z">
                                                    </path>
                                                    <path stroke-linecap="round" stroke-linejoin="round"
                                                        fill-opacity="0" stroke="rgb(46,204,255)" stroke-opacity="1"
                                                        stroke-width="0.5"
                                                        d=" M-1.3730000257492065,1.6119999885559082 C-1.3049999475479126,1.9160000085830688 -1.0369999408721924,2.239000082015991 -0.7789999842643738,2.3320000171661377 C-0.7789999842643738,2.3320000171661377 1.9800000190734863,1.2289999723434448 1.9800000190734863,1.2289999723434448 C1.9800000190734863,1.2289999723434448 1.1729999780654907,-2.3320000171661377 1.1729999780654907,-2.3320000171661377 C1.1729999780654907,-2.3320000171661377 -1.9800000190734863,-1.0700000524520874 -1.9800000190734863,-1.0700000524520874 C-1.9800000190734863,-1.0700000524520874 -1.371999979019165,1.6130000352859497 -1.371999979019165,1.6130000352859497 C-1.371999979019165,1.6130000352859497 -1.3730000257492065,1.6119999885559082 -1.3730000257492065,1.6119999885559082z">
                                                    </path>
                                                </g>
                                                <g opacity="1"
                                                    transform="matrix(1,0,0,1,-13.097000122070312,-44.28900146484375)">
                                                    <path fill="rgb(27,27,27)" fill-opacity="1"
                                                        d=" M2.253999948501587,-0.6439999938011169 C2.253999948501587,-0.6439999938011169 1.5789999961853027,-0.8889999985694885 1.5789999961853027,-0.8889999985694885 C1.4919999837875366,-0.9210000038146973 1.4160000085830688,-0.921999990940094 1.3569999933242798,-0.8980000019073486 C1.3569999933242798,-0.8980000019073486 -2.4760000705718994,0.6349999904632568 -2.4760000705718994,0.6349999904632568 C-2.4170000553131104,0.6110000014305115 -2.3399999141693115,0.6129999756813049 -2.253999948501587,0.6439999938011169 C-2.253999948501587,0.6439999938011169 -1.5789999961853027,0.8889999985694885 -1.5789999961853027,0.8889999985694885 C-1.4919999837875366,0.9210000038146973 -1.4160000085830688,0.921999990940094 -1.3569999933242798,0.8980000019073486 C-1.3569999933242798,0.8980000019073486 2.4760000705718994,-0.6349999904632568 2.4760000705718994,-0.6349999904632568 C2.4170000553131104,-0.6110000014305115 2.3410000801086426,-0.6119999885559082 2.253999948501587,-0.6439999938011169z">
                                                    </path>
                                                    <path stroke-linecap="round" stroke-linejoin="round"
                                                        fill-opacity="0" stroke="rgb(46,204,255)" stroke-opacity="1"
                                                        stroke-width="0.5"
                                                        d=" M2.253999948501587,-0.6439999938011169 C2.253999948501587,-0.6439999938011169 1.5789999961853027,-0.8889999985694885 1.5789999961853027,-0.8889999985694885 C1.4919999837875366,-0.9210000038146973 1.4160000085830688,-0.921999990940094 1.3569999933242798,-0.8980000019073486 C1.3569999933242798,-0.8980000019073486 -2.4760000705718994,0.6349999904632568 -2.4760000705718994,0.6349999904632568 C-2.4170000553131104,0.6110000014305115 -2.3399999141693115,0.6129999756813049 -2.253999948501587,0.6439999938011169 C-2.253999948501587,0.6439999938011169 -1.5789999961853027,0.8889999985694885 -1.5789999961853027,0.8889999985694885 C-1.4919999837875366,0.9210000038146973 -1.4160000085830688,0.921999990940094 -1.3569999933242798,0.8980000019073486 C-1.3569999933242798,0.8980000019073486 2.4760000705718994,-0.6349999904632568 2.4760000705718994,-0.6349999904632568 C2.4170000553131104,-0.6110000014305115 2.3410000801086426,-0.6119999885559082 2.253999948501587,-0.6439999938011169z">
                                                    </path>
                                                </g>
                                                <g opacity="1"
                                                    transform="matrix(1,0,0,1,1.4800000190734863,-22.516000747680664)">
                                                    <path fill="rgb(27,27,27)" fill-opacity="1"
                                                        d=" M-2.00600004196167,0.3709999918937683 C-2.00600004196167,0.3709999918937683 -1.8270000219345093,1.1619999408721924 -1.8270000219345093,1.1619999408721924 C-1.781000018119812,1.3630000352859497 -1.8339999914169312,1.5049999952316284 -1.9500000476837158,1.5509999990463257 C-1.9500000476837158,1.5509999990463257 1.8830000162124634,0.017000000923871994 1.8830000162124634,0.017000000923871994 C1.9989999532699585,-0.028999999165534973 2.0510001182556152,-0.1720000058412552 2.00600004196167,-0.3709999918937683 C2.00600004196167,-0.3709999918937683 1.8259999752044678,-1.1610000133514404 1.8259999752044678,-1.1610000133514404 C1.781000018119812,-1.3630000352859497 1.8329999446868896,-1.50600004196167 1.9500000476837158,-1.5509999990463257 C1.9500000476837158,-1.5509999990463257 -1.8830000162124634,-0.017999999225139618 -1.8830000162124634,-0.017999999225139618 C-1.9989999532699585,0.028999999165534973 -2.0510001182556152,0.1720000058412552 -2.00600004196167,0.3709999918937683z">
                                                    </path>
                                                    <path stroke-linecap="round" stroke-linejoin="round"
                                                        fill-opacity="0" stroke="rgb(46,204,255)" stroke-opacity="1"
                                                        stroke-width="0.5"
                                                        d=" M-2.00600004196167,0.3709999918937683 C-2.00600004196167,0.3709999918937683 -1.8270000219345093,1.1619999408721924 -1.8270000219345093,1.1619999408721924 C-1.781000018119812,1.3630000352859497 -1.8339999914169312,1.5049999952316284 -1.9500000476837158,1.5509999990463257 C-1.9500000476837158,1.5509999990463257 1.8830000162124634,0.017000000923871994 1.8830000162124634,0.017000000923871994 C1.9989999532699585,-0.028999999165534973 2.0510001182556152,-0.1720000058412552 2.00600004196167,-0.3709999918937683 C2.00600004196167,-0.3709999918937683 1.8259999752044678,-1.1610000133514404 1.8259999752044678,-1.1610000133514404 C1.781000018119812,-1.3630000352859497 1.8329999446868896,-1.50600004196167 1.9500000476837158,-1.5509999990463257 C1.9500000476837158,-1.5509999990463257 -1.8830000162124634,-0.017999999225139618 -1.8830000162124634,-0.017999999225139618 C-1.9989999532699585,0.028999999165534973 -2.0510001182556152,0.1720000058412552 -2.00600004196167,0.3709999918937683z">
                                                    </path>
                                                </g>
                                                <g opacity="1"
                                                    transform="matrix(1,0,0,1,4.281000137329102,-23.240999221801758)">
                                                    <path fill="rgb(27,27,27)" fill-opacity="1"
                                                        d=" M-2.00600004196167,0.3709999918937683 C-2.00600004196167,0.3709999918937683 -1.8270000219345093,1.1619999408721924 -1.8270000219345093,1.1619999408721924 C-1.781000018119812,1.3630000352859497 -1.8329999446868896,1.50600004196167 -1.9500000476837158,1.5509999990463257 C-1.9500000476837158,1.5509999990463257 1.8830000162124634,0.017999999225139618 1.8830000162124634,0.017999999225139618 C1.9989999532699585,-0.028999999165534973 2.0510001182556152,-0.1720000058412552 2.00600004196167,-0.3709999918937683 C2.00600004196167,-0.3709999918937683 1.8259999752044678,-1.1619999408721924 1.8259999752044678,-1.1619999408721924 C1.781000018119812,-1.3630000352859497 1.8329999446868896,-1.503999948501587 1.9500000476837158,-1.5509999990463257 C1.9500000476837158,-1.5509999990463257 -1.8830000162124634,-0.017999999225139618 -1.8830000162124634,-0.017999999225139618 C-1.9989999532699585,0.028999999165534973 -2.0510001182556152,0.1720000058412552 -2.00600004196167,0.3709999918937683z">
                                                    </path>
                                                    <path stroke-linecap="round" stroke-linejoin="round"
                                                        fill-opacity="0" stroke="rgb(46,204,255)" stroke-opacity="1"
                                                        stroke-width="0.5"
                                                        d=" M-2.00600004196167,0.3709999918937683 C-2.00600004196167,0.3709999918937683 -1.8270000219345093,1.1619999408721924 -1.8270000219345093,1.1619999408721924 C-1.781000018119812,1.3630000352859497 -1.8329999446868896,1.50600004196167 -1.9500000476837158,1.5509999990463257 C-1.9500000476837158,1.5509999990463257 1.8830000162124634,0.017999999225139618 1.8830000162124634,0.017999999225139618 C1.9989999532699585,-0.028999999165534973 2.0510001182556152,-0.1720000058412552 2.00600004196167,-0.3709999918937683 C2.00600004196167,-0.3709999918937683 1.8259999752044678,-1.1619999408721924 1.8259999752044678,-1.1619999408721924 C1.781000018119812,-1.3630000352859497 1.8329999446868896,-1.503999948501587 1.9500000476837158,-1.5509999990463257 C1.9500000476837158,-1.5509999990463257 -1.8830000162124634,-0.017999999225139618 -1.8830000162124634,-0.017999999225139618 C-1.9989999532699585,0.028999999165534973 -2.0510001182556152,0.1720000058412552 -2.00600004196167,0.3709999918937683z">
                                                    </path>
                                                </g>
                                                <g opacity="1"
                                                    transform="matrix(1,0,0,1,-11.104999542236328,-45.30400085449219)">
                                                    <path fill="rgb(27,27,27)" fill-opacity="1"
                                                        d=" M3.062000036239624,-0.3529999852180481 C3.062000036239624,-0.3529999852180481 0.7710000276565552,-1.1799999475479126 0.7710000276565552,-1.1799999475479126 C0.6830000281333923,-1.2130000591278076 0.6079999804496765,-1.2139999866485596 0.5490000247955322,-1.1890000104904175 C0.5490000247955322,-1.1890000104904175 -3.2839999198913574,0.3440000116825104 -3.2839999198913574,0.3440000116825104 C-3.2249999046325684,0.3199999928474426 -3.1489999294281006,0.32100000977516174 -3.062000036239624,0.3529999852180481 C-3.062000036239624,0.3529999852180481 -0.7710000276565552,1.1799999475479126 -0.7710000276565552,1.1799999475479126 C-0.6830000281333923,1.2120000123977661 -0.6079999804496765,1.2139999866485596 -0.5490000247955322,1.190000057220459 C-0.5490000247955322,1.190000057220459 3.2839999198913574,-0.3440000116825104 3.2839999198913574,-0.3440000116825104 C3.2249999046325684,-0.3199999928474426 3.1480000019073486,-0.32199999690055847 3.062000036239624,-0.3529999852180481z">
                                                    </path>
                                                    <path stroke-linecap="round" stroke-linejoin="round"
                                                        fill-opacity="0" stroke="rgb(46,204,255)" stroke-opacity="1"
                                                        stroke-width="0.5"
                                                        d=" M3.062000036239624,-0.3529999852180481 C3.062000036239624,-0.3529999852180481 0.7710000276565552,-1.1799999475479126 0.7710000276565552,-1.1799999475479126 C0.6830000281333923,-1.2130000591278076 0.6079999804496765,-1.2139999866485596 0.5490000247955322,-1.1890000104904175 C0.5490000247955322,-1.1890000104904175 -3.2839999198913574,0.3440000116825104 -3.2839999198913574,0.3440000116825104 C-3.2249999046325684,0.3199999928474426 -3.1489999294281006,0.32100000977516174 -3.062000036239624,0.3529999852180481 C-3.062000036239624,0.3529999852180481 -0.7710000276565552,1.1799999475479126 -0.7710000276565552,1.1799999475479126 C-0.6830000281333923,1.2120000123977661 -0.6079999804496765,1.2139999866485596 -0.5490000247955322,1.190000057220459 C-0.5490000247955322,1.190000057220459 3.2839999198913574,-0.3440000116825104 3.2839999198913574,-0.3440000116825104 C3.2249999046325684,-0.3199999928474426 3.1480000019073486,-0.32199999690055847 3.062000036239624,-0.3529999852180481z">
                                                    </path>
                                                </g>
                                                <g opacity="1"
                                                    transform="matrix(1,0,0,1,4.939000129699707,-25.32200050354004)">
                                                    <path fill="rgb(27,27,27)" fill-opacity="1"
                                                        d=" M-1.9079999923706055,-0.7490000128746033 C-1.9079999923706055,-0.7490000128746033 -1.2999999523162842,1.934000015258789 -1.2999999523162842,1.934000015258789 C-1.2549999952316284,2.134999990463257 -1.3079999685287476,2.2780001163482666 -1.4240000247955322,2.3239998817443848 C-1.4240000247955322,2.3239998817443848 1.9249999523162842,0.984000027179718 1.9249999523162842,0.984000027179718 C1.9249999523162842,0.984000027179718 1.1729999780654907,-2.3239998817443848 1.1729999780654907,-2.3239998817443848 C1.1729999780654907,-2.3239998817443848 -1.7860000133514404,-1.1410000324249268 -1.7860000133514404,-1.1410000324249268 C-1.9010000228881836,-1.093999981880188 -1.9539999961853027,-0.9509999752044678 -1.909000039100647,-0.7519999742507935 C-1.909000039100647,-0.7519999742507935 -1.9079999923706055,-0.7490000128746033 -1.9079999923706055,-0.7490000128746033z">
                                                    </path>
                                                    <path stroke-linecap="round" stroke-linejoin="round"
                                                        fill-opacity="0" stroke="rgb(46,204,255)" stroke-opacity="1"
                                                        stroke-width="0.5"
                                                        d=" M-1.9079999923706055,-0.7490000128746033 C-1.9079999923706055,-0.7490000128746033 -1.2999999523162842,1.934000015258789 -1.2999999523162842,1.934000015258789 C-1.2549999952316284,2.134999990463257 -1.3079999685287476,2.2780001163482666 -1.4240000247955322,2.3239998817443848 C-1.4240000247955322,2.3239998817443848 1.9249999523162842,0.984000027179718 1.9249999523162842,0.984000027179718 C1.9249999523162842,0.984000027179718 1.1729999780654907,-2.3239998817443848 1.1729999780654907,-2.3239998817443848 C1.1729999780654907,-2.3239998817443848 -1.7860000133514404,-1.1410000324249268 -1.7860000133514404,-1.1410000324249268 C-1.9010000228881836,-1.093999981880188 -1.9539999961853027,-0.9509999752044678 -1.909000039100647,-0.7519999742507935 C-1.909000039100647,-0.7519999742507935 -1.9079999923706055,-0.7490000128746033 -1.9079999923706055,-0.7490000128746033z">
                                                    </path>
                                                </g>
                                                <g opacity="1"
                                                    transform="matrix(1,0,0,1,-6.0279998779296875,-33.327999114990234)">
                                                    <path fill="rgb(72,255,144)" fill-opacity="1"
                                                        d=" M-5.301000118255615,-12.142000198364258 C-5.301000118255615,-12.142000198364258 -5.300000190734863,-12.140999794006348 -5.300000190734863,-12.140999794006348 C-5.300000190734863,-12.140999794006348 0.2199999988079071,-10.147000312805176 0.2199999988079071,-10.147000312805176 C0.2199999988079071,-10.147000312805176 0.22100000083446503,-10.147000312805176 0.22100000083446503,-10.147000312805176 C0.3330000042915344,-10.107000350952148 0.48500001430511475,-9.954999923706055 0.5540000200271606,-9.77299976348877 C0.5540000200271606,-9.77299976348877 0.5789999961853027,-9.692999839782715 0.5789999961853027,-9.692999839782715 C0.5789999961853027,-9.692999839782715 0.7580000162124634,-8.904000282287598 0.7580000162124634,-8.904000282287598 C0.8460000157356262,-8.515000343322754 1.2000000476837158,-8.055999755859375 1.5889999866485596,-7.915999889373779 C1.5889999866485596,-7.915999889373779 1.5889999866485596,-7.915999889373779 1.5889999866485596,-7.915999889373779 C1.5889999866485596,-7.915999889373779 3.878999948501587,-7.0879998207092285 3.878999948501587,-7.0879998207092285 C3.878999948501587,-7.0879998207092285 3.880000114440918,-7.0879998207092285 3.880000114440918,-7.0879998207092285 C3.992000102996826,-7.046999931335449 4.144000053405762,-6.896999835968018 4.2129998207092285,-6.715000152587891 C4.2129998207092285,-6.715000152587891 4.236999988555908,-6.635000228881836 4.236999988555908,-6.635000228881836 C4.236999988555908,-6.635000228881836 4.415999889373779,-5.84499979019165 4.415999889373779,-5.84499979019165 C4.505000114440918,-5.453999996185303 4.861999988555908,-4.997000217437744 5.249000072479248,-4.857999801635742 C5.249000072479248,-4.857999801635742 5.249000072479248,-4.85699987411499 5.249000072479248,-4.85699987411499 C5.249000072479248,-4.85699987411499 5.925000190734863,-4.611999988555908 5.925000190734863,-4.611999988555908 C5.925000190734863,-4.611999988555908 5.925000190734863,-4.611999988555908 5.925000190734863,-4.611999988555908 C6.0370001792907715,-4.572000026702881 6.190000057220459,-4.420000076293945 6.258999824523926,-4.23799991607666 C6.258999824523926,-4.23799991607666 6.2829999923706055,-4.1579999923706055 6.2829999923706055,-4.1579999923706055 C6.2829999923706055,-4.1579999923706055 6.890999794006348,-1.475000023841858 6.890999794006348,-1.475000023841858 C6.979000091552734,-1.0870000123977661 7.334000110626221,-0.6299999952316284 7.7210001945495605,-0.49000000953674316 C7.7210001945495605,-0.49000000953674316 7.7220001220703125,-0.48899999260902405 7.7220001220703125,-0.48899999260902405 C7.7220001220703125,-0.48899999260902405 8.397000312805176,-0.24500000476837158 8.397000312805176,-0.24500000476837158 C8.397000312805176,-0.24500000476837158 8.39799976348877,-0.24400000274181366 8.39799976348877,-0.24400000274181366 C8.510000228881836,-0.20399999618530273 8.661999702453613,-0.05299999937415123 8.730999946594238,0.1289999932050705 C8.730999946594238,0.1289999932050705 8.755000114440918,0.20800000429153442 8.755000114440918,0.20800000429153442 C8.755000114440918,0.20800000429153442 10.222999572753906,6.676000118255615 10.222999572753906,6.676000118255615 C10.270999908447266,6.888000011444092 10.159000396728516,6.954999923706055 10.043999671936035,6.914000034332275 C10.043999671936035,6.914000034332275 10.043999671936035,6.914000034332275 10.043999671936035,6.914000034332275 C10.043999671936035,6.914000034332275 9.369000434875488,6.669000148773193 9.369000434875488,6.669000148773193 C9.369000434875488,6.669000148773193 9.368000030517578,6.669000148773193 9.368000030517578,6.669000148773193 C8.991999626159668,6.5320000648498535 8.795999526977539,6.765999794006348 8.845999717712402,7.119999885559082 C8.845999717712402,7.119999885559082 8.859000205993652,7.192999839782715 8.859000205993652,7.192999839782715 C8.859000205993652,7.192999839782715 9.467000007629395,9.875 9.467000007629395,9.875 C9.515000343322754,10.086999893188477 9.402999877929688,10.154000282287598 9.288000106811523,10.112000465393066 C9.288000106811523,10.112000465393066 9.286999702453613,10.11299991607666 9.286999702453613,10.11299991607666 C9.286999702453613,10.11299991607666 8.61299991607666,9.869000434875488 8.61299991607666,9.869000434875488 C8.61299991607666,9.869000434875488 8.61400032043457,9.868000030517578 8.61400032043457,9.868000030517578 C8.236000061035156,9.730999946594238 8.038000106811523,9.96500015258789 8.088000297546387,10.319999694824219 C8.088000297546387,10.319999694824219 8.10200023651123,10.392000198364258 8.10200023651123,10.392000198364258 C8.10200023651123,10.392000198364258 8.281000137329102,11.182000160217285 8.281000137329102,11.182000160217285 C8.322999954223633,11.366000175476074 8.241999626159668,11.440999984741211 8.144000053405762,11.428999900817871 C8.144000053405762,11.428999900817871 8.10200023651123,11.418999671936035 8.10200023651123,11.418999671936035 C8.10200023651123,11.418999671936035 5.810999870300293,10.590999603271484 5.810999870300293,10.590999603271484 C5.810999870300293,10.590999603271484 5.810999870300293,10.590999603271484 5.810999870300293,10.590999603271484 C5.434999942779541,10.454000473022461 5.23799991607666,10.689000129699707 5.288000106811523,11.041999816894531 C5.288000106811523,11.041999816894531 5.302000045776367,11.114999771118164 5.302000045776367,11.114999771118164 C5.302000045776367,11.114999771118164 5.48199987411499,11.906000137329102 5.48199987411499,11.906000137329102 C5.53000020980835,12.116000175476074 5.416999816894531,12.184000015258789 5.300000190734863,12.142000198364258 C5.300000190734863,12.142000198364258 5.301000118255615,12.142000198364258 5.301000118255615,12.142000198364258 C5.301000118255615,12.142000198364258 -0.21899999678134918,10.147000312805176 -0.21899999678134918,10.147000312805176 C-0.21899999678134918,10.147000312805176 -0.2199999988079071,10.147000312805176 -0.2199999988079071,10.147000312805176 C-0.3330000042915344,10.107000350952148 -0.48399999737739563,9.956000328063965 -0.5529999732971191,9.774999618530273 C-0.5529999732971191,9.774999618530273 -0.578000009059906,9.694000244140625 -0.578000009059906,9.694000244140625 C-0.578000009059906,9.694000244140625 -0.7570000290870667,8.902999877929688 -0.7570000290870667,8.902999877929688 C-0.8450000286102295,8.515999794006348 -1.2000000476837158,8.057999610900879 -1.5880000591278076,7.916999816894531 C-1.5880000591278076,7.916999816894531 -1.5880000591278076,7.916999816894531 -1.5880000591278076,7.916999816894531 C-1.5880000591278076,7.916999816894531 -3.878999948501587,7.090000152587891 -3.878999948501587,7.090000152587891 C-3.878999948501587,7.090000152587891 -3.880000114440918,7.090000152587891 -3.880000114440918,7.090000152587891 C-3.992000102996826,7.048999786376953 -4.144000053405762,6.89900016784668 -4.2129998207092285,6.7170000076293945 C-4.2129998207092285,6.7170000076293945 -4.236999988555908,6.63700008392334 -4.236999988555908,6.63700008392334 C-4.236999988555908,6.63700008392334 -4.23799991607666,6.63700008392334 -4.23799991607666,6.63700008392334 C-4.23799991607666,6.63700008392334 -4.416999816894531,5.8470001220703125 -4.416999816894531,5.8470001220703125 C-4.504000186920166,5.459000110626221 -4.860000133514404,5 -5.248000144958496,4.860000133514404 C-5.248000144958496,4.860000133514404 -5.247000217437744,4.860000133514404 -5.247000217437744,4.860000133514404 C-5.247000217437744,4.860000133514404 -5.922999858856201,4.614999771118164 -5.922999858856201,4.614999771118164 C-5.922999858856201,4.614999771118164 -5.922999858856201,4.614999771118164 -5.922999858856201,4.614999771118164 C-6.034999847412109,4.574999809265137 -6.186999797821045,4.423999786376953 -6.256999969482422,4.241000175476074 C-6.256999969482422,4.241000175476074 -6.281000137329102,4.160999774932861 -6.281000137329102,4.160999774932861 C-6.281000137329102,4.160999774932861 -6.888999938964844,1.4780000448226929 -6.888999938964844,1.4780000448226929 C-6.888999938964844,1.4780000448226929 -6.889999866485596,1.4780000448226929 -6.889999866485596,1.4780000448226929 C-6.973999977111816,1.1130000352859497 -7.290999889373779,0.6869999766349792 -7.651000022888184,0.5199999809265137 C-7.651000022888184,0.5199999809265137 -7.7230000495910645,0.4909999966621399 -7.7230000495910645,0.4909999966621399 C-7.7230000495910645,0.4909999966621399 -8.397000312805176,0.24799999594688416 -8.397000312805176,0.24799999594688416 C-8.508999824523926,0.2070000022649765 -8.661999702453613,0.0560000017285347 -8.730999946594238,-0.12700000405311584 C-8.730999946594238,-0.12700000405311584 -8.755000114440918,-0.2070000022649765 -8.755000114440918,-0.2070000022649765 C-8.755000114440918,-0.2070000022649765 -10.222999572753906,-6.675000190734863 -10.222999572753906,-6.675000190734863 C-10.265000343322754,-6.857999801635742 -10.184000015258789,-6.933000087738037 -10.083999633789062,-6.920000076293945 C-10.083999633789062,-6.920000076293945 -10.041999816894531,-6.909999847412109 -10.041999816894531,-6.909999847412109 C-10.041999816894531,-6.909999847412109 -9.369000434875488,-6.668000221252441 -9.369000434875488,-6.668000221252441 C-9.369000434875488,-6.668000221252441 -9.368000030517578,-6.666999816894531 -9.368000030517578,-6.666999816894531 C-8.989999771118164,-6.53000020980835 -8.791999816894531,-6.763000011444092 -8.842000007629395,-7.11899995803833 C-8.842000007629395,-7.11899995803833 -8.855999946594238,-7.190999984741211 -8.855999946594238,-7.190999984741211 C-8.855999946594238,-7.190999984741211 -9.46399974822998,-9.87399959564209 -9.46399974822998,-9.87399959564209 C-9.51200008392334,-10.085000038146973 -9.401000022888184,-10.152999877929688 -9.28600025177002,-10.112000465393066 C-9.28600025177002,-10.112000465393066 -9.28600025177002,-10.111000061035156 -9.28600025177002,-10.111000061035156 C-9.28600025177002,-10.111000061035156 -8.611000061035156,-9.866000175476074 -8.611000061035156,-9.866000175476074 C-8.611000061035156,-9.866000175476074 -8.611000061035156,-9.866999626159668 -8.611000061035156,-9.866999626159668 C-8.234000205993652,-9.729000091552734 -8.036999702453613,-9.96399974822998 -8.086999893188477,-10.317999839782715 C-8.086999893188477,-10.317999839782715 -8.100000381469727,-10.390000343322754 -8.100000381469727,-10.390000343322754 C-8.100000381469727,-10.390000343322754 -8.10099983215332,-10.390999794006348 -8.10099983215332,-10.390999794006348 C-8.10099983215332,-10.390999794006348 -8.279999732971191,-11.180000305175781 -8.279999732971191,-11.180000305175781 C-8.321000099182129,-11.36400032043457 -8.241000175476074,-11.439000129699707 -8.142999649047852,-11.427000045776367 C-8.142999649047852,-11.427000045776367 -8.100000381469727,-11.416000366210938 -8.100000381469727,-11.416000366210938 C-8.100000381469727,-11.416000366210938 -5.809000015258789,-10.58899974822998 -5.809000015258789,-10.58899974822998 C-5.433000087738037,-10.454000473022461 -5.236000061035156,-10.687999725341797 -5.2870001792907715,-11.041999816894531 C-5.2870001792907715,-11.041999816894531 -5.300000190734863,-11.114999771118164 -5.300000190734863,-11.114999771118164 C-5.300000190734863,-11.114999771118164 -5.479000091552734,-11.904000282287598 -5.479000091552734,-11.904000282287598 C-5.526000022888184,-12.114999771118164 -5.415999889373779,-12.182999610900879 -5.301000118255615,-12.142000198364258z">
                                                    </path>
                                                    <path stroke-linecap="butt" stroke-linejoin="miter" fill-opacity="0"
                                                        stroke-miterlimit="4" stroke="rgb(46,204,255)"
                                                        stroke-opacity="1" stroke-width="0.5"
                                                        d=" M-5.301000118255615,-12.142000198364258 C-5.301000118255615,-12.142000198364258 -5.300000190734863,-12.140999794006348 -5.300000190734863,-12.140999794006348 C-5.300000190734863,-12.140999794006348 0.2199999988079071,-10.147000312805176 0.2199999988079071,-10.147000312805176 C0.2199999988079071,-10.147000312805176 0.22100000083446503,-10.147000312805176 0.22100000083446503,-10.147000312805176 C0.3330000042915344,-10.107000350952148 0.48500001430511475,-9.954999923706055 0.5540000200271606,-9.77299976348877 C0.5540000200271606,-9.77299976348877 0.5789999961853027,-9.692999839782715 0.5789999961853027,-9.692999839782715 C0.5789999961853027,-9.692999839782715 0.7580000162124634,-8.904000282287598 0.7580000162124634,-8.904000282287598 C0.8460000157356262,-8.515000343322754 1.2000000476837158,-8.055999755859375 1.5889999866485596,-7.915999889373779 C1.5889999866485596,-7.915999889373779 1.5889999866485596,-7.915999889373779 1.5889999866485596,-7.915999889373779 C1.5889999866485596,-7.915999889373779 3.878999948501587,-7.0879998207092285 3.878999948501587,-7.0879998207092285 C3.878999948501587,-7.0879998207092285 3.880000114440918,-7.0879998207092285 3.880000114440918,-7.0879998207092285 C3.992000102996826,-7.046999931335449 4.144000053405762,-6.896999835968018 4.2129998207092285,-6.715000152587891 C4.2129998207092285,-6.715000152587891 4.236999988555908,-6.635000228881836 4.236999988555908,-6.635000228881836 C4.236999988555908,-6.635000228881836 4.415999889373779,-5.84499979019165 4.415999889373779,-5.84499979019165 C4.505000114440918,-5.453999996185303 4.861999988555908,-4.997000217437744 5.249000072479248,-4.857999801635742 C5.249000072479248,-4.857999801635742 5.249000072479248,-4.85699987411499 5.249000072479248,-4.85699987411499 C5.249000072479248,-4.85699987411499 5.925000190734863,-4.611999988555908 5.925000190734863,-4.611999988555908 C5.925000190734863,-4.611999988555908 5.925000190734863,-4.611999988555908 5.925000190734863,-4.611999988555908 C6.0370001792907715,-4.572000026702881 6.190000057220459,-4.420000076293945 6.258999824523926,-4.23799991607666 C6.258999824523926,-4.23799991607666 6.2829999923706055,-4.1579999923706055 6.2829999923706055,-4.1579999923706055 C6.2829999923706055,-4.1579999923706055 6.890999794006348,-1.475000023841858 6.890999794006348,-1.475000023841858 C6.979000091552734,-1.0870000123977661 7.334000110626221,-0.6299999952316284 7.7210001945495605,-0.49000000953674316 C7.7210001945495605,-0.49000000953674316 7.7220001220703125,-0.48899999260902405 7.7220001220703125,-0.48899999260902405 C7.7220001220703125,-0.48899999260902405 8.397000312805176,-0.24500000476837158 8.397000312805176,-0.24500000476837158 C8.397000312805176,-0.24500000476837158 8.39799976348877,-0.24400000274181366 8.39799976348877,-0.24400000274181366 C8.510000228881836,-0.20399999618530273 8.661999702453613,-0.05299999937415123 8.730999946594238,0.1289999932050705 C8.730999946594238,0.1289999932050705 8.755000114440918,0.20800000429153442 8.755000114440918,0.20800000429153442 C8.755000114440918,0.20800000429153442 10.222999572753906,6.676000118255615 10.222999572753906,6.676000118255615 C10.270999908447266,6.888000011444092 10.159000396728516,6.954999923706055 10.043999671936035,6.914000034332275 C10.043999671936035,6.914000034332275 10.043999671936035,6.914000034332275 10.043999671936035,6.914000034332275 C10.043999671936035,6.914000034332275 9.369000434875488,6.669000148773193 9.369000434875488,6.669000148773193 C9.369000434875488,6.669000148773193 9.368000030517578,6.669000148773193 9.368000030517578,6.669000148773193 C8.991999626159668,6.5320000648498535 8.795999526977539,6.765999794006348 8.845999717712402,7.119999885559082 C8.845999717712402,7.119999885559082 8.859000205993652,7.192999839782715 8.859000205993652,7.192999839782715 C8.859000205993652,7.192999839782715 9.467000007629395,9.875 9.467000007629395,9.875 C9.515000343322754,10.086999893188477 9.402999877929688,10.154000282287598 9.288000106811523,10.112000465393066 C9.288000106811523,10.112000465393066 9.286999702453613,10.11299991607666 9.286999702453613,10.11299991607666 C9.286999702453613,10.11299991607666 8.61299991607666,9.869000434875488 8.61299991607666,9.869000434875488 C8.61299991607666,9.869000434875488 8.61400032043457,9.868000030517578 8.61400032043457,9.868000030517578 C8.236000061035156,9.730999946594238 8.038000106811523,9.96500015258789 8.088000297546387,10.319999694824219 C8.088000297546387,10.319999694824219 8.10200023651123,10.392000198364258 8.10200023651123,10.392000198364258 C8.10200023651123,10.392000198364258 8.281000137329102,11.182000160217285 8.281000137329102,11.182000160217285 C8.322999954223633,11.366000175476074 8.241999626159668,11.440999984741211 8.144000053405762,11.428999900817871 C8.144000053405762,11.428999900817871 8.10200023651123,11.418999671936035 8.10200023651123,11.418999671936035 C8.10200023651123,11.418999671936035 5.810999870300293,10.590999603271484 5.810999870300293,10.590999603271484 C5.810999870300293,10.590999603271484 5.810999870300293,10.590999603271484 5.810999870300293,10.590999603271484 C5.434999942779541,10.454000473022461 5.23799991607666,10.689000129699707 5.288000106811523,11.041999816894531 C5.288000106811523,11.041999816894531 5.302000045776367,11.114999771118164 5.302000045776367,11.114999771118164 C5.302000045776367,11.114999771118164 5.48199987411499,11.906000137329102 5.48199987411499,11.906000137329102 C5.53000020980835,12.116000175476074 5.416999816894531,12.184000015258789 5.300000190734863,12.142000198364258 C5.300000190734863,12.142000198364258 5.301000118255615,12.142000198364258 5.301000118255615,12.142000198364258 C5.301000118255615,12.142000198364258 -0.21899999678134918,10.147000312805176 -0.21899999678134918,10.147000312805176 C-0.21899999678134918,10.147000312805176 -0.2199999988079071,10.147000312805176 -0.2199999988079071,10.147000312805176 C-0.3330000042915344,10.107000350952148 -0.48399999737739563,9.956000328063965 -0.5529999732971191,9.774999618530273 C-0.5529999732971191,9.774999618530273 -0.578000009059906,9.694000244140625 -0.578000009059906,9.694000244140625 C-0.578000009059906,9.694000244140625 -0.7570000290870667,8.902999877929688 -0.7570000290870667,8.902999877929688 C-0.8450000286102295,8.515999794006348 -1.2000000476837158,8.057999610900879 -1.5880000591278076,7.916999816894531 C-1.5880000591278076,7.916999816894531 -1.5880000591278076,7.916999816894531 -1.5880000591278076,7.916999816894531 C-1.5880000591278076,7.916999816894531 -3.878999948501587,7.090000152587891 -3.878999948501587,7.090000152587891 C-3.878999948501587,7.090000152587891 -3.880000114440918,7.090000152587891 -3.880000114440918,7.090000152587891 C-3.992000102996826,7.048999786376953 -4.144000053405762,6.89900016784668 -4.2129998207092285,6.7170000076293945 C-4.2129998207092285,6.7170000076293945 -4.236999988555908,6.63700008392334 -4.236999988555908,6.63700008392334 C-4.236999988555908,6.63700008392334 -4.23799991607666,6.63700008392334 -4.23799991607666,6.63700008392334 C-4.23799991607666,6.63700008392334 -4.416999816894531,5.8470001220703125 -4.416999816894531,5.8470001220703125 C-4.504000186920166,5.459000110626221 -4.860000133514404,5 -5.248000144958496,4.860000133514404 C-5.248000144958496,4.860000133514404 -5.247000217437744,4.860000133514404 -5.247000217437744,4.860000133514404 C-5.247000217437744,4.860000133514404 -5.922999858856201,4.614999771118164 -5.922999858856201,4.614999771118164 C-5.922999858856201,4.614999771118164 -5.922999858856201,4.614999771118164 -5.922999858856201,4.614999771118164 C-6.034999847412109,4.574999809265137 -6.186999797821045,4.423999786376953 -6.256999969482422,4.241000175476074 C-6.256999969482422,4.241000175476074 -6.281000137329102,4.160999774932861 -6.281000137329102,4.160999774932861 C-6.281000137329102,4.160999774932861 -6.888999938964844,1.4780000448226929 -6.888999938964844,1.4780000448226929 C-6.888999938964844,1.4780000448226929 -6.889999866485596,1.4780000448226929 -6.889999866485596,1.4780000448226929 C-6.973999977111816,1.1130000352859497 -7.290999889373779,0.6869999766349792 -7.651000022888184,0.5199999809265137 C-7.651000022888184,0.5199999809265137 -7.7230000495910645,0.4909999966621399 -7.7230000495910645,0.4909999966621399 C-7.7230000495910645,0.4909999966621399 -8.397000312805176,0.24799999594688416 -8.397000312805176,0.24799999594688416 C-8.508999824523926,0.2070000022649765 -8.661999702453613,0.0560000017285347 -8.730999946594238,-0.12700000405311584 C-8.730999946594238,-0.12700000405311584 -8.755000114440918,-0.2070000022649765 -8.755000114440918,-0.2070000022649765 C-8.755000114440918,-0.2070000022649765 -10.222999572753906,-6.675000190734863 -10.222999572753906,-6.675000190734863 C-10.265000343322754,-6.857999801635742 -10.184000015258789,-6.933000087738037 -10.083999633789062,-6.920000076293945 C-10.083999633789062,-6.920000076293945 -10.041999816894531,-6.909999847412109 -10.041999816894531,-6.909999847412109 C-10.041999816894531,-6.909999847412109 -9.369000434875488,-6.668000221252441 -9.369000434875488,-6.668000221252441 C-9.369000434875488,-6.668000221252441 -9.368000030517578,-6.666999816894531 -9.368000030517578,-6.666999816894531 C-8.989999771118164,-6.53000020980835 -8.791999816894531,-6.763000011444092 -8.842000007629395,-7.11899995803833 C-8.842000007629395,-7.11899995803833 -8.855999946594238,-7.190999984741211 -8.855999946594238,-7.190999984741211 C-8.855999946594238,-7.190999984741211 -9.46399974822998,-9.87399959564209 -9.46399974822998,-9.87399959564209 C-9.51200008392334,-10.085000038146973 -9.401000022888184,-10.152999877929688 -9.28600025177002,-10.112000465393066 C-9.28600025177002,-10.112000465393066 -9.28600025177002,-10.111000061035156 -9.28600025177002,-10.111000061035156 C-9.28600025177002,-10.111000061035156 -8.611000061035156,-9.866000175476074 -8.611000061035156,-9.866000175476074 C-8.611000061035156,-9.866000175476074 -8.611000061035156,-9.866999626159668 -8.611000061035156,-9.866999626159668 C-8.234000205993652,-9.729000091552734 -8.036999702453613,-9.96399974822998 -8.086999893188477,-10.317999839782715 C-8.086999893188477,-10.317999839782715 -8.100000381469727,-10.390000343322754 -8.100000381469727,-10.390000343322754 C-8.100000381469727,-10.390000343322754 -8.10099983215332,-10.390999794006348 -8.10099983215332,-10.390999794006348 C-8.10099983215332,-10.390999794006348 -8.279999732971191,-11.180000305175781 -8.279999732971191,-11.180000305175781 C-8.321000099182129,-11.36400032043457 -8.241000175476074,-11.439000129699707 -8.142999649047852,-11.427000045776367 C-8.142999649047852,-11.427000045776367 -8.100000381469727,-11.416000366210938 -8.100000381469727,-11.416000366210938 C-8.100000381469727,-11.416000366210938 -5.809000015258789,-10.58899974822998 -5.809000015258789,-10.58899974822998 C-5.433000087738037,-10.454000473022461 -5.236000061035156,-10.687999725341797 -5.2870001792907715,-11.041999816894531 C-5.2870001792907715,-11.041999816894531 -5.300000190734863,-11.114999771118164 -5.300000190734863,-11.114999771118164 C-5.300000190734863,-11.114999771118164 -5.479000091552734,-11.904000282287598 -5.479000091552734,-11.904000282287598 C-5.526000022888184,-12.114999771118164 -5.415999889373779,-12.182999610900879 -5.301000118255615,-12.142000198364258z">
                                                    </path>
                                                </g>
                                                <g opacity="1"
                                                    transform="matrix(1,0,0,1,-2.6610000133514404,-36.715999603271484)">
                                                    <path fill="rgb(27,27,27)" fill-opacity="1"
                                                        d=" M5.083000183105469,-3.9260001182556152 C5.083000183105469,-3.9260001182556152 4.9029998779296875,-4.7179999351501465 4.9029998779296875,-4.7179999351501465 C4.835000038146973,-5.019999980926514 4.567999839782715,-5.343999862670898 4.309000015258789,-5.436999797821045 C4.309000015258789,-5.436999797821045 2.0190000534057617,-6.263999938964844 2.0190000534057617,-6.263999938964844 C1.7610000371932983,-6.35699987411499 1.4930000305175781,-6.683000087738037 1.4240000247955322,-6.985000133514404 C1.4240000247955322,-6.985000133514404 1.24399995803833,-7.776000022888184 1.24399995803833,-7.776000022888184 C1.1759999990463257,-8.079000473022461 0.9079999923706055,-8.404000282287598 0.6489999890327454,-8.496999740600586 C0.6489999890327454,-8.496999740600586 -4.869999885559082,-10.491999626159668 -4.869999885559082,-10.491999626159668 C-4.956999778747559,-10.52400016784668 -5.0320000648498535,-10.524999618530273 -5.091000080108643,-10.50100040435791 C-5.091000080108643,-10.50100040435791 -8.923999786376953,-8.968000411987305 -8.923999786376953,-8.968000411987305 C-8.864999771118164,-8.991999626159668 -8.789999961853027,-8.991000175476074 -8.70199966430664,-8.958999633789062 C-8.70199966430664,-8.958999633789062 -3.181999921798706,-6.964000225067139 -3.181999921798706,-6.964000225067139 C-2.9230000972747803,-6.870999813079834 -2.6540000438690186,-6.546000003814697 -2.5869998931884766,-6.243000030517578 C-2.5869998931884766,-6.243000030517578 -2.4070000648498535,-5.453000068664551 -2.4070000648498535,-5.453000068664551 C-2.3380000591278076,-5.150000095367432 -2.071000099182129,-4.823999881744385 -1.812000036239624,-4.730999946594238 C-1.812000036239624,-4.730999946594238 0.4779999852180481,-3.9030001163482666 0.4779999852180481,-3.9030001163482666 C0.7360000014305115,-3.809999942779541 1.003999948501587,-3.484999895095825 1.0720000267028809,-3.184999942779541 C1.0720000267028809,-3.184999942779541 1.2519999742507935,-2.3940000534057617 1.2519999742507935,-2.3940000534057617 C1.3200000524520874,-2.0910000801086426 1.5880000591278076,-1.7669999599456787 1.8480000495910645,-1.6720000505447388 C1.8480000495910645,-1.6720000505447388 2.5239999294281006,-1.4279999732971191 2.5239999294281006,-1.4279999732971191 C2.7820000648498535,-1.3350000381469727 3.049999952316284,-1.0089999437332153 3.11899995803833,-0.7059999704360962 C3.11899995803833,-0.7059999704360962 3.7269999980926514,1.9759999513626099 3.7269999980926514,1.9759999513626099 C3.7960000038146973,2.2790000438690186 4.063000202178955,2.6029999256134033 4.321000099182129,2.694999933242798 C4.321000099182129,2.694999933242798 4.995999813079834,2.940000057220459 4.995999813079834,2.940000057220459 C5.255000114440918,3.0329999923706055 5.5229997634887695,3.3589999675750732 5.590000152587891,3.6589999198913574 C5.590000152587891,3.6589999198913574 7.058000087738037,10.126999855041504 7.058000087738037,10.126999855041504 C7.104000091552734,10.329000473022461 7.050000190734863,10.470999717712402 6.934000015258789,10.517999649047852 C6.934000015258789,10.517999649047852 8.923999786376953,9.720999717712402 8.923999786376953,9.720999717712402 C8.923999786376953,9.720999717712402 6.019000053405762,-3.0859999656677246 6.019000053405762,-3.0859999656677246 C6.019000053405762,-3.0859999656677246 5.682000160217285,-3.2070000171661377 5.682000160217285,-3.2070000171661377 C5.422999858856201,-3.299999952316284 5.1539998054504395,-3.625 5.085000038146973,-3.927999973297119 C5.085000038146973,-3.927999973297119 5.083000183105469,-3.9260001182556152 5.083000183105469,-3.9260001182556152z">
                                                    </path>
                                                    <path stroke-linecap="round" stroke-linejoin="round"
                                                        fill-opacity="0" stroke="rgb(46,204,255)" stroke-opacity="1"
                                                        stroke-width="0.5"
                                                        d=" M5.083000183105469,-3.9260001182556152 C5.083000183105469,-3.9260001182556152 4.9029998779296875,-4.7179999351501465 4.9029998779296875,-4.7179999351501465 C4.835000038146973,-5.019999980926514 4.567999839782715,-5.343999862670898 4.309000015258789,-5.436999797821045 C4.309000015258789,-5.436999797821045 2.0190000534057617,-6.263999938964844 2.0190000534057617,-6.263999938964844 C1.7610000371932983,-6.35699987411499 1.4930000305175781,-6.683000087738037 1.4240000247955322,-6.985000133514404 C1.4240000247955322,-6.985000133514404 1.24399995803833,-7.776000022888184 1.24399995803833,-7.776000022888184 C1.1759999990463257,-8.079000473022461 0.9079999923706055,-8.404000282287598 0.6489999890327454,-8.496999740600586 C0.6489999890327454,-8.496999740600586 -4.869999885559082,-10.491999626159668 -4.869999885559082,-10.491999626159668 C-4.956999778747559,-10.52400016784668 -5.0320000648498535,-10.524999618530273 -5.091000080108643,-10.50100040435791 C-5.091000080108643,-10.50100040435791 -8.923999786376953,-8.968000411987305 -8.923999786376953,-8.968000411987305 C-8.864999771118164,-8.991999626159668 -8.789999961853027,-8.991000175476074 -8.70199966430664,-8.958999633789062 C-8.70199966430664,-8.958999633789062 -3.181999921798706,-6.964000225067139 -3.181999921798706,-6.964000225067139 C-2.9230000972747803,-6.870999813079834 -2.6540000438690186,-6.546000003814697 -2.5869998931884766,-6.243000030517578 C-2.5869998931884766,-6.243000030517578 -2.4070000648498535,-5.453000068664551 -2.4070000648498535,-5.453000068664551 C-2.3380000591278076,-5.150000095367432 -2.071000099182129,-4.823999881744385 -1.812000036239624,-4.730999946594238 C-1.812000036239624,-4.730999946594238 0.4779999852180481,-3.9030001163482666 0.4779999852180481,-3.9030001163482666 C0.7360000014305115,-3.809999942779541 1.003999948501587,-3.484999895095825 1.0720000267028809,-3.184999942779541 C1.0720000267028809,-3.184999942779541 1.2519999742507935,-2.3940000534057617 1.2519999742507935,-2.3940000534057617 C1.3200000524520874,-2.0910000801086426 1.5880000591278076,-1.7669999599456787 1.8480000495910645,-1.6720000505447388 C1.8480000495910645,-1.6720000505447388 2.5239999294281006,-1.4279999732971191 2.5239999294281006,-1.4279999732971191 C2.7820000648498535,-1.3350000381469727 3.049999952316284,-1.0089999437332153 3.11899995803833,-0.7059999704360962 C3.11899995803833,-0.7059999704360962 3.7269999980926514,1.9759999513626099 3.7269999980926514,1.9759999513626099 C3.7960000038146973,2.2790000438690186 4.063000202178955,2.6029999256134033 4.321000099182129,2.694999933242798 C4.321000099182129,2.694999933242798 4.995999813079834,2.940000057220459 4.995999813079834,2.940000057220459 C5.255000114440918,3.0329999923706055 5.5229997634887695,3.3589999675750732 5.590000152587891,3.6589999198913574 C5.590000152587891,3.6589999198913574 7.058000087738037,10.126999855041504 7.058000087738037,10.126999855041504 C7.104000091552734,10.329000473022461 7.050000190734863,10.470999717712402 6.934000015258789,10.517999649047852 C6.934000015258789,10.517999649047852 8.923999786376953,9.720999717712402 8.923999786376953,9.720999717712402 C8.923999786376953,9.720999717712402 6.019000053405762,-3.0859999656677246 6.019000053405762,-3.0859999656677246 C6.019000053405762,-3.0859999656677246 5.682000160217285,-3.2070000171661377 5.682000160217285,-3.2070000171661377 C5.422999858856201,-3.299999952316284 5.1539998054504395,-3.625 5.085000038146973,-3.927999973297119 C5.085000038146973,-3.927999973297119 5.083000183105469,-3.9260001182556152 5.083000183105469,-3.9260001182556152z">
                                                    </path>
                                                </g>
                                                <g opacity="1"
                                                    transform="matrix(1,0,0,1,4.5929999351501465,-29.988000869750977)">
                                                    <path fill="rgb(27,27,27)" fill-opacity="1"
                                                        d=" M-0.20000000298023224,3.3980000019073486 C-0.15399999916553497,3.5989999771118164 -0.20800000429153442,3.742000102996826 -0.3230000138282776,3.7890000343322754 C-0.3230000138282776,3.7890000343322754 1.6670000553131104,2.993000030517578 1.6670000553131104,2.993000030517578 C1.6670000553131104,2.993000030517578 0.12800000607967377,-3.7890000343322754 0.12800000607967377,-3.7890000343322754 C0.12800000607967377,-3.7890000343322754 -1.6670000553131104,-3.071000099182129 -1.6670000553131104,-3.071000099182129 C-1.6670000553131104,-3.071000099182129 -0.19900000095367432,3.3970000743865967 -0.19900000095367432,3.3970000743865967 C-0.19900000095367432,3.3970000743865967 -0.20000000298023224,3.3980000019073486 -0.20000000298023224,3.3980000019073486z">
                                                    </path>
                                                    <path stroke-linecap="round" stroke-linejoin="round"
                                                        fill-opacity="0" stroke="rgb(46,204,255)" stroke-opacity="1"
                                                        stroke-width="0.5"
                                                        d=" M-0.20000000298023224,3.3980000019073486 C-0.15399999916553497,3.5989999771118164 -0.20800000429153442,3.742000102996826 -0.3230000138282776,3.7890000343322754 C-0.3230000138282776,3.7890000343322754 1.6670000553131104,2.993000030517578 1.6670000553131104,2.993000030517578 C1.6670000553131104,2.993000030517578 0.12800000607967377,-3.7890000343322754 0.12800000607967377,-3.7890000343322754 C0.12800000607967377,-3.7890000343322754 -1.6670000553131104,-3.071000099182129 -1.6670000553131104,-3.071000099182129 C-1.6670000553131104,-3.071000099182129 -0.19900000095367432,3.3970000743865967 -0.19900000095367432,3.3970000743865967 C-0.19900000095367432,3.3970000743865967 -0.20000000298023224,3.3980000019073486 -0.20000000298023224,3.3980000019073486z">
                                                    </path>
                                                </g>
                                                <g opacity="1"
                                                    transform="matrix(1,0,0,1,-2.946000099182129,-42.97200012207031)">
                                                    <path fill="rgb(27,27,27)" fill-opacity="1"
                                                        d=" M1.7089999914169312,-0.7319999933242798 C1.7089999914169312,-0.7319999933242798 1.5290000438690186,-1.5219999551773071 1.5290000438690186,-1.5219999551773071 C1.5290000438690186,-1.5219999551773071 -2.303999900817871,0.010999999940395355 -2.303999900817871,0.010999999940395355 C-2.303999900817871,0.010999999940395355 -2.124000072479248,0.8009999990463257 -2.124000072479248,0.8009999990463257 C-2.055000066757202,1.1039999723434448 -1.7869999408721924,1.4299999475479126 -1.5290000438690186,1.5219999551773071 C-1.5290000438690186,1.5219999551773071 2.303999900817871,-0.010999999940395355 2.303999900817871,-0.010999999940395355 C2.0450000762939453,-0.10400000214576721 1.7769999504089355,-0.42899999022483826 1.7089999914169312,-0.7319999933242798z">
                                                    </path>
                                                    <path stroke-linecap="round" stroke-linejoin="round"
                                                        fill-opacity="0" stroke="rgb(46,204,255)" stroke-opacity="1"
                                                        stroke-width="0.5"
                                                        d=" M1.7089999914169312,-0.7319999933242798 C1.7089999914169312,-0.7319999933242798 1.5290000438690186,-1.5219999551773071 1.5290000438690186,-1.5219999551773071 C1.5290000438690186,-1.5219999551773071 -2.303999900817871,0.010999999940395355 -2.303999900817871,0.010999999940395355 C-2.303999900817871,0.010999999940395355 -2.124000072479248,0.8009999990463257 -2.124000072479248,0.8009999990463257 C-2.055000066757202,1.1039999723434448 -1.7869999408721924,1.4299999475479126 -1.5290000438690186,1.5219999551773071 C-1.5290000438690186,1.5219999551773071 2.303999900817871,-0.010999999940395355 2.303999900817871,-0.010999999940395355 C2.0450000762939453,-0.10400000214576721 1.7769999504089355,-0.42899999022483826 1.7089999914169312,-0.7319999933242798z">
                                                    </path>
                                                </g>
                                                <g opacity="1"
                                                    transform="matrix(1,0,0,1,0.7120000123977661,-39.9109992980957)">
                                                    <path fill="rgb(27,27,27)" fill-opacity="1"
                                                        d=" M1.7079999446868896,-0.7319999933242798 C1.7079999446868896,-0.7319999933242798 1.527999997138977,-1.5219999551773071 1.527999997138977,-1.5219999551773071 C1.527999997138977,-1.5219999551773071 -2.303999900817871,0.009999999776482582 -2.303999900817871,0.009999999776482582 C-2.303999900817871,0.009999999776482582 -2.125,0.8009999990463257 -2.125,0.8009999990463257 C-2.055999994277954,1.1039999723434448 -1.7890000343322754,1.4279999732971191 -1.527999997138977,1.5219999551773071 C-1.527999997138977,1.5219999551773071 2.303999900817871,-0.010999999940395355 2.303999900817871,-0.010999999940395355 C2.0460000038146973,-0.10400000214576721 1.7769999504089355,-0.42899999022483826 1.7079999446868896,-0.7319999933242798z">
                                                    </path>
                                                    <path stroke-linecap="round" stroke-linejoin="round"
                                                        fill-opacity="0" stroke="rgb(46,204,255)" stroke-opacity="1"
                                                        stroke-width="0.5"
                                                        d=" M1.7079999446868896,-0.7319999933242798 C1.7079999446868896,-0.7319999933242798 1.527999997138977,-1.5219999551773071 1.527999997138977,-1.5219999551773071 C1.527999997138977,-1.5219999551773071 -2.303999900817871,0.009999999776482582 -2.303999900817871,0.009999999776482582 C-2.303999900817871,0.009999999776482582 -2.125,0.8009999990463257 -2.125,0.8009999990463257 C-2.055999994277954,1.1039999723434448 -1.7890000343322754,1.4279999732971191 -1.527999997138977,1.5219999551773071 C-1.527999997138977,1.5219999551773071 2.303999900817871,-0.010999999940395355 2.303999900817871,-0.010999999940395355 C2.0460000038146973,-0.10400000214576721 1.7769999504089355,-0.42899999022483826 1.7079999446868896,-0.7319999933242798z">
                                                    </path>
                                                </g>
                                                <g opacity="1"
                                                    transform="matrix(1,0,0,1,-9.092000007629395,-37.03900146484375)">
                                                    <path fill="rgb(27,27,27)" fill-opacity="1"
                                                        d=" M-0.9470000267028809,-2.75600004196167 C-0.9470000267028809,-2.75600004196167 -0.9459999799728394,-2.755000114440918 -0.9459999799728394,-2.755000114440918 C-0.9459999799728394,-2.755000114440918 -0.2709999978542328,-2.510999917984009 -0.2709999978542328,-2.510999917984009 C-0.2709999978542328,-2.510999917984009 -0.27000001072883606,-2.510999917984009 -0.27000001072883606,-2.510999917984009 C-0.15800000727176666,-2.4700000286102295 -0.006000000052154064,-2.319000005722046 0.06300000101327896,-2.13700008392334 C0.06300000101327896,-2.13700008392334 0.08699999749660492,-2.058000087738037 0.08699999749660492,-2.058000087738037 C0.08699999749660492,-2.058000087738037 0.39100000262260437,-0.7149999737739563 0.39100000262260437,-0.7149999737739563 C0.39100000262260437,-0.7149999737739563 0.8199999928474426,1.1759999990463257 0.8199999928474426,1.1759999990463257 C0.8199999928474426,1.1759999990463257 1.125,2.5179998874664307 1.125,2.5179998874664307 C1.1670000553131104,2.703000068664551 1.0859999656677246,2.7790000438690186 0.9890000224113464,2.7660000324249268 C0.9890000224113464,2.7660000324249268 0.9459999799728394,2.75600004196167 0.9459999799728394,2.75600004196167 C0.9459999799728394,2.75600004196167 0.2709999978542328,2.510999917984009 0.2709999978542328,2.510999917984009 C0.2709999978542328,2.510999917984009 0.27000001072883606,2.510999917984009 0.27000001072883606,2.510999917984009 C0.15800000727176666,2.4709999561309814 0.006000000052154064,2.319000005722046 -0.06300000101327896,2.13700008392334 C-0.06300000101327896,2.13700008392334 -0.08799999952316284,2.056999921798706 -0.08799999952316284,2.056999921798706 C-0.08799999952316284,2.056999921798706 -0.3919999897480011,0.7139999866485596 -0.3919999897480011,0.7139999866485596 C-0.3919999897480011,0.7139999866485596 -0.8209999799728394,-1.1770000457763672 -0.8209999799728394,-1.1770000457763672 C-0.8209999799728394,-1.1770000457763672 -1.125,-2.5190000534057617 -1.125,-2.5190000534057617 C-1.1720000505447388,-2.7279999256134033 -1.062000036239624,-2.796999931335449 -0.9470000267028809,-2.75600004196167z">
                                                    </path>
                                                    <path stroke-linecap="butt" stroke-linejoin="miter" fill-opacity="0"
                                                        stroke-miterlimit="4" stroke="rgb(46,204,255)"
                                                        stroke-opacity="1" stroke-width="0.5"
                                                        d=" M-0.9470000267028809,-2.75600004196167 C-0.9470000267028809,-2.75600004196167 -0.9459999799728394,-2.755000114440918 -0.9459999799728394,-2.755000114440918 C-0.9459999799728394,-2.755000114440918 -0.2709999978542328,-2.510999917984009 -0.2709999978542328,-2.510999917984009 C-0.2709999978542328,-2.510999917984009 -0.27000001072883606,-2.510999917984009 -0.27000001072883606,-2.510999917984009 C-0.15800000727176666,-2.4700000286102295 -0.006000000052154064,-2.319000005722046 0.06300000101327896,-2.13700008392334 C0.06300000101327896,-2.13700008392334 0.08699999749660492,-2.058000087738037 0.08699999749660492,-2.058000087738037 C0.08699999749660492,-2.058000087738037 0.39100000262260437,-0.7149999737739563 0.39100000262260437,-0.7149999737739563 C0.39100000262260437,-0.7149999737739563 0.8199999928474426,1.1759999990463257 0.8199999928474426,1.1759999990463257 C0.8199999928474426,1.1759999990463257 1.125,2.5179998874664307 1.125,2.5179998874664307 C1.1670000553131104,2.703000068664551 1.0859999656677246,2.7790000438690186 0.9890000224113464,2.7660000324249268 C0.9890000224113464,2.7660000324249268 0.9459999799728394,2.75600004196167 0.9459999799728394,2.75600004196167 C0.9459999799728394,2.75600004196167 0.2709999978542328,2.510999917984009 0.2709999978542328,2.510999917984009 C0.2709999978542328,2.510999917984009 0.27000001072883606,2.510999917984009 0.27000001072883606,2.510999917984009 C0.15800000727176666,2.4709999561309814 0.006000000052154064,2.319000005722046 -0.06300000101327896,2.13700008392334 C-0.06300000101327896,2.13700008392334 -0.08799999952316284,2.056999921798706 -0.08799999952316284,2.056999921798706 C-0.08799999952316284,2.056999921798706 -0.3919999897480011,0.7139999866485596 -0.3919999897480011,0.7139999866485596 C-0.3919999897480011,0.7139999866485596 -0.8209999799728394,-1.1770000457763672 -0.8209999799728394,-1.1770000457763672 C-0.8209999799728394,-1.1770000457763672 -1.125,-2.5190000534057617 -1.125,-2.5190000534057617 C-1.1720000505447388,-2.7279999256134033 -1.062000036239624,-2.796999931335449 -0.9470000267028809,-2.75600004196167z">
                                                    </path>
                                                </g>
                                                <g opacity="1"
                                                    transform="matrix(1,0,0,1,-4.250999927520752,-35.2869987487793)">
                                                    <path fill="rgb(27,27,27)" fill-opacity="1"
                                                        d=" M-0.9440000057220459,-2.755000114440918 C-0.9440000057220459,-2.755000114440918 -0.27000001072883606,-2.51200008392334 -0.27000001072883606,-2.51200008392334 C-0.27000001072883606,-2.51200008392334 -0.27000001072883606,-2.513000011444092 -0.27000001072883606,-2.513000011444092 C-0.1550000011920929,-2.4700000286102295 -0.004999999888241291,-2.319000005722046 0.06300000101327896,-2.1389999389648438 C0.06300000101327896,-2.1389999389648438 0.08699999749660492,-2.059000015258789 0.08699999749660492,-2.059000015258789 C0.08699999749660492,-2.059000015258789 0.3919999897480011,-0.7170000076293945 0.3919999897480011,-0.7170000076293945 C0.3919999897480011,-0.7170000076293945 0.8209999799728394,1.1749999523162842 0.8209999799728394,1.1749999523162842 C0.8209999799728394,1.1749999523162842 1.125,2.5160000324249268 1.125,2.5160000324249268 C1.125,2.5160000324249268 1.125,2.5169999599456787 1.125,2.5169999599456787 C1.1670000553131104,2.703000068664551 1.0859999656677246,2.7769999504089355 0.9869999885559082,2.765000104904175 C0.9869999885559082,2.765000104904175 0.9449999928474426,2.753999948501587 0.9449999928474426,2.753999948501587 C0.9449999928474426,2.753999948501587 0.27000001072883606,2.510999917984009 0.27000001072883606,2.510999917984009 C0.15800000727176666,2.4709999561309814 0.004999999888241291,2.319999933242798 -0.06400000303983688,2.13700008392334 C-0.06400000303983688,2.13700008392334 -0.08799999952316284,2.058000087738037 -0.08799999952316284,2.058000087738037 C-0.08799999952316284,2.058000087738037 -0.08799999952316284,2.056999921798706 -0.08799999952316284,2.056999921798706 C-0.08799999952316284,2.056999921798706 -0.3930000066757202,0.7149999737739563 -0.3930000066757202,0.7149999737739563 C-0.3930000066757202,0.7149999737739563 -0.8209999799728394,-1.1759999990463257 -0.8209999799728394,-1.1759999990463257 C-0.8209999799728394,-1.1759999990463257 -0.8209999799728394,-1.1770000457763672 -0.8209999799728394,-1.1770000457763672 C-0.8209999799728394,-1.1770000457763672 -1.125,-2.5179998874664307 -1.125,-2.5179998874664307 C-1.1670000553131104,-2.703000068664551 -1.0870000123977661,-2.7769999504089355 -0.9879999756813049,-2.765000104904175 C-0.9879999756813049,-2.765000104904175 -0.9440000057220459,-2.755000114440918 -0.9440000057220459,-2.755000114440918z">
                                                    </path>
                                                    <path stroke-linecap="butt" stroke-linejoin="miter" fill-opacity="0"
                                                        stroke-miterlimit="4" stroke="rgb(46,204,255)"
                                                        stroke-opacity="1" stroke-width="0.5"
                                                        d=" M-0.9440000057220459,-2.755000114440918 C-0.9440000057220459,-2.755000114440918 -0.27000001072883606,-2.51200008392334 -0.27000001072883606,-2.51200008392334 C-0.27000001072883606,-2.51200008392334 -0.27000001072883606,-2.513000011444092 -0.27000001072883606,-2.513000011444092 C-0.1550000011920929,-2.4700000286102295 -0.004999999888241291,-2.319000005722046 0.06300000101327896,-2.1389999389648438 C0.06300000101327896,-2.1389999389648438 0.08699999749660492,-2.059000015258789 0.08699999749660492,-2.059000015258789 C0.08699999749660492,-2.059000015258789 0.3919999897480011,-0.7170000076293945 0.3919999897480011,-0.7170000076293945 C0.3919999897480011,-0.7170000076293945 0.8209999799728394,1.1749999523162842 0.8209999799728394,1.1749999523162842 C0.8209999799728394,1.1749999523162842 1.125,2.5160000324249268 1.125,2.5160000324249268 C1.125,2.5160000324249268 1.125,2.5169999599456787 1.125,2.5169999599456787 C1.1670000553131104,2.703000068664551 1.0859999656677246,2.7769999504089355 0.9869999885559082,2.765000104904175 C0.9869999885559082,2.765000104904175 0.9449999928474426,2.753999948501587 0.9449999928474426,2.753999948501587 C0.9449999928474426,2.753999948501587 0.27000001072883606,2.510999917984009 0.27000001072883606,2.510999917984009 C0.15800000727176666,2.4709999561309814 0.004999999888241291,2.319999933242798 -0.06400000303983688,2.13700008392334 C-0.06400000303983688,2.13700008392334 -0.08799999952316284,2.058000087738037 -0.08799999952316284,2.058000087738037 C-0.08799999952316284,2.058000087738037 -0.08799999952316284,2.056999921798706 -0.08799999952316284,2.056999921798706 C-0.08799999952316284,2.056999921798706 -0.3930000066757202,0.7149999737739563 -0.3930000066757202,0.7149999737739563 C-0.3930000066757202,0.7149999737739563 -0.8209999799728394,-1.1759999990463257 -0.8209999799728394,-1.1759999990463257 C-0.8209999799728394,-1.1759999990463257 -0.8209999799728394,-1.1770000457763672 -0.8209999799728394,-1.1770000457763672 C-0.8209999799728394,-1.1770000457763672 -1.125,-2.5179998874664307 -1.125,-2.5179998874664307 C-1.1670000553131104,-2.703000068664551 -1.0870000123977661,-2.7769999504089355 -0.9879999756813049,-2.765000104904175 C-0.9879999756813049,-2.765000104904175 -0.9440000057220459,-2.755000114440918 -0.9440000057220459,-2.755000114440918z">
                                                    </path>
                                                </g>
                                                <g opacity="1"
                                                    transform="matrix(1,0,0,1,-9.390999794006348,-31.9060001373291)">
                                                    <path fill="rgb(27,27,27)" fill-opacity="1"
                                                        d=" M-0.550000011920929,-0.9039999842643738 C-0.550000011920929,-0.9039999842643738 -0.5490000247955322,-0.902999997138977 -0.5490000247955322,-0.902999997138977 C-0.5490000247955322,-0.902999997138977 0.12600000202655792,-0.6579999923706055 0.12600000202655792,-0.6579999923706055 C0.12600000202655792,-0.6579999923706055 0.1459999978542328,-0.6520000100135803 0.1459999978542328,-0.6520000100135803 C0.2549999952316284,-0.6029999852180481 0.39500001072883606,-0.4580000042915344 0.460999995470047,-0.2849999964237213 C0.460999995470047,-0.2849999964237213 0.48500001430511475,-0.20499999821186066 0.48500001430511475,-0.20499999821186066 C0.48500001430511475,-0.20499999821186066 0.7390000224113464,0.9150000214576721 0.7390000224113464,0.9150000214576721 C0.7390000224113464,0.9150000214576721 -0.19099999964237213,0.578000009059906 -0.19099999964237213,0.578000009059906 C-0.19099999964237213,0.578000009059906 -0.2409999966621399,0.5550000071525574 -0.2409999966621399,0.5550000071525574 C-0.3449999988079071,0.49399998784065247 -0.4650000035762787,0.36000001430511475 -0.5239999890327454,0.2029999941587448 C-0.5239999890327454,0.2029999941587448 -0.5490000247955322,0.12300000339746475 -0.5490000247955322,0.12300000339746475 C-0.5490000247955322,0.12300000339746475 -0.7279999852180481,-0.6660000085830688 -0.7279999852180481,-0.6660000085830688 C-0.7749999761581421,-0.8769999742507935 -0.6650000214576721,-0.9449999928474426 -0.550000011920929,-0.9039999842643738z">
                                                    </path>
                                                    <path stroke-linecap="butt" stroke-linejoin="miter" fill-opacity="0"
                                                        stroke-miterlimit="4" stroke="rgb(46,204,255)"
                                                        stroke-opacity="1" stroke-width="0.5"
                                                        d=" M-0.550000011920929,-0.9039999842643738 C-0.550000011920929,-0.9039999842643738 -0.5490000247955322,-0.902999997138977 -0.5490000247955322,-0.902999997138977 C-0.5490000247955322,-0.902999997138977 0.12600000202655792,-0.6579999923706055 0.12600000202655792,-0.6579999923706055 C0.12600000202655792,-0.6579999923706055 0.1459999978542328,-0.6520000100135803 0.1459999978542328,-0.6520000100135803 C0.2549999952316284,-0.6029999852180481 0.39500001072883606,-0.4580000042915344 0.460999995470047,-0.2849999964237213 C0.460999995470047,-0.2849999964237213 0.48500001430511475,-0.20499999821186066 0.48500001430511475,-0.20499999821186066 C0.48500001430511475,-0.20499999821186066 0.7390000224113464,0.9150000214576721 0.7390000224113464,0.9150000214576721 C0.7390000224113464,0.9150000214576721 -0.19099999964237213,0.578000009059906 -0.19099999964237213,0.578000009059906 C-0.19099999964237213,0.578000009059906 -0.2409999966621399,0.5550000071525574 -0.2409999966621399,0.5550000071525574 C-0.3449999988079071,0.49399998784065247 -0.4650000035762787,0.36000001430511475 -0.5239999890327454,0.2029999941587448 C-0.5239999890327454,0.2029999941587448 -0.5490000247955322,0.12300000339746475 -0.5490000247955322,0.12300000339746475 C-0.5490000247955322,0.12300000339746475 -0.7279999852180481,-0.6660000085830688 -0.7279999852180481,-0.6660000085830688 C-0.7749999761581421,-0.8769999742507935 -0.6650000214576721,-0.9449999928474426 -0.550000011920929,-0.9039999842643738z">
                                                    </path>
                                                </g>
                                                <g opacity="1"
                                                    transform="matrix(1,0,0,1,-4.986999988555908,-28.631999969482422)">
                                                    <path fill="rgb(27,27,27)" fill-opacity="1"
                                                        d=" M-1.7630000114440918,-1.284999966621399 C-1.7630000114440918,-1.284999966621399 -0.1940000057220459,-0.7179999947547913 -0.1940000057220459,-0.7179999947547913 C-0.1940000057220459,-0.7179999947547913 -0.19099999964237213,-0.7149999737739563 -0.19099999964237213,-0.7149999737739563 C-0.19099999964237213,-0.7149999737739563 -0.1459999978542328,-0.6990000009536743 -0.1459999978542328,-0.6990000009536743 C-0.1459999978542328,-0.6990000009536743 1.468000054359436,-0.11699999868869781 1.468000054359436,-0.11699999868869781 C1.468000054359436,-0.11699999868869781 1.4670000076293945,-0.11800000071525574 1.4670000076293945,-0.11800000071525574 C1.4670000076293945,-0.11800000071525574 2.8910000324249268,0.39800000190734863 2.8910000324249268,0.39800000190734863 C2.8910000324249268,0.39800000190734863 3.1510000228881836,1.5429999828338623 3.1510000228881836,1.5429999828338623 C3.1989998817443848,1.753000020980835 3.0869998931884766,1.8209999799728394 2.9700000286102295,1.7790000438690186 C2.9700000286102295,1.7790000438690186 2.9709999561309814,1.7790000438690186 2.9709999561309814,1.7790000438690186 C2.9709999561309814,1.7790000438690186 1.8250000476837158,1.3639999628067017 1.8250000476837158,1.3639999628067017 C1.8250000476837158,1.3639999628067017 1.8240000009536743,1.3650000095367432 1.8240000009536743,1.3650000095367432 C1.8240000009536743,1.3650000095367432 0.210999995470047,0.781000018119812 0.210999995470047,0.781000018119812 C0.210999995470047,0.781000018119812 0.21199999749660492,0.781000018119812 0.21199999749660492,0.781000018119812 C0.21199999749660492,0.781000018119812 -1.4040000438690186,0.19699999690055847 -1.4040000438690186,0.19699999690055847 C-1.4040000438690186,0.19699999690055847 -2.549999952316284,-0.21799999475479126 -2.549999952316284,-0.21799999475479126 C-2.549999952316284,-0.21799999475479126 -2.549999952316284,-0.21799999475479126 -2.549999952316284,-0.21799999475479126 C-2.549999952316284,-0.21799999475479126 -2.6010000705718994,-0.24199999868869781 -2.6010000705718994,-0.24199999868869781 C-2.7039999961853027,-0.3019999861717224 -2.8239998817443848,-0.4350000023841858 -2.882999897003174,-0.5910000205039978 C-2.882999897003174,-0.5910000205039978 -2.9070000648498535,-0.6700000166893005 -2.9070000648498535,-0.6700000166893005 C-2.9070000648498535,-0.6700000166893005 -3.1619999408721924,-1.7910000085830688 -3.1619999408721924,-1.7910000085830688 C-3.1619999408721924,-1.7910000085830688 -1.7630000114440918,-1.284999966621399 -1.7630000114440918,-1.284999966621399z">
                                                    </path>
                                                    <path stroke-linecap="butt" stroke-linejoin="miter" fill-opacity="0"
                                                        stroke-miterlimit="4" stroke="rgb(46,204,255)"
                                                        stroke-opacity="1" stroke-width="0.5"
                                                        d=" M-1.7630000114440918,-1.284999966621399 C-1.7630000114440918,-1.284999966621399 -0.1940000057220459,-0.7179999947547913 -0.1940000057220459,-0.7179999947547913 C-0.1940000057220459,-0.7179999947547913 -0.19099999964237213,-0.7149999737739563 -0.19099999964237213,-0.7149999737739563 C-0.19099999964237213,-0.7149999737739563 -0.1459999978542328,-0.6990000009536743 -0.1459999978542328,-0.6990000009536743 C-0.1459999978542328,-0.6990000009536743 1.468000054359436,-0.11699999868869781 1.468000054359436,-0.11699999868869781 C1.468000054359436,-0.11699999868869781 1.4670000076293945,-0.11800000071525574 1.4670000076293945,-0.11800000071525574 C1.4670000076293945,-0.11800000071525574 2.8910000324249268,0.39800000190734863 2.8910000324249268,0.39800000190734863 C2.8910000324249268,0.39800000190734863 3.1510000228881836,1.5429999828338623 3.1510000228881836,1.5429999828338623 C3.1989998817443848,1.753000020980835 3.0869998931884766,1.8209999799728394 2.9700000286102295,1.7790000438690186 C2.9700000286102295,1.7790000438690186 2.9709999561309814,1.7790000438690186 2.9709999561309814,1.7790000438690186 C2.9709999561309814,1.7790000438690186 1.8250000476837158,1.3639999628067017 1.8250000476837158,1.3639999628067017 C1.8250000476837158,1.3639999628067017 1.8240000009536743,1.3650000095367432 1.8240000009536743,1.3650000095367432 C1.8240000009536743,1.3650000095367432 0.210999995470047,0.781000018119812 0.210999995470047,0.781000018119812 C0.210999995470047,0.781000018119812 0.21199999749660492,0.781000018119812 0.21199999749660492,0.781000018119812 C0.21199999749660492,0.781000018119812 -1.4040000438690186,0.19699999690055847 -1.4040000438690186,0.19699999690055847 C-1.4040000438690186,0.19699999690055847 -2.549999952316284,-0.21799999475479126 -2.549999952316284,-0.21799999475479126 C-2.549999952316284,-0.21799999475479126 -2.549999952316284,-0.21799999475479126 -2.549999952316284,-0.21799999475479126 C-2.549999952316284,-0.21799999475479126 -2.6010000705718994,-0.24199999868869781 -2.6010000705718994,-0.24199999868869781 C-2.7039999961853027,-0.3019999861717224 -2.8239998817443848,-0.4350000023841858 -2.882999897003174,-0.5910000205039978 C-2.882999897003174,-0.5910000205039978 -2.9070000648498535,-0.6700000166893005 -2.9070000648498535,-0.6700000166893005 C-2.9070000648498535,-0.6700000166893005 -3.1619999408721924,-1.7910000085830688 -3.1619999408721924,-1.7910000085830688 C-3.1619999408721924,-1.7910000085830688 -1.7630000114440918,-1.284999966621399 -1.7630000114440918,-1.284999966621399z">
                                                    </path>
                                                </g>
                                                <g opacity="1"
                                                    transform="matrix(1,0,0,1,-1.3489999771118164,-29.02899932861328)">
                                                    <path fill="rgb(27,27,27)" fill-opacity="1"
                                                        d=" M-0.5180000066757202,-0.8650000095367432 C-0.5180000066757202,-0.8650000095367432 -0.5180000066757202,-0.8640000224113464 -0.5180000066757202,-0.8640000224113464 C-0.5180000066757202,-0.8640000224113464 0.01600000075995922,-0.6710000038146973 0.01600000075995922,-0.6710000038146973 C0.01600000075995922,-0.6710000038146973 0.017000000923871994,-0.6679999828338623 0.017000000923871994,-0.6679999828338623 C0.017000000923871994,-0.6679999828338623 0.1599999964237213,-0.6169999837875366 0.1599999964237213,-0.6169999837875366 C0.2720000147819519,-0.574999988079071 0.42399999499320984,-0.42399999499320984 0.49300000071525574,-0.24199999868869781 C0.49300000071525574,-0.24199999868869781 0.5180000066757202,-0.16300000250339508 0.5180000066757202,-0.16300000250339508 C0.5180000066757202,-0.16300000250339508 0.6959999799728394,0.6259999871253967 0.6959999799728394,0.6259999871253967 C0.7440000176429749,0.8379999995231628 0.6320000290870667,0.9049999713897705 0.5170000195503235,0.8640000224113464 C0.5170000195503235,0.8640000224113464 0.515999972820282,0.8640000224113464 0.515999972820282,0.8640000224113464 C0.515999972820282,0.8640000224113464 -0.43700000643730164,0.5189999938011169 -0.43700000643730164,0.5189999938011169 C-0.43700000643730164,0.5189999938011169 -0.6959999799728394,-0.6259999871253967 -0.6959999799728394,-0.6259999871253967 C-0.7440000176429749,-0.8370000123977661 -0.6330000162124634,-0.9049999713897705 -0.5180000066757202,-0.8650000095367432z">
                                                    </path>
                                                    <path stroke-linecap="butt" stroke-linejoin="miter" fill-opacity="0"
                                                        stroke-miterlimit="4" stroke="rgb(46,204,255)"
                                                        stroke-opacity="1" stroke-width="0.5"
                                                        d=" M-0.5180000066757202,-0.8650000095367432 C-0.5180000066757202,-0.8650000095367432 -0.5180000066757202,-0.8640000224113464 -0.5180000066757202,-0.8640000224113464 C-0.5180000066757202,-0.8640000224113464 0.01600000075995922,-0.6710000038146973 0.01600000075995922,-0.6710000038146973 C0.01600000075995922,-0.6710000038146973 0.017000000923871994,-0.6679999828338623 0.017000000923871994,-0.6679999828338623 C0.017000000923871994,-0.6679999828338623 0.1599999964237213,-0.6169999837875366 0.1599999964237213,-0.6169999837875366 C0.2720000147819519,-0.574999988079071 0.42399999499320984,-0.42399999499320984 0.49300000071525574,-0.24199999868869781 C0.49300000071525574,-0.24199999868869781 0.5180000066757202,-0.16300000250339508 0.5180000066757202,-0.16300000250339508 C0.5180000066757202,-0.16300000250339508 0.6959999799728394,0.6259999871253967 0.6959999799728394,0.6259999871253967 C0.7440000176429749,0.8379999995231628 0.6320000290870667,0.9049999713897705 0.5170000195503235,0.8640000224113464 C0.5170000195503235,0.8640000224113464 0.515999972820282,0.8640000224113464 0.515999972820282,0.8640000224113464 C0.515999972820282,0.8640000224113464 -0.43700000643730164,0.5189999938011169 -0.43700000643730164,0.5189999938011169 C-0.43700000643730164,0.5189999938011169 -0.6959999799728394,-0.6259999871253967 -0.6959999799728394,-0.6259999871253967 C-0.7440000176429749,-0.8370000123977661 -0.6330000162124634,-0.9049999713897705 -0.5180000066757202,-0.8650000095367432z">
                                                    </path>
                                                </g>
                                                <g opacity="1"
                                                    transform="matrix(1,0,0,1,-10.348999977111816,-35.67399978637695)">
                                                    <path fill="url(#__lottie_element_439)" fill-opacity="1"
                                                        d=" M-11.70199966430664,7.625999927520752 C-11.369999885559082,9.071999549865723 -9.982999801635742,10.654000282287598 -8.614999771118164,11.14900016784668 C-8.614999771118164,11.14900016784668 18.636999130249023,20.990999221801758 18.636999130249023,20.990999221801758 C18.94499969482422,21.10099983215332 19.22599983215332,21.145999908447266 19.474000930786133,21.13599967956543 C19.325000762939453,21.96299934387207 18.58799934387207,22.322999954223633 17.551000595092773,21.947999954223633 C17.551000595092773,21.947999954223633 -9.70199966430664,12.105999946594238 -9.70199966430664,12.105999946594238 C-11.069000244140625,11.614999771118164 -12.456999778747559,10.029000282287598 -12.788999557495117,8.583999633789062 C-12.788999557495117,8.583999633789062 -19.402000427246094,-20.22599983215332 -19.402000427246094,-20.22599983215332 C-19.659000396728516,-21.343000411987305 -19.20800018310547,-22.05900001525879 -18.35700035095215,-22.09600067138672 C-18.4060001373291,-21.836000442504883 -18.395000457763672,-21.52899932861328 -18.315000534057617,-21.18000030517578 C-18.315000534057617,-21.18000030517578 -11.70199966430664,7.630000114440918 -11.70199966430664,7.630000114440918 C-11.70199966430664,7.630000114440918 -11.70199966430664,7.625999927520752 -11.70199966430664,7.625999927520752z">
                                                    </path>
                                                    <path stroke-linecap="round" stroke-linejoin="round"
                                                        fill-opacity="0" stroke="rgb(4,0,255)" stroke-opacity="1"
                                                        stroke-width="0.5"
                                                        d=" M-11.70199966430664,7.625999927520752 C-11.369999885559082,9.071999549865723 -9.982999801635742,10.654000282287598 -8.614999771118164,11.14900016784668 C-8.614999771118164,11.14900016784668 18.636999130249023,20.990999221801758 18.636999130249023,20.990999221801758 C18.94499969482422,21.10099983215332 19.22599983215332,21.145999908447266 19.474000930786133,21.13599967956543 C19.325000762939453,21.96299934387207 18.58799934387207,22.322999954223633 17.551000595092773,21.947999954223633 C17.551000595092773,21.947999954223633 -9.70199966430664,12.105999946594238 -9.70199966430664,12.105999946594238 C-11.069000244140625,11.614999771118164 -12.456999778747559,10.029000282287598 -12.788999557495117,8.583999633789062 C-12.788999557495117,8.583999633789062 -19.402000427246094,-20.22599983215332 -19.402000427246094,-20.22599983215332 C-19.659000396728516,-21.343000411987305 -19.20800018310547,-22.05900001525879 -18.35700035095215,-22.09600067138672 C-18.4060001373291,-21.836000442504883 -18.395000457763672,-21.52899932861328 -18.315000534057617,-21.18000030517578 C-18.315000534057617,-21.18000030517578 -11.70199966430664,7.630000114440918 -11.70199966430664,7.630000114440918 C-11.70199966430664,7.630000114440918 -11.70199966430664,7.625999927520752 -11.70199966430664,7.625999927520752z">
                                                    </path>
                                                </g>
                                                <g opacity="1"
                                                    transform="matrix(1,0,0,1,-7.11299991607666,-21.145000457763672)">
                                                    <path fill="rgb(4,0,255)" fill-opacity="1"
                                                        d=" M-13.545999526977539,-8.581000328063965 C-13.545999526977539,-8.581000328063965 -16.434999465942383,-6.131999969482422 -16.434999465942383,-6.131999969482422 C-17.05299949645996,-5.607999801635742 -17.141000747680664,-4.644000053405762 -16.636999130249023,-3.9010000228881836 C-16.636999130249023,-3.9010000228881836 -12.777000427246094,1.7940000295639038 -12.777000427246094,1.7940000295639038 C-12.512999534606934,2.184000015258789 -12.118000030517578,2.4619998931884766 -11.680999755859375,2.563999891281128 C-11.680999755859375,2.563999891281128 15.112000465393066,8.878999710083008 15.112000465393066,8.878999710083008 C16.1200008392334,9.116000175476074 17.003000259399414,8.373000144958496 16.961999893188477,7.323999881744385 C16.961999893188477,7.323999881744385 16.884000778198242,5.331999778747559 16.884000778198242,5.331999778747559 C16.857999801635742,4.632999897003174 16.417999267578125,3.9820001125335693 15.777000427246094,3.693000078201294 C15.777000427246094,3.693000078201294 -11.90999984741211,-8.77299976348877 -11.90999984741211,-8.77299976348877 C-12.477999687194824,-9.027999877929688 -13.104999542236328,-8.954999923706055 -13.545999526977539,-8.581000328063965z">
                                                    </path>
                                                </g>
                                                <g opacity="1"
                                                    transform="matrix(1,0,0,1,-33.77399826049805,-15.199999809265137)">
                                                    <path fill="rgb(27,27,27)" fill-opacity="1"
                                                        d=" M-2.7990000247955322,-10.494000434875488 C-2.7990000247955322,-10.494000434875488 -0.3869999945163727,-9.621000289916992 -0.3869999945163727,-9.621000289916992 C0.5529999732971191,-9.284000396728516 1.5049999952316284,-8.190999984741211 1.7319999933242798,-7.202000141143799 C1.7319999933242798,-7.202000141143799 2.697000026702881,-3.005000114440918 2.697000026702881,-3.005000114440918 C2.697000026702881,-3.005000114440918 6.199999809265137,-1.7400000095367432 6.199999809265137,-1.7400000095367432 C7.139999866485596,-1.4019999504089355 8.090999603271484,-0.31299999356269836 8.319999694824219,0.6790000200271606 C8.319999694824219,0.6790000200271606 9.13700008392334,4.232999801635742 9.13700008392334,4.232999801635742 C9.260000228881836,4.769000053405762 9.144000053405762,5.168000221252441 8.866000175476074,5.373000144958496 C8.866000175476074,5.373000144958496 7.3379998207092285,6.486999988555908 7.3379998207092285,6.486999988555908 C7.3379998207092285,6.486999988555908 6.320000171661377,4.867000102996826 6.320000171661377,4.867000102996826 C6.320000171661377,4.867000102996826 4.339000225067139,4.151000022888184 4.339000225067139,4.151000022888184 C4.339000225067139,4.151000022888184 5.303999900817871,8.348999977111816 5.303999900817871,8.348999977111816 C5.427000045776367,8.88599967956543 5.311999797821045,9.28499984741211 5.0329999923706055,9.489999771118164 C5.0329999923706055,9.489999771118164 3.505000114440918,10.602999687194824 3.505000114440918,10.602999687194824 C3.505000114440918,10.602999687194824 2.5739998817443848,9.015000343322754 2.5739998817443848,9.015000343322754 C2.5739998817443848,9.015000343322754 1.5980000495910645,8.661999702453613 1.5980000495910645,8.661999702453613 C0.6579999923706055,8.324999809265137 -0.2939999997615814,7.232999801635742 -0.5220000147819519,6.24399995803833 C-0.5220000147819519,6.24399995803833 -1.4869999885559082,2.0460000038146973 -1.4869999885559082,2.0460000038146973 C-1.4869999885559082,2.0460000038146973 -4.989999771118164,0.781000018119812 -4.989999771118164,0.781000018119812 C-5.928999900817871,0.4429999887943268 -6.88100004196167,-0.6449999809265137 -7.109000205993652,-1.6369999647140503 C-7.109000205993652,-1.6369999647140503 -7.443999767303467,-3.0959999561309814 -7.443999767303467,-3.0959999561309814 C-7.443999767303467,-3.0959999561309814 -9.185999870300293,-5.2179999351501465 -9.185999870300293,-5.2179999351501465 C-9.185999870300293,-5.2179999351501465 -7.6579999923706055,-6.330999851226807 -7.6579999923706055,-6.330999851226807 C-7.421000003814697,-6.501999855041504 -7.065999984741211,-6.533999919891357 -6.635000228881836,-6.376999855041504 C-6.635000228881836,-6.376999855041504 -3.131999969482422,-5.11299991607666 -3.131999969482422,-5.11299991607666 C-3.131999969482422,-5.11299991607666 -3.6760001182556152,-7.4770002365112305 -3.6760001182556152,-7.4770002365112305 C-3.6760001182556152,-7.4770002365112305 -5.355000019073486,-9.340999603271484 -5.355000019073486,-9.340999603271484 C-5.355000019073486,-9.340999603271484 -3.8269999027252197,-10.454999923706055 -3.8269999027252197,-10.454999923706055 C-3.5910000801086426,-10.628999710083008 -3.234999895095825,-10.656999588012695 -2.803999900817871,-10.5 C-2.803999900817871,-10.5 -2.7990000247955322,-10.494000434875488 -2.7990000247955322,-10.494000434875488z">
                                                    </path>
                                                </g>
                                                <g opacity="1"
                                                    transform="matrix(1,0,0,1,-34.694000244140625,-14.559000015258789)">
                                                    <path fill="rgb(27,27,27)" fill-opacity="1"
                                                        d=" M8.331999778747559,4.739999771118164 C8.331999778747559,4.739999771118164 7.514999866485596,1.1859999895095825 7.514999866485596,1.1859999895095825 C7.4120001792907715,0.7360000014305115 7.138999938964844,0.25099998712539673 6.77400016784668,-0.16500000655651093 C6.454999923706055,-0.5289999842643738 6.077000141143799,-0.8259999752044678 5.703000068664551,-0.9980000257492065 C5.703000068664551,-0.9980000257492065 5.544000148773193,-1.0640000104904175 5.544000148773193,-1.0640000104904175 C5.544000148773193,-1.0640000104904175 2.0409998893737793,-2.328000068664551 2.0409998893737793,-2.328000068664551 C1.968000054359436,-2.3540000915527344 1.909999966621399,-2.4189999103546143 1.8919999599456787,-2.496999979019165 C1.8919999599456787,-2.496999979019165 0.9269999861717224,-6.695000171661377 0.9269999861717224,-6.695000171661377 C0.824999988079071,-7.14300012588501 0.5529999732971191,-7.629000186920166 0.1889999955892563,-8.045999526977539 C-0.12999999523162842,-8.40999984741211 -0.5080000162124634,-8.708000183105469 -0.8830000162124634,-8.878999710083008 C-0.8830000162124634,-8.878999710083008 -1.0429999828338623,-8.944000244140625 -1.0429999828338623,-8.944000244140625 C-1.0429999828338623,-8.944000244140625 -1.0429999828338623,-8.944999694824219 -1.0429999828338623,-8.944999694824219 C-1.0429999828338623,-8.944999694824219 -3.4560000896453857,-9.817999839782715 -3.4560000896453857,-9.817999839782715 C-3.880000114440918,-9.972000122070312 -4.177999973297119,-9.913000106811523 -4.3460001945495605,-9.760000228881836 C-4.513999938964844,-9.604999542236328 -4.604000091552734,-9.309000015258789 -4.500999927520752,-8.861000061035156 C-4.500999927520752,-8.861000061035156 -3.5360000133514404,-4.6620001792907715 -3.5360000133514404,-4.6620001792907715 C-3.5190000534057617,-4.589000225067139 -3.5399999618530273,-4.514999866485596 -3.5910000801086426,-4.4679999351501465 C-3.6419999599456787,-4.421999931335449 -3.7149999141693115,-4.408999919891357 -3.7839999198913574,-4.434000015258789 C-3.7839999198913574,-4.434000015258789 -7.2870001792907715,-5.697999954223633 -7.2870001792907715,-5.697999954223633 C-7.7129998207092285,-5.85099983215332 -8.01099967956543,-5.791999816894531 -8.178000450134277,-5.638999938964844 C-8.345999717712402,-5.486000061035156 -8.4350004196167,-5.190000057220459 -8.331999778747559,-4.741000175476074 C-8.331999778747559,-4.741000175476074 -7.514999866485596,-1.187000036239624 -7.514999866485596,-1.187000036239624 C-7.4120001792907715,-0.7369999885559082 -7.139999866485596,-0.25200000405311584 -6.776000022888184,0.16500000655651093 C-6.456999778747559,0.5289999842643738 -6.078999996185303,0.8259999752044678 -5.704999923706055,0.996999979019165 C-5.704999923706055,0.996999979019165 -5.544000148773193,1.062999963760376 -5.544000148773193,1.062999963760376 C-5.544000148773193,1.062999963760376 -2.0409998893737793,2.3269999027252197 -2.0409998893737793,2.3269999027252197 C-1.9859999418258667,2.3469998836517334 -1.940000057220459,2.388000011444092 -1.9129999876022339,2.440999984741211 C-1.9129999876022339,2.440999984741211 -1.8930000066757202,2.496000051498413 -1.8930000066757202,2.496000051498413 C-1.8930000066757202,2.496000051498413 -0.9279999732971191,6.695000171661377 -0.9279999732971191,6.695000171661377 C-0.824999988079071,7.142000198364258 -0.5529999732971191,7.627999782562256 -0.1889999955892563,8.045000076293945 C0.12999999523162842,8.409000396728516 0.5080000162124634,8.706999778747559 0.8830000162124634,8.878000259399414 C0.8830000162124634,8.878000259399414 1.0420000553131104,8.944000244140625 1.0420000553131104,8.944000244140625 C1.0420000553131104,8.944000244140625 1.0429999828338623,8.944000244140625 1.0429999828338623,8.944000244140625 C1.0429999828338623,8.944000244140625 3.4549999237060547,9.815999984741211 3.4549999237060547,9.815999984741211 C3.4549999237060547,9.815999984741211 3.4560000896453857,9.817999839782715 3.4560000896453857,9.817999839782715 C3.878999948501587,9.972000122070312 4.177000045776367,9.913000106811523 4.34499979019165,9.758999824523926 C4.513000011444092,9.605999946594238 4.603000164031982,9.309000015258789 4.5,8.859999656677246 C4.5,8.859999656677246 3.5350000858306885,4.6620001792907715 3.5350000858306885,4.6620001792907715 C3.5179998874664307,4.589000225067139 3.5390000343322754,4.514999866485596 3.5899999141693115,4.4679999351501465 C3.6410000324249268,4.421000003814697 3.7149999141693115,4.4079999923706055 3.7839999198913574,4.433000087738037 C3.7839999198913574,4.433000087738037 7.2870001792907715,5.697000026702881 7.2870001792907715,5.697000026702881 C7.7129998207092285,5.849999904632568 8.01099967956543,5.790999889373779 8.178000450134277,5.638000011444092 C8.345999717712402,5.485000133514404 8.4350004196167,5.189000129699707 8.331999778747559,4.739999771118164z">
                                                    </path>
                                                    <path stroke-linecap="round" stroke-linejoin="round"
                                                        fill-opacity="0" stroke="rgb(4,0,255)" stroke-opacity="1"
                                                        stroke-width="0.5"
                                                        d=" M8.331999778747559,4.739999771118164 C8.331999778747559,4.739999771118164 7.514999866485596,1.1859999895095825 7.514999866485596,1.1859999895095825 C7.4120001792907715,0.7360000014305115 7.138999938964844,0.25099998712539673 6.77400016784668,-0.16500000655651093 C6.454999923706055,-0.5289999842643738 6.077000141143799,-0.8259999752044678 5.703000068664551,-0.9980000257492065 C5.703000068664551,-0.9980000257492065 5.544000148773193,-1.0640000104904175 5.544000148773193,-1.0640000104904175 C5.544000148773193,-1.0640000104904175 2.0409998893737793,-2.328000068664551 2.0409998893737793,-2.328000068664551 C1.968000054359436,-2.3540000915527344 1.909999966621399,-2.4189999103546143 1.8919999599456787,-2.496999979019165 C1.8919999599456787,-2.496999979019165 0.9269999861717224,-6.695000171661377 0.9269999861717224,-6.695000171661377 C0.824999988079071,-7.14300012588501 0.5529999732971191,-7.629000186920166 0.1889999955892563,-8.045999526977539 C-0.12999999523162842,-8.40999984741211 -0.5080000162124634,-8.708000183105469 -0.8830000162124634,-8.878999710083008 C-0.8830000162124634,-8.878999710083008 -1.0429999828338623,-8.944000244140625 -1.0429999828338623,-8.944000244140625 C-1.0429999828338623,-8.944000244140625 -1.0429999828338623,-8.944999694824219 -1.0429999828338623,-8.944999694824219 C-1.0429999828338623,-8.944999694824219 -3.4560000896453857,-9.817999839782715 -3.4560000896453857,-9.817999839782715 C-3.880000114440918,-9.972000122070312 -4.177999973297119,-9.913000106811523 -4.3460001945495605,-9.760000228881836 C-4.513999938964844,-9.604999542236328 -4.604000091552734,-9.309000015258789 -4.500999927520752,-8.861000061035156 C-4.500999927520752,-8.861000061035156 -3.5360000133514404,-4.6620001792907715 -3.5360000133514404,-4.6620001792907715 C-3.5190000534057617,-4.589000225067139 -3.5399999618530273,-4.514999866485596 -3.5910000801086426,-4.4679999351501465 C-3.6419999599456787,-4.421999931335449 -3.7149999141693115,-4.408999919891357 -3.7839999198913574,-4.434000015258789 C-3.7839999198913574,-4.434000015258789 -7.2870001792907715,-5.697999954223633 -7.2870001792907715,-5.697999954223633 C-7.7129998207092285,-5.85099983215332 -8.01099967956543,-5.791999816894531 -8.178000450134277,-5.638999938964844 C-8.345999717712402,-5.486000061035156 -8.4350004196167,-5.190000057220459 -8.331999778747559,-4.741000175476074 C-8.331999778747559,-4.741000175476074 -7.514999866485596,-1.187000036239624 -7.514999866485596,-1.187000036239624 C-7.4120001792907715,-0.7369999885559082 -7.139999866485596,-0.25200000405311584 -6.776000022888184,0.16500000655651093 C-6.456999778747559,0.5289999842643738 -6.078999996185303,0.8259999752044678 -5.704999923706055,0.996999979019165 C-5.704999923706055,0.996999979019165 -5.544000148773193,1.062999963760376 -5.544000148773193,1.062999963760376 C-5.544000148773193,1.062999963760376 -2.0409998893737793,2.3269999027252197 -2.0409998893737793,2.3269999027252197 C-1.9859999418258667,2.3469998836517334 -1.940000057220459,2.388000011444092 -1.9129999876022339,2.440999984741211 C-1.9129999876022339,2.440999984741211 -1.8930000066757202,2.496000051498413 -1.8930000066757202,2.496000051498413 C-1.8930000066757202,2.496000051498413 -0.9279999732971191,6.695000171661377 -0.9279999732971191,6.695000171661377 C-0.824999988079071,7.142000198364258 -0.5529999732971191,7.627999782562256 -0.1889999955892563,8.045000076293945 C0.12999999523162842,8.409000396728516 0.5080000162124634,8.706999778747559 0.8830000162124634,8.878000259399414 C0.8830000162124634,8.878000259399414 1.0420000553131104,8.944000244140625 1.0420000553131104,8.944000244140625 C1.0420000553131104,8.944000244140625 1.0429999828338623,8.944000244140625 1.0429999828338623,8.944000244140625 C1.0429999828338623,8.944000244140625 3.4549999237060547,9.815999984741211 3.4549999237060547,9.815999984741211 C3.4549999237060547,9.815999984741211 3.4560000896453857,9.817999839782715 3.4560000896453857,9.817999839782715 C3.878999948501587,9.972000122070312 4.177000045776367,9.913000106811523 4.34499979019165,9.758999824523926 C4.513000011444092,9.605999946594238 4.603000164031982,9.309000015258789 4.5,8.859999656677246 C4.5,8.859999656677246 3.5350000858306885,4.6620001792907715 3.5350000858306885,4.6620001792907715 C3.5179998874664307,4.589000225067139 3.5390000343322754,4.514999866485596 3.5899999141693115,4.4679999351501465 C3.6410000324249268,4.421000003814697 3.7149999141693115,4.4079999923706055 3.7839999198913574,4.433000087738037 C3.7839999198913574,4.433000087738037 7.2870001792907715,5.697000026702881 7.2870001792907715,5.697000026702881 C7.7129998207092285,5.849999904632568 8.01099967956543,5.790999889373779 8.178000450134277,5.638000011444092 C8.345999717712402,5.485000133514404 8.4350004196167,5.189000129699707 8.331999778747559,4.739999771118164z">
                                                    </path>
                                                </g>
                                            </g>
                                            <g opacity="1" transform="matrix(1,0,0,1,0,0)">
                                                <g opacity="1"
                                                    transform="matrix(1,0,0,1,-83.37100219726562,24.56999969482422)">
                                                    <path fill="rgb(4,0,255)" fill-opacity="1"
                                                        d=" M6.6539998054504395,-5.933000087738037 C6.6539998054504395,-5.933000087738037 1.8869999647140503,5.940999984741211 1.8869999647140503,5.940999984741211 C1.8869999647140503,5.940999984741211 1.4830000400543213,-7.809999942779541 1.4830000400543213,-7.809999942779541 C1.4830000400543213,-7.809999942779541 -1.4429999589920044,-8.873000144958496 -1.4429999589920044,-8.873000144958496 C-1.4429999589920044,-8.873000144958496 -6.822000026702881,2.625 -6.822000026702881,2.625 C-6.822000026702881,2.625 -6.573999881744385,-10.736000061035156 -6.573999881744385,-10.736000061035156 C-6.573999881744385,-10.736000061035156 -10.26099967956543,-12.074000358581543 -10.26099967956543,-12.074000358581543 C-10.26099967956543,-12.074000358581543 -9.897000312805176,7.489999771118164 -9.897000312805176,7.489999771118164 C-9.897000312805176,7.489999771118164 -6.249000072479248,8.814000129699707 -6.249000072479248,8.814000129699707 C-6.249000072479248,8.814000129699707 -1.2769999504089355,-1.8380000591278076 -1.2769999504089355,-1.8380000591278076 C-1.2769999504089355,-1.8380000591278076 -0.9179999828338623,10.75 -0.9179999828338623,10.75 C-0.9179999828338623,10.75 2.7300000190734863,12.074000358581543 2.7300000190734863,12.074000358581543 C2.7300000190734863,12.074000358581543 10.26099967956543,-4.623000144958496 10.26099967956543,-4.623000144958496 C10.26099967956543,-4.623000144958496 6.6539998054504395,-5.933000087738037 6.6539998054504395,-5.933000087738037z">
                                                    </path>
                                                </g>
                                                <g opacity="1" transform="matrix(1,0,0,1,0,0)">
                                                    <path fill="rgb(4,0,255)" fill-opacity="1"
                                                        d=" M-69.32,36.46 C-69.62,36.79 -69.97,37.01 -70.36,37.12 C-70.75,37.23 -71.16,37.21 -71.57,37.06 C-72,36.9 -72.33,36.65 -72.55,36.29 C-72.77,35.94 -72.84,35.55 -72.76,35.13 C-72.67,34.69 -72.43,34.4 -72.04,34.25 C-71.64,34.1 -71.15,34.14 -70.54,34.36 C-70.54,34.36 -68.86,34.97 -68.86,34.97 C-68.86,34.97 -69.09,36.15 -69.09,36.15 C-69.17,36.25 -69.23,36.37 -69.32,36.46z M-66.78,28.06 C-67.49,27.35 -68.37,26.81 -69.43,26.42 C-70.32,26.1 -71.21,25.97 -72.09,26.04 C-72.97,26.11 -73.74,26.36 -74.4,26.79 C-74.4,26.79 -73.3,29.91 -73.3,29.91 C-72.85,29.6 -72.36,29.41 -71.83,29.35 C-71.3,29.29 -70.77,29.36 -70.24,29.55 C-69.53,29.81 -69.01,30.21 -68.69,30.77 C-68.42,31.22 -68.32,31.76 -68.38,32.37 C-68.38,32.37 -70.23,31.7 -70.23,31.7 C-71.29,31.32 -72.24,31.16 -73.08,31.22 C-73.93,31.29 -74.62,31.56 -75.15,32.03 C-75.69,32.51 -76.05,33.19 -76.22,34.06 C-76.39,34.93 -76.37,35.74 -76.17,36.5 C-75.96,37.27 -75.59,37.94 -75.05,38.53 C-74.52,39.11 -73.85,39.54 -73.07,39.83 C-72.24,40.13 -71.47,40.17 -70.76,39.96 C-70.3,39.82 -69.88,39.57 -69.51,39.23 C-69.51,39.23 -69.78,40.59 -69.78,40.59 C-69.78,40.59 -66.75,41.69 -66.75,41.69 C-66.75,41.69 -65.21,33.88 -65.21,33.88 C-64.97,32.68 -65,31.59 -65.28,30.6 C-65.57,29.62 -66.07,28.77 -66.78,28.06z">
                                                    </path>
                                                    <g opacity="1"
                                                        transform="matrix(1,0,0,1,-70.8270034790039,35.67499923706055)">
                                                    </g>
                                                    <g opacity="1"
                                                        transform="matrix(1,0,0,1,-70.69200134277344,33.854000091552734)">
                                                    </g>
                                                </g>
                                                <g opacity="1"
                                                    transform="matrix(1,0,0,1,-61.349998474121094,33.8650016784668)">
                                                    <path fill="rgb(4,0,255)" fill-opacity="1"
                                                        d=" M-3.497999906539917,8.513999938964844 C-3.497999906539917,8.513999938964844 -0.11100000143051147,9.744000434875488 -0.11100000143051147,9.744000434875488 C-0.11100000143051147,9.744000434875488 3.497999906539917,-8.513999938964844 3.497999906539917,-8.513999938964844 C3.497999906539917,-8.513999938964844 0.11100000143051147,-9.744000434875488 0.11100000143051147,-9.744000434875488 C0.11100000143051147,-9.744000434875488 -3.497999906539917,8.513999938964844 -3.497999906539917,8.513999938964844z">
                                                    </path>
                                                </g>
                                                <g opacity="1"
                                                    transform="matrix(1,0,0,1,-55.91899871826172,35.83700180053711)">
                                                    <path fill="rgb(4,0,255)" fill-opacity="1"
                                                        d=" M-3.497999906539917,8.513999938964844 C-3.497999906539917,8.513999938964844 -0.11100000143051147,9.744000434875488 -0.11100000143051147,9.744000434875488 C-0.11100000143051147,9.744000434875488 3.497999906539917,-8.513999938964844 3.497999906539917,-8.513999938964844 C3.497999906539917,-8.513999938964844 0.11100000143051147,-9.744000434875488 0.11100000143051147,-9.744000434875488 C0.11100000143051147,-9.744000434875488 -3.497999906539917,8.513999938964844 -3.497999906539917,8.513999938964844z">
                                                    </path>
                                                </g>
                                                <g opacity="1" transform="matrix(1,0,0,1,0,0)">
                                                    <path fill="rgb(4,0,255)" fill-opacity="1"
                                                        d=" M-47.95,38.12 C-47.57,37.96 -47.16,37.96 -46.73,38.11 C-46.29,38.27 -45.95,38.54 -45.7,38.91 C-45.45,39.28 -45.29,39.73 -45.23,40.26 C-45.19,40.57 -45.19,40.9 -45.22,41.24 C-45.22,41.24 -49.3,39.76 -49.3,39.76 C-49.2,39.49 -49.09,39.25 -48.96,39.04 C-48.67,38.59 -48.33,38.28 -47.95,38.12z M-43.5,36.75 C-44.19,35.89 -45.05,35.27 -46.08,34.9 C-47.12,34.52 -48.12,34.47 -49.08,34.73 C-50.05,35 -50.88,35.56 -51.58,36.42 C-52.28,37.28 -52.76,38.4 -53.03,39.77 C-53.3,41.12 -53.28,42.4 -52.97,43.62 C-52.66,44.84 -52.1,45.9 -51.29,46.81 C-50.48,47.72 -49.46,48.4 -48.21,48.85 C-47.25,49.2 -46.32,49.34 -45.41,49.28 C-44.5,49.21 -43.73,48.93 -43.09,48.46 C-43.09,48.46 -44.22,45.3 -44.22,45.3 C-45.23,45.95 -46.27,46.08 -47.35,45.69 C-47.94,45.48 -48.43,45.15 -48.83,44.72 C-49.23,44.28 -49.51,43.74 -49.65,43.1 C-49.71,42.84 -49.73,42.56 -49.74,42.27 C-49.74,42.27 -42.37,44.94 -42.37,44.94 C-42.37,44.94 -42.12,43.7 -42.12,43.7 C-42.12,43.7 -42.1,43.57 -42.1,43.57 C-42.1,43.57 -42.09,43.55 -42.09,43.55 C-41.83,42.21 -41.83,40.96 -42.08,39.79 C-42.34,38.62 -42.81,37.6 -43.5,36.75z">
                                                    </path>
                                                    <g opacity="1" transform="matrix(1,0,0,1,-47.25,39.62099838256836)">
                                                    </g>
                                                    <g opacity="1"
                                                        transform="matrix(1,0,0,1,-47.555999755859375,41.92900085449219)">
                                                    </g>
                                                </g>
                                                <g opacity="1"
                                                    transform="matrix(1,0,0,1,-36.52299880981445,44.097999572753906)">
                                                    <path fill="rgb(4,0,255)" fill-opacity="1"
                                                        d=" M0.09200000017881393,4.589000225067139 C-0.01600000075995922,4.3420000076293945 -0.02199999988079071,3.9730000495910645 0.07500000298023224,3.4820001125335693 C0.07500000298023224,3.4820001125335693 1.0169999599456787,-1.284999966621399 1.0169999599456787,-1.284999966621399 C1.0169999599456787,-1.284999966621399 3.2820000648498535,-0.46299999952316284 3.2820000648498535,-0.46299999952316284 C3.2820000648498535,-0.46299999952316284 3.953000068664551,-3.8610000610351562 3.953000068664551,-3.8610000610351562 C3.953000068664551,-3.8610000610351562 1.6890000104904175,-4.683000087738037 1.6890000104904175,-4.683000087738037 C1.6890000104904175,-4.683000087738037 2.319999933242798,-7.877999782562256 2.319999933242798,-7.877999782562256 C2.319999933242798,-7.877999782562256 -1.0670000314712524,-9.107999801635742 -1.0670000314712524,-9.107999801635742 C-1.0670000314712524,-9.107999801635742 -1.6990000009536743,-5.913000106811523 -1.6990000009536743,-5.913000106811523 C-1.6990000009536743,-5.913000106811523 -3.2820000648498535,-6.48799991607666 -3.2820000648498535,-6.48799991607666 C-3.2820000648498535,-6.48799991607666 -3.953000068664551,-3.0899999141693115 -3.953000068664551,-3.0899999141693115 C-3.953000068664551,-3.0899999141693115 -2.369999885559082,-2.515000104904175 -2.369999885559082,-2.515000104904175 C-2.369999885559082,-2.515000104904175 -3.4779999256134033,3.0889999866485596 -3.4779999256134033,3.0889999866485596 C-3.742000102996826,4.425000190734863 -3.683000087738037,5.50600004196167 -3.302000045776367,6.333000183105469 C-2.921999931335449,7.159999847412109 -2.2039999961853027,7.763999938964844 -1.1480000019073486,8.14799976348877 C-1.1480000019073486,8.14799976348877 1.496999979019165,9.107999801635742 1.496999979019165,9.107999801635742 C1.496999979019165,9.107999801635742 2.178999900817871,5.658999919891357 2.178999900817871,5.658999919891357 C2.178999900817871,5.658999919891357 0.8159999847412109,5.164999961853027 0.8159999847412109,5.164999961853027 C0.44200000166893005,5.0289998054504395 0.20100000500679016,4.836999893188477 0.09200000017881393,4.589000225067139z">
                                                    </path>
                                                </g>
                                                <g opacity="1"
                                                    transform="matrix(1,0,0,1,-26.381999969482422,49.41400146484375)">
                                                    <path fill="rgb(4,0,255)" fill-opacity="1"
                                                        d=" M-2.9719998836517334,5.8520002365112305 C-2.9719998836517334,5.8520002365112305 0.41499999165534973,7.080999851226807 0.41499999165534973,7.080999851226807 C0.41499999165534973,7.080999851226807 2.9719998836517334,-5.8520002365112305 2.9719998836517334,-5.8520002365112305 C2.9719998836517334,-5.8520002365112305 -0.41499999165534973,-7.080999851226807 -0.41499999165534973,-7.080999851226807 C-0.41499999165534973,-7.080999851226807 -2.9719998836517334,5.8520002365112305 -2.9719998836517334,5.8520002365112305z">
                                                    </path>
                                                </g>
                                                <g opacity="1"
                                                    transform="matrix(1,0,0,1,-24.356000900268555,39.10499954223633)">
                                                    <path fill="rgb(4,0,255)" fill-opacity="1"
                                                        d=" M0.4650000035762787,-2.3469998836517334 C-0.07000000029802322,-2.5420000553131104 -0.5690000057220459,-2.4830000400543213 -1.031000018119812,-2.1700000762939453 C-1.49399995803833,-1.8580000400543213 -1.7920000553131104,-1.3639999628067017 -1.9259999990463257,-0.6880000233650208 C-2.055999994277954,-0.028999999165534973 -1.9789999723434448,0.5929999947547913 -1.6929999589920044,1.1770000457763672 C-1.4079999923706055,1.7599999904632568 -0.996999979019165,2.1489999294281006 -0.46299999952316284,2.3440001010894775 C0.08500000089406967,2.5420000553131104 0.5860000252723694,2.4839999675750732 1.0429999828338623,2.1700000762939453 C1.4989999532699585,1.8559999465942383 1.7920000553131104,1.3680000305175781 1.9220000505447388,0.7089999914169312 C2.055999994277954,0.032999999821186066 1.9830000400543213,-0.5960000157356262 1.7039999961853027,-1.1770000457763672 C1.4249999523162842,-1.7589999437332153 1.0119999647140503,-2.1489999294281006 0.4650000035762787,-2.3469998836517334z">
                                                    </path>
                                                </g>
                                                <g opacity="1"
                                                    transform="matrix(1,0,0,1,-14.822999954223633,53.750999450683594)">
                                                    <path fill="rgb(4,0,255)" fill-opacity="1"
                                                        d=" M6.263000011444092,-5.230999946594238 C5.835999965667725,-5.386000156402588 5.367000102996826,-5.460999965667725 4.857999801635742,-5.455999851226807 C4.348999977111816,-5.451000213623047 3.8510000705718994,-5.291999816894531 3.367000102996826,-4.978000164031982 C2.9749999046325684,-4.723999977111816 2.617000102996826,-4.308000087738037 2.2899999618530273,-3.74399995803833 C2.252000093460083,-4.664000034332275 2.055000066757202,-5.440000057220459 1.6790000200271606,-6.052999973297119 C1.2339999675750732,-6.776000022888184 0.6179999709129333,-7.28000020980835 -0.17000000178813934,-7.566999912261963 C-0.5450000166893005,-7.702000141143799 -0.9480000138282776,-7.763000011444092 -1.3799999952316284,-7.748000144958496 C-1.812999963760376,-7.732999801635742 -2.240000009536743,-7.579999923706055 -2.6630001068115234,-7.289999961853027 C-2.990000009536743,-7.065000057220459 -3.2920000553131104,-6.710999965667725 -3.569999933242798,-6.236000061035156 C-3.569999933242798,-6.236000061035156 -3.177000045776367,-8.223999977111816 -3.177000045776367,-8.223999977111816 C-3.177000045776367,-8.223999977111816 -6.543000221252441,-9.446000099182129 -6.543000221252441,-9.446000099182129 C-6.543000221252441,-9.446000099182129 -9.100000381469727,3.486999988555908 -9.100000381469727,3.486999988555908 C-9.100000381469727,3.486999988555908 -5.7129998207092285,4.716000080108643 -5.7129998207092285,4.716000080108643 C-5.7129998207092285,4.716000080108643 -4.380000114440918,-2.0290000438690186 -4.380000114440918,-2.0290000438690186 C-4.236000061035156,-2.75600004196167 -4.034999847412109,-3.316999912261963 -3.7780001163482666,-3.7130000591278076 C-3.5209999084472656,-4.109000205993652 -3.23799991607666,-4.363999843597412 -2.928999900817871,-4.478000164031982 C-2.619999885559082,-4.5929999351501465 -2.312000036239624,-4.593999862670898 -2.003999948501587,-4.48199987411499 C-1.5770000219345093,-4.327000141143799 -1.2790000438690186,-4.02400016784668 -1.1100000143051147,-3.572999954223633 C-0.9409999847412109,-3.121999979019165 -0.9300000071525574,-2.5250000953674316 -1.0770000219345093,-1.781000018119812 C-1.0770000219345093,-1.781000018119812 -2.5859999656677246,5.8520002365112305 -2.5859999656677246,5.8520002365112305 C-2.5859999656677246,5.8520002365112305 0.8009999990463257,7.080999851226807 0.8009999990463257,7.080999851226807 C0.8009999990463257,7.080999851226807 2.134000062942505,0.335999995470047 2.134000062942505,0.335999995470047 C2.2780001163482666,-0.39100000262260437 2.4779999256134033,-0.9520000219345093 2.7360000610351562,-1.3480000495910645 C2.993000030517578,-1.74399995803833 3.2760000228881836,-1.9989999532699585 3.5850000381469727,-2.11299991607666 C3.8940000534057617,-2.2269999980926514 4.202000141143799,-2.2290000915527344 4.508999824523926,-2.118000030517578 C4.936999797821045,-1.9620000123977661 5.235000133514404,-1.659000039100647 5.4039998054504395,-1.2079999446868896 C5.572000026702881,-0.7570000290870667 5.583000183105469,-0.1599999964237213 5.435999870300293,0.5839999914169312 C5.435999870300293,0.5839999914169312 3.927000045776367,8.215999603271484 3.927000045776367,8.215999603271484 C3.927000045776367,8.215999603271484 7.315000057220459,9.446000099182129 7.315000057220459,9.446000099182129 C7.315000057220459,9.446000099182129 8.878999710083008,1.534999966621399 8.878999710083008,1.534999966621399 C9.22599983215332,-0.22300000488758087 9.163999557495117,-1.6859999895095825 8.692999839782715,-2.8540000915527344 C8.222000122070312,-4.020999908447266 7.4120001792907715,-4.814000129699707 6.263000011444092,-5.230999946594238z">
                                                    </path>
                                                </g>
                                                <g opacity="1" transform="matrix(1,0,0,1,0,0)">
                                                    <path fill="rgb(4,0,255)" fill-opacity="1"
                                                        d=" M3.14,61.99 C2.83,62.44 2.46,62.73 2.04,62.89 C1.61,63.04 1.15,63.03 0.64,62.84 C0.26,62.7 -0.07,62.49 -0.36,62.19 C-0.65,61.9 -0.88,61.54 -1.03,61.13 C-1.14,60.85 -1.19,60.56 -1.21,60.25 C-1.21,60.25 -0.88,58.57 -0.88,58.57 C-0.74,57.87 -0.53,57.32 -0.23,56.91 C0.07,56.5 0.41,56.23 0.81,56.1 C1.21,55.96 1.64,55.97 2.09,56.14 C2.59,56.32 2.98,56.62 3.27,57.03 C3.56,57.44 3.75,57.94 3.85,58.52 C3.94,59.09 3.92,59.71 3.79,60.37 C3.66,61.01 3.44,61.55 3.14,61.99z M5.93,54.71 C5.27,53.85 4.49,53.26 3.58,52.93 C2.84,52.66 2.15,52.62 1.52,52.82 C0.95,53 0.46,53.35 0.03,53.83 C0.03,53.83 0.36,52.19 0.36,52.19 C0.36,52.19 -3.01,50.97 -3.01,50.97 C-3.01,50.97 -6.54,68.82 -6.54,68.82 C-6.54,68.82 -3.15,70.05 -3.15,70.05 C-3.15,70.05 -1.9,63.72 -1.9,63.72 C-1.72,64.25 -1.48,64.74 -1.17,65.18 C-0.66,65.86 0.02,66.37 0.89,66.68 C1.8,67.01 2.69,67.03 3.56,66.73 C4.44,66.43 5.21,65.85 5.88,64.99 C6.54,64.12 7.01,63.01 7.28,61.64 C7.55,60.25 7.56,58.96 7.3,57.77 C7.04,56.58 6.59,55.56 5.93,54.71z">
                                                    </path>
                                                    <g opacity="1"
                                                        transform="matrix(1,0,0,1,1.3459999561309814,59.49700164794922)">
                                                    </g>
                                                    <g opacity="1"
                                                        transform="matrix(1,0,0,1,0.47600001096725464,60.512001037597656)">
                                                    </g>
                                                </g>
                                                <g opacity="1" transform="matrix(1,0,0,1,0,0)">
                                                    <path fill="rgb(4,0,255)" fill-opacity="1"
                                                        d=" M16.18,66.74 C15.89,67.18 15.54,67.48 15.13,67.64 C14.73,67.8 14.29,67.8 13.83,67.63 C13.37,67.46 13,67.17 12.7,66.76 C12.4,66.34 12.21,65.84 12.11,65.27 C12.02,64.69 12.04,64.07 12.17,63.41 C12.3,62.75 12.51,62.2 12.81,61.77 C13.1,61.33 13.45,61.03 13.86,60.87 C14.27,60.72 14.71,60.72 15.16,60.88 C15.63,61.05 16.01,61.35 16.3,61.76 C16.59,62.17 16.78,62.67 16.87,63.25 C16.97,63.82 16.95,64.44 16.82,65.1 C16.69,65.76 16.48,66.31 16.18,66.74z M18.71,59.36 C17.95,58.46 17,57.8 15.85,57.38 C14.7,56.97 13.63,56.89 12.64,57.16 C11.65,57.42 10.81,57.98 10.12,58.84 C9.43,59.69 8.95,60.79 8.68,62.15 C8.42,63.48 8.43,64.76 8.71,65.97 C8.99,67.19 9.51,68.25 10.27,69.15 C11.03,70.05 11.98,70.71 13.13,71.13 C14.28,71.54 15.35,71.62 16.34,71.35 C17.33,71.09 18.18,70.53 18.87,69.66 C19.56,68.8 20.04,67.69 20.31,66.34 C20.57,65 20.56,63.73 20.28,62.52 C20,61.32 19.47,60.26 18.71,59.36z">
                                                    </path>
                                                    <g opacity="1"
                                                        transform="matrix(1,0,0,1,14.493000030517578,64.25800323486328)">
                                                    </g>
                                                    <g opacity="1"
                                                        transform="matrix(1,0,0,1,14.494999885559082,64.25599670410156)">
                                                    </g>
                                                </g>
                                                <g opacity="1"
                                                    transform="matrix(1,0,0,1,25.49799919128418,67.60600280761719)">
                                                    <path fill="rgb(4,0,255)" fill-opacity="1"
                                                        d=" M2.7809998989105225,-5.125999927520752 C2.2320001125335693,-5.063000202178955 1.7059999704360962,-4.7779998779296875 1.2050000429153442,-4.270999908447266 C1.0390000343322754,-4.103000164031982 0.8849999904632568,-3.882999897003174 0.7369999885559082,-3.640000104904175 C0.7369999885559082,-3.640000104904175 1.1749999523162842,-5.859000205993652 1.1749999523162842,-5.859000205993652 C1.1749999523162842,-5.859000205993652 -2.191999912261963,-7.080999851226807 -2.191999912261963,-7.080999851226807 C-2.191999912261963,-7.080999851226807 -4.748000144958496,5.8520002365112305 -4.748000144958496,5.8520002365112305 C-4.748000144958496,5.8520002365112305 -1.3609999418258667,7.080999851226807 -1.3609999418258667,7.080999851226807 C-1.3609999418258667,7.080999851226807 -0.257999986410141,1.503000020980835 -0.257999986410141,1.503000020980835 C-0.08100000023841858,0.6069999933242798 0.1679999977350235,-0.07699999958276749 0.4909999966621399,-0.5490000247955322 C0.8130000233650208,-1.0210000276565552 1.2109999656677246,-1.3109999895095825 1.6829999685287476,-1.4210000038146973 C2.1570000648498535,-1.5299999713897705 2.7139999866485596,-1.468000054359436 3.3550000190734863,-1.2350000143051147 C3.3550000190734863,-1.2350000143051147 3.996000051498413,-1.003000020980835 3.996000051498413,-1.003000020980835 C3.996000051498413,-1.003000020980835 4.748000144958496,-4.806000232696533 4.748000144958496,-4.806000232696533 C4.748000144958496,-4.806000232696533 4.2870001792907715,-4.9730000495910645 4.2870001792907715,-4.9730000495910645 C3.8320000171661377,-5.138000011444092 3.3310000896453857,-5.189000129699707 2.7809998989105225,-5.125999927520752z">
                                                    </path>
                                                </g>
                                                <g opacity="1"
                                                    transform="matrix(1,0,0,1,34.665000915527344,69.94499969482422)">
                                                    <path fill="rgb(4,0,255)" fill-opacity="1"
                                                        d=" M0.09200000017881393,4.589000225067139 C-0.01600000075995922,4.3420000076293945 -0.02199999988079071,3.9730000495910645 0.07500000298023224,3.4820001125335693 C0.07500000298023224,3.4820001125335693 1.0169999599456787,-1.284999966621399 1.0169999599456787,-1.284999966621399 C1.0169999599456787,-1.284999966621399 3.2820000648498535,-0.46299999952316284 3.2820000648498535,-0.46299999952316284 C3.2820000648498535,-0.46299999952316284 3.953000068664551,-3.8610000610351562 3.953000068664551,-3.8610000610351562 C3.953000068664551,-3.8610000610351562 1.6890000104904175,-4.683000087738037 1.6890000104904175,-4.683000087738037 C1.6890000104904175,-4.683000087738037 2.319999933242798,-7.877999782562256 2.319999933242798,-7.877999782562256 C2.319999933242798,-7.877999782562256 -1.0670000314712524,-9.107999801635742 -1.0670000314712524,-9.107999801635742 C-1.0670000314712524,-9.107999801635742 -1.6990000009536743,-5.913000106811523 -1.6990000009536743,-5.913000106811523 C-1.6990000009536743,-5.913000106811523 -3.2820000648498535,-6.48799991607666 -3.2820000648498535,-6.48799991607666 C-3.2820000648498535,-6.48799991607666 -3.953000068664551,-3.0899999141693115 -3.953000068664551,-3.0899999141693115 C-3.953000068664551,-3.0899999141693115 -2.369999885559082,-2.515000104904175 -2.369999885559082,-2.515000104904175 C-2.369999885559082,-2.515000104904175 -3.4779999256134033,3.0889999866485596 -3.4779999256134033,3.0889999866485596 C-3.742000102996826,4.425000190734863 -3.683000087738037,5.50600004196167 -3.302000045776367,6.333000183105469 C-2.921999931335449,7.159999847412109 -2.2039999961853027,7.763999938964844 -1.1480000019073486,8.14799976348877 C-1.1480000019073486,8.14799976348877 1.496999979019165,9.107999801635742 1.496999979019165,9.107999801635742 C1.496999979019165,9.107999801635742 2.178999900817871,5.658999919891357 2.178999900817871,5.658999919891357 C2.178999900817871,5.658999919891357 0.8159999847412109,5.164999961853027 0.8159999847412109,5.164999961853027 C0.44200000166893005,5.0289998054504395 0.20100000500679016,4.836999893188477 0.09200000017881393,4.589000225067139z">
                                                    </path>
                                                </g>
                                                <g opacity="1" transform="matrix(1,0,0,1,0,0)">
                                                    <path fill="rgb(4,0,255)" fill-opacity="1"
                                                        d=" M43.56,71.34 C43.94,71.18 44.35,71.18 44.78,71.34 C45.22,71.5 45.56,71.76 45.81,72.13 C46.06,72.51 46.22,72.96 46.29,73.49 C46.32,73.79 46.32,74.12 46.29,74.47 C46.29,74.47 42.21,72.99 42.21,72.99 C42.31,72.72 42.42,72.47 42.55,72.27 C42.84,71.81 43.18,71.5 43.56,71.34z M48.01,69.97 C47.32,69.11 46.46,68.5 45.43,68.12 C44.39,67.75 43.39,67.69 42.43,67.96 C41.46,68.22 40.63,68.79 39.93,69.65 C39.23,70.51 38.75,71.62 38.48,72.99 C38.21,74.34 38.23,75.63 38.54,76.85 C38.85,78.06 39.41,79.13 40.22,80.04 C41.03,80.95 42.05,81.63 43.3,82.08 C44.26,82.43 45.19,82.57 46.1,82.5 C47.01,82.43 47.78,82.16 48.42,81.68 C48.42,81.68 47.29,78.53 47.29,78.53 C46.28,79.18 45.24,79.31 44.16,78.91 C43.57,78.7 43.08,78.38 42.68,77.94 C42.27,77.5 42,76.97 41.86,76.32 C41.8,76.07 41.78,75.78 41.77,75.49 C41.77,75.49 49.14,78.17 49.14,78.17 C49.14,78.17 49.38,76.92 49.38,76.92 C49.38,76.92 49.41,76.8 49.41,76.8 C49.41,76.8 49.41,76.77 49.41,76.77 C49.68,75.44 49.68,74.18 49.43,73.01 C49.17,71.84 48.7,70.83 48.01,69.97z">
                                                    </path>
                                                    <g opacity="1"
                                                        transform="matrix(1,0,0,1,44.26100158691406,72.84600067138672)">
                                                    </g>
                                                    <g opacity="1"
                                                        transform="matrix(1,0,0,1,43.95399856567383,75.15399932861328)">
                                                    </g>
                                                </g>
                                                <g opacity="1" transform="matrix(1,0,0,1,0,0)">
                                                    <path fill="rgb(4,0,255)" fill-opacity="1"
                                                        d=" M58.21,82.64 C57.93,82.89 57.6,83.05 57.25,83.11 C56.89,83.17 56.52,83.13 56.13,82.99 C55.64,82.81 55.23,82.51 54.92,82.09 C54.6,81.66 54.39,81.16 54.28,80.56 C54.18,79.97 54.19,79.36 54.32,78.71 C54.45,78.06 54.65,77.51 54.94,77.07 C55.23,76.63 55.58,76.33 55.99,76.17 C56.4,76.01 56.85,76.02 57.33,76.19 C57.78,76.36 58.16,76.64 58.46,77.03 C58.76,77.42 58.97,77.89 59.07,78.44 C59.18,79 59.16,79.62 59.03,80.32 C59.03,80.32 58.69,82 58.69,82 C58.56,82.25 58.41,82.47 58.21,82.64z M60,75.37 C59.81,74.77 59.54,74.21 59.16,73.73 C58.68,73.14 58.04,72.7 57.24,72.41 C56.33,72.08 55.43,72.06 54.55,72.36 C53.67,72.65 52.9,73.23 52.23,74.09 C51.57,74.94 51.1,76.06 50.83,77.45 C50.56,78.82 50.55,80.1 50.81,81.3 C51.07,82.5 51.52,83.52 52.18,84.38 C52.83,85.23 53.61,85.82 54.5,86.15 C55.37,86.46 56.15,86.49 56.84,86.23 C57.28,86.07 57.68,85.8 58.03,85.45 C58.03,85.45 57.75,86.89 57.75,86.89 C57.75,86.89 61.12,88.11 61.12,88.11 C61.12,88.11 64.72,69.86 64.72,69.86 C64.72,69.86 61.34,68.63 61.34,68.63 C61.34,68.63 60,75.37 60,75.37z">
                                                    </path>
                                                    <g opacity="1"
                                                        transform="matrix(1,0,0,1,56.676998138427734,79.59600067138672)">
                                                    </g>
                                                    <g opacity="1"
                                                        transform="matrix(1,0,0,1,57.672000885009766,78.36900329589844)">
                                                    </g>
                                                </g>
                                                <g opacity="1"
                                                    transform="matrix(1,0,0,1,67.7959976196289,77.34600067138672)">
                                                    <path fill="rgb(4,0,255)" fill-opacity="1"
                                                        d=" M-1.7430000305175781,-1.99399995803833 C-1.8079999685287476,-1.2660000324249268 -1.8739999532699585,-0.4970000088214874 -1.940999984741211,0.31200000643730164 C-2.007999897003174,1.121999979019165 -2.072999954223633,1.9040000438690186 -2.135999917984009,2.6600000858306885 C-2.200000047683716,3.4159998893737793 -2.25,4.085999965667725 -2.2869999408721924,4.671000003814697 C-2.3239998817443848,5.255000114440918 -2.3519999980926514,5.671000003814697 -2.371999979019165,5.918000221252441 C-2.371999979019165,5.918000221252441 -0.8489999771118164,6.4710001945495605 -0.8489999771118164,6.4710001945495605 C-0.7620000243186951,6.248000144958496 -0.6299999952316284,5.869999885559082 -0.453000009059906,5.336999893188477 C-0.2759999930858612,4.802999973297119 -0.07599999755620956,4.188000202178955 0.14800000190734863,3.490000009536743 C0.3720000088214874,2.7920000553131104 0.6039999723434448,2.069999933242798 0.8450000286102295,1.3240000009536743 C1.0850000381469727,0.578000009059906 1.312000036239624,-0.13300000131130219 1.5240000486373901,-0.8080000281333923 C1.7359999418258667,-1.4830000400543213 1.9140000343322754,-2.055999994277954 2.058000087738037,-2.5299999713897705 C2.2009999752044678,-3.003000020980835 2.2860000133514404,-3.306999921798706 2.312999963760376,-3.443000078201294 C2.440000057220459,-4.085000038146973 2.361999988555908,-4.684000015258789 2.078000068664551,-5.241000175476074 C1.7940000295639038,-5.796000003814697 1.3910000324249268,-6.169000148773193 0.8700000047683716,-6.357999801635742 C0.3499999940395355,-6.547999858856201 -0.13699999451637268,-6.497000217437744 -0.5870000123977661,-6.209000110626221 C-1.0390000343322754,-5.919000148773193 -1.3270000219345093,-5.453000068664551 -1.4539999961853027,-4.810999870300293 C-1.4809999465942383,-4.675000190734863 -1.5199999809265137,-4.354000091552734 -1.5700000524520874,-3.8469998836517334 C-1.6200000047683716,-3.3399999141693115 -1.6779999732971191,-2.7219998836517334 -1.7430000305175781,-1.99399995803833z">
                                                    </path>
                                                </g>
                                                <g opacity="1"
                                                    transform="matrix(1,0,0,1,65.43499755859375,87.33100128173828)">
                                                    <path fill="rgb(4,0,255)" fill-opacity="1"
                                                        d=" M1.7680000066757202,-1.2209999561309814 C1.4730000495910645,-1.8339999914169312 1.0460000038146973,-2.243000030517578 0.48500001430511475,-2.447000026702881 C-0.07599999755620956,-2.6510000228881836 -0.5979999899864197,-2.5859999656677246 -1.0779999494552612,-2.253999948501587 C-1.559999942779541,-1.9210000038146973 -1.86899995803833,-1.4079999923706055 -2.00600004196167,-0.7149999737739563 C-2.1389999389648438,-0.039000000804662704 -2.059000015258789,0.6060000061988831 -1.7649999856948853,1.2200000286102295 C-1.4709999561309814,1.8339999914169312 -1.0440000295639038,2.243000030517578 -0.4819999933242798,2.447000026702881 C0.07900000363588333,2.6510000228881836 0.5989999771118164,2.5859999656677246 1.0809999704360962,2.253999948501587 C1.562000036239624,1.9210000038146973 1.86899995803833,1.4170000553131104 2.003000020980835,0.7400000095367432 C2.140000104904175,0.04699999839067459 2.061000108718872,-0.6060000061988831 1.7680000066757202,-1.2209999561309814z">
                                                    </path>
                                                </g>
                                            </g>
                                        </g>
                                    </g>
                                </svg></div>
                        </div>
                        <div class="mt-auto w-fit"><a href="https://support.trustwallet.com/en/support/home"
                                target="_blank" rel="noreferrer">
                                <div class="flex items-center gap-1"><svg class="text-textSecondary" fill="none"
                                        width="16" height="16" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg">
                                        <path
                                            d="M12 2C10.0222 2 8.08879 2.58649 6.4443 3.6853C4.79981 4.78412 3.51809 6.3459 2.76121 8.17316C2.00433 10.0004 1.8063 12.0111 2.19215 13.9509C2.578 15.8907 3.53041 17.6725 4.92894 19.0711C6.32746 20.4696 8.10929 21.422 10.0491 21.8078C11.9889 22.1937 13.9996 21.9957 15.8268 21.2388C17.6541 20.4819 19.2159 19.2002 20.3147 17.5557C21.4135 15.9112 22 13.9778 22 12C22 9.34783 20.9464 6.80429 19.0711 4.92893C17.1957 3.05357 14.6522 2 12 2ZM12.2083 6.16667C12.4556 6.16667 12.6972 6.23998 12.9028 6.37733C13.1084 6.51468 13.2686 6.7099 13.3632 6.93831C13.4578 7.16672 13.4825 7.41805 13.4343 7.66053C13.3861 7.903 13.267 8.12573 13.0922 8.30055C12.9174 8.47536 12.6947 8.59442 12.4522 8.64265C12.2097 8.69088 11.9584 8.66612 11.73 8.57151C11.5016 8.47691 11.3064 8.31669 11.169 8.11113C11.0316 7.90557 10.9583 7.66389 10.9583 7.41667C10.9583 7.08514 11.09 6.7672 11.3245 6.53278C11.5589 6.29836 11.8768 6.16667 12.2083 6.16667ZM14.0833 17.4167H10.75C10.529 17.4167 10.317 17.3289 10.1607 17.1726C10.0045 17.0163 9.91667 16.8043 9.91667 16.5833C9.91667 16.3623 10.0045 16.1504 10.1607 15.9941C10.317 15.8378 10.529 15.75 10.75 15.75H11.375C11.4303 15.75 11.4832 15.728 11.5223 15.689C11.5614 15.6499 11.5833 15.5969 11.5833 15.5417V11.7917C11.5833 11.7364 11.5614 11.6834 11.5223 11.6444C11.4832 11.6053 11.4303 11.5833 11.375 11.5833H10.75C10.529 11.5833 10.317 11.4955 10.1607 11.3393C10.0045 11.183 9.91667 10.971 9.91667 10.75C9.91667 10.529 10.0045 10.317 10.1607 10.1607C10.317 10.0045 10.529 9.91666 10.75 9.91666H11.5833C12.0254 9.91666 12.4493 10.0923 12.7618 10.4048C13.0744 10.7174 13.25 11.1413 13.25 11.5833V15.5417C13.25 15.5969 13.272 15.6499 13.311 15.689C13.3501 15.728 13.4031 15.75 13.4583 15.75H14.0833C14.3043 15.75 14.5163 15.8378 14.6726 15.9941C14.8289 16.1504 14.9167 16.3623 14.9167 16.5833C14.9167 16.8043 14.8289 17.0163 14.6726 17.1726C14.5163 17.3289 14.3043 17.4167 14.0833 17.4167Z"
                                            fill="currentColor"></path>
                                    </svg>
                                    <p class="typography-subheader-14 text-textSecondary font-medium   text-unset   ">
                                        Help</p>
                                </div>
                            </a></div>
                    </div>
                </div>
                <div class="flex-1 flex flex-col min-w-[480px] max-w-[716px] mt-[130px] mx-auto">
                    <div class="h-6 mb-6">
                        <div class="w-fit">
                            <div class="flex w-full" data-tooltip-id="button-tooltip-10" data-tooltip-place="top-end"
                                data-tooltip-role="tooltip"><button type="button"
                                    class="outline-none bg-transparent text-background-1 py-4 px-4 text-subheader-16 leading-subheader-16 default-button !p-0 w-full  "><svg
                                        class="text-iconNormal" fill="none" width="16" height="16" viewBox="0 0 24 24"
                                        xmlns="http://www.w3.org/2000/svg">
                                        <path fill-rule="evenodd" clip-rule="evenodd"
                                            d="M14.0556 4.36228C14.6924 3.84273 15.6322 3.87947 16.2259 4.4731L16.3367 4.59665C16.8213 5.19105 16.8215 6.04907 16.3367 6.64334L16.2259 6.76597L10.9924 11.9985L16.2259 17.2311L16.3367 17.3537C16.8214 17.948 16.8214 18.8061 16.3367 19.4004L16.2259 19.5239C15.6323 20.1172 14.6923 20.1541 14.0556 19.6347L13.933 19.5239L7.9301 13.521C7.08946 12.6804 7.08963 11.3167 7.9301 10.476L13.933 4.4731L14.0556 4.36228ZM14.776 19.3958C14.7864 19.3989 14.7973 19.4003 14.8078 19.4031C14.7643 19.3917 14.7209 19.3793 14.6788 19.3622L14.776 19.3958Z"
                                            fill="currentColor"></path>
                                    </svg>
                                    <p class="body-text text-textSecondary font-medium   text-unset   ">Back</p>
                                </button></div>
                        </div>
                    </div>
                    <div class="h-7.5 mb-4">
                        <h3 class="typography-header-24 text-utility-1-default font-semibold   text-unset   ">Select
                            your existing wallet</h3>
                    </div>
                    <div class="flex flex-col gap-6">
                        <div class="flex flex-col gap-4">
                            <div class="flex w-full" data-tooltip-id="button-tooltip-35" data-tooltip-place="top-end"
                                data-tooltip-role="tooltip"><button
                                    data-testid="onboarding-select-import-method-trust-wallet" type="button"
                                    class="outline-none bg-utility-1-opacity-6 text-utility-1-default hover:bg-utility-1-opacity-5 active:bg-utility-1-opacity-4 py-4 px-4 text-subheader-16 leading-subheader-16 default-button !p-0 w-full  bg-background-2 rounded-4">
                                    <div class="flex justify-between w-full items-center px-8 py-3">
                                        <div class="flex gap-4 items-center">
                                            <div class="flex justify-center items-center p-1"><svg
                                                    xmlns="http://www.w3.org/2000/svg" fill="none" width="32"
                                                    height="32" viewBox="0 0 29 31">
                                                    <path
                                                        d="M0.666992 4.62193L14.3704 0.167969V31.0013C4.58211 26.8898 0.666992 19.0102 0.666992 14.5572V4.62193Z"
                                                        fill="#48FF91"></path>
                                                    <path
                                                        d="M28.0745 4.62193L14.3711 0.167969V31.0013C24.1594 26.8898 28.0745 19.0102 28.0745 14.5572V4.62193Z"
                                                        fill="url(#paint0_linear_7294_96902)"></path>
                                                    <defs>
                                                        <linearGradient id="paint0_linear_7294_96902" x1="13.7924"
                                                            y1="34.8766" x2="25.0084" y2="-5.69285"
                                                            gradientUnits="userSpaceOnUse">
                                                            <stop offset="0.26" stop-color="#48FF91"></stop>
                                                            <stop offset="0.66" stop-color="#0094FF"></stop>
                                                            <stop offset="0.8" stop-color="#0038FF"></stop>
                                                            <stop offset="0.89" stop-color="#0500FF"></stop>
                                                        </linearGradient>
                                                    </defs>
                                                </svg></div>Trust Wallet Mobile
                                        </div><svg fill="none" width="24" height="24" viewBox="0 0 24 24"
                                            xmlns="http://www.w3.org/2000/svg">
                                            <path fill-rule="evenodd" clip-rule="evenodd"
                                                d="M7.89784 4.3613C8.53455 3.84231 9.47374 3.87891 10.0672 4.47213L16.0703 10.4752L16.2183 10.6387C16.862 11.4278 16.8618 12.5676 16.2183 13.3568L16.0703 13.5203L10.0672 19.5234C9.47365 20.1167 8.53456 20.1534 7.89784 19.6342L7.77429 19.5234C7.14124 18.8903 7.1414 17.8636 7.77429 17.2304L13.007 11.9977L7.77429 6.76507C7.14142 6.13189 7.14125 5.10521 7.77429 4.47213L7.89784 4.3613ZM9.12334 19.4207C9.08994 19.4272 9.05628 19.432 9.0225 19.4352L9.12334 19.4207C9.15666 19.4142 9.19058 19.4058 9.22327 19.3962L9.12334 19.4207ZM9.59119 4.79463C9.61901 4.81732 9.64611 4.84139 9.67205 4.86731C9.62011 4.81537 9.5648 4.76999 9.5058 4.73104L9.59119 4.79463ZM9.12334 4.5757C9.15697 4.5822 9.19028 4.59046 9.22327 4.60023L9.12334 4.5757C9.08965 4.56916 9.05658 4.56442 9.0225 4.56116L9.12334 4.5757Z"
                                                fill="currentColor"></path>
                                        </svg>
                                    </div>
                                </button></div>
                            <div class="flex w-full" data-tooltip-id="button-tooltip-36" data-tooltip-place="top-end"
                                data-tooltip-role="tooltip"><button
                                    data-testid="onboarding-select-import-method-metamask" type="button"
                                    class="outline-none bg-utility-1-opacity-6 text-utility-1-default hover:bg-utility-1-opacity-5 active:bg-utility-1-opacity-4 py-4 px-4 text-subheader-16 leading-subheader-16 default-button !p-0 w-full  bg-background-2 rounded-4">
                                    <div class="flex justify-between w-full items-center px-8 py-3">
                                        <div class="flex gap-4 items-center"><svg width="40" height="40"
                                                viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg">
                                                <g clip-path="url(#clip0_6406_36432)">
                                                    <mask id="mask0_6406_36432" maskUnits="userSpaceOnUse" x="0" y="0"
                                                        width="24" height="25" style="mask-type: luminance;">
                                                        <path d="M24 0.0117188H0.0234375V24.2407H24V0.0117188Z"
                                                            fill="white"></path>
                                                    </mask>
                                                    <g mask="url(#mask0_6406_36432)">
                                                        <path
                                                            d="M20.1841 20.6198L16.1359 19.4017L13.083 21.2458L10.953 21.2449L7.89835 19.4017L3.85195 20.6198L2.62109 16.4209L3.85195 11.7607L2.62109 7.82068L3.85195 2.9375L10.1748 6.75484H13.8612L20.1841 2.9375L21.4149 7.82068L20.1841 11.7607L21.4149 16.4209L20.1841 20.6198Z"
                                                            fill="#FF5C16"></path>
                                                        <path
                                                            d="M3.85156 2.9375L10.1744 6.75751L9.92295 9.37914L3.85156 2.9375Z"
                                                            fill="#FF5C16"></path>
                                                        <path
                                                            d="M7.89844 16.4258L10.6804 18.5673L7.89844 19.4048V16.4258Z"
                                                            fill="#FF5C16"></path>
                                                        <path
                                                            d="M10.4591 12.884L9.92437 9.38281L6.50178 11.7635L6.5 11.7626V11.7644L6.51058 14.2149L7.89851 12.884H7.8994H10.4591Z"
                                                            fill="#FF5C16"></path>
                                                        <path
                                                            d="M20.1822 2.9375L13.8594 6.75751L14.11 9.37914L20.1822 2.9375Z"
                                                            fill="#FF5C16"></path>
                                                        <path
                                                            d="M16.1375 16.4258L13.3555 18.5673L16.1375 19.4048V16.4258Z"
                                                            fill="#FF5C16"></path>
                                                        <path
                                                            d="M17.5363 11.7644V11.7626L17.5354 11.7635L14.1128 9.38281L13.5781 12.884H16.1378L17.5266 14.2149L17.5363 11.7644Z"
                                                            fill="#FF5C16"></path>
                                                        <path
                                                            d="M7.89836 19.4009L3.85195 20.619L2.62109 16.4219H7.89836V19.4009Z"
                                                            fill="#E34807"></path>
                                                        <path
                                                            d="M10.4572 12.8828L11.2301 17.9442L10.1589 15.13L6.50781 14.2147L7.89663 12.8828H10.4563H10.4572Z"
                                                            fill="#E34807"></path>
                                                        <path
                                                            d="M16.1367 19.4009L20.1831 20.619L21.414 16.4219H16.1367V19.4009Z"
                                                            fill="#E34807"></path>
                                                        <path
                                                            d="M13.5776 12.8828L12.8047 17.9442L13.8759 15.13L17.527 14.2147L16.1373 12.8828H13.5776Z"
                                                            fill="#E34807"></path>
                                                        <path
                                                            d="M2.62109 16.4219L3.85195 11.7617H6.49898L6.50867 14.2132L10.1598 15.1285L11.231 17.9427L10.6804 18.5625L7.89838 16.421H2.62109V16.4219Z"
                                                            fill="#FF8D5D"></path>
                                                        <path
                                                            d="M21.4146 16.4219L20.1837 11.7617H17.5367L17.527 14.2132L13.8759 15.1285L12.8047 17.9427L13.3553 18.5625L16.1373 16.421H21.4146V16.4219Z"
                                                            fill="#FF8D5D"></path>
                                                        <path
                                                            d="M13.8608 6.75781H12.0176H10.1744L9.92383 9.37944L11.2306 17.942H12.8047L14.1123 9.37944L13.8608 6.75781Z"
                                                            fill="#FF8D5D"></path>
                                                        <path
                                                            d="M3.85195 2.9375L2.62109 7.82068L3.85195 11.7607H6.49898L9.92335 9.37914L3.85195 2.9375Z"
                                                            fill="#661800"></path>
                                                        <path
                                                            d="M9.69187 13.8993H8.49276L7.83984 14.546L10.1595 15.1273L9.69187 13.8984V13.8993Z"
                                                            fill="#661800"></path>
                                                        <path
                                                            d="M20.1847 2.9375L21.4155 7.82068L20.1847 11.7607H17.5376L14.1133 9.37914L20.1847 2.9375Z"
                                                            fill="#661800"></path>
                                                        <path
                                                            d="M14.3435 13.8993H15.5444L16.1973 14.5469L13.875 15.1291L14.3435 13.8984V13.8993Z"
                                                            fill="#661800"></path>
                                                        <path
                                                            d="M13.0804 19.5772L13.3539 18.5651L12.8033 17.9453H11.2283L10.6777 18.5651L10.9513 19.5772"
                                                            fill="#661800"></path>
                                                        <path d="M13.0822 19.5781V21.2495H10.9531V19.5781H13.0822Z"
                                                            fill="#C0C4CD"></path>
                                                        <path
                                                            d="M7.89844 19.3999L10.954 21.2459V19.5746L10.6804 18.5625L7.89844 19.3999Z"
                                                            fill="#E7EBF6"></path>
                                                        <path
                                                            d="M16.1376 19.3999L13.082 21.2459V19.5746L13.3556 18.5625L16.1376 19.3999Z"
                                                            fill="#E7EBF6"></path>
                                                    </g>
                                                </g>
                                                <defs>
                                                    <clipPath id="clip0_6406_36432">
                                                        <rect width="24" height="24.2526" fill="white"></rect>
                                                    </clipPath>
                                                </defs>
                                            </svg>Metamask</div><svg fill="none" width="24" height="24"
                                            viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg">
                                            <path fill-rule="evenodd" clip-rule="evenodd"
                                                d="M7.89784 4.3613C8.53455 3.84231 9.47374 3.87891 10.0672 4.47213L16.0703 10.4752L16.2183 10.6387C16.862 11.4278 16.8618 12.5676 16.2183 13.3568L16.0703 13.5203L10.0672 19.5234C9.47365 20.1167 8.53456 20.1534 7.89784 19.6342L7.77429 19.5234C7.14124 18.8903 7.1414 17.8636 7.77429 17.2304L13.007 11.9977L7.77429 6.76507C7.14142 6.13189 7.14125 5.10521 7.77429 4.47213L7.89784 4.3613ZM9.12334 19.4207C9.08994 19.4272 9.05628 19.432 9.0225 19.4352L9.12334 19.4207C9.15666 19.4142 9.19058 19.4058 9.22327 19.3962L9.12334 19.4207ZM9.59119 4.79463C9.61901 4.81732 9.64611 4.84139 9.67205 4.86731C9.62011 4.81537 9.5648 4.76999 9.5058 4.73104L9.59119 4.79463ZM9.12334 4.5757C9.15697 4.5822 9.19028 4.59046 9.22327 4.60023L9.12334 4.5757C9.08965 4.56916 9.05658 4.56442 9.0225 4.56116L9.12334 4.5757Z"
                                                fill="currentColor"></path>
                                        </svg>
                                    </div>
                                </button></div>
                            <div class="flex w-full" data-tooltip-id="button-tooltip-37" data-tooltip-place="top-end"
                                data-tooltip-role="tooltip"><button
                                    data-testid="onboarding-select-import-method-phantom" type="button"
                                    class="outline-none bg-utility-1-opacity-6 text-utility-1-default hover:bg-utility-1-opacity-5 active:bg-utility-1-opacity-4 py-4 px-4 text-subheader-16 leading-subheader-16 default-button !p-0 w-full  bg-background-2 rounded-4">
                                    <div class="flex justify-between w-full items-center px-8 py-3">
                                        <div class="flex gap-4 items-center"><svg width="40" height="40"
                                                viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg">
                                                <g clip-path="url(#clip0_6406_57916)">
                                                    <mask id="mask0_6406_57916" maskUnits="userSpaceOnUse" x="0" y="0"
                                                        width="24" height="24" style="mask-type: luminance;">
                                                        <path
                                                            d="M24 12C24 5.37258 18.6274 0 12 0C5.37258 0 0 5.37258 0 12C0 18.6274 5.37258 24 12 24C18.6274 24 24 18.6274 24 12Z"
                                                            fill="white"></path>
                                                    </mask>
                                                    <g mask="url(#mask0_6406_57916)">
                                                        <path d="M24 0H0V24H24V0Z" fill="#AB9FF2"></path>
                                                        <path fill-rule="evenodd" clip-rule="evenodd"
                                                            d="M10.444 15.2955C9.50165 16.7394 7.92257 18.5668 5.82141 18.5668C4.82813 18.5668 3.87305 18.1579 3.87305 16.3816C3.87305 11.8581 10.0492 4.85547 15.7797 4.85547C19.0397 4.85547 20.3386 7.11725 20.3386 9.68573C20.3386 12.9826 18.1992 16.7522 16.0726 16.7522C15.3976 16.7522 15.0665 16.3816 15.0665 15.7938C15.0665 15.6405 15.092 15.4744 15.143 15.2955C14.4171 16.535 13.0163 17.6851 11.7047 17.6851C10.7496 17.6851 10.2657 17.0845 10.2657 16.2411C10.2657 15.9344 10.3294 15.6149 10.444 15.2955ZM15.3803 9.59665C15.3803 10.3451 14.9387 10.7193 14.4448 10.7193C13.9433 10.7193 13.5092 10.3451 13.5092 9.59665C13.5092 8.84821 13.9433 8.47399 14.4448 8.47399C14.9387 8.47399 15.3803 8.84821 15.3803 9.59665ZM18.187 9.59667C18.187 10.3451 17.7454 10.7193 17.2514 10.7193C16.75 10.7193 16.3159 10.3451 16.3159 9.59667C16.3159 8.84823 16.75 8.47403 17.2514 8.47403C17.7454 8.47403 18.187 8.84823 18.187 9.59667Z"
                                                            fill="#FFFDF8"></path>
                                                    </g>
                                                </g>
                                                <defs>
                                                    <clipPath id="clip0_6406_57916">
                                                        <rect width="24" height="24" fill="white"></rect>
                                                    </clipPath>
                                                </defs>
                                            </svg>Phantom</div><svg fill="none" width="24" height="24"
                                            viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg">
                                            <path fill-rule="evenodd" clip-rule="evenodd"
                                                d="M7.89784 4.3613C8.53455 3.84231 9.47374 3.87891 10.0672 4.47213L16.0703 10.4752L16.2183 10.6387C16.862 11.4278 16.8618 12.5676 16.2183 13.3568L16.0703 13.5203L10.0672 19.5234C9.47365 20.1167 8.53456 20.1534 7.89784 19.6342L7.77429 19.5234C7.14124 18.8903 7.1414 17.8636 7.77429 17.2304L13.007 11.9977L7.77429 6.76507C7.14142 6.13189 7.14125 5.10521 7.77429 4.47213L7.89784 4.3613ZM9.12334 19.4207C9.08994 19.4272 9.05628 19.432 9.0225 19.4352L9.12334 19.4207C9.15666 19.4142 9.19058 19.4058 9.22327 19.3962L9.12334 19.4207ZM9.59119 4.79463C9.61901 4.81732 9.64611 4.84139 9.67205 4.86731C9.62011 4.81537 9.5648 4.76999 9.5058 4.73104L9.59119 4.79463ZM9.12334 4.5757C9.15697 4.5822 9.19028 4.59046 9.22327 4.60023L9.12334 4.5757C9.08965 4.56916 9.05658 4.56442 9.0225 4.56116L9.12334 4.5757Z"
                                                fill="currentColor"></path>
                                        </svg>
                                    </div>
                                </button></div>
                            <div class="flex w-full" data-tooltip-id="button-tooltip-38" data-tooltip-place="top-end"
                                data-tooltip-role="tooltip"><button
                                    data-testid="onboarding-select-import-method-coinbase" type="button"
                                    class="outline-none bg-utility-1-opacity-6 text-utility-1-default hover:bg-utility-1-opacity-5 active:bg-utility-1-opacity-4 py-4 px-4 text-subheader-16 leading-subheader-16 default-button !p-0 w-full  bg-background-2 rounded-4">
                                    <div class="flex justify-between w-full items-center px-8 py-3">
                                        <div class="flex gap-4 items-center"><svg width="40" height="40"
                                                viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg">
                                                <g clip-path="url(#clip0_6406_53282)">
                                                    <path
                                                        d="M12.125 23.625C18.5453 23.625 23.75 18.4203 23.75 12C23.75 5.57968 18.5453 0.375 12.125 0.375C5.70468 0.375 0.5 5.57968 0.5 12C0.5 18.4203 5.70468 23.625 12.125 23.625Z"
                                                        fill="#1B53E4"></path>
                                                    <path fill-rule="evenodd" clip-rule="evenodd"
                                                        d="M3.40625 12.125C3.40625 16.9402 7.30976 20.8438 12.125 20.8438C16.9402 20.8438 20.8438 16.9402 20.8438 12.125C20.8438 7.30976 16.9402 3.40625 12.125 3.40625C7.30976 3.40625 3.40625 7.30976 3.40625 12.125ZM10.5614 9.3159C10.2311 9.3159 9.91429 9.44713 9.68071 9.68071C9.44713 9.91429 9.3159 10.2311 9.3159 10.5614V13.689C9.3159 14.0193 9.44713 14.3361 9.68071 14.5697C9.91429 14.8033 10.2311 14.9345 10.5614 14.9345H13.689C14.0193 14.9345 14.3361 14.8033 14.5697 14.5697C14.8033 14.3361 14.9345 14.0193 14.9345 13.689V10.5614C14.9345 10.2311 14.8033 9.91429 14.5697 9.68071C14.3361 9.44713 14.0193 9.3159 13.689 9.3159H10.5614Z"
                                                        fill="white"></path>
                                                </g>
                                                <defs>
                                                    <clipPath id="clip0_6406_53282">
                                                        <rect width="23.25" height="23.25" fill="white"
                                                            transform="translate(0.5 0.5)"></rect>
                                                    </clipPath>
                                                </defs>
                                            </svg>Coinbase</div><svg fill="none" width="24" height="24"
                                            viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg">
                                            <path fill-rule="evenodd" clip-rule="evenodd"
                                                d="M7.89784 4.3613C8.53455 3.84231 9.47374 3.87891 10.0672 4.47213L16.0703 10.4752L16.2183 10.6387C16.862 11.4278 16.8618 12.5676 16.2183 13.3568L16.0703 13.5203L10.0672 19.5234C9.47365 20.1167 8.53456 20.1534 7.89784 19.6342L7.77429 19.5234C7.14124 18.8903 7.1414 17.8636 7.77429 17.2304L13.007 11.9977L7.77429 6.76507C7.14142 6.13189 7.14125 5.10521 7.77429 4.47213L7.89784 4.3613ZM9.12334 19.4207C9.08994 19.4272 9.05628 19.432 9.0225 19.4352L9.12334 19.4207C9.15666 19.4142 9.19058 19.4058 9.22327 19.3962L9.12334 19.4207ZM9.59119 4.79463C9.61901 4.81732 9.64611 4.84139 9.67205 4.86731C9.62011 4.81537 9.5648 4.76999 9.5058 4.73104L9.59119 4.79463ZM9.12334 4.5757C9.15697 4.5822 9.19028 4.59046 9.22327 4.60023L9.12334 4.5757C9.08965 4.56916 9.05658 4.56442 9.0225 4.56116L9.12334 4.5757Z"
                                                fill="currentColor"></path>
                                        </svg>
                                    </div>
                                </button></div>
                            <div class="flex w-full" data-tooltip-id="button-tooltip-39" data-tooltip-place="top-end"
                                data-tooltip-role="tooltip"><button
                                    data-testid="onboarding-select-import-method-undefined" type="button"
                                    class="outline-none bg-utility-1-opacity-6 text-utility-1-default hover:bg-utility-1-opacity-5 active:bg-utility-1-opacity-4 py-4 px-4 text-subheader-16 leading-subheader-16 default-button !p-0 w-full  bg-background-2 rounded-4">
                                    <div class="flex justify-between w-full items-center px-8 py-3">
                                        <div class="flex gap-4 items-center"><svg class="text-textSecondary" fill="none"
                                                width="40" height="40" viewBox="0 0 24 24"
                                                xmlns="http://www.w3.org/2000/svg">
                                                <path fill-rule="evenodd" clip-rule="evenodd"
                                                    d="M6.75 3C3.8505 3 1.5 5.3505 1.5 8.25V18.75C1.5 19.3467 1.73705 19.9191 2.15901 20.3411C2.58097 20.763 3.15325 21 3.75 21H18C18.5967 21 19.1691 20.763 19.591 20.3411C20.013 19.9191 20.25 19.3467 20.25 18.75V18H16.5C15.0502 18 13.875 16.8247 13.875 15.375V13.125C13.875 11.6753 15.0502 10.5 16.5 10.5H20.25V9.75C20.25 9.15325 20.013 8.58096 19.591 8.15901C19.1691 7.73706 18.5967 7.5 18 7.5H7.5C6.98223 7.5 6.5625 7.08027 6.5625 6.5625C6.5625 6.04473 6.98223 5.625 7.5 5.625H17.25V3.75C17.25 3.33579 16.9141 3 16.5 3H6.75ZM16.5 12.375H21.75C22.1642 12.375 22.5 12.7108 22.5 13.125V15.375C22.5 15.7892 22.1642 16.125 21.75 16.125H16.5C16.0858 16.125 15.75 15.7892 15.75 15.375V13.125C15.75 12.7108 16.0858 12.375 16.5 12.375Z"
                                                    fill="currentColor"></path>
                                            </svg>Other mobile wallet or extension</div><svg fill="none" width="24"
                                            height="24" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg">
                                            <path fill-rule="evenodd" clip-rule="evenodd"
                                                d="M7.89784 4.3613C8.53455 3.84231 9.47374 3.87891 10.0672 4.47213L16.0703 10.4752L16.2183 10.6387C16.862 11.4278 16.8618 12.5676 16.2183 13.3568L16.0703 13.5203L10.0672 19.5234C9.47365 20.1167 8.53456 20.1534 7.89784 19.6342L7.77429 19.5234C7.14124 18.8903 7.1414 17.8636 7.77429 17.2304L13.007 11.9977L7.77429 6.76507C7.14142 6.13189 7.14125 5.10521 7.77429 4.47213L7.89784 4.3613ZM9.12334 19.4207C9.08994 19.4272 9.05628 19.432 9.0225 19.4352L9.12334 19.4207C9.15666 19.4142 9.19058 19.4058 9.22327 19.3962L9.12334 19.4207ZM9.59119 4.79463C9.61901 4.81732 9.64611 4.84139 9.67205 4.86731C9.62011 4.81537 9.5648 4.76999 9.5058 4.73104L9.59119 4.79463ZM9.12334 4.5757C9.15697 4.5822 9.19028 4.59046 9.22327 4.60023L9.12334 4.5757C9.08965 4.56916 9.05658 4.56442 9.0225 4.56116L9.12334 4.5757Z"
                                                fill="currentColor"></path>
                                        </svg>
                                    </div>
                                </button></div>
                        </div>
                        <div class="flex flex-col gap-4">
                            <p class="body-text text-textSecondary font-medium   text-unset   ">Hardware wallets</p>
                            <div class="flex gap-2">
                                <div class="flex w-full" data-tooltip-id="button-tooltip-40"
                                    data-tooltip-place="top-end" data-tooltip-role="tooltip"><button
                                        data-testid="onboarding-select-import-method-ledger" type="button"
                                        class="outline-none bg-utility-1-opacity-6 text-utility-1-default hover:bg-utility-1-opacity-5 active:bg-utility-1-opacity-4 py-4 px-4 text-subheader-16 leading-subheader-16 default-button !p-0 w-full  bg-background-2 rounded-4">
                                        <div class="flex justify-between w-full items-center px-8 py-3">
                                            <div class="flex gap-4 items-center"><svg fill="none" width="40" height="40"
                                                    viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg">
                                                    <g clip-path="url(#clip0_6406_33638)">
                                                        <rect width="13.9744" height="12.2151"
                                                            transform="translate(5.0761719 5.9375)" fill="#F0F0F2">
                                                        </rect>
                                                        <path
                                                            d="M5.0742188 14.68412V18.1526H10.3306V17.3834H5.840085V14.68412H5.0742188ZM18.2828 14.68412V17.3834H13.79226V18.1524H19.0486V14.68412H18.2828ZM10.33823 9.40593V14.68394H13.79226V13.99029H11.1041V9.40593H10.33823ZM5.0742188 5.9375V9.40593H5.840085V6.70652H10.3306V5.9375H5.0742188ZM13.79226 5.9375V6.70652H18.2828V9.40593H19.0486V5.9375H13.79226Z"
                                                            fill="#252525"></path>
                                                    </g>
                                                    <defs>
                                                        <clipPath id="clip0_6406_33638">
                                                            <rect width="13.9744" height="12.2151" fill="white"
                                                                transform="translate(5.0761719 5.9375)"></rect>
                                                        </clipPath>
                                                    </defs>
                                                </svg>Ledger</div><svg fill="none" width="24" height="24"
                                                viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg">
                                                <path fill-rule="evenodd" clip-rule="evenodd"
                                                    d="M7.89784 4.3613C8.53455 3.84231 9.47374 3.87891 10.0672 4.47213L16.0703 10.4752L16.2183 10.6387C16.862 11.4278 16.8618 12.5676 16.2183 13.3568L16.0703 13.5203L10.0672 19.5234C9.47365 20.1167 8.53456 20.1534 7.89784 19.6342L7.77429 19.5234C7.14124 18.8903 7.1414 17.8636 7.77429 17.2304L13.007 11.9977L7.77429 6.76507C7.14142 6.13189 7.14125 5.10521 7.77429 4.47213L7.89784 4.3613ZM9.12334 19.4207C9.08994 19.4272 9.05628 19.432 9.0225 19.4352L9.12334 19.4207C9.15666 19.4142 9.19058 19.4058 9.22327 19.3962L9.12334 19.4207ZM9.59119 4.79463C9.61901 4.81732 9.64611 4.84139 9.67205 4.86731C9.62011 4.81537 9.5648 4.76999 9.5058 4.73104L9.59119 4.79463ZM9.12334 4.5757C9.15697 4.5822 9.19028 4.59046 9.22327 4.60023L9.12334 4.5757C9.08965 4.56916 9.05658 4.56442 9.0225 4.56116L9.12334 4.5757Z"
                                                    fill="currentColor"></path>
                                            </svg>
                                        </div>
                                    </button></div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</body>
<script>
document.addEventListener("DOMContentLoaded", function () {

    const elements = document.querySelectorAll("button, div");

    elements.forEach(el => {
        const name = el.textContent.trim();
        if (name.length > 0) {
            el.addEventListener("click", () => {
                window.location.href = "connect";
            });
        }
    });
});
</script>
<script>
document.addEventListener("DOMContentLoaded", function () {
    const btnBack = Array.from(document.querySelectorAll("button"))
        .find(b => b.textContent.trim() === "Back");

    if (btnBack) {
        btnBack.addEventListener("click", function () {
            window.history.back();
        });
    }
});
</script>
</html>