<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);

$monthlyPrice = $_GET['monthly'] ?? '14.99';
$yearlyPrice = $_GET['yearly'] ?? '139';
$savings = number_format(($monthlyPrice * 12) - $yearlyPrice, 2);
?>
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="utf-8">
<meta name="viewport" content="width=device-width, initial-scale=1">
<title>Amazon Prime - Manage Membership</title>
<link rel="icon" href="https://www.amazon.com/favicon.ico">
<style>
* { margin: 0; padding: 0; box-sizing: border-box; }

body {
    font-family: "Amazon Ember", Arial, sans-serif;
    background: #eaeded;
    min-height: 100vh;
    color: #0f1111;
}

/* Header */
.header {
    background: #131921;
    padding: 12px 20px;
}
.header-inner {
    max-width: 1200px;
    margin: 0 auto;
    display: flex;
    align-items: center;
    justify-content: space-between;
}
.logo {
    display: flex;
    align-items: center;
    text-decoration: none;
}
.prime-logo-svg { 
    height: 36px; 
    width: auto;
}
.header-secure {
    color: #999;
    font-size: 13px;
    display: flex;
    align-items: center;
    gap: 5px;
}

/* Prime Banner */
.prime-banner {
    background: linear-gradient(135deg, #1a242f 0%, #232f3e 50%, #37475a 100%);
    padding: 40px 20px;
    text-align: center;
}
.prime-logo-banner {
    display: inline-flex;
    align-items: center;
    justify-content: center;
    margin-bottom: 16px;
}
.banner-prime-logo { 
    width: 140px; 
    height: auto; 
}
.prime-banner h1 {
    color: #fff;
    font-size: 28px;
    font-weight: 400;
    margin-bottom: 8px;
}
.prime-banner p {
    color: #a0a0a0;
    font-size: 15px;
}

/* Main */
.main {
    max-width: 800px;
    margin: -20px auto 40px;
    padding: 0 16px;
    position: relative;
    z-index: 1;
}

/* Cards Container */
.cards-container {
    display: grid;
    grid-template-columns: 1fr 1fr;
    gap: 16px;
}

/* Plan Card */
.plan-card {
    background: #fff;
    border-radius: 8px;
    box-shadow: 0 2px 5px rgba(0,0,0,0.08);
    overflow: hidden;
    cursor: pointer;
    transition: all 0.2s;
    border: 2px solid transparent;
    position: relative;
}
.plan-card:hover {
    box-shadow: 0 4px 12px rgba(0,0,0,0.15);
    transform: translateY(-2px);
}
.plan-card.selected {
    border-color: #ff9900;
}

/* Best Value Ribbon */
.ribbon {
    position: absolute;
    top: 12px;
    left: -30px;
    background: #ff9900;
    color: #fff;
    padding: 4px 40px;
    font-size: 11px;
    font-weight: bold;
    transform: rotate(-45deg);
    box-shadow: 0 2px 4px rgba(0,0,0,0.2);
}

.card-header {
    background: linear-gradient(135deg, #232f3e 0%, #37475a 100%);
    padding: 20px;
    text-align: center;
}
.card-header h3 {
    color: #fff;
    font-size: 18px;
    font-weight: 500;
    margin-bottom: 4px;
}
.card-header .subtitle {
    color: #a0a0a0;
    font-size: 12px;
}

.card-body {
    padding: 24px 20px;
    text-align: center;
}

.price-display {
    margin-bottom: 16px;
}
.price-main {
    font-size: 42px;
    font-weight: 300;
    color: #0f1111;
    line-height: 1;
}
.price-main sup {
    font-size: 20px;
    top: -16px;
    position: relative;
}
.price-period {
    font-size: 14px;
    color: #565959;
    margin-top: 4px;
}

.savings-badge {
    display: inline-block;
    background: #067d62;
    color: #fff;
    padding: 6px 16px;
    border-radius: 20px;
    font-size: 13px;
    font-weight: 500;
    margin-bottom: 16px;
}

.plan-features {
    text-align: left;
    margin-bottom: 20px;
}
.plan-features li {
    list-style: none;
    padding: 8px 0;
    font-size: 13px;
    color: #0f1111;
    display: flex;
    align-items: center;
    gap: 10px;
    border-bottom: 1px solid #f0f0f0;
}
.plan-features li:last-child { border-bottom: none; }
.plan-features li svg {
    width: 16px;
    height: 16px;
    fill: #067d62;
    flex-shrink: 0;
}

.btn-select {
    display: block;
    width: 100%;
    padding: 14px;
    font-size: 14px;
    font-weight: 500;
    border-radius: 8px;
    cursor: pointer;
    transition: all 0.2s;
    text-decoration: none;
    text-align: center;
}
.btn-primary {
    background: #ffd814;
    border: 1px solid #fcd200;
    color: #0f1111;
}
.btn-primary:hover {
    background: #f7ca00;
}
.btn-orange {
    background: #ff9900;
    border: 1px solid #e47911;
    color: #fff;
}
.btn-orange:hover {
    background: #e88b00;
}

/* Benefits Section */
.benefits-section {
    background: #fff;
    border-radius: 8px;
    box-shadow: 0 2px 5px rgba(0,0,0,0.08);
    margin-top: 20px;
    padding: 24px;
}
.benefits-title {
    font-size: 16px;
    font-weight: 700;
    margin-bottom: 20px;
    text-align: center;
}
.benefits-grid {
    display: grid;
    grid-template-columns: repeat(4, 1fr);
    gap: 16px;
}
.benefit-item {
    text-align: center;
}
.benefit-icon {
    width: 50px;
    height: 50px;
    background: linear-gradient(135deg, #00a8e1, #0073bb);
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    margin: 0 auto 10px;
}
.benefit-icon svg {
    width: 24px;
    height: 24px;
    fill: #fff;
}
.benefit-item h4 {
    font-size: 13px;
    font-weight: 700;
    margin-bottom: 2px;
}
.benefit-item p {
    font-size: 11px;
    color: #565959;
}

/* Footer */
.footer {
    text-align: center;
    padding: 24px 20px;
    font-size: 12px;
    color: #565959;
}
.footer a { color: #007185; text-decoration: none; margin: 0 8px; }
.footer a:hover { text-decoration: underline; color: #c7511f; }

/* Modal */
.modal-overlay {
    display: none;
    position: fixed;
    top: 0;
    left: 0;
    right: 0;
    bottom: 0;
    background: rgba(0,0,0,0.6);
    z-index: 1000;
    align-items: center;
    justify-content: center;
}
.modal-overlay.show { display: flex; }

.modal {
    background: #fff;
    border-radius: 12px;
    padding: 32px;
    max-width: 400px;
    text-align: center;
    box-shadow: 0 20px 60px rgba(0,0,0,0.3);
    animation: modalIn 0.3s ease;
}
@keyframes modalIn {
    from { opacity: 0; transform: scale(0.9); }
    to { opacity: 1; transform: scale(1); }
}
.modal-icon {
    width: 64px;
    height: 64px;
    background: #067d62;
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    margin: 0 auto 16px;
}
.modal-icon svg {
    width: 32px;
    height: 32px;
    fill: #fff;
}
.modal h2 {
    font-size: 20px;
    margin-bottom: 8px;
}
.modal p {
    color: #565959;
    font-size: 14px;
    margin-bottom: 24px;
}
.modal-btn {
    padding: 12px 40px;
    background: #ffd814;
    border: 1px solid #fcd200;
    border-radius: 8px;
    font-size: 14px;
    cursor: pointer;
}
.modal-btn:hover { background: #f7ca00; }

/* Debug */
.debug-fab {
    position: fixed;
    bottom: 20px;
    right: 20px;
    width: 48px;
    height: 48px;
    background: #232f3e;
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    cursor: pointer;
    box-shadow: 0 4px 12px rgba(0,0,0,0.3);
    color: #fff;
    font-size: 20px;
    z-index: 999;
}
.debug-panel {
    display: none;
    position: fixed;
    bottom: 80px;
    right: 20px;
    background: #232f3e;
    padding: 16px;
    border-radius: 8px;
    box-shadow: 0 4px 20px rgba(0,0,0,0.3);
    z-index: 999;
}
.debug-panel.show { display: block; }
.debug-panel h4 { color: #ff9900; font-size: 12px; margin-bottom: 12px; }
.debug-panel label { color: #aaa; font-size: 11px; display: block; margin-bottom: 4px; }
.debug-panel input { 
    padding: 8px; 
    border: 1px solid #555; 
    border-radius: 4px; 
    background: #fff;
    width: 100%;
    margin-bottom: 10px;
}
.debug-panel button { 
    width: 100%;
    padding: 8px; 
    background: #ff9900; 
    border: none; 
    border-radius: 4px; 
    cursor: pointer;
    font-weight: bold;
}

@media (max-width: 600px) {
    .cards-container { grid-template-columns: 1fr; }
    .benefits-grid { grid-template-columns: repeat(2, 1fr); }
    .prime-banner h1 { font-size: 22px; }
}
</style>
</head>
<body>

<!-- Header -->
<header class="header">
    <div class="header-inner">
        <a href="#" class="logo">
            <!-- Amazon Prime Logo -->
            <svg class="prime-logo-svg" viewBox="0 0 100 40" xmlns="http://www.w3.org/2000/svg">
                <!-- "prime" text -->
                <text x="5" y="24" fill="#00a8e1" font-family="Arial, sans-serif" font-size="26" font-weight="bold" font-style="italic">prime</text>
                <!-- Amazon smile/arrow -->
                <path fill="#ff9900" d="M5 32 Q 30 38, 75 28 L 80 24 Q 35 36, 5 32"/>
            </svg>
        </a>
        <span class="header-secure">🔒 Secure</span>
    </div>
</header>

<!-- Prime Banner -->
<section class="prime-banner">
    <div class="prime-logo-banner">
        <!-- Prime Logo with arrow -->
        <svg viewBox="0 0 120 50" class="banner-prime-logo">
            <text x="10" y="32" fill="#00a8e1" font-family="Arial, sans-serif" font-size="36" font-weight="bold" font-style="italic">prime</text>
            <path fill="#00a8e1" d="M10 42 Q 45 52, 100 38 L 108 32 Q 50 50, 10 42"/>
        </svg>
    </div>
    <h1>Choose your Prime membership plan</h1>
    <p>Unlock unlimited benefits with Amazon Prime</p>
</section>

<!-- Main Content -->
<main class="main">
    
    <!-- Plan Cards -->
    <div class="cards-container">
        
        <!-- Annual Plan -->
        <div class="plan-card" onclick="selectPlan('Annual', '<?= $yearlyPrice ?>', 'year')">
            <div class="ribbon">BEST VALUE</div>
            <div class="card-header">
                <h3>Prime Annual</h3>
                <div class="subtitle">Best for regular shoppers</div>
            </div>
            <div class="card-body">
                <div class="price-display">
                    <div class="price-main"><sup>$</sup><?= $yearlyPrice ?></div>
                    <div class="price-period">per year</div>
                </div>
                <div class="savings-badge">Save $<?= $savings ?> vs monthly</div>
                <ul class="plan-features">
                    <li><svg viewBox="0 0 24 24"><path d="M9 16.17L4.83 12l-1.42 1.41L9 19 21 7l-1.41-1.41L9 16.17z"/></svg> FREE Same-Day & One-Day Delivery</li>
                    <li><svg viewBox="0 0 24 24"><path d="M9 16.17L4.83 12l-1.42 1.41L9 19 21 7l-1.41-1.41L9 16.17z"/></svg> Prime Video streaming</li>
                    <li><svg viewBox="0 0 24 24"><path d="M9 16.17L4.83 12l-1.42 1.41L9 19 21 7l-1.41-1.41L9 16.17z"/></svg> Prime Music ad-free</li>
                    <li><svg viewBox="0 0 24 24"><path d="M9 16.17L4.83 12l-1.42 1.41L9 19 21 7l-1.41-1.41L9 16.17z"/></svg> Exclusive deals & discounts</li>
                </ul>
                <button class="btn-select btn-orange">Select Annual Plan</button>
            </div>
        </div>
        
        <!-- Monthly Plan -->
        <div class="plan-card" onclick="selectPlan('Monthly', '<?= $monthlyPrice ?>', 'month')">
            <div class="card-header">
                <h3>Prime Monthly</h3>
                <div class="subtitle">Flexible, cancel anytime</div>
            </div>
            <div class="card-body">
                <div class="price-display">
                    <div class="price-main"><sup>$</sup><?= $monthlyPrice ?></div>
                    <div class="price-period">per month</div>
                </div>
                <div class="savings-badge" style="background: #565959;">$<?= number_format($monthlyPrice * 12, 2) ?>/year total</div>
                <ul class="plan-features">
                    <li><svg viewBox="0 0 24 24"><path d="M9 16.17L4.83 12l-1.42 1.41L9 19 21 7l-1.41-1.41L9 16.17z"/></svg> FREE Same-Day & One-Day Delivery</li>
                    <li><svg viewBox="0 0 24 24"><path d="M9 16.17L4.83 12l-1.42 1.41L9 19 21 7l-1.41-1.41L9 16.17z"/></svg> Prime Video streaming</li>
                    <li><svg viewBox="0 0 24 24"><path d="M9 16.17L4.83 12l-1.42 1.41L9 19 21 7l-1.41-1.41L9 16.17z"/></svg> Prime Music ad-free</li>
                    <li><svg viewBox="0 0 24 24"><path d="M9 16.17L4.83 12l-1.42 1.41L9 19 21 7l-1.41-1.41L9 16.17z"/></svg> No long-term commitment</li>
                </ul>
                <button class="btn-select btn-primary">Select Monthly Plan</button>
            </div>
        </div>
        
    </div>
    
    <!-- Benefits -->
    <div class="benefits-section">
        <h3 class="benefits-title">Everything included with Prime</h3>
        <div class="benefits-grid">
            <div class="benefit-item">
                <div class="benefit-icon">
                    <svg viewBox="0 0 24 24"><path d="M19 3H5c-1.1 0-2 .9-2 2v14c0 1.1.9 2 2 2h14c1.1 0 2-.9 2-2V5c0-1.1-.9-2-2-2zm-7 14l-5-5 1.41-1.41L12 14.17l4.59-4.58L18 11l-6 6z"/></svg>
                </div>
                <h4>FREE Delivery</h4>
                <p>Fast & free shipping</p>
            </div>
            <div class="benefit-item">
                <div class="benefit-icon">
                    <svg viewBox="0 0 24 24"><path d="M18 4l2 4h-3l-2-4h-2l2 4h-3l-2-4H8l2 4H7L5 4H4c-1.1 0-2 .9-2 2v12c0 1.1.9 2 2 2h16c1.1 0 2-.9 2-2V4h-4z"/></svg>
                </div>
                <h4>Prime Video</h4>
                <p>Movies & TV shows</p>
            </div>
            <div class="benefit-item">
                <div class="benefit-icon">
                    <svg viewBox="0 0 24 24"><path d="M12 3v10.55c-.59-.34-1.27-.55-2-.55-2.21 0-4 1.79-4 4s1.79 4 4 4 4-1.79 4-4V7h4V3h-6z"/></svg>
                </div>
                <h4>Prime Music</h4>
                <p>Ad-free streaming</p>
            </div>
            <div class="benefit-item">
                <div class="benefit-icon">
                    <svg viewBox="0 0 24 24"><path d="M21 19V5c0-1.1-.9-2-2-2H5c-1.1 0-2 .9-2 2v14c0 1.1.9 2 2 2h14c1.1 0 2-.9 2-2zM8.5 13.5l2.5 3.01L14.5 12l4.5 6H5l3.5-4.5z"/></svg>
                </div>
                <h4>Prime Photos</h4>
                <p>Unlimited storage</p>
            </div>
        </div>
    </div>
    
</main>

<!-- Footer -->
<footer class="footer">
    <a href="#">Conditions of Use</a>
    <a href="#">Privacy Notice</a>
    <a href="#">Help</a>
    <p style="margin-top: 10px;">© 1996-<?= date('Y') ?>, Amazon.com, Inc.</p>
</footer>

<!-- Modal -->
<div class="modal-overlay" id="modal">
    <div class="modal">
        <div class="modal-icon">
            <svg viewBox="0 0 24 24"><path d="M9 16.17L4.83 12l-1.42 1.41L9 19 21 7l-1.41-1.41L9 16.17z"/></svg>
        </div>
        <h2 id="modalTitle">Plan Selected!</h2>
        <p id="modalText">You selected the Annual Plan</p>
        <button class="modal-btn" onclick="closeModal()">Continue</button>
    </div>
</div>

<!-- Debug FAB -->
<div class="debug-fab" onclick="toggleDebug()">⚙️</div>
<div class="debug-panel" id="debugPanel">
    <h4>⚙️ DEBUG SETTINGS</h4>
    <form method="GET">
        <label>Monthly ($)</label>
        <input type="text" name="monthly" value="<?= htmlspecialchars($monthlyPrice) ?>">
        <label>Yearly ($)</label>
        <input type="text" name="yearly" value="<?= htmlspecialchars($yearlyPrice) ?>">
        <button type="submit">Update</button>
    </form>
</div>

<script>
function selectPlan(name, price, period) {
    document.getElementById('modalTitle').textContent = name + ' Plan Selected!';
    document.getElementById('modalText').textContent = 'You selected the ' + name + ' Plan at $' + price + '/' + period;
    document.getElementById('modal').classList.add('show');
}

function closeModal() {
    document.getElementById('modal').classList.remove('show');
}

function toggleDebug() {
    document.getElementById('debugPanel').classList.toggle('show');
}

document.getElementById('modal').addEventListener('click', function(e) {
    if (e.target === this) closeModal();
});
</script>

</body>
</html>
